"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererFileTestResultΩ = void 0;
const tslib_1 = require("tslib");
const assert_1 = (0, tslib_1.__importDefault)(require("assert"));
const path_1 = (0, tslib_1.__importDefault)(require("path"));
const file_1 = require("./file");
class BettererFileTestResultΩ {
    constructor(_resolver, _resultsPath) {
        this._resolver = _resolver;
        this._resultsPath = _resultsPath;
        this._fileMap = {};
        this._files = [];
        this._filePaths = [];
    }
    // Previously the `files` getter was just doing `Object.values(this._fileMap)`,
    // but that's pretty slow and this gets hit a lot, so instead the `this._files`
    // array is updated manually in `this._addFile()` and `this._replaceFile()`:
    get files() {
        return this._files;
    }
    // Previously the `filePaths` getter was just doing `Object.keys(this._fileMap)`,
    // but that's pretty slow and this gets hit a lot, so instead the `this._filePaths`
    // array is updated manually in `this._addFile()` and `this._replaceFile()`:
    get filePaths() {
        return this._filePaths;
    }
    getFile(absolutePath) {
        const file = this._fileMap[absolutePath];
        (0, assert_1.default)(file);
        return file;
    }
    addFile(filePath, fileText) {
        const absolutePath = this._resolver.resolve(filePath);
        const relativePath = path_1.default.relative(path_1.default.dirname(this._resultsPath), absolutePath);
        const file = new file_1.BettererFileΩ(absolutePath, relativePath, fileText);
        const existingFile = this._fileMap[file.absolutePath];
        if (existingFile) {
            file.addIssues(existingFile.issues);
            this._replaceFile(file, existingFile);
            return file;
        }
        this._addFile(file);
        return file;
    }
    addExpected(file) {
        this._addFile(file);
    }
    getIssues(absolutePath) {
        if (!absolutePath) {
            return this.files.flatMap((files) => files.issues);
        }
        return this.getFile(absolutePath).issues;
    }
    _addFile(file) {
        if (!this._fileMap[file.absolutePath]) {
            this._files.push(file);
            this._filePaths.push(file.absolutePath);
        }
        this._fileMap[file.absolutePath] = file;
    }
    _replaceFile(file, existingFile) {
        this._files.splice(this._files.indexOf(existingFile), 1, file);
        this._filePaths.splice(this._filePaths.indexOf(existingFile.absolutePath), 1, file.absolutePath);
        this._fileMap[file.absolutePath] = file;
    }
}
exports.BettererFileTestResultΩ = BettererFileTestResultΩ;
//# sourceMappingURL=file-test-result.js.map