"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.merge = void 0;
const betterer_1 = require("@betterer/betterer");
const options_1 = require("./options");
/**
 * Run the **Betterer** `merge` command to resolve any merge conflicts in the
 * specified results file.
 */
function merge(cwd) {
    const command = (0, options_1.mergeCommand)();
    command.description('merge the Betterer results file');
    command.action(async (config, command) => {
        (0, options_1.setEnv)(config);
        // Mark options as unknown...
        const options = {
            contents: command.args,
            cwd,
            resultsPath: config.results
        };
        try {
            await betterer_1.betterer.merge(options);
        }
        catch (_a) {
            process.exitCode = 1;
        }
    });
    return command;
}
exports.merge = merge;
//# sourceMappingURL=merge.js.map