import { Centrifuge } from './centrifuge';
import { HistoryOptions, HistoryResult, PresenceResult, PresenceStatsResult, PublishResult, SubscriptionEvents, SubscriptionOptions, SubscriptionState, TypedEventEmitter } from './types';
declare const Subscription_base: new () => TypedEventEmitter<SubscriptionEvents>;
/** Subscription to a channel */
export declare class Subscription extends Subscription_base {
    channel: string;
    state: SubscriptionState;
    private _centrifuge;
    private _promises;
    private _resubscribeTimeout?;
    private _refreshTimeout?;
    private _getToken;
    private _minResubscribeDelay;
    private _maxResubscribeDelay;
    private _recover;
    private _offset;
    private _epoch;
    private _resubscribeAttempts;
    private _promiseId;
    private _token;
    private _data;
    private _recoverable;
    private _positioned;
    private _joinLeave;
    private _inflight;
    /** Subscription constructor should not be used directly, create subscriptions using Client method. */
    constructor(centrifuge: Centrifuge, channel: string, options?: Partial<SubscriptionOptions>);
    /** ready returns a Promise which resolves upon subscription goes to Subscribed
     * state and rejects in case of subscription goes to Unsubscribed state.
     * Optional timeout can be passed.*/
    ready(timeout?: number): Promise<void>;
    /** subscribe to a channel.*/
    subscribe(): void;
    /** unsubscribe from a channel, keeping position state.*/
    unsubscribe(): void;
    /** publish data to a channel.*/
    publish(data: any): Promise<PublishResult>;
    /** get online presence for a channel.*/
    presence(): Promise<PresenceResult>;
    /** presence stats for a channel (num clients and unique users).*/
    presenceStats(): Promise<PresenceStatsResult>;
    /** history for a channel. By default it does not return publications (only current
     *  StreamPosition data) – provide an explicit limit > 0 to load publications.*/
    history(opts: HistoryOptions): Promise<HistoryResult>;
    private _methodCall;
    private _nextPromiseId;
    private _needRecover;
    private _isUnsubscribed;
    private _isSubscribing;
    private _isSubscribed;
    private _setState;
    private _usesToken;
    private _clearSubscribingState;
    private _clearSubscribedState;
    private _setSubscribed;
    private _setSubscribing;
    private _subscribe;
    private _sendSubscribe;
    private _handleSubscribeError;
    private _handleSubscribeResponse;
    private _setUnsubscribed;
    private _handlePublication;
    protected _handleJoin(join: any): void;
    protected _handleLeave(leave: any): void;
    private _resolvePromises;
    private _rejectPromises;
    private _scheduleResubscribe;
    private _subscribeError;
    private _getResubscribeDelay;
    private _setOptions;
    private _getOffset;
    private _getEpoch;
    private _clearRefreshTimeout;
    private _clearResubscribeTimeout;
    private _getSubscriptionToken;
    private _refresh;
    private _refreshResponse;
    private _refreshError;
    private _getRefreshRetryDelay;
    private _failUnauthorized;
}
export {};
