// Code generated by Wire. DO NOT EDIT.

//go:generate go run -mod=mod github.com/google/wire/cmd/wire gen -tags "oss"
//go:build !wireinject
// +build !wireinject

package runner

import (
	"context"
	"github.com/google/wire"
	httpclient2 "github.com/grafana/grafana-plugin-sdk-go/backend/httpclient"
	"github.com/grafana/grafana/pkg/api"
	"github.com/grafana/grafana/pkg/api/avatar"
	"github.com/grafana/grafana/pkg/api/routing"
	"github.com/grafana/grafana/pkg/bus"
	"github.com/grafana/grafana/pkg/cuectx"
	"github.com/grafana/grafana/pkg/expr"
	registry2 "github.com/grafana/grafana/pkg/framework/coremodel/registry"
	"github.com/grafana/grafana/pkg/infra/httpclient"
	"github.com/grafana/grafana/pkg/infra/httpclient/httpclientprovider"
	"github.com/grafana/grafana/pkg/infra/kvstore"
	"github.com/grafana/grafana/pkg/infra/localcache"
	"github.com/grafana/grafana/pkg/infra/metrics"
	"github.com/grafana/grafana/pkg/infra/remotecache"
	"github.com/grafana/grafana/pkg/infra/serverlock"
	"github.com/grafana/grafana/pkg/infra/tracing"
	"github.com/grafana/grafana/pkg/infra/usagestats"
	service5 "github.com/grafana/grafana/pkg/infra/usagestats/service"
	"github.com/grafana/grafana/pkg/infra/usagestats/statscollector"
	login2 "github.com/grafana/grafana/pkg/login"
	"github.com/grafana/grafana/pkg/login/social"
	"github.com/grafana/grafana/pkg/middleware/csrf"
	"github.com/grafana/grafana/pkg/models"
	"github.com/grafana/grafana/pkg/plugins"
	"github.com/grafana/grafana/pkg/plugins/backendplugin/coreplugin"
	provider2 "github.com/grafana/grafana/pkg/plugins/backendplugin/provider"
	"github.com/grafana/grafana/pkg/plugins/config"
	manager3 "github.com/grafana/grafana/pkg/plugins/manager"
	"github.com/grafana/grafana/pkg/plugins/manager/client"
	"github.com/grafana/grafana/pkg/plugins/manager/dashboards"
	"github.com/grafana/grafana/pkg/plugins/manager/loader"
	"github.com/grafana/grafana/pkg/plugins/manager/process"
	"github.com/grafana/grafana/pkg/plugins/manager/registry"
	"github.com/grafana/grafana/pkg/plugins/manager/signature"
	store2 "github.com/grafana/grafana/pkg/plugins/manager/store"
	"github.com/grafana/grafana/pkg/plugins/plugincontext"
	"github.com/grafana/grafana/pkg/plugins/repo"
	"github.com/grafana/grafana/pkg/services/accesscontrol"
	"github.com/grafana/grafana/pkg/services/accesscontrol/acimpl"
	"github.com/grafana/grafana/pkg/services/accesscontrol/ossaccesscontrol"
	"github.com/grafana/grafana/pkg/services/alerting"
	"github.com/grafana/grafana/pkg/services/auth"
	"github.com/grafana/grafana/pkg/services/auth/jwt"
	"github.com/grafana/grafana/pkg/services/cleanup"
	"github.com/grafana/grafana/pkg/services/comments"
	"github.com/grafana/grafana/pkg/services/contexthandler"
	"github.com/grafana/grafana/pkg/services/contexthandler/authproxy"
	"github.com/grafana/grafana/pkg/services/dashboardimport"
	service8 "github.com/grafana/grafana/pkg/services/dashboardimport/service"
	dashboards2 "github.com/grafana/grafana/pkg/services/dashboards"
	database2 "github.com/grafana/grafana/pkg/services/dashboards/database"
	service3 "github.com/grafana/grafana/pkg/services/dashboards/service"
	"github.com/grafana/grafana/pkg/services/dashboardsnapshots"
	database5 "github.com/grafana/grafana/pkg/services/dashboardsnapshots/database"
	service6 "github.com/grafana/grafana/pkg/services/dashboardsnapshots/service"
	"github.com/grafana/grafana/pkg/services/dashboardversion/dashverimpl"
	"github.com/grafana/grafana/pkg/services/datasourceproxy"
	"github.com/grafana/grafana/pkg/services/datasources"
	"github.com/grafana/grafana/pkg/services/datasources/permissions"
	service2 "github.com/grafana/grafana/pkg/services/datasources/service"
	"github.com/grafana/grafana/pkg/services/encryption"
	"github.com/grafana/grafana/pkg/services/encryption/provider"
	"github.com/grafana/grafana/pkg/services/encryption/service"
	"github.com/grafana/grafana/pkg/services/export"
	"github.com/grafana/grafana/pkg/services/featuremgmt"
	"github.com/grafana/grafana/pkg/services/guardian"
	"github.com/grafana/grafana/pkg/services/hooks"
	"github.com/grafana/grafana/pkg/services/kmsproviders/osskmsproviders"
	"github.com/grafana/grafana/pkg/services/libraryelements"
	"github.com/grafana/grafana/pkg/services/librarypanels"
	"github.com/grafana/grafana/pkg/services/licensing"
	"github.com/grafana/grafana/pkg/services/live"
	"github.com/grafana/grafana/pkg/services/live/pushhttp"
	"github.com/grafana/grafana/pkg/services/login"
	"github.com/grafana/grafana/pkg/services/login/authinfoservice"
	database4 "github.com/grafana/grafana/pkg/services/login/authinfoservice/database"
	"github.com/grafana/grafana/pkg/services/login/loginservice"
	"github.com/grafana/grafana/pkg/services/loginattempt/loginattemptimpl"
	"github.com/grafana/grafana/pkg/services/ngalert"
	metrics2 "github.com/grafana/grafana/pkg/services/ngalert/metrics"
	"github.com/grafana/grafana/pkg/services/notifications"
	"github.com/grafana/grafana/pkg/services/oauthtoken"
	"github.com/grafana/grafana/pkg/services/org/orgimpl"
	"github.com/grafana/grafana/pkg/services/playlist/playlistimpl"
	"github.com/grafana/grafana/pkg/services/plugindashboards"
	service9 "github.com/grafana/grafana/pkg/services/plugindashboards/service"
	"github.com/grafana/grafana/pkg/services/pluginsettings"
	service7 "github.com/grafana/grafana/pkg/services/pluginsettings/service"
	"github.com/grafana/grafana/pkg/services/preference/prefimpl"
	"github.com/grafana/grafana/pkg/services/publicdashboards"
	api2 "github.com/grafana/grafana/pkg/services/publicdashboards/api"
	database7 "github.com/grafana/grafana/pkg/services/publicdashboards/database"
	service10 "github.com/grafana/grafana/pkg/services/publicdashboards/service"
	"github.com/grafana/grafana/pkg/services/query"
	"github.com/grafana/grafana/pkg/services/queryhistory"
	"github.com/grafana/grafana/pkg/services/quota/quotaimpl"
	"github.com/grafana/grafana/pkg/services/rendering"
	"github.com/grafana/grafana/pkg/services/search"
	"github.com/grafana/grafana/pkg/services/searchV2"
	"github.com/grafana/grafana/pkg/services/secrets"
	"github.com/grafana/grafana/pkg/services/secrets/database"
	kvstore2 "github.com/grafana/grafana/pkg/services/secrets/kvstore"
	"github.com/grafana/grafana/pkg/services/secrets/manager"
	"github.com/grafana/grafana/pkg/services/secrets/migrator"
	"github.com/grafana/grafana/pkg/services/serviceaccounts"
	database6 "github.com/grafana/grafana/pkg/services/serviceaccounts/database"
	manager4 "github.com/grafana/grafana/pkg/services/serviceaccounts/manager"
	"github.com/grafana/grafana/pkg/services/shorturls"
	"github.com/grafana/grafana/pkg/services/sqlstore"
	"github.com/grafana/grafana/pkg/services/sqlstore/db"
	"github.com/grafana/grafana/pkg/services/sqlstore/migrations"
	"github.com/grafana/grafana/pkg/services/sqlstore/mockstore"
	"github.com/grafana/grafana/pkg/services/star/starimpl"
	"github.com/grafana/grafana/pkg/services/store"
	"github.com/grafana/grafana/pkg/services/store/sanitizer"
	"github.com/grafana/grafana/pkg/services/tag"
	"github.com/grafana/grafana/pkg/services/tag/tagimpl"
	"github.com/grafana/grafana/pkg/services/team/teamimpl"
	"github.com/grafana/grafana/pkg/services/teamguardian"
	database3 "github.com/grafana/grafana/pkg/services/teamguardian/database"
	manager2 "github.com/grafana/grafana/pkg/services/teamguardian/manager"
	"github.com/grafana/grafana/pkg/services/thumbs"
	"github.com/grafana/grafana/pkg/services/updatechecker"
	"github.com/grafana/grafana/pkg/services/user/userimpl"
	"github.com/grafana/grafana/pkg/services/userauth/userauthimpl"
	"github.com/grafana/grafana/pkg/services/validations"
	"github.com/grafana/grafana/pkg/setting"
	"github.com/grafana/grafana/pkg/tsdb/azuremonitor"
	"github.com/grafana/grafana/pkg/tsdb/cloudmonitoring"
	"github.com/grafana/grafana/pkg/tsdb/cloudwatch"
	"github.com/grafana/grafana/pkg/tsdb/elasticsearch"
	"github.com/grafana/grafana/pkg/tsdb/grafanads"
	"github.com/grafana/grafana/pkg/tsdb/graphite"
	"github.com/grafana/grafana/pkg/tsdb/influxdb"
	"github.com/grafana/grafana/pkg/tsdb/legacydata"
	service4 "github.com/grafana/grafana/pkg/tsdb/legacydata/service"
	"github.com/grafana/grafana/pkg/tsdb/loki"
	"github.com/grafana/grafana/pkg/tsdb/mssql"
	"github.com/grafana/grafana/pkg/tsdb/mysql"
	"github.com/grafana/grafana/pkg/tsdb/opentsdb"
	"github.com/grafana/grafana/pkg/tsdb/postgres"
	"github.com/grafana/grafana/pkg/tsdb/prometheus"
	"github.com/grafana/grafana/pkg/tsdb/tempo"
	"github.com/grafana/grafana/pkg/tsdb/testdatasource"
	"github.com/grafana/grafana/pkg/web"
)

// Injectors from wire.go:

func Initialize(cfg *setting.Cfg) (Runner, error) {
	cacheService := localcache.ProvideService()
	ossMigrations := migrations.ProvideOSSMigrations()
	tracer, err := tracing.ProvideService(cfg)
	if err != nil {
		return Runner{}, err
	}
	inProcBus := bus.ProvideBus(tracer)
	sqlStore, err := sqlstore.ProvideService(cfg, cacheService, ossMigrations, inProcBus, tracer)
	if err != nil {
		return Runner{}, err
	}
	ossImpl := setting.ProvideProvider(cfg)
	providerProvider := provider.ProvideEncryptionProvider()
	usagestatsService := _wireNoOpUsageStatsValue
	serviceService, err := service.ProvideEncryptionService(providerProvider, usagestatsService, ossImpl)
	if err != nil {
		return Runner{}, err
	}
	hooksService := hooks.ProvideService()
	ossLicensingService := licensing.ProvideService(cfg, hooksService)
	featureManager, err := featuremgmt.ProvideManagerService(cfg, ossLicensingService)
	if err != nil {
		return Runner{}, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, ossImpl, featureToggles)
	secretsService, err := manager.ProvideSecretsService(secretsStoreImpl, osskmsprovidersService, serviceService, ossImpl, featureToggles, usagestatsService)
	if err != nil {
		return Runner{}, err
	}
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	orgService := orgimpl.ProvideService(sqlStore, cfg)
	starService := starimpl.ProvideService(sqlStore, cfg)
	tagimplService := tagimpl.ProvideService(sqlStore)
	dashboardStore := database2.ProvideDashboardStore(sqlStore, featureToggles, tagimplService)
	ossDatasourcePermissionsService := permissions.ProvideDatasourcePermissionsService()
	configCfg := config.ProvideConfig(ossImpl, cfg)
	inMemory := registry.ProvideService()
	unsignedPluginAuthorizer := signature.ProvideOSSAuthorizer(configCfg)
	ossPluginRequestValidator := validations.ProvideValidator()
	httpclientProvider := httpclientprovider.New(cfg, ossPluginRequestValidator, tracer)
	azuremonitorService := azuremonitor.ProvideService(cfg, httpclientProvider, tracer)
	cloudWatchService := cloudwatch.ProvideService(cfg, httpclientProvider, featureToggles)
	cloudmonitoringService := cloudmonitoring.ProvideService(httpclientProvider, tracer)
	elasticsearchService := elasticsearch.ProvideService(httpclientProvider)
	graphiteService := graphite.ProvideService(httpclientProvider, tracer)
	influxdbService := influxdb.ProvideService(httpclientProvider)
	lokiService := loki.ProvideService(httpclientProvider, featureToggles, tracer)
	opentsdbService := opentsdb.ProvideService(httpclientProvider)
	prometheusService := prometheus.ProvideService(httpclientProvider, cfg, featureToggles, tracer)
	tempoService := tempo.ProvideService(httpclientProvider)
	testdatasourceService := testdatasource.ProvideService(cfg, featureToggles)
	postgresService := postgres.ProvideService(cfg)
	mysqlService := mysql.ProvideService(cfg, httpclientProvider)
	mssqlService := mssql.ProvideService(cfg)
	entityEventsService := store.ProvideEntityEventsService(cfg, sqlStore, featureToggles)
	routeRegister := _wireNoOpRouteRegisterValue
	acimplService, err := acimpl.ProvideService(cfg, sqlStore, routeRegister, cacheService)
	if err != nil {
		return Runner{}, err
	}
	searchService := searchV2.ProvideService(cfg, sqlStore, entityEventsService, acimplService, tracer, featureToggles, orgService)
	activeAuthTokenService := auth.ProvideActiveAuthTokenService(cfg, sqlStore)
	quotaService := quotaimpl.ProvideService(sqlStore, cfg, activeAuthTokenService, sqlStore)
	storageService := store.ProvideService(sqlStore, featureToggles, cfg, quotaService)
	grafanadsService := grafanads.ProvideService(cfg, searchService, storageService)
	corepluginRegistry := coreplugin.ProvideCoreRegistry(azuremonitorService, cloudWatchService, cloudmonitoringService, elasticsearchService, graphiteService, influxdbService, lokiService, opentsdbService, prometheusService, tempoService, testdatasourceService, postgresService, mysqlService, mssqlService, grafanadsService)
	providerService := provider2.ProvideService(corepluginRegistry)
	loaderLoader := loader.ProvideService(configCfg, ossLicensingService, unsignedPluginAuthorizer, inMemory, providerService)
	storeService, err := store2.ProvideService(cfg, configCfg, inMemory, loaderLoader)
	if err != nil {
		return Runner{}, err
	}
	kvStore := kvstore.ProvideService(sqlStore)
	secretsKVStore, err := kvstore2.ProvideService(sqlStore, secretsService, storeService, kvStore, featureToggles, cfg)
	if err != nil {
		return Runner{}, err
	}
	accessControl := acimpl.ProvideAccessControl(cfg)
	datasourcePermissionsService := ossaccesscontrol.ProvideDatasourcePermissionsService()
	service4 := service2.ProvideService(sqlStore, secretsService, secretsKVStore, cfg, featureToggles, accessControl, datasourcePermissionsService)
	alertStore := alerting.ProvideAlertStore(sqlStore, cacheService, cfg, tagimplService)
	dashAlertExtractorService := alerting.ProvideDashAlertExtractorService(ossDatasourcePermissionsService, service4, alertStore)
	teamService := teamimpl.ProvideService(sqlStore, cfg)
	folderPermissionsService, err := ossaccesscontrol.ProvideFolderPermissions(cfg, routeRegister, sqlStore, accessControl, ossLicensingService, dashboardStore, acimplService, teamService)
	if err != nil {
		return Runner{}, err
	}
	dashboardPermissionsService, err := ossaccesscontrol.ProvideDashboardPermissions(cfg, routeRegister, sqlStore, accessControl, ossLicensingService, dashboardStore, acimplService, teamService)
	if err != nil {
		return Runner{}, err
	}
	dashboardServiceImpl := service3.ProvideDashboardService(cfg, dashboardStore, dashAlertExtractorService, featureToggles, folderPermissionsService, dashboardPermissionsService, accessControl)
	prefService := prefimpl.ProvideService(sqlStore, cfg, featureManager)
	teamGuardianStoreImpl := database3.ProvideTeamGuardianStore(sqlStore, teamService)
	teamGuardian := manager2.ProvideService(teamGuardianStoreImpl)
	userauthService := userauthimpl.ProvideService(sqlStore)
	remoteCache, err := remotecache.ProvideService(cfg, sqlStore, secretsService)
	if err != nil {
		return Runner{}, err
	}
	userService := userimpl.ProvideService(sqlStore, orgService, starService, dashboardServiceImpl, prefService, teamGuardian, userauthService, quotaService, acimplService, cfg, sqlStore, remoteCache, featureManager)
	runner := New(cfg, sqlStore, ossImpl, serviceService, featureToggles, secretsService, secretsMigrator, userService)
	return runner, nil
}

var (
	_wireNoOpUsageStatsValue    = noOpUsageStats{}
	_wireNoOpRouteRegisterValue = noOpRouteRegister{}
)

// wire.go:

var wireSet = wire.NewSet(
	New, localcache.ProvideService, tracing.ProvideService, bus.ProvideBus, featuremgmt.ProvideManagerService, featuremgmt.ProvideToggles, wire.Bind(new(bus.Bus), new(*bus.InProcBus)), sqlstore.ProvideService, wire.InterfaceValue(new(usagestats.Service), noOpUsageStats{}), wire.InterfaceValue(new(routing.RouteRegister), noOpRouteRegister{}), service.ProvideEncryptionService, wire.Bind(new(encryption.Internal), new(*service.Service)), database.ProvideSecretsStore, wire.Bind(new(secrets.Store), new(*database.SecretsStoreImpl)), manager.ProvideSecretsService, wire.Bind(new(secrets.Service), new(*manager.SecretsService)), hooks.ProvideService, service4.ProvideService, wire.Bind(new(legacydata.RequestHandler), new(*service4.Service)), alerting.ProvideAlertStore, alerting.ProvideAlertEngine, wire.Bind(new(alerting.UsageStatsQuerier), new(*alerting.AlertEngine)), api.ProvideHTTPServer, query.ProvideService, thumbs.ProvideService, rendering.ProvideService, wire.Bind(new(rendering.Service), new(*rendering.RenderingService)), kvstore.ProvideService, updatechecker.ProvideGrafanaService, updatechecker.ProvidePluginsService, service5.ProvideService, config.ProvideConfig, registry.ProvideService, wire.Bind(new(registry.Service), new(*registry.InMemory)), repo.ProvideService, wire.Bind(new(repo.Service), new(*repo.Manager)), manager3.ProvideInstaller, wire.Bind(new(plugins.Installer), new(*manager3.PluginInstaller)), client.ProvideService, wire.Bind(new(plugins.Client), new(*client.Service)), store2.ProvideService, wire.Bind(new(plugins.Store), new(*store2.Service)), wire.Bind(new(plugins.RendererManager), new(*store2.Service)), wire.Bind(new(plugins.SecretsPluginManager), new(*store2.Service)), wire.Bind(new(plugins.StaticRouteResolver), new(*store2.Service)), dashboards.ProvideFileStoreManager, wire.Bind(new(dashboards.FileStore), new(*dashboards.FileStoreManager)), process.ProvideService, wire.Bind(new(process.Service), new(*process.Manager)), coreplugin.ProvideCoreRegistry, loader.ProvideService, wire.Bind(new(loader.Service), new(*loader.Loader)), wire.Bind(new(plugins.ErrorResolver), new(*loader.Loader)), cloudwatch.ProvideService, cloudmonitoring.ProvideService, azuremonitor.ProvideService, postgres.ProvideService, mysql.ProvideService, mssql.ProvideService, store.ProvideEntityEventsService, httpclientprovider.New, wire.Bind(new(httpclient.Provider), new(*httpclient2.Provider)), serverlock.ProvideService, cleanup.ProvideService, shorturls.ProvideService, wire.Bind(new(shorturls.Service), new(*shorturls.ShortURLService)), queryhistory.ProvideService, wire.Bind(new(queryhistory.Service), new(*queryhistory.QueryHistoryService)), quotaimpl.ProvideService, remotecache.ProvideService, loginservice.ProvideService, wire.Bind(new(login.Service), new(*loginservice.Implementation)), authinfoservice.ProvideAuthInfoService, wire.Bind(new(login.AuthInfoService), new(*authinfoservice.Implementation)), database4.ProvideAuthInfoStore, login2.ProvideService, wire.Bind(new(login2.Authenticator), new(*login2.AuthenticatorService)), loginattemptimpl.ProvideService, datasourceproxy.ProvideService, search.ProvideService, searchV2.ProvideService, store.ProvideService, export.ProvideService, live.ProvideService, pushhttp.ProvideService, plugincontext.ProvideService, contexthandler.ProvideService, jwt.ProvideService, wire.Bind(new(models.JWTService), new(*jwt.AuthService)), ngalert.ProvideService, librarypanels.ProvideService, wire.Bind(new(librarypanels.Service), new(*librarypanels.LibraryPanelService)), libraryelements.ProvideService, wire.Bind(new(libraryelements.Service), new(*libraryelements.LibraryElementService)), notifications.ProvideService, notifications.ProvideSmtpService, metrics.ProvideService, testdatasource.ProvideService, social.ProvideService, influxdb.ProvideService, wire.Bind(new(social.Service), new(*social.SocialService)), oauthtoken.ProvideService, auth.ProvideActiveAuthTokenService, wire.Bind(new(models.ActiveTokenService), new(*auth.ActiveAuthTokenService)), wire.Bind(new(oauthtoken.OAuthTokenService), new(*oauthtoken.Service)), tempo.ProvideService, loki.ProvideService, graphite.ProvideService, prometheus.ProvideService, elasticsearch.ProvideService, migrator.ProvideSecretsMigrator, wire.Bind(new(secrets.Migrator), new(*migrator.SecretsMigrator)), grafanads.ProvideService, wire.Bind(new(dashboardsnapshots.Store), new(*database5.DashboardSnapshotStore)), database5.ProvideStore, wire.Bind(new(dashboardsnapshots.Service), new(*service6.ServiceImpl)), service6.ProvideService, service2.ProvideService, wire.Bind(new(datasources.DataSourceService), new(*service2.Service)), service7.ProvideService, wire.Bind(new(pluginsettings.Service), new(*service7.Service)), alerting.ProvideService, database6.ProvideServiceAccountsStore, wire.Bind(new(serviceaccounts.Store), new(*database6.ServiceAccountsStoreImpl)), ossaccesscontrol.ProvideServiceAccountPermissions, wire.Bind(new(accesscontrol.ServiceAccountPermissionsService), new(*ossaccesscontrol.ServiceAccountPermissionsService)), manager4.ProvideServiceAccountsService, wire.Bind(new(serviceaccounts.Service), new(*manager4.ServiceAccountsService)), expr.ProvideService, database3.ProvideTeamGuardianStore, wire.Bind(new(teamguardian.Store), new(*database3.TeamGuardianStoreImpl)), manager2.ProvideService, service3.ProvideDashboardService, service3.ProvideFolderService, database2.ProvideDashboardStore, wire.Bind(new(dashboards2.DashboardService), new(*service3.DashboardServiceImpl)), wire.Bind(new(dashboards2.DashboardProvisioningService), new(*service3.DashboardServiceImpl)), wire.Bind(new(dashboards2.PluginService), new(*service3.DashboardServiceImpl)), wire.Bind(new(dashboards2.FolderService), new(*service3.FolderServiceImpl)), wire.Bind(new(dashboards2.Store), new(*database2.DashboardStore)), service8.ProvideService, wire.Bind(new(dashboardimport.Service), new(*service8.ImportDashboardService)), service9.ProvideService, wire.Bind(new(plugindashboards.Service), new(*service9.Service)), service9.ProvideDashboardUpdater, alerting.ProvideDashAlertExtractorService, wire.Bind(new(alerting.DashAlertExtractor), new(*alerting.DashAlertExtractorService)), comments.ProvideService, guardian.ProvideService, sanitizer.ProvideService, kvstore2.ProvideService, avatar.ProvideAvatarCacheServer, authproxy.ProvideAuthProxy, statscollector.ProvideService, registry2.CoremodelSet, cuectx.ProvideCUEContext, cuectx.ProvideThemaLibrary, csrf.ProvideCSRFFilter, ossaccesscontrol.ProvideTeamPermissions, wire.Bind(new(accesscontrol.TeamPermissionsService), new(*ossaccesscontrol.TeamPermissionsService)), ossaccesscontrol.ProvideFolderPermissions, wire.Bind(new(accesscontrol.FolderPermissionsService), new(*ossaccesscontrol.FolderPermissionsService)), ossaccesscontrol.ProvideDashboardPermissions, wire.Bind(new(accesscontrol.DashboardPermissionsService), new(*ossaccesscontrol.DashboardPermissionsService)), starimpl.ProvideService, playlistimpl.ProvideService, dashverimpl.ProvideService, service10.ProvideService, wire.Bind(new(publicdashboards.Service), new(*service10.PublicDashboardServiceImpl)), database7.ProvideStore, wire.Bind(new(publicdashboards.Store), new(*database7.PublicDashboardStoreImpl)), api2.ProvideApi, userimpl.ProvideService, orgimpl.ProvideService, teamimpl.ProvideService, userauthimpl.ProvideService, metrics2.ProvideServiceForTest, notifications.MockNotificationService, wire.Bind(new(notifications.TempUserStore), new(*mockstore.SQLStoreMock)), wire.Bind(new(notifications.Service), new(*notifications.NotificationServiceMock)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationServiceMock)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationServiceMock)), mockstore.NewSQLStoreMock, wire.Bind(new(sqlstore.Store), new(*sqlstore.SQLStore)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService, opentsdb.ProvideService, acimpl.ProvideAccessControl, wire.Bind(new(accesscontrol.AccessControl), new(*acimpl.AccessControl)), tagimpl.ProvideService, wire.Bind(new(tag.Service), new(*tagimpl.Service)),
)

type noOpUsageStats struct{}

func (noOpUsageStats) GetUsageReport(context.Context) (usagestats.Report, error) {
	return usagestats.Report{}, nil
}

func (noOpUsageStats) RegisterMetricsFunc(_ usagestats.MetricsFunc) {}

func (noOpUsageStats) RegisterSendReportCallback(_ usagestats.SendReportCallbackFunc) {}

func (noOpUsageStats) ShouldBeReported(context.Context, string) bool { return false }

type noOpRouteRegister struct{}

func (noOpRouteRegister) Get(string, ...web.Handler) {}

func (noOpRouteRegister) Post(string, ...web.Handler) {}

func (noOpRouteRegister) Delete(string, ...web.Handler) {}

func (noOpRouteRegister) Put(string, ...web.Handler) {}

func (noOpRouteRegister) Patch(string, ...web.Handler) {}

func (noOpRouteRegister) Any(string, ...web.Handler) {}

func (noOpRouteRegister) Group(string, func(routing.RouteRegister), ...web.Handler) {}

func (noOpRouteRegister) Insert(string, func(routing.RouteRegister), ...web.Handler) {}

func (noOpRouteRegister) Register(routing.Router, ...routing.RegisterNamedMiddleware) {}

func (noOpRouteRegister) Reset() {}
