// Code generated by go-swagger; DO NOT EDIT.

// Copyright Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Integration integration
//
// swagger:model integration
type Integration struct {

	// A timestamp indicating the last attempt to deliver a notification regardless of the outcome.
	// Format: date-time
	LastNotifyAttempt strfmt.DateTime `json:"lastNotifyAttempt,omitempty"`

	// Duration of the last attempt to deliver a notification in humanized format (`1s` or `15ms`, etc).
	LastNotifyAttemptDuration string `json:"lastNotifyAttemptDuration,omitempty"`

	// Error string for the last attempt to deliver a notification. Empty if the last attempt was successful.
	LastNotifyAttemptError string `json:"lastNotifyAttemptError,omitempty"`

	// name
	// Required: true
	Name *string `json:"name"`

	// send resolved
	// Required: true
	SendResolved *bool `json:"sendResolved"`
}

// Validate validates this integration
func (m *Integration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLastNotifyAttempt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendResolved(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Integration) validateLastNotifyAttempt(formats strfmt.Registry) error {

	if swag.IsZero(m.LastNotifyAttempt) { // not required
		return nil
	}

	if err := validate.FormatOf("lastNotifyAttempt", "body", "date-time", m.LastNotifyAttempt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Integration) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *Integration) validateSendResolved(formats strfmt.Registry) error {

	if err := validate.Required("sendResolved", "body", m.SendResolved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Integration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Integration) UnmarshalBinary(b []byte) error {
	var res Integration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
