<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->








[![git-url-parse](http://i.imgur.com/HlfMsVf.png)](#)











# git-url-parse

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Travis](https://img.shields.io/travis/IonicaBizau/git-url-parse.svg)](https://travis-ci.org/IonicaBizau/git-url-parse/) [![Version](https://img.shields.io/npm/v/git-url-parse.svg)](https://www.npmjs.com/package/git-url-parse) [![Downloads](https://img.shields.io/npm/dt/git-url-parse.svg)](https://www.npmjs.com/package/git-url-parse) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> A high level git url parser for common git providers.

















## :cloud: Installation

```sh
# Using npm
npm install --save git-url-parse

# Using yarn
yarn add git-url-parse
```













## :clipboard: Example



```js
// Dependencies
const GitUrlParse = require("git-url-parse");

console.log(GitUrlParse("git@github.com:IonicaBizau/node-git-url-parse.git"));
// => {
//     protocols: []
//   , port: null
//   , resource: "github.com"
//   , user: "git"
//   , pathname: "/IonicaBizau/node-git-url-parse.git"
//   , hash: ""
//   , search: ""
//   , href: "git@github.com:IonicaBizau/node-git-url-parse.git"
//   , token: ""
//   , protocol: "ssh"
//   , toString: [Function]
//   , source: "github.com"
//   , name: "node-git-url-parse"
//   , owner: "IonicaBizau"
// }

console.log(GitUrlParse("https://github.com/IonicaBizau/node-git-url-parse.git"));
// => {
//     protocols: ["https"]
//   , port: null
//   , resource: "github.com"
//   , user: ""
//   , pathname: "/IonicaBizau/node-git-url-parse.git"
//   , hash: ""
//   , search: ""
//   , href: "https://github.com/IonicaBizau/node-git-url-parse.git"
//   , token: ""
//   , protocol: "https"
//   , toString: [Function]
//   , source: "github.com"
//   , name: "node-git-url-parse"
//   , owner: "IonicaBizau"
// }

console.log(GitUrlParse("https://github.com/IonicaBizau/git-url-parse/blob/master/test/index.js"));
// { protocols: [ 'https' ],
//   protocol: 'https',
//   port: null,
//   resource: 'github.com',
//   user: '',
//   pathname: '/IonicaBizau/git-url-parse/blob/master/test/index.js',
//   hash: '',
//   search: '',
//   href: 'https://github.com/IonicaBizau/git-url-parse/blob/master/test/index.js',
//   token: '',
//   toString: [Function],
//   source: 'github.com',
//   name: 'git-url-parse',
//   owner: 'IonicaBizau',
//   organization: '',
//   ref: 'master',
//   filepathtype: 'blob',
//   filepath: 'test/index.js',
//   full_name: 'IonicaBizau/git-url-parse' }

console.log(GitUrlParse("https://github.com/IonicaBizau/node-git-url-parse.git").toString("ssh"));
// => "git@github.com:IonicaBizau/node-git-url-parse.git"

console.log(GitUrlParse("git@github.com:IonicaBizau/node-git-url-parse.git").toString("https"));
// => "https://github.com/IonicaBizau/node-git-url-parse.git"
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `gitUrlParse(url)`
Parses a Git url.

#### Params

- **String** `url`: The Git url to parse.

#### Return
- **GitUrl** The `GitUrl` object containing:
 - `protocols` (Array): An array with the url protocols (usually it has one element).
 - `port` (null|Number): The domain port.
 - `resource` (String): The url domain (including subdomains).
 - `user` (String): The authentication user (usually for ssh urls).
 - `pathname` (String): The url pathname.
 - `hash` (String): The url hash.
 - `search` (String): The url querystring value.
 - `href` (String): The input url.
 - `protocol` (String): The git url protocol.
 - `token` (String): The oauth token (could appear in the https urls).
 - `source` (String): The Git provider (e.g. `"github.com"`).
 - `owner` (String): The repository owner.
 - `name` (String): The repository name.
 - `ref` (String): The repository ref (e.g., "master" or "dev").
 - `filepath` (String): A filepath relative to the repository root.
 - `filepathtype` (String): The type of filepath in the url ("blob" or "tree").
 - `full_name` (String): The owner and name values in the `owner/name` format.
 - `toString` (Function): A function to stringify the parsed url into another url type.
 - `organization` (String): The organization the owner belongs to. This is CloudForge specific.
 - `git_suffix` (Boolean): Whether to add the `.git` suffix or not.

### `stringify(obj, type)`
Stringifies a `GitUrl` object.

#### Params

- **GitUrl** `obj`: The parsed Git url object.
- **String** `type`: The type of the stringified url (default `obj.protocol`).

#### Return
- **String** The stringified url.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `release-it`
 - `documentation`
 - `apollo`
 - `@backstage/backend-common`
 - `@plone/scripts`
 - `@atomist/automation-client`
 - `@storybook/storybook-deployer`
 - `@backstage/integration`
 - `@pvm/core`
 - `@kadira/storybook-deployer`
 - `gatsby-source-git`
 - `workspace-tools`
 - `@backstage/plugin-scaffolder-backend`
 - `@backstage/plugin-catalog-backend`
 - `umi-build-dev`
 - `@lerna-lite/core`
 - `@era-ci/utils`
 - `@atomist/automation-client-ext-raven`
 - `git-source`
 - `@nuxt/telemetry`
 - `semantic-release-gitmoji`
 - `@qiwi/semantic-release-gh-pages-plugin`
 - `@atomist/sdm-pack-analysis`
 - `apify-shared`
 - `@git-stack/server-core`
 - `strapi-generate-new`
 - `query-registry`
 - `common-boilerplate`
 - `remax-stats`
 - `renovate`
 - `@backstage/plugin-techdocs-node`
 - `@s-ui/studio`
 - `@instructure/ui-scripts`
 - `@appworks/project-utils`
 - `@jswork/next-git-url`
 - `@umijs/block-sdk`
 - `@lerna/github-client`
 - `@micro-app/shared-utils`
 - `@oumi/block-sdk`
 - `@radjs/block-sdk`
 - `@wetrial/block-sdk`
 - `datoit-generate-new`
 - `@appirio/appirio`
 - `@backstage/plugin-techdocs`
 - `beachball`
 - `@log4brains/core`
 - `@xdn/cli`
 - `@atomist/skill`
 - `@koumoul/gh-pages-multi`
 - `@pvm/gitlab`
 - `@zeplin/cli`
 - `@atomist/cli`
 - `@brisk-docs/gatsby-generator`
 - `@microservices/cli`
 - `@vamsikc/plugin-catalog`
 - `hzero-block-sdk`
 - `@spryker-lerna/github-client`
 - `clipped`
 - `fotingo`
 - `git-issues`
 - `gitbook-start-plugin-iaas-ull-es-noejaco2017`
 - `@guardian/cdk`
 - `omg`
 - `@stackbit/dev-common`
 - `lambda-service`
 - `octokit-downloader`
 - `stylelint-formatter-utils`
 - `sync-repos`
 - `@enkeledi/react-native-week-month-date-picker`
 - `@kevinbds/techdocs-common`
 - `docula-ui`
 - `@s-ui/mono`
 - `copy-github-directory`
 - `@facadecompany/ignition-ui`
 - `@focusworkstemp/project-utils`
 - `@geut/git-url-parse`
 - `@git-stack/hemera-plugin`
 - `@jaredpalmer/workspace-tools`
 - `@unibtc/release-it`
 - `scaffolder-core`
 - `testarmada-midway`
 - `autorelease-setup`
 - `sherry-utils`
 - `wiby`
 - `@erquhart/lerna-github-client`
 - `@oumi/cli-ui`
 - `@yarnpkg/plugin-git`
 - `changelog.md`
 - `@feizheng/next-git-url`
 - `@0x-lerna-fork/github-client`
 - `@atomist/uhura`
 - `@iceworks/project-utils`
 - `@hygiene/plugin-github-url`
 - `@pmworks/project-utils`
 - `@pubbo/github-client`
 - `@sanv/apify-shared`
 - `@antv/gatsby-theme-antv`
 - `gcpayz-block-sdk`
 - `documentation-custom-markdown`
 - `generator-clearphp`
 - `@scafflater/scafflater`
 - `@backstage/plugin-scaffolder`
 - `@buschtoens/documentation`
 - `@brisk-docs/website`
 - `@dandean/storybook-deployer`
 - `@dougkulak/semantic-release-gh-pages-plugin`
 - `@emedvedev/renovate`
 - `@geut/git-compare-template`
 - `@hugomrdias/documentation`
 - `@pageshare/cli`
 - `@merna/github-client`
 - `@lerna-test-v1/markdown`
 - `@jswork/topics2keywords`
 - `@pvdlg/semantic-release`
 - `@rianfowler/backstage-backend-common`
 - `auto-changelog-vsts`
 - `@deskbtm/workspace-tools`
 - `debone`
 - `cz-conventional-changelog-befe`
 - `create-apex-js-app`
 - `gatsby-source-git-remotes`
 - `gatsby-source-npmjs`
 - `flutter-boot`
 - `fster`
 - `gatsby-theme-zh`
 - `git-service-node`
 - `git-origin-check`
 - `git-yoink`
 - `harry-reporter`
 - `jsnix`
 - `kef-core`
 - `konitor`
 - `laborious`
 - `l-other-data`
 - `lime-cli`
 - `npm_one_1_2_3`
 - `miguelcostero-ng2-toasty`
 - `mdnext-loader`
 - `native-kakao-login`
 - `open-pull-request`
 - `rn-adyen-dropin`
 - `simple-github-release`
 - `snipx`
 - `react-native-arunmeena1987`
 - `react-native-contact-list`
 - `react-native-payu-payment-testing`
 - `react-native-is7`
 - `react-native-my-first-try-arun-ramya`
 - `react-native-kakao-maps`
 - `react-native-ytximkit`
 - `vuepress-plugin-remote-url`
 - `@mmomtchev/documentation`
 - `spk`
 - `release-it-http`
 - `todo2issue`
 - `tooling-personal`
 - `tmplr`
 - `prep-barv11`
 - `belt-repo`
 - `@gasket/plugin-metrics`
 - `@axetroy/gpm`
 - `@belt/repo`
 - `@cliz/gpm`
 - `docula-ui-express`
 - `@positionex/position-sdk`
 - `gitlab-ci-variables-cli`
 - `gitbook-start-iaas-bbdd-alex-moi`
 - `gitbook-start-iaas-ull-es-merquililycony`
 - `gitc`
 - `lcov-server`
 - `gtni`
 - `@blackglory/git-list`
 - `@cilyn/bitbucket`
 - `@corelmax/react-native-my2c2p-sdk`
 - `@csmith/release-it`
 - `@1coin178/github-compare`
 - `@esops/publish-github-pages`
 - `@felipesimmi/react-native-datalogic-module`
 - `@geut/chan-parser`
 - `@narfeta/catalog-backend`
 - `@hawkingnetwork/react-native-tab-view`
 - `@infinitecsolutions/storybook-deployer`
 - `@pipelinedoc/cli`
 - `ftl-renovate`
 - `gatsby-theme-cone`
 - `gatsby-theme-nestx`
 - `generate-github-directory`
 - `git-url-promise`
 - `git-observer`
 - `github-assistant`
 - `github-action-readme`
 - `coc-discord-rpc`
 - `@xyz/create-package`
 - `@theowenyoung/gatsby-source-git`
 - `@voodeng/uppacks`
 - `bitbucket-pullr`
 - `configorama`
 - `drowl-base-theme-iconset`
 - `dx-scanner`
 - `native-apple-login`
 - `nmrium-cli`
 - `react-native-cplus`
 - `npm_qwerty`
 - `patchanon-cli`
 - `pbc`
 - `wsj.gatsby-source-git`
 - `semantic-release-github-milestones`
 - `react-native-bubble-chart`
 - `tldw`
 - `react-native-arunjeyam1987`
 - `publish-version`
 - `@githubnext/blocks`
 - `react-native-flyy`
 - `@evanpurkhiser/tooling-personal`
 - `@shopgate/pwa-releaser`
 - `complan`
 - `def-core`
 - `@stackbit/cli`
 - `pr-log`
 - `generator-openapi-repo`
 - `github-publish-npm`
 - `@tmplr/node`
 - `kontinuous`
 - `@tjmonsi/generator-uplb-hci-lab-project-template`
 - `@tjmonsi/generator-project-template`
 - `@vicoders/cli2`
 - `@voodeng/archive`
 - `@lerna-test-v1/git`
 - `@saad27/react-native-bottom-tab-tour`
 - `@patrickhulce/scripts`
 - `canarist`
 - `candlelabssdk`
 - `cirodown`
 - `aral-vps-test`
 - `auto-clone`
 - `detect-node-support`
 - `committing`
 - `@stagas/documentation-fork`
 - `@tagoro9/git`
 - `gatsby-theme-art-graph`
 - `gatsby-theme-cone-oc`
 - `generate-preview`
 - `generator-bootstrap-boilerplate-template`
 - `@turborepo/workspace-tools`
 - `git-imitate`
 - `git-upstream`
 - `github-books`
 - `react-native-dsphoto-module`
 - `react-native-responsive-size`
 - `react-native-sayhello-module`
 - `react-feedback-sdk`
 - `learning-journal-ci`
 - `just-dev-sdk`
 - `meta-release`
 - `nixitech_cli`
 - `openapi-repo-generator`
 - `npm_one_12_34_1_`
 - `npm_one_2_2`
 - `payutesting`
 - `sn-flutter-boot`
 - `umi-plugin-repo`
 - `@jupiterone/graph-checkmarx`
 - `wp-continuous-deployment`
 - `yarn-upgrade-on-ci`
 - `@axetroy/git-clone`
 - `branch-release`
 - `semantic-release-telegram`
 - `gatsby-theme-iot`
 - `@dvcorg/cml`
 - `@gogogosir/build-cli`
 - `download-repo-cli`
 - `@pvm/github`
 - `documentation-markdown-themes`
 - `gd-cli`
 - `gitline`
 - `gitbook-start-iaas-ull-es-alex-moi`
 - `@backstage/plugin-techdocs-module-addons-contrib`
 - `@con-test/react-native-concent-common`
 - `@activeviam/documentation`
 - `@hjin/generator-app`
 - `@githubtraining/github-exercise-manager`
 - `@hnp/package-scripts`
 - `@epranka/create-tsx-package`
 - `@elestu/actions-dependacop`
 - `@mayahq/mayadev`
 - `@pagedip/tool-autorelease`
 - `@stavalfi/ci`
 - `myrenobatebot`
 - `node-norman`
 - `@shushuer/cli`
 - `birken-react-native-community-image-editor`
 - `cetus-cli`
 - `cc-flow`
 - `@rocket.chat/houston`
 - `create-sourcegraph-extension`
 - `create-release-it`
 - `gatsby-theme-hansin`
 - `git-multi-profile`
 - `gitlab-tool-cli`
 - `luojia-cli-dev`
 - `mdxbook`
 - `reac-native-arun-ramya-test`
 - `react-native-transtracker-library`
 - `react-native-pulsator-native`
 - `react-native-arun-ramya-test`
 - `react-native-arunramya151`
 - `release2hub`
 - `@s-ui/changelog`
 - `vscode-gpm`
 - `sinanews-flutter-boot`
 - `vuepress-theme-next`
 - `bridgewwater-cli`
 - `@kevinbds/plugin-techdocs`
 - `@wpbrothers/sbcli`
 - `@alitajs/block-sdk`
 - `ourbigbook`
 - `ci-yarn-upgrade`
 - `bibi`
 - `gitbook-start-https-alex-moi`
 - `mira`
 - `moto-connector`
 - `@screeb/react-native`
 - `nodeschool-admin`
 - `ogh`
 - `one-more-gitlab-cli`
 - `airbyte-faros-destination`
 - `kube-workflow`
 - `ship-release`
 - `ssh-remote`
 - `strapper`
 - `@backstage/plugin-catalog-import`
 - `@cythral/renovate`
 - `@epranka/create-package`
 - `@gvhinks/wiby`
 - `@generates/kdot`
 - `@georgs/beachball`
 - `@limejs/cli`
 - `@atomist/ci-sdm`
 - `@bcgov/gatsby-source-github-raw`
 - `@buganto/client`
 - `@cloudoki/donderflow`
 - `@makepad/puppeteer-cli`
 - `@mockswitch/cli`
 - `@rescribe/cli`
 - `@pubcore/node-docker-build`
 - `@reshiftsecurity/reshift-plugin-npm`
 - `@tahini/nc`
 - `@senti-techlabs/generator-senti-project-template`
 - `@whey/gatsby-theme-whey`
 - `@zpmpkg/zpm`
 - `@zalando-backstage/plugin-catalog`
 - `air-material_cli`
 - `actions-package-update`
 - `angularvezba`
 - `aral-server`
 - `astra-ufo-sdk`
 - `blog-flutter-boot`
 - `react-native-syan-photo-picker`
 - `@wecraftapps/react-native-use-keyboard`
 - `documentation-fork`
 - `documentation42`
 - `create-n`
 - `gatsby-source-github-raw`
 - `git-csv`
 - `git-cherry-fix`
 - `gitex-flow`
 - `git-push-pr`
 - `kit-command`
 - `l2forlerna`
 - `next-mdx-books`
 - `myrenovatebot`
 - `native-google-login`
 - `private-beachball`
 - `raact-native-arunramya151`
 - `remote-commit-url`
 - `react-native-modal-progress-bar`
 - `react-native-test-module-hhh`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
