"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.byTitle = exports.byPlaceholderText = exports.byTestId = exports.byDisplayValue = exports.byAltText = exports.byLabelText = exports.byBoundAttribute = exports.byText = exports.byRole = void 0;
const DomQueries = __importStar(require("@testing-library/dom"));
const dom_1 = require("@testing-library/dom");
function makeRTLSelector(selection) {
    // too lazy to list out all combinations... macros would come in handy here!
    const exec = (type, waitForOptions, container) => {
        const methodName = `${type}${selection.query === 'ByBoundAttribute'
            ? `By${selection.attribute}`
            : selection.query}`;
        const args = [
            selection.matcher,
            selection.options,
            ...(waitForOptions ? [waitForOptions] : []),
        ];
        if (container) {
            // @ts-ignore
            return DomQueries[methodName](container, ...args);
        }
        // @ts-ignore
        return dom_1.screen[methodName](...args);
    };
    return {
        get: (container) => exec('get', undefined, container),
        getAll: (container) => exec('getAll', undefined, container),
        find: (container, waitForOptions) => exec('find', waitForOptions, container),
        findAll: (container, waitForOptions) => exec('findAll', waitForOptions, container),
        query: (container) => exec('query', undefined, container),
        queryAll: (container) => exec('queryAll', undefined, container),
    };
}
function byRole(role, options) {
    return makeRTLSelector({ query: 'ByRole', matcher: role, options });
}
exports.byRole = byRole;
function byText(id, options) {
    return makeRTLSelector({ query: 'ByText', matcher: id, options });
}
exports.byText = byText;
function byBoundAttribute(attribute, id, options) {
    return makeRTLSelector({
        query: 'ByBoundAttribute',
        attribute,
        matcher: id,
        options,
    });
}
exports.byBoundAttribute = byBoundAttribute;
function byLabelText(id, options) {
    return makeRTLSelector({ query: 'ByLabelText', matcher: id, options });
}
exports.byLabelText = byLabelText;
function byAltText(id, options) {
    return byBoundAttribute('AltText', id, options);
}
exports.byAltText = byAltText;
function byDisplayValue(id, options) {
    return byBoundAttribute('DisplayValue', id, options);
}
exports.byDisplayValue = byDisplayValue;
function byTestId(id, options) {
    return byBoundAttribute('TestId', id, options);
}
exports.byTestId = byTestId;
function byPlaceholderText(id, options) {
    return byBoundAttribute('PlaceholderText', id, options);
}
exports.byPlaceholderText = byPlaceholderText;
function byTitle(id, options) {
    return byBoundAttribute('Title', id, options);
}
exports.byTitle = byTitle;
//# sourceMappingURL=data:application/json;base64,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