import { getUIValue, getUISelection } from '../../document/UI.js';
import '../../utils/click/isClickableInput.js';
import '../../utils/dataTransfer/Clipboard.js';
import { getContentEditable } from '../../utils/edit/isContentEditable.js';
import '../../utils/edit/isEditable.js';
import '../../utils/edit/maxLength.js';
import '@testing-library/dom/dist/helpers.js';
import { hasOwnSelection } from '../../utils/focus/selection.js';
import '../../utils/keyDef/readNextDescriptor.js';
import '../../utils/misc/level.js';
import '../../options.js';
import { setSelection } from './setSelection.js';

/**
 * Expand a selection like the browser does when pressing Ctrl+A.
 */ function selectAll(target) {
    if (hasOwnSelection(target)) {
        return setSelection({
            focusNode: target,
            anchorOffset: 0,
            focusOffset: getUIValue(target).length
        });
    }
    var ref;
    const focusNode = (ref = getContentEditable(target)) !== null && ref !== void 0 ? ref : target.ownerDocument.body;
    setSelection({
        focusNode,
        anchorOffset: 0,
        focusOffset: focusNode.childNodes.length
    });
}
function isAllSelected(target) {
    if (hasOwnSelection(target)) {
        return getUISelection(target).startOffset === 0 && getUISelection(target).endOffset === getUIValue(target).length;
    }
    var ref;
    const focusNode = (ref = getContentEditable(target)) !== null && ref !== void 0 ? ref : target.ownerDocument.body;
    const selection = target.ownerDocument.getSelection();
    return (selection === null || selection === void 0 ? void 0 : selection.anchorNode) === focusNode && selection.focusNode === focusNode && selection.anchorOffset === 0 && selection.focusOffset === focusNode.childNodes.length;
}

export { isAllSelected, selectAll };
