import { FlattedElement, IArrayFormat, IObject, SplitOptions } from "./types";
export declare function dot(a1: number, a2: number, b1: number, b2: number): number;
export declare function isUndefined(value: any): value is undefined;
export declare function isObject(value: any): value is IObject<any>;
export declare function isArray(value: any): value is any[];
export declare function isString(value: any): value is string;
export declare function isNumber(value: any): value is number;
export declare function isFunction(value: any): value is (...args: any[]) => any;
export declare function splitText(text: string, splitOptions: string | SplitOptions): string[];
export declare function splitSpace(text: string): string[];
export declare function splitComma(text: string): string[];
export declare function splitBracket(text: string): {
    prefix?: undefined;
    value?: undefined;
    suffix?: undefined;
} | {
    prefix: string;
    value: string;
    suffix: string;
};
export declare function splitUnit(text: string): {
    prefix: string;
    unit: string;
    value: number;
};
export declare function camelize(str: string): string;
export declare function decamelize(str: string, separator?: string): string;
export declare function toArray<T>(value: IArrayFormat<T>): T[];
export declare function now(): number;
export declare function findIndex<T>(arr: T[], callback: (element: T, index: number, arr: T[]) => any, defaultIndex?: number): number;
export declare function findLastIndex<T>(arr: T[], callback: (element: T, index: number, arr: T[]) => any, defaultIndex?: number): number;
export declare function findLast<T>(arr: T[], callback: (element: T, index: number, arr: T[]) => any, defalutValue?: T): T | undefined;
export declare function find<T>(arr: T[], callback: (element: T, index: number, arr: T[]) => any, defalutValue?: T): T | undefined;
export declare const requestAnimationFrame: (callback: FrameRequestCallback) => number;
export declare const cancelAnimationFrame: (handle: number) => void;
export declare function getKeys(obj: IObject<any>): string[];
export declare function getValues(obj: IObject<any>): any[];
export declare function getEntries(obj: IObject<any>): [string, any][];
export declare function sortOrders(keys: Array<string | number>, orders?: Array<string | number>): void;
export declare function convertUnitSize(pos: string, size: number | IObject<((pos: number) => number) | number>): number;
export declare function between(value: number, min: number, max: number): number;
export declare function checkBoundSize(targetSize: number[], compareSize: number[], isMax: boolean, ratio?: number): number[];
export declare function calculateBoundSize(size: number[], minSize: number[], maxSize: number[], keepRatio?: number | boolean): number[];
export declare function sum(nums: number[]): number;
export declare function average(nums: number[]): number;
export declare function getRad(pos1: number[], pos2: number[]): number;
export declare function getCenterPoint(points: number[][]): number[];
export declare function getShapeDirection(points: number[][]): 1 | -1;
export declare function getDist(a: number[], b?: number[]): number;
export declare function throttle(num: number, unit?: number): number;
export declare function throttleArray(nums: number[], unit?: number): number[];
export declare function counter(num: number): number[];
export declare function replaceOnce(text: string, fromText: RegExp | string, toText: string | ((...args: any[]) => string)): string;
export declare function flat<Type>(arr: Type[][]): Type[];
export declare function deepFlat<T extends any[]>(arr: T): Array<FlattedElement<T[0]>>;
