/// <reference types="react" />
import { FC } from '@betterer/render';
import { BettererTasksDone, BettererTasksStatusUpdate } from './types';
/**
 * @public `props` type for {@link BettererTasksLogger | `<BettererTasksLogger/>`}.
 */
export interface BettererTasksLoggerProps {
    /**
     * Whether the Ink renderer instance should quit after the tasks are complete.
     *
     * @remarks Should be set to `false` if the Ink instance is rendering any other components.
     *
     * @defaultValue `true`
     */
    exit?: boolean;
    /**
     * The name of group of task that is shown to the user
     */
    name: string;
    /**
     * An optional hook to customise the output of the task status summary.
     *
     * @defaultValue `() => ${nRunning} tasks running... ${nDone} tasks done! ${nErrored} tasks errored!`
     */
    update?: BettererTasksStatusUpdate;
    /**
     * An optional callback function that is called whenever a set of tasks are completed.
     */
    done?: BettererTasksDone;
    /**
     * Whether the running time should be rendered.
     *
     * @defaultValue `true`
     */
    timer?: boolean;
}
/**
 * @public Ink component for rendering the output of a set of {@link BettererTask | `BettererTask`s}.
 * The output will update based on the current status of the tasks.
 */
export declare const BettererTasksLogger: FC<BettererTasksLoggerProps>;
//# sourceMappingURL=TasksLogger.d.ts.map