import { BettererLogger } from '@betterer/logger';
import { ForegroundColor } from 'chalk';
import { BettererTasksState } from './useTasksState';
export declare type BettererTaskColour = typeof ForegroundColor;
/**
 * @public An asynchronous task that will be orchestrated by the {@link @betterer/tasks#BettererTasksLogger | `BettererTasksLogger`}.
 *
 * @param logger - Parameter provides access to asynchronous logging which will be shown to the
 * user once the task is complete.
 * @returns If the task returns it is a "success".
 * @throws If the task throws it is a "failure".
 */
export declare type BettererTask = (logger: BettererLogger) => Promise<string | void>;
export declare type BettererTaskLog = [indicator: string, colour: BettererTaskColour, message: string];
export declare type BettererTaskLogs = Array<BettererTaskLog>;
/**
 * @public A function that is called whenever a set of tasks are completed.
 */
export declare type BettererTasksDone = () => void;
/**
 * @public A function that can be used to customise the output of the task status summary.
 *
 * @remarks Useful for custom pluralisation and internationalisation.
 */
export declare type BettererTasksStatusUpdate = (state: BettererTasksState) => string;
//# sourceMappingURL=types.d.ts.map