"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTimer = void 0;
const render_1 = require("@betterer/render");
const utils_1 = require("../utils");
const DEFAULT_TASK_TIME_INTERVAL = 100;
function useTimer(enable = true) {
    const timer = (0, render_1.useRef)(null);
    const [time, setTime] = (0, render_1.useState)((0, utils_1.getPreciseTime)());
    const updateTime = (0, render_1.useCallback)(() => {
        setTime((0, utils_1.getPreciseTime)());
    }, []);
    const clearTime = (0, render_1.useCallback)(() => {
        if (timer.current) {
            clearInterval(timer.current);
        }
    }, []);
    (0, render_1.useEffect)(() => {
        if (!enable) {
            return;
        }
        timer.current = setInterval(updateTime, DEFAULT_TASK_TIME_INTERVAL);
        updateTime();
        return clearTime;
    }, [updateTime, clearTime]);
    return [time, clearTime];
}
exports.useTimer = useTimer;
//# sourceMappingURL=useTimer.js.map