"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _fs = _interopRequireDefault(require("fs"));

var R = _interopRequireWildcard(require("ramda"));

var _utils = require("../utils");

var removeOrigins = R.map(function (_ref) {
  var origin = _ref.origin,
      message = (0, _objectWithoutProperties2.default)(_ref, ["origin"]);
  return message;
});
var removeLineNumbers = R.map(function (message) {
  if (message.origin) {
    message.origin.map(function (originValue) {
      originValue.pop();
      return originValue;
    });
  }

  return message;
});
var lingui = {
  catalogExtension: ".json",
  write: function write(filename, catalog, options) {
    var outputCatalog = catalog;

    if (options.origins === false) {
      outputCatalog = removeOrigins(catalog);
    }

    if (options.origins !== false && options.lineNumbers === false) {
      outputCatalog = removeLineNumbers(outputCatalog);
    }

    (0, _utils.writeFileIfChanged)(filename, JSON.stringify(outputCatalog, null, 2));
  },
  read: function read(filename) {
    var raw = _fs.default.readFileSync(filename).toString();

    try {
      return JSON.parse(raw);
    } catch (e) {
      throw new Error("Cannot read ".concat(filename, ": ").concat(e.message));
    }
  },
  parse: function parse(content) {
    return content;
  }
};
var _default = lingui;
exports.default = _default;