"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _chalk = _interopRequireDefault(require("chalk"));

var _chokidar = _interopRequireDefault(require("chokidar"));

var _fs = _interopRequireDefault(require("fs"));

var R = _interopRequireWildcard(require("ramda"));

var _commander = _interopRequireDefault(require("commander"));

var plurals = _interopRequireWildcard(require("make-plural"));

var _conf = require("@lingui/conf");

var _catalog = require("./api/catalog");

var _compile = require("./api/compile");

var _help = require("./api/help");

var _api = require("./api");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var noMessages = R.pipe(R.map(R.isEmpty), R.values, R.all(R.equals(true)));

function command(config, options) {
  var catalogs = (0, _catalog.getCatalogs)(config);

  if (noMessages(catalogs)) {
    console.error("Nothing to compile, message catalogs are empty!\n");
    console.error("(use \"".concat(_chalk.default.yellow((0, _help.helpRun)("extract")), "\" to extract messages from source files)"));
    return false;
  } // Check config.compile.merge if catalogs for current locale are to be merged into a single compiled file


  var doMerge = !!config.catalogsMergePath;
  var mergedCatalogs = {};
  console.error("Compiling message catalogs…");
  config.locales.forEach(function (locale) {
    var _locale$split = locale.split(/[_-]/),
        _locale$split2 = (0, _slicedToArray2.default)(_locale$split, 1),
        language = _locale$split2[0];

    if (locale !== config.pseudoLocale && !plurals[language]) {
      console.log(_chalk.default.red("Error: Invalid locale ".concat(_chalk.default.bold(locale), " (missing plural rules)!")));
      console.error();
      process.exit(1);
    }

    catalogs.forEach(function (catalog) {
      var messages = catalog.getTranslations(locale, {
        fallbackLocales: config.fallbackLocales,
        sourceLocale: config.sourceLocale
      });

      if (!options.allowEmpty) {
        var missingMsgIds = R.pipe(R.pickBy(R.isNil), R.keys)(messages);

        if (missingMsgIds.length > 0) {
          console.error(_chalk.default.red("Error: Failed to compile catalog for locale ".concat(_chalk.default.bold(locale), "!")));

          if (options.verbose) {
            console.error(_chalk.default.red("Missing translations:"));
            missingMsgIds.forEach(function (msgId) {
              return console.log(msgId);
            });
          } else {
            console.error(_chalk.default.red("Missing ".concat(missingMsgIds.length, " translation(s)")));
          }

          console.error();
          process.exit(1);
        }
      }

      if (doMerge) {
        mergedCatalogs = _objectSpread(_objectSpread({}, mergedCatalogs), messages);
      } else {
        var namespace = options.typescript ? "ts" : options.namespace || config.compileNamespace;
        var compiledCatalog = (0, _compile.createCompiledCatalog)(locale, messages, {
          strict: false,
          namespace: namespace,
          pseudoLocale: config.pseudoLocale,
          compilerBabelOptions: config.compilerBabelOptions
        });
        var compiledPath = catalog.writeCompiled(locale, compiledCatalog, namespace);

        if (options.typescript) {
          var typescriptPath = compiledPath.replace(/\.ts?$/, "") + ".d.ts";

          _fs.default.writeFileSync(typescriptPath, "import { Messages } from '@lingui/core';\n          declare const messages: Messages;\n          export { messages };\n          ");
        }

        options.verbose && console.error(_chalk.default.green("".concat(locale, " \u21D2 ").concat(compiledPath)));
      }
    });
  });
  return true;
}

if (require.main === module) {
  _commander.default.description("Add compile message catalogs and add language data (plurals) to compiled bundle.").option("--config <path>", "Path to the config file").option("--strict", "Disable defaults for missing translations").option("--verbose", "Verbose output").option("--format <format>", "Format of message catalog").option("--typescript", "Create Typescript definition for compiled bundle").option("--namespace <namespace>", "Specify namespace for compiled bundle. Ex: cjs(default) -> module.exports, es -> export, window.test -> window.test").option("--watch", "Enables Watch Mode").option("--debounce <delay>", "Debounces compilation for given amount of milliseconds").on("--help", function () {
    console.log("\n  Examples:\n");
    console.log("    # Compile translations and use defaults or message IDs for missing translations");
    console.log("    $ ".concat((0, _help.helpRun)("compile")));
    console.log("");
    console.log("    # Compile translations but fail when there are missing");
    console.log("    # translations (don't replace missing translations with");
    console.log("    # default messages or message IDs)");
    console.log("    $ ".concat((0, _help.helpRun)("compile --strict")));
  }).parse(process.argv);

  var config = (0, _conf.getConfig)({
    configPath: _commander.default.config
  });

  if (_commander.default.format) {
    var msg = "--format option is deprecated and will be removed in @lingui/cli@3.0.0." + " Please set format in configuration https://lingui.js.org/ref/conf.html#format";
    console.warn(msg);
    config.format = _commander.default.format;
  }

  var compile = function compile() {
    return command(config, {
      verbose: _commander.default.watch || _commander.default.verbose || false,
      allowEmpty: !_commander.default.strict,
      typescript: _commander.default.typescript || config.compileNamespace === "ts" || false,
      namespace: _commander.default.namespace // we want this to be undefined if user does not specify so default can be used

    });
  };

  var debounceTimer;

  var dispatchCompile = function dispatchCompile() {
    // Skip debouncing if not enabled
    if (!_commander.default.debounce) return compile(); // CLear the previous timer if there is any, and schedule the next

    debounceTimer && clearTimeout(debounceTimer);
    debounceTimer = setTimeout(function () {
      return compile();
    }, _commander.default.debounce);
  }; // Check if Watch Mode is enabled


  if (_commander.default.watch) {
    var NAME = "{name}";
    var LOCALE = "{locale}";
    console.info(_chalk.default.bold("Initializing Watch Mode..."));

    var _catalogs = (0, _catalog.getCatalogs)(config);

    var paths = [];
    var catalogExtension = (0, _api.getFormat)(config.format).catalogExtension;
    config.locales.forEach(function (locale) {
      _catalogs.forEach(function (catalog) {
        paths.push("".concat(catalog.path.replace(LOCALE, locale).replace(NAME, "*")).concat(catalogExtension));
      });
    });

    var watcher = _chokidar.default.watch(paths, {
      persistent: true
    });

    var onReady = function onReady() {
      console.info(_chalk.default.green.bold("Watcher is ready!"));
      watcher.on("add", function () {
        return dispatchCompile();
      }).on("change", function () {
        return dispatchCompile();
      });
    };

    watcher.on("ready", function () {
      return onReady();
    });
  } else {
    var results = compile();

    if (!results) {
      process.exit(1);
    }

    console.log("Done!");
  }
}