import { Instrumentation, MetaItem, App, Session, User, Config, Transport, Patterns, APIEvent, BeforeSendHook } from '@grafana/agent-core';
export interface BrowserConfig {
    app: App;
    url?: string;
    apiKey?: string;
    session?: Session;
    user?: User;
    globalObjectKey?: string;
    preventGlobalExposure?: boolean;
    metas?: MetaItem[];
    instrumentations?: Instrumentation[];
    transports?: Transport[];
    ignoreErrors?: Patterns;
    beforeSend?: BeforeSendHook<APIEvent>;
    paused?: boolean;
}
export declare const defaultMetas: MetaItem[];
interface GetWebInstrumentationsOptions {
    captureConsole?: boolean;
}
export declare const getWebInstrumentations: (options?: GetWebInstrumentationsOptions) => Instrumentation[];
export declare function makeCoreConfig(browserConfig: BrowserConfig): Config;
export {};
