import { isPrimitive } from '@grafana/agent-core';
import { primitiveUnhandledType, primitiveUnhandledValue } from './const';
import { getErrorDetails } from './getErrorDetails';
export function registerOnunhandledrejection(agent) {
    window.addEventListener('unhandledrejection', (event) => {
        var _a, _b;
        let error = event;
        if (error.reason) {
            error = event.reason;
        }
        else if ((_a = event.detail) === null || _a === void 0 ? void 0 : _a.reason) {
            error = (_b = event.detail) === null || _b === void 0 ? void 0 : _b.reason;
        }
        let value;
        let type;
        if (isPrimitive(error)) {
            value = `${primitiveUnhandledValue} ${String(error)}`;
            type = primitiveUnhandledType;
        }
        else {
            [value, type] = getErrorDetails(error);
        }
        if (value) {
            agent.api.pushError(new Error(value), { type });
        }
    });
}
//# sourceMappingURL=registerOnunhandledrejection.js.map