import { AggregationTemporality } from './AggregationTemporality';
import { MetricProducer } from './MetricProducer';
import { CollectionResult } from './MetricData';
import { InstrumentType } from '../InstrumentDescriptor';
import { CollectionOptions, ForceFlushOptions, ShutdownOptions } from '../types';
/**
 * A registered reader of metrics that, when linked to a {@link MetricProducer}, offers global
 * control over metrics.
 */
export declare abstract class MetricReader {
    private _shutdown;
    private _metricProducer?;
    /**
     * Set the {@link MetricProducer} used by this instance.
     *
     * @param metricProducer
     */
    setMetricProducer(metricProducer: MetricProducer): void;
    /**
     * Get the default {@link AggregationTemporality} for the given {@link InstrumentType}
     */
    abstract selectAggregationTemporality(instrumentType: InstrumentType): AggregationTemporality;
    /**
     * Handle once the SDK has initialized this {@link MetricReader}
     * Overriding this method is optional.
     */
    protected onInitialized(): void;
    /**
     * Handle a shutdown signal by the SDK.
     *
     * <p> For push exporters, this should shut down any intervals and close any open connections.
     * @protected
     */
    protected abstract onShutdown(): Promise<void>;
    /**
     * Handle a force flush signal by the SDK.
     *
     * <p> In all scenarios metrics should be collected via {@link collect()}.
     * <p> For push exporters, this should collect and report metrics.
     * @protected
     */
    protected abstract onForceFlush(): Promise<void>;
    /**
     * Collect all metrics from the associated {@link MetricProducer}
     */
    collect(options?: CollectionOptions): Promise<CollectionResult>;
    /**
     * Shuts down the metric reader, the promise will reject after the optional timeout or resolve after completion.
     *
     * <p> NOTE: this operation will continue even after the promise rejects due to a timeout.
     * @param options options with timeout.
     */
    shutdown(options?: ShutdownOptions): Promise<void>;
    /**
     * Flushes metrics read by this reader, the promise will reject after the optional timeout or resolve after completion.
     *
     * <p> NOTE: this operation will continue even after the promise rejects due to a timeout.
     * @param options options with timeout.
     */
    forceFlush(options?: ForceFlushOptions): Promise<void>;
}
//# sourceMappingURL=MetricReader.d.ts.map