# Installation
> `npm install --save @types/debounce-promise`

# Summary
This package contains type definitions for debounce-promise (https://github.com/bjoerge/debounce-promise).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/debounce-promise.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/debounce-promise/index.d.ts)
````ts
// Type definitions for debounce-promise 3.1
// Project: https://github.com/bjoerge/debounce-promise
// Definitions by: Wu Haotian <https://github.com/whtsky>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

declare namespace debounce {
    interface DebounceOptions {
        leading?: boolean | undefined;
        accumulate?: boolean | undefined;
    }
}

declare function debounce<T extends (...args: any[]) => any>(
    func: T,
    wait?: number,
    options?: debounce.DebounceOptions
): (
    ...args: Parameters<T>
) => ReturnType<T> extends Promise<any>
    ? ReturnType<T>
    : Promise<ReturnType<T>>;

export = debounce;

````

### Additional Details
 * Last updated: Tue, 06 Jul 2021 20:32:42 GMT
 * Dependencies: none
 * Global values: none

# Credits
These definitions were written by [Wu Haotian](https://github.com/whtsky).
