Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = require('react');
var React__default = _interopDefault(React);
var ui = require('@grafana/ui');
var data = require('@grafana/data');
var lodash = require('lodash');

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

var standardRegions = [
    'af-south-1',
    'ap-east-1',
    'ap-northeast-1',
    'ap-northeast-2',
    'ap-northeast-3',
    'ap-south-1',
    'ap-southeast-1',
    'ap-southeast-2',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-north-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'me-south-1',
    'sa-east-1',
    'us-east-1',
    'us-east-2',
    'us-gov-east-1',
    'us-gov-west-1',
    'us-iso-east-1',
    'us-isob-east-1',
    'us-west-1',
    'us-west-2',
];

(function (AwsAuthType) {
    AwsAuthType["Keys"] = "keys";
    AwsAuthType["Credentials"] = "credentials";
    AwsAuthType["Default"] = "default";
    AwsAuthType["EC2IAMRole"] = "ec2_iam_role";
    /**
     * @deprecated use default
     */
    AwsAuthType["ARN"] = "arn";
})(exports.AwsAuthType || (exports.AwsAuthType = {}));

var awsAuthProviderOptions = [
    {
        label: 'Workspace IAM Role',
        value: exports.AwsAuthType.EC2IAMRole,
    },
    {
        label: 'AWS SDK Default',
        value: exports.AwsAuthType.Default,
    },
    {
        label: 'Access & secret key',
        value: exports.AwsAuthType.Keys,
    },
    {
        label: 'Credentials file',
        value: exports.AwsAuthType.Credentials,
    },
];

var toOption = function (value) { return ({ value: value, label: value }); };
var ConnectionConfig = function (props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    var _k = __read(React.useState((props.standardRegions || standardRegions).map(toOption)), 2), regions = _k[0], setRegions = _k[1];
    var loadRegions = props.loadRegions, onOptionsChange = props.onOptionsChange, _l = props.skipHeader, skipHeader = _l === void 0 ? false : _l, _m = props.skipEndpoint, skipEndpoint = _m === void 0 ? false : _m;
    var options = props.options;
    var profile = options.jsonData.profile;
    if (profile === undefined) {
        profile = options.database;
    }
    var settings = window.grafanaBootData.settings;
    var awsAllowedAuthProviders = (_a = settings.awsAllowedAuthProviders) !== null && _a !== void 0 ? _a : [
        exports.AwsAuthType.Default,
        exports.AwsAuthType.Keys,
        exports.AwsAuthType.Credentials,
    ];
    var awsAssumeRoleEnabled = (_b = settings.awsAssumeRoleEnabled) !== null && _b !== void 0 ? _b : true;
    var currentProvider = awsAuthProviderOptions.find(function (p) { return p.value === options.jsonData.authType; });
    React.useEffect(function () {
        // Make sure a authType exists in the current model
        if (!currentProvider && awsAllowedAuthProviders.length) {
            onOptionsChange(__assign(__assign({}, options), { jsonData: __assign(__assign({}, options.jsonData), { authType: awsAllowedAuthProviders[0] }) }));
        }
    }, [currentProvider, options, onOptionsChange]);
    React.useEffect(function () {
        if (!loadRegions) {
            return;
        }
        loadRegions().then(function (regions) { return setRegions(regions.map(toOption)); });
    }, [loadRegions]);
    return (React__default.createElement(ui.FieldSet, { label: skipHeader ? '' : 'Connection Details', "data-testid": "connection-config" },
        React__default.createElement(ui.InlineField, { label: "Authentication Provider", labelWidth: 28, tooltip: "Specify which AWS credentials chain to use." },
            React__default.createElement(ui.Select, { "aria-label": "Authentication Provider", className: "width-30", value: currentProvider, options: awsAuthProviderOptions.filter(function (opt) { return awsAllowedAuthProviders.includes(opt.value); }), defaultValue: options.jsonData.authType, onChange: function (option) {
                    data.onUpdateDatasourceJsonDataOptionSelect(props, 'authType')(option);
                }, menuShouldPortal: true })),
        options.jsonData.authType === 'credentials' && (React__default.createElement(ui.InlineField, { label: "Credentials Profile Name", labelWidth: 28, tooltip: "Credentials profile name, as specified in ~/.aws/credentials, leave blank for default." },
            React__default.createElement(ui.Input, { "aria-label": "Credentials Profile Name", className: "width-30", placeholder: "default", value: profile, onChange: data.onUpdateDatasourceJsonDataOption(props, 'profile') }))),
        options.jsonData.authType === 'keys' && (React__default.createElement(React__default.Fragment, null,
            React__default.createElement(ui.InlineField, { label: "Access Key ID", labelWidth: 28 }, ((_c = props.options.secureJsonFields) === null || _c === void 0 ? void 0 : _c.accessKey) ? (React__default.createElement(ui.ButtonGroup, { className: "width-30" },
                React__default.createElement(ui.Input, { disabled: true, placeholder: "Configured" }),
                React__default.createElement(ui.ToolbarButton, { icon: "edit", tooltip: "Edit Access Key ID", type: "button", onClick: data.onUpdateDatasourceResetOption(props, 'accessKey') }))) : (React__default.createElement(ui.Input, { "aria-label": "Access Key ID", className: "width-30", value: (_e = (_d = options.secureJsonData) === null || _d === void 0 ? void 0 : _d.accessKey) !== null && _e !== void 0 ? _e : '', onChange: data.onUpdateDatasourceSecureJsonDataOption(props, 'accessKey') }))),
            React__default.createElement(ui.InlineField, { label: "Secret Access Key", labelWidth: 28 }, ((_f = props.options.secureJsonFields) === null || _f === void 0 ? void 0 : _f.secretKey) ? (React__default.createElement(ui.ButtonGroup, { className: "width-30" },
                React__default.createElement(ui.Input, { disabled: true, placeholder: "Configured" }),
                React__default.createElement(ui.ToolbarButton, { icon: "edit", type: "button", tooltip: "Edit Secret Access Key", onClick: data.onUpdateDatasourceResetOption(props, 'secretKey') }))) : (React__default.createElement(ui.Input, { "aria-label": "Secret Access Key", className: "width-30", value: (_h = (_g = options.secureJsonData) === null || _g === void 0 ? void 0 : _g.secretKey) !== null && _h !== void 0 ? _h : '', onChange: data.onUpdateDatasourceSecureJsonDataOption(props, 'secretKey') }))))),
        awsAssumeRoleEnabled && (React__default.createElement(React__default.Fragment, null,
            React__default.createElement(ui.InlineField, { label: "Assume Role ARN", labelWidth: 28, tooltip: "Optionally, specify the ARN of a role to assume. Specifying a role here will ensure that the selected authentication provider is used to assume the specified role rather than using the credentials directly. Leave blank if you don't need to assume a role at all" },
                React__default.createElement(ui.Input, { "aria-label": "Assume Role ARN", className: "width-30", placeholder: "arn:aws:iam:*", value: options.jsonData.assumeRoleArn || '', onChange: data.onUpdateDatasourceJsonDataOption(props, 'assumeRoleArn') })),
            React__default.createElement(ui.InlineField, { label: "External ID", labelWidth: 28, tooltip: "If you are assuming a role in another account, that has been created with an external ID, specify the external ID here." },
                React__default.createElement(ui.Input, { "aria-label": "External ID", className: "width-30", placeholder: "External ID", value: options.jsonData.externalId || '', onChange: data.onUpdateDatasourceJsonDataOption(props, 'externalId') })))),
        !skipEndpoint && (React__default.createElement(ui.InlineField, { label: "Endpoint", labelWidth: 28, tooltip: "Optionally, specify a custom endpoint for the service" },
            React__default.createElement(ui.Input, { "aria-label": "Endpoint", className: "width-30", placeholder: (_j = props.defaultEndpoint) !== null && _j !== void 0 ? _j : 'https://{service}.{region}.amazonaws.com', value: options.jsonData.endpoint || '', onChange: data.onUpdateDatasourceJsonDataOption(props, 'endpoint') }))),
        React__default.createElement(ui.InlineField, { label: "Default Region", labelWidth: 28, tooltip: "Specify the region, such as for US West (Oregon) use ` us-west-2 ` as the region." },
            React__default.createElement(ui.Select, { "aria-label": "Default Region", className: "width-30", value: regions.find(function (region) { return region.value === options.jsonData.defaultRegion; }), options: regions, defaultValue: options.jsonData.defaultRegion, allowCustomValue: true, onChange: data.onUpdateDatasourceJsonDataOptionSelect(props, 'defaultRegion'), formatCreateLabel: function (r) { return "Use region: " + r; }, menuShouldPortal: true })),
        props.children));
};

var SIGV4ConnectionConfig = function (props) {
    var _a, _b, _c, _d;
    var onOptionsChange = props.onOptionsChange, options = props.options;
    // Map HttpSettings props to ConnectionConfigProps
    var connectionConfigProps = {
        onOptionsChange: function (awsDataSourceSettings) {
            var _a, _b, _c, _d;
            var dataSourceSettings = __assign(__assign({}, options), { jsonData: __assign(__assign({}, options.jsonData), { sigV4AuthType: awsDataSourceSettings.jsonData.authType, sigV4Profile: awsDataSourceSettings.jsonData.profile, sigV4AssumeRoleArn: awsDataSourceSettings.jsonData.assumeRoleArn, sigV4ExternalId: awsDataSourceSettings.jsonData.externalId, sigV4Region: awsDataSourceSettings.jsonData.defaultRegion, sigV4Endpoint: awsDataSourceSettings.jsonData.endpoint }), secureJsonFields: {
                    sigV4AccessKey: (_a = awsDataSourceSettings.secureJsonFields) === null || _a === void 0 ? void 0 : _a.accessKey,
                    sigV4SecretKey: (_b = awsDataSourceSettings.secureJsonFields) === null || _b === void 0 ? void 0 : _b.secretKey,
                }, secureJsonData: {
                    sigV4AccessKey: (_c = awsDataSourceSettings.secureJsonData) === null || _c === void 0 ? void 0 : _c.accessKey,
                    sigV4SecretKey: (_d = awsDataSourceSettings.secureJsonData) === null || _d === void 0 ? void 0 : _d.secretKey,
                } });
            onOptionsChange(dataSourceSettings);
        },
        options: __assign(__assign({}, options), { jsonData: __assign(__assign({}, options.jsonData), { authType: options.jsonData.sigV4AuthType, profile: options.jsonData.sigV4Profile, assumeRoleArn: options.jsonData.sigV4AssumeRoleArn, externalId: options.jsonData.sigV4ExternalId, defaultRegion: options.jsonData.sigV4Region, endpoint: options.jsonData.sigV4Endpoint }), secureJsonFields: {
                accessKey: (_a = options.secureJsonFields) === null || _a === void 0 ? void 0 : _a.sigV4AccessKey,
                secretKey: (_b = options.secureJsonFields) === null || _b === void 0 ? void 0 : _b.sigV4SecretKey,
            }, secureJsonData: {
                accessKey: (_c = options.secureJsonData) === null || _c === void 0 ? void 0 : _c.sigV4AccessKey,
                secretKey: (_d = options.secureJsonData) === null || _d === void 0 ? void 0 : _d.sigV4SecretKey,
            } }),
    };
    return (React__default.createElement(React__default.Fragment, null,
        React__default.createElement("div", { className: "gf-form" },
            React__default.createElement("h6", null, "SigV4 Auth Details")),
        React__default.createElement(ConnectionConfig, __assign({}, connectionConfigProps, { skipHeader: true, skipEndpoint: true }))));
};

var defaultKey = '__default';

function ResourceSelector(props) {
    var _this = this;
    var _a = __read(React.useState(props.value || props.default || null), 2), resource = _a[0], setResource = _a[1];
    var _b = __read(React.useState(resource ? [resource] : []), 2), resources = _b[0], setResources = _b[1];
    var _c = __read(React.useState(props.dependencies), 2), dependencies = _c[0], setDependencies = _c[1];
    var _d = __read(React.useState(false), 2), isLoading = _d[0], setIsLoading = _d[1];
    var _e = __read(React.useState(false), 2), fetched = _e[0], setFetched = _e[1];
    var defaultOpts = React.useMemo(function () {
        var opts = [
            {
                label: "default (" + props.default + ")",
                value: defaultKey,
                description: "Default value set in the data source",
            },
        ];
        if (props.value && props.value !== defaultKey) {
            opts.push({ label: props.value, value: props.value });
        }
        return opts;
    }, [props.default, props.value]);
    var _f = __read(React.useState(props.default ? defaultOpts : []), 2), options = _f[0], setOptions = _f[1];
    React.useEffect(function () {
        if (props.resources !== undefined) {
            setResources(props.resources);
        }
    }, [props.resources]);
    React.useEffect(function () {
        var newOptions = props.default ? defaultOpts : [];
        if (resources.length) {
            resources.forEach(function (r) {
                var value = typeof r === 'string' ? r : r.value;
                if (!newOptions.find(function (o) { return o.value === value; })) {
                    typeof r === 'string' ? newOptions.push({ label: r, value: r }) : newOptions.push(r);
                }
            });
            setOptions(newOptions);
        }
        else {
            setOptions([]);
        }
    }, [resources, defaultOpts, props.default]);
    React.useEffect(function () {
        // A change in the dependencies cause a state clean-up
        if (!lodash.isEqual(props.dependencies, dependencies)) {
            setFetched(false);
            setResource(null);
            props.onChange(null);
            setDependencies(props.dependencies);
        }
    }, [props, dependencies]);
    var fetch = function () { return __awaiter(_this, void 0, void 0, function () {
        var resources_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (fetched) {
                        return [2 /*return*/];
                    }
                    if (!props.saveOptions) return [3 /*break*/, 2];
                    return [4 /*yield*/, props.saveOptions()];
                case 1:
                    _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 4, 5]);
                    return [4 /*yield*/, props.fetch()];
                case 3:
                    resources_1 = _a.sent();
                    setResources(resources_1);
                    return [3 /*break*/, 5];
                case 4:
                    setFetched(true);
                    return [7 /*endfinally*/];
                case 5: return [2 /*return*/];
            }
        });
    }); };
    var onChange = function (e) {
        props.onChange(e);
        if (e.value) {
            setResource(e.value);
        }
    };
    var onClick = function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    setIsLoading(true);
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, , 3, 4]);
                    return [4 /*yield*/, fetch()];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 4];
                case 3:
                    setIsLoading(false);
                    return [7 /*endfinally*/];
                case 4: return [2 /*return*/];
            }
        });
    }); };
    return (React__default.createElement(ui.InlineField, { label: props.label, labelWidth: props.labelWidth, tooltip: props.tooltip, hidden: props.hidden },
        React__default.createElement("div", { "data-testid": props['data-testid'], title: props.title },
            React__default.createElement(ui.Select, __assign({}, props, { "aria-label": props.label, options: options, onChange: onChange, isLoading: isLoading, className: props.className || 'min-width-6', onOpenMenu: function () { return props.fetch && onClick(); }, menuShouldPortal: true })))));
}

function ConfigSelect(props) {
    var _a, _b;
    var jsonData = props.options.jsonData;
    var commonProps = {
        title: jsonData.defaultRegion ? '' : 'select a default region',
        labelWidth: 28,
        className: 'width-30',
    };
    // Any change in the AWS connection details will affect selectors
    var dependencies = [
        props.options.jsonData.assumeRoleArn,
        props.options.jsonData.authType,
        props.options.jsonData.defaultRegion,
        props.options.jsonData.endpoint,
        props.options.jsonData.externalId,
        props.options.jsonData.profile,
        (_a = props.options.secureJsonData) === null || _a === void 0 ? void 0 : _a.accessKey,
        (_b = props.options.secureJsonData) === null || _b === void 0 ? void 0 : _b.secretKey,
    ].concat(props.dependencies);
    return (React__default.createElement(ResourceSelector, __assign({ label: props.label, "data-testid": props['data-testid'], onChange: props.onChange, fetch: props.fetch, value: props.value, saveOptions: props.saveOptions, dependencies: dependencies, hidden: props.hidden, disabled: props.disabled || !jsonData.defaultRegion, allowCustomValue: props.allowCustomValue, autoFocus: props.autoFocus, backspaceRemovesValue: props.backspaceRemovesValue, className: props.className, invalid: props.invalid, isClearable: props.isClearable, isMulti: props.isMulti, inputId: props.inputId, showAllSelectedWhenOpen: props.showAllSelectedWhenOpen, maxMenuHeight: props.maxMenuHeight, minMenuHeight: props.minMenuHeight, maxVisibleValues: props.maxVisibleValues, menuPlacement: props.menuPlacement, menuPosition: props.menuPosition, noOptionsMessage: props.noOptionsMessage, onBlur: props.onBlur, onCreateOption: props.onCreateOption, onInputChange: props.onInputChange, placeholder: props.placeholder, width: props.width, isOptionDisabled: props.isOptionDisabled }, commonProps)));
}

function InlineInput(props) {
    return (React__default.createElement(ui.InlineField, { label: props.label, labelWidth: 28, tooltip: props.tooltip, hidden: props.hidden, disabled: props.disabled },
        React__default.createElement(ui.Input, { "data-testid": props['data-testid'], className: "width-30", value: props.value, onChange: props.onChange, placeholder: props.placeholder, disabled: props.disabled })));
}

function QueryCodeEditor(props) {
    var getSuggestions = props.getSuggestions, query = props.query;
    var rawSQL = lodash.defaults(props.query, { rawSQL: '' }).rawSQL;
    var onRawSqlChange = function (rawSQL) {
        var query = __assign(__assign({}, props.query), { rawSQL: rawSQL });
        props.onChange(query);
        props.onRunQuery();
    };
    // Use a reference for suggestions because a bug in CodeEditor getSuggestions
    // https://github.com/grafana/grafana/issues/40121
    // It was been fixed in 8.3 but keeping the workaround here to support older
    // versions.
    var suggestionsRef = React.useRef([]);
    React.useEffect(function () {
        suggestionsRef.current = getSuggestions(query);
    }, [getSuggestions, query]);
    return (React__default.createElement(ui.CodeEditor, __assign({ language: props.language, value: rawSQL, onBlur: onRawSqlChange, showMiniMap: false, showLineNumbers: true, getSuggestions: function () { return suggestionsRef.current; }, height: "240px" }, props.editorProps)));
}

function FormatSelect(props) {
    var onChangeFormat = function (e) {
        props.onChange(__assign(__assign({}, props.query), { format: e.value || 0 }));
        props.onRunQuery();
    };
    return (React__default.createElement(ui.InlineField, { label: "Format as", labelWidth: 11 },
        React__default.createElement(ui.Select, { "aria-label": "Format as", options: props.options, value: props.query.format, onChange: onChangeFormat, className: "width-12", menuShouldPortal: true })));
}

(function (FillValueOptions) {
    FillValueOptions[FillValueOptions["Previous"] = 0] = "Previous";
    FillValueOptions[FillValueOptions["Null"] = 1] = "Null";
    FillValueOptions[FillValueOptions["Value"] = 2] = "Value";
})(exports.FillValueOptions || (exports.FillValueOptions = {}));
var SelectableFillValueOptions = [
    {
        label: 'Previous Value',
        value: exports.FillValueOptions.Previous,
    },
    {
        label: 'NULL',
        value: exports.FillValueOptions.Null,
    },
    {
        label: 'Value',
        value: exports.FillValueOptions.Value,
    },
];
function FillValueSelect(props) {
    var _a, _b, _c;
    return (React__default.createElement(React__default.Fragment, null,
        React__default.createElement(ui.InlineField, { label: "Fill value", tooltip: "value to fill missing points" },
            React__default.createElement(ui.Select, { "aria-label": "Fill value", options: SelectableFillValueOptions, value: (_b = (_a = props.query.fillMode) === null || _a === void 0 ? void 0 : _a.mode) !== null && _b !== void 0 ? _b : exports.FillValueOptions.Previous, onChange: function (_a) {
                    var value = _a.value;
                    props.onChange(__assign(__assign({}, props.query), { 
                        // Keep the fillMode.value in case FillValueOptions.Value mode is selected back
                        fillMode: __assign(__assign({}, props.query.fillMode), { mode: value }) }));
                    props.onRunQuery();
                }, className: "width-12", menuShouldPortal: true })),
        ((_c = props.query.fillMode) === null || _c === void 0 ? void 0 : _c.mode) === exports.FillValueOptions.Value && (React__default.createElement(ui.InlineField, { label: "Value", labelWidth: 11 },
            React__default.createElement(ui.Input, { type: "number", "aria-label": "Value", value: props.query.fillMode.value, onChange: function (_a) {
                    var currentTarget = _a.currentTarget;
                    return props.onChange(__assign(__assign({}, props.query), { fillMode: {
                            mode: exports.FillValueOptions.Value,
                            value: currentTarget.valueAsNumber,
                        } }));
                }, onBlur: function () { return props.onRunQuery(); } })))));
}

/**
 * Do not execute queries that do not exist yet
 */
function filterSQLQuery(query) {
    return !!query.rawSQL;
}
function applySQLTemplateVariables(query, scopedVars, getTemplateSrv) {
    var templateSrv = getTemplateSrv();
    return __assign(__assign({}, query), { rawSQL: templateSrv.replace(query.rawSQL, scopedVars, interpolateVariable) });
}
function interpolateVariable(value) {
    if (typeof value === 'string') {
        return value;
    }
    var quotedValues = value.map(function (v) {
        return quoteLiteral(v);
    });
    return quotedValues.join(',');
}
function quoteLiteral(value) {
    return "'" + String(value).replace(/'/g, "''") + "'";
}
var appendTemplateVariablesAsSuggestions = function (getTemplateSrv, sugs) {
    var templateSrv = getTemplateSrv();
    var templateSugs = [];
    templateSrv.getVariables().forEach(function (variable) {
        var label = '$' + variable.name;
        var val = templateSrv.replace(label);
        if (val === label) {
            val = '';
        }
        templateSugs.push({
            label: label,
            kind: ui.CodeEditorSuggestionItemKind.Text,
            detail: "(Template Variable) " + val,
        });
    });
    return sugs.concat(templateSugs);
};

exports.ConfigSelect = ConfigSelect;
exports.ConnectionConfig = ConnectionConfig;
exports.FillValueSelect = FillValueSelect;
exports.FormatSelect = FormatSelect;
exports.InlineInput = InlineInput;
exports.QueryCodeEditor = QueryCodeEditor;
exports.ResourceSelector = ResourceSelector;
exports.SIGV4ConnectionConfig = SIGV4ConnectionConfig;
exports.appendTemplateVariablesAsSuggestions = appendTemplateVariablesAsSuggestions;
exports.applySQLTemplateVariables = applySQLTemplateVariables;
exports.awsAuthProviderOptions = awsAuthProviderOptions;
exports.filterSQLQuery = filterSQLQuery;
exports.standardRegions = standardRegions;
//# sourceMappingURL=index.development.js.map
