/**
 * vis.js
 * https://github.com/almende/vis
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 4.25.0
 * @date    2018-09-20
 *
 * @license
 * Copyright (C) 2011-2017 Almende B.V, http://almende.com
 *
 * Vis.js is dual licensed under both
 *
 * * The Apache 2.0 License
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * and
 *
 * * The MIT License
 *   http://opensource.org/licenses/MIT
 *
 * Vis.js may be distributed under either license.
 */

(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["vis"] = factory();
	else
		root["vis"] = factory();
})(typeof self !== 'undefined' ? self : this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 85);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

exports.default = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _defineProperty = __webpack_require__(130);

var _defineProperty2 = _interopRequireDefault(_defineProperty);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      (0, _defineProperty2.default)(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _getIterator2 = __webpack_require__(58);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _create = __webpack_require__(31);

var _create2 = _interopRequireDefault(_create);

var _keys = __webpack_require__(9);

var _keys2 = _interopRequireDefault(_keys);

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

// utility functions

// first check if moment.js is already loaded in the browser window, if so,
// use this instance. Else, load via commonjs.

var moment = __webpack_require__(71);
var uuid = __webpack_require__(119);

/**
 * Test whether given object is a number
 * @param {*} object
 * @return {Boolean} isNumber
 */
exports.isNumber = function (object) {
  return object instanceof Number || typeof object == 'number';
};

/**
 * Remove everything in the DOM object
 * @param {Element} DOMobject
 */
exports.recursiveDOMDelete = function (DOMobject) {
  if (DOMobject) {
    while (DOMobject.hasChildNodes() === true) {
      exports.recursiveDOMDelete(DOMobject.firstChild);
      DOMobject.removeChild(DOMobject.firstChild);
    }
  }
};

/**
 * Test whether given object is a string
 * @param {*} object
 * @return {Boolean} isString
 */
exports.isString = function (object) {
  return object instanceof String || typeof object == 'string';
};

/**
 * Test whether given object is a Date, or a String containing a Date
 * @param {Date | String} object
 * @return {Boolean} isDate
 */
exports.isDate = function (object) {
  if (object instanceof Date) {
    return true;
  } else if (exports.isString(object)) {
    // test whether this string contains a date
    var match = ASPDateRegex.exec(object);
    if (match) {
      return true;
    } else if (!isNaN(Date.parse(object))) {
      return true;
    }
  }

  return false;
};

/**
 * Create a UUID
 * @return {string} uuid
 */
exports.randomUUID = function () {
  return uuid.v4();
};

/**
 * Copy property from b to a if property present in a.
 * If property in b explicitly set to null, delete it if `allowDeletion` set.
 *
 * Internal helper routine, should not be exported. Not added to `exports` for that reason.
 *
 * @param {object} a  target object
 * @param {object} b  source object
 * @param {string} prop  name of property to copy to a
 * @param {boolean} allowDeletion  if true, delete property in a if explicitly set to null in b
 * @private
 */
function copyOrDelete(a, b, prop, allowDeletion) {
  var doDeletion = false;
  if (allowDeletion === true) {
    doDeletion = b[prop] === null && a[prop] !== undefined;
  }

  if (doDeletion) {
    delete a[prop];
  } else {
    a[prop] = b[prop]; // Remember, this is a reference copy!
  }
}

/**
 * Fill an object with a possibly partially defined other object.
 *
 * Only copies values for the properties already present in a.
 * That means an object is not created on a property if only the b object has it.
 *
 * @param {object} a
 * @param {object} b
 * @param {boolean} [allowDeletion=false]  if true, delete properties in a that are explicitly set to null in b
 */
exports.fillIfDefined = function (a, b) {
  var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  // NOTE: iteration of properties of a
  // NOTE: prototype properties iterated over as well
  for (var prop in a) {
    if (b[prop] !== undefined) {
      if (b[prop] === null || (0, _typeof3['default'])(b[prop]) !== 'object') {
        // Note: typeof null === 'object'
        copyOrDelete(a, b, prop, allowDeletion);
      } else {
        if ((0, _typeof3['default'])(a[prop]) === 'object') {
          exports.fillIfDefined(a[prop], b[prop], allowDeletion);
        }
      }
    }
  }
};

/**
 * Extend object a with the properties of object b or a series of objects
 * Only properties with defined values are copied
 * @param {Object} a
 * @param {...Object} b
 * @return {Object} a
 */
exports.extend = function (a /* b */) {
  // eslint-disable-line no-unused-vars
  for (var i = 1; i < arguments.length; i++) {
    var other = arguments[i];
    for (var prop in other) {
      if (other.hasOwnProperty(prop)) {
        a[prop] = other[prop];
      }
    }
  }
  return a;
};

/**
 * Extend object a with selected properties of object b or a series of objects
 * Only properties with defined values are copied
 * @param {Array.<string>} props
 * @param {Object} a
 * @param {Object} b
 * @return {Object} a
 */
exports.selectiveExtend = function (props, a /* b */) {
  // eslint-disable-line no-unused-vars
  if (!Array.isArray(props)) {
    throw new Error('Array with property names expected as first argument');
  }

  for (var i = 2; i < arguments.length; i++) {
    var other = arguments[i];

    for (var p = 0; p < props.length; p++) {
      var prop = props[p];
      if (other && other.hasOwnProperty(prop)) {
        a[prop] = other[prop];
      }
    }
  }
  return a;
};

/**
 * Extend object a with selected properties of object b.
 * Only properties with defined values are copied.
 *
 * **Note:** Previous version of this routine implied that multiple source objects
 *           could be used; however, the implementation was **wrong**.
 *           Since multiple (>1) sources weren't used anywhere in the `vis.js` code,
 *           this has been removed
 *
 * @param {Array.<string>} props names of first-level properties to copy over
 * @param {object} a  target object
 * @param {object} b  source object
 * @param {boolean} [allowDeletion=false]  if true, delete property in a if explicitly set to null in b
 * @returns {Object} a
 */
exports.selectiveDeepExtend = function (props, a, b) {
  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  // TODO: add support for Arrays to deepExtend
  if (Array.isArray(b)) {
    throw new TypeError('Arrays are not supported by deepExtend');
  }

  for (var p = 0; p < props.length; p++) {
    var prop = props[p];
    if (b.hasOwnProperty(prop)) {
      if (b[prop] && b[prop].constructor === Object) {
        if (a[prop] === undefined) {
          a[prop] = {};
        }
        if (a[prop].constructor === Object) {
          exports.deepExtend(a[prop], b[prop], false, allowDeletion);
        } else {
          copyOrDelete(a, b, prop, allowDeletion);
        }
      } else if (Array.isArray(b[prop])) {
        throw new TypeError('Arrays are not supported by deepExtend');
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    }
  }
  return a;
};

/**
 * Extend object `a` with properties of object `b`, ignoring properties which are explicitly
 * specified to be excluded.
 *
 * The properties of `b` are considered for copying.
 * Properties which are themselves objects are are also extended.
 * Only properties with defined values are copied
 *
 * @param {Array.<string>} propsToExclude  names of properties which should *not* be copied
 * @param {Object}                      a  object to extend
 * @param {Object}                      b  object to take properties from for extension
 * @param {boolean} [allowDeletion=false]  if true, delete properties in a that are explicitly set to null in b
 * @return {Object} a
 */
exports.selectiveNotDeepExtend = function (propsToExclude, a, b) {
  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  // TODO: add support for Arrays to deepExtend
  // NOTE: array properties have an else-below; apparently, there is a problem here.
  if (Array.isArray(b)) {
    throw new TypeError('Arrays are not supported by deepExtend');
  }

  for (var prop in b) {
    if (!b.hasOwnProperty(prop)) continue; // Handle local properties only
    if (propsToExclude.indexOf(prop) !== -1) continue; // In exclusion list, skip

    if (b[prop] && b[prop].constructor === Object) {
      if (a[prop] === undefined) {
        a[prop] = {};
      }
      if (a[prop].constructor === Object) {
        exports.deepExtend(a[prop], b[prop]); // NOTE: allowDeletion not propagated!
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    } else if (Array.isArray(b[prop])) {
      a[prop] = [];
      for (var i = 0; i < b[prop].length; i++) {
        a[prop].push(b[prop][i]);
      }
    } else {
      copyOrDelete(a, b, prop, allowDeletion);
    }
  }

  return a;
};

/**
 * Deep extend an object a with the properties of object b
 *
 * @param {Object} a
 * @param {Object} b
 * @param {boolean} [protoExtend=false]  If true, the prototype values will also be extended.
 *                          (ie. the options objects that inherit from others will also get the inherited options)
 * @param {boolean} [allowDeletion=false] If true, the values of fields that are null will be deleted
 * @returns {Object}
 */
exports.deepExtend = function (a, b) {
  var protoExtend = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  for (var prop in b) {
    if (b.hasOwnProperty(prop) || protoExtend === true) {
      if (b[prop] && b[prop].constructor === Object) {
        if (a[prop] === undefined) {
          a[prop] = {};
        }
        if (a[prop].constructor === Object) {
          exports.deepExtend(a[prop], b[prop], protoExtend); // NOTE: allowDeletion not propagated!
        } else {
          copyOrDelete(a, b, prop, allowDeletion);
        }
      } else if (Array.isArray(b[prop])) {
        a[prop] = [];
        for (var i = 0; i < b[prop].length; i++) {
          a[prop].push(b[prop][i]);
        }
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    }
  }
  return a;
};

/**
 * Test whether all elements in two arrays are equal.
 * @param {Array} a
 * @param {Array} b
 * @return {boolean} Returns true if both arrays have the same length and same
 *                   elements.
 */
exports.equalArray = function (a, b) {
  if (a.length != b.length) return false;

  for (var i = 0, len = a.length; i < len; i++) {
    if (a[i] != b[i]) return false;
  }

  return true;
};

/**
 * Convert an object to another type
 * @param {boolean | number | string | Date | Moment | Null | undefined} object
 * @param {string | undefined} type   Name of the type. Available types:
 *                                    'Boolean', 'Number', 'String',
 *                                    'Date', 'Moment', ISODate', 'ASPDate'.
 * @return {*} object
 * @throws Error
 */
exports.convert = function (object, type) {
  var match;

  if (object === undefined) {
    return undefined;
  }
  if (object === null) {
    return null;
  }

  if (!type) {
    return object;
  }
  if (!(typeof type === 'string') && !(type instanceof String)) {
    throw new Error('Type must be a string');
  }

  //noinspection FallthroughInSwitchStatementJS
  switch (type) {
    case 'boolean':
    case 'Boolean':
      return Boolean(object);

    case 'number':
    case 'Number':
      if (exports.isString(object) && !isNaN(Date.parse(object))) {
        return moment(object).valueOf();
      } else {
        return Number(object.valueOf());
      }
    case 'string':
    case 'String':
      return String(object);

    case 'Date':
      if (exports.isNumber(object)) {
        return new Date(object);
      }
      if (object instanceof Date) {
        return new Date(object.valueOf());
      } else if (moment.isMoment(object)) {
        return new Date(object.valueOf());
      }
      if (exports.isString(object)) {
        match = ASPDateRegex.exec(object);
        if (match) {
          // object is an ASP date
          return new Date(Number(match[1])); // parse number
        } else {
          return moment(new Date(object)).toDate(); // parse string
        }
      } else {
        throw new Error('Cannot convert object of type ' + exports.getType(object) + ' to type Date');
      }

    case 'Moment':
      if (exports.isNumber(object)) {
        return moment(object);
      }
      if (object instanceof Date) {
        return moment(object.valueOf());
      } else if (moment.isMoment(object)) {
        return moment(object);
      }
      if (exports.isString(object)) {
        match = ASPDateRegex.exec(object);
        if (match) {
          // object is an ASP date
          return moment(Number(match[1])); // parse number
        } else {
          return moment(object); // parse string
        }
      } else {
        throw new Error('Cannot convert object of type ' + exports.getType(object) + ' to type Date');
      }

    case 'ISODate':
      if (exports.isNumber(object)) {
        return new Date(object);
      } else if (object instanceof Date) {
        return object.toISOString();
      } else if (moment.isMoment(object)) {
        return object.toDate().toISOString();
      } else if (exports.isString(object)) {
        match = ASPDateRegex.exec(object);
        if (match) {
          // object is an ASP date
          return new Date(Number(match[1])).toISOString(); // parse number
        } else {
          return moment(object).format(); // ISO 8601
        }
      } else {
        throw new Error('Cannot convert object of type ' + exports.getType(object) + ' to type ISODate');
      }

    case 'ASPDate':
      if (exports.isNumber(object)) {
        return '/Date(' + object + ')/';
      } else if (object instanceof Date) {
        return '/Date(' + object.valueOf() + ')/';
      } else if (exports.isString(object)) {
        match = ASPDateRegex.exec(object);
        var value;
        if (match) {
          // object is an ASP date
          value = new Date(Number(match[1])).valueOf(); // parse number
        } else {
          value = new Date(object).valueOf(); // parse string
        }
        return '/Date(' + value + ')/';
      } else {
        throw new Error('Cannot convert object of type ' + exports.getType(object) + ' to type ASPDate');
      }

    default:
      throw new Error('Unknown type "' + type + '"');
  }
};

// parse ASP.Net Date pattern,
// for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
// code from http://momentjs.com/
var ASPDateRegex = /^\/?Date\((\-?\d+)/i;

/**
 * Get the type of an object, for example exports.getType([]) returns 'Array'
 * @param {*} object
 * @return {string} type
 */
exports.getType = function (object) {
  var type = typeof object === 'undefined' ? 'undefined' : (0, _typeof3['default'])(object);

  if (type == 'object') {
    if (object === null) {
      return 'null';
    }
    if (object instanceof Boolean) {
      return 'Boolean';
    }
    if (object instanceof Number) {
      return 'Number';
    }
    if (object instanceof String) {
      return 'String';
    }
    if (Array.isArray(object)) {
      return 'Array';
    }
    if (object instanceof Date) {
      return 'Date';
    }
    return 'Object';
  } else if (type == 'number') {
    return 'Number';
  } else if (type == 'boolean') {
    return 'Boolean';
  } else if (type == 'string') {
    return 'String';
  } else if (type === undefined) {
    return 'undefined';
  }

  return type;
};

/**
 * Used to extend an array and copy it. This is used to propagate paths recursively.
 *
 * @param {Array} arr
 * @param {*} newValue
 * @returns {Array}
 */
exports.copyAndExtendArray = function (arr, newValue) {
  var newArr = [];
  for (var i = 0; i < arr.length; i++) {
    newArr.push(arr[i]);
  }
  newArr.push(newValue);
  return newArr;
};

/**
 * Used to extend an array and copy it. This is used to propagate paths recursively.
 *
 * @param {Array} arr
 * @returns {Array}
 */
exports.copyArray = function (arr) {
  var newArr = [];
  for (var i = 0; i < arr.length; i++) {
    newArr.push(arr[i]);
  }
  return newArr;
};

/**
 * Retrieve the absolute left value of a DOM element
 * @param {Element} elem        A dom element, for example a div
 * @return {number} left        The absolute left position of this element
 *                              in the browser page.
 */
exports.getAbsoluteLeft = function (elem) {
  return elem.getBoundingClientRect().left;
};

exports.getAbsoluteRight = function (elem) {
  return elem.getBoundingClientRect().right;
};

/**
 * Retrieve the absolute top value of a DOM element
 * @param {Element} elem        A dom element, for example a div
 * @return {number} top        The absolute top position of this element
 *                              in the browser page.
 */
exports.getAbsoluteTop = function (elem) {
  return elem.getBoundingClientRect().top;
};

/**
 * add a className to the given elements style
 * @param {Element} elem
 * @param {string} classNames
 */
exports.addClassName = function (elem, classNames) {
  var classes = elem.className.split(' ');
  var newClasses = classNames.split(' ');
  classes = classes.concat(newClasses.filter(function (className) {
    return classes.indexOf(className) < 0;
  }));
  elem.className = classes.join(' ');
};

/**
 * add a className to the given elements style
 * @param {Element} elem
 * @param {string} classNames
 */
exports.removeClassName = function (elem, classNames) {
  var classes = elem.className.split(' ');
  var oldClasses = classNames.split(' ');
  classes = classes.filter(function (className) {
    return oldClasses.indexOf(className) < 0;
  });
  elem.className = classes.join(' ');
};

/**
 * For each method for both arrays and objects.
 * In case of an array, the built-in Array.forEach() is applied. (**No, it's not!**)
 * In case of an Object, the method loops over all properties of the object.
 * @param {Object | Array} object   An Object or Array
 * @param {function} callback       Callback method, called for each item in
 *                                  the object or array with three parameters:
 *                                  callback(value, index, object)
 */
exports.forEach = function (object, callback) {
  var i, len;
  if (Array.isArray(object)) {
    // array
    for (i = 0, len = object.length; i < len; i++) {
      callback(object[i], i, object);
    }
  } else {
    // object
    for (i in object) {
      if (object.hasOwnProperty(i)) {
        callback(object[i], i, object);
      }
    }
  }
};

/**
 * Convert an object into an array: all objects properties are put into the
 * array. The resulting array is unordered.
 * @param {Object} object
 * @returns {Array} array
 */
exports.toArray = function (object) {
  var array = [];

  for (var prop in object) {
    if (object.hasOwnProperty(prop)) array.push(object[prop]);
  }

  return array;
};

/**
 * Update a property in an object
 * @param {Object} object
 * @param {string} key
 * @param {*} value
 * @return {Boolean} changed
 */
exports.updateProperty = function (object, key, value) {
  if (object[key] !== value) {
    object[key] = value;
    return true;
  } else {
    return false;
  }
};

/**
 * Throttle the given function to be only executed once per animation frame
 * @param {function} fn
 * @returns {function} Returns the throttled function
 */
exports.throttle = function (fn) {
  var scheduled = false;

  return function throttled() {
    if (!scheduled) {
      scheduled = true;
      requestAnimationFrame(function () {
        scheduled = false;
        fn();
      });
    }
  };
};

/**
 * Add and event listener. Works for all browsers
 * @param {Element}     element    An html element
 * @param {string}      action     The action, for example "click",
 *                                 without the prefix "on"
 * @param {function}    listener   The callback function to be executed
 * @param {boolean}     [useCapture]
 */
exports.addEventListener = function (element, action, listener, useCapture) {
  if (element.addEventListener) {
    if (useCapture === undefined) useCapture = false;

    if (action === 'mousewheel' && navigator.userAgent.indexOf('Firefox') >= 0) {
      action = 'DOMMouseScroll'; // For Firefox
    }

    element.addEventListener(action, listener, useCapture);
  } else {
    element.attachEvent('on' + action, listener); // IE browsers
  }
};

/**
 * Remove an event listener from an element
 * @param {Element}     element         An html dom element
 * @param {string}      action          The name of the event, for example "mousedown"
 * @param {function}    listener        The listener function
 * @param {boolean}     [useCapture]
 */
exports.removeEventListener = function (element, action, listener, useCapture) {
  if (element.removeEventListener) {
    // non-IE browsers
    if (useCapture === undefined) useCapture = false;

    if (action === 'mousewheel' && navigator.userAgent.indexOf('Firefox') >= 0) {
      action = 'DOMMouseScroll'; // For Firefox
    }

    element.removeEventListener(action, listener, useCapture);
  } else {
    // IE browsers
    element.detachEvent('on' + action, listener);
  }
};

/**
 * Cancels the event if it is cancelable, without stopping further propagation of the event.
 * @param {Event} event
 */
exports.preventDefault = function (event) {
  if (!event) event = window.event;

  if (event.preventDefault) {
    event.preventDefault(); // non-IE browsers
  } else {
    event.returnValue = false; // IE browsers
  }
};

/**
 * Get HTML element which is the target of the event
 * @param {Event} event
 * @return {Element} target element
 */
exports.getTarget = function (event) {
  // code from http://www.quirksmode.org/js/events_properties.html
  if (!event) {
    event = window.event;
  }

  var target;

  if (event.target) {
    target = event.target;
  } else if (event.srcElement) {
    target = event.srcElement;
  }

  if (target.nodeType != undefined && target.nodeType == 3) {
    // defeat Safari bug
    target = target.parentNode;
  }

  return target;
};

/**
 * Check if given element contains given parent somewhere in the DOM tree
 * @param {Element} element
 * @param {Element} parent
 * @returns {boolean}
 */
exports.hasParent = function (element, parent) {
  var e = element;

  while (e) {
    if (e === parent) {
      return true;
    }
    e = e.parentNode;
  }

  return false;
};

exports.option = {};

/**
 * Convert a value into a boolean
 * @param {Boolean | function | undefined} value
 * @param {boolean} [defaultValue]
 * @returns {Boolean} bool
 */
exports.option.asBoolean = function (value, defaultValue) {
  if (typeof value == 'function') {
    value = value();
  }

  if (value != null) {
    return value != false;
  }

  return defaultValue || null;
};

/**
 * Convert a value into a number
 * @param {Boolean | function | undefined} value
 * @param {number} [defaultValue]
 * @returns {number} number
 */
exports.option.asNumber = function (value, defaultValue) {
  if (typeof value == 'function') {
    value = value();
  }

  if (value != null) {
    return Number(value) || defaultValue || null;
  }

  return defaultValue || null;
};

/**
 * Convert a value into a string
 * @param {string | function | undefined} value
 * @param {string} [defaultValue]
 * @returns {String} str
 */
exports.option.asString = function (value, defaultValue) {
  if (typeof value == 'function') {
    value = value();
  }

  if (value != null) {
    return String(value);
  }

  return defaultValue || null;
};

/**
 * Convert a size or location into a string with pixels or a percentage
 * @param {string | number | function | undefined} value
 * @param {string} [defaultValue]
 * @returns {String} size
 */
exports.option.asSize = function (value, defaultValue) {
  if (typeof value == 'function') {
    value = value();
  }

  if (exports.isString(value)) {
    return value;
  } else if (exports.isNumber(value)) {
    return value + 'px';
  } else {
    return defaultValue || null;
  }
};

/**
 * Convert a value into a DOM element
 * @param {HTMLElement | function | undefined} value
 * @param {HTMLElement} [defaultValue]
 * @returns {HTMLElement | null} dom
 */
exports.option.asElement = function (value, defaultValue) {
  if (typeof value == 'function') {
    value = value();
  }

  return value || defaultValue || null;
};

/**
 * http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb
 *
 * @param {string} hex
 * @returns {{r: *, g: *, b: *}} | 255 range
 */
exports.hexToRGB = function (hex) {
  // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
  var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
  hex = hex.replace(shorthandRegex, function (m, r, g, b) {
    return r + r + g + g + b + b;
  });
  var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  return result ? {
    r: parseInt(result[1], 16),
    g: parseInt(result[2], 16),
    b: parseInt(result[3], 16)
  } : null;
};

/**
 * This function takes color in hex format or rgb() or rgba() format and overrides the opacity. Returns rgba() string.
 * @param {string} color
 * @param {number} opacity
 * @returns {String}
 */
exports.overrideOpacity = function (color, opacity) {
  var rgb;
  if (color.indexOf('rgba') != -1) {
    return color;
  } else if (color.indexOf('rgb') != -1) {
    rgb = color.substr(color.indexOf('(') + 1).replace(')', '').split(',');
    return 'rgba(' + rgb[0] + ',' + rgb[1] + ',' + rgb[2] + ',' + opacity + ')';
  } else {
    rgb = exports.hexToRGB(color);
    if (rgb == null) {
      return color;
    } else {
      return 'rgba(' + rgb.r + ',' + rgb.g + ',' + rgb.b + ',' + opacity + ')';
    }
  }
};

/**
 *
 * @param {number} red     0 -- 255
 * @param {number} green   0 -- 255
 * @param {number} blue    0 -- 255
 * @returns {String}
 * @constructor
 */
exports.RGBToHex = function (red, green, blue) {
  return '#' + ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16).slice(1);
};

/**
 * Parse a color property into an object with border, background, and
 * highlight colors
 * @param {Object | String} color
 * @return {Object} colorObject
 */
exports.parseColor = function (color) {
  var c;
  if (exports.isString(color) === true) {
    if (exports.isValidRGB(color) === true) {
      var rgb = color.substr(4).substr(0, color.length - 5).split(',').map(function (value) {
        return parseInt(value);
      });
      color = exports.RGBToHex(rgb[0], rgb[1], rgb[2]);
    }
    if (exports.isValidHex(color) === true) {
      var hsv = exports.hexToHSV(color);
      var lighterColorHSV = {
        h: hsv.h,
        s: hsv.s * 0.8,
        v: Math.min(1, hsv.v * 1.02)
      };
      var darkerColorHSV = {
        h: hsv.h,
        s: Math.min(1, hsv.s * 1.25),
        v: hsv.v * 0.8
      };
      var darkerColorHex = exports.HSVToHex(darkerColorHSV.h, darkerColorHSV.s, darkerColorHSV.v);
      var lighterColorHex = exports.HSVToHex(lighterColorHSV.h, lighterColorHSV.s, lighterColorHSV.v);
      c = {
        background: color,
        border: darkerColorHex,
        highlight: {
          background: lighterColorHex,
          border: darkerColorHex
        },
        hover: {
          background: lighterColorHex,
          border: darkerColorHex
        }
      };
    } else {
      c = {
        background: color,
        border: color,
        highlight: {
          background: color,
          border: color
        },
        hover: {
          background: color,
          border: color
        }
      };
    }
  } else {
    c = {};
    c.background = color.background || undefined;
    c.border = color.border || undefined;

    if (exports.isString(color.highlight)) {
      c.highlight = {
        border: color.highlight,
        background: color.highlight
      };
    } else {
      c.highlight = {};
      c.highlight.background = color.highlight && color.highlight.background || undefined;
      c.highlight.border = color.highlight && color.highlight.border || undefined;
    }

    if (exports.isString(color.hover)) {
      c.hover = {
        border: color.hover,
        background: color.hover
      };
    } else {
      c.hover = {};
      c.hover.background = color.hover && color.hover.background || undefined;
      c.hover.border = color.hover && color.hover.border || undefined;
    }
  }

  return c;
};

/**
 * http://www.javascripter.net/faq/rgb2hsv.htm
 *
 * @param {number} red
 * @param {number} green
 * @param {number} blue
 * @returns {{h: number, s: number, v: number}}
 * @constructor
 */
exports.RGBToHSV = function (red, green, blue) {
  red = red / 255;
  green = green / 255;
  blue = blue / 255;
  var minRGB = Math.min(red, Math.min(green, blue));
  var maxRGB = Math.max(red, Math.max(green, blue));

  // Black-gray-white
  if (minRGB == maxRGB) {
    return { h: 0, s: 0, v: minRGB };
  }

  // Colors other than black-gray-white:
  var d = red == minRGB ? green - blue : blue == minRGB ? red - green : blue - red;
  var h = red == minRGB ? 3 : blue == minRGB ? 1 : 5;
  var hue = 60 * (h - d / (maxRGB - minRGB)) / 360;
  var saturation = (maxRGB - minRGB) / maxRGB;
  var value = maxRGB;
  return { h: hue, s: saturation, v: value };
};

var cssUtil = {
  // split a string with css styles into an object with key/values
  split: function split(cssText) {
    var styles = {};

    cssText.split(';').forEach(function (style) {
      if (style.trim() != '') {
        var parts = style.split(':');
        var key = parts[0].trim();
        var value = parts[1].trim();
        styles[key] = value;
      }
    });

    return styles;
  },

  // build a css text string from an object with key/values
  join: function join(styles) {
    return (0, _keys2['default'])(styles).map(function (key) {
      return key + ': ' + styles[key];
    }).join('; ');
  }

  /**
   * Append a string with css styles to an element
   * @param {Element} element
   * @param {string} cssText
   */
};exports.addCssText = function (element, cssText) {
  var currentStyles = cssUtil.split(element.style.cssText);
  var newStyles = cssUtil.split(cssText);
  var styles = exports.extend(currentStyles, newStyles);

  element.style.cssText = cssUtil.join(styles);
};

/**
 * Remove a string with css styles from an element
 * @param {Element} element
 * @param {string} cssText
 */
exports.removeCssText = function (element, cssText) {
  var styles = cssUtil.split(element.style.cssText);
  var removeStyles = cssUtil.split(cssText);

  for (var key in removeStyles) {
    if (removeStyles.hasOwnProperty(key)) {
      delete styles[key];
    }
  }

  element.style.cssText = cssUtil.join(styles);
};

/**
 * https://gist.github.com/mjijackson/5311256
 * @param {number} h
 * @param {number} s
 * @param {number} v
 * @returns {{r: number, g: number, b: number}}
 * @constructor
 */
exports.HSVToRGB = function (h, s, v) {
  var r, g, b;

  var i = Math.floor(h * 6);
  var f = h * 6 - i;
  var p = v * (1 - s);
  var q = v * (1 - f * s);
  var t = v * (1 - (1 - f) * s);

  switch (i % 6) {
    case 0:
      ;r = v, g = t, b = p;
      break;
    case 1:
      ;r = q, g = v, b = p;
      break;
    case 2:
      ;r = p, g = v, b = t;
      break;
    case 3:
      ;r = p, g = q, b = v;
      break;
    case 4:
      ;r = t, g = p, b = v;
      break;
    case 5:
      ;r = v, g = p, b = q;
      break;
  }

  return {
    r: Math.floor(r * 255),
    g: Math.floor(g * 255),
    b: Math.floor(b * 255)
  };
};

exports.HSVToHex = function (h, s, v) {
  var rgb = exports.HSVToRGB(h, s, v);
  return exports.RGBToHex(rgb.r, rgb.g, rgb.b);
};

exports.hexToHSV = function (hex) {
  var rgb = exports.hexToRGB(hex);
  return exports.RGBToHSV(rgb.r, rgb.g, rgb.b);
};

exports.isValidHex = function (hex) {
  var isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
  return isOk;
};

exports.isValidRGB = function (rgb) {
  rgb = rgb.replace(' ', '');
  var isOk = /rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/i.test(rgb);
  return isOk;
};
exports.isValidRGBA = function (rgba) {
  rgba = rgba.replace(' ', '');
  var isOk = /rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),(.{1,3})\)/i.test(rgba);
  return isOk;
};

/**
 * This recursively redirects the prototype of JSON objects to the referenceObject
 * This is used for default options.
 *
 * @param {Array.<string>} fields
 * @param {Object} referenceObject
 * @returns {*}
 */
exports.selectiveBridgeObject = function (fields, referenceObject) {
  if (referenceObject !== null && (typeof referenceObject === 'undefined' ? 'undefined' : (0, _typeof3['default'])(referenceObject)) === 'object') {
    // !!! typeof null === 'object'
    var objectTo = (0, _create2['default'])(referenceObject);
    for (var i = 0; i < fields.length; i++) {
      if (referenceObject.hasOwnProperty(fields[i])) {
        if ((0, _typeof3['default'])(referenceObject[fields[i]]) == 'object') {
          objectTo[fields[i]] = exports.bridgeObject(referenceObject[fields[i]]);
        }
      }
    }
    return objectTo;
  } else {
    return null;
  }
};

/**
 * This recursively redirects the prototype of JSON objects to the referenceObject
 * This is used for default options.
 *
 * @param {Object} referenceObject
 * @returns {*}
 */
exports.bridgeObject = function (referenceObject) {
  if (referenceObject !== null && (typeof referenceObject === 'undefined' ? 'undefined' : (0, _typeof3['default'])(referenceObject)) === 'object') {
    // !!! typeof null === 'object'
    var objectTo = (0, _create2['default'])(referenceObject);
    if (referenceObject instanceof Element) {
      // Avoid bridging DOM objects
      objectTo = referenceObject;
    } else {
      objectTo = (0, _create2['default'])(referenceObject);
      for (var i in referenceObject) {
        if (referenceObject.hasOwnProperty(i)) {
          if ((0, _typeof3['default'])(referenceObject[i]) == 'object') {
            objectTo[i] = exports.bridgeObject(referenceObject[i]);
          }
        }
      }
    }
    return objectTo;
  } else {
    return null;
  }
};

/**
 * This method provides a stable sort implementation, very fast for presorted data
 *
 * @param {Array} a the array
 * @param {function} compare an order comparator
 * @returns {Array}
 */
exports.insertSort = function (a, compare) {
  for (var i = 0; i < a.length; i++) {
    var k = a[i];
    for (var j = i; j > 0 && compare(k, a[j - 1]) < 0; j--) {
      a[j] = a[j - 1];
    }
    a[j] = k;
  }
  return a;
};

/**
 * This is used to set the options of subobjects in the options object.
 *
 * A requirement of these subobjects is that they have an 'enabled' element
 * which is optional for the user but mandatory for the program.
 *
 * The added value here of the merge is that option 'enabled' is set as required.
 *
 *
 * @param {object} mergeTarget   | either this.options or the options used for the groups.
 * @param {object} options       | options
 * @param {string} option        | option key in the options argument
 * @param {object} globalOptions | global options, passed in to determine value of option 'enabled'
 */
exports.mergeOptions = function (mergeTarget, options, option) {
  var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  // Local helpers
  var isPresent = function isPresent(obj) {
    return obj !== null && obj !== undefined;
  };

  var isObject = function isObject(obj) {
    return obj !== null && (typeof obj === 'undefined' ? 'undefined' : (0, _typeof3['default'])(obj)) === 'object';
  };

  // https://stackoverflow.com/a/34491287/1223531
  var isEmpty = function isEmpty(obj) {
    for (var x in obj) {
      if (obj.hasOwnProperty(x)) return false;
    }
    return true;
  };

  // Guards
  if (!isObject(mergeTarget)) {
    throw new Error('Parameter mergeTarget must be an object');
  }

  if (!isObject(options)) {
    throw new Error('Parameter options must be an object');
  }

  if (!isPresent(option)) {
    throw new Error('Parameter option must have a value');
  }

  if (!isObject(globalOptions)) {
    throw new Error('Parameter globalOptions must be an object');
  }

  //
  // Actual merge routine, separated from main logic
  // Only a single level of options is merged. Deeper levels are ref'd. This may actually be an issue.
  //
  var doMerge = function doMerge(target, options, option) {
    if (!isObject(target[option])) {
      target[option] = {};
    }

    var src = options[option];
    var dst = target[option];
    for (var prop in src) {
      if (src.hasOwnProperty(prop)) {
        dst[prop] = src[prop];
      }
    }
  };

  // Local initialization
  var srcOption = options[option];
  var globalPassed = isObject(globalOptions) && !isEmpty(globalOptions);
  var globalOption = globalPassed ? globalOptions[option] : undefined;
  var globalEnabled = globalOption ? globalOption.enabled : undefined;

  /////////////////////////////////////////
  // Main routine
  /////////////////////////////////////////
  if (srcOption === undefined) {
    return; // Nothing to do
  }

  if (typeof srcOption === 'boolean') {
    if (!isObject(mergeTarget[option])) {
      mergeTarget[option] = {};
    }

    mergeTarget[option].enabled = srcOption;
    return;
  }

  if (srcOption === null && !isObject(mergeTarget[option])) {
    // If possible, explicit copy from globals
    if (isPresent(globalOption)) {
      mergeTarget[option] = (0, _create2['default'])(globalOption);
    } else {
      return; // Nothing to do
    }
  }

  if (!isObject(srcOption)) {
    return;
  }

  //
  // Ensure that 'enabled' is properly set. It is required internally
  // Note that the value from options will always overwrite the existing value
  //
  var enabled = true; // default value

  if (srcOption.enabled !== undefined) {
    enabled = srcOption.enabled;
  } else {
    // Take from globals, if present
    if (globalEnabled !== undefined) {
      enabled = globalOption.enabled;
    }
  }

  doMerge(mergeTarget, options, option);
  mergeTarget[option].enabled = enabled;
};

/**
 * This function does a binary search for a visible item in a sorted list. If we find a visible item, the code that uses
 * this function will then iterate in both directions over this sorted list to find all visible items.
 *
 * @param {Item[]} orderedItems       | Items ordered by start
 * @param {function} comparator       | -1 is lower, 0 is equal, 1 is higher
 * @param {string} field
 * @param {string} field2
 * @returns {number}
 * @private
 */
exports.binarySearchCustom = function (orderedItems, comparator, field, field2) {
  var maxIterations = 10000;
  var iteration = 0;
  var low = 0;
  var high = orderedItems.length - 1;

  while (low <= high && iteration < maxIterations) {
    var middle = Math.floor((low + high) / 2);

    var item = orderedItems[middle];
    var value = field2 === undefined ? item[field] : item[field][field2];

    var searchResult = comparator(value);
    if (searchResult == 0) {
      // jihaa, found a visible item!
      return middle;
    } else if (searchResult == -1) {
      // it is too small --> increase low
      low = middle + 1;
    } else {
      // it is too big --> decrease high
      high = middle - 1;
    }

    iteration++;
  }

  return -1;
};

/**
 * This function does a binary search for a specific value in a sorted array. If it does not exist but is in between of
 * two values, we return either the one before or the one after, depending on user input
 * If it is found, we return the index, else -1.
 *
 * @param {Array} orderedItems
 * @param {{start: number, end: number}} target
 * @param {string} field
 * @param {string} sidePreference   'before' or 'after'
 * @param {function} comparator an optional comparator, returning -1,0,1 for <,==,>.
 * @returns {number}
 * @private
 */
exports.binarySearchValue = function (orderedItems, target, field, sidePreference, comparator) {
  var maxIterations = 10000;
  var iteration = 0;
  var low = 0;
  var high = orderedItems.length - 1;
  var prevValue, value, nextValue, middle;

  comparator = comparator != undefined ? comparator : function (a, b) {
    return a == b ? 0 : a < b ? -1 : 1;
  };

  while (low <= high && iteration < maxIterations) {
    // get a new guess
    middle = Math.floor(0.5 * (high + low));
    prevValue = orderedItems[Math.max(0, middle - 1)][field];
    value = orderedItems[middle][field];
    nextValue = orderedItems[Math.min(orderedItems.length - 1, middle + 1)][field];

    if (comparator(value, target) == 0) {
      // we found the target
      return middle;
    } else if (comparator(prevValue, target) < 0 && comparator(value, target) > 0) {
      // target is in between of the previous and the current
      return sidePreference == 'before' ? Math.max(0, middle - 1) : middle;
    } else if (comparator(value, target) < 0 && comparator(nextValue, target) > 0) {
      // target is in between of the current and the next
      return sidePreference == 'before' ? middle : Math.min(orderedItems.length - 1, middle + 1);
    } else {
      // didnt find the target, we need to change our boundaries.
      if (comparator(value, target) < 0) {
        // it is too small --> increase low
        low = middle + 1;
      } else {
        // it is too big --> decrease high
        high = middle - 1;
      }
    }
    iteration++;
  }

  // didnt find anything. Return -1.
  return -1;
};

/*
 * Easing Functions - inspired from http://gizma.com/easing/
 * only considering the t value for the range [0, 1] => [0, 1]
 * https://gist.github.com/gre/1650294
 */
exports.easingFunctions = {
  // no easing, no acceleration
  linear: function linear(t) {
    return t;
  },
  // accelerating from zero velocity
  easeInQuad: function easeInQuad(t) {
    return t * t;
  },
  // decelerating to zero velocity
  easeOutQuad: function easeOutQuad(t) {
    return t * (2 - t);
  },
  // acceleration until halfway, then deceleration
  easeInOutQuad: function easeInOutQuad(t) {
    return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
  },
  // accelerating from zero velocity
  easeInCubic: function easeInCubic(t) {
    return t * t * t;
  },
  // decelerating to zero velocity
  easeOutCubic: function easeOutCubic(t) {
    return --t * t * t + 1;
  },
  // acceleration until halfway, then deceleration
  easeInOutCubic: function easeInOutCubic(t) {
    return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
  },
  // accelerating from zero velocity
  easeInQuart: function easeInQuart(t) {
    return t * t * t * t;
  },
  // decelerating to zero velocity
  easeOutQuart: function easeOutQuart(t) {
    return 1 - --t * t * t * t;
  },
  // acceleration until halfway, then deceleration
  easeInOutQuart: function easeInOutQuart(t) {
    return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
  },
  // accelerating from zero velocity
  easeInQuint: function easeInQuint(t) {
    return t * t * t * t * t;
  },
  // decelerating to zero velocity
  easeOutQuint: function easeOutQuint(t) {
    return 1 + --t * t * t * t * t;
  },
  // acceleration until halfway, then deceleration
  easeInOutQuint: function easeInOutQuint(t) {
    return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
  }
};

exports.getScrollBarWidth = function () {
  var inner = document.createElement('p');
  inner.style.width = '100%';
  inner.style.height = '200px';

  var outer = document.createElement('div');
  outer.style.position = 'absolute';
  outer.style.top = '0px';
  outer.style.left = '0px';
  outer.style.visibility = 'hidden';
  outer.style.width = '200px';
  outer.style.height = '150px';
  outer.style.overflow = 'hidden';
  outer.appendChild(inner);

  document.body.appendChild(outer);
  var w1 = inner.offsetWidth;
  outer.style.overflow = 'scroll';
  var w2 = inner.offsetWidth;
  if (w1 == w2) w2 = outer.clientWidth;

  document.body.removeChild(outer);

  return w1 - w2;
};

exports.topMost = function (pile, accessors) {
  var candidate = void 0;
  if (!Array.isArray(accessors)) {
    accessors = [accessors];
  }
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = (0, _getIterator3['default'])(pile), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var member = _step.value;

      if (member) {
        candidate = member[accessors[0]];
        for (var i = 1; i < accessors.length; i++) {
          if (candidate) {
            candidate = candidate[accessors[i]];
          }
        }
        if (typeof candidate != 'undefined') {
          break;
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator['return']) {
        _iterator['return']();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return candidate;
};

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(145), __esModule: true };

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && ((typeof call === "undefined" ? "undefined" : (0, _typeof3.default)(call)) === "object" || typeof call === "function") ? call : self;
};

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _setPrototypeOf = __webpack_require__(147);

var _setPrototypeOf2 = _interopRequireDefault(_setPrototypeOf);

var _create = __webpack_require__(31);

var _create2 = _interopRequireDefault(_create);

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === "undefined" ? "undefined" : (0, _typeof3.default)(superClass)));
  }

  subClass.prototype = (0, _create2.default)(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf2.default ? (0, _setPrototypeOf2.default)(subClass, superClass) : subClass.__proto__ = superClass;
};

/***/ }),
/* 6 */
/***/ (function(module, exports) {

var core = module.exports = { version: '2.5.7' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _iterator = __webpack_require__(104);

var _iterator2 = _interopRequireDefault(_iterator);

var _symbol = __webpack_require__(106);

var _symbol2 = _interopRequireDefault(_symbol);

var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof(obj);
} : function (obj) {
  return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
};

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(44)('wks');
var uid = __webpack_require__(29);
var Symbol = __webpack_require__(10).Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(102), __esModule: true };

/***/ }),
/* 10 */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(10);
var core = __webpack_require__(6);
var ctx = __webpack_require__(61);
var hide = __webpack_require__(19);
var has = __webpack_require__(14);
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && has(exports, key)) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(20);
var IE8_DOM_DEFINE = __webpack_require__(62);
var toPrimitive = __webpack_require__(40);
var dP = Object.defineProperty;

exports.f = __webpack_require__(13) ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(22)(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 14 */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _isIterable2 = __webpack_require__(136);

var _isIterable3 = _interopRequireDefault(_isIterable2);

var _getIterator2 = __webpack_require__(58);

var _getIterator3 = _interopRequireDefault(_getIterator2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function () {
  function sliceIterator(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = (0, _getIterator3.default)(arr), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  return function (arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if ((0, _isIterable3.default)(Object(arr))) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }
  };
}();

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * The Base class for all Nodes.
 */
var NodeBase = function () {
  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function NodeBase(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, NodeBase);

    this.body = body;
    this.labelModule = labelModule;
    this.setOptions(options);
    this.top = undefined;
    this.left = undefined;
    this.height = undefined;
    this.width = undefined;
    this.radius = undefined;
    this.margin = undefined;
    this.refreshNeeded = true;
    this.boundingBox = { top: 0, left: 0, right: 0, bottom: 0 };
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3['default'])(NodeBase, [{
    key: 'setOptions',
    value: function setOptions(options) {
      this.options = options;
    }

    /**
     *
     * @param {Label} labelModule
     * @private
     */

  }, {
    key: '_setMargins',
    value: function _setMargins(labelModule) {
      this.margin = {};
      if (this.options.margin) {
        if ((0, _typeof3['default'])(this.options.margin) == 'object') {
          this.margin.top = this.options.margin.top;
          this.margin.right = this.options.margin.right;
          this.margin.bottom = this.options.margin.bottom;
          this.margin.left = this.options.margin.left;
        } else {
          this.margin.top = this.options.margin;
          this.margin.right = this.options.margin;
          this.margin.bottom = this.options.margin;
          this.margin.left = this.options.margin;
        }
      }
      labelModule.adjustSizes(this.margin);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     * @private
     */

  }, {
    key: '_distanceToBorder',
    value: function _distanceToBorder(ctx, angle) {
      var borderWidth = this.options.borderWidth;
      this.resize(ctx);
      return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'enableShadow',
    value: function enableShadow(ctx, values) {
      if (values.shadow) {
        ctx.shadowColor = values.shadowColor;
        ctx.shadowBlur = values.shadowSize;
        ctx.shadowOffsetX = values.shadowX;
        ctx.shadowOffsetY = values.shadowY;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'disableShadow',
    value: function disableShadow(ctx, values) {
      if (values.shadow) {
        ctx.shadowColor = 'rgba(0,0,0,0)';
        ctx.shadowBlur = 0;
        ctx.shadowOffsetX = 0;
        ctx.shadowOffsetY = 0;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'enableBorderDashes',
    value: function enableBorderDashes(ctx, values) {
      if (values.borderDashes !== false) {
        if (ctx.setLineDash !== undefined) {
          var dashes = values.borderDashes;
          if (dashes === true) {
            dashes = [5, 15];
          }
          ctx.setLineDash(dashes);
        } else {
          console.warn('setLineDash is not supported in this browser. The dashed borders cannot be used.');
          this.options.shapeProperties.borderDashes = false;
          values.borderDashes = false;
        }
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'disableBorderDashes',
    value: function disableBorderDashes(ctx, values) {
      if (values.borderDashes !== false) {
        if (ctx.setLineDash !== undefined) {
          ctx.setLineDash([0]);
        } else {
          console.warn('setLineDash is not supported in this browser. The dashed borders cannot be used.');
          this.options.shapeProperties.borderDashes = false;
          values.borderDashes = false;
        }
      }
    }

    /**
     * Determine if the shape of a node needs to be recalculated.
     *
     * @param {boolean} selected
     * @param {boolean} hover
     * @returns {boolean}
     * @protected
     */

  }, {
    key: 'needsRefresh',
    value: function needsRefresh(selected, hover) {
      if (this.refreshNeeded === true) {
        // This is probably not the best location to reset this member.
        // However, in the current logic, it is the most convenient one.
        this.refreshNeeded = false;
        return true;
      }

      return this.width === undefined || this.labelModule.differentState(selected, hover);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'initContextForDraw',
    value: function initContextForDraw(ctx, values) {
      var borderWidth = values.borderWidth / this.body.view.scale;

      ctx.lineWidth = Math.min(this.width, borderWidth);
      ctx.strokeStyle = values.borderColor;
      ctx.fillStyle = values.color;
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'performStroke',
    value: function performStroke(ctx, values) {
      var borderWidth = values.borderWidth / this.body.view.scale;

      //draw dashed border if enabled, save and restore is required for firefox not to crash on unix.
      ctx.save();
      // if borders are zero width, they will be drawn with width 1 by default. This prevents that
      if (borderWidth > 0) {
        this.enableBorderDashes(ctx, values);
        //draw the border
        ctx.stroke();
        //disable dashed border for other elements
        this.disableBorderDashes(ctx, values);
      }
      ctx.restore();
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'performFill',
    value: function performFill(ctx, values) {
      // draw shadow if enabled
      this.enableShadow(ctx, values);
      // draw the background
      ctx.fill();
      // disable shadows for other elements.
      this.disableShadow(ctx, values);

      this.performStroke(ctx, values);
    }

    /**
     *
     * @param {number} margin
     * @private
     */

  }, {
    key: '_addBoundingBoxMargin',
    value: function _addBoundingBoxMargin(margin) {
      this.boundingBox.left -= margin;
      this.boundingBox.top -= margin;
      this.boundingBox.bottom += margin;
      this.boundingBox.right += margin;
    }

    /**
     * Actual implementation of this method call.
     *
     * Doing it like this makes it easier to override
     * in the child classes.
     *
     * @param {number} x width
     * @param {number} y height
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @private
     */

  }, {
    key: '_updateBoundingBox',
    value: function _updateBoundingBox(x, y, ctx, selected, hover) {
      if (ctx !== undefined) {
        this.resize(ctx, selected, hover);
      }

      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      this.boundingBox.left = this.left;
      this.boundingBox.top = this.top;
      this.boundingBox.bottom = this.top + this.height;
      this.boundingBox.right = this.left + this.width;
    }

    /**
     * Default implementation of this method call.
     * This acts as a stub which can be overridden.
     *
     * @param {number} x width
     * @param {number} y height
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     */

  }, {
    key: 'updateBoundingBox',
    value: function updateBoundingBox(x, y, ctx, selected, hover) {
      this._updateBoundingBox(x, y, ctx, selected, hover);
    }

    /**
     * Determine the dimensions to use for nodes with an internal label
     *
     * Currently, these are: Circle, Ellipse, Database, Box
     * The other nodes have external labels, and will not call this method
     *
     * If there is no label, decent default values are supplied.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} [selected]
     * @param {boolean} [hover]
     * @returns {{width:number, height:number}}
     */

  }, {
    key: 'getDimensionsFromLabel',
    value: function getDimensionsFromLabel(ctx, selected, hover) {
      // NOTE: previously 'textSize' was not put in 'this' for Ellipse
      // TODO: examine the consequences.
      this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
      var width = this.textSize.width;
      var height = this.textSize.height;

      var DEFAULT_SIZE = 14;
      if (width === 0) {
        // This happens when there is no label text set
        width = DEFAULT_SIZE; // use a decent default
        height = DEFAULT_SIZE; // if width zero, then height also always zero
      }

      return { width: width, height: height };
    }
  }]);
  return NodeBase;
}();

exports['default'] = NodeBase;

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _NodeBase2 = __webpack_require__(16);

var _NodeBase3 = _interopRequireDefault(_NodeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Base class for constructing Node/Cluster Shapes.
 *
 * @extends NodeBase
 */
var ShapeBase = function (_NodeBase) {
  (0, _inherits3['default'])(ShapeBase, _NodeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function ShapeBase(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, ShapeBase);
    return (0, _possibleConstructorReturn3['default'])(this, (ShapeBase.__proto__ || (0, _getPrototypeOf2['default'])(ShapeBase)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   * @param {Object} [values={size: this.options.size}]
   */


  (0, _createClass3['default'])(ShapeBase, [{
    key: 'resize',
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
      var values = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : { size: this.options.size };

      if (this.needsRefresh(selected, hover)) {
        this.labelModule.getTextSize(ctx, selected, hover);
        var size = 2 * values.size;
        this.width = size;
        this.height = size;
        this.radius = 0.5 * this.width;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {string} shape
     * @param {number} sizeMultiplier - Unused! TODO: Remove next major release
     * @param {number} x
     * @param {number} y
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     * @private
     */

  }, {
    key: '_drawShape',
    value: function _drawShape(ctx, shape, sizeMultiplier, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover, values);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      this.initContextForDraw(ctx, values);
      ctx[shape](x, y, values.size);
      this.performFill(ctx, values);

      if (this.options.icon !== undefined) {
        if (this.options.icon.code !== undefined) {
          ctx.font = (selected ? 'bold ' : '') + this.height / 2 + 'px ' + (this.options.icon.face || 'FontAwesome');
          ctx.fillStyle = this.options.icon.color || 'black';
          ctx.textAlign = 'center';
          ctx.textBaseline = 'middle';
          ctx.fillText(this.options.icon.code, x, y);
        }
      }

      if (this.options.label !== undefined) {
        // Need to call following here in order to ensure value for `this.labelModule.size.height`
        this.labelModule.calculateLabelSize(ctx, selected, hover, x, y, 'hanging');
        var yLabel = y + 0.5 * this.height + 0.5 * this.labelModule.size.height;
        this.labelModule.draw(ctx, x, yLabel, selected, hover, 'hanging');
      }

      this.updateBoundingBox(x, y);
    }

    /**
     *
     * @param {number} x
     * @param {number} y
     */

  }, {
    key: 'updateBoundingBox',
    value: function updateBoundingBox(x, y) {
      this.boundingBox.top = y - this.options.size;
      this.boundingBox.left = x - this.options.size;
      this.boundingBox.right = x + this.options.size;
      this.boundingBox.bottom = y + this.options.size;

      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height);
      }
    }
  }]);
  return ShapeBase;
}(_NodeBase3['default']);

exports['default'] = ShapeBase;

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(59);
var defined = __webpack_require__(39);
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(12);
var createDesc = __webpack_require__(28);
module.exports = __webpack_require__(13) ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(21);
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),
/* 21 */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),
/* 22 */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(123), __esModule: true };

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Setup a mock hammer.js object, for unit testing.
 *
 * Inspiration: https://github.com/uber/deck.gl/pull/658
 *
 * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
 */
function hammerMock() {
  var noop = function noop() {};

  return {
    on: noop,
    off: noop,
    destroy: noop,
    emit: noop,

    //eslint-disable-next-line no-unused-vars
    get: function get(m) {
      return {
        set: noop
      };
    }
  };
}

if (typeof window !== 'undefined') {
  var propagating = __webpack_require__(127);
  var Hammer = window['Hammer'] || __webpack_require__(128);
  module.exports = propagating(Hammer, {
    preventDefault: 'mouse'
  });
} else {
  module.exports = function () {
    // hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
    return hammerMock();
  };
}

/***/ }),
/* 25 */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(65);
var enumBugKeys = __webpack_require__(45);

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),
/* 27 */
/***/ (function(module, exports) {

module.exports = true;


/***/ }),
/* 28 */
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),
/* 29 */
/***/ (function(module, exports) {

var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.13 ToObject(argument)
var defined = __webpack_require__(39);
module.exports = function (it) {
  return Object(defined(it));
};


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(100), __esModule: true };

/***/ }),
/* 32 */
/***/ (function(module, exports) {

exports.f = {}.propertyIsEnumerable;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _stringify = __webpack_require__(23);

var _stringify2 = _interopRequireDefault(_stringify);

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

var _keys = __webpack_require__(9);

var _keys2 = _interopRequireDefault(_keys);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);
var Queue = __webpack_require__(72);

/**
 * DataSet
 * // TODO: add a DataSet constructor DataSet(data, options)
 *
 * Usage:
 *     var dataSet = new DataSet({
 *         fieldId: '_id',
 *         type: {
 *             // ...
 *         }
 *     });
 *
 *     dataSet.add(item);
 *     dataSet.add(data);
 *     dataSet.update(item);
 *     dataSet.update(data);
 *     dataSet.remove(id);
 *     dataSet.remove(ids);
 *     var data = dataSet.get();
 *     var data = dataSet.get(id);
 *     var data = dataSet.get(ids);
 *     var data = dataSet.get(ids, options, data);
 *     dataSet.clear();
 *
 * A data set can:
 * - add/remove/update data
 * - gives triggers upon changes in the data
 * - can  import/export data in various data formats
 *
 * @param {Array} [data]    Optional array with initial data
 * @param {Object} [options]   Available options:
 *                             {string} fieldId Field name of the id in the
 *                                              items, 'id' by default.
 *                             {Object.<string, string} type
 *                                              A map with field names as key,
 *                                              and the field type as value.
 *                             {Object} queue   Queue changes to the DataSet,
 *                                              flush them all at once.
 *                                              Queue options:
 *                                              - {number} delay  Delay in ms, null by default
 *                                              - {number} max    Maximum number of entries in the queue, Infinity by default
 * @constructor DataSet
 */
function DataSet(data, options) {
  // correctly read optional arguments
  if (data && !Array.isArray(data)) {
    options = data;
    data = null;
  }

  this._options = options || {};
  this._data = {}; // map with data indexed by id
  this.length = 0; // number of items in the DataSet
  this._fieldId = this._options.fieldId || 'id'; // name of the field containing id
  this._type = {}; // internal field types (NOTE: this can differ from this._options.type)

  // all variants of a Date are internally stored as Date, so we can convert
  // from everything to everything (also from ISODate to Number for example)
  if (this._options.type) {
    var fields = (0, _keys2['default'])(this._options.type);
    for (var i = 0, len = fields.length; i < len; i++) {
      var field = fields[i];
      var value = this._options.type[field];
      if (value == 'Date' || value == 'ISODate' || value == 'ASPDate') {
        this._type[field] = 'Date';
      } else {
        this._type[field] = value;
      }
    }
  }

  this._subscribers = {}; // event subscribers

  // add initial data when provided
  if (data) {
    this.add(data);
  }

  this.setOptions(options);
}

/**
 * @param {Object} options   Available options:
 *                             {Object} queue   Queue changes to the DataSet,
 *                                              flush them all at once.
 *                                              Queue options:
 *                                              - {number} delay  Delay in ms, null by default
 *                                              - {number} max    Maximum number of entries in the queue, Infinity by default
 */
DataSet.prototype.setOptions = function (options) {
  if (options && options.queue !== undefined) {
    if (options.queue === false) {
      // delete queue if loaded
      if (this._queue) {
        this._queue.destroy();
        delete this._queue;
      }
    } else {
      // create queue and update its options
      if (!this._queue) {
        this._queue = Queue.extend(this, {
          replace: ['add', 'update', 'remove']
        });
      }

      if ((0, _typeof3['default'])(options.queue) === 'object') {
        this._queue.setOptions(options.queue);
      }
    }
  }
};

/**
 * Subscribe to an event, add an event listener
 * @param {string} event        Event name. Available events: 'add', 'update',
 *                              'remove'
 * @param {function} callback   Callback method. Called with three parameters:
 *                                  {string} event
 *                                  {Object | null} params
 *                                  {string | number} senderId
 */
DataSet.prototype.on = function (event, callback) {
  var subscribers = this._subscribers[event];
  if (!subscribers) {
    subscribers = [];
    this._subscribers[event] = subscribers;
  }

  subscribers.push({
    callback: callback
  });
};

/**
 * Unsubscribe from an event, remove an event listener
 * @param {string} event
 * @param {function} callback
 */
DataSet.prototype.off = function (event, callback) {
  var subscribers = this._subscribers[event];
  if (subscribers) {
    this._subscribers[event] = subscribers.filter(function (listener) {
      return listener.callback != callback;
    });
  }
};

/**
 * Trigger an event
 * @param {string} event
 * @param {Object | null} params
 * @param {string} [senderId]       Optional id of the sender.
 * @private
 */
DataSet.prototype._trigger = function (event, params, senderId) {
  if (event == '*') {
    throw new Error('Cannot trigger event *');
  }

  var subscribers = [];
  if (event in this._subscribers) {
    subscribers = subscribers.concat(this._subscribers[event]);
  }
  if ('*' in this._subscribers) {
    subscribers = subscribers.concat(this._subscribers['*']);
  }

  for (var i = 0, len = subscribers.length; i < len; i++) {
    var subscriber = subscribers[i];
    if (subscriber.callback) {
      subscriber.callback(event, params, senderId || null);
    }
  }
};

/**
 * Add data.
 * Adding an item will fail when there already is an item with the same id.
 * @param {Object | Array} data
 * @param {string} [senderId] Optional sender id
 * @return {Array.<string|number>} addedIds      Array with the ids of the added items
 */
DataSet.prototype.add = function (data, senderId) {
  var addedIds = [],
      id,
      me = this;

  if (Array.isArray(data)) {
    // Array
    for (var i = 0, len = data.length; i < len; i++) {
      id = me._addItem(data[i]);
      addedIds.push(id);
    }
  } else if (data && (typeof data === 'undefined' ? 'undefined' : (0, _typeof3['default'])(data)) === 'object') {
    // Single item
    id = me._addItem(data);
    addedIds.push(id);
  } else {
    throw new Error('Unknown dataType');
  }

  if (addedIds.length) {
    this._trigger('add', { items: addedIds }, senderId);
  }

  return addedIds;
};

/**
 * Update existing items. When an item does not exist, it will be created
 * @param {Object | Array} data
 * @param {string} [senderId] Optional sender id
 * @return {Array.<string|number>} updatedIds     The ids of the added or updated items
 * @throws {Error} Unknown Datatype
 */
DataSet.prototype.update = function (data, senderId) {
  var addedIds = [];
  var updatedIds = [];
  var oldData = [];
  var updatedData = [];
  var me = this;
  var fieldId = me._fieldId;

  var addOrUpdate = function addOrUpdate(item) {
    var id = item[fieldId];
    if (me._data[id]) {
      var oldItem = util.extend({}, me._data[id]);
      // update item
      id = me._updateItem(item);
      updatedIds.push(id);
      updatedData.push(item);
      oldData.push(oldItem);
    } else {
      // add new item
      id = me._addItem(item);
      addedIds.push(id);
    }
  };

  if (Array.isArray(data)) {
    // Array
    for (var i = 0, len = data.length; i < len; i++) {
      if (data[i] && (0, _typeof3['default'])(data[i]) === 'object') {
        addOrUpdate(data[i]);
      } else {
        console.warn('Ignoring input item, which is not an object at index ' + i);
      }
    }
  } else if (data && (typeof data === 'undefined' ? 'undefined' : (0, _typeof3['default'])(data)) === 'object') {
    // Single item
    addOrUpdate(data);
  } else {
    throw new Error('Unknown dataType');
  }

  if (addedIds.length) {
    this._trigger('add', { items: addedIds }, senderId);
  }
  if (updatedIds.length) {
    var props = { items: updatedIds, oldData: oldData, data: updatedData
      // TODO: remove deprecated property 'data' some day
      //Object.defineProperty(props, 'data', {
      //  'get': (function() {
      //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
      //    return updatedData;
      //  }).bind(this)
      //});
    };this._trigger('update', props, senderId);
  }

  return addedIds.concat(updatedIds);
};

// prettier-ignore
/**
 * Get a data item or multiple items.
 *
 * Usage:
 *
 *     get()
 *     get(options: Object)
 *
 *     get(id: number | string)
 *     get(id: number | string, options: Object)
 *
 *     get(ids: number[] | string[])
 *     get(ids: number[] | string[], options: Object)
 *
 * Where:
 *
 * {number | string} id         The id of an item
 * {number[] | string{}} ids    An array with ids of items
 * {Object} options             An Object with options. Available options:
 * {string} [returnType]        Type of data to be returned.
 *                              Can be 'Array' (default) or 'Object'.
 * {Object.<string, string>} [type]
 * {string[]} [fields]          field names to be returned
 * {function} [filter]          filter items
 * {string | function} [order]  Order the items by a field name or custom sort function.
 * @param {Array} args
 * @returns {DataSet}
 * @throws Error
 */
DataSet.prototype.get = function (args) {
  // eslint-disable-line no-unused-vars
  var me = this;

  // parse the arguments
  var id, ids, options;
  var firstType = util.getType(arguments[0]);
  if (firstType == 'String' || firstType == 'Number') {
    // get(id [, options])
    id = arguments[0];
    options = arguments[1];
  } else if (firstType == 'Array') {
    // get(ids [, options])
    ids = arguments[0];
    options = arguments[1];
  } else {
    // get([, options])
    options = arguments[0];
  }

  // determine the return type
  var returnType;
  if (options && options.returnType) {
    var allowedValues = ['Array', 'Object'];
    returnType = allowedValues.indexOf(options.returnType) == -1 ? 'Array' : options.returnType;
  } else {
    returnType = 'Array';
  }

  // build options
  var type = options && options.type || this._options.type;
  var filter = options && options.filter;
  var items = [],
      item,
      itemIds,
      itemId,
      i,
      len;

  // convert items
  if (id != undefined) {
    // return a single item
    item = me._getItem(id, type);
    if (item && filter && !filter(item)) {
      item = null;
    }
  } else if (ids != undefined) {
    // return a subset of items
    for (i = 0, len = ids.length; i < len; i++) {
      item = me._getItem(ids[i], type);
      if (!filter || filter(item)) {
        items.push(item);
      }
    }
  } else {
    // return all items
    itemIds = (0, _keys2['default'])(this._data);
    for (i = 0, len = itemIds.length; i < len; i++) {
      itemId = itemIds[i];
      item = me._getItem(itemId, type);
      if (!filter || filter(item)) {
        items.push(item);
      }
    }
  }

  // order the results
  if (options && options.order && id == undefined) {
    this._sort(items, options.order);
  }

  // filter fields of the items
  if (options && options.fields) {
    var fields = options.fields;
    if (id != undefined) {
      item = this._filterFields(item, fields);
    } else {
      for (i = 0, len = items.length; i < len; i++) {
        items[i] = this._filterFields(items[i], fields);
      }
    }
  }

  // return the results
  if (returnType == 'Object') {
    var result = {},
        resultant;
    for (i = 0, len = items.length; i < len; i++) {
      resultant = items[i];
      result[resultant.id] = resultant;
    }
    return result;
  } else {
    if (id != undefined) {
      // a single item
      return item;
    } else {
      // just return our array
      return items;
    }
  }
};

/**
 * Get ids of all items or from a filtered set of items.
 * @param {Object} [options]    An Object with options. Available options:
 *                              {function} [filter] filter items
 *                              {string | function} [order] Order the items by
 *                                  a field name or custom sort function.
 * @return {Array.<string|number>} ids
 */
DataSet.prototype.getIds = function (options) {
  var data = this._data,
      filter = options && options.filter,
      order = options && options.order,
      type = options && options.type || this._options.type,
      itemIds = (0, _keys2['default'])(data),
      i,
      len,
      id,
      item,
      items,
      ids = [];

  if (filter) {
    // get filtered items
    if (order) {
      // create ordered list
      items = [];
      for (i = 0, len = itemIds.length; i < len; i++) {
        id = itemIds[i];
        item = this._getItem(id, type);
        if (filter(item)) {
          items.push(item);
        }
      }

      this._sort(items, order);

      for (i = 0, len = items.length; i < len; i++) {
        ids.push(items[i][this._fieldId]);
      }
    } else {
      // create unordered list
      for (i = 0, len = itemIds.length; i < len; i++) {
        id = itemIds[i];
        item = this._getItem(id, type);
        if (filter(item)) {
          ids.push(item[this._fieldId]);
        }
      }
    }
  } else {
    // get all items
    if (order) {
      // create an ordered list
      items = [];
      for (i = 0, len = itemIds.length; i < len; i++) {
        id = itemIds[i];
        items.push(data[id]);
      }

      this._sort(items, order);

      for (i = 0, len = items.length; i < len; i++) {
        ids.push(items[i][this._fieldId]);
      }
    } else {
      // create unordered list
      for (i = 0, len = itemIds.length; i < len; i++) {
        id = itemIds[i];
        item = data[id];
        ids.push(item[this._fieldId]);
      }
    }
  }

  return ids;
};

/**
 * Returns the DataSet itself. Is overwritten for example by the DataView,
 * which returns the DataSet it is connected to instead.
 * @returns {DataSet}
 */
DataSet.prototype.getDataSet = function () {
  return this;
};

/**
 * Execute a callback function for every item in the dataset.
 * @param {function} callback
 * @param {Object} [options]    Available options:
 *                              {Object.<string, string>} [type]
 *                              {string[]} [fields] filter fields
 *                              {function} [filter] filter items
 *                              {string | function} [order] Order the items by
 *                                  a field name or custom sort function.
 */
DataSet.prototype.forEach = function (callback, options) {
  var filter = options && options.filter,
      type = options && options.type || this._options.type,
      data = this._data,
      itemIds = (0, _keys2['default'])(data),
      i,
      len,
      item,
      id;

  if (options && options.order) {
    // execute forEach on ordered list
    var items = this.get(options);

    for (i = 0, len = items.length; i < len; i++) {
      item = items[i];
      id = item[this._fieldId];
      callback(item, id);
    }
  } else {
    // unordered
    for (i = 0, len = itemIds.length; i < len; i++) {
      id = itemIds[i];
      item = this._getItem(id, type);
      if (!filter || filter(item)) {
        callback(item, id);
      }
    }
  }
};

/**
 * Map every item in the dataset.
 * @param {function} callback
 * @param {Object} [options]    Available options:
 *                              {Object.<string, string>} [type]
 *                              {string[]} [fields] filter fields
 *                              {function} [filter] filter items
 *                              {string | function} [order] Order the items by
 *                                  a field name or custom sort function.
 * @return {Object[]} mappedItems
 */
DataSet.prototype.map = function (callback, options) {
  var filter = options && options.filter,
      type = options && options.type || this._options.type,
      mappedItems = [],
      data = this._data,
      itemIds = (0, _keys2['default'])(data),
      i,
      len,
      id,
      item;

  // convert and filter items
  for (i = 0, len = itemIds.length; i < len; i++) {
    id = itemIds[i];
    item = this._getItem(id, type);
    if (!filter || filter(item)) {
      mappedItems.push(callback(item, id));
    }
  }

  // order items
  if (options && options.order) {
    this._sort(mappedItems, options.order);
  }

  return mappedItems;
};

/**
 * Filter the fields of an item
 * @param {Object | null} item
 * @param {string[]} fields     Field names
 * @return {Object | null} filteredItem or null if no item is provided
 * @private
 */
DataSet.prototype._filterFields = function (item, fields) {
  if (!item) {
    // item is null
    return item;
  }

  var filteredItem = {},
      itemFields = (0, _keys2['default'])(item),
      len = itemFields.length,
      i,
      field;

  if (Array.isArray(fields)) {
    for (i = 0; i < len; i++) {
      field = itemFields[i];
      if (fields.indexOf(field) != -1) {
        filteredItem[field] = item[field];
      }
    }
  } else {
    for (i = 0; i < len; i++) {
      field = itemFields[i];
      if (fields.hasOwnProperty(field)) {
        filteredItem[fields[field]] = item[field];
      }
    }
  }

  return filteredItem;
};

/**
 * Sort the provided array with items
 * @param {Object[]} items
 * @param {string | function} order      A field name or custom sort function.
 * @private
 */
DataSet.prototype._sort = function (items, order) {
  if (util.isString(order)) {
    // order by provided field name
    var name = order; // field name
    items.sort(function (a, b) {
      var av = a[name];
      var bv = b[name];
      return av > bv ? 1 : av < bv ? -1 : 0;
    });
  } else if (typeof order === 'function') {
    // order by sort function
    items.sort(order);
  }
  // TODO: extend order by an Object {field:string, direction:string}
  //       where direction can be 'asc' or 'desc'
  else {
      throw new TypeError('Order must be a function or a string');
    }
};

/**
 * Remove an object by pointer or by id
 * @param {string | number | Object | Array.<string|number>} id Object or id, or an array with
 *                                              objects or ids to be removed
 * @param {string} [senderId] Optional sender id
 * @return {Array.<string|number>} removedIds
 */
DataSet.prototype.remove = function (id, senderId) {
  var removedIds = [],
      removedItems = [],
      ids = [],
      i,
      len,
      itemId,
      item;

  // force everything to be an array for simplicity
  ids = Array.isArray(id) ? id : [id];

  for (i = 0, len = ids.length; i < len; i++) {
    item = this._remove(ids[i]);
    if (item) {
      itemId = item[this._fieldId];
      if (itemId != undefined) {
        removedIds.push(itemId);
        removedItems.push(item);
      }
    }
  }

  if (removedIds.length) {
    this._trigger('remove', { items: removedIds, oldData: removedItems }, senderId);
  }

  return removedIds;
};

/**
 * Remove an item by its id
 * @param {number | string | Object} id   id or item
 * @returns {number | string | null} id
 * @private
 */
DataSet.prototype._remove = function (id) {
  var item, ident;

  // confirm the id to use based on the args type
  if (util.isNumber(id) || util.isString(id)) {
    ident = id;
  } else if (id && (typeof id === 'undefined' ? 'undefined' : (0, _typeof3['default'])(id)) === 'object') {
    ident = id[this._fieldId]; // look for the identifier field using _fieldId
  }

  // do the remove if the item is found
  if (ident !== undefined && this._data[ident]) {
    item = this._data[ident];
    delete this._data[ident];
    this.length--;
    return item;
  }
  return null;
};

/**
 * Clear the data
 * @param {string} [senderId] Optional sender id
 * @return {Array.<string|number>} removedIds    The ids of all removed items
 */
DataSet.prototype.clear = function (senderId) {
  var i, len;
  var ids = (0, _keys2['default'])(this._data);
  var items = [];

  for (i = 0, len = ids.length; i < len; i++) {
    items.push(this._data[ids[i]]);
  }

  this._data = {};
  this.length = 0;

  this._trigger('remove', { items: ids, oldData: items }, senderId);

  return ids;
};

/**
 * Find the item with maximum value of a specified field
 * @param {string} field
 * @return {Object | null} item  Item containing max value, or null if no items
 */
DataSet.prototype.max = function (field) {
  var data = this._data,
      itemIds = (0, _keys2['default'])(data),
      max = null,
      maxField = null,
      i,
      len;

  for (i = 0, len = itemIds.length; i < len; i++) {
    var id = itemIds[i];
    var item = data[id];
    var itemField = item[field];
    if (itemField != null && (!max || itemField > maxField)) {
      max = item;
      maxField = itemField;
    }
  }

  return max;
};

/**
 * Find the item with minimum value of a specified field
 * @param {string} field
 * @return {Object | null} item  Item containing max value, or null if no items
 */
DataSet.prototype.min = function (field) {
  var data = this._data,
      itemIds = (0, _keys2['default'])(data),
      min = null,
      minField = null,
      i,
      len;

  for (i = 0, len = itemIds.length; i < len; i++) {
    var id = itemIds[i];
    var item = data[id];
    var itemField = item[field];
    if (itemField != null && (!min || itemField < minField)) {
      min = item;
      minField = itemField;
    }
  }

  return min;
};

/**
 * Find all distinct values of a specified field
 * @param {string} field
 * @return {Array} values  Array containing all distinct values. If data items
 *                         do not contain the specified field are ignored.
 *                         The returned array is unordered.
 */
DataSet.prototype.distinct = function (field) {
  var data = this._data;
  var itemIds = (0, _keys2['default'])(data);
  var values = [];
  var fieldType = this._options.type && this._options.type[field] || null;
  var count = 0;
  var i, j, len;

  for (i = 0, len = itemIds.length; i < len; i++) {
    var id = itemIds[i];
    var item = data[id];
    var value = item[field];
    var exists = false;
    for (j = 0; j < count; j++) {
      if (values[j] == value) {
        exists = true;
        break;
      }
    }
    if (!exists && value !== undefined) {
      values[count] = value;
      count++;
    }
  }

  if (fieldType) {
    for (i = 0, len = values.length; i < len; i++) {
      values[i] = util.convert(values[i], fieldType);
    }
  }

  return values;
};

/**
 * Add a single item. Will fail when an item with the same id already exists.
 * @param {Object} item
 * @return {string} id
 * @private
 */
DataSet.prototype._addItem = function (item) {
  var id = item[this._fieldId];

  if (id != undefined) {
    // check whether this id is already taken
    if (this._data[id]) {
      // item already exists
      throw new Error('Cannot add item: item with id ' + id + ' already exists');
    }
  } else {
    // generate an id
    id = util.randomUUID();
    item[this._fieldId] = id;
  }

  var d = {},
      fields = (0, _keys2['default'])(item),
      i,
      len;
  for (i = 0, len = fields.length; i < len; i++) {
    var field = fields[i];
    var fieldType = this._type[field]; // type may be undefined
    d[field] = util.convert(item[field], fieldType);
  }
  this._data[id] = d;
  this.length++;

  return id;
};

/**
 * Get an item. Fields can be converted to a specific type
 * @param {string} id
 * @param {Object.<string, string>} [types]  field types to convert
 * @return {Object | null} item
 * @private
 */
DataSet.prototype._getItem = function (id, types) {
  var field, value, i, len;

  // get the item from the dataset
  var raw = this._data[id];
  if (!raw) {
    return null;
  }

  // convert the items field types
  var converted = {},
      fields = (0, _keys2['default'])(raw);

  if (types) {
    for (i = 0, len = fields.length; i < len; i++) {
      field = fields[i];
      value = raw[field];
      converted[field] = util.convert(value, types[field]);
    }
  } else {
    // no field types specified, no converting needed
    for (i = 0, len = fields.length; i < len; i++) {
      field = fields[i];
      value = raw[field];
      converted[field] = value;
    }
  }

  if (!converted[this._fieldId]) {
    converted[this._fieldId] = raw.id;
  }

  return converted;
};

/**
 * Update a single item: merge with existing item.
 * Will fail when the item has no id, or when there does not exist an item
 * with the same id.
 * @param {Object} item
 * @return {string} id
 * @private
 */
DataSet.prototype._updateItem = function (item) {
  var id = item[this._fieldId];
  if (id == undefined) {
    throw new Error('Cannot update item: item has no id (item: ' + (0, _stringify2['default'])(item) + ')');
  }
  var d = this._data[id];
  if (!d) {
    // item doesn't exist
    throw new Error('Cannot update item: no item with id ' + id + ' found');
  }

  // merge with current item
  var fields = (0, _keys2['default'])(item);
  for (var i = 0, len = fields.length; i < len; i++) {
    var field = fields[i];
    var fieldType = this._type[field]; // type may be undefined
    d[field] = util.convert(item[field], fieldType);
  }

  return id;
};

module.exports = DataSet;

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);

var Label = __webpack_require__(77)['default'];
var ComponentUtil = __webpack_require__(35)['default'];
var Box = __webpack_require__(144)['default'];
var Circle = __webpack_require__(151)['default'];
var CircularImage = __webpack_require__(152)['default'];
var Database = __webpack_require__(153)['default'];
var Diamond = __webpack_require__(154)['default'];
var Dot = __webpack_require__(155)['default'];
var Ellipse = __webpack_require__(156)['default'];
var Icon = __webpack_require__(157)['default'];
var Image = __webpack_require__(158)['default'];
var Square = __webpack_require__(159)['default'];
var Hexagon = __webpack_require__(160)['default'];
var Star = __webpack_require__(161)['default'];
var Text = __webpack_require__(162)['default'];
var Triangle = __webpack_require__(163)['default'];
var TriangleDown = __webpack_require__(164)['default'];

var _require = __webpack_require__(54),
    printStyle = _require.printStyle;

/**
 * A node. A node can be connected to other nodes via one or multiple edges.
 */


var Node = function () {
  /**
   *
   * @param {object} options An object containing options for the node. All
   *                            options are optional, except for the id.
   *                              {number} id     Id of the node. Required
   *                              {string} label  Text label for the node
   *                              {number} x      Horizontal position of the node
   *                              {number} y      Vertical position of the node
   *                              {string} shape  Node shape
   *                              {string} image  An image url
   *                              {string} title  A title text, can be HTML
   *                              {anytype} group A group name or number
   *
   * @param {Object} body               Shared state of current network instance
   * @param {Network.Images} imagelist  A list with images. Only needed when the node has an image
   * @param {Groups} grouplist          A list with groups. Needed for retrieving group options
   * @param {Object} globalOptions      Current global node options; these serve as defaults for the node instance
   * @param {Object} defaultOptions     Global default options for nodes; note that this is also the prototype
   *                                    for parameter `globalOptions`.
   */
  function Node(options, body, imagelist, grouplist, globalOptions, defaultOptions) {
    (0, _classCallCheck3['default'])(this, Node);

    this.options = util.bridgeObject(globalOptions);
    this.globalOptions = globalOptions;
    this.defaultOptions = defaultOptions;
    this.body = body;

    this.edges = []; // all edges connected to this node

    // set defaults for the options
    this.id = undefined;
    this.imagelist = imagelist;
    this.grouplist = grouplist;

    // state options
    this.x = undefined;
    this.y = undefined;
    this.baseSize = this.options.size;
    this.baseFontSize = this.options.font.size;
    this.predefinedPosition = false; // used to check if initial fit should just take the range or approximate
    this.selected = false;
    this.hover = false;

    this.labelModule = new Label(this.body, this.options, false /* Not edge label */
    );
    this.setOptions(options);
  }

  /**
   * Attach a edge to the node
   * @param {Edge} edge
   */


  (0, _createClass3['default'])(Node, [{
    key: 'attachEdge',
    value: function attachEdge(edge) {
      if (this.edges.indexOf(edge) === -1) {
        this.edges.push(edge);
      }
    }

    /**
     * Detach a edge from the node
     *
     * @param {Edge} edge
     */

  }, {
    key: 'detachEdge',
    value: function detachEdge(edge) {
      var index = this.edges.indexOf(edge);
      if (index != -1) {
        this.edges.splice(index, 1);
      }
    }

    /**
     * Set or overwrite options for the node
     *
     * @param {Object} options an object with options
     * @returns {null|boolean}
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      var currentShape = this.options.shape;
      if (!options) {
        return; // Note that the return value will be 'undefined'! This is OK.
      }

      // basic options
      if (options.id !== undefined) {
        this.id = options.id;
      }

      if (this.id === undefined) {
        throw new Error('Node must have an id');
      }

      Node.checkMass(options, this.id);

      // set these options locally
      // clear x and y positions
      if (options.x !== undefined) {
        if (options.x === null) {
          this.x = undefined;
          this.predefinedPosition = false;
        } else {
          this.x = parseInt(options.x);
          this.predefinedPosition = true;
        }
      }
      if (options.y !== undefined) {
        if (options.y === null) {
          this.y = undefined;
          this.predefinedPosition = false;
        } else {
          this.y = parseInt(options.y);
          this.predefinedPosition = true;
        }
      }
      if (options.size !== undefined) {
        this.baseSize = options.size;
      }
      if (options.value !== undefined) {
        options.value = parseFloat(options.value);
      }

      // this transforms all shorthands into fully defined options
      Node.parseOptions(this.options, options, true, this.globalOptions, this.grouplist);

      var pile = [options, this.options, this.defaultOptions];
      this.chooser = ComponentUtil.choosify('node', pile);

      this._load_images();
      this.updateLabelModule(options);
      this.updateShape(currentShape);

      return options.hidden !== undefined || options.physics !== undefined;
    }

    /**
     * Load the images from the options, for the nodes that need them.
     *
     * Images are always loaded, even if they are not used in the current shape.
     * The user may switch to an image shape later on.
     *
     * @private
     */

  }, {
    key: '_load_images',
    value: function _load_images() {
      if (this.options.shape === 'circularImage' || this.options.shape === 'image') {
        if (this.options.image === undefined) {
          throw new Error("Option image must be defined for node type '" + this.options.shape + "'");
        }
      }

      if (this.options.image === undefined) {
        return;
      }

      if (this.imagelist === undefined) {
        throw new Error('Internal Error: No images provided');
      }

      if (typeof this.options.image === 'string') {
        this.imageObj = this.imagelist.load(this.options.image, this.options.brokenImage, this.id);
      } else {
        if (this.options.image.unselected === undefined) {
          throw new Error('No unselected image provided');
        }

        this.imageObj = this.imagelist.load(this.options.image.unselected, this.options.brokenImage, this.id);

        if (this.options.image.selected !== undefined) {
          this.imageObjAlt = this.imagelist.load(this.options.image.selected, this.options.brokenImage, this.id);
        } else {
          this.imageObjAlt = undefined;
        }
      }
    }

    /**
     * Copy group option values into the node options.
     *
     * The group options override the global node options, so the copy of group options
     *  must happen *after* the global node options have been set.
     *
     * This method must also be called also if the global node options have changed and the group options did not.
     *
     * @param {Object} parentOptions
     * @param {Object} newOptions  new values for the options, currently only passed in for check
     * @param {Object} groupList
     */

  }, {
    key: 'getFormattingValues',


    /**
     *
     * @returns {{color: *, borderWidth: *, borderColor: *, size: *, borderDashes: (boolean|Array|allOptions.nodes.shapeProperties.borderDashes|{boolean, array}), borderRadius: (number|allOptions.nodes.shapeProperties.borderRadius|{number}|Array), shadow: *, shadowColor: *, shadowSize: *, shadowX: *, shadowY: *}}
     */
    value: function getFormattingValues() {
      var values = {
        color: this.options.color.background,
        borderWidth: this.options.borderWidth,
        borderColor: this.options.color.border,
        size: this.options.size,
        borderDashes: this.options.shapeProperties.borderDashes,
        borderRadius: this.options.shapeProperties.borderRadius,
        shadow: this.options.shadow.enabled,
        shadowColor: this.options.shadow.color,
        shadowSize: this.options.shadow.size,
        shadowX: this.options.shadow.x,
        shadowY: this.options.shadow.y
      };
      if (this.selected || this.hover) {
        if (this.chooser === true) {
          if (this.selected) {
            values.borderWidth *= 2;
            values.color = this.options.color.highlight.background;
            values.borderColor = this.options.color.highlight.border;
            values.shadow = this.options.shadow.enabled;
          } else if (this.hover) {
            values.color = this.options.color.hover.background;
            values.borderColor = this.options.color.hover.border;
            values.shadow = this.options.shadow.enabled;
          }
        } else if (typeof this.chooser === 'function') {
          this.chooser(values, this.options.id, this.selected, this.hover);
          if (values.shadow === false) {
            if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
              values.shadow = true;
            }
          }
        }
      } else {
        values.shadow = this.options.shadow.enabled;
      }
      return values;
    }

    /**
     *
     * @param {Object} options
     */

  }, {
    key: 'updateLabelModule',
    value: function updateLabelModule(options) {
      if (this.options.label === undefined || this.options.label === null) {
        this.options.label = '';
      }

      Node.updateGroupOptions(this.options, options, this.grouplist);

      //
      // Note:The prototype chain for this.options is:
      //
      // this.options ->    NodesHandler.options    -> NodesHandler.defaultOptions
      //                 (also: this.globalOptions)
      //
      // Note that the prototypes are mentioned explicitly in the pile list below;
      // WE DON'T WANT THE ORDER OF THE PROTOTYPES!!!! At least, not for font handling of labels.
      // This is a good indication that the prototype usage of options is deficient.
      //
      var currentGroup = this.grouplist.get(this.options.group, false);
      var pile = [options, // new options
      this.options, // current node options, see comment above for prototype
      currentGroup, // group options, if any
      this.globalOptions, // Currently set global node options
      this.defaultOptions // Default global node options
      ];
      this.labelModule.update(this.options, pile);

      if (this.labelModule.baseSize !== undefined) {
        this.baseFontSize = this.labelModule.baseSize;
      }
    }

    /**
     *
     * @param {string} currentShape
     */

  }, {
    key: 'updateShape',
    value: function updateShape(currentShape) {
      if (currentShape === this.options.shape && this.shape) {
        this.shape.setOptions(this.options, this.imageObj, this.imageObjAlt);
      } else {
        // choose draw method depending on the shape
        switch (this.options.shape) {
          case 'box':
            this.shape = new Box(this.options, this.body, this.labelModule);
            break;
          case 'circle':
            this.shape = new Circle(this.options, this.body, this.labelModule);
            break;
          case 'circularImage':
            this.shape = new CircularImage(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
            break;
          case 'database':
            this.shape = new Database(this.options, this.body, this.labelModule);
            break;
          case 'diamond':
            this.shape = new Diamond(this.options, this.body, this.labelModule);
            break;
          case 'dot':
            this.shape = new Dot(this.options, this.body, this.labelModule);
            break;
          case 'ellipse':
            this.shape = new Ellipse(this.options, this.body, this.labelModule);
            break;
          case 'icon':
            this.shape = new Icon(this.options, this.body, this.labelModule);
            break;
          case 'image':
            this.shape = new Image(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
            break;
          case 'square':
            this.shape = new Square(this.options, this.body, this.labelModule);
            break;
          case 'hexagon':
            this.shape = new Hexagon(this.options, this.body, this.labelModule);
            break;
          case 'star':
            this.shape = new Star(this.options, this.body, this.labelModule);
            break;
          case 'text':
            this.shape = new Text(this.options, this.body, this.labelModule);
            break;
          case 'triangle':
            this.shape = new Triangle(this.options, this.body, this.labelModule);
            break;
          case 'triangleDown':
            this.shape = new TriangleDown(this.options, this.body, this.labelModule);
            break;
          default:
            this.shape = new Ellipse(this.options, this.body, this.labelModule);
            break;
        }
      }
      this.needsRefresh();
    }

    /**
     * select this node
     */

  }, {
    key: 'select',
    value: function select() {
      this.selected = true;
      this.needsRefresh();
    }

    /**
     * unselect this node
     */

  }, {
    key: 'unselect',
    value: function unselect() {
      this.selected = false;
      this.needsRefresh();
    }

    /**
     * Reset the calculated size of the node, forces it to recalculate its size
     */

  }, {
    key: 'needsRefresh',
    value: function needsRefresh() {
      this.shape.refreshNeeded = true;
    }

    /**
     * get the title of this node.
     * @return {string} title    The title of the node, or undefined when no title
     *                           has been set.
     */

  }, {
    key: 'getTitle',
    value: function getTitle() {
      return this.options.title;
    }

    /**
     * Calculate the distance to the border of the Node
     * @param {CanvasRenderingContext2D}   ctx
     * @param {number} angle        Angle in radians
     * @returns {number} distance   Distance to the border in pixels
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this.shape.distanceToBorder(ctx, angle);
    }

    /**
     * Check if this node has a fixed x and y position
     * @return {boolean}      true if fixed, false if not
     */

  }, {
    key: 'isFixed',
    value: function isFixed() {
      return this.options.fixed.x && this.options.fixed.y;
    }

    /**
     * check if this node is selecte
     * @return {boolean} selected   True if node is selected, else false
     */

  }, {
    key: 'isSelected',
    value: function isSelected() {
      return this.selected;
    }

    /**
     * Retrieve the value of the node. Can be undefined
     * @return {number} value
     */

  }, {
    key: 'getValue',
    value: function getValue() {
      return this.options.value;
    }

    /**
     * Get the current dimensions of the label
     *
     * @return {rect}
     */

  }, {
    key: 'getLabelSize',
    value: function getLabelSize() {
      return this.labelModule.size();
    }

    /**
     * Adjust the value range of the node. The node will adjust it's size
     * based on its value.
     * @param {number} min
     * @param {number} max
     * @param {number} total
     */

  }, {
    key: 'setValueRange',
    value: function setValueRange(min, max, total) {
      if (this.options.value !== undefined) {
        var scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
        var sizeDiff = this.options.scaling.max - this.options.scaling.min;
        if (this.options.scaling.label.enabled === true) {
          var fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
          this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
        }
        this.options.size = this.options.scaling.min + scale * sizeDiff;
      } else {
        this.options.size = this.baseSize;
        this.options.font.size = this.baseFontSize;
      }

      this.updateLabelModule();
    }

    /**
     * Draw this node in the given canvas
     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
     * @param {CanvasRenderingContext2D}   ctx
     */

  }, {
    key: 'draw',
    value: function draw(ctx) {
      var values = this.getFormattingValues();
      this.shape.draw(ctx, this.x, this.y, this.selected, this.hover, values);
    }

    /**
     * Update the bounding box of the shape
     * @param {CanvasRenderingContext2D}   ctx
     */

  }, {
    key: 'updateBoundingBox',
    value: function updateBoundingBox(ctx) {
      this.shape.updateBoundingBox(this.x, this.y, ctx);
    }

    /**
     * Recalculate the size of this node in the given canvas
     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
     * @param {CanvasRenderingContext2D}   ctx
     */

  }, {
    key: 'resize',
    value: function resize(ctx) {
      var values = this.getFormattingValues();
      this.shape.resize(ctx, this.selected, this.hover, values);
    }

    /**
     * Determine all visual elements of this node instance, in which the given
     * point falls within the bounding shape.
     *
     * @param {point} point
     * @returns {Array.<nodeClickItem|nodeLabelClickItem>} list with the items which are on the point
     */

  }, {
    key: 'getItemsOnPoint',
    value: function getItemsOnPoint(point) {
      var ret = [];

      if (this.labelModule.visible()) {
        if (ComponentUtil.pointInRect(this.labelModule.getSize(), point)) {
          ret.push({ nodeId: this.id, labelId: 0 });
        }
      }

      if (ComponentUtil.pointInRect(this.shape.boundingBox, point)) {
        ret.push({ nodeId: this.id });
      }

      return ret;
    }

    /**
     * Check if this object is overlapping with the provided object
     * @param {Object} obj   an object with parameters left, top, right, bottom
     * @return {boolean}     True if location is located on node
     */

  }, {
    key: 'isOverlappingWith',
    value: function isOverlappingWith(obj) {
      return this.shape.left < obj.right && this.shape.left + this.shape.width > obj.left && this.shape.top < obj.bottom && this.shape.top + this.shape.height > obj.top;
    }

    /**
     * Check if this object is overlapping with the provided object
     * @param {Object} obj   an object with parameters left, top, right, bottom
     * @return {boolean}     True if location is located on node
     */

  }, {
    key: 'isBoundingBoxOverlappingWith',
    value: function isBoundingBoxOverlappingWith(obj) {
      return this.shape.boundingBox.left < obj.right && this.shape.boundingBox.right > obj.left && this.shape.boundingBox.top < obj.bottom && this.shape.boundingBox.bottom > obj.top;
    }

    /**
     * Check valid values for mass
     *
     * The mass may not be negative or zero. If it is, reset to 1
     *
     * @param {object} options
     * @param {Node.id} id
     * @static
     */

  }], [{
    key: 'updateGroupOptions',
    value: function updateGroupOptions(parentOptions, newOptions, groupList) {
      if (groupList === undefined) return; // No groups, nothing to do

      var group = parentOptions.group;

      // paranoia: the selected group is already merged into node options, check.
      if (newOptions !== undefined && newOptions.group !== undefined && group !== newOptions.group) {
        throw new Error("updateGroupOptions: group values in options don't match.");
      }

      var hasGroup = typeof group === 'number' || typeof group === 'string' && group != '';
      if (!hasGroup) return; // current node has no group, no need to merge

      var groupObj = groupList.get(group);

      // Skip merging of group font options into parent; these are required to be distinct for labels
      // Also skip mergin of color IF it is already defined in the node itself. This is to avoid the color of the
      // group overriding the color set at the node level
      // TODO: It might not be a good idea either to merge the rest of the options, investigate this.
      var skipProperties = ['font'];
      if (newOptions !== undefined && newOptions.color !== undefined && newOptions.color != null) skipProperties.push('color');
      util.selectiveNotDeepExtend(skipProperties, parentOptions, groupObj);

      // the color object needs to be completely defined.
      // Since groups can partially overwrite the colors, we parse it again, just in case.
      parentOptions.color = util.parseColor(parentOptions.color);
    }

    /**
     * This process all possible shorthands in the new options and makes sure that the parentOptions are fully defined.
     * Static so it can also be used by the handler.
     *
     * @param {Object} parentOptions
     * @param {Object} newOptions
     * @param {boolean} [allowDeletion=false]
     * @param {Object} [globalOptions={}]
     * @param {Object} [groupList]
     * @static
     */

  }, {
    key: 'parseOptions',
    value: function parseOptions(parentOptions, newOptions) {
      var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var groupList = arguments[4];

      var fields = ['color', 'fixed', 'shadow'];
      util.selectiveNotDeepExtend(fields, parentOptions, newOptions, allowDeletion);

      Node.checkMass(newOptions);

      // merge the shadow options into the parent.
      util.mergeOptions(parentOptions, newOptions, 'shadow', globalOptions);

      // individual shape newOptions
      if (newOptions.color !== undefined && newOptions.color !== null) {
        var parsedColor = util.parseColor(newOptions.color);
        util.fillIfDefined(parentOptions.color, parsedColor);
      } else if (allowDeletion === true && newOptions.color === null) {
        parentOptions.color = util.bridgeObject(globalOptions.color); // set the object back to the global options
      }

      // handle the fixed options
      if (newOptions.fixed !== undefined && newOptions.fixed !== null) {
        if (typeof newOptions.fixed === 'boolean') {
          parentOptions.fixed.x = newOptions.fixed;
          parentOptions.fixed.y = newOptions.fixed;
        } else {
          if (newOptions.fixed.x !== undefined && typeof newOptions.fixed.x === 'boolean') {
            parentOptions.fixed.x = newOptions.fixed.x;
          }
          if (newOptions.fixed.y !== undefined && typeof newOptions.fixed.y === 'boolean') {
            parentOptions.fixed.y = newOptions.fixed.y;
          }
        }
      }

      if (allowDeletion === true && newOptions.font === null) {
        parentOptions.font = util.bridgeObject(globalOptions.font); // set the object back to the global options
      }

      Node.updateGroupOptions(parentOptions, newOptions, groupList);

      // handle the scaling options, specifically the label part
      if (newOptions.scaling !== undefined) {
        util.mergeOptions(parentOptions.scaling, newOptions.scaling, 'label', globalOptions.scaling);
      }
    }
  }, {
    key: 'checkMass',
    value: function checkMass(options, id) {
      if (options.mass !== undefined && options.mass <= 0) {
        var strId = '';
        if (id !== undefined) {
          strId = ' in node id: ' + id;
        }
        console.log('%cNegative or zero mass disallowed' + strId + ', setting mass to 1.', printStyle);
        options.mass = 1;
      }
    }
  }]);
  return Node;
}();

exports['default'] = Node;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);

/**
 * Helper functions for components
 * @class
 */

var ComponentUtil = function () {
  function ComponentUtil() {
    (0, _classCallCheck3['default'])(this, ComponentUtil);
  }

  (0, _createClass3['default'])(ComponentUtil, null, [{
    key: 'choosify',

    /**
     * Determine values to use for (sub)options of 'chosen'.
     *
     * This option is either a boolean or an object whose values should be examined further.
     * The relevant structures are:
     *
     * - chosen: <boolean value>
     * - chosen: { subOption: <boolean or function> }
     *
     * Where subOption is 'node', 'edge' or 'label'.
     *
     * The intention of this method appears to be to set a specific priority to the options;
     * Since most properties are either bridged or merged into the local options objects, there
     * is not much point in handling them separately.
     * TODO: examine if 'most' in previous sentence can be replaced with 'all'. In that case, we
     *       should be able to get rid of this method.
     *
     * @param {string}  subOption  option within object 'chosen' to consider; either 'node', 'edge' or 'label'
     * @param {Object}  pile       array of options objects to consider
     *
     * @return {boolean|function}  value for passed subOption of 'chosen' to use
     */
    value: function choosify(subOption, pile) {
      // allowed values for subOption
      var allowed = ['node', 'edge', 'label'];
      var value = true;

      var chosen = util.topMost(pile, 'chosen');
      if (typeof chosen === 'boolean') {
        value = chosen;
      } else if ((typeof chosen === 'undefined' ? 'undefined' : (0, _typeof3['default'])(chosen)) === 'object') {
        if (allowed.indexOf(subOption) === -1) {
          throw new Error("choosify: subOption '" + subOption + "' should be one of " + "'" + allowed.join("', '") + "'");
        }

        var chosenEdge = util.topMost(pile, ['chosen', subOption]);
        if (typeof chosenEdge === 'boolean' || typeof chosenEdge === 'function') {
          value = chosenEdge;
        }
      }

      return value;
    }

    /**
     * Check if the point falls within the given rectangle.
     *
     * @param {rect} rect
     * @param {point} point
     * @param {rotationPoint} [rotationPoint] if specified, the rotation that applies to the rectangle.
     * @returns {boolean}  true if point within rectangle, false otherwise
     * @static
     */

  }, {
    key: 'pointInRect',
    value: function pointInRect(rect, point, rotationPoint) {
      if (rect.width <= 0 || rect.height <= 0) {
        return false; // early out
      }

      if (rotationPoint !== undefined) {
        // Rotate the point the same amount as the rectangle
        var tmp = {
          x: point.x - rotationPoint.x,
          y: point.y - rotationPoint.y
        };

        if (rotationPoint.angle !== 0) {
          // In order to get the coordinates the same, you need to
          // rotate in the reverse direction
          var angle = -rotationPoint.angle;

          var tmp2 = {
            x: Math.cos(angle) * tmp.x - Math.sin(angle) * tmp.y,
            y: Math.sin(angle) * tmp.x + Math.cos(angle) * tmp.y
          };
          point = tmp2;
        } else {
          point = tmp;
        }

        // Note that if a rotation is specified, the rectangle coordinates
        // are **not* the full canvas coordinates. They are relative to the
        // rotationPoint. Hence, the point coordinates need not be translated
        // back in this case.
      }

      var right = rect.x + rect.width;
      var bottom = rect.y + rect.width;

      return rect.left < point.x && right > point.x && rect.top < point.y && bottom > point.y;
    }

    /**
     * Check if given value is acceptable as a label text.
     *
     * @param {*} text value to check; can be anything at this point
     * @returns {boolean} true if valid label value, false otherwise
     */

  }, {
    key: 'isValidLabel',
    value: function isValidLabel(text) {
      // Note that this is quite strict: types that *might* be converted to string are disallowed
      return typeof text === 'string' && text !== '';
    }
  }]);
  return ComponentUtil;
}();

exports['default'] = ComponentUtil;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Register a touch event, taking place before a gesture
 * @param {Hammer} hammer       A hammer instance
 * @param {function} callback   Callback, called as callback(event)
 */
exports.onTouch = function (hammer, callback) {
  callback.inputHandler = function (event) {
    if (event.isFirst) {
      callback(event);
    }
  };

  hammer.on('hammer.input', callback.inputHandler);
};

/**
 * Register a release event, taking place after a gesture
 * @param {Hammer} hammer       A hammer instance
 * @param {function} callback   Callback, called as callback(event)
 * @returns {*}
 */
exports.onRelease = function (hammer, callback) {
  callback.inputHandler = function (event) {
    if (event.isFinal) {
      callback(event);
    }
  };

  return hammer.on('hammer.input', callback.inputHandler);
};

/**
 * Unregister a touch event, taking place before a gesture
 * @param {Hammer} hammer       A hammer instance
 * @param {function} callback   Callback, called as callback(event)
 */
exports.offTouch = function (hammer, callback) {
  hammer.off('hammer.input', callback.inputHandler);
};

/**
 * Unregister a release event, taking place before a gesture
 * @param {Hammer} hammer       A hammer instance
 * @param {function} callback   Callback, called as callback(event)
 */
exports.offRelease = exports.offTouch;

/**
 * Hack the PinchRecognizer such that it doesn't prevent default behavior
 * for vertical panning.
 *
 * Yeah ... this is quite a hack ... see https://github.com/hammerjs/hammer.js/issues/932
 *
 * @param {Hammer.Pinch} pinchRecognizer
 * @return {Hammer.Pinch} returns the pinchRecognizer
 */
exports.disablePreventDefaultVertically = function (pinchRecognizer) {
  var TOUCH_ACTION_PAN_Y = 'pan-y';

  pinchRecognizer.getTouchAction = function () {
    // default method returns [TOUCH_ACTION_NONE]
    return [TOUCH_ACTION_PAN_Y];
  };

  return pinchRecognizer;
};

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(87);
var global = __webpack_require__(10);
var hide = __webpack_require__(19);
var Iterators = __webpack_require__(25);
var TO_STRING_TAG = __webpack_require__(8)('toStringTag');

var DOMIterables = ('CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,' +
  'DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,' +
  'MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,' +
  'SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,' +
  'TextTrackList,TouchList').split(',');

for (var i = 0; i < DOMIterables.length; i++) {
  var NAME = DOMIterables[i];
  var Collection = global[NAME];
  var proto = Collection && Collection.prototype;
  if (proto && !proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);
  Iterators[NAME] = Iterators.Array;
}


/***/ }),
/* 38 */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),
/* 39 */
/***/ (function(module, exports) {

// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__(21);
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = __webpack_require__(20);
var dPs = __webpack_require__(92);
var enumBugKeys = __webpack_require__(45);
var IE_PROTO = __webpack_require__(43)('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = __webpack_require__(63)('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  __webpack_require__(96).appendChild(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};


/***/ }),
/* 42 */
/***/ (function(module, exports) {

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(44)('keys');
var uid = __webpack_require__(29);
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

var core = __webpack_require__(6);
var global = __webpack_require__(10);
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: core.version,
  mode: __webpack_require__(27) ? 'pure' : 'global',
  copyright: '© 2018 Denis Pushkarev (zloirock.ru)'
});


/***/ }),
/* 45 */
/***/ (function(module, exports) {

// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

var def = __webpack_require__(12).f;
var has = __webpack_require__(14);
var TAG = __webpack_require__(8)('toStringTag');

module.exports = function (it, tag, stat) {
  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $at = __webpack_require__(97)(true);

// 21.1.3.27 String.prototype[@@iterator]()
__webpack_require__(60)(String, 'String', function (iterated) {
  this._t = String(iterated); // target
  this._i = 0;                // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var index = this._i;
  var point;
  if (index >= O.length) return { value: undefined, done: true };
  point = $at(O, index);
  this._i += point.length;
  return { value: point, done: false };
});


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

exports.f = __webpack_require__(8);


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(10);
var core = __webpack_require__(6);
var LIBRARY = __webpack_require__(27);
var wksExt = __webpack_require__(48);
var defineProperty = __webpack_require__(12).f;
module.exports = function (name) {
  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });
};


/***/ }),
/* 50 */
/***/ (function(module, exports) {

exports.f = Object.getOwnPropertySymbols;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _keys = __webpack_require__(9);

var _keys2 = _interopRequireDefault(_keys);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);
var DataSet = __webpack_require__(33);

/**
 * DataView
 *
 * a dataview offers a filtered view on a dataset or an other dataview.
 *
 * @param {DataSet | DataView} data
 * @param {Object} [options]   Available options: see method get
 *
 * @constructor DataView
 */
function DataView(data, options) {
  this._data = null;
  this._ids = {}; // ids of the items currently in memory (just contains a boolean true)
  this.length = 0; // number of items in the DataView
  this._options = options || {};
  this._fieldId = 'id'; // name of the field containing id
  this._subscribers = {}; // event subscribers

  var me = this;
  this.listener = function () {
    me._onEvent.apply(me, arguments);
  };

  this.setData(data);
}

// TODO: implement a function .config() to dynamically update things like configured filter
// and trigger changes accordingly

/**
 * Set a data source for the view
 * @param {DataSet | DataView} data
 */
DataView.prototype.setData = function (data) {
  var ids, id, i, len, items;

  if (this._data) {
    // unsubscribe from current dataset
    if (this._data.off) {
      this._data.off('*', this.listener);
    }

    // trigger a remove of all items in memory
    ids = this._data.getIds({ filter: this._options && this._options.filter });
    items = [];

    for (i = 0, len = ids.length; i < len; i++) {
      items.push(this._data._data[ids[i]]);
    }

    this._ids = {};
    this.length = 0;
    this._trigger('remove', { items: ids, oldData: items });
  }

  this._data = data;

  if (this._data) {
    // update fieldId
    this._fieldId = this._options.fieldId || this._data && this._data.options && this._data.options.fieldId || 'id';

    // trigger an add of all added items
    ids = this._data.getIds({ filter: this._options && this._options.filter });
    for (i = 0, len = ids.length; i < len; i++) {
      id = ids[i];
      this._ids[id] = true;
    }
    this.length = ids.length;
    this._trigger('add', { items: ids });

    // subscribe to new dataset
    if (this._data.on) {
      this._data.on('*', this.listener);
    }
  }
};

/**
 * Refresh the DataView. Useful when the DataView has a filter function
 * containing a variable parameter.
 */
DataView.prototype.refresh = function () {
  var id, i, len;
  var ids = this._data.getIds({
    filter: this._options && this._options.filter
  }),
      oldIds = (0, _keys2['default'])(this._ids),
      newIds = {},
      addedIds = [],
      removedIds = [],
      removedItems = [];

  // check for additions
  for (i = 0, len = ids.length; i < len; i++) {
    id = ids[i];
    newIds[id] = true;
    if (!this._ids[id]) {
      addedIds.push(id);
      this._ids[id] = true;
    }
  }

  // check for removals
  for (i = 0, len = oldIds.length; i < len; i++) {
    id = oldIds[i];
    if (!newIds[id]) {
      removedIds.push(id);
      removedItems.push(this._data._data[id]);
      delete this._ids[id];
    }
  }

  this.length += addedIds.length - removedIds.length;

  // trigger events
  if (addedIds.length) {
    this._trigger('add', { items: addedIds });
  }
  if (removedIds.length) {
    this._trigger('remove', { items: removedIds, oldData: removedItems });
  }
};

// prettier-ignore
/**
 * Get data from the data view
 *
 * Usage:
 *
 *     get()
 *     get(options: Object)
 *     get(options: Object, data: Array | DataTable)
 *
 *     get(id: Number)
 *     get(id: Number, options: Object)
 *     get(id: Number, options: Object, data: Array | DataTable)
 *
 *     get(ids: Number[])
 *     get(ids: Number[], options: Object)
 *     get(ids: Number[], options: Object, data: Array | DataTable)
 *
 * Where:
 *
 * {number | string} id         The id of an item
 * {number[] | string{}} ids    An array with ids of items
 * {Object} options             An Object with options. Available options:
 *                              {string} [type] Type of data to be returned. Can
 *                                              be 'DataTable' or 'Array' (default)
 *                              {Object.<string, string>} [convert]
 *                              {string[]} [fields] field names to be returned
 *                              {function} [filter] filter items
 *                              {string | function} [order] Order the items by
 *                                  a field name or custom sort function.
 * {Array | DataTable} [data]   If provided, items will be appended to this
 *                              array or table. Required in case of Google
 *                              DataTable.
 * @param {Array} args
 * @return {DataSet|DataView}
 */
DataView.prototype.get = function (args) {
  // eslint-disable-line no-unused-vars
  var me = this;

  // parse the arguments
  var ids, options, data;
  var firstType = util.getType(arguments[0]);
  if (firstType == 'String' || firstType == 'Number' || firstType == 'Array') {
    // get(id(s) [, options] [, data])
    ids = arguments[0]; // can be a single id or an array with ids
    options = arguments[1];
    data = arguments[2];
  } else {
    // get([, options] [, data])
    options = arguments[0];
    data = arguments[1];
  }

  // extend the options with the default options and provided options
  var viewOptions = util.extend({}, this._options, options);

  // create a combined filter method when needed
  if (this._options.filter && options && options.filter) {
    viewOptions.filter = function (item) {
      return me._options.filter(item) && options.filter(item);
    };
  }

  // build up the call to the linked data set
  var getArguments = [];
  if (ids != undefined) {
    getArguments.push(ids);
  }
  getArguments.push(viewOptions);
  getArguments.push(data);

  return this._data && this._data.get.apply(this._data, getArguments);
};

/**
 * Get ids of all items or from a filtered set of items.
 * @param {Object} [options]    An Object with options. Available options:
 *                              {function} [filter] filter items
 *                              {string | function} [order] Order the items by
 *                                  a field name or custom sort function.
 * @return {Array.<string|number>} ids
 */
DataView.prototype.getIds = function (options) {
  var ids;

  if (this._data) {
    var defaultFilter = this._options.filter;
    var filter;

    if (options && options.filter) {
      if (defaultFilter) {
        filter = function filter(item) {
          return defaultFilter(item) && options.filter(item);
        };
      } else {
        filter = options.filter;
      }
    } else {
      filter = defaultFilter;
    }

    ids = this._data.getIds({
      filter: filter,
      order: options && options.order
    });
  } else {
    ids = [];
  }

  return ids;
};

/**
 * Map every item in the dataset.
 * @param {function} callback
 * @param {Object} [options]    Available options:
 *                              {Object.<string, string>} [type]
 *                              {string[]} [fields] filter fields
 *                              {function} [filter] filter items
 *                              {string | function} [order] Order the items by
 *                                  a field name or custom sort function.
 * @return {Object[]} mappedItems
 */
DataView.prototype.map = function (callback, options) {
  var mappedItems = [];
  if (this._data) {
    var defaultFilter = this._options.filter;
    var filter;

    if (options && options.filter) {
      if (defaultFilter) {
        filter = function filter(item) {
          return defaultFilter(item) && options.filter(item);
        };
      } else {
        filter = options.filter;
      }
    } else {
      filter = defaultFilter;
    }

    mappedItems = this._data.map(callback, {
      filter: filter,
      order: options && options.order
    });
  } else {
    mappedItems = [];
  }

  return mappedItems;
};

/**
 * Get the DataSet to which this DataView is connected. In case there is a chain
 * of multiple DataViews, the root DataSet of this chain is returned.
 * @return {DataSet} dataSet
 */
DataView.prototype.getDataSet = function () {
  var dataSet = this;
  while (dataSet instanceof DataView) {
    dataSet = dataSet._data;
  }
  return dataSet || null;
};

/**
 * Event listener. Will propagate all events from the connected data set to
 * the subscribers of the DataView, but will filter the items and only trigger
 * when there are changes in the filtered data set.
 * @param {string} event
 * @param {Object | null} params
 * @param {string} senderId
 * @private
 */
DataView.prototype._onEvent = function (event, params, senderId) {
  var i, len, id, item;
  var ids = params && params.items;
  var addedIds = [],
      updatedIds = [],
      removedIds = [],
      oldItems = [],
      updatedItems = [],
      removedItems = [];

  if (ids && this._data) {
    switch (event) {
      case 'add':
        // filter the ids of the added items
        for (i = 0, len = ids.length; i < len; i++) {
          id = ids[i];
          item = this.get(id);
          if (item) {
            this._ids[id] = true;
            addedIds.push(id);
          }
        }

        break;

      case 'update':
        // determine the event from the views viewpoint: an updated
        // item can be added, updated, or removed from this view.
        for (i = 0, len = ids.length; i < len; i++) {
          id = ids[i];
          item = this.get(id);

          if (item) {
            if (this._ids[id]) {
              updatedIds.push(id);
              updatedItems.push(params.data[i]);
              oldItems.push(params.oldData[i]);
            } else {
              this._ids[id] = true;
              addedIds.push(id);
            }
          } else {
            if (this._ids[id]) {
              delete this._ids[id];
              removedIds.push(id);
              removedItems.push(params.oldData[i]);
            } else {
              // nothing interesting for me :-(
            }
          }
        }

        break;

      case 'remove':
        // filter the ids of the removed items
        for (i = 0, len = ids.length; i < len; i++) {
          id = ids[i];
          if (this._ids[id]) {
            delete this._ids[id];
            removedIds.push(id);
            removedItems.push(params.oldData[i]);
          }
        }

        break;
    }

    this.length += addedIds.length - removedIds.length;

    if (addedIds.length) {
      this._trigger('add', { items: addedIds }, senderId);
    }
    if (updatedIds.length) {
      this._trigger('update', { items: updatedIds, oldData: oldItems, data: updatedItems }, senderId);
    }
    if (removedIds.length) {
      this._trigger('remove', { items: removedIds, oldData: removedItems }, senderId);
    }
  }
};

// copy subscription functionality from DataSet
DataView.prototype.on = DataSet.prototype.on;
DataView.prototype.off = DataSet.prototype.off;
DataView.prototype._trigger = DataSet.prototype._trigger;

// TODO: make these functions deprecated (replaced with `on` and `off` since version 0.5)
DataView.prototype.subscribe = DataView.prototype.on;
DataView.prototype.unsubscribe = DataView.prototype.off;

module.exports = DataView;

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;
/**
 * Created by Alex on 11/6/2014.
 */

// https://github.com/umdjs/umd/blob/master/returnExports.js#L40-L60
// if the module has no dependencies, the above pattern can be simplified to
(function (root, factory) {
  if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else if (typeof exports === 'object') {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.keycharm = factory();
  }
}(this, function () {

  function keycharm(options) {
    var preventDefault = options && options.preventDefault || false;

    var container = options && options.container || window;

    var _exportFunctions = {};
    var _bound = {keydown:{}, keyup:{}};
    var _keys = {};
    var i;

    // a - z
    for (i = 97; i <= 122; i++) {_keys[String.fromCharCode(i)] = {code:65 + (i - 97), shift: false};}
    // A - Z
    for (i = 65; i <= 90; i++) {_keys[String.fromCharCode(i)] = {code:i, shift: true};}
    // 0 - 9
    for (i = 0;  i <= 9;   i++) {_keys['' + i] = {code:48 + i, shift: false};}
    // F1 - F12
    for (i = 1;  i <= 12;   i++) {_keys['F' + i] = {code:111 + i, shift: false};}
    // num0 - num9
    for (i = 0;  i <= 9;   i++) {_keys['num' + i] = {code:96 + i, shift: false};}

    // numpad misc
    _keys['num*'] = {code:106, shift: false};
    _keys['num+'] = {code:107, shift: false};
    _keys['num-'] = {code:109, shift: false};
    _keys['num/'] = {code:111, shift: false};
    _keys['num.'] = {code:110, shift: false};
    // arrows
    _keys['left']  = {code:37, shift: false};
    _keys['up']    = {code:38, shift: false};
    _keys['right'] = {code:39, shift: false};
    _keys['down']  = {code:40, shift: false};
    // extra keys
    _keys['space'] = {code:32, shift: false};
    _keys['enter'] = {code:13, shift: false};
    _keys['shift'] = {code:16, shift: undefined};
    _keys['esc']   = {code:27, shift: false};
    _keys['backspace'] = {code:8, shift: false};
    _keys['tab']       = {code:9, shift: false};
    _keys['ctrl']      = {code:17, shift: false};
    _keys['alt']       = {code:18, shift: false};
    _keys['delete']    = {code:46, shift: false};
    _keys['pageup']    = {code:33, shift: false};
    _keys['pagedown']  = {code:34, shift: false};
    // symbols
    _keys['=']     = {code:187, shift: false};
    _keys['-']     = {code:189, shift: false};
    _keys[']']     = {code:221, shift: false};
    _keys['[']     = {code:219, shift: false};



    var down = function(event) {handleEvent(event,'keydown');};
    var up = function(event) {handleEvent(event,'keyup');};

    // handle the actualy bound key with the event
    var handleEvent = function(event,type) {
      if (_bound[type][event.keyCode] !== undefined) {
        var bound = _bound[type][event.keyCode];
        for (var i = 0; i < bound.length; i++) {
          if (bound[i].shift === undefined) {
            bound[i].fn(event);
          }
          else if (bound[i].shift == true && event.shiftKey == true) {
            bound[i].fn(event);
          }
          else if (bound[i].shift == false && event.shiftKey == false) {
            bound[i].fn(event);
          }
        }

        if (preventDefault == true) {
          event.preventDefault();
        }
      }
    };

    // bind a key to a callback
    _exportFunctions.bind = function(key, callback, type) {
      if (type === undefined) {
        type = 'keydown';
      }
      if (_keys[key] === undefined) {
        throw new Error("unsupported key: " + key);
      }
      if (_bound[type][_keys[key].code] === undefined) {
        _bound[type][_keys[key].code] = [];
      }
      _bound[type][_keys[key].code].push({fn:callback, shift:_keys[key].shift});
    };


    // bind all keys to a call back (demo purposes)
    _exportFunctions.bindAll = function(callback, type) {
      if (type === undefined) {
        type = 'keydown';
      }
      for (var key in _keys) {
        if (_keys.hasOwnProperty(key)) {
          _exportFunctions.bind(key,callback,type);
        }
      }
    };

    // get the key label from an event
    _exportFunctions.getKey = function(event) {
      for (var key in _keys) {
        if (_keys.hasOwnProperty(key)) {
          if (event.shiftKey == true && _keys[key].shift == true && event.keyCode == _keys[key].code) {
            return key;
          }
          else if (event.shiftKey == false && _keys[key].shift == false && event.keyCode == _keys[key].code) {
            return key;
          }
          else if (event.keyCode == _keys[key].code && key == 'shift') {
            return key;
          }
        }
      }
      return "unknown key, currently not supported";
    };

    // unbind either a specific callback from a key or all of them (by leaving callback undefined)
    _exportFunctions.unbind = function(key, callback, type) {
      if (type === undefined) {
        type = 'keydown';
      }
      if (_keys[key] === undefined) {
        throw new Error("unsupported key: " + key);
      }
      if (callback !== undefined) {
        var newBindings = [];
        var bound = _bound[type][_keys[key].code];
        if (bound !== undefined) {
          for (var i = 0; i < bound.length; i++) {
            if (!(bound[i].fn == callback && bound[i].shift == _keys[key].shift)) {
              newBindings.push(_bound[type][_keys[key].code][i]);
            }
          }
        }
        _bound[type][_keys[key].code] = newBindings;
      }
      else {
        _bound[type][_keys[key].code] = [];
      }
    };

    // reset all bound variables.
    _exportFunctions.reset = function() {
      _bound = {keydown:{}, keyup:{}};
    };

    // unbind all listeners and reset all variables.
    _exportFunctions.destroy = function() {
      _bound = {keydown:{}, keyup:{}};
      container.removeEventListener('keydown', down, true);
      container.removeEventListener('keyup', up, true);
    };

    // create listeners.
    container.addEventListener('keydown',down,true);
    container.addEventListener('keyup',up,true);

    // return the public functions.
    return _exportFunctions;
  }

  return keycharm;
}));




/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _NodeBase2 = __webpack_require__(16);

var _NodeBase3 = _interopRequireDefault(_NodeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * NOTE: This is a bad base class
 *
 * Child classes are:
 *
 *   Image       - uses *only* image methods
 *   Circle      - uses *only* _drawRawCircle
 *   CircleImage - uses all
 *
 * TODO: Refactor, move _drawRawCircle to different module, derive Circle from NodeBase
 *       Rename this to ImageBase
 *       Consolidate common code in Image and CircleImage to base class
 *
 * @extends NodeBase
 */
var CircleImageBase = function (_NodeBase) {
  (0, _inherits3['default'])(CircleImageBase, _NodeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function CircleImageBase(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, CircleImageBase);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (CircleImageBase.__proto__ || (0, _getPrototypeOf2['default'])(CircleImageBase)).call(this, options, body, labelModule));

    _this.labelOffset = 0;
    _this.selected = false;
    return _this;
  }

  /**
   *
   * @param {Object} options
   * @param {Object} [imageObj]
   * @param {Object} [imageObjAlt]
   */


  (0, _createClass3['default'])(CircleImageBase, [{
    key: 'setOptions',
    value: function setOptions(options, imageObj, imageObjAlt) {
      this.options = options;

      if (!(imageObj === undefined && imageObjAlt === undefined)) {
        this.setImages(imageObj, imageObjAlt);
      }
    }

    /**
     * Set the images for this node.
     *
     * The images can be updated after the initial setting of options;
     * therefore, this method needs to be reentrant.
     *
     * For correct working in error cases, it is necessary to properly set
     * field 'nodes.brokenImage' in the options.
     *
     * @param {Image} imageObj  required; main image to show for this node
     * @param {Image|undefined} imageObjAlt optional; image to show when node is selected
     */

  }, {
    key: 'setImages',
    value: function setImages(imageObj, imageObjAlt) {
      if (imageObjAlt && this.selected) {
        this.imageObj = imageObjAlt;
        this.imageObjAlt = imageObj;
      } else {
        this.imageObj = imageObj;
        this.imageObjAlt = imageObjAlt;
      }
    }

    /**
     * Set selection and switch between the base and the selected image.
     *
     * Do the switch only if imageObjAlt exists.
     *
     * @param {boolean} selected value of new selected state for current node
     */

  }, {
    key: 'switchImages',
    value: function switchImages(selected) {
      var selection_changed = selected && !this.selected || !selected && this.selected;
      this.selected = selected; // Remember new selection

      if (this.imageObjAlt !== undefined && selection_changed) {
        var imageTmp = this.imageObj;
        this.imageObj = this.imageObjAlt;
        this.imageObjAlt = imageTmp;
      }
    }

    /**
     * Adjust the node dimensions for a loaded image.
     *
     * Pre: this.imageObj is valid
     */

  }, {
    key: '_resizeImage',
    value: function _resizeImage() {
      var width, height;

      if (this.options.shapeProperties.useImageSize === false) {
        // Use the size property
        var ratio_width = 1;
        var ratio_height = 1;

        // Only calculate the proper ratio if both width and height not zero
        if (this.imageObj.width && this.imageObj.height) {
          if (this.imageObj.width > this.imageObj.height) {
            ratio_width = this.imageObj.width / this.imageObj.height;
          } else {
            ratio_height = this.imageObj.height / this.imageObj.width;
          }
        }

        width = this.options.size * 2 * ratio_width;
        height = this.options.size * 2 * ratio_height;
      } else {
        // Use the image size
        width = this.imageObj.width;
        height = this.imageObj.height;
      }

      this.width = width;
      this.height = height;
      this.radius = 0.5 * this.width;
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {ArrowOptions} values
     * @private
     */

  }, {
    key: '_drawRawCircle',
    value: function _drawRawCircle(ctx, x, y, values) {
      this.initContextForDraw(ctx, values);
      ctx.circle(x, y, values.size);
      this.performFill(ctx, values);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     * @private
     */

  }, {
    key: '_drawImageAtPosition',
    value: function _drawImageAtPosition(ctx, values) {
      if (this.imageObj.width != 0) {
        // draw the image
        ctx.globalAlpha = 1.0;

        // draw shadow if enabled
        this.enableShadow(ctx, values);

        var factor = 1;
        if (this.options.shapeProperties.interpolation === true) {
          factor = this.imageObj.width / this.width / this.body.view.scale;
        }

        this.imageObj.drawImageAtPosition(ctx, factor, this.left, this.top, this.width, this.height);

        // disable shadows for other elements.
        this.disableShadow(ctx, values);
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @private
     */

  }, {
    key: '_drawImageLabel',
    value: function _drawImageLabel(ctx, x, y, selected, hover) {
      var yLabel;
      var offset = 0;

      if (this.height !== undefined) {
        offset = this.height * 0.5;
        var labelDimensions = this.labelModule.getTextSize(ctx, selected, hover);
        if (labelDimensions.lineCount >= 1) {
          offset += labelDimensions.height / 2;
        }
      }

      yLabel = y + offset;

      if (this.options.label) {
        this.labelOffset = offset;
      }
      this.labelModule.draw(ctx, x, yLabel, selected, hover, 'hanging');
    }
  }]);
  return CircleImageBase;
}(_NodeBase3['default']);

exports['default'] = CircleImageBase;

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.printStyle = undefined;

var _stringify = __webpack_require__(23);

var _stringify2 = _interopRequireDefault(_stringify);

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

var _keys = __webpack_require__(9);

var _keys2 = _interopRequireDefault(_keys);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);

var errorFound = false;
var allOptions = void 0;
var printStyle = 'background: #FFeeee; color: #dd0000';
/**
 *  Used to validate options.
 */

var Validator = function () {
  /**
   * @ignore
   */
  function Validator() {
    (0, _classCallCheck3['default'])(this, Validator);
  }

  /**
   * Main function to be called
   * @param {Object} options
   * @param {Object} referenceOptions
   * @param {Object} subObject
   * @returns {boolean}
   * @static
   */


  (0, _createClass3['default'])(Validator, null, [{
    key: 'validate',
    value: function validate(options, referenceOptions, subObject) {
      errorFound = false;
      allOptions = referenceOptions;
      var usedOptions = referenceOptions;
      if (subObject !== undefined) {
        usedOptions = referenceOptions[subObject];
      }
      Validator.parse(options, usedOptions, []);
      return errorFound;
    }

    /**
     * Will traverse an object recursively and check every value
     * @param {Object} options
     * @param {Object} referenceOptions
     * @param {array} path    | where to look for the actual option
     * @static
     */

  }, {
    key: 'parse',
    value: function parse(options, referenceOptions, path) {
      for (var option in options) {
        if (options.hasOwnProperty(option)) {
          Validator.check(option, options, referenceOptions, path);
        }
      }
    }

    /**
     * Check every value. If the value is an object, call the parse function on that object.
     * @param {string} option
     * @param {Object} options
     * @param {Object} referenceOptions
     * @param {array} path    | where to look for the actual option
     * @static
     */

  }, {
    key: 'check',
    value: function check(option, options, referenceOptions, path) {
      if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
        Validator.getSuggestion(option, referenceOptions, path);
        return;
      }

      var referenceOption = option;
      var is_object = true;

      if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
        // NOTE: This only triggers if the __any__ is in the top level of the options object.
        //       THAT'S A REALLY BAD PLACE TO ALLOW IT!!!!
        // TODO: Examine if needed, remove if possible

        // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
        referenceOption = '__any__';

        // if the any-subgroup is not a predefined object in the configurator,
        // we do not look deeper into the object.
        is_object = Validator.getType(options[option]) === 'object';
      } else {
        // Since all options in the reference are objects, we can check whether
        // they are supposed to be the object to look for the __type__ field.
        // if this is an object, we check if the correct type has been supplied to account for shorthand options.
      }

      var refOptionObj = referenceOptions[referenceOption];
      if (is_object && refOptionObj.__type__ !== undefined) {
        refOptionObj = refOptionObj.__type__;
      }

      Validator.checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path);
    }

    /**
     *
     * @param {string}  option           | the option property
     * @param {Object}  options          | The supplied options object
     * @param {Object}  referenceOptions | The reference options containing all options and their allowed formats
     * @param {string}  referenceOption  | Usually this is the same as option, except when handling an __any__ tag.
     * @param {string}  refOptionObj     | This is the type object from the reference options
     * @param {Array}   path             | where in the object is the option
     * @static
     */

  }, {
    key: 'checkFields',
    value: function checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
      var log = function log(message) {
        console.log('%c' + message + Validator.printLocation(path, option), printStyle);
      };

      var optionType = Validator.getType(options[option]);
      var refOptionType = refOptionObj[optionType];

      if (refOptionType !== undefined) {
        // if the type is correct, we check if it is supposed to be one of a few select values
        if (Validator.getType(refOptionType) === 'array' && refOptionType.indexOf(options[option]) === -1) {
          log('Invalid option detected in "' + option + '".' + ' Allowed values are:' + Validator.print(refOptionType) + ' not "' + options[option] + '". ');
          errorFound = true;
        } else if (optionType === 'object' && referenceOption !== '__any__') {
          path = util.copyAndExtendArray(path, option);
          Validator.parse(options[option], referenceOptions[referenceOption], path);
        }
      } else if (refOptionObj['any'] === undefined) {
        // type of the field is incorrect and the field cannot be any
        log('Invalid type received for "' + option + '". Expected: ' + Validator.print((0, _keys2['default'])(refOptionObj)) + '. Received [' + optionType + '] "' + options[option] + '"');
        errorFound = true;
      }
    }

    /**
     *
     * @param {Object|boolean|number|string|Array.<number>|Date|Node|Moment|undefined|null} object
     * @returns {string}
     * @static
     */

  }, {
    key: 'getType',
    value: function getType(object) {
      var type = typeof object === 'undefined' ? 'undefined' : (0, _typeof3['default'])(object);

      if (type === 'object') {
        if (object === null) {
          return 'null';
        }
        if (object instanceof Boolean) {
          return 'boolean';
        }
        if (object instanceof Number) {
          return 'number';
        }
        if (object instanceof String) {
          return 'string';
        }
        if (Array.isArray(object)) {
          return 'array';
        }
        if (object instanceof Date) {
          return 'date';
        }
        if (object.nodeType !== undefined) {
          return 'dom';
        }
        if (object._isAMomentObject === true) {
          return 'moment';
        }
        return 'object';
      } else if (type === 'number') {
        return 'number';
      } else if (type === 'boolean') {
        return 'boolean';
      } else if (type === 'string') {
        return 'string';
      } else if (type === undefined) {
        return 'undefined';
      }
      return type;
    }

    /**
     * @param {string} option
     * @param {Object} options
     * @param {Array.<string>} path
     * @static
     */

  }, {
    key: 'getSuggestion',
    value: function getSuggestion(option, options, path) {
      var localSearch = Validator.findInOptions(option, options, path, false);
      var globalSearch = Validator.findInOptions(option, allOptions, [], true);

      var localSearchThreshold = 8;
      var globalSearchThreshold = 4;

      var msg = void 0;
      if (localSearch.indexMatch !== undefined) {
        msg = ' in ' + Validator.printLocation(localSearch.path, option, '') + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n';
      } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
        msg = ' in ' + Validator.printLocation(localSearch.path, option, '') + 'Perhaps it was misplaced? Matching option found at: ' + Validator.printLocation(globalSearch.path, globalSearch.closestMatch, '');
      } else if (localSearch.distance <= localSearchThreshold) {
        msg = '. Did you mean "' + localSearch.closestMatch + '"?' + Validator.printLocation(localSearch.path, option);
      } else {
        msg = '. Did you mean one of these: ' + Validator.print((0, _keys2['default'])(options)) + Validator.printLocation(path, option);
      }

      console.log('%cUnknown option detected: "' + option + '"' + msg, printStyle);
      errorFound = true;
    }

    /**
     * traverse the options in search for a match.
     * @param {string} option
     * @param {Object} options
     * @param {Array} path    | where to look for the actual option
     * @param {boolean} [recursive=false]
     * @returns {{closestMatch: string, path: Array, distance: number}}
     * @static
     */

  }, {
    key: 'findInOptions',
    value: function findInOptions(option, options, path) {
      var recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

      var min = 1e9;
      var closestMatch = '';
      var closestMatchPath = [];
      var lowerCaseOption = option.toLowerCase();
      var indexMatch = undefined;
      // eslint-disable-next-line guard-for-in
      for (var op in options) {
        var distance = void 0;
        if (options[op].__type__ !== undefined && recursive === true) {
          var result = Validator.findInOptions(option, options[op], util.copyAndExtendArray(path, op));
          if (min > result.distance) {
            closestMatch = result.closestMatch;
            closestMatchPath = result.path;
            min = result.distance;
            indexMatch = result.indexMatch;
          }
        } else {
          if (op.toLowerCase().indexOf(lowerCaseOption) !== -1) {
            indexMatch = op;
          }
          distance = Validator.levenshteinDistance(option, op);
          if (min > distance) {
            closestMatch = op;
            closestMatchPath = util.copyArray(path);
            min = distance;
          }
        }
      }
      return {
        closestMatch: closestMatch,
        path: closestMatchPath,
        distance: min,
        indexMatch: indexMatch
      };
    }

    /**
     * @param {Array.<string>} path
     * @param {Object} option
     * @param {string} prefix
     * @returns {String}
     * @static
     */

  }, {
    key: 'printLocation',
    value: function printLocation(path, option) {
      var prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Problem value found at: \n';

      var str = '\n\n' + prefix + 'options = {\n';
      for (var i = 0; i < path.length; i++) {
        for (var j = 0; j < i + 1; j++) {
          str += '  ';
        }
        str += path[i] + ': {\n';
      }
      for (var _j = 0; _j < path.length + 1; _j++) {
        str += '  ';
      }
      str += option + '\n';
      for (var _i = 0; _i < path.length + 1; _i++) {
        for (var _j2 = 0; _j2 < path.length - _i; _j2++) {
          str += '  ';
        }
        str += '}\n';
      }
      return str + '\n\n';
    }

    /**
     * @param {Object} options
     * @returns {String}
     * @static
     */

  }, {
    key: 'print',
    value: function print(options) {
      return (0, _stringify2['default'])(options).replace(/(\")|(\[)|(\])|(,"__type__")/g, '').replace(/(\,)/g, ', ');
    }

    /**
     *  Compute the edit distance between the two given strings
     * http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
     *
     * Copyright (c) 2011 Andrei Mackenzie
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
     *
     * @param {string} a
     * @param {string} b
     * @returns {Array.<Array.<number>>}}
     * @static
     */

  }, {
    key: 'levenshteinDistance',
    value: function levenshteinDistance(a, b) {
      if (a.length === 0) return b.length;
      if (b.length === 0) return a.length;

      var matrix = [];

      // increment along the first column of each row
      var i;
      for (i = 0; i <= b.length; i++) {
        matrix[i] = [i];
      }

      // increment each column in the first row
      var j;
      for (j = 0; j <= a.length; j++) {
        matrix[0][j] = j;
      }

      // Fill in the rest of the matrix
      for (i = 1; i <= b.length; i++) {
        for (j = 1; j <= a.length; j++) {
          if (b.charAt(i - 1) == a.charAt(j - 1)) {
            matrix[i][j] = matrix[i - 1][j - 1];
          } else {
            matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1, // substitution
            Math.min(matrix[i][j - 1] + 1, // insertion
            matrix[i - 1][j] + 1)); // deletion
          }
        }
      }

      return matrix[b.length][a.length];
    }
  }]);
  return Validator;
}();

exports['default'] = Validator;
exports.printStyle = printStyle;

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _stringify = __webpack_require__(23);

var _stringify2 = _interopRequireDefault(_stringify);

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

var _create = __webpack_require__(31);

var _create2 = _interopRequireDefault(_create);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);
var Label = __webpack_require__(77)['default'];
var ComponentUtil = __webpack_require__(35)['default'];
var CubicBezierEdge = __webpack_require__(166)['default'];
var BezierEdgeDynamic = __webpack_require__(168)['default'];
var BezierEdgeStatic = __webpack_require__(169)['default'];
var StraightEdge = __webpack_require__(170)['default'];

/**
 * An edge connects two nodes and has a specific direction.
 */

var Edge = function () {
  /**
   * @param {Object} options        values specific to this edge, must contain at least 'from' and 'to'
   * @param {Object} body           shared state from Network instance
   * @param {Object} globalOptions  options from the EdgesHandler instance
   * @param {Object} defaultOptions default options from the EdgeHandler instance. Value and reference are constant
   */
  function Edge(options, body, globalOptions, defaultOptions) {
    (0, _classCallCheck3['default'])(this, Edge);

    if (body === undefined) {
      throw new Error('No body provided');
    }

    // Since globalOptions is constant in values as well as reference,
    // Following needs to be done only once.

    this.options = util.bridgeObject(globalOptions);
    this.globalOptions = globalOptions;
    this.defaultOptions = defaultOptions;
    this.body = body;

    // initialize variables
    this.id = undefined;
    this.fromId = undefined;
    this.toId = undefined;
    this.selected = false;
    this.hover = false;
    this.labelDirty = true;

    this.baseWidth = this.options.width;
    this.baseFontSize = this.options.font.size;

    this.from = undefined; // a node
    this.to = undefined; // a node

    this.edgeType = undefined;

    this.connected = false;

    this.labelModule = new Label(this.body, this.options, true /* It's an edge label */
    );
    this.setOptions(options);
  }

  /**
   * Set or overwrite options for the edge
   * @param {Object} options  an object with options
   * @returns {null|boolean} null if no options, boolean if date changed
   */


  (0, _createClass3['default'])(Edge, [{
    key: 'setOptions',
    value: function setOptions(options) {
      if (!options) {
        return;
      }

      Edge.parseOptions(this.options, options, true, this.globalOptions);

      if (options.id !== undefined) {
        this.id = options.id;
      }
      if (options.from !== undefined) {
        this.fromId = options.from;
      }
      if (options.to !== undefined) {
        this.toId = options.to;
      }
      if (options.title !== undefined) {
        this.title = options.title;
      }
      if (options.value !== undefined) {
        options.value = parseFloat(options.value);
      }

      var pile = [options, this.options, this.defaultOptions];
      this.chooser = ComponentUtil.choosify('edge', pile);

      // update label Module
      this.updateLabelModule(options);

      var dataChanged = this.updateEdgeType();

      // if anything has been updates, reset the selection width and the hover width
      this._setInteractionWidths();

      // A node is connected when it has a from and to node that both exist in the network.body.nodes.
      this.connect();

      if (options.hidden !== undefined || options.physics !== undefined) {
        dataChanged = true;
      }

      return dataChanged;
    }

    /**
     *
     * @param {Object} parentOptions
     * @param {Object} newOptions
     * @param {boolean} [allowDeletion=false]
     * @param {Object} [globalOptions={}]
     * @param {boolean} [copyFromGlobals=false]
     */

  }, {
    key: 'getFormattingValues',


    /**
     *
     * @returns {ArrowOptions}
     */
    value: function getFormattingValues() {
      var toArrow = this.options.arrows.to === true || this.options.arrows.to.enabled === true;
      var fromArrow = this.options.arrows.from === true || this.options.arrows.from.enabled === true;
      var middleArrow = this.options.arrows.middle === true || this.options.arrows.middle.enabled === true;
      var inheritsColor = this.options.color.inherit;
      var values = {
        toArrow: toArrow,
        toArrowScale: this.options.arrows.to.scaleFactor,
        toArrowType: this.options.arrows.to.type,
        middleArrow: middleArrow,
        middleArrowScale: this.options.arrows.middle.scaleFactor,
        middleArrowType: this.options.arrows.middle.type,
        fromArrow: fromArrow,
        fromArrowScale: this.options.arrows.from.scaleFactor,
        fromArrowType: this.options.arrows.from.type,
        arrowStrikethrough: this.options.arrowStrikethrough,
        color: inheritsColor ? undefined : this.options.color.color,
        inheritsColor: inheritsColor,
        opacity: this.options.color.opacity,
        hidden: this.options.hidden,
        length: this.options.length,
        shadow: this.options.shadow.enabled,
        shadowColor: this.options.shadow.color,
        shadowSize: this.options.shadow.size,
        shadowX: this.options.shadow.x,
        shadowY: this.options.shadow.y,
        dashes: this.options.dashes,
        width: this.options.width,
        background: this.options.background.enabled,
        backgroundColor: this.options.background.color,
        backgroundSize: this.options.background.size,
        backgroundDashes: this.options.background.dashes
      };
      if (this.selected || this.hover) {
        if (this.chooser === true) {
          if (this.selected) {
            var selectedWidth = this.options.selectionWidth;
            if (typeof selectedWidth === 'function') {
              values.width = selectedWidth(values.width);
            } else if (typeof selectedWidth === 'number') {
              values.width += selectedWidth;
            }
            values.width = Math.max(values.width, 0.3 / this.body.view.scale);
            values.color = this.options.color.highlight;
            values.shadow = this.options.shadow.enabled;
          } else if (this.hover) {
            var hoverWidth = this.options.hoverWidth;
            if (typeof hoverWidth === 'function') {
              values.width = hoverWidth(values.width);
            } else if (typeof hoverWidth === 'number') {
              values.width += hoverWidth;
            }
            values.width = Math.max(values.width, 0.3 / this.body.view.scale);
            values.color = this.options.color.hover;
            values.shadow = this.options.shadow.enabled;
          }
        } else if (typeof this.chooser === 'function') {
          this.chooser(values, this.options.id, this.selected, this.hover);
          if (values.color !== undefined) {
            values.inheritsColor = false;
          }
          if (values.shadow === false) {
            if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
              values.shadow = true;
            }
          }
        }
      } else {
        values.shadow = this.options.shadow.enabled;
        values.width = Math.max(values.width, 0.3 / this.body.view.scale);
      }
      return values;
    }

    /**
     * update the options in the label module
     *
     * @param {Object} options
     */

  }, {
    key: 'updateLabelModule',
    value: function updateLabelModule(options) {
      var pile = [options, this.options, this.globalOptions, // Currently set global edge options
      this.defaultOptions];

      this.labelModule.update(this.options, pile);

      if (this.labelModule.baseSize !== undefined) {
        this.baseFontSize = this.labelModule.baseSize;
      }
    }

    /**
     * update the edge type, set the options
     * @returns {boolean}
     */

  }, {
    key: 'updateEdgeType',
    value: function updateEdgeType() {
      var smooth = this.options.smooth;
      var dataChanged = false;
      var changeInType = true;
      if (this.edgeType !== undefined) {
        if (this.edgeType instanceof BezierEdgeDynamic && smooth.enabled === true && smooth.type === 'dynamic' || this.edgeType instanceof CubicBezierEdge && smooth.enabled === true && smooth.type === 'cubicBezier' || this.edgeType instanceof BezierEdgeStatic && smooth.enabled === true && smooth.type !== 'dynamic' && smooth.type !== 'cubicBezier' || this.edgeType instanceof StraightEdge && smooth.type.enabled === false) {
          changeInType = false;
        }
        if (changeInType === true) {
          dataChanged = this.cleanup();
        }
      }
      if (changeInType === true) {
        if (smooth.enabled === true) {
          if (smooth.type === 'dynamic') {
            dataChanged = true;
            this.edgeType = new BezierEdgeDynamic(this.options, this.body, this.labelModule);
          } else if (smooth.type === 'cubicBezier') {
            this.edgeType = new CubicBezierEdge(this.options, this.body, this.labelModule);
          } else {
            this.edgeType = new BezierEdgeStatic(this.options, this.body, this.labelModule);
          }
        } else {
          this.edgeType = new StraightEdge(this.options, this.body, this.labelModule);
        }
      } else {
        // if nothing changes, we just set the options.
        this.edgeType.setOptions(this.options);
      }
      return dataChanged;
    }

    /**
     * Connect an edge to its nodes
     */

  }, {
    key: 'connect',
    value: function connect() {
      this.disconnect();

      this.from = this.body.nodes[this.fromId] || undefined;
      this.to = this.body.nodes[this.toId] || undefined;
      this.connected = this.from !== undefined && this.to !== undefined;

      if (this.connected === true) {
        this.from.attachEdge(this);
        this.to.attachEdge(this);
      } else {
        if (this.from) {
          this.from.detachEdge(this);
        }
        if (this.to) {
          this.to.detachEdge(this);
        }
      }

      this.edgeType.connect();
    }

    /**
     * Disconnect an edge from its nodes
     */

  }, {
    key: 'disconnect',
    value: function disconnect() {
      if (this.from) {
        this.from.detachEdge(this);
        this.from = undefined;
      }
      if (this.to) {
        this.to.detachEdge(this);
        this.to = undefined;
      }

      this.connected = false;
    }

    /**
     * get the title of this edge.
     * @return {string} title    The title of the edge, or undefined when no title
     *                           has been set.
     */

  }, {
    key: 'getTitle',
    value: function getTitle() {
      return this.title;
    }

    /**
     * check if this node is selecte
     * @return {boolean} selected   True if node is selected, else false
     */

  }, {
    key: 'isSelected',
    value: function isSelected() {
      return this.selected;
    }

    /**
     * Retrieve the value of the edge. Can be undefined
     * @return {number} value
     */

  }, {
    key: 'getValue',
    value: function getValue() {
      return this.options.value;
    }

    /**
     * Adjust the value range of the edge. The edge will adjust it's width
     * based on its value.
     * @param {number} min
     * @param {number} max
     * @param {number} total
     */

  }, {
    key: 'setValueRange',
    value: function setValueRange(min, max, total) {
      if (this.options.value !== undefined) {
        var scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
        var widthDiff = this.options.scaling.max - this.options.scaling.min;
        if (this.options.scaling.label.enabled === true) {
          var fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
          this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
        }
        this.options.width = this.options.scaling.min + scale * widthDiff;
      } else {
        this.options.width = this.baseWidth;
        this.options.font.size = this.baseFontSize;
      }

      this._setInteractionWidths();
      this.updateLabelModule();
    }

    /**
     *
     * @private
     */

  }, {
    key: '_setInteractionWidths',
    value: function _setInteractionWidths() {
      if (typeof this.options.hoverWidth === 'function') {
        this.edgeType.hoverWidth = this.options.hoverWidth(this.options.width);
      } else {
        this.edgeType.hoverWidth = this.options.hoverWidth + this.options.width;
      }
      if (typeof this.options.selectionWidth === 'function') {
        this.edgeType.selectionWidth = this.options.selectionWidth(this.options.width);
      } else {
        this.edgeType.selectionWidth = this.options.selectionWidth + this.options.width;
      }
    }

    /**
     * Redraw a edge
     * Draw this edge in the given canvas
     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
     * @param {CanvasRenderingContext2D}   ctx
     */

  }, {
    key: 'draw',
    value: function draw(ctx) {
      var values = this.getFormattingValues();
      if (values.hidden) {
        return;
      }

      // get the via node from the edge type
      var viaNode = this.edgeType.getViaNode();
      var arrowData = {};

      // restore edge targets to defaults
      this.edgeType.fromPoint = this.edgeType.from;
      this.edgeType.toPoint = this.edgeType.to;

      // from and to arrows give a different end point for edges. we set them here
      if (values.fromArrow) {
        arrowData.from = this.edgeType.getArrowData(ctx, 'from', viaNode, this.selected, this.hover, values);
        if (values.arrowStrikethrough === false) this.edgeType.fromPoint = arrowData.from.core;
      }
      if (values.toArrow) {
        arrowData.to = this.edgeType.getArrowData(ctx, 'to', viaNode, this.selected, this.hover, values);
        if (values.arrowStrikethrough === false) this.edgeType.toPoint = arrowData.to.core;
      }

      // the middle arrow depends on the line, which can depend on the to and from arrows so we do this one lastly.
      if (values.middleArrow) {
        arrowData.middle = this.edgeType.getArrowData(ctx, 'middle', viaNode, this.selected, this.hover, values);
      }

      // draw everything
      this.edgeType.drawLine(ctx, values, this.selected, this.hover, viaNode);
      this.drawArrows(ctx, arrowData, values);
      this.drawLabel(ctx, viaNode);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {Object} arrowData
     * @param {ArrowOptions} values
     */

  }, {
    key: 'drawArrows',
    value: function drawArrows(ctx, arrowData, values) {
      if (values.fromArrow) {
        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.from);
      }
      if (values.middleArrow) {
        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.middle);
      }
      if (values.toArrow) {
        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.to);
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {Node} viaNode
     */

  }, {
    key: 'drawLabel',
    value: function drawLabel(ctx, viaNode) {
      if (this.options.label !== undefined) {
        // set style
        var node1 = this.from;
        var node2 = this.to;

        if (this.labelModule.differentState(this.selected, this.hover)) {
          this.labelModule.getTextSize(ctx, this.selected, this.hover);
        }

        if (node1.id != node2.id) {
          this.labelModule.pointToSelf = false;
          var point = this.edgeType.getPoint(0.5, viaNode);
          ctx.save();

          var rotationPoint = this._getRotation(ctx);
          if (rotationPoint.angle != 0) {
            ctx.translate(rotationPoint.x, rotationPoint.y);
            ctx.rotate(rotationPoint.angle);
          }

          // draw the label
          this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);

          /*
          // Useful debug code: draw a border around the label
          // This should **not** be enabled in production!
          var size = this.labelModule.getSize();; // ;; intentional so lint catches it
          ctx.strokeStyle = "#ff0000";
          ctx.strokeRect(size.left, size.top, size.width, size.height);
          // End  debug code
          */

          ctx.restore();
        } else {
          // Ignore the orientations.
          this.labelModule.pointToSelf = true;
          var x, y;
          var radius = this.options.selfReferenceSize;
          if (node1.shape.width > node1.shape.height) {
            x = node1.x + node1.shape.width * 0.5;
            y = node1.y - radius;
          } else {
            x = node1.x + radius;
            y = node1.y - node1.shape.height * 0.5;
          }
          point = this._pointOnCircle(x, y, radius, 0.125);
          this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);
        }
      }
    }

    /**
     * Determine all visual elements of this edge instance, in which the given
     * point falls within the bounding shape.
     *
     * @param {point} point
     * @returns {Array.<edgeClickItem|edgeLabelClickItem>} list with the items which are on the point
     */

  }, {
    key: 'getItemsOnPoint',
    value: function getItemsOnPoint(point) {
      var ret = [];

      if (this.labelModule.visible()) {
        var rotationPoint = this._getRotation();
        if (ComponentUtil.pointInRect(this.labelModule.getSize(), point, rotationPoint)) {
          ret.push({ edgeId: this.id, labelId: 0 });
        }
      }

      var obj = {
        left: point.x,
        top: point.y
      };

      if (this.isOverlappingWith(obj)) {
        ret.push({ edgeId: this.id });
      }

      return ret;
    }

    /**
     * Check if this object is overlapping with the provided object
     * @param {Object} obj   an object with parameters left, top
     * @return {boolean}     True if location is located on the edge
     */

  }, {
    key: 'isOverlappingWith',
    value: function isOverlappingWith(obj) {
      if (this.connected) {
        var distMax = 10;
        var xFrom = this.from.x;
        var yFrom = this.from.y;
        var xTo = this.to.x;
        var yTo = this.to.y;
        var xObj = obj.left;
        var yObj = obj.top;

        var dist = this.edgeType.getDistanceToEdge(xFrom, yFrom, xTo, yTo, xObj, yObj);

        return dist < distMax;
      } else {
        return false;
      }
    }

    /**
     * Determine the rotation point, if any.
     *
     * @param {CanvasRenderingContext2D} [ctx] if passed, do a recalculation of the label size
     * @returns {rotationPoint} the point to rotate around and the angle in radians to rotate
     * @private
     */

  }, {
    key: '_getRotation',
    value: function _getRotation(ctx) {
      var viaNode = this.edgeType.getViaNode();
      var point = this.edgeType.getPoint(0.5, viaNode);

      if (ctx !== undefined) {
        this.labelModule.calculateLabelSize(ctx, this.selected, this.hover, point.x, point.y);
      }

      var ret = {
        x: point.x,
        y: this.labelModule.size.yLine,
        angle: 0
      };

      if (!this.labelModule.visible()) {
        return ret; // Don't even bother doing the atan2, there's nothing to draw
      }

      if (this.options.font.align === 'horizontal') {
        return ret; // No need to calculate angle
      }

      var dy = this.from.y - this.to.y;
      var dx = this.from.x - this.to.x;
      var angle = Math.atan2(dy, dx); // radians

      // rotate so that label is readable
      if (angle < -1 && dx < 0 || angle > 0 && dx < 0) {
        angle += Math.PI;
      }
      ret.angle = angle;

      return ret;
    }

    /**
     * Get a point on a circle
     * @param {number} x
     * @param {number} y
     * @param {number} radius
     * @param {number} percentage Value between 0 (line start) and 1 (line end)
     * @return {Object} point
     * @private
     */

  }, {
    key: '_pointOnCircle',
    value: function _pointOnCircle(x, y, radius, percentage) {
      var angle = percentage * 2 * Math.PI;
      return {
        x: x + radius * Math.cos(angle),
        y: y - radius * Math.sin(angle)
      };
    }

    /**
     * Sets selected state to true
     */

  }, {
    key: 'select',
    value: function select() {
      this.selected = true;
    }

    /**
     * Sets selected state to false
     */

  }, {
    key: 'unselect',
    value: function unselect() {
      this.selected = false;
    }

    /**
     * cleans all required things on delete
     * @returns {*}
     */

  }, {
    key: 'cleanup',
    value: function cleanup() {
      return this.edgeType.cleanup();
    }

    /**
     * Remove edge from the list and perform necessary cleanup.
     */

  }, {
    key: 'remove',
    value: function remove() {
      this.cleanup();
      this.disconnect();
      delete this.body.edges[this.id];
    }

    /**
     * Check if both connecting nodes exist
     * @returns {boolean}
     */

  }, {
    key: 'endPointsValid',
    value: function endPointsValid() {
      return this.body.nodes[this.fromId] !== undefined && this.body.nodes[this.toId] !== undefined;
    }
  }], [{
    key: 'parseOptions',
    value: function parseOptions(parentOptions, newOptions) {
      var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var copyFromGlobals = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

      var fields = ['arrowStrikethrough', 'id', 'from', 'hidden', 'hoverWidth', 'labelHighlightBold', 'length', 'line', 'opacity', 'physics', 'scaling', 'selectionWidth', 'selfReferenceSize', 'to', 'title', 'value', 'width', 'font', 'chosen', 'widthConstraint'];

      // only deep extend the items in the field array. These do not have shorthand.
      util.selectiveDeepExtend(fields, parentOptions, newOptions, allowDeletion);

      // Only copy label if it's a legal value.
      if (ComponentUtil.isValidLabel(newOptions.label)) {
        parentOptions.label = newOptions.label;
      } else {
        parentOptions.label = undefined;
      }

      util.mergeOptions(parentOptions, newOptions, 'smooth', globalOptions);
      util.mergeOptions(parentOptions, newOptions, 'shadow', globalOptions);
      util.mergeOptions(parentOptions, newOptions, 'background', globalOptions);

      if (newOptions.dashes !== undefined && newOptions.dashes !== null) {
        parentOptions.dashes = newOptions.dashes;
      } else if (allowDeletion === true && newOptions.dashes === null) {
        parentOptions.dashes = (0, _create2['default'])(globalOptions.dashes); // this sets the pointer of the option back to the global option.
      }

      // set the scaling newOptions
      if (newOptions.scaling !== undefined && newOptions.scaling !== null) {
        if (newOptions.scaling.min !== undefined) {
          parentOptions.scaling.min = newOptions.scaling.min;
        }
        if (newOptions.scaling.max !== undefined) {
          parentOptions.scaling.max = newOptions.scaling.max;
        }
        util.mergeOptions(parentOptions.scaling, newOptions.scaling, 'label', globalOptions.scaling);
      } else if (allowDeletion === true && newOptions.scaling === null) {
        parentOptions.scaling = (0, _create2['default'])(globalOptions.scaling); // this sets the pointer of the option back to the global option.
      }

      // handle multiple input cases for arrows
      if (newOptions.arrows !== undefined && newOptions.arrows !== null) {
        if (typeof newOptions.arrows === 'string') {
          var arrows = newOptions.arrows.toLowerCase();
          parentOptions.arrows.to.enabled = arrows.indexOf('to') != -1;
          parentOptions.arrows.middle.enabled = arrows.indexOf('middle') != -1;
          parentOptions.arrows.from.enabled = arrows.indexOf('from') != -1;
        } else if ((0, _typeof3['default'])(newOptions.arrows) === 'object') {
          util.mergeOptions(parentOptions.arrows, newOptions.arrows, 'to', globalOptions.arrows);
          util.mergeOptions(parentOptions.arrows, newOptions.arrows, 'middle', globalOptions.arrows);
          util.mergeOptions(parentOptions.arrows, newOptions.arrows, 'from', globalOptions.arrows);
        } else {
          throw new Error('The arrow newOptions can only be an object or a string. Refer to the documentation. You used:' + (0, _stringify2['default'])(newOptions.arrows));
        }
      } else if (allowDeletion === true && newOptions.arrows === null) {
        parentOptions.arrows = (0, _create2['default'])(globalOptions.arrows); // this sets the pointer of the option back to the global option.
      }

      // handle multiple input cases for color
      if (newOptions.color !== undefined && newOptions.color !== null) {
        var fromColor = newOptions.color;
        var toColor = parentOptions.color;

        // If passed, fill in values from default options - required in the case of no prototype bridging
        if (copyFromGlobals) {
          util.deepExtend(toColor, globalOptions.color, false, allowDeletion);
        } else {
          // Clear local properties - need to do it like this in order to retain prototype bridges
          for (var i in toColor) {
            if (toColor.hasOwnProperty(i)) {
              delete toColor[i];
            }
          }
        }

        if (util.isString(toColor)) {
          toColor.color = toColor;
          toColor.highlight = toColor;
          toColor.hover = toColor;
          toColor.inherit = false;
          if (fromColor.opacity === undefined) {
            toColor.opacity = 1.0; // set default
          }
        } else {
          var colorsDefined = false;
          if (fromColor.color !== undefined) {
            toColor.color = fromColor.color;
            colorsDefined = true;
          }
          if (fromColor.highlight !== undefined) {
            toColor.highlight = fromColor.highlight;
            colorsDefined = true;
          }
          if (fromColor.hover !== undefined) {
            toColor.hover = fromColor.hover;
            colorsDefined = true;
          }
          if (fromColor.inherit !== undefined) {
            toColor.inherit = fromColor.inherit;
          }
          if (fromColor.opacity !== undefined) {
            toColor.opacity = Math.min(1, Math.max(0, fromColor.opacity));
          }

          if (colorsDefined === true) {
            toColor.inherit = false;
          } else {
            if (toColor.inherit === undefined) {
              toColor.inherit = 'from'; // Set default
            }
          }
        }
      } else if (allowDeletion === true && newOptions.color === null) {
        parentOptions.color = util.bridgeObject(globalOptions.color); // set the object back to the global options
      }

      if (allowDeletion === true && newOptions.font === null) {
        parentOptions.font = util.bridgeObject(globalOptions.font); // set the object back to the global options
      }
    }
  }]);
  return Edge;
}();

exports['default'] = Edge;

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _EdgeBase2 = __webpack_require__(79);

var _EdgeBase3 = _interopRequireDefault(_EdgeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * The Base Class for all Bezier edges. Bezier curves are used to model smooth
 * gradual curves in paths between nodes.
 *
 * @extends EdgeBase
 */
var BezierEdgeBase = function (_EdgeBase) {
  (0, _inherits3['default'])(BezierEdgeBase, _EdgeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function BezierEdgeBase(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, BezierEdgeBase);
    return (0, _possibleConstructorReturn3['default'])(this, (BezierEdgeBase.__proto__ || (0, _getPrototypeOf2['default'])(BezierEdgeBase)).call(this, options, body, labelModule));
  }

  /**
   * This function uses binary search to look for the point where the bezier curve crosses the border of the node.
   *
   * @param {Node} nearNode
   * @param {CanvasRenderingContext2D} ctx
   * @param {Node} viaNode
   * @returns {*}
   * @private
   */


  (0, _createClass3['default'])(BezierEdgeBase, [{
    key: '_findBorderPositionBezier',
    value: function _findBorderPositionBezier(nearNode, ctx) {
      var viaNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this._getViaCoordinates();

      var maxIterations = 10;
      var iteration = 0;
      var low = 0;
      var high = 1;
      var pos, angle, distanceToBorder, distanceToPoint, difference;
      var threshold = 0.2;
      var node = this.to;
      var from = false;
      if (nearNode.id === this.from.id) {
        node = this.from;
        from = true;
      }

      while (low <= high && iteration < maxIterations) {
        var middle = (low + high) * 0.5;

        pos = this.getPoint(middle, viaNode);
        angle = Math.atan2(node.y - pos.y, node.x - pos.x);
        distanceToBorder = node.distanceToBorder(ctx, angle);
        distanceToPoint = Math.sqrt(Math.pow(pos.x - node.x, 2) + Math.pow(pos.y - node.y, 2));
        difference = distanceToBorder - distanceToPoint;
        if (Math.abs(difference) < threshold) {
          break; // found
        } else if (difference < 0) {
          // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
          if (from === false) {
            low = middle;
          } else {
            high = middle;
          }
        } else {
          if (from === false) {
            high = middle;
          } else {
            low = middle;
          }
        }

        iteration++;
      }
      pos.t = middle;

      return pos;
    }

    /**
     * Calculate the distance between a point (x3,y3) and a line segment from
     * (x1,y1) to (x2,y2).
     * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
     * @param {number} x1 from x
     * @param {number} y1 from y
     * @param {number} x2 to x
     * @param {number} y2 to y
     * @param {number} x3 point to check x
     * @param {number} y3 point to check y
     * @param {Node} via
     * @returns {number}
     * @private
     */

  }, {
    key: '_getDistanceToBezierEdge',
    value: function _getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, via) {
      // x3,y3 is the point
      var minDistance = 1e9;
      var distance = void 0;
      var i = void 0,
          t = void 0,
          x = void 0,
          y = void 0;
      var lastX = x1;
      var lastY = y1;
      for (i = 1; i < 10; i++) {
        t = 0.1 * i;
        x = Math.pow(1 - t, 2) * x1 + 2 * t * (1 - t) * via.x + Math.pow(t, 2) * x2;
        y = Math.pow(1 - t, 2) * y1 + 2 * t * (1 - t) * via.y + Math.pow(t, 2) * y2;
        if (i > 0) {
          distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);
          minDistance = distance < minDistance ? distance : minDistance;
        }
        lastX = x;
        lastY = y;
      }

      return minDistance;
    }

    /**
     * Draw a bezier curve between two nodes
     *
     * The method accepts zero, one or two control points.
     * Passing zero control points just draws a straight line
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {Object}           values   | options for shadow drawing
     * @param {Object|undefined} viaNode1 | first control point for curve drawing
     * @param {Object|undefined} viaNode2 | second control point for curve drawing
     *
     * @protected
     */

  }, {
    key: '_bezierCurve',
    value: function _bezierCurve(ctx, values, viaNode1, viaNode2) {
      var hasNode1 = viaNode1 !== undefined && viaNode1.x !== undefined;
      var hasNode2 = viaNode2 !== undefined && viaNode2.x !== undefined;

      ctx.beginPath();
      ctx.moveTo(this.fromPoint.x, this.fromPoint.y);

      if (hasNode1 && hasNode2) {
        ctx.bezierCurveTo(viaNode1.x, viaNode1.y, viaNode2.x, viaNode2.y, this.toPoint.x, this.toPoint.y);
      } else if (hasNode1) {
        ctx.quadraticCurveTo(viaNode1.x, viaNode1.y, this.toPoint.x, this.toPoint.y);
      } else {
        // fallback to normal straight edge
        ctx.lineTo(this.toPoint.x, this.toPoint.y);
      }
      // draw a background
      this.drawBackground(ctx, values);

      // draw shadow if enabled
      this.enableShadow(ctx, values);
      ctx.stroke();
      this.disableShadow(ctx, values);
    }

    /**
     *
     * @returns {*|{x, y}|{x: undefined, y: undefined}}
     */

  }, {
    key: 'getViaNode',
    value: function getViaNode() {
      return this._getViaCoordinates();
    }
  }]);
  return BezierEdgeBase;
}(_EdgeBase3['default']);

exports['default'] = BezierEdgeBase;

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);

/**
 * Utility Class
 */

var NetworkUtil = function () {
  /**
   * @ignore
   */
  function NetworkUtil() {
    (0, _classCallCheck3['default'])(this, NetworkUtil);
  }

  /**
   * Find the center position of the network considering the bounding boxes
   *
   * @param {Array.<Node>} allNodes
   * @param {Array.<Node>} [specificNodes=[]]
   * @returns {{minX: number, maxX: number, minY: number, maxY: number}}
   * @static
   */


  (0, _createClass3['default'])(NetworkUtil, null, [{
    key: 'getRange',
    value: function getRange(allNodes) {
      var specificNodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

      var minY = 1e9,
          maxY = -1e9,
          minX = 1e9,
          maxX = -1e9,
          node;
      if (specificNodes.length > 0) {
        for (var i = 0; i < specificNodes.length; i++) {
          node = allNodes[specificNodes[i]];
          if (minX > node.shape.boundingBox.left) {
            minX = node.shape.boundingBox.left;
          }
          if (maxX < node.shape.boundingBox.right) {
            maxX = node.shape.boundingBox.right;
          }
          if (minY > node.shape.boundingBox.top) {
            minY = node.shape.boundingBox.top;
          } // top is negative, bottom is positive
          if (maxY < node.shape.boundingBox.bottom) {
            maxY = node.shape.boundingBox.bottom;
          } // top is negative, bottom is positive
        }
      }

      if (minX === 1e9 && maxX === -1e9 && minY === 1e9 && maxY === -1e9) {
        ;minY = 0, maxY = 0, minX = 0, maxX = 0;
      }
      return { minX: minX, maxX: maxX, minY: minY, maxY: maxY };
    }

    /**
     * Find the center position of the network
     *
     * @param {Array.<Node>} allNodes
     * @param {Array.<Node>} [specificNodes=[]]
     * @returns {{minX: number, maxX: number, minY: number, maxY: number}}
     * @static
     */

  }, {
    key: 'getRangeCore',
    value: function getRangeCore(allNodes) {
      var specificNodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

      var minY = 1e9,
          maxY = -1e9,
          minX = 1e9,
          maxX = -1e9,
          node;
      if (specificNodes.length > 0) {
        for (var i = 0; i < specificNodes.length; i++) {
          node = allNodes[specificNodes[i]];
          if (minX > node.x) {
            minX = node.x;
          }
          if (maxX < node.x) {
            maxX = node.x;
          }
          if (minY > node.y) {
            minY = node.y;
          } // top is negative, bottom is positive
          if (maxY < node.y) {
            maxY = node.y;
          } // top is negative, bottom is positive
        }
      }

      if (minX === 1e9 && maxX === -1e9 && minY === 1e9 && maxY === -1e9) {
        ;minY = 0, maxY = 0, minX = 0, maxX = 0;
      }
      return { minX: minX, maxX: maxX, minY: minY, maxY: maxY };
    }

    /**
     * @param {object} range = {minX: minX, maxX: maxX, minY: minY, maxY: maxY};
     * @returns {{x: number, y: number}}
     * @static
     */

  }, {
    key: 'findCenter',
    value: function findCenter(range) {
      return {
        x: 0.5 * (range.maxX + range.minX),
        y: 0.5 * (range.maxY + range.minY)
      };
    }

    /**
     * This returns a clone of the options or options of the edge or node to be used for construction of new edges or check functions for new nodes.
     * @param {vis.Item} item
     * @param {'node'|undefined} type
     * @returns {{}}
     * @static
     */

  }, {
    key: 'cloneOptions',
    value: function cloneOptions(item, type) {
      var clonedOptions = {};
      if (type === undefined || type === 'node') {
        util.deepExtend(clonedOptions, item.options, true);
        clonedOptions.x = item.x;
        clonedOptions.y = item.y;
        clonedOptions.amountOfConnections = item.edges.length;
      } else {
        util.deepExtend(clonedOptions, item.options, true);
      }
      return clonedOptions;
    }
  }]);
  return NetworkUtil;
}();

exports['default'] = NetworkUtil;

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(86), __esModule: true };

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__(38);
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var LIBRARY = __webpack_require__(27);
var $export = __webpack_require__(11);
var redefine = __webpack_require__(64);
var hide = __webpack_require__(19);
var Iterators = __webpack_require__(25);
var $iterCreate = __webpack_require__(91);
var setToStringTag = __webpack_require__(46);
var getPrototypeOf = __webpack_require__(66);
var ITERATOR = __webpack_require__(8)('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  $iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = $native || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!LIBRARY && typeof IteratorPrototype[ITERATOR] != 'function') hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    hide(proto, ITERATOR, $default);
  }
  // Plug for library
  Iterators[NAME] = $default;
  Iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) redefine(proto, key, methods[key]);
    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

// optional / simple context binding
var aFunction = __webpack_require__(90);
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = !__webpack_require__(13) && !__webpack_require__(22)(function () {
  return Object.defineProperty(__webpack_require__(63)('div'), 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(21);
var document = __webpack_require__(10).document;
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(19);


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(14);
var toIObject = __webpack_require__(18);
var arrayIndexOf = __webpack_require__(93)(false);
var IE_PROTO = __webpack_require__(43)('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
var has = __webpack_require__(14);
var toObject = __webpack_require__(30);
var IE_PROTO = __webpack_require__(43)('IE_PROTO');
var ObjectProto = Object.prototype;

module.exports = Object.getPrototypeOf || function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectProto : null;
};


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

// getting tag from 19.1.3.6 Object.prototype.toString()
var cof = __webpack_require__(38);
var TAG = __webpack_require__(8)('toStringTag');
// ES3 wrong here
var ARG = cof(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (e) { /* empty */ }
};

module.exports = function (it) {
  var O, T, B;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
    // builtinTag case
    : ARG ? cof(O)
    // ES3 arguments fallback
    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
};


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

// most Object methods by ES6 should accept primitives
var $export = __webpack_require__(11);
var core = __webpack_require__(6);
var fails = __webpack_require__(22);
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
var $keys = __webpack_require__(65);
var hiddenKeys = __webpack_require__(45).concat('length', 'prototype');

exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return $keys(O, hiddenKeys);
};


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

var pIE = __webpack_require__(32);
var createDesc = __webpack_require__(28);
var toIObject = __webpack_require__(18);
var toPrimitive = __webpack_require__(40);
var has = __webpack_require__(14);
var IE8_DOM_DEFINE = __webpack_require__(62);
var gOPD = Object.getOwnPropertyDescriptor;

exports.f = __webpack_require__(13) ? gOPD : function getOwnPropertyDescriptor(O, P) {
  O = toIObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return gOPD(O, P);
  } catch (e) { /* empty */ }
  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
};


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// first check if moment.js is already loaded in the browser window, if so,
// use this instance. Else, load via commonjs.
module.exports = typeof window !== 'undefined' && window['moment'] || __webpack_require__(116);

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * A queue
 * @param {Object} options
 *            Available options:
 *            - delay: number    When provided, the queue will be flushed
 *                               automatically after an inactivity of this delay
 *                               in milliseconds.
 *                               Default value is null.
 *            - max: number      When the queue exceeds the given maximum number
 *                               of entries, the queue is flushed automatically.
 *                               Default value of max is Infinity.
 * @constructor Queue
 */
function Queue(options) {
  // options
  this.delay = null;
  this.max = Infinity;

  // properties
  this._queue = [];
  this._timeout = null;
  this._extended = null;

  this.setOptions(options);
}

/**
 * Update the configuration of the queue
 * @param {Object} options
 *            Available options:
 *            - delay: number    When provided, the queue will be flushed
 *                               automatically after an inactivity of this delay
 *                               in milliseconds.
 *                               Default value is null.
 *            - max: number      When the queue exceeds the given maximum number
 *                               of entries, the queue is flushed automatically.
 *                               Default value of max is Infinity.
 */
Queue.prototype.setOptions = function (options) {
  if (options && typeof options.delay !== 'undefined') {
    this.delay = options.delay;
  }
  if (options && typeof options.max !== 'undefined') {
    this.max = options.max;
  }

  this._flushIfNeeded();
};

/**
 * Extend an object with queuing functionality.
 * The object will be extended with a function flush, and the methods provided
 * in options.replace will be replaced with queued ones.
 * @param {Object} object
 * @param {Object} options
 *            Available options:
 *            - replace: Array.<string>
 *                               A list with method names of the methods
 *                               on the object to be replaced with queued ones.
 *            - delay: number    When provided, the queue will be flushed
 *                               automatically after an inactivity of this delay
 *                               in milliseconds.
 *                               Default value is null.
 *            - max: number      When the queue exceeds the given maximum number
 *                               of entries, the queue is flushed automatically.
 *                               Default value of max is Infinity.
 * @return {Queue} Returns the created queue
 */
Queue.extend = function (object, options) {
  var queue = new Queue(options);

  if (object.flush !== undefined) {
    throw new Error('Target object already has a property flush');
  }
  object.flush = function () {
    queue.flush();
  };

  var methods = [{
    name: 'flush',
    original: undefined
  }];

  if (options && options.replace) {
    for (var i = 0; i < options.replace.length; i++) {
      var name = options.replace[i];
      methods.push({
        name: name,
        original: object[name]
      });
      queue.replace(object, name);
    }
  }

  queue._extended = {
    object: object,
    methods: methods
  };

  return queue;
};

/**
 * Destroy the queue. The queue will first flush all queued actions, and in
 * case it has extended an object, will restore the original object.
 */
Queue.prototype.destroy = function () {
  this.flush();

  if (this._extended) {
    var object = this._extended.object;
    var methods = this._extended.methods;
    for (var i = 0; i < methods.length; i++) {
      var method = methods[i];
      if (method.original) {
        object[method.name] = method.original;
      } else {
        delete object[method.name];
      }
    }
    this._extended = null;
  }
};

/**
 * Replace a method on an object with a queued version
 * @param {Object} object   Object having the method
 * @param {string} method   The method name
 */
Queue.prototype.replace = function (object, method) {
  var me = this;
  var original = object[method];
  if (!original) {
    throw new Error('Method ' + method + ' undefined');
  }

  object[method] = function () {
    // create an Array with the arguments
    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args[i] = arguments[i];
    }

    // add this call to the queue
    me.queue({
      args: args,
      fn: original,
      context: this
    });
  };
};

/**
 * Queue a call
 * @param {function | {fn: function, args: Array} | {fn: function, args: Array, context: Object}} entry
 */
Queue.prototype.queue = function (entry) {
  if (typeof entry === 'function') {
    this._queue.push({ fn: entry });
  } else {
    this._queue.push(entry);
  }

  this._flushIfNeeded();
};

/**
 * Check whether the queue needs to be flushed
 * @private
 */
Queue.prototype._flushIfNeeded = function () {
  // flush when the maximum is exceeded.
  if (this._queue.length > this.max) {
    this.flush();
  }

  // flush after a period of inactivity when a delay is configured
  clearTimeout(this._timeout);
  if (this.queue.length > 0 && typeof this.delay === 'number') {
    var me = this;
    this._timeout = setTimeout(function () {
      me.flush();
    }, this.delay);
  }
};

/**
 * Flush all queued calls
 */
Queue.prototype.flush = function () {
  while (this._queue.length > 0) {
    var entry = this._queue.shift();
    entry.fn.apply(entry.context || entry.fn, entry.args || []);
  }
};

module.exports = Queue;

/***/ }),
/* 73 */
/***/ (function(module, exports) {


/**
 * Expose `Emitter`.
 */

module.exports = Emitter;

/**
 * Initialize a new `Emitter`.
 *
 * @api public
 */

function Emitter(obj) {
  if (obj) return mixin(obj);
};

/**
 * Mixin the emitter properties.
 *
 * @param {Object} obj
 * @return {Object}
 * @api private
 */

function mixin(obj) {
  for (var key in Emitter.prototype) {
    obj[key] = Emitter.prototype[key];
  }
  return obj;
}

/**
 * Listen on the given `event` with `fn`.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.on =
Emitter.prototype.addEventListener = function(event, fn){
  this._callbacks = this._callbacks || {};
  (this._callbacks[event] = this._callbacks[event] || [])
    .push(fn);
  return this;
};

/**
 * Adds an `event` listener that will be invoked a single
 * time then automatically removed.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.once = function(event, fn){
  var self = this;
  this._callbacks = this._callbacks || {};

  function on() {
    self.off(event, on);
    fn.apply(this, arguments);
  }

  on.fn = fn;
  this.on(event, on);
  return this;
};

/**
 * Remove the given callback for `event` or all
 * registered callbacks.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.off =
Emitter.prototype.removeListener =
Emitter.prototype.removeAllListeners =
Emitter.prototype.removeEventListener = function(event, fn){
  this._callbacks = this._callbacks || {};

  // all
  if (0 == arguments.length) {
    this._callbacks = {};
    return this;
  }

  // specific event
  var callbacks = this._callbacks[event];
  if (!callbacks) return this;

  // remove all handlers
  if (1 == arguments.length) {
    delete this._callbacks[event];
    return this;
  }

  // remove specific handler
  var cb;
  for (var i = 0; i < callbacks.length; i++) {
    cb = callbacks[i];
    if (cb === fn || cb.fn === fn) {
      callbacks.splice(i, 1);
      break;
    }
  }
  return this;
};

/**
 * Emit `event` with the given args.
 *
 * @param {String} event
 * @param {Mixed} ...
 * @return {Emitter}
 */

Emitter.prototype.emit = function(event){
  this._callbacks = this._callbacks || {};
  var args = [].slice.call(arguments, 1)
    , callbacks = this._callbacks[event];

  if (callbacks) {
    callbacks = callbacks.slice(0);
    for (var i = 0, len = callbacks.length; i < len; ++i) {
      callbacks[i].apply(this, args);
    }
  }

  return this;
};

/**
 * Return array of callbacks for `event`.
 *
 * @param {String} event
 * @return {Array}
 * @api public
 */

Emitter.prototype.listeners = function(event){
  this._callbacks = this._callbacks || {};
  return this._callbacks[event] || [];
};

/**
 * Check if this emitter has `event` handlers.
 *
 * @param {String} event
 * @return {Boolean}
 * @api public
 */

Emitter.prototype.hasListeners = function(event){
  return !! this.listeners(event).length;
};


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _create = __webpack_require__(31);

var _create2 = _interopRequireDefault(_create);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Parse a text source containing data in DOT language into a JSON object.
 * The object contains two lists: one with nodes and one with edges.
 *
 * DOT language reference: http://www.graphviz.org/doc/info/lang.html
 *
 * DOT language attributes: http://graphviz.org/content/attrs
 *
 * @param {string} data     Text containing a graph in DOT-notation
 * @return {Object} graph   An object containing two parameters:
 *                          {Object[]} nodes
 *                          {Object[]} edges
 *
 * -------------------------------------------
 * TODO
 * ====
 *
 * For label handling, this is an incomplete implementation. From docs (quote #3015):
 *
 * > the escape sequences "\n", "\l" and "\r" divide the label into lines, centered,
 * > left-justified, and right-justified, respectively.
 *
 * Source: http://www.graphviz.org/content/attrs#kescString
 *
 * > As another aid for readability, dot allows double-quoted strings to span multiple physical
 * > lines using the standard C convention of a backslash immediately preceding a newline
 * > character
 * > In addition, double-quoted strings can be concatenated using a '+' operator.
 * > As HTML strings can contain newline characters, which are used solely for formatting,
 * > the language does not allow escaped newlines or concatenation operators to be used
 * > within them.
 *
 * - Currently, only '\\n' is handled
 * - Note that text explicitly says 'labels'; the dot parser currently handles escape
 *   sequences in **all** strings.
 */
function parseDOT(data) {
  dot = data;
  return parseGraph();
}

// mapping of attributes from DOT (the keys) to vis.js (the values)
var NODE_ATTR_MAPPING = {
  fontsize: 'font.size',
  fontcolor: 'font.color',
  labelfontcolor: 'font.color',
  fontname: 'font.face',
  color: ['color.border', 'color.background'],
  fillcolor: 'color.background',
  tooltip: 'title',
  labeltooltip: 'title'
};
var EDGE_ATTR_MAPPING = (0, _create2['default'])(NODE_ATTR_MAPPING);
EDGE_ATTR_MAPPING.color = 'color.color';
EDGE_ATTR_MAPPING.style = 'dashes';

// token types enumeration
var TOKENTYPE = {
  NULL: 0,
  DELIMITER: 1,
  IDENTIFIER: 2,
  UNKNOWN: 3

  // map with all delimiters
};var DELIMITERS = {
  '{': true,
  '}': true,
  '[': true,
  ']': true,
  ';': true,
  '=': true,
  ',': true,

  '->': true,
  '--': true
};

var dot = ''; // current dot file
var index = 0; // current index in dot file
var c = ''; // current token character in expr
var token = ''; // current token
var tokenType = TOKENTYPE.NULL; // type of the token

/**
 * Get the first character from the dot file.
 * The character is stored into the char c. If the end of the dot file is
 * reached, the function puts an empty string in c.
 */
function first() {
  index = 0;
  c = dot.charAt(0);
}

/**
 * Get the next character from the dot file.
 * The character is stored into the char c. If the end of the dot file is
 * reached, the function puts an empty string in c.
 */
function next() {
  index++;
  c = dot.charAt(index);
}

/**
 * Preview the next character from the dot file.
 * @return {string} cNext
 */
function nextPreview() {
  return dot.charAt(index + 1);
}

var regexAlphaNumeric = /[a-zA-Z_0-9.:#]/;
/**
 * Test whether given character is alphabetic or numeric
 * @param {string} c
 * @return {Boolean} isAlphaNumeric
 */
function isAlphaNumeric(c) {
  return regexAlphaNumeric.test(c);
}

/**
 * Merge all options of object b into object b
 * @param {Object} a
 * @param {Object} b
 * @return {Object} a
 */
function merge(a, b) {
  if (!a) {
    a = {};
  }

  if (b) {
    for (var name in b) {
      if (b.hasOwnProperty(name)) {
        a[name] = b[name];
      }
    }
  }
  return a;
}

/**
 * Set a value in an object, where the provided parameter name can be a
 * path with nested parameters. For example:
 *
 *     var obj = {a: 2};
 *     setValue(obj, 'b.c', 3);     // obj = {a: 2, b: {c: 3}}
 *
 * @param {Object} obj
 * @param {string} path  A parameter name or dot-separated parameter path,
 *                      like "color.highlight.border".
 * @param {*} value
 */
function setValue(obj, path, value) {
  var keys = path.split('.');
  var o = obj;
  while (keys.length) {
    var key = keys.shift();
    if (keys.length) {
      // this isn't the end point
      if (!o[key]) {
        o[key] = {};
      }
      o = o[key];
    } else {
      // this is the end point
      o[key] = value;
    }
  }
}

/**
 * Add a node to a graph object. If there is already a node with
 * the same id, their attributes will be merged.
 * @param {Object} graph
 * @param {Object} node
 */
function addNode(graph, node) {
  var i, len;
  var current = null;

  // find root graph (in case of subgraph)
  var graphs = [graph]; // list with all graphs from current graph to root graph
  var root = graph;
  while (root.parent) {
    graphs.push(root.parent);
    root = root.parent;
  }

  // find existing node (at root level) by its id
  if (root.nodes) {
    for (i = 0, len = root.nodes.length; i < len; i++) {
      if (node.id === root.nodes[i].id) {
        current = root.nodes[i];
        break;
      }
    }
  }

  if (!current) {
    // this is a new node
    current = {
      id: node.id
    };
    if (graph.node) {
      // clone default attributes
      current.attr = merge(current.attr, graph.node);
    }
  }

  // add node to this (sub)graph and all its parent graphs
  for (i = graphs.length - 1; i >= 0; i--) {
    var g = graphs[i];

    if (!g.nodes) {
      g.nodes = [];
    }
    if (g.nodes.indexOf(current) === -1) {
      g.nodes.push(current);
    }
  }

  // merge attributes
  if (node.attr) {
    current.attr = merge(current.attr, node.attr);
  }
}

/**
 * Add an edge to a graph object
 * @param {Object} graph
 * @param {Object} edge
 */
function addEdge(graph, edge) {
  if (!graph.edges) {
    graph.edges = [];
  }
  graph.edges.push(edge);
  if (graph.edge) {
    var attr = merge({}, graph.edge); // clone default attributes
    edge.attr = merge(attr, edge.attr); // merge attributes
  }
}

/**
 * Create an edge to a graph object
 * @param {Object} graph
 * @param {string | number | Object} from
 * @param {string | number | Object} to
 * @param {string} type
 * @param {Object | null} attr
 * @return {Object} edge
 */
function createEdge(graph, from, to, type, attr) {
  var edge = {
    from: from,
    to: to,
    type: type
  };

  if (graph.edge) {
    edge.attr = merge({}, graph.edge); // clone default attributes
  }
  edge.attr = merge(edge.attr || {}, attr); // merge attributes

  // Move arrows attribute from attr to edge temporally created in
  // parseAttributeList().
  if (attr != null) {
    if (attr.hasOwnProperty('arrows')) {
      edge['arrows'] = { to: { enabled: true, type: attr.arrows.type } };
      attr['arrows'] = null;
    }
  }
  return edge;
}

/**
 * Get next token in the current dot file.
 * The token and token type are available as token and tokenType
 */
function getToken() {
  tokenType = TOKENTYPE.NULL;
  token = '';

  // skip over whitespaces
  while (c === ' ' || c === '\t' || c === '\n' || c === '\r') {
    // space, tab, enter
    next();
  }

  do {
    var isComment = false;

    // skip comment
    if (c === '#') {
      // find the previous non-space character
      var i = index - 1;
      while (dot.charAt(i) === ' ' || dot.charAt(i) === '\t') {
        i--;
      }
      if (dot.charAt(i) === '\n' || dot.charAt(i) === '') {
        // the # is at the start of a line, this is indeed a line comment
        while (c != '' && c != '\n') {
          next();
        }
        isComment = true;
      }
    }
    if (c === '/' && nextPreview() === '/') {
      // skip line comment
      while (c != '' && c != '\n') {
        next();
      }
      isComment = true;
    }
    if (c === '/' && nextPreview() === '*') {
      // skip block comment
      while (c != '') {
        if (c === '*' && nextPreview() === '/') {
          // end of block comment found. skip these last two characters
          next();
          next();
          break;
        } else {
          next();
        }
      }
      isComment = true;
    }

    // skip over whitespaces
    while (c === ' ' || c === '\t' || c === '\n' || c === '\r') {
      // space, tab, enter
      next();
    }
  } while (isComment);

  // check for end of dot file
  if (c === '') {
    // token is still empty
    tokenType = TOKENTYPE.DELIMITER;
    return;
  }

  // check for delimiters consisting of 2 characters
  var c2 = c + nextPreview();
  if (DELIMITERS[c2]) {
    tokenType = TOKENTYPE.DELIMITER;
    token = c2;
    next();
    next();
    return;
  }

  // check for delimiters consisting of 1 character
  if (DELIMITERS[c]) {
    tokenType = TOKENTYPE.DELIMITER;
    token = c;
    next();
    return;
  }

  // check for an identifier (number or string)
  // TODO: more precise parsing of numbers/strings (and the port separator ':')
  if (isAlphaNumeric(c) || c === '-') {
    token += c;
    next();

    while (isAlphaNumeric(c)) {
      token += c;
      next();
    }
    if (token === 'false') {
      token = false; // convert to boolean
    } else if (token === 'true') {
      token = true; // convert to boolean
    } else if (!isNaN(Number(token))) {
      token = Number(token); // convert to number
    }
    tokenType = TOKENTYPE.IDENTIFIER;
    return;
  }

  // check for a string enclosed by double quotes
  if (c === '"') {
    next();
    while (c != '' && (c != '"' || c === '"' && nextPreview() === '"')) {
      if (c === '"') {
        // skip the escape character
        token += c;
        next();
      } else if (c === '\\' && nextPreview() === 'n') {
        // Honor a newline escape sequence
        token += '\n';
        next();
      } else {
        token += c;
      }
      next();
    }
    if (c != '"') {
      throw newSyntaxError('End of string " expected');
    }
    next();
    tokenType = TOKENTYPE.IDENTIFIER;
    return;
  }

  // something unknown is found, wrong characters, a syntax error
  tokenType = TOKENTYPE.UNKNOWN;
  while (c != '') {
    token += c;
    next();
  }
  throw new SyntaxError('Syntax error in part "' + chop(token, 30) + '"');
}

/**
 * Parse a graph.
 * @returns {Object} graph
 */
function parseGraph() {
  var graph = {};

  first();
  getToken();

  // optional strict keyword
  if (token === 'strict') {
    graph.strict = true;
    getToken();
  }

  // graph or digraph keyword
  if (token === 'graph' || token === 'digraph') {
    graph.type = token;
    getToken();
  }

  // optional graph id
  if (tokenType === TOKENTYPE.IDENTIFIER) {
    graph.id = token;
    getToken();
  }

  // open angle bracket
  if (token != '{') {
    throw newSyntaxError('Angle bracket { expected');
  }
  getToken();

  // statements
  parseStatements(graph);

  // close angle bracket
  if (token != '}') {
    throw newSyntaxError('Angle bracket } expected');
  }
  getToken();

  // end of file
  if (token !== '') {
    throw newSyntaxError('End of file expected');
  }
  getToken();

  // remove temporary default options
  delete graph.node;
  delete graph.edge;
  delete graph.graph;

  return graph;
}

/**
 * Parse a list with statements.
 * @param {Object} graph
 */
function parseStatements(graph) {
  while (token !== '' && token != '}') {
    parseStatement(graph);
    if (token === ';') {
      getToken();
    }
  }
}

/**
 * Parse a single statement. Can be a an attribute statement, node
 * statement, a series of node statements and edge statements, or a
 * parameter.
 * @param {Object} graph
 */
function parseStatement(graph) {
  // parse subgraph
  var subgraph = parseSubgraph(graph);
  if (subgraph) {
    // edge statements
    parseEdge(graph, subgraph);

    return;
  }

  // parse an attribute statement
  var attr = parseAttributeStatement(graph);
  if (attr) {
    return;
  }

  // parse node
  if (tokenType != TOKENTYPE.IDENTIFIER) {
    throw newSyntaxError('Identifier expected');
  }
  var id = token; // id can be a string or a number
  getToken();

  if (token === '=') {
    // id statement
    getToken();
    if (tokenType != TOKENTYPE.IDENTIFIER) {
      throw newSyntaxError('Identifier expected');
    }
    graph[id] = token;
    getToken();
    // TODO: implement comma separated list with "a_list: ID=ID [','] [a_list] "
  } else {
    parseNodeStatement(graph, id);
  }
}

/**
 * Parse a subgraph
 * @param {Object} graph    parent graph object
 * @return {Object | null} subgraph
 */
function parseSubgraph(graph) {
  var subgraph = null;

  // optional subgraph keyword
  if (token === 'subgraph') {
    subgraph = {};
    subgraph.type = 'subgraph';
    getToken();

    // optional graph id
    if (tokenType === TOKENTYPE.IDENTIFIER) {
      subgraph.id = token;
      getToken();
    }
  }

  // open angle bracket
  if (token === '{') {
    getToken();

    if (!subgraph) {
      subgraph = {};
    }
    subgraph.parent = graph;
    subgraph.node = graph.node;
    subgraph.edge = graph.edge;
    subgraph.graph = graph.graph;

    // statements
    parseStatements(subgraph);

    // close angle bracket
    if (token != '}') {
      throw newSyntaxError('Angle bracket } expected');
    }
    getToken();

    // remove temporary default options
    delete subgraph.node;
    delete subgraph.edge;
    delete subgraph.graph;
    delete subgraph.parent;

    // register at the parent graph
    if (!graph.subgraphs) {
      graph.subgraphs = [];
    }
    graph.subgraphs.push(subgraph);
  }

  return subgraph;
}

/**
 * parse an attribute statement like "node [shape=circle fontSize=16]".
 * Available keywords are 'node', 'edge', 'graph'.
 * The previous list with default attributes will be replaced
 * @param {Object} graph
 * @returns {String | null} keyword Returns the name of the parsed attribute
 *                                  (node, edge, graph), or null if nothing
 *                                  is parsed.
 */
function parseAttributeStatement(graph) {
  // attribute statements
  if (token === 'node') {
    getToken();

    // node attributes
    graph.node = parseAttributeList();
    return 'node';
  } else if (token === 'edge') {
    getToken();

    // edge attributes
    graph.edge = parseAttributeList();
    return 'edge';
  } else if (token === 'graph') {
    getToken();

    // graph attributes
    graph.graph = parseAttributeList();
    return 'graph';
  }

  return null;
}

/**
 * parse a node statement
 * @param {Object} graph
 * @param {string | number} id
 */
function parseNodeStatement(graph, id) {
  // node statement
  var node = {
    id: id
  };
  var attr = parseAttributeList();
  if (attr) {
    node.attr = attr;
  }
  addNode(graph, node);

  // edge statements
  parseEdge(graph, id);
}

/**
 * Parse an edge or a series of edges
 * @param {Object} graph
 * @param {string | number} from        Id of the from node
 */
function parseEdge(graph, from) {
  while (token === '->' || token === '--') {
    var to;
    var type = token;
    getToken();

    var subgraph = parseSubgraph(graph);
    if (subgraph) {
      to = subgraph;
    } else {
      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError('Identifier or subgraph expected');
      }
      to = token;
      addNode(graph, {
        id: to
      });
      getToken();
    }

    // parse edge attributes
    var attr = parseAttributeList();

    // create edge
    var edge = createEdge(graph, from, to, type, attr);
    addEdge(graph, edge);

    from = to;
  }
}

/**
 * As explained in [1], graphviz has limitations for combination of
 * arrow[head|tail] and dir. If attribute list includes 'dir',
 * following cases just be supported.
 *   1. both or none + arrowhead, arrowtail
 *   2. forward + arrowhead (arrowtail is not affedted)
 *   3. back + arrowtail (arrowhead is not affected)
 * [1] https://www.graphviz.org/doc/info/attrs.html#h:undir_note
 *
 * This function is called from parseAttributeList() to parse 'dir'
 * attribute with given 'attr_names' and 'attr_list'.
 * @param {Object} attr_names  Array of attribute names
 * @param {Object} attr_list  Array of objects of attribute set
 * @return {Object} attr_list  Updated attr_list
 */
function parseDirAttribute(attr_names, attr_list) {
  var i;
  if (attr_names.includes('dir')) {
    var idx = {}; // get index of 'arrows' and 'dir'
    idx.arrows = {};
    for (i = 0; i < attr_list.length; i++) {
      if (attr_list[i].name === 'arrows') {
        if (attr_list[i].value.to != null) {
          idx.arrows.to = i;
        } else if (attr_list[i].value.from != null) {
          idx.arrows.from = i;
        } else {
          throw newSyntaxError('Invalid value of arrows');
        }
      } else if (attr_list[i].name === 'dir') {
        idx.dir = i;
      }
    }

    // first, add default arrow shape if it is not assigned to avoid error
    var dir_type = attr_list[idx.dir].value;
    if (!attr_names.includes('arrows')) {
      if (dir_type === 'both') {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: 'arrows',
          value: { to: { enabled: true } }
        });
        idx.arrows.to = attr_list.length - 1;
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: 'arrows',
          value: { from: { enabled: true } }
        });
        idx.arrows.from = attr_list.length - 1;
      } else if (dir_type === 'forward') {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: 'arrows',
          value: { to: { enabled: true } }
        });
        idx.arrows.to = attr_list.length - 1;
      } else if (dir_type === 'back') {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: 'arrows',
          value: { from: { enabled: true } }
        });
        idx.arrows.from = attr_list.length - 1;
      } else if (dir_type === 'none') {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: 'arrows',
          value: ''
        });
        idx.arrows.to = attr_list.length - 1;
      } else {
        throw newSyntaxError('Invalid dir type "' + dir_type + '"');
      }
    }

    var from_type;
    var to_type;
    // update 'arrows' attribute from 'dir'.
    if (dir_type === 'both') {
      // both of shapes of 'from' and 'to' are given
      if (idx.arrows.to && idx.arrows.from) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }
        };
        attr_list.splice(idx.arrows.from, 1);

        // shape of 'to' is assigned and use default to 'from'
      } else if (idx.arrows.to) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = 'arrow';
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }

          // only shape of 'from' is assigned and use default for 'to'
        };
      } else if (idx.arrows.from) {
        to_type = 'arrow';
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }
        };
      }
    } else if (dir_type === 'back') {
      // given both of shapes, but use only 'from'
      if (idx.arrows.to && idx.arrows.from) {
        to_type = '';
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }

          // given shape of 'to', but does not use it
        };
      } else if (idx.arrows.to) {
        to_type = '';
        from_type = 'arrow';
        idx.arrows.from = idx.arrows.to;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }

          // assign given 'from' shape
        };
      } else if (idx.arrows.from) {
        to_type = '';
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }
        };
      }

      attr_list[idx.arrows.from] = {
        attr: attr_list[idx.arrows.from].attr,
        name: attr_list[idx.arrows.from].name,
        value: {
          from: {
            enabled: true,
            type: attr_list[idx.arrows.from].value.from.type
          }
        }
      };
    } else if (dir_type === 'none') {
      var idx_arrow;
      if (idx.arrows.to) {
        idx_arrow = idx.arrows.to;
      } else {
        idx_arrow = idx.arrows.from;
      }

      attr_list[idx_arrow] = {
        attr: attr_list[idx_arrow].attr,
        name: attr_list[idx_arrow].name,
        value: ''
      };
    } else if (dir_type === 'forward') {
      // given both of shapes, but use only 'to'
      if (idx.arrows.to && idx.arrows.from) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = '';
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }

          // assign given 'to' shape
        };
      } else if (idx.arrows.to) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = '';
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }

          // given shape of 'from', but does not use it
        };
      } else if (idx.arrows.from) {
        to_type = 'arrow';
        from_type = '';
        idx.arrows.to = idx.arrows.from;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: { enabled: true, type: to_type },
            from: { enabled: true, type: from_type }
          }
        };
      }

      attr_list[idx.arrows.to] = {
        attr: attr_list[idx.arrows.to].attr,
        name: attr_list[idx.arrows.to].name,
        value: {
          to: {
            enabled: true,
            type: attr_list[idx.arrows.to].value.to.type
          }
        }
      };
    } else {
      throw newSyntaxError('Invalid dir type "' + dir_type + '"');
    }

    // remove 'dir' attribute no need anymore
    attr_list.splice(idx.dir, 1);
  }
  return attr_list;
}

/**
 * Parse a set with attributes,
 * for example [label="1.000", shape=solid]
 * @return {Object | null} attr
 */
function parseAttributeList() {
  var i;
  var attr = null;

  // edge styles of dot and vis
  var edgeStyles = {
    dashed: true,
    solid: false,
    dotted: [1, 5]

    /**
     * Define arrow types.
     * vis currently supports types defined in 'arrowTypes'.
     * Details of arrow shapes are described in
     * http://www.graphviz.org/content/arrow-shapes
     */
  };var arrowTypes = {
    dot: 'circle',
    box: 'box',
    crow: 'crow',
    curve: 'curve',
    icurve: 'inv_curve',
    normal: 'triangle',
    inv: 'inv_triangle',
    diamond: 'diamond',
    tee: 'bar',
    vee: 'vee'

    /**
     * 'attr_list' contains attributes for checking if some of them are affected
     * later. For instance, both of 'arrowhead' and 'dir' (edge style defined
     * in DOT) make changes to 'arrows' attribute in vis.
     */
  };var attr_list = new Array();
  var attr_names = new Array(); // used for checking the case.

  // parse attributes
  while (token === '[') {
    getToken();
    attr = {};
    while (token !== '' && token != ']') {
      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError('Attribute name expected');
      }
      var name = token;

      getToken();
      if (token != '=') {
        throw newSyntaxError('Equal sign = expected');
      }
      getToken();

      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError('Attribute value expected');
      }
      var value = token;

      // convert from dot style to vis
      if (name === 'style') {
        value = edgeStyles[value];
      }

      var arrowType;
      if (name === 'arrowhead') {
        arrowType = arrowTypes[value];
        name = 'arrows';
        value = { to: { enabled: true, type: arrowType } };
      }

      if (name === 'arrowtail') {
        arrowType = arrowTypes[value];
        name = 'arrows';
        value = { from: { enabled: true, type: arrowType } };
      }

      attr_list.push({ attr: attr, name: name, value: value });
      attr_names.push(name);

      getToken();
      if (token == ',') {
        getToken();
      }
    }

    if (token != ']') {
      throw newSyntaxError('Bracket ] expected');
    }
    getToken();
  }

  attr_list = parseDirAttribute(attr_names, attr_list);

  // parse 'penwidth'
  var nof_attr_list;
  if (attr_names.includes('penwidth')) {
    var tmp_attr_list = [];

    nof_attr_list = attr_list.length;
    for (i = 0; i < nof_attr_list; i++) {
      // exclude 'width' from attr_list if 'penwidth' exists
      if (attr_list[i].name !== 'width') {
        if (attr_list[i].name === 'penwidth') {
          attr_list[i].name = 'width';
        }
        tmp_attr_list.push(attr_list[i]);
      }
    }
    attr_list = tmp_attr_list;
  }

  nof_attr_list = attr_list.length;
  for (i = 0; i < nof_attr_list; i++) {
    setValue(attr_list[i].attr, attr_list[i].name, attr_list[i].value);
  }

  return attr;
}

/**
 * Create a syntax error with extra information on current token and index.
 * @param {string} message
 * @returns {SyntaxError} err
 */
function newSyntaxError(message) {
  return new SyntaxError(message + ', got "' + chop(token, 30) + '" (char ' + index + ')');
}

/**
 * Chop off text after a maximum length
 * @param {string} text
 * @param {number} maxLength
 * @returns {String}
 */
function chop(text, maxLength) {
  return text.length <= maxLength ? text : text.substr(0, 27) + '...';
}

/**
 * Execute a function fn for each pair of elements in two arrays
 * @param {Array | *} array1
 * @param {Array | *} array2
 * @param {function} fn
 */
function forEach2(array1, array2, fn) {
  if (Array.isArray(array1)) {
    array1.forEach(function (elem1) {
      if (Array.isArray(array2)) {
        array2.forEach(function (elem2) {
          fn(elem1, elem2);
        });
      } else {
        fn(elem1, array2);
      }
    });
  } else {
    if (Array.isArray(array2)) {
      array2.forEach(function (elem2) {
        fn(array1, elem2);
      });
    } else {
      fn(array1, array2);
    }
  }
}

/**
 * Set a nested property on an object
 * When nested objects are missing, they will be created.
 * For example setProp({}, 'font.color', 'red') will return {font: {color: 'red'}}
 * @param {Object} object
 * @param {string} path   A dot separated string like 'font.color'
 * @param {*} value       Value for the property
 * @return {Object} Returns the original object, allows for chaining.
 */
function setProp(object, path, value) {
  var names = path.split('.');
  var prop = names.pop();

  // traverse over the nested objects
  var obj = object;
  for (var i = 0; i < names.length; i++) {
    var name = names[i];
    if (!(name in obj)) {
      obj[name] = {};
    }
    obj = obj[name];
  }

  // set the property value
  obj[prop] = value;

  return object;
}

/**
 * Convert an object with DOT attributes to their vis.js equivalents.
 * @param {Object} attr     Object with DOT attributes
 * @param {Object} mapping
 * @return {Object}         Returns an object with vis.js attributes
 */
function convertAttr(attr, mapping) {
  var converted = {};

  for (var prop in attr) {
    if (attr.hasOwnProperty(prop)) {
      var visProp = mapping[prop];
      if (Array.isArray(visProp)) {
        visProp.forEach(function (visPropI) {
          setProp(converted, visPropI, attr[prop]);
        });
      } else if (typeof visProp === 'string') {
        setProp(converted, visProp, attr[prop]);
      } else {
        setProp(converted, prop, attr[prop]);
      }
    }
  }

  return converted;
}

/**
 * Convert a string containing a graph in DOT language into a map containing
 * with nodes and edges in the format of graph.
 * @param {string} data         Text containing a graph in DOT-notation
 * @return {Object} graphData
 */
function DOTToGraph(data) {
  // parse the DOT file
  var dotData = parseDOT(data);
  var graphData = {
    nodes: [],
    edges: [],
    options: {}

    // copy the nodes
  };if (dotData.nodes) {
    dotData.nodes.forEach(function (dotNode) {
      var graphNode = {
        id: dotNode.id,
        label: String(dotNode.label || dotNode.id)
      };
      merge(graphNode, convertAttr(dotNode.attr, NODE_ATTR_MAPPING));
      if (graphNode.image) {
        graphNode.shape = 'image';
      }
      graphData.nodes.push(graphNode);
    });
  }

  // copy the edges
  if (dotData.edges) {
    /**
     * Convert an edge in DOT format to an edge with VisGraph format
     * @param {Object} dotEdge
     * @returns {Object} graphEdge
     */
    var convertEdge = function convertEdge(dotEdge) {
      var graphEdge = {
        from: dotEdge.from,
        to: dotEdge.to
      };
      merge(graphEdge, convertAttr(dotEdge.attr, EDGE_ATTR_MAPPING));

      // Add arrows attribute to default styled arrow.
      // The reason why default style is not added in parseAttributeList() is
      // because only default is cleared before here.
      if (graphEdge.arrows == null && dotEdge.type === '->') {
        graphEdge.arrows = 'to';
      }

      return graphEdge;
    };

    dotData.edges.forEach(function (dotEdge) {
      var from, to;
      if (dotEdge.from instanceof Object) {
        from = dotEdge.from.nodes;
      } else {
        from = {
          id: dotEdge.from
        };
      }

      if (dotEdge.to instanceof Object) {
        to = dotEdge.to.nodes;
      } else {
        to = {
          id: dotEdge.to
        };
      }

      if (dotEdge.from instanceof Object && dotEdge.from.edges) {
        dotEdge.from.edges.forEach(function (subEdge) {
          var graphEdge = convertEdge(subEdge);
          graphData.edges.push(graphEdge);
        });
      }

      forEach2(from, to, function (from, to) {
        var subEdge = createEdge(graphData, from.id, to.id, dotEdge.type, dotEdge.attr);
        var graphEdge = convertEdge(subEdge);
        graphData.edges.push(graphEdge);
      });

      if (dotEdge.to instanceof Object && dotEdge.to.edges) {
        dotEdge.to.edges.forEach(function (subEdge) {
          var graphEdge = convertEdge(subEdge);
          graphData.edges.push(graphEdge);
        });
      }
    });
  }

  // copy the options
  if (dotData.attr) {
    graphData.options = dotData.attr;
  }

  return graphData;
}

// exports
exports.parseDOT = parseDOT;
exports.DOTToGraph = DOTToGraph;

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 *
 * @param {json} gephiJSON
 * @param {obj} optionsObj
 * @returns {{nodes: Array, edges: Array}}
 */
function parseGephi(gephiJSON, optionsObj) {
  var edges = [];
  var nodes = [];
  var options = {
    edges: {
      inheritColor: false
    },
    nodes: {
      fixed: false,
      parseColor: false
    }
  };

  if (optionsObj !== undefined) {
    if (optionsObj.fixed !== undefined) {
      options.nodes.fixed = optionsObj.fixed;
    }
    if (optionsObj.parseColor !== undefined) {
      options.nodes.parseColor = optionsObj.parseColor;
    }
    if (optionsObj.inheritColor !== undefined) {
      options.edges.inheritColor = optionsObj.inheritColor;
    }
  }

  var gEdges = gephiJSON.edges;
  var gNodes = gephiJSON.nodes;
  for (var i = 0; i < gEdges.length; i++) {
    var edge = {};
    var gEdge = gEdges[i];
    edge['id'] = gEdge.id;
    edge['from'] = gEdge.source;
    edge['to'] = gEdge.target;
    edge['attributes'] = gEdge.attributes;
    edge['label'] = gEdge.label;
    edge['title'] = gEdge.attributes !== undefined ? gEdge.attributes.title : undefined;
    if (gEdge['type'] === 'Directed') {
      edge['arrows'] = 'to';
    }
    //    edge['value'] = gEdge.attributes !== undefined ? gEdge.attributes.Weight : undefined;
    //    edge['width'] = edge['value'] !== undefined ? undefined : edgegEdge.size;
    if (gEdge.color && options.inheritColor === false) {
      edge['color'] = gEdge.color;
    }
    edges.push(edge);
  }

  for (var j = 0; j < gNodes.length; j++) {
    var node = {};
    var gNode = gNodes[j];
    node['id'] = gNode.id;
    node['attributes'] = gNode.attributes;
    node['x'] = gNode.x;
    node['y'] = gNode.y;
    node['label'] = gNode.label;
    node['title'] = gNode.attributes !== undefined ? gNode.attributes.title : gNode.title;
    if (options.nodes.parseColor === true) {
      node['color'] = gNode.color;
    } else {
      node['color'] = gNode.color !== undefined ? {
        background: gNode.color,
        border: gNode.color,
        highlight: { background: gNode.color, border: gNode.color },
        hover: { background: gNode.color, border: gNode.color }
      } : undefined;
    }
    node['size'] = gNode.size;
    node['fixed'] = options.nodes.fixed && gNode.x !== undefined && gNode.y !== undefined;
    nodes.push(node);
  }

  return { nodes: nodes, edges: edges };
}

exports.parseGephi = parseGephi;

/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _CachedImage = __webpack_require__(133);

var _CachedImage2 = _interopRequireDefault(_CachedImage);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * This callback is a callback that accepts an Image.
 * @callback ImageCallback
 * @param {Image} image
 */

/**
 * This class loads images and keeps them stored.
 *
 * @param {ImageCallback} callback
 */
var Images = function () {
  /**
   * @param {ImageCallback} callback
   */
  function Images(callback) {
    (0, _classCallCheck3['default'])(this, Images);

    this.images = {};
    this.imageBroken = {};
    this.callback = callback;
  }

  /**
   * @param {string} url                      The original Url that failed to load, if the broken image is successfully loaded it will be added to the cache using this Url as the key so that subsequent requests for this Url will return the broken image
   * @param {string} brokenUrl                Url the broken image to try and load
   * @param {Image} imageToLoadBrokenUrlOn   The image object
   */


  (0, _createClass3['default'])(Images, [{
    key: '_tryloadBrokenUrl',
    value: function _tryloadBrokenUrl(url, brokenUrl, imageToLoadBrokenUrlOn) {
      //If these parameters aren't specified then exit the function because nothing constructive can be done
      if (url === undefined || imageToLoadBrokenUrlOn === undefined) return;
      if (brokenUrl === undefined) {
        console.warn('No broken url image defined');
        return;
      }

      //Clear the old subscription to the error event and put a new in place that only handle errors in loading the brokenImageUrl
      imageToLoadBrokenUrlOn.onerror = function () {
        console.error('Could not load brokenImage:', brokenUrl);
        // cache item will contain empty image, this should be OK for default
      };

      //Set the source of the image to the brokenUrl, this is actually what kicks off the loading of the broken image
      imageToLoadBrokenUrlOn.image.src = brokenUrl;
    }

    /**
     *
     * @param {vis.Image} imageToRedrawWith
     * @private
     */

  }, {
    key: '_redrawWithImage',
    value: function _redrawWithImage(imageToRedrawWith) {
      if (this.callback) {
        this.callback(imageToRedrawWith);
      }
    }

    /**
     * @param {string} url          Url of the image
     * @param {string} brokenUrl    Url of an image to use if the url image is not found
     * @return {Image} img          The image object
     */

  }, {
    key: 'load',
    value: function load(url, brokenUrl) {
      var _this = this;

      //Try and get the image from the cache, if successful then return the cached image
      var cachedImage = this.images[url];
      if (cachedImage) return cachedImage;

      //Create a new image
      var img = new _CachedImage2['default']();

      // Need to add to cache here, otherwise final return will spawn different copies of the same image,
      // Also, there will be multiple loads of the same image.
      this.images[url] = img;

      //Subscribe to the event that is raised if the image loads successfully
      img.image.onload = function () {
        // Properly init the cached item and then request a redraw
        _this._fixImageCoordinates(img.image);
        img.init();
        _this._redrawWithImage(img);
      };

      //Subscribe to the event that is raised if the image fails to load
      img.image.onerror = function () {
        console.error('Could not load image:', url);
        //Try and load the image specified by the brokenUrl using
        _this._tryloadBrokenUrl(url, brokenUrl, img);
      };

      //Set the source of the image to the url, this is what actually kicks off the loading of the image
      img.image.src = url;

      //Return the new image
      return img;
    }

    /**
     * IE11 fix -- thanks dponch!
     *
     * Local helper function
     * @param {vis.Image} imageToCache
     * @private
     */

  }, {
    key: '_fixImageCoordinates',
    value: function _fixImageCoordinates(imageToCache) {
      if (imageToCache.width === 0) {
        document.body.appendChild(imageToCache);
        imageToCache.width = imageToCache.offsetWidth;
        imageToCache.height = imageToCache.offsetHeight;
        document.body.removeChild(imageToCache);
      }
    }
  }]);
  return Images;
}();

exports['default'] = Images;

/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = __webpack_require__(15);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);
var ComponentUtil = __webpack_require__(35)['default'];
var LabelSplitter = __webpack_require__(139)['default'];

/**
 * List of special styles for multi-fonts
 * @private
 */
var multiFontStyle = ['bold', 'ital', 'boldital', 'mono'];

/**
 * A Label to be used for Nodes or Edges.
 */

var Label = function () {
  /**
   * @param {Object} body
   * @param {Object} options
   * @param {boolean} [edgelabel=false]
   */
  function Label(body, options) {
    var edgelabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    (0, _classCallCheck3['default'])(this, Label);

    this.body = body;
    this.pointToSelf = false;
    this.baseSize = undefined;
    this.fontOptions = {}; // instance variable containing the *instance-local* font options
    this.setOptions(options);
    this.size = { top: 0, left: 0, width: 0, height: 0, yLine: 0 };
    this.isEdgeLabel = edgelabel;
  }

  /**
   * @param {Object} options the options of the parent Node-instance
   */


  (0, _createClass3['default'])(Label, [{
    key: 'setOptions',
    value: function setOptions(options) {
      this.elementOptions = options; // Reference to the options of the parent Node-instance

      this.initFontOptions(options.font);

      if (ComponentUtil.isValidLabel(options.label)) {
        this.labelDirty = true;
      } else {
        // Bad label! Change the option value to prevent bad stuff happening
        options.label = '';
      }

      if (options.font !== undefined && options.font !== null) {
        // font options can be deleted at various levels
        if (typeof options.font === 'string') {
          this.baseSize = this.fontOptions.size;
        } else if ((0, _typeof3['default'])(options.font) === 'object') {
          var size = options.font.size;

          if (size !== undefined) {
            this.baseSize = size;
          }
        }
      }
    }

    /**
     * Init the font Options structure.
     *
     * Member fontOptions serves as an accumulator for the current font options.
     * As such, it needs to be completely separated from the node options.
     *
     * @param {Object} newFontOptions the new font options to process
     * @private
     */

  }, {
    key: 'initFontOptions',
    value: function initFontOptions(newFontOptions) {
      var _this = this;

      // Prepare the multi-font option objects.
      // These will be filled in propagateFonts(), if required
      util.forEach(multiFontStyle, function (style) {
        _this.fontOptions[style] = {};
      });

      // Handle shorthand option, if present
      if (Label.parseFontString(this.fontOptions, newFontOptions)) {
        this.fontOptions.vadjust = 0;
        return;
      }

      // Copy over the non-multifont options, if specified
      util.forEach(newFontOptions, function (prop, n) {
        if (prop !== undefined && prop !== null && (typeof prop === 'undefined' ? 'undefined' : (0, _typeof3['default'])(prop)) !== 'object') {
          _this.fontOptions[n] = prop;
        }
      });
    }

    /**
     * If in-variable is a string, parse it as a font specifier.
     *
     * Note that following is not done here and have to be done after the call:
     * - No number conversion (size)
     * - Not all font options are set (vadjust, mod)
     *
     * @param {Object} outOptions  out-parameter, object in which to store the parse results (if any)
     * @param {Object} inOptions  font options to parse
     * @return {boolean} true if font parsed as string, false otherwise
     * @static
     */

  }, {
    key: 'constrain',


    /**
     * Set the width and height constraints based on 'nearest' value
     *
     * @param {Array} pile array of option objects to consider
     * @returns {object} the actual constraint values to use
     * @private
     */
    value: function constrain(pile) {
      // NOTE: constrainWidth and  constrainHeight never set!
      // NOTE: for edge labels, only 'maxWdt' set
      // Node labels can set all the fields
      var fontOptions = {
        constrainWidth: false,
        maxWdt: -1,
        minWdt: -1,
        constrainHeight: false,
        minHgt: -1,
        valign: 'middle'
      };

      var widthConstraint = util.topMost(pile, 'widthConstraint');
      if (typeof widthConstraint === 'number') {
        fontOptions.maxWdt = Number(widthConstraint);
        fontOptions.minWdt = Number(widthConstraint);
      } else if ((typeof widthConstraint === 'undefined' ? 'undefined' : (0, _typeof3['default'])(widthConstraint)) === 'object') {
        var widthConstraintMaximum = util.topMost(pile, ['widthConstraint', 'maximum']);
        if (typeof widthConstraintMaximum === 'number') {
          fontOptions.maxWdt = Number(widthConstraintMaximum);
        }
        var widthConstraintMinimum = util.topMost(pile, ['widthConstraint', 'minimum']);
        if (typeof widthConstraintMinimum === 'number') {
          fontOptions.minWdt = Number(widthConstraintMinimum);
        }
      }

      var heightConstraint = util.topMost(pile, 'heightConstraint');
      if (typeof heightConstraint === 'number') {
        fontOptions.minHgt = Number(heightConstraint);
      } else if ((typeof heightConstraint === 'undefined' ? 'undefined' : (0, _typeof3['default'])(heightConstraint)) === 'object') {
        var heightConstraintMinimum = util.topMost(pile, ['heightConstraint', 'minimum']);
        if (typeof heightConstraintMinimum === 'number') {
          fontOptions.minHgt = Number(heightConstraintMinimum);
        }
        var heightConstraintValign = util.topMost(pile, ['heightConstraint', 'valign']);
        if (typeof heightConstraintValign === 'string') {
          if (heightConstraintValign === 'top' || heightConstraintValign === 'bottom') {
            fontOptions.valign = heightConstraintValign;
          }
        }
      }

      return fontOptions;
    }

    /**
     * Set options and update internal state
     *
     * @param {Object} options  options to set
     * @param {Array}  pile     array of option objects to consider for option 'chosen'
     */

  }, {
    key: 'update',
    value: function update(options, pile) {
      this.setOptions(options, true);
      this.propagateFonts(pile);
      util.deepExtend(this.fontOptions, this.constrain(pile));
      this.fontOptions.chooser = ComponentUtil.choosify('label', pile);
    }

    /**
     * When margins are set in an element, adjust sizes is called to remove them
     * from the width/height constraints. This must be done prior to label sizing.
     *
     * @param {{top: number, right: number, bottom: number, left: number}} margins
     */

  }, {
    key: 'adjustSizes',
    value: function adjustSizes(margins) {
      var widthBias = margins ? margins.right + margins.left : 0;
      if (this.fontOptions.constrainWidth) {
        this.fontOptions.maxWdt -= widthBias;
        this.fontOptions.minWdt -= widthBias;
      }
      var heightBias = margins ? margins.top + margins.bottom : 0;
      if (this.fontOptions.constrainHeight) {
        this.fontOptions.minHgt -= heightBias;
      }
    }

    /////////////////////////////////////////////////////////
    // Methods for handling options piles
    // Eventually, these will be moved to a separate class
    /////////////////////////////////////////////////////////

    /**
     * Add the font members of the passed list of option objects to the pile.
     *
     * @param {Pile} dstPile  pile of option objects add to
     * @param {Pile} srcPile  pile of option objects to take font options from
     * @private
     */

  }, {
    key: 'addFontOptionsToPile',
    value: function addFontOptionsToPile(dstPile, srcPile) {
      for (var i = 0; i < srcPile.length; ++i) {
        this.addFontToPile(dstPile, srcPile[i]);
      }
    }

    /**
     * Add given font option object to the list of objects (the 'pile') to consider for determining
     * multi-font option values.
     *
     * @param {Pile} pile  pile of option objects to use
     * @param {object} options  instance to add to pile
     * @private
     */

  }, {
    key: 'addFontToPile',
    value: function addFontToPile(pile, options) {
      if (options === undefined) return;
      if (options.font === undefined || options.font === null) return;

      var item = options.font;
      pile.push(item);
    }

    /**
     * Collect all own-property values from the font pile that aren't multi-font option objectss.
     *
     * @param {Pile} pile  pile of option objects to use
     * @returns {object} object with all current own basic font properties
     * @private
     */

  }, {
    key: 'getBasicOptions',
    value: function getBasicOptions(pile) {
      var ret = {};

      // Scans the whole pile to get all options present
      for (var n = 0; n < pile.length; ++n) {
        var fontOptions = pile[n];

        // Convert shorthand if necessary
        var tmpShorthand = {};
        if (Label.parseFontString(tmpShorthand, fontOptions)) {
          fontOptions = tmpShorthand;
        }

        util.forEach(fontOptions, function (opt, name) {
          if (opt === undefined) return; // multi-font option need not be present
          if (ret.hasOwnProperty(name)) return; // Keep first value we encounter

          if (multiFontStyle.indexOf(name) !== -1) {
            // Skip multi-font properties but we do need the structure
            ret[name] = {};
          } else {
            ret[name] = opt;
          }
        });
      }

      return ret;
    }

    /**
     * Return the value for given option for the given multi-font.
     *
     * All available option objects are trawled in the set order to construct the option values.
     *
     * ---------------------------------------------------------------------
     * ## Traversal of pile for multi-fonts
     *
     * The determination of multi-font option values is a special case, because any values not
     * present in the multi-font options should by definition be taken from the main font options,
     * i.e. from the current 'parent' object of the multi-font option.
     *
     * ### Search order for multi-fonts
     *
     * 'bold' used as example:
     *
     *   - search in option group 'bold' in local properties
     *   - search in main font option group in local properties
     *
     * ---------------------------------------------------------------------
     *
     * @param {Pile} pile  pile of option objects to use
     * @param {MultiFontStyle} multiName sub path for the multi-font
     * @param {string} option  the option to search for, for the given multi-font
     * @returns {string|number} the value for the given option
     * @private
     */

  }, {
    key: 'getFontOption',
    value: function getFontOption(pile, multiName, option) {
      var multiFont = void 0;

      // Search multi font in local properties
      for (var n = 0; n < pile.length; ++n) {
        var fontOptions = pile[n];

        if (fontOptions.hasOwnProperty(multiName)) {
          multiFont = fontOptions[multiName];
          if (multiFont === undefined || multiFont === null) continue;

          // Convert shorthand if necessary
          // TODO: inefficient to do this conversion every time; find a better way.
          var tmpShorthand = {};
          if (Label.parseFontString(tmpShorthand, multiFont)) {
            multiFont = tmpShorthand;
          }

          if (multiFont.hasOwnProperty(option)) {
            return multiFont[option];
          }
        }
      }

      // Option is not mentioned in the multi font options; take it from the parent font options.
      // These have already been converted with getBasicOptions(), so use the converted values.
      if (this.fontOptions.hasOwnProperty(option)) {
        return this.fontOptions[option];
      }

      // A value **must** be found; you should never get here.
      throw new Error("Did not find value for multi-font for property: '" + option + "'");
    }

    /**
     * Return all options values for the given multi-font.
     *
     * All available option objects are trawled in the set order to construct the option values.
     *
     * @param {Pile} pile  pile of option objects to use
     * @param {MultiFontStyle} multiName sub path for the mod-font
     * @returns {MultiFontOptions}
     * @private
     */

  }, {
    key: 'getFontOptions',
    value: function getFontOptions(pile, multiName) {
      var result = {};
      var optionNames = ['color', 'size', 'face', 'mod', 'vadjust']; // List of allowed options per multi-font

      for (var i = 0; i < optionNames.length; ++i) {
        var mod = optionNames[i];
        result[mod] = this.getFontOption(pile, multiName, mod);
      }

      return result;
    }

    /////////////////////////////////////////////////////////
    // End methods for handling options piles
    /////////////////////////////////////////////////////////

    /**
     * Collapse the font options for the multi-font to single objects, from
     * the chain of option objects passed (the 'pile').
     *
     * @param {Pile} pile  sequence of option objects to consider.
     *                     First item in list assumed to be the newly set options.
     */

  }, {
    key: 'propagateFonts',
    value: function propagateFonts(pile) {
      var _this2 = this;

      var fontPile = []; // sequence of font objects to consider, order important

      // Note that this.elementOptions is not used here.
      this.addFontOptionsToPile(fontPile, pile);
      this.fontOptions = this.getBasicOptions(fontPile);

      // We set multifont values even if multi === false, for consistency (things break otherwise)

      var _loop = function _loop(i) {
        var mod = multiFontStyle[i];
        var modOptions = _this2.fontOptions[mod];
        var tmpMultiFontOptions = _this2.getFontOptions(fontPile, mod);

        // Copy over found values
        util.forEach(tmpMultiFontOptions, function (option, n) {
          modOptions[n] = option;
        });

        modOptions.size = Number(modOptions.size);
        modOptions.vadjust = Number(modOptions.vadjust);
      };

      for (var i = 0; i < multiFontStyle.length; ++i) {
        _loop(i);
      }
    }

    /**
     * Main function. This is called from anything that wants to draw a label.
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x
     * @param {number} y
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {string} [baseline='middle']
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover) {
      var baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 'middle';

      // if no label, return
      if (this.elementOptions.label === undefined) return;

      // check if we have to render the label
      var viewFontSize = this.fontOptions.size * this.body.view.scale;
      if (this.elementOptions.label && viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) return;

      // This ensures that there will not be HUGE letters on screen
      // by setting an upper limit on the visible text size (regardless of zoomLevel)
      if (viewFontSize >= this.elementOptions.scaling.label.maxVisible) {
        viewFontSize = Number(this.elementOptions.scaling.label.maxVisible) / this.body.view.scale;
      }

      // update the size cache if required
      this.calculateLabelSize(ctx, selected, hover, x, y, baseline);
      this._drawBackground(ctx);
      this._drawText(ctx, x, this.size.yLine, baseline, viewFontSize);
    }

    /**
     * Draws the label background
     * @param {CanvasRenderingContext2D} ctx
     * @private
     */

  }, {
    key: '_drawBackground',
    value: function _drawBackground(ctx) {
      if (this.fontOptions.background !== undefined && this.fontOptions.background !== 'none') {
        ctx.fillStyle = this.fontOptions.background;
        var size = this.getSize();
        ctx.fillRect(size.left, size.top, size.width, size.height);
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x
     * @param {number} y
     * @param {string} [baseline='middle']
     * @param {number} viewFontSize
     * @private
     */

  }, {
    key: '_drawText',
    value: function _drawText(ctx, x, y) {
      var baseline = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'middle';
      var viewFontSize = arguments[4];

      ;
      var _setAlignment2 = this._setAlignment(ctx, x, y, baseline);

      var _setAlignment3 = (0, _slicedToArray3['default'])(_setAlignment2, 2);

      x = _setAlignment3[0];
      y = _setAlignment3[1];


      ctx.textAlign = 'left';
      x = x - this.size.width / 2; // Shift label 1/2-distance to the left
      if (this.fontOptions.valign && this.size.height > this.size.labelHeight) {
        if (this.fontOptions.valign === 'top') {
          y -= (this.size.height - this.size.labelHeight) / 2;
        }
        if (this.fontOptions.valign === 'bottom') {
          y += (this.size.height - this.size.labelHeight) / 2;
        }
      }

      // draw the text
      for (var i = 0; i < this.lineCount; i++) {
        var line = this.lines[i];
        if (line && line.blocks) {
          var width = 0;
          if (this.isEdgeLabel || this.fontOptions.align === 'center') {
            width += (this.size.width - line.width) / 2;
          } else if (this.fontOptions.align === 'right') {
            width += this.size.width - line.width;
          }
          for (var j = 0; j < line.blocks.length; j++) {
            var block = line.blocks[j];
            ctx.font = block.font;

            var _getColor2 = this._getColor(block.color, viewFontSize, block.strokeColor),
                _getColor3 = (0, _slicedToArray3['default'])(_getColor2, 2),
                fontColor = _getColor3[0],
                strokeColor = _getColor3[1];

            if (block.strokeWidth > 0) {
              ctx.lineWidth = block.strokeWidth;
              ctx.strokeStyle = strokeColor;
              ctx.lineJoin = 'round';
            }
            ctx.fillStyle = fontColor;

            if (block.strokeWidth > 0) {
              ctx.strokeText(block.text, x + width, y + block.vadjust);
            }
            ctx.fillText(block.text, x + width, y + block.vadjust);
            width += block.width;
          }
          y += line.height;
        }
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x
     * @param {number} y
     * @param {string} baseline
     * @returns {Array.<number>}
     * @private
     */

  }, {
    key: '_setAlignment',
    value: function _setAlignment(ctx, x, y, baseline) {
      // check for label alignment (for edges)
      // TODO: make alignment for nodes
      if (this.isEdgeLabel && this.fontOptions.align !== 'horizontal' && this.pointToSelf === false) {
        x = 0;
        y = 0;

        var lineMargin = 2;
        if (this.fontOptions.align === 'top') {
          ctx.textBaseline = 'alphabetic';
          y -= 2 * lineMargin; // distance from edge, required because we use alphabetic. Alphabetic has less difference between browsers
        } else if (this.fontOptions.align === 'bottom') {
          ctx.textBaseline = 'hanging';
          y += 2 * lineMargin; // distance from edge, required because we use hanging. Hanging has less difference between browsers
        } else {
          ctx.textBaseline = 'middle';
        }
      } else {
        ctx.textBaseline = baseline;
      }
      return [x, y];
    }

    /**
     * fade in when relative scale is between threshold and threshold - 1.
     * If the relative scale would be smaller than threshold -1 the draw function would have returned before coming here.
     *
     * @param {string} color  The font color to use
     * @param {number} viewFontSize
     * @param {string} initialStrokeColor
     * @returns {Array.<string>} An array containing the font color and stroke color
     * @private
     */

  }, {
    key: '_getColor',
    value: function _getColor(color, viewFontSize, initialStrokeColor) {
      var fontColor = color || '#000000';
      var strokeColor = initialStrokeColor || '#ffffff';
      if (viewFontSize <= this.elementOptions.scaling.label.drawThreshold) {
        var opacity = Math.max(0, Math.min(1, 1 - (this.elementOptions.scaling.label.drawThreshold - viewFontSize)));
        fontColor = util.overrideOpacity(fontColor, opacity);
        strokeColor = util.overrideOpacity(strokeColor, opacity);
      }
      return [fontColor, strokeColor];
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @returns {{width: number, height: number}}
     */

  }, {
    key: 'getTextSize',
    value: function getTextSize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      this._processLabel(ctx, selected, hover);
      return {
        width: this.size.width,
        height: this.size.height,
        lineCount: this.lineCount
      };
    }

    /**
     * Get the current dimensions of the label
     *
     * @return {rect}
     */

  }, {
    key: 'getSize',
    value: function getSize() {
      var lineMargin = 2;
      var x = this.size.left; // default values which might be overridden below
      var y = this.size.top - 0.5 * lineMargin; // idem

      if (this.isEdgeLabel) {
        var x2 = -this.size.width * 0.5;

        switch (this.fontOptions.align) {
          case 'middle':
            x = x2;
            y = -this.size.height * 0.5;
            break;
          case 'top':
            x = x2;
            y = -(this.size.height + lineMargin);
            break;
          case 'bottom':
            x = x2;
            y = lineMargin;
            break;
        }
      }

      var ret = {
        left: x,
        top: y,
        width: this.size.width,
        height: this.size.height
      };

      return ret;
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {number} [x=0]
     * @param {number} [y=0]
     * @param {'middle'|'hanging'} [baseline='middle']
     */

  }, {
    key: 'calculateLabelSize',
    value: function calculateLabelSize(ctx, selected, hover) {
      var x = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var y = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
      var baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 'middle';

      this._processLabel(ctx, selected, hover);
      this.size.left = x - this.size.width * 0.5;
      this.size.top = y - this.size.height * 0.5;
      this.size.yLine = y + (1 - this.lineCount) * 0.5 * this.fontOptions.size;
      if (baseline === 'hanging') {
        this.size.top += 0.5 * this.fontOptions.size;
        this.size.top += 4; // distance from node, required because we use hanging. Hanging has less difference between browsers
        this.size.yLine += 4; // distance from node
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {string} mod
     * @returns {{color, size, face, mod, vadjust, strokeWidth: *, strokeColor: (*|string|allOptions.edges.font.strokeColor|{string}|allOptions.nodes.font.strokeColor|Array)}}
     */

  }, {
    key: 'getFormattingValues',
    value: function getFormattingValues(ctx, selected, hover, mod) {
      var getValue = function getValue(fontOptions, mod, option) {
        if (mod === 'normal') {
          if (option === 'mod') return '';
          return fontOptions[option];
        }

        if (fontOptions[mod][option] !== undefined) {
          // Grumbl leaving out test on undefined equals false for ""
          return fontOptions[mod][option];
        } else {
          // Take from parent font option
          return fontOptions[option];
        }
      };

      var values = {
        color: getValue(this.fontOptions, mod, 'color'),
        size: getValue(this.fontOptions, mod, 'size'),
        face: getValue(this.fontOptions, mod, 'face'),
        mod: getValue(this.fontOptions, mod, 'mod'),
        vadjust: getValue(this.fontOptions, mod, 'vadjust'),
        strokeWidth: this.fontOptions.strokeWidth,
        strokeColor: this.fontOptions.strokeColor
      };
      if (selected || hover) {
        if (mod === 'normal' && this.fontOptions.chooser === true && this.elementOptions.labelHighlightBold) {
          values.mod = 'bold';
        } else {
          if (typeof this.fontOptions.chooser === 'function') {
            this.fontOptions.chooser(values, this.elementOptions.id, selected, hover);
          }
        }
      }

      var fontString = '';
      if (values.mod !== undefined && values.mod !== '') {
        // safeguard for undefined - this happened
        fontString += values.mod + ' ';
      }
      fontString += values.size + 'px ' + values.face;

      ctx.font = fontString.replace(/"/g, '');
      values.font = ctx.font;
      values.height = values.size;
      return values;
    }

    /**
     *
     * @param {boolean} selected
     * @param {boolean} hover
     * @returns {boolean}
     */

  }, {
    key: 'differentState',
    value: function differentState(selected, hover) {
      return selected !== this.selectedState || hover !== this.hoverState;
    }

    /**
     * This explodes the passed text into lines and determines the width, height and number of lines.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {string} inText  the text to explode
     * @returns {{width, height, lines}|*}
     * @private
     */

  }, {
    key: '_processLabelText',
    value: function _processLabelText(ctx, selected, hover, inText) {
      var splitter = new LabelSplitter(ctx, this, selected, hover);
      return splitter.process(inText);
    }

    /**
     * This explodes the label string into lines and sets the width, height and number of lines.
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @private
     */

  }, {
    key: '_processLabel',
    value: function _processLabel(ctx, selected, hover) {
      if (this.labelDirty === false && !this.differentState(selected, hover)) return;

      var state = this._processLabelText(ctx, selected, hover, this.elementOptions.label);

      if (this.fontOptions.minWdt > 0 && state.width < this.fontOptions.minWdt) {
        state.width = this.fontOptions.minWdt;
      }

      this.size.labelHeight = state.height;
      if (this.fontOptions.minHgt > 0 && state.height < this.fontOptions.minHgt) {
        state.height = this.fontOptions.minHgt;
      }

      this.lines = state.lines;
      this.lineCount = state.lines.length;
      this.size.width = state.width;
      this.size.height = state.height;
      this.selectedState = selected;
      this.hoverState = hover;

      this.labelDirty = false;
    }

    /**
     * Check if this label is visible
     *
     * @return {boolean} true if this label will be show, false otherwise
     */

  }, {
    key: 'visible',
    value: function visible() {
      if (this.size.width === 0 || this.size.height === 0 || this.elementOptions.label === undefined) {
        return false; // nothing to display
      }

      var viewFontSize = this.fontOptions.size * this.body.view.scale;
      if (viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) {
        return false; // Too small or too far away to show
      }

      return true;
    }
  }], [{
    key: 'parseFontString',
    value: function parseFontString(outOptions, inOptions) {
      if (!inOptions || typeof inOptions !== 'string') return false;

      var newOptionsArray = inOptions.split(' ');

      outOptions.size = newOptionsArray[0].replace('px', '');
      outOptions.face = newOptionsArray[1];
      outOptions.color = newOptionsArray[2];

      return true;
    }
  }]);
  return Label;
}();

exports['default'] = Label;

/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(141), __esModule: true };

/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = __webpack_require__(15);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);
var EndPoints = __webpack_require__(80)['default'];

/**
 * The Base Class for all edges.
 *
 */

var EdgeBase = function () {
  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function EdgeBase(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, EdgeBase);

    this.body = body;
    this.labelModule = labelModule;
    this.options = {};
    this.setOptions(options);
    this.colorDirty = true;
    this.color = {};
    this.selectionWidth = 2;
    this.hoverWidth = 1.5;
    this.fromPoint = this.from;
    this.toPoint = this.to;
  }

  /**
   * Connects a node to itself
   */


  (0, _createClass3['default'])(EdgeBase, [{
    key: 'connect',
    value: function connect() {
      this.from = this.body.nodes[this.options.from];
      this.to = this.body.nodes[this.options.to];
    }

    /**
     *
     * @returns {boolean} always false
     */

  }, {
    key: 'cleanup',
    value: function cleanup() {
      return false;
    }

    /**
     *
     * @param {Object} options
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      this.options = options;
      this.from = this.body.nodes[this.options.from];
      this.to = this.body.nodes[this.options.to];
      this.id = this.options.id;
    }

    /**
     * Redraw a edge as a line
     * Draw this edge in the given canvas
     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
     *
     * @param {CanvasRenderingContext2D}   ctx
     * @param {Array} values
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {Node} viaNode
     * @private
     */

  }, {
    key: 'drawLine',
    value: function drawLine(ctx, values, selected, hover, viaNode) {
      // set style
      ctx.strokeStyle = this.getColor(ctx, values, selected, hover);
      ctx.lineWidth = values.width;

      if (values.dashes !== false) {
        this._drawDashedLine(ctx, values, viaNode);
      } else {
        this._drawLine(ctx, values, viaNode);
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D}   ctx
     * @param {Array} values
     * @param {Node} viaNode
     * @param {{x: number, y: number}} [fromPoint]
     * @param {{x: number, y: number}} [toPoint]
     * @private
     */

  }, {
    key: '_drawLine',
    value: function _drawLine(ctx, values, viaNode, fromPoint, toPoint) {
      if (this.from != this.to) {
        // draw line
        this._line(ctx, values, viaNode, fromPoint, toPoint);
      } else {
        var _getCircleData2 = this._getCircleData(ctx),
            _getCircleData3 = (0, _slicedToArray3['default'])(_getCircleData2, 3),
            x = _getCircleData3[0],
            y = _getCircleData3[1],
            radius = _getCircleData3[2];

        this._circle(ctx, values, x, y, radius);
      }
    }

    // prettier-ignore
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {Array} values
     * @param {Node} viaNode
     * @param {{x: number, y: number}} [fromPoint]  TODO: Remove in next major release
     * @param {{x: number, y: number}} [toPoint]    TODO: Remove in next major release
     * @private
     */

  }, {
    key: '_drawDashedLine',
    value: function _drawDashedLine(ctx, values, viaNode, fromPoint, toPoint) {
      // eslint-disable-line no-unused-vars
      ctx.lineCap = 'round';
      var pattern = [5, 5];
      if (Array.isArray(values.dashes) === true) {
        pattern = values.dashes;
      }

      // only firefox and chrome support this method, else we use the legacy one.
      if (ctx.setLineDash !== undefined) {
        ctx.save();

        // set dash settings for chrome or firefox
        ctx.setLineDash(pattern);
        ctx.lineDashOffset = 0;

        // draw the line
        if (this.from != this.to) {
          // draw line
          this._line(ctx, values, viaNode);
        } else {
          var _getCircleData4 = this._getCircleData(ctx),
              _getCircleData5 = (0, _slicedToArray3['default'])(_getCircleData4, 3),
              x = _getCircleData5[0],
              y = _getCircleData5[1],
              radius = _getCircleData5[2];

          this._circle(ctx, values, x, y, radius);
        }

        // restore the dash settings.
        ctx.setLineDash([0]);
        ctx.lineDashOffset = 0;
        ctx.restore();
      } else {
        // unsupporting smooth lines
        if (this.from != this.to) {
          // draw line
          ctx.dashedLine(this.from.x, this.from.y, this.to.x, this.to.y, pattern);
        } else {
          var _getCircleData6 = this._getCircleData(ctx),
              _getCircleData7 = (0, _slicedToArray3['default'])(_getCircleData6, 3),
              _x = _getCircleData7[0],
              _y = _getCircleData7[1],
              _radius = _getCircleData7[2];

          this._circle(ctx, values, _x, _y, _radius);
        }
        // draw shadow if enabled
        this.enableShadow(ctx, values);

        ctx.stroke();

        // disable shadows for other elements.
        this.disableShadow(ctx, values);
      }
    }

    /**
     *
     * @param {Node} nearNode
     * @param {CanvasRenderingContext2D} ctx
     * @param {Object} options
     * @returns {{x: number, y: number}}
     */

  }, {
    key: 'findBorderPosition',
    value: function findBorderPosition(nearNode, ctx, options) {
      if (this.from != this.to) {
        return this._findBorderPosition(nearNode, ctx, options);
      } else {
        return this._findBorderPositionCircle(nearNode, ctx, options);
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @returns {{from: ({x: number, y: number, t: number}|*), to: ({x: number, y: number, t: number}|*)}}
     */

  }, {
    key: 'findBorderPositions',
    value: function findBorderPositions(ctx) {
      var from = {};
      var to = {};
      if (this.from != this.to) {
        from = this._findBorderPosition(this.from, ctx);
        to = this._findBorderPosition(this.to, ctx);
      } else {
        var _getCircleData$slice = this._getCircleData(ctx).slice(0, 2),
            _getCircleData$slice2 = (0, _slicedToArray3['default'])(_getCircleData$slice, 2),
            x = _getCircleData$slice2[0],
            y = _getCircleData$slice2[1];

        from = this._findBorderPositionCircle(this.from, ctx, {
          x: x,
          y: y,
          low: 0.25,
          high: 0.6,
          direction: -1
        });
        to = this._findBorderPositionCircle(this.from, ctx, {
          x: x,
          y: y,
          low: 0.6,
          high: 0.8,
          direction: 1
        });
      }
      return { from: from, to: to };
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @returns {Array.<number>} x, y, radius
     * @private
     */

  }, {
    key: '_getCircleData',
    value: function _getCircleData(ctx) {
      var x = void 0,
          y = void 0;
      var node = this.from;
      var radius = this.options.selfReferenceSize;

      if (ctx !== undefined) {
        if (node.shape.width === undefined) {
          node.shape.resize(ctx);
        }
      }

      // get circle coordinates
      if (node.shape.width > node.shape.height) {
        x = node.x + node.shape.width * 0.5;
        y = node.y - radius;
      } else {
        x = node.x + radius;
        y = node.y - node.shape.height * 0.5;
      }
      return [x, y, radius];
    }

    /**
     * Get a point on a circle
     * @param {number} x
     * @param {number} y
     * @param {number} radius
     * @param {number} percentage - Value between 0 (line start) and 1 (line end)
     * @return {Object} point
     * @private
     */

  }, {
    key: '_pointOnCircle',
    value: function _pointOnCircle(x, y, radius, percentage) {
      var angle = percentage * 2 * Math.PI;
      return {
        x: x + radius * Math.cos(angle),
        y: y - radius * Math.sin(angle)
      };
    }

    /**
     * This function uses binary search to look for the point where the circle crosses the border of the node.
     * @param {Node} node
     * @param {CanvasRenderingContext2D} ctx
     * @param {Object} options
     * @returns {*}
     * @private
     */

  }, {
    key: '_findBorderPositionCircle',
    value: function _findBorderPositionCircle(node, ctx, options) {
      var x = options.x;
      var y = options.y;
      var low = options.low;
      var high = options.high;
      var direction = options.direction;

      var maxIterations = 10;
      var iteration = 0;
      var radius = this.options.selfReferenceSize;
      var pos = void 0,
          angle = void 0,
          distanceToBorder = void 0,
          distanceToPoint = void 0,
          difference = void 0;
      var threshold = 0.05;
      var middle = (low + high) * 0.5;

      while (low <= high && iteration < maxIterations) {
        middle = (low + high) * 0.5;

        pos = this._pointOnCircle(x, y, radius, middle);
        angle = Math.atan2(node.y - pos.y, node.x - pos.x);
        distanceToBorder = node.distanceToBorder(ctx, angle);
        distanceToPoint = Math.sqrt(Math.pow(pos.x - node.x, 2) + Math.pow(pos.y - node.y, 2));
        difference = distanceToBorder - distanceToPoint;
        if (Math.abs(difference) < threshold) {
          break; // found
        } else if (difference > 0) {
          // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
          if (direction > 0) {
            low = middle;
          } else {
            high = middle;
          }
        } else {
          if (direction > 0) {
            high = middle;
          } else {
            low = middle;
          }
        }
        iteration++;
      }
      pos.t = middle;

      return pos;
    }

    /**
     * Get the line width of the edge. Depends on width and whether one of the
     * connected nodes is selected.
     * @param {boolean} selected
     * @param {boolean} hover
     * @returns {number} width
     * @private
     */

  }, {
    key: 'getLineWidth',
    value: function getLineWidth(selected, hover) {
      if (selected === true) {
        return Math.max(this.selectionWidth, 0.3 / this.body.view.scale);
      } else {
        if (hover === true) {
          return Math.max(this.hoverWidth, 0.3 / this.body.view.scale);
        } else {
          return Math.max(this.options.width, 0.3 / this.body.view.scale);
        }
      }
    }

    // prettier-ignore
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     * @param {boolean} selected - Unused
     * @param {boolean} hover - Unused
     * @returns {string}
     */

  }, {
    key: 'getColor',
    value: function getColor(ctx, values, selected, hover) {
      // eslint-disable-line no-unused-vars
      if (values.inheritsColor !== false) {
        // when this is a loop edge, just use the 'from' method
        if (values.inheritsColor === 'both' && this.from.id !== this.to.id) {
          var grd = ctx.createLinearGradient(this.from.x, this.from.y, this.to.x, this.to.y);
          var fromColor = void 0,
              toColor = void 0;
          fromColor = this.from.options.color.highlight.border;
          toColor = this.to.options.color.highlight.border;

          if (this.from.selected === false && this.to.selected === false) {
            fromColor = util.overrideOpacity(this.from.options.color.border, values.opacity);
            toColor = util.overrideOpacity(this.to.options.color.border, values.opacity);
          } else if (this.from.selected === true && this.to.selected === false) {
            toColor = this.to.options.color.border;
          } else if (this.from.selected === false && this.to.selected === true) {
            fromColor = this.from.options.color.border;
          }
          grd.addColorStop(0, fromColor);
          grd.addColorStop(1, toColor);

          // -------------------- this returns -------------------- //
          return grd;
        }

        if (values.inheritsColor === 'to') {
          return util.overrideOpacity(this.to.options.color.border, values.opacity);
        } else {
          // "from"
          return util.overrideOpacity(this.from.options.color.border, values.opacity);
        }
      } else {
        return util.overrideOpacity(values.color, values.opacity);
      }
    }

    /**
     * Draw a line from a node to itself, a circle
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {Array} values
     * @param {number} x
     * @param {number} y
     * @param {number} radius
     * @private
     */

  }, {
    key: '_circle',
    value: function _circle(ctx, values, x, y, radius) {
      // draw shadow if enabled
      this.enableShadow(ctx, values);

      // draw a circle
      ctx.beginPath();
      ctx.arc(x, y, radius, 0, 2 * Math.PI, false);
      ctx.stroke();

      // disable shadows for other elements.
      this.disableShadow(ctx, values);
    }

    // prettier-ignore
    /**
     * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
     * (x3,y3) is the point.
     *
     * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {number} x3
     * @param {number} y3
     * @param {Node} via
     * @param {Array} values
     * @returns {number}
     */

  }, {
    key: 'getDistanceToEdge',
    value: function getDistanceToEdge(x1, y1, x2, y2, x3, y3, via, values) {
      // eslint-disable-line no-unused-vars
      var returnValue = 0;
      if (this.from != this.to) {
        returnValue = this._getDistanceToEdge(x1, y1, x2, y2, x3, y3, via);
      } else {
        var _getCircleData8 = this._getCircleData(undefined),
            _getCircleData9 = (0, _slicedToArray3['default'])(_getCircleData8, 3),
            x = _getCircleData9[0],
            y = _getCircleData9[1],
            radius = _getCircleData9[2];

        var dx = x - x3;
        var dy = y - y3;
        returnValue = Math.abs(Math.sqrt(dx * dx + dy * dy) - radius);
      }

      return returnValue;
    }

    /**
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {number} x3
     * @param {number} y3
     * @returns {number}
     * @private
     */

  }, {
    key: '_getDistanceToLine',
    value: function _getDistanceToLine(x1, y1, x2, y2, x3, y3) {
      var px = x2 - x1;
      var py = y2 - y1;
      var something = px * px + py * py;
      var u = ((x3 - x1) * px + (y3 - y1) * py) / something;

      if (u > 1) {
        u = 1;
      } else if (u < 0) {
        u = 0;
      }

      var x = x1 + u * px;
      var y = y1 + u * py;
      var dx = x - x3;
      var dy = y - y3;

      //# Note: If the actual distance does not matter,
      //# if you only want to compare what this function
      //# returns to other results of this function, you
      //# can just return the squared distance instead
      //# (i.e. remove the sqrt) to gain a little performance

      return Math.sqrt(dx * dx + dy * dy);
    }

    /**
     * @param {CanvasRenderingContext2D} ctx
     * @param {string} position
     * @param {Node} viaNode
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {Array} values
     * @returns {{point: *, core: {x: number, y: number}, angle: *, length: number, type: *}}
     */

  }, {
    key: 'getArrowData',
    value: function getArrowData(ctx, position, viaNode, selected, hover, values) {
      // set lets
      var angle = void 0;
      var arrowPoint = void 0;
      var node1 = void 0;
      var node2 = void 0;
      var guideOffset = void 0;
      var scaleFactor = void 0;
      var type = void 0;
      var lineWidth = values.width;

      if (position === 'from') {
        node1 = this.from;
        node2 = this.to;
        guideOffset = 0.1;
        scaleFactor = values.fromArrowScale;
        type = values.fromArrowType;
      } else if (position === 'to') {
        node1 = this.to;
        node2 = this.from;
        guideOffset = -0.1;
        scaleFactor = values.toArrowScale;
        type = values.toArrowType;
      } else {
        node1 = this.to;
        node2 = this.from;
        scaleFactor = values.middleArrowScale;
        type = values.middleArrowType;
      }

      // if not connected to itself
      if (node1 != node2) {
        if (position !== 'middle') {
          // draw arrow head
          if (this.options.smooth.enabled === true) {
            arrowPoint = this.findBorderPosition(node1, ctx, { via: viaNode });
            var guidePos = this.getPoint(Math.max(0.0, Math.min(1.0, arrowPoint.t + guideOffset)), viaNode);
            angle = Math.atan2(arrowPoint.y - guidePos.y, arrowPoint.x - guidePos.x);
          } else {
            angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
            arrowPoint = this.findBorderPosition(node1, ctx);
          }
        } else {
          angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
          arrowPoint = this.getPoint(0.5, viaNode); // this is 0.6 to account for the size of the arrow.
        }
      } else {
        // draw circle
        var _getCircleData10 = this._getCircleData(ctx),
            _getCircleData11 = (0, _slicedToArray3['default'])(_getCircleData10, 3),
            x = _getCircleData11[0],
            y = _getCircleData11[1],
            radius = _getCircleData11[2];

        if (position === 'from') {
          arrowPoint = this.findBorderPosition(this.from, ctx, {
            x: x,
            y: y,
            low: 0.25,
            high: 0.6,
            direction: -1
          });
          angle = arrowPoint.t * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
        } else if (position === 'to') {
          arrowPoint = this.findBorderPosition(this.from, ctx, {
            x: x,
            y: y,
            low: 0.6,
            high: 1.0,
            direction: 1
          });
          angle = arrowPoint.t * -2 * Math.PI + 1.5 * Math.PI - 1.1 * Math.PI;
        } else {
          arrowPoint = this._pointOnCircle(x, y, radius, 0.175);
          angle = 3.9269908169872414; // === 0.175 * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
        }
      }

      if (position === 'middle' && scaleFactor < 0) lineWidth *= -1; // reversed middle arrow
      var length = 15 * scaleFactor + 3 * lineWidth; // 3* lineWidth is the width of the edge.

      var xi = arrowPoint.x - length * 0.9 * Math.cos(angle);
      var yi = arrowPoint.y - length * 0.9 * Math.sin(angle);
      var arrowCore = { x: xi, y: yi };

      return {
        point: arrowPoint,
        core: arrowCore,
        angle: angle,
        length: length,
        type: type
      };
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {Object} arrowData
     */

  }, {
    key: 'drawArrowHead',
    value: function drawArrowHead(ctx, values, selected, hover, arrowData) {
      // set style
      ctx.strokeStyle = this.getColor(ctx, values, selected, hover);
      ctx.fillStyle = ctx.strokeStyle;
      ctx.lineWidth = values.width;

      EndPoints.draw(ctx, arrowData);

      // draw shadow if enabled
      this.enableShadow(ctx, values);
      ctx.fill();
      // disable shadows for other elements.
      this.disableShadow(ctx, values);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'enableShadow',
    value: function enableShadow(ctx, values) {
      if (values.shadow === true) {
        ctx.shadowColor = values.shadowColor;
        ctx.shadowBlur = values.shadowSize;
        ctx.shadowOffsetX = values.shadowX;
        ctx.shadowOffsetY = values.shadowY;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: 'disableShadow',
    value: function disableShadow(ctx, values) {
      if (values.shadow === true) {
        ctx.shadowColor = 'rgba(0,0,0,0)';
        ctx.shadowBlur = 0;
        ctx.shadowOffsetX = 0;
        ctx.shadowOffsetY = 0;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {{toArrow: boolean, toArrowScale: (allOptions.edges.arrows.to.scaleFactor|{number}|allOptions.edges.arrows.middle.scaleFactor|allOptions.edges.arrows.from.scaleFactor|Array|number), toArrowType: *, middleArrow: boolean, middleArrowScale: (number|allOptions.edges.arrows.middle.scaleFactor|{number}|Array), middleArrowType: (allOptions.edges.arrows.middle.type|{string}|string|*), fromArrow: boolean, fromArrowScale: (allOptions.edges.arrows.to.scaleFactor|{number}|allOptions.edges.arrows.middle.scaleFactor|allOptions.edges.arrows.from.scaleFactor|Array|number), fromArrowType: *, arrowStrikethrough: (*|boolean|allOptions.edges.arrowStrikethrough|{boolean}), color: undefined, inheritsColor: (string|string|string|allOptions.edges.color.inherit|{string, boolean}|Array|*), opacity: *, hidden: *, length: *, shadow: *, shadowColor: *, shadowSize: *, shadowX: *, shadowY: *, dashes: (*|boolean|Array|allOptions.edges.dashes|{boolean, array}), width: *}} values
     */

  }, {
    key: 'drawBackground',
    value: function drawBackground(ctx, values) {
      if (values.background !== false) {
        var attrs = ['strokeStyle', 'lineWidth', 'dashes'];
        var origCtxAttr = {};
        // save original line attrs
        attrs.forEach(function (attrname) {
          origCtxAttr[attrname] = ctx[attrname];
        });

        ctx.strokeStyle = values.backgroundColor;
        ctx.lineWidth = values.backgroundSize;
        this.setStrokeDashed(ctx, values.backgroundDashes);

        ctx.stroke();

        // restore original line attrs
        attrs.forEach(function (attrname) {
          ctx[attrname] = origCtxAttr[attrname];
        });
        this.setStrokeDashed(ctx, values.dashes);
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean|Array} dashes
     */

  }, {
    key: 'setStrokeDashed',
    value: function setStrokeDashed(ctx, dashes) {
      if (dashes !== false) {
        if (ctx.setLineDash !== undefined) {
          var pattern = [5, 5];
          if (Array.isArray(dashes) === true) {
            pattern = dashes;
          }
          ctx.setLineDash(pattern);
        } else {
          console.warn('setLineDash is not supported in this browser. The dashed stroke cannot be used.');
        }
      } else {
        if (ctx.setLineDash !== undefined) {
          ctx.setLineDash([]);
        } else {
          console.warn('setLineDash is not supported in this browser. The dashed stroke cannot be used.');
        }
      }
    }
  }]);
  return EdgeBase;
}();

exports['default'] = EdgeBase;

/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** ============================================================================
 * Location of all the endpoint drawing routines.
 *
 * Every endpoint has its own drawing routine, which contains an endpoint definition.
 *
 * The endpoint definitions must have the following properies:
 *
 * - (0,0) is the connection point to the node it attaches to
 * - The endpoints are orientated to the positive x-direction
 * - The length of the endpoint is at most 1
 *
 * As long as the endpoint classes remain simple and not too numerous, they will
 * be contained within this module.
 * All classes here except `EndPoints` should be considered as private to this module.
 *
 * -----------------------------------------------------------------------------
 * ### Further Actions
 *
 * After adding a new endpoint here, you also need to do the following things:
 *
 * - Add the new endpoint name to `network/options.js` in array `endPoints`.
 * - Add the new endpoint name to the documentation.
 *   Scan for 'arrows.to.type` and add it to the description.
 * - Add the endpoint to the examples. At the very least, add it to example
 *   `edgeStyles/arrowTypes`.
 * ============================================================================= */

/**
 * Common methods for endpoints
 *
 * @class
 */
var EndPoint = function () {
  function EndPoint() {
    (0, _classCallCheck3['default'])(this, EndPoint);
  }

  (0, _createClass3['default'])(EndPoint, null, [{
    key: 'transform',

    /**
     * Apply transformation on points for display.
     *
     * The following is done:
     * - rotate by the specified angle
     * - multiply the (normalized) coordinates by the passed length
     * - offset by the target coordinates
     *
     * @param {Array<Point>} points
     * @param {ArrowData} arrowData
     * @static
     */
    value: function transform(points, arrowData) {
      if (!(points instanceof Array)) {
        points = [points];
      }

      var x = arrowData.point.x;
      var y = arrowData.point.y;
      var angle = arrowData.angle;
      var length = arrowData.length;

      for (var i = 0; i < points.length; ++i) {
        var p = points[i];
        var xt = p.x * Math.cos(angle) - p.y * Math.sin(angle);
        var yt = p.x * Math.sin(angle) + p.y * Math.cos(angle);

        p.x = x + length * xt;
        p.y = y + length * yt;
      }
    }

    /**
     * Draw a closed path using the given real coordinates.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {Array.<Point>} points
     * @static
     */

  }, {
    key: 'drawPath',
    value: function drawPath(ctx, points) {
      ctx.beginPath();
      ctx.moveTo(points[0].x, points[0].y);
      for (var i = 1; i < points.length; ++i) {
        ctx.lineTo(points[i].x, points[i].y);
      }
      ctx.closePath();
    }
  }]);
  return EndPoint;
}();

/**
 * Drawing methods for the arrow endpoint.
 * @extends EndPoint
 */


var Arrow = function (_EndPoint) {
  (0, _inherits3['default'])(Arrow, _EndPoint);

  function Arrow() {
    (0, _classCallCheck3['default'])(this, Arrow);
    return (0, _possibleConstructorReturn3['default'])(this, (Arrow.__proto__ || (0, _getPrototypeOf2['default'])(Arrow)).apply(this, arguments));
  }

  (0, _createClass3['default'])(Arrow, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{ x: 0, y: 0 }, { x: -1, y: 0.3 }, { x: -0.9, y: 0 }, { x: -1, y: -0.3 }];

      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
    }
  }]);
  return Arrow;
}(EndPoint);

/**
 * Drawing methods for the crow endpoint.
 * @extends EndPoint
 */


var Crow = function () {
  function Crow() {
    (0, _classCallCheck3['default'])(this, Crow);
  }

  (0, _createClass3['default'])(Crow, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{ x: -1, y: 0 }, { x: 0, y: 0.3 }, { x: -0.4, y: 0 }, { x: 0, y: -0.3 }];

      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
    }
  }]);
  return Crow;
}();

/**
 * Drawing methods for the curve endpoint.
 * @extends EndPoint
 */


var Curve = function () {
  function Curve() {
    (0, _classCallCheck3['default'])(this, Curve);
  }

  (0, _createClass3['default'])(Curve, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var point = { x: -0.4, y: 0 };
      EndPoint.transform(point, arrowData);

      // Update endpoint style for drawing transparent arc.
      ctx.strokeStyle = ctx.fillStyle;
      ctx.fillStyle = 'rgba(0, 0, 0, 0)';

      // Define curve endpoint as semicircle.
      var pi = Math.PI;
      var start_angle = arrowData.angle - pi / 2;
      var end_angle = arrowData.angle + pi / 2;
      ctx.beginPath();
      ctx.arc(point.x, point.y, arrowData.length * 0.4, start_angle, end_angle, false);
      ctx.stroke();
    }
  }]);
  return Curve;
}();

/**
 * Drawing methods for the inverted curve endpoint.
 * @extends EndPoint
 */


var InvertedCurve = function () {
  function InvertedCurve() {
    (0, _classCallCheck3['default'])(this, InvertedCurve);
  }

  (0, _createClass3['default'])(InvertedCurve, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var point = { x: -0.3, y: 0 };
      EndPoint.transform(point, arrowData);

      // Update endpoint style for drawing transparent arc.
      ctx.strokeStyle = ctx.fillStyle;
      ctx.fillStyle = 'rgba(0, 0, 0, 0)';

      // Define inverted curve endpoint as semicircle.
      var pi = Math.PI;
      var start_angle = arrowData.angle + pi / 2;
      var end_angle = arrowData.angle + 3 * pi / 2;
      ctx.beginPath();
      ctx.arc(point.x, point.y, arrowData.length * 0.4, start_angle, end_angle, false);
      ctx.stroke();
    }
  }]);
  return InvertedCurve;
}();

/**
 * Drawing methods for the trinagle endpoint.
 * @extends EndPoint
 */


var Triangle = function () {
  function Triangle() {
    (0, _classCallCheck3['default'])(this, Triangle);
  }

  (0, _createClass3['default'])(Triangle, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{ x: 0.02, y: 0 }, { x: -1, y: 0.3 }, { x: -1, y: -0.3 }];

      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
    }
  }]);
  return Triangle;
}();

/**
 * Drawing methods for the inverted trinagle endpoint.
 * @extends EndPoint
 */


var InvertedTriangle = function () {
  function InvertedTriangle() {
    (0, _classCallCheck3['default'])(this, InvertedTriangle);
  }

  (0, _createClass3['default'])(InvertedTriangle, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{ x: 0, y: 0.3 }, { x: 0, y: -0.3 }, { x: -1, y: 0 }];

      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
    }
  }]);
  return InvertedTriangle;
}();

/**
 * Drawing methods for the circle endpoint.
 */


var Circle = function () {
  function Circle() {
    (0, _classCallCheck3['default'])(this, Circle);
  }

  (0, _createClass3['default'])(Circle, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      var point = { x: -0.4, y: 0 };

      EndPoint.transform(point, arrowData);
      ctx.circle(point.x, point.y, arrowData.length * 0.4);
    }
  }]);
  return Circle;
}();

/**
 * Drawing methods for the bar endpoint.
 */


var Bar = function () {
  function Bar() {
    (0, _classCallCheck3['default'])(this, Bar);
  }

  (0, _createClass3['default'])(Bar, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      /*
      var points = [
        {x:0, y:0.5},
        {x:0, y:-0.5}
      ];
       EndPoint.transform(points, arrowData);
      ctx.beginPath();
      ctx.moveTo(points[0].x, points[0].y);
      ctx.lineTo(points[1].x, points[1].y);
      ctx.stroke();
      */

      var points = [{ x: 0, y: 0.5 }, { x: 0, y: -0.5 }, { x: -0.15, y: -0.5 }, { x: -0.15, y: 0.5 }];

      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
    }
  }]);
  return Bar;
}();

/**
 * Drawing methods for the box endpoint.
 */


var Box = function () {
  function Box() {
    (0, _classCallCheck3['default'])(this, Box);
  }

  (0, _createClass3['default'])(Box, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      var points = [{ x: 0, y: 0.3 }, { x: 0, y: -0.3 }, { x: -0.6, y: -0.3 }, { x: -0.6, y: 0.3 }];

      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
    }
  }]);
  return Box;
}();

/**
 * Drawing methods for the diamond endpoint.
 */


var Diamond = function () {
  function Diamond() {
    (0, _classCallCheck3['default'])(this, Diamond);
  }

  (0, _createClass3['default'])(Diamond, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      var points = [{ x: 0, y: 0 }, { x: -0.5, y: -0.3 }, { x: -1, y: 0 }, { x: -0.5, y: 0.3 }];

      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
    }
  }]);
  return Diamond;
}();

/**
 * Drawing methods for the vee endpoint.
 * @extends EndPoint
 */


var Vee = function () {
  function Vee() {
    (0, _classCallCheck3['default'])(this, Vee);
  }

  (0, _createClass3['default'])(Vee, null, [{
    key: 'draw',

    /**
     * Draw this shape at the end of a line.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{ x: -1, y: 0.3 }, { x: -0.5, y: 0 }, { x: -1, y: -0.3 }, { x: 0, y: 0 }];

      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
    }
  }]);
  return Vee;
}();

/**
 * Drawing methods for the endpoints.
 */


var EndPoints = function () {
  function EndPoints() {
    (0, _classCallCheck3['default'])(this, EndPoints);
  }

  (0, _createClass3['default'])(EndPoints, null, [{
    key: 'draw',

    /**
     * Draw an endpoint
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowData} arrowData
     * @static
     */
    value: function draw(ctx, arrowData) {
      var type;
      if (arrowData.type) {
        type = arrowData.type.toLowerCase();
      }

      switch (type) {
        case 'circle':
          Circle.draw(ctx, arrowData);
          break;
        case 'box':
          Box.draw(ctx, arrowData);
          break;
        case 'crow':
          Crow.draw(ctx, arrowData);
          break;
        case 'curve':
          Curve.draw(ctx, arrowData);
          break;
        case 'diamond':
          Diamond.draw(ctx, arrowData);
          break;
        case 'inv_curve':
          InvertedCurve.draw(ctx, arrowData);
          break;
        case 'triangle':
          Triangle.draw(ctx, arrowData);
          break;
        case 'inv_triangle':
          InvertedTriangle.draw(ctx, arrowData);
          break;
        case 'bar':
          Bar.draw(ctx, arrowData);
          break;
        case 'vee':
          Vee.draw(ctx, arrowData);
          break;
        case 'arrow': // fall-through
        default:
          Arrow.draw(ctx, arrowData);
      }
    }
  }]);
  return EndPoints;
}();

exports['default'] = EndPoints;

/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Barnes Hut Solver
 */
var BarnesHutSolver = function () {
  /**
   * @param {Object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {Object} options
   */
  function BarnesHutSolver(body, physicsBody, options) {
    (0, _classCallCheck3['default'])(this, BarnesHutSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.barnesHutTree;
    this.setOptions(options);
    this.randomSeed = 5;

    // debug: show grid
    // this.body.emitter.on("afterDrawing", (ctx) => {this._debug(ctx,'#ff0000')})
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3['default'])(BarnesHutSolver, [{
    key: 'setOptions',
    value: function setOptions(options) {
      this.options = options;
      this.thetaInversed = 1 / this.options.theta;

      // if 1 then min distance = 0.5, if 0.5 then min distance = 0.5 + 0.5*node.shape.radius
      this.overlapAvoidanceFactor = 1 - Math.max(0, Math.min(1, this.options.avoidOverlap));
    }

    /**
     *
     * @returns {number} random integer
     */

  }, {
    key: 'seededRandom',
    value: function seededRandom() {
      var x = Math.sin(this.randomSeed++) * 10000;
      return x - Math.floor(x);
    }

    /**
     * This function calculates the forces the nodes apply on each other based on a gravitational model.
     * The Barnes Hut method is used to speed up this N-body simulation.
     *
     * @private
     */

  }, {
    key: 'solve',
    value: function solve() {
      if (this.options.gravitationalConstant !== 0 && this.physicsBody.physicsNodeIndices.length > 0) {
        var node = void 0;
        var nodes = this.body.nodes;
        var nodeIndices = this.physicsBody.physicsNodeIndices;
        var nodeCount = nodeIndices.length;

        // create the tree
        var barnesHutTree = this._formBarnesHutTree(nodes, nodeIndices);

        // for debugging
        this.barnesHutTree = barnesHutTree;

        // place the nodes one by one recursively
        for (var i = 0; i < nodeCount; i++) {
          node = nodes[nodeIndices[i]];
          if (node.options.mass > 0) {
            // starting with root is irrelevant, it never passes the BarnesHutSolver condition
            this._getForceContributions(barnesHutTree.root, node);
          }
        }
      }
    }

    /**
     * @param {Object} parentBranch
     * @param {Node} node
     * @private
     */

  }, {
    key: '_getForceContributions',
    value: function _getForceContributions(parentBranch, node) {
      this._getForceContribution(parentBranch.children.NW, node);
      this._getForceContribution(parentBranch.children.NE, node);
      this._getForceContribution(parentBranch.children.SW, node);
      this._getForceContribution(parentBranch.children.SE, node);
    }

    /**
     * This function traverses the barnesHutTree. It checks when it can approximate distant nodes with their center of mass.
     * If a region contains a single node, we check if it is not itself, then we apply the force.
     *
     * @param {Object} parentBranch
     * @param {Node} node
     * @private
     */

  }, {
    key: '_getForceContribution',
    value: function _getForceContribution(parentBranch, node) {
      // we get no force contribution from an empty region
      if (parentBranch.childrenCount > 0) {
        var dx = void 0,
            dy = void 0,
            distance = void 0;

        // get the distance from the center of mass to the node.
        dx = parentBranch.centerOfMass.x - node.x;
        dy = parentBranch.centerOfMass.y - node.y;
        distance = Math.sqrt(dx * dx + dy * dy);

        // BarnesHutSolver condition
        // original condition : s/d < theta = passed  ===  d/s > 1/theta = passed
        // calcSize = 1/s --> d * 1/s > 1/theta = passed
        if (distance * parentBranch.calcSize > this.thetaInversed) {
          this._calculateForces(distance, dx, dy, node, parentBranch);
        } else {
          // Did not pass the condition, go into children if available
          if (parentBranch.childrenCount === 4) {
            this._getForceContributions(parentBranch, node);
          } else {
            // parentBranch must have only one node, if it was empty we wouldnt be here
            if (parentBranch.children.data.id != node.id) {
              // if it is not self
              this._calculateForces(distance, dx, dy, node, parentBranch);
            }
          }
        }
      }
    }

    /**
     * Calculate the forces based on the distance.
     *
     * @param {number} distance
     * @param {number} dx
     * @param {number} dy
     * @param {Node} node
     * @param {Object} parentBranch
     * @private
     */

  }, {
    key: '_calculateForces',
    value: function _calculateForces(distance, dx, dy, node, parentBranch) {
      if (distance === 0) {
        distance = 0.1;
        dx = distance;
      }

      if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
        distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
      }

      // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
      // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce
      var gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass / Math.pow(distance, 3);
      var fx = dx * gravityForce;
      var fy = dy * gravityForce;

      this.physicsBody.forces[node.id].x += fx;
      this.physicsBody.forces[node.id].y += fy;
    }

    /**
     * This function constructs the barnesHut tree recursively. It creates the root, splits it and starts placing the nodes.
     *
     * @param {Array.<Node>} nodes
     * @param {Array.<number>} nodeIndices
     * @returns {{root: {centerOfMass: {x: number, y: number}, mass: number, range: {minX: number, maxX: number, minY: number, maxY: number}, size: number, calcSize: number, children: {data: null}, maxWidth: number, level: number, childrenCount: number}}} BarnesHutTree
     * @private
     */

  }, {
    key: '_formBarnesHutTree',
    value: function _formBarnesHutTree(nodes, nodeIndices) {
      var node = void 0;
      var nodeCount = nodeIndices.length;

      var minX = nodes[nodeIndices[0]].x;
      var minY = nodes[nodeIndices[0]].y;
      var maxX = nodes[nodeIndices[0]].x;
      var maxY = nodes[nodeIndices[0]].y;

      // get the range of the nodes
      for (var i = 1; i < nodeCount; i++) {
        var _node = nodes[nodeIndices[i]];
        var x = _node.x;
        var y = _node.y;
        if (_node.options.mass > 0) {
          if (x < minX) {
            minX = x;
          }
          if (x > maxX) {
            maxX = x;
          }
          if (y < minY) {
            minY = y;
          }
          if (y > maxY) {
            maxY = y;
          }
        }
      }
      // make the range a square
      var sizeDiff = Math.abs(maxX - minX) - Math.abs(maxY - minY); // difference between X and Y
      if (sizeDiff > 0) {
        minY -= 0.5 * sizeDiff;
        maxY += 0.5 * sizeDiff;
      } // xSize > ySize
      else {
          minX += 0.5 * sizeDiff;
          maxX -= 0.5 * sizeDiff;
        } // xSize < ySize

      var minimumTreeSize = 1e-5;
      var rootSize = Math.max(minimumTreeSize, Math.abs(maxX - minX));
      var halfRootSize = 0.5 * rootSize;
      var centerX = 0.5 * (minX + maxX),
          centerY = 0.5 * (minY + maxY);

      // construct the barnesHutTree
      var barnesHutTree = {
        root: {
          centerOfMass: { x: 0, y: 0 },
          mass: 0,
          range: {
            minX: centerX - halfRootSize,
            maxX: centerX + halfRootSize,
            minY: centerY - halfRootSize,
            maxY: centerY + halfRootSize
          },
          size: rootSize,
          calcSize: 1 / rootSize,
          children: { data: null },
          maxWidth: 0,
          level: 0,
          childrenCount: 4
        }
      };
      this._splitBranch(barnesHutTree.root);

      // place the nodes one by one recursively
      for (var _i = 0; _i < nodeCount; _i++) {
        node = nodes[nodeIndices[_i]];
        if (node.options.mass > 0) {
          this._placeInTree(barnesHutTree.root, node);
        }
      }

      // make global
      return barnesHutTree;
    }

    /**
     * this updates the mass of a branch. this is increased by adding a node.
     *
     * @param {Object} parentBranch
     * @param {Node} node
     * @private
     */

  }, {
    key: '_updateBranchMass',
    value: function _updateBranchMass(parentBranch, node) {
      var centerOfMass = parentBranch.centerOfMass;
      var totalMass = parentBranch.mass + node.options.mass;
      var totalMassInv = 1 / totalMass;

      centerOfMass.x = centerOfMass.x * parentBranch.mass + node.x * node.options.mass;
      centerOfMass.x *= totalMassInv;

      centerOfMass.y = centerOfMass.y * parentBranch.mass + node.y * node.options.mass;
      centerOfMass.y *= totalMassInv;

      parentBranch.mass = totalMass;
      var biggestSize = Math.max(Math.max(node.height, node.radius), node.width);
      parentBranch.maxWidth = parentBranch.maxWidth < biggestSize ? biggestSize : parentBranch.maxWidth;
    }

    /**
     * determine in which branch the node will be placed.
     *
     * @param {Object} parentBranch
     * @param {Node} node
     * @param {boolean} skipMassUpdate
     * @private
     */

  }, {
    key: '_placeInTree',
    value: function _placeInTree(parentBranch, node, skipMassUpdate) {
      if (skipMassUpdate != true || skipMassUpdate === undefined) {
        // update the mass of the branch.
        this._updateBranchMass(parentBranch, node);
      }

      var range = parentBranch.children.NW.range;
      var region = void 0;
      if (range.maxX > node.x) {
        // in NW or SW
        if (range.maxY > node.y) {
          region = 'NW';
        } else {
          region = 'SW';
        }
      } else {
        // in NE or SE
        if (range.maxY > node.y) {
          region = 'NE';
        } else {
          region = 'SE';
        }
      }

      this._placeInRegion(parentBranch, node, region);
    }

    /**
     * actually place the node in a region (or branch)
     *
     * @param {Object} parentBranch
     * @param {Node} node
     * @param {'NW'| 'NE' | 'SW' | 'SE'} region
     * @private
     */

  }, {
    key: '_placeInRegion',
    value: function _placeInRegion(parentBranch, node, region) {
      var children = parentBranch.children[region];

      switch (children.childrenCount) {
        case 0:
          // place node here
          children.children.data = node;
          children.childrenCount = 1;
          this._updateBranchMass(children, node);
          break;
        case 1:
          // convert into children
          // if there are two nodes exactly overlapping (on init, on opening of cluster etc.)
          // we move one node a little bit and we do not put it in the tree.
          if (children.children.data.x === node.x && children.children.data.y === node.y) {
            node.x += this.seededRandom();
            node.y += this.seededRandom();
          } else {
            this._splitBranch(children);
            this._placeInTree(children, node);
          }
          break;
        case 4:
          // place in branch
          this._placeInTree(children, node);
          break;
      }
    }

    /**
     * this function splits a branch into 4 sub branches. If the branch contained a node, we place it in the subbranch
     * after the split is complete.
     *
     * @param {Object} parentBranch
     * @private
     */

  }, {
    key: '_splitBranch',
    value: function _splitBranch(parentBranch) {
      // if the branch is shaded with a node, replace the node in the new subset.
      var containedNode = null;
      if (parentBranch.childrenCount === 1) {
        containedNode = parentBranch.children.data;
        parentBranch.mass = 0;
        parentBranch.centerOfMass.x = 0;
        parentBranch.centerOfMass.y = 0;
      }
      parentBranch.childrenCount = 4;
      parentBranch.children.data = null;
      this._insertRegion(parentBranch, 'NW');
      this._insertRegion(parentBranch, 'NE');
      this._insertRegion(parentBranch, 'SW');
      this._insertRegion(parentBranch, 'SE');

      if (containedNode != null) {
        this._placeInTree(parentBranch, containedNode);
      }
    }

    /**
     * This function subdivides the region into four new segments.
     * Specifically, this inserts a single new segment.
     * It fills the children section of the parentBranch
     *
     * @param {Object} parentBranch
     * @param {'NW'| 'NE' | 'SW' | 'SE'} region
     * @private
     */

  }, {
    key: '_insertRegion',
    value: function _insertRegion(parentBranch, region) {
      var minX = void 0,
          maxX = void 0,
          minY = void 0,
          maxY = void 0;
      var childSize = 0.5 * parentBranch.size;
      switch (region) {
        case 'NW':
          minX = parentBranch.range.minX;
          maxX = parentBranch.range.minX + childSize;
          minY = parentBranch.range.minY;
          maxY = parentBranch.range.minY + childSize;
          break;
        case 'NE':
          minX = parentBranch.range.minX + childSize;
          maxX = parentBranch.range.maxX;
          minY = parentBranch.range.minY;
          maxY = parentBranch.range.minY + childSize;
          break;
        case 'SW':
          minX = parentBranch.range.minX;
          maxX = parentBranch.range.minX + childSize;
          minY = parentBranch.range.minY + childSize;
          maxY = parentBranch.range.maxY;
          break;
        case 'SE':
          minX = parentBranch.range.minX + childSize;
          maxX = parentBranch.range.maxX;
          minY = parentBranch.range.minY + childSize;
          maxY = parentBranch.range.maxY;
          break;
      }

      parentBranch.children[region] = {
        centerOfMass: { x: 0, y: 0 },
        mass: 0,
        range: { minX: minX, maxX: maxX, minY: minY, maxY: maxY },
        size: 0.5 * parentBranch.size,
        calcSize: 2 * parentBranch.calcSize,
        children: { data: null },
        maxWidth: 0,
        level: parentBranch.level + 1,
        childrenCount: 0
      };
    }

    //---------------------------  DEBUGGING BELOW  ---------------------------//

    /**
     * This function is for debugging purposed, it draws the tree.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {string} color
     * @private
     */

  }, {
    key: '_debug',
    value: function _debug(ctx, color) {
      if (this.barnesHutTree !== undefined) {
        ctx.lineWidth = 1;

        this._drawBranch(this.barnesHutTree.root, ctx, color);
      }
    }

    /**
     * This function is for debugging purposes. It draws the branches recursively.
     *
     * @param {Object} branch
     * @param {CanvasRenderingContext2D} ctx
     * @param {string} color
     * @private
     */

  }, {
    key: '_drawBranch',
    value: function _drawBranch(branch, ctx, color) {
      if (color === undefined) {
        color = '#FF0000';
      }

      if (branch.childrenCount === 4) {
        this._drawBranch(branch.children.NW, ctx);
        this._drawBranch(branch.children.NE, ctx);
        this._drawBranch(branch.children.SE, ctx);
        this._drawBranch(branch.children.SW, ctx);
      }
      ctx.strokeStyle = color;
      ctx.beginPath();
      ctx.moveTo(branch.range.minX, branch.range.minY);
      ctx.lineTo(branch.range.maxX, branch.range.minY);
      ctx.stroke();

      ctx.beginPath();
      ctx.moveTo(branch.range.maxX, branch.range.minY);
      ctx.lineTo(branch.range.maxX, branch.range.maxY);
      ctx.stroke();

      ctx.beginPath();
      ctx.moveTo(branch.range.maxX, branch.range.maxY);
      ctx.lineTo(branch.range.minX, branch.range.maxY);
      ctx.stroke();

      ctx.beginPath();
      ctx.moveTo(branch.range.minX, branch.range.maxY);
      ctx.lineTo(branch.range.minX, branch.range.minY);
      ctx.stroke();

      /*
       if (branch.mass > 0) {
       ctx.circle(branch.centerOfMass.x, branch.centerOfMass.y, 3*branch.mass);
       ctx.stroke();
       }
       */
    }
  }]);
  return BarnesHutSolver;
}();

exports['default'] = BarnesHutSolver;

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Central Gravity Solver
 */
var CentralGravitySolver = function () {
  /**
   * @param {Object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {Object} options
   */
  function CentralGravitySolver(body, physicsBody, options) {
    (0, _classCallCheck3["default"])(this, CentralGravitySolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3["default"])(CentralGravitySolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }

    /**
     * Calculates forces for each node
     */

  }, {
    key: "solve",
    value: function solve() {
      var dx = void 0,
          dy = void 0,
          distance = void 0,
          node = void 0;
      var nodes = this.body.nodes;
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var forces = this.physicsBody.forces;

      for (var i = 0; i < nodeIndices.length; i++) {
        var nodeId = nodeIndices[i];
        node = nodes[nodeId];
        dx = -node.x;
        dy = -node.y;
        distance = Math.sqrt(dx * dx + dy * dy);

        this._calculateForces(distance, dx, dy, forces, node);
      }
    }

    /**
     * Calculate the forces based on the distance.
     * @param {number} distance
     * @param {number} dx
     * @param {number} dy
     * @param {Object<Node.id, vis.Node>} forces
     * @param {Node} node
     * @private
     */

  }, {
    key: "_calculateForces",
    value: function _calculateForces(distance, dx, dy, forces, node) {
      var gravityForce = distance === 0 ? 0 : this.options.centralGravity / distance;
      forces[node.id].x = dx * gravityForce;
      forces[node.id].y = dy * gravityForce;
    }
  }]);
  return CentralGravitySolver;
}();

exports["default"] = CentralGravitySolver;

/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(188);

/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
/**
 * This object contains all possible options. It will check if the types are correct, if required if the option is one
 * of the allowed values.
 *
 * __any__ means that the name of the property does not matter.
 * __type__ is a required field for all objects and contains the allowed types of all objects
 */
var string = 'string';
var bool = 'boolean';
var number = 'number';
var array = 'array';
var object = 'object'; // should only be in a __type__ property
var dom = 'dom';
var any = 'any';

// List of endpoints
var endPoints = ['arrow', 'circle', 'bar'];

var allOptions = {
  configure: {
    enabled: { boolean: bool },
    filter: { boolean: bool, string: string, array: array, 'function': 'function' },
    container: { dom: dom },
    showButton: { boolean: bool },
    __type__: { object: object, boolean: bool, string: string, array: array, 'function': 'function' }
  },
  edges: {
    arrows: {
      to: {
        enabled: { boolean: bool },
        scaleFactor: { number: number },
        type: { string: endPoints },
        __type__: { object: object, boolean: bool }
      },
      middle: {
        enabled: { boolean: bool },
        scaleFactor: { number: number },
        type: { string: endPoints },
        __type__: { object: object, boolean: bool }
      },
      from: {
        enabled: { boolean: bool },
        scaleFactor: { number: number },
        type: { string: endPoints },
        __type__: { object: object, boolean: bool }
      },
      __type__: { string: ['from', 'to', 'middle'], object: object }
    },
    arrowStrikethrough: { boolean: bool },
    background: {
      enabled: { boolean: bool },
      color: { string: string },
      size: { number: number },
      dashes: { boolean: bool, array: array },
      __type__: { object: object, boolean: bool }
    },
    chosen: {
      label: { boolean: bool, 'function': 'function' },
      edge: { boolean: bool, 'function': 'function' },
      __type__: { object: object, boolean: bool }
    },
    color: {
      color: { string: string },
      highlight: { string: string },
      hover: { string: string },
      inherit: { string: ['from', 'to', 'both'], boolean: bool },
      opacity: { number: number },
      __type__: { object: object, string: string }
    },
    dashes: { boolean: bool, array: array },
    font: {
      color: { string: string },
      size: { number: number }, // px
      face: { string: string },
      background: { string: string },
      strokeWidth: { number: number }, // px
      strokeColor: { string: string },
      align: { string: ['horizontal', 'top', 'middle', 'bottom'] },
      vadjust: { number: number },
      multi: { boolean: bool, string: string },
      bold: {
        color: { string: string },
        size: { number: number }, // px
        face: { string: string },
        mod: { string: string },
        vadjust: { number: number },
        __type__: { object: object, string: string }
      },
      boldital: {
        color: { string: string },
        size: { number: number }, // px
        face: { string: string },
        mod: { string: string },
        vadjust: { number: number },
        __type__: { object: object, string: string }
      },
      ital: {
        color: { string: string },
        size: { number: number }, // px
        face: { string: string },
        mod: { string: string },
        vadjust: { number: number },
        __type__: { object: object, string: string }
      },
      mono: {
        color: { string: string },
        size: { number: number }, // px
        face: { string: string },
        mod: { string: string },
        vadjust: { number: number },
        __type__: { object: object, string: string }
      },
      __type__: { object: object, string: string }
    },
    hidden: { boolean: bool },
    hoverWidth: { 'function': 'function', number: number },
    label: { string: string, undefined: 'undefined' },
    labelHighlightBold: { boolean: bool },
    length: { number: number, undefined: 'undefined' },
    physics: { boolean: bool },
    scaling: {
      min: { number: number },
      max: { number: number },
      label: {
        enabled: { boolean: bool },
        min: { number: number },
        max: { number: number },
        maxVisible: { number: number },
        drawThreshold: { number: number },
        __type__: { object: object, boolean: bool }
      },
      customScalingFunction: { 'function': 'function' },
      __type__: { object: object }
    },
    selectionWidth: { 'function': 'function', number: number },
    selfReferenceSize: { number: number },
    shadow: {
      enabled: { boolean: bool },
      color: { string: string },
      size: { number: number },
      x: { number: number },
      y: { number: number },
      __type__: { object: object, boolean: bool }
    },
    smooth: {
      enabled: { boolean: bool },
      type: {
        string: ['dynamic', 'continuous', 'discrete', 'diagonalCross', 'straightCross', 'horizontal', 'vertical', 'curvedCW', 'curvedCCW', 'cubicBezier']
      },
      roundness: { number: number },
      forceDirection: {
        string: ['horizontal', 'vertical', 'none'],
        boolean: bool
      },
      __type__: { object: object, boolean: bool }
    },
    title: { string: string, undefined: 'undefined' },
    width: { number: number },
    widthConstraint: {
      maximum: { number: number },
      __type__: { object: object, boolean: bool, number: number }
    },
    value: { number: number, undefined: 'undefined' },
    __type__: { object: object }
  },
  groups: {
    useDefaultGroups: { boolean: bool },
    __any__: 'get from nodes, will be overwritten below',
    __type__: { object: object }
  },
  interaction: {
    dragNodes: { boolean: bool },
    dragView: { boolean: bool },
    hideEdgesOnDrag: { boolean: bool },
    hideEdgesOnZoom: { boolean: bool },
    hideNodesOnDrag: { boolean: bool },
    hover: { boolean: bool },
    keyboard: {
      enabled: { boolean: bool },
      speed: {
        x: { number: number },
        y: { number: number },
        zoom: { number: number },
        __type__: { object: object }
      },
      bindToWindow: { boolean: bool },
      __type__: { object: object, boolean: bool }
    },
    multiselect: { boolean: bool },
    navigationButtons: { boolean: bool },
    selectable: { boolean: bool },
    selectConnectedEdges: { boolean: bool },
    hoverConnectedEdges: { boolean: bool },
    tooltipDelay: { number: number },
    zoomView: { boolean: bool },
    zoomSpeed: { number: number },
    __type__: { object: object }
  },
  layout: {
    randomSeed: { undefined: 'undefined', number: number },
    improvedLayout: { boolean: bool },
    hierarchical: {
      enabled: { boolean: bool },
      levelSeparation: { number: number },
      nodeSpacing: { number: number },
      treeSpacing: { number: number },
      blockShifting: { boolean: bool },
      edgeMinimization: { boolean: bool },
      parentCentralization: { boolean: bool },
      direction: { string: ['UD', 'DU', 'LR', 'RL'] }, // UD, DU, LR, RL
      sortMethod: { string: ['hubsize', 'directed'] }, // hubsize, directed
      __type__: { object: object, boolean: bool }
    },
    __type__: { object: object }
  },
  manipulation: {
    enabled: { boolean: bool },
    initiallyActive: { boolean: bool },
    addNode: { boolean: bool, 'function': 'function' },
    addEdge: { boolean: bool, 'function': 'function' },
    editNode: { 'function': 'function' },
    editEdge: {
      editWithoutDrag: { 'function': 'function' },
      __type__: { object: object, boolean: bool, 'function': 'function' }
    },
    deleteNode: { boolean: bool, 'function': 'function' },
    deleteEdge: { boolean: bool, 'function': 'function' },
    controlNodeStyle: 'get from nodes, will be overwritten below',
    __type__: { object: object, boolean: bool }
  },
  nodes: {
    borderWidth: { number: number },
    borderWidthSelected: { number: number, undefined: 'undefined' },
    brokenImage: { string: string, undefined: 'undefined' },
    chosen: {
      label: { boolean: bool, 'function': 'function' },
      node: { boolean: bool, 'function': 'function' },
      __type__: { object: object, boolean: bool }
    },
    color: {
      border: { string: string },
      background: { string: string },
      highlight: {
        border: { string: string },
        background: { string: string },
        __type__: { object: object, string: string }
      },
      hover: {
        border: { string: string },
        background: { string: string },
        __type__: { object: object, string: string }
      },
      __type__: { object: object, string: string }
    },
    fixed: {
      x: { boolean: bool },
      y: { boolean: bool },
      __type__: { object: object, boolean: bool }
    },
    font: {
      align: { string: string },
      color: { string: string },
      size: { number: number }, // px
      face: { string: string },
      background: { string: string },
      strokeWidth: { number: number }, // px
      strokeColor: { string: string },
      vadjust: { number: number },
      multi: { boolean: bool, string: string },
      bold: {
        color: { string: string },
        size: { number: number }, // px
        face: { string: string },
        mod: { string: string },
        vadjust: { number: number },
        __type__: { object: object, string: string }
      },
      boldital: {
        color: { string: string },
        size: { number: number }, // px
        face: { string: string },
        mod: { string: string },
        vadjust: { number: number },
        __type__: { object: object, string: string }
      },
      ital: {
        color: { string: string },
        size: { number: number }, // px
        face: { string: string },
        mod: { string: string },
        vadjust: { number: number },
        __type__: { object: object, string: string }
      },
      mono: {
        color: { string: string },
        size: { number: number }, // px
        face: { string: string },
        mod: { string: string },
        vadjust: { number: number },
        __type__: { object: object, string: string }
      },
      __type__: { object: object, string: string }
    },
    group: { string: string, number: number, undefined: 'undefined' },
    heightConstraint: {
      minimum: { number: number },
      valign: { string: string },
      __type__: { object: object, boolean: bool, number: number }
    },
    hidden: { boolean: bool },
    icon: {
      face: { string: string },
      code: { string: string }, //'\uf007',
      size: { number: number }, //50,
      color: { string: string },
      __type__: { object: object }
    },
    id: { string: string, number: number },
    image: {
      selected: { string: string, undefined: 'undefined' }, // --> URL
      unselected: { string: string, undefined: 'undefined' }, // --> URL
      __type__: { object: object, string: string }
    },
    label: { string: string, undefined: 'undefined' },
    labelHighlightBold: { boolean: bool },
    level: { number: number, undefined: 'undefined' },
    margin: {
      top: { number: number },
      right: { number: number },
      bottom: { number: number },
      left: { number: number },
      __type__: { object: object, number: number }
    },
    mass: { number: number },
    physics: { boolean: bool },
    scaling: {
      min: { number: number },
      max: { number: number },
      label: {
        enabled: { boolean: bool },
        min: { number: number },
        max: { number: number },
        maxVisible: { number: number },
        drawThreshold: { number: number },
        __type__: { object: object, boolean: bool }
      },
      customScalingFunction: { 'function': 'function' },
      __type__: { object: object }
    },
    shadow: {
      enabled: { boolean: bool },
      color: { string: string },
      size: { number: number },
      x: { number: number },
      y: { number: number },
      __type__: { object: object, boolean: bool }
    },
    shape: {
      string: ['ellipse', 'circle', 'database', 'box', 'text', 'image', 'circularImage', 'diamond', 'dot', 'star', 'triangle', 'triangleDown', 'square', 'icon', 'hexagon']
    },
    shapeProperties: {
      borderDashes: { boolean: bool, array: array },
      borderRadius: { number: number },
      interpolation: { boolean: bool },
      useImageSize: { boolean: bool },
      useBorderWithImage: { boolean: bool },
      __type__: { object: object }
    },
    size: { number: number },
    title: { string: string, dom: dom, undefined: 'undefined' },
    value: { number: number, undefined: 'undefined' },
    widthConstraint: {
      minimum: { number: number },
      maximum: { number: number },
      __type__: { object: object, boolean: bool, number: number }
    },
    x: { number: number },
    y: { number: number },
    __type__: { object: object }
  },
  physics: {
    enabled: { boolean: bool },
    barnesHut: {
      gravitationalConstant: { number: number },
      centralGravity: { number: number },
      springLength: { number: number },
      springConstant: { number: number },
      damping: { number: number },
      avoidOverlap: { number: number },
      __type__: { object: object }
    },
    forceAtlas2Based: {
      gravitationalConstant: { number: number },
      centralGravity: { number: number },
      springLength: { number: number },
      springConstant: { number: number },
      damping: { number: number },
      avoidOverlap: { number: number },
      __type__: { object: object }
    },
    repulsion: {
      centralGravity: { number: number },
      springLength: { number: number },
      springConstant: { number: number },
      nodeDistance: { number: number },
      damping: { number: number },
      __type__: { object: object }
    },
    hierarchicalRepulsion: {
      centralGravity: { number: number },
      springLength: { number: number },
      springConstant: { number: number },
      nodeDistance: { number: number },
      damping: { number: number },
      __type__: { object: object }
    },
    maxVelocity: { number: number },
    minVelocity: { number: number }, // px/s
    solver: {
      string: ['barnesHut', 'repulsion', 'hierarchicalRepulsion', 'forceAtlas2Based']
    },
    stabilization: {
      enabled: { boolean: bool },
      iterations: { number: number }, // maximum number of iteration to stabilize
      updateInterval: { number: number },
      onlyDynamicEdges: { boolean: bool },
      fit: { boolean: bool },
      __type__: { object: object, boolean: bool }
    },
    timestep: { number: number },
    adaptiveTimestep: { boolean: bool },
    __type__: { object: object, boolean: bool }
  },

  //globals :
  autoResize: { boolean: bool },
  clickToUse: { boolean: bool },
  locale: { string: string },
  locales: {
    __any__: { any: any },
    __type__: { object: object }
  },
  height: { string: string },
  width: { string: string },
  __type__: { object: object }
};

allOptions.groups.__any__ = allOptions.nodes;
allOptions.manipulation.controlNodeStyle = allOptions.nodes;

var configureOptions = {
  nodes: {
    borderWidth: [1, 0, 10, 1],
    borderWidthSelected: [2, 0, 10, 1],
    color: {
      border: ['color', '#2B7CE9'],
      background: ['color', '#97C2FC'],
      highlight: {
        border: ['color', '#2B7CE9'],
        background: ['color', '#D2E5FF']
      },
      hover: {
        border: ['color', '#2B7CE9'],
        background: ['color', '#D2E5FF']
      }
    },
    fixed: {
      x: false,
      y: false
    },
    font: {
      color: ['color', '#343434'],
      size: [14, 0, 100, 1], // px
      face: ['arial', 'verdana', 'tahoma'],
      background: ['color', 'none'],
      strokeWidth: [0, 0, 50, 1], // px
      strokeColor: ['color', '#ffffff']
    },
    //group: 'string',
    hidden: false,
    labelHighlightBold: true,
    //icon: {
    //  face: 'string',  //'FontAwesome',
    //  code: 'string',  //'\uf007',
    //  size: [50, 0, 200, 1],  //50,
    //  color: ['color','#2B7CE9']   //'#aa00ff'
    //},
    //image: 'string', // --> URL
    physics: true,
    scaling: {
      min: [10, 0, 200, 1],
      max: [30, 0, 200, 1],
      label: {
        enabled: false,
        min: [14, 0, 200, 1],
        max: [30, 0, 200, 1],
        maxVisible: [30, 0, 200, 1],
        drawThreshold: [5, 0, 20, 1]
      }
    },
    shadow: {
      enabled: false,
      color: 'rgba(0,0,0,0.5)',
      size: [10, 0, 20, 1],
      x: [5, -30, 30, 1],
      y: [5, -30, 30, 1]
    },
    shape: ['ellipse', 'box', 'circle', 'database', 'diamond', 'dot', 'square', 'star', 'text', 'triangle', 'triangleDown', 'hexagon'],
    shapeProperties: {
      borderDashes: false,
      borderRadius: [6, 0, 20, 1],
      interpolation: true,
      useImageSize: false
    },
    size: [25, 0, 200, 1]
  },
  edges: {
    arrows: {
      to: { enabled: false, scaleFactor: [1, 0, 3, 0.05], type: 'arrow' },
      middle: { enabled: false, scaleFactor: [1, 0, 3, 0.05], type: 'arrow' },
      from: { enabled: false, scaleFactor: [1, 0, 3, 0.05], type: 'arrow' }
    },
    arrowStrikethrough: true,
    color: {
      color: ['color', '#848484'],
      highlight: ['color', '#848484'],
      hover: ['color', '#848484'],
      inherit: ['from', 'to', 'both', true, false],
      opacity: [1, 0, 1, 0.05]
    },
    dashes: false,
    font: {
      color: ['color', '#343434'],
      size: [14, 0, 100, 1], // px
      face: ['arial', 'verdana', 'tahoma'],
      background: ['color', 'none'],
      strokeWidth: [2, 0, 50, 1], // px
      strokeColor: ['color', '#ffffff'],
      align: ['horizontal', 'top', 'middle', 'bottom']
    },
    hidden: false,
    hoverWidth: [1.5, 0, 5, 0.1],
    labelHighlightBold: true,
    physics: true,
    scaling: {
      min: [1, 0, 100, 1],
      max: [15, 0, 100, 1],
      label: {
        enabled: true,
        min: [14, 0, 200, 1],
        max: [30, 0, 200, 1],
        maxVisible: [30, 0, 200, 1],
        drawThreshold: [5, 0, 20, 1]
      }
    },
    selectionWidth: [1.5, 0, 5, 0.1],
    selfReferenceSize: [20, 0, 200, 1],
    shadow: {
      enabled: false,
      color: 'rgba(0,0,0,0.5)',
      size: [10, 0, 20, 1],
      x: [5, -30, 30, 1],
      y: [5, -30, 30, 1]
    },
    smooth: {
      enabled: true,
      type: ['dynamic', 'continuous', 'discrete', 'diagonalCross', 'straightCross', 'horizontal', 'vertical', 'curvedCW', 'curvedCCW', 'cubicBezier'],
      forceDirection: ['horizontal', 'vertical', 'none'],
      roundness: [0.5, 0, 1, 0.05]
    },
    width: [1, 0, 30, 1]
  },
  layout: {
    //randomSeed: [0, 0, 500, 1],
    //improvedLayout: true,
    hierarchical: {
      enabled: false,
      levelSeparation: [150, 20, 500, 5],
      nodeSpacing: [100, 20, 500, 5],
      treeSpacing: [200, 20, 500, 5],
      blockShifting: true,
      edgeMinimization: true,
      parentCentralization: true,
      direction: ['UD', 'DU', 'LR', 'RL'], // UD, DU, LR, RL
      sortMethod: ['hubsize', 'directed'] // hubsize, directed
    }
  },
  interaction: {
    dragNodes: true,
    dragView: true,
    hideEdgesOnDrag: false,
    hideEdgesOnZoom: false,
    hideNodesOnDrag: false,
    hover: false,
    keyboard: {
      enabled: false,
      speed: {
        x: [10, 0, 40, 1],
        y: [10, 0, 40, 1],
        zoom: [0.02, 0, 0.1, 0.005]
      },
      bindToWindow: true
    },
    multiselect: false,
    navigationButtons: false,
    selectable: true,
    selectConnectedEdges: true,
    hoverConnectedEdges: true,
    tooltipDelay: [300, 0, 1000, 25],
    zoomView: true,
    zoomSpeed: 1
  },
  manipulation: {
    enabled: false,
    initiallyActive: false
  },
  physics: {
    enabled: true,
    barnesHut: {
      //theta: [0.5, 0.1, 1, 0.05],
      gravitationalConstant: [-2000, -30000, 0, 50],
      centralGravity: [0.3, 0, 10, 0.05],
      springLength: [95, 0, 500, 5],
      springConstant: [0.04, 0, 1.2, 0.005],
      damping: [0.09, 0, 1, 0.01],
      avoidOverlap: [0, 0, 1, 0.01]
    },
    forceAtlas2Based: {
      //theta: [0.5, 0.1, 1, 0.05],
      gravitationalConstant: [-50, -500, 0, 1],
      centralGravity: [0.01, 0, 1, 0.005],
      springLength: [95, 0, 500, 5],
      springConstant: [0.08, 0, 1.2, 0.005],
      damping: [0.4, 0, 1, 0.01],
      avoidOverlap: [0, 0, 1, 0.01]
    },
    repulsion: {
      centralGravity: [0.2, 0, 10, 0.05],
      springLength: [200, 0, 500, 5],
      springConstant: [0.05, 0, 1.2, 0.005],
      nodeDistance: [100, 0, 500, 5],
      damping: [0.09, 0, 1, 0.01]
    },
    hierarchicalRepulsion: {
      centralGravity: [0.2, 0, 10, 0.05],
      springLength: [100, 0, 500, 5],
      springConstant: [0.01, 0, 1.2, 0.005],
      nodeDistance: [120, 0, 500, 5],
      damping: [0.09, 0, 1, 0.01]
    },
    maxVelocity: [50, 0, 150, 1],
    minVelocity: [0.1, 0.01, 0.5, 0.01],
    solver: ['barnesHut', 'forceAtlas2Based', 'repulsion', 'hierarchicalRepulsion'],
    timestep: [0.5, 0.01, 1, 0.01]
    //adaptiveTimestep: true
  }
};

exports.allOptions = allOptions;
exports.configureOptions = configureOptions;

/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var util = __webpack_require__(2);

// Network
util.extend(exports, __webpack_require__(121));

/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(37);
__webpack_require__(47);
module.exports = __webpack_require__(98);


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var addToUnscopables = __webpack_require__(88);
var step = __webpack_require__(89);
var Iterators = __webpack_require__(25);
var toIObject = __webpack_require__(18);

// 22.1.3.4 Array.prototype.entries()
// 22.1.3.13 Array.prototype.keys()
// 22.1.3.29 Array.prototype.values()
// 22.1.3.30 Array.prototype[@@iterator]()
module.exports = __webpack_require__(60)(Array, 'Array', function (iterated, kind) {
  this._t = toIObject(iterated); // target
  this._i = 0;                   // next index
  this._k = kind;                // kind
// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var kind = this._k;
  var index = this._i++;
  if (!O || index >= O.length) {
    this._t = undefined;
    return step(1);
  }
  if (kind == 'keys') return step(0, index);
  if (kind == 'values') return step(0, O[index]);
  return step(0, [index, O[index]]);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
Iterators.Arguments = Iterators.Array;

addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');


/***/ }),
/* 88 */
/***/ (function(module, exports) {

module.exports = function () { /* empty */ };


/***/ }),
/* 89 */
/***/ (function(module, exports) {

module.exports = function (done, value) {
  return { value: value, done: !!done };
};


/***/ }),
/* 90 */
/***/ (function(module, exports) {

module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var create = __webpack_require__(41);
var descriptor = __webpack_require__(28);
var setToStringTag = __webpack_require__(46);
var IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
__webpack_require__(19)(IteratorPrototype, __webpack_require__(8)('iterator'), function () { return this; });

module.exports = function (Constructor, NAME, next) {
  Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
  setToStringTag(Constructor, NAME + ' Iterator');
};


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(12);
var anObject = __webpack_require__(20);
var getKeys = __webpack_require__(26);

module.exports = __webpack_require__(13) ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = getKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
  return O;
};


/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

// false -> Array#indexOf
// true  -> Array#includes
var toIObject = __webpack_require__(18);
var toLength = __webpack_require__(94);
var toAbsoluteIndex = __webpack_require__(95);
module.exports = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
      if (O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.15 ToLength
var toInteger = __webpack_require__(42);
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(42);
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

var document = __webpack_require__(10).document;
module.exports = document && document.documentElement;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(42);
var defined = __webpack_require__(39);
// true  -> String#at
// false -> String#codePointAt
module.exports = function (TO_STRING) {
  return function (that, pos) {
    var s = String(defined(that));
    var i = toInteger(pos);
    var l = s.length;
    var a, b;
    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
    a = s.charCodeAt(i);
    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
      ? TO_STRING ? s.charAt(i) : a
      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
  };
};


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(20);
var get = __webpack_require__(99);
module.exports = __webpack_require__(6).getIterator = function (it) {
  var iterFn = get(it);
  if (typeof iterFn != 'function') throw TypeError(it + ' is not iterable!');
  return anObject(iterFn.call(it));
};


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

var classof = __webpack_require__(67);
var ITERATOR = __webpack_require__(8)('iterator');
var Iterators = __webpack_require__(25);
module.exports = __webpack_require__(6).getIteratorMethod = function (it) {
  if (it != undefined) return it[ITERATOR]
    || it['@@iterator']
    || Iterators[classof(it)];
};


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(101);
var $Object = __webpack_require__(6).Object;
module.exports = function create(P, D) {
  return $Object.create(P, D);
};


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

var $export = __webpack_require__(11);
// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
$export($export.S, 'Object', { create: __webpack_require__(41) });


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(103);
module.exports = __webpack_require__(6).Object.keys;


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 Object.keys(O)
var toObject = __webpack_require__(30);
var $keys = __webpack_require__(26);

__webpack_require__(68)('keys', function () {
  return function keys(it) {
    return $keys(toObject(it));
  };
});


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(105), __esModule: true };

/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(47);
__webpack_require__(37);
module.exports = __webpack_require__(48).f('iterator');


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(107), __esModule: true };

/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(108);
__webpack_require__(113);
__webpack_require__(114);
__webpack_require__(115);
module.exports = __webpack_require__(6).Symbol;


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// ECMAScript 6 symbols shim
var global = __webpack_require__(10);
var has = __webpack_require__(14);
var DESCRIPTORS = __webpack_require__(13);
var $export = __webpack_require__(11);
var redefine = __webpack_require__(64);
var META = __webpack_require__(109).KEY;
var $fails = __webpack_require__(22);
var shared = __webpack_require__(44);
var setToStringTag = __webpack_require__(46);
var uid = __webpack_require__(29);
var wks = __webpack_require__(8);
var wksExt = __webpack_require__(48);
var wksDefine = __webpack_require__(49);
var enumKeys = __webpack_require__(110);
var isArray = __webpack_require__(111);
var anObject = __webpack_require__(20);
var isObject = __webpack_require__(21);
var toIObject = __webpack_require__(18);
var toPrimitive = __webpack_require__(40);
var createDesc = __webpack_require__(28);
var _create = __webpack_require__(41);
var gOPNExt = __webpack_require__(112);
var $GOPD = __webpack_require__(70);
var $DP = __webpack_require__(12);
var $keys = __webpack_require__(26);
var gOPD = $GOPD.f;
var dP = $DP.f;
var gOPN = gOPNExt.f;
var $Symbol = global.Symbol;
var $JSON = global.JSON;
var _stringify = $JSON && $JSON.stringify;
var PROTOTYPE = 'prototype';
var HIDDEN = wks('_hidden');
var TO_PRIMITIVE = wks('toPrimitive');
var isEnum = {}.propertyIsEnumerable;
var SymbolRegistry = shared('symbol-registry');
var AllSymbols = shared('symbols');
var OPSymbols = shared('op-symbols');
var ObjectProto = Object[PROTOTYPE];
var USE_NATIVE = typeof $Symbol == 'function';
var QObject = global.QObject;
// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
var setter = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
var setSymbolDesc = DESCRIPTORS && $fails(function () {
  return _create(dP({}, 'a', {
    get: function () { return dP(this, 'a', { value: 7 }).a; }
  })).a != 7;
}) ? function (it, key, D) {
  var protoDesc = gOPD(ObjectProto, key);
  if (protoDesc) delete ObjectProto[key];
  dP(it, key, D);
  if (protoDesc && it !== ObjectProto) dP(ObjectProto, key, protoDesc);
} : dP;

var wrap = function (tag) {
  var sym = AllSymbols[tag] = _create($Symbol[PROTOTYPE]);
  sym._k = tag;
  return sym;
};

var isSymbol = USE_NATIVE && typeof $Symbol.iterator == 'symbol' ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  return it instanceof $Symbol;
};

var $defineProperty = function defineProperty(it, key, D) {
  if (it === ObjectProto) $defineProperty(OPSymbols, key, D);
  anObject(it);
  key = toPrimitive(key, true);
  anObject(D);
  if (has(AllSymbols, key)) {
    if (!D.enumerable) {
      if (!has(it, HIDDEN)) dP(it, HIDDEN, createDesc(1, {}));
      it[HIDDEN][key] = true;
    } else {
      if (has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;
      D = _create(D, { enumerable: createDesc(0, false) });
    } return setSymbolDesc(it, key, D);
  } return dP(it, key, D);
};
var $defineProperties = function defineProperties(it, P) {
  anObject(it);
  var keys = enumKeys(P = toIObject(P));
  var i = 0;
  var l = keys.length;
  var key;
  while (l > i) $defineProperty(it, key = keys[i++], P[key]);
  return it;
};
var $create = function create(it, P) {
  return P === undefined ? _create(it) : $defineProperties(_create(it), P);
};
var $propertyIsEnumerable = function propertyIsEnumerable(key) {
  var E = isEnum.call(this, key = toPrimitive(key, true));
  if (this === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return false;
  return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
};
var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {
  it = toIObject(it);
  key = toPrimitive(key, true);
  if (it === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return;
  var D = gOPD(it, key);
  if (D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;
  return D;
};
var $getOwnPropertyNames = function getOwnPropertyNames(it) {
  var names = gOPN(toIObject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (!has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);
  } return result;
};
var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {
  var IS_OP = it === ObjectProto;
  var names = gOPN(IS_OP ? OPSymbols : toIObject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (has(AllSymbols, key = names[i++]) && (IS_OP ? has(ObjectProto, key) : true)) result.push(AllSymbols[key]);
  } return result;
};

// 19.4.1.1 Symbol([description])
if (!USE_NATIVE) {
  $Symbol = function Symbol() {
    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor!');
    var tag = uid(arguments.length > 0 ? arguments[0] : undefined);
    var $set = function (value) {
      if (this === ObjectProto) $set.call(OPSymbols, value);
      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
      setSymbolDesc(this, tag, createDesc(1, value));
    };
    if (DESCRIPTORS && setter) setSymbolDesc(ObjectProto, tag, { configurable: true, set: $set });
    return wrap(tag);
  };
  redefine($Symbol[PROTOTYPE], 'toString', function toString() {
    return this._k;
  });

  $GOPD.f = $getOwnPropertyDescriptor;
  $DP.f = $defineProperty;
  __webpack_require__(69).f = gOPNExt.f = $getOwnPropertyNames;
  __webpack_require__(32).f = $propertyIsEnumerable;
  __webpack_require__(50).f = $getOwnPropertySymbols;

  if (DESCRIPTORS && !__webpack_require__(27)) {
    redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);
  }

  wksExt.f = function (name) {
    return wrap(wks(name));
  };
}

$export($export.G + $export.W + $export.F * !USE_NATIVE, { Symbol: $Symbol });

for (var es6Symbols = (
  // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14
  'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables'
).split(','), j = 0; es6Symbols.length > j;)wks(es6Symbols[j++]);

for (var wellKnownSymbols = $keys(wks.store), k = 0; wellKnownSymbols.length > k;) wksDefine(wellKnownSymbols[k++]);

$export($export.S + $export.F * !USE_NATIVE, 'Symbol', {
  // 19.4.2.1 Symbol.for(key)
  'for': function (key) {
    return has(SymbolRegistry, key += '')
      ? SymbolRegistry[key]
      : SymbolRegistry[key] = $Symbol(key);
  },
  // 19.4.2.5 Symbol.keyFor(sym)
  keyFor: function keyFor(sym) {
    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol!');
    for (var key in SymbolRegistry) if (SymbolRegistry[key] === sym) return key;
  },
  useSetter: function () { setter = true; },
  useSimple: function () { setter = false; }
});

$export($export.S + $export.F * !USE_NATIVE, 'Object', {
  // 19.1.2.2 Object.create(O [, Properties])
  create: $create,
  // 19.1.2.4 Object.defineProperty(O, P, Attributes)
  defineProperty: $defineProperty,
  // 19.1.2.3 Object.defineProperties(O, Properties)
  defineProperties: $defineProperties,
  // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)
  getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
  // 19.1.2.7 Object.getOwnPropertyNames(O)
  getOwnPropertyNames: $getOwnPropertyNames,
  // 19.1.2.8 Object.getOwnPropertySymbols(O)
  getOwnPropertySymbols: $getOwnPropertySymbols
});

// 24.3.2 JSON.stringify(value [, replacer [, space]])
$JSON && $export($export.S + $export.F * (!USE_NATIVE || $fails(function () {
  var S = $Symbol();
  // MS Edge converts symbol values to JSON as {}
  // WebKit converts symbol values to JSON as null
  // V8 throws on boxed symbols
  return _stringify([S]) != '[null]' || _stringify({ a: S }) != '{}' || _stringify(Object(S)) != '{}';
})), 'JSON', {
  stringify: function stringify(it) {
    var args = [it];
    var i = 1;
    var replacer, $replacer;
    while (arguments.length > i) args.push(arguments[i++]);
    $replacer = replacer = args[1];
    if (!isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined
    if (!isArray(replacer)) replacer = function (key, value) {
      if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
      if (!isSymbol(value)) return value;
    };
    args[1] = replacer;
    return _stringify.apply($JSON, args);
  }
});

// 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)
$Symbol[PROTOTYPE][TO_PRIMITIVE] || __webpack_require__(19)($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);
// 19.4.3.5 Symbol.prototype[@@toStringTag]
setToStringTag($Symbol, 'Symbol');
// 20.2.1.9 Math[@@toStringTag]
setToStringTag(Math, 'Math', true);
// 24.3.3 JSON[@@toStringTag]
setToStringTag(global.JSON, 'JSON', true);


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

var META = __webpack_require__(29)('meta');
var isObject = __webpack_require__(21);
var has = __webpack_require__(14);
var setDesc = __webpack_require__(12).f;
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !__webpack_require__(22)(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};


/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

// all enumerable object keys, includes symbols
var getKeys = __webpack_require__(26);
var gOPS = __webpack_require__(50);
var pIE = __webpack_require__(32);
module.exports = function (it) {
  var result = getKeys(it);
  var getSymbols = gOPS.f;
  if (getSymbols) {
    var symbols = getSymbols(it);
    var isEnum = pIE.f;
    var i = 0;
    var key;
    while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);
  } return result;
};


/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

// 7.2.2 IsArray(argument)
var cof = __webpack_require__(38);
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
var toIObject = __webpack_require__(18);
var gOPN = __webpack_require__(69).f;
var toString = {}.toString;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return gOPN(it);
  } catch (e) {
    return windowNames.slice();
  }
};

module.exports.f = function getOwnPropertyNames(it) {
  return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));
};


/***/ }),
/* 113 */
/***/ (function(module, exports) {



/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(49)('asyncIterator');


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(49)('observable');


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var require;//! moment.js

;(function (global, factory) {
     true ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    global.moment = factory()
}(this, (function () { 'use strict';

    var hookCallback;

    function hooks () {
        return hookCallback.apply(null, arguments);
    }

    // This is done to register the method called with moment()
    // without creating circular dependencies.
    function setHookCallback (callback) {
        hookCallback = callback;
    }

    function isArray(input) {
        return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
    }

    function isObject(input) {
        // IE8 will treat undefined and null as object if it wasn't for
        // input != null
        return input != null && Object.prototype.toString.call(input) === '[object Object]';
    }

    function isObjectEmpty(obj) {
        if (Object.getOwnPropertyNames) {
            return (Object.getOwnPropertyNames(obj).length === 0);
        } else {
            var k;
            for (k in obj) {
                if (obj.hasOwnProperty(k)) {
                    return false;
                }
            }
            return true;
        }
    }

    function isUndefined(input) {
        return input === void 0;
    }

    function isNumber(input) {
        return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';
    }

    function isDate(input) {
        return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
    }

    function map(arr, fn) {
        var res = [], i;
        for (i = 0; i < arr.length; ++i) {
            res.push(fn(arr[i], i));
        }
        return res;
    }

    function hasOwnProp(a, b) {
        return Object.prototype.hasOwnProperty.call(a, b);
    }

    function extend(a, b) {
        for (var i in b) {
            if (hasOwnProp(b, i)) {
                a[i] = b[i];
            }
        }

        if (hasOwnProp(b, 'toString')) {
            a.toString = b.toString;
        }

        if (hasOwnProp(b, 'valueOf')) {
            a.valueOf = b.valueOf;
        }

        return a;
    }

    function createUTC (input, format, locale, strict) {
        return createLocalOrUTC(input, format, locale, strict, true).utc();
    }

    function defaultParsingFlags() {
        // We need to deep clone this object.
        return {
            empty           : false,
            unusedTokens    : [],
            unusedInput     : [],
            overflow        : -2,
            charsLeftOver   : 0,
            nullInput       : false,
            invalidMonth    : null,
            invalidFormat   : false,
            userInvalidated : false,
            iso             : false,
            parsedDateParts : [],
            meridiem        : null,
            rfc2822         : false,
            weekdayMismatch : false
        };
    }

    function getParsingFlags(m) {
        if (m._pf == null) {
            m._pf = defaultParsingFlags();
        }
        return m._pf;
    }

    var some;
    if (Array.prototype.some) {
        some = Array.prototype.some;
    } else {
        some = function (fun) {
            var t = Object(this);
            var len = t.length >>> 0;

            for (var i = 0; i < len; i++) {
                if (i in t && fun.call(this, t[i], i, t)) {
                    return true;
                }
            }

            return false;
        };
    }

    function isValid(m) {
        if (m._isValid == null) {
            var flags = getParsingFlags(m);
            var parsedParts = some.call(flags.parsedDateParts, function (i) {
                return i != null;
            });
            var isNowValid = !isNaN(m._d.getTime()) &&
                flags.overflow < 0 &&
                !flags.empty &&
                !flags.invalidMonth &&
                !flags.invalidWeekday &&
                !flags.weekdayMismatch &&
                !flags.nullInput &&
                !flags.invalidFormat &&
                !flags.userInvalidated &&
                (!flags.meridiem || (flags.meridiem && parsedParts));

            if (m._strict) {
                isNowValid = isNowValid &&
                    flags.charsLeftOver === 0 &&
                    flags.unusedTokens.length === 0 &&
                    flags.bigHour === undefined;
            }

            if (Object.isFrozen == null || !Object.isFrozen(m)) {
                m._isValid = isNowValid;
            }
            else {
                return isNowValid;
            }
        }
        return m._isValid;
    }

    function createInvalid (flags) {
        var m = createUTC(NaN);
        if (flags != null) {
            extend(getParsingFlags(m), flags);
        }
        else {
            getParsingFlags(m).userInvalidated = true;
        }

        return m;
    }

    // Plugins that add properties should also add the key here (null value),
    // so we can properly clone ourselves.
    var momentProperties = hooks.momentProperties = [];

    function copyConfig(to, from) {
        var i, prop, val;

        if (!isUndefined(from._isAMomentObject)) {
            to._isAMomentObject = from._isAMomentObject;
        }
        if (!isUndefined(from._i)) {
            to._i = from._i;
        }
        if (!isUndefined(from._f)) {
            to._f = from._f;
        }
        if (!isUndefined(from._l)) {
            to._l = from._l;
        }
        if (!isUndefined(from._strict)) {
            to._strict = from._strict;
        }
        if (!isUndefined(from._tzm)) {
            to._tzm = from._tzm;
        }
        if (!isUndefined(from._isUTC)) {
            to._isUTC = from._isUTC;
        }
        if (!isUndefined(from._offset)) {
            to._offset = from._offset;
        }
        if (!isUndefined(from._pf)) {
            to._pf = getParsingFlags(from);
        }
        if (!isUndefined(from._locale)) {
            to._locale = from._locale;
        }

        if (momentProperties.length > 0) {
            for (i = 0; i < momentProperties.length; i++) {
                prop = momentProperties[i];
                val = from[prop];
                if (!isUndefined(val)) {
                    to[prop] = val;
                }
            }
        }

        return to;
    }

    var updateInProgress = false;

    // Moment prototype object
    function Moment(config) {
        copyConfig(this, config);
        this._d = new Date(config._d != null ? config._d.getTime() : NaN);
        if (!this.isValid()) {
            this._d = new Date(NaN);
        }
        // Prevent infinite loop in case updateOffset creates new moment
        // objects.
        if (updateInProgress === false) {
            updateInProgress = true;
            hooks.updateOffset(this);
            updateInProgress = false;
        }
    }

    function isMoment (obj) {
        return obj instanceof Moment || (obj != null && obj._isAMomentObject != null);
    }

    function absFloor (number) {
        if (number < 0) {
            // -0 -> 0
            return Math.ceil(number) || 0;
        } else {
            return Math.floor(number);
        }
    }

    function toInt(argumentForCoercion) {
        var coercedNumber = +argumentForCoercion,
            value = 0;

        if (coercedNumber !== 0 && isFinite(coercedNumber)) {
            value = absFloor(coercedNumber);
        }

        return value;
    }

    // compare two arrays, return the number of differences
    function compareArrays(array1, array2, dontConvert) {
        var len = Math.min(array1.length, array2.length),
            lengthDiff = Math.abs(array1.length - array2.length),
            diffs = 0,
            i;
        for (i = 0; i < len; i++) {
            if ((dontConvert && array1[i] !== array2[i]) ||
                (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))) {
                diffs++;
            }
        }
        return diffs + lengthDiff;
    }

    function warn(msg) {
        if (hooks.suppressDeprecationWarnings === false &&
                (typeof console !==  'undefined') && console.warn) {
            console.warn('Deprecation warning: ' + msg);
        }
    }

    function deprecate(msg, fn) {
        var firstTime = true;

        return extend(function () {
            if (hooks.deprecationHandler != null) {
                hooks.deprecationHandler(null, msg);
            }
            if (firstTime) {
                var args = [];
                var arg;
                for (var i = 0; i < arguments.length; i++) {
                    arg = '';
                    if (typeof arguments[i] === 'object') {
                        arg += '\n[' + i + '] ';
                        for (var key in arguments[0]) {
                            arg += key + ': ' + arguments[0][key] + ', ';
                        }
                        arg = arg.slice(0, -2); // Remove trailing comma and space
                    } else {
                        arg = arguments[i];
                    }
                    args.push(arg);
                }
                warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + (new Error()).stack);
                firstTime = false;
            }
            return fn.apply(this, arguments);
        }, fn);
    }

    var deprecations = {};

    function deprecateSimple(name, msg) {
        if (hooks.deprecationHandler != null) {
            hooks.deprecationHandler(name, msg);
        }
        if (!deprecations[name]) {
            warn(msg);
            deprecations[name] = true;
        }
    }

    hooks.suppressDeprecationWarnings = false;
    hooks.deprecationHandler = null;

    function isFunction(input) {
        return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
    }

    function set (config) {
        var prop, i;
        for (i in config) {
            prop = config[i];
            if (isFunction(prop)) {
                this[i] = prop;
            } else {
                this['_' + i] = prop;
            }
        }
        this._config = config;
        // Lenient ordinal parsing accepts just a number in addition to
        // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
        // TODO: Remove "ordinalParse" fallback in next major release.
        this._dayOfMonthOrdinalParseLenient = new RegExp(
            (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) +
                '|' + (/\d{1,2}/).source);
    }

    function mergeConfigs(parentConfig, childConfig) {
        var res = extend({}, parentConfig), prop;
        for (prop in childConfig) {
            if (hasOwnProp(childConfig, prop)) {
                if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
                    res[prop] = {};
                    extend(res[prop], parentConfig[prop]);
                    extend(res[prop], childConfig[prop]);
                } else if (childConfig[prop] != null) {
                    res[prop] = childConfig[prop];
                } else {
                    delete res[prop];
                }
            }
        }
        for (prop in parentConfig) {
            if (hasOwnProp(parentConfig, prop) &&
                    !hasOwnProp(childConfig, prop) &&
                    isObject(parentConfig[prop])) {
                // make sure changes to properties don't modify parent config
                res[prop] = extend({}, res[prop]);
            }
        }
        return res;
    }

    function Locale(config) {
        if (config != null) {
            this.set(config);
        }
    }

    var keys;

    if (Object.keys) {
        keys = Object.keys;
    } else {
        keys = function (obj) {
            var i, res = [];
            for (i in obj) {
                if (hasOwnProp(obj, i)) {
                    res.push(i);
                }
            }
            return res;
        };
    }

    var defaultCalendar = {
        sameDay : '[Today at] LT',
        nextDay : '[Tomorrow at] LT',
        nextWeek : 'dddd [at] LT',
        lastDay : '[Yesterday at] LT',
        lastWeek : '[Last] dddd [at] LT',
        sameElse : 'L'
    };

    function calendar (key, mom, now) {
        var output = this._calendar[key] || this._calendar['sameElse'];
        return isFunction(output) ? output.call(mom, now) : output;
    }

    var defaultLongDateFormat = {
        LTS  : 'h:mm:ss A',
        LT   : 'h:mm A',
        L    : 'MM/DD/YYYY',
        LL   : 'MMMM D, YYYY',
        LLL  : 'MMMM D, YYYY h:mm A',
        LLLL : 'dddd, MMMM D, YYYY h:mm A'
    };

    function longDateFormat (key) {
        var format = this._longDateFormat[key],
            formatUpper = this._longDateFormat[key.toUpperCase()];

        if (format || !formatUpper) {
            return format;
        }

        this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {
            return val.slice(1);
        });

        return this._longDateFormat[key];
    }

    var defaultInvalidDate = 'Invalid date';

    function invalidDate () {
        return this._invalidDate;
    }

    var defaultOrdinal = '%d';
    var defaultDayOfMonthOrdinalParse = /\d{1,2}/;

    function ordinal (number) {
        return this._ordinal.replace('%d', number);
    }

    var defaultRelativeTime = {
        future : 'in %s',
        past   : '%s ago',
        s  : 'a few seconds',
        ss : '%d seconds',
        m  : 'a minute',
        mm : '%d minutes',
        h  : 'an hour',
        hh : '%d hours',
        d  : 'a day',
        dd : '%d days',
        M  : 'a month',
        MM : '%d months',
        y  : 'a year',
        yy : '%d years'
    };

    function relativeTime (number, withoutSuffix, string, isFuture) {
        var output = this._relativeTime[string];
        return (isFunction(output)) ?
            output(number, withoutSuffix, string, isFuture) :
            output.replace(/%d/i, number);
    }

    function pastFuture (diff, output) {
        var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
        return isFunction(format) ? format(output) : format.replace(/%s/i, output);
    }

    var aliases = {};

    function addUnitAlias (unit, shorthand) {
        var lowerCase = unit.toLowerCase();
        aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
    }

    function normalizeUnits(units) {
        return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
    }

    function normalizeObjectUnits(inputObject) {
        var normalizedInput = {},
            normalizedProp,
            prop;

        for (prop in inputObject) {
            if (hasOwnProp(inputObject, prop)) {
                normalizedProp = normalizeUnits(prop);
                if (normalizedProp) {
                    normalizedInput[normalizedProp] = inputObject[prop];
                }
            }
        }

        return normalizedInput;
    }

    var priorities = {};

    function addUnitPriority(unit, priority) {
        priorities[unit] = priority;
    }

    function getPrioritizedUnits(unitsObj) {
        var units = [];
        for (var u in unitsObj) {
            units.push({unit: u, priority: priorities[u]});
        }
        units.sort(function (a, b) {
            return a.priority - b.priority;
        });
        return units;
    }

    function zeroFill(number, targetLength, forceSign) {
        var absNumber = '' + Math.abs(number),
            zerosToFill = targetLength - absNumber.length,
            sign = number >= 0;
        return (sign ? (forceSign ? '+' : '') : '-') +
            Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
    }

    var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;

    var localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;

    var formatFunctions = {};

    var formatTokenFunctions = {};

    // token:    'M'
    // padded:   ['MM', 2]
    // ordinal:  'Mo'
    // callback: function () { this.month() + 1 }
    function addFormatToken (token, padded, ordinal, callback) {
        var func = callback;
        if (typeof callback === 'string') {
            func = function () {
                return this[callback]();
            };
        }
        if (token) {
            formatTokenFunctions[token] = func;
        }
        if (padded) {
            formatTokenFunctions[padded[0]] = function () {
                return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
            };
        }
        if (ordinal) {
            formatTokenFunctions[ordinal] = function () {
                return this.localeData().ordinal(func.apply(this, arguments), token);
            };
        }
    }

    function removeFormattingTokens(input) {
        if (input.match(/\[[\s\S]/)) {
            return input.replace(/^\[|\]$/g, '');
        }
        return input.replace(/\\/g, '');
    }

    function makeFormatFunction(format) {
        var array = format.match(formattingTokens), i, length;

        for (i = 0, length = array.length; i < length; i++) {
            if (formatTokenFunctions[array[i]]) {
                array[i] = formatTokenFunctions[array[i]];
            } else {
                array[i] = removeFormattingTokens(array[i]);
            }
        }

        return function (mom) {
            var output = '', i;
            for (i = 0; i < length; i++) {
                output += isFunction(array[i]) ? array[i].call(mom, format) : array[i];
            }
            return output;
        };
    }

    // format date using native date object
    function formatMoment(m, format) {
        if (!m.isValid()) {
            return m.localeData().invalidDate();
        }

        format = expandFormat(format, m.localeData());
        formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);

        return formatFunctions[format](m);
    }

    function expandFormat(format, locale) {
        var i = 5;

        function replaceLongDateFormatTokens(input) {
            return locale.longDateFormat(input) || input;
        }

        localFormattingTokens.lastIndex = 0;
        while (i >= 0 && localFormattingTokens.test(format)) {
            format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
            localFormattingTokens.lastIndex = 0;
            i -= 1;
        }

        return format;
    }

    var match1         = /\d/;            //       0 - 9
    var match2         = /\d\d/;          //      00 - 99
    var match3         = /\d{3}/;         //     000 - 999
    var match4         = /\d{4}/;         //    0000 - 9999
    var match6         = /[+-]?\d{6}/;    // -999999 - 999999
    var match1to2      = /\d\d?/;         //       0 - 99
    var match3to4      = /\d\d\d\d?/;     //     999 - 9999
    var match5to6      = /\d\d\d\d\d\d?/; //   99999 - 999999
    var match1to3      = /\d{1,3}/;       //       0 - 999
    var match1to4      = /\d{1,4}/;       //       0 - 9999
    var match1to6      = /[+-]?\d{1,6}/;  // -999999 - 999999

    var matchUnsigned  = /\d+/;           //       0 - inf
    var matchSigned    = /[+-]?\d+/;      //    -inf - inf

    var matchOffset    = /Z|[+-]\d\d:?\d\d/gi; // +00:00 -00:00 +0000 -0000 or Z
    var matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi; // +00 -00 +00:00 -00:00 +0000 -0000 or Z

    var matchTimestamp = /[+-]?\d+(\.\d{1,3})?/; // 123456789 123456789.123

    // any word (or two) characters or numbers including two/three word month in arabic.
    // includes scottish gaelic two word and hyphenated months
    var matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i;

    var regexes = {};

    function addRegexToken (token, regex, strictRegex) {
        regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
            return (isStrict && strictRegex) ? strictRegex : regex;
        };
    }

    function getParseRegexForToken (token, config) {
        if (!hasOwnProp(regexes, token)) {
            return new RegExp(unescapeFormat(token));
        }

        return regexes[token](config._strict, config._locale);
    }

    // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
    function unescapeFormat(s) {
        return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
            return p1 || p2 || p3 || p4;
        }));
    }

    function regexEscape(s) {
        return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
    }

    var tokens = {};

    function addParseToken (token, callback) {
        var i, func = callback;
        if (typeof token === 'string') {
            token = [token];
        }
        if (isNumber(callback)) {
            func = function (input, array) {
                array[callback] = toInt(input);
            };
        }
        for (i = 0; i < token.length; i++) {
            tokens[token[i]] = func;
        }
    }

    function addWeekParseToken (token, callback) {
        addParseToken(token, function (input, array, config, token) {
            config._w = config._w || {};
            callback(input, config._w, config, token);
        });
    }

    function addTimeToArrayFromToken(token, input, config) {
        if (input != null && hasOwnProp(tokens, token)) {
            tokens[token](input, config._a, config, token);
        }
    }

    var YEAR = 0;
    var MONTH = 1;
    var DATE = 2;
    var HOUR = 3;
    var MINUTE = 4;
    var SECOND = 5;
    var MILLISECOND = 6;
    var WEEK = 7;
    var WEEKDAY = 8;

    // FORMATTING

    addFormatToken('Y', 0, 0, function () {
        var y = this.year();
        return y <= 9999 ? '' + y : '+' + y;
    });

    addFormatToken(0, ['YY', 2], 0, function () {
        return this.year() % 100;
    });

    addFormatToken(0, ['YYYY',   4],       0, 'year');
    addFormatToken(0, ['YYYYY',  5],       0, 'year');
    addFormatToken(0, ['YYYYYY', 6, true], 0, 'year');

    // ALIASES

    addUnitAlias('year', 'y');

    // PRIORITIES

    addUnitPriority('year', 1);

    // PARSING

    addRegexToken('Y',      matchSigned);
    addRegexToken('YY',     match1to2, match2);
    addRegexToken('YYYY',   match1to4, match4);
    addRegexToken('YYYYY',  match1to6, match6);
    addRegexToken('YYYYYY', match1to6, match6);

    addParseToken(['YYYYY', 'YYYYYY'], YEAR);
    addParseToken('YYYY', function (input, array) {
        array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
    });
    addParseToken('YY', function (input, array) {
        array[YEAR] = hooks.parseTwoDigitYear(input);
    });
    addParseToken('Y', function (input, array) {
        array[YEAR] = parseInt(input, 10);
    });

    // HELPERS

    function daysInYear(year) {
        return isLeapYear(year) ? 366 : 365;
    }

    function isLeapYear(year) {
        return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
    }

    // HOOKS

    hooks.parseTwoDigitYear = function (input) {
        return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
    };

    // MOMENTS

    var getSetYear = makeGetSet('FullYear', true);

    function getIsLeapYear () {
        return isLeapYear(this.year());
    }

    function makeGetSet (unit, keepTime) {
        return function (value) {
            if (value != null) {
                set$1(this, unit, value);
                hooks.updateOffset(this, keepTime);
                return this;
            } else {
                return get(this, unit);
            }
        };
    }

    function get (mom, unit) {
        return mom.isValid() ?
            mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
    }

    function set$1 (mom, unit, value) {
        if (mom.isValid() && !isNaN(value)) {
            if (unit === 'FullYear' && isLeapYear(mom.year()) && mom.month() === 1 && mom.date() === 29) {
                mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value, mom.month(), daysInMonth(value, mom.month()));
            }
            else {
                mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
            }
        }
    }

    // MOMENTS

    function stringGet (units) {
        units = normalizeUnits(units);
        if (isFunction(this[units])) {
            return this[units]();
        }
        return this;
    }


    function stringSet (units, value) {
        if (typeof units === 'object') {
            units = normalizeObjectUnits(units);
            var prioritized = getPrioritizedUnits(units);
            for (var i = 0; i < prioritized.length; i++) {
                this[prioritized[i].unit](units[prioritized[i].unit]);
            }
        } else {
            units = normalizeUnits(units);
            if (isFunction(this[units])) {
                return this[units](value);
            }
        }
        return this;
    }

    function mod(n, x) {
        return ((n % x) + x) % x;
    }

    var indexOf;

    if (Array.prototype.indexOf) {
        indexOf = Array.prototype.indexOf;
    } else {
        indexOf = function (o) {
            // I know
            var i;
            for (i = 0; i < this.length; ++i) {
                if (this[i] === o) {
                    return i;
                }
            }
            return -1;
        };
    }

    function daysInMonth(year, month) {
        if (isNaN(year) || isNaN(month)) {
            return NaN;
        }
        var modMonth = mod(month, 12);
        year += (month - modMonth) / 12;
        return modMonth === 1 ? (isLeapYear(year) ? 29 : 28) : (31 - modMonth % 7 % 2);
    }

    // FORMATTING

    addFormatToken('M', ['MM', 2], 'Mo', function () {
        return this.month() + 1;
    });

    addFormatToken('MMM', 0, 0, function (format) {
        return this.localeData().monthsShort(this, format);
    });

    addFormatToken('MMMM', 0, 0, function (format) {
        return this.localeData().months(this, format);
    });

    // ALIASES

    addUnitAlias('month', 'M');

    // PRIORITY

    addUnitPriority('month', 8);

    // PARSING

    addRegexToken('M',    match1to2);
    addRegexToken('MM',   match1to2, match2);
    addRegexToken('MMM',  function (isStrict, locale) {
        return locale.monthsShortRegex(isStrict);
    });
    addRegexToken('MMMM', function (isStrict, locale) {
        return locale.monthsRegex(isStrict);
    });

    addParseToken(['M', 'MM'], function (input, array) {
        array[MONTH] = toInt(input) - 1;
    });

    addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
        var month = config._locale.monthsParse(input, token, config._strict);
        // if we didn't find a month name, mark the date as invalid.
        if (month != null) {
            array[MONTH] = month;
        } else {
            getParsingFlags(config).invalidMonth = input;
        }
    });

    // LOCALES

    var MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;
    var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_');
    function localeMonths (m, format) {
        if (!m) {
            return isArray(this._months) ? this._months :
                this._months['standalone'];
        }
        return isArray(this._months) ? this._months[m.month()] :
            this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
    }

    var defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');
    function localeMonthsShort (m, format) {
        if (!m) {
            return isArray(this._monthsShort) ? this._monthsShort :
                this._monthsShort['standalone'];
        }
        return isArray(this._monthsShort) ? this._monthsShort[m.month()] :
            this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
    }

    function handleStrictParse(monthName, format, strict) {
        var i, ii, mom, llc = monthName.toLocaleLowerCase();
        if (!this._monthsParse) {
            // this is not used
            this._monthsParse = [];
            this._longMonthsParse = [];
            this._shortMonthsParse = [];
            for (i = 0; i < 12; ++i) {
                mom = createUTC([2000, i]);
                this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
                this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
            }
        }

        if (strict) {
            if (format === 'MMM') {
                ii = indexOf.call(this._shortMonthsParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._longMonthsParse, llc);
                return ii !== -1 ? ii : null;
            }
        } else {
            if (format === 'MMM') {
                ii = indexOf.call(this._shortMonthsParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._longMonthsParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._longMonthsParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortMonthsParse, llc);
                return ii !== -1 ? ii : null;
            }
        }
    }

    function localeMonthsParse (monthName, format, strict) {
        var i, mom, regex;

        if (this._monthsParseExact) {
            return handleStrictParse.call(this, monthName, format, strict);
        }

        if (!this._monthsParse) {
            this._monthsParse = [];
            this._longMonthsParse = [];
            this._shortMonthsParse = [];
        }

        // TODO: add sorting
        // Sorting makes sure if one month (or abbr) is a prefix of another
        // see sorting in computeMonthsParse
        for (i = 0; i < 12; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, i]);
            if (strict && !this._longMonthsParse[i]) {
                this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
                this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
            }
            if (!strict && !this._monthsParse[i]) {
                regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
                this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
            }
            // test the regex
            if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
                return i;
            } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
                return i;
            } else if (!strict && this._monthsParse[i].test(monthName)) {
                return i;
            }
        }
    }

    // MOMENTS

    function setMonth (mom, value) {
        var dayOfMonth;

        if (!mom.isValid()) {
            // No op
            return mom;
        }

        if (typeof value === 'string') {
            if (/^\d+$/.test(value)) {
                value = toInt(value);
            } else {
                value = mom.localeData().monthsParse(value);
                // TODO: Another silent failure?
                if (!isNumber(value)) {
                    return mom;
                }
            }
        }

        dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
        mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);
        return mom;
    }

    function getSetMonth (value) {
        if (value != null) {
            setMonth(this, value);
            hooks.updateOffset(this, true);
            return this;
        } else {
            return get(this, 'Month');
        }
    }

    function getDaysInMonth () {
        return daysInMonth(this.year(), this.month());
    }

    var defaultMonthsShortRegex = matchWord;
    function monthsShortRegex (isStrict) {
        if (this._monthsParseExact) {
            if (!hasOwnProp(this, '_monthsRegex')) {
                computeMonthsParse.call(this);
            }
            if (isStrict) {
                return this._monthsShortStrictRegex;
            } else {
                return this._monthsShortRegex;
            }
        } else {
            if (!hasOwnProp(this, '_monthsShortRegex')) {
                this._monthsShortRegex = defaultMonthsShortRegex;
            }
            return this._monthsShortStrictRegex && isStrict ?
                this._monthsShortStrictRegex : this._monthsShortRegex;
        }
    }

    var defaultMonthsRegex = matchWord;
    function monthsRegex (isStrict) {
        if (this._monthsParseExact) {
            if (!hasOwnProp(this, '_monthsRegex')) {
                computeMonthsParse.call(this);
            }
            if (isStrict) {
                return this._monthsStrictRegex;
            } else {
                return this._monthsRegex;
            }
        } else {
            if (!hasOwnProp(this, '_monthsRegex')) {
                this._monthsRegex = defaultMonthsRegex;
            }
            return this._monthsStrictRegex && isStrict ?
                this._monthsStrictRegex : this._monthsRegex;
        }
    }

    function computeMonthsParse () {
        function cmpLenRev(a, b) {
            return b.length - a.length;
        }

        var shortPieces = [], longPieces = [], mixedPieces = [],
            i, mom;
        for (i = 0; i < 12; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, i]);
            shortPieces.push(this.monthsShort(mom, ''));
            longPieces.push(this.months(mom, ''));
            mixedPieces.push(this.months(mom, ''));
            mixedPieces.push(this.monthsShort(mom, ''));
        }
        // Sorting makes sure if one month (or abbr) is a prefix of another it
        // will match the longer piece.
        shortPieces.sort(cmpLenRev);
        longPieces.sort(cmpLenRev);
        mixedPieces.sort(cmpLenRev);
        for (i = 0; i < 12; i++) {
            shortPieces[i] = regexEscape(shortPieces[i]);
            longPieces[i] = regexEscape(longPieces[i]);
        }
        for (i = 0; i < 24; i++) {
            mixedPieces[i] = regexEscape(mixedPieces[i]);
        }

        this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
        this._monthsShortRegex = this._monthsRegex;
        this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
        this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
    }

    function createDate (y, m, d, h, M, s, ms) {
        // can't just apply() to create a date:
        // https://stackoverflow.com/q/181348
        var date = new Date(y, m, d, h, M, s, ms);

        // the date constructor remaps years 0-99 to 1900-1999
        if (y < 100 && y >= 0 && isFinite(date.getFullYear())) {
            date.setFullYear(y);
        }
        return date;
    }

    function createUTCDate (y) {
        var date = new Date(Date.UTC.apply(null, arguments));

        // the Date.UTC function remaps years 0-99 to 1900-1999
        if (y < 100 && y >= 0 && isFinite(date.getUTCFullYear())) {
            date.setUTCFullYear(y);
        }
        return date;
    }

    // start-of-first-week - start-of-year
    function firstWeekOffset(year, dow, doy) {
        var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
            fwd = 7 + dow - doy,
            // first-week day local weekday -- which local weekday is fwd
            fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;

        return -fwdlw + fwd - 1;
    }

    // https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
    function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
        var localWeekday = (7 + weekday - dow) % 7,
            weekOffset = firstWeekOffset(year, dow, doy),
            dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
            resYear, resDayOfYear;

        if (dayOfYear <= 0) {
            resYear = year - 1;
            resDayOfYear = daysInYear(resYear) + dayOfYear;
        } else if (dayOfYear > daysInYear(year)) {
            resYear = year + 1;
            resDayOfYear = dayOfYear - daysInYear(year);
        } else {
            resYear = year;
            resDayOfYear = dayOfYear;
        }

        return {
            year: resYear,
            dayOfYear: resDayOfYear
        };
    }

    function weekOfYear(mom, dow, doy) {
        var weekOffset = firstWeekOffset(mom.year(), dow, doy),
            week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
            resWeek, resYear;

        if (week < 1) {
            resYear = mom.year() - 1;
            resWeek = week + weeksInYear(resYear, dow, doy);
        } else if (week > weeksInYear(mom.year(), dow, doy)) {
            resWeek = week - weeksInYear(mom.year(), dow, doy);
            resYear = mom.year() + 1;
        } else {
            resYear = mom.year();
            resWeek = week;
        }

        return {
            week: resWeek,
            year: resYear
        };
    }

    function weeksInYear(year, dow, doy) {
        var weekOffset = firstWeekOffset(year, dow, doy),
            weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
        return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
    }

    // FORMATTING

    addFormatToken('w', ['ww', 2], 'wo', 'week');
    addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');

    // ALIASES

    addUnitAlias('week', 'w');
    addUnitAlias('isoWeek', 'W');

    // PRIORITIES

    addUnitPriority('week', 5);
    addUnitPriority('isoWeek', 5);

    // PARSING

    addRegexToken('w',  match1to2);
    addRegexToken('ww', match1to2, match2);
    addRegexToken('W',  match1to2);
    addRegexToken('WW', match1to2, match2);

    addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
        week[token.substr(0, 1)] = toInt(input);
    });

    // HELPERS

    // LOCALES

    function localeWeek (mom) {
        return weekOfYear(mom, this._week.dow, this._week.doy).week;
    }

    var defaultLocaleWeek = {
        dow : 0, // Sunday is the first day of the week.
        doy : 6  // The week that contains Jan 1st is the first week of the year.
    };

    function localeFirstDayOfWeek () {
        return this._week.dow;
    }

    function localeFirstDayOfYear () {
        return this._week.doy;
    }

    // MOMENTS

    function getSetWeek (input) {
        var week = this.localeData().week(this);
        return input == null ? week : this.add((input - week) * 7, 'd');
    }

    function getSetISOWeek (input) {
        var week = weekOfYear(this, 1, 4).week;
        return input == null ? week : this.add((input - week) * 7, 'd');
    }

    // FORMATTING

    addFormatToken('d', 0, 'do', 'day');

    addFormatToken('dd', 0, 0, function (format) {
        return this.localeData().weekdaysMin(this, format);
    });

    addFormatToken('ddd', 0, 0, function (format) {
        return this.localeData().weekdaysShort(this, format);
    });

    addFormatToken('dddd', 0, 0, function (format) {
        return this.localeData().weekdays(this, format);
    });

    addFormatToken('e', 0, 0, 'weekday');
    addFormatToken('E', 0, 0, 'isoWeekday');

    // ALIASES

    addUnitAlias('day', 'd');
    addUnitAlias('weekday', 'e');
    addUnitAlias('isoWeekday', 'E');

    // PRIORITY
    addUnitPriority('day', 11);
    addUnitPriority('weekday', 11);
    addUnitPriority('isoWeekday', 11);

    // PARSING

    addRegexToken('d',    match1to2);
    addRegexToken('e',    match1to2);
    addRegexToken('E',    match1to2);
    addRegexToken('dd',   function (isStrict, locale) {
        return locale.weekdaysMinRegex(isStrict);
    });
    addRegexToken('ddd',   function (isStrict, locale) {
        return locale.weekdaysShortRegex(isStrict);
    });
    addRegexToken('dddd',   function (isStrict, locale) {
        return locale.weekdaysRegex(isStrict);
    });

    addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
        var weekday = config._locale.weekdaysParse(input, token, config._strict);
        // if we didn't get a weekday name, mark the date as invalid
        if (weekday != null) {
            week.d = weekday;
        } else {
            getParsingFlags(config).invalidWeekday = input;
        }
    });

    addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
        week[token] = toInt(input);
    });

    // HELPERS

    function parseWeekday(input, locale) {
        if (typeof input !== 'string') {
            return input;
        }

        if (!isNaN(input)) {
            return parseInt(input, 10);
        }

        input = locale.weekdaysParse(input);
        if (typeof input === 'number') {
            return input;
        }

        return null;
    }

    function parseIsoWeekday(input, locale) {
        if (typeof input === 'string') {
            return locale.weekdaysParse(input) % 7 || 7;
        }
        return isNaN(input) ? null : input;
    }

    // LOCALES

    var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');
    function localeWeekdays (m, format) {
        if (!m) {
            return isArray(this._weekdays) ? this._weekdays :
                this._weekdays['standalone'];
        }
        return isArray(this._weekdays) ? this._weekdays[m.day()] :
            this._weekdays[this._weekdays.isFormat.test(format) ? 'format' : 'standalone'][m.day()];
    }

    var defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');
    function localeWeekdaysShort (m) {
        return (m) ? this._weekdaysShort[m.day()] : this._weekdaysShort;
    }

    var defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_');
    function localeWeekdaysMin (m) {
        return (m) ? this._weekdaysMin[m.day()] : this._weekdaysMin;
    }

    function handleStrictParse$1(weekdayName, format, strict) {
        var i, ii, mom, llc = weekdayName.toLocaleLowerCase();
        if (!this._weekdaysParse) {
            this._weekdaysParse = [];
            this._shortWeekdaysParse = [];
            this._minWeekdaysParse = [];

            for (i = 0; i < 7; ++i) {
                mom = createUTC([2000, 1]).day(i);
                this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
                this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
                this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
            }
        }

        if (strict) {
            if (format === 'dddd') {
                ii = indexOf.call(this._weekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else if (format === 'ddd') {
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            }
        } else {
            if (format === 'dddd') {
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else if (format === 'ddd') {
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._minWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            }
        }
    }

    function localeWeekdaysParse (weekdayName, format, strict) {
        var i, mom, regex;

        if (this._weekdaysParseExact) {
            return handleStrictParse$1.call(this, weekdayName, format, strict);
        }

        if (!this._weekdaysParse) {
            this._weekdaysParse = [];
            this._minWeekdaysParse = [];
            this._shortWeekdaysParse = [];
            this._fullWeekdaysParse = [];
        }

        for (i = 0; i < 7; i++) {
            // make the regex if we don't have it already

            mom = createUTC([2000, 1]).day(i);
            if (strict && !this._fullWeekdaysParse[i]) {
                this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\\.?') + '$', 'i');
                this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\\.?') + '$', 'i');
                this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\\.?') + '$', 'i');
            }
            if (!this._weekdaysParse[i]) {
                regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
                this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
            }
            // test the regex
            if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
                return i;
            } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
                return i;
            } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
                return i;
            } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
                return i;
            }
        }
    }

    // MOMENTS

    function getSetDayOfWeek (input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
        if (input != null) {
            input = parseWeekday(input, this.localeData());
            return this.add(input - day, 'd');
        } else {
            return day;
        }
    }

    function getSetLocaleDayOfWeek (input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
        return input == null ? weekday : this.add(input - weekday, 'd');
    }

    function getSetISODayOfWeek (input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }

        // behaves the same as moment#day except
        // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
        // as a setter, sunday should belong to the previous week.

        if (input != null) {
            var weekday = parseIsoWeekday(input, this.localeData());
            return this.day(this.day() % 7 ? weekday : weekday - 7);
        } else {
            return this.day() || 7;
        }
    }

    var defaultWeekdaysRegex = matchWord;
    function weekdaysRegex (isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, '_weekdaysRegex')) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysStrictRegex;
            } else {
                return this._weekdaysRegex;
            }
        } else {
            if (!hasOwnProp(this, '_weekdaysRegex')) {
                this._weekdaysRegex = defaultWeekdaysRegex;
            }
            return this._weekdaysStrictRegex && isStrict ?
                this._weekdaysStrictRegex : this._weekdaysRegex;
        }
    }

    var defaultWeekdaysShortRegex = matchWord;
    function weekdaysShortRegex (isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, '_weekdaysRegex')) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysShortStrictRegex;
            } else {
                return this._weekdaysShortRegex;
            }
        } else {
            if (!hasOwnProp(this, '_weekdaysShortRegex')) {
                this._weekdaysShortRegex = defaultWeekdaysShortRegex;
            }
            return this._weekdaysShortStrictRegex && isStrict ?
                this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
        }
    }

    var defaultWeekdaysMinRegex = matchWord;
    function weekdaysMinRegex (isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, '_weekdaysRegex')) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysMinStrictRegex;
            } else {
                return this._weekdaysMinRegex;
            }
        } else {
            if (!hasOwnProp(this, '_weekdaysMinRegex')) {
                this._weekdaysMinRegex = defaultWeekdaysMinRegex;
            }
            return this._weekdaysMinStrictRegex && isStrict ?
                this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
        }
    }


    function computeWeekdaysParse () {
        function cmpLenRev(a, b) {
            return b.length - a.length;
        }

        var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [],
            i, mom, minp, shortp, longp;
        for (i = 0; i < 7; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, 1]).day(i);
            minp = this.weekdaysMin(mom, '');
            shortp = this.weekdaysShort(mom, '');
            longp = this.weekdays(mom, '');
            minPieces.push(minp);
            shortPieces.push(shortp);
            longPieces.push(longp);
            mixedPieces.push(minp);
            mixedPieces.push(shortp);
            mixedPieces.push(longp);
        }
        // Sorting makes sure if one weekday (or abbr) is a prefix of another it
        // will match the longer piece.
        minPieces.sort(cmpLenRev);
        shortPieces.sort(cmpLenRev);
        longPieces.sort(cmpLenRev);
        mixedPieces.sort(cmpLenRev);
        for (i = 0; i < 7; i++) {
            shortPieces[i] = regexEscape(shortPieces[i]);
            longPieces[i] = regexEscape(longPieces[i]);
            mixedPieces[i] = regexEscape(mixedPieces[i]);
        }

        this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
        this._weekdaysShortRegex = this._weekdaysRegex;
        this._weekdaysMinRegex = this._weekdaysRegex;

        this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
        this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
        this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
    }

    // FORMATTING

    function hFormat() {
        return this.hours() % 12 || 12;
    }

    function kFormat() {
        return this.hours() || 24;
    }

    addFormatToken('H', ['HH', 2], 0, 'hour');
    addFormatToken('h', ['hh', 2], 0, hFormat);
    addFormatToken('k', ['kk', 2], 0, kFormat);

    addFormatToken('hmm', 0, 0, function () {
        return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
    });

    addFormatToken('hmmss', 0, 0, function () {
        return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) +
            zeroFill(this.seconds(), 2);
    });

    addFormatToken('Hmm', 0, 0, function () {
        return '' + this.hours() + zeroFill(this.minutes(), 2);
    });

    addFormatToken('Hmmss', 0, 0, function () {
        return '' + this.hours() + zeroFill(this.minutes(), 2) +
            zeroFill(this.seconds(), 2);
    });

    function meridiem (token, lowercase) {
        addFormatToken(token, 0, 0, function () {
            return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
        });
    }

    meridiem('a', true);
    meridiem('A', false);

    // ALIASES

    addUnitAlias('hour', 'h');

    // PRIORITY
    addUnitPriority('hour', 13);

    // PARSING

    function matchMeridiem (isStrict, locale) {
        return locale._meridiemParse;
    }

    addRegexToken('a',  matchMeridiem);
    addRegexToken('A',  matchMeridiem);
    addRegexToken('H',  match1to2);
    addRegexToken('h',  match1to2);
    addRegexToken('k',  match1to2);
    addRegexToken('HH', match1to2, match2);
    addRegexToken('hh', match1to2, match2);
    addRegexToken('kk', match1to2, match2);

    addRegexToken('hmm', match3to4);
    addRegexToken('hmmss', match5to6);
    addRegexToken('Hmm', match3to4);
    addRegexToken('Hmmss', match5to6);

    addParseToken(['H', 'HH'], HOUR);
    addParseToken(['k', 'kk'], function (input, array, config) {
        var kInput = toInt(input);
        array[HOUR] = kInput === 24 ? 0 : kInput;
    });
    addParseToken(['a', 'A'], function (input, array, config) {
        config._isPm = config._locale.isPM(input);
        config._meridiem = input;
    });
    addParseToken(['h', 'hh'], function (input, array, config) {
        array[HOUR] = toInt(input);
        getParsingFlags(config).bigHour = true;
    });
    addParseToken('hmm', function (input, array, config) {
        var pos = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos));
        array[MINUTE] = toInt(input.substr(pos));
        getParsingFlags(config).bigHour = true;
    });
    addParseToken('hmmss', function (input, array, config) {
        var pos1 = input.length - 4;
        var pos2 = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos1));
        array[MINUTE] = toInt(input.substr(pos1, 2));
        array[SECOND] = toInt(input.substr(pos2));
        getParsingFlags(config).bigHour = true;
    });
    addParseToken('Hmm', function (input, array, config) {
        var pos = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos));
        array[MINUTE] = toInt(input.substr(pos));
    });
    addParseToken('Hmmss', function (input, array, config) {
        var pos1 = input.length - 4;
        var pos2 = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos1));
        array[MINUTE] = toInt(input.substr(pos1, 2));
        array[SECOND] = toInt(input.substr(pos2));
    });

    // LOCALES

    function localeIsPM (input) {
        // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
        // Using charAt should be more compatible.
        return ((input + '').toLowerCase().charAt(0) === 'p');
    }

    var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i;
    function localeMeridiem (hours, minutes, isLower) {
        if (hours > 11) {
            return isLower ? 'pm' : 'PM';
        } else {
            return isLower ? 'am' : 'AM';
        }
    }


    // MOMENTS

    // Setting the hour should keep the time, because the user explicitly
    // specified which hour they want. So trying to maintain the same hour (in
    // a new timezone) makes sense. Adding/subtracting hours does not follow
    // this rule.
    var getSetHour = makeGetSet('Hours', true);

    var baseConfig = {
        calendar: defaultCalendar,
        longDateFormat: defaultLongDateFormat,
        invalidDate: defaultInvalidDate,
        ordinal: defaultOrdinal,
        dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
        relativeTime: defaultRelativeTime,

        months: defaultLocaleMonths,
        monthsShort: defaultLocaleMonthsShort,

        week: defaultLocaleWeek,

        weekdays: defaultLocaleWeekdays,
        weekdaysMin: defaultLocaleWeekdaysMin,
        weekdaysShort: defaultLocaleWeekdaysShort,

        meridiemParse: defaultLocaleMeridiemParse
    };

    // internal storage for locale config files
    var locales = {};
    var localeFamilies = {};
    var globalLocale;

    function normalizeLocale(key) {
        return key ? key.toLowerCase().replace('_', '-') : key;
    }

    // pick the locale from the array
    // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
    // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
    function chooseLocale(names) {
        var i = 0, j, next, locale, split;

        while (i < names.length) {
            split = normalizeLocale(names[i]).split('-');
            j = split.length;
            next = normalizeLocale(names[i + 1]);
            next = next ? next.split('-') : null;
            while (j > 0) {
                locale = loadLocale(split.slice(0, j).join('-'));
                if (locale) {
                    return locale;
                }
                if (next && next.length >= j && compareArrays(split, next, true) >= j - 1) {
                    //the next array item is better than a shallower substring of this one
                    break;
                }
                j--;
            }
            i++;
        }
        return globalLocale;
    }

    function loadLocale(name) {
        var oldLocale = null;
        // TODO: Find a better way to register and load all the locales in Node
        if (!locales[name] && (typeof module !== 'undefined') &&
                module && module.exports) {
            try {
                oldLocale = globalLocale._abbr;
                var aliasedRequire = require;
                !(function webpackMissingModule() { var e = new Error("Cannot find module \"./locale\""); e.code = 'MODULE_NOT_FOUND'; throw e; }());
                getSetGlobalLocale(oldLocale);
            } catch (e) {}
        }
        return locales[name];
    }

    // This function will load locale and then set the global locale.  If
    // no arguments are passed in, it will simply return the current global
    // locale key.
    function getSetGlobalLocale (key, values) {
        var data;
        if (key) {
            if (isUndefined(values)) {
                data = getLocale(key);
            }
            else {
                data = defineLocale(key, values);
            }

            if (data) {
                // moment.duration._locale = moment._locale = data;
                globalLocale = data;
            }
            else {
                if ((typeof console !==  'undefined') && console.warn) {
                    //warn user if arguments are passed but the locale could not be set
                    console.warn('Locale ' + key +  ' not found. Did you forget to load it?');
                }
            }
        }

        return globalLocale._abbr;
    }

    function defineLocale (name, config) {
        if (config !== null) {
            var locale, parentConfig = baseConfig;
            config.abbr = name;
            if (locales[name] != null) {
                deprecateSimple('defineLocaleOverride',
                        'use moment.updateLocale(localeName, config) to change ' +
                        'an existing locale. moment.defineLocale(localeName, ' +
                        'config) should only be used for creating a new locale ' +
                        'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
                parentConfig = locales[name]._config;
            } else if (config.parentLocale != null) {
                if (locales[config.parentLocale] != null) {
                    parentConfig = locales[config.parentLocale]._config;
                } else {
                    locale = loadLocale(config.parentLocale);
                    if (locale != null) {
                        parentConfig = locale._config;
                    } else {
                        if (!localeFamilies[config.parentLocale]) {
                            localeFamilies[config.parentLocale] = [];
                        }
                        localeFamilies[config.parentLocale].push({
                            name: name,
                            config: config
                        });
                        return null;
                    }
                }
            }
            locales[name] = new Locale(mergeConfigs(parentConfig, config));

            if (localeFamilies[name]) {
                localeFamilies[name].forEach(function (x) {
                    defineLocale(x.name, x.config);
                });
            }

            // backwards compat for now: also set the locale
            // make sure we set the locale AFTER all child locales have been
            // created, so we won't end up with the child locale set.
            getSetGlobalLocale(name);


            return locales[name];
        } else {
            // useful for testing
            delete locales[name];
            return null;
        }
    }

    function updateLocale(name, config) {
        if (config != null) {
            var locale, tmpLocale, parentConfig = baseConfig;
            // MERGE
            tmpLocale = loadLocale(name);
            if (tmpLocale != null) {
                parentConfig = tmpLocale._config;
            }
            config = mergeConfigs(parentConfig, config);
            locale = new Locale(config);
            locale.parentLocale = locales[name];
            locales[name] = locale;

            // backwards compat for now: also set the locale
            getSetGlobalLocale(name);
        } else {
            // pass null for config to unupdate, useful for tests
            if (locales[name] != null) {
                if (locales[name].parentLocale != null) {
                    locales[name] = locales[name].parentLocale;
                } else if (locales[name] != null) {
                    delete locales[name];
                }
            }
        }
        return locales[name];
    }

    // returns locale data
    function getLocale (key) {
        var locale;

        if (key && key._locale && key._locale._abbr) {
            key = key._locale._abbr;
        }

        if (!key) {
            return globalLocale;
        }

        if (!isArray(key)) {
            //short-circuit everything else
            locale = loadLocale(key);
            if (locale) {
                return locale;
            }
            key = [key];
        }

        return chooseLocale(key);
    }

    function listLocales() {
        return keys(locales);
    }

    function checkOverflow (m) {
        var overflow;
        var a = m._a;

        if (a && getParsingFlags(m).overflow === -2) {
            overflow =
                a[MONTH]       < 0 || a[MONTH]       > 11  ? MONTH :
                a[DATE]        < 1 || a[DATE]        > daysInMonth(a[YEAR], a[MONTH]) ? DATE :
                a[HOUR]        < 0 || a[HOUR]        > 24 || (a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0)) ? HOUR :
                a[MINUTE]      < 0 || a[MINUTE]      > 59  ? MINUTE :
                a[SECOND]      < 0 || a[SECOND]      > 59  ? SECOND :
                a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND :
                -1;

            if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
                overflow = DATE;
            }
            if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
                overflow = WEEK;
            }
            if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
                overflow = WEEKDAY;
            }

            getParsingFlags(m).overflow = overflow;
        }

        return m;
    }

    // Pick the first defined of two or three arguments.
    function defaults(a, b, c) {
        if (a != null) {
            return a;
        }
        if (b != null) {
            return b;
        }
        return c;
    }

    function currentDateArray(config) {
        // hooks is actually the exported moment object
        var nowValue = new Date(hooks.now());
        if (config._useUTC) {
            return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
        }
        return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
    }

    // convert an array to a date.
    // the array should mirror the parameters below
    // note: all values past the year are optional and will default to the lowest possible value.
    // [year, month, day , hour, minute, second, millisecond]
    function configFromArray (config) {
        var i, date, input = [], currentDate, expectedWeekday, yearToUse;

        if (config._d) {
            return;
        }

        currentDate = currentDateArray(config);

        //compute day of the year from weeks and weekdays
        if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
            dayOfYearFromWeekInfo(config);
        }

        //if the day of the year is set, figure out what it is
        if (config._dayOfYear != null) {
            yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

            if (config._dayOfYear > daysInYear(yearToUse) || config._dayOfYear === 0) {
                getParsingFlags(config)._overflowDayOfYear = true;
            }

            date = createUTCDate(yearToUse, 0, config._dayOfYear);
            config._a[MONTH] = date.getUTCMonth();
            config._a[DATE] = date.getUTCDate();
        }

        // Default to current date.
        // * if no year, month, day of month are given, default to today
        // * if day of month is given, default month and year
        // * if month is given, default only year
        // * if year is given, don't default anything
        for (i = 0; i < 3 && config._a[i] == null; ++i) {
            config._a[i] = input[i] = currentDate[i];
        }

        // Zero out whatever was not defaulted, including time
        for (; i < 7; i++) {
            config._a[i] = input[i] = (config._a[i] == null) ? (i === 2 ? 1 : 0) : config._a[i];
        }

        // Check for 24:00:00.000
        if (config._a[HOUR] === 24 &&
                config._a[MINUTE] === 0 &&
                config._a[SECOND] === 0 &&
                config._a[MILLISECOND] === 0) {
            config._nextDay = true;
            config._a[HOUR] = 0;
        }

        config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
        expectedWeekday = config._useUTC ? config._d.getUTCDay() : config._d.getDay();

        // Apply timezone offset from input. The actual utcOffset can be changed
        // with parseZone.
        if (config._tzm != null) {
            config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
        }

        if (config._nextDay) {
            config._a[HOUR] = 24;
        }

        // check for mismatching day of week
        if (config._w && typeof config._w.d !== 'undefined' && config._w.d !== expectedWeekday) {
            getParsingFlags(config).weekdayMismatch = true;
        }
    }

    function dayOfYearFromWeekInfo(config) {
        var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow;

        w = config._w;
        if (w.GG != null || w.W != null || w.E != null) {
            dow = 1;
            doy = 4;

            // TODO: We need to take the current isoWeekYear, but that depends on
            // how we interpret now (local, utc, fixed offset). So create
            // a now version of current config (take local/utc/offset flags, and
            // create now).
            weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
            week = defaults(w.W, 1);
            weekday = defaults(w.E, 1);
            if (weekday < 1 || weekday > 7) {
                weekdayOverflow = true;
            }
        } else {
            dow = config._locale._week.dow;
            doy = config._locale._week.doy;

            var curWeek = weekOfYear(createLocal(), dow, doy);

            weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);

            // Default to current week.
            week = defaults(w.w, curWeek.week);

            if (w.d != null) {
                // weekday -- low day numbers are considered next week
                weekday = w.d;
                if (weekday < 0 || weekday > 6) {
                    weekdayOverflow = true;
                }
            } else if (w.e != null) {
                // local weekday -- counting starts from begining of week
                weekday = w.e + dow;
                if (w.e < 0 || w.e > 6) {
                    weekdayOverflow = true;
                }
            } else {
                // default to begining of week
                weekday = dow;
            }
        }
        if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
            getParsingFlags(config)._overflowWeeks = true;
        } else if (weekdayOverflow != null) {
            getParsingFlags(config)._overflowWeekday = true;
        } else {
            temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
            config._a[YEAR] = temp.year;
            config._dayOfYear = temp.dayOfYear;
        }
    }

    // iso 8601 regex
    // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
    var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
    var basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;

    var tzRegex = /Z|[+-]\d\d(?::?\d\d)?/;

    var isoDates = [
        ['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/],
        ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/],
        ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/],
        ['GGGG-[W]WW', /\d{4}-W\d\d/, false],
        ['YYYY-DDD', /\d{4}-\d{3}/],
        ['YYYY-MM', /\d{4}-\d\d/, false],
        ['YYYYYYMMDD', /[+-]\d{10}/],
        ['YYYYMMDD', /\d{8}/],
        // YYYYMM is NOT allowed by the standard
        ['GGGG[W]WWE', /\d{4}W\d{3}/],
        ['GGGG[W]WW', /\d{4}W\d{2}/, false],
        ['YYYYDDD', /\d{7}/]
    ];

    // iso time formats and regexes
    var isoTimes = [
        ['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/],
        ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/],
        ['HH:mm:ss', /\d\d:\d\d:\d\d/],
        ['HH:mm', /\d\d:\d\d/],
        ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/],
        ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/],
        ['HHmmss', /\d\d\d\d\d\d/],
        ['HHmm', /\d\d\d\d/],
        ['HH', /\d\d/]
    ];

    var aspNetJsonRegex = /^\/?Date\((\-?\d+)/i;

    // date from iso format
    function configFromISO(config) {
        var i, l,
            string = config._i,
            match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
            allowTime, dateFormat, timeFormat, tzFormat;

        if (match) {
            getParsingFlags(config).iso = true;

            for (i = 0, l = isoDates.length; i < l; i++) {
                if (isoDates[i][1].exec(match[1])) {
                    dateFormat = isoDates[i][0];
                    allowTime = isoDates[i][2] !== false;
                    break;
                }
            }
            if (dateFormat == null) {
                config._isValid = false;
                return;
            }
            if (match[3]) {
                for (i = 0, l = isoTimes.length; i < l; i++) {
                    if (isoTimes[i][1].exec(match[3])) {
                        // match[2] should be 'T' or space
                        timeFormat = (match[2] || ' ') + isoTimes[i][0];
                        break;
                    }
                }
                if (timeFormat == null) {
                    config._isValid = false;
                    return;
                }
            }
            if (!allowTime && timeFormat != null) {
                config._isValid = false;
                return;
            }
            if (match[4]) {
                if (tzRegex.exec(match[4])) {
                    tzFormat = 'Z';
                } else {
                    config._isValid = false;
                    return;
                }
            }
            config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
            configFromStringAndFormat(config);
        } else {
            config._isValid = false;
        }
    }

    // RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3
    var rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;

    function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
        var result = [
            untruncateYear(yearStr),
            defaultLocaleMonthsShort.indexOf(monthStr),
            parseInt(dayStr, 10),
            parseInt(hourStr, 10),
            parseInt(minuteStr, 10)
        ];

        if (secondStr) {
            result.push(parseInt(secondStr, 10));
        }

        return result;
    }

    function untruncateYear(yearStr) {
        var year = parseInt(yearStr, 10);
        if (year <= 49) {
            return 2000 + year;
        } else if (year <= 999) {
            return 1900 + year;
        }
        return year;
    }

    function preprocessRFC2822(s) {
        // Remove comments and folding whitespace and replace multiple-spaces with a single space
        return s.replace(/\([^)]*\)|[\n\t]/g, ' ').replace(/(\s\s+)/g, ' ').replace(/^\s\s*/, '').replace(/\s\s*$/, '');
    }

    function checkWeekday(weekdayStr, parsedInput, config) {
        if (weekdayStr) {
            // TODO: Replace the vanilla JS Date object with an indepentent day-of-week check.
            var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr),
                weekdayActual = new Date(parsedInput[0], parsedInput[1], parsedInput[2]).getDay();
            if (weekdayProvided !== weekdayActual) {
                getParsingFlags(config).weekdayMismatch = true;
                config._isValid = false;
                return false;
            }
        }
        return true;
    }

    var obsOffsets = {
        UT: 0,
        GMT: 0,
        EDT: -4 * 60,
        EST: -5 * 60,
        CDT: -5 * 60,
        CST: -6 * 60,
        MDT: -6 * 60,
        MST: -7 * 60,
        PDT: -7 * 60,
        PST: -8 * 60
    };

    function calculateOffset(obsOffset, militaryOffset, numOffset) {
        if (obsOffset) {
            return obsOffsets[obsOffset];
        } else if (militaryOffset) {
            // the only allowed military tz is Z
            return 0;
        } else {
            var hm = parseInt(numOffset, 10);
            var m = hm % 100, h = (hm - m) / 100;
            return h * 60 + m;
        }
    }

    // date and time from ref 2822 format
    function configFromRFC2822(config) {
        var match = rfc2822.exec(preprocessRFC2822(config._i));
        if (match) {
            var parsedArray = extractFromRFC2822Strings(match[4], match[3], match[2], match[5], match[6], match[7]);
            if (!checkWeekday(match[1], parsedArray, config)) {
                return;
            }

            config._a = parsedArray;
            config._tzm = calculateOffset(match[8], match[9], match[10]);

            config._d = createUTCDate.apply(null, config._a);
            config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);

            getParsingFlags(config).rfc2822 = true;
        } else {
            config._isValid = false;
        }
    }

    // date from iso format or fallback
    function configFromString(config) {
        var matched = aspNetJsonRegex.exec(config._i);

        if (matched !== null) {
            config._d = new Date(+matched[1]);
            return;
        }

        configFromISO(config);
        if (config._isValid === false) {
            delete config._isValid;
        } else {
            return;
        }

        configFromRFC2822(config);
        if (config._isValid === false) {
            delete config._isValid;
        } else {
            return;
        }

        // Final attempt, use Input Fallback
        hooks.createFromInputFallback(config);
    }

    hooks.createFromInputFallback = deprecate(
        'value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' +
        'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' +
        'discouraged and will be removed in an upcoming major release. Please refer to ' +
        'http://momentjs.com/guides/#/warnings/js-date/ for more info.',
        function (config) {
            config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
        }
    );

    // constant that refers to the ISO standard
    hooks.ISO_8601 = function () {};

    // constant that refers to the RFC 2822 form
    hooks.RFC_2822 = function () {};

    // date from string and format string
    function configFromStringAndFormat(config) {
        // TODO: Move this to another part of the creation flow to prevent circular deps
        if (config._f === hooks.ISO_8601) {
            configFromISO(config);
            return;
        }
        if (config._f === hooks.RFC_2822) {
            configFromRFC2822(config);
            return;
        }
        config._a = [];
        getParsingFlags(config).empty = true;

        // This array is used to make a Date, either with `new Date` or `Date.UTC`
        var string = '' + config._i,
            i, parsedInput, tokens, token, skipped,
            stringLength = string.length,
            totalParsedInputLength = 0;

        tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];

        for (i = 0; i < tokens.length; i++) {
            token = tokens[i];
            parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];
            // console.log('token', token, 'parsedInput', parsedInput,
            //         'regex', getParseRegexForToken(token, config));
            if (parsedInput) {
                skipped = string.substr(0, string.indexOf(parsedInput));
                if (skipped.length > 0) {
                    getParsingFlags(config).unusedInput.push(skipped);
                }
                string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
                totalParsedInputLength += parsedInput.length;
            }
            // don't parse if it's not a known token
            if (formatTokenFunctions[token]) {
                if (parsedInput) {
                    getParsingFlags(config).empty = false;
                }
                else {
                    getParsingFlags(config).unusedTokens.push(token);
                }
                addTimeToArrayFromToken(token, parsedInput, config);
            }
            else if (config._strict && !parsedInput) {
                getParsingFlags(config).unusedTokens.push(token);
            }
        }

        // add remaining unparsed input length to the string
        getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;
        if (string.length > 0) {
            getParsingFlags(config).unusedInput.push(string);
        }

        // clear _12h flag if hour is <= 12
        if (config._a[HOUR] <= 12 &&
            getParsingFlags(config).bigHour === true &&
            config._a[HOUR] > 0) {
            getParsingFlags(config).bigHour = undefined;
        }

        getParsingFlags(config).parsedDateParts = config._a.slice(0);
        getParsingFlags(config).meridiem = config._meridiem;
        // handle meridiem
        config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);

        configFromArray(config);
        checkOverflow(config);
    }


    function meridiemFixWrap (locale, hour, meridiem) {
        var isPm;

        if (meridiem == null) {
            // nothing to do
            return hour;
        }
        if (locale.meridiemHour != null) {
            return locale.meridiemHour(hour, meridiem);
        } else if (locale.isPM != null) {
            // Fallback
            isPm = locale.isPM(meridiem);
            if (isPm && hour < 12) {
                hour += 12;
            }
            if (!isPm && hour === 12) {
                hour = 0;
            }
            return hour;
        } else {
            // this is not supposed to happen
            return hour;
        }
    }

    // date from string and array of format strings
    function configFromStringAndArray(config) {
        var tempConfig,
            bestMoment,

            scoreToBeat,
            i,
            currentScore;

        if (config._f.length === 0) {
            getParsingFlags(config).invalidFormat = true;
            config._d = new Date(NaN);
            return;
        }

        for (i = 0; i < config._f.length; i++) {
            currentScore = 0;
            tempConfig = copyConfig({}, config);
            if (config._useUTC != null) {
                tempConfig._useUTC = config._useUTC;
            }
            tempConfig._f = config._f[i];
            configFromStringAndFormat(tempConfig);

            if (!isValid(tempConfig)) {
                continue;
            }

            // if there is any input that was not parsed add a penalty for that format
            currentScore += getParsingFlags(tempConfig).charsLeftOver;

            //or tokens
            currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;

            getParsingFlags(tempConfig).score = currentScore;

            if (scoreToBeat == null || currentScore < scoreToBeat) {
                scoreToBeat = currentScore;
                bestMoment = tempConfig;
            }
        }

        extend(config, bestMoment || tempConfig);
    }

    function configFromObject(config) {
        if (config._d) {
            return;
        }

        var i = normalizeObjectUnits(config._i);
        config._a = map([i.year, i.month, i.day || i.date, i.hour, i.minute, i.second, i.millisecond], function (obj) {
            return obj && parseInt(obj, 10);
        });

        configFromArray(config);
    }

    function createFromConfig (config) {
        var res = new Moment(checkOverflow(prepareConfig(config)));
        if (res._nextDay) {
            // Adding is smart enough around DST
            res.add(1, 'd');
            res._nextDay = undefined;
        }

        return res;
    }

    function prepareConfig (config) {
        var input = config._i,
            format = config._f;

        config._locale = config._locale || getLocale(config._l);

        if (input === null || (format === undefined && input === '')) {
            return createInvalid({nullInput: true});
        }

        if (typeof input === 'string') {
            config._i = input = config._locale.preparse(input);
        }

        if (isMoment(input)) {
            return new Moment(checkOverflow(input));
        } else if (isDate(input)) {
            config._d = input;
        } else if (isArray(format)) {
            configFromStringAndArray(config);
        } else if (format) {
            configFromStringAndFormat(config);
        }  else {
            configFromInput(config);
        }

        if (!isValid(config)) {
            config._d = null;
        }

        return config;
    }

    function configFromInput(config) {
        var input = config._i;
        if (isUndefined(input)) {
            config._d = new Date(hooks.now());
        } else if (isDate(input)) {
            config._d = new Date(input.valueOf());
        } else if (typeof input === 'string') {
            configFromString(config);
        } else if (isArray(input)) {
            config._a = map(input.slice(0), function (obj) {
                return parseInt(obj, 10);
            });
            configFromArray(config);
        } else if (isObject(input)) {
            configFromObject(config);
        } else if (isNumber(input)) {
            // from milliseconds
            config._d = new Date(input);
        } else {
            hooks.createFromInputFallback(config);
        }
    }

    function createLocalOrUTC (input, format, locale, strict, isUTC) {
        var c = {};

        if (locale === true || locale === false) {
            strict = locale;
            locale = undefined;
        }

        if ((isObject(input) && isObjectEmpty(input)) ||
                (isArray(input) && input.length === 0)) {
            input = undefined;
        }
        // object construction must be done this way.
        // https://github.com/moment/moment/issues/1423
        c._isAMomentObject = true;
        c._useUTC = c._isUTC = isUTC;
        c._l = locale;
        c._i = input;
        c._f = format;
        c._strict = strict;

        return createFromConfig(c);
    }

    function createLocal (input, format, locale, strict) {
        return createLocalOrUTC(input, format, locale, strict, false);
    }

    var prototypeMin = deprecate(
        'moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',
        function () {
            var other = createLocal.apply(null, arguments);
            if (this.isValid() && other.isValid()) {
                return other < this ? this : other;
            } else {
                return createInvalid();
            }
        }
    );

    var prototypeMax = deprecate(
        'moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',
        function () {
            var other = createLocal.apply(null, arguments);
            if (this.isValid() && other.isValid()) {
                return other > this ? this : other;
            } else {
                return createInvalid();
            }
        }
    );

    // Pick a moment m from moments so that m[fn](other) is true for all
    // other. This relies on the function fn to be transitive.
    //
    // moments should either be an array of moment objects or an array, whose
    // first element is an array of moment objects.
    function pickBy(fn, moments) {
        var res, i;
        if (moments.length === 1 && isArray(moments[0])) {
            moments = moments[0];
        }
        if (!moments.length) {
            return createLocal();
        }
        res = moments[0];
        for (i = 1; i < moments.length; ++i) {
            if (!moments[i].isValid() || moments[i][fn](res)) {
                res = moments[i];
            }
        }
        return res;
    }

    // TODO: Use [].sort instead?
    function min () {
        var args = [].slice.call(arguments, 0);

        return pickBy('isBefore', args);
    }

    function max () {
        var args = [].slice.call(arguments, 0);

        return pickBy('isAfter', args);
    }

    var now = function () {
        return Date.now ? Date.now() : +(new Date());
    };

    var ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];

    function isDurationValid(m) {
        for (var key in m) {
            if (!(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
                return false;
            }
        }

        var unitHasDecimal = false;
        for (var i = 0; i < ordering.length; ++i) {
            if (m[ordering[i]]) {
                if (unitHasDecimal) {
                    return false; // only allow non-integers for smallest unit
                }
                if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
                    unitHasDecimal = true;
                }
            }
        }

        return true;
    }

    function isValid$1() {
        return this._isValid;
    }

    function createInvalid$1() {
        return createDuration(NaN);
    }

    function Duration (duration) {
        var normalizedInput = normalizeObjectUnits(duration),
            years = normalizedInput.year || 0,
            quarters = normalizedInput.quarter || 0,
            months = normalizedInput.month || 0,
            weeks = normalizedInput.week || 0,
            days = normalizedInput.day || 0,
            hours = normalizedInput.hour || 0,
            minutes = normalizedInput.minute || 0,
            seconds = normalizedInput.second || 0,
            milliseconds = normalizedInput.millisecond || 0;

        this._isValid = isDurationValid(normalizedInput);

        // representation for dateAddRemove
        this._milliseconds = +milliseconds +
            seconds * 1e3 + // 1000
            minutes * 6e4 + // 1000 * 60
            hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
        // Because of dateAddRemove treats 24 hours as different from a
        // day when working around DST, we need to store them separately
        this._days = +days +
            weeks * 7;
        // It is impossible to translate months into days without knowing
        // which months you are are talking about, so we have to store
        // it separately.
        this._months = +months +
            quarters * 3 +
            years * 12;

        this._data = {};

        this._locale = getLocale();

        this._bubble();
    }

    function isDuration (obj) {
        return obj instanceof Duration;
    }

    function absRound (number) {
        if (number < 0) {
            return Math.round(-1 * number) * -1;
        } else {
            return Math.round(number);
        }
    }

    // FORMATTING

    function offset (token, separator) {
        addFormatToken(token, 0, 0, function () {
            var offset = this.utcOffset();
            var sign = '+';
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            }
            return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~(offset) % 60, 2);
        });
    }

    offset('Z', ':');
    offset('ZZ', '');

    // PARSING

    addRegexToken('Z',  matchShortOffset);
    addRegexToken('ZZ', matchShortOffset);
    addParseToken(['Z', 'ZZ'], function (input, array, config) {
        config._useUTC = true;
        config._tzm = offsetFromString(matchShortOffset, input);
    });

    // HELPERS

    // timezone chunker
    // '+10:00' > ['10',  '00']
    // '-1530'  > ['-15', '30']
    var chunkOffset = /([\+\-]|\d\d)/gi;

    function offsetFromString(matcher, string) {
        var matches = (string || '').match(matcher);

        if (matches === null) {
            return null;
        }

        var chunk   = matches[matches.length - 1] || [];
        var parts   = (chunk + '').match(chunkOffset) || ['-', 0, 0];
        var minutes = +(parts[1] * 60) + toInt(parts[2]);

        return minutes === 0 ?
          0 :
          parts[0] === '+' ? minutes : -minutes;
    }

    // Return a moment from input, that is local/utc/zone equivalent to model.
    function cloneWithOffset(input, model) {
        var res, diff;
        if (model._isUTC) {
            res = model.clone();
            diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
            // Use low-level api, because this fn is low-level api.
            res._d.setTime(res._d.valueOf() + diff);
            hooks.updateOffset(res, false);
            return res;
        } else {
            return createLocal(input).local();
        }
    }

    function getDateOffset (m) {
        // On Firefox.24 Date#getTimezoneOffset returns a floating point.
        // https://github.com/moment/moment/pull/1871
        return -Math.round(m._d.getTimezoneOffset() / 15) * 15;
    }

    // HOOKS

    // This function will be called whenever a moment is mutated.
    // It is intended to keep the offset in sync with the timezone.
    hooks.updateOffset = function () {};

    // MOMENTS

    // keepLocalTime = true means only change the timezone, without
    // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
    // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
    // +0200, so we adjust the time as needed, to be valid.
    //
    // Keeping the time actually adds/subtracts (one hour)
    // from the actual represented time. That is why we call updateOffset
    // a second time. In case it wants us to change the offset again
    // _changeInProgress == true case, then we have to adjust, because
    // there is no such time in the given timezone.
    function getSetOffset (input, keepLocalTime, keepMinutes) {
        var offset = this._offset || 0,
            localAdjust;
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        if (input != null) {
            if (typeof input === 'string') {
                input = offsetFromString(matchShortOffset, input);
                if (input === null) {
                    return this;
                }
            } else if (Math.abs(input) < 16 && !keepMinutes) {
                input = input * 60;
            }
            if (!this._isUTC && keepLocalTime) {
                localAdjust = getDateOffset(this);
            }
            this._offset = input;
            this._isUTC = true;
            if (localAdjust != null) {
                this.add(localAdjust, 'm');
            }
            if (offset !== input) {
                if (!keepLocalTime || this._changeInProgress) {
                    addSubtract(this, createDuration(input - offset, 'm'), 1, false);
                } else if (!this._changeInProgress) {
                    this._changeInProgress = true;
                    hooks.updateOffset(this, true);
                    this._changeInProgress = null;
                }
            }
            return this;
        } else {
            return this._isUTC ? offset : getDateOffset(this);
        }
    }

    function getSetZone (input, keepLocalTime) {
        if (input != null) {
            if (typeof input !== 'string') {
                input = -input;
            }

            this.utcOffset(input, keepLocalTime);

            return this;
        } else {
            return -this.utcOffset();
        }
    }

    function setOffsetToUTC (keepLocalTime) {
        return this.utcOffset(0, keepLocalTime);
    }

    function setOffsetToLocal (keepLocalTime) {
        if (this._isUTC) {
            this.utcOffset(0, keepLocalTime);
            this._isUTC = false;

            if (keepLocalTime) {
                this.subtract(getDateOffset(this), 'm');
            }
        }
        return this;
    }

    function setOffsetToParsedOffset () {
        if (this._tzm != null) {
            this.utcOffset(this._tzm, false, true);
        } else if (typeof this._i === 'string') {
            var tZone = offsetFromString(matchOffset, this._i);
            if (tZone != null) {
                this.utcOffset(tZone);
            }
            else {
                this.utcOffset(0, true);
            }
        }
        return this;
    }

    function hasAlignedHourOffset (input) {
        if (!this.isValid()) {
            return false;
        }
        input = input ? createLocal(input).utcOffset() : 0;

        return (this.utcOffset() - input) % 60 === 0;
    }

    function isDaylightSavingTime () {
        return (
            this.utcOffset() > this.clone().month(0).utcOffset() ||
            this.utcOffset() > this.clone().month(5).utcOffset()
        );
    }

    function isDaylightSavingTimeShifted () {
        if (!isUndefined(this._isDSTShifted)) {
            return this._isDSTShifted;
        }

        var c = {};

        copyConfig(c, this);
        c = prepareConfig(c);

        if (c._a) {
            var other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
            this._isDSTShifted = this.isValid() &&
                compareArrays(c._a, other.toArray()) > 0;
        } else {
            this._isDSTShifted = false;
        }

        return this._isDSTShifted;
    }

    function isLocal () {
        return this.isValid() ? !this._isUTC : false;
    }

    function isUtcOffset () {
        return this.isValid() ? this._isUTC : false;
    }

    function isUtc () {
        return this.isValid() ? this._isUTC && this._offset === 0 : false;
    }

    // ASP.NET json date format regex
    var aspNetRegex = /^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;

    // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
    // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
    // and further modified to allow for strings containing both week and day
    var isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;

    function createDuration (input, key) {
        var duration = input,
            // matching against regexp is expensive, do it on demand
            match = null,
            sign,
            ret,
            diffRes;

        if (isDuration(input)) {
            duration = {
                ms : input._milliseconds,
                d  : input._days,
                M  : input._months
            };
        } else if (isNumber(input)) {
            duration = {};
            if (key) {
                duration[key] = input;
            } else {
                duration.milliseconds = input;
            }
        } else if (!!(match = aspNetRegex.exec(input))) {
            sign = (match[1] === '-') ? -1 : 1;
            duration = {
                y  : 0,
                d  : toInt(match[DATE])                         * sign,
                h  : toInt(match[HOUR])                         * sign,
                m  : toInt(match[MINUTE])                       * sign,
                s  : toInt(match[SECOND])                       * sign,
                ms : toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match
            };
        } else if (!!(match = isoRegex.exec(input))) {
            sign = (match[1] === '-') ? -1 : (match[1] === '+') ? 1 : 1;
            duration = {
                y : parseIso(match[2], sign),
                M : parseIso(match[3], sign),
                w : parseIso(match[4], sign),
                d : parseIso(match[5], sign),
                h : parseIso(match[6], sign),
                m : parseIso(match[7], sign),
                s : parseIso(match[8], sign)
            };
        } else if (duration == null) {// checks for null or undefined
            duration = {};
        } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
            diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));

            duration = {};
            duration.ms = diffRes.milliseconds;
            duration.M = diffRes.months;
        }

        ret = new Duration(duration);

        if (isDuration(input) && hasOwnProp(input, '_locale')) {
            ret._locale = input._locale;
        }

        return ret;
    }

    createDuration.fn = Duration.prototype;
    createDuration.invalid = createInvalid$1;

    function parseIso (inp, sign) {
        // We'd normally use ~~inp for this, but unfortunately it also
        // converts floats to ints.
        // inp may be undefined, so careful calling replace on it.
        var res = inp && parseFloat(inp.replace(',', '.'));
        // apply sign while we're at it
        return (isNaN(res) ? 0 : res) * sign;
    }

    function positiveMomentsDifference(base, other) {
        var res = {milliseconds: 0, months: 0};

        res.months = other.month() - base.month() +
            (other.year() - base.year()) * 12;
        if (base.clone().add(res.months, 'M').isAfter(other)) {
            --res.months;
        }

        res.milliseconds = +other - +(base.clone().add(res.months, 'M'));

        return res;
    }

    function momentsDifference(base, other) {
        var res;
        if (!(base.isValid() && other.isValid())) {
            return {milliseconds: 0, months: 0};
        }

        other = cloneWithOffset(other, base);
        if (base.isBefore(other)) {
            res = positiveMomentsDifference(base, other);
        } else {
            res = positiveMomentsDifference(other, base);
            res.milliseconds = -res.milliseconds;
            res.months = -res.months;
        }

        return res;
    }

    // TODO: remove 'name' arg after deprecation is removed
    function createAdder(direction, name) {
        return function (val, period) {
            var dur, tmp;
            //invert the arguments, but complain about it
            if (period !== null && !isNaN(+period)) {
                deprecateSimple(name, 'moment().' + name  + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' +
                'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
                tmp = val; val = period; period = tmp;
            }

            val = typeof val === 'string' ? +val : val;
            dur = createDuration(val, period);
            addSubtract(this, dur, direction);
            return this;
        };
    }

    function addSubtract (mom, duration, isAdding, updateOffset) {
        var milliseconds = duration._milliseconds,
            days = absRound(duration._days),
            months = absRound(duration._months);

        if (!mom.isValid()) {
            // No op
            return;
        }

        updateOffset = updateOffset == null ? true : updateOffset;

        if (months) {
            setMonth(mom, get(mom, 'Month') + months * isAdding);
        }
        if (days) {
            set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
        }
        if (milliseconds) {
            mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
        }
        if (updateOffset) {
            hooks.updateOffset(mom, days || months);
        }
    }

    var add      = createAdder(1, 'add');
    var subtract = createAdder(-1, 'subtract');

    function getCalendarFormat(myMoment, now) {
        var diff = myMoment.diff(now, 'days', true);
        return diff < -6 ? 'sameElse' :
                diff < -1 ? 'lastWeek' :
                diff < 0 ? 'lastDay' :
                diff < 1 ? 'sameDay' :
                diff < 2 ? 'nextDay' :
                diff < 7 ? 'nextWeek' : 'sameElse';
    }

    function calendar$1 (time, formats) {
        // We want to compare the start of today, vs this.
        // Getting start-of-today depends on whether we're local/utc/offset or not.
        var now = time || createLocal(),
            sod = cloneWithOffset(now, this).startOf('day'),
            format = hooks.calendarFormat(this, sod) || 'sameElse';

        var output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);

        return this.format(output || this.localeData().calendar(format, this, createLocal(now)));
    }

    function clone () {
        return new Moment(this);
    }

    function isAfter (input, units) {
        var localInput = isMoment(input) ? input : createLocal(input);
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
        if (units === 'millisecond') {
            return this.valueOf() > localInput.valueOf();
        } else {
            return localInput.valueOf() < this.clone().startOf(units).valueOf();
        }
    }

    function isBefore (input, units) {
        var localInput = isMoment(input) ? input : createLocal(input);
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
        if (units === 'millisecond') {
            return this.valueOf() < localInput.valueOf();
        } else {
            return this.clone().endOf(units).valueOf() < localInput.valueOf();
        }
    }

    function isBetween (from, to, units, inclusivity) {
        inclusivity = inclusivity || '()';
        return (inclusivity[0] === '(' ? this.isAfter(from, units) : !this.isBefore(from, units)) &&
            (inclusivity[1] === ')' ? this.isBefore(to, units) : !this.isAfter(to, units));
    }

    function isSame (input, units) {
        var localInput = isMoment(input) ? input : createLocal(input),
            inputMs;
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(units || 'millisecond');
        if (units === 'millisecond') {
            return this.valueOf() === localInput.valueOf();
        } else {
            inputMs = localInput.valueOf();
            return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
        }
    }

    function isSameOrAfter (input, units) {
        return this.isSame(input, units) || this.isAfter(input,units);
    }

    function isSameOrBefore (input, units) {
        return this.isSame(input, units) || this.isBefore(input,units);
    }

    function diff (input, units, asFloat) {
        var that,
            zoneDelta,
            output;

        if (!this.isValid()) {
            return NaN;
        }

        that = cloneWithOffset(input, this);

        if (!that.isValid()) {
            return NaN;
        }

        zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;

        units = normalizeUnits(units);

        switch (units) {
            case 'year': output = monthDiff(this, that) / 12; break;
            case 'month': output = monthDiff(this, that); break;
            case 'quarter': output = monthDiff(this, that) / 3; break;
            case 'second': output = (this - that) / 1e3; break; // 1000
            case 'minute': output = (this - that) / 6e4; break; // 1000 * 60
            case 'hour': output = (this - that) / 36e5; break; // 1000 * 60 * 60
            case 'day': output = (this - that - zoneDelta) / 864e5; break; // 1000 * 60 * 60 * 24, negate dst
            case 'week': output = (this - that - zoneDelta) / 6048e5; break; // 1000 * 60 * 60 * 24 * 7, negate dst
            default: output = this - that;
        }

        return asFloat ? output : absFloor(output);
    }

    function monthDiff (a, b) {
        // difference in months
        var wholeMonthDiff = ((b.year() - a.year()) * 12) + (b.month() - a.month()),
            // b is in (anchor - 1 month, anchor + 1 month)
            anchor = a.clone().add(wholeMonthDiff, 'months'),
            anchor2, adjust;

        if (b - anchor < 0) {
            anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');
            // linear across the month
            adjust = (b - anchor) / (anchor - anchor2);
        } else {
            anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');
            // linear across the month
            adjust = (b - anchor) / (anchor2 - anchor);
        }

        //check for negative zero, return zero if negative zero
        return -(wholeMonthDiff + adjust) || 0;
    }

    hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
    hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';

    function toString () {
        return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
    }

    function toISOString(keepOffset) {
        if (!this.isValid()) {
            return null;
        }
        var utc = keepOffset !== true;
        var m = utc ? this.clone().utc() : this;
        if (m.year() < 0 || m.year() > 9999) {
            return formatMoment(m, utc ? 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ');
        }
        if (isFunction(Date.prototype.toISOString)) {
            // native implementation is ~50x faster, use it when we can
            if (utc) {
                return this.toDate().toISOString();
            } else {
                return new Date(this.valueOf() + this.utcOffset() * 60 * 1000).toISOString().replace('Z', formatMoment(m, 'Z'));
            }
        }
        return formatMoment(m, utc ? 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYY-MM-DD[T]HH:mm:ss.SSSZ');
    }

    /**
     * Return a human readable representation of a moment that can
     * also be evaluated to get a new moment which is the same
     *
     * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
     */
    function inspect () {
        if (!this.isValid()) {
            return 'moment.invalid(/* ' + this._i + ' */)';
        }
        var func = 'moment';
        var zone = '';
        if (!this.isLocal()) {
            func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
            zone = 'Z';
        }
        var prefix = '[' + func + '("]';
        var year = (0 <= this.year() && this.year() <= 9999) ? 'YYYY' : 'YYYYYY';
        var datetime = '-MM-DD[T]HH:mm:ss.SSS';
        var suffix = zone + '[")]';

        return this.format(prefix + year + datetime + suffix);
    }

    function format (inputString) {
        if (!inputString) {
            inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
        }
        var output = formatMoment(this, inputString);
        return this.localeData().postformat(output);
    }

    function from (time, withoutSuffix) {
        if (this.isValid() &&
                ((isMoment(time) && time.isValid()) ||
                 createLocal(time).isValid())) {
            return createDuration({to: this, from: time}).locale(this.locale()).humanize(!withoutSuffix);
        } else {
            return this.localeData().invalidDate();
        }
    }

    function fromNow (withoutSuffix) {
        return this.from(createLocal(), withoutSuffix);
    }

    function to (time, withoutSuffix) {
        if (this.isValid() &&
                ((isMoment(time) && time.isValid()) ||
                 createLocal(time).isValid())) {
            return createDuration({from: this, to: time}).locale(this.locale()).humanize(!withoutSuffix);
        } else {
            return this.localeData().invalidDate();
        }
    }

    function toNow (withoutSuffix) {
        return this.to(createLocal(), withoutSuffix);
    }

    // If passed a locale key, it will set the locale for this
    // instance.  Otherwise, it will return the locale configuration
    // variables for this instance.
    function locale (key) {
        var newLocaleData;

        if (key === undefined) {
            return this._locale._abbr;
        } else {
            newLocaleData = getLocale(key);
            if (newLocaleData != null) {
                this._locale = newLocaleData;
            }
            return this;
        }
    }

    var lang = deprecate(
        'moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',
        function (key) {
            if (key === undefined) {
                return this.localeData();
            } else {
                return this.locale(key);
            }
        }
    );

    function localeData () {
        return this._locale;
    }

    function startOf (units) {
        units = normalizeUnits(units);
        // the following switch intentionally omits break keywords
        // to utilize falling through the cases.
        switch (units) {
            case 'year':
                this.month(0);
                /* falls through */
            case 'quarter':
            case 'month':
                this.date(1);
                /* falls through */
            case 'week':
            case 'isoWeek':
            case 'day':
            case 'date':
                this.hours(0);
                /* falls through */
            case 'hour':
                this.minutes(0);
                /* falls through */
            case 'minute':
                this.seconds(0);
                /* falls through */
            case 'second':
                this.milliseconds(0);
        }

        // weeks are a special case
        if (units === 'week') {
            this.weekday(0);
        }
        if (units === 'isoWeek') {
            this.isoWeekday(1);
        }

        // quarters are also special
        if (units === 'quarter') {
            this.month(Math.floor(this.month() / 3) * 3);
        }

        return this;
    }

    function endOf (units) {
        units = normalizeUnits(units);
        if (units === undefined || units === 'millisecond') {
            return this;
        }

        // 'date' is an alias for 'day', so it should be considered as such.
        if (units === 'date') {
            units = 'day';
        }

        return this.startOf(units).add(1, (units === 'isoWeek' ? 'week' : units)).subtract(1, 'ms');
    }

    function valueOf () {
        return this._d.valueOf() - ((this._offset || 0) * 60000);
    }

    function unix () {
        return Math.floor(this.valueOf() / 1000);
    }

    function toDate () {
        return new Date(this.valueOf());
    }

    function toArray () {
        var m = this;
        return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
    }

    function toObject () {
        var m = this;
        return {
            years: m.year(),
            months: m.month(),
            date: m.date(),
            hours: m.hours(),
            minutes: m.minutes(),
            seconds: m.seconds(),
            milliseconds: m.milliseconds()
        };
    }

    function toJSON () {
        // new Date(NaN).toJSON() === null
        return this.isValid() ? this.toISOString() : null;
    }

    function isValid$2 () {
        return isValid(this);
    }

    function parsingFlags () {
        return extend({}, getParsingFlags(this));
    }

    function invalidAt () {
        return getParsingFlags(this).overflow;
    }

    function creationData() {
        return {
            input: this._i,
            format: this._f,
            locale: this._locale,
            isUTC: this._isUTC,
            strict: this._strict
        };
    }

    // FORMATTING

    addFormatToken(0, ['gg', 2], 0, function () {
        return this.weekYear() % 100;
    });

    addFormatToken(0, ['GG', 2], 0, function () {
        return this.isoWeekYear() % 100;
    });

    function addWeekYearFormatToken (token, getter) {
        addFormatToken(0, [token, token.length], 0, getter);
    }

    addWeekYearFormatToken('gggg',     'weekYear');
    addWeekYearFormatToken('ggggg',    'weekYear');
    addWeekYearFormatToken('GGGG',  'isoWeekYear');
    addWeekYearFormatToken('GGGGG', 'isoWeekYear');

    // ALIASES

    addUnitAlias('weekYear', 'gg');
    addUnitAlias('isoWeekYear', 'GG');

    // PRIORITY

    addUnitPriority('weekYear', 1);
    addUnitPriority('isoWeekYear', 1);


    // PARSING

    addRegexToken('G',      matchSigned);
    addRegexToken('g',      matchSigned);
    addRegexToken('GG',     match1to2, match2);
    addRegexToken('gg',     match1to2, match2);
    addRegexToken('GGGG',   match1to4, match4);
    addRegexToken('gggg',   match1to4, match4);
    addRegexToken('GGGGG',  match1to6, match6);
    addRegexToken('ggggg',  match1to6, match6);

    addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
        week[token.substr(0, 2)] = toInt(input);
    });

    addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
        week[token] = hooks.parseTwoDigitYear(input);
    });

    // MOMENTS

    function getSetWeekYear (input) {
        return getSetWeekYearHelper.call(this,
                input,
                this.week(),
                this.weekday(),
                this.localeData()._week.dow,
                this.localeData()._week.doy);
    }

    function getSetISOWeekYear (input) {
        return getSetWeekYearHelper.call(this,
                input, this.isoWeek(), this.isoWeekday(), 1, 4);
    }

    function getISOWeeksInYear () {
        return weeksInYear(this.year(), 1, 4);
    }

    function getWeeksInYear () {
        var weekInfo = this.localeData()._week;
        return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
    }

    function getSetWeekYearHelper(input, week, weekday, dow, doy) {
        var weeksTarget;
        if (input == null) {
            return weekOfYear(this, dow, doy).year;
        } else {
            weeksTarget = weeksInYear(input, dow, doy);
            if (week > weeksTarget) {
                week = weeksTarget;
            }
            return setWeekAll.call(this, input, week, weekday, dow, doy);
        }
    }

    function setWeekAll(weekYear, week, weekday, dow, doy) {
        var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
            date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);

        this.year(date.getUTCFullYear());
        this.month(date.getUTCMonth());
        this.date(date.getUTCDate());
        return this;
    }

    // FORMATTING

    addFormatToken('Q', 0, 'Qo', 'quarter');

    // ALIASES

    addUnitAlias('quarter', 'Q');

    // PRIORITY

    addUnitPriority('quarter', 7);

    // PARSING

    addRegexToken('Q', match1);
    addParseToken('Q', function (input, array) {
        array[MONTH] = (toInt(input) - 1) * 3;
    });

    // MOMENTS

    function getSetQuarter (input) {
        return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
    }

    // FORMATTING

    addFormatToken('D', ['DD', 2], 'Do', 'date');

    // ALIASES

    addUnitAlias('date', 'D');

    // PRIORITY
    addUnitPriority('date', 9);

    // PARSING

    addRegexToken('D',  match1to2);
    addRegexToken('DD', match1to2, match2);
    addRegexToken('Do', function (isStrict, locale) {
        // TODO: Remove "ordinalParse" fallback in next major release.
        return isStrict ?
          (locale._dayOfMonthOrdinalParse || locale._ordinalParse) :
          locale._dayOfMonthOrdinalParseLenient;
    });

    addParseToken(['D', 'DD'], DATE);
    addParseToken('Do', function (input, array) {
        array[DATE] = toInt(input.match(match1to2)[0]);
    });

    // MOMENTS

    var getSetDayOfMonth = makeGetSet('Date', true);

    // FORMATTING

    addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');

    // ALIASES

    addUnitAlias('dayOfYear', 'DDD');

    // PRIORITY
    addUnitPriority('dayOfYear', 4);

    // PARSING

    addRegexToken('DDD',  match1to3);
    addRegexToken('DDDD', match3);
    addParseToken(['DDD', 'DDDD'], function (input, array, config) {
        config._dayOfYear = toInt(input);
    });

    // HELPERS

    // MOMENTS

    function getSetDayOfYear (input) {
        var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
        return input == null ? dayOfYear : this.add((input - dayOfYear), 'd');
    }

    // FORMATTING

    addFormatToken('m', ['mm', 2], 0, 'minute');

    // ALIASES

    addUnitAlias('minute', 'm');

    // PRIORITY

    addUnitPriority('minute', 14);

    // PARSING

    addRegexToken('m',  match1to2);
    addRegexToken('mm', match1to2, match2);
    addParseToken(['m', 'mm'], MINUTE);

    // MOMENTS

    var getSetMinute = makeGetSet('Minutes', false);

    // FORMATTING

    addFormatToken('s', ['ss', 2], 0, 'second');

    // ALIASES

    addUnitAlias('second', 's');

    // PRIORITY

    addUnitPriority('second', 15);

    // PARSING

    addRegexToken('s',  match1to2);
    addRegexToken('ss', match1to2, match2);
    addParseToken(['s', 'ss'], SECOND);

    // MOMENTS

    var getSetSecond = makeGetSet('Seconds', false);

    // FORMATTING

    addFormatToken('S', 0, 0, function () {
        return ~~(this.millisecond() / 100);
    });

    addFormatToken(0, ['SS', 2], 0, function () {
        return ~~(this.millisecond() / 10);
    });

    addFormatToken(0, ['SSS', 3], 0, 'millisecond');
    addFormatToken(0, ['SSSS', 4], 0, function () {
        return this.millisecond() * 10;
    });
    addFormatToken(0, ['SSSSS', 5], 0, function () {
        return this.millisecond() * 100;
    });
    addFormatToken(0, ['SSSSSS', 6], 0, function () {
        return this.millisecond() * 1000;
    });
    addFormatToken(0, ['SSSSSSS', 7], 0, function () {
        return this.millisecond() * 10000;
    });
    addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
        return this.millisecond() * 100000;
    });
    addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
        return this.millisecond() * 1000000;
    });


    // ALIASES

    addUnitAlias('millisecond', 'ms');

    // PRIORITY

    addUnitPriority('millisecond', 16);

    // PARSING

    addRegexToken('S',    match1to3, match1);
    addRegexToken('SS',   match1to3, match2);
    addRegexToken('SSS',  match1to3, match3);

    var token;
    for (token = 'SSSS'; token.length <= 9; token += 'S') {
        addRegexToken(token, matchUnsigned);
    }

    function parseMs(input, array) {
        array[MILLISECOND] = toInt(('0.' + input) * 1000);
    }

    for (token = 'S'; token.length <= 9; token += 'S') {
        addParseToken(token, parseMs);
    }
    // MOMENTS

    var getSetMillisecond = makeGetSet('Milliseconds', false);

    // FORMATTING

    addFormatToken('z',  0, 0, 'zoneAbbr');
    addFormatToken('zz', 0, 0, 'zoneName');

    // MOMENTS

    function getZoneAbbr () {
        return this._isUTC ? 'UTC' : '';
    }

    function getZoneName () {
        return this._isUTC ? 'Coordinated Universal Time' : '';
    }

    var proto = Moment.prototype;

    proto.add               = add;
    proto.calendar          = calendar$1;
    proto.clone             = clone;
    proto.diff              = diff;
    proto.endOf             = endOf;
    proto.format            = format;
    proto.from              = from;
    proto.fromNow           = fromNow;
    proto.to                = to;
    proto.toNow             = toNow;
    proto.get               = stringGet;
    proto.invalidAt         = invalidAt;
    proto.isAfter           = isAfter;
    proto.isBefore          = isBefore;
    proto.isBetween         = isBetween;
    proto.isSame            = isSame;
    proto.isSameOrAfter     = isSameOrAfter;
    proto.isSameOrBefore    = isSameOrBefore;
    proto.isValid           = isValid$2;
    proto.lang              = lang;
    proto.locale            = locale;
    proto.localeData        = localeData;
    proto.max               = prototypeMax;
    proto.min               = prototypeMin;
    proto.parsingFlags      = parsingFlags;
    proto.set               = stringSet;
    proto.startOf           = startOf;
    proto.subtract          = subtract;
    proto.toArray           = toArray;
    proto.toObject          = toObject;
    proto.toDate            = toDate;
    proto.toISOString       = toISOString;
    proto.inspect           = inspect;
    proto.toJSON            = toJSON;
    proto.toString          = toString;
    proto.unix              = unix;
    proto.valueOf           = valueOf;
    proto.creationData      = creationData;
    proto.year       = getSetYear;
    proto.isLeapYear = getIsLeapYear;
    proto.weekYear    = getSetWeekYear;
    proto.isoWeekYear = getSetISOWeekYear;
    proto.quarter = proto.quarters = getSetQuarter;
    proto.month       = getSetMonth;
    proto.daysInMonth = getDaysInMonth;
    proto.week           = proto.weeks        = getSetWeek;
    proto.isoWeek        = proto.isoWeeks     = getSetISOWeek;
    proto.weeksInYear    = getWeeksInYear;
    proto.isoWeeksInYear = getISOWeeksInYear;
    proto.date       = getSetDayOfMonth;
    proto.day        = proto.days             = getSetDayOfWeek;
    proto.weekday    = getSetLocaleDayOfWeek;
    proto.isoWeekday = getSetISODayOfWeek;
    proto.dayOfYear  = getSetDayOfYear;
    proto.hour = proto.hours = getSetHour;
    proto.minute = proto.minutes = getSetMinute;
    proto.second = proto.seconds = getSetSecond;
    proto.millisecond = proto.milliseconds = getSetMillisecond;
    proto.utcOffset            = getSetOffset;
    proto.utc                  = setOffsetToUTC;
    proto.local                = setOffsetToLocal;
    proto.parseZone            = setOffsetToParsedOffset;
    proto.hasAlignedHourOffset = hasAlignedHourOffset;
    proto.isDST                = isDaylightSavingTime;
    proto.isLocal              = isLocal;
    proto.isUtcOffset          = isUtcOffset;
    proto.isUtc                = isUtc;
    proto.isUTC                = isUtc;
    proto.zoneAbbr = getZoneAbbr;
    proto.zoneName = getZoneName;
    proto.dates  = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
    proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
    proto.years  = deprecate('years accessor is deprecated. Use year instead', getSetYear);
    proto.zone   = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
    proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);

    function createUnix (input) {
        return createLocal(input * 1000);
    }

    function createInZone () {
        return createLocal.apply(null, arguments).parseZone();
    }

    function preParsePostFormat (string) {
        return string;
    }

    var proto$1 = Locale.prototype;

    proto$1.calendar        = calendar;
    proto$1.longDateFormat  = longDateFormat;
    proto$1.invalidDate     = invalidDate;
    proto$1.ordinal         = ordinal;
    proto$1.preparse        = preParsePostFormat;
    proto$1.postformat      = preParsePostFormat;
    proto$1.relativeTime    = relativeTime;
    proto$1.pastFuture      = pastFuture;
    proto$1.set             = set;

    proto$1.months            =        localeMonths;
    proto$1.monthsShort       =        localeMonthsShort;
    proto$1.monthsParse       =        localeMonthsParse;
    proto$1.monthsRegex       = monthsRegex;
    proto$1.monthsShortRegex  = monthsShortRegex;
    proto$1.week = localeWeek;
    proto$1.firstDayOfYear = localeFirstDayOfYear;
    proto$1.firstDayOfWeek = localeFirstDayOfWeek;

    proto$1.weekdays       =        localeWeekdays;
    proto$1.weekdaysMin    =        localeWeekdaysMin;
    proto$1.weekdaysShort  =        localeWeekdaysShort;
    proto$1.weekdaysParse  =        localeWeekdaysParse;

    proto$1.weekdaysRegex       =        weekdaysRegex;
    proto$1.weekdaysShortRegex  =        weekdaysShortRegex;
    proto$1.weekdaysMinRegex    =        weekdaysMinRegex;

    proto$1.isPM = localeIsPM;
    proto$1.meridiem = localeMeridiem;

    function get$1 (format, index, field, setter) {
        var locale = getLocale();
        var utc = createUTC().set(setter, index);
        return locale[field](utc, format);
    }

    function listMonthsImpl (format, index, field) {
        if (isNumber(format)) {
            index = format;
            format = undefined;
        }

        format = format || '';

        if (index != null) {
            return get$1(format, index, field, 'month');
        }

        var i;
        var out = [];
        for (i = 0; i < 12; i++) {
            out[i] = get$1(format, i, field, 'month');
        }
        return out;
    }

    // ()
    // (5)
    // (fmt, 5)
    // (fmt)
    // (true)
    // (true, 5)
    // (true, fmt, 5)
    // (true, fmt)
    function listWeekdaysImpl (localeSorted, format, index, field) {
        if (typeof localeSorted === 'boolean') {
            if (isNumber(format)) {
                index = format;
                format = undefined;
            }

            format = format || '';
        } else {
            format = localeSorted;
            index = format;
            localeSorted = false;

            if (isNumber(format)) {
                index = format;
                format = undefined;
            }

            format = format || '';
        }

        var locale = getLocale(),
            shift = localeSorted ? locale._week.dow : 0;

        if (index != null) {
            return get$1(format, (index + shift) % 7, field, 'day');
        }

        var i;
        var out = [];
        for (i = 0; i < 7; i++) {
            out[i] = get$1(format, (i + shift) % 7, field, 'day');
        }
        return out;
    }

    function listMonths (format, index) {
        return listMonthsImpl(format, index, 'months');
    }

    function listMonthsShort (format, index) {
        return listMonthsImpl(format, index, 'monthsShort');
    }

    function listWeekdays (localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
    }

    function listWeekdaysShort (localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
    }

    function listWeekdaysMin (localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
    }

    getSetGlobalLocale('en', {
        dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
        ordinal : function (number) {
            var b = number % 10,
                output = (toInt(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                (b === 2) ? 'nd' :
                (b === 3) ? 'rd' : 'th';
            return number + output;
        }
    });

    // Side effect imports

    hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);
    hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);

    var mathAbs = Math.abs;

    function abs () {
        var data           = this._data;

        this._milliseconds = mathAbs(this._milliseconds);
        this._days         = mathAbs(this._days);
        this._months       = mathAbs(this._months);

        data.milliseconds  = mathAbs(data.milliseconds);
        data.seconds       = mathAbs(data.seconds);
        data.minutes       = mathAbs(data.minutes);
        data.hours         = mathAbs(data.hours);
        data.months        = mathAbs(data.months);
        data.years         = mathAbs(data.years);

        return this;
    }

    function addSubtract$1 (duration, input, value, direction) {
        var other = createDuration(input, value);

        duration._milliseconds += direction * other._milliseconds;
        duration._days         += direction * other._days;
        duration._months       += direction * other._months;

        return duration._bubble();
    }

    // supports only 2.0-style add(1, 's') or add(duration)
    function add$1 (input, value) {
        return addSubtract$1(this, input, value, 1);
    }

    // supports only 2.0-style subtract(1, 's') or subtract(duration)
    function subtract$1 (input, value) {
        return addSubtract$1(this, input, value, -1);
    }

    function absCeil (number) {
        if (number < 0) {
            return Math.floor(number);
        } else {
            return Math.ceil(number);
        }
    }

    function bubble () {
        var milliseconds = this._milliseconds;
        var days         = this._days;
        var months       = this._months;
        var data         = this._data;
        var seconds, minutes, hours, years, monthsFromDays;

        // if we have a mix of positive and negative values, bubble down first
        // check: https://github.com/moment/moment/issues/2166
        if (!((milliseconds >= 0 && days >= 0 && months >= 0) ||
                (milliseconds <= 0 && days <= 0 && months <= 0))) {
            milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
            days = 0;
            months = 0;
        }

        // The following code bubbles up values, see the tests for
        // examples of what that means.
        data.milliseconds = milliseconds % 1000;

        seconds           = absFloor(milliseconds / 1000);
        data.seconds      = seconds % 60;

        minutes           = absFloor(seconds / 60);
        data.minutes      = minutes % 60;

        hours             = absFloor(minutes / 60);
        data.hours        = hours % 24;

        days += absFloor(hours / 24);

        // convert days to months
        monthsFromDays = absFloor(daysToMonths(days));
        months += monthsFromDays;
        days -= absCeil(monthsToDays(monthsFromDays));

        // 12 months -> 1 year
        years = absFloor(months / 12);
        months %= 12;

        data.days   = days;
        data.months = months;
        data.years  = years;

        return this;
    }

    function daysToMonths (days) {
        // 400 years have 146097 days (taking into account leap year rules)
        // 400 years have 12 months === 4800
        return days * 4800 / 146097;
    }

    function monthsToDays (months) {
        // the reverse of daysToMonths
        return months * 146097 / 4800;
    }

    function as (units) {
        if (!this.isValid()) {
            return NaN;
        }
        var days;
        var months;
        var milliseconds = this._milliseconds;

        units = normalizeUnits(units);

        if (units === 'month' || units === 'year') {
            days   = this._days   + milliseconds / 864e5;
            months = this._months + daysToMonths(days);
            return units === 'month' ? months : months / 12;
        } else {
            // handle milliseconds separately because of floating point math errors (issue #1867)
            days = this._days + Math.round(monthsToDays(this._months));
            switch (units) {
                case 'week'   : return days / 7     + milliseconds / 6048e5;
                case 'day'    : return days         + milliseconds / 864e5;
                case 'hour'   : return days * 24    + milliseconds / 36e5;
                case 'minute' : return days * 1440  + milliseconds / 6e4;
                case 'second' : return days * 86400 + milliseconds / 1000;
                // Math.floor prevents floating point math errors here
                case 'millisecond': return Math.floor(days * 864e5) + milliseconds;
                default: throw new Error('Unknown unit ' + units);
            }
        }
    }

    // TODO: Use this.as('ms')?
    function valueOf$1 () {
        if (!this.isValid()) {
            return NaN;
        }
        return (
            this._milliseconds +
            this._days * 864e5 +
            (this._months % 12) * 2592e6 +
            toInt(this._months / 12) * 31536e6
        );
    }

    function makeAs (alias) {
        return function () {
            return this.as(alias);
        };
    }

    var asMilliseconds = makeAs('ms');
    var asSeconds      = makeAs('s');
    var asMinutes      = makeAs('m');
    var asHours        = makeAs('h');
    var asDays         = makeAs('d');
    var asWeeks        = makeAs('w');
    var asMonths       = makeAs('M');
    var asYears        = makeAs('y');

    function clone$1 () {
        return createDuration(this);
    }

    function get$2 (units) {
        units = normalizeUnits(units);
        return this.isValid() ? this[units + 's']() : NaN;
    }

    function makeGetter(name) {
        return function () {
            return this.isValid() ? this._data[name] : NaN;
        };
    }

    var milliseconds = makeGetter('milliseconds');
    var seconds      = makeGetter('seconds');
    var minutes      = makeGetter('minutes');
    var hours        = makeGetter('hours');
    var days         = makeGetter('days');
    var months       = makeGetter('months');
    var years        = makeGetter('years');

    function weeks () {
        return absFloor(this.days() / 7);
    }

    var round = Math.round;
    var thresholds = {
        ss: 44,         // a few seconds to seconds
        s : 45,         // seconds to minute
        m : 45,         // minutes to hour
        h : 22,         // hours to day
        d : 26,         // days to month
        M : 11          // months to year
    };

    // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
    function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
        return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
    }

    function relativeTime$1 (posNegDuration, withoutSuffix, locale) {
        var duration = createDuration(posNegDuration).abs();
        var seconds  = round(duration.as('s'));
        var minutes  = round(duration.as('m'));
        var hours    = round(duration.as('h'));
        var days     = round(duration.as('d'));
        var months   = round(duration.as('M'));
        var years    = round(duration.as('y'));

        var a = seconds <= thresholds.ss && ['s', seconds]  ||
                seconds < thresholds.s   && ['ss', seconds] ||
                minutes <= 1             && ['m']           ||
                minutes < thresholds.m   && ['mm', minutes] ||
                hours   <= 1             && ['h']           ||
                hours   < thresholds.h   && ['hh', hours]   ||
                days    <= 1             && ['d']           ||
                days    < thresholds.d   && ['dd', days]    ||
                months  <= 1             && ['M']           ||
                months  < thresholds.M   && ['MM', months]  ||
                years   <= 1             && ['y']           || ['yy', years];

        a[2] = withoutSuffix;
        a[3] = +posNegDuration > 0;
        a[4] = locale;
        return substituteTimeAgo.apply(null, a);
    }

    // This function allows you to set the rounding function for relative time strings
    function getSetRelativeTimeRounding (roundingFunction) {
        if (roundingFunction === undefined) {
            return round;
        }
        if (typeof(roundingFunction) === 'function') {
            round = roundingFunction;
            return true;
        }
        return false;
    }

    // This function allows you to set a threshold for relative time strings
    function getSetRelativeTimeThreshold (threshold, limit) {
        if (thresholds[threshold] === undefined) {
            return false;
        }
        if (limit === undefined) {
            return thresholds[threshold];
        }
        thresholds[threshold] = limit;
        if (threshold === 's') {
            thresholds.ss = limit - 1;
        }
        return true;
    }

    function humanize (withSuffix) {
        if (!this.isValid()) {
            return this.localeData().invalidDate();
        }

        var locale = this.localeData();
        var output = relativeTime$1(this, !withSuffix, locale);

        if (withSuffix) {
            output = locale.pastFuture(+this, output);
        }

        return locale.postformat(output);
    }

    var abs$1 = Math.abs;

    function sign(x) {
        return ((x > 0) - (x < 0)) || +x;
    }

    function toISOString$1() {
        // for ISO strings we do not use the normal bubbling rules:
        //  * milliseconds bubble up until they become hours
        //  * days do not bubble at all
        //  * months bubble up until they become years
        // This is because there is no context-free conversion between hours and days
        // (think of clock changes)
        // and also not between days and months (28-31 days per month)
        if (!this.isValid()) {
            return this.localeData().invalidDate();
        }

        var seconds = abs$1(this._milliseconds) / 1000;
        var days         = abs$1(this._days);
        var months       = abs$1(this._months);
        var minutes, hours, years;

        // 3600 seconds -> 60 minutes -> 1 hour
        minutes           = absFloor(seconds / 60);
        hours             = absFloor(minutes / 60);
        seconds %= 60;
        minutes %= 60;

        // 12 months -> 1 year
        years  = absFloor(months / 12);
        months %= 12;


        // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
        var Y = years;
        var M = months;
        var D = days;
        var h = hours;
        var m = minutes;
        var s = seconds ? seconds.toFixed(3).replace(/\.?0+$/, '') : '';
        var total = this.asSeconds();

        if (!total) {
            // this is the same as C#'s (Noda) and python (isodate)...
            // but not other JS (goog.date)
            return 'P0D';
        }

        var totalSign = total < 0 ? '-' : '';
        var ymSign = sign(this._months) !== sign(total) ? '-' : '';
        var daysSign = sign(this._days) !== sign(total) ? '-' : '';
        var hmsSign = sign(this._milliseconds) !== sign(total) ? '-' : '';

        return totalSign + 'P' +
            (Y ? ymSign + Y + 'Y' : '') +
            (M ? ymSign + M + 'M' : '') +
            (D ? daysSign + D + 'D' : '') +
            ((h || m || s) ? 'T' : '') +
            (h ? hmsSign + h + 'H' : '') +
            (m ? hmsSign + m + 'M' : '') +
            (s ? hmsSign + s + 'S' : '');
    }

    var proto$2 = Duration.prototype;

    proto$2.isValid        = isValid$1;
    proto$2.abs            = abs;
    proto$2.add            = add$1;
    proto$2.subtract       = subtract$1;
    proto$2.as             = as;
    proto$2.asMilliseconds = asMilliseconds;
    proto$2.asSeconds      = asSeconds;
    proto$2.asMinutes      = asMinutes;
    proto$2.asHours        = asHours;
    proto$2.asDays         = asDays;
    proto$2.asWeeks        = asWeeks;
    proto$2.asMonths       = asMonths;
    proto$2.asYears        = asYears;
    proto$2.valueOf        = valueOf$1;
    proto$2._bubble        = bubble;
    proto$2.clone          = clone$1;
    proto$2.get            = get$2;
    proto$2.milliseconds   = milliseconds;
    proto$2.seconds        = seconds;
    proto$2.minutes        = minutes;
    proto$2.hours          = hours;
    proto$2.days           = days;
    proto$2.weeks          = weeks;
    proto$2.months         = months;
    proto$2.years          = years;
    proto$2.humanize       = humanize;
    proto$2.toISOString    = toISOString$1;
    proto$2.toString       = toISOString$1;
    proto$2.toJSON         = toISOString$1;
    proto$2.locale         = locale;
    proto$2.localeData     = localeData;

    proto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);
    proto$2.lang = lang;

    // Side effect imports

    // FORMATTING

    addFormatToken('X', 0, 0, 'unix');
    addFormatToken('x', 0, 0, 'valueOf');

    // PARSING

    addRegexToken('x', matchSigned);
    addRegexToken('X', matchTimestamp);
    addParseToken('X', function (input, array, config) {
        config._d = new Date(parseFloat(input, 10) * 1000);
    });
    addParseToken('x', function (input, array, config) {
        config._d = new Date(toInt(input));
    });

    // Side effect imports


    hooks.version = '2.22.2';

    setHookCallback(createLocal);

    hooks.fn                    = proto;
    hooks.min                   = min;
    hooks.max                   = max;
    hooks.now                   = now;
    hooks.utc                   = createUTC;
    hooks.unix                  = createUnix;
    hooks.months                = listMonths;
    hooks.isDate                = isDate;
    hooks.locale                = getSetGlobalLocale;
    hooks.invalid               = createInvalid;
    hooks.duration              = createDuration;
    hooks.isMoment              = isMoment;
    hooks.weekdays              = listWeekdays;
    hooks.parseZone             = createInZone;
    hooks.localeData            = getLocale;
    hooks.isDuration            = isDuration;
    hooks.monthsShort           = listMonthsShort;
    hooks.weekdaysMin           = listWeekdaysMin;
    hooks.defineLocale          = defineLocale;
    hooks.updateLocale          = updateLocale;
    hooks.locales               = listLocales;
    hooks.weekdaysShort         = listWeekdaysShort;
    hooks.normalizeUnits        = normalizeUnits;
    hooks.relativeTimeRounding  = getSetRelativeTimeRounding;
    hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
    hooks.calendarFormat        = getCalendarFormat;
    hooks.prototype             = proto;

    // currently HTML5 input type only supports 24-hour formats
    hooks.HTML5_FMT = {
        DATETIME_LOCAL: 'YYYY-MM-DDTHH:mm',             // <input type="datetime-local" />
        DATETIME_LOCAL_SECONDS: 'YYYY-MM-DDTHH:mm:ss',  // <input type="datetime-local" step="1" />
        DATETIME_LOCAL_MS: 'YYYY-MM-DDTHH:mm:ss.SSS',   // <input type="datetime-local" step="0.001" />
        DATE: 'YYYY-MM-DD',                             // <input type="date" />
        TIME: 'HH:mm',                                  // <input type="time" />
        TIME_SECONDS: 'HH:mm:ss',                       // <input type="time" step="1" />
        TIME_MS: 'HH:mm:ss.SSS',                        // <input type="time" step="0.001" />
        WEEK: 'YYYY-[W]WW',                             // <input type="week" />
        MONTH: 'YYYY-MM'                                // <input type="month" />
    };

    return hooks;

})));

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(117)(module)))

/***/ }),
/* 117 */
/***/ (function(module, exports) {

module.exports = function(module) {
	if(!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if(!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),
/* 118 */
/***/ (function(module, exports) {

function webpackEmptyContext(req) {
	throw new Error("Cannot find module '" + req + "'.");
}
webpackEmptyContext.keys = function() { return []; };
webpackEmptyContext.resolve = webpackEmptyContext;
module.exports = webpackEmptyContext;
webpackEmptyContext.id = 118;

/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

/* eslint-disable require-jsdoc */

var _rng;

var globalVar = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : null;

if (globalVar && globalVar.crypto && crypto.getRandomValues) {
  // WHATWG crypto-based RNG - http://wiki.whatwg.org/wiki/Crypto
  // Moderately fast, high quality
  var _rnds8 = new Uint8Array(16);
  _rng = function whatwgRNG() {
    crypto.getRandomValues(_rnds8);
    return _rnds8;
  };
}

if (!_rng) {
  // Math.random()-based (RNG)
  //
  // If all else fails, use Math.random().  It's fast, but is of unspecified
  // quality.
  var _rnds = new Array(16);
  _rng = function _rng() {
    for (var i = 0, r; i < 16; i++) {
      if ((i & 0x03) === 0) r = Math.random() * 0x100000000;
      _rnds[i] = r >>> ((i & 0x03) << 3) & 0xff;
    }

    return _rnds;
  };
}

//     uuid.js
//
//     Copyright (c) 2010-2012 Robert Kieffer
//     MIT License - http://opensource.org/licenses/mit-license.php

// Unique ID creation requires a high quality random # generator.  We feature
// detect to determine the best RNG source, normalizing to a function that
// returns 128-bits of randomness, since that's what's usually required

//var _rng = require('./rng');

// Maps for number <-> hex string conversion
var _byteToHex = [];
var _hexToByte = {};
for (var i = 0; i < 256; i++) {
  _byteToHex[i] = (i + 0x100).toString(16).substr(1);
  _hexToByte[_byteToHex[i]] = i;
}

// **`parse()` - Parse a UUID into it's component bytes**
function parse(s, buf, offset) {
  var i = buf && offset || 0,
      ii = 0;

  buf = buf || [];
  s.toLowerCase().replace(/[0-9a-f]{2}/g, function (oct) {
    if (ii < 16) {
      // Don't overflow!
      buf[i + ii++] = _hexToByte[oct];
    }
  });

  // Zero out remaining bytes if string was short
  while (ii < 16) {
    buf[i + ii++] = 0;
  }

  return buf;
}

// **`unparse()` - Convert UUID byte array (ala parse()) into a string**
function unparse(buf, offset) {
  var i = offset || 0,
      bth = _byteToHex;
  return bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]];
}

// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html

// random #'s we need to init node and clockseq
var _seedBytes = _rng();

// Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
var _nodeId = [_seedBytes[0] | 0x01, _seedBytes[1], _seedBytes[2], _seedBytes[3], _seedBytes[4], _seedBytes[5]];

// Per 4.2.2, randomize (14 bit) clockseq
var _clockseq = (_seedBytes[6] << 8 | _seedBytes[7]) & 0x3fff;

// Previous uuid creation time
var _lastMSecs = 0,
    _lastNSecs = 0;

// See https://github.com/broofa/node-uuid for API details
function v1(options, buf, offset) {
  var i = buf && offset || 0;
  var b = buf || [];

  options = options || {};

  var clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq;

  // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.
  var msecs = options.msecs !== undefined ? options.msecs : new Date().getTime();

  // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock
  var nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1;

  // Time since last uuid creation (in msecs)
  var dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000;

  // Per 4.2.1.2, Bump clockseq on clock regression
  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  }

  // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval
  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  }

  // Per 4.2.1.2 Throw error if too many uuids are requested
  if (nsecs >= 10000) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq;

  // Per 4.1.4 - Convert from unix epoch to Gregorian epoch
  msecs += 12219292800000;

  // `time_low`
  var tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff;

  // `time_mid`
  var tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff;

  // `time_high_and_version`
  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version
  b[i++] = tmh >>> 16 & 0xff;

  // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)
  b[i++] = clockseq >>> 8 | 0x80;

  // `clock_seq_low`
  b[i++] = clockseq & 0xff;

  // `node`
  var node = options.node || _nodeId;
  for (var n = 0; n < 6; n++) {
    b[i + n] = node[n];
  }

  return buf ? buf : unparse(b);
}

// **`v4()` - Generate random UUID**

// See https://github.com/broofa/node-uuid for API details
function v4(options, buf, offset) {
  // Deprecated - 'format' argument, as supported in v1.2
  var i = buf && offset || 0;

  if (typeof options == 'string') {
    buf = options == 'binary' ? new Array(16) : null;
    options = null;
  }
  options = options || {};

  var rnds = options.random || (options.rng || _rng)();

  // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`
  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80;

  // Copy bytes to buffer, if provided
  if (buf) {
    for (var ii = 0; ii < 16; ii++) {
      buf[i + ii] = rnds[ii];
    }
  }

  return buf || unparse(rnds);
}

// Export public API
var uuid = v4;
uuid.v1 = v1;
uuid.v4 = v4;
uuid.parse = parse;
uuid.unparse = unparse;

module.exports = uuid;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(120)))

/***/ }),
/* 120 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// utils
exports.util = __webpack_require__(2);
exports.DOMutil = __webpack_require__(122);

// data
exports.DataSet = __webpack_require__(33);
exports.DataView = __webpack_require__(51);
exports.Queue = __webpack_require__(72);

// Network
exports.Network = __webpack_require__(124);
exports.network = {
  Images: __webpack_require__(76),
  dotparser: __webpack_require__(74),
  gephiParser: __webpack_require__(75),
  allOptions: __webpack_require__(84)
};
exports.network.convertDot = function (input) {
  return exports.network.dotparser.DOTToGraph(input);
};
exports.network.convertGephi = function (input, options) {
  return exports.network.gephiParser.parseGephi(input, options);
};

// bundled external libraries
exports.moment = __webpack_require__(71);
exports.Hammer = __webpack_require__(24);
exports.keycharm = __webpack_require__(52);

/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// DOM utility methods

/**
 * this prepares the JSON container for allocating SVG elements
 * @param {Object} JSONcontainer
 * @private
 */
exports.prepareElements = function (JSONcontainer) {
  // cleanup the redundant svgElements;
  for (var elementType in JSONcontainer) {
    if (JSONcontainer.hasOwnProperty(elementType)) {
      JSONcontainer[elementType].redundant = JSONcontainer[elementType].used;
      JSONcontainer[elementType].used = [];
    }
  }
};

/**
 * this cleans up all the unused SVG elements. By asking for the parentNode, we only need to supply the JSON container from
 * which to remove the redundant elements.
 *
 * @param {Object} JSONcontainer
 * @private
 */
exports.cleanupElements = function (JSONcontainer) {
  // cleanup the redundant svgElements;
  for (var elementType in JSONcontainer) {
    if (JSONcontainer.hasOwnProperty(elementType)) {
      if (JSONcontainer[elementType].redundant) {
        for (var i = 0; i < JSONcontainer[elementType].redundant.length; i++) {
          JSONcontainer[elementType].redundant[i].parentNode.removeChild(JSONcontainer[elementType].redundant[i]);
        }
        JSONcontainer[elementType].redundant = [];
      }
    }
  }
};

/**
 * Ensures that all elements are removed first up so they can be recreated cleanly
 * @param {Object} JSONcontainer
 */
exports.resetElements = function (JSONcontainer) {
  exports.prepareElements(JSONcontainer);
  exports.cleanupElements(JSONcontainer);
  exports.prepareElements(JSONcontainer);
};

/**
 * Allocate or generate an SVG element if needed. Store a reference to it in the JSON container and draw it in the svgContainer
 * the JSON container and the SVG container have to be supplied so other svg containers (like the legend) can use this.
 *
 * @param {string} elementType
 * @param {Object} JSONcontainer
 * @param {Object} svgContainer
 * @returns {Element}
 * @private
 */
exports.getSVGElement = function (elementType, JSONcontainer, svgContainer) {
  var element;
  // allocate SVG element, if it doesnt yet exist, create one.
  if (JSONcontainer.hasOwnProperty(elementType)) {
    // this element has been created before
    // check if there is an redundant element
    if (JSONcontainer[elementType].redundant.length > 0) {
      element = JSONcontainer[elementType].redundant[0];
      JSONcontainer[elementType].redundant.shift();
    } else {
      // create a new element and add it to the SVG
      element = document.createElementNS('http://www.w3.org/2000/svg', elementType);
      svgContainer.appendChild(element);
    }
  } else {
    // create a new element and add it to the SVG, also create a new object in the svgElements to keep track of it.
    element = document.createElementNS('http://www.w3.org/2000/svg', elementType);
    JSONcontainer[elementType] = { used: [], redundant: [] };
    svgContainer.appendChild(element);
  }
  JSONcontainer[elementType].used.push(element);
  return element;
};

/**
 * Allocate or generate an SVG element if needed. Store a reference to it in the JSON container and draw it in the svgContainer
 * the JSON container and the SVG container have to be supplied so other svg containers (like the legend) can use this.
 *
 * @param {string} elementType
 * @param {Object} JSONcontainer
 * @param {Element} DOMContainer
 * @param {Element} insertBefore
 * @returns {*}
 */
exports.getDOMElement = function (elementType, JSONcontainer, DOMContainer, insertBefore) {
  var element;
  // allocate DOM element, if it doesnt yet exist, create one.
  if (JSONcontainer.hasOwnProperty(elementType)) {
    // this element has been created before
    // check if there is an redundant element
    if (JSONcontainer[elementType].redundant.length > 0) {
      element = JSONcontainer[elementType].redundant[0];
      JSONcontainer[elementType].redundant.shift();
    } else {
      // create a new element and add it to the SVG
      element = document.createElement(elementType);
      if (insertBefore !== undefined) {
        DOMContainer.insertBefore(element, insertBefore);
      } else {
        DOMContainer.appendChild(element);
      }
    }
  } else {
    // create a new element and add it to the SVG, also create a new object in the svgElements to keep track of it.
    element = document.createElement(elementType);
    JSONcontainer[elementType] = { used: [], redundant: [] };
    if (insertBefore !== undefined) {
      DOMContainer.insertBefore(element, insertBefore);
    } else {
      DOMContainer.appendChild(element);
    }
  }
  JSONcontainer[elementType].used.push(element);
  return element;
};

/**
 * Draw a point object. This is a separate function because it can also be called by the legend.
 * The reason the JSONcontainer and the target SVG svgContainer have to be supplied is so the legend can use these functions
 * as well.
 *
 * @param {number} x
 * @param {number} y
 * @param {Object} groupTemplate: A template containing the necessary information to draw the datapoint e.g., {style: 'circle', size: 5, className: 'className' }
 * @param {Object} JSONcontainer
 * @param {Object} svgContainer
 * @param {Object} labelObj
 * @returns {vis.PointItem}
 */
exports.drawPoint = function (x, y, groupTemplate, JSONcontainer, svgContainer, labelObj) {
  var point;
  if (groupTemplate.style == 'circle') {
    point = exports.getSVGElement('circle', JSONcontainer, svgContainer);
    point.setAttributeNS(null, 'cx', x);
    point.setAttributeNS(null, 'cy', y);
    point.setAttributeNS(null, 'r', 0.5 * groupTemplate.size);
  } else {
    point = exports.getSVGElement('rect', JSONcontainer, svgContainer);
    point.setAttributeNS(null, 'x', x - 0.5 * groupTemplate.size);
    point.setAttributeNS(null, 'y', y - 0.5 * groupTemplate.size);
    point.setAttributeNS(null, 'width', groupTemplate.size);
    point.setAttributeNS(null, 'height', groupTemplate.size);
  }

  if (groupTemplate.styles !== undefined) {
    point.setAttributeNS(null, 'style', groupTemplate.styles);
  }
  point.setAttributeNS(null, 'class', groupTemplate.className + ' vis-point');
  //handle label

  if (labelObj) {
    var label = exports.getSVGElement('text', JSONcontainer, svgContainer);
    if (labelObj.xOffset) {
      x = x + labelObj.xOffset;
    }

    if (labelObj.yOffset) {
      y = y + labelObj.yOffset;
    }
    if (labelObj.content) {
      label.textContent = labelObj.content;
    }

    if (labelObj.className) {
      label.setAttributeNS(null, 'class', labelObj.className + ' vis-label');
    }
    label.setAttributeNS(null, 'x', x);
    label.setAttributeNS(null, 'y', y);
  }

  return point;
};

/**
 * draw a bar SVG element centered on the X coordinate
 *
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {string} className
 * @param {Object} JSONcontainer
 * @param {Object} svgContainer
 * @param {string} style
 */
exports.drawBar = function (x, y, width, height, className, JSONcontainer, svgContainer, style) {
  if (height != 0) {
    if (height < 0) {
      height *= -1;
      y -= height;
    }
    var rect = exports.getSVGElement('rect', JSONcontainer, svgContainer);
    rect.setAttributeNS(null, 'x', x - 0.5 * width);
    rect.setAttributeNS(null, 'y', y);
    rect.setAttributeNS(null, 'width', width);
    rect.setAttributeNS(null, 'height', height);
    rect.setAttributeNS(null, 'class', className);
    if (style) {
      rect.setAttributeNS(null, 'style', style);
    }
  }
};

/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

var core = __webpack_require__(6);
var $JSON = core.JSON || (core.JSON = { stringify: JSON.stringify });
module.exports = function stringify(it) { // eslint-disable-line no-unused-vars
  return $JSON.stringify.apply($JSON, arguments);
};


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Load custom shapes into CanvasRenderingContext2D
__webpack_require__(125);

var Emitter = __webpack_require__(73);
var util = __webpack_require__(2);
var dotparser = __webpack_require__(74);
var gephiParser = __webpack_require__(75);
var Activator = __webpack_require__(126);
var locales = __webpack_require__(129);

var Images = __webpack_require__(76)['default'];
var Groups = __webpack_require__(134)['default'];
var NodesHandler = __webpack_require__(135)['default'];
var EdgesHandler = __webpack_require__(165)['default'];
var PhysicsEngine = __webpack_require__(171)['default'];
var ClusterEngine = __webpack_require__(178)['default'];
var CanvasRenderer = __webpack_require__(180)['default'];
var Canvas = __webpack_require__(181)['default'];
var View = __webpack_require__(182)['default'];
var InteractionHandler = __webpack_require__(183)['default'];
var SelectionHandler = __webpack_require__(186)['default'];
var LayoutEngine = __webpack_require__(187)['default'];
var ManipulationSystem = __webpack_require__(190)['default'];
var Configurator = __webpack_require__(191)['default'];
var Validator = __webpack_require__(54)['default'];

var _require = __webpack_require__(54),
    printStyle = _require.printStyle;

var _require2 = __webpack_require__(84),
    allOptions = _require2.allOptions,
    configureOptions = _require2.configureOptions;

var KamadaKawai = __webpack_require__(193)['default'];

/**
 * Create a network visualization, displaying nodes and edges.
 *
 * @param {Element} container   The DOM element in which the Network will
 *                                  be created. Normally a div element.
 * @param {Object} data         An object containing parameters
 *                              {Array} nodes
 *                              {Array} edges
 * @param {Object} options      Options
 * @constructor Network
 */
function Network(container, data, options) {
  var _this = this;

  if (!(this instanceof Network)) {
    throw new SyntaxError('Constructor must be called with the new operator');
  }

  // set constant values
  this.options = {};
  this.defaultOptions = {
    locale: 'en',
    locales: locales,
    clickToUse: false
  };
  util.extend(this.options, this.defaultOptions);

  /**
   * Containers for nodes and edges.
   *
   * 'edges' and 'nodes' contain the full definitions of all the network elements.
   * 'nodeIndices' and 'edgeIndices' contain the id's of the active elements.
   *
   * The distinction is important, because a defined node need not be active, i.e.
   * visible on the canvas. This happens in particular when clusters are defined, in
   * that case there will be nodes and edges not displayed.
   * The bottom line is that all code with actions related to visibility, *must* use
   * 'nodeIndices' and 'edgeIndices', not 'nodes' and 'edges' directly.
   */
  this.body = {
    container: container,

    // See comment above for following fields
    nodes: {},
    nodeIndices: [],
    edges: {},
    edgeIndices: [],

    emitter: {
      on: this.on.bind(this),
      off: this.off.bind(this),
      emit: this.emit.bind(this),
      once: this.once.bind(this)
    },
    eventListeners: {
      onTap: function onTap() {},
      onTouch: function onTouch() {},
      onDoubleTap: function onDoubleTap() {},
      onHold: function onHold() {},
      onDragStart: function onDragStart() {},
      onDrag: function onDrag() {},
      onDragEnd: function onDragEnd() {},
      onMouseWheel: function onMouseWheel() {},
      onPinch: function onPinch() {},
      onMouseMove: function onMouseMove() {},
      onRelease: function onRelease() {},
      onContext: function onContext() {}
    },
    data: {
      nodes: null, // A DataSet or DataView
      edges: null // A DataSet or DataView
    },
    functions: {
      createNode: function createNode() {},
      createEdge: function createEdge() {},
      getPointer: function getPointer() {}
    },
    modules: {},
    view: {
      scale: 1,
      translation: { x: 0, y: 0 }
    }

    // bind the event listeners
  };this.bindEventListeners();

  // setting up all modules
  this.images = new Images(function () {
    return _this.body.emitter.emit('_requestRedraw');
  }); // object with images
  this.groups = new Groups(); // object with groups
  this.canvas = new Canvas(this.body); // DOM handler
  this.selectionHandler = new SelectionHandler(this.body, this.canvas); // Selection handler
  this.interactionHandler = new InteractionHandler(this.body, this.canvas, this.selectionHandler); // Interaction handler handles all the hammer bindings (that are bound by canvas), key
  this.view = new View(this.body, this.canvas); // camera handler, does animations and zooms
  this.renderer = new CanvasRenderer(this.body, this.canvas); // renderer, starts renderloop, has events that modules can hook into
  this.physics = new PhysicsEngine(this.body); // physics engine, does all the simulations
  this.layoutEngine = new LayoutEngine(this.body); // layout engine for inital layout and hierarchical layout
  this.clustering = new ClusterEngine(this.body); // clustering api
  this.manipulation = new ManipulationSystem(this.body, this.canvas, this.selectionHandler); // data manipulation system

  this.nodesHandler = new NodesHandler(this.body, this.images, this.groups, this.layoutEngine); // Handle adding, deleting and updating of nodes as well as global options
  this.edgesHandler = new EdgesHandler(this.body, this.images, this.groups); // Handle adding, deleting and updating of edges as well as global options

  this.body.modules['kamadaKawai'] = new KamadaKawai(this.body, 150, 0.05); // Layouting algorithm.
  this.body.modules['clustering'] = this.clustering;

  // create the DOM elements
  this.canvas._create();

  // apply options
  this.setOptions(options);

  // load data (the disable start variable will be the same as the enabled clustering)
  this.setData(data);
}

// Extend Network with an Emitter mixin
Emitter(Network.prototype);

/**
 * Set options
 * @param {Object} options
 */
Network.prototype.setOptions = function (options) {
  var _this2 = this;

  if (options === null) {
    options = undefined; // This ensures that options handling doesn't crash in the handling
  }

  if (options !== undefined) {
    var errorFound = Validator.validate(options, allOptions);
    if (errorFound === true) {
      console.log('%cErrors have been found in the supplied options object.', printStyle);
    }

    // copy the global fields over
    var fields = ['locale', 'locales', 'clickToUse'];
    util.selectiveDeepExtend(fields, this.options, options);

    // the hierarchical system can adapt the edges and the physics to it's own options because not all combinations work with the hierarichical system.
    options = this.layoutEngine.setOptions(options.layout, options);

    this.canvas.setOptions(options); // options for canvas are in globals

    // pass the options to the modules
    this.groups.setOptions(options.groups);
    this.nodesHandler.setOptions(options.nodes);
    this.edgesHandler.setOptions(options.edges);
    this.physics.setOptions(options.physics);
    this.manipulation.setOptions(options.manipulation, options, this.options); // manipulation uses the locales in the globals

    this.interactionHandler.setOptions(options.interaction);
    this.renderer.setOptions(options.interaction); // options for rendering are in interaction
    this.selectionHandler.setOptions(options.interaction); // options for selection are in interaction

    // reload the settings of the nodes to apply changes in groups that are not referenced by pointer.
    if (options.groups !== undefined) {
      this.body.emitter.emit('refreshNodes');
    }
    // these two do not have options at the moment, here for completeness
    //this.view.setOptions(options.view);
    //this.clustering.setOptions(options.clustering);

    if ('configure' in options) {
      if (!this.configurator) {
        this.configurator = new Configurator(this, this.body.container, configureOptions, this.canvas.pixelRatio);
      }

      this.configurator.setOptions(options.configure);
    }

    // if the configuration system is enabled, copy all options and put them into the config system
    if (this.configurator && this.configurator.options.enabled === true) {
      var networkOptions = {
        nodes: {},
        edges: {},
        layout: {},
        interaction: {},
        manipulation: {},
        physics: {},
        global: {}
      };
      util.deepExtend(networkOptions.nodes, this.nodesHandler.options);
      util.deepExtend(networkOptions.edges, this.edgesHandler.options);
      util.deepExtend(networkOptions.layout, this.layoutEngine.options);
      // load the selectionHandler and render default options in to the interaction group
      util.deepExtend(networkOptions.interaction, this.selectionHandler.options);
      util.deepExtend(networkOptions.interaction, this.renderer.options);

      util.deepExtend(networkOptions.interaction, this.interactionHandler.options);
      util.deepExtend(networkOptions.manipulation, this.manipulation.options);
      util.deepExtend(networkOptions.physics, this.physics.options);

      // load globals into the global object
      util.deepExtend(networkOptions.global, this.canvas.options);
      util.deepExtend(networkOptions.global, this.options);

      this.configurator.setModuleOptions(networkOptions);
    }

    // handle network global options
    if (options.clickToUse !== undefined) {
      if (options.clickToUse === true) {
        if (this.activator === undefined) {
          this.activator = new Activator(this.canvas.frame);
          this.activator.on('change', function () {
            _this2.body.emitter.emit('activate');
          });
        }
      } else {
        if (this.activator !== undefined) {
          this.activator.destroy();
          delete this.activator;
        }
        this.body.emitter.emit('activate');
      }
    } else {
      this.body.emitter.emit('activate');
    }

    this.canvas.setSize();
    // start the physics simulation. Can be safely called multiple times.
    this.body.emitter.emit('startSimulation');
  }
};

/**
 * Update the visible nodes and edges list with the most recent node state.
 *
 * Visible nodes are stored in this.body.nodeIndices.
 * Visible edges are stored in this.body.edgeIndices.
 * A node or edges is visible if it is not hidden or clustered.
 *
 * @private
 */
Network.prototype._updateVisibleIndices = function () {
  var nodes = this.body.nodes;
  var edges = this.body.edges;
  this.body.nodeIndices = [];
  this.body.edgeIndices = [];

  for (var nodeId in nodes) {
    if (nodes.hasOwnProperty(nodeId)) {
      if (!this.clustering._isClusteredNode(nodeId) && nodes[nodeId].options.hidden === false) {
        this.body.nodeIndices.push(nodes[nodeId].id);
      }
    }
  }

  for (var edgeId in edges) {
    if (edges.hasOwnProperty(edgeId)) {
      var edge = edges[edgeId];

      // It can happen that this is executed *after* a node edge has been removed,
      // but *before* the edge itself has been removed. Taking this into account.
      var fromNode = nodes[edge.fromId];
      var toNode = nodes[edge.toId];
      var edgeNodesPresent = fromNode !== undefined && toNode !== undefined;

      var isVisible = !this.clustering._isClusteredEdge(edgeId) && edge.options.hidden === false && edgeNodesPresent && fromNode.options.hidden === false && // Also hidden if any of its connecting nodes are hidden
      toNode.options.hidden === false; // idem

      if (isVisible) {
        this.body.edgeIndices.push(edge.id);
      }
    }
  }
};

/**
 * Bind all events
 */
Network.prototype.bindEventListeners = function () {
  var _this3 = this;

  // This event will trigger a rebuilding of the cache everything.
  // Used when nodes or edges have been added or removed.
  this.body.emitter.on('_dataChanged', function () {
    _this3.edgesHandler._updateState();
    _this3.body.emitter.emit('_dataUpdated');
  });

  // this is called when options of EXISTING nodes or edges have changed.
  this.body.emitter.on('_dataUpdated', function () {
    // Order important in following block
    _this3.clustering._updateState();
    _this3._updateVisibleIndices();

    _this3._updateValueRange(_this3.body.nodes);
    _this3._updateValueRange(_this3.body.edges);
    // start simulation (can be called safely, even if already running)
    _this3.body.emitter.emit('startSimulation');
    _this3.body.emitter.emit('_requestRedraw');
  });
};

/**
 * Set nodes and edges, and optionally options as well.
 *
 * @param {Object} data              Object containing parameters:
 *                                   {Array | DataSet | DataView} [nodes] Array with nodes
 *                                   {Array | DataSet | DataView} [edges] Array with edges
 *                                   {String} [dot] String containing data in DOT format
 *                                   {String} [gephi] String containing data in gephi JSON format
 *                                   {Options} [options] Object with options
 */
Network.prototype.setData = function (data) {
  // reset the physics engine.
  this.body.emitter.emit('resetPhysics');
  this.body.emitter.emit('_resetData');

  // unselect all to ensure no selections from old data are carried over.
  this.selectionHandler.unselectAll();

  if (data && data.dot && (data.nodes || data.edges)) {
    throw new SyntaxError('Data must contain either parameter "dot" or ' + ' parameter pair "nodes" and "edges", but not both.');
  }

  // set options
  this.setOptions(data && data.options);
  // set all data
  if (data && data.dot) {
    console.log('The dot property has been deprecated. Please use the static convertDot method to convert DOT into vis.network format and use the normal data format with nodes and edges. This converter is used like this: var data = vis.network.convertDot(dotString);');
    // parse DOT file
    var dotData = dotparser.DOTToGraph(data.dot);
    this.setData(dotData);
    return;
  } else if (data && data.gephi) {
    // parse DOT file
    console.log('The gephi property has been deprecated. Please use the static convertGephi method to convert gephi into vis.network format and use the normal data format with nodes and edges. This converter is used like this: var data = vis.network.convertGephi(gephiJson);');
    var gephiData = gephiParser.parseGephi(data.gephi);
    this.setData(gephiData);
    return;
  } else {
    this.nodesHandler.setData(data && data.nodes, true);
    this.edgesHandler.setData(data && data.edges, true);
  }

  // emit change in data
  this.body.emitter.emit('_dataChanged');

  // emit data loaded
  this.body.emitter.emit('_dataLoaded');

  // find a stable position or start animating to a stable position
  this.body.emitter.emit('initPhysics');
};

/**
 * Cleans up all bindings of the network, removing it fully from the memory IF the variable is set to null after calling this function.
 * var network = new vis.Network(..);
 * network.destroy();
 * network = null;
 */
Network.prototype.destroy = function () {
  this.body.emitter.emit('destroy');
  // clear events
  this.body.emitter.off();
  this.off();

  // delete modules
  delete this.groups;
  delete this.canvas;
  delete this.selectionHandler;
  delete this.interactionHandler;
  delete this.view;
  delete this.renderer;
  delete this.physics;
  delete this.layoutEngine;
  delete this.clustering;
  delete this.manipulation;
  delete this.nodesHandler;
  delete this.edgesHandler;
  delete this.configurator;
  delete this.images;

  for (var nodeId in this.body.nodes) {
    if (!this.body.nodes.hasOwnProperty(nodeId)) continue;
    delete this.body.nodes[nodeId];
  }

  for (var edgeId in this.body.edges) {
    if (!this.body.edges.hasOwnProperty(edgeId)) continue;
    delete this.body.edges[edgeId];
  }

  // remove the container and everything inside it recursively
  util.recursiveDOMDelete(this.body.container);
};

/**
 * Update the values of all object in the given array according to the current
 * value range of the objects in the array.
 * @param {Object} obj    An object containing a set of Edges or Nodes
 *                        The objects must have a method getValue() and
 *                        setValueRange(min, max).
 * @private
 */
Network.prototype._updateValueRange = function (obj) {
  var id;

  // determine the range of the objects
  var valueMin = undefined;
  var valueMax = undefined;
  var valueTotal = 0;
  for (id in obj) {
    if (obj.hasOwnProperty(id)) {
      var value = obj[id].getValue();
      if (value !== undefined) {
        valueMin = valueMin === undefined ? value : Math.min(value, valueMin);
        valueMax = valueMax === undefined ? value : Math.max(value, valueMax);
        valueTotal += value;
      }
    }
  }

  // adjust the range of all objects
  if (valueMin !== undefined && valueMax !== undefined) {
    for (id in obj) {
      if (obj.hasOwnProperty(id)) {
        obj[id].setValueRange(valueMin, valueMax, valueTotal);
      }
    }
  }
};

/**
 * Returns true when the Network is active.
 * @returns {boolean}
 */
Network.prototype.isActive = function () {
  return !this.activator || this.activator.active;
};

Network.prototype.setSize = function () {
  return this.canvas.setSize.apply(this.canvas, arguments);
};
Network.prototype.canvasToDOM = function () {
  return this.canvas.canvasToDOM.apply(this.canvas, arguments);
};
Network.prototype.DOMtoCanvas = function () {
  return this.canvas.DOMtoCanvas.apply(this.canvas, arguments);
};

/**
 * Nodes can be in clusters. Clusters can also be in clusters. This function returns and array of
 * nodeIds showing where the node is.
 *
 * If any nodeId in the chain, especially the first passed in as a parameter, is not present in
 * the current nodes list, an empty array is returned.
 *
 * Example:
 * cluster 'A' contains cluster 'B',
 * cluster 'B' contains cluster 'C',
 * cluster 'C' contains node 'fred'.
 * `jsnetwork.clustering.findNode('fred')` will return `['A','B','C','fred']`.
 *
 * @param {string|number} nodeId
 * @returns {Array}
 */
Network.prototype.findNode = function () {
  return this.clustering.findNode.apply(this.clustering, arguments);
};

Network.prototype.isCluster = function () {
  return this.clustering.isCluster.apply(this.clustering, arguments);
};
Network.prototype.openCluster = function () {
  return this.clustering.openCluster.apply(this.clustering, arguments);
};
Network.prototype.cluster = function () {
  return this.clustering.cluster.apply(this.clustering, arguments);
};
Network.prototype.getNodesInCluster = function () {
  return this.clustering.getNodesInCluster.apply(this.clustering, arguments);
};
Network.prototype.clusterByConnection = function () {
  return this.clustering.clusterByConnection.apply(this.clustering, arguments);
};
Network.prototype.clusterByHubsize = function () {
  return this.clustering.clusterByHubsize.apply(this.clustering, arguments);
};

/**
 * This method will cluster all nodes with 1 edge with their respective connected node.
 * The options object is explained in full <a data-scroll="" data-options="{ &quot;easing&quot;: &quot;easeInCubic&quot; }" href="#optionsObject">below</a>.
 *
 * @param {object} [options]
 * @returns {undefined}
 */
Network.prototype.clusterOutliers = function () {
  return this.clustering.clusterOutliers.apply(this.clustering, arguments);
};

Network.prototype.getSeed = function () {
  return this.layoutEngine.getSeed.apply(this.layoutEngine, arguments);
};
Network.prototype.enableEditMode = function () {
  return this.manipulation.enableEditMode.apply(this.manipulation, arguments);
};
Network.prototype.disableEditMode = function () {
  return this.manipulation.disableEditMode.apply(this.manipulation, arguments);
};
Network.prototype.addNodeMode = function () {
  return this.manipulation.addNodeMode.apply(this.manipulation, arguments);
};
Network.prototype.editNode = function () {
  return this.manipulation.editNode.apply(this.manipulation, arguments);
};
Network.prototype.editNodeMode = function () {
  console.log('Deprecated: Please use editNode instead of editNodeMode.');
  return this.manipulation.editNode.apply(this.manipulation, arguments);
};
Network.prototype.addEdgeMode = function () {
  return this.manipulation.addEdgeMode.apply(this.manipulation, arguments);
};
Network.prototype.editEdgeMode = function () {
  return this.manipulation.editEdgeMode.apply(this.manipulation, arguments);
};
Network.prototype.deleteSelected = function () {
  return this.manipulation.deleteSelected.apply(this.manipulation, arguments);
};
Network.prototype.getPositions = function () {
  return this.nodesHandler.getPositions.apply(this.nodesHandler, arguments);
};
Network.prototype.storePositions = function () {
  return this.nodesHandler.storePositions.apply(this.nodesHandler, arguments);
};
Network.prototype.moveNode = function () {
  return this.nodesHandler.moveNode.apply(this.nodesHandler, arguments);
};
Network.prototype.getBoundingBox = function () {
  return this.nodesHandler.getBoundingBox.apply(this.nodesHandler, arguments);
};
Network.prototype.getConnectedNodes = function (objectId) {
  if (this.body.nodes[objectId] !== undefined) {
    return this.nodesHandler.getConnectedNodes.apply(this.nodesHandler, arguments);
  } else {
    return this.edgesHandler.getConnectedNodes.apply(this.edgesHandler, arguments);
  }
};
Network.prototype.getConnectedEdges = function () {
  return this.nodesHandler.getConnectedEdges.apply(this.nodesHandler, arguments);
};
Network.prototype.startSimulation = function () {
  return this.physics.startSimulation.apply(this.physics, arguments);
};
Network.prototype.stopSimulation = function () {
  return this.physics.stopSimulation.apply(this.physics, arguments);
};
Network.prototype.stabilize = function () {
  return this.physics.stabilize.apply(this.physics, arguments);
};
Network.prototype.getSelection = function () {
  return this.selectionHandler.getSelection.apply(this.selectionHandler, arguments);
};
Network.prototype.setSelection = function () {
  return this.selectionHandler.setSelection.apply(this.selectionHandler, arguments);
};
Network.prototype.getSelectedNodes = function () {
  return this.selectionHandler.getSelectedNodes.apply(this.selectionHandler, arguments);
};
Network.prototype.getSelectedEdges = function () {
  return this.selectionHandler.getSelectedEdges.apply(this.selectionHandler, arguments);
};
Network.prototype.getNodeAt = function () {
  var node = this.selectionHandler.getNodeAt.apply(this.selectionHandler, arguments);
  if (node !== undefined && node.id !== undefined) {
    return node.id;
  }
  return node;
};
Network.prototype.getEdgeAt = function () {
  var edge = this.selectionHandler.getEdgeAt.apply(this.selectionHandler, arguments);
  if (edge !== undefined && edge.id !== undefined) {
    return edge.id;
  }
  return edge;
};
Network.prototype.selectNodes = function () {
  return this.selectionHandler.selectNodes.apply(this.selectionHandler, arguments);
};
Network.prototype.selectEdges = function () {
  return this.selectionHandler.selectEdges.apply(this.selectionHandler, arguments);
};
Network.prototype.unselectAll = function () {
  this.selectionHandler.unselectAll.apply(this.selectionHandler, arguments);
  this.redraw();
};
Network.prototype.redraw = function () {
  return this.renderer.redraw.apply(this.renderer, arguments);
};
Network.prototype.getScale = function () {
  return this.view.getScale.apply(this.view, arguments);
};
Network.prototype.getViewPosition = function () {
  return this.view.getViewPosition.apply(this.view, arguments);
};
Network.prototype.fit = function () {
  return this.view.fit.apply(this.view, arguments);
};
Network.prototype.moveTo = function () {
  return this.view.moveTo.apply(this.view, arguments);
};
Network.prototype.focus = function () {
  return this.view.focus.apply(this.view, arguments);
};
Network.prototype.releaseNode = function () {
  return this.view.releaseNode.apply(this.view, arguments);
};
Network.prototype.getOptionsFromConfigurator = function () {
  var options = {};
  if (this.configurator) {
    options = this.configurator.getOptions.apply(this.configurator);
  }
  return options;
};

module.exports = Network;

/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Canvas shapes used by Network
 */
if (typeof CanvasRenderingContext2D !== 'undefined') {
  /**
   * Draw a circle shape
   *
   * @param {number} x
   * @param {number} y
   * @param {number} r
   */
  CanvasRenderingContext2D.prototype.circle = function (x, y, r) {
    this.beginPath();
    this.arc(x, y, r, 0, 2 * Math.PI, false);
    this.closePath();
  };

  /**
   * Draw a square shape
   * @param {number} x horizontal center
   * @param {number} y vertical center
   * @param {number} r   size, width and height of the square
   */
  CanvasRenderingContext2D.prototype.square = function (x, y, r) {
    this.beginPath();
    this.rect(x - r, y - r, r * 2, r * 2);
    this.closePath();
  };

  /**
   * Draw a triangle shape
   * @param {number} x horizontal center
   * @param {number} y vertical center
   * @param {number} r   radius, half the length of the sides of the triangle
   */
  CanvasRenderingContext2D.prototype.triangle = function (x, y, r) {
    // http://en.wikipedia.org/wiki/Equilateral_triangle
    this.beginPath();

    // the change in radius and the offset is here to center the shape
    r *= 1.15;
    y += 0.275 * r;

    var s = r * 2;
    var s2 = s / 2;
    var ir = Math.sqrt(3) / 6 * s; // radius of inner circle
    var h = Math.sqrt(s * s - s2 * s2); // height

    this.moveTo(x, y - (h - ir));
    this.lineTo(x + s2, y + ir);
    this.lineTo(x - s2, y + ir);
    this.lineTo(x, y - (h - ir));
    this.closePath();
  };

  /**
   * Draw a triangle shape in downward orientation
   * @param {number} x horizontal center
   * @param {number} y vertical center
   * @param {number} r radius
   */
  CanvasRenderingContext2D.prototype.triangleDown = function (x, y, r) {
    // http://en.wikipedia.org/wiki/Equilateral_triangle
    this.beginPath();

    // the change in radius and the offset is here to center the shape
    r *= 1.15;
    y -= 0.275 * r;

    var s = r * 2;
    var s2 = s / 2;
    var ir = Math.sqrt(3) / 6 * s; // radius of inner circle
    var h = Math.sqrt(s * s - s2 * s2); // height

    this.moveTo(x, y + (h - ir));
    this.lineTo(x + s2, y - ir);
    this.lineTo(x - s2, y - ir);
    this.lineTo(x, y + (h - ir));
    this.closePath();
  };

  /**
   * Draw a star shape, a star with 5 points
   * @param {number} x horizontal center
   * @param {number} y vertical center
   * @param {number} r   radius, half the length of the sides of the triangle
   */
  CanvasRenderingContext2D.prototype.star = function (x, y, r) {
    // http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
    this.beginPath();

    // the change in radius and the offset is here to center the shape
    r *= 0.82;
    y += 0.1 * r;

    for (var n = 0; n < 10; n++) {
      var radius = n % 2 === 0 ? r * 1.3 : r * 0.5;
      this.lineTo(x + radius * Math.sin(n * 2 * Math.PI / 10), y - radius * Math.cos(n * 2 * Math.PI / 10));
    }

    this.closePath();
  };

  /**
   * Draw a Diamond shape
   * @param {number} x horizontal center
   * @param {number} y vertical center
   * @param {number} r   radius, half the length of the sides of the triangle
   */
  CanvasRenderingContext2D.prototype.diamond = function (x, y, r) {
    // http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
    this.beginPath();

    this.lineTo(x, y + r);
    this.lineTo(x + r, y);
    this.lineTo(x, y - r);
    this.lineTo(x - r, y);

    this.closePath();
  };

  /**
   * http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
   *
   * @param {number} x
   * @param {number} y
   * @param {number} w
   * @param {number} h
   * @param {number} r
   */
  CanvasRenderingContext2D.prototype.roundRect = function (x, y, w, h, r) {
    var r2d = Math.PI / 180;
    if (w - 2 * r < 0) {
      r = w / 2;
    } //ensure that the radius isn't too large for x
    if (h - 2 * r < 0) {
      r = h / 2;
    } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(x + r, y);
    this.lineTo(x + w - r, y);
    this.arc(x + w - r, y + r, r, r2d * 270, r2d * 360, false);
    this.lineTo(x + w, y + h - r);
    this.arc(x + w - r, y + h - r, r, 0, r2d * 90, false);
    this.lineTo(x + r, y + h);
    this.arc(x + r, y + h - r, r, r2d * 90, r2d * 180, false);
    this.lineTo(x, y + r);
    this.arc(x + r, y + r, r, r2d * 180, r2d * 270, false);
    this.closePath();
  };

  /**
   * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
   *
   * Postfix '_vis' added to discern it from standard method ellipse().
   *
   * @param {number} x
   * @param {number} y
   * @param {number} w
   * @param {number} h
   */
  CanvasRenderingContext2D.prototype.ellipse_vis = function (x, y, w, h) {
    var kappa = 0.5522848,
        ox = w / 2 * kappa,
        // control point offset horizontal
    oy = h / 2 * kappa,
        // control point offset vertical
    xe = x + w,
        // x-end
    ye = y + h,
        // y-end
    xm = x + w / 2,
        // x-middle
    ym = y + h / 2; // y-middle

    this.beginPath();
    this.moveTo(x, ym);
    this.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
    this.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
    this.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
    this.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
    this.closePath();
  };

  /**
   * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
   *
   * @param {number} x
   * @param {number} y
   * @param {number} w
   * @param {number} h
   */
  CanvasRenderingContext2D.prototype.database = function (x, y, w, h) {
    var f = 1 / 3;
    var wEllipse = w;
    var hEllipse = h * f;

    var kappa = 0.5522848,
        ox = wEllipse / 2 * kappa,
        // control point offset horizontal
    oy = hEllipse / 2 * kappa,
        // control point offset vertical
    xe = x + wEllipse,
        // x-end
    ye = y + hEllipse,
        // y-end
    xm = x + wEllipse / 2,
        // x-middle
    ym = y + hEllipse / 2,
        // y-middle
    ymb = y + (h - hEllipse / 2),
        // y-midlle, bottom ellipse
    yeb = y + h; // y-end, bottom ellipse

    this.beginPath();
    this.moveTo(xe, ym);

    this.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
    this.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);

    this.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
    this.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);

    this.lineTo(xe, ymb);

    this.bezierCurveTo(xe, ymb + oy, xm + ox, yeb, xm, yeb);
    this.bezierCurveTo(xm - ox, yeb, x, ymb + oy, x, ymb);

    this.lineTo(x, ym);
  };

  /**
   * Sets up the dashedLine functionality for drawing
   * Original code came from http://stackoverflow.com/questions/4576724/dotted-stroke-in-canvas
   * @author David Jordan
   * @date 2012-08-08
   *
   * @param {number} x
   * @param {number} y
   * @param {number} x2
   * @param {number} y2
   * @param {string} pattern
   */
  CanvasRenderingContext2D.prototype.dashedLine = function (x, y, x2, y2, pattern) {
    this.beginPath();
    this.moveTo(x, y);

    var patternLength = pattern.length;
    var dx = x2 - x;
    var dy = y2 - y;
    var slope = dy / dx;
    var distRemaining = Math.sqrt(dx * dx + dy * dy);
    var patternIndex = 0;
    var draw = true;
    var xStep = 0;
    var dashLength = pattern[0];

    while (distRemaining >= 0.1) {
      dashLength = pattern[patternIndex++ % patternLength];
      if (dashLength > distRemaining) {
        dashLength = distRemaining;
      }

      xStep = Math.sqrt(dashLength * dashLength / (1 + slope * slope));
      xStep = dx < 0 ? -xStep : xStep;
      x += xStep;
      y += slope * xStep;

      if (draw === true) {
        this.lineTo(x, y);
      } else {
        this.moveTo(x, y);
      }

      distRemaining -= dashLength;
      draw = !draw;
    }
  };

  /**
   * Draw a Hexagon shape with 6 sides
   * @param {Number} x horizontal center
   * @param {Number} y vertical center
   * @param {Number} r   radius
   */
  CanvasRenderingContext2D.prototype.hexagon = function (x, y, r) {
    this.beginPath();
    var sides = 6;
    var a = Math.PI * 2 / sides;
    this.moveTo(x + r, y);
    for (var i = 1; i < sides; i++) {
      this.lineTo(x + r * Math.cos(a * i), y + r * Math.sin(a * i));
    }
    this.closePath();
  };
}

/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var keycharm = __webpack_require__(52);
var Emitter = __webpack_require__(73);
var Hammer = __webpack_require__(24);
var util = __webpack_require__(2);

/**
 * Turn an element into an clickToUse element.
 * When not active, the element has a transparent overlay. When the overlay is
 * clicked, the mode is changed to active.
 * When active, the element is displayed with a blue border around it, and
 * the interactive contents of the element can be used. When clicked outside
 * the element, the elements mode is changed to inactive.
 * @param {Element} container
 * @constructor Activator
 */
function Activator(container) {
  this.active = false;

  this.dom = {
    container: container
  };

  this.dom.overlay = document.createElement('div');
  this.dom.overlay.className = 'vis-overlay';

  this.dom.container.appendChild(this.dom.overlay);

  this.hammer = Hammer(this.dom.overlay);
  this.hammer.on('tap', this._onTapOverlay.bind(this));

  // block all touch events (except tap)
  var me = this;
  var events = ['tap', 'doubletap', 'press', 'pinch', 'pan', 'panstart', 'panmove', 'panend'];
  events.forEach(function (event) {
    me.hammer.on(event, function (event) {
      event.stopPropagation();
    });
  });

  // attach a click event to the window, in order to deactivate when clicking outside the timeline
  if (document && document.body) {
    this.onClick = function (event) {
      if (!_hasParent(event.target, container)) {
        me.deactivate();
      }
    };
    document.body.addEventListener('click', this.onClick);
  }

  if (this.keycharm !== undefined) {
    this.keycharm.destroy();
  }
  this.keycharm = keycharm();

  // keycharm listener only bounded when active)
  this.escListener = this.deactivate.bind(this);
}

// turn into an event emitter
Emitter(Activator.prototype);

// The currently active activator
Activator.current = null;

/**
 * Destroy the activator. Cleans up all created DOM and event listeners
 */
Activator.prototype.destroy = function () {
  this.deactivate();

  // remove dom
  this.dom.overlay.parentNode.removeChild(this.dom.overlay);

  // remove global event listener
  if (this.onClick) {
    document.body.removeEventListener('click', this.onClick);
  }
  // remove keycharm
  if (this.keycharm !== undefined) {
    this.keycharm.destroy();
  }
  this.keycharm = null;
  // cleanup hammer instances
  this.hammer.destroy();
  this.hammer = null;
  // FIXME: cleaning up hammer instances doesn't work (Timeline not removed from memory)
};

/**
 * Activate the element
 * Overlay is hidden, element is decorated with a blue shadow border
 */
Activator.prototype.activate = function () {
  // we allow only one active activator at a time
  if (Activator.current) {
    Activator.current.deactivate();
  }
  Activator.current = this;

  this.active = true;
  this.dom.overlay.style.display = 'none';
  util.addClassName(this.dom.container, 'vis-active');

  this.emit('change');
  this.emit('activate');

  // ugly hack: bind ESC after emitting the events, as the Network rebinds all
  // keyboard events on a 'change' event
  this.keycharm.bind('esc', this.escListener);
};

/**
 * Deactivate the element
 * Overlay is displayed on top of the element
 */
Activator.prototype.deactivate = function () {
  this.active = false;
  this.dom.overlay.style.display = '';
  util.removeClassName(this.dom.container, 'vis-active');
  this.keycharm.unbind('esc', this.escListener);

  this.emit('change');
  this.emit('deactivate');
};

/**
 * Handle a tap event: activate the container
 * @param {Event}  event   The event
 * @private
 */
Activator.prototype._onTapOverlay = function (event) {
  // activate the container
  this.activate();
  event.stopPropagation();
};

/**
 * Test whether the element has the requested parent element somewhere in
 * its chain of parent nodes.
 * @param {HTMLElement} element
 * @param {HTMLElement} parent
 * @returns {boolean} Returns true when the parent is found somewhere in the
 *                    chain of parent nodes.
 * @private
 */
function _hasParent(element, parent) {
  while (element) {
    if (element === parent) {
      return true;
    }
    element = element.parentNode;
  }
  return false;
}

module.exports = Activator;

/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

(function (factory) {
  if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else if (typeof exports === 'object') {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    window.propagating = factory();
  }
}(function () {
  var _firstTarget = null; // singleton, will contain the target element where the touch event started

  /**
   * Extend an Hammer.js instance with event propagation.
   *
   * Features:
   * - Events emitted by hammer will propagate in order from child to parent
   *   elements.
   * - Events are extended with a function `event.stopPropagation()` to stop
   *   propagation to parent elements.
   * - An option `preventDefault` to stop all default browser behavior.
   *
   * Usage:
   *   var hammer = propagatingHammer(new Hammer(element));
   *   var hammer = propagatingHammer(new Hammer(element), {preventDefault: true});
   *
   * @param {Hammer.Manager} hammer   An hammer instance.
   * @param {Object} [options]        Available options:
   *                                  - `preventDefault: true | false | 'mouse' | 'touch' | 'pen'`.
   *                                    Enforce preventing the default browser behavior.
   *                                    Cannot be set to `false`.
   * @return {Hammer.Manager} Returns the same hammer instance with extended
   *                          functionality
   */
  return function propagating(hammer, options) {
    var _options = options || {
      preventDefault: false
    };

    if (hammer.Manager) {
      // This looks like the Hammer constructor.
      // Overload the constructors with our own.
      var Hammer = hammer;

      var PropagatingHammer = function(element, options) {
        var o = Object.create(_options);
        if (options) Hammer.assign(o, options);
        return propagating(new Hammer(element, o), o);
      };
      Hammer.assign(PropagatingHammer, Hammer);

      PropagatingHammer.Manager = function (element, options) {
        var o = Object.create(_options);
        if (options) Hammer.assign(o, options);
        return propagating(new Hammer.Manager(element, o), o);
      };

      return PropagatingHammer;
    }

    // create a wrapper object which will override the functions
    // `on`, `off`, `destroy`, and `emit` of the hammer instance
    var wrapper = Object.create(hammer);

    // attach to DOM element
    var element = hammer.element;

    if(!element.hammer) element.hammer = [];
    element.hammer.push(wrapper);

    // register an event to catch the start of a gesture and store the
    // target in a singleton
    hammer.on('hammer.input', function (event) {
      if (_options.preventDefault === true || (_options.preventDefault === event.pointerType)) {
        event.preventDefault();
      }
      if (event.isFirst) {
        _firstTarget = event.target;
      }
    });

    /** @type {Object.<String, Array.<function>>} */
    wrapper._handlers = {};

    /**
     * Register a handler for one or multiple events
     * @param {String} events    A space separated string with events
     * @param {function} handler A callback function, called as handler(event)
     * @returns {Hammer.Manager} Returns the hammer instance
     */
    wrapper.on = function (events, handler) {
      // register the handler
      split(events).forEach(function (event) {
        var _handlers = wrapper._handlers[event];
        if (!_handlers) {
          wrapper._handlers[event] = _handlers = [];

          // register the static, propagated handler
          hammer.on(event, propagatedHandler);
        }
        _handlers.push(handler);
      });

      return wrapper;
    };

    /**
     * Unregister a handler for one or multiple events
     * @param {String} events      A space separated string with events
     * @param {function} [handler] Optional. The registered handler. If not
     *                             provided, all handlers for given events
     *                             are removed.
     * @returns {Hammer.Manager}   Returns the hammer instance
     */
    wrapper.off = function (events, handler) {
      // unregister the handler
      split(events).forEach(function (event) {
        var _handlers = wrapper._handlers[event];
        if (_handlers) {
          _handlers = handler ? _handlers.filter(function (h) {
            return h !== handler;
          }) : [];

          if (_handlers.length > 0) {
            wrapper._handlers[event] = _handlers;
          }
          else {
            // remove static, propagated handler
            hammer.off(event, propagatedHandler);
            delete wrapper._handlers[event];
          }
        }
      });

      return wrapper;
    };

    /**
     * Emit to the event listeners
     * @param {string} eventType
     * @param {Event} event
     */
    wrapper.emit = function(eventType, event) {
      _firstTarget = event.target;
      hammer.emit(eventType, event);
    };

    wrapper.destroy = function () {
      // Detach from DOM element
      var hammers = hammer.element.hammer;
      var idx = hammers.indexOf(wrapper);
      if(idx !== -1) hammers.splice(idx,1);
      if(!hammers.length) delete hammer.element.hammer;

      // clear all handlers
      wrapper._handlers = {};

      // call original hammer destroy
      hammer.destroy();
    };

    // split a string with space separated words
    function split(events) {
      return events.match(/[^ ]+/g);
    }

    /**
     * A static event handler, applying event propagation.
     * @param {Object} event
     */
    function propagatedHandler(event) {
      // let only a single hammer instance handle this event
      if (event.type !== 'hammer.input') {
        // it is possible that the same srcEvent is used with multiple hammer events,
        // we keep track on which events are handled in an object _handled
        if (!event.srcEvent._handled) {
          event.srcEvent._handled = {};
        }

        if (event.srcEvent._handled[event.type]) {
          return;
        }
        else {
          event.srcEvent._handled[event.type] = true;
        }
      }

      // attach a stopPropagation function to the event
      var stopped = false;
      event.stopPropagation = function () {
        stopped = true;
      };

      //wrap the srcEvent's stopPropagation to also stop hammer propagation:
      var srcStop = event.srcEvent.stopPropagation.bind(event.srcEvent);
      if(typeof srcStop == "function") {
        event.srcEvent.stopPropagation = function(){
          srcStop();
          event.stopPropagation();
        }
      }

      // attach firstTarget property to the event
      event.firstTarget = _firstTarget;

      // propagate over all elements (until stopped)
      var elem = _firstTarget;
      while (elem && !stopped) {
        var elemHammer = elem.hammer;
        if(elemHammer){
          var _handlers;
          for(var k = 0; k < elemHammer.length; k++){
            _handlers = elemHammer[k]._handlers[event.type];
            if(_handlers) for (var i = 0; i < _handlers.length && !stopped; i++) {
              _handlers[i](event);
            }
          }
        }
        elem = elem.parentNode;
      }
    }

    return wrapper;
  };
}));


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_RESULT__;/*! Hammer.JS - v2.0.7 - 2016-04-22
 * http://hammerjs.github.io/
 *
 * Copyright (c) 2016 Jorik Tangelder;
 * Licensed under the MIT license */
(function(window, document, exportName, undefined) {
  'use strict';

var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
var TEST_ELEMENT = document.createElement('div');

var TYPE_FUNCTION = 'function';

var round = Math.round;
var abs = Math.abs;
var now = Date.now;

/**
 * set a timeout with a given scope
 * @param {Function} fn
 * @param {Number} timeout
 * @param {Object} context
 * @returns {number}
 */
function setTimeoutContext(fn, timeout, context) {
    return setTimeout(bindFn(fn, context), timeout);
}

/**
 * if the argument is an array, we want to execute the fn on each entry
 * if it aint an array we don't want to do a thing.
 * this is used by all the methods that accept a single and array argument.
 * @param {*|Array} arg
 * @param {String} fn
 * @param {Object} [context]
 * @returns {Boolean}
 */
function invokeArrayArg(arg, fn, context) {
    if (Array.isArray(arg)) {
        each(arg, context[fn], context);
        return true;
    }
    return false;
}

/**
 * walk objects and arrays
 * @param {Object} obj
 * @param {Function} iterator
 * @param {Object} context
 */
function each(obj, iterator, context) {
    var i;

    if (!obj) {
        return;
    }

    if (obj.forEach) {
        obj.forEach(iterator, context);
    } else if (obj.length !== undefined) {
        i = 0;
        while (i < obj.length) {
            iterator.call(context, obj[i], i, obj);
            i++;
        }
    } else {
        for (i in obj) {
            obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
        }
    }
}

/**
 * wrap a method with a deprecation warning and stack trace
 * @param {Function} method
 * @param {String} name
 * @param {String} message
 * @returns {Function} A new function wrapping the supplied method.
 */
function deprecate(method, name, message) {
    var deprecationMessage = 'DEPRECATED METHOD: ' + name + '\n' + message + ' AT \n';
    return function() {
        var e = new Error('get-stack-trace');
        var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '')
            .replace(/^\s+at\s+/gm, '')
            .replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';

        var log = window.console && (window.console.warn || window.console.log);
        if (log) {
            log.call(window.console, deprecationMessage, stack);
        }
        return method.apply(this, arguments);
    };
}

/**
 * extend object.
 * means that properties in dest will be overwritten by the ones in src.
 * @param {Object} target
 * @param {...Object} objects_to_assign
 * @returns {Object} target
 */
var assign;
if (typeof Object.assign !== 'function') {
    assign = function assign(target) {
        if (target === undefined || target === null) {
            throw new TypeError('Cannot convert undefined or null to object');
        }

        var output = Object(target);
        for (var index = 1; index < arguments.length; index++) {
            var source = arguments[index];
            if (source !== undefined && source !== null) {
                for (var nextKey in source) {
                    if (source.hasOwnProperty(nextKey)) {
                        output[nextKey] = source[nextKey];
                    }
                }
            }
        }
        return output;
    };
} else {
    assign = Object.assign;
}

/**
 * extend object.
 * means that properties in dest will be overwritten by the ones in src.
 * @param {Object} dest
 * @param {Object} src
 * @param {Boolean} [merge=false]
 * @returns {Object} dest
 */
var extend = deprecate(function extend(dest, src, merge) {
    var keys = Object.keys(src);
    var i = 0;
    while (i < keys.length) {
        if (!merge || (merge && dest[keys[i]] === undefined)) {
            dest[keys[i]] = src[keys[i]];
        }
        i++;
    }
    return dest;
}, 'extend', 'Use `assign`.');

/**
 * merge the values from src in the dest.
 * means that properties that exist in dest will not be overwritten by src
 * @param {Object} dest
 * @param {Object} src
 * @returns {Object} dest
 */
var merge = deprecate(function merge(dest, src) {
    return extend(dest, src, true);
}, 'merge', 'Use `assign`.');

/**
 * simple class inheritance
 * @param {Function} child
 * @param {Function} base
 * @param {Object} [properties]
 */
function inherit(child, base, properties) {
    var baseP = base.prototype,
        childP;

    childP = child.prototype = Object.create(baseP);
    childP.constructor = child;
    childP._super = baseP;

    if (properties) {
        assign(childP, properties);
    }
}

/**
 * simple function bind
 * @param {Function} fn
 * @param {Object} context
 * @returns {Function}
 */
function bindFn(fn, context) {
    return function boundFn() {
        return fn.apply(context, arguments);
    };
}

/**
 * let a boolean value also be a function that must return a boolean
 * this first item in args will be used as the context
 * @param {Boolean|Function} val
 * @param {Array} [args]
 * @returns {Boolean}
 */
function boolOrFn(val, args) {
    if (typeof val == TYPE_FUNCTION) {
        return val.apply(args ? args[0] || undefined : undefined, args);
    }
    return val;
}

/**
 * use the val2 when val1 is undefined
 * @param {*} val1
 * @param {*} val2
 * @returns {*}
 */
function ifUndefined(val1, val2) {
    return (val1 === undefined) ? val2 : val1;
}

/**
 * addEventListener with multiple events at once
 * @param {EventTarget} target
 * @param {String} types
 * @param {Function} handler
 */
function addEventListeners(target, types, handler) {
    each(splitStr(types), function(type) {
        target.addEventListener(type, handler, false);
    });
}

/**
 * removeEventListener with multiple events at once
 * @param {EventTarget} target
 * @param {String} types
 * @param {Function} handler
 */
function removeEventListeners(target, types, handler) {
    each(splitStr(types), function(type) {
        target.removeEventListener(type, handler, false);
    });
}

/**
 * find if a node is in the given parent
 * @method hasParent
 * @param {HTMLElement} node
 * @param {HTMLElement} parent
 * @return {Boolean} found
 */
function hasParent(node, parent) {
    while (node) {
        if (node == parent) {
            return true;
        }
        node = node.parentNode;
    }
    return false;
}

/**
 * small indexOf wrapper
 * @param {String} str
 * @param {String} find
 * @returns {Boolean} found
 */
function inStr(str, find) {
    return str.indexOf(find) > -1;
}

/**
 * split string on whitespace
 * @param {String} str
 * @returns {Array} words
 */
function splitStr(str) {
    return str.trim().split(/\s+/g);
}

/**
 * find if a array contains the object using indexOf or a simple polyFill
 * @param {Array} src
 * @param {String} find
 * @param {String} [findByKey]
 * @return {Boolean|Number} false when not found, or the index
 */
function inArray(src, find, findByKey) {
    if (src.indexOf && !findByKey) {
        return src.indexOf(find);
    } else {
        var i = 0;
        while (i < src.length) {
            if ((findByKey && src[i][findByKey] == find) || (!findByKey && src[i] === find)) {
                return i;
            }
            i++;
        }
        return -1;
    }
}

/**
 * convert array-like objects to real arrays
 * @param {Object} obj
 * @returns {Array}
 */
function toArray(obj) {
    return Array.prototype.slice.call(obj, 0);
}

/**
 * unique array with objects based on a key (like 'id') or just by the array's value
 * @param {Array} src [{id:1},{id:2},{id:1}]
 * @param {String} [key]
 * @param {Boolean} [sort=False]
 * @returns {Array} [{id:1},{id:2}]
 */
function uniqueArray(src, key, sort) {
    var results = [];
    var values = [];
    var i = 0;

    while (i < src.length) {
        var val = key ? src[i][key] : src[i];
        if (inArray(values, val) < 0) {
            results.push(src[i]);
        }
        values[i] = val;
        i++;
    }

    if (sort) {
        if (!key) {
            results = results.sort();
        } else {
            results = results.sort(function sortUniqueArray(a, b) {
                return a[key] > b[key];
            });
        }
    }

    return results;
}

/**
 * get the prefixed property
 * @param {Object} obj
 * @param {String} property
 * @returns {String|Undefined} prefixed
 */
function prefixed(obj, property) {
    var prefix, prop;
    var camelProp = property[0].toUpperCase() + property.slice(1);

    var i = 0;
    while (i < VENDOR_PREFIXES.length) {
        prefix = VENDOR_PREFIXES[i];
        prop = (prefix) ? prefix + camelProp : property;

        if (prop in obj) {
            return prop;
        }
        i++;
    }
    return undefined;
}

/**
 * get a unique id
 * @returns {number} uniqueId
 */
var _uniqueId = 1;
function uniqueId() {
    return _uniqueId++;
}

/**
 * get the window object of an element
 * @param {HTMLElement} element
 * @returns {DocumentView|Window}
 */
function getWindowForElement(element) {
    var doc = element.ownerDocument || element;
    return (doc.defaultView || doc.parentWindow || window);
}

var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;

var SUPPORT_TOUCH = ('ontouchstart' in window);
var SUPPORT_POINTER_EVENTS = prefixed(window, 'PointerEvent') !== undefined;
var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);

var INPUT_TYPE_TOUCH = 'touch';
var INPUT_TYPE_PEN = 'pen';
var INPUT_TYPE_MOUSE = 'mouse';
var INPUT_TYPE_KINECT = 'kinect';

var COMPUTE_INTERVAL = 25;

var INPUT_START = 1;
var INPUT_MOVE = 2;
var INPUT_END = 4;
var INPUT_CANCEL = 8;

var DIRECTION_NONE = 1;
var DIRECTION_LEFT = 2;
var DIRECTION_RIGHT = 4;
var DIRECTION_UP = 8;
var DIRECTION_DOWN = 16;

var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;

var PROPS_XY = ['x', 'y'];
var PROPS_CLIENT_XY = ['clientX', 'clientY'];

/**
 * create new input type manager
 * @param {Manager} manager
 * @param {Function} callback
 * @returns {Input}
 * @constructor
 */
function Input(manager, callback) {
    var self = this;
    this.manager = manager;
    this.callback = callback;
    this.element = manager.element;
    this.target = manager.options.inputTarget;

    // smaller wrapper around the handler, for the scope and the enabled state of the manager,
    // so when disabled the input events are completely bypassed.
    this.domHandler = function(ev) {
        if (boolOrFn(manager.options.enable, [manager])) {
            self.handler(ev);
        }
    };

    this.init();

}

Input.prototype = {
    /**
     * should handle the inputEvent data and trigger the callback
     * @virtual
     */
    handler: function() { },

    /**
     * bind the events
     */
    init: function() {
        this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
        this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
        this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
    },

    /**
     * unbind the events
     */
    destroy: function() {
        this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
        this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
        this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
    }
};

/**
 * create new input type manager
 * called by the Manager constructor
 * @param {Hammer} manager
 * @returns {Input}
 */
function createInputInstance(manager) {
    var Type;
    var inputClass = manager.options.inputClass;

    if (inputClass) {
        Type = inputClass;
    } else if (SUPPORT_POINTER_EVENTS) {
        Type = PointerEventInput;
    } else if (SUPPORT_ONLY_TOUCH) {
        Type = TouchInput;
    } else if (!SUPPORT_TOUCH) {
        Type = MouseInput;
    } else {
        Type = TouchMouseInput;
    }
    return new (Type)(manager, inputHandler);
}

/**
 * handle input events
 * @param {Manager} manager
 * @param {String} eventType
 * @param {Object} input
 */
function inputHandler(manager, eventType, input) {
    var pointersLen = input.pointers.length;
    var changedPointersLen = input.changedPointers.length;
    var isFirst = (eventType & INPUT_START && (pointersLen - changedPointersLen === 0));
    var isFinal = (eventType & (INPUT_END | INPUT_CANCEL) && (pointersLen - changedPointersLen === 0));

    input.isFirst = !!isFirst;
    input.isFinal = !!isFinal;

    if (isFirst) {
        manager.session = {};
    }

    // source event is the normalized value of the domEvents
    // like 'touchstart, mouseup, pointerdown'
    input.eventType = eventType;

    // compute scale, rotation etc
    computeInputData(manager, input);

    // emit secret event
    manager.emit('hammer.input', input);

    manager.recognize(input);
    manager.session.prevInput = input;
}

/**
 * extend the data with some usable properties like scale, rotate, velocity etc
 * @param {Object} manager
 * @param {Object} input
 */
function computeInputData(manager, input) {
    var session = manager.session;
    var pointers = input.pointers;
    var pointersLength = pointers.length;

    // store the first input to calculate the distance and direction
    if (!session.firstInput) {
        session.firstInput = simpleCloneInputData(input);
    }

    // to compute scale and rotation we need to store the multiple touches
    if (pointersLength > 1 && !session.firstMultiple) {
        session.firstMultiple = simpleCloneInputData(input);
    } else if (pointersLength === 1) {
        session.firstMultiple = false;
    }

    var firstInput = session.firstInput;
    var firstMultiple = session.firstMultiple;
    var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;

    var center = input.center = getCenter(pointers);
    input.timeStamp = now();
    input.deltaTime = input.timeStamp - firstInput.timeStamp;

    input.angle = getAngle(offsetCenter, center);
    input.distance = getDistance(offsetCenter, center);

    computeDeltaXY(session, input);
    input.offsetDirection = getDirection(input.deltaX, input.deltaY);

    var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
    input.overallVelocityX = overallVelocity.x;
    input.overallVelocityY = overallVelocity.y;
    input.overallVelocity = (abs(overallVelocity.x) > abs(overallVelocity.y)) ? overallVelocity.x : overallVelocity.y;

    input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
    input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;

    input.maxPointers = !session.prevInput ? input.pointers.length : ((input.pointers.length >
        session.prevInput.maxPointers) ? input.pointers.length : session.prevInput.maxPointers);

    computeIntervalInputData(session, input);

    // find the correct target
    var target = manager.element;
    if (hasParent(input.srcEvent.target, target)) {
        target = input.srcEvent.target;
    }
    input.target = target;
}

function computeDeltaXY(session, input) {
    var center = input.center;
    var offset = session.offsetDelta || {};
    var prevDelta = session.prevDelta || {};
    var prevInput = session.prevInput || {};

    if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
        prevDelta = session.prevDelta = {
            x: prevInput.deltaX || 0,
            y: prevInput.deltaY || 0
        };

        offset = session.offsetDelta = {
            x: center.x,
            y: center.y
        };
    }

    input.deltaX = prevDelta.x + (center.x - offset.x);
    input.deltaY = prevDelta.y + (center.y - offset.y);
}

/**
 * velocity is calculated every x ms
 * @param {Object} session
 * @param {Object} input
 */
function computeIntervalInputData(session, input) {
    var last = session.lastInterval || input,
        deltaTime = input.timeStamp - last.timeStamp,
        velocity, velocityX, velocityY, direction;

    if (input.eventType != INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
        var deltaX = input.deltaX - last.deltaX;
        var deltaY = input.deltaY - last.deltaY;

        var v = getVelocity(deltaTime, deltaX, deltaY);
        velocityX = v.x;
        velocityY = v.y;
        velocity = (abs(v.x) > abs(v.y)) ? v.x : v.y;
        direction = getDirection(deltaX, deltaY);

        session.lastInterval = input;
    } else {
        // use latest velocity info if it doesn't overtake a minimum period
        velocity = last.velocity;
        velocityX = last.velocityX;
        velocityY = last.velocityY;
        direction = last.direction;
    }

    input.velocity = velocity;
    input.velocityX = velocityX;
    input.velocityY = velocityY;
    input.direction = direction;
}

/**
 * create a simple clone from the input used for storage of firstInput and firstMultiple
 * @param {Object} input
 * @returns {Object} clonedInputData
 */
function simpleCloneInputData(input) {
    // make a simple copy of the pointers because we will get a reference if we don't
    // we only need clientXY for the calculations
    var pointers = [];
    var i = 0;
    while (i < input.pointers.length) {
        pointers[i] = {
            clientX: round(input.pointers[i].clientX),
            clientY: round(input.pointers[i].clientY)
        };
        i++;
    }

    return {
        timeStamp: now(),
        pointers: pointers,
        center: getCenter(pointers),
        deltaX: input.deltaX,
        deltaY: input.deltaY
    };
}

/**
 * get the center of all the pointers
 * @param {Array} pointers
 * @return {Object} center contains `x` and `y` properties
 */
function getCenter(pointers) {
    var pointersLength = pointers.length;

    // no need to loop when only one touch
    if (pointersLength === 1) {
        return {
            x: round(pointers[0].clientX),
            y: round(pointers[0].clientY)
        };
    }

    var x = 0, y = 0, i = 0;
    while (i < pointersLength) {
        x += pointers[i].clientX;
        y += pointers[i].clientY;
        i++;
    }

    return {
        x: round(x / pointersLength),
        y: round(y / pointersLength)
    };
}

/**
 * calculate the velocity between two points. unit is in px per ms.
 * @param {Number} deltaTime
 * @param {Number} x
 * @param {Number} y
 * @return {Object} velocity `x` and `y`
 */
function getVelocity(deltaTime, x, y) {
    return {
        x: x / deltaTime || 0,
        y: y / deltaTime || 0
    };
}

/**
 * get the direction between two points
 * @param {Number} x
 * @param {Number} y
 * @return {Number} direction
 */
function getDirection(x, y) {
    if (x === y) {
        return DIRECTION_NONE;
    }

    if (abs(x) >= abs(y)) {
        return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
    }
    return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
}

/**
 * calculate the absolute distance between two points
 * @param {Object} p1 {x, y}
 * @param {Object} p2 {x, y}
 * @param {Array} [props] containing x and y keys
 * @return {Number} distance
 */
function getDistance(p1, p2, props) {
    if (!props) {
        props = PROPS_XY;
    }
    var x = p2[props[0]] - p1[props[0]],
        y = p2[props[1]] - p1[props[1]];

    return Math.sqrt((x * x) + (y * y));
}

/**
 * calculate the angle between two coordinates
 * @param {Object} p1
 * @param {Object} p2
 * @param {Array} [props] containing x and y keys
 * @return {Number} angle
 */
function getAngle(p1, p2, props) {
    if (!props) {
        props = PROPS_XY;
    }
    var x = p2[props[0]] - p1[props[0]],
        y = p2[props[1]] - p1[props[1]];
    return Math.atan2(y, x) * 180 / Math.PI;
}

/**
 * calculate the rotation degrees between two pointersets
 * @param {Array} start array of pointers
 * @param {Array} end array of pointers
 * @return {Number} rotation
 */
function getRotation(start, end) {
    return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
}

/**
 * calculate the scale factor between two pointersets
 * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
 * @param {Array} start array of pointers
 * @param {Array} end array of pointers
 * @return {Number} scale
 */
function getScale(start, end) {
    return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
}

var MOUSE_INPUT_MAP = {
    mousedown: INPUT_START,
    mousemove: INPUT_MOVE,
    mouseup: INPUT_END
};

var MOUSE_ELEMENT_EVENTS = 'mousedown';
var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';

/**
 * Mouse events input
 * @constructor
 * @extends Input
 */
function MouseInput() {
    this.evEl = MOUSE_ELEMENT_EVENTS;
    this.evWin = MOUSE_WINDOW_EVENTS;

    this.pressed = false; // mousedown state

    Input.apply(this, arguments);
}

inherit(MouseInput, Input, {
    /**
     * handle mouse events
     * @param {Object} ev
     */
    handler: function MEhandler(ev) {
        var eventType = MOUSE_INPUT_MAP[ev.type];

        // on start we want to have the left mouse button down
        if (eventType & INPUT_START && ev.button === 0) {
            this.pressed = true;
        }

        if (eventType & INPUT_MOVE && ev.which !== 1) {
            eventType = INPUT_END;
        }

        // mouse must be down
        if (!this.pressed) {
            return;
        }

        if (eventType & INPUT_END) {
            this.pressed = false;
        }

        this.callback(this.manager, eventType, {
            pointers: [ev],
            changedPointers: [ev],
            pointerType: INPUT_TYPE_MOUSE,
            srcEvent: ev
        });
    }
});

var POINTER_INPUT_MAP = {
    pointerdown: INPUT_START,
    pointermove: INPUT_MOVE,
    pointerup: INPUT_END,
    pointercancel: INPUT_CANCEL,
    pointerout: INPUT_CANCEL
};

// in IE10 the pointer types is defined as an enum
var IE10_POINTER_TYPE_ENUM = {
    2: INPUT_TYPE_TOUCH,
    3: INPUT_TYPE_PEN,
    4: INPUT_TYPE_MOUSE,
    5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816
};

var POINTER_ELEMENT_EVENTS = 'pointerdown';
var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel';

// IE10 has prefixed support, and case-sensitive
if (window.MSPointerEvent && !window.PointerEvent) {
    POINTER_ELEMENT_EVENTS = 'MSPointerDown';
    POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
}

/**
 * Pointer events input
 * @constructor
 * @extends Input
 */
function PointerEventInput() {
    this.evEl = POINTER_ELEMENT_EVENTS;
    this.evWin = POINTER_WINDOW_EVENTS;

    Input.apply(this, arguments);

    this.store = (this.manager.session.pointerEvents = []);
}

inherit(PointerEventInput, Input, {
    /**
     * handle mouse events
     * @param {Object} ev
     */
    handler: function PEhandler(ev) {
        var store = this.store;
        var removePointer = false;

        var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
        var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
        var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;

        var isTouch = (pointerType == INPUT_TYPE_TOUCH);

        // get index of the event in the store
        var storeIndex = inArray(store, ev.pointerId, 'pointerId');

        // start and mouse must be down
        if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
            if (storeIndex < 0) {
                store.push(ev);
                storeIndex = store.length - 1;
            }
        } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
            removePointer = true;
        }

        // it not found, so the pointer hasn't been down (so it's probably a hover)
        if (storeIndex < 0) {
            return;
        }

        // update the event in the store
        store[storeIndex] = ev;

        this.callback(this.manager, eventType, {
            pointers: store,
            changedPointers: [ev],
            pointerType: pointerType,
            srcEvent: ev
        });

        if (removePointer) {
            // remove from the store
            store.splice(storeIndex, 1);
        }
    }
});

var SINGLE_TOUCH_INPUT_MAP = {
    touchstart: INPUT_START,
    touchmove: INPUT_MOVE,
    touchend: INPUT_END,
    touchcancel: INPUT_CANCEL
};

var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';

/**
 * Touch events input
 * @constructor
 * @extends Input
 */
function SingleTouchInput() {
    this.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
    this.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
    this.started = false;

    Input.apply(this, arguments);
}

inherit(SingleTouchInput, Input, {
    handler: function TEhandler(ev) {
        var type = SINGLE_TOUCH_INPUT_MAP[ev.type];

        // should we handle the touch events?
        if (type === INPUT_START) {
            this.started = true;
        }

        if (!this.started) {
            return;
        }

        var touches = normalizeSingleTouches.call(this, ev, type);

        // when done, reset the started state
        if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
            this.started = false;
        }

        this.callback(this.manager, type, {
            pointers: touches[0],
            changedPointers: touches[1],
            pointerType: INPUT_TYPE_TOUCH,
            srcEvent: ev
        });
    }
});

/**
 * @this {TouchInput}
 * @param {Object} ev
 * @param {Number} type flag
 * @returns {undefined|Array} [all, changed]
 */
function normalizeSingleTouches(ev, type) {
    var all = toArray(ev.touches);
    var changed = toArray(ev.changedTouches);

    if (type & (INPUT_END | INPUT_CANCEL)) {
        all = uniqueArray(all.concat(changed), 'identifier', true);
    }

    return [all, changed];
}

var TOUCH_INPUT_MAP = {
    touchstart: INPUT_START,
    touchmove: INPUT_MOVE,
    touchend: INPUT_END,
    touchcancel: INPUT_CANCEL
};

var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';

/**
 * Multi-user touch events input
 * @constructor
 * @extends Input
 */
function TouchInput() {
    this.evTarget = TOUCH_TARGET_EVENTS;
    this.targetIds = {};

    Input.apply(this, arguments);
}

inherit(TouchInput, Input, {
    handler: function MTEhandler(ev) {
        var type = TOUCH_INPUT_MAP[ev.type];
        var touches = getTouches.call(this, ev, type);
        if (!touches) {
            return;
        }

        this.callback(this.manager, type, {
            pointers: touches[0],
            changedPointers: touches[1],
            pointerType: INPUT_TYPE_TOUCH,
            srcEvent: ev
        });
    }
});

/**
 * @this {TouchInput}
 * @param {Object} ev
 * @param {Number} type flag
 * @returns {undefined|Array} [all, changed]
 */
function getTouches(ev, type) {
    var allTouches = toArray(ev.touches);
    var targetIds = this.targetIds;

    // when there is only one touch, the process can be simplified
    if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
        targetIds[allTouches[0].identifier] = true;
        return [allTouches, allTouches];
    }

    var i,
        targetTouches,
        changedTouches = toArray(ev.changedTouches),
        changedTargetTouches = [],
        target = this.target;

    // get target touches from touches
    targetTouches = allTouches.filter(function(touch) {
        return hasParent(touch.target, target);
    });

    // collect touches
    if (type === INPUT_START) {
        i = 0;
        while (i < targetTouches.length) {
            targetIds[targetTouches[i].identifier] = true;
            i++;
        }
    }

    // filter changed touches to only contain touches that exist in the collected target ids
    i = 0;
    while (i < changedTouches.length) {
        if (targetIds[changedTouches[i].identifier]) {
            changedTargetTouches.push(changedTouches[i]);
        }

        // cleanup removed touches
        if (type & (INPUT_END | INPUT_CANCEL)) {
            delete targetIds[changedTouches[i].identifier];
        }
        i++;
    }

    if (!changedTargetTouches.length) {
        return;
    }

    return [
        // merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
        uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true),
        changedTargetTouches
    ];
}

/**
 * Combined touch and mouse input
 *
 * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
 * This because touch devices also emit mouse events while doing a touch.
 *
 * @constructor
 * @extends Input
 */

var DEDUP_TIMEOUT = 2500;
var DEDUP_DISTANCE = 25;

function TouchMouseInput() {
    Input.apply(this, arguments);

    var handler = bindFn(this.handler, this);
    this.touch = new TouchInput(this.manager, handler);
    this.mouse = new MouseInput(this.manager, handler);

    this.primaryTouch = null;
    this.lastTouches = [];
}

inherit(TouchMouseInput, Input, {
    /**
     * handle mouse and touch events
     * @param {Hammer} manager
     * @param {String} inputEvent
     * @param {Object} inputData
     */
    handler: function TMEhandler(manager, inputEvent, inputData) {
        var isTouch = (inputData.pointerType == INPUT_TYPE_TOUCH),
            isMouse = (inputData.pointerType == INPUT_TYPE_MOUSE);

        if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
            return;
        }

        // when we're in a touch event, record touches to  de-dupe synthetic mouse event
        if (isTouch) {
            recordTouches.call(this, inputEvent, inputData);
        } else if (isMouse && isSyntheticEvent.call(this, inputData)) {
            return;
        }

        this.callback(manager, inputEvent, inputData);
    },

    /**
     * remove the event listeners
     */
    destroy: function destroy() {
        this.touch.destroy();
        this.mouse.destroy();
    }
});

function recordTouches(eventType, eventData) {
    if (eventType & INPUT_START) {
        this.primaryTouch = eventData.changedPointers[0].identifier;
        setLastTouch.call(this, eventData);
    } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
        setLastTouch.call(this, eventData);
    }
}

function setLastTouch(eventData) {
    var touch = eventData.changedPointers[0];

    if (touch.identifier === this.primaryTouch) {
        var lastTouch = {x: touch.clientX, y: touch.clientY};
        this.lastTouches.push(lastTouch);
        var lts = this.lastTouches;
        var removeLastTouch = function() {
            var i = lts.indexOf(lastTouch);
            if (i > -1) {
                lts.splice(i, 1);
            }
        };
        setTimeout(removeLastTouch, DEDUP_TIMEOUT);
    }
}

function isSyntheticEvent(eventData) {
    var x = eventData.srcEvent.clientX, y = eventData.srcEvent.clientY;
    for (var i = 0; i < this.lastTouches.length; i++) {
        var t = this.lastTouches[i];
        var dx = Math.abs(x - t.x), dy = Math.abs(y - t.y);
        if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
            return true;
        }
    }
    return false;
}

var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;

// magical touchAction value
var TOUCH_ACTION_COMPUTE = 'compute';
var TOUCH_ACTION_AUTO = 'auto';
var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented
var TOUCH_ACTION_NONE = 'none';
var TOUCH_ACTION_PAN_X = 'pan-x';
var TOUCH_ACTION_PAN_Y = 'pan-y';
var TOUCH_ACTION_MAP = getTouchActionProps();

/**
 * Touch Action
 * sets the touchAction property or uses the js alternative
 * @param {Manager} manager
 * @param {String} value
 * @constructor
 */
function TouchAction(manager, value) {
    this.manager = manager;
    this.set(value);
}

TouchAction.prototype = {
    /**
     * set the touchAction value on the element or enable the polyfill
     * @param {String} value
     */
    set: function(value) {
        // find out the touch-action by the event handlers
        if (value == TOUCH_ACTION_COMPUTE) {
            value = this.compute();
        }

        if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
            this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
        }
        this.actions = value.toLowerCase().trim();
    },

    /**
     * just re-set the touchAction value
     */
    update: function() {
        this.set(this.manager.options.touchAction);
    },

    /**
     * compute the value for the touchAction property based on the recognizer's settings
     * @returns {String} value
     */
    compute: function() {
        var actions = [];
        each(this.manager.recognizers, function(recognizer) {
            if (boolOrFn(recognizer.options.enable, [recognizer])) {
                actions = actions.concat(recognizer.getTouchAction());
            }
        });
        return cleanTouchActions(actions.join(' '));
    },

    /**
     * this method is called on each input cycle and provides the preventing of the browser behavior
     * @param {Object} input
     */
    preventDefaults: function(input) {
        var srcEvent = input.srcEvent;
        var direction = input.offsetDirection;

        // if the touch action did prevented once this session
        if (this.manager.session.prevented) {
            srcEvent.preventDefault();
            return;
        }

        var actions = this.actions;
        var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
        var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
        var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

        if (hasNone) {
            //do not prevent defaults if this is a tap gesture

            var isTapPointer = input.pointers.length === 1;
            var isTapMovement = input.distance < 2;
            var isTapTouchTime = input.deltaTime < 250;

            if (isTapPointer && isTapMovement && isTapTouchTime) {
                return;
            }
        }

        if (hasPanX && hasPanY) {
            // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
            return;
        }

        if (hasNone ||
            (hasPanY && direction & DIRECTION_HORIZONTAL) ||
            (hasPanX && direction & DIRECTION_VERTICAL)) {
            return this.preventSrc(srcEvent);
        }
    },

    /**
     * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
     * @param {Object} srcEvent
     */
    preventSrc: function(srcEvent) {
        this.manager.session.prevented = true;
        srcEvent.preventDefault();
    }
};

/**
 * when the touchActions are collected they are not a valid value, so we need to clean things up. *
 * @param {String} actions
 * @returns {*}
 */
function cleanTouchActions(actions) {
    // none
    if (inStr(actions, TOUCH_ACTION_NONE)) {
        return TOUCH_ACTION_NONE;
    }

    var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
    var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y);

    // if both pan-x and pan-y are set (different recognizers
    // for different directions, e.g. horizontal pan but vertical swipe?)
    // we need none (as otherwise with pan-x pan-y combined none of these
    // recognizers will work, since the browser would handle all panning
    if (hasPanX && hasPanY) {
        return TOUCH_ACTION_NONE;
    }

    // pan-x OR pan-y
    if (hasPanX || hasPanY) {
        return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
    }

    // manipulation
    if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
        return TOUCH_ACTION_MANIPULATION;
    }

    return TOUCH_ACTION_AUTO;
}

function getTouchActionProps() {
    if (!NATIVE_TOUCH_ACTION) {
        return false;
    }
    var touchMap = {};
    var cssSupports = window.CSS && window.CSS.supports;
    ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function(val) {

        // If css.supports is not supported but there is native touch-action assume it supports
        // all values. This is the case for IE 10 and 11.
        touchMap[val] = cssSupports ? window.CSS.supports('touch-action', val) : true;
    });
    return touchMap;
}

/**
 * Recognizer flow explained; *
 * All recognizers have the initial state of POSSIBLE when a input session starts.
 * The definition of a input session is from the first input until the last input, with all it's movement in it. *
 * Example session for mouse-input: mousedown -> mousemove -> mouseup
 *
 * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
 * which determines with state it should be.
 *
 * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
 * POSSIBLE to give it another change on the next cycle.
 *
 *               Possible
 *                  |
 *            +-----+---------------+
 *            |                     |
 *      +-----+-----+               |
 *      |           |               |
 *   Failed      Cancelled          |
 *                          +-------+------+
 *                          |              |
 *                      Recognized       Began
 *                                         |
 *                                      Changed
 *                                         |
 *                                  Ended/Recognized
 */
var STATE_POSSIBLE = 1;
var STATE_BEGAN = 2;
var STATE_CHANGED = 4;
var STATE_ENDED = 8;
var STATE_RECOGNIZED = STATE_ENDED;
var STATE_CANCELLED = 16;
var STATE_FAILED = 32;

/**
 * Recognizer
 * Every recognizer needs to extend from this class.
 * @constructor
 * @param {Object} options
 */
function Recognizer(options) {
    this.options = assign({}, this.defaults, options || {});

    this.id = uniqueId();

    this.manager = null;

    // default is enable true
    this.options.enable = ifUndefined(this.options.enable, true);

    this.state = STATE_POSSIBLE;

    this.simultaneous = {};
    this.requireFail = [];
}

Recognizer.prototype = {
    /**
     * @virtual
     * @type {Object}
     */
    defaults: {},

    /**
     * set options
     * @param {Object} options
     * @return {Recognizer}
     */
    set: function(options) {
        assign(this.options, options);

        // also update the touchAction, in case something changed about the directions/enabled state
        this.manager && this.manager.touchAction.update();
        return this;
    },

    /**
     * recognize simultaneous with an other recognizer.
     * @param {Recognizer} otherRecognizer
     * @returns {Recognizer} this
     */
    recognizeWith: function(otherRecognizer) {
        if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
            return this;
        }

        var simultaneous = this.simultaneous;
        otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
        if (!simultaneous[otherRecognizer.id]) {
            simultaneous[otherRecognizer.id] = otherRecognizer;
            otherRecognizer.recognizeWith(this);
        }
        return this;
    },

    /**
     * drop the simultaneous link. it doesnt remove the link on the other recognizer.
     * @param {Recognizer} otherRecognizer
     * @returns {Recognizer} this
     */
    dropRecognizeWith: function(otherRecognizer) {
        if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
            return this;
        }

        otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
        delete this.simultaneous[otherRecognizer.id];
        return this;
    },

    /**
     * recognizer can only run when an other is failing
     * @param {Recognizer} otherRecognizer
     * @returns {Recognizer} this
     */
    requireFailure: function(otherRecognizer) {
        if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
            return this;
        }

        var requireFail = this.requireFail;
        otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
        if (inArray(requireFail, otherRecognizer) === -1) {
            requireFail.push(otherRecognizer);
            otherRecognizer.requireFailure(this);
        }
        return this;
    },

    /**
     * drop the requireFailure link. it does not remove the link on the other recognizer.
     * @param {Recognizer} otherRecognizer
     * @returns {Recognizer} this
     */
    dropRequireFailure: function(otherRecognizer) {
        if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
            return this;
        }

        otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
        var index = inArray(this.requireFail, otherRecognizer);
        if (index > -1) {
            this.requireFail.splice(index, 1);
        }
        return this;
    },

    /**
     * has require failures boolean
     * @returns {boolean}
     */
    hasRequireFailures: function() {
        return this.requireFail.length > 0;
    },

    /**
     * if the recognizer can recognize simultaneous with an other recognizer
     * @param {Recognizer} otherRecognizer
     * @returns {Boolean}
     */
    canRecognizeWith: function(otherRecognizer) {
        return !!this.simultaneous[otherRecognizer.id];
    },

    /**
     * You should use `tryEmit` instead of `emit` directly to check
     * that all the needed recognizers has failed before emitting.
     * @param {Object} input
     */
    emit: function(input) {
        var self = this;
        var state = this.state;

        function emit(event) {
            self.manager.emit(event, input);
        }

        // 'panstart' and 'panmove'
        if (state < STATE_ENDED) {
            emit(self.options.event + stateStr(state));
        }

        emit(self.options.event); // simple 'eventName' events

        if (input.additionalEvent) { // additional event(panleft, panright, pinchin, pinchout...)
            emit(input.additionalEvent);
        }

        // panend and pancancel
        if (state >= STATE_ENDED) {
            emit(self.options.event + stateStr(state));
        }
    },

    /**
     * Check that all the require failure recognizers has failed,
     * if true, it emits a gesture event,
     * otherwise, setup the state to FAILED.
     * @param {Object} input
     */
    tryEmit: function(input) {
        if (this.canEmit()) {
            return this.emit(input);
        }
        // it's failing anyway
        this.state = STATE_FAILED;
    },

    /**
     * can we emit?
     * @returns {boolean}
     */
    canEmit: function() {
        var i = 0;
        while (i < this.requireFail.length) {
            if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
                return false;
            }
            i++;
        }
        return true;
    },

    /**
     * update the recognizer
     * @param {Object} inputData
     */
    recognize: function(inputData) {
        // make a new copy of the inputData
        // so we can change the inputData without messing up the other recognizers
        var inputDataClone = assign({}, inputData);

        // is is enabled and allow recognizing?
        if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
            this.reset();
            this.state = STATE_FAILED;
            return;
        }

        // reset when we've reached the end
        if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
            this.state = STATE_POSSIBLE;
        }

        this.state = this.process(inputDataClone);

        // the recognizer has recognized a gesture
        // so trigger an event
        if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
            this.tryEmit(inputDataClone);
        }
    },

    /**
     * return the state of the recognizer
     * the actual recognizing happens in this method
     * @virtual
     * @param {Object} inputData
     * @returns {Const} STATE
     */
    process: function(inputData) { }, // jshint ignore:line

    /**
     * return the preferred touch-action
     * @virtual
     * @returns {Array}
     */
    getTouchAction: function() { },

    /**
     * called when the gesture isn't allowed to recognize
     * like when another is being recognized or it is disabled
     * @virtual
     */
    reset: function() { }
};

/**
 * get a usable string, used as event postfix
 * @param {Const} state
 * @returns {String} state
 */
function stateStr(state) {
    if (state & STATE_CANCELLED) {
        return 'cancel';
    } else if (state & STATE_ENDED) {
        return 'end';
    } else if (state & STATE_CHANGED) {
        return 'move';
    } else if (state & STATE_BEGAN) {
        return 'start';
    }
    return '';
}

/**
 * direction cons to string
 * @param {Const} direction
 * @returns {String}
 */
function directionStr(direction) {
    if (direction == DIRECTION_DOWN) {
        return 'down';
    } else if (direction == DIRECTION_UP) {
        return 'up';
    } else if (direction == DIRECTION_LEFT) {
        return 'left';
    } else if (direction == DIRECTION_RIGHT) {
        return 'right';
    }
    return '';
}

/**
 * get a recognizer by name if it is bound to a manager
 * @param {Recognizer|String} otherRecognizer
 * @param {Recognizer} recognizer
 * @returns {Recognizer}
 */
function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
    var manager = recognizer.manager;
    if (manager) {
        return manager.get(otherRecognizer);
    }
    return otherRecognizer;
}

/**
 * This recognizer is just used as a base for the simple attribute recognizers.
 * @constructor
 * @extends Recognizer
 */
function AttrRecognizer() {
    Recognizer.apply(this, arguments);
}

inherit(AttrRecognizer, Recognizer, {
    /**
     * @namespace
     * @memberof AttrRecognizer
     */
    defaults: {
        /**
         * @type {Number}
         * @default 1
         */
        pointers: 1
    },

    /**
     * Used to check if it the recognizer receives valid input, like input.distance > 10.
     * @memberof AttrRecognizer
     * @param {Object} input
     * @returns {Boolean} recognized
     */
    attrTest: function(input) {
        var optionPointers = this.options.pointers;
        return optionPointers === 0 || input.pointers.length === optionPointers;
    },

    /**
     * Process the input and return the state for the recognizer
     * @memberof AttrRecognizer
     * @param {Object} input
     * @returns {*} State
     */
    process: function(input) {
        var state = this.state;
        var eventType = input.eventType;

        var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
        var isValid = this.attrTest(input);

        // on cancel input and we've recognized before, return STATE_CANCELLED
        if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
            return state | STATE_CANCELLED;
        } else if (isRecognized || isValid) {
            if (eventType & INPUT_END) {
                return state | STATE_ENDED;
            } else if (!(state & STATE_BEGAN)) {
                return STATE_BEGAN;
            }
            return state | STATE_CHANGED;
        }
        return STATE_FAILED;
    }
});

/**
 * Pan
 * Recognized when the pointer is down and moved in the allowed direction.
 * @constructor
 * @extends AttrRecognizer
 */
function PanRecognizer() {
    AttrRecognizer.apply(this, arguments);

    this.pX = null;
    this.pY = null;
}

inherit(PanRecognizer, AttrRecognizer, {
    /**
     * @namespace
     * @memberof PanRecognizer
     */
    defaults: {
        event: 'pan',
        threshold: 10,
        pointers: 1,
        direction: DIRECTION_ALL
    },

    getTouchAction: function() {
        var direction = this.options.direction;
        var actions = [];
        if (direction & DIRECTION_HORIZONTAL) {
            actions.push(TOUCH_ACTION_PAN_Y);
        }
        if (direction & DIRECTION_VERTICAL) {
            actions.push(TOUCH_ACTION_PAN_X);
        }
        return actions;
    },

    directionTest: function(input) {
        var options = this.options;
        var hasMoved = true;
        var distance = input.distance;
        var direction = input.direction;
        var x = input.deltaX;
        var y = input.deltaY;

        // lock to axis?
        if (!(direction & options.direction)) {
            if (options.direction & DIRECTION_HORIZONTAL) {
                direction = (x === 0) ? DIRECTION_NONE : (x < 0) ? DIRECTION_LEFT : DIRECTION_RIGHT;
                hasMoved = x != this.pX;
                distance = Math.abs(input.deltaX);
            } else {
                direction = (y === 0) ? DIRECTION_NONE : (y < 0) ? DIRECTION_UP : DIRECTION_DOWN;
                hasMoved = y != this.pY;
                distance = Math.abs(input.deltaY);
            }
        }
        input.direction = direction;
        return hasMoved && distance > options.threshold && direction & options.direction;
    },

    attrTest: function(input) {
        return AttrRecognizer.prototype.attrTest.call(this, input) &&
            (this.state & STATE_BEGAN || (!(this.state & STATE_BEGAN) && this.directionTest(input)));
    },

    emit: function(input) {

        this.pX = input.deltaX;
        this.pY = input.deltaY;

        var direction = directionStr(input.direction);

        if (direction) {
            input.additionalEvent = this.options.event + direction;
        }
        this._super.emit.call(this, input);
    }
});

/**
 * Pinch
 * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
 * @constructor
 * @extends AttrRecognizer
 */
function PinchRecognizer() {
    AttrRecognizer.apply(this, arguments);
}

inherit(PinchRecognizer, AttrRecognizer, {
    /**
     * @namespace
     * @memberof PinchRecognizer
     */
    defaults: {
        event: 'pinch',
        threshold: 0,
        pointers: 2
    },

    getTouchAction: function() {
        return [TOUCH_ACTION_NONE];
    },

    attrTest: function(input) {
        return this._super.attrTest.call(this, input) &&
            (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
    },

    emit: function(input) {
        if (input.scale !== 1) {
            var inOut = input.scale < 1 ? 'in' : 'out';
            input.additionalEvent = this.options.event + inOut;
        }
        this._super.emit.call(this, input);
    }
});

/**
 * Press
 * Recognized when the pointer is down for x ms without any movement.
 * @constructor
 * @extends Recognizer
 */
function PressRecognizer() {
    Recognizer.apply(this, arguments);

    this._timer = null;
    this._input = null;
}

inherit(PressRecognizer, Recognizer, {
    /**
     * @namespace
     * @memberof PressRecognizer
     */
    defaults: {
        event: 'press',
        pointers: 1,
        time: 251, // minimal time of the pointer to be pressed
        threshold: 9 // a minimal movement is ok, but keep it low
    },

    getTouchAction: function() {
        return [TOUCH_ACTION_AUTO];
    },

    process: function(input) {
        var options = this.options;
        var validPointers = input.pointers.length === options.pointers;
        var validMovement = input.distance < options.threshold;
        var validTime = input.deltaTime > options.time;

        this._input = input;

        // we only allow little movement
        // and we've reached an end event, so a tap is possible
        if (!validMovement || !validPointers || (input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime)) {
            this.reset();
        } else if (input.eventType & INPUT_START) {
            this.reset();
            this._timer = setTimeoutContext(function() {
                this.state = STATE_RECOGNIZED;
                this.tryEmit();
            }, options.time, this);
        } else if (input.eventType & INPUT_END) {
            return STATE_RECOGNIZED;
        }
        return STATE_FAILED;
    },

    reset: function() {
        clearTimeout(this._timer);
    },

    emit: function(input) {
        if (this.state !== STATE_RECOGNIZED) {
            return;
        }

        if (input && (input.eventType & INPUT_END)) {
            this.manager.emit(this.options.event + 'up', input);
        } else {
            this._input.timeStamp = now();
            this.manager.emit(this.options.event, this._input);
        }
    }
});

/**
 * Rotate
 * Recognized when two or more pointer are moving in a circular motion.
 * @constructor
 * @extends AttrRecognizer
 */
function RotateRecognizer() {
    AttrRecognizer.apply(this, arguments);
}

inherit(RotateRecognizer, AttrRecognizer, {
    /**
     * @namespace
     * @memberof RotateRecognizer
     */
    defaults: {
        event: 'rotate',
        threshold: 0,
        pointers: 2
    },

    getTouchAction: function() {
        return [TOUCH_ACTION_NONE];
    },

    attrTest: function(input) {
        return this._super.attrTest.call(this, input) &&
            (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
    }
});

/**
 * Swipe
 * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
 * @constructor
 * @extends AttrRecognizer
 */
function SwipeRecognizer() {
    AttrRecognizer.apply(this, arguments);
}

inherit(SwipeRecognizer, AttrRecognizer, {
    /**
     * @namespace
     * @memberof SwipeRecognizer
     */
    defaults: {
        event: 'swipe',
        threshold: 10,
        velocity: 0.3,
        direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
        pointers: 1
    },

    getTouchAction: function() {
        return PanRecognizer.prototype.getTouchAction.call(this);
    },

    attrTest: function(input) {
        var direction = this.options.direction;
        var velocity;

        if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
            velocity = input.overallVelocity;
        } else if (direction & DIRECTION_HORIZONTAL) {
            velocity = input.overallVelocityX;
        } else if (direction & DIRECTION_VERTICAL) {
            velocity = input.overallVelocityY;
        }

        return this._super.attrTest.call(this, input) &&
            direction & input.offsetDirection &&
            input.distance > this.options.threshold &&
            input.maxPointers == this.options.pointers &&
            abs(velocity) > this.options.velocity && input.eventType & INPUT_END;
    },

    emit: function(input) {
        var direction = directionStr(input.offsetDirection);
        if (direction) {
            this.manager.emit(this.options.event + direction, input);
        }

        this.manager.emit(this.options.event, input);
    }
});

/**
 * A tap is ecognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
 * between the given interval and position. The delay option can be used to recognize multi-taps without firing
 * a single tap.
 *
 * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
 * multi-taps being recognized.
 * @constructor
 * @extends Recognizer
 */
function TapRecognizer() {
    Recognizer.apply(this, arguments);

    // previous time and center,
    // used for tap counting
    this.pTime = false;
    this.pCenter = false;

    this._timer = null;
    this._input = null;
    this.count = 0;
}

inherit(TapRecognizer, Recognizer, {
    /**
     * @namespace
     * @memberof PinchRecognizer
     */
    defaults: {
        event: 'tap',
        pointers: 1,
        taps: 1,
        interval: 300, // max time between the multi-tap taps
        time: 250, // max time of the pointer to be down (like finger on the screen)
        threshold: 9, // a minimal movement is ok, but keep it low
        posThreshold: 10 // a multi-tap can be a bit off the initial position
    },

    getTouchAction: function() {
        return [TOUCH_ACTION_MANIPULATION];
    },

    process: function(input) {
        var options = this.options;

        var validPointers = input.pointers.length === options.pointers;
        var validMovement = input.distance < options.threshold;
        var validTouchTime = input.deltaTime < options.time;

        this.reset();

        if ((input.eventType & INPUT_START) && (this.count === 0)) {
            return this.failTimeout();
        }

        // we only allow little movement
        // and we've reached an end event, so a tap is possible
        if (validMovement && validTouchTime && validPointers) {
            if (input.eventType != INPUT_END) {
                return this.failTimeout();
            }

            var validInterval = this.pTime ? (input.timeStamp - this.pTime < options.interval) : true;
            var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;

            this.pTime = input.timeStamp;
            this.pCenter = input.center;

            if (!validMultiTap || !validInterval) {
                this.count = 1;
            } else {
                this.count += 1;
            }

            this._input = input;

            // if tap count matches we have recognized it,
            // else it has began recognizing...
            var tapCount = this.count % options.taps;
            if (tapCount === 0) {
                // no failing requirements, immediately trigger the tap event
                // or wait as long as the multitap interval to trigger
                if (!this.hasRequireFailures()) {
                    return STATE_RECOGNIZED;
                } else {
                    this._timer = setTimeoutContext(function() {
                        this.state = STATE_RECOGNIZED;
                        this.tryEmit();
                    }, options.interval, this);
                    return STATE_BEGAN;
                }
            }
        }
        return STATE_FAILED;
    },

    failTimeout: function() {
        this._timer = setTimeoutContext(function() {
            this.state = STATE_FAILED;
        }, this.options.interval, this);
        return STATE_FAILED;
    },

    reset: function() {
        clearTimeout(this._timer);
    },

    emit: function() {
        if (this.state == STATE_RECOGNIZED) {
            this._input.tapCount = this.count;
            this.manager.emit(this.options.event, this._input);
        }
    }
});

/**
 * Simple way to create a manager with a default set of recognizers.
 * @param {HTMLElement} element
 * @param {Object} [options]
 * @constructor
 */
function Hammer(element, options) {
    options = options || {};
    options.recognizers = ifUndefined(options.recognizers, Hammer.defaults.preset);
    return new Manager(element, options);
}

/**
 * @const {string}
 */
Hammer.VERSION = '2.0.7';

/**
 * default settings
 * @namespace
 */
Hammer.defaults = {
    /**
     * set if DOM events are being triggered.
     * But this is slower and unused by simple implementations, so disabled by default.
     * @type {Boolean}
     * @default false
     */
    domEvents: false,

    /**
     * The value for the touchAction property/fallback.
     * When set to `compute` it will magically set the correct value based on the added recognizers.
     * @type {String}
     * @default compute
     */
    touchAction: TOUCH_ACTION_COMPUTE,

    /**
     * @type {Boolean}
     * @default true
     */
    enable: true,

    /**
     * EXPERIMENTAL FEATURE -- can be removed/changed
     * Change the parent input target element.
     * If Null, then it is being set the to main element.
     * @type {Null|EventTarget}
     * @default null
     */
    inputTarget: null,

    /**
     * force an input class
     * @type {Null|Function}
     * @default null
     */
    inputClass: null,

    /**
     * Default recognizer setup when calling `Hammer()`
     * When creating a new Manager these will be skipped.
     * @type {Array}
     */
    preset: [
        // RecognizerClass, options, [recognizeWith, ...], [requireFailure, ...]
        [RotateRecognizer, {enable: false}],
        [PinchRecognizer, {enable: false}, ['rotate']],
        [SwipeRecognizer, {direction: DIRECTION_HORIZONTAL}],
        [PanRecognizer, {direction: DIRECTION_HORIZONTAL}, ['swipe']],
        [TapRecognizer],
        [TapRecognizer, {event: 'doubletap', taps: 2}, ['tap']],
        [PressRecognizer]
    ],

    /**
     * Some CSS properties can be used to improve the working of Hammer.
     * Add them to this method and they will be set when creating a new Manager.
     * @namespace
     */
    cssProps: {
        /**
         * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
         * @type {String}
         * @default 'none'
         */
        userSelect: 'none',

        /**
         * Disable the Windows Phone grippers when pressing an element.
         * @type {String}
         * @default 'none'
         */
        touchSelect: 'none',

        /**
         * Disables the default callout shown when you touch and hold a touch target.
         * On iOS, when you touch and hold a touch target such as a link, Safari displays
         * a callout containing information about the link. This property allows you to disable that callout.
         * @type {String}
         * @default 'none'
         */
        touchCallout: 'none',

        /**
         * Specifies whether zooming is enabled. Used by IE10>
         * @type {String}
         * @default 'none'
         */
        contentZooming: 'none',

        /**
         * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
         * @type {String}
         * @default 'none'
         */
        userDrag: 'none',

        /**
         * Overrides the highlight color shown when the user taps a link or a JavaScript
         * clickable element in iOS. This property obeys the alpha value, if specified.
         * @type {String}
         * @default 'rgba(0,0,0,0)'
         */
        tapHighlightColor: 'rgba(0,0,0,0)'
    }
};

var STOP = 1;
var FORCED_STOP = 2;

/**
 * Manager
 * @param {HTMLElement} element
 * @param {Object} [options]
 * @constructor
 */
function Manager(element, options) {
    this.options = assign({}, Hammer.defaults, options || {});

    this.options.inputTarget = this.options.inputTarget || element;

    this.handlers = {};
    this.session = {};
    this.recognizers = [];
    this.oldCssProps = {};

    this.element = element;
    this.input = createInputInstance(this);
    this.touchAction = new TouchAction(this, this.options.touchAction);

    toggleCssProps(this, true);

    each(this.options.recognizers, function(item) {
        var recognizer = this.add(new (item[0])(item[1]));
        item[2] && recognizer.recognizeWith(item[2]);
        item[3] && recognizer.requireFailure(item[3]);
    }, this);
}

Manager.prototype = {
    /**
     * set options
     * @param {Object} options
     * @returns {Manager}
     */
    set: function(options) {
        assign(this.options, options);

        // Options that need a little more setup
        if (options.touchAction) {
            this.touchAction.update();
        }
        if (options.inputTarget) {
            // Clean up existing event listeners and reinitialize
            this.input.destroy();
            this.input.target = options.inputTarget;
            this.input.init();
        }
        return this;
    },

    /**
     * stop recognizing for this session.
     * This session will be discarded, when a new [input]start event is fired.
     * When forced, the recognizer cycle is stopped immediately.
     * @param {Boolean} [force]
     */
    stop: function(force) {
        this.session.stopped = force ? FORCED_STOP : STOP;
    },

    /**
     * run the recognizers!
     * called by the inputHandler function on every movement of the pointers (touches)
     * it walks through all the recognizers and tries to detect the gesture that is being made
     * @param {Object} inputData
     */
    recognize: function(inputData) {
        var session = this.session;
        if (session.stopped) {
            return;
        }

        // run the touch-action polyfill
        this.touchAction.preventDefaults(inputData);

        var recognizer;
        var recognizers = this.recognizers;

        // this holds the recognizer that is being recognized.
        // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
        // if no recognizer is detecting a thing, it is set to `null`
        var curRecognizer = session.curRecognizer;

        // reset when the last recognizer is recognized
        // or when we're in a new session
        if (!curRecognizer || (curRecognizer && curRecognizer.state & STATE_RECOGNIZED)) {
            curRecognizer = session.curRecognizer = null;
        }

        var i = 0;
        while (i < recognizers.length) {
            recognizer = recognizers[i];

            // find out if we are allowed try to recognize the input for this one.
            // 1.   allow if the session is NOT forced stopped (see the .stop() method)
            // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
            //      that is being recognized.
            // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
            //      this can be setup with the `recognizeWith()` method on the recognizer.
            if (session.stopped !== FORCED_STOP && ( // 1
                    !curRecognizer || recognizer == curRecognizer || // 2
                    recognizer.canRecognizeWith(curRecognizer))) { // 3
                recognizer.recognize(inputData);
            } else {
                recognizer.reset();
            }

            // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
            // current active recognizer. but only if we don't already have an active recognizer
            if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
                curRecognizer = session.curRecognizer = recognizer;
            }
            i++;
        }
    },

    /**
     * get a recognizer by its event name.
     * @param {Recognizer|String} recognizer
     * @returns {Recognizer|Null}
     */
    get: function(recognizer) {
        if (recognizer instanceof Recognizer) {
            return recognizer;
        }

        var recognizers = this.recognizers;
        for (var i = 0; i < recognizers.length; i++) {
            if (recognizers[i].options.event == recognizer) {
                return recognizers[i];
            }
        }
        return null;
    },

    /**
     * add a recognizer to the manager
     * existing recognizers with the same event name will be removed
     * @param {Recognizer} recognizer
     * @returns {Recognizer|Manager}
     */
    add: function(recognizer) {
        if (invokeArrayArg(recognizer, 'add', this)) {
            return this;
        }

        // remove existing
        var existing = this.get(recognizer.options.event);
        if (existing) {
            this.remove(existing);
        }

        this.recognizers.push(recognizer);
        recognizer.manager = this;

        this.touchAction.update();
        return recognizer;
    },

    /**
     * remove a recognizer by name or instance
     * @param {Recognizer|String} recognizer
     * @returns {Manager}
     */
    remove: function(recognizer) {
        if (invokeArrayArg(recognizer, 'remove', this)) {
            return this;
        }

        recognizer = this.get(recognizer);

        // let's make sure this recognizer exists
        if (recognizer) {
            var recognizers = this.recognizers;
            var index = inArray(recognizers, recognizer);

            if (index !== -1) {
                recognizers.splice(index, 1);
                this.touchAction.update();
            }
        }

        return this;
    },

    /**
     * bind event
     * @param {String} events
     * @param {Function} handler
     * @returns {EventEmitter} this
     */
    on: function(events, handler) {
        if (events === undefined) {
            return;
        }
        if (handler === undefined) {
            return;
        }

        var handlers = this.handlers;
        each(splitStr(events), function(event) {
            handlers[event] = handlers[event] || [];
            handlers[event].push(handler);
        });
        return this;
    },

    /**
     * unbind event, leave emit blank to remove all handlers
     * @param {String} events
     * @param {Function} [handler]
     * @returns {EventEmitter} this
     */
    off: function(events, handler) {
        if (events === undefined) {
            return;
        }

        var handlers = this.handlers;
        each(splitStr(events), function(event) {
            if (!handler) {
                delete handlers[event];
            } else {
                handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
            }
        });
        return this;
    },

    /**
     * emit event to the listeners
     * @param {String} event
     * @param {Object} data
     */
    emit: function(event, data) {
        // we also want to trigger dom events
        if (this.options.domEvents) {
            triggerDomEvent(event, data);
        }

        // no handlers, so skip it all
        var handlers = this.handlers[event] && this.handlers[event].slice();
        if (!handlers || !handlers.length) {
            return;
        }

        data.type = event;
        data.preventDefault = function() {
            data.srcEvent.preventDefault();
        };

        var i = 0;
        while (i < handlers.length) {
            handlers[i](data);
            i++;
        }
    },

    /**
     * destroy the manager and unbinds all events
     * it doesn't unbind dom events, that is the user own responsibility
     */
    destroy: function() {
        this.element && toggleCssProps(this, false);

        this.handlers = {};
        this.session = {};
        this.input.destroy();
        this.element = null;
    }
};

/**
 * add/remove the css properties as defined in manager.options.cssProps
 * @param {Manager} manager
 * @param {Boolean} add
 */
function toggleCssProps(manager, add) {
    var element = manager.element;
    if (!element.style) {
        return;
    }
    var prop;
    each(manager.options.cssProps, function(value, name) {
        prop = prefixed(element.style, name);
        if (add) {
            manager.oldCssProps[prop] = element.style[prop];
            element.style[prop] = value;
        } else {
            element.style[prop] = manager.oldCssProps[prop] || '';
        }
    });
    if (!add) {
        manager.oldCssProps = {};
    }
}

/**
 * trigger dom event
 * @param {String} event
 * @param {Object} data
 */
function triggerDomEvent(event, data) {
    var gestureEvent = document.createEvent('Event');
    gestureEvent.initEvent(event, true, true);
    gestureEvent.gesture = data;
    data.target.dispatchEvent(gestureEvent);
}

assign(Hammer, {
    INPUT_START: INPUT_START,
    INPUT_MOVE: INPUT_MOVE,
    INPUT_END: INPUT_END,
    INPUT_CANCEL: INPUT_CANCEL,

    STATE_POSSIBLE: STATE_POSSIBLE,
    STATE_BEGAN: STATE_BEGAN,
    STATE_CHANGED: STATE_CHANGED,
    STATE_ENDED: STATE_ENDED,
    STATE_RECOGNIZED: STATE_RECOGNIZED,
    STATE_CANCELLED: STATE_CANCELLED,
    STATE_FAILED: STATE_FAILED,

    DIRECTION_NONE: DIRECTION_NONE,
    DIRECTION_LEFT: DIRECTION_LEFT,
    DIRECTION_RIGHT: DIRECTION_RIGHT,
    DIRECTION_UP: DIRECTION_UP,
    DIRECTION_DOWN: DIRECTION_DOWN,
    DIRECTION_HORIZONTAL: DIRECTION_HORIZONTAL,
    DIRECTION_VERTICAL: DIRECTION_VERTICAL,
    DIRECTION_ALL: DIRECTION_ALL,

    Manager: Manager,
    Input: Input,
    TouchAction: TouchAction,

    TouchInput: TouchInput,
    MouseInput: MouseInput,
    PointerEventInput: PointerEventInput,
    TouchMouseInput: TouchMouseInput,
    SingleTouchInput: SingleTouchInput,

    Recognizer: Recognizer,
    AttrRecognizer: AttrRecognizer,
    Tap: TapRecognizer,
    Pan: PanRecognizer,
    Swipe: SwipeRecognizer,
    Pinch: PinchRecognizer,
    Rotate: RotateRecognizer,
    Press: PressRecognizer,

    on: addEventListeners,
    off: removeEventListeners,
    each: each,
    merge: merge,
    extend: extend,
    assign: assign,
    inherit: inherit,
    bindFn: bindFn,
    prefixed: prefixed
});

// this prevents errors when Hammer is loaded in the presence of an AMD
//  style loader but by script tag, not by the loader.
var freeGlobal = (typeof window !== 'undefined' ? window : (typeof self !== 'undefined' ? self : {})); // jshint ignore:line
freeGlobal.Hammer = Hammer;

if (true) {
    !(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {
        return Hammer;
    }).call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
} else if (typeof module != 'undefined' && module.exports) {
    module.exports = Hammer;
} else {
    window[exportName] = Hammer;
}

})(window, document, 'Hammer');


/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// English
exports['en'] = {
  edit: 'Edit',
  del: 'Delete selected',
  back: 'Back',
  addNode: 'Add Node',
  addEdge: 'Add Edge',
  editNode: 'Edit Node',
  editEdge: 'Edit Edge',
  addDescription: 'Click in an empty space to place a new node.',
  edgeDescription: 'Click on a node and drag the edge to another node to connect them.',
  editEdgeDescription: 'Click on the control points and drag them to a node to connect to it.',
  createEdgeError: 'Cannot link edges to a cluster.',
  deleteClusterError: 'Clusters cannot be deleted.',
  editClusterError: 'Clusters cannot be edited.'
};
exports['en_EN'] = exports['en'];
exports['en_US'] = exports['en'];

// German
exports['de'] = {
  edit: 'Editieren',
  del: 'L\xF6sche Auswahl',
  back: 'Zur\xFCck',
  addNode: 'Knoten hinzuf\xFCgen',
  addEdge: 'Kante hinzuf\xFCgen',
  editNode: 'Knoten editieren',
  editEdge: 'Kante editieren',
  addDescription: 'Klicke auf eine freie Stelle, um einen neuen Knoten zu plazieren.',
  edgeDescription: 'Klicke auf einen Knoten und ziehe die Kante zu einem anderen Knoten, um diese zu verbinden.',
  editEdgeDescription: 'Klicke auf die Verbindungspunkte und ziehe diese auf einen Knoten, um sie zu verbinden.',
  createEdgeError: 'Es ist nicht m\xF6glich, Kanten mit Clustern zu verbinden.',
  deleteClusterError: 'Cluster k\xF6nnen nicht gel\xF6scht werden.',
  editClusterError: 'Cluster k\xF6nnen nicht editiert werden.'
};
exports['de_DE'] = exports['de'];

// Spanish
exports['es'] = {
  edit: 'Editar',
  del: 'Eliminar selecci\xF3n',
  back: '\xC1tras',
  addNode: 'A\xF1adir nodo',
  addEdge: 'A\xF1adir arista',
  editNode: 'Editar nodo',
  editEdge: 'Editar arista',
  addDescription: 'Haga clic en un lugar vac\xEDo para colocar un nuevo nodo.',
  edgeDescription: 'Haga clic en un nodo y arrastre la arista hacia otro nodo para conectarlos.',
  editEdgeDescription: 'Haga clic en un punto de control y arrastrelo a un nodo para conectarlo.',
  createEdgeError: 'No se puede conectar una arista a un grupo.',
  deleteClusterError: 'No es posible eliminar grupos.',
  editClusterError: 'No es posible editar grupos.'
};
exports['es_ES'] = exports['es'];

//Italiano
exports['it'] = {
  edit: 'Modifica',
  del: 'Cancella la selezione',
  back: 'Indietro',
  addNode: 'Aggiungi un nodo',
  addEdge: 'Aggiungi un vertice',
  editNode: 'Modifica il nodo',
  editEdge: 'Modifica il vertice',
  addDescription: 'Clicca per aggiungere un nuovo nodo',
  edgeDescription: 'Clicca su un nodo e trascinalo ad un altro nodo per connetterli.',
  editEdgeDescription: 'Clicca sui Punti di controllo e trascinali ad un nodo per connetterli.',
  createEdgeError: 'Non si possono collegare vertici ad un cluster',
  deleteClusterError: 'I cluster non possono essere cancellati',
  editClusterError: 'I clusters non possono essere modificati.'
};
exports['it_IT'] = exports['it'];

// Dutch
exports['nl'] = {
  edit: 'Wijzigen',
  del: 'Selectie verwijderen',
  back: 'Terug',
  addNode: 'Node toevoegen',
  addEdge: 'Link toevoegen',
  editNode: 'Node wijzigen',
  editEdge: 'Link wijzigen',
  addDescription: 'Klik op een leeg gebied om een nieuwe node te maken.',
  edgeDescription: 'Klik op een node en sleep de link naar een andere node om ze te verbinden.',
  editEdgeDescription: 'Klik op de verbindingspunten en sleep ze naar een node om daarmee te verbinden.',
  createEdgeError: 'Kan geen link maken naar een cluster.',
  deleteClusterError: 'Clusters kunnen niet worden verwijderd.',
  editClusterError: 'Clusters kunnen niet worden aangepast.'
};
exports['nl_NL'] = exports['nl'];
exports['nl_BE'] = exports['nl'];

// Portuguese Brazil
exports['pt-br'] = {
  edit: 'Editar',
  del: 'Remover selecionado',
  back: 'Voltar',
  addNode: 'Adicionar nó',
  addEdge: 'Adicionar aresta',
  editNode: 'Editar nó',
  editEdge: 'Editar aresta',
  addDescription: 'Clique em um espaço em branco para adicionar um novo nó',
  edgeDescription: 'Clique em um nó e arraste a aresta até outro nó para conectá-los',
  editEdgeDescription: 'Clique nos pontos de controle e os arraste para um nó para conectá-los',
  createEdgeError: 'Não foi possível linkar arestas a um cluster.',
  deleteClusterError: 'Clusters não puderam ser removidos.',
  editClusterError: 'Clusters não puderam ser editados.'
};
exports['pt-BR'] = exports['pt-br'];
exports['pt_BR'] = exports['pt-br'];
exports['pt_br'] = exports['pt-br'];

// Russian
exports['ru'] = {
  edit: 'Редактировать',
  del: 'Удалить выбранное',
  back: 'Назад',
  addNode: 'Добавить узел',
  addEdge: 'Добавить ребро',
  editNode: 'Редактировать узел',
  editEdge: 'Редактировать ребро',
  addDescription: 'Кликните в свободное место, чтобы добавить новый узел.',
  edgeDescription: 'Кликните на узел и протяните ребро к другому узлу, чтобы соединить их.',
  editEdgeDescription: 'Кликните на контрольные точки и перетащите их в узел, чтобы подключиться к нему.',
  createEdgeError: 'Невозможно соединить ребра в кластер.',
  deleteClusterError: 'Кластеры не могут быть удалены',
  editClusterError: 'Кластеры недоступны для редактирования.'
};
exports['ru_RU'] = exports['ru'];

// Chinese
exports['cn'] = {
  edit: '编辑',
  del: '删除选定',
  back: '返回',
  addNode: '添加节点',
  addEdge: '添加连接线',
  editNode: '编辑节点',
  editEdge: '编辑连接线',
  addDescription: '单击空白处放置新节点。',
  edgeDescription: '单击某个节点并将该连接线拖动到另一个节点以连接它们。',
  editEdgeDescription: '单击控制节点并将它们拖到节点上连接。',
  createEdgeError: '无法将连接线连接到群集。',
  deleteClusterError: '无法删除群集。',
  editClusterError: '无法编辑群集。'
};
exports['zh_CN'] = exports['cn'];

// Ukrainian
exports['uk'] = {
  edit: 'Редагувати',
  del: 'Видалити обране',
  back: 'Назад',
  addNode: 'Додати вузол',
  addEdge: 'Додати край',
  editNode: 'Редагувати вузол',
  editEdge: 'Редагувати край',
  addDescription: 'Kлікніть на вільне місце, щоб додати новий вузол.',
  edgeDescription: "Клікніть на вузол і перетягніть край до іншого вузла, щоб їх з'єднати.",
  editEdgeDescription: 'Клікніть на контрольні точки і перетягніть їх у вузол, щоб підключитися до нього.',
  createEdgeError: "Не можливо об'єднати краї в групу.",
  deleteClusterError: 'Групи не можуть бути видалені.',
  editClusterError: 'Групи недоступні для редагування.'
};
exports['uk_UA'] = exports['uk'];

// French
exports['fr'] = {
  edit: 'Editer',
  del: 'Effacer la selection',
  back: 'Retour',
  addNode: 'Ajouter un noeud',
  addEdge: 'Ajouter un lien',
  editNode: 'Editer le noeud',
  editEdge: 'Editer le lien',
  addDescription: 'Cliquez dans un endroit vide pour placer un noeud.',
  edgeDescription: 'Cliquez sur un noeud et glissez le lien vers un autre noeud pour les connecter.',
  editEdgeDescription: 'Cliquez sur les points de contrôle et glissez-les pour connecter un noeud.',
  createEdgeError: 'Impossible de créer un lien vers un cluster.',
  deleteClusterError: 'Les clusters ne peuvent pas être éffacés.',
  editClusterError: 'Les clusters ne peuvent pas être édites.'
};
exports['fr_FR'] = exports['fr'];

/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(131), __esModule: true };

/***/ }),
/* 131 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(132);
var $Object = __webpack_require__(6).Object;
module.exports = function defineProperty(it, key, desc) {
  return $Object.defineProperty(it, key, desc);
};


/***/ }),
/* 132 */
/***/ (function(module, exports, __webpack_require__) {

var $export = __webpack_require__(11);
// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
$export($export.S + $export.F * !__webpack_require__(13), 'Object', { defineProperty: __webpack_require__(12).f });


/***/ }),
/* 133 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Associates a canvas to a given image, containing a number of renderings
 * of the image at various sizes.
 *
 * This technique is known as 'mipmapping'.
 *
 * NOTE: Images can also be of type 'data:svg+xml`. This code also works
 *       for svg, but the mipmapping may not be necessary.
 *
 * @param {Image} image
 */
var CachedImage = function () {
  /**
   * @ignore
   */
  function CachedImage() {
    (0, _classCallCheck3['default'])(this, CachedImage);

    // eslint-disable-line no-unused-vars
    this.NUM_ITERATIONS = 4; // Number of items in the coordinates array

    this.image = new Image();
    this.canvas = document.createElement('canvas');
  }

  /**
   * Called when the image has been successfully loaded.
   */


  (0, _createClass3['default'])(CachedImage, [{
    key: 'init',
    value: function init() {
      if (this.initialized()) return;

      this.src = this.image.src; // For same interface with Image
      var w = this.image.width;
      var h = this.image.height;

      // Ease external access
      this.width = w;
      this.height = h;

      var h2 = Math.floor(h / 2);
      var h4 = Math.floor(h / 4);
      var h8 = Math.floor(h / 8);
      var h16 = Math.floor(h / 16);

      var w2 = Math.floor(w / 2);
      var w4 = Math.floor(w / 4);
      var w8 = Math.floor(w / 8);
      var w16 = Math.floor(w / 16);

      // Make canvas as small as possible
      this.canvas.width = 3 * w4;
      this.canvas.height = h2;

      // Coordinates and sizes of images contained in the canvas
      // Values per row:  [top x, left y, width, height]

      this.coordinates = [[0, 0, w2, h2], [w2, 0, w4, h4], [w2, h4, w8, h8], [5 * w8, h4, w16, h16]];

      this._fillMipMap();
    }

    /**
     * @return {Boolean} true if init() has been called, false otherwise.
     */

  }, {
    key: 'initialized',
    value: function initialized() {
      return this.coordinates !== undefined;
    }

    /**
     * Redraw main image in various sizes to the context.
     *
     * The rationale behind this is to reduce artefacts due to interpolation
     * at differing zoom levels.
     *
     * Source: http://stackoverflow.com/q/18761404/1223531
     *
     * This methods takes the resizing out of the drawing loop, in order to
     * reduce performance overhead.
     *
     * TODO: The code assumes that a 2D context can always be gotten. This is
     *       not necessarily true! OTOH, if not true then usage of this class
     *       is senseless.
     *
     * @private
     */

  }, {
    key: '_fillMipMap',
    value: function _fillMipMap() {
      var ctx = this.canvas.getContext('2d');

      // First zoom-level comes from the image
      var to = this.coordinates[0];
      ctx.drawImage(this.image, to[0], to[1], to[2], to[3]);

      // The rest are copy actions internal to the canvas/context
      for (var iterations = 1; iterations < this.NUM_ITERATIONS; iterations++) {
        var from = this.coordinates[iterations - 1];
        var _to = this.coordinates[iterations];

        ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], _to[0], _to[1], _to[2], _to[3]);
      }
    }

    /**
     * Draw the image, using the mipmap if necessary.
     *
     * MipMap is only used if param factor > 2; otherwise, original bitmap
     * is resized. This is also used to skip mipmap usage, e.g. by setting factor = 1
     *
     * Credits to 'Alex de Mulder' for original implementation.
     *
     * @param {CanvasRenderingContext2D} ctx  context on which to draw zoomed image
     * @param {Float} factor scale factor at which to draw
     * @param {number} left
     * @param {number} top
     * @param {number} width
     * @param {number} height
     */

  }, {
    key: 'drawImageAtPosition',
    value: function drawImageAtPosition(ctx, factor, left, top, width, height) {
      if (!this.initialized()) return; //can't draw image yet not intialized

      if (factor > 2) {
        // Determine which zoomed image to use
        factor *= 0.5;
        var iterations = 0;
        while (factor > 2 && iterations < this.NUM_ITERATIONS) {
          factor *= 0.5;
          iterations += 1;
        }

        if (iterations >= this.NUM_ITERATIONS) {
          iterations = this.NUM_ITERATIONS - 1;
        }
        //console.log("iterations: " + iterations);

        var from = this.coordinates[iterations];
        ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], left, top, width, height);
      } else {
        // Draw image directly
        ctx.drawImage(this.image, left, top, width, height);
      }
    }
  }]);
  return CachedImage;
}();

exports['default'] = CachedImage;

/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);

/**
 * This class can store groups and options specific for groups.
 */

var Groups = function () {
  /**
   * @ignore
   */
  function Groups() {
    (0, _classCallCheck3['default'])(this, Groups);

    this.clear();
    this.defaultIndex = 0;
    this.groupsArray = [];
    this.groupIndex = 0;

    this.defaultGroups = [{
      border: '#2B7CE9',
      background: '#97C2FC',
      highlight: { border: '#2B7CE9', background: '#D2E5FF' },
      hover: { border: '#2B7CE9', background: '#D2E5FF' }
    }, // 0: blue
    {
      border: '#FFA500',
      background: '#FFFF00',
      highlight: { border: '#FFA500', background: '#FFFFA3' },
      hover: { border: '#FFA500', background: '#FFFFA3' }
    }, // 1: yellow
    {
      border: '#FA0A10',
      background: '#FB7E81',
      highlight: { border: '#FA0A10', background: '#FFAFB1' },
      hover: { border: '#FA0A10', background: '#FFAFB1' }
    }, // 2: red
    {
      border: '#41A906',
      background: '#7BE141',
      highlight: { border: '#41A906', background: '#A1EC76' },
      hover: { border: '#41A906', background: '#A1EC76' }
    }, // 3: green
    {
      border: '#E129F0',
      background: '#EB7DF4',
      highlight: { border: '#E129F0', background: '#F0B3F5' },
      hover: { border: '#E129F0', background: '#F0B3F5' }
    }, // 4: magenta
    {
      border: '#7C29F0',
      background: '#AD85E4',
      highlight: { border: '#7C29F0', background: '#D3BDF0' },
      hover: { border: '#7C29F0', background: '#D3BDF0' }
    }, // 5: purple
    {
      border: '#C37F00',
      background: '#FFA807',
      highlight: { border: '#C37F00', background: '#FFCA66' },
      hover: { border: '#C37F00', background: '#FFCA66' }
    }, // 6: orange
    {
      border: '#4220FB',
      background: '#6E6EFD',
      highlight: { border: '#4220FB', background: '#9B9BFD' },
      hover: { border: '#4220FB', background: '#9B9BFD' }
    }, // 7: darkblue
    {
      border: '#FD5A77',
      background: '#FFC0CB',
      highlight: { border: '#FD5A77', background: '#FFD1D9' },
      hover: { border: '#FD5A77', background: '#FFD1D9' }
    }, // 8: pink
    {
      border: '#4AD63A',
      background: '#C2FABC',
      highlight: { border: '#4AD63A', background: '#E6FFE3' },
      hover: { border: '#4AD63A', background: '#E6FFE3' }
    }, // 9: mint

    {
      border: '#990000',
      background: '#EE0000',
      highlight: { border: '#BB0000', background: '#FF3333' },
      hover: { border: '#BB0000', background: '#FF3333' }
    }, // 10:bright red

    {
      border: '#FF6000',
      background: '#FF6000',
      highlight: { border: '#FF6000', background: '#FF6000' },
      hover: { border: '#FF6000', background: '#FF6000' }
    }, // 12: real orange
    {
      border: '#97C2FC',
      background: '#2B7CE9',
      highlight: { border: '#D2E5FF', background: '#2B7CE9' },
      hover: { border: '#D2E5FF', background: '#2B7CE9' }
    }, // 13: blue
    {
      border: '#399605',
      background: '#255C03',
      highlight: { border: '#399605', background: '#255C03' },
      hover: { border: '#399605', background: '#255C03' }
    }, // 14: green
    {
      border: '#B70054',
      background: '#FF007E',
      highlight: { border: '#B70054', background: '#FF007E' },
      hover: { border: '#B70054', background: '#FF007E' }
    }, // 15: magenta
    {
      border: '#AD85E4',
      background: '#7C29F0',
      highlight: { border: '#D3BDF0', background: '#7C29F0' },
      hover: { border: '#D3BDF0', background: '#7C29F0' }
    }, // 16: purple
    {
      border: '#4557FA',
      background: '#000EA1',
      highlight: { border: '#6E6EFD', background: '#000EA1' },
      hover: { border: '#6E6EFD', background: '#000EA1' }
    }, // 17: darkblue
    {
      border: '#FFC0CB',
      background: '#FD5A77',
      highlight: { border: '#FFD1D9', background: '#FD5A77' },
      hover: { border: '#FFD1D9', background: '#FD5A77' }
    }, // 18: pink
    {
      border: '#C2FABC',
      background: '#74D66A',
      highlight: { border: '#E6FFE3', background: '#74D66A' },
      hover: { border: '#E6FFE3', background: '#74D66A' }
    }, // 19: mint

    {
      border: '#EE0000',
      background: '#990000',
      highlight: { border: '#FF3333', background: '#BB0000' },
      hover: { border: '#FF3333', background: '#BB0000' } // 20:bright red
    }];

    this.options = {};
    this.defaultOptions = {
      useDefaultGroups: true
    };
    util.extend(this.options, this.defaultOptions);
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3['default'])(Groups, [{
    key: 'setOptions',
    value: function setOptions(options) {
      var optionFields = ['useDefaultGroups'];

      if (options !== undefined) {
        for (var groupName in options) {
          if (options.hasOwnProperty(groupName)) {
            if (optionFields.indexOf(groupName) === -1) {
              var group = options[groupName];
              this.add(groupName, group);
            }
          }
        }
      }
    }

    /**
     * Clear all groups
     */

  }, {
    key: 'clear',
    value: function clear() {
      this.groups = {};
      this.groupsArray = [];
    }

    /**
     * Get group options of a groupname.
     * If groupname is not found, a new group may be created.
     *
     * @param {*}       groupname     Can be a number, string, Date, etc.
     * @param {boolean} [shouldCreate=true] If true, create a new group
     * @return {Object} The found or created group
     */

  }, {
    key: 'get',
    value: function get(groupname) {
      var shouldCreate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      var group = this.groups[groupname];

      if (group === undefined && shouldCreate) {
        if (this.options.useDefaultGroups === false && this.groupsArray.length > 0) {
          // create new group
          var index = this.groupIndex % this.groupsArray.length;
          this.groupIndex++;
          group = {};
          group.color = this.groups[this.groupsArray[index]];
          this.groups[groupname] = group;
        } else {
          // create new group
          var _index = this.defaultIndex % this.defaultGroups.length;
          this.defaultIndex++;
          group = {};
          group.color = this.defaultGroups[_index];
          this.groups[groupname] = group;
        }
      }

      return group;
    }

    /**
     * Add a custom group style
     * @param {string} groupName
     * @param {Object} style       An object containing borderColor,
     *                             backgroundColor, etc.
     * @return {Object} group      The created group object
     */

  }, {
    key: 'add',
    value: function add(groupName, style) {
      this.groups[groupName] = style;
      this.groupsArray.push(groupName);
      return style;
    }
  }]);
  return Groups;
}();

exports['default'] = Groups;

/***/ }),
/* 135 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);
var DataSet = __webpack_require__(33);
var DataView = __webpack_require__(51);
var Node = __webpack_require__(34)['default'];

/**
 * Handler for Nodes
 */

var NodesHandler = function () {
  /**
   * @param {Object} body
   * @param {Images} images
   * @param {Array.<Group>} groups
   * @param {LayoutEngine} layoutEngine
   */
  function NodesHandler(body, images, groups, layoutEngine) {
    var _this = this;

    (0, _classCallCheck3['default'])(this, NodesHandler);

    this.body = body;
    this.images = images;
    this.groups = groups;
    this.layoutEngine = layoutEngine;

    // create the node API in the body container
    this.body.functions.createNode = this.create.bind(this);

    this.nodesListeners = {
      add: function add(event, params) {
        _this.add(params.items);
      },
      update: function update(event, params) {
        _this.update(params.items, params.data, params.oldData);
      },
      remove: function remove(event, params) {
        _this.remove(params.items);
      }
    };

    this.defaultOptions = {
      borderWidth: 1,
      borderWidthSelected: 2,
      brokenImage: undefined,
      color: {
        border: '#2B7CE9',
        background: '#97C2FC',
        highlight: {
          border: '#2B7CE9',
          background: '#D2E5FF'
        },
        hover: {
          border: '#2B7CE9',
          background: '#D2E5FF'
        }
      },
      fixed: {
        x: false,
        y: false
      },
      font: {
        color: '#343434',
        size: 14, // px
        face: 'arial',
        background: 'none',
        strokeWidth: 0, // px
        strokeColor: '#ffffff',
        align: 'center',
        vadjust: 0,
        multi: false,
        bold: {
          mod: 'bold'
        },
        boldital: {
          mod: 'bold italic'
        },
        ital: {
          mod: 'italic'
        },
        mono: {
          mod: '',
          size: 15, // px
          face: 'monospace',
          vadjust: 2
        }
      },
      group: undefined,
      hidden: false,
      icon: {
        face: 'FontAwesome', //'FontAwesome',
        code: undefined, //'\uf007',
        size: 50, //50,
        color: '#2B7CE9' //'#aa00ff'
      },
      image: undefined, // --> URL
      label: undefined,
      labelHighlightBold: true,
      level: undefined,
      margin: {
        top: 5,
        right: 5,
        bottom: 5,
        left: 5
      },
      mass: 1,
      physics: true,
      scaling: {
        min: 10,
        max: 30,
        label: {
          enabled: false,
          min: 14,
          max: 30,
          maxVisible: 30,
          drawThreshold: 5
        },
        customScalingFunction: function customScalingFunction(min, max, total, value) {
          if (max === min) {
            return 0.5;
          } else {
            var scale = 1 / (max - min);
            return Math.max(0, (value - min) * scale);
          }
        }
      },
      shadow: {
        enabled: false,
        color: 'rgba(0,0,0,0.5)',
        size: 10,
        x: 5,
        y: 5
      },
      shape: 'ellipse',
      shapeProperties: {
        borderDashes: false, // only for borders
        borderRadius: 6, // only for box shape
        interpolation: true, // only for image and circularImage shapes
        useImageSize: false, // only for image and circularImage shapes
        useBorderWithImage: false // only for image shape
      },
      size: 25,
      title: undefined,
      value: undefined,
      x: undefined,
      y: undefined

      // Protect from idiocy
    };if (this.defaultOptions.mass <= 0) {
      throw 'Internal error: mass in defaultOptions of NodesHandler may not be zero or negative';
    }

    this.options = util.bridgeObject(this.defaultOptions);

    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */


  (0, _createClass3['default'])(NodesHandler, [{
    key: 'bindEventListeners',
    value: function bindEventListeners() {
      var _this2 = this;

      // refresh the nodes. Used when reverting from hierarchical layout
      this.body.emitter.on('refreshNodes', this.refresh.bind(this));
      this.body.emitter.on('refresh', this.refresh.bind(this));
      this.body.emitter.on('destroy', function () {
        util.forEach(_this2.nodesListeners, function (callback, event) {
          if (_this2.body.data.nodes) _this2.body.data.nodes.off(event, callback);
        });
        delete _this2.body.functions.createNode;
        delete _this2.nodesListeners.add;
        delete _this2.nodesListeners.update;
        delete _this2.nodesListeners.remove;
        delete _this2.nodesListeners;
      });
    }

    /**
     *
     * @param {Object} options
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      if (options !== undefined) {
        Node.parseOptions(this.options, options);

        // update the shape in all nodes
        if (options.shape !== undefined) {
          for (var nodeId in this.body.nodes) {
            if (this.body.nodes.hasOwnProperty(nodeId)) {
              this.body.nodes[nodeId].updateShape();
            }
          }
        }

        // update the font in all nodes
        if (options.font !== undefined) {
          for (var _nodeId in this.body.nodes) {
            if (this.body.nodes.hasOwnProperty(_nodeId)) {
              this.body.nodes[_nodeId].updateLabelModule();
              this.body.nodes[_nodeId].needsRefresh();
            }
          }
        }

        // update the shape size in all nodes
        if (options.size !== undefined) {
          for (var _nodeId2 in this.body.nodes) {
            if (this.body.nodes.hasOwnProperty(_nodeId2)) {
              this.body.nodes[_nodeId2].needsRefresh();
            }
          }
        }

        // update the state of the variables if needed
        if (options.hidden !== undefined || options.physics !== undefined) {
          this.body.emitter.emit('_dataChanged');
        }
      }
    }

    /**
     * Set a data set with nodes for the network
     * @param {Array | DataSet | DataView} nodes         The data containing the nodes.
     * @param {boolean} [doNotEmit=false]
     * @private
     */

  }, {
    key: 'setData',
    value: function setData(nodes) {
      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      var oldNodesData = this.body.data.nodes;

      if (nodes instanceof DataSet || nodes instanceof DataView) {
        this.body.data.nodes = nodes;
      } else if (Array.isArray(nodes)) {
        this.body.data.nodes = new DataSet();
        this.body.data.nodes.add(nodes);
      } else if (!nodes) {
        this.body.data.nodes = new DataSet();
      } else {
        throw new TypeError('Array or DataSet expected');
      }

      if (oldNodesData) {
        // unsubscribe from old dataset
        util.forEach(this.nodesListeners, function (callback, event) {
          oldNodesData.off(event, callback);
        });
      }

      // remove drawn nodes
      this.body.nodes = {};

      if (this.body.data.nodes) {
        // subscribe to new dataset
        var me = this;
        util.forEach(this.nodesListeners, function (callback, event) {
          me.body.data.nodes.on(event, callback);
        });

        // draw all new nodes
        var ids = this.body.data.nodes.getIds();
        this.add(ids, true);
      }

      if (doNotEmit === false) {
        this.body.emitter.emit('_dataChanged');
      }
    }

    /**
     * Add nodes
     * @param {number[] | string[]} ids
     * @param {boolean} [doNotEmit=false]
     * @private
     */

  }, {
    key: 'add',
    value: function add(ids) {
      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      var id = void 0;
      var newNodes = [];
      for (var i = 0; i < ids.length; i++) {
        id = ids[i];
        var properties = this.body.data.nodes.get(id);
        var node = this.create(properties);
        newNodes.push(node);
        this.body.nodes[id] = node; // note: this may replace an existing node
      }

      this.layoutEngine.positionInitially(newNodes);

      if (doNotEmit === false) {
        this.body.emitter.emit('_dataChanged');
      }
    }

    /**
     * Update existing nodes, or create them when not yet existing
     * @param {number[] | string[]} ids id's of changed nodes
     * @param {Array} changedData array with changed data
     * @param {Array|undefined} oldData optional; array with previous data
     * @private
     */

  }, {
    key: 'update',
    value: function update(ids, changedData, oldData) {
      var nodes = this.body.nodes;
      var dataChanged = false;
      for (var i = 0; i < ids.length; i++) {
        var id = ids[i];
        var node = nodes[id];
        var data = changedData[i];
        if (node !== undefined) {
          // update node
          if (node.setOptions(data)) {
            dataChanged = true;
          }
        } else {
          dataChanged = true;
          // create node
          node = this.create(data);
          nodes[id] = node;
        }
      }

      if (!dataChanged && oldData !== undefined) {
        // Check for any changes which should trigger a layout recalculation
        // For now, this is just 'level' for hierarchical layout
        // Assumption: old and new data arranged in same order; at time of writing, this holds.
        dataChanged = changedData.some(function (newValue, index) {
          var oldValue = oldData[index];
          return oldValue && oldValue.level !== newValue.level;
        });
      }

      if (dataChanged === true) {
        this.body.emitter.emit('_dataChanged');
      } else {
        this.body.emitter.emit('_dataUpdated');
      }
    }

    /**
     * Remove existing nodes. If nodes do not exist, the method will just ignore it.
     * @param {number[] | string[]} ids
     * @private
     */

  }, {
    key: 'remove',
    value: function remove(ids) {
      var nodes = this.body.nodes;

      for (var i = 0; i < ids.length; i++) {
        var id = ids[i];
        delete nodes[id];
      }

      this.body.emitter.emit('_dataChanged');
    }

    /**
     * create a node
     * @param {Object} properties
     * @param {class} [constructorClass=Node.default]
     * @returns {*}
     */

  }, {
    key: 'create',
    value: function create(properties) {
      var constructorClass = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Node;

      return new constructorClass(properties, this.body, this.images, this.groups, this.options, this.defaultOptions);
    }

    /**
     *
     * @param {boolean} [clearPositions=false]
     */

  }, {
    key: 'refresh',
    value: function refresh() {
      var _this3 = this;

      var clearPositions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

      util.forEach(this.body.nodes, function (node, nodeId) {
        var data = _this3.body.data.nodes.get(nodeId);
        if (data !== undefined) {
          if (clearPositions === true) {
            node.setOptions({ x: null, y: null });
          }
          node.setOptions({ fixed: false });
          node.setOptions(data);
        }
      });
    }

    /**
     * Returns the positions of the nodes.
     * @param {Array.<Node.id>|String} [ids]  --> optional, can be array of nodeIds, can be string
     * @returns {{}}
     */

  }, {
    key: 'getPositions',
    value: function getPositions(ids) {
      var dataArray = {};
      if (ids !== undefined) {
        if (Array.isArray(ids) === true) {
          for (var i = 0; i < ids.length; i++) {
            if (this.body.nodes[ids[i]] !== undefined) {
              var node = this.body.nodes[ids[i]];
              dataArray[ids[i]] = { x: Math.round(node.x), y: Math.round(node.y) };
            }
          }
        } else {
          if (this.body.nodes[ids] !== undefined) {
            var _node = this.body.nodes[ids];
            dataArray[ids] = { x: Math.round(_node.x), y: Math.round(_node.y) };
          }
        }
      } else {
        for (var _i = 0; _i < this.body.nodeIndices.length; _i++) {
          var _node2 = this.body.nodes[this.body.nodeIndices[_i]];
          dataArray[this.body.nodeIndices[_i]] = {
            x: Math.round(_node2.x),
            y: Math.round(_node2.y)
          };
        }
      }
      return dataArray;
    }

    /**
     * Load the XY positions of the nodes into the dataset.
     */

  }, {
    key: 'storePositions',
    value: function storePositions() {
      // todo: add support for clusters and hierarchical.
      var dataArray = [];
      var dataset = this.body.data.nodes.getDataSet();

      for (var nodeId in dataset._data) {
        if (dataset._data.hasOwnProperty(nodeId)) {
          var node = this.body.nodes[nodeId];
          if (dataset._data[nodeId].x != Math.round(node.x) || dataset._data[nodeId].y != Math.round(node.y)) {
            dataArray.push({
              id: node.id,
              x: Math.round(node.x),
              y: Math.round(node.y)
            });
          }
        }
      }
      dataset.update(dataArray);
    }

    /**
     * get the bounding box of a node.
     * @param {Node.id} nodeId
     * @returns {j|*}
     */

  }, {
    key: 'getBoundingBox',
    value: function getBoundingBox(nodeId) {
      if (this.body.nodes[nodeId] !== undefined) {
        return this.body.nodes[nodeId].shape.boundingBox;
      }
    }

    /**
     * Get the Ids of nodes connected to this node.
     * @param {Node.id} nodeId
     * @param {'to'|'from'|undefined} direction values 'from' and 'to' select respectively parent and child nodes only.
     *                                          Any other value returns both parent and child nodes.
     * @returns {Array}
     */

  }, {
    key: 'getConnectedNodes',
    value: function getConnectedNodes(nodeId, direction) {
      var nodeList = [];
      if (this.body.nodes[nodeId] !== undefined) {
        var node = this.body.nodes[nodeId];
        var nodeObj = {}; // used to quickly check if node already exists
        for (var i = 0; i < node.edges.length; i++) {
          var edge = node.edges[i];
          if (direction !== 'to' && edge.toId == node.id) {
            // these are double equals since ids can be numeric or string
            if (nodeObj[edge.fromId] === undefined) {
              nodeList.push(edge.fromId);
              nodeObj[edge.fromId] = true;
            }
          } else if (direction !== 'from' && edge.fromId == node.id) {
            // these are double equals since ids can be numeric or string
            if (nodeObj[edge.toId] === undefined) {
              nodeList.push(edge.toId);
              nodeObj[edge.toId] = true;
            }
          }
        }
      }
      return nodeList;
    }

    /**
     * Get the ids of the edges connected to this node.
     * @param {Node.id} nodeId
     * @returns {*}
     */

  }, {
    key: 'getConnectedEdges',
    value: function getConnectedEdges(nodeId) {
      var edgeList = [];
      if (this.body.nodes[nodeId] !== undefined) {
        var node = this.body.nodes[nodeId];
        for (var i = 0; i < node.edges.length; i++) {
          edgeList.push(node.edges[i].id);
        }
      } else {
        console.log('NodeId provided for getConnectedEdges does not exist. Provided: ', nodeId);
      }
      return edgeList;
    }

    /**
     * Move a node.
     *
     * @param {Node.id} nodeId
     * @param {number} x
     * @param {number} y
     */

  }, {
    key: 'moveNode',
    value: function moveNode(nodeId, x, y) {
      var _this4 = this;

      if (this.body.nodes[nodeId] !== undefined) {
        this.body.nodes[nodeId].x = Number(x);
        this.body.nodes[nodeId].y = Number(y);
        setTimeout(function () {
          _this4.body.emitter.emit('startSimulation');
        }, 0);
      } else {
        console.log('Node id supplied to moveNode does not exist. Provided: ', nodeId);
      }
    }
  }]);
  return NodesHandler;
}();

exports['default'] = NodesHandler;

/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(137), __esModule: true };

/***/ }),
/* 137 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(37);
__webpack_require__(47);
module.exports = __webpack_require__(138);


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

var classof = __webpack_require__(67);
var ITERATOR = __webpack_require__(8)('iterator');
var Iterators = __webpack_require__(25);
module.exports = __webpack_require__(6).isIterable = function (it) {
  var O = Object(it);
  return O[ITERATOR] !== undefined
    || '@@iterator' in O
    // eslint-disable-next-line no-prototype-builtins
    || Iterators.hasOwnProperty(classof(O));
};


/***/ }),
/* 139 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = __webpack_require__(15);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var LabelAccumulator = __webpack_require__(140)['default'];
var ComponentUtil = __webpack_require__(35)['default'];

// Hash of prepared regexp's for tags
var tagPattern = {
  // HTML
  '<b>': /<b>/,
  '<i>': /<i>/,
  '<code>': /<code>/,
  '</b>': /<\/b>/,
  '</i>': /<\/i>/,
  '</code>': /<\/code>/,
  // Markdown
  '*': /\*/, // bold
  _: /\_/, // ital
  '`': /`/, // mono
  afterBold: /[^\*]/,
  afterItal: /[^_]/,
  afterMono: /[^`]/

  /**
   * Internal helper class for parsing the markup tags for HTML and Markdown.
   *
   * NOTE: Sequences of tabs and spaces are reduced to single space.
   *       Scan usage of `this.spacing` within method
   */
};
var MarkupAccumulator = function () {
  /**
   * Create an instance
   *
   * @param {string} text  text to parse for markup
   */
  function MarkupAccumulator(text) {
    (0, _classCallCheck3['default'])(this, MarkupAccumulator);

    this.text = text;
    this.bold = false;
    this.ital = false;
    this.mono = false;
    this.spacing = false;
    this.position = 0;
    this.buffer = '';
    this.modStack = [];

    this.blocks = [];
  }

  /**
   * Return the mod label currently on the top of the stack
   *
   * @returns {string}  label of topmost mod
   * @private
   */


  (0, _createClass3['default'])(MarkupAccumulator, [{
    key: 'mod',
    value: function mod() {
      return this.modStack.length === 0 ? 'normal' : this.modStack[0];
    }

    /**
     * Return the mod label currently active
     *
     * @returns {string}  label of active mod
     * @private
     */

  }, {
    key: 'modName',
    value: function modName() {
      if (this.modStack.length === 0) return 'normal';else if (this.modStack[0] === 'mono') return 'mono';else {
        if (this.bold && this.ital) {
          return 'boldital';
        } else if (this.bold) {
          return 'bold';
        } else if (this.ital) {
          return 'ital';
        }
      }
    }

    /**
     * @private
     */

  }, {
    key: 'emitBlock',
    value: function emitBlock() {
      if (this.spacing) {
        this.add(' ');
        this.spacing = false;
      }
      if (this.buffer.length > 0) {
        this.blocks.push({ text: this.buffer, mod: this.modName() });
        this.buffer = '';
      }
    }

    /**
     * Output text to buffer
     *
     * @param {string} text  text to add
     * @private
     */

  }, {
    key: 'add',
    value: function add(text) {
      if (text === ' ') {
        this.spacing = true;
      }
      if (this.spacing) {
        this.buffer += ' ';
        this.spacing = false;
      }
      if (text != ' ') {
        this.buffer += text;
      }
    }

    /**
     * Handle parsing of whitespace
     *
     * @param {string} ch  the character to check
     * @returns {boolean} true if the character was processed as whitespace, false otherwise
     */

  }, {
    key: 'parseWS',
    value: function parseWS(ch) {
      if (/[ \t]/.test(ch)) {
        if (!this.mono) {
          this.spacing = true;
        } else {
          this.add(ch);
        }
        return true;
      }

      return false;
    }

    /**
     * @param {string} tagName  label for block type to set
     * @private
     */

  }, {
    key: 'setTag',
    value: function setTag(tagName) {
      this.emitBlock();
      this[tagName] = true;
      this.modStack.unshift(tagName);
    }

    /**
     * @param {string} tagName  label for block type to unset
     * @private
     */

  }, {
    key: 'unsetTag',
    value: function unsetTag(tagName) {
      this.emitBlock();
      this[tagName] = false;
      this.modStack.shift();
    }

    /**
     * @param {string} tagName label for block type we are currently processing
     * @param {string|RegExp} tag string to match in text
     * @returns {boolean} true if the tag was processed, false otherwise
     */

  }, {
    key: 'parseStartTag',
    value: function parseStartTag(tagName, tag) {
      // Note: if 'mono' passed as tagName, there is a double check here. This is OK
      if (!this.mono && !this[tagName] && this.match(tag)) {
        this.setTag(tagName);
        return true;
      }

      return false;
    }

    /**
     * @param {string|RegExp} tag
     * @param {number} [advance=true] if set, advance current position in text
     * @returns {boolean} true if match at given position, false otherwise
     * @private
     */

  }, {
    key: 'match',
    value: function match(tag) {
      var advance = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      var _prepareRegExp = this.prepareRegExp(tag),
          _prepareRegExp2 = (0, _slicedToArray3['default'])(_prepareRegExp, 2),
          regExp = _prepareRegExp2[0],
          length = _prepareRegExp2[1];

      var matched = regExp.test(this.text.substr(this.position, length));

      if (matched && advance) {
        this.position += length - 1;
      }

      return matched;
    }

    /**
     * @param {string} tagName label for block type we are currently processing
     * @param {string|RegExp} tag string to match in text
     * @param {RegExp} [nextTag] regular expression to match for characters *following* the current tag
     * @returns {boolean} true if the tag was processed, false otherwise
     */

  }, {
    key: 'parseEndTag',
    value: function parseEndTag(tagName, tag, nextTag) {
      var checkTag = this.mod() === tagName;
      if (tagName === 'mono') {
        // special handling for 'mono'
        checkTag = checkTag && this.mono;
      } else {
        checkTag = checkTag && !this.mono;
      }

      if (checkTag && this.match(tag)) {
        if (nextTag !== undefined) {
          // Purpose of the following match is to prevent a direct unset/set of a given tag
          // E.g. '*bold **still bold*' => '*bold still bold*'
          if (this.position === this.text.length - 1 || this.match(nextTag, false)) {
            this.unsetTag(tagName);
          }
        } else {
          this.unsetTag(tagName);
        }

        return true;
      }

      return false;
    }

    /**
     * @param {string|RegExp} tag  string to match in text
     * @param {value} value  string to replace tag with, if found at current position
     * @returns {boolean} true if the tag was processed, false otherwise
     */

  }, {
    key: 'replace',
    value: function replace(tag, value) {
      if (this.match(tag)) {
        this.add(value);
        this.position += length - 1;
        return true;
      }

      return false;
    }

    /**
     * Create a regular expression for the tag if it isn't already one.
     *
     * The return value is an array `[RegExp, number]`, with exactly two value, where:
     *  - RegExp is the regular expression to use
     *  - number is the lenth of the input string to match
     *
     * @param {string|RegExp} tag  string to match in text
     * @returns {Array}  regular expression to use and length of input string to match
     * @private
     */

  }, {
    key: 'prepareRegExp',
    value: function prepareRegExp(tag) {
      var length = void 0;
      var regExp = void 0;
      if (tag instanceof RegExp) {
        regExp = tag;
        length = 1; // ASSUMPTION: regexp only tests one character
      } else {
        // use prepared regexp if present
        var prepared = tagPattern[tag];
        if (prepared !== undefined) {
          regExp = prepared;
        } else {
          regExp = new RegExp(tag);
        }

        length = tag.length;
      }

      return [regExp, length];
    }
  }]);
  return MarkupAccumulator;
}();

/**
 * Helper class for Label which explodes the label text into lines and blocks within lines
 *
 * @private
 */


var LabelSplitter = function () {
  /**
   * @param {CanvasRenderingContext2D} ctx Canvas rendering context
   * @param {Label} parent reference to the Label instance using current instance
   * @param {boolean} selected
   * @param {boolean} hover
   */
  function LabelSplitter(ctx, parent, selected, hover) {
    var _this = this;

    (0, _classCallCheck3['default'])(this, LabelSplitter);

    this.ctx = ctx;
    this.parent = parent;

    /**
     * Callback to determine text width; passed to LabelAccumulator instance
     *
     * @param  {String} text string to determine width of
     * @param  {String} mod  font type to use for this text
     * @return {Object} { width, values} width in pixels and font attributes
     */
    var textWidth = function textWidth(text, mod) {
      if (text === undefined) return 0;

      // TODO: This can be done more efficiently with caching
      var values = _this.parent.getFormattingValues(ctx, selected, hover, mod);

      var width = 0;
      if (text !== '') {
        // NOTE: The following may actually be *incorrect* for the mod fonts!
        //       This returns the size with a regular font, bold etc. may
        //       have different sizes.
        var measure = _this.ctx.measureText(text);
        width = measure.width;
      }

      return { width: width, values: values };
    };

    this.lines = new LabelAccumulator(textWidth);
  }

  /**
   * Split passed text of a label into lines and blocks.
   *
   * # NOTE
   *
   * The handling of spacing is option dependent:
   *
   * - if `font.multi : false`, all spaces are retained
   * - if `font.multi : true`, every sequence of spaces is compressed to a single space
   *
   * This might not be the best way to do it, but this is as it has been working till now.
   * In order not to break existing functionality, for the time being this behaviour will
   * be retained in any code changes.
   *
   * @param {string} text  text to split
   * @returns {Array<line>}
   */


  (0, _createClass3['default'])(LabelSplitter, [{
    key: 'process',
    value: function process(text) {
      if (!ComponentUtil.isValidLabel(text)) {
        return this.lines.finalize();
      }

      var font = this.parent.fontOptions;

      // Normalize the end-of-line's to a single representation - order important
      text = text.replace(/\r\n/g, '\n'); // Dos EOL's
      text = text.replace(/\r/g, '\n'); // Mac EOL's

      // Note that at this point, there can be no \r's in the text.
      // This is used later on splitStringIntoLines() to split multifont texts.

      var nlLines = String(text).split('\n');
      var lineCount = nlLines.length;

      if (font.multi) {
        // Multi-font case: styling tags active
        for (var i = 0; i < lineCount; i++) {
          var blocks = this.splitBlocks(nlLines[i], font.multi);
          // Post: Sequences of tabs and spaces are reduced to single space

          if (blocks === undefined) continue;

          if (blocks.length === 0) {
            this.lines.newLine('');
            continue;
          }

          if (font.maxWdt > 0) {
            // widthConstraint.maximum defined
            //console.log('Running widthConstraint multi, max: ' + this.fontOptions.maxWdt);
            for (var j = 0; j < blocks.length; j++) {
              var mod = blocks[j].mod;
              var _text = blocks[j].text;
              this.splitStringIntoLines(_text, mod, true);
            }
          } else {
            // widthConstraint.maximum NOT defined
            for (var _j = 0; _j < blocks.length; _j++) {
              var _mod = blocks[_j].mod;
              var _text2 = blocks[_j].text;
              this.lines.append(_text2, _mod);
            }
          }

          this.lines.newLine();
        }
      } else {
        // Single-font case
        if (font.maxWdt > 0) {
          // widthConstraint.maximum defined
          // console.log('Running widthConstraint normal, max: ' + this.fontOptions.maxWdt);
          for (var _i = 0; _i < lineCount; _i++) {
            this.splitStringIntoLines(nlLines[_i]);
          }
        } else {
          // widthConstraint.maximum NOT defined
          for (var _i2 = 0; _i2 < lineCount; _i2++) {
            this.lines.newLine(nlLines[_i2]);
          }
        }
      }

      return this.lines.finalize();
    }

    /**
     * normalize the markup system
     *
     * @param {boolean|'md'|'markdown'|'html'} markupSystem
     * @returns {string}
     */

  }, {
    key: 'decodeMarkupSystem',
    value: function decodeMarkupSystem(markupSystem) {
      var system = 'none';
      if (markupSystem === 'markdown' || markupSystem === 'md') {
        system = 'markdown';
      } else if (markupSystem === true || markupSystem === 'html') {
        system = 'html';
      }
      return system;
    }

    /**
     *
     * @param {string} text
     * @returns {Array}
     */

  }, {
    key: 'splitHtmlBlocks',
    value: function splitHtmlBlocks(text) {
      var s = new MarkupAccumulator(text);

      var parseEntities = function parseEntities(ch) {
        if (/&/.test(ch)) {
          var parsed = s.replace(s.text, '&lt;', '<') || s.replace(s.text, '&amp;', '&');

          if (!parsed) {
            s.add('&');
          }

          return true;
        }

        return false;
      };

      while (s.position < s.text.length) {
        var ch = s.text.charAt(s.position);

        var parsed = s.parseWS(ch) || /</.test(ch) && (s.parseStartTag('bold', '<b>') || s.parseStartTag('ital', '<i>') || s.parseStartTag('mono', '<code>') || s.parseEndTag('bold', '</b>') || s.parseEndTag('ital', '</i>') || s.parseEndTag('mono', '</code>')) || parseEntities(ch);

        if (!parsed) {
          s.add(ch);
        }
        s.position++;
      }
      s.emitBlock();
      return s.blocks;
    }

    /**
     *
     * @param {string} text
     * @returns {Array}
     */

  }, {
    key: 'splitMarkdownBlocks',
    value: function splitMarkdownBlocks(text) {
      var _this2 = this;

      var s = new MarkupAccumulator(text);
      var beginable = true;

      var parseOverride = function parseOverride(ch) {
        if (/\\/.test(ch)) {
          if (s.position < _this2.text.length + 1) {
            s.position++;
            ch = _this2.text.charAt(s.position);
            if (/ \t/.test(ch)) {
              s.spacing = true;
            } else {
              s.add(ch);
              beginable = false;
            }
          }

          return true;
        }

        return false;
      };

      while (s.position < s.text.length) {
        var ch = s.text.charAt(s.position);

        var parsed = s.parseWS(ch) || parseOverride(ch) || (beginable || s.spacing) && (s.parseStartTag('bold', '*') || s.parseStartTag('ital', '_') || s.parseStartTag('mono', '`')) || s.parseEndTag('bold', '*', 'afterBold') || s.parseEndTag('ital', '_', 'afterItal') || s.parseEndTag('mono', '`', 'afterMono');

        if (!parsed) {
          s.add(ch);
          beginable = false;
        }
        s.position++;
      }
      s.emitBlock();
      return s.blocks;
    }

    /**
     * Explodes a piece of text into single-font blocks using a given markup
     *
     * @param {string} text
     * @param {boolean|'md'|'markdown'|'html'} markupSystem
     * @returns {Array.<{text: string, mod: string}>}
     * @private
     */

  }, {
    key: 'splitBlocks',
    value: function splitBlocks(text, markupSystem) {
      var system = this.decodeMarkupSystem(markupSystem);
      if (system === 'none') {
        return [{
          text: text,
          mod: 'normal'
        }];
      } else if (system === 'markdown') {
        return this.splitMarkdownBlocks(text);
      } else if (system === 'html') {
        return this.splitHtmlBlocks(text);
      }
    }

    /**
     * @param {string} text
     * @returns {boolean} true if text length over the current max with
     * @private
     */

  }, {
    key: 'overMaxWidth',
    value: function overMaxWidth(text) {
      var width = this.ctx.measureText(text).width;
      return this.lines.curWidth() + width > this.parent.fontOptions.maxWdt;
    }

    /**
     * Determine the longest part of the sentence which still fits in the
     * current max width.
     *
     * @param {Array} words  Array of strings signifying a text lines
     * @return {number}      index of first item in string making string go over max
     * @private
     */

  }, {
    key: 'getLongestFit',
    value: function getLongestFit(words) {
      var text = '';
      var w = 0;

      while (w < words.length) {
        var pre = text === '' ? '' : ' ';
        var newText = text + pre + words[w];

        if (this.overMaxWidth(newText)) break;
        text = newText;
        w++;
      }

      return w;
    }

    /**
     * Determine the longest part of the string which still fits in the
     * current max width.
     *
     * @param {Array} words Array of strings signifying a text lines
     * @return {number} index of first item in string making string go over max
     */

  }, {
    key: 'getLongestFitWord',
    value: function getLongestFitWord(words) {
      var w = 0;

      while (w < words.length) {
        if (this.overMaxWidth(words.slice(0, w))) break;
        w++;
      }

      return w;
    }

    /**
     * Split the passed text into lines, according to width constraint (if any).
     *
     * The method assumes that the input string is a single line, i.e. without lines break.
     *
     * This method retains spaces, if still present (case `font.multi: false`).
     * A space which falls on an internal line break, will be replaced by a newline.
     * There is no special handling of tabs; these go along with the flow.
     *
     * @param {string} str
     * @param {string} [mod='normal']
     * @param {boolean} [appendLast=false]
     * @private
     */

  }, {
    key: 'splitStringIntoLines',
    value: function splitStringIntoLines(str) {
      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'normal';
      var appendLast = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      // Still-present spaces are relevant, retain them
      str = str.replace(/^( +)/g, '$1\r');
      str = str.replace(/([^\r][^ ]*)( +)/g, '$1\r$2\r');
      var words = str.split('\r');

      while (words.length > 0) {
        var w = this.getLongestFit(words);

        if (w === 0) {
          // Special case: the first word is already larger than the max width.
          var word = words[0];

          // Break the word to the largest part that fits the line
          var x = this.getLongestFitWord(word);
          this.lines.newLine(word.slice(0, x), mod);

          // Adjust the word, so that the rest will be done next iteration
          words[0] = word.slice(x);
        } else {
          // skip any space that is replaced by a newline
          var newW = w;
          if (words[w - 1] === ' ') {
            w--;
          } else if (words[newW] === ' ') {
            newW++;
          }

          var text = words.slice(0, w).join('');

          if (w == words.length && appendLast) {
            this.lines.append(text, mod);
          } else {
            this.lines.newLine(text, mod);
          }

          // Adjust the word, so that the rest will be done next iteration
          words = words.slice(newW);
        }
      }
    }
  }]);
  return LabelSplitter;
}();

exports['default'] = LabelSplitter;

/***/ }),
/* 140 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _assign = __webpack_require__(78);

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Callback to determine text dimensions, using the parent label settings.
 * @callback MeasureText
 * @param {text} text
 * @param {text} mod
 * @return {Object} { width, values} width in pixels and font attributes
 */

/**
 * Helper class for Label which collects results of splitting labels into lines and blocks.
 *
 * @private
 */
var LabelAccumulator = function () {
  /**
   * @param {MeasureText} measureText
   */
  function LabelAccumulator(measureText) {
    (0, _classCallCheck3['default'])(this, LabelAccumulator);

    this.measureText = measureText;
    this.current = 0;
    this.width = 0;
    this.height = 0;
    this.lines = [];
  }

  /**
   * Append given text to the given line.
   *
   * @param {number}  l    index of line to add to
   * @param {string}  text string to append to line
   * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
   * @private
   */


  (0, _createClass3['default'])(LabelAccumulator, [{
    key: '_add',
    value: function _add(l, text) {
      var mod = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'normal';

      if (this.lines[l] === undefined) {
        this.lines[l] = {
          width: 0,
          height: 0,
          blocks: []
        };
      }

      // We still need to set a block for undefined and empty texts, hence return at this point
      // This is necessary because we don't know at this point if we're at the
      // start of an empty line or not.
      // To compensate, empty blocks are removed in `finalize()`.
      //
      // Empty strings should still have a height
      var tmpText = text;
      if (text === undefined || text === '') tmpText = ' ';

      // Determine width and get the font properties
      var result = this.measureText(tmpText, mod);
      var block = (0, _assign2['default'])({}, result.values);
      block.text = text;
      block.width = result.width;
      block.mod = mod;

      if (text === undefined || text === '') {
        block.width = 0;
      }

      this.lines[l].blocks.push(block);

      // Update the line width. We need this for determining if a string goes over max width
      this.lines[l].width += block.width;
    }

    /**
     * Returns the width in pixels of the current line.
     *
     * @returns {number}
     */

  }, {
    key: 'curWidth',
    value: function curWidth() {
      var line = this.lines[this.current];
      if (line === undefined) return 0;

      return line.width;
    }

    /**
     * Add text in block to current line
     *
     * @param {string} text
     * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
     */

  }, {
    key: 'append',
    value: function append(text) {
      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'normal';

      this._add(this.current, text, mod);
    }

    /**
     * Add text in block to current line and start a new line
     *
     * @param {string} text
     * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
     */

  }, {
    key: 'newLine',
    value: function newLine(text) {
      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'normal';

      this._add(this.current, text, mod);
      this.current++;
    }

    /**
     * Determine and set the heights of all the lines currently contained in this instance
     *
     * Note that width has already been set.
     *
     * @private
     */

  }, {
    key: 'determineLineHeights',
    value: function determineLineHeights() {
      for (var k = 0; k < this.lines.length; k++) {
        var line = this.lines[k];

        // Looking for max height of blocks in line
        var height = 0;

        if (line.blocks !== undefined) {
          // Can happen if text contains e.g. '\n '
          for (var l = 0; l < line.blocks.length; l++) {
            var block = line.blocks[l];

            if (height < block.height) {
              height = block.height;
            }
          }
        }

        line.height = height;
      }
    }

    /**
     * Determine the full size of the label text, as determined by current lines and blocks
     *
     * @private
     */

  }, {
    key: 'determineLabelSize',
    value: function determineLabelSize() {
      var width = 0;
      var height = 0;
      for (var k = 0; k < this.lines.length; k++) {
        var line = this.lines[k];

        if (line.width > width) {
          width = line.width;
        }
        height += line.height;
      }

      this.width = width;
      this.height = height;
    }

    /**
     * Remove all empty blocks and empty lines we don't need
     *
     * This must be done after the width/height determination,
     * so that these are set properly for processing here.
     *
     * @returns {Array<Line>} Lines with empty blocks (and some empty lines) removed
     * @private
     */

  }, {
    key: 'removeEmptyBlocks',
    value: function removeEmptyBlocks() {
      var tmpLines = [];
      for (var k = 0; k < this.lines.length; k++) {
        var line = this.lines[k];

        // Note: an empty line in between text has width zero but is still relevant to layout.
        // So we can't use width for testing empty line here
        if (line.blocks.length === 0) continue;

        // Discard final empty line always
        if (k === this.lines.length - 1) {
          if (line.width === 0) continue;
        }

        var tmpLine = {};
        (0, _assign2['default'])(tmpLine, line);
        tmpLine.blocks = [];

        var firstEmptyBlock = void 0;
        var tmpBlocks = [];
        for (var l = 0; l < line.blocks.length; l++) {
          var block = line.blocks[l];
          if (block.width !== 0) {
            tmpBlocks.push(block);
          } else {
            if (firstEmptyBlock === undefined) {
              firstEmptyBlock = block;
            }
          }
        }

        // Ensure that there is *some* text present
        if (tmpBlocks.length === 0 && firstEmptyBlock !== undefined) {
          tmpBlocks.push(firstEmptyBlock);
        }

        tmpLine.blocks = tmpBlocks;

        tmpLines.push(tmpLine);
      }

      return tmpLines;
    }

    /**
     * Set the sizes for all lines and the whole thing.
     *
     * @returns {{width: (number|*), height: (number|*), lines: Array}}
     */

  }, {
    key: 'finalize',
    value: function finalize() {
      //console.log(JSON.stringify(this.lines, null, 2));

      this.determineLineHeights();
      this.determineLabelSize();
      var tmpLines = this.removeEmptyBlocks();

      // Return a simple hash object for further processing.
      return {
        width: this.width,
        height: this.height,
        lines: tmpLines
      };
    }
  }]);
  return LabelAccumulator;
}();

exports['default'] = LabelAccumulator;

/***/ }),
/* 141 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(142);
module.exports = __webpack_require__(6).Object.assign;


/***/ }),
/* 142 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.3.1 Object.assign(target, source)
var $export = __webpack_require__(11);

$export($export.S + $export.F, 'Object', { assign: __webpack_require__(143) });


/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// 19.1.2.1 Object.assign(target, source, ...)
var getKeys = __webpack_require__(26);
var gOPS = __webpack_require__(50);
var pIE = __webpack_require__(32);
var toObject = __webpack_require__(30);
var IObject = __webpack_require__(59);
var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
module.exports = !$assign || __webpack_require__(22)(function () {
  var A = {};
  var B = {};
  // eslint-disable-next-line no-undef
  var S = Symbol();
  var K = 'abcdefghijklmnopqrst';
  A[S] = 7;
  K.split('').forEach(function (k) { B[k] = k; });
  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars
  var T = toObject(target);
  var aLen = arguments.length;
  var index = 1;
  var getSymbols = gOPS.f;
  var isEnum = pIE.f;
  while (aLen > index) {
    var S = IObject(arguments[index++]);
    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) if (isEnum.call(S, key = keys[j++])) T[key] = S[key];
  } return T;
} : $assign;


/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _NodeBase2 = __webpack_require__(16);

var _NodeBase3 = _interopRequireDefault(_NodeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Box Node/Cluster shape.
 *
 * @extends NodeBase
 */
var Box = function (_NodeBase) {
  (0, _inherits3['default'])(Box, _NodeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Box(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Box);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Box.__proto__ || (0, _getPrototypeOf2['default'])(Box)).call(this, options, body, labelModule));

    _this._setMargins(labelModule);
    return _this;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  (0, _createClass3['default'])(Box, [{
    key: 'resize',
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

      if (this.needsRefresh(selected, hover)) {
        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);

        this.width = dimensions.width + this.margin.right + this.margin.left;
        this.height = dimensions.height + this.margin.top + this.margin.bottom;
        this.radius = this.width / 2;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      this.initContextForDraw(ctx, values);
      ctx.roundRect(this.left, this.top, this.width, this.height, values.borderRadius);
      this.performFill(ctx, values);

      this.updateBoundingBox(x, y, ctx, selected, hover);
      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
    }

    /**
     *
     * @param {number} x width
     * @param {number} y height
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     */

  }, {
    key: 'updateBoundingBox',
    value: function updateBoundingBox(x, y, ctx, selected, hover) {
      this._updateBoundingBox(x, y, ctx, selected, hover);

      var borderRadius = this.options.shapeProperties.borderRadius; // only effective for box
      this._addBoundingBoxMargin(borderRadius);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      this.resize(ctx);
      var borderWidth = this.options.borderWidth;

      return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
    }
  }]);
  return Box;
}(_NodeBase3['default']);

exports['default'] = Box;

/***/ }),
/* 145 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(146);
module.exports = __webpack_require__(6).Object.getPrototypeOf;


/***/ }),
/* 146 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.9 Object.getPrototypeOf(O)
var toObject = __webpack_require__(30);
var $getPrototypeOf = __webpack_require__(66);

__webpack_require__(68)('getPrototypeOf', function () {
  return function getPrototypeOf(it) {
    return $getPrototypeOf(toObject(it));
  };
});


/***/ }),
/* 147 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(148), __esModule: true };

/***/ }),
/* 148 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(149);
module.exports = __webpack_require__(6).Object.setPrototypeOf;


/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.3.19 Object.setPrototypeOf(O, proto)
var $export = __webpack_require__(11);
$export($export.S, 'Object', { setPrototypeOf: __webpack_require__(150).set });


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

// Works with __proto__ only. Old v8 can't work with null proto objects.
/* eslint-disable no-proto */
var isObject = __webpack_require__(21);
var anObject = __webpack_require__(20);
var check = function (O, proto) {
  anObject(O);
  if (!isObject(proto) && proto !== null) throw TypeError(proto + ": can't set as prototype!");
};
module.exports = {
  set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line
    function (test, buggy, set) {
      try {
        set = __webpack_require__(61)(Function.call, __webpack_require__(70).f(Object.prototype, '__proto__').set, 2);
        set(test, []);
        buggy = !(test instanceof Array);
      } catch (e) { buggy = true; }
      return function setPrototypeOf(O, proto) {
        check(O, proto);
        if (buggy) O.__proto__ = proto;
        else set(O, proto);
        return O;
      };
    }({}, false) : undefined),
  check: check
};


/***/ }),
/* 151 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _CircleImageBase2 = __webpack_require__(53);

var _CircleImageBase3 = _interopRequireDefault(_CircleImageBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Circle Node/Cluster shape.
 *
 * @extends CircleImageBase
 */
var Circle = function (_CircleImageBase) {
  (0, _inherits3['default'])(Circle, _CircleImageBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Circle(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Circle);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Circle.__proto__ || (0, _getPrototypeOf2['default'])(Circle)).call(this, options, body, labelModule));

    _this._setMargins(labelModule);
    return _this;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  (0, _createClass3['default'])(Circle, [{
    key: 'resize',
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

      if (this.needsRefresh(selected, hover)) {
        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);

        var diameter = Math.max(dimensions.width + this.margin.right + this.margin.left, dimensions.height + this.margin.top + this.margin.bottom);

        this.options.size = diameter / 2; // NOTE: this size field only set here, not in Ellipse, Database, Box
        this.width = diameter;
        this.height = diameter;
        this.radius = this.width / 2;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      this._drawRawCircle(ctx, x, y, values);

      this.updateBoundingBox(x, y);
      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, y, selected, hover);
    }

    /**
     *
     * @param {number} x width
     * @param {number} y height
     */

  }, {
    key: 'updateBoundingBox',
    value: function updateBoundingBox(x, y) {
      this.boundingBox.top = y - this.options.size;
      this.boundingBox.left = x - this.options.size;
      this.boundingBox.right = x + this.options.size;
      this.boundingBox.bottom = y + this.options.size;
    }

    // prettier-ignore
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle - Unused
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      // eslint-disable-line no-unused-vars
      this.resize(ctx);
      return this.width * 0.5;
    }
  }]);
  return Circle;
}(_CircleImageBase3['default']);

exports['default'] = Circle;

/***/ }),
/* 152 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _CircleImageBase2 = __webpack_require__(53);

var _CircleImageBase3 = _interopRequireDefault(_CircleImageBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A CircularImage Node/Cluster shape.
 *
 * @extends CircleImageBase
 */
var CircularImage = function (_CircleImageBase) {
  (0, _inherits3['default'])(CircularImage, _CircleImageBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   * @param {Image} imageObj
   * @param {Image} imageObjAlt
   */
  function CircularImage(options, body, labelModule, imageObj, imageObjAlt) {
    (0, _classCallCheck3['default'])(this, CircularImage);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (CircularImage.__proto__ || (0, _getPrototypeOf2['default'])(CircularImage)).call(this, options, body, labelModule));

    _this.setImages(imageObj, imageObjAlt);
    return _this;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  (0, _createClass3['default'])(CircularImage, [{
    key: 'resize',
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

      var imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;

      if (imageAbsent) {
        var diameter = this.options.size * 2;
        this.width = diameter;
        this.height = diameter;
        this.radius = 0.5 * this.width;
        return;
      }

      // At this point, an image is present, i.e. this.imageObj is valid.
      if (this.needsRefresh(selected, hover)) {
        this._resizeImage();
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this.switchImages(selected);
      this.resize();
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      // draw the background circle. IMPORTANT: the stroke in this method is used by the clip method below.
      this._drawRawCircle(ctx, x, y, values);

      // now we draw in the circle, we save so we can revert the clip operation after drawing.
      ctx.save();
      // clip is used to use the stroke in drawRawCircle as an area that we can draw in.
      ctx.clip();
      // draw the image
      this._drawImageAtPosition(ctx, values);
      // restore so we can again draw on the full canvas
      ctx.restore();

      this._drawImageLabel(ctx, x, y, selected, hover);

      this.updateBoundingBox(x, y);
    }

    // TODO: compare with Circle.updateBoundingBox(), consolidate? More stuff is happening here
    /**
     *
     * @param {number} x width
     * @param {number} y height
     */

  }, {
    key: 'updateBoundingBox',
    value: function updateBoundingBox(x, y) {
      this.boundingBox.top = y - this.options.size;
      this.boundingBox.left = x - this.options.size;
      this.boundingBox.right = x + this.options.size;
      this.boundingBox.bottom = y + this.options.size;

      // TODO: compare with Image.updateBoundingBox(), consolidate?
      this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
      this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
      this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
    }

    // prettier-ignore
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle - Unused
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      // eslint-disable-line no-unused-vars
      this.resize(ctx);
      return this.width * 0.5;
    }
  }]);
  return CircularImage;
}(_CircleImageBase3['default']);

exports['default'] = CircularImage;

/***/ }),
/* 153 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _NodeBase2 = __webpack_require__(16);

var _NodeBase3 = _interopRequireDefault(_NodeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Database Node/Cluster shape.
 *
 * @extends NodeBase
 */
var Database = function (_NodeBase) {
  (0, _inherits3['default'])(Database, _NodeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Database(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Database);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Database.__proto__ || (0, _getPrototypeOf2['default'])(Database)).call(this, options, body, labelModule));

    _this._setMargins(labelModule);
    return _this;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   */


  (0, _createClass3['default'])(Database, [{
    key: 'resize',
    value: function resize(ctx, selected, hover) {
      if (this.needsRefresh(selected, hover)) {
        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
        var size = dimensions.width + this.margin.right + this.margin.left;

        this.width = size;
        this.height = size;
        this.radius = this.width / 2;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      this.initContextForDraw(ctx, values);
      ctx.database(x - this.width / 2, y - this.height / 2, this.width, this.height);
      this.performFill(ctx, values);

      this.updateBoundingBox(x, y, ctx, selected, hover);
      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Database;
}(_NodeBase3['default']);

exports['default'] = Database;

/***/ }),
/* 154 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _ShapeBase2 = __webpack_require__(17);

var _ShapeBase3 = _interopRequireDefault(_ShapeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Diamond Node/Cluster shape.
 *
 * @extends ShapeBase
 */
var Diamond = function (_ShapeBase) {
  (0, _inherits3['default'])(Diamond, _ShapeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Diamond(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Diamond);
    return (0, _possibleConstructorReturn3['default'])(this, (Diamond.__proto__ || (0, _getPrototypeOf2['default'])(Diamond)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */


  (0, _createClass3['default'])(Diamond, [{
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this._drawShape(ctx, 'diamond', 4, x, y, selected, hover, values);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Diamond;
}(_ShapeBase3['default']);

exports['default'] = Diamond;

/***/ }),
/* 155 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _ShapeBase2 = __webpack_require__(17);

var _ShapeBase3 = _interopRequireDefault(_ShapeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Dot Node/Cluster shape.
 *
 * @extends ShapeBase
 */
var Dot = function (_ShapeBase) {
  (0, _inherits3['default'])(Dot, _ShapeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Dot(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Dot);
    return (0, _possibleConstructorReturn3['default'])(this, (Dot.__proto__ || (0, _getPrototypeOf2['default'])(Dot)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */


  (0, _createClass3['default'])(Dot, [{
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this._drawShape(ctx, 'circle', 2, x, y, selected, hover, values);
    }

    // prettier-ignore
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      // eslint-disable-line no-unused-vars
      this.resize(ctx);
      return this.options.size;
    }
  }]);
  return Dot;
}(_ShapeBase3['default']);

exports['default'] = Dot;

/***/ }),
/* 156 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _NodeBase2 = __webpack_require__(16);

var _NodeBase3 = _interopRequireDefault(_NodeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Am Ellipse Node/Cluster shape.
 *
 * @extends NodeBase
 */
var Ellipse = function (_NodeBase) {
  (0, _inherits3['default'])(Ellipse, _NodeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Ellipse(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Ellipse);
    return (0, _possibleConstructorReturn3['default'])(this, (Ellipse.__proto__ || (0, _getPrototypeOf2['default'])(Ellipse)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  (0, _createClass3['default'])(Ellipse, [{
    key: 'resize',
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

      if (this.needsRefresh(selected, hover)) {
        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);

        this.height = dimensions.height * 2;
        this.width = dimensions.width + dimensions.height;
        this.radius = 0.5 * this.width;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width * 0.5;
      this.top = y - this.height * 0.5;

      this.initContextForDraw(ctx, values);
      ctx.ellipse_vis(this.left, this.top, this.width, this.height);
      this.performFill(ctx, values);

      this.updateBoundingBox(x, y, ctx, selected, hover);
      this.labelModule.draw(ctx, x, y, selected, hover);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      this.resize(ctx);
      var a = this.width * 0.5;
      var b = this.height * 0.5;
      var w = Math.sin(angle) * a;
      var h = Math.cos(angle) * b;
      return a * b / Math.sqrt(w * w + h * h);
    }
  }]);
  return Ellipse;
}(_NodeBase3['default']);

exports['default'] = Ellipse;

/***/ }),
/* 157 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _NodeBase2 = __webpack_require__(16);

var _NodeBase3 = _interopRequireDefault(_NodeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * An icon replacement for the default Node shape.
 *
 * @extends NodeBase
 */
var Icon = function (_NodeBase) {
  (0, _inherits3['default'])(Icon, _NodeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Icon(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Icon);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Icon.__proto__ || (0, _getPrototypeOf2['default'])(Icon)).call(this, options, body, labelModule));

    _this._setMargins(labelModule);
    return _this;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx - Unused.
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  (0, _createClass3['default'])(Icon, [{
    key: 'resize',
    value: function resize(ctx, selected, hover) {
      if (this.needsRefresh(selected, hover)) {
        this.iconSize = {
          width: Number(this.options.icon.size),
          height: Number(this.options.icon.size)
        };
        this.width = this.iconSize.width + this.margin.right + this.margin.left;
        this.height = this.iconSize.height + this.margin.top + this.margin.bottom;
        this.radius = 0.5 * this.width;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.options.icon.size = this.options.icon.size || 50;

      this.left = x - this.width / 2;
      this.top = y - this.height / 2;
      this._icon(ctx, x, y, selected, hover, values);

      if (this.options.label !== undefined) {
        var iconTextSpacing = 5;
        this.labelModule.draw(ctx, this.left + this.iconSize.width / 2 + this.margin.left, y + this.height / 2 + iconTextSpacing, selected);
      }

      this.updateBoundingBox(x, y);
    }

    /**
     *
     * @param {number} x
     * @param {number} y
     */

  }, {
    key: 'updateBoundingBox',
    value: function updateBoundingBox(x, y) {
      this.boundingBox.top = y - this.options.icon.size * 0.5;
      this.boundingBox.left = x - this.options.icon.size * 0.5;
      this.boundingBox.right = x + this.options.icon.size * 0.5;
      this.boundingBox.bottom = y + this.options.icon.size * 0.5;

      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
        var iconTextSpacing = 5;
        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height + iconTextSpacing);
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover - Unused
     * @param {ArrowOptions} values
     */

  }, {
    key: '_icon',
    value: function _icon(ctx, x, y, selected, hover, values) {
      var iconSize = Number(this.options.icon.size);

      if (this.options.icon.code !== undefined) {
        ctx.font = (selected ? 'bold ' : '') + iconSize + 'px ' + this.options.icon.face;

        // draw icon
        ctx.fillStyle = this.options.icon.color || 'black';
        ctx.textAlign = 'center';
        ctx.textBaseline = 'middle';

        // draw shadow if enabled
        this.enableShadow(ctx, values);
        ctx.fillText(this.options.icon.code, x, y);

        // disable shadows for other elements.
        this.disableShadow(ctx, values);
      } else {
        console.error('When using the icon shape, you need to define the code in the icon options object. This can be done per node or globally.');
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Icon;
}(_NodeBase3['default']);

exports['default'] = Icon;

/***/ }),
/* 158 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _CircleImageBase2 = __webpack_require__(53);

var _CircleImageBase3 = _interopRequireDefault(_CircleImageBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * An image-based replacement for the default Node shape.
 *
 * @extends CircleImageBase
 */
var Image = function (_CircleImageBase) {
  (0, _inherits3['default'])(Image, _CircleImageBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   * @param {Image} imageObj
   * @param {Image} imageObjAlt
   */
  function Image(options, body, labelModule, imageObj, imageObjAlt) {
    (0, _classCallCheck3['default'])(this, Image);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Image.__proto__ || (0, _getPrototypeOf2['default'])(Image)).call(this, options, body, labelModule));

    _this.setImages(imageObj, imageObjAlt);
    return _this;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx - Unused.
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  (0, _createClass3['default'])(Image, [{
    key: 'resize',
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

      var imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;

      if (imageAbsent) {
        var side = this.options.size * 2;
        this.width = side;
        this.height = side;
        return;
      }

      if (this.needsRefresh(selected, hover)) {
        this._resizeImage();
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this.switchImages(selected);
      this.resize();
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      if (this.options.shapeProperties.useBorderWithImage === true) {
        var neutralborderWidth = this.options.borderWidth;
        var selectionLineWidth = this.options.borderWidthSelected || 2 * this.options.borderWidth;
        var borderWidth = (selected ? selectionLineWidth : neutralborderWidth) / this.body.view.scale;
        ctx.lineWidth = Math.min(this.width, borderWidth);

        ctx.beginPath();

        // setup the line properties.
        ctx.strokeStyle = selected ? this.options.color.highlight.border : hover ? this.options.color.hover.border : this.options.color.border;

        // set a fillstyle
        ctx.fillStyle = selected ? this.options.color.highlight.background : hover ? this.options.color.hover.background : this.options.color.background;

        // draw a rectangle to form the border around. This rectangle is filled so the opacity of a picture (in future vis releases?) can be used to tint the image
        ctx.rect(this.left - 0.5 * ctx.lineWidth, this.top - 0.5 * ctx.lineWidth, this.width + ctx.lineWidth, this.height + ctx.lineWidth);
        ctx.fill();

        this.performStroke(ctx, values);

        ctx.closePath();
      }

      this._drawImageAtPosition(ctx, values);

      this._drawImageLabel(ctx, x, y, selected, hover);

      this.updateBoundingBox(x, y);
    }

    /**
     *
     * @param {number} x
     * @param {number} y
     */

  }, {
    key: 'updateBoundingBox',
    value: function updateBoundingBox(x, y) {
      this.resize();
      this._updateBoundingBox(x, y);

      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Image;
}(_CircleImageBase3['default']);

exports['default'] = Image;

/***/ }),
/* 159 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _ShapeBase2 = __webpack_require__(17);

var _ShapeBase3 = _interopRequireDefault(_ShapeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Square Node/Cluster shape.
 *
 * @extends ShapeBase
 */
var Square = function (_ShapeBase) {
  (0, _inherits3['default'])(Square, _ShapeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Square(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Square);
    return (0, _possibleConstructorReturn3['default'])(this, (Square.__proto__ || (0, _getPrototypeOf2['default'])(Square)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */


  (0, _createClass3['default'])(Square, [{
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this._drawShape(ctx, 'square', 2, x, y, selected, hover, values);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Square;
}(_ShapeBase3['default']);

exports['default'] = Square;

/***/ }),
/* 160 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _ShapeBase2 = __webpack_require__(17);

var _ShapeBase3 = _interopRequireDefault(_ShapeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Hexagon Node/Cluster shape.
 *
 * @extends ShapeBase
 */
var Hexagon = function (_ShapeBase) {
  (0, _inherits3['default'])(Hexagon, _ShapeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Hexagon(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Hexagon);
    return (0, _possibleConstructorReturn3['default'])(this, (Hexagon.__proto__ || (0, _getPrototypeOf2['default'])(Hexagon)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */


  (0, _createClass3['default'])(Hexagon, [{
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this._drawShape(ctx, 'hexagon', 4, x, y, selected, hover, values);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Hexagon;
}(_ShapeBase3['default']);

exports['default'] = Hexagon;

/***/ }),
/* 161 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _ShapeBase2 = __webpack_require__(17);

var _ShapeBase3 = _interopRequireDefault(_ShapeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Star Node/Cluster shape.
 *
 * @extends ShapeBase
 */
var Star = function (_ShapeBase) {
  (0, _inherits3['default'])(Star, _ShapeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Star(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Star);
    return (0, _possibleConstructorReturn3['default'])(this, (Star.__proto__ || (0, _getPrototypeOf2['default'])(Star)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */


  (0, _createClass3['default'])(Star, [{
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this._drawShape(ctx, 'star', 4, x, y, selected, hover, values);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Star;
}(_ShapeBase3['default']);

exports['default'] = Star;

/***/ }),
/* 162 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _NodeBase2 = __webpack_require__(16);

var _NodeBase3 = _interopRequireDefault(_NodeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A text-based replacement for the default Node shape.
 *
 * @extends NodeBase
 */
var Text = function (_NodeBase) {
  (0, _inherits3['default'])(Text, _NodeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Text(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Text);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Text.__proto__ || (0, _getPrototypeOf2['default'])(Text)).call(this, options, body, labelModule));

    _this._setMargins(labelModule);
    return _this;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   */


  (0, _createClass3['default'])(Text, [{
    key: 'resize',
    value: function resize(ctx, selected, hover) {
      if (this.needsRefresh(selected, hover)) {
        this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
        this.width = this.textSize.width + this.margin.right + this.margin.left;
        this.height = this.textSize.height + this.margin.top + this.margin.bottom;
        this.radius = 0.5 * this.width;
      }
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      // draw shadow if enabled
      this.enableShadow(ctx, values);
      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);

      // disable shadows for other elements.
      this.disableShadow(ctx, values);

      this.updateBoundingBox(x, y, ctx, selected, hover);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Text;
}(_NodeBase3['default']);

exports['default'] = Text;

/***/ }),
/* 163 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _ShapeBase2 = __webpack_require__(17);

var _ShapeBase3 = _interopRequireDefault(_ShapeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Triangle Node/Cluster shape.
 *
 * @extends ShapeBase
 */
var Triangle = function (_ShapeBase) {
  (0, _inherits3['default'])(Triangle, _ShapeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function Triangle(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, Triangle);
    return (0, _possibleConstructorReturn3['default'])(this, (Triangle.__proto__ || (0, _getPrototypeOf2['default'])(Triangle)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */


  (0, _createClass3['default'])(Triangle, [{
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this._drawShape(ctx, 'triangle', 3, x, y, selected, hover, values);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return Triangle;
}(_ShapeBase3['default']);

exports['default'] = Triangle;

/***/ }),
/* 164 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _ShapeBase2 = __webpack_require__(17);

var _ShapeBase3 = _interopRequireDefault(_ShapeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A downward facing Triangle Node/Cluster shape.
 *
 * @extends ShapeBase
 */
var TriangleDown = function (_ShapeBase) {
  (0, _inherits3['default'])(TriangleDown, _ShapeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function TriangleDown(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, TriangleDown);
    return (0, _possibleConstructorReturn3['default'])(this, (TriangleDown.__proto__ || (0, _getPrototypeOf2['default'])(TriangleDown)).call(this, options, body, labelModule));
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */


  (0, _createClass3['default'])(TriangleDown, [{
    key: 'draw',
    value: function draw(ctx, x, y, selected, hover, values) {
      this._drawShape(ctx, 'triangleDown', 3, x, y, selected, hover, values);
    }

    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: 'distanceToBorder',
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);
  return TriangleDown;
}(_ShapeBase3['default']);

exports['default'] = TriangleDown;

/***/ }),
/* 165 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);
var DataSet = __webpack_require__(33);
var DataView = __webpack_require__(51);
var Edge = __webpack_require__(55)['default'];

/**
 * Handler for Edges
 */

var EdgesHandler = function () {
  /**
   * @param {Object} body
   * @param {Array.<Image>} images
   * @param {Array.<Group>} groups
   */
  function EdgesHandler(body, images, groups) {
    var _this = this;

    (0, _classCallCheck3['default'])(this, EdgesHandler);

    this.body = body;
    this.images = images;
    this.groups = groups;

    // create the edge API in the body container
    this.body.functions.createEdge = this.create.bind(this);

    this.edgesListeners = {
      add: function add(event, params) {
        _this.add(params.items);
      },
      update: function update(event, params) {
        _this.update(params.items);
      },
      remove: function remove(event, params) {
        _this.remove(params.items);
      }
    };

    this.options = {};
    this.defaultOptions = {
      arrows: {
        to: { enabled: false, scaleFactor: 1, type: 'arrow' }, // boolean / {arrowScaleFactor:1} / {enabled: false, arrowScaleFactor:1}
        middle: { enabled: false, scaleFactor: 1, type: 'arrow' },
        from: { enabled: false, scaleFactor: 1, type: 'arrow' }
      },
      arrowStrikethrough: true,
      color: {
        color: '#848484',
        highlight: '#848484',
        hover: '#848484',
        inherit: 'from',
        opacity: 1.0
      },
      dashes: false,
      font: {
        color: '#343434',
        size: 14, // px
        face: 'arial',
        background: 'none',
        strokeWidth: 2, // px
        strokeColor: '#ffffff',
        align: 'horizontal',
        multi: false,
        vadjust: 0,
        bold: {
          mod: 'bold'
        },
        boldital: {
          mod: 'bold italic'
        },
        ital: {
          mod: 'italic'
        },
        mono: {
          mod: '',
          size: 15, // px
          face: 'courier new',
          vadjust: 2
        }
      },
      hidden: false,
      hoverWidth: 1.5,
      label: undefined,
      labelHighlightBold: true,
      length: undefined,
      physics: true,
      scaling: {
        min: 1,
        max: 15,
        label: {
          enabled: true,
          min: 14,
          max: 30,
          maxVisible: 30,
          drawThreshold: 5
        },
        customScalingFunction: function customScalingFunction(min, max, total, value) {
          if (max === min) {
            return 0.5;
          } else {
            var scale = 1 / (max - min);
            return Math.max(0, (value - min) * scale);
          }
        }
      },
      selectionWidth: 1.5,
      selfReferenceSize: 20,
      shadow: {
        enabled: false,
        color: 'rgba(0,0,0,0.5)',
        size: 10,
        x: 5,
        y: 5
      },
      background: {
        enabled: false,
        color: 'rgba(111,111,111,1)',
        size: 10,
        dashes: false
      },
      smooth: {
        enabled: true,
        type: 'dynamic',
        forceDirection: 'none',
        roundness: 0.5
      },
      title: undefined,
      width: 1,
      value: undefined
    };

    util.deepExtend(this.options, this.defaultOptions);

    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */


  (0, _createClass3['default'])(EdgesHandler, [{
    key: 'bindEventListeners',
    value: function bindEventListeners() {
      var _this2 = this;

      // this allows external modules to force all dynamic curves to turn static.
      this.body.emitter.on('_forceDisableDynamicCurves', function (type) {
        var emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

        if (type === 'dynamic') {
          type = 'continuous';
        }
        var dataChanged = false;
        for (var edgeId in _this2.body.edges) {
          if (_this2.body.edges.hasOwnProperty(edgeId)) {
            var edge = _this2.body.edges[edgeId];
            var edgeData = _this2.body.data.edges._data[edgeId];

            // only forcibly remove the smooth curve if the data has been set of the edge has the smooth curves defined.
            // this is because a change in the global would not affect these curves.
            if (edgeData !== undefined) {
              var smoothOptions = edgeData.smooth;
              if (smoothOptions !== undefined) {
                if (smoothOptions.enabled === true && smoothOptions.type === 'dynamic') {
                  if (type === undefined) {
                    edge.setOptions({ smooth: false });
                  } else {
                    edge.setOptions({ smooth: { type: type } });
                  }
                  dataChanged = true;
                }
              }
            }
          }
        }
        if (emit === true && dataChanged === true) {
          _this2.body.emitter.emit('_dataChanged');
        }
      });

      // this is called when options of EXISTING nodes or edges have changed.
      //
      // NOTE: Not true, called when options have NOT changed, for both existing as well as new nodes.
      //       See update() for logic.
      // TODO: Verify and examine the consequences of this. It might still trigger when
      //       non-option fields have changed, but then reconnecting edges is still useless.
      //       Alternatively, it might also be called when edges are removed.
      //
      this.body.emitter.on('_dataUpdated', function () {
        _this2.reconnectEdges();
      });

      // refresh the edges. Used when reverting from hierarchical layout
      this.body.emitter.on('refreshEdges', this.refresh.bind(this));
      this.body.emitter.on('refresh', this.refresh.bind(this));
      this.body.emitter.on('destroy', function () {
        util.forEach(_this2.edgesListeners, function (callback, event) {
          if (_this2.body.data.edges) _this2.body.data.edges.off(event, callback);
        });
        delete _this2.body.functions.createEdge;
        delete _this2.edgesListeners.add;
        delete _this2.edgesListeners.update;
        delete _this2.edgesListeners.remove;
        delete _this2.edgesListeners;
      });
    }

    /**
     *
     * @param {Object} options
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      if (options !== undefined) {
        // use the parser from the Edge class to fill in all shorthand notations
        Edge.parseOptions(this.options, options, true, this.defaultOptions, true);

        // update smooth settings in all edges
        var dataChanged = false;
        if (options.smooth !== undefined) {
          for (var edgeId in this.body.edges) {
            if (this.body.edges.hasOwnProperty(edgeId)) {
              dataChanged = this.body.edges[edgeId].updateEdgeType() || dataChanged;
            }
          }
        }

        // update fonts in all edges
        if (options.font !== undefined) {
          for (var _edgeId in this.body.edges) {
            if (this.body.edges.hasOwnProperty(_edgeId)) {
              this.body.edges[_edgeId].updateLabelModule();
            }
          }
        }

        // update the state of the variables if needed
        if (options.hidden !== undefined || options.physics !== undefined || dataChanged === true) {
          this.body.emitter.emit('_dataChanged');
        }
      }
    }

    /**
     * Load edges by reading the data table
     * @param {Array | DataSet | DataView} edges    The data containing the edges.
     * @param {boolean} [doNotEmit=false]
     * @private
     */

  }, {
    key: 'setData',
    value: function setData(edges) {
      var _this3 = this;

      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      var oldEdgesData = this.body.data.edges;

      if (edges instanceof DataSet || edges instanceof DataView) {
        this.body.data.edges = edges;
      } else if (Array.isArray(edges)) {
        this.body.data.edges = new DataSet();
        this.body.data.edges.add(edges);
      } else if (!edges) {
        this.body.data.edges = new DataSet();
      } else {
        throw new TypeError('Array or DataSet expected');
      }

      // TODO: is this null or undefined or false?
      if (oldEdgesData) {
        // unsubscribe from old dataset
        util.forEach(this.edgesListeners, function (callback, event) {
          oldEdgesData.off(event, callback);
        });
      }

      // remove drawn edges
      this.body.edges = {};

      // TODO: is this null or undefined or false?
      if (this.body.data.edges) {
        // subscribe to new dataset
        util.forEach(this.edgesListeners, function (callback, event) {
          _this3.body.data.edges.on(event, callback);
        });

        // draw all new nodes
        var ids = this.body.data.edges.getIds();
        this.add(ids, true);
      }

      this.body.emitter.emit('_adjustEdgesForHierarchicalLayout');
      if (doNotEmit === false) {
        this.body.emitter.emit('_dataChanged');
      }
    }

    /**
     * Add edges
     * @param {number[] | string[]} ids
     * @param {boolean} [doNotEmit=false]
     * @private
     */

  }, {
    key: 'add',
    value: function add(ids) {
      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      var edges = this.body.edges;
      var edgesData = this.body.data.edges;

      for (var i = 0; i < ids.length; i++) {
        var id = ids[i];

        var oldEdge = edges[id];
        if (oldEdge) {
          oldEdge.disconnect();
        }

        var data = edgesData.get(id, { showInternalIds: true });
        edges[id] = this.create(data);
      }

      this.body.emitter.emit('_adjustEdgesForHierarchicalLayout');

      if (doNotEmit === false) {
        this.body.emitter.emit('_dataChanged');
      }
    }

    /**
     * Update existing edges, or create them when not yet existing
     * @param {number[] | string[]} ids
     * @private
     */

  }, {
    key: 'update',
    value: function update(ids) {
      var edges = this.body.edges;
      var edgesData = this.body.data.edges;
      var dataChanged = false;
      for (var i = 0; i < ids.length; i++) {
        var id = ids[i];
        var data = edgesData.get(id);
        var edge = edges[id];
        if (edge !== undefined) {
          // update edge
          edge.disconnect();
          dataChanged = edge.setOptions(data) || dataChanged; // if a support node is added, data can be changed.
          edge.connect();
        } else {
          // create edge
          this.body.edges[id] = this.create(data);
          dataChanged = true;
        }
      }

      if (dataChanged === true) {
        this.body.emitter.emit('_adjustEdgesForHierarchicalLayout');
        this.body.emitter.emit('_dataChanged');
      } else {
        this.body.emitter.emit('_dataUpdated');
      }
    }

    /**
     * Remove existing edges. Non existing ids will be ignored
     * @param {number[] | string[]} ids
     * @param {boolean} [emit=true]
     * @private
     */

  }, {
    key: 'remove',
    value: function remove(ids) {
      var emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      if (ids.length === 0) return; // early out

      var edges = this.body.edges;
      util.forEach(ids, function (id) {
        var edge = edges[id];
        if (edge !== undefined) {
          edge.remove();
        }
      });

      if (emit) {
        this.body.emitter.emit('_dataChanged');
      }
    }

    /**
     * Refreshes Edge Handler
     */

  }, {
    key: 'refresh',
    value: function refresh() {
      var _this4 = this;

      util.forEach(this.body.edges, function (edge, edgeId) {
        var data = _this4.body.data.edges._data[edgeId];
        if (data !== undefined) {
          edge.setOptions(data);
        }
      });
    }

    /**
     *
     * @param {Object} properties
     * @returns {Edge}
     */

  }, {
    key: 'create',
    value: function create(properties) {
      return new Edge(properties, this.body, this.options, this.defaultOptions);
    }

    /**
     * Reconnect all edges
     * @private
     */

  }, {
    key: 'reconnectEdges',
    value: function reconnectEdges() {
      var id;
      var nodes = this.body.nodes;
      var edges = this.body.edges;

      for (id in nodes) {
        if (nodes.hasOwnProperty(id)) {
          nodes[id].edges = [];
        }
      }

      for (id in edges) {
        if (edges.hasOwnProperty(id)) {
          var edge = edges[id];
          edge.from = null;
          edge.to = null;
          edge.connect();
        }
      }
    }

    /**
     *
     * @param {Edge.id} edgeId
     * @returns {Array}
     */

  }, {
    key: 'getConnectedNodes',
    value: function getConnectedNodes(edgeId) {
      var nodeList = [];
      if (this.body.edges[edgeId] !== undefined) {
        var edge = this.body.edges[edgeId];
        if (edge.fromId !== undefined) {
          nodeList.push(edge.fromId);
        }
        if (edge.toId !== undefined) {
          nodeList.push(edge.toId);
        }
      }
      return nodeList;
    }

    /**
     * There is no direct relation between the nodes and the edges DataSet,
     * so the right place to do call this is in the handler for event `_dataUpdated`.
     */

  }, {
    key: '_updateState',
    value: function _updateState() {
      this._addMissingEdges();
      this._removeInvalidEdges();
    }

    /**
     * Scan for missing nodes and remove corresponding edges, if any.
     * @private
     */

  }, {
    key: '_removeInvalidEdges',
    value: function _removeInvalidEdges() {
      var _this5 = this;

      var edgesToDelete = [];

      util.forEach(this.body.edges, function (edge, id) {
        var toNode = _this5.body.nodes[edge.toId];
        var fromNode = _this5.body.nodes[edge.fromId];

        // Skip clustering edges here, let the Clustering module handle those
        if (toNode !== undefined && toNode.isCluster === true || fromNode !== undefined && fromNode.isCluster === true) {
          return;
        }

        if (toNode === undefined || fromNode === undefined) {
          edgesToDelete.push(id);
        }
      });

      this.remove(edgesToDelete, false);
    }

    /**
     * add all edges from dataset that are not in the cached state
     * @private
     */

  }, {
    key: '_addMissingEdges',
    value: function _addMissingEdges() {
      var edgesData = this.body.data.edges;
      if (edgesData === undefined || edgesData === null) {
        return; // No edges DataSet yet; can happen on startup
      }

      var edges = this.body.edges;
      var addIds = [];

      edgesData.forEach(function (edgeData, edgeId) {
        var edge = edges[edgeId];
        if (edge === undefined) {
          addIds.push(edgeId);
        }
      });

      this.add(addIds, true);
    }
  }]);
  return EdgesHandler;
}();

exports['default'] = EdgesHandler;

/***/ }),
/* 166 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = __webpack_require__(15);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _CubicBezierEdgeBase2 = __webpack_require__(167);

var _CubicBezierEdgeBase3 = _interopRequireDefault(_CubicBezierEdgeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Cubic Bezier Edge. Bezier curves are used to model smooth gradual
 * curves in paths between nodes.
 *
 * @extends CubicBezierEdgeBase
 */
var CubicBezierEdge = function (_CubicBezierEdgeBase) {
  (0, _inherits3['default'])(CubicBezierEdge, _CubicBezierEdgeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function CubicBezierEdge(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, CubicBezierEdge);
    return (0, _possibleConstructorReturn3['default'])(this, (CubicBezierEdge.__proto__ || (0, _getPrototypeOf2['default'])(CubicBezierEdge)).call(this, options, body, labelModule));
  }

  /**
   * Draw a line between two nodes
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   * @param {Array.<Node>} viaNodes
   * @private
   */


  (0, _createClass3['default'])(CubicBezierEdge, [{
    key: '_line',
    value: function _line(ctx, values, viaNodes) {
      // get the coordinates of the support points.
      var via1 = viaNodes[0];
      var via2 = viaNodes[1];
      this._bezierCurve(ctx, values, via1, via2);
    }

    /**
     *
     * @returns {Array.<{x: number, y: number}>}
     * @private
     */

  }, {
    key: '_getViaCoordinates',
    value: function _getViaCoordinates() {
      var dx = this.from.x - this.to.x;
      var dy = this.from.y - this.to.y;

      var x1 = void 0,
          y1 = void 0,
          x2 = void 0,
          y2 = void 0;
      var roundness = this.options.smooth.roundness;

      // horizontal if x > y or if direction is forced or if direction is horizontal
      if ((Math.abs(dx) > Math.abs(dy) || this.options.smooth.forceDirection === true || this.options.smooth.forceDirection === 'horizontal') && this.options.smooth.forceDirection !== 'vertical') {
        y1 = this.from.y;
        y2 = this.to.y;
        x1 = this.from.x - roundness * dx;
        x2 = this.to.x + roundness * dx;
      } else {
        y1 = this.from.y - roundness * dy;
        y2 = this.to.y + roundness * dy;
        x1 = this.from.x;
        x2 = this.to.x;
      }

      return [{ x: x1, y: y1 }, { x: x2, y: y2 }];
    }

    /**
     *
     * @returns {Array.<{x: number, y: number}>}
     */

  }, {
    key: 'getViaNode',
    value: function getViaNode() {
      return this._getViaCoordinates();
    }

    /**
     *
     * @param {Node} nearNode
     * @param {CanvasRenderingContext2D} ctx
     * @returns {{x: number, y: number, t: number}}
     * @private
     */

  }, {
    key: '_findBorderPosition',
    value: function _findBorderPosition(nearNode, ctx) {
      return this._findBorderPositionBezier(nearNode, ctx);
    }

    /**
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {number} x3
     * @param {number} y3
     * @param {Node} via1
     * @param {Node} via2
     * @returns {number}
     * @private
     */

  }, {
    key: '_getDistanceToEdge',
    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      var _ref = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates(),
          _ref2 = (0, _slicedToArray3['default'])(_ref, 2),
          via1 = _ref2[0],
          via2 = _ref2[1];

      // x3,y3 is the point
      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, via1, via2);
    }

    /**
     * Combined function of pointOnLine and pointOnBezier. This gives the coordinates of a point on the line at a certain percentage of the way
     * @param {number} percentage
     * @param {{x: number, y: number}} [via1=this._getViaCoordinates()[0]]
     * @param {{x: number, y: number}} [via2=this._getViaCoordinates()[1]]
     * @returns {{x: number, y: number}}
     * @private
     */

  }, {
    key: 'getPoint',
    value: function getPoint(percentage) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates(),
          _ref4 = (0, _slicedToArray3['default'])(_ref3, 2),
          via1 = _ref4[0],
          via2 = _ref4[1];

      var t = percentage;
      var vec = [];
      vec[0] = Math.pow(1 - t, 3);
      vec[1] = 3 * t * Math.pow(1 - t, 2);
      vec[2] = 3 * Math.pow(t, 2) * (1 - t);
      vec[3] = Math.pow(t, 3);
      var x = vec[0] * this.fromPoint.x + vec[1] * via1.x + vec[2] * via2.x + vec[3] * this.toPoint.x;
      var y = vec[0] * this.fromPoint.y + vec[1] * via1.y + vec[2] * via2.y + vec[3] * this.toPoint.y;

      return { x: x, y: y };
    }
  }]);
  return CubicBezierEdge;
}(_CubicBezierEdgeBase3['default']);

exports['default'] = CubicBezierEdge;

/***/ }),
/* 167 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _BezierEdgeBase2 = __webpack_require__(56);

var _BezierEdgeBase3 = _interopRequireDefault(_BezierEdgeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Base Class for all Cubic Bezier Edges. Bezier curves are used to model
 * smooth gradual curves in paths between nodes.
 *
 * @extends BezierEdgeBase
 */
var CubicBezierEdgeBase = function (_BezierEdgeBase) {
  (0, _inherits3['default'])(CubicBezierEdgeBase, _BezierEdgeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function CubicBezierEdgeBase(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, CubicBezierEdgeBase);
    return (0, _possibleConstructorReturn3['default'])(this, (CubicBezierEdgeBase.__proto__ || (0, _getPrototypeOf2['default'])(CubicBezierEdgeBase)).call(this, options, body, labelModule));
  }

  /**
   * Calculate the distance between a point (x3,y3) and a line segment from
   * (x1,y1) to (x2,y2).
   * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
   * https://en.wikipedia.org/wiki/B%C3%A9zier_curve
   * @param {number} x1 from x
   * @param {number} y1 from y
   * @param {number} x2 to x
   * @param {number} y2 to y
   * @param {number} x3 point to check x
   * @param {number} y3 point to check y
   * @param {Node} via1
   * @param {Node} via2
   * @returns {number}
   * @private
   */


  (0, _createClass3['default'])(CubicBezierEdgeBase, [{
    key: '_getDistanceToBezierEdge',
    value: function _getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, via1, via2) {
      // x3,y3 is the point
      var minDistance = 1e9;
      var distance = void 0;
      var i = void 0,
          t = void 0,
          x = void 0,
          y = void 0;
      var lastX = x1;
      var lastY = y1;
      var vec = [0, 0, 0, 0];
      for (i = 1; i < 10; i++) {
        t = 0.1 * i;
        vec[0] = Math.pow(1 - t, 3);
        vec[1] = 3 * t * Math.pow(1 - t, 2);
        vec[2] = 3 * Math.pow(t, 2) * (1 - t);
        vec[3] = Math.pow(t, 3);
        x = vec[0] * x1 + vec[1] * via1.x + vec[2] * via2.x + vec[3] * x2;
        y = vec[0] * y1 + vec[1] * via1.y + vec[2] * via2.y + vec[3] * y2;
        if (i > 0) {
          distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);
          minDistance = distance < minDistance ? distance : minDistance;
        }
        lastX = x;
        lastY = y;
      }

      return minDistance;
    }
  }]);
  return CubicBezierEdgeBase;
}(_BezierEdgeBase3['default']);

exports['default'] = CubicBezierEdgeBase;

/***/ }),
/* 168 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = __webpack_require__(15);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _BezierEdgeBase2 = __webpack_require__(56);

var _BezierEdgeBase3 = _interopRequireDefault(_BezierEdgeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Dynamic Bezier Edge. Bezier curves are used to model smooth gradual
 * curves in paths between nodes. The Dynamic piece refers to how the curve
 * reacts to physics changes.
 *
 * @extends BezierEdgeBase
 */
var BezierEdgeDynamic = function (_BezierEdgeBase) {
  (0, _inherits3['default'])(BezierEdgeDynamic, _BezierEdgeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function BezierEdgeDynamic(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, BezierEdgeDynamic);

    // --> this calls the setOptions below
    var _this = (0, _possibleConstructorReturn3['default'])(this, (BezierEdgeDynamic.__proto__ || (0, _getPrototypeOf2['default'])(BezierEdgeDynamic)).call(this, options, body, labelModule));
    //this.via = undefined; // Here for completeness but not allowed to defined before super() is invoked.


    _this._boundFunction = function () {
      _this.positionBezierNode();
    };
    _this.body.emitter.on('_repositionBezierNodes', _this._boundFunction);
    return _this;
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3['default'])(BezierEdgeDynamic, [{
    key: 'setOptions',
    value: function setOptions(options) {
      // check if the physics has changed.
      var physicsChange = false;
      if (this.options.physics !== options.physics) {
        physicsChange = true;
      }

      // set the options and the to and from nodes
      this.options = options;
      this.id = this.options.id;
      this.from = this.body.nodes[this.options.from];
      this.to = this.body.nodes[this.options.to];

      // setup the support node and connect
      this.setupSupportNode();
      this.connect();

      // when we change the physics state of the edge, we reposition the support node.
      if (physicsChange === true) {
        this.via.setOptions({ physics: this.options.physics });
        this.positionBezierNode();
      }
    }

    /**
     * Connects an edge to node(s)
     */

  }, {
    key: 'connect',
    value: function connect() {
      this.from = this.body.nodes[this.options.from];
      this.to = this.body.nodes[this.options.to];
      if (this.from === undefined || this.to === undefined || this.options.physics === false) {
        this.via.setOptions({ physics: false });
      } else {
        // fix weird behaviour where a self referencing node has physics enabled
        if (this.from.id === this.to.id) {
          this.via.setOptions({ physics: false });
        } else {
          this.via.setOptions({ physics: true });
        }
      }
    }

    /**
     * remove the support nodes
     * @returns {boolean}
     */

  }, {
    key: 'cleanup',
    value: function cleanup() {
      this.body.emitter.off('_repositionBezierNodes', this._boundFunction);
      if (this.via !== undefined) {
        delete this.body.nodes[this.via.id];
        this.via = undefined;
        return true;
      }
      return false;
    }

    /**
     * Bezier curves require an anchor point to calculate the smooth flow. These points are nodes. These nodes are invisible but
     * are used for the force calculation.
     *
     * The changed data is not called, if needed, it is returned by the main edge constructor.
     * @private
     */

  }, {
    key: 'setupSupportNode',
    value: function setupSupportNode() {
      if (this.via === undefined) {
        var nodeId = 'edgeId:' + this.id;
        var node = this.body.functions.createNode({
          id: nodeId,
          shape: 'circle',
          physics: true,
          hidden: true
        });
        this.body.nodes[nodeId] = node;
        this.via = node;
        this.via.parentEdgeId = this.id;
        this.positionBezierNode();
      }
    }

    /**
     * Positions bezier node
     */

  }, {
    key: 'positionBezierNode',
    value: function positionBezierNode() {
      if (this.via !== undefined && this.from !== undefined && this.to !== undefined) {
        this.via.x = 0.5 * (this.from.x + this.to.x);
        this.via.y = 0.5 * (this.from.y + this.to.y);
      } else if (this.via !== undefined) {
        this.via.x = 0;
        this.via.y = 0;
      }
    }

    /**
     * Draw a line between two nodes
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     * @param {Node} viaNode
     * @private
     */

  }, {
    key: '_line',
    value: function _line(ctx, values, viaNode) {
      this._bezierCurve(ctx, values, viaNode);
    }

    /**
     *
     * @returns {Node|undefined|*|{index, line, column}}
     */

  }, {
    key: 'getViaNode',
    value: function getViaNode() {
      return this.via;
    }

    /**
     * Combined function of pointOnLine and pointOnBezier. This gives the coordinates of a point on the line at a certain percentage of the way
     *
     * @param {number} percentage
     * @param {Node} viaNode
     * @returns {{x: number, y: number}}
     * @private
     */

  }, {
    key: 'getPoint',
    value: function getPoint(percentage) {
      var viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.via;

      var t = percentage;
      var x = void 0,
          y = void 0;
      if (this.from === this.to) {
        var _getCircleData = this._getCircleData(this.from),
            _getCircleData2 = (0, _slicedToArray3['default'])(_getCircleData, 3),
            cx = _getCircleData2[0],
            cy = _getCircleData2[1],
            cr = _getCircleData2[2];

        var a = 2 * Math.PI * (1 - t);
        x = cx + cr * Math.sin(a);
        y = cy + cr - cr * (1 - Math.cos(a));
      } else {
        x = Math.pow(1 - t, 2) * this.fromPoint.x + 2 * t * (1 - t) * viaNode.x + Math.pow(t, 2) * this.toPoint.x;
        y = Math.pow(1 - t, 2) * this.fromPoint.y + 2 * t * (1 - t) * viaNode.y + Math.pow(t, 2) * this.toPoint.y;
      }

      return { x: x, y: y };
    }

    /**
     *
     * @param {Node} nearNode
     * @param {CanvasRenderingContext2D} ctx
     * @returns {*}
     * @private
     */

  }, {
    key: '_findBorderPosition',
    value: function _findBorderPosition(nearNode, ctx) {
      return this._findBorderPositionBezier(nearNode, ctx, this.via);
    }

    /**
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {number} x3
     * @param {number} y3
     * @returns {number}
     * @private
     */

  }, {
    key: '_getDistanceToEdge',
    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      // x3,y3 is the point
      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, this.via);
    }
  }]);
  return BezierEdgeDynamic;
}(_BezierEdgeBase3['default']);

exports['default'] = BezierEdgeDynamic;

/***/ }),
/* 169 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _BezierEdgeBase2 = __webpack_require__(56);

var _BezierEdgeBase3 = _interopRequireDefault(_BezierEdgeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Static Bezier Edge. Bezier curves are used to model smooth gradual
 * curves in paths between nodes.
 *
 * @extends BezierEdgeBase
 */
var BezierEdgeStatic = function (_BezierEdgeBase) {
  (0, _inherits3['default'])(BezierEdgeStatic, _BezierEdgeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function BezierEdgeStatic(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, BezierEdgeStatic);
    return (0, _possibleConstructorReturn3['default'])(this, (BezierEdgeStatic.__proto__ || (0, _getPrototypeOf2['default'])(BezierEdgeStatic)).call(this, options, body, labelModule));
  }

  /**
   * Draw a line between two nodes
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   * @param {Node} viaNode
   * @private
   */


  (0, _createClass3['default'])(BezierEdgeStatic, [{
    key: '_line',
    value: function _line(ctx, values, viaNode) {
      this._bezierCurve(ctx, values, viaNode);
    }

    /**
     *
     * @returns {Array.<{x: number, y: number}>}
     */

  }, {
    key: 'getViaNode',
    value: function getViaNode() {
      return this._getViaCoordinates();
    }

    /**
     * We do not use the to and fromPoints here to make the via nodes the same as edges without arrows.
     * @returns {{x: undefined, y: undefined}}
     * @private
     */

  }, {
    key: '_getViaCoordinates',
    value: function _getViaCoordinates() {
      // Assumption: x/y coordinates in from/to always defined
      var xVia = undefined;
      var yVia = undefined;
      var factor = this.options.smooth.roundness;
      var type = this.options.smooth.type;
      var dx = Math.abs(this.from.x - this.to.x);
      var dy = Math.abs(this.from.y - this.to.y);
      if (type === 'discrete' || type === 'diagonalCross') {
        var stepX = void 0;
        var stepY = void 0;

        if (dx <= dy) {
          stepX = stepY = factor * dy;
        } else {
          stepX = stepY = factor * dx;
        }

        if (this.from.x > this.to.x) stepX = -stepX;
        if (this.from.y >= this.to.y) stepY = -stepY;

        xVia = this.from.x + stepX;
        yVia = this.from.y + stepY;

        if (type === 'discrete') {
          if (dx <= dy) {
            xVia = dx < factor * dy ? this.from.x : xVia;
          } else {
            yVia = dy < factor * dx ? this.from.y : yVia;
          }
        }
      } else if (type === 'straightCross') {
        var _stepX = (1 - factor) * dx;
        var _stepY = (1 - factor) * dy;

        if (dx <= dy) {
          // up - down
          _stepX = 0;
          if (this.from.y < this.to.y) _stepY = -_stepY;
        } else {
          // left - right
          if (this.from.x < this.to.x) _stepX = -_stepX;
          _stepY = 0;
        }
        xVia = this.to.x + _stepX;
        yVia = this.to.y + _stepY;
      } else if (type === 'horizontal') {
        var _stepX2 = (1 - factor) * dx;
        if (this.from.x < this.to.x) _stepX2 = -_stepX2;
        xVia = this.to.x + _stepX2;
        yVia = this.from.y;
      } else if (type === 'vertical') {
        var _stepY2 = (1 - factor) * dy;
        if (this.from.y < this.to.y) _stepY2 = -_stepY2;
        xVia = this.from.x;
        yVia = this.to.y + _stepY2;
      } else if (type === 'curvedCW') {
        dx = this.to.x - this.from.x;
        dy = this.from.y - this.to.y;
        var radius = Math.sqrt(dx * dx + dy * dy);
        var pi = Math.PI;

        var originalAngle = Math.atan2(dy, dx);
        var myAngle = (originalAngle + (factor * 0.5 + 0.5) * pi) % (2 * pi);

        xVia = this.from.x + (factor * 0.5 + 0.5) * radius * Math.sin(myAngle);
        yVia = this.from.y + (factor * 0.5 + 0.5) * radius * Math.cos(myAngle);
      } else if (type === 'curvedCCW') {
        dx = this.to.x - this.from.x;
        dy = this.from.y - this.to.y;
        var _radius = Math.sqrt(dx * dx + dy * dy);
        var _pi = Math.PI;

        var _originalAngle = Math.atan2(dy, dx);
        var _myAngle = (_originalAngle + (-factor * 0.5 + 0.5) * _pi) % (2 * _pi);

        xVia = this.from.x + (factor * 0.5 + 0.5) * _radius * Math.sin(_myAngle);
        yVia = this.from.y + (factor * 0.5 + 0.5) * _radius * Math.cos(_myAngle);
      } else {
        // continuous
        var _stepX3 = void 0;
        var _stepY3 = void 0;

        if (dx <= dy) {
          _stepX3 = _stepY3 = factor * dy;
        } else {
          _stepX3 = _stepY3 = factor * dx;
        }

        if (this.from.x > this.to.x) _stepX3 = -_stepX3;
        if (this.from.y >= this.to.y) _stepY3 = -_stepY3;

        xVia = this.from.x + _stepX3;
        yVia = this.from.y + _stepY3;

        if (dx <= dy) {
          if (this.from.x <= this.to.x) {
            xVia = this.to.x < xVia ? this.to.x : xVia;
          } else {
            xVia = this.to.x > xVia ? this.to.x : xVia;
          }
        } else {
          if (this.from.y >= this.to.y) {
            yVia = this.to.y > yVia ? this.to.y : yVia;
          } else {
            yVia = this.to.y < yVia ? this.to.y : yVia;
          }
        }
      }
      return { x: xVia, y: yVia };
    }

    /**
     *
     * @param {Node} nearNode
     * @param {CanvasRenderingContext2D} ctx
     * @param {Object} options
     * @returns {*}
     * @private
     */

  }, {
    key: '_findBorderPosition',
    value: function _findBorderPosition(nearNode, ctx) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      return this._findBorderPositionBezier(nearNode, ctx, options.via);
    }

    /**
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {number} x3
     * @param {number} y3
     * @param {Node} viaNode
     * @returns {number}
     * @private
     */

  }, {
    key: '_getDistanceToEdge',
    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      var viaNode = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates();

      // x3,y3 is the point
      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, viaNode);
    }

    /**
     * Combined function of pointOnLine and pointOnBezier. This gives the coordinates of a point on the line at a certain percentage of the way
     * @param {number} percentage
     * @param {Node} viaNode
     * @returns {{x: number, y: number}}
     * @private
     */

  }, {
    key: 'getPoint',
    value: function getPoint(percentage) {
      var viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates();

      var t = percentage;
      var x = Math.pow(1 - t, 2) * this.fromPoint.x + 2 * t * (1 - t) * viaNode.x + Math.pow(t, 2) * this.toPoint.x;
      var y = Math.pow(1 - t, 2) * this.fromPoint.y + 2 * t * (1 - t) * viaNode.y + Math.pow(t, 2) * this.toPoint.y;

      return { x: x, y: y };
    }
  }]);
  return BezierEdgeStatic;
}(_BezierEdgeBase3['default']);

exports['default'] = BezierEdgeStatic;

/***/ }),
/* 170 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _EdgeBase2 = __webpack_require__(79);

var _EdgeBase3 = _interopRequireDefault(_EdgeBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * A Straight Edge.
 *
 * @extends EdgeBase
 */
var StraightEdge = function (_EdgeBase) {
  (0, _inherits3['default'])(StraightEdge, _EdgeBase);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Label} labelModule
   */
  function StraightEdge(options, body, labelModule) {
    (0, _classCallCheck3['default'])(this, StraightEdge);
    return (0, _possibleConstructorReturn3['default'])(this, (StraightEdge.__proto__ || (0, _getPrototypeOf2['default'])(StraightEdge)).call(this, options, body, labelModule));
  }

  /**
   * Draw a line between two nodes
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   * @private
   */


  (0, _createClass3['default'])(StraightEdge, [{
    key: '_line',
    value: function _line(ctx, values) {
      // draw a straight line
      ctx.beginPath();
      ctx.moveTo(this.fromPoint.x, this.fromPoint.y);
      ctx.lineTo(this.toPoint.x, this.toPoint.y);
      // draw shadow if enabled
      this.enableShadow(ctx, values);
      ctx.stroke();
      this.disableShadow(ctx, values);
    }

    /**
     *
     * @returns {undefined}
     */

  }, {
    key: 'getViaNode',
    value: function getViaNode() {
      return undefined;
    }

    /**
     * Combined function of pointOnLine and pointOnBezier. This gives the coordinates of a point on the line at a certain percentage of the way
     *
     * @param {number} percentage
     * @returns {{x: number, y: number}}
     * @private
     */

  }, {
    key: 'getPoint',
    value: function getPoint(percentage) {
      return {
        x: (1 - percentage) * this.fromPoint.x + percentage * this.toPoint.x,
        y: (1 - percentage) * this.fromPoint.y + percentage * this.toPoint.y
      };
    }

    /**
     *
     * @param {Node} nearNode
     * @param {CanvasRenderingContext2D} ctx
     * @returns {{x: number, y: number}}
     * @private
     */

  }, {
    key: '_findBorderPosition',
    value: function _findBorderPosition(nearNode, ctx) {
      var node1 = this.to;
      var node2 = this.from;
      if (nearNode.id === this.from.id) {
        node1 = this.from;
        node2 = this.to;
      }

      var angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
      var dx = node1.x - node2.x;
      var dy = node1.y - node2.y;
      var edgeSegmentLength = Math.sqrt(dx * dx + dy * dy);
      var toBorderDist = nearNode.distanceToBorder(ctx, angle);
      var toBorderPoint = (edgeSegmentLength - toBorderDist) / edgeSegmentLength;

      var borderPos = {};
      borderPos.x = (1 - toBorderPoint) * node2.x + toBorderPoint * node1.x;
      borderPos.y = (1 - toBorderPoint) * node2.y + toBorderPoint * node1.y;

      return borderPos;
    }

    /**
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {number} x3
     * @param {number} y3
     * @returns {number}
     * @private
     */

  }, {
    key: '_getDistanceToEdge',
    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      // x3,y3 is the point
      return this._getDistanceToLine(x1, y1, x2, y2, x3, y3);
    }
  }]);
  return StraightEdge;
}(_EdgeBase3['default']);

exports['default'] = StraightEdge;

/***/ }),
/* 171 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _keys = __webpack_require__(9);

var _keys2 = _interopRequireDefault(_keys);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var BarnesHutSolver = __webpack_require__(81)['default'];
var Repulsion = __webpack_require__(172)['default'];
var HierarchicalRepulsion = __webpack_require__(173)['default'];
var SpringSolver = __webpack_require__(174)['default'];
var HierarchicalSpringSolver = __webpack_require__(175)['default'];
var CentralGravitySolver = __webpack_require__(82)['default'];
var ForceAtlas2BasedRepulsionSolver = __webpack_require__(176)['default'];
var ForceAtlas2BasedCentralGravitySolver = __webpack_require__(177)['default'];
var util = __webpack_require__(2);
var EndPoints = __webpack_require__(80)['default']; // for debugging with _drawForces()

/**
 * The physics engine
 */

var PhysicsEngine = function () {
  /**
   * @param {Object} body
   */
  function PhysicsEngine(body) {
    (0, _classCallCheck3['default'])(this, PhysicsEngine);

    this.body = body;
    this.physicsBody = {
      physicsNodeIndices: [],
      physicsEdgeIndices: [],
      forces: {},
      velocities: {}
    };

    this.physicsEnabled = true;
    this.simulationInterval = 1000 / 60;
    this.requiresTimeout = true;
    this.previousStates = {};
    this.referenceState = {};
    this.freezeCache = {};
    this.renderTimer = undefined;

    // parameters for the adaptive timestep
    this.adaptiveTimestep = false;
    this.adaptiveTimestepEnabled = false;
    this.adaptiveCounter = 0;
    this.adaptiveInterval = 3;

    this.stabilized = false;
    this.startedStabilization = false;
    this.stabilizationIterations = 0;
    this.ready = false; // will be set to true if the stabilize

    // default options
    this.options = {};
    this.defaultOptions = {
      enabled: true,
      barnesHut: {
        theta: 0.5,
        gravitationalConstant: -2000,
        centralGravity: 0.3,
        springLength: 95,
        springConstant: 0.04,
        damping: 0.09,
        avoidOverlap: 0
      },
      forceAtlas2Based: {
        theta: 0.5,
        gravitationalConstant: -50,
        centralGravity: 0.01,
        springConstant: 0.08,
        springLength: 100,
        damping: 0.4,
        avoidOverlap: 0
      },
      repulsion: {
        centralGravity: 0.2,
        springLength: 200,
        springConstant: 0.05,
        nodeDistance: 100,
        damping: 0.09,
        avoidOverlap: 0
      },
      hierarchicalRepulsion: {
        centralGravity: 0.0,
        springLength: 100,
        springConstant: 0.01,
        nodeDistance: 120,
        damping: 0.09
      },
      maxVelocity: 50,
      minVelocity: 0.75, // px/s
      solver: 'barnesHut',
      stabilization: {
        enabled: true,
        iterations: 1000, // maximum number of iteration to stabilize
        updateInterval: 50,
        onlyDynamicEdges: false,
        fit: true
      },
      timestep: 0.5,
      adaptiveTimestep: true
    };
    util.extend(this.options, this.defaultOptions);
    this.timestep = 0.5;
    this.layoutFailed = false;

    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */


  (0, _createClass3['default'])(PhysicsEngine, [{
    key: 'bindEventListeners',
    value: function bindEventListeners() {
      var _this = this;

      this.body.emitter.on('initPhysics', function () {
        _this.initPhysics();
      });
      this.body.emitter.on('_layoutFailed', function () {
        _this.layoutFailed = true;
      });
      this.body.emitter.on('resetPhysics', function () {
        _this.stopSimulation();
        _this.ready = false;
      });
      this.body.emitter.on('disablePhysics', function () {
        _this.physicsEnabled = false;
        _this.stopSimulation();
      });
      this.body.emitter.on('restorePhysics', function () {
        _this.setOptions(_this.options);
        if (_this.ready === true) {
          _this.startSimulation();
        }
      });
      this.body.emitter.on('startSimulation', function () {
        if (_this.ready === true) {
          _this.startSimulation();
        }
      });
      this.body.emitter.on('stopSimulation', function () {
        _this.stopSimulation();
      });
      this.body.emitter.on('destroy', function () {
        _this.stopSimulation(false);
        _this.body.emitter.off();
      });
      this.body.emitter.on('_dataChanged', function () {
        // Nodes and/or edges have been added or removed, update shortcut lists.
        _this.updatePhysicsData();
      });

      // debug: show forces
      // this.body.emitter.on("afterDrawing", (ctx) => {this._drawForces(ctx);});
    }

    /**
     * set the physics options
     * @param {Object} options
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      if (options !== undefined) {
        if (options === false) {
          this.options.enabled = false;
          this.physicsEnabled = false;
          this.stopSimulation();
        } else if (options === true) {
          this.options.enabled = true;
          this.physicsEnabled = true;
          this.startSimulation();
        } else {
          this.physicsEnabled = true;
          util.selectiveNotDeepExtend(['stabilization'], this.options, options);
          util.mergeOptions(this.options, options, 'stabilization');

          if (options.enabled === undefined) {
            this.options.enabled = true;
          }

          if (this.options.enabled === false) {
            this.physicsEnabled = false;
            this.stopSimulation();
          }

          // set the timestep
          this.timestep = this.options.timestep;
        }
      }
      this.init();
    }

    /**
     * configure the engine.
     */

  }, {
    key: 'init',
    value: function init() {
      var options;
      if (this.options.solver === 'forceAtlas2Based') {
        options = this.options.forceAtlas2Based;
        this.nodesSolver = new ForceAtlas2BasedRepulsionSolver(this.body, this.physicsBody, options);
        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
        this.gravitySolver = new ForceAtlas2BasedCentralGravitySolver(this.body, this.physicsBody, options);
      } else if (this.options.solver === 'repulsion') {
        options = this.options.repulsion;
        this.nodesSolver = new Repulsion(this.body, this.physicsBody, options);
        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
      } else if (this.options.solver === 'hierarchicalRepulsion') {
        options = this.options.hierarchicalRepulsion;
        this.nodesSolver = new HierarchicalRepulsion(this.body, this.physicsBody, options);
        this.edgesSolver = new HierarchicalSpringSolver(this.body, this.physicsBody, options);
        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
      } else {
        // barnesHut
        options = this.options.barnesHut;
        this.nodesSolver = new BarnesHutSolver(this.body, this.physicsBody, options);
        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
      }

      this.modelOptions = options;
    }

    /**
     * initialize the engine
     */

  }, {
    key: 'initPhysics',
    value: function initPhysics() {
      if (this.physicsEnabled === true && this.options.enabled === true) {
        if (this.options.stabilization.enabled === true) {
          this.stabilize();
        } else {
          this.stabilized = false;
          this.ready = true;
          this.body.emitter.emit('fit', {}, this.layoutFailed); // if the layout failed, we use the approximation for the zoom
          this.startSimulation();
        }
      } else {
        this.ready = true;
        this.body.emitter.emit('fit');
      }
    }

    /**
     * Start the simulation
     */

  }, {
    key: 'startSimulation',
    value: function startSimulation() {
      if (this.physicsEnabled === true && this.options.enabled === true) {
        this.stabilized = false;

        // when visible, adaptivity is disabled.
        this.adaptiveTimestep = false;

        // this sets the width of all nodes initially which could be required for the avoidOverlap
        this.body.emitter.emit('_resizeNodes');
        if (this.viewFunction === undefined) {
          this.viewFunction = this.simulationStep.bind(this);
          this.body.emitter.on('initRedraw', this.viewFunction);
          this.body.emitter.emit('_startRendering');
        }
      } else {
        this.body.emitter.emit('_redraw');
      }
    }

    /**
     * Stop the simulation, force stabilization.
     * @param {boolean} [emit=true]
     */

  }, {
    key: 'stopSimulation',
    value: function stopSimulation() {
      var emit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      this.stabilized = true;
      if (emit === true) {
        this._emitStabilized();
      }
      if (this.viewFunction !== undefined) {
        this.body.emitter.off('initRedraw', this.viewFunction);
        this.viewFunction = undefined;
        if (emit === true) {
          this.body.emitter.emit('_stopRendering');
        }
      }
    }

    /**
     * The viewFunction inserts this step into each render loop. It calls the physics tick and handles the cleanup at stabilized.
     *
     */

  }, {
    key: 'simulationStep',
    value: function simulationStep() {
      // check if the physics have settled
      var startTime = Date.now();
      this.physicsTick();
      var physicsTime = Date.now() - startTime;

      // run double speed if it is a little graph
      if ((physicsTime < 0.4 * this.simulationInterval || this.runDoubleSpeed === true) && this.stabilized === false) {
        this.physicsTick();

        // this makes sure there is no jitter. The decision is taken once to run it at double speed.
        this.runDoubleSpeed = true;
      }

      if (this.stabilized === true) {
        this.stopSimulation();
      }
    }

    /**
     * trigger the stabilized event.
     *
     * @param {number} [amountOfIterations=this.stabilizationIterations]
     * @private
     */

  }, {
    key: '_emitStabilized',
    value: function _emitStabilized() {
      var _this2 = this;

      var amountOfIterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.stabilizationIterations;

      if (this.stabilizationIterations > 1 || this.startedStabilization === true) {
        setTimeout(function () {
          _this2.body.emitter.emit('stabilized', { iterations: amountOfIterations });
          _this2.startedStabilization = false;
          _this2.stabilizationIterations = 0;
        }, 0);
      }
    }

    /**
     * Calculate the forces for one physics iteration and move the nodes.
     * @private
     */

  }, {
    key: 'physicsStep',
    value: function physicsStep() {
      this.gravitySolver.solve();
      this.nodesSolver.solve();
      this.edgesSolver.solve();
      this.moveNodes();
    }

    /**
     * Make dynamic adjustments to the timestep, based on current state.
     *
     * Helper function for physicsTick().
     * @private
     */

  }, {
    key: 'adjustTimeStep',
    value: function adjustTimeStep() {
      var factor = 1.2; // Factor for increasing the timestep on success.

      // we compare the two steps. if it is acceptable we double the step.
      if (this._evaluateStepQuality() === true) {
        this.timestep = factor * this.timestep;
      } else {
        // if not, we decrease the step to a minimum of the options timestep.
        // if the decreased timestep is smaller than the options step, we do not reset the counter
        // we assume that the options timestep is stable enough.
        if (this.timestep / factor < this.options.timestep) {
          this.timestep = this.options.timestep;
        } else {
          // if the timestep was larger than 2 times the option one we check the adaptivity again to ensure
          // that large instabilities do not form.
          this.adaptiveCounter = -1; // check again next iteration
          this.timestep = Math.max(this.options.timestep, this.timestep / factor);
        }
      }
    }

    /**
     * A single simulation step (or 'tick') in the physics simulation
     *
     * @private
     */

  }, {
    key: 'physicsTick',
    value: function physicsTick() {
      this._startStabilizing(); // this ensures that there is no start event when the network is already stable.
      if (this.stabilized === true) return;

      // adaptivity means the timestep adapts to the situation, only applicable for stabilization
      if (this.adaptiveTimestep === true && this.adaptiveTimestepEnabled === true) {
        // timestep remains stable for "interval" iterations.
        var doAdaptive = this.adaptiveCounter % this.adaptiveInterval === 0;

        if (doAdaptive) {
          // first the big step and revert.
          this.timestep = 2 * this.timestep;
          this.physicsStep();
          this.revert(); // saves the reference state

          // now the normal step. Since this is the last step, it is the more stable one and we will take this.
          this.timestep = 0.5 * this.timestep;

          // since it's half the step, we do it twice.
          this.physicsStep();
          this.physicsStep();

          this.adjustTimeStep();
        } else {
          this.physicsStep(); // normal step, keeping timestep constant
        }

        this.adaptiveCounter += 1;
      } else {
        // case for the static timestep, we reset it to the one in options and take a normal step.
        this.timestep = this.options.timestep;
        this.physicsStep();
      }

      if (this.stabilized === true) this.revert();
      this.stabilizationIterations++;
    }

    /**
     * Nodes and edges can have the physics toggles on or off. A collection of indices is created here so we can skip the check all the time.
     *
     * @private
     */

  }, {
    key: 'updatePhysicsData',
    value: function updatePhysicsData() {
      this.physicsBody.forces = {};
      this.physicsBody.physicsNodeIndices = [];
      this.physicsBody.physicsEdgeIndices = [];
      var nodes = this.body.nodes;
      var edges = this.body.edges;

      // get node indices for physics
      for (var nodeId in nodes) {
        if (nodes.hasOwnProperty(nodeId)) {
          if (nodes[nodeId].options.physics === true) {
            this.physicsBody.physicsNodeIndices.push(nodes[nodeId].id);
          }
        }
      }

      // get edge indices for physics
      for (var edgeId in edges) {
        if (edges.hasOwnProperty(edgeId)) {
          if (edges[edgeId].options.physics === true) {
            this.physicsBody.physicsEdgeIndices.push(edges[edgeId].id);
          }
        }
      }

      // get the velocity and the forces vector
      for (var i = 0; i < this.physicsBody.physicsNodeIndices.length; i++) {
        var _nodeId = this.physicsBody.physicsNodeIndices[i];
        this.physicsBody.forces[_nodeId] = { x: 0, y: 0

          // forces can be reset because they are recalculated. Velocities have to persist.
        };if (this.physicsBody.velocities[_nodeId] === undefined) {
          this.physicsBody.velocities[_nodeId] = { x: 0, y: 0 };
        }
      }

      // clean deleted nodes from the velocity vector
      for (var _nodeId2 in this.physicsBody.velocities) {
        if (nodes[_nodeId2] === undefined) {
          delete this.physicsBody.velocities[_nodeId2];
        }
      }
    }

    /**
     * Revert the simulation one step. This is done so after stabilization, every new start of the simulation will also say stabilized.
     */

  }, {
    key: 'revert',
    value: function revert() {
      var nodeIds = (0, _keys2['default'])(this.previousStates);
      var nodes = this.body.nodes;
      var velocities = this.physicsBody.velocities;
      this.referenceState = {};

      for (var i = 0; i < nodeIds.length; i++) {
        var nodeId = nodeIds[i];
        if (nodes[nodeId] !== undefined) {
          if (nodes[nodeId].options.physics === true) {
            this.referenceState[nodeId] = {
              positions: { x: nodes[nodeId].x, y: nodes[nodeId].y }
            };
            velocities[nodeId].x = this.previousStates[nodeId].vx;
            velocities[nodeId].y = this.previousStates[nodeId].vy;
            nodes[nodeId].x = this.previousStates[nodeId].x;
            nodes[nodeId].y = this.previousStates[nodeId].y;
          }
        } else {
          delete this.previousStates[nodeId];
        }
      }
    }

    /**
     * This compares the reference state to the current state
     *
     * @returns {boolean}
     * @private
     */

  }, {
    key: '_evaluateStepQuality',
    value: function _evaluateStepQuality() {
      var dx = void 0,
          dy = void 0,
          dpos = void 0;
      var nodes = this.body.nodes;
      var reference = this.referenceState;
      var posThreshold = 0.3;

      for (var nodeId in this.referenceState) {
        if (this.referenceState.hasOwnProperty(nodeId) && nodes[nodeId] !== undefined) {
          dx = nodes[nodeId].x - reference[nodeId].positions.x;
          dy = nodes[nodeId].y - reference[nodeId].positions.y;

          dpos = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));

          if (dpos > posThreshold) {
            return false;
          }
        }
      }
      return true;
    }

    /**
     * move the nodes one timestep and check if they are stabilized
     */

  }, {
    key: 'moveNodes',
    value: function moveNodes() {
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var maxNodeVelocity = 0;
      var averageNodeVelocity = 0;

      // the velocity threshold (energy in the system) for the adaptivity toggle
      var velocityAdaptiveThreshold = 5;

      for (var i = 0; i < nodeIndices.length; i++) {
        var nodeId = nodeIndices[i];
        var nodeVelocity = this._performStep(nodeId);
        // stabilized is true if stabilized is true and velocity is smaller than vmin --> all nodes must be stabilized
        maxNodeVelocity = Math.max(maxNodeVelocity, nodeVelocity);
        averageNodeVelocity += nodeVelocity;
      }

      // evaluating the stabilized and adaptiveTimestepEnabled conditions
      this.adaptiveTimestepEnabled = averageNodeVelocity / nodeIndices.length < velocityAdaptiveThreshold;
      this.stabilized = maxNodeVelocity < this.options.minVelocity;
    }

    /**
     * Calculate new velocity for a coordinate direction
     *
     * @param {number} v  velocity for current coordinate
     * @param {number} f  regular force for current coordinate
     * @param {number} m  mass of current node
     * @returns {number} new velocity for current coordinate
     * @private
     */

  }, {
    key: 'calculateComponentVelocity',
    value: function calculateComponentVelocity(v, f, m) {
      var df = this.modelOptions.damping * v; // damping force
      var a = (f - df) / m; // acceleration

      v += a * this.timestep;

      // Put a limit on the velocities if it is really high
      var maxV = this.options.maxVelocity || 1e9;
      if (Math.abs(v) > maxV) {
        v = v > 0 ? maxV : -maxV;
      }

      return v;
    }

    /**
     * Perform the actual step
     *
     * @param {Node.id} nodeId
     * @returns {number} the new velocity of given node
     * @private
     */

  }, {
    key: '_performStep',
    value: function _performStep(nodeId) {
      var node = this.body.nodes[nodeId];
      var force = this.physicsBody.forces[nodeId];
      var velocity = this.physicsBody.velocities[nodeId];

      // store the state so we can revert
      this.previousStates[nodeId] = {
        x: node.x,
        y: node.y,
        vx: velocity.x,
        vy: velocity.y
      };

      if (node.options.fixed.x === false) {
        velocity.x = this.calculateComponentVelocity(velocity.x, force.x, node.options.mass);
        node.x += velocity.x * this.timestep;
      } else {
        force.x = 0;
        velocity.x = 0;
      }

      if (node.options.fixed.y === false) {
        velocity.y = this.calculateComponentVelocity(velocity.y, force.y, node.options.mass);
        node.y += velocity.y * this.timestep;
      } else {
        force.y = 0;
        velocity.y = 0;
      }

      var totalVelocity = Math.sqrt(Math.pow(velocity.x, 2) + Math.pow(velocity.y, 2));
      return totalVelocity;
    }

    /**
     * When initializing and stabilizing, we can freeze nodes with a predefined position.
     * This greatly speeds up stabilization because only the supportnodes for the smoothCurves have to settle.
     *
     * @private
     */

  }, {
    key: '_freezeNodes',
    value: function _freezeNodes() {
      var nodes = this.body.nodes;
      for (var id in nodes) {
        if (nodes.hasOwnProperty(id)) {
          if (nodes[id].x && nodes[id].y) {
            var fixed = nodes[id].options.fixed;
            this.freezeCache[id] = { x: fixed.x, y: fixed.y };
            fixed.x = true;
            fixed.y = true;
          }
        }
      }
    }

    /**
     * Unfreezes the nodes that have been frozen by _freezeDefinedNodes.
     *
     * @private
     */

  }, {
    key: '_restoreFrozenNodes',
    value: function _restoreFrozenNodes() {
      var nodes = this.body.nodes;
      for (var id in nodes) {
        if (nodes.hasOwnProperty(id)) {
          if (this.freezeCache[id] !== undefined) {
            nodes[id].options.fixed.x = this.freezeCache[id].x;
            nodes[id].options.fixed.y = this.freezeCache[id].y;
          }
        }
      }
      this.freezeCache = {};
    }

    /**
     * Find a stable position for all nodes
     *
     * @param {number} [iterations=this.options.stabilization.iterations]
     */

  }, {
    key: 'stabilize',
    value: function stabilize() {
      var _this3 = this;

      var iterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.options.stabilization.iterations;

      if (typeof iterations !== 'number') {
        iterations = this.options.stabilization.iterations;
        console.log('The stabilize method needs a numeric amount of iterations. Switching to default: ', iterations);
      }

      if (this.physicsBody.physicsNodeIndices.length === 0) {
        this.ready = true;
        return;
      }

      // enable adaptive timesteps
      this.adaptiveTimestep = true && this.options.adaptiveTimestep;

      // this sets the width of all nodes initially which could be required for the avoidOverlap
      this.body.emitter.emit('_resizeNodes');

      this.stopSimulation(); // stop the render loop
      this.stabilized = false;

      // block redraw requests
      this.body.emitter.emit('_blockRedraw');
      this.targetIterations = iterations;

      // start the stabilization
      if (this.options.stabilization.onlyDynamicEdges === true) {
        this._freezeNodes();
      }
      this.stabilizationIterations = 0;

      setTimeout(function () {
        return _this3._stabilizationBatch();
      }, 0);
    }

    /**
     * If not already stabilizing, start it and emit a start event.
     *
     * @returns {boolean} true if stabilization started with this call
     * @private
     */

  }, {
    key: '_startStabilizing',
    value: function _startStabilizing() {
      if (this.startedStabilization === true) return false;

      this.body.emitter.emit('startStabilizing');
      this.startedStabilization = true;
      return true;
    }

    /**
     * One batch of stabilization
     * @private
     */

  }, {
    key: '_stabilizationBatch',
    value: function _stabilizationBatch() {
      var _this4 = this;

      var running = function running() {
        return _this4.stabilized === false && _this4.stabilizationIterations < _this4.targetIterations;
      };

      var sendProgress = function sendProgress() {
        _this4.body.emitter.emit('stabilizationProgress', {
          iterations: _this4.stabilizationIterations,
          total: _this4.targetIterations
        });
      };

      if (this._startStabilizing()) {
        sendProgress(); // Ensure that there is at least one start event.
      }

      var count = 0;
      while (running() && count < this.options.stabilization.updateInterval) {
        this.physicsTick();
        count++;
      }

      sendProgress();

      if (running()) {
        setTimeout(this._stabilizationBatch.bind(this), 0);
      } else {
        this._finalizeStabilization();
      }
    }

    /**
     * Wrap up the stabilization, fit and emit the events.
     * @private
     */

  }, {
    key: '_finalizeStabilization',
    value: function _finalizeStabilization() {
      this.body.emitter.emit('_allowRedraw');
      if (this.options.stabilization.fit === true) {
        this.body.emitter.emit('fit');
      }

      if (this.options.stabilization.onlyDynamicEdges === true) {
        this._restoreFrozenNodes();
      }

      this.body.emitter.emit('stabilizationIterationsDone');
      this.body.emitter.emit('_requestRedraw');

      if (this.stabilized === true) {
        this._emitStabilized();
      } else {
        this.startSimulation();
      }

      this.ready = true;
    }

    //---------------------------  DEBUGGING BELOW  ---------------------------//

    /**
     * Debug function that display arrows for the forces currently active in the network.
     *
     * Use this when debugging only.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @private
     */

  }, {
    key: '_drawForces',
    value: function _drawForces(ctx) {
      for (var i = 0; i < this.physicsBody.physicsNodeIndices.length; i++) {
        var index = this.physicsBody.physicsNodeIndices[i];
        var node = this.body.nodes[index];
        var force = this.physicsBody.forces[index];
        var factor = 20;
        var colorFactor = 0.03;
        var forceSize = Math.sqrt(Math.pow(force.x, 2) + Math.pow(force.x, 2));

        var size = Math.min(Math.max(5, forceSize), 15);
        var arrowSize = 3 * size;

        var color = util.HSVToHex((180 - Math.min(1, Math.max(0, colorFactor * forceSize)) * 180) / 360, 1, 1);

        var point = {
          x: node.x + factor * force.x,
          y: node.y + factor * force.y
        };

        ctx.lineWidth = size;
        ctx.strokeStyle = color;
        ctx.beginPath();
        ctx.moveTo(node.x, node.y);
        ctx.lineTo(point.x, point.y);
        ctx.stroke();

        var angle = Math.atan2(force.y, force.x);
        ctx.fillStyle = color;
        EndPoints.draw(ctx, {
          type: 'arrow',
          point: point,
          angle: angle,
          length: arrowSize
        });
        ctx.fill();
      }
    }
  }]);
  return PhysicsEngine;
}();

exports['default'] = PhysicsEngine;

/***/ }),
/* 172 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Repulsion Solver
 */
var RepulsionSolver = function () {
  /**
   * @param {Object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {Object} options
   */
  function RepulsionSolver(body, physicsBody, options) {
    (0, _classCallCheck3["default"])(this, RepulsionSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3["default"])(RepulsionSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }

    /**
     * Calculate the forces the nodes apply on each other based on a repulsion field.
     * This field is linearly approximated.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      var dx, dy, distance, fx, fy, repulsingForce, node1, node2;

      var nodes = this.body.nodes;
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var forces = this.physicsBody.forces;

      // repulsing forces between nodes
      var nodeDistance = this.options.nodeDistance;

      // approximation constants
      var a = -2 / 3 / nodeDistance;
      var b = 4 / 3;

      // we loop from i over all but the last entree in the array
      // j loops from i+1 to the last. This way we do not double count any of the indices, nor i === j
      for (var i = 0; i < nodeIndices.length - 1; i++) {
        node1 = nodes[nodeIndices[i]];
        for (var j = i + 1; j < nodeIndices.length; j++) {
          node2 = nodes[nodeIndices[j]];

          dx = node2.x - node1.x;
          dy = node2.y - node1.y;
          distance = Math.sqrt(dx * dx + dy * dy);

          // same condition as BarnesHutSolver, making sure nodes are never 100% overlapping.
          if (distance === 0) {
            distance = 0.1 * Math.random();
            dx = distance;
          }

          if (distance < 2 * nodeDistance) {
            if (distance < 0.5 * nodeDistance) {
              repulsingForce = 1.0;
            } else {
              repulsingForce = a * distance + b; // linear approx of  1 / (1 + Math.exp((distance / nodeDistance - 1) * steepness))
            }
            repulsingForce = repulsingForce / distance;

            fx = dx * repulsingForce;
            fy = dy * repulsingForce;

            forces[node1.id].x -= fx;
            forces[node1.id].y -= fy;
            forces[node2.id].x += fx;
            forces[node2.id].y += fy;
          }
        }
      }
    }
  }]);
  return RepulsionSolver;
}();

exports["default"] = RepulsionSolver;

/***/ }),
/* 173 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Hierarchical Repulsion Solver
 */
var HierarchicalRepulsionSolver = function () {
  /**
   * @param {Object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {Object} options
   */
  function HierarchicalRepulsionSolver(body, physicsBody, options) {
    (0, _classCallCheck3["default"])(this, HierarchicalRepulsionSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3["default"])(HierarchicalRepulsionSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }

    /**
     * Calculate the forces the nodes apply on each other based on a repulsion field.
     * This field is linearly approximated.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      var dx, dy, distance, fx, fy, repulsingForce, node1, node2, i, j;

      var nodes = this.body.nodes;
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var forces = this.physicsBody.forces;

      // repulsing forces between nodes
      var nodeDistance = this.options.nodeDistance;

      // we loop from i over all but the last entree in the array
      // j loops from i+1 to the last. This way we do not double count any of the indices, nor i === j
      for (i = 0; i < nodeIndices.length - 1; i++) {
        node1 = nodes[nodeIndices[i]];
        for (j = i + 1; j < nodeIndices.length; j++) {
          node2 = nodes[nodeIndices[j]];

          // nodes only affect nodes on their level
          if (node1.level === node2.level) {
            dx = node2.x - node1.x;
            dy = node2.y - node1.y;
            distance = Math.sqrt(dx * dx + dy * dy);

            var steepness = 0.05;
            if (distance < nodeDistance) {
              repulsingForce = -Math.pow(steepness * distance, 2) + Math.pow(steepness * nodeDistance, 2);
            } else {
              repulsingForce = 0;
            }
            // normalize force with
            if (distance === 0) {
              distance = 0.01;
            } else {
              repulsingForce = repulsingForce / distance;
            }
            fx = dx * repulsingForce;
            fy = dy * repulsingForce;

            forces[node1.id].x -= fx;
            forces[node1.id].y -= fy;
            forces[node2.id].x += fx;
            forces[node2.id].y += fy;
          }
        }
      }
    }
  }]);
  return HierarchicalRepulsionSolver;
}();

exports["default"] = HierarchicalRepulsionSolver;

/***/ }),
/* 174 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Spring Solver
 */
var SpringSolver = function () {
  /**
   * @param {Object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {Object} options
   */
  function SpringSolver(body, physicsBody, options) {
    (0, _classCallCheck3["default"])(this, SpringSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3["default"])(SpringSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }

    /**
     * This function calculates the springforces on the nodes, accounting for the support nodes.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      var edgeLength = void 0,
          edge = void 0;
      var edgeIndices = this.physicsBody.physicsEdgeIndices;
      var edges = this.body.edges;
      var node1 = void 0,
          node2 = void 0,
          node3 = void 0;

      // forces caused by the edges, modelled as springs
      for (var i = 0; i < edgeIndices.length; i++) {
        edge = edges[edgeIndices[i]];
        if (edge.connected === true && edge.toId !== edge.fromId) {
          // only calculate forces if nodes are in the same sector
          if (this.body.nodes[edge.toId] !== undefined && this.body.nodes[edge.fromId] !== undefined) {
            if (edge.edgeType.via !== undefined) {
              edgeLength = edge.options.length === undefined ? this.options.springLength : edge.options.length;
              node1 = edge.to;
              node2 = edge.edgeType.via;
              node3 = edge.from;

              this._calculateSpringForce(node1, node2, 0.5 * edgeLength);
              this._calculateSpringForce(node2, node3, 0.5 * edgeLength);
            } else {
              // the * 1.5 is here so the edge looks as large as a smooth edge. It does not initially because the smooth edges use
              // the support nodes which exert a repulsive force on the to and from nodes, making the edge appear larger.
              edgeLength = edge.options.length === undefined ? this.options.springLength * 1.5 : edge.options.length;
              this._calculateSpringForce(edge.from, edge.to, edgeLength);
            }
          }
        }
      }
    }

    /**
     * This is the code actually performing the calculation for the function above.
     *
     * @param {Node} node1
     * @param {Node} node2
     * @param {number} edgeLength
     * @private
     */

  }, {
    key: "_calculateSpringForce",
    value: function _calculateSpringForce(node1, node2, edgeLength) {
      var dx = node1.x - node2.x;
      var dy = node1.y - node2.y;
      var distance = Math.max(Math.sqrt(dx * dx + dy * dy), 0.01);

      // the 1/distance is so the fx and fy can be calculated without sine or cosine.
      var springForce = this.options.springConstant * (edgeLength - distance) / distance;

      var fx = dx * springForce;
      var fy = dy * springForce;

      // handle the case where one node is not part of the physcis
      if (this.physicsBody.forces[node1.id] !== undefined) {
        this.physicsBody.forces[node1.id].x += fx;
        this.physicsBody.forces[node1.id].y += fy;
      }

      if (this.physicsBody.forces[node2.id] !== undefined) {
        this.physicsBody.forces[node2.id].x -= fx;
        this.physicsBody.forces[node2.id].y -= fy;
      }
    }
  }]);
  return SpringSolver;
}();

exports["default"] = SpringSolver;

/***/ }),
/* 175 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Hierarchical Spring Solver
 */
var HierarchicalSpringSolver = function () {
  /**
   * @param {Object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {Object} options
   */
  function HierarchicalSpringSolver(body, physicsBody, options) {
    (0, _classCallCheck3["default"])(this, HierarchicalSpringSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {Object} options
   */


  (0, _createClass3["default"])(HierarchicalSpringSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }

    /**
     * This function calculates the springforces on the nodes, accounting for the support nodes.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      var edgeLength, edge;
      var dx, dy, fx, fy, springForce, distance;
      var edges = this.body.edges;
      var factor = 0.5;

      var edgeIndices = this.physicsBody.physicsEdgeIndices;
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var forces = this.physicsBody.forces;

      // initialize the spring force counters
      for (var i = 0; i < nodeIndices.length; i++) {
        var nodeId = nodeIndices[i];
        forces[nodeId].springFx = 0;
        forces[nodeId].springFy = 0;
      }

      // forces caused by the edges, modelled as springs
      for (var _i = 0; _i < edgeIndices.length; _i++) {
        edge = edges[edgeIndices[_i]];
        if (edge.connected === true) {
          edgeLength = edge.options.length === undefined ? this.options.springLength : edge.options.length;

          dx = edge.from.x - edge.to.x;
          dy = edge.from.y - edge.to.y;
          distance = Math.sqrt(dx * dx + dy * dy);
          distance = distance === 0 ? 0.01 : distance;

          // the 1/distance is so the fx and fy can be calculated without sine or cosine.
          springForce = this.options.springConstant * (edgeLength - distance) / distance;

          fx = dx * springForce;
          fy = dy * springForce;

          if (edge.to.level != edge.from.level) {
            if (forces[edge.toId] !== undefined) {
              forces[edge.toId].springFx -= fx;
              forces[edge.toId].springFy -= fy;
            }
            if (forces[edge.fromId] !== undefined) {
              forces[edge.fromId].springFx += fx;
              forces[edge.fromId].springFy += fy;
            }
          } else {
            if (forces[edge.toId] !== undefined) {
              forces[edge.toId].x -= factor * fx;
              forces[edge.toId].y -= factor * fy;
            }
            if (forces[edge.fromId] !== undefined) {
              forces[edge.fromId].x += factor * fx;
              forces[edge.fromId].y += factor * fy;
            }
          }
        }
      }

      // normalize spring forces
      springForce = 1;
      var springFx, springFy;
      for (var _i2 = 0; _i2 < nodeIndices.length; _i2++) {
        var _nodeId = nodeIndices[_i2];
        springFx = Math.min(springForce, Math.max(-springForce, forces[_nodeId].springFx));
        springFy = Math.min(springForce, Math.max(-springForce, forces[_nodeId].springFy));

        forces[_nodeId].x += springFx;
        forces[_nodeId].y += springFy;
      }

      // retain energy balance
      var totalFx = 0;
      var totalFy = 0;
      for (var _i3 = 0; _i3 < nodeIndices.length; _i3++) {
        var _nodeId2 = nodeIndices[_i3];
        totalFx += forces[_nodeId2].x;
        totalFy += forces[_nodeId2].y;
      }
      var correctionFx = totalFx / nodeIndices.length;
      var correctionFy = totalFy / nodeIndices.length;

      for (var _i4 = 0; _i4 < nodeIndices.length; _i4++) {
        var _nodeId3 = nodeIndices[_i4];
        forces[_nodeId3].x -= correctionFx;
        forces[_nodeId3].y -= correctionFy;
      }
    }
  }]);
  return HierarchicalSpringSolver;
}();

exports["default"] = HierarchicalSpringSolver;

/***/ }),
/* 176 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _BarnesHutSolver2 = __webpack_require__(81);

var _BarnesHutSolver3 = _interopRequireDefault(_BarnesHutSolver2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * @extends BarnesHutSolver
 */
var ForceAtlas2BasedRepulsionSolver = function (_BarnesHutSolver) {
  (0, _inherits3['default'])(ForceAtlas2BasedRepulsionSolver, _BarnesHutSolver);

  /**
   * @param {Object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {Object} options
   */
  function ForceAtlas2BasedRepulsionSolver(body, physicsBody, options) {
    (0, _classCallCheck3['default'])(this, ForceAtlas2BasedRepulsionSolver);
    return (0, _possibleConstructorReturn3['default'])(this, (ForceAtlas2BasedRepulsionSolver.__proto__ || (0, _getPrototypeOf2['default'])(ForceAtlas2BasedRepulsionSolver)).call(this, body, physicsBody, options));
  }

  /**
   * Calculate the forces based on the distance.
   *
   * @param {number} distance
   * @param {number} dx
   * @param {number} dy
   * @param {Node} node
   * @param {Object} parentBranch
   * @private
   */


  (0, _createClass3['default'])(ForceAtlas2BasedRepulsionSolver, [{
    key: '_calculateForces',
    value: function _calculateForces(distance, dx, dy, node, parentBranch) {
      if (distance === 0) {
        distance = 0.1 * Math.random();
        dx = distance;
      }

      if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
        distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
      }

      var degree = node.edges.length + 1;
      // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
      // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce
      var gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass * degree / Math.pow(distance, 2);
      var fx = dx * gravityForce;
      var fy = dy * gravityForce;

      this.physicsBody.forces[node.id].x += fx;
      this.physicsBody.forces[node.id].y += fy;
    }
  }]);
  return ForceAtlas2BasedRepulsionSolver;
}(_BarnesHutSolver3['default']);

exports['default'] = ForceAtlas2BasedRepulsionSolver;

/***/ }),
/* 177 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

var _CentralGravitySolver2 = __webpack_require__(82);

var _CentralGravitySolver3 = _interopRequireDefault(_CentralGravitySolver2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * @extends CentralGravitySolver
 */
var ForceAtlas2BasedCentralGravitySolver = function (_CentralGravitySolver) {
  (0, _inherits3['default'])(ForceAtlas2BasedCentralGravitySolver, _CentralGravitySolver);

  /**
   * @param {Object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {Object} options
   */
  function ForceAtlas2BasedCentralGravitySolver(body, physicsBody, options) {
    (0, _classCallCheck3['default'])(this, ForceAtlas2BasedCentralGravitySolver);
    return (0, _possibleConstructorReturn3['default'])(this, (ForceAtlas2BasedCentralGravitySolver.__proto__ || (0, _getPrototypeOf2['default'])(ForceAtlas2BasedCentralGravitySolver)).call(this, body, physicsBody, options));
  }

  /**
   * Calculate the forces based on the distance.
   *
   * @param {number} distance
   * @param {number} dx
   * @param {number} dy
   * @param {Object<Node.id, Node>} forces
   * @param {Node} node
   * @private
   */


  (0, _createClass3['default'])(ForceAtlas2BasedCentralGravitySolver, [{
    key: '_calculateForces',
    value: function _calculateForces(distance, dx, dy, forces, node) {
      if (distance > 0) {
        var degree = node.edges.length + 1;
        var gravityForce = this.options.centralGravity * degree * node.options.mass;
        forces[node.id].x = dx * gravityForce;
        forces[node.id].y = dy * gravityForce;
      }
    }
  }]);
  return ForceAtlas2BasedCentralGravitySolver;
}(_CentralGravitySolver3['default']);

exports['default'] = ForceAtlas2BasedCentralGravitySolver;

/***/ }),
/* 178 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _keys = __webpack_require__(9);

var _keys2 = _interopRequireDefault(_keys);

var _typeof2 = __webpack_require__(7);

var _typeof3 = _interopRequireDefault(_typeof2);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/* ===========================================================================

# TODO

- `edgeReplacedById` not cleaned up yet on cluster edge removal
- allowSingleNodeCluster could be a global option as well; currently needs to always
  be passed to clustering methods

----------------------------------------------

# State Model for Clustering

The total state for clustering is non-trivial. It is useful to have a model
available as to how it works. The following documents the relevant state items.


## Network State

The following `network`-members are relevant to clustering:

- `body.nodes`       - all nodes actively participating in the network
- `body.edges`       - same for edges
- `body.nodeIndices` - id's of nodes that are visible at a given moment
- `body.edgeIndices` - same for edges

This includes:

- helper nodes for dragging in `manipulation`
- helper nodes for edge type `dynamic`
- cluster nodes and edges
- there may be more than this.

A node/edge may be missing in the `Indices` member if:

- it is a helper node
- the node or edge state has option `hidden` set
- It is not visible due to clustering


## Clustering State

For the hashes, the id's of the nodes/edges are used as key.

Member `network.clustering` contains the following items:

- `clusteredNodes` - hash with values: { clusterId: <id of cluster>, node: <node instance>}
- `clusteredEdges` - hash with values: restore information for given edge


Due to nesting of clusters, these members can contain cluster nodes and edges as well.

The important thing to note here, is that the clustered nodes and edges also
appear in the members of the cluster nodes. For data update, it is therefore 
important to scan these lists as well as the cluster nodes.


### Cluster Node

A cluster node has the following extra fields:

- `isCluster : true` - indication that this is a cluster node
- `containedNodes`   - hash of nodes contained in this cluster
- `containedEdges`   - same for edges
- `edges`            - array of cluster edges for this node 


**NOTE:**

- `containedEdges` can also contain edges which are not clustered; e.g. an edge
   connecting two nodes in the same cluster.


### Cluster Edge

These are the items in the `edges` member of a clustered node. They have the
following relevant members:

- 'clusteringEdgeReplacingIds` - array of id's of edges replaced by this edge

Note that it's possible to nest clusters, so that `clusteringEdgeReplacingIds`
can contain edge id's of other clusters.


### Clustered Edge

This is any edge contained by a cluster edge. It gets the following additional
member:

- `edgeReplacedById` - id of the cluster edge in which current edge is clustered


   =========================================================================== */
var util = __webpack_require__(2);
var NetworkUtil = __webpack_require__(57)['default'];
var Cluster = __webpack_require__(179)['default'];
var Edge = __webpack_require__(55)['default']; // Only needed for check on type!
var Node = __webpack_require__(34)['default']; // Only needed for check on type!

/**
 * The clustering engine
 */

var ClusterEngine = function () {
  /**
   * @param {Object} body
   */
  function ClusterEngine(body) {
    var _this = this;

    (0, _classCallCheck3['default'])(this, ClusterEngine);

    this.body = body;
    this.clusteredNodes = {}; // key: node id, value: { clusterId: <id of cluster>, node: <node instance>}
    this.clusteredEdges = {}; // key: edge id, value: restore information for given edge

    this.options = {};
    this.defaultOptions = {};
    util.extend(this.options, this.defaultOptions);

    this.body.emitter.on('_resetData', function () {
      _this.clusteredNodes = {};
      _this.clusteredEdges = {};
    });
  }

  /**
   *
   * @param {number} hubsize
   * @param {Object} options
   */


  (0, _createClass3['default'])(ClusterEngine, [{
    key: 'clusterByHubsize',
    value: function clusterByHubsize(hubsize, options) {
      if (hubsize === undefined) {
        hubsize = this._getHubSize();
      } else if ((typeof hubsize === 'undefined' ? 'undefined' : (0, _typeof3['default'])(hubsize)) === 'object') {
        options = this._checkOptions(hubsize);
        hubsize = this._getHubSize();
      }

      var nodesToCluster = [];
      for (var i = 0; i < this.body.nodeIndices.length; i++) {
        var node = this.body.nodes[this.body.nodeIndices[i]];
        if (node.edges.length >= hubsize) {
          nodesToCluster.push(node.id);
        }
      }

      for (var _i = 0; _i < nodesToCluster.length; _i++) {
        this.clusterByConnection(nodesToCluster[_i], options, true);
      }

      this.body.emitter.emit('_dataChanged');
    }

    /**
     * loop over all nodes, check if they adhere to the condition and cluster if needed.
     * @param {Object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: 'cluster',
    value: function cluster() {
      var _this2 = this;

      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      if (options.joinCondition === undefined) {
        throw new Error('Cannot call clusterByNodeData without a joinCondition function in the options.');
      }

      // check if the options object is fine, append if needed
      options = this._checkOptions(options);

      var childNodesObj = {};
      var childEdgesObj = {};

      // collect the nodes that will be in the cluster
      util.forEach(this.body.nodes, function (node, nodeId) {
        if (node.options && options.joinCondition(node.options) === true) {
          childNodesObj[nodeId] = node;

          // collect the edges that will be in the cluster
          util.forEach(node.edges, function (edge) {
            if (_this2.clusteredEdges[edge.id] === undefined) {
              childEdgesObj[edge.id] = edge;
            }
          });
        }
      });

      this._cluster(childNodesObj, childEdgesObj, options, refreshData);
    }

    /**
     * Cluster all nodes in the network that have only X edges
     * @param {number} edgeCount
     * @param {Object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: 'clusterByEdgeCount',
    value: function clusterByEdgeCount(edgeCount, options) {
      var _this3 = this;

      var refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      options = this._checkOptions(options);
      var clusters = [];
      var usedNodes = {};
      var edge = void 0,
          edges = void 0,
          relevantEdgeCount = void 0;
      // collect the nodes that will be in the cluster

      var _loop = function _loop(i) {
        var childNodesObj = {};
        var childEdgesObj = {};
        var nodeId = _this3.body.nodeIndices[i];
        var node = _this3.body.nodes[nodeId];

        // if this node is already used in another cluster this session, we do not have to re-evaluate it.
        if (usedNodes[nodeId] === undefined) {
          relevantEdgeCount = 0;
          edges = [];
          for (var j = 0; j < node.edges.length; j++) {
            edge = node.edges[j];
            if (_this3.clusteredEdges[edge.id] === undefined) {
              if (edge.toId !== edge.fromId) {
                relevantEdgeCount++;
              }
              edges.push(edge);
            }
          }

          // this node qualifies, we collect its neighbours to start the clustering process.
          if (relevantEdgeCount === edgeCount) {
            checkJoinCondition = function checkJoinCondition(node) {
              if (options.joinCondition === undefined || options.joinCondition === null) {
                return true;
              }

              var clonedOptions = NetworkUtil.cloneOptions(node);
              return options.joinCondition(clonedOptions);
            };

            var gatheringSuccessful = true;
            for (var _j = 0; _j < edges.length; _j++) {
              edge = edges[_j];
              var childNodeId = _this3._getConnectedId(edge, nodeId);
              // add the nodes to the list by the join condition.
              if (checkJoinCondition(node)) {
                childEdgesObj[edge.id] = edge;
                childNodesObj[nodeId] = node;
                childNodesObj[childNodeId] = _this3.body.nodes[childNodeId];
                usedNodes[nodeId] = true;
              } else {
                // this node does not qualify after all.
                gatheringSuccessful = false;
                break;
              }
            }

            // add to the cluster queue
            if ((0, _keys2['default'])(childNodesObj).length > 0 && (0, _keys2['default'])(childEdgesObj).length > 0 && gatheringSuccessful === true) {
              /**
               * Search for cluster data that contains any of the node id's
               * @returns {Boolean} true if no joinCondition, otherwise return value of joinCondition
               */
              findClusterData = function findClusterData() {
                for (var n = 0; n < clusters.length; ++n) {
                  // Search for a cluster containing any of the node id's
                  for (var m in childNodesObj) {
                    if (clusters[n].nodes[m] !== undefined) {
                      return clusters[n];
                    }
                  }
                }

                return undefined;
              };

              // If any of the found nodes is part of a cluster found in this method,
              // add the current values to that cluster


              foundCluster = findClusterData();

              if (foundCluster !== undefined) {
                // Add nodes to found cluster if not present
                for (var m in childNodesObj) {
                  if (foundCluster.nodes[m] === undefined) {
                    foundCluster.nodes[m] = childNodesObj[m];
                  }
                }

                // Add edges to found cluster, if not present
                for (var _m in childEdgesObj) {
                  if (foundCluster.edges[_m] === undefined) {
                    foundCluster.edges[_m] = childEdgesObj[_m];
                  }
                }
              } else {
                // Create a new cluster group
                clusters.push({ nodes: childNodesObj, edges: childEdgesObj });
              }
            }
          }
        }
      };

      for (var i = 0; i < this.body.nodeIndices.length; i++) {
        var checkJoinCondition;
        var findClusterData;
        var foundCluster;

        _loop(i);
      }

      for (var i = 0; i < clusters.length; i++) {
        this._cluster(clusters[i].nodes, clusters[i].edges, options, false);
      }

      if (refreshData === true) {
        this.body.emitter.emit('_dataChanged');
      }
    }

    /**
     * Cluster all nodes in the network that have only 1 edge
     * @param {Object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: 'clusterOutliers',
    value: function clusterOutliers(options) {
      var refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      this.clusterByEdgeCount(1, options, refreshData);
    }

    /**
     * Cluster all nodes in the network that have only 2 edge
     * @param {Object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: 'clusterBridges',
    value: function clusterBridges(options) {
      var refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      this.clusterByEdgeCount(2, options, refreshData);
    }

    /**
     * suck all connected nodes of a node into the node.
     * @param {Node.id} nodeId
     * @param {Object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: 'clusterByConnection',
    value: function clusterByConnection(nodeId, options) {
      var refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      // kill conditions
      if (nodeId === undefined) {
        throw new Error('No nodeId supplied to clusterByConnection!');
      }
      if (this.body.nodes[nodeId] === undefined) {
        throw new Error('The nodeId given to clusterByConnection does not exist!');
      }

      var node = this.body.nodes[nodeId];
      options = this._checkOptions(options, node);
      if (options.clusterNodeProperties.x === undefined) {
        options.clusterNodeProperties.x = node.x;
      }
      if (options.clusterNodeProperties.y === undefined) {
        options.clusterNodeProperties.y = node.y;
      }
      if (options.clusterNodeProperties.fixed === undefined) {
        options.clusterNodeProperties.fixed = {};
        options.clusterNodeProperties.fixed.x = node.options.fixed.x;
        options.clusterNodeProperties.fixed.y = node.options.fixed.y;
      }

      var childNodesObj = {};
      var childEdgesObj = {};
      var parentNodeId = node.id;
      var parentClonedOptions = NetworkUtil.cloneOptions(node);
      childNodesObj[parentNodeId] = node;

      // collect the nodes that will be in the cluster
      for (var i = 0; i < node.edges.length; i++) {
        var edge = node.edges[i];
        if (this.clusteredEdges[edge.id] === undefined) {
          var childNodeId = this._getConnectedId(edge, parentNodeId);

          // if the child node is not in a cluster
          if (this.clusteredNodes[childNodeId] === undefined) {
            if (childNodeId !== parentNodeId) {
              if (options.joinCondition === undefined) {
                childEdgesObj[edge.id] = edge;
                childNodesObj[childNodeId] = this.body.nodes[childNodeId];
              } else {
                // clone the options and insert some additional parameters that could be interesting.
                var childClonedOptions = NetworkUtil.cloneOptions(this.body.nodes[childNodeId]);
                if (options.joinCondition(parentClonedOptions, childClonedOptions) === true) {
                  childEdgesObj[edge.id] = edge;
                  childNodesObj[childNodeId] = this.body.nodes[childNodeId];
                }
              }
            } else {
              // swallow the edge if it is self-referencing.
              childEdgesObj[edge.id] = edge;
            }
          }
        }
      }
      var childNodeIDs = (0, _keys2['default'])(childNodesObj).map(function (childNode) {
        return childNodesObj[childNode].id;
      });

      for (childNode in childNodesObj) {
        if (!childNodesObj.hasOwnProperty(childNode)) continue;

        var childNode = childNodesObj[childNode];
        for (var y = 0; y < childNode.edges.length; y++) {
          var childEdge = childNode.edges[y];
          if (childNodeIDs.indexOf(this._getConnectedId(childEdge, childNode.id)) > -1) {
            childEdgesObj[childEdge.id] = childEdge;
          }
        }
      }
      this._cluster(childNodesObj, childEdgesObj, options, refreshData);
    }

    /**
     * This function creates the edges that will be attached to the cluster
     * It looks for edges that are connected to the nodes from the "outside' of the cluster.
     *
     * @param {{Node.id: vis.Node}} childNodesObj
     * @param {{vis.Edge.id: vis.Edge}} childEdgesObj
     * @param {Object} clusterNodeProperties
     * @param {Object} clusterEdgeProperties
     * @private
     */

  }, {
    key: '_createClusterEdges',
    value: function _createClusterEdges(childNodesObj, childEdgesObj, clusterNodeProperties, clusterEdgeProperties) {
      var edge = void 0,
          childNodeId = void 0,
          childNode = void 0,
          toId = void 0,
          fromId = void 0,
          otherNodeId = void 0;

      // loop over all child nodes and their edges to find edges going out of the cluster
      // these edges will be replaced by clusterEdges.
      var childKeys = (0, _keys2['default'])(childNodesObj);
      var createEdges = [];
      for (var i = 0; i < childKeys.length; i++) {
        childNodeId = childKeys[i];
        childNode = childNodesObj[childNodeId];

        // construct new edges from the cluster to others
        for (var j = 0; j < childNode.edges.length; j++) {
          edge = childNode.edges[j];
          // we only handle edges that are visible to the system, not the disabled ones from the clustering process.
          if (this.clusteredEdges[edge.id] === undefined) {
            // self-referencing edges will be added to the "hidden" list
            if (edge.toId == edge.fromId) {
              childEdgesObj[edge.id] = edge;
            } else {
              // set up the from and to.
              if (edge.toId == childNodeId) {
                // this is a double equals because ints and strings can be interchanged here.
                toId = clusterNodeProperties.id;
                fromId = edge.fromId;
                otherNodeId = fromId;
              } else {
                toId = edge.toId;
                fromId = clusterNodeProperties.id;
                otherNodeId = toId;
              }
            }

            // Only edges from the cluster outwards are being replaced.
            if (childNodesObj[otherNodeId] === undefined) {
              createEdges.push({ edge: edge, fromId: fromId, toId: toId });
            }
          }
        }
      }

      //
      // Here we actually create the replacement edges.
      //
      // We could not do this in the loop above as the creation process
      // would add an edge to the edges array we are iterating over.
      //
      // NOTE: a clustered edge can have multiple base edges!
      //
      var newEdges = [];

      /**
       * Find a cluster edge which matches the given created edge.
       * @param {vis.Edge} createdEdge
       * @returns {vis.Edge}
       */
      var getNewEdge = function getNewEdge(createdEdge) {
        for (var _j2 = 0; _j2 < newEdges.length; _j2++) {
          var newEdge = newEdges[_j2];

          // We replace both to and from edges with a single cluster edge
          var matchToDirection = createdEdge.fromId === newEdge.fromId && createdEdge.toId === newEdge.toId;
          var matchFromDirection = createdEdge.fromId === newEdge.toId && createdEdge.toId === newEdge.fromId;

          if (matchToDirection || matchFromDirection) {
            return newEdge;
          }
        }

        return null;
      };

      for (var _j3 = 0; _j3 < createEdges.length; _j3++) {
        var createdEdge = createEdges[_j3];
        var _edge = createdEdge.edge;
        var newEdge = getNewEdge(createdEdge);

        if (newEdge === null) {
          // Create a clustered edge for this connection
          newEdge = this._createClusteredEdge(createdEdge.fromId, createdEdge.toId, _edge, clusterEdgeProperties);

          newEdges.push(newEdge);
        } else {
          newEdge.clusteringEdgeReplacingIds.push(_edge.id);
        }

        // also reference the new edge in the old edge
        this.body.edges[_edge.id].edgeReplacedById = newEdge.id;

        // hide the replaced edge
        this._backupEdgeOptions(_edge);
        _edge.setOptions({ physics: false });
      }
    }

    /**
     * This function checks the options that can be supplied to the different cluster functions
     * for certain fields and inserts defaults if needed
     * @param {Object} options
     * @returns {*}
     * @private
     */

  }, {
    key: '_checkOptions',
    value: function _checkOptions() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (options.clusterEdgeProperties === undefined) {
        options.clusterEdgeProperties = {};
      }
      if (options.clusterNodeProperties === undefined) {
        options.clusterNodeProperties = {};
      }

      return options;
    }

    /**
     *
     * @param {Object}    childNodesObj         | object with node objects, id as keys, same as childNodes except it also contains a source node
     * @param {Object}    childEdgesObj         | object with edge objects, id as keys
     * @param {Array}     options               | object with {clusterNodeProperties, clusterEdgeProperties, processProperties}
     * @param {boolean}   refreshData | when true, do not wrap up
     * @private
     */

  }, {
    key: '_cluster',
    value: function _cluster(childNodesObj, childEdgesObj, options) {
      var refreshData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;

      // Remove nodes which are already clustered
      var tmpNodesToRemove = [];
      for (var _nodeId in childNodesObj) {
        if (childNodesObj.hasOwnProperty(_nodeId)) {
          if (this.clusteredNodes[_nodeId] !== undefined) {
            tmpNodesToRemove.push(_nodeId);
          }
        }
      }

      for (var n = 0; n < tmpNodesToRemove.length; ++n) {
        delete childNodesObj[tmpNodesToRemove[n]];
      }

      // kill condition: no nodes don't bother
      if ((0, _keys2['default'])(childNodesObj).length == 0) {
        return;
      }

      // allow clusters of 1 if options allow
      if ((0, _keys2['default'])(childNodesObj).length == 1 && options.clusterNodeProperties.allowSingleNodeCluster != true) {
        return;
      }

      var clusterNodeProperties = util.deepExtend({}, options.clusterNodeProperties);

      // construct the clusterNodeProperties
      if (options.processProperties !== undefined) {
        // get the childNode options
        var childNodesOptions = [];
        for (var _nodeId2 in childNodesObj) {
          if (childNodesObj.hasOwnProperty(_nodeId2)) {
            var clonedOptions = NetworkUtil.cloneOptions(childNodesObj[_nodeId2]);
            childNodesOptions.push(clonedOptions);
          }
        }

        // get cluster properties based on childNodes
        var childEdgesOptions = [];
        for (var edgeId in childEdgesObj) {
          if (childEdgesObj.hasOwnProperty(edgeId)) {
            // these cluster edges will be removed on creation of the cluster.
            if (edgeId.substr(0, 12) !== 'clusterEdge:') {
              var _clonedOptions = NetworkUtil.cloneOptions(childEdgesObj[edgeId], 'edge');
              childEdgesOptions.push(_clonedOptions);
            }
          }
        }

        clusterNodeProperties = options.processProperties(clusterNodeProperties, childNodesOptions, childEdgesOptions);
        if (!clusterNodeProperties) {
          throw new Error('The processProperties function does not return properties!');
        }
      }

      // check if we have an unique id;
      if (clusterNodeProperties.id === undefined) {
        clusterNodeProperties.id = 'cluster:' + util.randomUUID();
      }
      var clusterId = clusterNodeProperties.id;

      if (clusterNodeProperties.label === undefined) {
        clusterNodeProperties.label = 'cluster';
      }

      // give the clusterNode a position if it does not have one.
      var pos = undefined;
      if (clusterNodeProperties.x === undefined) {
        pos = this._getClusterPosition(childNodesObj);
        clusterNodeProperties.x = pos.x;
      }
      if (clusterNodeProperties.y === undefined) {
        if (pos === undefined) {
          pos = this._getClusterPosition(childNodesObj);
        }
        clusterNodeProperties.y = pos.y;
      }

      // force the ID to remain the same
      clusterNodeProperties.id = clusterId;

      // create the cluster Node
      // Note that allowSingleNodeCluster, if present, is stored in the options as well
      var clusterNode = this.body.functions.createNode(clusterNodeProperties, Cluster);
      clusterNode.containedNodes = childNodesObj;
      clusterNode.containedEdges = childEdgesObj;
      // cache a copy from the cluster edge properties if we have to reconnect others later on
      clusterNode.clusterEdgeProperties = options.clusterEdgeProperties;

      // finally put the cluster node into global
      this.body.nodes[clusterNodeProperties.id] = clusterNode;

      this._clusterEdges(childNodesObj, childEdgesObj, clusterNodeProperties, options.clusterEdgeProperties);

      // set ID to undefined so no duplicates arise
      clusterNodeProperties.id = undefined;

      // wrap up
      if (refreshData === true) {
        this.body.emitter.emit('_dataChanged');
      }
    }

    /**
     *
     * @param {Edge} edge
     * @private
     */

  }, {
    key: '_backupEdgeOptions',
    value: function _backupEdgeOptions(edge) {
      if (this.clusteredEdges[edge.id] === undefined) {
        this.clusteredEdges[edge.id] = { physics: edge.options.physics };
      }
    }

    /**
     *
     * @param {Edge} edge
     * @private
     */

  }, {
    key: '_restoreEdge',
    value: function _restoreEdge(edge) {
      var originalOptions = this.clusteredEdges[edge.id];
      if (originalOptions !== undefined) {
        edge.setOptions({ physics: originalOptions.physics });
        delete this.clusteredEdges[edge.id];
      }
    }

    /**
     * Check if a node is a cluster.
     * @param {Node.id} nodeId
     * @returns {*}
     */

  }, {
    key: 'isCluster',
    value: function isCluster(nodeId) {
      if (this.body.nodes[nodeId] !== undefined) {
        return this.body.nodes[nodeId].isCluster === true;
      } else {
        console.log('Node does not exist.');
        return false;
      }
    }

    /**
     * get the position of the cluster node based on what's inside
     * @param {object} childNodesObj    | object with node objects, id as keys
     * @returns {{x: number, y: number}}
     * @private
     */

  }, {
    key: '_getClusterPosition',
    value: function _getClusterPosition(childNodesObj) {
      var childKeys = (0, _keys2['default'])(childNodesObj);
      var minX = childNodesObj[childKeys[0]].x;
      var maxX = childNodesObj[childKeys[0]].x;
      var minY = childNodesObj[childKeys[0]].y;
      var maxY = childNodesObj[childKeys[0]].y;
      var node = void 0;
      for (var i = 1; i < childKeys.length; i++) {
        node = childNodesObj[childKeys[i]];
        minX = node.x < minX ? node.x : minX;
        maxX = node.x > maxX ? node.x : maxX;
        minY = node.y < minY ? node.y : minY;
        maxY = node.y > maxY ? node.y : maxY;
      }

      return { x: 0.5 * (minX + maxX), y: 0.5 * (minY + maxY) };
    }

    /**
     * Open a cluster by calling this function.
     * @param {vis.Edge.id}  clusterNodeId | the ID of the cluster node
     * @param {Object} options
     * @param {boolean} refreshData | wrap up afterwards if not true
     */

  }, {
    key: 'openCluster',
    value: function openCluster(clusterNodeId, options) {
      var refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      // kill conditions
      if (clusterNodeId === undefined) {
        throw new Error('No clusterNodeId supplied to openCluster.');
      }

      var clusterNode = this.body.nodes[clusterNodeId];

      if (clusterNode === undefined) {
        throw new Error('The clusterNodeId supplied to openCluster does not exist.');
      }
      if (clusterNode.isCluster !== true || clusterNode.containedNodes === undefined || clusterNode.containedEdges === undefined) {
        throw new Error('The node:' + clusterNodeId + ' is not a valid cluster.');
      }

      // Check if current cluster is clustered itself
      var stack = this.findNode(clusterNodeId);
      var parentIndex = stack.indexOf(clusterNodeId) - 1;
      if (parentIndex >= 0) {
        // Current cluster is clustered; transfer contained nodes and edges to parent
        var parentClusterNodeId = stack[parentIndex];
        var parentClusterNode = this.body.nodes[parentClusterNodeId];

        // clustering.clusteredNodes and clustering.clusteredEdges remain unchanged
        parentClusterNode._openChildCluster(clusterNodeId);

        // All components of child cluster node have been transferred. It can die now.
        delete this.body.nodes[clusterNodeId];
        if (refreshData === true) {
          this.body.emitter.emit('_dataChanged');
        }

        return;
      }

      // main body
      var containedNodes = clusterNode.containedNodes;
      var containedEdges = clusterNode.containedEdges;

      // allow the user to position the nodes after release.
      if (options !== undefined && options.releaseFunction !== undefined && typeof options.releaseFunction === 'function') {
        var positions = {};
        var clusterPosition = { x: clusterNode.x, y: clusterNode.y };
        for (var _nodeId3 in containedNodes) {
          if (containedNodes.hasOwnProperty(_nodeId3)) {
            var containedNode = this.body.nodes[_nodeId3];
            positions[_nodeId3] = { x: containedNode.x, y: containedNode.y };
          }
        }
        var newPositions = options.releaseFunction(clusterPosition, positions);

        for (var _nodeId4 in containedNodes) {
          if (containedNodes.hasOwnProperty(_nodeId4)) {
            var _containedNode = this.body.nodes[_nodeId4];
            if (newPositions[_nodeId4] !== undefined) {
              _containedNode.x = newPositions[_nodeId4].x === undefined ? clusterNode.x : newPositions[_nodeId4].x;
              _containedNode.y = newPositions[_nodeId4].y === undefined ? clusterNode.y : newPositions[_nodeId4].y;
            }
          }
        }
      } else {
        // copy the position from the cluster
        util.forEach(containedNodes, function (containedNode) {
          // inherit position
          if (containedNode.options.fixed.x === false) {
            containedNode.x = clusterNode.x;
          }
          if (containedNode.options.fixed.y === false) {
            containedNode.y = clusterNode.y;
          }
        });
      }

      // release nodes
      for (var _nodeId5 in containedNodes) {
        if (containedNodes.hasOwnProperty(_nodeId5)) {
          var _containedNode2 = this.body.nodes[_nodeId5];

          // inherit speed
          _containedNode2.vx = clusterNode.vx;
          _containedNode2.vy = clusterNode.vy;

          _containedNode2.setOptions({ physics: true });

          delete this.clusteredNodes[_nodeId5];
        }
      }

      // copy the clusterNode edges because we cannot iterate over an object that we add or remove from.
      var edgesToBeDeleted = [];
      for (var i = 0; i < clusterNode.edges.length; i++) {
        edgesToBeDeleted.push(clusterNode.edges[i]);
      }

      // actually handling the deleting.
      for (var _i2 = 0; _i2 < edgesToBeDeleted.length; _i2++) {
        var edge = edgesToBeDeleted[_i2];
        var otherNodeId = this._getConnectedId(edge, clusterNodeId);
        var otherNode = this.clusteredNodes[otherNodeId];

        for (var j = 0; j < edge.clusteringEdgeReplacingIds.length; j++) {
          var transferId = edge.clusteringEdgeReplacingIds[j];
          var transferEdge = this.body.edges[transferId];
          if (transferEdge === undefined) continue;

          // if the other node is in another cluster, we transfer ownership of this edge to the other cluster
          if (otherNode !== undefined) {
            // transfer ownership:
            var otherCluster = this.body.nodes[otherNode.clusterId];
            otherCluster.containedEdges[transferEdge.id] = transferEdge;

            // delete local reference
            delete containedEdges[transferEdge.id];

            // get to and from
            var fromId = transferEdge.fromId;
            var toId = transferEdge.toId;
            if (transferEdge.toId == otherNodeId) {
              toId = otherNode.clusterId;
            } else {
              fromId = otherNode.clusterId;
            }

            // create new cluster edge from the otherCluster
            this._createClusteredEdge(fromId, toId, transferEdge, otherCluster.clusterEdgeProperties, { hidden: false, physics: true });
          } else {
            this._restoreEdge(transferEdge);
          }
        }

        edge.remove();
      }

      // handle the releasing of the edges
      for (var edgeId in containedEdges) {
        if (containedEdges.hasOwnProperty(edgeId)) {
          this._restoreEdge(containedEdges[edgeId]);
        }
      }

      // remove clusterNode
      delete this.body.nodes[clusterNodeId];

      if (refreshData === true) {
        this.body.emitter.emit('_dataChanged');
      }
    }

    /**
     *
     * @param {Cluster.id} clusterId
     * @returns {Array.<Node.id>}
     */

  }, {
    key: 'getNodesInCluster',
    value: function getNodesInCluster(clusterId) {
      var nodesArray = [];
      if (this.isCluster(clusterId) === true) {
        var containedNodes = this.body.nodes[clusterId].containedNodes;
        for (var _nodeId6 in containedNodes) {
          if (containedNodes.hasOwnProperty(_nodeId6)) {
            nodesArray.push(this.body.nodes[_nodeId6].id);
          }
        }
      }

      return nodesArray;
    }

    /**
     * Get the stack clusterId's that a certain node resides in. cluster A -> cluster B -> cluster C -> node
     *
     * If a node can't be found in the chain, return an empty array.
     *
     * @param {string|number} nodeId
     * @returns {Array}
     */

  }, {
    key: 'findNode',
    value: function findNode(nodeId) {
      var stack = [];
      var max = 100;
      var counter = 0;
      var node = void 0;

      while (this.clusteredNodes[nodeId] !== undefined && counter < max) {
        node = this.body.nodes[nodeId];
        if (node === undefined) return [];
        stack.push(node.id);

        nodeId = this.clusteredNodes[nodeId].clusterId;
        counter++;
      }

      node = this.body.nodes[nodeId];
      if (node === undefined) return [];
      stack.push(node.id);

      stack.reverse();
      return stack;
    }

    /**
     * Using a clustered nodeId, update with the new options
     * @param {vis.Edge.id} clusteredNodeId
     * @param {object} newOptions
     */

  }, {
    key: 'updateClusteredNode',
    value: function updateClusteredNode(clusteredNodeId, newOptions) {
      if (clusteredNodeId === undefined) {
        throw new Error('No clusteredNodeId supplied to updateClusteredNode.');
      }
      if (newOptions === undefined) {
        throw new Error('No newOptions supplied to updateClusteredNode.');
      }
      if (this.body.nodes[clusteredNodeId] === undefined) {
        throw new Error('The clusteredNodeId supplied to updateClusteredNode does not exist.');
      }

      this.body.nodes[clusteredNodeId].setOptions(newOptions);
      this.body.emitter.emit('_dataChanged');
    }

    /**
     * Using a base edgeId, update all related clustered edges with the new options
     * @param {vis.Edge.id} startEdgeId
     * @param {object} newOptions
     */

  }, {
    key: 'updateEdge',
    value: function updateEdge(startEdgeId, newOptions) {
      if (startEdgeId === undefined) {
        throw new Error('No startEdgeId supplied to updateEdge.');
      }
      if (newOptions === undefined) {
        throw new Error('No newOptions supplied to updateEdge.');
      }
      if (this.body.edges[startEdgeId] === undefined) {
        throw new Error('The startEdgeId supplied to updateEdge does not exist.');
      }

      var allEdgeIds = this.getClusteredEdges(startEdgeId);
      for (var i = 0; i < allEdgeIds.length; i++) {
        var edge = this.body.edges[allEdgeIds[i]];
        edge.setOptions(newOptions);
      }
      this.body.emitter.emit('_dataChanged');
    }

    /**
     * Get a stack of clusterEdgeId's (+base edgeid) that a base edge is the same as. cluster edge C -> cluster edge B -> cluster edge A -> base edge(edgeId)
     * @param {vis.Edge.id} edgeId
     * @returns {Array.<vis.Edge.id>}
     */

  }, {
    key: 'getClusteredEdges',
    value: function getClusteredEdges(edgeId) {
      var stack = [];
      var max = 100;
      var counter = 0;

      while (edgeId !== undefined && this.body.edges[edgeId] !== undefined && counter < max) {
        stack.push(this.body.edges[edgeId].id);
        edgeId = this.body.edges[edgeId].edgeReplacedById;
        counter++;
      }
      stack.reverse();
      return stack;
    }

    /**
     * Get the base edge id of clusterEdgeId. cluster edge (clusteredEdgeId) -> cluster edge B -> cluster edge C -> base edge
     * @param {vis.Edge.id} clusteredEdgeId
     * @returns {vis.Edge.id} baseEdgeId
     *
     * TODO: deprecate in 5.0.0. Method getBaseEdges() is the correct one to use.
     */

  }, {
    key: 'getBaseEdge',
    value: function getBaseEdge(clusteredEdgeId) {
      // Just kludge this by returning the first base edge id found
      return this.getBaseEdges(clusteredEdgeId)[0];
    }

    /**
     * Get all regular edges for this clustered edge id.
     *
     * @param {vis.Edge.id} clusteredEdgeId
     * @returns {Array.<vis.Edge.id>} all baseEdgeId's under this clustered edge
     */

  }, {
    key: 'getBaseEdges',
    value: function getBaseEdges(clusteredEdgeId) {
      var IdsToHandle = [clusteredEdgeId];
      var doneIds = [];
      var foundIds = [];
      var max = 100;
      var counter = 0;

      while (IdsToHandle.length > 0 && counter < max) {
        var nextId = IdsToHandle.pop();
        if (nextId === undefined) continue; // Paranoia here and onwards
        var nextEdge = this.body.edges[nextId];
        if (nextEdge === undefined) continue;
        counter++;

        var replacingIds = nextEdge.clusteringEdgeReplacingIds;
        if (replacingIds === undefined) {
          // nextId is a base id
          foundIds.push(nextId);
        } else {
          // Another cluster edge, unravel this one as well
          for (var i = 0; i < replacingIds.length; ++i) {
            var replacingId = replacingIds[i];

            // Don't add if already handled
            // TODO: never triggers; find a test-case which does
            if (IdsToHandle.indexOf(replacingIds) !== -1 || doneIds.indexOf(replacingIds) !== -1) {
              continue;
            }

            IdsToHandle.push(replacingId);
          }
        }

        doneIds.push(nextId);
      }

      return foundIds;
    }

    /**
     * Get the Id the node is connected to
     * @param {vis.Edge} edge
     * @param {Node.id} nodeId
     * @returns {*}
     * @private
     */

  }, {
    key: '_getConnectedId',
    value: function _getConnectedId(edge, nodeId) {
      if (edge.toId != nodeId) {
        return edge.toId;
      } else if (edge.fromId != nodeId) {
        return edge.fromId;
      } else {
        return edge.fromId;
      }
    }

    /**
     * We determine how many connections denote an important hub.
     * We take the mean + 2*std as the important hub size. (Assuming a normal distribution of data, ~2.2%)
     *
     * @returns {number}
     * @private
     */

  }, {
    key: '_getHubSize',
    value: function _getHubSize() {
      var average = 0;
      var averageSquared = 0;
      var hubCounter = 0;
      var largestHub = 0;

      for (var i = 0; i < this.body.nodeIndices.length; i++) {
        var _node = this.body.nodes[this.body.nodeIndices[i]];
        if (_node.edges.length > largestHub) {
          largestHub = _node.edges.length;
        }
        average += _node.edges.length;
        averageSquared += Math.pow(_node.edges.length, 2);
        hubCounter += 1;
      }
      average = average / hubCounter;
      averageSquared = averageSquared / hubCounter;

      var variance = averageSquared - Math.pow(average, 2);
      var standardDeviation = Math.sqrt(variance);

      var hubThreshold = Math.floor(average + 2 * standardDeviation);

      // always have at least one to cluster
      if (hubThreshold > largestHub) {
        hubThreshold = largestHub;
      }

      return hubThreshold;
    }

    /**
     * Create an edge for the cluster representation.
     *
     * @param {Node.id} fromId
     * @param {Node.id} toId
     * @param {vis.Edge} baseEdge
     * @param {Object} clusterEdgeProperties
     * @param {Object} extraOptions
     * @returns {Edge} newly created clustered edge
     * @private
     */

  }, {
    key: '_createClusteredEdge',
    value: function _createClusteredEdge(fromId, toId, baseEdge, clusterEdgeProperties, extraOptions) {
      // copy the options of the edge we will replace
      var clonedOptions = NetworkUtil.cloneOptions(baseEdge, 'edge');
      // make sure the properties of clusterEdges are superimposed on it
      util.deepExtend(clonedOptions, clusterEdgeProperties);

      // set up the edge
      clonedOptions.from = fromId;
      clonedOptions.to = toId;
      clonedOptions.id = 'clusterEdge:' + util.randomUUID();

      // apply the edge specific options to it if specified
      if (extraOptions !== undefined) {
        util.deepExtend(clonedOptions, extraOptions);
      }

      var newEdge = this.body.functions.createEdge(clonedOptions);
      newEdge.clusteringEdgeReplacingIds = [baseEdge.id];
      newEdge.connect();

      // Register the new edge
      this.body.edges[newEdge.id] = newEdge;

      return newEdge;
    }

    /**
     * Add the passed child nodes and edges to the given cluster node.
     *
     * @param {Object|Node} childNodes  hash of nodes or single node to add in cluster
     * @param {Object|Edge} childEdges  hash of edges or single edge to take into account when clustering
     * @param {Node} clusterNode  cluster node to add nodes and edges to
     * @param {Object} [clusterEdgeProperties]
     * @private
     */

  }, {
    key: '_clusterEdges',
    value: function _clusterEdges(childNodes, childEdges, clusterNode, clusterEdgeProperties) {
      if (childEdges instanceof Edge) {
        var edge = childEdges;
        var obj = {};
        obj[edge.id] = edge;
        childEdges = obj;
      }

      if (childNodes instanceof Node) {
        var _node2 = childNodes;
        var _obj = {};
        _obj[_node2.id] = _node2;
        childNodes = _obj;
      }

      if (clusterNode === undefined || clusterNode === null) {
        throw new Error('_clusterEdges: parameter clusterNode required');
      }

      if (clusterEdgeProperties === undefined) {
        // Take the required properties from the cluster node
        clusterEdgeProperties = clusterNode.clusterEdgeProperties;
      }

      // create the new edges that will connect to the cluster.
      // All self-referencing edges will be added to childEdges here.
      this._createClusterEdges(childNodes, childEdges, clusterNode, clusterEdgeProperties);

      // disable the childEdges
      for (var edgeId in childEdges) {
        if (childEdges.hasOwnProperty(edgeId)) {
          if (this.body.edges[edgeId] !== undefined) {
            var _edge2 = this.body.edges[edgeId];
            // cache the options before changing
            this._backupEdgeOptions(_edge2);
            // disable physics and hide the edge
            _edge2.setOptions({ physics: false });
          }
        }
      }

      // disable the childNodes
      for (var _nodeId7 in childNodes) {
        if (childNodes.hasOwnProperty(_nodeId7)) {
          this.clusteredNodes[_nodeId7] = {
            clusterId: clusterNode.id,
            node: this.body.nodes[_nodeId7]
          };
          this.body.nodes[_nodeId7].setOptions({ physics: false });
        }
      }
    }

    /**
     * Determine in which cluster given nodeId resides.
     *
     * If not in cluster, return undefined.
     *
     * NOTE: If you know a cleaner way to do this, please enlighten me (wimrijnders).
     *
     * @param {Node.id} nodeId
     * @returns {Node|undefined} Node instance for cluster, if present
     * @private
     */

  }, {
    key: '_getClusterNodeForNode',
    value: function _getClusterNodeForNode(nodeId) {
      if (nodeId === undefined) return undefined;
      var clusteredNode = this.clusteredNodes[nodeId];

      // NOTE: If no cluster info found, it should actually be an error
      if (clusteredNode === undefined) return undefined;
      var clusterId = clusteredNode.clusterId;
      if (clusterId === undefined) return undefined;

      return this.body.nodes[clusterId];
    }

    /**
     * Internal helper function for conditionally removing items in array
     *
     * Done like this because Array.filter() is not fully supported by all IE's.
     *
     * @param {Array} arr
     * @param {function} callback
     * @returns {Array}
     * @private
     */

  }, {
    key: '_filter',
    value: function _filter(arr, callback) {
      var ret = [];

      util.forEach(arr, function (item) {
        if (callback(item)) {
          ret.push(item);
        }
      });

      return ret;
    }

    /**
     * Scan all edges for changes in clustering and adjust this if necessary.
     *
     * Call this (internally) after there has been a change in node or edge data.
     *
     * Pre: States of this.body.nodes and this.body.edges consistent
     * Pre: this.clusteredNodes and this.clusteredEdge consistent with containedNodes and containedEdges
     *      of cluster nodes.
     */

  }, {
    key: '_updateState',
    value: function _updateState() {
      var _this4 = this;

      var nodeId = void 0;
      var deletedNodeIds = [];
      var deletedEdgeIds = {};

      /**
       * Utility function to iterate over clustering nodes only
       *
       * @param {Function} callback  function to call for each cluster node
       */
      var eachClusterNode = function eachClusterNode(callback) {
        util.forEach(_this4.body.nodes, function (node) {
          if (node.isCluster === true) {
            callback(node);
          }
        });
      };

      //
      // Remove deleted regular nodes from clustering
      //

      // Determine the deleted nodes
      for (nodeId in this.clusteredNodes) {
        if (!this.clusteredNodes.hasOwnProperty(nodeId)) continue;
        var _node3 = this.body.nodes[nodeId];

        if (_node3 === undefined) {
          deletedNodeIds.push(nodeId);
        }
      }

      // Remove nodes from cluster nodes
      eachClusterNode(function (clusterNode) {
        for (var n = 0; n < deletedNodeIds.length; n++) {
          delete clusterNode.containedNodes[deletedNodeIds[n]];
        }
      });

      // Remove nodes from cluster list
      for (var n = 0; n < deletedNodeIds.length; n++) {
        delete this.clusteredNodes[deletedNodeIds[n]];
      }

      //
      // Remove deleted edges from clustering
      //

      // Add the deleted clustered edges to the list
      util.forEach(this.clusteredEdges, function (edgeId) {
        var edge = _this4.body.edges[edgeId];
        if (edge === undefined || !edge.endPointsValid()) {
          deletedEdgeIds[edgeId] = edgeId;
        }
      });

      // Cluster nodes can also contain edges which are not clustered,
      // i.e. nodes 1-2 within cluster with an edge in between.
      // So the cluster nodes also need to be scanned for invalid edges
      eachClusterNode(function (clusterNode) {
        util.forEach(clusterNode.containedEdges, function (edge, edgeId) {
          if (!edge.endPointsValid() && !deletedEdgeIds[edgeId]) {
            deletedEdgeIds[edgeId] = edgeId;
          }
        });
      });

      // Also scan for cluster edges which need to be removed in the active list.
      // Regular edges have been removed beforehand, so this only picks up the cluster edges.
      util.forEach(this.body.edges, function (edge, edgeId) {
        // Explicitly scan the contained edges for validity
        var isValid = true;
        var replacedIds = edge.clusteringEdgeReplacingIds;
        if (replacedIds !== undefined) {
          var numValid = 0;

          util.forEach(replacedIds, function (containedEdgeId) {
            var containedEdge = _this4.body.edges[containedEdgeId];

            if (containedEdge !== undefined && containedEdge.endPointsValid()) {
              numValid += 1;
            }
          });

          isValid = numValid > 0;
        }

        if (!edge.endPointsValid() || !isValid) {
          deletedEdgeIds[edgeId] = edgeId;
        }
      });

      // Remove edges from cluster nodes
      eachClusterNode(function (clusterNode) {
        util.forEach(deletedEdgeIds, function (deletedEdgeId) {
          delete clusterNode.containedEdges[deletedEdgeId];

          util.forEach(clusterNode.edges, function (edge, m) {
            if (edge.id === deletedEdgeId) {
              clusterNode.edges[m] = null; // Don't want to directly delete here, because in the loop
              return;
            }

            edge.clusteringEdgeReplacingIds = _this4._filter(edge.clusteringEdgeReplacingIds, function (id) {
              return !deletedEdgeIds[id];
            });
          });

          // Clean up the nulls
          clusterNode.edges = _this4._filter(clusterNode.edges, function (item) {
            return item !== null;
          });
        });
      });

      // Remove from cluster list
      util.forEach(deletedEdgeIds, function (edgeId) {
        delete _this4.clusteredEdges[edgeId];
      });

      // Remove cluster edges from active list (this.body.edges).
      // deletedEdgeIds still contains id of regular edges, but these should all
      // be gone when you reach here.
      util.forEach(deletedEdgeIds, function (edgeId) {
        delete _this4.body.edges[edgeId];
      });

      //
      // Check changed cluster state of edges
      //

      // Iterating over keys here, because edges may be removed in the loop
      var ids = (0, _keys2['default'])(this.body.edges);
      util.forEach(ids, function (edgeId) {
        var edge = _this4.body.edges[edgeId];

        var shouldBeClustered = _this4._isClusteredNode(edge.fromId) || _this4._isClusteredNode(edge.toId);
        if (shouldBeClustered === _this4._isClusteredEdge(edge.id)) {
          return; // all is well
        }

        if (shouldBeClustered) {
          // add edge to clustering
          var clusterFrom = _this4._getClusterNodeForNode(edge.fromId);
          if (clusterFrom !== undefined) {
            _this4._clusterEdges(_this4.body.nodes[edge.fromId], edge, clusterFrom);
          }

          var clusterTo = _this4._getClusterNodeForNode(edge.toId);
          if (clusterTo !== undefined) {
            _this4._clusterEdges(_this4.body.nodes[edge.toId], edge, clusterTo);
          }

          // TODO: check that it works for both edges clustered
          //       (This might be paranoia)
        } else {
          // This should not be happening, the state should
          // be properly updated at this point.
          //
          // If it *is* reached during normal operation, then we have to implement
          // undo clustering for this edge here.
          throw new Error('remove edge from clustering not implemented!');
        }
      });

      // Clusters may be nested to any level. Keep on opening until nothing to open
      var changed = false;
      var continueLoop = true;

      var _loop2 = function _loop2() {
        var clustersToOpen = [];

        // Determine the id's of clusters that need opening
        eachClusterNode(function (clusterNode) {
          var numNodes = (0, _keys2['default'])(clusterNode.containedNodes).length;
          var allowSingle = clusterNode.options.allowSingleNodeCluster === true;
          if (allowSingle && numNodes < 1 || !allowSingle && numNodes < 2) {
            clustersToOpen.push(clusterNode.id);
          }
        });

        // Open them
        for (var _n = 0; _n < clustersToOpen.length; ++_n) {
          _this4.openCluster(clustersToOpen[_n], {}, false /* Don't refresh, we're in an refresh/update already */
          );
        }

        continueLoop = clustersToOpen.length > 0;
        changed = changed || continueLoop;
      };

      while (continueLoop) {
        _loop2();
      }

      if (changed) {
        this._updateState(); // Redo this method (recursion possible! should be safe)
      }
    }

    /**
     * Determine if node with given id is part of a cluster.
     *
     * @param {Node.id} nodeId
     * @return {boolean} true if part of a cluster.
     */

  }, {
    key: '_isClusteredNode',
    value: function _isClusteredNode(nodeId) {
      return this.clusteredNodes[nodeId] !== undefined;
    }

    /**
     * Determine if edge with given id is not visible due to clustering.
     *
     * An edge is considered clustered if:
     * - it is directly replaced by a clustering edge
     * - any of its connecting nodes is in a cluster
     *
     * @param {vis.Edge.id} edgeId
     * @return {boolean} true if part of a cluster.
     */

  }, {
    key: '_isClusteredEdge',
    value: function _isClusteredEdge(edgeId) {
      return this.clusteredEdges[edgeId] !== undefined;
    }
  }]);
  return ClusterEngine;
}();

exports['default'] = ClusterEngine;

/***/ }),
/* 179 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(3);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(4);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(5);

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);
var Node = __webpack_require__(34)['default'];

/**
 * A Cluster is a special Node that allows a group of Nodes positioned closely together
 * to be represented by a single Cluster Node.
 *
 * @extends Node
 */

var Cluster = function (_Node) {
  (0, _inherits3['default'])(Cluster, _Node);

  /**
   * @param {Object} options
   * @param {Object} body
   * @param {Array.<HTMLImageElement>}imagelist
   * @param {Array} grouplist
   * @param {Object} globalOptions
   * @param {Object} defaultOptions     Global default options for nodes
   */
  function Cluster(options, body, imagelist, grouplist, globalOptions, defaultOptions) {
    (0, _classCallCheck3['default'])(this, Cluster);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Cluster.__proto__ || (0, _getPrototypeOf2['default'])(Cluster)).call(this, options, body, imagelist, grouplist, globalOptions, defaultOptions));

    _this.isCluster = true;
    _this.containedNodes = {};
    _this.containedEdges = {};
    return _this;
  }

  /**
   * Transfer child cluster data to current and disconnect the child cluster.
   *
   * Please consult the header comment in 'Clustering.js' for the fields set here.
   *
   * @param {string|number} childClusterId  id of child cluster to open
   */


  (0, _createClass3['default'])(Cluster, [{
    key: '_openChildCluster',
    value: function _openChildCluster(childClusterId) {
      var _this2 = this;

      var childCluster = this.body.nodes[childClusterId];
      if (this.containedNodes[childClusterId] === undefined) {
        throw new Error('node with id: ' + childClusterId + ' not in current cluster');
      }
      if (!childCluster.isCluster) {
        throw new Error('node with id: ' + childClusterId + ' is not a cluster');
      }

      // Disconnect child cluster from current cluster
      delete this.containedNodes[childClusterId];
      util.forEach(childCluster.edges, function (edge) {
        delete _this2.containedEdges[edge.id];
      });

      // Transfer nodes and edges
      util.forEach(childCluster.containedNodes, function (node, nodeId) {
        _this2.containedNodes[nodeId] = node;
      });
      childCluster.containedNodes = {};

      util.forEach(childCluster.containedEdges, function (edge, edgeId) {
        _this2.containedEdges[edgeId] = edge;
      });
      childCluster.containedEdges = {};

      // Transfer edges within cluster edges which are clustered
      util.forEach(childCluster.edges, function (clusterEdge) {
        util.forEach(_this2.edges, function (parentClusterEdge) {
          // Assumption: a clustered edge can only be present in a single clustering edge
          // Not tested here
          var index = parentClusterEdge.clusteringEdgeReplacingIds.indexOf(clusterEdge.id);
          if (index === -1) return;

          util.forEach(clusterEdge.clusteringEdgeReplacingIds, function (srcId) {
            parentClusterEdge.clusteringEdgeReplacingIds.push(srcId);

            // Maintain correct bookkeeping for transferred edge
            _this2.body.edges[srcId].edgeReplacedById = parentClusterEdge.id;
          });

          // Remove cluster edge from parent cluster edge
          parentClusterEdge.clusteringEdgeReplacingIds.splice(index, 1);
        });
      });
      childCluster.edges = [];
    }
  }]);
  return Cluster;
}(Node);

exports['default'] = Cluster;

/***/ }),
/* 180 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Initializes window.requestAnimationFrame() to a usable form.
 *
 * Specifically, set up this method for the case of running on node.js with jsdom enabled.
 *
 * NOTES:
 *
 * * On node.js, when calling this directly outside of this class, `window` is not defined.
 *   This happens even if jsdom is used.
 * * For node.js + jsdom, `window` is available at the moment the constructor is called.
 *   For this reason, the called is placed within the constructor.
 * * Even then, `window.requestAnimationFrame()` is not defined, so it still needs to be added.
 * * During unit testing, it happens that the window object is reset during execution, causing
 *   a runtime error due to missing `requestAnimationFrame()`. This needs to be compensated for,
 *   see `_requestNextFrame()`.
 * * Since this is a global object, it may affect other modules besides `Network`. With normal
 *   usage, this does not cause any problems. During unit testing, errors may occur. These have
 *   been compensated for, see comment block in _requestNextFrame().
 *
 * @private
 */
function _initRequestAnimationFrame() {
  var func;

  if (window !== undefined) {
    func = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
  }

  if (func === undefined) {
    // window or method not present, setting mock requestAnimationFrame
    window.requestAnimationFrame = function (callback) {
      //console.log("Called mock requestAnimationFrame");
      callback();
    };
  } else {
    window.requestAnimationFrame = func;
  }
}

var util = __webpack_require__(2);

/**
 * The canvas renderer
 */

var CanvasRenderer = function () {
  /**
   * @param {Object} body
   * @param {Canvas} canvas
   */
  function CanvasRenderer(body, canvas) {
    (0, _classCallCheck3['default'])(this, CanvasRenderer);

    _initRequestAnimationFrame();
    this.body = body;
    this.canvas = canvas;

    this.redrawRequested = false;
    this.renderTimer = undefined;
    this.requiresTimeout = true;
    this.renderingActive = false;
    this.renderRequests = 0;
    this.allowRedraw = true;

    this.dragging = false;
    this.zooming = false;
    this.options = {};
    this.defaultOptions = {
      hideEdgesOnDrag: false,
      hideEdgesOnZoom: false,
      hideNodesOnDrag: false
    };
    util.extend(this.options, this.defaultOptions);

    this._determineBrowserMethod();
    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */


  (0, _createClass3['default'])(CanvasRenderer, [{
    key: 'bindEventListeners',
    value: function bindEventListeners() {
      var _this = this;

      this.body.emitter.on('dragStart', function () {
        _this.dragging = true;
      });
      this.body.emitter.on('dragEnd', function () {
        _this.dragging = false;
      });
      this.body.emitter.on('zoom', function () {
        _this.zooming = true;
        window.clearTimeout(_this.zoomTimeoutId);
        _this.zoomTimeoutId = window.setTimeout(function () {
          _this.zooming = false;
          _this._requestRedraw.bind(_this)();
        }, 250);
      });
      this.body.emitter.on('_resizeNodes', function () {
        _this._resizeNodes();
      });
      this.body.emitter.on('_redraw', function () {
        if (_this.renderingActive === false) {
          _this._redraw();
        }
      });
      this.body.emitter.on('_blockRedraw', function () {
        _this.allowRedraw = false;
      });
      this.body.emitter.on('_allowRedraw', function () {
        _this.allowRedraw = true;
        _this.redrawRequested = false;
      });
      this.body.emitter.on('_requestRedraw', this._requestRedraw.bind(this));
      this.body.emitter.on('_startRendering', function () {
        _this.renderRequests += 1;
        _this.renderingActive = true;
        _this._startRendering();
      });
      this.body.emitter.on('_stopRendering', function () {
        _this.renderRequests -= 1;
        _this.renderingActive = _this.renderRequests > 0;
        _this.renderTimer = undefined;
      });
      this.body.emitter.on('destroy', function () {
        _this.renderRequests = 0;
        _this.allowRedraw = false;
        _this.renderingActive = false;
        if (_this.requiresTimeout === true) {
          clearTimeout(_this.renderTimer);
        } else {
          window.cancelAnimationFrame(_this.renderTimer);
        }
        _this.body.emitter.off();
      });
    }

    /**
     *
     * @param {Object} options
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      if (options !== undefined) {
        var fields = ['hideEdgesOnDrag', 'hideEdgesOnZoom', 'hideNodesOnDrag'];
        util.selectiveDeepExtend(fields, this.options, options);
      }
    }

    /**
     * Prepare the drawing of the next frame.
     *
     * Calls the callback when the next frame can or will be drawn.
     *
     * @param {function} callback
     * @param {number} delay - timeout case only, wait this number of milliseconds
     * @returns {function|undefined}
     * @private
     */

  }, {
    key: '_requestNextFrame',
    value: function _requestNextFrame(callback, delay) {
      // During unit testing, it happens that the mock window object is reset while
      // the next frame is still pending. Then, either 'window' is not present, or
      // 'requestAnimationFrame()' is not present because it is not defined on the
      // mock window object.
      //
      // As a consequence, unrelated unit tests may appear to fail, even if the problem
      // described happens in the current unit test.
      //
      // This is not something that will happen in normal operation, but we still need
      // to take it into account.
      //
      if (typeof window === 'undefined') return; // Doing `if (window === undefined)` does not work here!

      var timer = void 0;

      var myWindow = window; // Grab a reference to reduce the possibility that 'window' is reset
      // while running this method.

      if (this.requiresTimeout === true) {
        // wait given number of milliseconds and perform the animation step function
        timer = myWindow.setTimeout(callback, delay);
      } else {
        if (myWindow.requestAnimationFrame) {
          timer = myWindow.requestAnimationFrame(callback);
        }
      }

      return timer;
    }

    /**
     *
     * @private
     */

  }, {
    key: '_startRendering',
    value: function _startRendering() {
      if (this.renderingActive === true) {
        if (this.renderTimer === undefined) {
          this.renderTimer = this._requestNextFrame(this._renderStep.bind(this), this.simulationInterval);
        }
      }
    }

    /**
     *
     * @private
     */

  }, {
    key: '_renderStep',
    value: function _renderStep() {
      if (this.renderingActive === true) {
        // reset the renderTimer so a new scheduled animation step can be set
        this.renderTimer = undefined;

        if (this.requiresTimeout === true) {
          // this schedules a new simulation step
          this._startRendering();
        }

        this._redraw();

        if (this.requiresTimeout === false) {
          // this schedules a new simulation step
          this._startRendering();
        }
      }
    }

    /**
     * Redraw the network with the current data
     * chart will be resized too.
     */

  }, {
    key: 'redraw',
    value: function redraw() {
      this.body.emitter.emit('setSize');
      this._redraw();
    }

    /**
     * Redraw the network with the current data
     * @private
     */

  }, {
    key: '_requestRedraw',
    value: function _requestRedraw() {
      var _this2 = this;

      if (this.redrawRequested !== true && this.renderingActive === false && this.allowRedraw === true) {
        this.redrawRequested = true;
        this._requestNextFrame(function () {
          _this2._redraw(false);
        }, 0);
      }
    }

    /**
     * Redraw the network with the current data
     * @param {boolean} [hidden=false] | Used to get the first estimate of the node sizes.
     *                                   Only the nodes are drawn after which they are quickly drawn over.
     * @private
     */

  }, {
    key: '_redraw',
    value: function _redraw() {
      var hidden = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

      if (this.allowRedraw === true) {
        this.body.emitter.emit('initRedraw');

        this.redrawRequested = false;

        // when the container div was hidden, this fixes it back up!
        if (this.canvas.frame.canvas.width === 0 || this.canvas.frame.canvas.height === 0) {
          this.canvas.setSize();
        }

        this.canvas.setTransform();

        var ctx = this.canvas.getContext();

        // clear the canvas
        var w = this.canvas.frame.canvas.clientWidth;
        var h = this.canvas.frame.canvas.clientHeight;
        ctx.clearRect(0, 0, w, h);

        // if the div is hidden, we stop the redraw here for performance.
        if (this.canvas.frame.clientWidth === 0) {
          return;
        }

        // set scaling and translation
        ctx.save();
        ctx.translate(this.body.view.translation.x, this.body.view.translation.y);
        ctx.scale(this.body.view.scale, this.body.view.scale);

        ctx.beginPath();
        this.body.emitter.emit('beforeDrawing', ctx);
        ctx.closePath();

        if (hidden === false) {
          if ((this.dragging === false || this.dragging === true && this.options.hideEdgesOnDrag === false) && (this.zooming === false || this.zooming === true && this.options.hideEdgesOnZoom === false)) {
            this._drawEdges(ctx);
          }
        }

        if (this.dragging === false || this.dragging === true && this.options.hideNodesOnDrag === false) {
          this._drawNodes(ctx, hidden);
        }

        ctx.beginPath();
        this.body.emitter.emit('afterDrawing', ctx);
        ctx.closePath();

        // restore original scaling and translation
        ctx.restore();
        if (hidden === true) {
          ctx.clearRect(0, 0, w, h);
        }
      }
    }

    /**
     * Redraw all nodes
     *
     * @param {CanvasRenderingContext2D}   ctx
     * @param {boolean} [alwaysShow]
     * @private
     */

  }, {
    key: '_resizeNodes',
    value: function _resizeNodes() {
      this.canvas.setTransform();
      var ctx = this.canvas.getContext();
      ctx.save();
      ctx.translate(this.body.view.translation.x, this.body.view.translation.y);
      ctx.scale(this.body.view.scale, this.body.view.scale);

      var nodes = this.body.nodes;
      var node = void 0;

      // resize all nodes
      for (var nodeId in nodes) {
        if (nodes.hasOwnProperty(nodeId)) {
          node = nodes[nodeId];
          node.resize(ctx);
          node.updateBoundingBox(ctx, node.selected);
        }
      }

      // restore original scaling and translation
      ctx.restore();
    }

    /**
     * Redraw all nodes
     *
     * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
     * @param {boolean} [alwaysShow]
     * @private
     */

  }, {
    key: '_drawNodes',
    value: function _drawNodes(ctx) {
      var alwaysShow = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      var nodes = this.body.nodes;
      var nodeIndices = this.body.nodeIndices;
      var node = void 0;
      var selected = [];
      var margin = 20;
      var topLeft = this.canvas.DOMtoCanvas({ x: -margin, y: -margin });
      var bottomRight = this.canvas.DOMtoCanvas({
        x: this.canvas.frame.canvas.clientWidth + margin,
        y: this.canvas.frame.canvas.clientHeight + margin
      });
      var viewableArea = {
        top: topLeft.y,
        left: topLeft.x,
        bottom: bottomRight.y,
        right: bottomRight.x

        // draw unselected nodes;
      };for (var i = 0; i < nodeIndices.length; i++) {
        node = nodes[nodeIndices[i]];
        // set selected nodes aside
        if (node.isSelected()) {
          selected.push(nodeIndices[i]);
        } else {
          if (alwaysShow === true) {
            node.draw(ctx);
          } else if (node.isBoundingBoxOverlappingWith(viewableArea) === true) {
            node.draw(ctx);
          } else {
            node.updateBoundingBox(ctx, node.selected);
          }
        }
      }

      // draw the selected nodes on top
      for (var _i = 0; _i < selected.length; _i++) {
        node = nodes[selected[_i]];
        node.draw(ctx);
      }
    }

    /**
     * Redraw all edges
     * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
     * @private
     */

  }, {
    key: '_drawEdges',
    value: function _drawEdges(ctx) {
      var edges = this.body.edges;
      var edgeIndices = this.body.edgeIndices;
      var edge = void 0;

      for (var i = 0; i < edgeIndices.length; i++) {
        edge = edges[edgeIndices[i]];
        if (edge.connected === true) {
          edge.draw(ctx);
        }
      }
    }

    /**
     * Determine if the browser requires a setTimeout or a requestAnimationFrame. This was required because
     * some implementations (safari and IE9) did not support requestAnimationFrame
     * @private
     */

  }, {
    key: '_determineBrowserMethod',
    value: function _determineBrowserMethod() {
      if (typeof window !== 'undefined') {
        var browserType = navigator.userAgent.toLowerCase();
        this.requiresTimeout = false;
        if (browserType.indexOf('msie 9.0') != -1) {
          // IE 9
          this.requiresTimeout = true;
        } else if (browserType.indexOf('safari') != -1) {
          // safari
          if (browserType.indexOf('chrome') <= -1) {
            this.requiresTimeout = true;
          }
        }
      } else {
        this.requiresTimeout = true;
      }
    }
  }]);
  return CanvasRenderer;
}();

exports['default'] = CanvasRenderer;

/***/ }),
/* 181 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var Hammer = __webpack_require__(24);
var hammerUtil = __webpack_require__(36);

var util = __webpack_require__(2);

/**
 * Create the main frame for the Network.
 * This function is executed once when a Network object is created. The frame
 * contains a canvas, and this canvas contains all objects like the axis and
 * nodes.
 */

var Canvas = function () {
  /**
   * @param {Object} body
   */
  function Canvas(body) {
    (0, _classCallCheck3['default'])(this, Canvas);

    this.body = body;
    this.pixelRatio = 1;
    this.resizeTimer = undefined;
    this.resizeFunction = this._onResize.bind(this);
    this.cameraState = {};
    this.initialized = false;
    this.canvasViewCenter = {};

    this.options = {};
    this.defaultOptions = {
      autoResize: true,
      height: '100%',
      width: '100%'
    };
    util.extend(this.options, this.defaultOptions);

    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */


  (0, _createClass3['default'])(Canvas, [{
    key: 'bindEventListeners',
    value: function bindEventListeners() {
      var _this = this;

      // bind the events
      this.body.emitter.once('resize', function (obj) {
        if (obj.width !== 0) {
          _this.body.view.translation.x = obj.width * 0.5;
        }
        if (obj.height !== 0) {
          _this.body.view.translation.y = obj.height * 0.5;
        }
      });
      this.body.emitter.on('setSize', this.setSize.bind(this));
      this.body.emitter.on('destroy', function () {
        _this.hammerFrame.destroy();
        _this.hammer.destroy();
        _this._cleanUp();
      });
    }

    /**
     * @param {Object} options
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      var _this2 = this;

      if (options !== undefined) {
        var fields = ['width', 'height', 'autoResize'];
        util.selectiveDeepExtend(fields, this.options, options);
      }

      if (this.options.autoResize === true) {
        // automatically adapt to a changing size of the browser.
        this._cleanUp();
        this.resizeTimer = setInterval(function () {
          var changed = _this2.setSize();
          if (changed === true) {
            _this2.body.emitter.emit('_requestRedraw');
          }
        }, 1000);
        this.resizeFunction = this._onResize.bind(this);
        util.addEventListener(window, 'resize', this.resizeFunction);
      }
    }

    /**
     * @private
     */

  }, {
    key: '_cleanUp',
    value: function _cleanUp() {
      // automatically adapt to a changing size of the browser.
      if (this.resizeTimer !== undefined) {
        clearInterval(this.resizeTimer);
      }
      util.removeEventListener(window, 'resize', this.resizeFunction);
      this.resizeFunction = undefined;
    }

    /**
     * @private
     */

  }, {
    key: '_onResize',
    value: function _onResize() {
      this.setSize();
      this.body.emitter.emit('_redraw');
    }

    /**
     * Get and store the cameraState
     *
     * @param {number} [pixelRatio=this.pixelRatio]
     * @private
     */

  }, {
    key: '_getCameraState',
    value: function _getCameraState() {
      var pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.pixelRatio;

      if (this.initialized === true) {
        this.cameraState.previousWidth = this.frame.canvas.width / pixelRatio;
        this.cameraState.previousHeight = this.frame.canvas.height / pixelRatio;
        this.cameraState.scale = this.body.view.scale;
        this.cameraState.position = this.DOMtoCanvas({
          x: 0.5 * this.frame.canvas.width / pixelRatio,
          y: 0.5 * this.frame.canvas.height / pixelRatio
        });
      }
    }

    /**
     * Set the cameraState
     * @private
     */

  }, {
    key: '_setCameraState',
    value: function _setCameraState() {
      if (this.cameraState.scale !== undefined && this.frame.canvas.clientWidth !== 0 && this.frame.canvas.clientHeight !== 0 && this.pixelRatio !== 0 && this.cameraState.previousWidth > 0) {
        var widthRatio = this.frame.canvas.width / this.pixelRatio / this.cameraState.previousWidth;
        var heightRatio = this.frame.canvas.height / this.pixelRatio / this.cameraState.previousHeight;
        var newScale = this.cameraState.scale;

        if (widthRatio != 1 && heightRatio != 1) {
          newScale = this.cameraState.scale * 0.5 * (widthRatio + heightRatio);
        } else if (widthRatio != 1) {
          newScale = this.cameraState.scale * widthRatio;
        } else if (heightRatio != 1) {
          newScale = this.cameraState.scale * heightRatio;
        }

        this.body.view.scale = newScale;
        // this comes from the view module.
        var currentViewCenter = this.DOMtoCanvas({
          x: 0.5 * this.frame.canvas.clientWidth,
          y: 0.5 * this.frame.canvas.clientHeight
        });

        var distanceFromCenter = {
          // offset from view, distance view has to change by these x and y to center the node
          x: currentViewCenter.x - this.cameraState.position.x,
          y: currentViewCenter.y - this.cameraState.position.y
        };
        this.body.view.translation.x += distanceFromCenter.x * this.body.view.scale;
        this.body.view.translation.y += distanceFromCenter.y * this.body.view.scale;
      }
    }

    /**
     *
     * @param {number|string} value
     * @returns {string}
     * @private
     */

  }, {
    key: '_prepareValue',
    value: function _prepareValue(value) {
      if (typeof value === 'number') {
        return value + 'px';
      } else if (typeof value === 'string') {
        if (value.indexOf('%') !== -1 || value.indexOf('px') !== -1) {
          return value;
        } else if (value.indexOf('%') === -1) {
          return value + 'px';
        }
      }
      throw new Error('Could not use the value supplied for width or height:' + value);
    }

    /**
     * Create the HTML
     */

  }, {
    key: '_create',
    value: function _create() {
      // remove all elements from the container element.
      while (this.body.container.hasChildNodes()) {
        this.body.container.removeChild(this.body.container.firstChild);
      }

      this.frame = document.createElement('div');
      this.frame.className = 'vis-network';
      this.frame.style.position = 'relative';
      this.frame.style.overflow = 'hidden';
      this.frame.tabIndex = 900; // tab index is required for keycharm to bind keystrokes to the div instead of the window

      //////////////////////////////////////////////////////////////////

      this.frame.canvas = document.createElement('canvas');
      this.frame.canvas.style.position = 'relative';
      this.frame.appendChild(this.frame.canvas);

      if (!this.frame.canvas.getContext) {
        var noCanvas = document.createElement('DIV');
        noCanvas.style.color = 'red';
        noCanvas.style.fontWeight = 'bold';
        noCanvas.style.padding = '10px';
        noCanvas.innerHTML = 'Error: your browser does not support HTML canvas';
        this.frame.canvas.appendChild(noCanvas);
      } else {
        this._setPixelRatio();
        this.setTransform();
      }

      // add the frame to the container element
      this.body.container.appendChild(this.frame);

      this.body.view.scale = 1;
      this.body.view.translation = {
        x: 0.5 * this.frame.canvas.clientWidth,
        y: 0.5 * this.frame.canvas.clientHeight
      };

      this._bindHammer();
    }

    /**
     * This function binds hammer, it can be repeated over and over due to the uniqueness check.
     * @private
     */

  }, {
    key: '_bindHammer',
    value: function _bindHammer() {
      var _this3 = this;

      if (this.hammer !== undefined) {
        this.hammer.destroy();
      }
      this.drag = {};
      this.pinch = {};

      // init hammer
      this.hammer = new Hammer(this.frame.canvas);
      this.hammer.get('pinch').set({ enable: true });
      // enable to get better response, todo: test on mobile.
      this.hammer.get('pan').set({ threshold: 5, direction: Hammer.DIRECTION_ALL });

      hammerUtil.onTouch(this.hammer, function (event) {
        _this3.body.eventListeners.onTouch(event);
      });
      this.hammer.on('tap', function (event) {
        _this3.body.eventListeners.onTap(event);
      });
      this.hammer.on('doubletap', function (event) {
        _this3.body.eventListeners.onDoubleTap(event);
      });
      this.hammer.on('press', function (event) {
        _this3.body.eventListeners.onHold(event);
      });
      this.hammer.on('panstart', function (event) {
        _this3.body.eventListeners.onDragStart(event);
      });
      this.hammer.on('panmove', function (event) {
        _this3.body.eventListeners.onDrag(event);
      });
      this.hammer.on('panend', function (event) {
        _this3.body.eventListeners.onDragEnd(event);
      });
      this.hammer.on('pinch', function (event) {
        _this3.body.eventListeners.onPinch(event);
      });

      // TODO: neatly cleanup these handlers when re-creating the Canvas, IF these are done with hammer, event.stopPropagation will not work?
      this.frame.canvas.addEventListener('mousewheel', function (event) {
        _this3.body.eventListeners.onMouseWheel(event);
      });
      this.frame.canvas.addEventListener('DOMMouseScroll', function (event) {
        _this3.body.eventListeners.onMouseWheel(event);
      });

      this.frame.canvas.addEventListener('mousemove', function (event) {
        _this3.body.eventListeners.onMouseMove(event);
      });
      this.frame.canvas.addEventListener('contextmenu', function (event) {
        _this3.body.eventListeners.onContext(event);
      });

      this.hammerFrame = new Hammer(this.frame);
      hammerUtil.onRelease(this.hammerFrame, function (event) {
        _this3.body.eventListeners.onRelease(event);
      });
    }

    /**
     * Set a new size for the network
     * @param {string} width   Width in pixels or percentage (for example '800px'
     *                         or '50%')
     * @param {string} height  Height in pixels or percentage  (for example '400px'
     *                         or '30%')
     * @returns {boolean}
     */

  }, {
    key: 'setSize',
    value: function setSize() {
      var width = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.options.width;
      var height = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.options.height;

      width = this._prepareValue(width);
      height = this._prepareValue(height);

      var emitEvent = false;
      var oldWidth = this.frame.canvas.width;
      var oldHeight = this.frame.canvas.height;

      // update the pixel ratio
      //
      // NOTE: Comment in following is rather inconsistent; this is the ONLY place in the code
      //       where it is assumed that the pixel ratio could change at runtime.
      //       The only way I can think of this happening is a rotating screen or tablet; but then
      //       there should be a mechanism for reloading the data (TODO: check if this is present).
      //
      //       If the assumption is true (i.e. pixel ratio can change at runtime), then *all* usage
      //       of pixel ratio must be overhauled for this.
      //
      //       For the time being, I will humor the assumption here, and in the rest of the code assume it is
      //       constant.
      var previousRatio = this.pixelRatio; // we cache this because the camera state storage needs the old value
      this._setPixelRatio();

      if (width != this.options.width || height != this.options.height || this.frame.style.width != width || this.frame.style.height != height) {
        this._getCameraState(previousRatio);

        this.frame.style.width = width;
        this.frame.style.height = height;

        this.frame.canvas.style.width = '100%';
        this.frame.canvas.style.height = '100%';

        this.frame.canvas.width = Math.round(this.frame.canvas.clientWidth * this.pixelRatio);
        this.frame.canvas.height = Math.round(this.frame.canvas.clientHeight * this.pixelRatio);

        this.options.width = width;
        this.options.height = height;

        this.canvasViewCenter = {
          x: 0.5 * this.frame.clientWidth,
          y: 0.5 * this.frame.clientHeight
        };

        emitEvent = true;
      } else {
        // this would adapt the width of the canvas to the width from 100% if and only if
        // there is a change.

        var newWidth = Math.round(this.frame.canvas.clientWidth * this.pixelRatio);
        var newHeight = Math.round(this.frame.canvas.clientHeight * this.pixelRatio);

        // store the camera if there is a change in size.
        if (this.frame.canvas.width !== newWidth || this.frame.canvas.height !== newHeight) {
          this._getCameraState(previousRatio);
        }

        if (this.frame.canvas.width !== newWidth) {
          this.frame.canvas.width = newWidth;
          emitEvent = true;
        }
        if (this.frame.canvas.height !== newHeight) {
          this.frame.canvas.height = newHeight;
          emitEvent = true;
        }
      }

      if (emitEvent === true) {
        this.body.emitter.emit('resize', {
          width: Math.round(this.frame.canvas.width / this.pixelRatio),
          height: Math.round(this.frame.canvas.height / this.pixelRatio),
          oldWidth: Math.round(oldWidth / this.pixelRatio),
          oldHeight: Math.round(oldHeight / this.pixelRatio)
        });

        // restore the camera on change.
        this._setCameraState();
      }

      // set initialized so the get and set camera will work from now on.
      this.initialized = true;
      return emitEvent;
    }

    /**
     *
     * @returns {CanvasRenderingContext2D}
     */

  }, {
    key: 'getContext',
    value: function getContext() {
      return this.frame.canvas.getContext('2d');
    }

    /**
     * Determine the pixel ratio for various browsers.
     *
     * @returns {number}
     * @private
     */

  }, {
    key: '_determinePixelRatio',
    value: function _determinePixelRatio() {
      var ctx = this.getContext();
      if (ctx === undefined) {
        throw new Error('Could not get canvax context');
      }

      var numerator = 1;
      if (typeof window !== 'undefined') {
        // (window !== undefined) doesn't work here!
        // Protection during unit tests, where 'window' can be missing
        numerator = window.devicePixelRatio || 1;
      }

      var denominator = ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;

      return numerator / denominator;
    }

    /**
     * Lazy determination of pixel ratio.
     *
     * @private
     */

  }, {
    key: '_setPixelRatio',
    value: function _setPixelRatio() {
      this.pixelRatio = this._determinePixelRatio();
    }

    /**
     * Set the transform in the contained context, based on its pixelRatio
     */

  }, {
    key: 'setTransform',
    value: function setTransform() {
      var ctx = this.getContext();
      if (ctx === undefined) {
        throw new Error('Could not get canvax context');
      }

      ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
    }

    /**
     * Convert the X coordinate in DOM-space (coordinate point in browser relative to the container div) to
     * the X coordinate in canvas-space (the simulation sandbox, which the camera looks upon)
     * @param {number} x
     * @returns {number}
     * @private
     */

  }, {
    key: '_XconvertDOMtoCanvas',
    value: function _XconvertDOMtoCanvas(x) {
      return (x - this.body.view.translation.x) / this.body.view.scale;
    }

    /**
     * Convert the X coordinate in canvas-space (the simulation sandbox, which the camera looks upon) to
     * the X coordinate in DOM-space (coordinate point in browser relative to the container div)
     * @param {number} x
     * @returns {number}
     * @private
     */

  }, {
    key: '_XconvertCanvasToDOM',
    value: function _XconvertCanvasToDOM(x) {
      return x * this.body.view.scale + this.body.view.translation.x;
    }

    /**
     * Convert the Y coordinate in DOM-space (coordinate point in browser relative to the container div) to
     * the Y coordinate in canvas-space (the simulation sandbox, which the camera looks upon)
     * @param {number} y
     * @returns {number}
     * @private
     */

  }, {
    key: '_YconvertDOMtoCanvas',
    value: function _YconvertDOMtoCanvas(y) {
      return (y - this.body.view.translation.y) / this.body.view.scale;
    }

    /**
     * Convert the Y coordinate in canvas-space (the simulation sandbox, which the camera looks upon) to
     * the Y coordinate in DOM-space (coordinate point in browser relative to the container div)
     * @param {number} y
     * @returns {number}
     * @private
     */

  }, {
    key: '_YconvertCanvasToDOM',
    value: function _YconvertCanvasToDOM(y) {
      return y * this.body.view.scale + this.body.view.translation.y;
    }

    /**
     * @param {point} pos
     * @returns {point}
     */

  }, {
    key: 'canvasToDOM',
    value: function canvasToDOM(pos) {
      return {
        x: this._XconvertCanvasToDOM(pos.x),
        y: this._YconvertCanvasToDOM(pos.y)
      };
    }

    /**
     *
     * @param {point} pos
     * @returns {point}
     */

  }, {
    key: 'DOMtoCanvas',
    value: function DOMtoCanvas(pos) {
      return {
        x: this._XconvertDOMtoCanvas(pos.x),
        y: this._YconvertDOMtoCanvas(pos.y)
      };
    }
  }]);
  return Canvas;
}();

exports['default'] = Canvas;

/***/ }),
/* 182 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _assign = __webpack_require__(78);

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = __webpack_require__(0);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(1);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var util = __webpack_require__(2);

var NetworkUtil = __webpack_require__(57)['default'];

/**
 * The view
 */

var View = function () {
  /**
   * @param {Object} body
   * @param {Canvas} canvas
   */
  function View(body, canvas) {
    var _this = this;

    (0, _classCallCheck3['default'])(this, View);

    this.body = body;
    this.canvas = canvas;

    this.animationSpeed = 1 / this.renderRefreshRate;
    this.animationEasingFunction = 'easeInOutQuint';
    this.easingTime = 0;
    this.sourceScale = 0;
    this.targetScale = 0;
    this.sourceTranslation = 0;
    this.targetTranslation = 0;
    this.lockedOnNodeId = undefined;
    this.lockedOnNodeOffset = undefined;
    this.touchTime = 0;

    this.viewFunction = undefined;

    this.body.emitter.on('fit', this.fit.bind(this));
    this.body.emitter.on('animationFinished', function () {
      _this.body.emitter.emit('_stopRendering');
    });
    this.body.emitter.on('unlockNode', this.releaseNode.bind(this));
  }

  /**
   *
   * @param {Object} [options={}]
   */


  (0, _createClass3['default'])(View, [{
    key: 'setOptions',
    value: function setOptions() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      this.options = options;
    }

    /**
     * This function zooms out to fit all data on screen based on amount of nodes
     * @param {Object} [options={{nodes=Array}}]
     * @param {boolean} [initialZoom=false]  | zoom based on fitted formula or range, true = fitted, default = false;
     */

  }, {
    key: 'fit',
    value: function fit() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { nodes: [] };
      var initialZoom = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      var range = void 0;
      var zoomLevel = void 0;
      options = (0, _assign2['default'])({}, options);
      if (options.nodes === undefined || options.nodes.length === 0) {
        options.nodes = this.body.nodeIndices;
      }

      if (initialZoom === true) {
        // check if more than half of the nodes have a predefined position. If so, we use the range, not the approximation.
        var positionDefined = 0;
        for (var nodeId in this.body.nodes) {
          if (this.body.nodes.hasOwnProperty(nodeId)) {
            var node = this.body.nodes[nodeId];
            if (node.predefinedPosition === true) {
              positionDefined += 1;
            }
          }
        }
        if (positionDefined > 0.5 * this.body.nodeIndices.length) {
          this.fit(options, false);
          return;
        }

        range = NetworkUtil.getRange(this.body.nodes, options.nodes);

        var numberOfNodes = this.body.nodeIndices.length;
        zoomLevel = 12.662 / (numberOfNodes + 7.4147) + 0.0964822; // this is obtained from fitting a dataset from 5 points with scale levels that looked good.

        // correct for larger canvasses.
        var factor = Math.min(this.canvas.frame.canvas.clientWidth / 600, this.canvas.frame.canvas.clientHeight / 600);
        zoomLevel *= factor;
      } else {
        this.body.emitter.emit('_resizeNodes');
        range = NetworkUtil.getRange(this.body.nodes, options.nodes);

        var xDistance = Math.abs(range.maxX - range.minX) * 1.1;
        var yDistance = Math.abs(range.maxY - range.minY) * 1.1;

        var xZoomLevel = this.canvas.frame.canvas.clientWidth / xDistance;
        var yZoomLevel = this.canvas.frame.canvas.clientHeight / yDistance;

        zoomLevel = xZoomLevel <= yZoomLevel ? xZoomLevel : yZoomLevel;
      }

      if (zoomLevel > 1.0) {
        zoomLevel = 1.0;
      } else if (zoomLevel === 0) {
        zoomLevel = 1.0;
      }

      var center = NetworkUtil.findCenter(range);
      var animationOptions = {
        position: center,
        scale: zoomLevel,
        animation: options.animation
      };
      this.moveTo(animationOptions);
    }

    // animation

    /**
     * Center a node in view.
     *
     * @param {number} nodeId
     * @param {number} [options]
     */

  }, {
    key: 'focus',
    value: function focus(nodeId) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (this.body.nodes[nodeId] !== undefined) {
        var nodePosition = {
          x: this.body.nodes[nodeId].x,
          y: this.body.nodes[nodeId].y
        };
        options.position = nodePosition;
        options.lockedOnNode = nodeId;

        this.moveTo(options);
      } else {
        console.log('Node: ' + nodeId + ' cannot be found.');
      }
    }

    /**
     *
     * @param {Object} options  |  options.offset   = {x:number, y:number}   // offset from the center in DOM pixels
     *                          |  options.scale    = number                 // scale to move to
     *                          |  options.position = {x:number, y:number}   // position to move to
     *                          |  options.animation = {duration:number, easingFunction:String} || Boolean   // position to move to
     */

  }, {
    key: 'moveTo',
    value: function moveTo(options) {
      if (options === undefined) {
        options = {};
        return;
      }
      if (options.offset === undefined) {
        options.offset = { x: 0, y: 0 };
      }
      if (options.offset.x === undefined) {
        options.offset.x = 0;
      }
      if (options.offset.y === undefined) {
        options.offset.y = 0;
      }
      if (options.scale === undefined) {
        options.scale = this.body.view.scale;
      }
      if (options.position === undefined) {
        options.position = this.getViewPosition();
      }
      if (options.animation === undefined) {
        options.animation = { duration: 0 };
      }
      if (options.animation === false) {
        options.animation = { duration: 0 };
      }
      if (options.animation === true) {
        options.animation = {};
      }
      if (options.animation.duration === undefined) {
        options.animation.duration = 1000;
      } // default duration
      if (options.animation.easingFunction === undefined) {
        options.animation.easingFunction = 'easeInOutQuad';
      } // default easing function

      this.animateView(options);
    }

    /**
     *
     * @param {Object} options  |  options.offset   = {x:number, y:number}   // offset from the center in DOM pixels
     *                          |  options.time     = number                 // animation time in milliseconds
     *                          |  options.scale    = number                 // scale to animate to
     *                          |  options.position = {x:number, y:number}   // position to animate to
     *                          |  options.easingFunction = String           // linear, easeInQuad, easeOutQuad, easeInOutQuad,
     *                                                                       // easeInCubic, easeOutCubic, easeInOutCubic,
     *                                                                       // easeInQuart, easeOutQuart, easeInOutQuart,
     *                                                                       // easeInQuint, easeOutQuint, easeInOutQuint
     */

  }, {
    key: 'animateView',
    value: function animateView(options) {
      if (options === undefined) {
        return;
      }
      this.animationEasingFunction = options.animation.easingFunction;
      // release if something focussed on the node
      this.releaseNode();
      if (options.locked === true) {
        this.lockedOnNodeId = options.lockedOnNode;
        this.lockedOnNodeOffset = options.offset;
      }

      // forcefully complete the old animation if it was still running
      if (this.easingTime != 0) {
        this._transitionRedraw(true); // by setting easingtime to 1, we finish the animation.
      }

      this.sourceScale = this.body.view.scale;
      this.sourceTranslation = this.body.view.translation;
      this.targetScale = options.scale;

      // set the scale so the viewCenter is based on the correct zoom level. This is overridden in the transitionRedraw
      // but at least then we'll have the target transition
      this.body.view.scale = this.targetScale;
      var viewCenter = this.canvas.DOMtoCanvas({
        x: 0.5 * this.canvas.frame.canvas.clientWidth,
        y: 0.5 * this.canvas.frame.canvas.clientHeight
      });

      var distanceFromCenter = {
        // offset from view, distance view has to change by these x and y to center the node
        x: viewCenter.x - options.position.x,
        y: viewCenter.y - options.position.y
      };
      this.targetTranslation = {
        x: this.sourceTranslation.x + distanceFromCenter.x * this.targetScale + options.offset.x,
        y: this.sourceTranslation.y + distanceFromCenter.y * this.targetScale + options.offset.y

        // if the time is set to 0, don't do an animation
      };if (options.animation.duration === 0) {
        if (this.lockedOnNodeId != undefined) {
          this.viewFunction = this._lockedRedraw.bind(this);
          this.body.emitter.on('initRedraw', this.viewFunction);
        } else {
          this.body.view.scale = this.targetScale;
          this.body.view.translation = this.targetTranslation;
          this.body.emitter.emit('_requestRedraw');
        }
      } else {
        this.animationSpeed = 1 / (60 * options.animation.duration * 0.001) || 1 / 60; // 60 for 60 seconds, 0.001 for milli's
        this.animationEasingFunction = options.animation.easingFunction;

        this.viewFunction = this._transitionRedraw.bind(this);
        this.body.emitter.on('initRedraw', this.viewFunction);
        this.body.emitter.emit('_startRendering');
      }
    }

    /**
     * used to animate smoothly by hijacking the redraw function.
     * @private
     */

  }, {
    key: '_lockedRedraw',
    value: function _lockedRedraw() {
      var nodePosition = {
        x: this.body.nodes[this.lockedOnNodeId].x,
        y: this.body.nodes[this.lockedOnNodeId].y
      };
      var viewCenter = this.canvas.DOMtoCanvas({
        x: 0.5 * this.canvas.frame.canvas.clientWidth,
        y: 0.5 * this.canvas.frame.canvas.clientHeight
      });
      var distanceFromCenter = {
        // offset from view, distance view has to change by these x and y to center the node
        x: viewCenter.x - nodePosition.x,
        y: viewCenter.y - nodePosition.y
      };
      var sourceTranslation = this.body.view.translation;
      var targetTranslation = {
        x: sourceTranslation.x + distanceFromCenter.x * this.body.view.scale + this.lockedOnNodeOffset.x,
        y: sourceTranslation.y + distanceFromCenter.y * this.body.view.scale + this.lockedOnNodeOffset.y
      };

      this.body.view.translation = targetTranslation;
    }

    /**
     * Resets state of a locked on Node
     */

  }, {
    key: 'releaseNode',
    value: function releaseNode() {
      if (this.lockedOnNodeId !== undefined && this.viewFunction !