function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

import "core-js/modules/es.array.concat.js";
import "core-js/modules/es.array.map.js";
import "core-js/modules/es.object.entries.js";
import "core-js/modules/es.function.name.js";
import "core-js/modules/es.object.assign.js";
import "core-js/modules/es.array.filter.js";
import "core-js/modules/es.string.bold.js";
import "core-js/modules/es.array.find.js";
import "core-js/modules/es.object.keys.js";
import "core-js/modules/es.string.replace.js";
import "core-js/modules/es.regexp.exec.js";
import "core-js/modules/es.symbol.js";
import "core-js/modules/es.symbol.description.js";
import "core-js/modules/es.object.to-string.js";
import "core-js/modules/es.symbol.iterator.js";
import "core-js/modules/es.string.iterator.js";
import "core-js/modules/es.array.iterator.js";
import "core-js/modules/web.dom-collections.iterator.js";
import "core-js/modules/es.array.from.js";
import "core-js/modules/es.array.slice.js";

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/* eslint-disable no-fallthrough */
import React, { Fragment, useEffect, useRef, memo } from 'react';
import memoize from 'memoizerific';
import { styled, Global, withTheme } from '@storybook/theming';
import { Icons, IconButton, WithTooltip, TooltipLinkList } from '@storybook/components';
import { useStorybookApi, useParameter, useAddonState } from '@storybook/api';
import { registerShortcuts } from './shortcuts';
import { PARAM_KEY, ADDON_ID } from './constants';
import { MINIMAL_VIEWPORTS } from './defaults';
var toList = memoize(50)(function (items) {
  return [].concat(baseViewports, _toConsumableArray(Object.entries(items).map(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        id = _ref3[0],
        _ref = _ref3[1];

    var name = _ref.name,
        rest = _objectWithoutProperties(_ref, ["name"]);

    return Object.assign({}, rest, {
      id: id,
      title: name
    });
  })));
});
var responsiveViewport = {
  id: 'reset',
  title: 'Reset viewport',
  styles: null,
  type: 'other'
};
var baseViewports = [responsiveViewport];
var toLinks = memoize(50)(function (list, active, set, state, close) {
  return list.map(function (i) {
    switch (i.id) {
      case responsiveViewport.id:
        {
          if (active.id === i.id) {
            return null;
          }
        }

      default:
        {
          return Object.assign({}, i, {
            onClick: function onClick() {
              set(Object.assign({}, state, {
                selected: i.id
              }));
              close();
            }
          });
        }
    }
  }).filter(Boolean);
});
var iframeId = 'storybook-preview-iframe';
var wrapperId = 'storybook-preview-wrapper';

var flip = function flip(_ref4) {
  var width = _ref4.width,
      height = _ref4.height,
      styles = _objectWithoutProperties(_ref4, ["width", "height"]);

  return Object.assign({}, styles, {
    height: width,
    width: height
  });
};

var ActiveViewportSize = styled.div(function () {
  return {
    display: 'inline-flex'
  };
});
var ActiveViewportLabel = styled.div(function (_ref5) {
  var theme = _ref5.theme;
  return {
    display: 'inline-block',
    textDecoration: 'none',
    padding: 10,
    fontWeight: theme.typography.weight.bold,
    fontSize: theme.typography.size.s2 - 1,
    lineHeight: '1',
    height: 40,
    border: 'none',
    borderTop: '3px solid transparent',
    borderBottom: '3px solid transparent',
    background: 'transparent'
  };
});
var IconButtonWithLabel = styled(IconButton)(function () {
  return {
    display: 'inline-flex',
    alignItems: 'center'
  };
});
var IconButtonLabel = styled.div(function (_ref6) {
  var theme = _ref6.theme;
  return {
    fontSize: theme.typography.size.s2 - 1,
    marginLeft: 10
  };
});

var getStyles = function getStyles(prevStyles, styles, isRotated) {
  if (styles === null) {
    return null;
  }

  var result = typeof styles === 'function' ? styles(prevStyles) : styles;
  return isRotated ? flip(result) : result;
};

export var ViewportTool = /*#__PURE__*/memo(withTheme(function (_ref7) {
  var _ref9;

  var theme = _ref7.theme;

  var _useParameter = useParameter(PARAM_KEY, {}),
      _useParameter$viewpor = _useParameter.viewports,
      viewports = _useParameter$viewpor === void 0 ? MINIMAL_VIEWPORTS : _useParameter$viewpor,
      _useParameter$default = _useParameter.defaultViewport,
      defaultViewport = _useParameter$default === void 0 ? responsiveViewport.id : _useParameter$default,
      disable = _useParameter.disable;

  var _useAddonState = useAddonState(ADDON_ID, {
    selected: defaultViewport,
    isRotated: false
  }),
      _useAddonState2 = _slicedToArray(_useAddonState, 2),
      state = _useAddonState2[0],
      setState = _useAddonState2[1];

  var list = toList(viewports);
  var api = useStorybookApi();

  if (!list.find(function (i) {
    return i.id === defaultViewport;
  })) {
    // eslint-disable-next-line no-console
    console.warn("Cannot find \"defaultViewport\" of \"".concat(defaultViewport, "\" in addon-viewport configs, please check the \"viewports\" setting in the configuration."));
  }

  useEffect(function () {
    registerShortcuts(api, setState, Object.keys(viewports));
  }, [viewports]);
  useEffect(function () {
    setState({
      selected: defaultViewport || (viewports[state.selected] ? state.selected : responsiveViewport.id),
      isRotated: state.isRotated
    });
  }, [defaultViewport]);
  var selected = state.selected,
      isRotated = state.isRotated;
  var item = list.find(function (i) {
    return i.id === selected;
  }) || list.find(function (i) {
    return i.id === defaultViewport;
  }) || list.find(function (i) {
    return i.default;
  }) || responsiveViewport;
  var ref = useRef();
  var styles = getStyles(ref.current, item.styles, isRotated);
  useEffect(function () {
    ref.current = styles;
  }, [item]);

  if (disable || Object.entries(viewports).length === 0) {
    return null;
  }

  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(WithTooltip, {
    placement: "top",
    trigger: "click",
    tooltip: function tooltip(_ref8) {
      var onHide = _ref8.onHide;
      return /*#__PURE__*/React.createElement(TooltipLinkList, {
        links: toLinks(list, item, setState, state, onHide)
      });
    },
    closeOnClick: true
  }, /*#__PURE__*/React.createElement(IconButtonWithLabel, {
    key: "viewport",
    title: "Change the size of the preview",
    active: !!styles,
    onDoubleClick: function onDoubleClick() {
      setState(Object.assign({}, state, {
        selected: responsiveViewport.id
      }));
    }
  }, /*#__PURE__*/React.createElement(Icons, {
    icon: "grow"
  }), styles ? /*#__PURE__*/React.createElement(IconButtonLabel, null, isRotated ? "".concat(item.title, " (L)") : "".concat(item.title, " (P)")) : null)), styles ? /*#__PURE__*/React.createElement(ActiveViewportSize, null, /*#__PURE__*/React.createElement(Global, {
    styles: (_ref9 = {}, _defineProperty(_ref9, "#".concat(iframeId), Object.assign({
      margin: "auto",
      transition: 'width .3s, height .3s',
      position: 'relative',
      border: "1px solid black",
      boxShadow: '0 0 100px 100vw rgba(0,0,0,0.5)'
    }, styles)), _defineProperty(_ref9, "#".concat(wrapperId), {
      padding: theme.layoutMargin,
      alignContent: 'center',
      alignItems: 'center',
      justifyContent: 'center',
      justifyItems: 'center',
      overflow: 'auto',
      display: 'grid',
      gridTemplateColumns: '100%',
      gridTemplateRows: '100%'
    }), _ref9)
  }), /*#__PURE__*/React.createElement(ActiveViewportLabel, {
    title: "Viewport width"
  }, styles.width.replace('px', '')), /*#__PURE__*/React.createElement(IconButton, {
    key: "viewport-rotate",
    title: "Rotate viewport",
    onClick: function onClick() {
      setState(Object.assign({}, state, {
        isRotated: !isRotated
      }));
    }
  }, /*#__PURE__*/React.createElement(Icons, {
    icon: "transfer"
  })), /*#__PURE__*/React.createElement(ActiveViewportLabel, {
    title: "Viewport height"
  }, styles.height.replace('px', ''))) : null);
}));