/**
 * @author Microsoft
 * @copyright © Microsoft Corporation. All rights reserved.
 * @compiler Bridge.NET 17.10.1
 */
Bridge.assembly("Kusto.Language.Bridge", function ($asm, globals) {
    "use strict";

    /** @namespace Kusto.Language */

    /**
     * Well known aggregates
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Aggregates
     */
    Bridge.define("Kusto.Language.Aggregates", {
        statics: {
            fields: {
                Sum: null,
                SumIf: null,
                Cnt: null,
                Count: null,
                CountIf: null,
                DCount: null,
                DCountIf: null,
                TDigest: null,
                TDigestMerge: null,
                MergeTDigests: null,
                Hll: null,
                HllMerge: null,
                Min: null,
                MinIf: null,
                Max: null,
                MaxIf: null,
                Avg: null,
                AvgIf: null,
                MakeList_Deprecated: null,
                MakeList: null,
                MakeListIf: null,
                MakeListWithNulls: null,
                MakeSet_Deprecated: null,
                MakeSet: null,
                MakeSetIf: null,
                Passthrough: null,
                MakeDictionary: null,
                MakeBag: null,
                MakeBagIf: null,
                BuildSchema: null,
                BinaryAllOr: null,
                BinaryAllAnd: null,
                BinaryAllXor: null,
                PercentileReturn: null,
                PercentileArrayReturn: null,
                Percentile: null,
                Percentiles: null,
                PercentilesArray: null,
                PercentileW: null,
                PercentilesW: null,
                PercentilesWArray: null,
                Stdev: null,
                StdevIf: null,
                Stdevp: null,
                Variance: null,
                VarianceIf: null,
                Variancep: null,
                Any: null,
                TakeAny: null,
                AnyIf: null,
                TakeAnyIf: null,
                ArgMin: null,
                ArgMax: null,
                ArgMin_Deprecated: null,
                ArgMax_Deprecated: null
            },
            props: {
                All: null
            },
            ctors: {
                init: function () {
                    this.Sum = new Kusto.Language.Symbols.FunctionSymbol.$ctor4("sum", Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("sum");
                    this.SumIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor4("sumif", Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("sumif");
                    this.Cnt = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("cnt", Kusto.Language.Symbols.ScalarTypes.Long).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("cnt").Obsolete("count").Hide();
                    this.Count = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("count", Kusto.Language.Symbols.ScalarTypes.Long).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("count");
                    this.CountIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("countif", Kusto.Language.Symbols.ScalarTypes.Long, [new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("countif");
                    this.DCount = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("dcount", Kusto.Language.Symbols.ScalarTypes.Long, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("accuracy", Kusto.Language.Symbols.ParameterTypeKind.NotDynamic, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("dcount");
                    this.DCountIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("dcountif", Kusto.Language.Symbols.ScalarTypes.Long, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool), new Kusto.Language.Symbols.Parameter.ctor("accuracy", Kusto.Language.Symbols.ParameterTypeKind.NotDynamic, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("dcountif");
                    this.TDigest = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("tdigest", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable), new Kusto.Language.Symbols.Parameter.ctor("weight", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("tdigest");
                    this.TDigestMerge = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("tdigest_merge", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.$ctor2("tdigest", Kusto.Language.Symbols.ScalarTypes.Dynamic)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("tdigest_merge");
                    this.MergeTDigests = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("merge_tdigests", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.$ctor2("tdigest", Kusto.Language.Symbols.ScalarTypes.Dynamic)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("merge_tdigests");
                    this.Hll = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("hll", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.NotRealOrBool), new Kusto.Language.Symbols.Parameter.ctor("accuracy", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("hll");
                    this.HllMerge = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("hll_merge", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.$ctor2("hll", Kusto.Language.Symbols.ScalarTypes.Dynamic)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("hll_merge");
                    this.Min = new Kusto.Language.Symbols.FunctionSymbol.$ctor4("min", Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Orderable)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("min");
                    this.MinIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor4("minif", Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Orderable), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("minif");
                    this.Max = new Kusto.Language.Symbols.FunctionSymbol.$ctor4("max", Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Orderable)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("max");
                    this.MaxIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor4("maxif", Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Orderable), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("maxif");
                    this.Avg = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("avg", [new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Integer)]), new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.Real)]), new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.Decimal, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.Decimal)]), new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.TimeSpan, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.TimeSpan)]), new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.DateTime, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.DateTime)])]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("avg");
                    this.AvgIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("avgif", [new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Integer), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]), new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.Real), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]), new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.Decimal, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.Decimal), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]), new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.TimeSpan, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.TimeSpan), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]), new Kusto.Language.Symbols.Signature.$ctor7(Kusto.Language.Symbols.ScalarTypes.DateTime, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.DateTime), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)])]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("avgif");
                    this.MakeList_Deprecated = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("makelist", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("list").Obsolete("make_list").Hide();
                    this.MakeList = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("make_list", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("list");
                    this.MakeListIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("make_list_if", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("list");
                    this.MakeListWithNulls = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("make_list_with_nulls", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("list");
                    this.MakeSet_Deprecated = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("makeset", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("set").Obsolete("make_set").Hide();
                    this.MakeSet = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("make_set", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("set");
                    this.MakeSetIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("make_set_if", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("set");
                    this.Passthrough = new Kusto.Language.Symbols.FunctionSymbol.$ctor4("passthrough", Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.FirstArgument).Hide();
                    this.MakeDictionary = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("make_dictionary", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.Dynamic), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("dictionary").Hide();
                    this.MakeBag = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("make_bag", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.Dynamic), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("bag");
                    this.MakeBagIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("make_bag_if", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.Dynamic), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool), new Kusto.Language.Symbols.Parameter.ctor("maxSize", Kusto.Language.Symbols.ParameterTypeKind.Integer, 0, void 0, void 0, false, void 0, 0, 1, void 0, void 0)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("bag");
                    this.BuildSchema = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("buildschema", Kusto.Language.Symbols.ScalarTypes.Dynamic, [new Kusto.Language.Symbols.Parameter.$ctor2("expr", Kusto.Language.Symbols.ScalarTypes.Dynamic)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("schema");
                    this.BinaryAllOr = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("binary_all_or", [new Kusto.Language.Symbols.Signature.$ctor4(Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable)])]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.FirstArgument);
                    this.BinaryAllAnd = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("binary_all_and", [new Kusto.Language.Symbols.Signature.$ctor4(Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable)])]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.FirstArgument);
                    this.BinaryAllXor = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("binary_all_xor", [new Kusto.Language.Symbols.Signature.$ctor4(Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable)])]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.FirstArgument);
                    this.PercentileReturn = function (table, args, signature) {
                        var cols = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();
                        Kusto.Language.Aggregates.AddPercentileColumns(cols, signature, "expr", "percentile", args);
                        return new Kusto.Language.Symbols.TupleSymbol.$ctor1(cols);
                    };
                    this.PercentileArrayReturn = function (table, args, signature) {
                        var cols = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();
                        var valueArg;
                        var valueArgName;
                        if (((valueArg = Kusto.Language.FunctionHelpers.GetArgument(args, signature, "expr"))) != null && ((valueArgName = Kusto.Language.FunctionHelpers.GetExpressionResultName(valueArg))) != null) {
                            cols.add(new Kusto.Language.Symbols.ColumnSymbol("percentiles_" + (valueArgName || ""), Kusto.Language.Symbols.ScalarTypes.Dynamic));
                        }

                        return new Kusto.Language.Symbols.TupleSymbol.$ctor1(cols);
                    };
                    this.Percentile = new Kusto.Language.Symbols.FunctionSymbol.ctor("percentile", Kusto.Language.Aggregates.PercentileReturn, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("percentile", Kusto.Language.Symbols.ParameterTypeKind.Number)]);
                    this.Percentiles = new Kusto.Language.Symbols.FunctionSymbol.ctor("percentiles", Kusto.Language.Aggregates.PercentileReturn, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("percentile", Kusto.Language.Symbols.ParameterTypeKind.Number, 0, void 0, void 0, false, void 0, 1, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)]);
                    this.PercentilesArray = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("percentiles_array", [new Kusto.Language.Symbols.Signature.ctor(Kusto.Language.Aggregates.PercentileArrayReturn, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("percentile", Kusto.Language.Symbols.ParameterTypeKind.Number, 0, void 0, void 0, false, void 0, 1, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)]), new Kusto.Language.Symbols.Signature.ctor(Kusto.Language.Aggregates.PercentileArrayReturn, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.$ctor2("percentiles", Kusto.Language.Symbols.ScalarTypes.Dynamic)])]);
                    this.PercentileW = new Kusto.Language.Symbols.FunctionSymbol.ctor("percentilew", Kusto.Language.Aggregates.PercentileReturn, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("weight", Kusto.Language.Symbols.ParameterTypeKind.Integer), new Kusto.Language.Symbols.Parameter.ctor("percentile", Kusto.Language.Symbols.ParameterTypeKind.Number)]);
                    this.PercentilesW = new Kusto.Language.Symbols.FunctionSymbol.ctor("percentilesw", Kusto.Language.Aggregates.PercentileReturn, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("weight", Kusto.Language.Symbols.ParameterTypeKind.Integer), new Kusto.Language.Symbols.Parameter.ctor("percentile", Kusto.Language.Symbols.ParameterTypeKind.Number, 0, void 0, void 0, false, void 0, 1, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)]);
                    this.PercentilesWArray = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("percentilesw_array", [new Kusto.Language.Symbols.Signature.ctor(Kusto.Language.Aggregates.PercentileArrayReturn, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("weight", Kusto.Language.Symbols.ParameterTypeKind.Integer), new Kusto.Language.Symbols.Parameter.ctor("percentile", Kusto.Language.Symbols.ParameterTypeKind.Number, 0, void 0, void 0, false, void 0, 1, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)]), new Kusto.Language.Symbols.Signature.ctor(Kusto.Language.Aggregates.PercentileArrayReturn, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.ctor("weight", Kusto.Language.Symbols.ParameterTypeKind.Integer), new Kusto.Language.Symbols.Parameter.$ctor2("percentiles", Kusto.Language.Symbols.ScalarTypes.Dynamic)])]);
                    this.Stdev = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("stdev", Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("stdev");
                    this.StdevIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("stdevif", Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("stdevif");
                    this.Stdevp = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("stdevp", Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("stdevp");
                    this.Variance = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("variance", Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("variance");
                    this.VarianceIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("varianceif", Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("varianceif");
                    this.Variancep = new Kusto.Language.Symbols.FunctionSymbol.$ctor7("variancep", Kusto.Language.Symbols.ScalarTypes.Real, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Summable)]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("variancep");
                    this.Any = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("any", [new Kusto.Language.Symbols.Signature.$ctor4(Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar)]), new Kusto.Language.Symbols.Signature.$ctor2(function (table, args) {
                        return Kusto.Language.Aggregates.GetAnyResult(table, args, null);
                    }, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar, 0, void 0, void 0, false, void 0, 2, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)]), new Kusto.Language.Symbols.Signature.$ctor2(function (table, args) {
                        return Kusto.Language.Aggregates.GetAnyResult(table, args, null);
                    }, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar, Kusto.Language.Symbols.ArgumentKind.StarOnly)])]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("any").Obsolete("take_any");
                    this.TakeAny = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("take_any", [new Kusto.Language.Symbols.Signature.$ctor2(function (table, args) {
                        return Kusto.Language.Aggregates.GetAnyResult(table, args, "any_");
                    }, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar, Kusto.Language.Symbols.ArgumentKind.StarAllowed, void 0, void 0, false, void 0, 1, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)])]);
                    this.AnyIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("anyif", [new Kusto.Language.Symbols.Signature.$ctor4(Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)])]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument).WithResultNamePrefix("anyif").Obsolete("take_anyif");
                    this.TakeAnyIf = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("take_anyif", [new Kusto.Language.Symbols.Signature.$ctor4(Kusto.Language.Symbols.ReturnTypeKind.Parameter0, [new Kusto.Language.Symbols.Parameter.ctor("expr", Kusto.Language.Symbols.ParameterTypeKind.Scalar), new Kusto.Language.Symbols.Parameter.$ctor2("predicate", Kusto.Language.Symbols.ScalarTypes.Bool)])]).WithResultNameKind(Kusto.Language.Symbols.ResultNameKind.FirstArgument);
                    this.ArgMin = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("arg_min", [new Kusto.Language.Symbols.Signature.$ctor2(function (table, args) {
                        return Kusto.Language.Aggregates.GetArgMinMaxResult(table, args, "min");
                    }, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("minimized", Kusto.Language.Symbols.ParameterTypeKind.Orderable), new Kusto.Language.Symbols.Parameter.ctor("returned", Kusto.Language.Symbols.ParameterTypeKind.Scalar, Kusto.Language.Symbols.ArgumentKind.StarAllowed, void 0, void 0, false, void 0, 0, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)])]);
                    this.ArgMax = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("arg_max", [new Kusto.Language.Symbols.Signature.$ctor2(function (table, args) {
                        return Kusto.Language.Aggregates.GetArgMinMaxResult(table, args, "max");
                    }, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("maximized", Kusto.Language.Symbols.ParameterTypeKind.Orderable), new Kusto.Language.Symbols.Parameter.ctor("returned", Kusto.Language.Symbols.ParameterTypeKind.Scalar, Kusto.Language.Symbols.ArgumentKind.StarAllowed, void 0, void 0, false, void 0, 0, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)])]);
                    this.ArgMin_Deprecated = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("argmin", [new Kusto.Language.Symbols.Signature.$ctor2(Kusto.Language.Aggregates.GetArgMinMaxDepResult, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("minimized", Kusto.Language.Symbols.ParameterTypeKind.Orderable), new Kusto.Language.Symbols.Parameter.ctor("returned", Kusto.Language.Symbols.ParameterTypeKind.Scalar, Kusto.Language.Symbols.ArgumentKind.StarAllowed, void 0, void 0, false, void 0, 0, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)])]).WithResultNamePrefix("min").Obsolete("arg_min").Hide();
                    this.ArgMax_Deprecated = new Kusto.Language.Symbols.FunctionSymbol.$ctor6("argmax", [new Kusto.Language.Symbols.Signature.$ctor2(Kusto.Language.Aggregates.GetArgMinMaxDepResult, Kusto.Language.Symbols.Tabularity.Scalar, [new Kusto.Language.Symbols.Parameter.ctor("maximized", Kusto.Language.Symbols.ParameterTypeKind.Orderable), new Kusto.Language.Symbols.Parameter.ctor("returned", Kusto.Language.Symbols.ParameterTypeKind.Scalar, Kusto.Language.Symbols.ArgumentKind.StarAllowed, void 0, void 0, false, void 0, 0, Kusto.Language.FunctionHelpers.MaxRepeat, void 0, void 0)])]).WithResultNamePrefix("max").Obsolete("arg_max").Hide();
                    this.All = System.Array.init([Kusto.Language.Aggregates.Sum, Kusto.Language.Aggregates.SumIf, Kusto.Language.Aggregates.Cnt, Kusto.Language.Aggregates.Count, Kusto.Language.Aggregates.CountIf, Kusto.Language.Aggregates.DCount, Kusto.Language.Aggregates.DCountIf, Kusto.Language.Aggregates.TDigest, Kusto.Language.Aggregates.TDigestMerge, Kusto.Language.Aggregates.MergeTDigests, Kusto.Language.Aggregates.Hll, Kusto.Language.Aggregates.HllMerge, Kusto.Language.Aggregates.Min, Kusto.Language.Aggregates.MinIf, Kusto.Language.Aggregates.Max, Kusto.Language.Aggregates.MaxIf, Kusto.Language.Aggregates.Avg, Kusto.Language.Aggregates.AvgIf, Kusto.Language.Aggregates.MakeList_Deprecated, Kusto.Language.Aggregates.MakeList, Kusto.Language.Aggregates.MakeListIf, Kusto.Language.Aggregates.MakeListWithNulls, Kusto.Language.Aggregates.MakeSet_Deprecated, Kusto.Language.Aggregates.MakeSet, Kusto.Language.Aggregates.MakeSetIf, Kusto.Language.Aggregates.MakeDictionary, Kusto.Language.Aggregates.MakeBag, Kusto.Language.Aggregates.MakeBagIf, Kusto.Language.Aggregates.BuildSchema, Kusto.Language.Aggregates.Passthrough, Kusto.Language.Aggregates.Percentile, Kusto.Language.Aggregates.Percentiles, Kusto.Language.Aggregates.PercentilesArray, Kusto.Language.Aggregates.PercentileW, Kusto.Language.Aggregates.PercentilesW, Kusto.Language.Aggregates.PercentilesWArray, Kusto.Language.Aggregates.Stdev, Kusto.Language.Aggregates.StdevIf, Kusto.Language.Aggregates.Stdevp, Kusto.Language.Aggregates.Variance, Kusto.Language.Aggregates.VarianceIf, Kusto.Language.Aggregates.Variancep, Kusto.Language.Aggregates.Any, Kusto.Language.Aggregates.TakeAny, Kusto.Language.Aggregates.AnyIf, Kusto.Language.Aggregates.TakeAnyIf, Kusto.Language.Aggregates.ArgMin, Kusto.Language.Aggregates.ArgMax, Kusto.Language.Aggregates.ArgMin_Deprecated, Kusto.Language.Aggregates.ArgMax_Deprecated, Kusto.Language.Aggregates.BinaryAllOr, Kusto.Language.Aggregates.BinaryAllAnd, Kusto.Language.Aggregates.BinaryAllXor], Kusto.Language.Symbols.FunctionSymbol);
                }
            },
            methods: {
                AddPercentileColumns: function (columns, signature, valueParameterName, percentileParameterName, args) {
                    var valueArg;
                    var valueArgName;
                    if (((valueArg = Kusto.Language.FunctionHelpers.GetArgument(args, signature, valueParameterName))) != null && ((valueArgName = Kusto.Language.FunctionHelpers.GetExpressionResultName(valueArg))) != null) {
                        var percentileParameter = signature.GetParameter(percentileParameterName);
                        var argumentParameters = signature.GetArgumentParameters(args);
                        var start = { };
                        var length = { };
                        Kusto.Language.FunctionHelpers.GetArgumentRange(argumentParameters, percentileParameter, start, length);

                        var resultType = valueArg.ResultType;
                        if (Bridge.referenceEquals(resultType, Kusto.Language.Symbols.ScalarTypes.Int)) {
                            resultType = Kusto.Language.Symbols.ScalarTypes.Long;
                        } else {
                            if (Bridge.referenceEquals(resultType, Kusto.Language.Symbols.ScalarTypes.Decimal)) {
                                resultType = Kusto.Language.Symbols.ScalarTypes.Real;
                            }
                        }

                        for (var p = start.v; p < ((start.v + length.v) | 0); p = (p + 1) | 0) {
                            var percentileArg = System.Array.getItem(args, p, Kusto.Language.Syntax.Expression);
                            var percentileFragment = Kusto.Language.FunctionHelpers.MakeValidNameFragment(Kusto.Language.FunctionHelpers.GetLiteralValue(percentileArg));
                            var name = (percentileParameterName || "") + "_" + (valueArgName || "") + "_" + (percentileFragment || "");

                            columns.add(new Kusto.Language.Symbols.ColumnSymbol(name, resultType));
                        }
                    }
                },
                GetAnyResult: function (table, args, unnamedExpressionPrefix) {
                    var $t, $t1;
                    var columns = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();
                    var prefix = ($t = unnamedExpressionPrefix, $t != null ? $t : "");

                    var doNotRepeat = new (System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.ColumnSymbol)).$ctor1(Kusto.Language.FunctionHelpers.GetSummarizeByColumns(args));
                    var anyStar = System.Linq.Enumerable.from(args, Kusto.Language.Syntax.Expression).any(function (a) {
                            return Bridge.is(a, Kusto.Language.Syntax.StarExpression);
                        });

                    for (var i = 0; i < System.Array.getCount(args, Kusto.Language.Syntax.Expression); i = (i + 1) | 0) {
                        var arg = System.Array.getItem(args, i, Kusto.Language.Syntax.Expression);

                        if (Bridge.is(arg, Kusto.Language.Syntax.StarExpression)) {
                            $t1 = Bridge.getEnumerator(table.Columns, Kusto.Language.Symbols.ColumnSymbol);
                            try {
                                while ($t1.moveNext()) {
                                    var c = $t1.Current;
                                    if (Kusto.Language.Aggregates.CanAddAnyResultColumn(c, doNotRepeat, anyStar)) {
                                        doNotRepeat.add(c);
                                        columns.add(c);
                                    }
                                }
                            } finally {
                                if (Bridge.is($t1, System.IDisposable)) {
                                    $t1.System$IDisposable$Dispose();
                                }
                            }
                        } else {
                            var snx;
                            var vc;
                            if (((snx = Bridge.as(arg, Kusto.Language.Syntax.SimpleNamedExpression))) != null && ((vc = Kusto.Language.Aggregates.GetResultColumn(snx.Expression))) != null) {
                                if (Kusto.Language.Aggregates.CanAddAnyResultColumn(vc, doNotRepeat, anyStar)) {
                                    doNotRepeat.add(vc);
                                    columns.add(new Kusto.Language.Symbols.ColumnSymbol(snx.Name.SimpleName, vc.Type));
                                }
                            } else {
                                var c1;
                                if (((c1 = Kusto.Language.Aggregates.GetResultColumn(arg))) != null) {
                                    // this is explicitly referenced column (not assigned)
                                    if (Kusto.Language.Aggregates.CanAddAnyResultColumn(c1, doNotRepeat, anyStar)) {
                                        doNotRepeat.add(c1);
                                        // change identity of explicitly referenced columns so won't match same columns already in projection list
                                        columns.add(new Kusto.Language.Symbols.ColumnSymbol(c1.Name, c1.Type));
                                    }
                                } else {
                                    var expName = Kusto.Language.Binding.Binder.GetExpressionResultName(arg, "");
                                    if (System.String.isNullOrEmpty(expName)) {
                                        expName = (prefix || "") + "arg" + i;
                                    }

                                    var col = new Kusto.Language.Symbols.ColumnSymbol(expName, arg.ResultType);
                                    columns.add(col);
                                }
                            }
                        }
                    }

                    return new Kusto.Language.Symbols.TupleSymbol.$ctor1(columns);
                },
                CanAddAnyResultColumn: function (column, doNotRepeat, anyStar) {
                    if (!anyStar) {
                        return true;
                    }

                    return !doNotRepeat.contains(column);
                },
                GetArgMinMaxResult: function (table, args, prefix) {
                    var $t;
                    var columns = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();

                    if (System.Array.getCount(args, Kusto.Language.Syntax.Expression) > 0) {
                        var byClauseColumns = new (System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.ColumnSymbol)).$ctor1(Kusto.Language.FunctionHelpers.GetSummarizeByColumns(args));
                        var doNotRepeat = new (System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();

                        var primaryArg = System.Array.getItem(args, 0, Kusto.Language.Syntax.Expression);
                        var primaryColName = Kusto.Language.Binding.Binder.GetExpressionResultName(primaryArg);

                        var anyStar = System.Linq.Enumerable.from(args, Kusto.Language.Syntax.Expression).any(function (a) {
                                return Bridge.is(a, Kusto.Language.Syntax.StarExpression);
                            });

                        for (var i = 0; i < System.Array.getCount(args, Kusto.Language.Syntax.Expression); i = (i + 1) | 0) {
                            var arg = System.Array.getItem(args, i, Kusto.Language.Syntax.Expression);

                            if (Bridge.is(arg, Kusto.Language.Syntax.StarExpression)) {
                                $t = Bridge.getEnumerator(table.Columns, Kusto.Language.Symbols.ColumnSymbol);
                                try {
                                    while ($t.moveNext()) {
                                        var c = $t.Current;
                                        if (Kusto.Language.Aggregates.CanAddArgMinMaxResultColumn(i, c, byClauseColumns, doNotRepeat, anyStar)) {
                                            doNotRepeat.add(c);
                                            columns.add(c);
                                        }
                                    }
                                } finally {
                                    if (Bridge.is($t, System.IDisposable)) {
                                        $t.System$IDisposable$Dispose();
                                    }
                                }
                            } else {
                                var snx;
                                var vc;
                                if (((snx = Bridge.as(arg, Kusto.Language.Syntax.SimpleNamedExpression))) != null && ((vc = Kusto.Language.Aggregates.GetResultColumn(snx.Expression))) != null) {
                                    if (Kusto.Language.Aggregates.CanAddArgMinMaxResultColumn(i, vc, byClauseColumns, doNotRepeat, anyStar)) {
                                        doNotRepeat.add(vc);
                                        columns.add(new Kusto.Language.Symbols.ColumnSymbol(snx.Name.SimpleName, vc.Type));
                                    }
                                } else {
                                    var c1;
                                    if (((c1 = Kusto.Language.Aggregates.GetResultColumn(arg))) != null) {
                                        // this is explicitly referenced column (not assigned)
                                        if (Kusto.Language.Aggregates.CanAddArgMinMaxResultColumn(i, c1, byClauseColumns, doNotRepeat, anyStar)) {
                                            doNotRepeat.add(c1);
                                            // change identity of explicitly referenced columns so won't match same columns already in projection list
                                            columns.add(new Kusto.Language.Symbols.ColumnSymbol(c1.Name, c1.Type));
                                        }
                                    } else {
                                        var expName = Kusto.Language.Binding.Binder.GetExpressionResultName(arg, null);
                                        if (expName == null) {
                                            if (i === 0) {
                                                expName = (prefix || "") + "_";
                                            } else {
                                                expName = (prefix || "") + "_" + (primaryColName || "") + "_arg" + i;
                                            }
                                        }

                                        var col = new Kusto.Language.Symbols.ColumnSymbol(expName, arg.ResultType);
                                        columns.add(col);
                                    }
                                }
                            }
                        }
                    }

                    return new Kusto.Language.Symbols.TupleSymbol.$ctor1(columns);
                },
                CanAddArgMinMaxResultColumn: function (argIndex, column, byClauseColumns, doNotRepeat, anyStar) {
                    if (argIndex === 0) {
                        return true;
                    }

                    if (!anyStar) {
                        return true;
                    }

                    return !doNotRepeat.contains(column) && !byClauseColumns.contains(column);
                },
                GetResultColumn: function (expr) {
                    return Kusto.Language.Binding.Binder.GetResultColumn(expr);
                },
                GetArgMinMaxDepResult: function (table, args) {
                    var $t;
                    var columns = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();

                    if (System.Array.getCount(args, Kusto.Language.Syntax.Expression) > 0) {
                        // determine columns in by expression
                        var byClauseColumns = new (System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.ColumnSymbol)).$ctor1(Kusto.Language.FunctionHelpers.GetSummarizeByColumns(args));
                        var doNotRepeat = new (System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();
                        var anyStar = System.Linq.Enumerable.from(args, Kusto.Language.Syntax.Expression).any(function (a) {
                                return Bridge.is(a, Kusto.Language.Syntax.StarExpression);
                            });

                        var primaryArg = System.Array.getItem(args, 0, Kusto.Language.Syntax.Expression);
                        var primaryColName;
                        var pc;
                        if (((pc = Kusto.Language.Aggregates.GetResultColumn(primaryArg))) != null) {
                            doNotRepeat.add(pc);
                            columns.add(pc);
                            primaryColName = pc.Name;
                        } else {
                            primaryColName = Kusto.Language.Binding.Binder.GetExpressionResultName(primaryArg);
                            var primaryCol = new Kusto.Language.Symbols.ColumnSymbol(primaryColName, primaryArg.ResultType);
                            columns.add(primaryCol);
                        }

                        for (var i = 1; i < System.Array.getCount(args, Kusto.Language.Syntax.Expression); i = (i + 1) | 0) {
                            var arg = System.Array.getItem(args, i, Kusto.Language.Syntax.Expression);

                            if (Bridge.is(arg, Kusto.Language.Syntax.StarExpression)) {
                                $t = Bridge.getEnumerator(table.Columns, Kusto.Language.Symbols.ColumnSymbol);
                                try {
                                    while ($t.moveNext()) {
                                        var c = $t.Current;
                                        if (!Bridge.referenceEquals(c, primaryArg.ReferencedSymbol) && Kusto.Language.Aggregates.CanAddArgMinMaxResultColumn(i, c, byClauseColumns, doNotRepeat, anyStar)) {
                                            doNotRepeat.add(c);
                                            columns.add(c.WithName((primaryColName || "") + "_" + (c.Name || "")));
                                        }
                                    }
                                } finally {
                                    if (Bridge.is($t, System.IDisposable)) {
                                        $t.System$IDisposable$Dispose();
                                    }
                                }
                            } else {
                                var snx;
                                var vc;
                                if (((snx = Bridge.as(arg, Kusto.Language.Syntax.SimpleNamedExpression))) != null && ((vc = Kusto.Language.Aggregates.GetResultColumn(snx.Expression))) != null) {
                                    if (Kusto.Language.Aggregates.CanAddArgMinMaxResultColumn(i, vc, byClauseColumns, doNotRepeat, anyStar)) {
                                        doNotRepeat.add(vc);
                                        columns.add(new Kusto.Language.Symbols.ColumnSymbol((primaryColName || "") + "_" + (snx.Name.SimpleName || ""), vc.Type));
                                    }
                                } else {
                                    var c1;
                                    if (((c1 = Kusto.Language.Aggregates.GetResultColumn(arg))) != null) {
                                        if (Kusto.Language.Aggregates.CanAddArgMinMaxResultColumn(i, c1, byClauseColumns, doNotRepeat, anyStar)) {
                                            doNotRepeat.add(c1);
                                            columns.add(c1.WithName((primaryColName || "") + "_" + (c1.Name || "")));
                                        }
                                    } else {
                                        var expName = Kusto.Language.Binding.Binder.GetExpressionResultName(arg, null);
                                        if (expName == null) {
                                            expName = "arg" + i;
                                        }
                                        var col = new Kusto.Language.Symbols.ColumnSymbol((primaryColName || "") + "_" + (expName || ""), arg.ResultType);
                                        columns.add(col);
                                    }
                                }
                            }
                        }
                    }

                    return new Kusto.Language.Symbols.TupleSymbol.$ctor1(columns);
                }
            }
        }
    });

    Bridge.define("Kusto.Language.AriaBridgeCommands", {
        statics: {
            fields: {
                ShowVersion: null,
                All: null
            },
            ctors: {
                init: function () {
                    this.ShowVersion = new Kusto.Language.Symbols.CommandSymbol("ShowVersion", "(BuildVersion: string, BuildTime: datetime, ServiceType: string, ProductVersion: string)");
                    this.All = System.Array.init([Kusto.Language.AriaBridgeCommands.ShowVersion], Kusto.Language.Symbols.CommandSymbol);
                }
            }
        }
    });

    /** @namespace System */

    /**
     * @memberof System
     * @callback System.Action
     * @param   {Kusto.Language.Syntax.SyntaxNode}       arg1    
     * @param   {Kusto.Language.Binding.SemanticInfo}    arg2
     * @return  {void}
     */

    /** @namespace Kusto.Language.Binding */

    /**
     * The binder performs general semantic analysis of the syntax tree, 
     identifying the symbols corresponding to named references, 
     the return types of operations and generating error diagnostics.
     *
     * @class Kusto.Language.Binding.Binder
     */
    Bridge.define("Kusto.Language.Binding.Binder", {
        statics: {
            fields: {
                s_symbolListPool: null,
                s_symbolHashSetPool: null,
                s_diagnosticListPool: null,
                s_columnListPool: null,
                s_tableListPool: null,
                s_functionListPool: null,
                s_signatureListPool: null,
                s_patternListPool: null,
                s_expressionListPool: null,
                s_typeListPool: null,
                s_stringSetPool: null,
                s_uniqueNameTablePool: null,
                s_projectionBuilderPool: null,
                s_parameterListPool: null,
                LiteralBoolInfo: null,
                LiteralIntInfo: null,
                LiteralLongInfo: null,
                LiteralRealInfo: null,
                LiteralDecimalInfo: null,
                LiteralStringInfo: null,
                LiteralDateTimeInfo: null,
                LiteralTimeSpanInfo: null,
                LiteralGuidInfo: null,
                LiteralDynamicInfo: null,
                UnknownInfo: null,
                ErrorInfo: null,
                VoidInfo: null
            },
            ctors: {
                init: function () {
                    this.s_symbolListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.Symbol)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.Symbol)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_symbolHashSetPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.Symbol)))(function () {
                        return new (System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.Symbol)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_diagnosticListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Diagnostic)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Diagnostic)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_columnListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_tableListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.TableSymbol)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.TableSymbol)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_functionListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.FunctionSymbol)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.FunctionSymbol)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_signatureListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.Signature)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.Signature)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_patternListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.PatternSignature)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.PatternSignature)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_expressionListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Syntax.Expression)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Syntax.Expression)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_typeListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.TypeSymbol)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.TypeSymbol)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_stringSetPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.HashSet$1(System.String)))(function () {
                        return new (System.Collections.Generic.HashSet$1(System.String)).ctor();
                    }, function (s) {
                        s.clear();
                    });
                    this.s_uniqueNameTablePool = new (Kusto.Language.Utils.ObjectPool$1(Kusto.Language.Utils.UniqueNameTable))(function () {
                        return new Kusto.Language.Utils.UniqueNameTable();
                    }, function (t) {
                        t.Clear();
                    });
                    this.s_projectionBuilderPool = new (Kusto.Language.Utils.ObjectPool$1(Kusto.Language.Binding.ProjectionBuilder))(function () {
                        return new Kusto.Language.Binding.ProjectionBuilder();
                    }, function (b) {
                        b.Clear();
                    });
                    this.s_parameterListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.Parameter)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.Parameter)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.LiteralBoolInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.Bool, void 0, true, void 0);
                    this.LiteralIntInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.Int, void 0, true, void 0);
                    this.LiteralLongInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.Long, void 0, true, void 0);
                    this.LiteralRealInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.Real, void 0, true, void 0);
                    this.LiteralDecimalInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.Decimal, void 0, true, void 0);
                    this.LiteralStringInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.String, void 0, true, void 0);
                    this.LiteralDateTimeInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.DateTime, void 0, true, void 0);
                    this.LiteralTimeSpanInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.TimeSpan, void 0, true, void 0);
                    this.LiteralGuidInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.Guid, void 0, true, void 0);
                    this.LiteralDynamicInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.Dynamic, void 0, true, void 0);
                    this.UnknownInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ScalarTypes.Unknown, void 0, true, void 0);
                    this.ErrorInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ErrorSymbol.Instance);
                    this.VoidInfo = new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.VoidSymbol.Instance);
                }
            },
            methods: {
                /**
                 * Do semantic analysis over the syntax tree.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.SyntaxTree}            tree                  
                 * @param   {Kusto.Language.GlobalState}                  globals               
                 * @param   {Kusto.Language.Binding.LocalBindingCache}    localBindingCache     
                 * @param   {System.Action}                               semanticInfoSetter    
                 * @param   {Kusto.Language.Utils.CancellationToken}      cancellationToken
                 * @return  {boolean}
                 */
                TryBind: function (tree, globals, localBindingCache, semanticInfoSetter, cancellationToken) {
                    if (localBindingCache === void 0) { localBindingCache = null; }
                    if (semanticInfoSetter === void 0) { semanticInfoSetter = null; }
                    if (cancellationToken === void 0) { cancellationToken = new Kusto.Language.Utils.CancellationToken(); }
                    if (!tree.IsSafeToRecurse) {
                        return false;
                    }

                    globals = globals.WithCache();
                    var bindingCache = globals.Cache.GetOrCreate(Kusto.Language.Binding.GlobalBindingCache);
                    bindingCache;
                    {
                        var binder = new Kusto.Language.Binding.Binder(globals, globals.Cluster, globals.Database, null, Kusto.Language.Binding.Binder.GetDefaultOuterScope(globals), bindingCache, localBindingCache, semanticInfoSetter, cancellationToken);

                        var treeBinder = new Kusto.Language.Binding.Binder.TreeBinder(binder);

                        tree.Root.Accept$1(treeBinder);
                        return true;
                    }
                },
                GetDefaultOuterScope: function (globals) {
                    var outerScope = null;

                    if (System.Array.getCount(globals.Parameters, Kusto.Language.Symbols.ParameterSymbol) > 0) {
                        outerScope = new Kusto.Language.Binding.LocalScope.ctor();
                        outerScope.AddSymbols(globals.Parameters);
                    }

                    return outerScope;
                },
                DefaultSetSemanticInfo: function (node, info) {
                    if (info != null) {
                        var data = node.GetExtendedData(true);
                        data.SemanticInfo = info;
                    }
                },
                /**
                 * Do semantic analysis over the body of a called function.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.SyntaxTree}            bodyTree           
                 * @param   {Kusto.Language.Binding.Binder}               outer              
                 * @param   {Kusto.Language.Symbols.ClusterSymbol}        currentCluster     
                 * @param   {Kusto.Language.Symbols.DatabaseSymbol}       currentDatabase    
                 * @param   {Kusto.Language.Symbols.FunctionSymbol}       currentFunction    
                 * @param   {Kusto.Language.Binding.LocalScope}           outerScope         
                 * @param   {System.Collections.Generic.IEnumerable$1}    locals
                 * @return  {boolean}
                 */
                TryBindCalledFunctionBody: function (bodyTree, outer, currentCluster, currentDatabase, currentFunction, outerScope, locals) {
                    if (!bodyTree.IsSafeToRecurse) {
                        return false;
                    }

                    var binder = new Kusto.Language.Binding.Binder(outer._globals, currentCluster || outer._currentCluster, currentDatabase || outer._currentDatabase, currentFunction, outerScope, outer._globalBindingCache, outer._localBindingCache, outer._semanticInfoSetter, outer._cancellationToken);

                    if (locals != null) {
                        binder.SetLocals(locals);
                    }

                    var treeBinder = new Kusto.Language.Binding.Binder.TreeBinder(binder);
                    bodyTree.Root.Accept$1(treeBinder);

                    return true;
                },
                /**
                 * Entry point for {@link } to access the cache.
                 This is used for testing.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.FunctionSymbol}    symbol     
                 * @param   {Kusto.Language.GlobalState}               globals    
                 * @param   {Kusto.Language.FunctionBodyFacts}         facts
                 * @return  {boolean}
                 */
                TryGetDatabaseFunctionBodyFacts: function (symbol, globals, facts) {
                    if (globals.Cache != null) {
                        var bindingCache = globals.Cache.GetOrCreate(Kusto.Language.Binding.GlobalBindingCache);
                        bindingCache;
                        {
                            return bindingCache.DatabaseFunctionBodyFacts.tryGetValue(System.Array.getItem(symbol.Signatures, 0, Kusto.Language.Symbols.Signature), facts);
                        }
                    }

                    facts.v = null;
                    return false;
                },
                /**
                 * Gets the computed return type for functions specified with a body or declaration.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.Signature}              signature        
                 * @param   {Kusto.Language.GlobalState}                    globals          
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
                 * @return  {Kusto.Language.Symbols.TypeSymbol}
                 */
                GetComputedReturnType: function (signature, globals, argumentTypes) {
                    if (argumentTypes === void 0) { argumentTypes = null; }
                    globals = globals.WithCache();

                    var currentDatabase = globals.GetDatabase$1(signature.Symbol);
                    var currentCluster = globals.GetCluster(currentDatabase);

                    var bindingCache = globals.Cache.GetOrCreate(Kusto.Language.Binding.GlobalBindingCache);
                    bindingCache;
                    {
                        var binder = new Kusto.Language.Binding.Binder(globals, currentCluster, currentDatabase, Bridge.as(signature.Symbol, Kusto.Language.Symbols.FunctionSymbol), Kusto.Language.Binding.Binder.GetDefaultOuterScope(globals), bindingCache, null, null, Bridge.getDefaultValue(Kusto.Language.Utils.CancellationToken));

                        return binder.GetComputedFunctionCallResult(signature, null, argumentTypes).Type;
                    }
                },
                /**
                 * Gets the symbol that would be referenced at the specified location.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.SyntaxTree}          tree                 
                 * @param   {number}                                    position             
                 * @param   {string}                                    name                 
                 * @param   {Kusto.Language.GlobalState}                globals              
                 * @param   {Kusto.Language.Symbols.SymbolMatch}        match                
                 * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
                 * @return  {Kusto.Language.Symbols.Symbol}
                 */
                GetReferencedSymbol: function (tree, position, name, globals, match, cancellationToken) {
                    if (tree.IsSafeToRecurse) {
                        globals = globals.WithCache();
                        var bindingCache = globals.Cache.GetOrCreate(Kusto.Language.Binding.GlobalBindingCache);
                        bindingCache;
                        {
                            var binder = new Kusto.Language.Binding.Binder(globals, globals.Cluster, globals.Database, null, Kusto.Language.Binding.Binder.GetDefaultOuterScope(globals), bindingCache, null, null, cancellationToken);
                            var startNode = Kusto.Language.Binding.Binder.GetStartNode(tree.Root, position);
                            if (startNode != null) {
                                binder.SetContext(startNode, position);
                                var info = binder.BindName(name, match, startNode);
                                return info != null ? info.ReferencedSymbol : null;
                            }
                        }
                    }

                    return null;
                },
                /**
                 * Gets the {@link } that is in scope as the implicit set of columns accessible within a query.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.SyntaxTree}          tree                 
                 * @param   {number}                                    position             
                 * @param   {Kusto.Language.GlobalState}                globals              
                 * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
                 * @return  {Kusto.Language.Symbols.TableSymbol}
                 */
                GetRowScope: function (tree, position, globals, cancellationToken) {
                    if (cancellationToken === void 0) { cancellationToken = new Kusto.Language.Utils.CancellationToken(); }
                    if (tree.IsSafeToRecurse) {
                        globals = globals.WithCache();
                        var bindingCache = globals.Cache.GetOrCreate(Kusto.Language.Binding.GlobalBindingCache);
                        bindingCache;
                        {
                            var binder = new Kusto.Language.Binding.Binder(globals, globals.Cluster, globals.Database, null, Kusto.Language.Binding.Binder.GetDefaultOuterScope(globals), bindingCache, null, null, cancellationToken);
                            var startNode = Kusto.Language.Binding.Binder.GetStartNode(tree.Root, position);
                            if (startNode != null) {
                                binder.SetContext(startNode, position);
                                return binder._rowScope;
                            }
                        }
                    }

                    return Kusto.Language.Symbols.TableSymbol.Empty;
                },
                /**
                 * Gets all the symbols that are in scope at the text position.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.SyntaxTree}          tree                 
                 * @param   {number}                                    position             
                 * @param   {Kusto.Language.GlobalState}                globals              
                 * @param   {Kusto.Language.Symbols.SymbolMatch}        match                
                 * @param   {Kusto.Language.IncludeFunctionKind}        include              
                 * @param   {System.Collections.Generic.List$1}         list                 
                 * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
                 * @return  {void}
                 */
                GetSymbolsInScope: function (tree, position, globals, match, include, list, cancellationToken) {
                    if (tree.IsSafeToRecurse) {
                        globals = globals.WithCache();
                        var bindingCache = globals.Cache.GetOrCreate(Kusto.Language.Binding.GlobalBindingCache);
                        bindingCache;
                        {
                            var binder = new Kusto.Language.Binding.Binder(globals, globals.Cluster, globals.Database, null, Kusto.Language.Binding.Binder.GetDefaultOuterScope(globals), bindingCache, null, null, cancellationToken);
                            var startNode = Kusto.Language.Binding.Binder.GetStartNode(tree.Root, position);
                            if (startNode != null) {
                                binder.SetContext(startNode, position);
                                binder.GetSymbolsInContext(startNode, match, include, list);
                            }
                        }
                    }
                },
                GetStartNode: function (root, position) {
                    var token = root.GetTokenAt(position);

                    if (token != null) {
                        if (position <= token.TextStart) {
                            var prev = token.GetPreviousToken();
                            if (prev != null && prev.Depth >= token.Depth) {
                                return prev.Parent;
                            }
                        }

                        return token.Parent;
                    }

                    return null;
                },
                GetPathMembers: function (target, memberMatch, result) {
                    var $t;
                    var g;
                    if (((g = Bridge.as(target, Kusto.Language.Symbols.GroupSymbol))) != null && Kusto.Language.Binding.Binder.IsPassThrough(g)) {
                        $t = Bridge.getEnumerator(g.Members, Kusto.Language.Symbols.Symbol);
                        try {
                            while ($t.moveNext()) {
                                var s = $t.Current;
                                Kusto.Language.Binding.Binder.GetPathMembers(s, memberMatch, result);
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    } else {
                        target.GetMembers(memberMatch, result);
                    }
                },
                GetPathMembers$1: function (target, name, memberMatch, result) {
                    var $t;
                    var g;
                    if (((g = Bridge.as(target, Kusto.Language.Symbols.GroupSymbol))) != null && Kusto.Language.Binding.Binder.IsPassThrough(g)) {
                        $t = Bridge.getEnumerator(g.Members, Kusto.Language.Symbols.Symbol);
                        try {
                            while ($t.moveNext()) {
                                var s = $t.Current;
                                Kusto.Language.Binding.Binder.GetPathMembers$1(s, name, memberMatch, result);
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    } else {
                        target.GetMembers$1(name, memberMatch, result);
                    }
                },
                IsInvokeOperatorFunctionCall: function (functionCall) {
                    var p;
                    return Bridge.is(functionCall.Parent, Kusto.Language.Syntax.InvokeOperator) || (((p = Bridge.as(functionCall.Parent, Kusto.Language.Syntax.PathExpression))) != null && Bridge.referenceEquals(p.Selector, functionCall) && Bridge.is(p.Parent, Kusto.Language.Syntax.InvokeOperator));
                },
                TryGetLiteralStringValue: function (expression, value) {
                    var objValue = { };
                    if (Kusto.Language.Binding.Binder.TryGetLiteralValue(expression, objValue)) {
                        value.v = Bridge.as(objValue.v, System.String);
                        return value.v != null;
                    } else {
                        value.v = null;
                        return false;
                    }
                },
                /**
                 * Gets the value of the literal if the expression is a literal or refers to literal
                 *
                 * @static
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.Expression}    expression    
                 * @param   {System.Object}                       value
                 * @return  {boolean}
                 */
                TryGetLiteralValue: function (expression, value) {
                    expression = Kusto.Language.Binding.Binder.GetUnderlyingExpression(expression);

                    if (expression.IsLiteral) {
                        value.v = expression.LiteralValue;
                        return value.v != null;
                    } else {
                        var nr;
                        var vs;
                        if (((nr = Bridge.as(expression, Kusto.Language.Syntax.NameReference))) != null && ((vs = Bridge.as(nr.ReferencedSymbol, Kusto.Language.Symbols.VariableSymbol))) != null && vs.IsConstant) {
                            value.v = vs.ConstantValue;
                            return true;
                        } else {
                            value.v = null;
                            return false;
                        }
                    }
                },
                /**
                 * Determines if the name is a pattern (contains a *)
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {string}     name
                 * @return  {boolean}
                 */
                IsPattern: function (name) {
                    return System.String.contains(name,"*");
                },
                /**
                 * Gets the matching databases in the specified cluster
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {string}                                  nameOrPattern    
                 * @param   {Kusto.Language.Symbols.ClusterSymbol}    cluster          
                 * @param   {System.Collections.Generic.List$1}       matches
                 * @return  {void}
                 */
                GetMatchingDatabases: function (nameOrPattern, cluster, matches) {
                    var $t;
                    $t = Bridge.getEnumerator(cluster.Databases, Kusto.Language.Symbols.DatabaseSymbol);
                    try {
                        while ($t.moveNext()) {
                            var cdb = $t.Current;
                            if (Kusto.Language.KustoFacts.Matches(nameOrPattern, cdb.Name, true)) {
                                matches.add(cdb);
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                },
                /**
                 * Determines if {@link } can be promoted to {@link }
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.TypeSymbol}    type1    
                 * @param   {Kusto.Language.Symbols.TypeSymbol}    type2
                 * @return  {boolean}
                 */
                IsPromotable: function (type1, type2) {
                    var type1Scalar;
                    var type2Scalar;
                    return ((type1Scalar = Bridge.as(type1, Kusto.Language.Symbols.ScalarSymbol))) != null && ((type2Scalar = Bridge.as(type2, Kusto.Language.Symbols.ScalarSymbol))) != null && type2Scalar.IsWiderThan(type1Scalar);
                },
                /**
                 * Promotes int to long
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.TypeSymbol}    symbol
                 * @return  {Kusto.Language.Symbols.TypeSymbol}
                 */
                Promote: function (symbol) {
                    if (Bridge.referenceEquals(symbol, Kusto.Language.Symbols.ScalarTypes.Int)) {
                        return Kusto.Language.Symbols.ScalarTypes.Long;
                    } else {
                        return symbol;
                    }
                },
                /**
                 * Gets the widest numeric type of the argument types.
                 The widest type is the one that can contain the values of all the other types:
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.Signature}              signature        
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
                 * @return  {Kusto.Language.Symbols.TypeSymbol}
                 */
                GetWidestArgumentType: function (signature, argumentTypes) {
                    var widestType = null;

                    for (var i = 0; i < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol); i = (i + 1) | 0) {
                        var argType = System.Array.getItem(argumentTypes, i, Kusto.Language.Symbols.TypeSymbol);
                        var s;
                        if (((s = Bridge.as(argType, Kusto.Language.Symbols.ScalarSymbol))) != null && s.IsNumeric && !Bridge.referenceEquals(s, widestType)) {
                            if (widestType == null || s.IsWiderThan(widestType)) {
                                widestType = s;
                            }
                        }
                    }

                    return widestType;
                },
                /**
                 * Gets the common argument type for arguments corresponding to parameters constrained to specific {@link }.CommonXXX values.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentParameters    
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
                 * @return  {Kusto.Language.Symbols.TypeSymbol}
                 */
                GetCommonArgumentType: function (argumentParameters, argumentTypes) {
                    var commonType = null;
                    var hadUnknown = false;

                    for (var i = 0; i < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol); i = (i + 1) | 0) {
                        var parameter = System.Array.getItem(argumentParameters, i, Kusto.Language.Symbols.Parameter);
                        if (parameter != null) {
                            var argType = System.Array.getItem(argumentTypes, i, Kusto.Language.Symbols.TypeSymbol);

                            if ((parameter.TypeKind === Kusto.Language.Symbols.ParameterTypeKind.CommonScalar && argType.IsScalar) || (parameter.TypeKind === Kusto.Language.Symbols.ParameterTypeKind.CommonScalarOrDynamic && argType.IsScalar) || (parameter.TypeKind === Kusto.Language.Symbols.ParameterTypeKind.CommonNumber && Kusto.Language.Binding.Binder.IsNumber(argType)) || (parameter.TypeKind === Kusto.Language.Symbols.ParameterTypeKind.CommonSummable && Kusto.Language.Binding.Binder.IsSummable(argType)) || (parameter.TypeKind === Kusto.Language.Symbols.ParameterTypeKind.CommonOrderable && Kusto.Language.Binding.Binder.IsOrderable(argType))) {
                                if (commonType == null) {
                                    if (Bridge.referenceEquals(argType, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                                        hadUnknown = true;
                                    } else {
                                        commonType = argType;
                                    }
                                } else if (Kusto.Language.Binding.Binder.IsPromotable(commonType, argType)) {
                                    // a type that can be promoted to is better
                                    commonType = argType;
                                } else if (Bridge.referenceEquals(commonType, Kusto.Language.Symbols.ScalarTypes.Dynamic)) {
                                    // non-dynamic scalars are better
                                    commonType = argType;
                                }
                            }
                        }
                    }

                    if (commonType == null && hadUnknown) {
                        return Kusto.Language.Symbols.ScalarTypes.Unknown;
                    }

                    return commonType;
                },
                /**
                 * Gets the common scalar type amongst a set of types.
                 This is either the one type if they are all them same type, the most promoted of the types, or the common type of the types that are not dynamic.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Array.<Kusto.Language.Symbols.TypeSymbol>}    types
                 * @return  {Kusto.Language.Symbols.TypeSymbol}
                 */
                GetCommonScalarType: function (types) {
                    if (types === void 0) { types = []; }
                    var commonType = null;
                    var hadUnknown = false;

                    for (var i = 0; i < types.length; i = (i + 1) | 0) {
                        var type = types[System.Array.index(i, types)];

                        if (type.IsScalar) {
                            // TODO: should there be a general betterness between types instead of these specific rules?
                            if (commonType == null) {
                                if (Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                                    hadUnknown = true;
                                } else {
                                    commonType = type;
                                }
                            } else if (Kusto.Language.Binding.Binder.IsPromotable(commonType, type)) {
                                // a type that can be promoted to is better
                                commonType = type;
                            } else if (Kusto.Language.Binding.Binder.SymbolsAssignable(commonType, Kusto.Language.Symbols.ScalarTypes.Dynamic)) {
                                // non-dynamic scalars are better
                                commonType = type;
                            }
                        }
                    }

                    if (commonType == null && hadUnknown) {
                        return Kusto.Language.Symbols.ScalarTypes.Unknown;
                    }

                    return commonType;
                },
                IsDefaultValueIndicator: function (parameter, argument) {
                    var lit;
                    var value;
                    return parameter.DefaultValueIndicator != null && Bridge.referenceEquals(argument.ResultType, Kusto.Language.Symbols.ScalarTypes.String) && ((lit = Bridge.as(argument, Kusto.Language.Syntax.LiteralExpression))) != null && ((value = Bridge.as(lit.LiteralValue, System.String))) != null && Bridge.referenceEquals(value, parameter.DefaultValueIndicator);
                },
                /**
                 * Determines the kind of match that the argument has with its corresponding signature parameter.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.Signature}              signature                      
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentParameters             
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes                  
                 * @param   {Kusto.Language.Symbols.Parameter}              parameter                      
                 * @param   {Kusto.Language.Syntax.Expression}              argument                       
                 * @param   {Kusto.Language.Symbols.TypeSymbol}             argumentType                   
                 * @param   {boolean}                                       allowLooseParameterMatching
                 * @return  {Kusto.Language.Binding.ParameterMatchKind}
                 */
                GetParameterMatchKind: function (signature, argumentParameters, argumentTypes, parameter, argument, argumentType, allowLooseParameterMatching) {
                    if (parameter == null) {
                        return Kusto.Language.Binding.ParameterMatchKind.None;
                    }

                    if (Bridge.referenceEquals(argumentType, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                        return Kusto.Language.Binding.ParameterMatchKind.Unknown;
                    }

                    if (Kusto.Language.Binding.Binder.IsDefaultValueIndicator(parameter, argument)) {
                        return Kusto.Language.Binding.ParameterMatchKind.Exact;
                    }

                    if (Bridge.is(argument, Kusto.Language.Syntax.StarExpression)) {
                        return (parameter.ArgumentKind === Kusto.Language.Symbols.ArgumentKind.StarOnly || parameter.ArgumentKind === Kusto.Language.Symbols.ArgumentKind.StarAllowed) ? Kusto.Language.Binding.ParameterMatchKind.Exact : Kusto.Language.Binding.ParameterMatchKind.None;
                    } else if (parameter.ArgumentKind === Kusto.Language.Symbols.ArgumentKind.StarOnly) {
                        return Kusto.Language.Binding.ParameterMatchKind.None;
                    }

                    switch (parameter.TypeKind) {
                        case Kusto.Language.Symbols.ParameterTypeKind.Declared: 
                            if (Kusto.Language.Binding.Binder.SymbolsAssignable$1(parameter.DeclaredTypes, argumentType, Kusto.Language.Binding.Conversion.None)) {
                                if (System.Array.getCount(parameter.DeclaredTypes, Kusto.Language.Symbols.TypeSymbol) === 1) {
                                    return Kusto.Language.Binding.ParameterMatchKind.Exact;
                                } else {
                                    return Kusto.Language.Binding.ParameterMatchKind.OneOfTwo;
                                }
                            } else if (Kusto.Language.Binding.Binder.SymbolsAssignable$1(parameter.DeclaredTypes, argumentType, Kusto.Language.Binding.Conversion.Promotable)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Promoted;
                            } else if (allowLooseParameterMatching && Kusto.Language.Binding.Binder.SymbolsAssignable$1(parameter.DeclaredTypes, argumentType, Kusto.Language.Binding.Conversion.Compatible)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Compatible;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Scalar: 
                            if (argumentType.IsScalar) {
                                return Kusto.Language.Binding.ParameterMatchKind.Scalar;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Integer: 
                            if (Kusto.Language.Binding.Binder.IsInteger(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.OneOfTwo;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.RealOrDecimal: 
                            if (Kusto.Language.Binding.Binder.IsRealOrDecimal(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.OneOfTwo;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.StringOrDynamic: 
                            if (Kusto.Language.Binding.Binder.IsStringOrDynamic(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.OneOfTwo;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.IntegerOrDynamic: 
                            if (Kusto.Language.Binding.Binder.IsIntegerOrDynamic(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.OneOfTwo;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Number: 
                            if (Kusto.Language.Binding.Binder.IsNumber(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Number;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.NumberOrBool: 
                            if (Kusto.Language.Binding.Binder.IsNumber(argumentType) || Bridge.referenceEquals(argumentType, Kusto.Language.Symbols.ScalarTypes.Bool)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Number;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Summable: 
                            if (Kusto.Language.Binding.Binder.IsSummable(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Summable;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Orderable: 
                            if (Kusto.Language.Binding.Binder.IsOrderable(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Orderable;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Tabular: 
                            if (Kusto.Language.Binding.Binder.IsTabular(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Tabular;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Database: 
                            if (Kusto.Language.Binding.Binder.IsDatabase(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Database;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Cluster: 
                            if (Kusto.Language.Binding.Binder.IsCluster(argumentType)) {
                                return Kusto.Language.Binding.ParameterMatchKind.Cluster;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.NotBool: 
                            if (!Kusto.Language.Binding.Binder.SymbolsAssignable(argumentType, Kusto.Language.Symbols.ScalarTypes.Bool)) {
                                return Kusto.Language.Binding.ParameterMatchKind.NotType;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.NotRealOrBool: 
                            if (!Kusto.Language.Binding.Binder.SymbolsAssignable(argumentType, Kusto.Language.Symbols.ScalarTypes.Real) && !Kusto.Language.Binding.Binder.SymbolsAssignable(argumentType, Kusto.Language.Symbols.ScalarTypes.Bool)) {
                                return Kusto.Language.Binding.ParameterMatchKind.NotType;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.NotDynamic: 
                            if (!Kusto.Language.Binding.Binder.SymbolsAssignable(argumentType, Kusto.Language.Symbols.ScalarTypes.Dynamic)) {
                                return Kusto.Language.Binding.ParameterMatchKind.NotType;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Parameter0: 
                            return Kusto.Language.Binding.Binder.GetParameterMatchKind(signature, argumentParameters, argumentTypes, System.Array.getItem(argumentParameters, 0, Kusto.Language.Symbols.Parameter), argument, argumentType, allowLooseParameterMatching);
                        case Kusto.Language.Symbols.ParameterTypeKind.Parameter1: 
                            return Kusto.Language.Binding.Binder.GetParameterMatchKind(signature, argumentParameters, argumentTypes, System.Array.getItem(argumentParameters, 1, Kusto.Language.Symbols.Parameter), argument, argumentType, allowLooseParameterMatching);
                        case Kusto.Language.Symbols.ParameterTypeKind.Parameter2: 
                            return Kusto.Language.Binding.Binder.GetParameterMatchKind(signature, argumentParameters, argumentTypes, System.Array.getItem(argumentParameters, 2, Kusto.Language.Symbols.Parameter), argument, argumentType, allowLooseParameterMatching);
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonScalar: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonNumber: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonSummable: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonOrderable: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonScalarOrDynamic: 
                            var commonType = Kusto.Language.Binding.Binder.GetCommonArgumentType(argumentParameters, argumentTypes);
                            if (commonType != null) {
                                if (Kusto.Language.Binding.Binder.SymbolsAssignable(commonType, argumentType, Kusto.Language.Binding.Conversion.None)) {
                                    return Kusto.Language.Binding.ParameterMatchKind.Exact;
                                } else if (Kusto.Language.Binding.Binder.SymbolsAssignable(commonType, argumentType, Kusto.Language.Binding.Conversion.Promotable)) {
                                    return Kusto.Language.Binding.ParameterMatchKind.Promoted;
                                } else if (allowLooseParameterMatching && Kusto.Language.Binding.Binder.SymbolsAssignable(commonType, argumentType, Kusto.Language.Binding.Conversion.Compatible)) {
                                    return Kusto.Language.Binding.ParameterMatchKind.Compatible;
                                } else if (parameter.TypeKind === Kusto.Language.Symbols.ParameterTypeKind.CommonScalarOrDynamic && Kusto.Language.Binding.Binder.SymbolsAssignable(argumentType, Kusto.Language.Symbols.ScalarTypes.Dynamic)) {
                                    return Kusto.Language.Binding.ParameterMatchKind.Exact;
                                }
                            }
                            break;
                    }

                    return Kusto.Language.Binding.ParameterMatchKind.None;
                },
                GetBodyResultType: function (body) {
                    var $t;
                    var exprBody;
                    var functionBody;
                    return ((exprBody = Bridge.as(body, Kusto.Language.Syntax.Expression))) != null ? exprBody.ResultType : ((functionBody = Bridge.as(body, Kusto.Language.Syntax.FunctionBody))) != null ? ($t = functionBody.Expression) != null ? $t.ResultType : null : null;
                },
                HasErrors: function (syntax) {
                    return syntax != null && ((syntax.ContainsSyntaxDiagnostics && System.Linq.Enumerable.from(syntax.GetContainedSyntaxDiagnostics(), Kusto.Language.Diagnostic).any(function (d) {
                            return Bridge.referenceEquals(d.Severity, Kusto.Language.DiagnosticSeverity.Error);
                        })) || (System.Linq.Enumerable.from(syntax.GetContainedDiagnostics(), Kusto.Language.Diagnostic).any(function (d) {
                            return Bridge.referenceEquals(d.Severity, Kusto.Language.DiagnosticSeverity.Error);
                        })));
                },
                /**
                 * Builds an expanded declaration of the function customized given the arguments used at the call site.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.Signature}    signature
                 * @return  {string}
                 */
                GetFunctionBodyText: function (signature) {
                    var body = signature.Body.trim();

                    if (!System.String.startsWith(body, "{", 4)) {
                        body = "{" + (body || "");
                    }

                    if (!System.String.endsWith(body, "}", 4)) {
                        body = (body || "") + "\n}";
                    }

                    return body;
                },
                GetEntityGroupBodyText: function (signature) {
                    var body = signature.Body.trim();
                    if (!System.String.startsWith(body, "[", 4)) {
                        body = "[" + (body || "");
                    }

                    if (!System.String.endsWith(body, "]", 4)) {
                        body = (body || "") + "\n]";
                    }

                    return System.String.format("entity_group {0}", [body]);
                },
                GetUnboundBody: function (signature) {
                    if (signature.Declaration != null) {
                        return signature.Declaration.Clone$1();
                    } else if (Bridge.is(signature.Symbol, Kusto.Language.Symbols.EntityGroupSymbol)) {
                        var text = Kusto.Language.Binding.Binder.GetEntityGroupBodyText(signature);
                        return Kusto.Language.Parsing.QueryParser.ParseEntityGroup$1(text);
                    } else {
                        var text1 = Kusto.Language.Binding.Binder.GetFunctionBodyText(signature);
                        return Kusto.Language.Parsing.QueryParser.ParseFunctionBody$1(text1);
                    }
                },
                GetRepresentativeType: function (parameter) {
                    switch (parameter.TypeKind) {
                        case Kusto.Language.Symbols.ParameterTypeKind.Declared: 
                            return System.Array.getItem(parameter.DeclaredTypes, 0, Kusto.Language.Symbols.TypeSymbol);
                        case Kusto.Language.Symbols.ParameterTypeKind.Tabular: 
                            return Kusto.Language.Symbols.TableSymbol.Empty;
                        default: 
                            return Kusto.Language.Symbols.ScalarTypes.Dynamic;
                    }
                },
                GetMainBodyOnlyDescendants: function (TElement, body, predicate) {
                    var list = null;

                    Kusto.Language.Syntax.SyntaxElement.WalkElements(body, void 0, function (element) {
                        var te;
                        if (((te = Bridge.as(element, TElement))) != null && predicate(te)) {
                            if (list == null) {
                                list = new (System.Collections.Generic.List$1(TElement)).ctor();
                            }
                            list.add(te);
                        }
                    }, function (element) {
                        return Bridge.referenceEquals(element, body) || (!(Bridge.is(element, Kusto.Language.Syntax.FunctionDeclaration)) && !(Bridge.is(element, Kusto.Language.Syntax.FunctionBody)));
                    });

                    return list || Kusto.Language.Utils.EmptyReadOnlyList$1(TElement).Instance;
                },
                IsSymbolLookupFunction: function (symbol) {
                    return Bridge.referenceEquals(symbol, Kusto.Language.Functions.Table) || Bridge.referenceEquals(symbol, Kusto.Language.Functions.ExternalTable) || Bridge.referenceEquals(symbol, Kusto.Language.Functions.MaterializedView) || Bridge.referenceEquals(symbol, Kusto.Language.Functions.Database) || Bridge.referenceEquals(symbol, Kusto.Language.Functions.Cluster);
                },
                GetDeclaredType: function (typeExpression, diagnostics, binder) {
                    if (diagnostics === void 0) { diagnostics = null; }
                    if (binder === void 0) { binder = null; }
                    do {
                        if (Bridge.is(typeExpression, Kusto.Language.Syntax.PrimitiveTypeExpression)) {
                            var p = Bridge.cast(typeExpression, Kusto.Language.Syntax.PrimitiveTypeExpression);
                            return Kusto.Language.Binding.Binder.GetType(p, diagnostics);
                        }

                        if (Bridge.is(typeExpression, Kusto.Language.Syntax.SchemaTypeExpression)) {
                            var s = Bridge.cast(typeExpression, Kusto.Language.Syntax.SchemaTypeExpression);
                            if (s.Columns.Count === 1 && Bridge.is(s.Columns.getItem$1(0).Element$1, Kusto.Language.Syntax.StarExpression)) {
                                // (*) was the entire declaration.. no columns specified.
                                return Kusto.Language.Symbols.TableSymbol.Empty;
                            }

                            var columns = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                            try {
                                for (var i = 0, n = s.Columns.Count; i < n; i = (i + 1) | 0) {
                                    var expr = s.Columns.getItem$1(i).Element$1;
                                    if (!expr.IsMissing) {
                                        do {
                                            if (Bridge.is(expr, Kusto.Language.Syntax.NameAndTypeDeclaration)) {
                                                var nat = Bridge.cast(expr, Kusto.Language.Syntax.NameAndTypeDeclaration);
                                                var declaredType = Kusto.Language.Binding.Binder.GetDeclaredType(nat.Type, diagnostics, binder);
                                                var newColumn = new Kusto.Language.Symbols.ColumnSymbol(nat.Name.SimpleName, declaredType);
                                                columns.add(newColumn);
                                                if (binder != null) {
                                                    binder.SetSemanticInfo(nat.Name, Kusto.Language.Binding.Binder.GetSemanticInfo(newColumn));
                                                }

                                                break;
                                            }

                                            {
                                                if (diagnostics != null) {
                                                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetInvalidColumnDeclaration().WithLocation(expr));
                                                }

                                                break;
                                            }
                                        } while (false);
                                    }
                                }

                                return new Kusto.Language.Symbols.TableSymbol.$ctor3(columns);
                            } finally {
                                Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(columns);
                            }
                        }

                        {
                            if (diagnostics != null) {
                                diagnostics.add(Kusto.Language.DiagnosticFacts.GetInvalidTypeExpression().WithLocation(typeExpression));
                            }

                            return Kusto.Language.Symbols.ErrorSymbol.Instance;
                        }
                    } while (false);
                },
                GetType: function (primitiveType, diagnostics) {
                    if (diagnostics === void 0) { diagnostics = null; }
                    var typeName = primitiveType.Type.Text;

                    var type = Kusto.Language.Symbols.ScalarTypes.GetSymbol(typeName);

                    if (type != null) {
                        return type;
                    }

                    if (diagnostics != null) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetInvalidTypeName(typeName).WithLocation(primitiveType.Type));
                    }

                    return Kusto.Language.Symbols.ErrorSymbol.Instance;
                },
                IsInteger: function (type) {
                    var s;
                    return ((s = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s.IsInteger;
                },
                IsRealOrDecimal: function (type) {
                    return Kusto.Language.Binding.Binder.SymbolsAssignable(Kusto.Language.Symbols.ScalarTypes.Real, type) || Kusto.Language.Binding.Binder.SymbolsAssignable(Kusto.Language.Symbols.ScalarTypes.Decimal, type);
                },
                IsStringOrDynamic: function (type) {
                    return Kusto.Language.Binding.Binder.SymbolsAssignable(Kusto.Language.Symbols.ScalarTypes.String, type) || Kusto.Language.Binding.Binder.SymbolsAssignable(Kusto.Language.Symbols.ScalarTypes.Dynamic, type);
                },
                IsNumber: function (type) {
                    var s;
                    return ((s = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s.IsNumeric;
                },
                IsIntegerOrDynamic: function (type) {
                    return Kusto.Language.Binding.Binder.IsInteger(type) || Kusto.Language.Binding.Binder.SymbolsAssignable(Kusto.Language.Symbols.ScalarTypes.Dynamic, type);
                },
                IsSummable: function (type) {
                    var s;
                    return ((s = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s.IsSummable;
                },
                IsOrderable: function (type) {
                    var s;
                    return ((s = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s.IsOrderable;
                },
                IsTabular: function (type) {
                    return type != null && type.IsTabular;
                },
                IsDatabase: function (symbol) {
                    return Bridge.is(symbol, Kusto.Language.Symbols.DatabaseSymbol);
                },
                IsCluster: function (symbol) {
                    return Bridge.is(symbol, Kusto.Language.Symbols.ClusterSymbol);
                },
                GetSemanticInfo: function (referencedSymbol, diagnostics) {
                    if (diagnostics === void 0) { diagnostics = []; }
                    return Kusto.Language.Binding.Binder.CreateSemanticInfo(referencedSymbol, Bridge.cast(diagnostics, System.Collections.Generic.IEnumerable$1(Kusto.Language.Diagnostic)));
                },
                CreateSemanticInfo: function (referencedSymbol, diagnostics) {
                    if (diagnostics === void 0) { diagnostics = null; }
                    switch (referencedSymbol.Kind) {
                        case Kusto.Language.Symbols.SymbolKind.Operator: 
                        case Kusto.Language.Symbols.SymbolKind.Column: 
                        case Kusto.Language.Symbols.SymbolKind.Table: 
                        case Kusto.Language.Symbols.SymbolKind.Database: 
                        case Kusto.Language.Symbols.SymbolKind.Cluster: 
                        case Kusto.Language.Symbols.SymbolKind.Parameter: 
                        case Kusto.Language.Symbols.SymbolKind.Function: 
                        case Kusto.Language.Symbols.SymbolKind.Pattern: 
                        case Kusto.Language.Symbols.SymbolKind.Group: 
                        case Kusto.Language.Symbols.SymbolKind.MaterializedView: 
                            return new Kusto.Language.Binding.SemanticInfo.$ctor3(referencedSymbol, Kusto.Language.Binding.Binder.GetResultType(referencedSymbol), diagnostics);
                        case Kusto.Language.Symbols.SymbolKind.Variable: 
                            var v = Bridge.cast(referencedSymbol, Kusto.Language.Symbols.VariableSymbol);
                            return new Kusto.Language.Binding.SemanticInfo.$ctor3(referencedSymbol, Kusto.Language.Binding.Binder.GetResultType(referencedSymbol), diagnostics, v.IsConstant, void 0);
                        case Kusto.Language.Symbols.SymbolKind.Scalar: 
                        case Kusto.Language.Symbols.SymbolKind.Tuple: 
                            return new Kusto.Language.Binding.SemanticInfo.$ctor5(Bridge.cast(referencedSymbol, Kusto.Language.Symbols.TypeSymbol), diagnostics);
                        default: 
                            return new Kusto.Language.Binding.SemanticInfo.$ctor5(Kusto.Language.Symbols.ErrorSymbol.Instance, diagnostics);
                    }
                },
                GetResultType: function (symbol) {
                    return Kusto.Language.Symbols.Symbol.GetExpressionResultType(symbol);
                },
                SymbolsAssignable$1: function (targetTypes, sourceType, conversion) {
                    if (conversion === void 0) { conversion = 0; }
                    for (var i = 0; i < System.Array.getCount(targetTypes, Kusto.Language.Symbols.TypeSymbol); i = (i + 1) | 0) {
                        if (Kusto.Language.Binding.Binder.SymbolsAssignable(System.Array.getItem(targetTypes, i, Kusto.Language.Symbols.TypeSymbol), sourceType, conversion)) {
                            return true;
                        }
                    }

                    return false;
                },
                /**
                 * True if a value of type {@link } can be assigned to a parameter of type {@link }
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.Symbol}        targetType    
                 * @param   {Kusto.Language.Symbols.Symbol}        sourceType    
                 * @param   {Kusto.Language.Binding.Conversion}    conversion
                 * @return  {boolean}
                 */
                SymbolsAssignable: function (targetType, sourceType, conversion) {
                    if (conversion === void 0) { conversion = 0; }
                    if (Bridge.referenceEquals(targetType, sourceType)) {
                        return true;
                    }

                    if (targetType == null || sourceType == null) {
                        return false;
                    }

                    if (Bridge.referenceEquals(sourceType, Kusto.Language.Symbols.ScalarTypes.Unknown) && targetType.IsScalar) {
                        return true;
                    }

                    if (Bridge.referenceEquals(targetType, Kusto.Language.Symbols.ScalarTypes.Unknown) && sourceType.IsScalar) {
                        return true;
                    }
                    var stt;
                    // a single column tuple is assignable to a scalar
                    if (sourceType.Kind === Kusto.Language.Symbols.SymbolKind.Tuple && targetType.Kind === Kusto.Language.Symbols.SymbolKind.Scalar && ((stt = Bridge.as(sourceType, Kusto.Language.Symbols.TupleSymbol))) != null && System.Array.getCount(stt.Columns, Kusto.Language.Symbols.ColumnSymbol) === 1) {
                        return Kusto.Language.Binding.Binder.SymbolsAssignable(targetType, System.Array.getItem(stt.Columns, 0, Kusto.Language.Symbols.ColumnSymbol).Type);
                    }

                    if (targetType.Kind !== sourceType.Kind) {
                        return false;
                    }

                    switch (targetType.Kind) {
                        case Kusto.Language.Symbols.SymbolKind.Column: 
                            var tarCol = Bridge.cast(targetType, Kusto.Language.Symbols.ColumnSymbol);
                            var srcCol = Bridge.cast(sourceType, Kusto.Language.Symbols.ColumnSymbol);
                            return Bridge.referenceEquals(tarCol.Name, srcCol.Name) && Kusto.Language.Binding.Binder.SymbolsAssignable(tarCol.Type, srcCol.Type, conversion);
                        case Kusto.Language.Symbols.SymbolKind.Tuple: 
                        case Kusto.Language.Symbols.SymbolKind.Group: 
                            return Kusto.Language.Binding.Binder.MembersEqual(targetType, sourceType);
                        case Kusto.Language.Symbols.SymbolKind.Table: 
                            return Kusto.Language.Binding.Binder.TablesAssignable(Bridge.cast(targetType, Kusto.Language.Symbols.TableSymbol), Bridge.cast(sourceType, Kusto.Language.Symbols.TableSymbol));
                        case Kusto.Language.Symbols.SymbolKind.Scalar: 
                            switch (conversion) {
                                case Kusto.Language.Binding.Conversion.Promotable: 
                                    return Kusto.Language.Binding.Binder.IsPromotable(Bridge.cast(sourceType, Kusto.Language.Symbols.TypeSymbol), Bridge.cast(targetType, Kusto.Language.Symbols.TypeSymbol));
                                case Kusto.Language.Binding.Conversion.Compatible: 
                                    return Kusto.Language.Binding.Binder.IsPromotable(Bridge.cast(sourceType, Kusto.Language.Symbols.TypeSymbol), Bridge.cast(targetType, Kusto.Language.Symbols.TypeSymbol)) || Kusto.Language.Binding.Binder.IsPromotable(Bridge.cast(targetType, Kusto.Language.Symbols.TypeSymbol), Bridge.cast(sourceType, Kusto.Language.Symbols.TypeSymbol));
                                case Kusto.Language.Binding.Conversion.Any: 
                                    return true;
                                default: 
                                    return false;
                            }
                    }

                    return false;
                },
                MembersEqual: function (target, source) {
                    if (System.Array.getCount(target.Members, Kusto.Language.Symbols.Symbol) !== System.Array.getCount(source.Members, Kusto.Language.Symbols.Symbol)) {
                        return false;
                    }

                    for (var i = 0, n = System.Array.getCount(target.Members, Kusto.Language.Symbols.Symbol); i < n; i = (i + 1) | 0) {
                        if (!Kusto.Language.Binding.Binder.SymbolsAssignable(System.Array.getItem(target.Members, i, Kusto.Language.Symbols.Symbol), System.Array.getItem(source.Members, i, Kusto.Language.Symbols.Symbol))) {
                            return false;
                        }
                    }

                    return true;
                },
                /**
                 * True if a table value can be assigned to a parameter of a specific table type.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.TableSymbol}    target    
                 * @param   {Kusto.Language.Symbols.TableSymbol}    source
                 * @return  {boolean}
                 */
                TablesAssignable: function (target, source) {
                    var $t;
                    // ensure that the value table has at least the columns specified for the parameter table.

                    $t = Bridge.getEnumerator(target.Columns, Kusto.Language.Symbols.ColumnSymbol);
                    try {
                        while ($t.moveNext()) {
                            var tarCol = $t.Current;
                            var valueColumn = { };
                            if (!source.TryGetColumn(tarCol.Name, valueColumn) || !Kusto.Language.Binding.Binder.SymbolsAssignable(tarCol.Type, valueColumn.v.Type)) {
                                return false;
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    return true;
                },
                GetQueryOperatorParameter: function (name, parameters) {
                    var $t;
                    $t = Bridge.getEnumerator(parameters, Kusto.Language.QueryOperatorParameter);
                    try {
                        while ($t.moveNext()) {
                            var p = $t.Current;
                            if (Bridge.referenceEquals(p.Name, name) || (System.Array.getCount(p.Aliases, System.String) > 0 && System.Linq.Enumerable.from(p.Aliases, System.String).contains(name))) {
                                return p;
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    return null;
                },
                Contains: function (values, value, caseSensitive) {
                    var stringValue = Bridge.as(value, System.String);
                    if (stringValue != null) {
                        for (var i = 0, n = System.Array.getCount(values, System.Object); i < n; i = (i + 1) | 0) {
                            var v = Bridge.as(System.Array.getItem(values, i, System.Object), System.String);
                            if (System.String.compare(stringValue, v, !caseSensitive) === 0) {
                                return true;
                            }
                        }
                    } else {
                        for (var i1 = 0, n1 = System.Array.getCount(values, System.Object); i1 < n1; i1 = (i1 + 1) | 0) {
                            if (Bridge.referenceEquals(System.Array.getItem(values, i1, System.Object), value)) {
                                return true;
                            }
                        }
                    }

                    return false;
                },
                /**
                 * True if any argument type is an error type or unknown.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
                 * @return  {boolean}
                 */
                ArgumentsHaveErrorsOrUnknown: function (argumentTypes) {
                    for (var i = 0; i < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol); i = (i + 1) | 0) {
                        var type = System.Array.getItem(argumentTypes, i, Kusto.Language.Symbols.TypeSymbol);
                        if (type.IsError || Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                            return true;
                        }
                    }

                    return false;
                },
                IsNamedArgument: function (argument) {
                    return Bridge.is(argument, Kusto.Language.Syntax.NamedExpression);
                },
                GetNamedArgumentNameNode: function (argument) {
                    do {
                        if (Bridge.is(argument, Kusto.Language.Syntax.SimpleNamedExpression)) {
                            var sn = Bridge.cast(argument, Kusto.Language.Syntax.SimpleNamedExpression);
                            return sn.Name;
                        }

                        if (Bridge.is(argument, Kusto.Language.Syntax.CompoundNamedExpression)) {
                            var cn = Bridge.cast(argument, Kusto.Language.Syntax.CompoundNamedExpression);
                            return cn.Names;
                        }

                        {
                            return null;
                        }
                    } while (false);
                },
                CheckArgumentCount: function (expressions, expectedCount, diagnostics) {
                    if (expressions.Count === expectedCount) {
                        return true;
                    }

                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetArgumentCountExpected(expectedCount).WithLocation(expressions));
                    return false;
                },
                IsFunctionCallName: function (name) {
                    var fn;
                    return ((fn = Bridge.as(name.Parent, Kusto.Language.Syntax.FunctionCallExpression))) != null && Bridge.referenceEquals(fn.Name, name);
                },
                IsInsideControlCommandFunctionDeclaration: function (location) {
                    var functionDeclaration = location.GetFirstAncestor(Kusto.Language.Syntax.FunctionDeclaration);
                    if (functionDeclaration != null && Bridge.is(functionDeclaration.Parent, Kusto.Language.Syntax.CustomNode)) {
                        return true;
                    }

                    var functionBody = location.GetFirstAncestor(Kusto.Language.Syntax.FunctionBody);
                    if (functionBody != null && Bridge.is(functionBody.Parent, Kusto.Language.Syntax.CustomNode)) {
                        return true;
                    }

                    return false;
                },
                IsInsideControlCommand: function (location) {
                    // so far, only control commands use CustomNode
                    return location.GetFirstAncestor(Kusto.Language.Syntax.CustomNode) != null;
                },
                IsInsideControlCommandProper: function (location) {
                    // its part of the control command but not part of any
                    // function declaration or input query
                    return Kusto.Language.Binding.Binder.IsInsideControlCommand(location) && !Kusto.Language.Binding.Binder.IsInsideControlCommandFunctionDeclaration(location) && !Kusto.Language.Binding.Binder.IsInsideControlCommandInputQuery(location);
                },
                IsInsideControlCommandInputQuery: function (location) {
                    // looking for statement list that is child of a CustomNode
                    return location.GetFirstAncestor(Kusto.Language.Syntax.SyntaxList$1(Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement)), function (s) {
                        return Bridge.is(s.Parent, Kusto.Language.Syntax.CustomNode);
                    }) != null;
                },
                IsInvocableFunctionName: function (location) {
                    // function names in non-executable parts of control commands are not invocable
                    return !Kusto.Language.Binding.Binder.IsInsideControlCommandProper(location);
                },
                IsPossibleInvocableFunctionWithoutArgumentList: function (location) {
                    return !Kusto.Language.Binding.Binder.IsFunctionCallName(location) && Kusto.Language.Binding.Binder.IsInvocableFunctionName(location);
                },
                IsEvaluateFunctionName: function (name) {
                    var fn;
                    return ((fn = Bridge.as(name.Parent, Kusto.Language.Syntax.FunctionCallExpression))) != null && Bridge.is(fn.Parent, Kusto.Language.Syntax.EvaluateOperator);
                },
                /**
                 * True if member access operators (dot) on this apply to the members
                 as opposed to matching the members themselves.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.GroupSymbol}    group
                 * @return  {boolean}
                 */
                IsPassThrough: function (group) {
                    // dot access on groups of clusters or databases is meant to be 
                    // the aggregate of the dot access on all the clusters or databases
                    return System.Linq.Enumerable.from(group.Members, Kusto.Language.Symbols.Symbol).any(function (m) {
                            return Bridge.is(m, Kusto.Language.Symbols.DatabaseSymbol) || Bridge.is(m, Kusto.Language.Symbols.ClusterSymbol);
                        });
                },
                MakeDistinct: function (list) {
                    var $t;
                    if (list.Count > 1) {
                        var hset = Kusto.Language.Binding.Binder.s_symbolHashSetPool.AllocateFromPool();
                        var newList = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();

                        $t = Bridge.getEnumerator(list);
                        try {
                            while ($t.moveNext()) {
                                var item = $t.Current;
                                if (!hset.contains(item)) {
                                    hset.add(item);
                                    newList.add(item);
                                }
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }

                        list.clear();
                        list.AddRange(newList);

                        Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(newList);
                        Kusto.Language.Binding.Binder.s_symbolHashSetPool.ReturnToPool(hset);
                    }
                },
                RemoveFunctionsThatCannotBeInvokedWithZeroArgs: function (list) {
                    for (var i = (list.Count - 1) | 0; i >= 0; i = (i - 1) | 0) {
                        var fn;
                        if (((fn = Bridge.as(list.getItem(i), Kusto.Language.Symbols.FunctionSymbol))) != null && fn.MinArgumentCount > 0) {
                            list.removeAt(i);
                        }
                    }
                },
                GetWildcardSymbols: function (pattern, symbols, matchingSymbols) {
                    var $t;
                    $t = Bridge.getEnumerator(symbols, Kusto.Language.Symbols.Symbol);
                    try {
                        while ($t.moveNext()) {
                            var symbol = $t.Current;
                            if (Kusto.Language.KustoFacts.Matches(pattern, symbol.Name)) {
                                matchingSymbols.add(symbol);
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                },
                /**
                 * Determine if the element (a name) is in a known tabular context
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.SyntaxElement}    element
                 * @return  {boolean}
                 */
                IsInTabularContext: function (element) {
                    var fc; // if function call name, look further up to determine context
                    if (((fc = Bridge.as(element.Parent, Kusto.Language.Syntax.FunctionCallExpression))) != null && Bridge.referenceEquals(fc.Name, element)) {
                        element = element.Parent;
                    }

                    // if inside parenthesis or part of a list, look further up
                    while (Bridge.is(element.Parent, Kusto.Language.Syntax.ParenthesizedExpression) || Bridge.is(element.Parent, Kusto.Language.Syntax.SyntaxList) || Bridge.is(element.Parent, Kusto.Language.Syntax.SeparatedElement)) {
                        element = element.Parent;
                    }

                    if (element.Parent != null) {
                        var pe; // if x | op then x is expected to be tabular
                        if (((pe = Bridge.as(element.Parent, Kusto.Language.Syntax.PipeExpression))) != null && Bridge.referenceEquals(pe.Expression, element)) {
                            return true;
                        }
                        var pt;
                        // if database().x then x is expected to be tabular
                        if (((pt = Bridge.as(element.Parent, Kusto.Language.Syntax.PathExpression))) != null && Bridge.referenceEquals(pt.Selector, element)) {
                            if (Bridge.is(pt.Expression.ResultType, Kusto.Language.Symbols.DatabaseSymbol)) {
                                return true;
                            }
                            var g;
                            if (((g = Bridge.as(pt.Expression.ResultType, Kusto.Language.Symbols.GroupSymbol))) != null && System.Linq.Enumerable.from(g.Members, Kusto.Language.Symbols.Symbol).any(function (m) {
                                    return Bridge.is(m, Kusto.Language.Symbols.DatabaseSymbol);
                                })) {
                                return true;
                            }
                        }

                        // use completion hint to help us determine if context is tabular
                        var hint = element.Parent.GetCompletionHint(element.IndexInParent);

                        if (hint === Kusto.Language.Editor.CompletionHint.Table || hint === Kusto.Language.Editor.CompletionHint.Tabular || hint === Kusto.Language.Editor.CompletionHint.MaterializedView || hint === Kusto.Language.Editor.CompletionHint.ExternalTable) {
                            return true;
                        }
                    }

                    return false;
                },
                /**
                 * Determine if the element is the operand of a fuzzy union
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.SyntaxElement}    element
                 * @return  {boolean}
                 */
                IsFuzzyUnionOperand: function (element) {
                    var fc;
                    if (((fc = Bridge.as(element.Parent, Kusto.Language.Syntax.FunctionCallExpression))) != null && Bridge.referenceEquals(fc.Name, element)) {
                        element = element.Parent;
                    }

                    while (Bridge.is(element.Parent, Kusto.Language.Syntax.ParenthesizedExpression) || Bridge.is(element.Parent, Kusto.Language.Syntax.SyntaxList) || Bridge.is(element.Parent, Kusto.Language.Syntax.SeparatedElement)) {
                        element = element.Parent;
                    }

                    var context = element.Parent;

                    if (context != null) {
                        var pe;
                        if (((pe = Bridge.as(context, Kusto.Language.Syntax.PipeExpression))) != null && Bridge.referenceEquals(pe.Expression, element)) {
                            context = pe.Operator;
                        }
                        var uo;
                        if (((uo = Bridge.as(context, Kusto.Language.Syntax.UnionOperator))) != null) {
                            var np = Kusto.Language.Syntax.SyntaxListExtensions.GetParameter(uo.Parameters, Kusto.Language.QueryOperatorParameters.IsFuzzy);
                            var b;
                            return np != null && ((b = Bridge.is(np.Expression.ConstantValue, System.Boolean) ? System.Nullable.getValue(Bridge.cast(Bridge.unbox(np.Expression.ConstantValue, System.Boolean), System.Boolean)) : null)) != null && b;
                        }
                    }

                    return false;
                },
                GetOperatorKind: function (kind) {
                    switch (kind) {
                        case Kusto.Language.Syntax.SyntaxKind.AddExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Add;
                        case Kusto.Language.Syntax.SyntaxKind.SubtractExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Subtract;
                        case Kusto.Language.Syntax.SyntaxKind.MultiplyExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Multiply;
                        case Kusto.Language.Syntax.SyntaxKind.DivideExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Divide;
                        case Kusto.Language.Syntax.SyntaxKind.ModuloExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Modulo;
                        case Kusto.Language.Syntax.SyntaxKind.UnaryMinusExpression: 
                            return Kusto.Language.Symbols.OperatorKind.UnaryMinus;
                        case Kusto.Language.Syntax.SyntaxKind.UnaryPlusExpression: 
                            return Kusto.Language.Symbols.OperatorKind.UnaryPlus;
                        case Kusto.Language.Syntax.SyntaxKind.EqualExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Equal;
                        case Kusto.Language.Syntax.SyntaxKind.NotEqualExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotEqual;
                        case Kusto.Language.Syntax.SyntaxKind.LessThanExpression: 
                            return Kusto.Language.Symbols.OperatorKind.LessThan;
                        case Kusto.Language.Syntax.SyntaxKind.LessThanOrEqualExpression: 
                            return Kusto.Language.Symbols.OperatorKind.LessThanOrEqual;
                        case Kusto.Language.Syntax.SyntaxKind.GreaterThanExpression: 
                            return Kusto.Language.Symbols.OperatorKind.GreaterThan;
                        case Kusto.Language.Syntax.SyntaxKind.GreaterThanOrEqualExpression: 
                            return Kusto.Language.Symbols.OperatorKind.GreaterThanOrEqual;
                        case Kusto.Language.Syntax.SyntaxKind.EqualTildeExpression: 
                            return Kusto.Language.Symbols.OperatorKind.EqualTilde;
                        case Kusto.Language.Syntax.SyntaxKind.BangTildeExpression: 
                            return Kusto.Language.Symbols.OperatorKind.BangTilde;
                        case Kusto.Language.Syntax.SyntaxKind.HasExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Has;
                        case Kusto.Language.Syntax.SyntaxKind.HasCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.HasCs;
                        case Kusto.Language.Syntax.SyntaxKind.NotHasExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotHas;
                        case Kusto.Language.Syntax.SyntaxKind.NotHasCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotHasCs;
                        case Kusto.Language.Syntax.SyntaxKind.HasPrefixExpression: 
                            return Kusto.Language.Symbols.OperatorKind.HasPrefix;
                        case Kusto.Language.Syntax.SyntaxKind.HasPrefixCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.HasPrefixCs;
                        case Kusto.Language.Syntax.SyntaxKind.NotHasPrefixExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotHasPrefix;
                        case Kusto.Language.Syntax.SyntaxKind.NotHasPrefixCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotHasPrefixCs;
                        case Kusto.Language.Syntax.SyntaxKind.HasSuffixExpression: 
                            return Kusto.Language.Symbols.OperatorKind.HasSuffix;
                        case Kusto.Language.Syntax.SyntaxKind.HasSuffixCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.HasSuffixCs;
                        case Kusto.Language.Syntax.SyntaxKind.NotHasSuffixExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotHasSuffix;
                        case Kusto.Language.Syntax.SyntaxKind.NotHasSuffixCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotHasSuffixCs;
                        case Kusto.Language.Syntax.SyntaxKind.LikeExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Like;
                        case Kusto.Language.Syntax.SyntaxKind.LikeCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.LikeCs;
                        case Kusto.Language.Syntax.SyntaxKind.NotLikeExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotLike;
                        case Kusto.Language.Syntax.SyntaxKind.NotLikeCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotLikeCs;
                        case Kusto.Language.Syntax.SyntaxKind.ContainsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Contains;
                        case Kusto.Language.Syntax.SyntaxKind.ContainsCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.ContainsCs;
                        case Kusto.Language.Syntax.SyntaxKind.NotContainsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotContains;
                        case Kusto.Language.Syntax.SyntaxKind.NotContainsCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotContainsCs;
                        case Kusto.Language.Syntax.SyntaxKind.StartsWithExpression: 
                            return Kusto.Language.Symbols.OperatorKind.StartsWith;
                        case Kusto.Language.Syntax.SyntaxKind.StartsWithCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.StartsWithCs;
                        case Kusto.Language.Syntax.SyntaxKind.NotStartsWithExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotStartsWith;
                        case Kusto.Language.Syntax.SyntaxKind.NotStartsWithCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotStartsWithCs;
                        case Kusto.Language.Syntax.SyntaxKind.EndsWithExpression: 
                            return Kusto.Language.Symbols.OperatorKind.EndsWith;
                        case Kusto.Language.Syntax.SyntaxKind.EndsWithCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.EndsWithCs;
                        case Kusto.Language.Syntax.SyntaxKind.NotEndsWithExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotEndsWith;
                        case Kusto.Language.Syntax.SyntaxKind.NotEndsWithCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotEndsWithCs;
                        case Kusto.Language.Syntax.SyntaxKind.MatchesRegexExpression: 
                            return Kusto.Language.Symbols.OperatorKind.MatchRegex;
                        case Kusto.Language.Syntax.SyntaxKind.InExpression: 
                            return Kusto.Language.Symbols.OperatorKind.In;
                        case Kusto.Language.Syntax.SyntaxKind.InCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.InCs;
                        case Kusto.Language.Syntax.SyntaxKind.NotInExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotIn;
                        case Kusto.Language.Syntax.SyntaxKind.NotInCsExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotInCs;
                        case Kusto.Language.Syntax.SyntaxKind.BetweenExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Between;
                        case Kusto.Language.Syntax.SyntaxKind.NotBetweenExpression: 
                            return Kusto.Language.Symbols.OperatorKind.NotBetween;
                        case Kusto.Language.Syntax.SyntaxKind.AndExpression: 
                            return Kusto.Language.Symbols.OperatorKind.And;
                        case Kusto.Language.Syntax.SyntaxKind.OrExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Or;
                        case Kusto.Language.Syntax.SyntaxKind.SearchExpression: 
                            return Kusto.Language.Symbols.OperatorKind.Search;
                        case Kusto.Language.Syntax.SyntaxKind.HasAnyExpression: 
                            return Kusto.Language.Symbols.OperatorKind.HasAny;
                        case Kusto.Language.Syntax.SyntaxKind.HasAllExpression: 
                            return Kusto.Language.Symbols.OperatorKind.HasAll;
                        default: 
                            return Kusto.Language.Symbols.OperatorKind.None;
                    }
                },
                GetResultColumn: function (expr) {
                    if (expr == null) {
                        return null;
                    } else {
                        var p;
                        if (((p = Bridge.as(expr, Kusto.Language.Syntax.ParenthesizedExpression))) != null) {
                            return Kusto.Language.Binding.Binder.GetResultColumn(p.Expression);
                        } else {
                            var c;
                            if (((c = Bridge.as(expr.ReferencedSymbol, Kusto.Language.Symbols.ColumnSymbol))) != null) {
                                return c;
                            } else {
                                var fc;
                                var ac;
                                if (((fc = Bridge.as(expr, Kusto.Language.Syntax.FunctionCallExpression))) != null && Kusto.Language.Binding.Binder.IsConversionFunction$1(fc) && fc.ArgumentList.Expressions.Count === 1 && ((ac = Bridge.as(fc.ArgumentList.Expressions.getItem$1(0).Element$1.ReferencedSymbol, Kusto.Language.Symbols.ColumnSymbol))) != null && Bridge.referenceEquals(fc.ResultType, ac.Type)) {
                                    // this is a no-op conversion with column argument, so use argument column as 
                                    // the column reference for this expression too.
                                    return ac;
                                } else {
                                    return null;
                                }
                            }
                        }
                    }
                },
                IsConversionFunction$1: function (expr) {
                    var fs;
                    return ((fs = Bridge.as(expr.ReferencedSymbol, Kusto.Language.Symbols.FunctionSymbol))) != null && Kusto.Language.Binding.Binder.IsConversionFunction(fs);
                },
                IsConversionFunction: function (fn) {
                    return Bridge.referenceEquals(fn, Kusto.Language.Functions.ToBool) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToBool) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToDateTime) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToDecimal) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToDouble) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToDynamic_) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToGuid) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToInt) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToLong) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToReal) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToString) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToTime) || Bridge.referenceEquals(fn, Kusto.Language.Functions.ToTimespan);
                },
                DeclareColumnName: function (declaredNames, newName, diagnostics, location) {
                    if (declaredNames.contains(newName)) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetDuplicateColumnDeclaration(newName).WithLocation(location));
                        return false;
                    } else {
                        declaredNames.add(newName);
                        return true;
                    }
                },
                /**
                 * Gets the name that a function call expression will use as its column name in a projection.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.FunctionCallExpression}    fc             
                 * @param   {string}                                          defaultName    
                 * @param   {Kusto.Language.Symbols.TableSymbol}              row
                 * @return  {string}
                 */
                GetFunctionResultName: function (fc, defaultName, row) {
                    var $t;
                    if (defaultName === void 0) { defaultName = ""; }
                    if (row === void 0) { row = null; }
                    var fs = Bridge.as(fc.ReferencedSymbol, Kusto.Language.Symbols.FunctionSymbol);
                    var kind = ($t = (fs != null ? fs.ResultNameKind : null), $t != null ? $t : Kusto.Language.Symbols.ResultNameKind.None);
                    var prefix = fs != null ? fs.ResultNamePrefix : null;

                    if (kind === Kusto.Language.Symbols.ResultNameKind.NameAndFirstArgument) {
                        prefix = fs.Name;
                        kind = Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument;
                    } else if (kind === Kusto.Language.Symbols.ResultNameKind.NameAndOnlyArgument) {
                        prefix = fs.Name;
                        kind = Kusto.Language.Symbols.ResultNameKind.PrefixAndOnlyArgument;
                    }

                    if (kind === Kusto.Language.Symbols.ResultNameKind.PrefixAndFirstArgument) {
                        if (fc.ArgumentList.Expressions.Count > 0) {
                            var name = Kusto.Language.Binding.Binder.GetExpressionResultName(fc.ArgumentList.Expressions.getItem$1(0).Element$1, defaultName);
                            if (prefix != null) {
                                return (prefix || "") + "_" + (name || "");
                            } else {
                                return name;
                            }
                        } else if (prefix != null) {
                            return (prefix || "") + "_";
                        } else {
                            return null;
                        }
                    } else if (kind === Kusto.Language.Symbols.ResultNameKind.PrefixAndOnlyArgument && fc.ArgumentList.Expressions.Count === 1) {
                        var name1 = Kusto.Language.Binding.Binder.GetExpressionResultName(fc.ArgumentList.Expressions.getItem$1(0).Element$1, defaultName);
                        if (prefix != null) {
                            return (prefix || "") + "_" + (name1 || "");
                        } else {
                            return name1;
                        }
                    } else {
                        var name2;
                        if (kind === Kusto.Language.Symbols.ResultNameKind.FirstArgumentValueIfColumn && fc.ArgumentList.Expressions.Count > 0 && ((name2 = Bridge.as(fc.ArgumentList.Expressions.getItem$1(0).Element$1.ConstantValue, System.String))) != null) {
                            var _discard1 = { };
                            if (row != null && row.TryGetColumn(name2, _discard1)) {
                                return name2;
                            } else {
                                return defaultName;
                            }
                        } else if (kind === Kusto.Language.Symbols.ResultNameKind.FirstArgument) {
                            if (fc.ArgumentList.Expressions.Count > 0) {
                                return Kusto.Language.Binding.Binder.GetExpressionResultName(fc.ArgumentList.Expressions.getItem$1(0).Element$1, defaultName);
                            } else {
                                return null;
                            }
                        } else if (kind === Kusto.Language.Symbols.ResultNameKind.PrefixOnly && prefix != null) {
                            return prefix;
                        } else if (kind === Kusto.Language.Symbols.ResultNameKind.OnlyArgument && fc.ArgumentList.Expressions.Count === 1) {
                            return Kusto.Language.Binding.Binder.GetExpressionResultName(fc.ArgumentList.Expressions.getItem$1(0).Element$1, defaultName);
                        } else {
                            return defaultName;
                        }
                    }
                },
                /**
                 * Gets the name that an expression will use for its column name in a projection.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.Expression}      expr           
                 * @param   {string}                                defaultName    
                 * @param   {Kusto.Language.Symbols.TableSymbol}    row
                 * @return  {string}
                 */
                GetExpressionResultName: function (expr, defaultName, row) {
                    if (defaultName === void 0) { defaultName = ""; }
                    if (row === void 0) { row = null; }
                    do {
                        if (Bridge.is(expr, Kusto.Language.Syntax.ParenthesizedExpression)) {
                            var p = Bridge.cast(expr, Kusto.Language.Syntax.ParenthesizedExpression);
                            return Kusto.Language.Binding.Binder.GetExpressionResultName(p.Expression, defaultName, row);
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.NameReference)) {
                            var n = Bridge.cast(expr, Kusto.Language.Syntax.NameReference);
                            return n.SimpleName;
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.BracketedExpression)) {
                            var be = Bridge.cast(expr, Kusto.Language.Syntax.BracketedExpression);
                            {
                                var bet;
                                if (be.Expression.IsLiteral && ((bet = Bridge.as(be.Expression.ResultType, Kusto.Language.Symbols.ScalarSymbol))) != null && (Bridge.referenceEquals(bet, Kusto.Language.Symbols.ScalarTypes.String) || Bridge.referenceEquals(bet, Kusto.Language.Symbols.ScalarTypes.Long) || Bridge.referenceEquals(bet, Kusto.Language.Symbols.ScalarTypes.Int))) {
                                    return Bridge.toString(be.Expression.LiteralValue);
                                }
                            }

                            return defaultName;
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.PathExpression)) {
                            var p1 = Bridge.cast(expr, Kusto.Language.Syntax.PathExpression);
                            if (Bridge.referenceEquals(p1.Expression.ResultType, Kusto.Language.Symbols.ScalarTypes.Dynamic) || Bridge.referenceEquals(p1.Expression.ResultType, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                                var left = Kusto.Language.Binding.Binder.GetExpressionResultName(p1.Expression, null);
                                var right = Kusto.Language.Binding.Binder.GetExpressionResultName(p1.Selector, null);
                                if (!System.String.isNullOrWhiteSpace(left)) {
                                    return System.String.format("{0}_{1}", left, right);
                                } else {
                                    return right;
                                }
                            } else {
                                return Kusto.Language.Binding.Binder.GetExpressionResultName(p1.Selector, defaultName);
                            }
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.ElementExpression)) {
                            var e = Bridge.cast(expr, Kusto.Language.Syntax.ElementExpression);
                            if (Bridge.referenceEquals(e.Expression.ResultType, Kusto.Language.Symbols.ScalarTypes.Dynamic) || Bridge.referenceEquals(e.Expression.ResultType, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                                var left1 = Kusto.Language.Binding.Binder.GetExpressionResultName(e.Expression, null);
                                var right1 = Kusto.Language.Binding.Binder.GetExpressionResultName(e.Selector, null);
                                if (!System.String.isNullOrWhiteSpace(left1)) {
                                    return System.String.format("{0}_{1}", left1, right1);
                                } else {
                                    return right1;
                                }
                            } else {
                                return Kusto.Language.Binding.Binder.GetExpressionResultName(e.Selector, defaultName);
                            }
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.OrderedExpression)) {
                            var o = Bridge.cast(expr, Kusto.Language.Syntax.OrderedExpression);
                            return Kusto.Language.Binding.Binder.GetExpressionResultName(o.Expression, defaultName);
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.SimpleNamedExpression)) {
                            var s = Bridge.cast(expr, Kusto.Language.Syntax.SimpleNamedExpression);
                            return s.Name.SimpleName;
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.FunctionCallExpression)) {
                            var f = Bridge.cast(expr, Kusto.Language.Syntax.FunctionCallExpression);
                            return Kusto.Language.Binding.Binder.GetFunctionResultName(f, defaultName, row);
                        }

                        {
                            return defaultName;
                        }
                    } while (false);
                },
                /**
                 * Gets the declared name of a {@link } or null.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.Expression}    expr
                 * @return  {string}
                 */
                GetExpressionDeclaredName: function (expr) {
                    do {
                        if (Bridge.is(expr, Kusto.Language.Syntax.SimpleNamedExpression)) {
                            var n = Bridge.cast(expr, Kusto.Language.Syntax.SimpleNamedExpression);
                            return n.Name.SimpleName;
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.OrderedExpression)) {
                            var o = Bridge.cast(expr, Kusto.Language.Syntax.OrderedExpression);
                            return Kusto.Language.Binding.Binder.GetExpressionDeclaredName(o.Expression);
                        }

                        {
                            return null;
                        }
                    } while (false);
                },
                /**
                 * Gets the expression underlying adornments such as name assignment or ordering
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.Expression}    expression
                 * @return  {Kusto.Language.Syntax.Expression}
                 */
                GetUnderlyingExpression: function (expression) {
                    do {
                        if (Bridge.is(expression, Kusto.Language.Syntax.SimpleNamedExpression)) {
                            var n = Bridge.cast(expression, Kusto.Language.Syntax.SimpleNamedExpression);
                            return Kusto.Language.Binding.Binder.GetUnderlyingExpression(n.Expression);
                        }

                        if (Bridge.is(expression, Kusto.Language.Syntax.OrderedExpression)) {
                            var o = Bridge.cast(expression, Kusto.Language.Syntax.OrderedExpression);
                            return Kusto.Language.Binding.Binder.GetUnderlyingExpression(o.Expression);
                        }

                        {
                            return expression;
                        }
                    } while (false);
                },
                GetNameDeclarationName: function (expr) {
                    do {
                        if (Bridge.is(expr, Kusto.Language.Syntax.NameDeclaration)) {
                            var nd = Bridge.cast(expr, Kusto.Language.Syntax.NameDeclaration);
                            return nd.Name.SimpleName;
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.NameReference)) {
                            var nr = Bridge.cast(expr, Kusto.Language.Syntax.NameReference);
                            return nr.Name.SimpleName;
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.LiteralExpression)) {
                            var le = Bridge.cast(expr, Kusto.Language.Syntax.LiteralExpression);
                            if (le.Kind === Kusto.Language.Syntax.SyntaxKind.StringLiteralExpression || le.Kind === Kusto.Language.Syntax.SyntaxKind.TokenLiteralExpression) {
                                return Bridge.cast(le.LiteralValue, System.String);
                            }
                            break;
                        }

                        if (Bridge.is(expr, Kusto.Language.Syntax.CompoundStringLiteralExpression)) {
                            var cs = Bridge.cast(expr, Kusto.Language.Syntax.CompoundStringLiteralExpression);
                            return Bridge.cast(cs.LiteralValue, System.String);
                        }
                    } while (false);
                    return null;
                },
                /**
                 * Converts a list of columns into a list of unique (unioned columns)
                 Columns with the same name and type will be merged into one column.
                 Columns with the same name but different type will be renamed to include the type name as a suffix.
                 *
                 * @static
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.List$1}    columns
                 * @return  {void}
                 */
                UnifyColumnsWithSameNameAndType: function (columns) {
                    var $t;
                    var uniqueNames = Kusto.Language.Binding.Binder.s_uniqueNameTablePool.AllocateFromPool();
                    var newColumns = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                    try {
                        // TODO: pool this too?
                        var map = Kusto.Language.Binding.Binder.BuildColumnNameMap(columns);

                        // go through original column order and build out new column list
                        for (var i = 0; i < columns.Count; i = (i + 1) | 0) {
                            var col = columns.getItem(i);
                            var sameNamedColumns = { };

                            if (map.tryGetValue(col.Name, sameNamedColumns)) {
                                if (sameNamedColumns.v.Count === 1) {
                                    // exactly one column with this name
                                    newColumns.add(Kusto.Language.Binding.Binder.GetUniqueColumn(col, uniqueNames));
                                } else if (sameNamedColumns.v.Count > 1) {
                                    // more than one column, so lets make a unique column for each type used
                                    $t = Bridge.getEnumerator(sameNamedColumns.v);
                                    try {
                                        while ($t.moveNext()) {
                                            var colType = $t.Current;
                                            var name = uniqueNames.GetOrAddName((col.Name || "") + "_" + (colType.Name || ""));
                                            newColumns.add(new Kusto.Language.Symbols.ColumnSymbol(name, colType));
                                        }
                                    } finally {
                                        if (Bridge.is($t, System.IDisposable)) {
                                            $t.System$IDisposable$Dispose();
                                        }
                                    }
                                }

                                // we've already handled this name, remove it so we don't try adding it again
                                map.remove(col.Name);
                            }
                        }

                        // copy new list back to original
                        columns.clear();
                        columns.AddRange(newColumns);
                    } finally {
                        Kusto.Language.Binding.Binder.s_uniqueNameTablePool.ReturnToPool(uniqueNames);
                        Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(newColumns);
                    }
                },
                /**
                 * Converts list of columns to a list of columns with distinct names.
                 If multiple columns have the same name, but differ in type, the resulting single columns has the type dynamic.
                 *
                 * @static
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.List$1}    columns
                 * @return  {void}
                 */
                UnifyColumnsWithSameName: function (columns) {
                    var newColumns = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                    try {
                        var map = Kusto.Language.Binding.Binder.BuildColumnNameMap(columns);

                        // go through original column order and build out new column list
                        for (var i = 0; i < columns.Count; i = (i + 1) | 0) {
                            var col = columns.getItem(i);
                            var sameNamedColumns = { };

                            if (map.tryGetValue(col.Name, sameNamedColumns)) {
                                if (sameNamedColumns.v.Count === 1) {
                                    // exactly one column with this name (and type)
                                    newColumns.add(col);
                                } else if (sameNamedColumns.v.Count > 1) {
                                    // multiple columns with same name, add a single one that uses a common type.
                                    var types = sameNamedColumns.v.ToArray();
                                    var commonType = Kusto.Language.Binding.Binder.GetCommonScalarType(types);

                                    if (commonType == null) {
                                        commonType = Kusto.Language.Symbols.ScalarTypes.Dynamic;
                                    }

                                    if (Bridge.referenceEquals(col.Type, commonType)) {
                                        newColumns.add(col);
                                    } else {
                                        newColumns.add(new Kusto.Language.Symbols.ColumnSymbol(col.Name, commonType));
                                    }
                                }

                                // we've already handled this name, so remove it so we don't add it again
                                map.remove(col.Name);
                            }
                        }

                        // copy new list back to original
                        columns.clear();
                        columns.AddRange(newColumns);
                    } finally {
                        Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(newColumns);
                    }
                },
                /**
                 * Converts a list of columns into a list of unique columns by name.
                 Columns with the same name will be renamed to include a numeric suffix.
                 *
                 * @static
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.List$1}    columns
                 * @return  {void}
                 */
                MakeColumnNamesUnique: function (columns) {
                    var names = Kusto.Language.Binding.Binder.s_uniqueNameTablePool.AllocateFromPool();
                    var newColumns = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                    try {
                        // go through original column order and build out new column list
                        for (var i = 0; i < columns.Count; i = (i + 1) | 0) {
                            var col = columns.getItem(i);
                            newColumns.add(Kusto.Language.Binding.Binder.GetUniqueColumn(col, names));
                        }

                        // copy new list back to original
                        columns.clear();
                        columns.AddRange(newColumns);
                    } finally {
                        Kusto.Language.Binding.Binder.s_uniqueNameTablePool.ReturnToPool(names);
                        Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(newColumns);
                    }
                },
                /**
                 * Builds a map between names and columns with that name.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.List$1}          columns
                 * @return  {System.Collections.Generic.Dictionary$2}
                 */
                BuildColumnNameMap: function (columns) {
                    var map = new (System.Collections.Generic.Dictionary$2(System.String,System.Collections.Generic.List$1(Kusto.Language.Symbols.TypeSymbol))).ctor();

                    // build up a map between column names and types.
                    for (var i = 0; i < columns.Count; i = (i + 1) | 0) {
                        var col = columns.getItem(i);
                        var sameNameColumns = { };
                        if (!map.tryGetValue(col.Name, sameNameColumns)) {
                            sameNameColumns.v = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.TypeSymbol)).ctor();
                            map.add(col.Name, sameNameColumns.v);
                        }

                        if (!sameNameColumns.v.contains(col.Type)) {
                            sameNameColumns.v.add(col.Type);
                        }
                    }

                    return map;
                },
                /**
                 * Gets the columns that appear in both list of columns (by name)
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    columnsA    
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    columnsB    
                 * @param   {System.Collections.Generic.List$1}             result
                 * @return  {void}
                 */
                GetCommonColumns$2: function (columnsA, columnsB, result) {
                    var $t;
                    var columns = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                    try {
                        Kusto.Language.Binding.Binder.GetCommonColumns$1(columnsA, columnsB, columns);

                        $t = Bridge.getEnumerator(columns);
                        try {
                            while ($t.moveNext()) {
                                var c = $t.Current;
                                result.add(c);
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    } finally {
                        Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(columns);
                    }
                },
                /**
                 * Gets the columns that appear in both list of columns (by name)
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    columnsA    
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    columnsB    
                 * @param   {System.Collections.Generic.List$1}             result
                 * @return  {void}
                 */
                GetCommonColumns$1: function (columnsA, columnsB, result) {
                    var $t, $t1;
                    var names = Kusto.Language.Binding.Binder.s_stringSetPool.AllocateFromPool();
                    try {
                        $t = Bridge.getEnumerator(columnsB, Kusto.Language.Symbols.ColumnSymbol);
                        try {
                            while ($t.moveNext()) {
                                var c = $t.Current;
                                names.add(c.Name);
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }

                        $t1 = Bridge.getEnumerator(columnsA, Kusto.Language.Symbols.ColumnSymbol);
                        try {
                            while ($t1.moveNext()) {
                                var c1 = $t1.Current;
                                if (names.contains(c1.Name)) {
                                    result.add(c1);
                                }
                            }
                        } finally {
                            if (Bridge.is($t1, System.IDisposable)) {
                                $t1.System$IDisposable$Dispose();
                            }
                        }
                    } finally {
                        Kusto.Language.Binding.Binder.s_stringSetPool.ReturnToPool(names);
                    }
                },
                /**
                 * Gets the columns that appear in all tables.
                 *
                 * @static
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    tables    
                 * @param   {System.Collections.Generic.List$1}             common
                 * @return  {void}
                 */
                GetCommonColumns: function (tables, common) {
                    common.clear();

                    if (System.Array.getCount(tables, Kusto.Language.Symbols.TableSymbol) === 1) {
                        common.AddRange(System.Array.getItem(tables, 0, Kusto.Language.Symbols.TableSymbol).Columns);
                    } else if (System.Array.getCount(tables, Kusto.Language.Symbols.TableSymbol) === 2) {
                        Kusto.Language.Binding.Binder.GetCommonColumns$1(System.Array.getItem(tables, 0, Kusto.Language.Symbols.TableSymbol).Columns, System.Array.getItem(tables, 1, Kusto.Language.Symbols.TableSymbol).Columns, common);
                    } else if (System.Array.getCount(tables, Kusto.Language.Symbols.TableSymbol) > 2) {
                        var columnsA = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                        var columnsC = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                        try {
                            Kusto.Language.Binding.Binder.GetCommonColumns$1(System.Array.getItem(tables, 0, Kusto.Language.Symbols.TableSymbol).Columns, System.Array.getItem(tables, 1, Kusto.Language.Symbols.TableSymbol).Columns, columnsA);

                            for (var i = 2; i < System.Array.getCount(tables, Kusto.Language.Symbols.TableSymbol); i = (i + 1) | 0) {
                                Kusto.Language.Binding.Binder.GetCommonColumns$1(columnsA, System.Array.getItem(tables, i, Kusto.Language.Symbols.TableSymbol).Columns, columnsC);

                                if (i < ((System.Array.getCount(tables, Kusto.Language.Symbols.TableSymbol) - 1) | 0)) {
                                    columnsA.clear();
                                    columnsA.AddRange(columnsC);
                                    columnsC.clear();
                                }
                            }

                            common.AddRange(columnsC);
                        } finally {
                            Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(columnsA);
                            Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(columnsC);
                        }
                    }
                },
                /**
                 * Gets a column with a unique name (given a set of already used names).
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Symbols.ColumnSymbol}     column         
                 * @param   {Kusto.Language.Utils.UniqueNameTable}    uniqueNames
                 * @return  {Kusto.Language.Symbols.ColumnSymbol}
                 */
                GetUniqueColumn: function (column, uniqueNames) {
                    var uniqueName = uniqueNames.GetOrAddName(column.Name);
                    if (!Bridge.referenceEquals(uniqueName, column.Name)) {
                        return new Kusto.Language.Symbols.ColumnSymbol(uniqueName, column.Type);
                    } else {
                        return column;
                    }
                },
                /**
                 * Creates column symbols for all the columns declared in the schema.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.SchemaTypeExpression}    schema           
                 * @param   {System.Collections.Generic.List$1}             columns          
                 * @param   {System.Collections.Generic.HashSet$1}          declaredNames    
                 * @param   {System.Collections.Generic.List$1}             diagnostics
                 * @return  {void}
                 */
                CreateColumnsFromSchema$1: function (schema, columns, declaredNames, diagnostics) {
                    for (var i = 0, n = schema.Columns.Count; i < n; i = (i + 1) | 0) {
                        var expr = schema.Columns.getItem$1(i).Element$1;
                        do {
                            if (Bridge.is(expr, Kusto.Language.Syntax.NameAndTypeDeclaration)) {
                                var nat = Bridge.cast(expr, Kusto.Language.Syntax.NameAndTypeDeclaration);
                                Kusto.Language.Binding.Binder.CreateColumnsFromSchema(nat, columns, declaredNames, diagnostics);
                                break;
                            }

                            if (Bridge.is(expr, Kusto.Language.Syntax.StarExpression)) {
                                var _discard1 = Bridge.cast(expr, Kusto.Language.Syntax.StarExpression);
                                // not sure what this means here yet.
                                break;
                            }
                        } while (false);
                    }
                },
                /**
                 * Creates a column symbol for the column declared by the {@link }
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Binding.Binder
                 * @memberof Kusto.Language.Binding.Binder
                 * @param   {Kusto.Language.Syntax.NameAndTypeDeclaration}    declaration      
                 * @param   {System.Collections.Generic.List$1}               columns          
                 * @param   {System.Collections.Generic.HashSet$1}            declaredNames    
                 * @param   {System.Collections.Generic.List$1}               diagnostics
                 * @return  {void}
                 */
                CreateColumnsFromSchema: function (declaration, columns, declaredNames, diagnostics) {
                    var $t;
                    var name = declaration.Name.SimpleName;
                    do {
                        ($t = declaration.Type);
                        if (Bridge.is($t, Kusto.Language.Syntax.PrimitiveTypeExpression)) {
                            var p = Bridge.cast($t, Kusto.Language.Syntax.PrimitiveTypeExpression);
                            var type = Kusto.Language.Binding.Binder.GetType(p); // diagnostics should already have been added
                            if (Kusto.Language.Binding.Binder.DeclareColumnName(declaredNames, name, diagnostics, declaration.Name)) {
                                columns.add(new Kusto.Language.Symbols.ColumnSymbol(name, type));
                            }

                            break;
                        }

                        if (Bridge.is($t, Kusto.Language.Syntax.SchemaTypeExpression)) {
                            var s = Bridge.cast($t, Kusto.Language.Syntax.SchemaTypeExpression);
                            var subSchemaColumns = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                            var subSchemaNames = Kusto.Language.Binding.Binder.s_stringSetPool.AllocateFromPool();
                            try {
                                Kusto.Language.Binding.Binder.CreateColumnsFromSchema$1(s, subSchemaColumns, subSchemaNames, diagnostics);
                                if (Kusto.Language.Binding.Binder.DeclareColumnName(declaredNames, name, diagnostics, declaration.Name)) {
                                    columns.add(new Kusto.Language.Symbols.ColumnSymbol(name, new Kusto.Language.Symbols.TableSymbol.$ctor3(subSchemaColumns)));
                                }
                            } finally {
                                Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(subSchemaColumns);
                                Kusto.Language.Binding.Binder.s_stringSetPool.ReturnToPool(subSchemaNames);
                            }

                            break;
                        }

                        {
                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetInvalidColumnDeclaration().WithLocation(declaration));
                            break;
                        }
                    } while (false);
                }
            }
        },
        fields: {
            /**
             * Global state including symbols declared in ambient database.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.GlobalState
             */
            _globals: null,
            /**
             * Keeps track of the number of dynamic nodes in the current traversal.
             Used to check if the current node is a child of a dynamic node.
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @default 0
             * @type number
             */
            _dynamicDepth: 0,
            /**
             * The cluster assumed when resolveing unqualified calls to database()
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Symbols.ClusterSymbol
             */
            _currentCluster: null,
            /**
             * The database assumed when resolving unqualified references table/function names or calls to table()
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Symbols.DatabaseSymbol
             */
            _currentDatabase: null,
            /**
             * The function being declared.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Symbols.FunctionSymbol
             */
            _currentFunction: null,
            /**
             * All symbol declared locally within the query appear in the local scope.
             These are symbols declared by let statements or the as query operator.
             Local scopes may be nested within other local scopes.
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Binding.LocalScope
             */
            _localScope: null,
            /**
             * Columns accessible in piped query operators
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Symbols.TableSymbol
             */
            _rowScope: null,
            /**
             * Columns accessible from right side of join operator
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Symbols.TableSymbol
             */
            _rightRowScope: null,
            /**
             * Members accessible from left side of path/element expression
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Symbols.Symbol
             */
            _pathScope: null,
            /**
             * Implicit argument type used for invoke binding.
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Symbols.TypeSymbol
             */
            _implicitArgumentType: null,
            /**
             * The kind of scope in effect.
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Binding.ScopeKind
             */
            _scopeKind: 0,
            /**
             * Any aliased databases.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type System.Collections.Generic.Dictionary$2
             */
            _aliasedDatabases: null,
            /**
             * Binding state that is shared across many binders/bindings
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Binding.GlobalBindingCache
             */
            _globalBindingCache: null,
            /**
             * Binding state that is private to one binding (including analysis of called function bodies)
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Binding.LocalBindingCache
             */
            _localBindingCache: null,
            /**
             * An optional function that assigns {@link } to a {@link }
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type System.Action
             */
            _semanticInfoSetter: null,
            /**
             * An optional {@link } specified for use during binding.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.Binder
             * @type Kusto.Language.Utils.CancellationToken
             */
            _cancellationToken: null,
            /**
             * The set of open cluster symbols so far.
             This set is accumulated as the binder processes the query in lexical order.
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type System.Collections.Generic.Dictionary$2
             */
            _openClusters: null,
            /**
             * A map between an open cluster symbol and the set of inferred open databases so far.
             This set is accumulated as the binder processes the query in lexical order.
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type System.Collections.Generic.Dictionary$2
             */
            _openDatabases: null,
            /**
             * A map between an open database symbol and the set of inferred open tables identified so far.
             This set is accumulated as the binder processes the query in lexical order.
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type System.Collections.Generic.Dictionary$2
             */
            _openTables: null,
            /**
             * A map between an open table and the set of inferred columns (so far)
             This set is accumulated as the binder processes the query in lexical order.
             *
             * @instance
             * @private
             * @memberof Kusto.Language.Binding.Binder
             * @type System.Collections.Generic.Dictionary$2
             */
            _openTableInferredColumns: null,
            _tupleMap: null,
            _defaultColumnNameSuffix: 0
        },
        props: {
            RowScopeOrEmpty: {
                get: function () {
                    return this._rowScope || Kusto.Language.Symbols.TableSymbol.Empty;
                }
            },
            RightRowScopeOrEmpty: {
                get: function () {
                    return this._rightRowScope || Kusto.Language.Symbols.TableSymbol.Empty;
                }
            }
        },
        ctors: {
            init: function () {
                this._cancellationToken = new Kusto.Language.Utils.CancellationToken();
                this._dynamicDepth = 0;
                this._aliasedDatabases = new (System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.DatabaseSymbol)).ctor();
                this._defaultColumnNameSuffix = 1;
            },
            ctor: function (globals, currentCluster, currentDatabase, currentFunction, outerScope, globalBindingCache, localBindingCache, semanticInfoSetter, cancellationToken) {
                this.$initialize();
                this._globals = globals;
                this._currentCluster = currentCluster || globals.Cluster;
                this._currentDatabase = currentDatabase || globals.Database;
                this._currentFunction = currentFunction;
                this._globalBindingCache = globalBindingCache || new Kusto.Language.Binding.GlobalBindingCache();
                this._localBindingCache = localBindingCache || new Kusto.Language.Binding.LocalBindingCache();
                this._localScope = new Kusto.Language.Binding.LocalScope.ctor(outerScope);
                this._semanticInfoSetter = semanticInfoSetter || Kusto.Language.Binding.Binder.DefaultSetSemanticInfo;
                this._cancellationToken = cancellationToken;
            }
        },
        methods: {
            /**
             * Adds the symbols to the current local scope.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IEnumerable$1}    locals
             * @return  {void}
             */
            SetLocals: function (locals) {
                var $t;
                $t = Bridge.getEnumerator(locals, Kusto.Language.Symbols.Symbol);
                try {
                    while ($t.moveNext()) {
                        var local = $t.Current;
                        this._localScope.AddSymbol(local);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            /**
             * Sets the context of the binder to the specified node and text position.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.SyntaxNode}    contextNode    
             * @param   {number}                              position
             * @return  {void}
             */
            SetContext: function (contextNode, position) {
                if (position === void 0) { position = -1; }
                // note: assumes this API is only called at most once after constructor.
                if (contextNode != null) {
                    var builder = new Kusto.Language.Binding.Binder.ContextBuilder(this, position >= 0 ? position : contextNode.TextStart);
                    contextNode.Accept$1(builder);
                }
            },
            GetSymbolsInContext: function (contextNode, match, include, list) {
                var $t;
                var g;
                if (((g = Bridge.as(this._pathScope, Kusto.Language.Symbols.GroupSymbol))) != null && Kusto.Language.Binding.Binder.IsPassThrough(g)) {
                    var savePathScope = this._pathScope;
                    $t = Bridge.getEnumerator(g.Members, Kusto.Language.Symbols.Symbol);
                    try {
                        while ($t.moveNext()) {
                            var s = $t.Current;
                            this._pathScope = s;
                            this.GetSymbolsInContext(contextNode, match, include, list);
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                    this._pathScope = savePathScope;
                } else if (this._pathScope != null) {
                    // so far only columns, tables and functions can be dot accessed.
                    var memberMatch = match & (11);

                    // table.column only works in commands
                    if (Bridge.is(this._pathScope, Kusto.Language.Symbols.TableSymbol) && !Kusto.Language.Binding.Binder.IsInsideControlCommandProper(contextNode)) {
                        memberMatch &= -2;
                    }

                    // any columns or tables from left-hand side?
                    if ((memberMatch & Kusto.Language.Symbols.SymbolMatch.Column) !== 0) {
                        var table;
                        if (((table = Bridge.as(this._pathScope, Kusto.Language.Symbols.TableSymbol))) != null && table.IsOpen) {
                            list.AddRange(this.GetDeclaredAndInferredColumns(table));
                        } else {
                            var tuple;
                            if (((tuple = Bridge.as(this._pathScope, Kusto.Language.Symbols.TupleSymbol))) != null && tuple.RelatedTable != null && tuple.RelatedTable.IsOpen) {
                                list.AddRange(this.GetDeclaredAndInferredColumns(tuple.RelatedTable));
                            } else {
                                Kusto.Language.Binding.Binder.GetPathMembers(this._pathScope, memberMatch, list);
                            }
                        }
                    } else if (memberMatch !== 0) {
                        Kusto.Language.Binding.Binder.GetPathMembers(this._pathScope, memberMatch, list);
                    }

                    // any special functions from left-hand side?
                    if ((match & Kusto.Language.Symbols.SymbolMatch.Function) !== 0) {
                        this.GetSpecialFunctions(null, list);
                    }
                } else {
                    switch (this._scopeKind) {
                        case Kusto.Language.Binding.ScopeKind.Normal: 
                            // row scope columns
                            if (this._rowScope != null && (match & Kusto.Language.Symbols.SymbolMatch.Column) !== 0) {
                                if (this._rightRowScope != null) {
                                    // add $left and $right variables
                                    list.add(new Kusto.Language.Symbols.VariableSymbol("$left", this.GetTuple(this._rowScope)));
                                    list.add(new Kusto.Language.Symbols.VariableSymbol("$right", this.GetTuple(this._rightRowScope)));

                                    // common columns
                                    Kusto.Language.Binding.Binder.GetCommonColumns$2(this.GetDeclaredAndInferredColumns(this._rowScope), this.GetDeclaredAndInferredColumns(this._rightRowScope), list);
                                } else {
                                    this._rowScope.GetMembers(match, list);
                                }
                            }
                            var localMatch = match;
                            if ((include & Kusto.Language.IncludeFunctionKind.LocalFunctions) === 0) {
                                localMatch &= -9;
                            }
                            // local symbols
                            this._localScope.GetSymbols(localMatch, list);
                            // get any built-in functions
                            if ((match & Kusto.Language.Symbols.SymbolMatch.Function) !== 0 && (include & Kusto.Language.IncludeFunctionKind.BuiltInFunctions) !== 0) {
                                this.GetFunctionsInScope$1(match, null, Kusto.Language.IncludeFunctionKind.BuiltInFunctions, list);
                            }
                            // metadata symbols (tables, etc)
                            if (this._currentDatabase != null) {
                                var dbMatch = match;

                                if ((include & Kusto.Language.IncludeFunctionKind.DatabaseFunctions) === 0) {
                                    dbMatch &= -9;
                                }

                                this._currentDatabase.GetMembers(dbMatch, list);
                            }
                            if ((match & Kusto.Language.Symbols.SymbolMatch.Database) !== 0) {
                                this._currentCluster.GetMembers(match, list);
                            }
                            if ((match & Kusto.Language.Symbols.SymbolMatch.Cluster) !== 0) {
                                list.AddRange(this._globals.Clusters);
                            }
                            break;
                        case Kusto.Language.Binding.ScopeKind.Aggregate: 
                            if ((match & Kusto.Language.Symbols.SymbolMatch.Function) !== 0) {
                                this.GetFunctionsInScope$1(match, null, include, list);
                            }
                            break;
                        case Kusto.Language.Binding.ScopeKind.PlugIn: 
                            if ((match & Kusto.Language.Symbols.SymbolMatch.Function) !== 0) {
                                this.GetFunctionsInScope$1(match, null, include, list);
                            }
                            break;
                        case Kusto.Language.Binding.ScopeKind.Option: 
                            if ((match & Kusto.Language.Symbols.SymbolMatch.Option) !== 0) {
                                list.AddRange(this._globals.Options);
                            }
                            break;
                    }
                }
            },
            GetSpecialFunctions: function (name, functions) {
                if (this._pathScope != null) {
                    var g;
                    if (((g = Bridge.as(this._pathScope, Kusto.Language.Symbols.GroupSymbol))) != null && System.Array.getCount(g.Members, Kusto.Language.Symbols.Symbol) > 0 && Kusto.Language.Binding.Binder.IsPassThrough(g)) {
                        // use info for first symbol in group
                        var savePathScope = this._pathScope;
                        this._pathScope = System.Array.getItem(g.Members, 0, Kusto.Language.Symbols.Symbol);
                        this.GetSpecialFunctions(name, functions);
                        this._pathScope = savePathScope;
                    } else {
                        // these special methods show up as dottable methods on their respective types
                        switch (this._pathScope.Kind) {
                            case Kusto.Language.Symbols.SymbolKind.Cluster: 
                                if (name == null || Bridge.referenceEquals(Kusto.Language.Functions.Database.Name, name)) {
                                    functions.add(Kusto.Language.Functions.Database);
                                }
                                break;
                            case Kusto.Language.Symbols.SymbolKind.Database: 
                                if (name == null || Bridge.referenceEquals(Kusto.Language.Functions.Database.Name, name)) {
                                    functions.add(Kusto.Language.Functions.Table);
                                    functions.add(Kusto.Language.Functions.ExternalTable);
                                    functions.add(Kusto.Language.Functions.MaterializedView);
                                }
                                break;
                        }
                    }
                }
            },
            GetFunctionsInScope$1: function (match, name, include, functions) {
                var $t;
                var allFunctions = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                try {
                    this.GetFunctionsInScope(this._scopeKind, name, include, allFunctions);

                    $t = Bridge.getEnumerator(allFunctions);
                    try {
                        while ($t.moveNext()) {
                            var fn = $t.Current;
                            if (Kusto.Language.Symbols.SymbolMatchExtensions.Matches(fn, match)) {
                                functions.add(fn);
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(allFunctions);
                }
            },
            GetFunctionsInScope: function (kind, name, include, functions) {
                if (this._pathScope != null) {
                    this.GetSpecialFunctions(name, functions);
                } else {
                    switch (kind) {
                        case Kusto.Language.Binding.ScopeKind.Aggregate: 
                            if (name == null) {
                                if ((include & Kusto.Language.IncludeFunctionKind.BuiltInFunctions) !== 0) {
                                    functions.AddRange(this._globals.Aggregates);
                                }

                                this.GetFunctionsInScope(Kusto.Language.Binding.ScopeKind.Normal, name, include, functions);
                            } else {
                                if ((include & Kusto.Language.IncludeFunctionKind.BuiltInFunctions) !== 0) {
                                    var fn = this._globals.GetAggregate(name);
                                    if (fn != null) {
                                        functions.add(fn);
                                    }
                                }

                                if (functions.Count === 0) {
                                    this.GetFunctionsInScope(Kusto.Language.Binding.ScopeKind.Normal, name, include, functions);
                                }
                            }
                            break;
                        case Kusto.Language.Binding.ScopeKind.PlugIn: 
                            if ((include & Kusto.Language.IncludeFunctionKind.BuiltInFunctions) !== 0) {
                                if (name == null) {
                                    functions.AddRange(this._globals.PlugIns);
                                } else {
                                    var fn1 = this._globals.GetPlugIn(name);
                                    if (fn1 != null) {
                                        functions.add(fn1);
                                    }
                                }
                            }
                            break;
                        default: 
                            if ((include & Kusto.Language.IncludeFunctionKind.BuiltInFunctions) !== 0) {
                                if (name == null) {
                                    functions.AddRange(this._globals.Functions);
                                } else if (functions.Count === 0) {
                                    var fn2 = this._globals.GetFunction(name);
                                    if (fn2 != null) {
                                        functions.add(fn2);
                                    }
                                }
                            }
                            if ((name == null || functions.Count === 0) && (include & Kusto.Language.IncludeFunctionKind.LocalFunctions) !== 0) {
                                this.GetLocalFunctionsInScope(name, functions);
                            }
                            if ((name == null || functions.Count === 0) && (include & Kusto.Language.IncludeFunctionKind.DatabaseFunctions) !== 0 && this._currentDatabase != null) {
                                this._currentDatabase.GetMembers$1(name, Kusto.Language.Symbols.SymbolMatch.Function, functions);
                            }
                            break;
                    }
                }
            },
            GetLocalFunctionsInScope: function (name, functions) {
                var $t;
                var locals = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                try {
                    this._localScope.GetSymbols$1(name, 24, locals);

                    $t = Bridge.getEnumerator(locals);
                    try {
                        while ($t.moveNext()) {
                            var local = $t.Current;
                            var fs;
                            if (((fs = Bridge.as(local, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                                functions.add(fs);
                            } else {
                                var ps;
                                if (((ps = Bridge.as(local, Kusto.Language.Symbols.PatternSymbol))) != null) {
                                    functions.add(ps);
                                } else {
                                    var vs;
                                    if (((vs = Bridge.as(local, Kusto.Language.Symbols.VariableSymbol))) != null) {
                                        var resultType = Kusto.Language.Binding.Binder.GetResultType(local);
                                        var lfs;
                                        if (((lfs = Bridge.as(resultType, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                                            functions.add(lfs);
                                        } else {
                                            var lps;
                                            if (((lps = Bridge.as(resultType, Kusto.Language.Symbols.PatternSymbol))) != null) {
                                                functions.add(lps);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(locals);
                }
            },
            /**
             * Binds a function call or pattern invocation expression
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.FunctionCallExpression}    functionCall
             * @return  {Kusto.Language.Binding.SemanticInfo}
             */
            BindFunctionCallOrPattern: function (functionCall) {
                // the result type of the name should be bound to the function/pattern
                var symbol = this.GetResultTypeOrError(functionCall.Name);
                var fn;
                if (((fn = Bridge.as(symbol, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                    return this.BindFunctionCall(functionCall, fn);
                } else {
                    var ps;
                    if (((ps = Bridge.as(symbol, Kusto.Language.Symbols.PatternSymbol))) != null) {
                        return this.BindPattern(functionCall, ps);
                    } else if (!symbol.IsError) {
                        // the name was not a known function or pattern, but we decided to give it a result type, so let's use it
                        return functionCall.Name.GetSemanticInfo();
                    } else if (Kusto.Language.Binding.Binder.IsFuzzyUnionOperand(functionCall)) {
                        return new Kusto.Language.Binding.SemanticInfo.$ctor4(new Kusto.Language.Symbols.TableSymbol.ctor().WithIsOpen(true), Kusto.Language.DiagnosticFacts.GetFuzzyUnionOperandNotDefined(functionCall.Name.SimpleName).WithLocation(functionCall));
                    } else {
                        return null;
                    }
                }
            },
            /**
             * Binds a function call
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.FunctionCallExpression}    functionCall    
             * @param   {Kusto.Language.Symbols.FunctionSymbol}           fn
             * @return  {Kusto.Language.Binding.SemanticInfo}
             */
            BindFunctionCall: function (functionCall, fn) {
                var diagnostics = Kusto.Language.Binding.Binder.s_diagnosticListPool.AllocateFromPool();
                var $arguments = Kusto.Language.Binding.Binder.s_expressionListPool.AllocateFromPool();
                var argumentTypes = Kusto.Language.Binding.Binder.s_typeListPool.AllocateFromPool();
                var matchingSignatures = Kusto.Language.Binding.Binder.s_signatureListPool.AllocateFromPool();

                try {
                    this.GetArgumentsAndTypes(functionCall, $arguments, argumentTypes);

                    this.GetBestMatchingSignatures(fn.Signatures, $arguments, argumentTypes, matchingSignatures);

                    if (matchingSignatures.Count === 1) {
                        this.CheckSignature(matchingSignatures.getItem(0), $arguments, argumentTypes, functionCall.Name, diagnostics);
                        var funResult = this.GetFunctionCallResult$1(matchingSignatures.getItem(0), $arguments, argumentTypes, diagnostics);
                        return new Kusto.Language.Binding.SemanticInfo.$ctor1(matchingSignatures.getItem(0), funResult.Type, diagnostics, fn.IsConstantFoldable && this.AllAreConstant($arguments), funResult.Info);
                    } else {
                        if ($arguments.Count === 0 && fn.MinArgumentCount > 0) {
                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetFunctionExpectsArgumentCountRange(fn.Name, fn.MinArgumentCount, fn.MaxArgumentCount).WithLocation(functionCall.Name));
                        } else if (!Kusto.Language.Binding.Binder.ArgumentsHaveErrorsOrUnknown(argumentTypes)) {
                            var types = System.Linq.Enumerable.from($arguments, Kusto.Language.Syntax.Expression).select(Bridge.fn.bind(this, function (e) {
                                    return this.GetResultTypeOrError(e);
                                })).toList(Kusto.Language.Symbols.TypeSymbol);
                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetFunctionNotDefinedWithMatchingParameters(functionCall.Name.SimpleName, types).WithLocation(functionCall.Name));
                        }

                        var returnType = this.GetCommonReturnType(matchingSignatures, $arguments, argumentTypes);

                        return new Kusto.Language.Binding.SemanticInfo.$ctor3(fn, returnType, diagnostics, fn.IsConstantFoldable && this.AllAreConstant($arguments), void 0);
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_diagnosticListPool.ReturnToPool(diagnostics);
                    Kusto.Language.Binding.Binder.s_expressionListPool.ReturnToPool($arguments);
                    Kusto.Language.Binding.Binder.s_typeListPool.ReturnToPool(argumentTypes);
                    Kusto.Language.Binding.Binder.s_signatureListPool.ReturnToPool(matchingSignatures);
                }
            },
            /**
             * Binds a pattern
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.FunctionCallExpression}    functionCall    
             * @param   {Kusto.Language.Symbols.PatternSymbol}            pattern
             * @return  {Kusto.Language.Binding.SemanticInfo}
             */
            BindPattern: function (functionCall, pattern) {
                var diagnostics = Kusto.Language.Binding.Binder.s_diagnosticListPool.AllocateFromPool();
                var matchingSignatures = Kusto.Language.Binding.Binder.s_patternListPool.AllocateFromPool();
                var $arguments = Kusto.Language.Binding.Binder.s_expressionListPool.AllocateFromPool();
                try {
                    // check argument count
                    if (System.Array.getCount(pattern.Parameters, Kusto.Language.Symbols.Parameter) !== functionCall.ArgumentList.Expressions.Count) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetArgumentCountExpected(System.Array.getCount(pattern.Parameters, Kusto.Language.Symbols.Parameter)).WithLocation(functionCall.Name));
                    }

                    // check actual arguments
                    for (var i = 0, n = functionCall.ArgumentList.Expressions.Count; i < n; i = (i + 1) | 0) {
                        var argument = functionCall.ArgumentList.Expressions.getItem$1(i).Element$1;
                        $arguments.add(argument);

                        if (i < System.Array.getCount(pattern.Parameters, Kusto.Language.Symbols.Parameter)) {
                            var type = System.Array.getItem(System.Array.getItem(pattern.Parameters, i, Kusto.Language.Symbols.Parameter).DeclaredTypes, 0, Kusto.Language.Symbols.TypeSymbol);
                            if (this.CheckIsExactType(argument, type, diagnostics)) {
                                this.CheckIsLiteral(argument, diagnostics);
                            }
                        }
                    }

                    this.GetMatchingPatterns(pattern.Signatures, $arguments, matchingSignatures);

                    if (matchingSignatures.Count === 0) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetNoPatternMatchesArguments().WithLocation(functionCall.Name));
                        return new Kusto.Language.Binding.SemanticInfo.$ctor3(pattern, Kusto.Language.Symbols.ErrorSymbol.Instance, diagnostics);
                    } else {
                        var result = this.GetPatternReturnType(matchingSignatures);
                        return new Kusto.Language.Binding.SemanticInfo.$ctor3(pattern, result, diagnostics);
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_diagnosticListPool.ReturnToPool(diagnostics);
                    Kusto.Language.Binding.Binder.s_patternListPool.ReturnToPool(matchingSignatures);
                    Kusto.Language.Binding.Binder.s_expressionListPool.ReturnToPool($arguments);
                }
            },
            /**
             * Gets the set of pattern signatures that match the arguments.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IReadOnlyList$1}    signatures            
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
             * @param   {System.Collections.Generic.List$1}             matchingSignatures
             * @return  {void}
             */
            GetMatchingPatterns: function (signatures, $arguments, matchingSignatures) {
                var $t, $t1;
                // look for exact match
                $t = Bridge.getEnumerator(signatures, Kusto.Language.Symbols.PatternSignature);
                try {
                    while ($t.moveNext()) {
                        var sig = $t.Current;
                        if (this.PatternMatches(sig, $arguments, true)) {
                            matchingSignatures.add(sig);
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                // if no exact matches, look for partial matches
                if (matchingSignatures.Count === 0) {
                    $t1 = Bridge.getEnumerator(signatures, Kusto.Language.Symbols.PatternSignature);
                    try {
                        while ($t1.moveNext()) {
                            var sig1 = $t1.Current;
                            if (this.PatternMatches(sig1, $arguments, false)) {
                                matchingSignatures.add(sig1);
                            }
                        }
                    } finally {
                        if (Bridge.is($t1, System.IDisposable)) {
                            $t1.System$IDisposable$Dispose();
                        }
                    }
                }
            },
            /**
             * Determines if the pattern signature matches the arguments.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.PatternSignature}       signature    
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments    
             * @param   {boolean}                                       exact
             * @return  {boolean}
             */
            PatternMatches: function (signature, $arguments, exact) {
                var $t, $t1;
                if (exact && System.Array.getCount(signature.ArgumentValues, System.String) !== System.Array.getCount($arguments, Kusto.Language.Syntax.Expression)) {
                    return false;
                }

                for (var i = 0; i < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression); i = (i + 1) | 0) {
                    if (i < System.Array.getCount(signature.ArgumentValues, System.String)) {
                        var matchValue = System.Array.getItem(signature.ArgumentValues, i, System.String);
                        var argValue = ($t = (($t1 = System.Array.getItem($arguments, i, Kusto.Language.Syntax.Expression).LiteralValue) != null ? Bridge.toString($t1) : null), $t != null ? $t : "");
                        if (!Bridge.referenceEquals(matchValue, argValue)) {
                            return false;
                        }
                    }
                }

                return true;
            },
            /**
             * Gets the return type of the set of pattern signatures.
             The return type is either the type of the signature body if there is no path,
             or a database symbol containing variables named for each path.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IReadOnlyList$1}    signatures
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetPatternReturnType: function (signatures) {
                var $t;
                if (System.Array.getCount(signatures, Kusto.Language.Symbols.PatternSignature) === 1 && System.Array.getItem(signatures, 0, Kusto.Language.Symbols.PatternSignature).PathValue == null) {
                    return System.Array.getItem(signatures, 0, Kusto.Language.Symbols.PatternSignature).Signature.GetReturnType(this._globals);
                }

                var paths = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                var types = Kusto.Language.Binding.Binder.s_typeListPool.AllocateFromPool();
                try {
                    $t = Bridge.getEnumerator(signatures, Kusto.Language.Symbols.PatternSignature);
                    try {
                        while ($t.moveNext()) {
                            var sig = $t.Current;
                            var type = sig.Signature.GetReturnType(this._globals);

                            if (sig.PathValue == null) {
                                if (!types.contains(type)) {
                                    types.add(type);
                                }
                            } else {
                                paths.add(new Kusto.Language.Symbols.VariableSymbol(Bridge.toString(sig.PathValue), type));
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    if (paths.Count > 0) {
                        if (types.Count > 0) {
                            // this should not happen, but in case it does
                            return new Kusto.Language.Symbols.GroupSymbol.$ctor1(System.Linq.Enumerable.from(paths, Kusto.Language.Symbols.Symbol).concat(types));
                        } else {
                            return new Kusto.Language.Symbols.GroupSymbol.$ctor1(paths);
                        }
                    } else if (types.Count === 1) {
                        return types.getItem(0);
                    } else {
                        return new Kusto.Language.Symbols.GroupSymbol.$ctor1(types);
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(paths);
                    Kusto.Language.Binding.Binder.s_typeListPool.ReturnToPool(types);
                }
            },
            /**
             * Extracts the argument expressions and their result types into two separate lists.
             Handles the special case of the implicit invoke operator argument
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.FunctionCallExpression}    functionCall     
             * @param   {System.Collections.Generic.List$1}               arguments        
             * @param   {System.Collections.Generic.List$1}               argumentTypes
             * @return  {void}
             */
            GetArgumentsAndTypes: function (functionCall, $arguments, argumentTypes) {
                var expressions = functionCall.ArgumentList.Expressions;

                for (var i = 0, n = expressions.Count; i < n; i = (i + 1) | 0) {
                    var arg = expressions.getItem$1(i).Element$1;
                    $arguments.add(arg);
                    argumentTypes.add(this.GetResultTypeOrError(arg));
                }

                if (Kusto.Language.Binding.Binder.IsInvokeOperatorFunctionCall(functionCall)) {
                    // add fake argument to represent the implicit value
                    $arguments.insert(0, functionCall.Name);
                    argumentTypes.insert(0, this._implicitArgumentType);
                }
            },
            /**
             * Gets the result information for the function call or operator invocation when invoked with the specified arguments.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}              signature        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
             * @param   {System.Collections.Generic.List$1}             diagnostics
             * @return  {Kusto.Language.Binding.FunctionCallResult}
             */
            GetFunctionCallResult$1: function (signature, $arguments, argumentTypes, diagnostics) {
                if (diagnostics === void 0) { diagnostics = null; }
                if ($arguments == null) {
                    throw new System.ArgumentNullException.$ctor1("arguments");
                }

                if (argumentTypes == null) {
                    throw new System.ArgumentNullException.$ctor1("argumentTypes");
                }

                var argumentParameters = Kusto.Language.Binding.Binder.s_parameterListPool.AllocateFromPool();
                try {
                    signature.GetArgumentParameters$2($arguments, argumentParameters);
                    return this.GetFunctionCallResult(signature, $arguments, argumentTypes, argumentParameters, diagnostics);
                } finally {
                    Kusto.Language.Binding.Binder.s_parameterListPool.ReturnToPool(argumentParameters);
                }
            },
            /**
             * Gets the result information of the function call or operator invocation when invoked with the specified arguments.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}              signature             
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes         
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentParameters    
             * @param   {System.Collections.Generic.List$1}             diagnostics
             * @return  {Kusto.Language.Binding.FunctionCallResult}
             */
            GetFunctionCallResult: function (signature, $arguments, argumentTypes, argumentParameters, diagnostics) {
                if (diagnostics === void 0) { diagnostics = null; }
                if ($arguments == null) {
                    throw new System.ArgumentNullException.$ctor1("arguments");
                }

                if (argumentTypes == null) {
                    throw new System.ArgumentNullException.$ctor1("argumentTypes");
                }

                if (argumentParameters == null) {
                    throw new System.ArgumentNullException.$ctor1("argumentParameters");
                }

                switch (signature.ReturnKind) {
                    case Kusto.Language.Symbols.ReturnTypeKind.Declared: 
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(signature.DeclaredReturnType);
                    case Kusto.Language.Symbols.ReturnTypeKind.Computed: 
                        return this.GetComputedFunctionCallResult(signature, $arguments, argumentTypes);
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0: 
                        var iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 0, Kusto.Language.Symbols.Parameter));
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(iArg >= 0 && iArg < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol) ? System.Array.getItem(argumentTypes, iArg, Kusto.Language.Symbols.TypeSymbol) : Kusto.Language.Symbols.ErrorSymbol.Instance);
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter1: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 1, Kusto.Language.Symbols.Parameter));
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(iArg >= 0 && iArg < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol) ? System.Array.getItem(argumentTypes, iArg, Kusto.Language.Symbols.TypeSymbol) : Kusto.Language.Symbols.ErrorSymbol.Instance);
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter2: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 2, Kusto.Language.Symbols.Parameter));
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(iArg >= 0 && iArg < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol) ? System.Array.getItem(argumentTypes, iArg, Kusto.Language.Symbols.TypeSymbol) : Kusto.Language.Symbols.ErrorSymbol.Instance);
                    case Kusto.Language.Symbols.ReturnTypeKind.ParameterN: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, ((System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter) - 1) | 0), Kusto.Language.Symbols.Parameter));
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(iArg >= 0 && iArg < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol) ? System.Array.getItem(argumentTypes, iArg, Kusto.Language.Symbols.TypeSymbol) : Kusto.Language.Symbols.ErrorSymbol.Instance);
                    case Kusto.Language.Symbols.ReturnTypeKind.ParameterNLiteral: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, ((System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter) - 1) | 0), Kusto.Language.Symbols.Parameter));
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(iArg >= 0 && iArg < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) ? this.GetTypeOfType(System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression)) : Kusto.Language.Symbols.ErrorSymbol.Instance);
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0Promoted: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 0, Kusto.Language.Symbols.Parameter));
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(iArg >= 0 && iArg < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol) ? Kusto.Language.Binding.Binder.Promote(System.Array.getItem(argumentTypes, iArg, Kusto.Language.Symbols.TypeSymbol)) : Kusto.Language.Symbols.ErrorSymbol.Instance);
                    case Kusto.Language.Symbols.ReturnTypeKind.Common: 
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(Kusto.Language.Binding.Binder.GetCommonArgumentType(argumentParameters, argumentTypes) || Kusto.Language.Symbols.ErrorSymbol.Instance);
                    case Kusto.Language.Symbols.ReturnTypeKind.Widest: 
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(Kusto.Language.Binding.Binder.Promote(Kusto.Language.Binding.Binder.GetWidestArgumentType(signature, argumentTypes)) || Kusto.Language.Symbols.ErrorSymbol.Instance);
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0Cluster: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 0, Kusto.Language.Symbols.Parameter));
                        {
                            var clusterName = { };
                            if (iArg >= 0 && iArg < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) && Kusto.Language.Binding.Binder.TryGetLiteralStringValue(System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), clusterName)) {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(this.GetClusterFunctionResult(clusterName.v, System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), diagnostics));
                            } else {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(new Kusto.Language.Symbols.ClusterSymbol.$ctor1("", null, true));
                            }
                        }
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0Database: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 0, Kusto.Language.Symbols.Parameter));
                        {
                            var databaseName = { };
                            if (iArg >= 0 && iArg < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) && Kusto.Language.Binding.Binder.TryGetLiteralStringValue(System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), databaseName)) {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(this.GetDatabaseFunctionResult(databaseName.v, System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), diagnostics));
                            } else {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(new Kusto.Language.Symbols.DatabaseSymbol.$ctor1("", null, true));
                            }
                        }
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0Table: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 0, Kusto.Language.Symbols.Parameter));
                        {
                            var tableName = { };
                            if (iArg >= 0 && iArg < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) && Kusto.Language.Binding.Binder.TryGetLiteralStringValue(System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), tableName)) {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(this.GetTableFunctionResult(tableName.v, System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), diagnostics));
                            } else {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(Kusto.Language.Symbols.TableSymbol.Empty.WithIsOpen(true));
                            }
                        }
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0ExternalTable: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 0, Kusto.Language.Symbols.Parameter));
                        {
                            var externalTableName = { };
                            if (iArg >= 0 && iArg < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) && Kusto.Language.Binding.Binder.TryGetLiteralStringValue(System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), externalTableName)) {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(this.GetExternalTableFunctionResult(externalTableName.v, System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), diagnostics));
                            } else {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(Kusto.Language.Symbols.TableSymbol.Empty.WithIsOpen(true));
                            }
                        }
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0MaterializedView: 
                        iArg = Kusto.Language.Utils.ListExtensions.IndexOf(Kusto.Language.Symbols.Parameter, argumentParameters, System.Array.getItem(signature.Parameters, 0, Kusto.Language.Symbols.Parameter));
                        {
                            var materializedViewName = { };
                            if (iArg >= 0 && iArg < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) && Kusto.Language.Binding.Binder.TryGetLiteralStringValue(System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), materializedViewName)) {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(this.GetMaterializedViewFunctionResult(materializedViewName.v, System.Array.getItem($arguments, iArg, Kusto.Language.Syntax.Expression), diagnostics));
                            } else {
                                return Kusto.Language.Binding.FunctionCallResult.op_Implicit(Kusto.Language.Symbols.TableSymbol.Empty.WithIsOpen(true));
                            }
                        }
                    case Kusto.Language.Symbols.ReturnTypeKind.Custom: 
                        return Kusto.Language.Binding.FunctionCallResult.op_Implicit(signature.CustomReturnType(this._rowScope || Kusto.Language.Symbols.TableSymbol.Empty, $arguments, signature) || Kusto.Language.Symbols.ErrorSymbol.Instance);
                    default: 
                        throw new System.NotImplementedException.ctor();
                }
            },
            /**
             * Gets the cluster for the specified name, or an empty open cluster.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                                  name           
             * @param   {Kusto.Language.Syntax.SyntaxNode}        location       
             * @param   {System.Collections.Generic.List$1}       diagnostics
             * @return  {Kusto.Language.Symbols.ClusterSymbol}
             */
            GetClusterFunctionResult: function (name, location, diagnostics) {
                var cluster = this._globals.GetCluster$1(name);
                if (cluster == null) {
                    if (diagnostics != null && location != null) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownCluster(name).WithLocation(location));
                    }

                    cluster = this.GetOpenCluster(name);
                }

                return cluster;
            },
            /**
             * Gets the result for an invocation of the database() function
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                               nameOrPattern    
             * @param   {Kusto.Language.Syntax.SyntaxNode}     location         
             * @param   {System.Collections.Generic.List$1}    diagnostics
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetDatabaseFunctionResult: function (nameOrPattern, location, diagnostics) {
                var db = this.GetMatchingDatabase(nameOrPattern, this._pathScope);

                if (db == null) {
                    if (diagnostics != null && location != null) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownDatabase(nameOrPattern).WithLocation(location));
                    }

                    if (!Kusto.Language.Binding.Binder.IsPattern(nameOrPattern)) {
                        // return open database regardless of container's open state to reduce cascading errors
                        if (this._pathScope == null) {
                            db = this.GetOpenDatabase(nameOrPattern, this._currentCluster);
                        } else {
                            var cluster;
                            if (((cluster = Bridge.as(this._pathScope, Kusto.Language.Symbols.ClusterSymbol))) != null) {
                                db = this.GetOpenDatabase(nameOrPattern, cluster);
                            } else {
                                var g;
                                if (((g = Bridge.as(this._pathScope, Kusto.Language.Symbols.GroupSymbol))) != null) {
                                    // use the first cluster in the group 
                                    var gc = System.Linq.Enumerable.from(g.Members).ofType(Kusto.Language.Symbols.ClusterSymbol).firstOrDefault(null, null);
                                    if (gc != null) {
                                        db = this.GetOpenDatabase(nameOrPattern, gc);
                                    }
                                }
                            }
                        }
                    }
                }

                return db;
            },
            /**
             * Gets the named database or group of databases
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                               nameOrPattern     
             * @param   {Kusto.Language.Symbols.Symbol}        clusterOrGroup
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetMatchingDatabase: function (nameOrPattern, clusterOrGroup) {
                var $t, $t1;
                if (Bridge.referenceEquals(clusterOrGroup, this._currentCluster) && System.String.compare(this._currentDatabase.Name, nameOrPattern, true) === 0) {
                    return this._currentDatabase;
                }
                var db = { };

                if (this._aliasedDatabases.tryGetValue(nameOrPattern, db)) {
                    return db.v;
                }

                var matching = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                try {
                    if (clusterOrGroup == null) {
                        Kusto.Language.Binding.Binder.GetMatchingDatabases(nameOrPattern, this._currentCluster, matching);
                    } else {
                        var cluster;
                        if (((cluster = Bridge.as(clusterOrGroup, Kusto.Language.Symbols.ClusterSymbol))) != null) {
                            Kusto.Language.Binding.Binder.GetMatchingDatabases(nameOrPattern, cluster, matching);
                        } else {
                            var group;
                            if (((group = Bridge.as(clusterOrGroup, Kusto.Language.Symbols.GroupSymbol))) != null) {
                                $t = Bridge.getEnumerator(group.Members, Kusto.Language.Symbols.Symbol);
                                try {
                                    while ($t.moveNext()) {
                                        var s = $t.Current;
                                        var c;
                                        if (((c = Bridge.as(s, Kusto.Language.Symbols.ClusterSymbol))) != null) {
                                            Kusto.Language.Binding.Binder.GetMatchingDatabases(nameOrPattern, c, matching);
                                        }
                                    }
                                } finally {
                                    if (Bridge.is($t, System.IDisposable)) {
                                        $t.System$IDisposable$Dispose();
                                    }
                                }
                            }
                        }
                    }
                    if (matching.Count === 1) {
                        return Bridge.cast(matching.getItem(0), Kusto.Language.Symbols.TypeSymbol);
                    } else if (matching.Count > 1) {
                        return new Kusto.Language.Symbols.GroupSymbol.$ctor1(matching);
                    } else if (!Kusto.Language.Binding.Binder.IsPattern(nameOrPattern)) {
                        if (clusterOrGroup == null && this._currentCluster.IsOpen) {
                            return this.GetOpenDatabase(nameOrPattern, this._currentCluster);
                        } else {
                            var c1;
                            if (((c1 = Bridge.as(clusterOrGroup, Kusto.Language.Symbols.ClusterSymbol))) != null && c1.IsOpen) {
                                return this.GetOpenDatabase(nameOrPattern, c1);
                            } else {
                                var g;
                                if (((g = Bridge.as(clusterOrGroup, Kusto.Language.Symbols.GroupSymbol))) != null) {
                                    // if any cluster in the group is open, return an open database corresponding to that cluster
                                    $t1 = Bridge.getEnumerator(g.Members, Kusto.Language.Symbols.Symbol);
                                    try {
                                        while ($t1.moveNext()) {
                                            var m = $t1.Current;
                                            var cs;
                                            if (((cs = Bridge.as(m, Kusto.Language.Symbols.ClusterSymbol))) != null && cs.IsOpen) {
                                                return this.GetOpenDatabase(nameOrPattern, cs);
                                            }
                                        }
                                    } finally {
                                        if (Bridge.is($t1, System.IDisposable)) {
                                            $t1.System$IDisposable$Dispose();
                                        }
                                    }
                                }
                            }
                        }
                    }

                    // no matching name and cannot be open database
                    return null;
                } finally {
                    Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(matching);
                }
            },
            /**
             * Gets the result of calling the table() function in the current context.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                               nameOrPattern    
             * @param   {Kusto.Language.Syntax.SyntaxNode}     location         
             * @param   {System.Collections.Generic.List$1}    diagnostics
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetTableFunctionResult: function (nameOrPattern, location, diagnostics) {
                // check for local table first
                if (this._pathScope == null && !Kusto.Language.Binding.Binder.IsPattern(nameOrPattern)) {
                    var match = 18;

                    var symbols = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                    try {
                        // check scope for variables, etc
                        this._localScope.GetSymbols$1(nameOrPattern, match, symbols);

                        if (symbols.Count > 0) {
                            var result = Kusto.Language.Binding.Binder.GetResultType(symbols.getItem(0));
                            return Bridge.as(result, Kusto.Language.Symbols.TableSymbol) || Bridge.cast(Kusto.Language.Symbols.ErrorSymbol.Instance, Kusto.Language.Symbols.TypeSymbol);
                        }
                    } finally {
                        Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(symbols);
                    }
                }

                var table = this.GetMatchingDatabaseTable(nameOrPattern, this._pathScope);

                if (table == null) {
                    if (diagnostics != null && location != null) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownTable(nameOrPattern).WithLocation(location));
                    }

                    // return open table regardless of containing tables's open state to reduce cascading errors
                    if (!Kusto.Language.Binding.Binder.IsPattern(nameOrPattern)) {
                        if (this._pathScope == null) {
                            table = this.GetOpenTable(nameOrPattern, this._currentDatabase);
                        } else {
                            var db;
                            if (((db = Bridge.as(this._pathScope, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                                table = this.GetOpenTable(nameOrPattern, db);
                            } else {
                                var g;
                                if (((g = Bridge.as(this._pathScope, Kusto.Language.Symbols.GroupSymbol))) != null) {
                                    // make an open table based on the first database
                                    var gdb = System.Linq.Enumerable.from(g.Members).ofType(Kusto.Language.Symbols.DatabaseSymbol).firstOrDefault(null, null);
                                    if (gdb != null) {
                                        table = this.GetOpenTable(nameOrPattern, gdb);
                                    }
                                }
                            }
                        }
                    }
                }

                return table;
            },
            /**
             * Gets the matching table or group of tables
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                               nameOrPattern      
             * @param   {Kusto.Language.Symbols.Symbol}        databaseOrGroup
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetMatchingDatabaseTable: function (nameOrPattern, databaseOrGroup) {
                var $t, $t1;
                var matches = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                try {
                    if (databaseOrGroup == null) {
                        this.GetMatchingDatabaseTables(nameOrPattern, this._currentDatabase, matches);
                    } else {
                        var database;
                        if (((database = Bridge.as(databaseOrGroup, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                            this.GetMatchingDatabaseTables(nameOrPattern, database, matches);
                        } else {
                            var group;
                            if (((group = Bridge.as(databaseOrGroup, Kusto.Language.Symbols.GroupSymbol))) != null) {
                                $t = Bridge.getEnumerator(group.Members, Kusto.Language.Symbols.Symbol);
                                try {
                                    while ($t.moveNext()) {
                                        var s = $t.Current;
                                        var db;
                                        if (((db = Bridge.as(s, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                                            this.GetMatchingDatabaseTables(nameOrPattern, db, matches);
                                        }
                                    }
                                } finally {
                                    if (Bridge.is($t, System.IDisposable)) {
                                        $t.System$IDisposable$Dispose();
                                    }
                                }
                            }
                        }
                    }
                    if (matches.Count === 1) {
                        return Bridge.cast(matches.getItem(0), Kusto.Language.Symbols.TableSymbol);
                    } else if (matches.Count > 1) {
                        return new Kusto.Language.Symbols.GroupSymbol.$ctor1(matches);
                    } else if (!Kusto.Language.Binding.Binder.IsPattern(nameOrPattern)) {
                        if (databaseOrGroup == null && this._currentDatabase.IsOpen) {
                            return this.GetOpenTable(nameOrPattern, this._currentDatabase);
                        }
                        var db1;
                        if (((db1 = Bridge.as(databaseOrGroup, Kusto.Language.Symbols.DatabaseSymbol))) != null && db1.IsOpen) {
                            return this.GetOpenTable(nameOrPattern, db1);
                        } else {
                            var g;
                            if (((g = Bridge.as(databaseOrGroup, Kusto.Language.Symbols.GroupSymbol))) != null) {
                                // in any database in group is open, then return an open table corresponding to that database
                                $t1 = Bridge.getEnumerator(g.Members, Kusto.Language.Symbols.Symbol);
                                try {
                                    while ($t1.moveNext()) {
                                        var m = $t1.Current;
                                        var gdb;
                                        if (((gdb = Bridge.as(m, Kusto.Language.Symbols.DatabaseSymbol))) != null && gdb.IsOpen) {
                                            return this.GetOpenTable(nameOrPattern, gdb);
                                        }
                                    }
                                } finally {
                                    if (Bridge.is($t1, System.IDisposable)) {
                                        $t1.System$IDisposable$Dispose();
                                    }
                                }
                            }
                        }
                    }

                    // nothing matched and could not invent an OpenTable
                    return null;
                } finally {
                    Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(matches);
                }
            },
            /**
             * Gets all matching tables
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                                   nameOrPattern    
             * @param   {Kusto.Language.Symbols.DatabaseSymbol}    database         
             * @param   {System.Collections.Generic.List$1}        matches
             * @return  {void}
             */
            GetMatchingDatabaseTables: function (nameOrPattern, database, matches) {
                var $t;
                $t = Bridge.getEnumerator(database.Tables, Kusto.Language.Symbols.TableSymbol);
                try {
                    while ($t.moveNext()) {
                        var table = $t.Current;
                        if (Kusto.Language.KustoFacts.Matches(nameOrPattern, table.Name)) {
                            matches.add(table);
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            /**
             * Gets the result of calling the external_table() function in the current context.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                               name           
             * @param   {Kusto.Language.Syntax.SyntaxNode}     location       
             * @param   {System.Collections.Generic.List$1}    diagnostics
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetExternalTableFunctionResult: function (name, location, diagnostics) {
                var db = Bridge.as(this._pathScope, Kusto.Language.Symbols.DatabaseSymbol) || this._currentDatabase;
                var table = db.GetExternalTable(name);

                if (table == null) {
                    if (diagnostics != null && location != null) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownExternalTable(name).WithLocation(location));
                    }

                    table = new Kusto.Language.Symbols.TableSymbol.$ctor4(name).WithIsExternal(true).WithIsOpen(true);
                }

                return table;
            },
            /**
             * Gets the result of calling the materialized_view() function in the current context.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                               name           
             * @param   {Kusto.Language.Syntax.SyntaxNode}     location       
             * @param   {System.Collections.Generic.List$1}    diagnostics
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetMaterializedViewFunctionResult: function (name, location, diagnostics) {
                var db = Bridge.as(this._pathScope, Kusto.Language.Symbols.DatabaseSymbol) || this._currentDatabase;
                var table = db.GetMaterializedView(name);

                if (table == null) {
                    if (diagnostics != null && location != null) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownMaterializedView(name).WithLocation(location));
                    }

                    table = new Kusto.Language.Symbols.TableSymbol.$ctor4(name).WithIsMaterializedView(true).WithIsOpen(true);
                }

                return table;
            },
            /**
             * Gets the common return type across a set of signatures, or error if there is no common type.
             The common return type is the return type all the signatures share, or the error type if the return types differ.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IReadOnlyList$1}    signatures       
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetCommonReturnType: function (signatures, $arguments, argumentTypes) {
                if (System.Array.getCount(signatures, Kusto.Language.Symbols.Signature) === 0) {
                    return Kusto.Language.Symbols.ErrorSymbol.Instance;
                } else if (System.Array.getCount(signatures, Kusto.Language.Symbols.Signature) === 1) {
                    return this.GetFunctionCallResult$1(System.Array.getItem(signatures, 0, Kusto.Language.Symbols.Signature), $arguments, argumentTypes).Type;
                } else {
                    var firstType = this.GetFunctionCallResult$1(System.Array.getItem(signatures, 0, Kusto.Language.Symbols.Signature), $arguments, argumentTypes).Type;

                    for (var i = 1; i < System.Array.getCount(signatures, Kusto.Language.Symbols.Signature); i = (i + 1) | 0) {
                        var type = this.GetFunctionCallResult$1(System.Array.getItem(signatures, i, Kusto.Language.Symbols.Signature), $arguments, argumentTypes).Type;
                        if (!Kusto.Language.Binding.Binder.SymbolsAssignable(firstType, type)) {
                            if (Kusto.Language.Binding.Binder.ArgumentsHaveErrorsOrUnknown(argumentTypes)) {
                                return Kusto.Language.Symbols.ScalarTypes.Unknown;
                            } else {
                                return Kusto.Language.Symbols.ErrorSymbol.Instance;
                            }
                        }
                    }

                    return firstType;
                }
            },
            /**
             * Gets the signatures that best match the specified arguments.
             If there is no best match, then multiple signatures will be returned.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IReadOnlyList$1}    signatures       
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
             * @param   {System.Collections.Generic.List$1}             result
             * @return  {void}
             */
            GetBestMatchingSignatures: function (signatures, $arguments, argumentTypes, result) {
                var $t, $t1, $t2;
                var argCount = System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol);

                if (System.Array.getCount(signatures, Kusto.Language.Symbols.Signature) === 0) {
                    return;
                } else if (System.Array.getCount(signatures, Kusto.Language.Symbols.Signature) === 1) {
                    result.add(System.Array.getItem(signatures, 0, Kusto.Language.Symbols.Signature));
                    return;
                }

                // determine candidates
                if (System.Array.getCount(signatures, Kusto.Language.Symbols.Signature) > 1) {
                    var closestCount = 0;
                    var maxCount = 0;

                    $t = Bridge.getEnumerator(signatures, Kusto.Language.Symbols.Signature);
                    try {
                        while ($t.moveNext()) {
                            var s = $t.Current;
                            if (argCount >= s.MinArgumentCount && argCount <= s.MaxArgumentCount) {
                                result.add(s);
                            } else if (argCount < s.MinArgumentCount && closestCount > s.MinArgumentCount) {
                                closestCount = s.MinArgumentCount;
                            }

                            if (s.MaxArgumentCount > maxCount) {
                                maxCount = s.MaxArgumentCount;
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    // if we didn't already find candidates, pick all with closest count
                    if (result.Count === 0) {
                        if (closestCount === 0) {
                            closestCount = maxCount;
                        }

                        $t1 = Bridge.getEnumerator(signatures, Kusto.Language.Symbols.Signature);
                        try {
                            while ($t1.moveNext()) {
                                var s1 = $t1.Current;
                                if (closestCount >= s1.MinArgumentCount && closestCount <= s1.MaxArgumentCount) {
                                    result.add(s1);
                                }
                            }
                        } finally {
                            if (Bridge.is($t1, System.IDisposable)) {
                                $t1.System$IDisposable$Dispose();
                            }
                        }
                    }
                }

                // reduce results to best matching functions
                if (result.Count > 1) {
                    var mostMatchingParameterCount = 0;

                    // determine the most matching parameter count
                    $t2 = Bridge.getEnumerator(result);
                    try {
                        while ($t2.moveNext()) {
                            var s2 = $t2.Current;
                            var count = this.GetParameterMatchCount(s2, $arguments, argumentTypes);
                            if (count > mostMatchingParameterCount) {
                                mostMatchingParameterCount = count;
                            }
                        }
                    } finally {
                        if (Bridge.is($t2, System.IDisposable)) {
                            $t2.System$IDisposable$Dispose();
                        }
                    }

                    // remove all candidates that do not have the most matching parameters
                    for (var i = (result.Count - 1) | 0; i >= 0; i = (i - 1) | 0) {
                        var f = result.getItem(i);
                        if (this.GetParameterMatchCount(f, $arguments, argumentTypes) !== mostMatchingParameterCount) {
                            result.removeAt(i);
                        }
                    }

                    // still more than one?  Try to find best match
                    if (result.Count > 1) {
                        var best = result.getItem(0);
                        for (var i1 = 1; i1 < result.Count; i1 = (i1 + 1) | 0) {
                            if (this.IsBetterSignatureMatch(result.getItem(i1), best, $arguments, argumentTypes)) {
                                best = result.getItem(i1);
                            }
                        }

                        for (var i2 = 0; i2 < result.Count; i2 = (i2 + 1) | 0) {
                            if (!Bridge.referenceEquals(result.getItem(i2), best) && !this.IsBetterSignatureMatch(best, result.getItem(i2), $arguments, argumentTypes)) {
                                // non-best is now better than best second time around??? must be ambiguous
                                return;
                            }
                        }

                        // one was clearly the best
                        result.clear();
                        result.add(best);
                    }
                }
            },
            /**
             * Determines if {@link } is a better match than {@link } for the specified arguments.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}              signature1       
             * @param   {Kusto.Language.Symbols.Signature}              signature2       
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
             * @return  {boolean}
             */
            IsBetterSignatureMatch: function (signature1, signature2, $arguments, argumentTypes) {
                var argCount = System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol);
                var matchCount1 = this.GetParameterMatchCount(signature1, $arguments, argumentTypes);
                var matchCount2 = this.GetParameterMatchCount(signature2, $arguments, argumentTypes);

                // if function matches all arguments but other-function does not, function is better
                if (matchCount1 === argCount && matchCount2 < argCount) {
                    return true;
                }

                // function with better parameter matches wins
                var better = null;
                for (var i = 0; i < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol); i = (i + 1) | 0) {
                    if (this.IsBetterParameterMatch(signature1, signature2, $arguments, argumentTypes, i)) {
                        if (Bridge.referenceEquals(better, signature2)) {
                            break;
                        }

                        better = signature1;
                    } else if (this.IsBetterParameterMatch(signature2, signature1, $arguments, argumentTypes, i)) {
                        if (Bridge.referenceEquals(better, signature1)) {
                            better = null;
                            break;
                        }

                        better = signature2;
                    }
                }

                // if function1 is clearly better on all parameter matches, function1 is better
                if (Bridge.referenceEquals(better, signature1)) {
                    return true;
                }

                // ambigous on parameter-to-parameter matches
                // if function1 has more matches than function2, function1 is better
                return matchCount1 > matchCount2;
            },
            /**
             * Determines if {@link } is a better match than {@link } for the specified argument at the corresponding parameter position.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}              signature1       
             * @param   {Kusto.Language.Symbols.Signature}              signature2       
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
             * @param   {number}                                        argumentIndex
             * @return  {boolean}
             */
            IsBetterParameterMatch: function (signature1, signature2, $arguments, argumentTypes, argumentIndex) {
                var argumentParameters1 = Kusto.Language.Binding.Binder.s_parameterListPool.AllocateFromPool();
                var argumentParameters2 = Kusto.Language.Binding.Binder.s_parameterListPool.AllocateFromPool();
                try {
                    signature1.GetArgumentParameters$2($arguments, argumentParameters1);
                    signature2.GetArgumentParameters$2($arguments, argumentParameters2);

                    var matches1 = this.GetParameterMatchKind(signature1, argumentParameters1, argumentTypes, argumentParameters1.getItem(argumentIndex), System.Array.getItem($arguments, argumentIndex, Kusto.Language.Syntax.Expression), System.Array.getItem(argumentTypes, argumentIndex, Kusto.Language.Symbols.TypeSymbol));
                    var matches2 = this.GetParameterMatchKind(signature2, argumentParameters2, argumentTypes, argumentParameters2.getItem(argumentIndex), System.Array.getItem($arguments, argumentIndex, Kusto.Language.Syntax.Expression), System.Array.getItem(argumentTypes, argumentIndex, Kusto.Language.Symbols.TypeSymbol));

                    return matches1 > matches2;
                } finally {
                    Kusto.Language.Binding.Binder.s_parameterListPool.ReturnToPool(argumentParameters2);
                    Kusto.Language.Binding.Binder.s_parameterListPool.ReturnToPool(argumentParameters1);
                }
            },
            /**
             * Determines the number of arguments that match their corresponding signature parameter.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}              signature        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
             * @return  {number}
             */
            GetParameterMatchCount: function (signature, $arguments, argumentTypes) {
                var argCount = System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol);
                var matches = 0;

                var argumentParameters = Kusto.Language.Binding.Binder.s_parameterListPool.AllocateFromPool();
                try {
                    signature.GetArgumentParameters$2($arguments, argumentParameters);

                    for (var i = 0; i < argCount; i = (i + 1) | 0) {
                        if (this.GetParameterMatchKind(signature, argumentParameters, argumentTypes, argumentParameters.getItem(i), System.Array.getItem($arguments, i, Kusto.Language.Syntax.Expression), System.Array.getItem(argumentTypes, i, Kusto.Language.Symbols.TypeSymbol)) !== Kusto.Language.Binding.ParameterMatchKind.None) {
                            matches = (matches + 1) | 0;
                        }
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_parameterListPool.ReturnToPool(argumentParameters);
                }


                return matches;
            },
            GetParameterMatchKind: function (signature, argumentParameters, argumentTypes, parameter, argument, argumentType) {
                return Kusto.Language.Binding.Binder.GetParameterMatchKind(signature, argumentParameters, argumentTypes, parameter, argument, argumentType, this.AllowLooseParameterMatching(signature));
            },
            /**
             * Gets {@link } for computed functions that have bodies that must be parsed and bound before understanding the result type.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}              signature        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
             * @return  {Kusto.Language.Binding.FunctionCallResult}
             */
            GetComputedFunctionCallResult: function (signature, $arguments, argumentTypes) {
                if ($arguments === void 0) { $arguments = null; }
                if (argumentTypes === void 0) { argumentTypes = null; }
                var outerScope = this._localScope.Copy();
                var funFacts = { };

                this.TryGetFunctionBodyFacts(signature, funFacts);

                // if the function is not yet analyzed or is known to have a variable return type
                // then compute the function body facts and return type for this location by calling GetCallSiteExpansion.
                if (funFacts.v == null || funFacts.v.HasVariableReturnType) {
                    // use expansion at this call site to determine correct return type
                    // if signature facts was not yet known, it will be computed by calling GetCallSiteExpansion
                    var expansion = this.GetFunctionCallExpansion(signature, $arguments, argumentTypes, outerScope);

                    // try again after evaluating expansion
                    this.TryGetFunctionBodyFacts(signature, funFacts);

                    var returnType = Kusto.Language.Binding.Binder.GetBodyResultType(expansion != null ? expansion.Root : null);

                    var hasErrors = funFacts.v != null ? funFacts.v.HasErrors : returnType != null && returnType.IsError ? true : Kusto.Language.Binding.Binder.HasErrors(expansion != null ? expansion.Root : null);

                    if (returnType == null || returnType.IsError) {
                        returnType = Kusto.Language.Symbols.ScalarTypes.Unknown;
                    }

                    return new Kusto.Language.Binding.FunctionCallResult.$ctor1(returnType, new Kusto.Language.Binding.FunctionCallInfo.ctor(expansion, funFacts.v, hasErrors));
                } else {
                    // body has non-variable (fixed) return type.
                    return new Kusto.Language.Binding.FunctionCallResult.$ctor1(funFacts.v.NonVariableComputedReturnType, new Kusto.Language.Binding.FunctionCallInfo.$ctor1(this.GetDeferredFunctionCallExpansion(signature, $arguments, argumentTypes, outerScope), funFacts.v, funFacts.v.HasErrors));
                }
            },
            GetDeferredFunctionCallExpansion: function (signature, $arguments, argumentTypes, outerScope) {
                if ($arguments === void 0) { $arguments = null; }
                if (argumentTypes === void 0) { argumentTypes = null; }
                if (outerScope === void 0) { outerScope = null; }
                var expansion = null;
                var args = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Syntax.Expression, $arguments); // force copy
                var types = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Symbols.TypeSymbol, argumentTypes); // force copy

                return Bridge.fn.bind(this, function () {
                    if (expansion == null) {
                        // re-introduce binding lock since deferred function can be called outside the current binding lock
                        this._globalBindingCache;
                        {
                            expansion = this.GetFunctionCallExpansion(signature, args, types, outerScope);
                        }
                    }

                    return expansion;
                });
            },
            /**
             * Gets the inline expansion of a function call
             *
             * @instance
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}              signature        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
             * @param   {Kusto.Language.Binding.LocalScope}             outerScope
             * @return  {Kusto.Language.FunctionCallExpansion}
             */
            GetFunctionCallExpansion: function (signature, $arguments, argumentTypes, outerScope) {
                if ($arguments === void 0) { $arguments = null; }
                if (argumentTypes === void 0) { argumentTypes = null; }
                if (outerScope === void 0) { outerScope = null; }
                var AddExpansionToCache = null;
                var TryGetExpansionFromCache = null;
                if (signature.ReturnKind !== Kusto.Language.Symbols.ReturnTypeKind.Computed) {
                    return null;
                }

                // block cycles in computation
                if (this._localBindingCache.SignaturesComputingExpansion.contains(signature)) {
                    return null;
                }

                this._localBindingCache.SignaturesComputingExpansion.add(signature);
                TryGetExpansionFromCache = Bridge.fn.bind(this, function (callsite, expansion) {
                    return this._localBindingCache.CallSiteToExpansionMap.tryGetValue(callsite, expansion) || this._globalBindingCache.CallSiteToExpansionMap.tryGetValue(callsite, expansion);
                });
                AddExpansionToCache = Bridge.fn.bind(this, function (callsite, expansion) {
                    var funFacts = { };
                    this.TryGetFunctionBodyFacts(callsite.Signature, funFacts);
                    // if there is a call to unqualified table(t) then it may require resolving using dynamic scope, so don't cache anywhere
                    if (funFacts.v != null && funFacts.v.HasUnqualifiedTableCall) {
                        return;
                    }
                    // only add database functions that are not variable in nature to global cache
                    // might need to rethink this if memory consumption is shown to be an issue
                    var shouldCacheGlobally = this.IsDatabaseSymbolSignature(callsite.Signature) && (funFacts.v != null && !funFacts.v.HasVariableReturnType);
                    if (shouldCacheGlobally) {
                        this._globalBindingCache.CallSiteToExpansionMap.add(callsite, expansion);
                    } else {
                        this._localBindingCache.CallSiteToExpansionMap.add(callsite, expansion);
                    }
                });
                try {
                    var callSiteInfo = this.GetCallSiteInfo(signature, $arguments, argumentTypes);
                    var expansion = { };

                    if (!TryGetExpansionFromCache(callSiteInfo, expansion)) {
                        try {
                            var body = Kusto.Language.Binding.Binder.GetUnboundBody(signature);

                            if (body != null) {
                                var isInDatabase = this.IsDatabaseSymbolSignature(signature);
                                var currentDatabase = isInDatabase ? this._globals.GetDatabase$1(signature.Symbol) : null;
                                var currentCluster = isInDatabase ? this._globals.GetCluster(currentDatabase) : null;
                                expansion.v = new Kusto.Language.FunctionCallExpansion(body);

                                if (Kusto.Language.Binding.Binder.TryBindCalledFunctionBody(expansion.v, this, currentCluster, currentDatabase, Bridge.as(signature.Symbol, Kusto.Language.Symbols.FunctionSymbol), outerScope, callSiteInfo.Locals)) {
                                    // compute function body facts as side effect
                                    var _ = this.GetOrComputeFunctionBodyFacts(signature, expansion.v.Root);
                                } else {
                                    // don't return expansion that did not bind
                                    expansion.v = null;
                                }
                            }
                        } catch ($e1) {
                            $e1 = System.Exception.create($e1);
                            // don't return expansion that failed in binding
                            expansion.v = null;
                        }

                        AddExpansionToCache(callSiteInfo, expansion.v);
                    }

                    return expansion.v;
                } finally {
                    this._localBindingCache.SignaturesComputingExpansion.remove(signature);
                }

                // Tries to get the expansion from global or local cache.


                // Adds expansion to global or local cache.

            },
            /**
             * True if the signature is declared by a symbol that is part of database known to the current {@link }
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}    signature
             * @return  {boolean}
             */
            IsDatabaseSymbolSignature: function (signature) {
                return signature != null && signature.Symbol != null && signature.Declaration == null && signature.Body != null && this._globals.IsDatabaseSymbol(signature.Symbol); // and they are known by the global state
            },
            GetCallSiteInfo: function (signature, $arguments, argumentTypes) {
                var locals = this.GetArgumentsAsLocals(signature, $arguments, argumentTypes);
                return new Kusto.Language.Binding.CallSiteInfo(signature, locals);
            },
            GetArgumentsAsLocals: function (signature, $arguments, argumentTypes) {
                var $t;
                var locals = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.VariableSymbol)).ctor();

                var argumentParameters = Kusto.Language.Binding.Binder.s_parameterListPool.AllocateFromPool();
                try {
                    if ($arguments != null) {
                        signature.GetArgumentParameters$2($arguments, argumentParameters);
                    } else if (argumentTypes != null) {
                        signature.GetArgumentParameters$1(argumentTypes, argumentParameters);
                    }

                    $t = Bridge.getEnumerator(signature.Parameters, Kusto.Language.Symbols.Parameter);
                    try {
                        while ($t.moveNext()) {
                            var p = $t.Current;
                            var argIndex = argumentParameters != null ? argumentParameters.indexOf(p) : -1;

                            if (argIndex >= 0 && !!($arguments != null & argIndex < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression))) {
                                var arg = System.Array.getItem($arguments, argIndex, Kusto.Language.Syntax.Expression);

                                var argType = argumentTypes != null && argIndex < System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol) ? System.Array.getItem(argumentTypes, argIndex, Kusto.Language.Symbols.TypeSymbol) : arg.ResultType;

                                // use parameter type as variable type if scalar, to avoid analyzing function bodies with incorrect types.
                                var localType = p.IsScalar && p.TypeKind === Kusto.Language.Symbols.ParameterTypeKind.Declared ? System.Array.getItem(p.DeclaredTypes, 0, Kusto.Language.Symbols.TypeSymbol) : argType;
                                var literalValue = { };

                                var isLiteral = Kusto.Language.Binding.Binder.TryGetLiteralValue(arg, literalValue);
                                locals.add(new Kusto.Language.Symbols.VariableSymbol(p.Name, localType, isLiteral, literalValue.v));
                            } else {
                                var type = Kusto.Language.Binding.Binder.GetRepresentativeType(p);

                                var isConstant = p.IsOptional && p.DefaultValue != null;
                                var constantValue = { v : null };
                                if (isConstant) {
                                    Kusto.Language.Binding.Binder.TryGetLiteralValue(p.DefaultValue, constantValue);
                                }

                                locals.add(new Kusto.Language.Symbols.VariableSymbol(p.Name, type, isConstant, constantValue.v));
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    return Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Symbols.VariableSymbol, locals);
                } finally {
                    Kusto.Language.Binding.Binder.s_parameterListPool.ReturnToPool(argumentParameters);
                }
            },
            GetOrComputeFunctionBodyFacts: function (signature, body) {
                var facts = { };
                if (!this.TryGetFunctionBodyFacts(signature, facts)) {
                    var bodyFacts = this.ComputeFunctionBodyFlags(signature, body);

                    var nonVariableReturnType = (bodyFacts & Kusto.Language.FunctionBodyFlags.VariableReturn) === 0 ? Kusto.Language.Binding.Binder.GetBodyResultType(body) || Kusto.Language.Symbols.ErrorSymbol.Instance : null;

                    var hasErrors = Kusto.Language.Binding.Binder.HasErrors(body);

                    facts.v = new Kusto.Language.FunctionBodyFacts(bodyFacts, nonVariableReturnType, hasErrors);
                    this.SetFunctionBodyFacts(signature, facts.v);
                }

                return facts.v;
            },
            TryGetFunctionBodyFacts: function (signature, facts) {
                if (this._globalBindingCache.DatabaseFunctionBodyFacts.tryGetValue(signature, facts)) {
                    return true;
                }
                var fs;
                if (((fs = Bridge.as(signature.Symbol, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                    facts.v = fs.NonDatabaseFunctionBodyFacts;
                    return facts.v != null;
                }

                facts.v = null;
                return false;
            },
            SetFunctionBodyFacts: function (signature, facts) {
                if (this.IsDatabaseSymbolSignature(signature)) {
                    this._globalBindingCache.DatabaseFunctionBodyFacts.setItem(signature, facts);
                } else {
                    var fs;
                    if (((fs = Bridge.as(signature.Symbol, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                        fs.NonDatabaseFunctionBodyFacts = facts;
                    }
                }
            },
            ComputeFunctionBodyFlags: function (signature, body) {
                var $t, $t1;
                var result = Kusto.Language.FunctionBodyFlags.None;
                var isTabular = Bridge.is(Kusto.Language.Binding.Binder.GetBodyResultType(body), Kusto.Language.Symbols.TableSymbol);

                // look for explicit calls to table(), database() or cluster() like functions
                $t = Bridge.getEnumerator(Kusto.Language.Binding.Binder.GetMainBodyOnlyDescendants(Kusto.Language.Syntax.FunctionCallExpression, body, function (_fc) {
                    return Kusto.Language.Binding.Binder.IsSymbolLookupFunction(_fc.ReferencedSymbol);
                }), Kusto.Language.Syntax.FunctionCallExpression);
                try {
                    while ($t.moveNext()) {
                        var fc = $t.Current;
                        if (Bridge.referenceEquals(fc.ReferencedSymbol, Kusto.Language.Functions.Table)) {
                            var p; // distinguish between database(d).table(t) vs just table(t)
                            // since table(t) can see variables in dynamic scope
                            if (((p = Bridge.as(fc.Parent, Kusto.Language.Syntax.PathExpression))) != null && Bridge.referenceEquals(p.Selector, fc)) {
                                result |= Kusto.Language.FunctionBodyFlags.QualifiedTable;
                            } else {
                                // unqualified table calls (even with literal arguments) can be dependent on the call site since
                                // the names can reference local tabular variables in outer scopes
                                result |= 36;
                            }
                        } else if (Bridge.referenceEquals(fc.ReferencedSymbol, Kusto.Language.Functions.ExternalTable)) {
                            result |= Kusto.Language.FunctionBodyFlags.ExternalTable;
                        } else if (Bridge.referenceEquals(fc.ReferencedSymbol, Kusto.Language.Functions.MaterializedView)) {
                            result |= Kusto.Language.FunctionBodyFlags.MaterializedView;
                        } else if (Bridge.referenceEquals(fc.ReferencedSymbol, Kusto.Language.Functions.Database)) {
                            result |= Kusto.Language.FunctionBodyFlags.Database;
                        } else if (Bridge.referenceEquals(fc.ReferencedSymbol, Kusto.Language.Functions.Cluster)) {
                            result |= Kusto.Language.FunctionBodyFlags.Cluster;
                        }

                        // if the argument is not a literal, then the function likely has a variable return schema
                        // note: it might not, but that would require full flow analysis of result type back to inputs.
                        var isLiteral = fc.ArgumentList.Expressions.Count > 0 && fc.ArgumentList.Expressions.getItem$1(0).Element$1.IsLiteral;
                        if (!isLiteral && isTabular) {
                            result |= Kusto.Language.FunctionBodyFlags.VariableReturn;
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                // the function returns a table and at least one parameter is a tabular
                if (isTabular && System.Linq.Enumerable.from(signature.Parameters, Kusto.Language.Symbols.Parameter).any(function (p1) {
                        return p1.IsTabular;
                    })) {
                    result |= Kusto.Language.FunctionBodyFlags.VariableReturn;
                }

                // also consider any facts from other calls to user functions
                $t1 = Bridge.getEnumerator(Kusto.Language.Binding.Binder.GetMainBodyOnlyDescendants(Kusto.Language.Syntax.Expression, body, function (ex) {
                    var fs;
                    return ((fs = Bridge.as(ex.ReferencedSymbol, Kusto.Language.Symbols.FunctionSymbol))) != null && !Kusto.Language.Binding.Binder.IsSymbolLookupFunction(fs) && (Bridge.is(ex, Kusto.Language.Syntax.FunctionCallExpression) || (Bridge.is(ex, Kusto.Language.Syntax.NameReference) && !(Bridge.is(ex.Parent, Kusto.Language.Syntax.FunctionCallExpression))));
                }), Kusto.Language.Syntax.Expression);
                try {
                    while ($t1.moveNext()) {
                        var fce = $t1.Current;
                        var flags = this.GetFunctionBodyFlags(fce);

                        // if the calling function has no parameters and the called function does not contain unqualified calls to table() function, then don't considered it having a variable return
                        if (System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter) === 0 && (flags & Kusto.Language.FunctionBodyFlags.UnqualifiedTable) === 0) {
                            flags &= -33;
                        }

                        result |= flags;
                    }
                } finally {
                    if (Bridge.is($t1, System.IDisposable)) {
                        $t1.System$IDisposable$Dispose();
                    }
                }

                return result;
            },
            /**
             * Gets the {@link } for the function invocation
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.Expression}    expr
             * @return  {Kusto.Language.FunctionBodyFlags}
             */
            GetFunctionBodyFlags: function (expr) {
                var $t;
                var fs;
                if (((fs = Bridge.as(expr.ReferencedSymbol, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                    var signature = System.Array.getItem(fs.Signatures, 0, Kusto.Language.Symbols.Signature);
                    var funFacts = { };

                    if (!this.TryGetFunctionBodyFacts(signature, funFacts) && signature.ReturnKind === Kusto.Language.Symbols.ReturnTypeKind.Computed) {
                        var functionCall;
                        if (((functionCall = Bridge.as(expr, Kusto.Language.Syntax.FunctionCallExpression))) != null) {
                            var $arguments = Kusto.Language.Binding.Binder.s_expressionListPool.AllocateFromPool();
                            var argumentTypes = Kusto.Language.Binding.Binder.s_typeListPool.AllocateFromPool();

                            try {
                                this.GetArgumentsAndTypes(functionCall, $arguments, argumentTypes);
                                this.GetComputedFunctionCallResult(signature, $arguments, argumentTypes);
                            } finally {
                                Kusto.Language.Binding.Binder.s_expressionListPool.ReturnToPool($arguments);
                                Kusto.Language.Binding.Binder.s_typeListPool.ReturnToPool(argumentTypes);
                            }
                        } else if (Bridge.is(expr, Kusto.Language.Syntax.NameReference)) {
                            this.GetComputedFunctionCallResult(signature, Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Syntax.Expression).Instance, Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Symbols.TypeSymbol).Instance);
                        }

                        // try again
                        this.TryGetFunctionBodyFacts(signature, funFacts);
                    }

                    return ($t = (funFacts.v != null ? funFacts.v.Flags : null), $t != null ? $t : Kusto.Language.FunctionBodyFlags.None);
                }

                return Kusto.Language.FunctionBodyFlags.None;
            },
            SetSemanticInfo: function (node, info) {
                if (node != null) {
                    !Bridge.staticEquals(this._semanticInfoSetter, null) ? this._semanticInfoSetter(node, info) : null;
                }
            },
            GetResultTypeOrError: function (expression) {
                return (expression != null ? expression.ResultType : null) || Kusto.Language.Symbols.ErrorSymbol.Instance;
            },
            GetResultType: function (expression) {
                return expression != null ? expression.ResultType : null;
            },
            GetReferencedSymbol: function (expression) {
                return expression != null ? expression.ReferencedSymbol : null;
            },
            GetIsConstant: function (expression) {
                var $t;
                return ($t = (expression != null ? expression.IsConstant : null), $t != null ? $t : false);
            },
            /**
             * Gets or creates an open cluster symbol of the given name.
             This is used when a cluster('...') call does not map to a known cluster.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                                  name
             * @return  {Kusto.Language.Symbols.ClusterSymbol}
             */
            GetOpenCluster: function (name) {
                if (this._openClusters == null) {
                    this._openClusters = new (System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.ClusterSymbol)).ctor();
                }
                var cluster = { };

                if (!this._openClusters.tryGetValue(name, cluster)) {
                    cluster.v = new Kusto.Language.Symbols.ClusterSymbol.$ctor1(name, null, true);
                    this._openClusters.add(name, cluster.v);
                }

                return cluster.v;
            },
            /**
             * Gets or creates an open database symbol of the given name.
             This is primarily used for database('...') of an unknown database within an open cluster.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                                   name       
             * @param   {Kusto.Language.Symbols.ClusterSymbol}     cluster
             * @return  {Kusto.Language.Symbols.DatabaseSymbol}
             */
            GetOpenDatabase: function (name, cluster) {
                cluster = cluster || this._currentCluster;

                if (this._openDatabases == null) {
                    this._openDatabases = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Symbols.ClusterSymbol,System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.DatabaseSymbol))).ctor();
                }
                var map = { };

                if (!this._openDatabases.tryGetValue(cluster, map)) {
                    map.v = new (System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.DatabaseSymbol)).ctor();
                    this._openDatabases.add(cluster, map.v);
                }
                var database = { };

                if (!map.v.tryGetValue(name, database)) {
                    database.v = new Kusto.Language.Symbols.DatabaseSymbol.$ctor1(name, null, true);
                    map.v.add(name, database.v);
                }

                return database.v;
            },
            /**
             * Gets or creates an open table symbol of the given name.
             This is primarily used for db.Table or db.table('...') of an unknown table within an open database.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                                   name        
             * @param   {Kusto.Language.Symbols.DatabaseSymbol}    database
             * @return  {Kusto.Language.Symbols.TableSymbol}
             */
            GetOpenTable: function (name, database) {
                if (this._openTables == null) {
                    this._openTables = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Symbols.DatabaseSymbol,System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.TableSymbol))).ctor();
                }
                var map = { };

                if (!this._openTables.tryGetValue(database, map)) {
                    map.v = new (System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.TableSymbol)).ctor();
                    this._openTables.add(database, map.v);
                }
                var table = { };

                if (!map.v.tryGetValue(name, table)) {
                    table.v = new Kusto.Language.Symbols.TableSymbol.$ctor4(name).WithIsOpen(true);
                    map.v.add(name, table.v);
                }

                return table.v;
            },
            /**
             * Gets or creates an inferred column symbol and associates it with the specified open table.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {string}                                 name     
             * @param   {Kusto.Language.Symbols.TableSymbol}     table
             * @return  {Kusto.Language.Symbols.ColumnSymbol}
             */
            GetOpenTableInferredColumn: function (name, table) {
                if (this._openTableInferredColumns == null) {
                    this._openTableInferredColumns = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Symbols.TableSymbol,System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.ColumnSymbol))).ctor();
                }
                var columnMap = { };

                if (!this._openTableInferredColumns.tryGetValue(table, columnMap)) {
                    columnMap.v = new (System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.ColumnSymbol)).ctor();
                    this._openTableInferredColumns.add(table, columnMap.v);
                }
                var column = { };

                if (!columnMap.v.tryGetValue(name, column)) {
                    column.v = new Kusto.Language.Symbols.ColumnSymbol(name, Kusto.Language.Symbols.ScalarTypes.Unknown);
                    columnMap.v.add(name, column.v);
                }

                return column.v;
            },
            /**
             * Gets all the declared or inferred columns for the specified table.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.TableSymbol}    table      
             * @param   {System.Collections.Generic.List$1}     columns
             * @return  {void}
             */
            GetDeclaredAndInferredColumns$1: function (table, columns) {
                columns.AddRange(table.Columns);
                var columnMap = { };

                if (table.IsOpen && this._openTableInferredColumns != null && this._openTableInferredColumns.tryGetValue(table, columnMap)) {
                    columns.AddRange(columnMap.v.Values);
                }
            },
            /**
             * Gets all the declared or inferred columns for the specified table.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.TableSymbol}            table
             * @return  {System.Collections.Generic.IReadOnlyList$1}
             */
            GetDeclaredAndInferredColumns: function (table) {
                if (table.IsOpen && this._openTableInferredColumns != null && this._openTableInferredColumns.containsKey(table)) {
                    var list = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();
                    this.GetDeclaredAndInferredColumns$1(table, list);
                    return list;
                } else {
                    return table.Columns;
                }
            },
            /**
             * Gets the declared or inferred column of the given name for the specified table.
             If the column is not declared and the table is open, a new column is inferred with the given name.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.TableSymbol}     table     
             * @param   {string}                                 name      
             * @param   {Kusto.Language.Symbols.ColumnSymbol}    column
             * @return  {boolean}
             */
            TryGetDeclaredOrInferredColumn: function (table, name, column) {
                if (table.TryGetColumn(name, column)) {
                    return true;
                } else if (table.IsOpen) {
                    column.v = this.GetOpenTableInferredColumn(name, table);
                    return true;
                } else {
                    column.v = null;
                    return false;
                }
            },
            /**
             * Gets a tuple with the same columns (declared and inferred) as the table.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.TableSymbol}    table
             * @return  {Kusto.Language.Symbols.TupleSymbol}
             */
            GetTuple: function (table) {
                if (this._tupleMap == null) {
                    this._tupleMap = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Symbols.TableSymbol,Kusto.Language.Symbols.TupleSymbol)).ctor();
                }
                var tuple = { };

                if (!this._tupleMap.tryGetValue(table, tuple)) {
                    tuple.v = new Kusto.Language.Symbols.TupleSymbol.$ctor1(table.Columns, table);
                    this._tupleMap.add(table, tuple.v);
                }

                return tuple.v;
            },
            /**
             * Returns true if the list of tables can be cached globally (tied by global state cache)
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IReadOnlyList$1}    tables
             * @return  {boolean}
             */
            CanGlobalCache: function (tables) {
                // if this is the list of tables from the current database definition, then okay.
                // otherwise if its a list of stricly database tables then allow
                //     (note: this still may cause excessive caching if queries have lots of queries with joins,unions of strictly database tables)
                return Bridge.referenceEquals(tables, this._currentDatabase.Tables) || System.Linq.Enumerable.from(tables, Kusto.Language.Symbols.TableSymbol).all(Bridge.fn.bind(this, function (t) {
                        return this._globals.IsDatabaseTable(t);
                    }));
            },
            /**
             * A table that contains all the columns in the specified list of tables, unified on name.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IReadOnlyList$1}    tables
             * @return  {Kusto.Language.Symbols.TableSymbol}
             */
            GetTableOfColumnsUnifiedByName: function (tables) {
                var $t;
                var unifiedColumnsTable = { };
                // consider making this cache thread safe
                if (!this._globalBindingCache.UnifiedNameColumnsMap.tryGetValue(tables, unifiedColumnsTable)) {
                    var canCache = this.CanGlobalCache(tables);

                    tables = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Symbols.TableSymbol, tables);
                    var columns = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();

                    $t = Bridge.getEnumerator(tables, Kusto.Language.Symbols.TableSymbol);
                    try {
                        while ($t.moveNext()) {
                            var table = $t.Current;
                            columns.AddRange(table.Columns);
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    Kusto.Language.Binding.Binder.UnifyColumnsWithSameName(columns);

                    unifiedColumnsTable.v = new Kusto.Language.Symbols.TableSymbol.$ctor3(columns).WithIsOpen(System.Linq.Enumerable.from(tables, Kusto.Language.Symbols.TableSymbol).any(function (t) {
                            return t.IsOpen;
                        }));

                    if (canCache) {
                        this._globalBindingCache.UnifiedNameColumnsMap.setItem(tables, unifiedColumnsTable.v);
                    }
                }

                return unifiedColumnsTable.v;
            },
            /**
             * A table that contains all the columns in the specified list of tables, unified on name and type.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IReadOnlyList$1}    tables
             * @return  {Kusto.Language.Symbols.TableSymbol}
             */
            GetTableOfColumnsUnifiedByNameAndType: function (tables) {
                var $t;
                var unifiedColumnsTable = { };
                // consider making this cache thread safe
                if (!this._globalBindingCache.UnifiedNameAndTypeColumnsMap.tryGetValue(tables, unifiedColumnsTable)) {
                    var canCache = this.CanGlobalCache(tables);

                    tables = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Symbols.TableSymbol, tables);
                    var columns = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();

                    $t = Bridge.getEnumerator(tables, Kusto.Language.Symbols.TableSymbol);
                    try {
                        while ($t.moveNext()) {
                            var table = $t.Current;
                            columns.AddRange(table.Columns);
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    Kusto.Language.Binding.Binder.UnifyColumnsWithSameNameAndType(columns);

                    unifiedColumnsTable.v = new Kusto.Language.Symbols.TableSymbol.$ctor3(columns).WithIsOpen(System.Linq.Enumerable.from(tables, Kusto.Language.Symbols.TableSymbol).any(function (t) {
                            return t.IsOpen;
                        }));

                    if (canCache) {
                        this._globalBindingCache.UnifiedNameAndTypeColumnsMap.setItem(tables, unifiedColumnsTable.v);
                    }
                }

                return unifiedColumnsTable.v;
            },
            /**
             * A table that contains the common columns in the specified list of tables.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.IReadOnlyList$1}    tables
             * @return  {Kusto.Language.Symbols.TableSymbol}
             */
            GetTableOfCommonColumns: function (tables) {
                var commonColumnsTable = { };
                // consider making this cache thread safe
                if (!this._globalBindingCache.CommonColumnsMap.tryGetValue(tables, commonColumnsTable)) {
                    var canCache = this.CanGlobalCache(tables);

                    tables = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Symbols.TableSymbol, tables);
                    var columns = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();

                    Kusto.Language.Binding.Binder.GetCommonColumns(tables, columns);

                    commonColumnsTable.v = new Kusto.Language.Symbols.TableSymbol.$ctor3(columns);

                    // since these are the common columns, open columns can only exist if all tables are open
                    if (System.Array.getCount(tables, Kusto.Language.Symbols.TableSymbol) > 0 && System.Linq.Enumerable.from(tables, Kusto.Language.Symbols.TableSymbol).all(function (t) {
                            return t.IsOpen;
                        })) {
                        commonColumnsTable.v = commonColumnsTable.v.WithIsOpen(true);
                    }

                    if (canCache) {
                        this._globalBindingCache.CommonColumnsMap.setItem(tables, commonColumnsTable.v);
                    }
                }

                return commonColumnsTable.v;
            },
            AddLetDeclarationToScope: function (scope, statement, diagnostics) {
                if (diagnostics === void 0) { diagnostics = null; }
                scope.AddSymbol(this.GetReferencedSymbol(statement.Name));
            },
            AddDeclarationsToLocalScope: function (declarations) {
                for (var i = 0, n = declarations.Count; i < n; i = (i + 1) | 0) {
                    var d = declarations.getItem$1(i).Element$1;
                    this.AddDeclarationToLocalScope(d.NameAndType.Name);
                }
            },
            AddDeclarationsToLocalScope$1: function (declarations) {
                for (var i = 0, n = declarations.Count; i < n; i = (i + 1) | 0) {
                    var d = declarations.getItem$1(i).Element$1;
                    this.AddDeclarationToLocalScope(d.Name);
                }
            },
            AddDeclarationToLocalScope: function (node) {
                var s;
                if (((s = node.ReferencedSymbol)) != null) {
                    this._localScope.AddSymbol(s);
                }
            },
            BindParameterDeclarations: function (parameters) {
                for (var i = 0; i < parameters.Count; i = (i + 1) | 0) {
                    var p = parameters.getItem$1(i).Element$1;
                    this.BindParameterDeclaration(p);
                }
            },
            BindParameterDeclarations$1: function (parameters) {
                for (var i = 0; i < parameters.Count; i = (i + 1) | 0) {
                    var p = parameters.getItem$1(i).Element$1;
                    this.BindParameterDeclaration$1(p);
                }
            },
            BindParameterDeclaration: function (node) {
                this.BindParameterDeclaration$1(node.NameAndType);
            },
            BindParameterDeclaration$1: function (node) {
                var name = node.Name.SimpleName;
                var type = this.GetTypeFromTypeExpression(node.Type);

                if (!System.String.isNullOrEmpty(name)) {
                    var symbol = new Kusto.Language.Symbols.ParameterSymbol(name, type);
                    this.SetSemanticInfo(node.Name, new Kusto.Language.Binding.SemanticInfo.$ctor3(symbol, type));
                }
            },
            BindColumnDeclarations: function (parameters) {
                for (var i = 0; i < parameters.Count; i = (i + 1) | 0) {
                    var p = parameters.getItem$1(i).Element$1;
                    this.BindColumnDeclaration(p);
                }
            },
            BindColumnDeclaration: function (node) {
                var name = node.NameAndType.Name.SimpleName;
                var type = this.GetTypeFromTypeExpression(node.NameAndType.Type);

                if (!System.String.isNullOrEmpty(name)) {
                    var symbol = new Kusto.Language.Symbols.ColumnSymbol(name, type);
                    this.SetSemanticInfo(node.NameAndType.Name, new Kusto.Language.Binding.SemanticInfo.$ctor3(symbol, type));
                }
            },
            GetScanStepTuple: function (node) {
                var $t;
                var columns = Kusto.Language.Binding.Binder.s_columnListPool.AllocateFromPool();
                try {
                    this.GetDeclaredAndInferredColumns$1(this.RowScopeOrEmpty, columns);

                    if (node.DeclareClause != null) {
                        $t = Bridge.getEnumerator(node.DeclareClause.Declarations, "GetEnumerator$1");
                        try {
                            while ($t.moveNext()) {
                                var elem = $t.Current;
                                var c;
                                if (((c = Bridge.as(elem.Element$1.NameAndType.Name.ReferencedSymbol, Kusto.Language.Symbols.ColumnSymbol))) != null) {
                                    columns.add(c);
                                }
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }

                    return new Kusto.Language.Symbols.TupleSymbol.$ctor1(columns, this._rowScope);
                } finally {
                    Kusto.Language.Binding.Binder.s_columnListPool.ReturnToPool(columns);
                }
            },
            BindStepDeclarations: function (node) {
                var $t;
                var stepTuple = this.GetScanStepTuple(node);

                $t = Bridge.getEnumerator(node.Steps, "GetEnumerator$1");
                try {
                    while ($t.moveNext()) {
                        var step = $t.Current;
                        var name = step.Name.SimpleName;
                        var local = new Kusto.Language.Symbols.VariableSymbol(name, stepTuple);
                        this.SetSemanticInfo(step.Name, new Kusto.Language.Binding.SemanticInfo.$ctor3(local, stepTuple));
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            AddStepDeclarationsToLocalScope: function (node) {
                var $t;
                var stepTuple = this.GetScanStepTuple(node);

                $t = Bridge.getEnumerator(node.Steps, "GetEnumerator$1");
                try {
                    while ($t.moveNext()) {
                        var step = $t.Current;
                        this.AddDeclarationToLocalScope(step.Name);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            /**
             * Gets the {@link } in effect for a function's arguments.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.FunctionCallExpression}    fc            
             * @param   {Kusto.Language.Binding.ScopeKind}                outerScope
             * @return  {Kusto.Language.Binding.ScopeKind}
             */
            GetArgumentScope: function (fc, outerScope) {
                var fs;
                if (((fs = Bridge.as(this.GetReferencedSymbol(fc.Name), Kusto.Language.Symbols.FunctionSymbol))) != null && this._globals.IsAggregateFunction(fs)) {
                    // aggregate function arguments are always normal
                    return Kusto.Language.Binding.ScopeKind.Normal;
                } else if (outerScope === Kusto.Language.Binding.ScopeKind.Aggregate) {
                    // if the function is not a known aggregate then keep aggregate scope as there may be
                    // aggregates nested in the function arguments
                    return Kusto.Language.Binding.ScopeKind.Aggregate;
                } else {
                    return Kusto.Language.Binding.ScopeKind.Normal;
                }
            },
            /**
             * Gets the type referenced in the type expression.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.TypeExpression}    typeExpression    
             * @param   {System.Collections.Generic.List$1}       diagnostics
             * @return  {Kusto.Language.Symbols.TypeSymbol}
             */
            GetTypeFromTypeExpression: function (typeExpression, diagnostics) {
                if (diagnostics === void 0) { diagnostics = null; }
                return Kusto.Language.Binding.Binder.GetDeclaredType(typeExpression, diagnostics, this);
            },
            GetTypeOfType: function (typeofLiteral) {
                return Bridge.as(this.GetReferencedSymbol(typeofLiteral), Kusto.Language.Symbols.TypeSymbol) || Kusto.Language.Symbols.ErrorSymbol.Instance;
            },
            IsTabular: function (expr) {
                return Kusto.Language.Binding.Binder.IsTabular(this.GetResultTypeOrError(expr));
            },
            IsColumn: function (expr) {
                return Bridge.is(this.GetReferencedSymbol(expr), Kusto.Language.Symbols.ColumnSymbol);
            },
            CheckQueryOperatorParameters: function (parameters, queryParameters, diagnostics) {
                var names = Kusto.Language.Binding.Binder.s_stringSetPool.AllocateFromPool();
                try {
                    for (var i = 0, n = parameters.Count; i < n; i = (i + 1) | 0) {
                        this.CheckQueryOperatorParameter$1(parameters.getItem$1(i), queryParameters, names, diagnostics);
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_stringSetPool.ReturnToPool(names);
                }
            },
            CheckQueryOperatorParameters$1: function (parameters, queryParameters, diagnostics) {
                var names = Kusto.Language.Binding.Binder.s_stringSetPool.AllocateFromPool();
                try {
                    for (var i = 0, n = parameters.Count; i < n; i = (i + 1) | 0) {
                        this.CheckQueryOperatorParameter$1(parameters.getItem$1(i).Element$1, queryParameters, names, diagnostics);
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_stringSetPool.ReturnToPool(names);
                }
            },
            CheckQueryOperatorParameter$1: function (parameter, queryOperatorParameters, namesAlreadySpecified, diagnostics) {
                var name = parameter.Name.SimpleName;
                if (!System.String.isNullOrEmpty(name)) {
                    var qop = Kusto.Language.Binding.Binder.GetQueryOperatorParameter(name, queryOperatorParameters);

                    if (qop != null) {
                        this.SetSemanticInfo(parameter.Name, new Kusto.Language.Binding.SemanticInfo.$ctor3(qop, Kusto.Language.Symbols.ScalarTypes.Unknown));

                        if (!qop.IsRepeatable) {
                            if (namesAlreadySpecified.contains(qop.Name) || (System.Array.getCount(qop.Aliases, System.String) > 0 && System.Linq.Enumerable.from(qop.Aliases, System.String).any(function (a) {
                                    return namesAlreadySpecified.contains(a);
                                }))) {
                                diagnostics.add(Kusto.Language.DiagnosticFacts.GetParameterAlreadySpecified(name).WithLocation(parameter.Name));
                            } else {
                                namesAlreadySpecified.add(qop.Name);
                            }
                        }

                        this.CheckQueryOperatorParameter(parameter, qop, diagnostics);
                    } else {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetUnknownQueryOperatorParameterName(name).WithLocation(parameter.Name));
                    }
                }
            },
            CheckQueryOperatorParameter: function (parameter, qop, diagnostics) {
                if (!this.IsQueryOperatorParameterKind(parameter, qop)) {
                    switch (qop.ValueKind) {
                        case Kusto.Language.QueryOperatorParameterValueKind.IntegerLiteral: 
                            this.CheckIsLiteral(parameter.Expression, diagnostics);
                            this.CheckIsInteger(parameter.Expression, diagnostics);
                            break;
                        case Kusto.Language.QueryOperatorParameterValueKind.NumericLiteral: 
                        case Kusto.Language.QueryOperatorParameterValueKind.ForcedRealLiteral: 
                            this.CheckIsLiteral(parameter.Expression, diagnostics);
                            this.CheckIsNumber(parameter.Expression, diagnostics);
                            break;
                        case Kusto.Language.QueryOperatorParameterValueKind.ScalarLiteral: 
                            this.CheckIsLiteral(parameter.Expression, diagnostics);
                            this.CheckIsScalar(parameter.Expression, diagnostics);
                            break;
                        case Kusto.Language.QueryOperatorParameterValueKind.SummableLiteral: 
                            this.CheckIsLiteral(parameter.Expression, diagnostics);
                            this.CheckIsSummable(parameter.Expression, diagnostics);
                            break;
                        case Kusto.Language.QueryOperatorParameterValueKind.StringLiteral: 
                            this.CheckIsLiteral(parameter.Expression, diagnostics);
                            this.CheckIsExactType(parameter.Expression, Kusto.Language.Symbols.ScalarTypes.String, diagnostics);
                            break;
                        case Kusto.Language.QueryOperatorParameterValueKind.BoolLiteral: 
                            this.CheckIsLiteral(parameter.Expression, diagnostics);
                            this.CheckIsExactType(parameter.Expression, Kusto.Language.Symbols.ScalarTypes.Bool, diagnostics);
                            break;
                        case Kusto.Language.QueryOperatorParameterValueKind.Column: 
                            this.CheckIsColumn(parameter.Expression, diagnostics);
                            break;
                        case Kusto.Language.QueryOperatorParameterValueKind.Word: 
                        case Kusto.Language.QueryOperatorParameterValueKind.WordOrNumber: 
                            this.CheckIsTokenLiteral(parameter.Expression, qop.Values, qop.IsCaseSensitive, diagnostics);
                            break;
                    }

                    if (qop.ValueKind !== Kusto.Language.QueryOperatorParameterValueKind.Word && qop.ValueKind !== Kusto.Language.QueryOperatorParameterValueKind.WordOrNumber && qop.Values != null && System.Array.getCount(qop.Values, System.String) > 0) {
                        this.CheckIsLiteral(parameter.Expression, diagnostics);
                        this.CheckLiteralValue(parameter.Expression, qop.Values, qop.IsCaseSensitive, diagnostics);
                    }
                }
            },
            IsQueryOperatorParameterKind: function (parameter, qop) {
                var type = this.GetResultTypeOrError(parameter.Expression);
                switch (qop.ValueKind) {
                    case Kusto.Language.QueryOperatorParameterValueKind.IntegerLiteral: 
                        if (!(parameter.Expression.IsLiteral && Kusto.Language.Binding.Binder.IsInteger(type))) {
                            return false;
                        }
                        break;
                    case Kusto.Language.QueryOperatorParameterValueKind.NumericLiteral: 
                    case Kusto.Language.QueryOperatorParameterValueKind.ForcedRealLiteral: 
                        if (!(parameter.Expression.IsLiteral && Kusto.Language.Binding.Binder.IsNumber(type))) {
                            return false;
                        }
                        break;
                    case Kusto.Language.QueryOperatorParameterValueKind.ScalarLiteral: 
                        if (!(parameter.Expression.IsLiteral && type.IsScalar)) {
                            return false;
                        }
                        break;
                    case Kusto.Language.QueryOperatorParameterValueKind.SummableLiteral: 
                        if (!(parameter.Expression.IsLiteral && Kusto.Language.Binding.Binder.IsSummable(type))) {
                            return false;
                        }
                        break;
                    case Kusto.Language.QueryOperatorParameterValueKind.StringLiteral: 
                        if (!(parameter.Expression.IsLiteral && this.IsType(parameter.Expression, Kusto.Language.Symbols.ScalarTypes.String))) {
                            return false;
                        }
                        break;
                    case Kusto.Language.QueryOperatorParameterValueKind.BoolLiteral: 
                        if (!(parameter.Expression.IsLiteral && this.IsType(parameter.Expression, Kusto.Language.Symbols.ScalarTypes.Bool))) {
                            return false;
                        }
                        break;
                    case Kusto.Language.QueryOperatorParameterValueKind.Column: 
                        if (!(Bridge.is(this.GetReferencedSymbol(parameter.Expression), Kusto.Language.Symbols.ColumnSymbol))) {
                            return false;
                        }
                        break;
                    case Kusto.Language.QueryOperatorParameterValueKind.Word: 
                        if (!this.IsTokenLiteral(parameter.Expression, qop.Values, qop.IsCaseSensitive)) {
                            return false;
                        }
                        break;
                    case Kusto.Language.QueryOperatorParameterValueKind.WordOrNumber: 
                        if (!Kusto.Language.Binding.Binder.IsNumber(type) && !this.IsTokenLiteral(parameter.Expression, qop.Values, qop.IsCaseSensitive)) {
                            return false;
                        }
                        break;
                }

                if (qop.ValueKind !== Kusto.Language.QueryOperatorParameterValueKind.Word && qop.ValueKind !== Kusto.Language.QueryOperatorParameterValueKind.WordOrNumber && qop.Values != null && System.Array.getCount(qop.Values, System.String) > 0) {
                    if (!parameter.Expression.IsLiteral) {
                        return false;
                    }

                    if (!this.IsLiteralValue(parameter.Expression, qop.Values, qop.IsCaseSensitive)) {
                        return false;
                    }
                }

                return true;
            },
            /**
             * Checks that the data value expressions have the types corresponding to the columns.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.SyntaxList$1}    expressions    
             * @param   {System.Collections.Generic.List$1}     columns        
             * @param   {System.Collections.Generic.List$1}     diagnostics
             * @return  {void}
             */
            CheckDataValueTypes: function (expressions, columns, diagnostics) {
                if (columns.Count > 0 && expressions.Count % columns.Count !== 0) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetIncorrectNumberOfDataValues(columns.Count).WithLocation(expressions));
                }

                for (var i = 0, n = expressions.Count; i < n; i = (i + 1) | 0) {
                    var expr = expressions.getItem$1(i).Element$1;
                    this.CheckIsScalar(expr, diagnostics);

                    // note: data values are convertible at runtime so no check is given
                    // consider adding checks for obvious incovertible values
                    // var column = columns[i % columns.Count];
                    // CheckIsType(expr, column.Type, true, diagnostics);
                }
            },
            CheckIsScalar: function (expression, diagnostics, resultType) {
                if (resultType === void 0) { resultType = null; }
                if (resultType == null) {
                    resultType = this.GetResultType(expression);
                }

                if (resultType != null) {
                    if (resultType.IsScalar) {
                        return true;
                    }

                    if (!resultType.IsError) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetScalarTypeExpected().WithLocation(expression));
                    }
                }

                return false;
            },
            CheckIsInteger: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsInteger(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeInteger().WithLocation(expression));
                }

                return false;
            },
            CheckIsRealOrDecimal: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsRealOrDecimal(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeRealOrDecimal().WithLocation(expression));
                }

                return false;
            },
            CheckIsIntegerOrDynamic: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsIntegerOrDynamic(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeIntegerOrDynamic().WithLocation(expression));
                }

                return false;
            },
            CheckIsStringOrDynamic: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsStringOrDynamic(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustHaveType(Kusto.Language.Symbols.ScalarSymbol, [Kusto.Language.Symbols.ScalarTypes.String, Kusto.Language.Symbols.ScalarTypes.Dynamic]).WithLocation(expression));
                }

                return false;
            },
            CheckIsNumber: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsNumber(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeNumeric().WithLocation(expression));
                }

                return false;
            },
            CheckIsNumberOrBool: function (expression, diagnostics) {
                var type = this.GetResultTypeOrError(expression);

                if (Kusto.Language.Binding.Binder.IsNumber(type) || Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Bool)) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeNumericOrBool().WithLocation(expression));
                }

                return false;
            },
            CheckIsSummable: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsSummable(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeSummable().WithLocation(expression));
                }

                return false;
            },
            CheckIsOrderable: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsOrderable(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeOrderable().WithLocation(expression));
                }

                return false;
            },
            CheckIsExactType: function (expression, type, diagnostics) {
                return this.CheckIsType(expression, type, Kusto.Language.Binding.Conversion.None, diagnostics);
            },
            CheckIsTypeOrDynamic: function (expression, type, canPromote, diagnostics) {
                var exprType = this.GetResultTypeOrError(expression);

                if (Kusto.Language.Binding.Binder.SymbolsAssignable(type, exprType, canPromote ? Kusto.Language.Binding.Conversion.Promotable : Kusto.Language.Binding.Conversion.None) || Kusto.Language.Binding.Binder.SymbolsAssignable(Kusto.Language.Symbols.ScalarTypes.Dynamic, exprType)) {
                    return true;
                }

                if (!exprType.IsError) {
                    if (Kusto.Language.Binding.Binder.SymbolsAssignable(Kusto.Language.Symbols.ScalarTypes.Dynamic, type)) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustHaveType(Kusto.Language.Symbols.TypeSymbol, [type]).WithLocation(expression));
                    } else {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustHaveType(Kusto.Language.Symbols.TypeSymbol, [type, Kusto.Language.Symbols.ScalarTypes.Dynamic]).WithLocation(expression));
                    }
                }

                return false;
            },
            IsType: function (expression, type, conversionKind) {
                if (conversionKind === void 0) { conversionKind = 0; }
                var exprType = this.GetResultTypeOrError(expression);
                return Kusto.Language.Binding.Binder.SymbolsAssignable(type, exprType, conversionKind);
            },
            CheckIsType: function (expression, type, conversionKind, diagnostics) {
                if (this.IsType(expression, type, conversionKind)) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError && !type.IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustHaveType(Kusto.Language.Symbols.TypeSymbol, [type]).WithLocation(expression));
                }

                return false;
            },
            IsAnyType: function (T, expression, types, conversionKind) {
                var $t;
                if (conversionKind === void 0) { conversionKind = 0; }
                var exprType = this.GetResultTypeOrError(expression);

                $t = Bridge.getEnumerator(types, T);
                try {
                    while ($t.moveNext()) {
                        var type = $t.Current;
                        if (Kusto.Language.Binding.Binder.SymbolsAssignable(type, exprType, conversionKind)) {
                            return true;
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return false;
            },
            CheckIsAnyType: function (T, expression, types, conversionKind, diagnostics) {
                if (this.IsAnyType(T, expression, types, conversionKind)) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustHaveType$1(T, types).WithLocation(expression));
                }

                return false;
            },
            CheckIsNotType: function (expression, type, diagnostics) {
                var exprType = this.GetResultTypeOrError(expression);

                if (Bridge.referenceEquals(exprType, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                    return true;
                }

                if (!Kusto.Language.Binding.Binder.SymbolsAssignable(type, exprType)) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetTypeNotAllowed(type).WithLocation(expression));
                }

                return false;
            },
            CheckIsIntervalType: function (expression, rangeType, diagnostics) {
                // check to see if add operator is defined between the expression's type and the range type
                var info = this.GetBinaryOperatorInfo(Kusto.Language.Symbols.OperatorKind.Add, expression, rangeType, expression, this.GetResultTypeOrError(expression), expression);
                if (info.ReferencedSymbol != null && Kusto.Language.Binding.Binder.SymbolsAssignable(rangeType, info.ResultType)) {
                    return true;
                }

                if (!rangeType.IsError && !this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetTypeIsNotIntervalType(this.GetResultTypeOrError(expression), rangeType).WithLocation(expression));
                }

                return false;
            },
            IsLiteralOrName: function (expression) {
                return Bridge.is(expression, Kusto.Language.Syntax.LiteralExpression) || Bridge.is(expression, Kusto.Language.Syntax.CompoundStringLiteralExpression) || expression.Kind === Kusto.Language.Syntax.SyntaxKind.DynamicExpression || expression.Kind === Kusto.Language.Syntax.SyntaxKind.NameReference;
            },
            CheckIsIdentifierNameDeclaration: function (name, diagnostics) {
                if (Bridge.is(name.Name, Kusto.Language.Syntax.TokenName)) {
                    return true;
                }

                diagnostics.add(Kusto.Language.DiagnosticFacts.GetIdentifierNameOnly().WithLocation(name));
                return false;
            },
            CheckIsLiteralOrName: function (expression, diagnostics) {
                if (this.IsLiteralOrName(expression)) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeConstantOrIdentifier().WithLocation(expression));
                }

                return false;
            },
            CheckIsTabular: function (expression, diagnostics, resultType) {
                if (resultType === void 0) { resultType = null; }
                resultType = resultType || this.GetResultType(expression);

                if (resultType != null) {
                    if (resultType.IsTabular) {
                        return true;
                    }

                    if (!resultType.IsError) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetTableExpected().WithLocation(expression));
                    }
                }

                return false;
            },
            CheckIsSingleColumnTable: function (expression, diagnostics, resultType) {
                if (resultType === void 0) { resultType = null; }
                resultType = resultType || this.GetResultType(expression);

                if (resultType != null) {
                    var table = Bridge.as(resultType, Kusto.Language.Symbols.TableSymbol);
                    if (table != null && System.Array.getCount(table.Columns, Kusto.Language.Symbols.ColumnSymbol) === 1) {
                        return true;
                    }

                    if (!resultType.IsError) {
                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetSingleColumnTableExpected().WithLocation(expression));
                    }
                }

                return false;
            },
            CheckIsDatabase: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsDatabase(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetDatabaseExpected().WithLocation(expression));
                }

                return false;
            },
            CheckIsCluster: function (expression, diagnostics) {
                if (Kusto.Language.Binding.Binder.IsCluster(this.GetResultTypeOrError(expression))) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetClusterExpected().WithLocation(expression));
                }

                return false;
            },
            CheckIsColumn: function (expression, diagnostics) {
                if (Bridge.is(this.GetReferencedSymbol(expression), Kusto.Language.Symbols.ColumnSymbol)) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetColumnExpected().WithLocation(expression));
                }

                return false;
            },
            CheckIsLiteral: function (expression, diagnostics) {
                if (expression.IsLiteral) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeLiteral().WithLocation(expression));
                }

                return false;
            },
            CheckIsLiteralValue: function (expression, diagnostics) {
                if (expression.IsLiteral && expression.Kind !== Kusto.Language.Syntax.SyntaxKind.TokenLiteralExpression) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeLiteralScalarValue().WithLocation(expression));
                }

                return false;
            },
            CheckLiteralStringNotEmpty: function (expression, diagnostics) {
                var $t;
                var result = this.GetResultTypeOrError(expression);
                if (!result.IsError && expression.IsLiteral) {
                    var value = ($t = expression.LiteralValue) != null ? Bridge.toString($t) : null;
                    if (!System.String.isNullOrEmpty(value)) {
                        return true;
                    }

                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustNotBeEmpty().WithLocation(expression));
                }

                return false;
            },
            IsTokenLiteral: function (expression, values, caseSensitive) {
                if (expression.Kind === Kusto.Language.Syntax.SyntaxKind.TokenLiteralExpression) {
                    if (values != null && System.Array.getCount(values, System.Object) > 0) {
                        var value = Kusto.Language.Utils.ConvertHelper.ChangeType(expression.LiteralValue, System.Array.getItem(values, 0, System.Object));
                        return Kusto.Language.Binding.Binder.Contains(values, value, caseSensitive);
                    }

                    return true;
                }

                return false;
            },
            CheckIsTokenLiteral: function (expression, values, caseSensitive, diagnostics) {
                var result = this.GetResultTypeOrError(expression);
                if (!result.IsError) {
                    if (this.IsTokenLiteral(expression, values, caseSensitive)) {
                        return true;
                    }

                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetTokenExpected$1(System.Linq.Enumerable.from(values, System.Object).select(function (v) {
                            return Bridge.toString(v);
                        }).toList(System.String)).WithLocation(expression));
                }

                return false;
            },
            CheckIsToken: function (token, values, caseSensitive, diagnostics) {
                var value = Kusto.Language.Utils.ConvertHelper.ChangeType(token.Text, System.Array.getItem(values, 0, System.Object));
                if (Kusto.Language.Binding.Binder.Contains(values, value, caseSensitive)) {
                    return true;
                }

                if (!token.HasSyntaxDiagnostics) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetTokenExpected$1(System.Linq.Enumerable.from(values, System.Object).select(function (v) {
                            return Bridge.toString(v);
                        }).toList(System.String)).WithLocation(token));
                }

                return false;
            },
            IsLiteralValue: function (expression, values, caseSensitive) {
                if (!expression.IsLiteral) {
                    return false;
                }

                var value = Kusto.Language.Utils.ConvertHelper.ChangeType(expression.LiteralValue, System.Array.getItem(values, 0, System.Object));
                return Kusto.Language.Binding.Binder.Contains(values, value, caseSensitive);
            },
            CheckLiteralValue: function (expression, values, caseSensitive, diagnostics) {
                var result = this.GetResultTypeOrError(expression);
                if (!result.IsError) {
                    if (this.IsLiteralValue(expression, values, caseSensitive)) {
                        return true;
                    }

                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustHaveValue$1(System.Object, values).WithLocation(expression));
                }

                return false;
            },
            CheckIsConstant: function (expression, diagnostics) {
                if (this.GetIsConstant(expression) || Bridge.is(expression.ReferencedSymbol, Kusto.Language.Symbols.ParameterSymbol)) {
                    return true;
                }

                if (!this.GetResultTypeOrError(expression).IsError) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetExpressionMustBeConstant().WithLocation(expression));
                }

                return false;
            },
            /**
             * Checks the invocation of a method/operator signature
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}              signature        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
             * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
             * @param   {Kusto.Language.Syntax.SyntaxElement}           location         
             * @param   {System.Collections.Generic.List$1}             dx
             * @return  {void}
             */
            CheckSignature: function (signature, $arguments, argumentTypes, location, dx) {
                var $t;
                var argCount = System.Array.getCount($arguments, Kusto.Language.Syntax.Expression);
                var initialDxCount = dx.Count;

                if (!signature.IsValidArgumentCount(argCount)) {
                    if (signature.HasRepeatableParameters) {
                        if (argCount < signature.MinArgumentCount || argCount > signature.MaxArgumentCount) {
                            dx.add(Kusto.Language.DiagnosticFacts.GetFunctionExpectsArgumentCountRange(signature.Symbol.Name, signature.MinArgumentCount, signature.MaxArgumentCount).WithLocation(location));
                        } else {
                            // not sure how else to say this.. the variable arguments are not specified correctly?
                            dx.add(Kusto.Language.DiagnosticFacts.GetFunctionHasIncorrectNumberOfArguments().WithLocation(location));
                        }
                    } else if (argCount !== System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter)) {
                        dx.add(Kusto.Language.DiagnosticFacts.GetFunctionExpectsArgumentCountExact(signature.Symbol.Name, System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter)).WithLocation(location));
                    }
                }

                // check named arguments
                var namedArgumentsAllowed = this.NamedArgumentsAllowed(signature);
                if (namedArgumentsAllowed && dx.Count === initialDxCount) {
                    var hadOutOfOrderNamedArgument = false;
                    var reportedUnnamedArgument = false;

                    for (var i = 0; i < argCount; i = (i + 1) | 0) {
                        var argument = System.Array.getItem($arguments, i, Kusto.Language.Syntax.Expression);
                        var simpleNamed = Bridge.as(argument, Kusto.Language.Syntax.SimpleNamedExpression);
                        var isNamed = simpleNamed != null;
                        var namedParameter = isNamed ? signature.GetParameter(simpleNamed.Name.SimpleName) : null;

                        if (isNamed && namedParameter == null) {
                            dx.add(Kusto.Language.DiagnosticFacts.GetUnknownArgumentName().WithLocation(simpleNamed.Name));
                        }

                        if (isNamed && !hadOutOfOrderNamedArgument) {
                            var orderedParameter = i < System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter) ? System.Array.getItem(signature.Parameters, i, Kusto.Language.Symbols.Parameter) : null;
                            hadOutOfOrderNamedArgument = !Bridge.referenceEquals(orderedParameter, namedParameter);
                        } else if (!isNamed && hadOutOfOrderNamedArgument && !reportedUnnamedArgument) {
                            dx.add(Kusto.Language.DiagnosticFacts.GetUnnamedArgumentAfterOutofOrderNamedArgument().WithLocation(argument));
                            reportedUnnamedArgument = true;
                        }
                    }
                }

                var argumentParameters = Kusto.Language.Binding.Binder.s_parameterListPool.AllocateFromPool();
                try {
                    signature.GetArgumentParameters$2($arguments, argumentParameters);

                    // check arguments... 
                    if (dx.Count === initialDxCount) {
                        for (var i1 = 0; i1 < argCount; i1 = (i1 + 1) | 0) {
                            this.CheckArgument(signature, argumentParameters, $arguments, argumentTypes, i1, dx);
                        }
                    }

                    // check for missing arguments to non-optional parameters
                    if (namedArgumentsAllowed && dx.Count === initialDxCount) {
                        $t = Bridge.getEnumerator(signature.Parameters, Kusto.Language.Symbols.Parameter);
                        try {
                            while ($t.moveNext()) {
                                var parameter = $t.Current;
                                if (!parameter.IsOptional) {
                                    var iArg = argumentParameters.indexOf(parameter);
                                    if (iArg < 0) {
                                        dx.add(Kusto.Language.DiagnosticFacts.GetMissingArgumentForParameter(parameter.Name).WithLocation(location));
                                    }
                                }
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_parameterListPool.ReturnToPool(argumentParameters);
                }
            },
            /**
             * True if named arguments are allowed for this signature.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Signature}    signature
             * @return  {boolean}
             */
            NamedArgumentsAllowed: function (signature) {
                var fn = Bridge.as(signature.Symbol, Kusto.Language.Symbols.FunctionSymbol);
                return fn != null && !this._globals.IsBuiltInFunction(fn);
            },
            AllowLooseParameterMatching: function (signature) {
                var fs;
                return ((fs = Bridge.as(signature.Symbol, Kusto.Language.Symbols.FunctionSymbol))) != null && (this._globals.IsDatabaseFunction(fs) || System.Array.getItem(fs.Signatures, 0, Kusto.Language.Symbols.Signature).Declaration != null); // user function have declarations
            },
            CheckArgument: function (signature, argumentParameters, $arguments, argumentTypes, argumentIndex, diagnostics) {
                var argument = System.Array.getItem($arguments, argumentIndex, Kusto.Language.Syntax.Expression);
                var argumentType = System.Array.getItem(argumentTypes, argumentIndex, Kusto.Language.Symbols.TypeSymbol);
                var parameter = System.Array.getItem(argumentParameters, argumentIndex, Kusto.Language.Symbols.Parameter);

                if (parameter != null) {
                    if (Bridge.is(argument, Kusto.Language.Syntax.StarExpression) && signature.Symbol.Kind !== Kusto.Language.Symbols.SymbolKind.Operator) {
                        if (parameter.ArgumentKind !== Kusto.Language.Symbols.ArgumentKind.StarOnly && parameter.ArgumentKind !== Kusto.Language.Symbols.ArgumentKind.StarAllowed) {
                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetStarExpressionNotAllowed().WithLocation(argument));
                        }
                    } else if (Kusto.Language.Binding.Binder.IsDefaultValueIndicator(parameter, argument)) {
                        // do nothing, this is a legal value for this parameter
                    } else {
                        var cn;
                        if (((cn = Bridge.as(argument, Kusto.Language.Syntax.CompoundNamedExpression))) != null) {
                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetCompoundNamedArgumentsNotSupported().WithLocation(cn.Names));
                        }

                        // see through any named argument
                        argument = Kusto.Language.Binding.Binder.GetUnderlyingExpression(argument);

                        switch (parameter.TypeKind) {
                            case Kusto.Language.Symbols.ParameterTypeKind.Declared: 
                                switch (this.GetParameterMatchKind(signature, argumentParameters, argumentTypes, parameter, argument, argumentType)) {
                                    case Kusto.Language.Binding.ParameterMatchKind.Compatible: 
                                    case Kusto.Language.Binding.ParameterMatchKind.None: 
                                        if (!this.AllowLooseParameterMatching(signature)) {
                                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetTypeExpected$1(parameter.DeclaredTypes).WithLocation(argument));
                                        }
                                        break;
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Scalar: 
                                this.CheckIsScalar(argument, diagnostics, argumentType);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Integer: 
                                this.CheckIsInteger(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.RealOrDecimal: 
                                this.CheckIsRealOrDecimal(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.IntegerOrDynamic: 
                                this.CheckIsIntegerOrDynamic(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.StringOrDynamic: 
                                this.CheckIsStringOrDynamic(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Number: 
                                this.CheckIsNumber(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.NumberOrBool: 
                                this.CheckIsNumberOrBool(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Summable: 
                                this.CheckIsSummable(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Orderable: 
                                this.CheckIsOrderable(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.NotBool: 
                                if (this.CheckIsScalar(argument, diagnostics)) {
                                    this.CheckIsNotType(argument, Kusto.Language.Symbols.ScalarTypes.Bool, diagnostics);
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.NotRealOrBool: 
                                if (this.CheckIsScalar(argument, diagnostics)) {
                                    this.CheckIsNotType(argument, Kusto.Language.Symbols.ScalarTypes.Real, diagnostics);
                                    this.CheckIsNotType(argument, Kusto.Language.Symbols.ScalarTypes.Bool, diagnostics);
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.NotDynamic: 
                                if (this.CheckIsScalar(argument, diagnostics)) {
                                    this.CheckIsNotType(argument, Kusto.Language.Symbols.ScalarTypes.Dynamic, diagnostics);
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Tabular: 
                                this.CheckIsTabular(argument, diagnostics, argumentType);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Database: 
                                this.CheckIsDatabase(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Cluster: 
                                this.CheckIsCluster(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Parameter0: 
                                this.CheckIsExactType(argument, System.Array.getItem(argumentTypes, 0, Kusto.Language.Symbols.TypeSymbol), diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Parameter1: 
                                this.CheckIsExactType(argument, System.Array.getItem(argumentTypes, 1, Kusto.Language.Symbols.TypeSymbol), diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Parameter2: 
                                this.CheckIsExactType(argument, System.Array.getItem(argumentTypes, 2, Kusto.Language.Symbols.TypeSymbol), diagnostics);
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.CommonScalar: 
                                if (this.CheckIsScalar(argument, diagnostics)) {
                                    var commonType = Kusto.Language.Binding.Binder.GetCommonArgumentType(argumentParameters, argumentTypes);
                                    if (commonType != null) {
                                        this.CheckIsType(argument, commonType, Kusto.Language.Binding.Conversion.Promotable, diagnostics);
                                    }
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.CommonScalarOrDynamic: 
                                if (this.CheckIsScalar(argument, diagnostics)) {
                                    var commonType1 = Kusto.Language.Binding.Binder.GetCommonArgumentType(argumentParameters, argumentTypes);
                                    if (commonType1 != null) {
                                        this.CheckIsTypeOrDynamic(argument, commonType1, true, diagnostics);
                                    }
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.CommonNumber: 
                                if (this.CheckIsNumber(argument, diagnostics)) {
                                    var commonType2 = Kusto.Language.Binding.Binder.GetCommonArgumentType(argumentParameters, argumentTypes);
                                    if (commonType2 != null) {
                                        this.CheckIsType(argument, commonType2, Kusto.Language.Binding.Conversion.Promotable, diagnostics);
                                    }
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.CommonSummable: 
                                if (this.CheckIsSummable(argument, diagnostics)) {
                                    var commonType3 = Kusto.Language.Binding.Binder.GetCommonArgumentType(argumentParameters, argumentTypes);
                                    if (commonType3 != null) {
                                        this.CheckIsType(argument, commonType3, Kusto.Language.Binding.Conversion.Promotable, diagnostics);
                                    }
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.CommonOrderable: 
                                if (this.CheckIsOrderable(argument, diagnostics)) {
                                    var commonType4 = Kusto.Language.Binding.Binder.GetCommonArgumentType(argumentParameters, argumentTypes);
                                    if (commonType4 != null) {
                                        this.CheckIsType(argument, commonType4, Kusto.Language.Binding.Conversion.Promotable, diagnostics);
                                    }
                                }
                                break;
                        }

                        switch (parameter.ArgumentKind) {
                            case Kusto.Language.Symbols.ArgumentKind.Column: 
                                this.CheckIsColumn(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ArgumentKind.Constant: 
                                this.CheckIsConstant(argument, diagnostics);
                                break;
                            case Kusto.Language.Symbols.ArgumentKind.Literal: 
                                if (this.CheckIsLiteral(argument, diagnostics) && System.Array.getCount(parameter.Values, System.Object) > 0) {
                                    this.CheckLiteralValue(argument, parameter.Values, parameter.IsCaseSensitive, diagnostics);
                                }
                                break;
                            case Kusto.Language.Symbols.ArgumentKind.LiteralNotEmpty: 
                                if (this.CheckIsLiteral(argument, diagnostics)) {
                                    this.CheckLiteralStringNotEmpty(argument, diagnostics);
                                }
                                break;
                        }
                    }
                }
            },
            BindName: function (name, match, location, includeRowScope, inferColumns) {
                var $t;
                if (includeRowScope === void 0) { includeRowScope = true; }
                if (inferColumns === void 0) { inferColumns = true; }
                if (Bridge.referenceEquals(name, "")) {
                    return Kusto.Language.Binding.Binder.ErrorInfo;
                }

                var list = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                try {
                    var allowZeroArgumentInvocation = false;

                    if (this._pathScope != null) {
                        if (Bridge.referenceEquals(this._pathScope, Kusto.Language.Symbols.ScalarTypes.Dynamic)) {
                            // any x.y where x is dynamic, is also dynamic
                            return Kusto.Language.Binding.Binder.LiteralDynamicInfo;
                        } else if (Bridge.referenceEquals(this._pathScope, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                            // any x.y where x is unknown, is also unknown (though probably dynamic)
                            return Kusto.Language.Binding.Binder.UnknownInfo;
                        } else if (Bridge.referenceEquals(this._pathScope, Kusto.Language.Symbols.ErrorSymbol.Instance)) {
                            // any x.y where x is an error, is also an error
                            return Kusto.Language.Binding.Binder.ErrorInfo;
                        } else {
                            var grp;
                            if (((grp = Bridge.as(this._pathScope, Kusto.Language.Symbols.GroupSymbol))) != null && Kusto.Language.Binding.Binder.IsPassThrough(grp)) {
                                // get all symbols for all databases
                                var savePathScope = this._pathScope;
                                $t = Bridge.getEnumerator(grp.Members, Kusto.Language.Symbols.Symbol);
                                try {
                                    while ($t.moveNext()) {
                                        var s = $t.Current;
                                        this._pathScope = s;
                                        var alz = this.GetMatchingSymbols(name, match, location, list, includeRowScope, inferColumns);
                                        allowZeroArgumentInvocation = !!(allowZeroArgumentInvocation | alz);
                                    }
                                } finally {
                                    if (Bridge.is($t, System.IDisposable)) {
                                        $t.System$IDisposable$Dispose();
                                    }
                                }

                                this._pathScope = savePathScope;
                                Kusto.Language.Binding.Binder.MakeDistinct(list);
                                return this.GetMatchingSymbolResult(name, location, list, allowZeroArgumentInvocation);
                            }
                        }
                    } else if (Bridge.referenceEquals(name, "$left") && this._rowScope != null && this._rightRowScope != null) {
                        var tuple = this.GetTuple(this._rowScope);
                        return new Kusto.Language.Binding.SemanticInfo.$ctor3(tuple, tuple);
                    } else if (Bridge.referenceEquals(name, "$right") && this._rightRowScope != null) {
                        var tuple1 = this.GetTuple(this._rightRowScope);
                        return new Kusto.Language.Binding.SemanticInfo.$ctor3(tuple1, tuple1);
                    }

                    if (list.Count === 0) {
                        allowZeroArgumentInvocation = this.GetMatchingSymbols(name, match, location, list, includeRowScope, inferColumns);
                    }

                    return this.GetMatchingSymbolResult(name, location, list, allowZeroArgumentInvocation);
                } finally {
                    Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(list);
                }
            },
            CanBindName: function (name, match, location, includeRowScope, inferColumns) {
                var $t;
                if (includeRowScope === void 0) { includeRowScope = true; }
                if (inferColumns === void 0) { inferColumns = true; }
                if (Bridge.referenceEquals(name, "")) {
                    return false;
                }

                var list = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                try {
                    if (this._pathScope != null) {
                        if (Bridge.referenceEquals(this._pathScope, Kusto.Language.Symbols.ScalarTypes.Dynamic)) {
                            // any x.y where x is dynamic, is also dynamic
                            return true;
                        } else if (Bridge.referenceEquals(this._pathScope, Kusto.Language.Symbols.ScalarTypes.Unknown)) {
                            // any x.y where x is unknown, is also unknown (though probably dynamic)
                            return true;
                        } else if (Bridge.referenceEquals(this._pathScope, Kusto.Language.Symbols.ErrorSymbol.Instance)) {
                            // any x.y where x is an error, is also an error
                            return true;
                        } else {
                            var grp;
                            if (((grp = Bridge.as(this._pathScope, Kusto.Language.Symbols.GroupSymbol))) != null && Kusto.Language.Binding.Binder.IsPassThrough(grp)) {
                                // get all symbols for all databases
                                var savePathScope = this._pathScope;
                                $t = Bridge.getEnumerator(grp.Members, Kusto.Language.Symbols.Symbol);
                                try {
                                    while ($t.moveNext()) {
                                        var s = $t.Current;
                                        this._pathScope = s;
                                        var _ = this.GetMatchingSymbols(name, match, location, list, includeRowScope, inferColumns);
                                    }
                                } finally {
                                    if (Bridge.is($t, System.IDisposable)) {
                                        $t.System$IDisposable$Dispose();
                                    }
                                }

                                this._pathScope = savePathScope;
                                return list.Count > 0;
                            }
                        }
                    } else if (Bridge.referenceEquals(name, "$left") && this._rowScope != null && this._rightRowScope != null) {
                        return true;
                    } else if (Bridge.referenceEquals(name, "$right") && this._rightRowScope != null) {
                        return true;
                    }

                    if (list.Count === 0) {
                        var _1 = this.GetMatchingSymbols(name, match, location, list, includeRowScope, inferColumns);
                    }

                    return list.Count > 0;
                } finally {
                    Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(list);
                }
            },
            IsInsideDatabaseFunctionDeclaration: function (location) {
                // this is true when during expansion binding of database functions
                if (this._currentFunction != null) {
                    return true;
                }

                return Kusto.Language.Binding.Binder.IsInsideControlCommandFunctionDeclaration(location);
            },
            GetMatchingSymbols: function (name, match, location, list, includeRowScope, inferColumns) {
                var allowZeroArgumentInvocation = false;

                if (Kusto.Language.Binding.Binder.IsFunctionCallName(location)) {
                    if (Bridge.is(this._pathScope, Kusto.Language.Symbols.DatabaseSymbol)) {
                        if (Bridge.referenceEquals(name, Kusto.Language.Functions.Table.Name)) {
                            list.add(Kusto.Language.Functions.Table);
                        } else if (Bridge.referenceEquals(name, Kusto.Language.Functions.ExternalTable.Name)) {
                            list.add(Kusto.Language.Functions.ExternalTable);
                        } else if (Bridge.referenceEquals(name, Kusto.Language.Functions.MaterializedView.Name)) {
                            list.add(Kusto.Language.Functions.MaterializedView);
                        } else {
                            this._pathScope.GetMembers$1(name, Kusto.Language.Symbols.SymbolMatch.Function, list);
                        }
                    } else if (Bridge.is(this._pathScope, Kusto.Language.Symbols.ClusterSymbol) && Bridge.referenceEquals(name, Kusto.Language.Functions.Database.Name)) {
                        list.add(Kusto.Language.Functions.Database);
                    } else {
                        this.GetFunctionsInScope(this._scopeKind, name, Kusto.Language.IncludeFunctionKind.All, list);
                    }
                } else {
                    // don't match the database functions that have same name as database tables
                    // if we are inside declaration of a database function
                    if (this.IsInsideDatabaseFunctionDeclaration(location) && this._currentDatabase.GetAnyTable(name) != null) {
                        match &= -9;
                    }

                    // if there is a path scope, then the operation was <path>.<name>
                    if (this._pathScope != null) {
                        var col = { };
                        var tuple; // check for inferred columns associated with scan operator step variables (encoded as tuples associated with a table)
                        if (((tuple = Bridge.as(this._pathScope, Kusto.Language.Symbols.TupleSymbol))) != null && tuple.RelatedTable != null && tuple.RelatedTable.IsOpen && inferColumns && this.TryGetDeclaredOrInferredColumn(tuple.RelatedTable, name, col)) {
                            list.add(col.v);
                        } else {
                            var ds;
                            if (((ds = Bridge.as(this._pathScope, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                                // first look for functions
                                this._pathScope.GetMembers$1(name, match & Kusto.Language.Symbols.SymbolMatch.Function, list);
                                Kusto.Language.Binding.Binder.RemoveFunctionsThatCannotBeInvokedWithZeroArgs(list);
                                // database functions don't require argument lists to invoke
                                allowZeroArgumentInvocation = list.Count > 0;
                                if (list.Count === 0) {
                                    // next look for anything else (tables)
                                    this._pathScope.GetMembers$1(name, match & -9, list);
                                }

                                // otherwise this is possible an open table
                                if (list.Count === 0 && ds.IsOpen) {
                                    var table = this.GetOpenTable(name, ds);
                                    list.add(table);
                                    return allowZeroArgumentInvocation;
                                }
                            } else if (!(Bridge.is(this._pathScope, Kusto.Language.Symbols.TableSymbol)) || Kusto.Language.Binding.Binder.IsInsideControlCommandProper(location)) {
                                // lookup named members
                                this._pathScope.GetMembers$1(name, match, list);
                            }
                        }
                    }

                    // check binding against any columns in the row scope
                    // note: the row scope is the scope containing the columns from the left that are in scope on the right of a pipe operator.
                    if (list.Count === 0 && this._rowScope != null && includeRowScope) {
                        this._rowScope.GetMembers$1(name, match, list);
                    }

                    // try secondary right-side row scope (used in join operator)
                    if (list.Count === 0 && this._rightRowScope != null) {
                        this._rightRowScope.GetMembers$1(name, match, list);
                    }

                    // try local variables (includes any user-defined functions)
                    // these are defined by a previous let statement
                    if (list.Count === 0) {
                        this._localScope.GetSymbols$1(name, match, list);

                        // user defined functions do not require argument list if it has no arguments
                        allowZeroArgumentInvocation = list.Count > 0;
                    }

                    // look for zero-argument database functions
                    if (list.Count === 0 && Kusto.Language.Binding.Binder.IsPossibleInvocableFunctionWithoutArgumentList(location) && (match & Kusto.Language.Symbols.SymbolMatch.Function) !== 0) {
                        // database functions only (locally defined functions are already handled above)
                        this.GetFunctionsInScope(this._scopeKind, name, Kusto.Language.IncludeFunctionKind.DatabaseFunctions, list);
                        Kusto.Language.Binding.Binder.RemoveFunctionsThatCannotBeInvokedWithZeroArgs(list);

                        // database functions do not require argument list if it has zero arguments.
                        allowZeroArgumentInvocation = list.Count > 0;
                    }

                    // other items in database (tables, etc)
                    if (list.Count === 0 && this._currentDatabase != null) {
                        this._currentDatabase.GetMembers$1(name, match, list);
                    }

                    // databases can be directly referenced in commands
                    if (list.Count === 0 && this._currentCluster != null && (match & Kusto.Language.Symbols.SymbolMatch.Database) !== 0) {
                        this._currentCluster.GetMembers$1(name, match, list);
                    }

                    // look for any built-in functions with matching name (even with those with parameters)
                    if (list.Count === 0 && (match & Kusto.Language.Symbols.SymbolMatch.Function) !== 0) {
                        this.GetFunctionsInScope(this._scopeKind, name, Kusto.Language.IncludeFunctionKind.BuiltInFunctions, list);
                    }

                    // infer column for this otherwise unbound reference?
                    if (list.Count === 0 && this._rowScope != null && this._rowScope.IsOpen && (match & Kusto.Language.Symbols.SymbolMatch.Column) !== 0 && includeRowScope && inferColumns) {
                        // row scope table has open definition, so create an inferred column for the otherwise unbound name
                        list.add(this.GetOpenTableInferredColumn(name, this._rowScope));
                    }
                }

                return allowZeroArgumentInvocation;
            },
            GetMatchingSymbolResult: function (name, location, matches, allowZeroArgumentInvocation) {
                var $t;
                if (matches.Count === 1) {
                    var item = matches.getItem(0);
                    var resultType = Kusto.Language.Binding.Binder.GetResultType(item);
                    var fn;
                    // check for zero-parameter function invocation not part of a function call node
                    if (((fn = Bridge.as(resultType, Kusto.Language.Symbols.FunctionSymbol))) != null && Kusto.Language.Binding.Binder.IsPossibleInvocableFunctionWithoutArgumentList(location)) {
                        var sig = System.Linq.Enumerable.from(fn.Signatures, Kusto.Language.Symbols.Signature).firstOrDefault(function (s) {
                                return s.MinArgumentCount === 0;
                            }, null);
                        if (sig != null && allowZeroArgumentInvocation) {
                            var funResult = this.GetFunctionCallResult$1(sig, Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Syntax.Expression).Instance, Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Symbols.TypeSymbol).Instance);
                            return new Kusto.Language.Binding.SemanticInfo.$ctor3(item, funResult.Type, void 0, false, funResult.Info);
                        } else {
                            var returnType = this.GetCommonReturnType(fn.Signatures, Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Syntax.Expression).Instance, Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Symbols.TypeSymbol).Instance);
                            return new Kusto.Language.Binding.SemanticInfo.$ctor2(item, returnType, Kusto.Language.DiagnosticFacts.GetFunctionRequiresArgumentList(name).WithLocation(location));
                        }
                    } else {
                        var eg;
                        if (((eg = Bridge.as(resultType, Kusto.Language.Symbols.EntityGroupSymbol))) != null) {
                            // entity group symbols are like function symbols that have a body to be evaluated
                            // in order to determine their result type
                            var result = this.GetFunctionCallResult$1(eg.Signature, Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Syntax.Expression).Instance, Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Symbols.TypeSymbol).Instance);
                            return new Kusto.Language.Binding.SemanticInfo.$ctor3(item, result.Type, void 0, false, result.Info);
                        } else {
                            return Kusto.Language.Binding.Binder.CreateSemanticInfo(item);
                        }
                    }
                } else if (matches.Count === 0) {
                    if (Kusto.Language.Binding.Binder.IsFunctionCallName(location)) {
                        if (this._globals.GetAggregate(name) != null && this._scopeKind !== Kusto.Language.Binding.ScopeKind.Aggregate) {
                            return new Kusto.Language.Binding.SemanticInfo.$ctor4(Kusto.Language.Symbols.ErrorSymbol.Instance, Kusto.Language.DiagnosticFacts.GetAggregateNotAllowedInThisContext(name).WithLocation(location));
                        } else if (this._globals.GetPlugIn(name) != null && this._scopeKind !== Kusto.Language.Binding.ScopeKind.PlugIn) {
                            return new Kusto.Language.Binding.SemanticInfo.$ctor4(Kusto.Language.Symbols.ErrorSymbol.Instance, Kusto.Language.DiagnosticFacts.GetPluginNotAllowedInThisContext(name).WithLocation(location));
                        } else if (Kusto.Language.Binding.Binder.IsEvaluateFunctionName(location)) {
                            if (Kusto.Language.PlugIns.GetPlugIn(name) != null) {
                                return new Kusto.Language.Binding.SemanticInfo.$ctor4(Kusto.Language.Symbols.ErrorSymbol.Instance, Kusto.Language.DiagnosticFacts.GetPlugInFunctionIsNotEnabled(name).WithLocation(location));
                            } else {
                                return new Kusto.Language.Binding.SemanticInfo.$ctor4(Kusto.Language.Symbols.ErrorSymbol.Instance, Kusto.Language.DiagnosticFacts.GetPlugInFunctionNotDefined(name).WithLocation(location));
                            }
                        } else if (Kusto.Language.Binding.Binder.IsFuzzyUnionOperand(location)) {
                            return null;
                        } else {
                            var ds;
                            if (((ds = Bridge.as(this._pathScope, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                                if (ds != null && ds.IsOpen) {
                                    return new Kusto.Language.Binding.SemanticInfo.$ctor5(new Kusto.Language.Symbols.TableSymbol.$ctor4("").WithIsOpen(true));
                                } else {
                                    return new Kusto.Language.Binding.SemanticInfo.$ctor4(new Kusto.Language.Symbols.TableSymbol.$ctor4("").WithIsOpen(true), Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownFunction(name).WithLocation(location));
                                }
                            } else if (Kusto.Language.Binding.Binder.IsInTabularContext(location)) {
                                return new Kusto.Language.Binding.SemanticInfo.$ctor4(new Kusto.Language.Symbols.TableSymbol.$ctor4("").WithIsOpen(true), Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownFunction(name).WithLocation(location));
                            } else {
                                return new Kusto.Language.Binding.SemanticInfo.$ctor4(Kusto.Language.Symbols.ErrorSymbol.Instance, Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownFunction(name).WithLocation(location));
                            }
                        }
                    } else if (Kusto.Language.Binding.Binder.IsInTabularContext(location)) {
                        if (Kusto.Language.Binding.Binder.IsFuzzyUnionOperand(location)) {
                            return new Kusto.Language.Binding.SemanticInfo.$ctor4(new Kusto.Language.Symbols.TableSymbol.ctor().WithIsOpen(true), Kusto.Language.DiagnosticFacts.GetFuzzyUnionOperandNotDefined(name).WithLocation(location));
                        } else {
                            var ds1;
                            if (((ds1 = Bridge.as(this._pathScope, Kusto.Language.Symbols.DatabaseSymbol))) != null && ds1.IsOpen) {
                                return new Kusto.Language.Binding.SemanticInfo.$ctor5(new Kusto.Language.Symbols.TableSymbol.$ctor4(name).WithIsOpen(true));
                            } else {
                                return new Kusto.Language.Binding.SemanticInfo.$ctor4(new Kusto.Language.Symbols.TableSymbol.$ctor4(name).WithIsOpen(true), Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownTable(name).WithLocation(location));
                            }
                        }
                    } else {
                        return new Kusto.Language.Binding.SemanticInfo.$ctor4(Kusto.Language.Symbols.ErrorSymbol.Instance, Kusto.Language.DiagnosticFacts.GetNameDoesNotReferToAnyKnownItem(name).WithLocation(location));
                    }
                } else {
                    return new Kusto.Language.Binding.SemanticInfo.$ctor2(new Kusto.Language.Symbols.GroupSymbol.$ctor1(($t = Kusto.Language.Symbols.Symbol, System.Linq.Enumerable.from(matches, $t).toList($t))), Kusto.Language.Symbols.ErrorSymbol.Instance, Kusto.Language.DiagnosticFacts.GetNameRefersToMoreThanOneItem(name).WithLocation(location));
                }
            },
            GetBinaryOperatorInfo$1: function (kind, left, right, location) {
                return this.GetBinaryOperatorInfo(kind, left, this.GetResultTypeOrError(left), right, this.GetResultTypeOrError(right), location);
            },
            GetBinaryOperatorInfo: function (kind, left, leftType, right, rightType, location) {
                var $arguments = Kusto.Language.Binding.Binder.s_expressionListPool.AllocateFromPool();
                var argumentTypes = Kusto.Language.Binding.Binder.s_typeListPool.AllocateFromPool();

                try {
                    $arguments.add(left);
                    $arguments.add(right);

                    argumentTypes.add(leftType);
                    argumentTypes.add(rightType);

                    return this.GetOperatorInfo$1(kind, $arguments, argumentTypes, location);
                } finally {
                    Kusto.Language.Binding.Binder.s_expressionListPool.ReturnToPool($arguments);
                    Kusto.Language.Binding.Binder.s_typeListPool.ReturnToPool(argumentTypes);
                }
            },
            GetUnaryOperatorInfo: function (kind, operand, location) {
                var $arguments = Kusto.Language.Binding.Binder.s_expressionListPool.AllocateFromPool();

                try {
                    $arguments.add(operand);

                    return this.GetOperatorInfo(kind, $arguments, location);
                } finally {
                    Kusto.Language.Binding.Binder.s_expressionListPool.ReturnToPool($arguments);
                }
            },
            GetOperatorInfo: function (kind, $arguments, location) {
                var argumentTypes = Kusto.Language.Binding.Binder.s_typeListPool.AllocateFromPool();

                try {
                    for (var i = 0; i < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression); i = (i + 1) | 0) {
                        argumentTypes.add(this.GetResultTypeOrError(System.Array.getItem($arguments, i, Kusto.Language.Syntax.Expression)));
                    }

                    return this.GetOperatorInfo$1(kind, $arguments, argumentTypes, location);
                } finally {
                    Kusto.Language.Binding.Binder.s_typeListPool.ReturnToPool(argumentTypes);
                }
            },
            GetOperatorInfo$1: function (kind, $arguments, argumentTypes, location) {
                var matchingSignatures = Kusto.Language.Binding.Binder.s_signatureListPool.AllocateFromPool();
                var diagnostics = Kusto.Language.Binding.Binder.s_diagnosticListPool.AllocateFromPool();

                try {
                    var op = this._globals.GetOperator(kind);

                    this.GetBestMatchingSignatures(op.Signatures, $arguments, argumentTypes, matchingSignatures);

                    if (matchingSignatures.Count === 1) {
                        this.CheckSignature(matchingSignatures.getItem(0), $arguments, argumentTypes, location, diagnostics);
                        var funResult = this.GetFunctionCallResult$1(matchingSignatures.getItem(0), $arguments, argumentTypes);
                        return new Kusto.Language.Binding.SemanticInfo.$ctor1(matchingSignatures.getItem(0), funResult.Type, diagnostics, this.AllAreConstant($arguments), void 0);
                    } else {
                        if (!Kusto.Language.Binding.Binder.ArgumentsHaveErrorsOrUnknown(argumentTypes)) {
                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetOperatorNotDefined$1(location.ToString(Kusto.Language.Syntax.IncludeTrivia.Interior), argumentTypes).WithLocation(location));
                        }

                        var returnType = this.GetCommonReturnType(matchingSignatures, $arguments, argumentTypes);
                        return new Kusto.Language.Binding.SemanticInfo.$ctor3(matchingSignatures.getItem(0).Symbol, returnType, diagnostics);
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_signatureListPool.ReturnToPool(matchingSignatures);
                    Kusto.Language.Binding.Binder.s_diagnosticListPool.ReturnToPool(diagnostics);
                }
            },
            AllAreConstant: function (expressions) {
                for (var i = 0; i < System.Array.getCount(expressions, Kusto.Language.Syntax.Expression); i = (i + 1) | 0) {
                    if (!this.GetIsConstant(System.Array.getItem(expressions, i, Kusto.Language.Syntax.Expression))) {
                        return false;
                    }
                }

                return true;
            },
            /**
             * Creates projection columns for all the expressions.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.SyntaxList$1}          expressions    
             * @param   {Kusto.Language.Binding.ProjectionBuilder}    builder        
             * @param   {System.Collections.Generic.List$1}           diagnostics    
             * @param   {number}                                      style          
             * @param   {boolean}                                     doNotRepeat
             * @return  {void}
             */
            CreateProjectionColumns$1: function (expressions, builder, diagnostics, style, doNotRepeat) {
                var $t;
                if (style === void 0) { style = 0; }
                if (doNotRepeat === void 0) { doNotRepeat = false; }
                $t = Bridge.getEnumerator(expressions, "GetEnumerator$1");
                try {
                    while ($t.moveNext()) {
                        var elem = $t.Current;
                        this.CreateProjectionColumns(elem.Element$1, builder, diagnostics, style, doNotRepeat, void 0, void 0);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            /**
             * Creates projection columns for the expression.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.Expression}            expression     
             * @param   {Kusto.Language.Binding.ProjectionBuilder}    builder        
             * @param   {System.Collections.Generic.List$1}           diagnostics    
             * @param   {number}                                      style          
             * @param   {boolean}                                     doNotRepeat    
             * @param   {Kusto.Language.Symbols.TypeSymbol}           columnType     
             * @param   {string}                                      columnName
             * @return  {void}
             */
            CreateProjectionColumns: function (expression, builder, diagnostics, style, doNotRepeat, columnType, columnName) {
                var $t, $t1, $t2, $t3, $t4, $t5, $t6;
                if (style === void 0) { style = 0; }
                if (doNotRepeat === void 0) { doNotRepeat = false; }
                if (columnType === void 0) { columnType = null; }
                if (columnName === void 0) { columnName = null; }
                var col;
                var type;

                // look through ordered expressions to find column references
                var oe = Bridge.as(expression, Kusto.Language.Syntax.OrderedExpression);
                if (oe != null) {
                    expression = oe.Expression;
                }

                // this is poorly formed syntax?
                if (expression == null) {
                    return;
                }

                if (style === Kusto.Language.Binding.Binder.ProjectionStyle.Rename) {
                    do {
                        if (Bridge.is(expression, Kusto.Language.Syntax.SimpleNamedExpression)) {
                            var n = Bridge.cast(expression, Kusto.Language.Syntax.SimpleNamedExpression);
                            {
                                var cs;
                                if (((cs = Bridge.as(this.GetReferencedSymbol(n.Expression), Kusto.Language.Symbols.ColumnSymbol))) != null) {
                                    col = builder.Rename(cs.Name, n.Name.SimpleName, diagnostics, n.Name);
                                    if (col != null) {
                                        this.SetSemanticInfo(n.Name, Kusto.Language.Binding.Binder.CreateSemanticInfo(col));
                                    }
                                } else {
                                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetColumnExpected().WithLocation(n.Expression));
                                }
                            }

                            break;
                        }

                        {
                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetRenameAssignmentExpected().WithLocation(expression));
                            break;
                        }
                    } while (false);
                } else {
                    do {
                        if (Bridge.is(expression, Kusto.Language.Syntax.SimpleNamedExpression)) {
                            var n1 = Bridge.cast(expression, Kusto.Language.Syntax.SimpleNamedExpression);
                            {
                                var tu;
                                // single name assigned from multi-value tuple just assigns the first value. equivalant to (name) = tuple
                                if (((tu = Bridge.as(n1.Expression.RawResultType, Kusto.Language.Symbols.TupleSymbol))) != null) {
                                    // first column has declared name so it uses declared name add/replace rule
                                    col = new Kusto.Language.Symbols.ColumnSymbol(n1.Name.SimpleName, columnType || System.Array.getItem(tu.Columns, 0, Kusto.Language.Symbols.ColumnSymbol).Type);
                                    builder.Declare(col, diagnostics, n1.Name, true);
                                    this.SetSemanticInfo(n1.Name, Kusto.Language.Binding.Binder.CreateSemanticInfo(col));
                                    if (doNotRepeat) {
                                        builder.DoNotAdd(System.Array.getItem(tu.Columns, 0, Kusto.Language.Symbols.ColumnSymbol));
                                    }

                                    // don't add unnamed tuple columns if print style
                                    if (style === Kusto.Language.Binding.Binder.ProjectionStyle.Print) {
                                        break;
                                    }
                                    // all other columns are not declared, so they must be unique
                                    for (var i = 1; i < System.Array.getCount(tu.Members, Kusto.Language.Symbols.Symbol); i = (i + 1) | 0) {
                                        var fs1;
                                        if (((fs1 = Bridge.as(this.GetReferencedSymbol(n1.Expression), Kusto.Language.Symbols.FunctionSymbol))) != null) {
                                            this.AddFunctionTupleResultColumn(fs1, System.Array.getItem(tu.Columns, i, Kusto.Language.Symbols.ColumnSymbol), builder, doNotRepeat, style === Kusto.Language.Binding.Binder.ProjectionStyle.Summarize);
                                        } else {
                                            builder.Add(System.Array.getItem(tu.Columns, i, Kusto.Language.Symbols.ColumnSymbol), void 0, false, doNotRepeat);
                                        }
                                    }
                                } else {
                                    var c;
                                    if (((c = Bridge.as(n1.Expression.ReferencedSymbol, Kusto.Language.Symbols.ColumnSymbol))) != null) {
                                        col = new Kusto.Language.Symbols.ColumnSymbol(n1.Name.SimpleName, columnType || c.Type);
                                        builder.Declare(col, diagnostics, n1.Name, true);
                                        this.SetSemanticInfo(n1.Name, Kusto.Language.Binding.Binder.CreateSemanticInfo(col));
                                        if (doNotRepeat) {
                                            builder.DoNotAdd(c);
                                        }
                                    } else {
                                        col = new Kusto.Language.Symbols.ColumnSymbol(n1.Name.SimpleName, columnType || this.GetResultTypeOrError(n1.Expression));
                                        builder.Declare(col, diagnostics, n1.Name, style === Kusto.Language.Binding.Binder.ProjectionStyle.Replace || style === Kusto.Language.Binding.Binder.ProjectionStyle.Extend);
                                        this.SetSemanticInfo(n1.Name, Kusto.Language.Binding.Binder.CreateSemanticInfo(col));
                                    }
                                }
                            }

                            break;
                        }

                        if (Bridge.is(expression, Kusto.Language.Syntax.CompoundNamedExpression)) {
                            var cn = Bridge.cast(expression, Kusto.Language.Syntax.CompoundNamedExpression);
                            {
                                var tupleType;
                                if (((tupleType = Bridge.as(cn.Expression.RawResultType, Kusto.Language.Symbols.TupleSymbol))) != null) {
                                    for (var i1 = 0; i1 < System.Array.getCount(tupleType.Columns, Kusto.Language.Symbols.ColumnSymbol); i1 = (i1 + 1) | 0) {
                                        col = System.Array.getItem(tupleType.Columns, i1, Kusto.Language.Symbols.ColumnSymbol);
                                        type = columnType || col.Type;
                                        // if element has name declaration then use name declaration rule
                                        if (i1 < cn.Names.Names.Count) {
                                            var nameDecl = cn.Names.Names.getItem$1(i1).Element$1;
                                            var name = nameDecl.SimpleName;
                                            col = new Kusto.Language.Symbols.ColumnSymbol(name, type);
                                            builder.Declare(col, diagnostics, nameDecl, style === Kusto.Language.Binding.Binder.ProjectionStyle.Replace || style === Kusto.Language.Binding.Binder.ProjectionStyle.Extend);
                                            this.SetSemanticInfo(nameDecl, Kusto.Language.Binding.Binder.CreateSemanticInfo(col));
                                            if (doNotRepeat) {
                                                builder.DoNotAdd(System.Array.getItem(tupleType.Columns, i1, Kusto.Language.Symbols.ColumnSymbol));
                                            }
                                        } else if (style !== Kusto.Language.Binding.Binder.ProjectionStyle.Print) {
                                            var fs11;
                                            if (((fs11 = Bridge.as(this.GetReferencedSymbol(cn.Expression), Kusto.Language.Symbols.FunctionSymbol))) != null) {
                                                this.AddFunctionTupleResultColumn(fs11, col, builder, doNotRepeat, style === Kusto.Language.Binding.Binder.ProjectionStyle.Summarize);
                                            } else {
                                                // not-declared so make unique column
                                                builder.Add(col, void 0, style === Kusto.Language.Binding.Binder.ProjectionStyle.Replace || style === Kusto.Language.Binding.Binder.ProjectionStyle.Extend, doNotRepeat);
                                            }
                                        }
                                    }

                                    // any additional names without matching tuple members gets a diagnostic
                                    for (var i2 = System.Array.getCount(tupleType.Members, Kusto.Language.Symbols.Symbol); i2 < cn.Names.Names.Count; i2 = (i2 + 1) | 0) {
                                        var nameDecl1 = cn.Names.Names.getItem$1(i2);
                                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetTheNameDoesNotHaveCorrespondingExpression().WithLocation(nameDecl1));
                                    }
                                } else if (cn.Names.Names.Count === 1) {
                                    var expr = cn.Expression;
                                    var name1 = cn.Names.Names.getItem$1(0).Element$1;
                                    var c1;
                                    if (((c1 = Bridge.as(expr.ReferencedSymbol, Kusto.Language.Symbols.ColumnSymbol))) != null) {
                                        col = new Kusto.Language.Symbols.ColumnSymbol(name1.SimpleName, columnType || c1.Type);
                                        builder.Declare(col, diagnostics, name1, true);
                                        this.SetSemanticInfo(name1, Kusto.Language.Binding.Binder.CreateSemanticInfo(col));
                                        if (doNotRepeat) {
                                            builder.DoNotAdd(c1);
                                        }
                                    } else {
                                        col = new Kusto.Language.Symbols.ColumnSymbol(name1.SimpleName, columnType || this.GetResultTypeOrError(cn.Expression));
                                        builder.Declare(col, diagnostics, name1, style === Kusto.Language.Binding.Binder.ProjectionStyle.Replace || style === Kusto.Language.Binding.Binder.ProjectionStyle.Extend);
                                        this.SetSemanticInfo(name1, Kusto.Language.Binding.Binder.CreateSemanticInfo(col));
                                    }
                                } else {
                                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetTheExpressionDoesNotHaveMultipleValues().WithLocation(cn.Names));
                                }
                            }

                            break;
                        }

                        if (Bridge.is(expression, Kusto.Language.Syntax.FunctionCallExpression)) {
                            var f = Bridge.cast(expression, Kusto.Language.Syntax.FunctionCallExpression);
                            // check for trivial case of no-op conversion operator
                            col = Kusto.Language.Binding.Binder.GetResultColumn(f);
                            if (col != null) {
                                // if the expression is a column reference, then consider it a declaration
                                builder.Declare(col.WithType(columnType || col.Type), diagnostics, expression, style === Kusto.Language.Binding.Binder.ProjectionStyle.Replace);
                                if (doNotRepeat) {
                                    builder.DoNotAdd(col);
                                }
                            } else {
                                var ftype = f.RawResultType || Kusto.Language.Symbols.ErrorSymbol.Instance;
                                var ts = Bridge.as(ftype, Kusto.Language.Symbols.TupleSymbol);
                                if (style === Kusto.Language.Binding.Binder.ProjectionStyle.Print && columnName != null && (ts == null || System.Array.getCount(ts.Columns, Kusto.Language.Symbols.ColumnSymbol) === 1)) {
                                    if (ts != null && System.Array.getCount(ts.Columns, Kusto.Language.Symbols.ColumnSymbol) === 1) {
                                        ftype = System.Array.getItem(ts.Columns, 0, Kusto.Language.Symbols.ColumnSymbol).Type;
                                    }
                                    col = new Kusto.Language.Symbols.ColumnSymbol(columnName, columnType || ftype);
                                    builder.Add(col, columnName, false, false);
                                } else {
                                    var fs;
                                    if (ts != null && ((fs = Bridge.as(this.GetReferencedSymbol(f), Kusto.Language.Symbols.FunctionSymbol))) != null) {
                                        $t = Bridge.getEnumerator(ts.Members, Kusto.Language.Symbols.Symbol);
                                        try {
                                            while ($t.moveNext()) {
                                                var c2 = Bridge.cast($t.Current, Kusto.Language.Symbols.ColumnSymbol);
                                                this.AddFunctionTupleResultColumn(fs, c2, builder, doNotRepeat, style === Kusto.Language.Binding.Binder.ProjectionStyle.Summarize);
                                            }
                                        } finally {
                                            if (Bridge.is($t, System.IDisposable)) {
                                                $t.System$IDisposable$Dispose();
                                            }
                                        }
                                    } else {
                                        var name2 = ($t1 = Kusto.Language.Binding.Binder.GetFunctionResultName(f, null, this._rowScope), $t1 != null ? $t1 : ($t2 = columnName, $t2 != null ? $t2 : this.GetDefaultColumnName(expression, style === Kusto.Language.Binding.Binder.ProjectionStyle.Extend)));
                                        col = new Kusto.Language.Symbols.ColumnSymbol(name2, columnType || ftype);
                                        builder.Add(col, void 0, style === Kusto.Language.Binding.Binder.ProjectionStyle.Replace || style === Kusto.Language.Binding.Binder.ProjectionStyle.Extend, false);
                                    }
                                }
                            }

                            break;
                        }

                        if (Bridge.is(expression, Kusto.Language.Syntax.StarExpression)) {
                            var s = Bridge.cast(expression, Kusto.Language.Syntax.StarExpression);
                            $t3 = Bridge.getEnumerator(this.GetDeclaredAndInferredColumns(this.RowScopeOrEmpty), Kusto.Language.Symbols.ColumnSymbol);
                            try {
                                while ($t3.moveNext()) {
                                    var c3 = $t3.Current;
                                    builder.Add(c3, void 0, true, doNotRepeat);
                                }
                            } finally {
                                if (Bridge.is($t3, System.IDisposable)) {
                                    $t3.System$IDisposable$Dispose();
                                }
                            }

                            break;
                        }

                        {
                            var rs = this.GetReferencedSymbol(expression);
                            col = Kusto.Language.Binding.Binder.GetResultColumn(expression);
                            if (col != null) {
                                // if the expression is a column reference, then consider it a declaration
                                builder.Declare(col.WithType(columnType || col.Type), diagnostics, expression, style === Kusto.Language.Binding.Binder.ProjectionStyle.Replace);
                                if (doNotRepeat) {
                                    builder.DoNotAdd(col);
                                }
                            } else {
                                var group;
                                if (((group = Bridge.as(rs, Kusto.Language.Symbols.GroupSymbol))) != null && style === Kusto.Language.Binding.Binder.ProjectionStyle.Reorder) {
                                    var members = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                                    try {
                                        if (oe != null && oe.Ordering != null) {
                                            if (oe.Ordering.AscOrDescKeyword.Kind === Kusto.Language.Syntax.SyntaxKind.DescKeyword) {
                                                members.AddRange(System.Linq.Enumerable.from(group.Members, Kusto.Language.Symbols.Symbol).orderByDescending(function (m) {
                                                        return m.Name;
                                                    }));
                                            } else {
                                                members.AddRange(System.Linq.Enumerable.from(group.Members, Kusto.Language.Symbols.Symbol).orderBy(function (m) {
                                                        return m.Name;
                                                    }));
                                            }
                                        } else {
                                            members.AddRange(group.Members);
                                        }

                                        // add any columns referenced in group
                                        $t4 = Bridge.getEnumerator(members);
                                        try {
                                            while ($t4.moveNext()) {
                                                var m = $t4.Current;
                                                var c4;
                                                if (((c4 = Bridge.as(m, Kusto.Language.Symbols.ColumnSymbol))) != null) {
                                                    builder.Add(c4, void 0, false, true);
                                                }
                                            }
                                        } finally {
                                            if (Bridge.is($t4, System.IDisposable)) {
                                                $t4.System$IDisposable$Dispose();
                                            }
                                        }
                                    } finally {
                                        Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(members);
                                    }
                                } else {
                                    var g;
                                    if (((g = Bridge.as(this.GetResultType(expression), Kusto.Language.Symbols.GroupSymbol))) != null) {
                                        diagnostics.add(Kusto.Language.DiagnosticFacts.GetTheExpressionRefersToMoreThanOneColumn().WithLocation(expression));
                                    } else {
                                        type = this.GetResultTypeOrError(expression);
                                        if (!type.IsError && !type.IsScalar) {
                                            diagnostics.add(Kusto.Language.DiagnosticFacts.GetScalarTypeExpected().WithLocation(expression));
                                            type = Kusto.Language.Symbols.ScalarTypes.Unknown;
                                        }

                                        if (style === Kusto.Language.Binding.Binder.ProjectionStyle.Print && columnName != null) {
                                            col = new Kusto.Language.Symbols.ColumnSymbol(columnName, columnType || type);
                                            builder.Add(col, columnName, false, false);
                                        } else {
                                            var name3 = ($t5 = Kusto.Language.Binding.Binder.GetExpressionResultName(expression, null), $t5 != null ? $t5 : ($t6 = columnName, $t6 != null ? $t6 : this.GetDefaultColumnName(expression, style === Kusto.Language.Binding.Binder.ProjectionStyle.Extend)));
                                            col = new Kusto.Language.Symbols.ColumnSymbol(name3, columnType || type);
                                            builder.Add(col, void 0, style === Kusto.Language.Binding.Binder.ProjectionStyle.Replace || style === Kusto.Language.Binding.Binder.ProjectionStyle.Extend, false);
                                        }
                                    }
                                }
                            }

                            break;
                        }
                    } while (false);
                }
            },
            GetDefaultColumnName: function (location, includeRowScope) {
                var name = "Column" + Bridge.identity(this._defaultColumnNameSuffix, ((this._defaultColumnNameSuffix = (this._defaultColumnNameSuffix + 1) | 0)));

                while (this.CanBindName(name, Kusto.Language.Symbols.SymbolMatch.Any, location, includeRowScope, false)) {
                    name = "Column" + Bridge.identity(this._defaultColumnNameSuffix, ((this._defaultColumnNameSuffix = (this._defaultColumnNameSuffix + 1) | 0)));
                }

                return name;
            },
            AddFunctionTupleResultColumn: function ($function, column, builder, doNotRepeat, isAggregate) {
                //if (builder.CanAdd(column))
                {
                    var prefix = $function.ResultNamePrefix;

                    if (prefix != null) {
                        var prefixedColumn = column.WithName(($function.ResultNamePrefix || "") + "_" + (column.Name || ""));
                        builder.Add(prefixedColumn, void 0, false, doNotRepeat);
                    } else {
                        builder.Add(column, void 0, false, doNotRepeat);
                    }
                }
            },
            /**
             * Adds all the columns declared by the symbol to the list of columns.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Symbol}        symbol     
             * @param   {System.Collections.Generic.List$1}    columns
             * @return  {void}
             */
            AddTableColumns: function (symbol, columns) {
                var $t;
                do {
                    if (Bridge.is(symbol, Kusto.Language.Symbols.TableSymbol)) {
                        var t = Bridge.cast(symbol, Kusto.Language.Symbols.TableSymbol);
                        this.GetDeclaredAndInferredColumns$1(t, columns);
                        break;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.GroupSymbol)) {
                        var g = Bridge.cast(symbol, Kusto.Language.Symbols.GroupSymbol);
                        $t = Bridge.getEnumerator(g.Members, Kusto.Language.Symbols.Symbol);
                        try {
                            while ($t.moveNext()) {
                                var s = $t.Current;
                                this.AddTableColumns(s, columns);
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }

                        break;
                    }
                } while (false);
            },
            /**
             * Add the table (or all the tables in a group) to the list of tables.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Symbols.Symbol}        symbol    
             * @param   {System.Collections.Generic.List$1}    tables
             * @return  {void}
             */
            AddTables: function (symbol, tables) {
                var $t;
                do {
                    if (Bridge.is(symbol, Kusto.Language.Symbols.TableSymbol)) {
                        var t = Bridge.cast(symbol, Kusto.Language.Symbols.TableSymbol);
                        tables.add(t);
                        break;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.GroupSymbol)) {
                        var g = Bridge.cast(symbol, Kusto.Language.Symbols.GroupSymbol);
                        $t = Bridge.getEnumerator(g.Members, Kusto.Language.Symbols.Symbol);
                        try {
                            while ($t.moveNext()) {
                                var m = $t.Current;
                                this.AddTables(m, tables);
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }

                        break;
                    }
                } while (false);
            },
            /**
             * Gets a table representing the aggregate set of columns in scope
             for find operator expressions.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.FindOperator}    node
             * @return  {Kusto.Language.Symbols.TableSymbol}
             */
            GetFindColumnsTable: function (node) {
                var tables = this.GetFindTables(node);
                return this.GetTableOfColumnsUnifiedByName(tables);
            },
            /**
             * Get the set of tables applicable to the find operator.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.FindOperator}            node
             * @return  {System.Collections.Generic.IReadOnlyList$1}
             */
            GetFindTables: function (node) {
                if (node.InClause != null) {
                    return this.GetReferencedTables(node.InClause.Expressions);
                } else {
                    // no in clause or row scope, so all tables in universe then!
                    return this.GetImpliedTables();
                }
            },
            /**
             * Gets the set of columns from the tables applicable to the search operator.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.SearchOperator}    node
             * @return  {Kusto.Language.Symbols.TableSymbol}
             */
            GetSearchColumnsTable: function (node) {
                if (this._rowScope != null && node.InClause == null) {
                    return this._rowScope;
                } else {
                    var tables = this.GetSearchTables(node);

                    // access through cache
                    return this.GetTableOfColumnsUnifiedByNameAndType(tables);
                }
            },
            /**
             * Gets the set of tables used by the search operator
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.SearchOperator}          node
             * @return  {System.Collections.Generic.IReadOnlyList$1}
             */
            GetSearchTables: function (node) {
                if (node.InClause != null) {
                    return this.GetReferencedTables(node.InClause.Expressions);
                } else if (this._rowScope != null) {
                    return System.Array.init([this._rowScope], Kusto.Language.Symbols.TableSymbol);
                } else {
                    // no in clause or row scope, so all tables in universe then!
                    return this.GetImpliedTables();
                }
            },
            /**
             * Gets all the tables accessible to the current operator through osmosis,
             not from pipe operator or sub clause.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @return  {System.Collections.Generic.IReadOnlyList$1}
             */
            GetImpliedTables: function () {
                // include current database's tables and any views in scope
                var declaredViews = Kusto.Language.Binding.Binder.s_tableListPool.AllocateFromPool();
                try {
                    this.GetViewsInScope(declaredViews);
                    if (declaredViews.Count > 0) {
                        return System.Linq.Enumerable.from(this._currentDatabase.Tables, Kusto.Language.Symbols.TableSymbol).concat(declaredViews).toList(Kusto.Language.Symbols.TableSymbol);
                    } else {
                        return this._currentDatabase.Tables;
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_tableListPool.ReturnToPool(declaredViews);
                }
            },
            /**
             * Gets all the declared views in scope
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {System.Collections.Generic.List$1}    views
             * @return  {void}
             */
            GetViewsInScope: function (views) {
                var $t;
                var localSymbols = Kusto.Language.Binding.Binder.s_symbolListPool.AllocateFromPool();
                try {
                    // get all declared tabular functions
                    this._localScope.GetSymbols(520, localSymbols);

                    // pick out just view function declarations
                    $t = Bridge.getEnumerator(localSymbols);
                    try {
                        while ($t.moveNext()) {
                            var sym = $t.Current;
                            var fs;
                            if (((fs = Bridge.as(sym, Kusto.Language.Symbols.FunctionSymbol))) != null && fs.MinArgumentCount === 0) {
                                var decl = System.Array.getItem(fs.Signatures, 0, Kusto.Language.Symbols.Signature).Declaration;
                                var fd;
                                if (decl != null && ((fd = Bridge.as(decl.Parent, Kusto.Language.Syntax.FunctionDeclaration))) != null && fd.ViewKeyword != null) {
                                    var fts = Bridge.as(fs.GetReturnType(this._globals), Kusto.Language.Symbols.TableSymbol);
                                    if (fts != null) {
                                        views.add(fts);
                                    }
                                }
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                } finally {
                    Kusto.Language.Binding.Binder.s_symbolListPool.ReturnToPool(localSymbols);
                }
            },
            /**
             * Gets the set of tables referenced by the entity expressions, 
             where each expression is a reference to a table or group of tables.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.SyntaxList$1}            list
             * @return  {System.Collections.Generic.IReadOnlyList$1}
             */
            GetReferencedTables: function (list) {
                var $t;
                var tables = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.TableSymbol)).ctor();

                $t = Bridge.getEnumerator(list, "GetEnumerator$1");
                try {
                    while ($t.moveNext()) {
                        var x = $t.Current;
                        var ts;
                        if (((ts = Bridge.as(x.Element$1.ResultType, Kusto.Language.Symbols.TableSymbol))) != null) {
                            tables.add(ts);
                        } else {
                            var gs;
                            if (((gs = Bridge.as(x.Element$1.ResultType, Kusto.Language.Symbols.GroupSymbol))) != null) {
                                tables.AddRange(System.Linq.Enumerable.from(gs.Members).ofType(Kusto.Language.Symbols.TableSymbol));
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return tables;
            },
            /**
             * Gets the columns referenced by all expressions
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.SyntaxList$1}    expressions    
             * @param   {System.Collections.Generic.List$1}     columns        
             * @param   {System.Collections.Generic.List$1}     diagnostics
             * @return  {void}
             */
            GetColumnsInColumnList: function (expressions, columns, diagnostics) {
                var $t;
                $t = Bridge.getEnumerator(expressions, "GetEnumerator$1");
                try {
                    while ($t.moveNext()) {
                        var elem = $t.Current;
                        this.GetReferencedColumns(elem.Element$1, columns, diagnostics);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            /**
             * Gets the columns referenced by one expression.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.Expression}     expression     
             * @param   {System.Collections.Generic.List$1}    columns        
             * @param   {System.Collections.Generic.List$1}    diagnostics
             * @return  {void}
             */
            GetReferencedColumns: function (expression, columns, diagnostics) {
                var $t;
                if (diagnostics === void 0) { diagnostics = null; }
                var symbol = this.GetReferencedSymbol(expression);
                do {
                    if (Bridge.is(symbol, Kusto.Language.Symbols.ColumnSymbol)) {
                        var c = Bridge.cast(symbol, Kusto.Language.Symbols.ColumnSymbol);
                        columns.add(c);
                        break;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.GroupSymbol)) {
                        var g = Bridge.cast(symbol, Kusto.Language.Symbols.GroupSymbol);
                        $t = Bridge.getEnumerator(g.Members, Kusto.Language.Symbols.Symbol);
                        try {
                            while ($t.moveNext()) {
                                var m = $t.Current;
                                var c1;
                                if (((c1 = Bridge.as(m, Kusto.Language.Symbols.ColumnSymbol))) != null) {
                                    columns.add(c1);
                                }
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }

                        break;
                    }

                    {
                        diagnostics != null ? diagnostics.add(Kusto.Language.DiagnosticFacts.GetColumnExpected().WithLocation(expression)) : null;
                        break;
                    }
                } while (false);
            },
            /**
             * Gets all the columns referenced in the syntax tree.
             *
             * @instance
             * @private
             * @this Kusto.Language.Binding.Binder
             * @memberof Kusto.Language.Binding.Binder
             * @param   {Kusto.Language.Syntax.SyntaxNode}     node       
             * @param   {System.Collections.Generic.List$1}    columns
             * @return  {void}
             */
            GetReferencedColumnsInTree: function (node, columns) {
                var $t;
                $t = Bridge.getEnumerator(node.GetDescendantsOrSelf(Kusto.Language.Syntax.NameReference), Kusto.Language.Syntax.NameReference);
                try {
                    while ($t.moveNext()) {
                        var nr = $t.Current;
                        this.GetReferencedColumns(nr, columns);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Syntax.SyntaxVisitor");

    Bridge.define("Kusto.Language.Syntax.SyntaxVisitor$1", function (TResult) { return {

    }; });

    Bridge.define("Kusto.Language.Binding.Binder.ProjectionStyle", {
        $kind: "nested enum",
        statics: {
            fields: {
                Default: 0,
                Extend: 1,
                Print: 2,
                Rename: 3,
                Replace: 4,
                Reorder: 5,
                Summarize: 6
            }
        }
    });

    /**
     * Represents the information known at the location of a user function call.
     *
     * @class Kusto.Language.Binding.CallSiteInfo
     */
    Bridge.define("Kusto.Language.Binding.CallSiteInfo", {
        props: {
            /**
             * The signature of the function being called.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Binding.CallSiteInfo
             * @function Signature
             * @type Kusto.Language.Symbols.Signature
             */
            Signature: null,
            /**
             * The parameters of the function represented as local variables.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Binding.CallSiteInfo
             * @function Locals
             * @type System.Collections.Generic.IReadOnlyList$1
             */
            Locals: null
        },
        ctors: {
            ctor: function (signature, locals) {
                this.$initialize();
                this.Signature = signature;
                this.Locals = locals;
            }
        },
        methods: {
            toString: function () {
                return (this.Signature.Symbol.Name || "") + "(" + (Bridge.toArray(System.Linq.Enumerable.from(this.Locals, Kusto.Language.Symbols.VariableSymbol).select(function (v) {
                            return v.IsConstant && v.ConstantValue != null ? System.String.format("{0}={1}", v.Name, v.ConstantValue) : v.Name;
                        })).join(",") || "") + ")";
            }
        }
    });

    /**
     * The kinds of conversions allowed between values of two different types.
     *
     * @class Kusto.Language.Binding.Conversion
     */
    Bridge.define("Kusto.Language.Binding.Conversion", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * No conversion allowed between different scalar types (strict)
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.Conversion
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Binding.Conversion
                 */
                None: 0,
                /**
                 * Type promotion (widening) allowed.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.Conversion
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Binding.Conversion
                 */
                Promotable: 1,
                /**
                 * Conversions between compatible types allowed (widening or narrowing)
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.Conversion
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Binding.Conversion
                 */
                Compatible: 2,
                /**
                 * All conversions allowed (no checking)
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.Conversion
                 * @constant
                 * @default 3
                 * @type Kusto.Language.Binding.Conversion
                 */
                Any: 3
            }
        }
    });

    /**
     * @memberof System
     * @callback System.Func
     * @return  {Kusto.Language.FunctionCallExpansion}
     */

    /**
     * Extended semantic information for function calls.
     *
     * @class Kusto.Language.Binding.FunctionCallInfo
     */
    Bridge.define("Kusto.Language.Binding.FunctionCallInfo", {
        fields: {
            /**
             * A function that returns the expanded body of the referenced function at the call site.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.FunctionCallInfo
             * @type System.Func
             */
            _expander: null,
            _expansion: null,
            _facts: null,
            _hasErrors: false,
            _diagnostics: null
        },
        props: {
            /**
             * The function body facts associated with the called function.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Binding.FunctionCallInfo
             * @function Facts
             * @type Kusto.Language.FunctionBodyFacts
             */
            Facts: {
                get: function () {
                    return this._facts;
                }
            },
            /**
             * The expansion (analyzed syntax tree in context of call arguments) of the called function.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Binding.FunctionCallInfo
             * @function Expansion
             * @type Kusto.Language.FunctionCallExpansion
             */
            Expansion: {
                get: function () {
                    if (this._expansion == null && !Bridge.staticEquals(this._expander, null)) {
                        this._expansion = this._expander();
                    }

                    return this._expansion;
                }
            },
            HasErrors: {
                get: function () {
                    return this._hasErrors;
                }
            },
            Diagnostics: {
                get: function () {
                    var $t, $t1;
                    if (this._diagnostics == null) {
                        this._diagnostics = (($t = this.Expansion) != null && ($t1 = $t.Root) != null ? $t1.GetContainedDiagnostics() : null) || Kusto.Language.Diagnostic.NoDiagnostics;
                    }

                    return this._diagnostics;
                }
            }
        },
        ctors: {
            $ctor1: function (expander, facts, hasErrors) {
                this.$initialize();
                this._expander = expander;
                this._facts = facts;
                this._hasErrors = hasErrors;
            },
            ctor: function (expansion, facts, hasErrors) {
                this.$initialize();
                this._expansion = expansion;
                this._facts = facts;
                this._hasErrors = hasErrors;
            }
        }
    });

    /**
     * Represents the result information for a function or operator invocation.
     *
     * @class Kusto.Language.Binding.FunctionCallResult
     */
    Bridge.define("Kusto.Language.Binding.FunctionCallResult", {
        $kind: "struct",
        statics: {
            methods: {
                op_Implicit: function (type) {
                    return new Kusto.Language.Binding.FunctionCallResult.$ctor1(type, null);
                },
                getDefaultValue: function () { return new Kusto.Language.Binding.FunctionCallResult(); }
            }
        },
        props: {
            /**
             * The result type of this signature.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Binding.FunctionCallResult
             * @function Type
             * @type Kusto.Language.Symbols.TypeSymbol
             */
            Type: null,
            /**
             * The extended semantic info for the function call.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Binding.FunctionCallResult
             * @function Info
             * @type Kusto.Language.Binding.FunctionCallInfo
             */
            Info: null
        },
        ctors: {
            $ctor1: function (type, info) {
                if (info === void 0) { info = null; }

                this.$initialize();
                this.Type = type;
                this.Info = info;
            },
            ctor: function () {
                this.$initialize();
            }
        },
        methods: {
            getHashCode: function () {
                var h = Bridge.addHash([7310547387, this.Type, this.Info]);
                return h;
            },
            equals: function (o) {
                if (!Bridge.is(o, Kusto.Language.Binding.FunctionCallResult)) {
                    return false;
                }
                return Bridge.equals(this.Type, o.Type) && Bridge.equals(this.Info, o.Info);
            },
            $clone: function (to) { return this; }
        }
    });

    /**
     * Binding state that persists across multiple bindings (lifetime of {@link })
     *
     * @class Kusto.Language.Binding.GlobalBindingCache
     */
    Bridge.define("Kusto.Language.Binding.GlobalBindingCache", {
        fields: {
            UnifiedNameColumnsMap: null,
            UnifiedNameAndTypeColumnsMap: null,
            CommonColumnsMap: null,
            CallSiteToExpansionMap: null,
            DatabaseFunctionBodyFacts: null
        },
        ctors: {
            init: function () {
                this.UnifiedNameColumnsMap = new (System.Collections.Generic.Dictionary$2(System.Collections.Generic.IReadOnlyList$1(Kusto.Language.Symbols.TableSymbol),Kusto.Language.Symbols.TableSymbol)).$ctor3(Kusto.Language.Utils.ReadOnlyListComparer$1(Kusto.Language.Symbols.TableSymbol).Default);
                this.UnifiedNameAndTypeColumnsMap = new (System.Collections.Generic.Dictionary$2(System.Collections.Generic.IReadOnlyList$1(Kusto.Language.Symbols.TableSymbol),Kusto.Language.Symbols.TableSymbol)).$ctor3(Kusto.Language.Utils.ReadOnlyListComparer$1(Kusto.Language.Symbols.TableSymbol).Default);
                this.CommonColumnsMap = new (System.Collections.Generic.Dictionary$2(System.Collections.Generic.IReadOnlyList$1(Kusto.Language.Symbols.TableSymbol),Kusto.Language.Symbols.TableSymbol)).$ctor3(Kusto.Language.Utils.ReadOnlyListComparer$1(Kusto.Language.Symbols.TableSymbol).Default);
                this.CallSiteToExpansionMap = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Binding.CallSiteInfo,Kusto.Language.FunctionCallExpansion)).$ctor3(Kusto.Language.Binding.CallSiteInfo.Comparer.Instance);
                this.DatabaseFunctionBodyFacts = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Symbols.Signature,Kusto.Language.FunctionBodyFacts)).ctor();
            }
        }
    });

    /**
     * Binding state that exists for the duration of the binder.
     *
     * @class Kusto.Language.Binding.LocalBindingCache
     */
    Bridge.define("Kusto.Language.Binding.LocalBindingCache", {
        fields: {
            SignaturesComputingExpansion: null,
            CallSiteToExpansionMap: null
        },
        ctors: {
            init: function () {
                this.SignaturesComputingExpansion = new (System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.Signature)).ctor();
                this.CallSiteToExpansionMap = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Binding.CallSiteInfo,Kusto.Language.FunctionCallExpansion)).$ctor3(Kusto.Language.Binding.CallSiteInfo.Comparer.Instance);
            }
        }
    });

    /**
     * Models nested scoping for let variables and function parameters.
     *
     * @class Kusto.Language.Binding.LocalScope
     */
    Bridge.define("Kusto.Language.Binding.LocalScope", {
        statics: {
            methods: {
                GetMinimalOuterScope: function (outerScope) {
                    while (outerScope != null && outerScope._symbols == null && outerScope._sharedSymbols == null) {
                        outerScope = outerScope._outerScope;
                    }

                    return outerScope;
                }
            }
        },
        fields: {
            _outerScope: null,
            _symbols: null,
            _sharedSymbols: null
        },
        ctors: {
            $ctor1: function (symbols, outerScope, sharedScope) {
                this.$initialize();
                this._symbols = symbols;
                this._outerScope = Kusto.Language.Binding.LocalScope.GetMinimalOuterScope(outerScope);
                this._sharedSymbols = sharedScope;
            },
            /**
             * Create a new instance of a {@link }
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.LocalScope
             * @memberof Kusto.Language.Binding.LocalScope
             * @param   {Kusto.Language.Binding.LocalScope}    outerScope    An optional outer scope.
             * @return  {void}
             */
            ctor: function (outerScope) {
                if (outerScope === void 0) { outerScope = null; }

                Kusto.Language.Binding.LocalScope.$ctor1.call(this, null, outerScope, null);
            }
        },
        methods: {
            /**
             * Returns true if the local scope constains a symbol with the given name.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.LocalScope
             * @memberof Kusto.Language.Binding.LocalScope
             * @param   {string}     name
             * @return  {boolean}
             */
            ContainsSymbol: function (name) {
                return (this._symbols != null && this._symbols.containsKey(name)) || (this._sharedSymbols != null && this._sharedSymbols.ContainsSymbol(name));
            },
            /**
             * Makes a copy of this {@link }.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.LocalScope
             * @memberof Kusto.Language.Binding.LocalScope
             * @return  {Kusto.Language.Binding.LocalScope}
             */
            Copy: function () {
                // if we have any non-shared symbols, then move them into shared chain of symbols that
                // can be shared w/o fear of modification (basically copy-on-fear-of-writing).
                if (this._symbols != null && this._symbols.Count > 0) {
                    this._sharedSymbols = new Kusto.Language.Binding.LocalScope.$ctor1(this._symbols, null, this._sharedSymbols);
                    this._symbols = null;
                }

                return new Kusto.Language.Binding.LocalScope.$ctor1(null, this._outerScope, this._sharedSymbols);
            },
            /**
             * Add a {@link } to the {@link }
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.LocalScope
             * @memberof Kusto.Language.Binding.LocalScope
             * @param   {Kusto.Language.Symbols.Symbol}    symbol
             * @return  {boolean}
             */
            AddSymbol: function (symbol) {
                if (symbol != null) {
                    if (this._symbols == null) {
                        this._symbols = new (System.Collections.Generic.Dictionary$2(System.String,Kusto.Language.Symbols.Symbol)).ctor();
                    }

                    this._symbols.setItem(symbol.Name, symbol);
                    return true;
                }

                return false;
            },
            /**
             * Adds a collection of {@link } to the {@link }.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.LocalScope
             * @memberof Kusto.Language.Binding.LocalScope
             * @param   {System.Collections.Generic.IEnumerable$1}    symbols
             * @return  {void}
             */
            AddSymbols: function (symbols) {
                var $t;
                $t = Bridge.getEnumerator(symbols, Kusto.Language.Symbols.Symbol);
                try {
                    while ($t.moveNext()) {
                        var symbol = $t.Current;
                        this.AddSymbol(symbol);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            /**
             * Gets all the matching symbols in the scope, and then from any outer scopes.
             If any named matches are found in this scope, all other named matches from outer scopes are ignored.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.LocalScope
             * @memberof Kusto.Language.Binding.LocalScope
             * @param   {string}                                name       
             * @param   {Kusto.Language.Symbols.SymbolMatch}    match      
             * @param   {System.Collections.Generic.List$1}     symbols
             * @return  {void}
             */
            GetSymbols$1: function (name, match, symbols) {
                var $t;
                var originalCount = symbols.Count;

                if (this._symbols != null) {
                    if (name != null) {
                        var decl = { };
                        if (this._symbols.tryGetValue(name, decl) && Kusto.Language.Symbols.SymbolMatchExtensions.Matches$1(decl.v, name, match)) {
                            symbols.add(decl.v);
                        }
                    } else {
                        $t = Bridge.getEnumerator(this._symbols.Values);
                        try {
                            while ($t.moveNext()) {
                                var symbol = $t.Current;
                                if (Kusto.Language.Symbols.SymbolMatchExtensions.Matches(symbol, match)) {
                                    symbols.add(symbol);
                                }
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }
                    }
                }

                if (this._sharedSymbols != null && (name == null || symbols.Count === originalCount)) {
                    this._sharedSymbols.GetSymbols$1(name, match, symbols);
                }

                if (this._outerScope != null && (name == null || symbols.Count === originalCount)) {
                    this._outerScope.GetSymbols$1(name, match, symbols);
                }
            },
            /**
             * Gets all the matching symbols in the scope, and then from any outer scopes.
             If any named matches are found in this scope, all other named matches from outer scopes are ignored.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.LocalScope
             * @memberof Kusto.Language.Binding.LocalScope
             * @param   {Kusto.Language.Symbols.SymbolMatch}    match      
             * @param   {System.Collections.Generic.List$1}     symbols
             * @return  {void}
             */
            GetSymbols: function (match, symbols) {
                this.GetSymbols$1(null, match, symbols);
            }
        }
    });

    /**
     * The kind of match that an argument can have with its corresponding signature parameter.
     *
     * @class Kusto.Language.Binding.ParameterMatchKind
     */
    Bridge.define("Kusto.Language.Binding.ParameterMatchKind", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * There is no match between the argument and the parameter.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                None: 0,
                /**
                 * The argument had an unknown type.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Unknown: 1,
                /**
                 * The argument's type is not the excluded type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                NotType: 2,
                /**
                 * The argument's type is a scalar type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 3
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Scalar: 3,
                /**
                 * The argument's type is a summable scalar type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 4
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Summable: 4,
                /**
                 * The argument's type is an orderable scalar type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 5
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Orderable: 5,
                /**
                 * The argumet's type is a number
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 6
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Number: 6,
                /**
                 * The argument type is compatible with the parameter type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 7
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Compatible: 7,
                /**
                 * The arguments type can be promoted to the parameter type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 8
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Promoted: 8,
                /**
                 * The argument's type is tabular.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 9
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Tabular: 9,
                /**
                 * The argument's type is a table.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 10
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Table: 10,
                /**
                 * The argument's type is a database
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 11
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Database: 11,
                /**
                 * The argument's type is a cluster
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 12
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Cluster: 12,
                /**
                 * The argument's type is one of two possible parameter types
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 13
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                OneOfTwo: 13,
                /**
                 * The argument's type is an exact match for the parameter type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ParameterMatchKind
                 * @constant
                 * @default 14
                 * @type Kusto.Language.Binding.ParameterMatchKind
                 */
                Exact: 14
            }
        }
    });

    /**
     * A class that manages building a list of columns in a projection
     *
     * @class Kusto.Language.Binding.ProjectionBuilder
     */
    Bridge.define("Kusto.Language.Binding.ProjectionBuilder", {
        fields: {
            /**
             * The current projection list
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @type System.Collections.Generic.List$1
             */
            _projection: null,
            /**
             * A list of columns that should not be added to the projection.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @type System.Collections.Generic.HashSet$1
             */
            _doNotAdd: null,
            /**
             * A map between column names in the projection and their current index.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @type System.Collections.Generic.Dictionary$2
             */
            _columnIndexMap: null,
            /**
             * Column names that were explicitly declared in the projection: Name = e
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @type System.Collections.Generic.HashSet$1
             */
            _declaredNames: null,
            /**
             * Names already in use.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @type Kusto.Language.Utils.UniqueNameTable
             */
            _uniqueNames: null
        },
        ctors: {
            init: function () {
                this._projection = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();
                this._doNotAdd = new (System.Collections.Generic.HashSet$1(Kusto.Language.Symbols.ColumnSymbol)).ctor();
                this._columnIndexMap = new (System.Collections.Generic.Dictionary$2(System.String,System.Int32)).ctor();
                this._declaredNames = new (System.Collections.Generic.HashSet$1(System.String)).ctor();
                this._uniqueNames = new Kusto.Language.Utils.UniqueNameTable();
            },
            ctor: function () {
                this.$initialize();
            }
        },
        methods: {
            /**
             * Clears the {@link } so it can be used again.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @return  {void}
             */
            Clear: function () {
                this._projection.clear();
                this._doNotAdd.clear();
                this._columnIndexMap.clear();
                this._uniqueNames.Clear();
                this._declaredNames.clear();
            },
            /**
             * Gets the projected columns.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @return  {System.Collections.Generic.IReadOnlyList$1}
             */
            GetProjection: function () {
                return this._projection;
            },
            /**
             * Adds one or more columns to the projection list, renaming them if necessary.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @param   {System.Collections.Generic.IEnumerable$1}    columns        The list of columns to add.
             * @param   {boolean}                                     declare        If true, then consider these columns to have been explicitly declared, so further declarations cannot use their name.
             * @param   {boolean}                                     doNotRepeat    If true then ignore any further attempt to add these columns.
             * @return  {void}
             */
            AddRange: function (columns, declare, doNotRepeat) {
                var $t;
                if (declare === void 0) { declare = false; }
                if (doNotRepeat === void 0) { doNotRepeat = false; }
                $t = Bridge.getEnumerator(columns, Kusto.Language.Symbols.ColumnSymbol);
                try {
                    while ($t.moveNext()) {
                        var column = $t.Current;
                        var c = this.Add(column, void 0, false, doNotRepeat);

                        if (declare && c != null) {
                            this._declaredNames.add(c.Name);
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            /**
             * Ignore any further attempt to add this column to the projection.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @param   {Kusto.Language.Symbols.ColumnSymbol}    column
             * @return  {void}
             */
            DoNotAdd: function (column) {
                this._doNotAdd.add(column);
            },
            /**
             * Ignore any further attempt to add any of these columns to the projection.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @param   {System.Collections.Generic.IEnumerable$1}    columns
             * @return  {void}
             */
            DoNotAddAny: function (columns) {
                var $t;
                $t = Bridge.getEnumerator(columns, Kusto.Language.Symbols.ColumnSymbol);
                try {
                    while ($t.moveNext()) {
                        var col = $t.Current;
                        this.DoNotAdd(col);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            /**
             * True if an attempt to add the column will succeed.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @param   {Kusto.Language.Symbols.ColumnSymbol}    column
             * @return  {boolean}
             */
            CanAdd: function (column) {
                return !this._doNotAdd.contains(column);
            },
            /**
             * Adds a new undeclared column to the projection list.
             The name will be changed if it conflicts with a previously added column.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @param   {Kusto.Language.Symbols.ColumnSymbol}    column         The column to add.
             * @param   {string}                                 baseName       The base name to use when generating an alternate unique name for this column.
             * @param   {boolean}                                replace        If true, allow this column to replace any previously added column with the same name.
             * @param   {boolean}                                doNotRepeat    If true, ignore any further attempts to add this column.
             * @return  {Kusto.Language.Symbols.ColumnSymbol}
             */
            Add: function (column, baseName, replace, doNotRepeat) {
                if (baseName === void 0) { baseName = null; }
                if (replace === void 0) { replace = false; }
                if (doNotRepeat === void 0) { doNotRepeat = false; }
                // do not accept columns without names
                if (System.String.isNullOrEmpty(column.Name)) {
                    return column;
                }

                if (this._doNotAdd.contains(column)) {
                    // this column is ignored when attempting to add it.
                    return column;
                }
                var index = { };

                if (replace && this._columnIndexMap.tryGetValue(column.Name, index)) {
                    this._projection.setItem(index.v, column);
                } else {
                    // make sure the column name is unique.
                    var uniqueName = this._uniqueNames.GetOrAddName(column.Name, baseName);
                    if (!Bridge.referenceEquals(uniqueName, column.Name)) {
                        // include knowledge of the original column before it got renamed
                        column = column.WithName(uniqueName);
                    }

                    this._projection.add(column);
                    this._columnIndexMap.add(column.Name, ((this._projection.Count - 1) | 0));
                }

                if (doNotRepeat) {
                    this._doNotAdd.add(column);
                }

                return column;
            },
            /**
             * The column is added if a column with the same name is not already declared.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @param   {Kusto.Language.Symbols.ColumnSymbol}    column         The column to declare.
             * @param   {System.Collections.Generic.List$1}      diagnostics    The diagnostics list to add diagnostics to if the column's name has already been declared.
             * @param   {Kusto.Language.Syntax.SyntaxNode}       location       The syntax location used to associate with diagnostics.
             * @param   {boolean}                                replace        If true, allow this column to replace any previously added column with the same name, but not specifically declared.
             * @return  {void}
             */
            Declare: function (column, diagnostics, location, replace) {
                if (replace === void 0) { replace = false; }
                // is this name already explicitly declared elsewhere?
                if (this._declaredNames.contains(column.Name)) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetDuplicateColumnDeclaration(column.Name).WithLocation(location));
                    return;
                }
                var index = { };

                if (replace && this._columnIndexMap.tryGetValue(column.Name, index)) {
                    this._projection.setItem(index.v, column);
                    this._declaredNames.add(column.Name);
                } else {
                    var added = this.Add(column);

                    if (added != null) {
                        this._declaredNames.add(added.Name);
                    }
                }
            },
            /**
             * Rename a column that exists from a previous query source.
             *
             * @instance
             * @public
             * @this Kusto.Language.Binding.ProjectionBuilder
             * @memberof Kusto.Language.Binding.ProjectionBuilder
             * @param   {string}                                 oldName        The name of a column already in the projection
             * @param   {string}                                 newName        The new name for the column.
             * @param   {System.Collections.Generic.List$1}      diagnostics    The diagnostics list to add diagnostics to if the column's name has already been declared.
             * @param   {Kusto.Language.Syntax.SyntaxNode}       location       The syntax location used to associate with any diagnostics added.
             * @return  {Kusto.Language.Symbols.ColumnSymbol}
             */
            Rename: function (oldName, newName, diagnostics, location) {
                var index = { };
                // find existing column index
                if (!this._columnIndexMap.tryGetValue(oldName, index)) {
                    // cannot find column... should this be an error?
                    return null;
                }

                // is this name already explicitly declared elsewhere?
                if (this._declaredNames.contains(newName)) {
                    diagnostics.add(Kusto.Language.DiagnosticFacts.GetDuplicateColumnDeclaration(newName).WithLocation(location));
                    return null;
                }

                var oldColumn = this._projection.getItem(index.v);
                var newColumn = oldColumn.WithName(newName);

                this._projection.setItem(index.v, newColumn);
                this._columnIndexMap.remove(oldName);
                this._columnIndexMap.add(newName, index.v);
                this._declaredNames.add(newName);
                this._uniqueNames.AddName(newName);

                return newColumn;
            }
        }
    });

    /**
     * Scope kind.
     *
     * @class Kusto.Language.Binding.ScopeKind
     */
    Bridge.define("Kusto.Language.Binding.ScopeKind", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * Normal lookup in {@link }
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ScopeKind
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Binding.ScopeKind
                 */
                Normal: 0,
                /**
                 * Only aggregate functions are visible
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ScopeKind
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Binding.ScopeKind
                 */
                Aggregate: 1,
                /**
                 * Only plug-in funtions are visible
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ScopeKind
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Binding.ScopeKind
                 */
                PlugIn: 2,
                /**
                 * Only query options are visible
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Binding.ScopeKind
                 * @constant
                 * @default 3
                 * @type Kusto.Language.Binding.ScopeKind
                 */
                Option: 3
            }
        }
    });

    Bridge.define("Kusto.Language.ClusterManagerCommands", {
        statics: {
            fields: {
                ShowVersion: null,
                All: null
            },
            ctors: {
                init: function () {
                    this.ShowVersion = new Kusto.Language.Symbols.CommandSymbol("ShowVersion", "(BuildVersion: string, BuildTime: datetime, ServiceType: string, ProductVersion: string)");
                    this.All = System.Array.init([Kusto.Language.ClusterManagerCommands.ShowVersion], Kusto.Language.Symbols.CommandSymbol);
                }
            }
        }
    });

    Bridge.define("Kusto.Language.DataManagerCommands", {
        statics: {
            fields: {
                ShowVersion: null,
                All: null
            },
            ctors: {
                init: function () {
                    this.ShowVersion = new Kusto.Language.Symbols.CommandSymbol("ShowVersion", "(BuildVersion: string, BuildTime: datetime, ServiceType: string, ProductVersion: string)");
                    this.All = System.Array.init([Kusto.Language.DataManagerCommands.ShowVersion], Kusto.Language.Symbols.CommandSymbol);
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Diagnostic", {
        statics: {
            fields: {
                NoDiagnostics: null
            },
            ctors: {
                init: function () {
                    this.NoDiagnostics = System.Array.init(0, null, Kusto.Language.Diagnostic);
                }
            }
        },
        fields: {
            start: 0,
            length: 0
        },
        props: {
            /**
             * The code that uniquely identifies the specific kind of diagnostic.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Diagnostic
             * @function Code
             * @type string
             */
            Code: null,
            /**
             * The category of the diagnostic; Correctness, Performance, General, etc
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Diagnostic
             * @function Category
             * @type string
             */
            Category: null,
            /**
             * The severity of the diagnostic; Error, Warning, Suggestion, etc
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Diagnostic
             * @function Severity
             * @type string
             */
            Severity: null,
            /**
             * A short description of the diagnostic.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Diagnostic
             * @function Description
             * @type string
             */
            Description: null,
            /**
             * The message of the diagnostic.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Diagnostic
             * @function Message
             * @type string
             */
            Message: null,
            /**
             * True if the diagnostic has an known source location
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Diagnostic
             * @function HasLocation
             * @type boolean
             */
            HasLocation: {
                get: function () {
                    return this.LocationKind === Kusto.Language.DiagnosticLocationKind.Absolute;
                }
            },
            /**
             * The kind of diagnositc location.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Diagnostic
             * @function LocationKind
             * @type Kusto.Language.DiagnosticLocationKind
             */
            LocationKind: 0,
            /**
             * Start of diagnostic location in the source.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Diagnostic
             * @function Start
             * @type number
             */
            Start: {
                get: function () {
                    return this.start;
                }
            },
            /**
             * Length of diagnostic location in the source.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Diagnostic
             * @function Length
             * @type number
             */
            Length: {
                get: function () {
                    return this.length;
                }
            },
            /**
             * The position after the end of the diagnostic in source.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Diagnostic
             * @function End
             * @type number
             */
            End: {
                get: function () {
                    return ((this.Start + this.Length) | 0);
                }
            }
        },
        ctors: {
            ctor: function (code, message) {
                Kusto.Language.Diagnostic.$ctor3.call(this, code, null, null, null, message, Kusto.Language.DiagnosticLocationKind.Relative, 0, 0);
            },
            $ctor1: function (code, category, severity, description) {
                Kusto.Language.Diagnostic.$ctor3.call(this, code, category, severity, description, null, Kusto.Language.DiagnosticLocationKind.Relative, 0, 0);
            },
            $ctor2: function (code, category, severity, description, message) {
                Kusto.Language.Diagnostic.$ctor3.call(this, code, category, severity, description, message, Kusto.Language.DiagnosticLocationKind.Relative, 0, 0);
            },
            $ctor3: function (code, category, severity, description, message, locationKind, start, length) {
                var $t, $t1, $t2, $t3, $t4, $t5, $t6;
                this.$initialize();
                this.Code = ($t = code, $t != null ? $t : "");
                this.Category = ($t1 = category, $t1 != null ? $t1 : Kusto.Language.DiagnosticCategory.General);
                this.Severity = ($t2 = severity, $t2 != null ? $t2 : Kusto.Language.DiagnosticSeverity.Error);
                this.Description = ($t3 = description, $t3 != null ? $t3 : ($t4 = message, $t4 != null ? $t4 : ""));
                this.Message = ($t5 = message, $t5 != null ? $t5 : ($t6 = description, $t6 != null ? $t6 : ""));
                this.LocationKind = locationKind;
                this.start = start >= 0 ? start : 0;
                this.length = length >= 0 ? length : 0;
            }
        },
        methods: {
            With: function (code, category, severity, description, message, locationKind, start, length) {
                var $t, $t1, $t2, $t3, $t4;
                if (code === void 0) { code = null; }
                if (category === void 0) { category = null; }
                if (severity === void 0) { severity = null; }
                if (description === void 0) { description = null; }
                if (message === void 0) { message = null; }
                if (locationKind === void 0) { locationKind = null; }
                if (start === void 0) { start = -1; }
                if (length === void 0) { length = -1; }
                code = ($t = code, $t != null ? $t : this.Code);
                category = ($t1 = category, $t1 != null ? $t1 : this.Category);
                severity = ($t2 = severity, $t2 != null ? $t2 : this.Severity);
                description = ($t3 = description, $t3 != null ? $t3 : this.Description);
                message = ($t4 = message, $t4 != null ? $t4 : this.Message);
                var useLocationKind = locationKind != null ? System.Nullable.getValue(locationKind) : this.LocationKind;
                start = start >= 0 ? start : this.start;
                length = length >= 0 ? length : this.length;

                if (!Bridge.referenceEquals(code, this.Code) || !Bridge.referenceEquals(category, this.Code) || !Bridge.referenceEquals(severity, this.Severity) || !Bridge.referenceEquals(description, this.Description) || !Bridge.referenceEquals(message, this.Message) || useLocationKind !== this.LocationKind || start !== this.start || length !== this.length) {
                    return new Kusto.Language.Diagnostic.$ctor3(code, category, severity, description, message, useLocationKind, start, length);
                } else {
                    return this;
                }
            },
            WithCode: function (code) {
                return this.With(code, void 0, void 0, void 0, void 0, void 0, -1, -1);
            },
            WithCategory: function (category) {
                return this.With(void 0, category, void 0, void 0, void 0, void 0, -1, -1);
            },
            WithSeverity: function (severity) {
                return this.With(void 0, void 0, severity, void 0, void 0, void 0, -1, -1);
            },
            WithMessage: function (message) {
                return this.With(void 0, void 0, void 0, void 0, message, void 0, -1, -1);
            },
            WithLocation: function (location) {
                return this.With(void 0, void 0, void 0, void 0, void 0, Kusto.Language.DiagnosticLocationKind.Absolute, location.TextStart, location.Width);
            },
            WithLocation$1: function (start, length) {
                return this.With(void 0, void 0, void 0, void 0, void 0, Kusto.Language.DiagnosticLocationKind.Absolute, start, length);
            },
            WithLocationKind: function (locationKind) {
                return this.With(void 0, void 0, void 0, void 0, void 0, locationKind, -1, -1);
            }
        }
    });

    Bridge.define("Kusto.Language.DiagnosticCategory", {
        statics: {
            fields: {
                General: null,
                Correctness: null,
                Performance: null
            },
            ctors: {
                init: function () {
                    this.General = "General";
                    this.Correctness = "Correctness";
                    this.Performance = "Performance";
                }
            }
        }
    });

    Bridge.define("Kusto.Language.DiagnosticFacts", {
        statics: {
            methods: {
                GetMissingText: function (text) {
                    return new Kusto.Language.Diagnostic.ctor("KS001", System.String.format("Missing: {0}", [text]));
                },
                GetUnexpectedCharacter: function (text) {
                    return new Kusto.Language.Diagnostic.ctor("KS002", System.String.format("Unexpected: {0}", [text]));
                },
                GetMalformedToken: function (term) {
                    return new Kusto.Language.Diagnostic.ctor("KS003", System.String.format("Malformed {0}", [term]));
                },
                GetMalformedLiteral: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS004", "Malformed literal");
                },
                GetTermsExpected: function (terms) {
                    var $t;
                    if (terms === void 0) { terms = []; }
                    var list = Kusto.Language.Utils.ListExtensions.Join(($t = System.String, System.Linq.Enumerable.from(terms, $t).ToArray($t)), ", ", " or ");
                    return new Kusto.Language.Diagnostic.ctor("KS005", System.String.format("Expected: {0}", [list]));
                },
                GetTokenExpected: function (kinds) {
                    if (kinds === void 0) { kinds = []; }
                    return Kusto.Language.DiagnosticFacts.GetTokenExpected$2(Bridge.cast(kinds, System.Collections.Generic.IReadOnlyList$1(Kusto.Language.Syntax.SyntaxKind)));
                },
                GetTokenExpected$2: function (kinds) {
                    return Kusto.Language.DiagnosticFacts.GetTokenExpected$1(System.Linq.Enumerable.from(kinds, Kusto.Language.Syntax.SyntaxKind).select(function (k) {
                            return Kusto.Language.Syntax.SyntaxFacts.GetText(k);
                        }));
                },
                GetTokenExpected$1: function (texts) {
                    return Kusto.Language.DiagnosticFacts.GetTermsExpected(System.Linq.Enumerable.from(texts, System.String).select(function (t) {
                            return System.String.format("'{0}'", [t]);
                        }).ToArray(System.String));
                },
                GetTokenExpected$3: function (tokens) {
                    if (tokens === void 0) { tokens = []; }
                    return Kusto.Language.DiagnosticFacts.GetTokenExpected$1(Bridge.cast(tokens, System.Collections.Generic.IReadOnlyList$1(System.String)));
                },
                GetMissingElement: function (term) {
                    return new Kusto.Language.Diagnostic.ctor("KS006", System.String.format("Missing {0}", [term]));
                },
                GetMissingName: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("name");
                },
                GetMissingValue: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("value");
                },
                GetMissingExpression: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("expression");
                },
                GetMissingNumber: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("number");
                },
                GetMissingString: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("string");
                },
                GetMissingBoolean: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("boolean");
                },
                GetMissingTypeOfLiteral: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("typeof");
                },
                GetMissingFunctionCall: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("function call");
                },
                GetMissingFunctionDeclaration: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("function declaration");
                },
                GetMissingTypeName: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("type name");
                },
                GetMissingParameter: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("parameter");
                },
                GetMissingFirstOrLast: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("first or last");
                },
                GetMissingAllLastOrNone: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("all, last or none");
                },
                GetMissingJsonValue: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("json value");
                },
                GetMissingJoinOnClause: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("join on condition clause");
                },
                GetMissingJsonPair: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("json key:value pair");
                },
                GetMissingStatement: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("statement");
                },
                GetMissingPatternMatch: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("pattern match clause");
                },
                GetMissingClause: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("clause");
                },
                GetMissingClause$1: function (clauseName) {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement(System.String.format("{0} clause", [clauseName]));
                },
                GetMissingSchemaDeclaration: function () {
                    return Kusto.Language.DiagnosticFacts.GetMissingElement("schema declaration");
                },
                GetParsePatternMustStartWithColumnNameOrStar: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS100", "The pattern must start with a column name or *");
                },
                GetParsePatternNameDoesNotFollowStringLiteral: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS101", "The column name must follow a string literal");
                },
                GetParsePatternStringLiteralMustFollowStar: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS102", "A string literal must follow a *");
                },
                GetParsePatternUsingStarAfterStringColumnIsAmbiguous: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS103", "Using * after parsing a string column is ambiguous.");
                },
                GetInvalidPatternPart: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS104", "Invalid pattern part.");
                },
                GetIdentifierNameOnly: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS105", "The name must be a single identifier only.");
                },
                GetOperatorNotDefined: function (name, argumentTypes) {
                    if (argumentTypes === void 0) { argumentTypes = []; }
                    return Kusto.Language.DiagnosticFacts.GetOperatorNotDefined$1(name, Bridge.cast(argumentTypes, System.Collections.Generic.IReadOnlyList$1(Kusto.Language.Symbols.TypeSymbol)));
                },
                GetOperatorNotDefined$1: function (name, argumentTypes) {
                    if (System.Array.getCount(argumentTypes, Kusto.Language.Symbols.TypeSymbol) === 1) {
                        return new Kusto.Language.Diagnostic.ctor("KS106", System.String.format("The operator '{0}' is not defined for the operand type {1}.", name, System.Array.getItem(argumentTypes, 0, Kusto.Language.Symbols.TypeSymbol).Name));
                    } else {
                        var list = Kusto.Language.Utils.ListExtensions.Join(System.Linq.Enumerable.from(argumentTypes, Kusto.Language.Symbols.TypeSymbol).select(function (t) {
                                return t.Name;
                            }).toList(System.String), ", ", " and ");
                        return new Kusto.Language.Diagnostic.ctor("KS106", System.String.format("The operator '{0}' is not defined for the operand types {1}.", name, list));
                    }
                },
                GetTypeExpected: function (type) {
                    return new Kusto.Language.Diagnostic.ctor("KS107", System.String.format("A value of type '{0}' expected.", [type.Name]));
                },
                GetTypeExpected$1: function (types) {
                    if (System.Array.getCount(types, Kusto.Language.Symbols.TypeSymbol) === 0) {
                        return Kusto.Language.DiagnosticFacts.GetTypeExpected(System.Array.getItem(types, 0, Kusto.Language.Symbols.TypeSymbol));
                    } else {
                        var list = Kusto.Language.Utils.ListExtensions.Join(System.Linq.Enumerable.from(types, Kusto.Language.Symbols.TypeSymbol).select(function (t) {
                                return "'" + (t.Name || "") + "'";
                            }).toList(System.String), ", ", " or ");
                        return new Kusto.Language.Diagnostic.ctor("KS107", System.String.format("A value of type {0} expected.", [list]));
                    }
                },
                GetScalarTypeExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS108", System.String.format("Scalar value expected.", null));
                },
                GetColumnExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS109", "Column name expected.");
                },
                GetRenameAssignmentExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS110", "Column rename assignment expected.");
                },
                GetTableExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS111", "Table expected.");
                },
                GetTableOrScalarExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS112", "A table or scalar value expected.");
                },
                GetSingleColumnTableExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS113", "A table with only one column expected.");
                },
                GetDatabaseExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS114", "Database expected.");
                },
                GetClusterExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS115", "Cluster expected.");
                },
                GetTypeNotAllowed: function (type) {
                    return new Kusto.Language.Diagnostic.ctor("KS116", System.String.format("The value of type '{0}' is not allowed in this context.", [type.Name]));
                },
                GetFunctionRequiresArgumentList: function (functionName) {
                    return new Kusto.Language.Diagnostic.ctor("KS117", System.String.format("The function '{0}' requires an argument list.", [functionName]));
                },
                GetArgumentCountExpected: function (count) {
                    if (count === 0) {
                        return new Kusto.Language.Diagnostic.ctor("KS118", System.String.format("No arguments expected.", null));
                    } else if (count === 1) {
                        return new Kusto.Language.Diagnostic.ctor("KS118", System.String.format("1 argument expected.", null));
                    } else {
                        return new Kusto.Language.Diagnostic.ctor("KS118", System.String.format("{0} arguments expected.", [Bridge.box(count, System.Int32)]));
                    }
                },
                GetFunctionExpectsArgumentCountExact: function (functionName, count) {
                    if (count === 0) {
                        return new Kusto.Language.Diagnostic.ctor("KS119", System.String.format("The function '{0}' expects no arguments.", [functionName]));
                    } else if (count === 1) {
                        return new Kusto.Language.Diagnostic.ctor("KS119", System.String.format("The function '{0}' expects 1 argument.", [functionName]));
                    } else {
                        return new Kusto.Language.Diagnostic.ctor("KS119", System.String.format("The function '{0}' expects {1} arguments.", functionName, Bridge.box(count, System.Int32)));
                    }
                },
                GetFunctionExpectsArgumentCountRange: function (functionName, min, max) {
                    if (min === max) {
                        return Kusto.Language.DiagnosticFacts.GetFunctionExpectsArgumentCountExact(functionName, min);
                    } else {
                        return new Kusto.Language.Diagnostic.ctor("KS120", System.String.format("The function '{0}' expects between {1} and {2} arguments.", functionName, Bridge.box(min, System.Int32), Bridge.box(max, System.Int32)));
                    }
                },
                GetFunctionHasIncorrectNumberOfArguments: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS121", System.String.format("The function call has an incorrect number of arguments.", null));
                },
                GetScalarFunctionNotDefined: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS122", System.String.format("The scalar function '{0}' is not defined.", [name]));
                },
                GetAggregateFunctionNotDefined: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS123", System.String.format("The aggregate function '{0}' is not defined.", [name]));
                },
                GetPlugInFunctionNotDefined: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS124", System.String.format("The plug-in function '{0}' is not defined.", [name]));
                },
                GetPlugInFunctionIsNotEnabled: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS125", System.String.format("The plug-in function '{0}' is not enabled.", [name]));
                },
                GetPluginNotAllowedInThisContext: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS126", System.String.format("The plug-in function '{0}' is not allowed in this context.", [name]));
                },
                GetFunctionNotDefinedWithMatchingParameters: function (name, argumentTypes) {
                    var types = Bridge.toArray(System.Linq.Enumerable.from(argumentTypes, Kusto.Language.Symbols.Symbol).select(function (p) {
                                return p.Name;
                            })).join(", ");
                    return new Kusto.Language.Diagnostic.ctor("KS127", System.String.format("The function '{0}' is not compatible with arguments ({1})", name, types));
                },
                GetNameIsNotAFunction: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS128", System.String.format("The name '{0}' does not refer to a function.", [name]));
                },
                GetExpressionMustBeConstant: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS129", "The expression must be a constant.");
                },
                GetExpressionMustBeConstantOrIdentifier: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS130", "The expression must be a constant or identifier.");
                },
                GetExpressionMustBeLiteral: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS131", System.String.format("The expression must be a literal.", null));
                },
                GetExpressionMustBeLiteralScalarValue: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS132", System.String.format("The expression must be a literal scalar value.", null));
                },
                GetExpressionMustNotBeEmpty: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS133", System.String.format("The expression value must not be empty.", null));
                },
                GetExpressionMustBeInteger: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS134", "The expression value must be an integer.");
                },
                GetExpressionMustBeRealOrDecimal: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS135", "The expression value must be an real or decimal number.");
                },
                GetExpressionMustBeIntegerOrDynamic: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS136", "The expression value must be an integer or dynamic.");
                },
                GetExpressionMustBeNumeric: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS137", "The expression value must be a number.");
                },
                GetExpressionMustBeNumericOrBool: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS137", "The expression value must be a number or boolean true/false.");
                },
                GetExpressionMustBeSummable: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS138", "The argument value must be summable: a number, timespan or datetime.");
                },
                GetMultiValuedExpressionCannotBeAssignedToVariable: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS139", "The multi-valued expression cannot be assigned to a variable.");
                },
                GetExpressionMustHaveValue$1: function (T, values) {
                    if (System.Array.getCount(values, T) === 1) {
                        return new Kusto.Language.Diagnostic.ctor("KS140", System.String.format("The expression must be the value: {0}", [System.Array.getItem(values, 0, T)]));
                    } else {
                        var list = Kusto.Language.Utils.ListExtensions.Join(System.Linq.Enumerable.from(values, T).select(function (v) {
                                return Bridge.toString(v);
                            }).toList(System.String), ", ", " or ");
                        return new Kusto.Language.Diagnostic.ctor("KS140", System.String.format("The expression must be one of the values: {0}", [list]));
                    }
                },
                GetExpressionMustHaveValue: function (T, values) {
                    if (values === void 0) { values = []; }
                    return Kusto.Language.DiagnosticFacts.GetExpressionMustHaveValue$1(T, Bridge.cast(values, System.Collections.Generic.IReadOnlyList$1(T)));
                },
                GetExpressionMustHaveType$1: function (S, types) {
                    if (System.Array.getCount(types, S) === 1) {
                        return new Kusto.Language.Diagnostic.ctor("KS141", System.String.format("The expression must have the type {0}.", [System.Array.getItem(types, 0, S).Name]));
                    } else {
                        var list = Kusto.Language.Utils.ListExtensions.Join(System.Linq.Enumerable.from(types, S).select(function (s) {
                                return s.Name;
                            }).toList(System.String), ", ", " or ");
                        return new Kusto.Language.Diagnostic.ctor("KS141", System.String.format("The expression must have one of the types: {0}.", [list]));
                    }
                },
                GetExpressionMustHaveType: function (S, types) {
                    if (types === void 0) { types = []; }
                    return Kusto.Language.DiagnosticFacts.GetExpressionMustHaveType$1(S, Bridge.cast(types, System.Collections.Generic.IReadOnlyList$1(S)));
                },
                GetNameDoesNotReferToAnyKnownItem: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS142", System.String.format("The name '{0}' does not refer to any known column, table, variable or function.", [name]));
                },
                GetFunctionNotDefined: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS143", System.String.format("The function '{0}' is not defined.", [name]));
                },
                GetAggregateNotAllowedInThisContext: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS144", System.String.format("The aggregate function '{0}' is not allowed in this context.", [name]));
                },
                GetColumnMustExistOnBothSidesOfJoin: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS145", System.String.format("The column '{0}' must exist on both sides of the join.", [name]));
                },
                GetNameRefersToMoreThanOneItem: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS146", System.String.format("The name '{0}' refers to more than one column or variable", [name]));
                },
                GetTheElementAccessOperatorIsNotAllowedInThisContext: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS147", "The element access operator [] is not allowed in this context.");
                },
                GetTheExpressionHasNoName: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS148", "A column name cannot be inferred for this expression.");
                },
                GetTheExpressionDoesNotHaveMultipleValues: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS149", "The expression does not have multiple named values.");
                },
                GetTheNameDoesNotHaveCorrespondingExpression: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS150", "The name does not have a corresponding expression.");
                },
                GetInvalidTypeName: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS160", System.String.format("The name '{0}' is not a valid type name.", [name]));
                },
                GetInvalidColumnDeclaration: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS170", "The syntax is not a valid column declaration.");
                },
                GetDuplicateColumnDeclaration: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS171", System.String.format("A column with the name '{0}' is already declared.", [name]));
                },
                GetInvalidTypeExpression: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS172", "The syntax is not a valid type expression.");
                },
                GetIncorrectNumberOfDataValues: function (multiple) {
                    return new Kusto.Language.Diagnostic.ctor("KS173", System.String.format("Incorrect number of data values. The values should appear in multiples of {0}.", [Bridge.box(multiple, System.Int32)]));
                },
                GetQueryOperatorCannotBeFirst: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS174", System.String.format("The operator cannot be the first operator in a query.", null));
                },
                GetQueryOperatorMustBeFirst: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS175", "The operator must be the first operator in the query.");
                },
                GetQueryOperatorExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS176", "Query operator expected.");
                },
                GetQueryOperatorNotAllowedInContext: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS177", System.String.format("The query operator '{0}' is not allowed in the current context.", [name]));
                },
                GetTypeIsNotIntervalType: function (intervalType, rangeType) {
                    return new Kusto.Language.Diagnostic.ctor("KS178", System.String.format("The type '{0}' is not an appropriate interval type for '{1}'", intervalType.Name, rangeType.Name));
                },
                GetUnknownQueryOperatorParameterName: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS179", System.String.format("The name '{0}' is not a recognized parameter for this operator.", [name])).WithSeverity(Kusto.Language.DiagnosticSeverity.Warning);
                },
                GetParameterAlreadySpecified: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS180", System.String.format("The parameter '{0}' is already specified.", [name]));
                },
                GetNameDoesNotReferToTable: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS181", System.String.format("The name '{0}' does not refer to a table.", [name]));
                },
                GetInvalidJoinCondition: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS182", "The join condition must be either the name of a column common to both tables or in the form $left.<column> == $right.<column>.");
                },
                GetInvalidJoinConditionOperand: function (prefix) {
                    return new Kusto.Language.Diagnostic.ctor("KS183", System.String.format("The join condition operand must be: {0}.<column>", [prefix]));
                },
                GetTheExpressionRefersToMoreThanOneColumn: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS184", "The expression refers to more than one column.");
                },
                GetPackMustBeLastItemInList: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS185", "The pack(*) expression must be the last item in the list.");
                },
                GetValueCountMustEqualParameterCount: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS185", "The number of values must equal the number of parameters.");
                },
                GetPathValueWithNoPathParameter: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS186", "A path value can only be specified when a path name is part of the declaration.");
                },
                GetPathValueExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS187", "A path value is expected.");
                },
                GetNoPatternMatchesArguments: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS188", "No pattern matches the specified arguments.");
                },
                GetDefaultValueExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS189", "Default value expected.");
                },
                GetTableHasNoColumns: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS190", "The table has no columns");
                },
                GetStarExpressionNotAllowed: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS191", "The * syntax is not allowed here.");
                },
                GetStarExpressionMustBeLastArgument: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS192", "The * syntax must be the last argument.");
                },
                GetNamedArgumentsNotSupported: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS193", "Named arguments are not supported for this function.");
                },
                GetCompoundNamedArgumentsNotSupported: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS194", "Compound named arguments are not supported.");
                },
                GetUnnamedArgumentAfterOutofOrderNamedArgument: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS195", "All arguments after an unordered named argument must be named.");
                },
                GetUnknownArgumentName: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS196", System.String.format("The argument name does not refer to a declared parameter.", null));
                },
                GetMissingArgumentForParameter: function (parameterName) {
                    return new Kusto.Language.Diagnostic.ctor("KS197", System.String.format("The argument for parameter '{0}' is missing.", [parameterName]));
                },
                GetIncompleteFragment: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS198", "The incomplete fragment is unexpected.");
                },
                GetNoColumnsInScope: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS199", "No columns are currently in scope.");
                },
                GetErrorInExpansion: function (name, errors) {
                    return new Kusto.Language.Diagnostic.ctor("KS200", System.String.format("Failure in expansion of '{0}': {1}", name, errors));
                },
                GetVariableAlreadyDeclared: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS201", System.String.format("A variable with the name '{0}' has already been declared.", [name]));
                },
                GetMaterializedViewNameMustBeStringLiteral: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS202", System.String.format("Materialized view name must be a string literal", null));
                },
                AnalysisFailure: function (analyzerName, message) {
                    return new Kusto.Language.Diagnostic.ctor("KS203", System.String.format("Failure in analysis '{0}': {1}", analyzerName, message));
                },
                GetNameDoesNotReferToAnyKnownTable: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS204", System.String.format("The name '{0}' does not refer to any known table, tabular variable or function.", [name]));
                },
                GetFuzzyUnionOperandNotDefined: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS205", System.String.format("The fuzzy union operand '{0}' does not refer to any known table, tabular variable or function.", [name])).WithSeverity(Kusto.Language.DiagnosticSeverity.Warning);
                },
                GetExpressionMustBeOrderable: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS206", "The argument value must be orderable: a number, timespan, datetime, string or boolean.");
                },
                GetNameDoesNotReferToAnyKnownCluster: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS207", System.String.format("The name '{0}' either does not refer to a reachable cluster or no schema from it is currently available.", [name])).WithSeverity(Kusto.Language.DiagnosticSeverity.Warning);
                },
                GetNameDoesNotReferToAnyKnownDatabase: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS208", System.String.format("The name '{0}' does not refer to any known database.", [name]));
                },
                GetNameDoesNotReferToAnyKnownExternalTable: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS209", System.String.format("The name '{0}' does not refer to any known external table.", [name]));
                },
                GetNameDoesNotReferToAnyKnownMaterializedView: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS210", System.String.format("The name '{0}' does not refer to any known materialized view.", [name]));
                },
                GetNameDoesNotReferToAnyKnownFunction: function (name) {
                    return new Kusto.Language.Diagnostic.ctor("KS211", System.String.format("The name '{0}' does not refer to any known function.", [name]));
                },
                GetClientParametersNotSupported: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS213", "Client parameters are not supported or enabled.");
                },
                GetRawGuidLiteralNotAllowed: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS214", "Raw guid literals are not allowed in this context, use guid(...) instead.");
                },
                GetDecimalInDynamic: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS215", "Decimal values are not supported in dynamic objects.");
                },
                GetDatabaseOrTableExpected: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS216", "Database or Table expected.");
                },
                GetMissingCommand: function () {
                    return new Kusto.Language.Diagnostic.ctor("KS300", "Missing command.");
                }
            }
        }
    });

    Bridge.define("Kusto.Language.DiagnosticLocationKind", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * The diagnostic location is known with absolute start and length values.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.DiagnosticLocationKind
                 * @constant
                 * @default 0
                 * @type Kusto.Language.DiagnosticLocationKind
                 */
                Absolute: 0,
                /**
                 * The diagnostic location is unknown, but relative to the syntax item it is associated with.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.DiagnosticLocationKind
                 * @constant
                 * @default 1
                 * @type Kusto.Language.DiagnosticLocationKind
                 */
                Relative: 1,
                /**
                 * The diagnostic location is unknown, but after the end of the syntax item it is associated with.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.DiagnosticLocationKind
                 * @constant
                 * @default 2
                 * @type Kusto.Language.DiagnosticLocationKind
                 */
                RelativeEnd: 2
            }
        }
    });

    Bridge.define("Kusto.Language.DiagnosticSeverity", {
        statics: {
            fields: {
                /**
                 * A diagnostic that represents code that will fail to execute.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.DiagnosticSeverity
                 * @constant
                 * @default "Error"
                 * @type string
                 */
                Error: null,
                /**
                 * A diagnostic that represents code that will execute but with possible unintended consequence.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.DiagnosticSeverity
                 * @constant
                 * @default "Warning"
                 * @type string
                 */
                Warning: null,
                /**
                 * A diagnostic that represents a suggestion to improve the code.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.DiagnosticSeverity
                 * @constant
                 * @default "Suggestion"
                 * @type string
                 */
                Suggestion: null,
                /**
                 * A diagnostic that represents information about the code.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.DiagnosticSeverity
                 * @constant
                 * @default "Information"
                 * @type string
                 */
                Information: null,
                /**
                 * A diagnostic that is not meant to be relayed to the user.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.DiagnosticSeverity
                 * @constant
                 * @default "Hidden"
                 * @type string
                 */
                Hidden: null
            },
            ctors: {
                init: function () {
                    this.Error = "Error";
                    this.Warning = "Warning";
                    this.Suggestion = "Suggestion";
                    this.Information = "Information";
                    this.Hidden = "Hidden";
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.ActorUtilities", {
        statics: {
            methods: {
                /**
                 * Get's the token near the position
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.KustoCode}             code        
                 * @param   {number}                               position
                 * @return  {Kusto.Language.Syntax.SyntaxToken}
                 */
                GetTokenNear: function (code, position) {
                    var token = code.Syntax.GetTokenAt(position);

                    if (token != null && position === token.TriviaStart && token.Trivia.length > 0) {
                        var prevToken = token.GetPreviousToken();
                        if (prevToken != null) {
                            return prevToken;
                        }
                    }

                    return token;
                },
                /**
                 * Gets the biggest node that fits within the range.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.KustoCode}            code      
                 * @param   {number}                              start     
                 * @param   {number}                              length
                 * @return  {Kusto.Language.Syntax.SyntaxNode}
                 */
                GetNodeInRange: function (code, start, length) {
                    var node = code.Syntax.GetNodeAt(start, length);

                    // check if we got the node that ends in the correct position.
                    // if the node goes beyond the range then the range might have been off by just a token or within the next token's whitespace
                    if (node.End > ((start + length) | 0)) {
                        // adjust end to see if we are just one token off from fitting
                        var lastToken = code.Syntax.GetTokenAt(((((start + length) | 0) - 1) | 0));
                        if (lastToken == null) {
                            return null;
                        }

                        var prevToken = lastToken.GetPreviousToken();
                        if (prevToken == null) {
                            return null;
                        }

                        var newEnd = prevToken.End;

                        length = (newEnd - start) | 0;

                        node = code.Syntax.GetNodeAt(start, length);

                        // if range is still too big then fail
                        if (node.End > ((start + length) | 0)) {
                            return null;
                        }
                    }

                    return node;
                },
                /**
                 * Adjusts the range to not include the leading and trailing trivia between tokens.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.KustoCode}    code      
                 * @param   {System.Int32}                start     
                 * @param   {System.Int32}                length
                 * @return  {void}
                 */
                TrimRange: function (code, start, length) {
                    var expectedEnd = (start.v + length.v) | 0;

                    // adjust for start/end within whitespace between tokens

                    var endToken = code.Syntax.GetTokenAt(expectedEnd);
                    if (endToken != null && start.v < endToken.TextStart) {
                        var adjustedEnd = endToken.TriviaStart;
                        length.v = (adjustedEnd - start.v) | 0;
                        expectedEnd = (start.v + length.v) | 0;
                    }

                    var startToken = code.Syntax.GetTokenAt(start.v);
                    if (startToken != null && start.v < startToken.TextStart) {
                        start.v = startToken.TextStart;
                        length.v = (expectedEnd - start.v) | 0;
                    }
                },
                /**
                 * Gets the adjusted range around the sequence of query operators in a pipe expression.
                 Returns false if the range does not correctly surround a distinct sub query
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.KustoCode}    code      
                 * @param   {System.Int32}                start     
                 * @param   {System.Int32}                length
                 * @return  {boolean}
                 */
                TryGetAdjustedSubqueryRange: function (code, start, length) {
                    Kusto.Language.Editor.ActorUtilities.TrimRange(code, start, length);
                    var ex;
                    if (((ex = Bridge.as(code.Syntax.GetNodeAt(start.v, length.v), Kusto.Language.Syntax.Expression))) != null) {
                        var pe;
                        if (((pe = Bridge.as(ex, Kusto.Language.Syntax.PipeExpression))) != null) {
                            var firstOp = Kusto.Language.Editor.ActorUtilities.GetPipeOperatorOrExpressionFromRangeStart(pe, start.v);
                            if (firstOp == null) {
                                return false;
                            }

                            if (firstOp.TextStart > start.v) {
                                var end = (start.v + length.v) | 0;
                                start.v = firstOp.TextStart;
                                length.v = (end - start.v) | 0;
                            }

                            var lastOp = Kusto.Language.Editor.ActorUtilities.GetPipeOperatorOrExpressionFromRangeEnd(pe, ((start.v + length.v) | 0));
                            if (lastOp == null) {
                                return false;
                            }

                            if (lastOp.End !== ((start.v + length.v) | 0)) {
                                length.v = (lastOp.End - start.v) | 0;
                            }
                        }

                        return true;
                    }

                    return false;
                },
                GetPipeOperatorOrExpressionFromRangeStart: function (pe, start) {
                    while (true) {
                        // allow operator to include range that overlaps leading pipe
                        if (start >= pe.Expression.End && start <= pe.Operator.TextStart) {
                            return pe.Operator;
                        } else {
                            var ppe;
                            if (start <= pe.Expression.End && ((ppe = Bridge.as(pe.Expression, Kusto.Language.Syntax.PipeExpression))) != null) {
                                pe = ppe;
                                continue;
                            } else if (start >= pe.Expression.TriviaStart && start <= pe.Expression.TextStart) {
                                return pe.Expression;
                            } else {
                                return null;
                            }
                        }
                    }
                },
                GetPipeOperatorOrExpressionFromRangeEnd: function (pe, end) {
                    while (true) {
                        // allow operator to include range that overlaps leading pipe
                        if (end === pe.End) {
                            return pe.Operator;
                        } else if (end < pe.Operator.TextStart && end >= pe.Expression.End) {
                            return pe.Expression;
                        } else {
                            var ppe;
                            if (((ppe = Bridge.as(pe.Expression, Kusto.Language.Syntax.PipeExpression))) != null) {
                                pe = ppe;
                                continue;
                            } else {
                                return null;
                            }
                        }
                    }
                },
                IsFirstInQuery: function (expr) {
                    var pe;
                    if (((pe = Bridge.as(expr.Parent, Kusto.Language.Syntax.PipeExpression))) != null) {
                        return Bridge.referenceEquals(pe.Expression, expr);
                    } else {
                        // not part of pipe
                        return true;
                    }
                },
                /**
                 * Gets the first named reference to the specified symbol within the syntax tree.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.Syntax.SyntaxNode}         root      
                 * @param   {Kusto.Language.Symbols.FunctionSymbol}    symbol
                 * @return  {Kusto.Language.Syntax.NameReference}
                 */
                GetFirstReference: function (root, symbol) {
                    return root.GetFirstDescendant(Kusto.Language.Syntax.NameReference, function (nr) {
                        return Bridge.referenceEquals(nr.ReferencedSymbol, symbol);
                    });
                },
                TryGetNearestTopLevelStatementInsertionPosition: function (code, position, insertPosition) {
                    // first find statement that the position is inside of
                    var statement = Kusto.Language.Editor.ActorUtilities.GetEnclosingTopLevelStatement(code, position);
                    if (statement != null) {
                        insertPosition.v = Kusto.Language.Editor.ActorUtilities.GetInsertionPositionBefore(statement);
                        return true;
                    } else {
                        insertPosition.v = 0;
                        return false;
                    }
                },
                TryGetNearestStatementInsertionPosition: function (code, position, insertPosition) {
                    // first find statement that the position is inside of
                    var node = Kusto.Language.Editor.ActorUtilities.GetEnclosingStatementOrFunctionBodyExpression(code, position);
                    if (node != null) {
                        insertPosition.v = Kusto.Language.Editor.ActorUtilities.GetInsertionPositionBefore(node);
                        return true;
                    } else {
                        insertPosition.v = 0;
                        return false;
                    }
                },
                /**
                 * Gets the stastement insertion position before the start of the specified node.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.Syntax.SyntaxNode}    node
                 * @return  {number}
                 */
                GetInsertionPositionBefore: function (node) {
                    var $t, $t1;
                    var trivia = ($t = (($t1 = node.GetFirstToken()) != null ? $t1.Trivia : null), $t != null ? $t : "");

                    if (node.TriviaStart === 0) {
                        // statement is the first statement of the query block
                        // assume any leading trivia with line breaks is comments and that comments are for entire query
                        var lastLbEnd = Kusto.Language.Parsing.TextFacts.GetLastLineBreakEnd(trivia);
                        return (((lastLbEnd >= 0 ? lastLbEnd : 0) + node.TriviaStart) | 0);
                    } else {
                        // statement is not first, so place new statement after on the next new line
                        var firstLbEnd = Kusto.Language.Parsing.TextFacts.GetFirstLineBreakEnd(trivia);
                        return (((firstLbEnd >= 0 ? firstLbEnd : 0) + node.TriviaStart) | 0);
                    }
                },
                GetEnclosingTopLevelStatement: function (code, position) {
                    var token = code.Syntax.GetTokenAt(position);
                    var node = token.Parent;

                    while (node != null && !Kusto.Language.Editor.ActorUtilities.IsTopLevelStatement(node)) {
                        node = node.GetFirstAncestor(Kusto.Language.Syntax.Statement);
                    }

                    return Bridge.as(node, Kusto.Language.Syntax.Statement);
                },
                GetEnclosingStatementOrFunctionBodyExpression: function (code, position) {
                    var token = code.Syntax.GetTokenAt(position);
                    var node = token.Parent;

                    while (node != null && !Kusto.Language.Editor.ActorUtilities.IsTopLevelStatement(node) && !Kusto.Language.Editor.ActorUtilities.IsFunctionBodyStatement(node) && !Kusto.Language.Editor.ActorUtilities.IsFunctionBodyExpression(node)) {
                        node = node.GetFirstAncestor(Kusto.Language.Syntax.SyntaxNode);
                    }

                    return node;
                },
                IsTopLevelStatement: function (node) {
                    var element;
                    var list;
                    return Bridge.is(node, Kusto.Language.Syntax.Statement) && ((element = Bridge.as(node.Parent, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement)))) != null && ((list = Bridge.as(element.Parent, Kusto.Language.Syntax.SyntaxList$1(Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement))))) != null && Bridge.is(list.Parent, Kusto.Language.Syntax.QueryBlock);
                },
                IsFunctionBodyStatement: function (node) {
                    var element;
                    var list;
                    return Bridge.is(node, Kusto.Language.Syntax.Statement) && ((element = Bridge.as(node.Parent, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement)))) != null && ((list = Bridge.as(element.Parent, Kusto.Language.Syntax.SyntaxList$1(Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement))))) != null && Bridge.is(list.Parent, Kusto.Language.Syntax.FunctionBody);
                },
                IsFunctionBodyExpression: function (node) {
                    var fb;
                    return ((fb = Bridge.as(node.Parent, Kusto.Language.Syntax.FunctionBody))) != null && Bridge.referenceEquals(fb.Expression, node);
                },
                /**
                 * Determines if the node is the right hand side of a path expression after a database(xxx) or cluster().database() expression.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.Syntax.SyntaxNode}    node
                 * @return  {boolean}
                 */
                IsDatabaseQualifiedName: function (node) {
                    var pfc;
                    if (((pfc = Bridge.as(node.Parent, Kusto.Language.Syntax.FunctionCallExpression))) != null) {
                        node = pfc;
                    }
                    var pe;
                    if (((pe = Bridge.as(node.Parent, Kusto.Language.Syntax.PathExpression))) != null) {
                        var fc;
                        var ppe;
                        var ppefc;
                        return (((fc = Bridge.as(pe.Expression, Kusto.Language.Syntax.FunctionCallExpression))) != null && Bridge.referenceEquals(fc.ReferencedSymbol, Kusto.Language.Functions.Database)) || (((ppe = Bridge.as(pe.Expression, Kusto.Language.Syntax.PathExpression))) != null && ((ppefc = Bridge.as(ppe.Selector, Kusto.Language.Syntax.FunctionCallExpression))) != null && Bridge.referenceEquals(ppefc.ReferencedSymbol, Kusto.Language.Functions.Database));
                    }

                    return false;
                },
                /**
                 * Returns true if the symbol is a member of a known database but not a member of the current database.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.Symbols.Symbol}    symbol     
                 * @param   {Kusto.Language.GlobalState}       globals
                 * @return  {boolean}
                 */
                IsDatabaseMemberNotFromCurrentDatabase: function (symbol, globals) {
                    var db;
                    return ((db = globals.GetDatabase$1(symbol))) != null && !Bridge.referenceEquals(db, globals.Database);
                },
                /**
                 * Gets the query text with the database() and cluster().database() qualifiers removed for a specified symbol.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.Syntax.SyntaxNode}    query              
                 * @param   {Kusto.Language.Symbols.Symbol}       qualifiedSymbol    
                 * @param   {Kusto.Language.GlobalState}          globals
                 * @return  {Kusto.Language.Utils.EditString}
                 */
                GetQueryWithDatabaseQualifiersRemoved: function (query, qualifiedSymbol, globals) {
                    var text = new Kusto.Language.Utils.EditString.ctor(query.toString());

                    var nameRefsToDequalify = query.GetDescendants(Kusto.Language.Syntax.NameReference, function (nr) {
                        return Kusto.Language.Editor.ActorUtilities.IsDatabaseQualifiedName(nr) && Bridge.referenceEquals(nr.ReferencedSymbol, qualifiedSymbol);
                    });

                    for (var i = (System.Array.getCount(nameRefsToDequalify, Kusto.Language.Syntax.NameReference) - 1) | 0; i >= 0; i = (i - 1) | 0) {
                        var nr = System.Array.getItem(nameRefsToDequalify, i, Kusto.Language.Syntax.NameReference);
                        var qualifier = Kusto.Language.Editor.ActorUtilities.GetQualifierToRemove(nr);
                        if (!Bridge.referenceEquals(qualifier, nr)) {
                            var len = (nr.TextStart - qualifier.TextStart) | 0;
                            text = text.Remove(qualifier.TextStart, len);
                        }
                    }

                    return text;
                },
                GetQualifierToRemove: function (node) {
                    var fc;
                    if (((fc = Bridge.as(node.Parent, Kusto.Language.Syntax.FunctionCallExpression))) != null) {
                        node = node.Parent;
                    }

                    if (Kusto.Language.Editor.ActorUtilities.IsDatabaseQualifiedName(node)) {
                        // works for database(...).name and cluster(...).database(...).name
                        return node.Parent;
                    } else {
                        return node;
                    }
                },
                /**
                 * Gets the new line characters that are currently being used by the text,
                 or Environment.NewLine if none are found.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {string}    text
                 * @return  {string}
                 */
                GetInferredNewLine: function (text) {
                    var newLinePos = text.lastIndexOf(String.fromCharCode(10));

                    if (newLinePos >= 0) {
                        if (newLinePos > 0 && text.charCodeAt(((newLinePos - 1) | 0)) === 13) {
                            return "\r\n";
                        } else {
                            return "\n";
                        }
                    } else {
                        return "\n";
                    }
                },
                IsExpressionOfLetStatement: function (node) {
                    var ls;
                    return ((ls = Bridge.as(node.Parent, Kusto.Language.Syntax.LetStatement))) != null && Bridge.referenceEquals(ls.Expression, node);
                },
                IsSelectorOfPathExpression: function (node) {
                    var pe;
                    return ((pe = Bridge.as(node.Parent, Kusto.Language.Syntax.PathExpression))) != null && Bridge.referenceEquals(pe.Selector, node);
                },
                IsOperatorOfPipeExpression: function (node) {
                    var pe;
                    return ((pe = Bridge.as(node.Parent, Kusto.Language.Syntax.PipeExpression))) != null && Bridge.referenceEquals(pe.Operator, node);
                },
                IsFreeStandingExpression: function (ex) {
                    return !Kusto.Language.Editor.ActorUtilities.IsSelectorOfPathExpression(ex) && !Kusto.Language.Editor.ActorUtilities.IsOperatorOfPipeExpression(ex);
                },
                /**
                 * Gets a name that does not already refer to something in the code at the specified position.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.KustoCode}    code        
                 * @param   {number}                      position    
                 * @param   {string}                      baseName
                 * @return  {string}
                 */
                GetNewName: function (code, position, baseName) {
                    var name = baseName;
                    var count = 0;

                    // check if the name already refers to something..
                    // if it does, try a different name
                    if (code.GetSpeculativeReferencedSymbol(position, name) != null) {
                        count = (count + 1) | 0;
                        name = (baseName || "") + count;
                    }

                    return name;
                },
                /**
                 * Gets a list of all the referenced symbols declared outside the fragment.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.KustoCode}                      code      
                 * @param   {number}                                        start     
                 * @param   {number}                                        length
                 * @return  {System.Collections.Generic.IReadOnlyList$1}
                 */
                GetExternalSymbolsReferenced: function (code, start, length) {
                    // this is all the visible symbols declared before the range
                    var symbolsInScope = Kusto.Language.Utils.ListExtensions.ToHashSetEx(Kusto.Language.Symbols.Symbol, code.GetSymbolsInScope(start));

                    // what about columns that are found in context before the fragment, but also found within the fragment (query operators)
                    return Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Symbols.Symbol, System.Linq.Enumerable.from(code.Syntax.GetDescendantsOrSelf(Kusto.Language.Syntax.Expression, function (ex) {
                            return Kusto.Language.Editor.ActorUtilities.IsInRange(ex, start, length) && ex.ReferencedSymbol != null && symbolsInScope.contains(ex.ReferencedSymbol);
                        }), Kusto.Language.Syntax.Expression).select(function (ex) {
                            return ex.ReferencedSymbol;
                        }).distinct());
                },
                IsInRange: function (element, start, length) {
                    var end = (start + length) | 0;
                    return element.TriviaStart <= end && element.End >= start;
                },
                /**
                 * Gets all the columns in scope within a query operator.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.KustoCode}                      code        
                 * @param   {number}                                        position
                 * @return  {System.Collections.Generic.IReadOnlyList$1}
                 */
                GetColumnsInScope: function (code, position) {
                    var token = code.Syntax.GetTokenAt(position);
                    var op = token.Parent.GetFirstAncestorOrSelf(Kusto.Language.Syntax.QueryOperator);

                    if (op != null) {
                        var pe;
                        var ts; // this is faster, but might not be true in all contexts inside a query operator
                        if (((pe = Bridge.as(op.Parent, Kusto.Language.Syntax.PipeExpression))) != null && Bridge.referenceEquals(pe.Operator, op) && ((ts = Bridge.as(pe.Expression.ResultType, Kusto.Language.Symbols.TableSymbol))) != null) {
                            return ts.Columns;
                        } else {
                            var ts2;
                            if (((ts2 = code.GetColumnsInScope(op.TextStart))) != null) {
                                return ts2.Columns;
                            }
                        }
                    }

                    return Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Symbols.ColumnSymbol).Instance;
                },
                /**
                 * Gets the schema representation of a table as it would be represented in Kusto.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {System.Collections.Generic.IReadOnlyList$1}    columns
                 * @return  {string}
                 */
                GetSchema: function (columns) {
                    return "(" + (Bridge.toArray(System.Linq.Enumerable.from(columns, Kusto.Language.Symbols.ColumnSymbol).select(function (c) {
                                return System.String.format("{0}: {1}", Kusto.Language.KustoFacts.BracketNameIfNecessary(c.Name), Kusto.Language.Editor.ActorUtilities.GetKustoType(c.Type));
                            })).join(", ") || "") + ")";
                },
                /**
                 * Gets the text for a type/schema declaration as it would be represented in a kusto query.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {Kusto.Language.Symbols.TypeSymbol}    type
                 * @return  {string}
                 */
                GetKustoType: function (type) {
                    var s;
                    if (((s = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null) {
                        return s.Name;
                    } else {
                        var t;
                        if (((t = Bridge.as(type, Kusto.Language.Symbols.TableSymbol))) != null) {
                            if (System.Array.getCount(t.Columns, Kusto.Language.Symbols.ColumnSymbol) === 0) {
                                return "(*)";
                            } else {
                                return Kusto.Language.Editor.ActorUtilities.GetSchema(t.Columns);
                            }
                        } else {
                            return "unknown";
                        }
                    }
                },
                /**
                 * Changes the indentation of the individual lines to the specified indenation.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.ActorUtilities
                 * @memberof Kusto.Language.Editor.ActorUtilities
                 * @param   {string}     text                
                 * @param   {string}     newIndentation      
                 * @param   {boolean}    includeFirstLine
                 * @return  {string}
                 */
                ChangeIndentation: function (text, newIndentation, includeFirstLine) {
                    var builder = new System.Text.StringBuilder();

                    var lineStart = 0;
                    if (!includeFirstLine) {
                        var lineLength = Kusto.Language.Parsing.TextFacts.GetLineLength(text, lineStart, true);
                        builder.append(text, lineStart, lineLength);
                        lineStart = (lineStart + lineLength) | 0;
                    }

                    while (lineStart < text.length) {
                        var lineLength1 = Kusto.Language.Parsing.TextFacts.GetLineLength(text, lineStart, true);
                        var wsLength = Kusto.Language.Parsing.TokenParser.ScanWhitespace(text, lineStart);
                        builder.append(newIndentation);
                        builder.append(text, ((lineStart + wsLength) | 0), ((lineLength1 - wsLength) | 0));
                        lineStart = (lineStart + lineLength1) | 0;
                    }

                    return builder.toString();
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.AnalyzerInfo", {
        props: {
            /**
             * The name of the analyzer.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.AnalyzerInfo
             * @function Name
             * @type string
             */
            Name: null,
            /**
             * The diagnostic codes produced by this analyzer.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.AnalyzerInfo
             * @function Diagnostics
             * @type System.Collections.Generic.IReadOnlyList$1
             */
            Diagnostics: null
        },
        ctors: {
            ctor: function (name, diagnostics) {
                var $t;
                this.$initialize();
                this.Name = ($t = name, $t != null ? $t : "");
                this.Diagnostics = diagnostics || Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Diagnostic).Instance;
            }
        }
    });

    Bridge.define("Kusto.Language.Parsing.ParserVisitor$3", function (TInput, TArg, TResult) { return {

    }; });

    Bridge.define("Kusto.Language.Editor.CodeAnalyzer", {
        props: {
            /**
             * The name of this {@link }
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeAnalyzer
             * @function Name
             * @type string
             */
            Name: {
                get: function () {
                    return Bridge.Reflection.getTypeName(Bridge.getType(this));
                }
            },
            /**
             * The diagnostics produced by this {@link }.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeAnalyzer
             * @function Diagnostics
             * @type System.Collections.Generic.IReadOnlyList$1
             */
            Diagnostics: {
                get: function () {
                    return Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Diagnostic).Instance;
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.BrackettingStyle", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * Do not adjust bracketting.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.BrackettingStyle
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.BrackettingStyle
                 */
                None: 0,
                /**
                 * Bracketting pairs are aligned horizontally when they are place on new lines.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.BrackettingStyle
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.BrackettingStyle
                 */
                Vertical: 1,
                /**
                 * Bracketting pairs are aligned diagonally, KR style, when placed on new lines.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.BrackettingStyle
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Editor.BrackettingStyle
                 */
                Diagonal: 2
            }
        }
    });

    /** @namespace Kusto.Language.Editor */

    /**
     * An action taken by the caller to apply the {@link }
     *
     * @abstract
     * @public
     * @class Kusto.Language.Editor.ResultAction
     */
    Bridge.define("Kusto.Language.Editor.ResultAction");

    Bridge.define("Kusto.Language.Editor.ClassificationInfo", {
        statics: {
            fields: {
                Empty: null
            },
            ctors: {
                init: function () {
                    this.Empty = new Kusto.Language.Editor.ClassificationInfo(null);
                }
            }
        },
        props: {
            Classifications: null
        },
        ctors: {
            ctor: function (classifications) {
                this.$initialize();
                this.Classifications = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Editor.ClassifiedRange, classifications);
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.ClassificationKind", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * The text is considered plain text.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                PlainText: 0,
                /**
                 * The text is a comment.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Comment: 1,
                /**
                 * The text is punctuation: (),;:
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Punctuation: 2,
                /**
                 * The text is a directive:  #
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 3
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Directive: 3,
                /**
                 * The text is a non-string literal.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 4
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Literal: 4,
                /**
                 * The text is a string literal.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 5
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                StringLiteral: 5,
                /**
                 * The text is a type name.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 6
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Type: 6,
                /**
                 * The text is a column name.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 7
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Column: 7,
                /**
                 * The text is a table name.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 8
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Table: 8,
                /**
                 * The textg is a database name.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 9
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Database: 9,
                /**
                 * The text is a function name.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 10
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Function: 10,
                /**
                 * The text is a parameter name.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 11
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Parameter: 11,
                /**
                 * The text is a variable name.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 12
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Variable: 12,
                /**
                 * The text is an identifier.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 13
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Identifier: 13,
                /**
                 * The text is a client parameter.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 14
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                ClientParameter: 14,
                /**
                 * The text is a query parameter. (ie kind=x)
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 15
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                QueryParameter: 15,
                /**
                 * The text is a scalar operator keyword: has, in, between
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 16
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                ScalarOperator: 16,
                /**
                 * The text is a math or logic operator: +, -, /, *, ==
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 17
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                MathOperator: 17,
                /**
                 * The text is a query operator.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 18
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                QueryOperator: 18,
                /**
                 * The text is a command keyword
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 19
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Command: 19,
                /**
                 * The text is a language keyword
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 20
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Keyword: 20,
                /**
                 * The text is a materialized view entity
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 21
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                MaterializedView: 21,
                /**
                 * A member of a table/tuple schema declaration
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 22
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                SchemaMember: 22,
                /**
                 * A member of a function signature declaration
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 23
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                SignatureParameter: 23,
                /**
                 * A query option
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.ClassificationKind
                 * @constant
                 * @default 24
                 * @type Kusto.Language.Editor.ClassificationKind
                 */
                Option: 24
            }
        }
    });

    /**
     * A {@link } and text range.
     *
     * @public
     * @class Kusto.Language.Editor.ClassifiedRange
     */
    Bridge.define("Kusto.Language.Editor.ClassifiedRange", {
        props: {
            /**
             * The classification.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.ClassifiedRange
             * @function Kind
             * @type Kusto.Language.Editor.ClassificationKind
             */
            Kind: 0,
            /**
             * The starting text position of the classified range.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.ClassifiedRange
             * @function Start
             * @type number
             */
            Start: 0,
            /**
             * The length (in characters) of the classified range.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.ClassifiedRange
             * @function Length
             * @type number
             */
            Length: 0,
            /**
             * The end of the classification range.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.ClassifiedRange
             * @function End
             * @type number
             */
            End: {
                get: function () {
                    return ((this.Start + this.Length) | 0);
                }
            }
        },
        ctors: {
            ctor: function (kind, start, length) {
                this.$initialize();
                this.Kind = kind;
                this.Start = start;
                this.Length = length;
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.ClassifiedText", {
        props: {
            /**
             * The {@link } of the text.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.ClassifiedText
             * @function Kind
             * @type Kusto.Language.Editor.ClassificationKind
             */
            Kind: 0,
            /**
             * The text itself.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.ClassifiedText
             * @function Text
             * @type string
             */
            Text: null
        },
        ctors: {
            $ctor1: function (text) {
                Kusto.Language.Editor.ClassifiedText.ctor.call(this, Kusto.Language.Editor.ClassificationKind.PlainText, text);
            },
            ctor: function (kind, text) {
                this.$initialize();
                this.Kind = kind;
                this.Text = text;
            }
        }
    });

    /**
     * A range of text.
     *
     * @public
     * @class Kusto.Language.Editor.TextRange
     */
    Bridge.define("Kusto.Language.Editor.TextRange", {
        props: {
            /**
             * The starting position of the range in the text.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.TextRange
             * @function Start
             * @type number
             */
            Start: 0,
            /**
             * The length of the range in the text.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.TextRange
             * @function Length
             * @type number
             */
            Length: 0,
            /**
             * The ending of the range in the text.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.TextRange
             * @function End
             * @type number
             */
            End: {
                get: function () {
                    return ((this.Start + this.Length) | 0);
                }
            }
        },
        ctors: {
            ctor: function (start, length) {
                this.$initialize();
                this.Start = start;
                this.Length = length;
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.CodeAction", {
        props: {
            Actor: null,
            Name: null,
            Description: null,
            Data: null
        },
        ctors: {
            ctor: function (actor, name, description, data) {
                this.$initialize();
                this.Actor = actor;
                this.Name = name;
                this.Description = description;
                this.Data = data;
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.CodeActionInfo", {
        statics: {
            fields: {
                NoActions: null
            },
            ctors: {
                init: function () {
                    this.NoActions = new Kusto.Language.Editor.CodeActionInfo(Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Editor.CodeAction).Instance);
                }
            }
        },
        props: {
            Actions: null
        },
        ctors: {
            ctor: function (actions) {
                this.$initialize();
                this.Actions = actions;
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.CodeActionOptions", {
        statics: {
            fields: {
                Default: null
            },
            ctors: {
                init: function () {
                    this.Default = new Kusto.Language.Editor.CodeActionOptions(null, null, null);
                }
            }
        },
        props: {
            Actors: null,
            AdditionalDiagnostics: null,
            FormattingOptions: null
        },
        ctors: {
            ctor: function (actors, additionalDiagnostics, formattingOptions) {
                this.$initialize();
                this.Actors = actors || Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Editor.CodeActor).Instance;
                this.AdditionalDiagnostics = additionalDiagnostics || Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Diagnostic).Instance;
                this.FormattingOptions = formattingOptions || Kusto.Language.Editor.FormattingOptions.Default;
            }
        },
        methods: {
            WithActors: function (actors) {
                return new Kusto.Language.Editor.CodeActionOptions(actors, this.AdditionalDiagnostics, this.FormattingOptions);
            },
            WithAdditionalDiagnostics: function (diagnostics) {
                return new Kusto.Language.Editor.CodeActionOptions(this.Actors, diagnostics, this.FormattingOptions);
            },
            WithFormattingOptions: function (options) {
                return new Kusto.Language.Editor.CodeActionOptions(this.Actors, this.AdditionalDiagnostics, options);
            }
        }
    });

    /**
     * The resulting effects of applying a {@link }.
     These result actions must be
     *
     * @public
     * @class Kusto.Language.Editor.CodeActionResult
     */
    Bridge.define("Kusto.Language.Editor.CodeActionResult", {
        statics: {
            fields: {
                /**
                 * A {@link } where nothing happens.
                 *
                 * @static
                 * @public
                 * @readonly
                 * @memberof Kusto.Language.Editor.CodeActionResult
                 * @type Kusto.Language.Editor.CodeActionResult
                 */
                Nothing: null
            },
            ctors: {
                init: function () {
                    this.Nothing = new Kusto.Language.Editor.CodeActionResult.$ctor3(Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Editor.ResultAction).Instance);
                }
            },
            methods: {
                Failure: function (failureReason) {
                    return new Kusto.Language.Editor.CodeActionResult.$ctor4(null, failureReason);
                }
            }
        },
        props: {
            /**
             * The list of {@link } that to be applied in order.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CodeActionResult
             * @function Actions
             * @type System.Collections.Generic.IReadOnlyList$1
             */
            Actions: null,
            /**
             * The reason the application of the {@link } failed (or null).
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CodeActionResult
             * @function FailureReason
             * @type string
             */
            FailureReason: null
        },
        ctors: {
            $ctor4: function (actions, failureReason) {
                this.$initialize();
                this.Actions = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Editor.ResultAction, actions);
                this.FailureReason = failureReason;
            },
            $ctor3: function (actions) {
                Kusto.Language.Editor.CodeActionResult.$ctor4.call(this, actions, null);
            },
            ctor: function (actions) {
                if (actions === void 0) { actions = []; }

                Kusto.Language.Editor.CodeActionResult.$ctor3.call(this, Bridge.cast(actions, System.Collections.Generic.IReadOnlyList$1(Kusto.Language.Editor.ResultAction)));
            },
            $ctor1: function (newText) {
                Kusto.Language.Editor.CodeActionResult.ctor.call(this, System.Array.init([new Kusto.Language.Editor.ChangeTextAction(newText)], Kusto.Language.Editor.ResultAction));
            },
            $ctor2: function (newText, newPosition) {
                Kusto.Language.Editor.CodeActionResult.ctor.call(this, System.Array.init([new Kusto.Language.Editor.ChangeTextAction(newText), new Kusto.Language.Editor.MoveCaretAction(newPosition)], Kusto.Language.Editor.ResultAction));
            }
        },
        methods: {
            WithAction: function (action) {
                return new Kusto.Language.Editor.CodeActionResult.$ctor4(System.Linq.Enumerable.from(this.Actions, Kusto.Language.Editor.ResultAction).concat(System.Array.init([action], Kusto.Language.Editor.ResultAction)).toList(Kusto.Language.Editor.ResultAction), null);
            },
            WithAdjustedPosition: function (delta) {
                var $t;
                if (System.Array.getCount(this.Actions, Kusto.Language.Editor.ResultAction) > 0 && delta !== 0) {
                    var adjustedActions = new (System.Collections.Generic.List$1(Kusto.Language.Editor.ResultAction)).ctor();

                    $t = Bridge.getEnumerator(this.Actions, Kusto.Language.Editor.ResultAction);
                    try {
                        while ($t.moveNext()) {
                            var act = $t.Current;
                            do {
                                if (Bridge.is(act, Kusto.Language.Editor.MoveCaretAction)) {
                                    var mca = Bridge.cast(act, Kusto.Language.Editor.MoveCaretAction);
                                    adjustedActions.add(new Kusto.Language.Editor.MoveCaretAction(((mca.NewCaretPosition + delta) | 0)));
                                    break;
                                }

                                {
                                    adjustedActions.add(act);
                                    break;
                                }
                            } while (false);
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    return new Kusto.Language.Editor.CodeActionResult.$ctor3(adjustedActions);
                }

                return this;
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.CodeActor", {
        props: {
            /**
             * The name of the {@link }
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeActor
             * @function Name
             * @type string
             */
            Name: {
                get: function () {
                    return Bridge.Reflection.getTypeName(Bridge.getType(this));
                }
            }
        }
    });

    /**
     * A class that details the range of text of a unique block of code in a {@link } and its associated {@link }.
     *
     * @public
     * @class Kusto.Language.Editor.CodeBlock
     */
    Bridge.define("Kusto.Language.Editor.CodeBlock", {
        fields: {
            _codeService: null
        },
        props: {
            /**
             * The text of the {@link }
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeBlock
             * @function Text
             * @type string
             */
            Text: {
                get: function () {
                    return this._codeService.Text;
                }
            },
            /**
             * The start of the {@link } within the {@link }.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CodeBlock
             * @function Start
             * @type number
             */
            Start: 0,
            /**
             * The length of the {@link } within the {@link }.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeBlock
             * @function Length
             * @type number
             */
            Length: {
                get: function () {
                    return this.Text.length;
                }
            },
            /**
             * The end of the {@link } within the {@link }.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeBlock
             * @function End
             * @type number
             */
            End: {
                get: function () {
                    return ((this.Start + this.Length) | 0);
                }
            },
            /**
             * The kind of code in the {@link }.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeBlock
             * @function Kind
             * @type string
             */
            Kind: {
                get: function () {
                    return this._codeService.Kind;
                }
            },
            /**
             * The {@link } associated with this {@link }.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeBlock
             * @function Service
             * @type Kusto.Language.Editor.CodeService
             */
            Service: {
                get: function () {
                    return this._codeService;
                }
            }
        },
        ctors: {
            ctor: function (start, codeService) {
                this.$initialize();
                this.Start = start;
                var ols;
                this._codeService = ((ols = Bridge.as(codeService, Kusto.Language.Editor.OffsetCodeService))) != null ? ols.WithOffset(start) : new Kusto.Language.Editor.OffsetCodeService(codeService, start);
            }
        },
        methods: {
            /**
             * Creates a new {@link } with a modified starting position.
             *
             * @instance
             * @this Kusto.Language.Editor.CodeBlock
             * @memberof Kusto.Language.Editor.CodeBlock
             * @param   {number}                             start
             * @return  {Kusto.Language.Editor.CodeBlock}
             */
            WithStart: function (start) {
                return new Kusto.Language.Editor.CodeBlock(start, this.Service);
            }
        }
    });

    /**
     * Known code kinds.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Editor.CodeKinds
     */
    Bridge.define("Kusto.Language.Editor.CodeKinds", {
        statics: {
            fields: {
                /**
                 * The code is a Kusto Query.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CodeKinds
                 * @constant
                 * @default "Query"
                 * @type string
                 */
                Query: null,
                /**
                 * The code is a Kusto Commmand.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CodeKinds
                 * @constant
                 * @default "Command"
                 * @type string
                 */
                Command: null,
                /**
                 * The code is a Kusto Directive
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CodeKinds
                 * @constant
                 * @default "Directive"
                 * @type string
                 */
                Directive: null,
                /**
                 * The code kind is not known.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CodeKinds
                 * @constant
                 * @default "Unknown"
                 * @type string
                 */
                Unknown: null
            },
            ctors: {
                init: function () {
                    this.Query = "Query";
                    this.Command = "Command";
                    this.Directive = "Directive";
                    this.Unknown = "Unknown";
                }
            }
        }
    });

    /**
     * A script that contains a sequence of independent {@link }s,
     each with its own {@link } for intellisense and editor related features.
     *
     * @public
     * @class Kusto.Language.Editor.CodeScript
     */
    Bridge.define("Kusto.Language.Editor.CodeScript", {
        statics: {
            methods: {
                /**
                 * Create a new {@link } from the specified text and a {@link }
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.CodeScript
                 * @memberof Kusto.Language.Editor.CodeScript
                 * @param   {string}                                      text       
                 * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory
                 * @return  {Kusto.Language.Editor.CodeScript}
                 */
                From: function (text, factory) {
                    var $t;
                    return Kusto.Language.Editor.CodeScript.CreateScript(($t = text, $t != null ? $t : ""), factory);
                },
                /**
                 * Create a new {@link } from the specified text and globals.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.CodeScript
                 * @memberof Kusto.Language.Editor.CodeScript
                 * @param   {string}                              text       
                 * @param   {Kusto.Language.GlobalState}          globals
                 * @return  {Kusto.Language.Editor.CodeScript}
                 */
                From$1: function (text, globals) {
                    return Kusto.Language.Editor.CodeScript.From(text, new Kusto.Language.Editor.KustoCodeServiceFactory(globals));
                },
                /**
                 * Creates a {@link } from the text
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.CodeScript
                 * @memberof Kusto.Language.Editor.CodeScript
                 * @param   {string}                                      text              
                 * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory           
                 * @param   {System.Collections.Generic.IEnumerable$1}    existingBlocks
                 * @return  {Kusto.Language.Editor.CodeScript}
                 */
                CreateScript: function (text, factory, existingBlocks) {
                    if (existingBlocks === void 0) { existingBlocks = null; }
                    var lineStarts = new (System.Collections.Generic.List$1(System.Int32)).ctor();
                    var blockStarts = new (System.Collections.Generic.List$1(System.Int32)).ctor();
                    Kusto.Language.Editor.CodeScript.GetStarts(text, lineStarts, blockStarts);

                    var existingBlockMap = existingBlocks != null ? Kusto.Language.Utils.TextKeyedDictionaryExtensions.ToTextKeyedDictionary(Kusto.Language.Editor.CodeBlock, Kusto.Language.Editor.CodeBlock, existingBlocks, function (b) {
                        return b.Text;
                    }, function (b) {
                        return b;
                    }) : null;

                    var blocks = new (System.Collections.Generic.List$1(Kusto.Language.Editor.CodeBlock)).ctor();
                    for (var i = 0; i < blockStarts.Count; i = (i + 1) | 0) {
                        var start = blockStarts.getItem(i);
                        var length = ((i + 1) | 0) < blockStarts.Count ? ((blockStarts.getItem(((i + 1) | 0)) - start) | 0) : ((text.length - start) | 0);
                        var block = { };

                        if (existingBlockMap != null && existingBlockMap.TryGetValue(text, start, length, block)) {
                            block.v = block.v.WithStart(start);
                        } else {
                            var blockText = text.substr(start, length);
                            var service = { };

                            if (!factory.TryGetCodeService(blockText, service)) {
                                service.v = new Kusto.Language.Editor.UnknownCodeService(blockText);
                            }

                            block.v = new Kusto.Language.Editor.CodeBlock(start, service.v);
                        }

                        blocks.add(block.v);
                    }

                    return new Kusto.Language.Editor.CodeScript(text, lineStarts, blocks, factory);
                },
                /**
                 * Gets the starting offset of all the lines and script blocks.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.CodeScript
                 * @memberof Kusto.Language.Editor.CodeScript
                 * @param   {string}                               text           
                 * @param   {System.Collections.Generic.List$1}    lineStarts     
                 * @param   {System.Collections.Generic.List$1}    blockStarts
                 * @return  {void}
                 */
                GetStarts: function (text, lineStarts, blockStarts) {
                    lineStarts.add(0);
                    blockStarts.add(0);

                    var allWhitespace = true; // until proven otherwise
                    var newBlockNextWhitespaceLine = false; // no prior block
                    var newBlockNextNonWhitespaceLine = false; // already added first block
                    var lineStart = 0;
                    var skipToEnd = 0; // region to ignore linebreaks informing block breaks

                    for (var i = 0, n = text.length; i < n; ) {
                        var lb = Kusto.Language.Parsing.TextFacts.GetLineBreakLength(text, i);
                        if (lb > 0) {
                            i = (i + lb) | 0;

                            // next block start happens after one all whitespace line gap
                            if (allWhitespace && i > skipToEnd) {
                                if (newBlockNextWhitespaceLine) {
                                    // this is a one line empty block
                                    blockStarts.add(lineStart);
                                }

                                newBlockNextWhitespaceLine = true;
                                newBlockNextNonWhitespaceLine = true;
                            } else if (newBlockNextNonWhitespaceLine) {
                                blockStarts.add(lineStart);
                                newBlockNextWhitespaceLine = false;
                                newBlockNextNonWhitespaceLine = false;
                            } else {
                                // first gap line belongs to prior block
                                newBlockNextWhitespaceLine = false;
                            }

                            lineStart = i;
                            lineStarts.add(lineStart);
                            allWhitespace = true;
                            continue;
                        }

                        if (i >= skipToEnd) {
                            // skip over strings in case they contain blank lines
                            // or they may contain characters that would otherwise appear to be the start
                            // of multi-line string
                            var strlen = Kusto.Language.Parsing.TokenParser.ScanStringLiteral(text, i);
                            if (strlen > 0) {
                                skipToEnd = (i + strlen) | 0;
                            } else {
                                // skip over comments as they may contain characters that appear to be the start
                                // of a multi-line string
                                var commentLen = Kusto.Language.Parsing.TokenParser.ScanComment(text, i);
                                if (commentLen > 0) {
                                    skipToEnd = (i + commentLen) | 0;
                                }
                            }
                        }

                        if (!Kusto.Language.Parsing.TextFacts.IsWhitespace(text.charCodeAt(i))) {
                            i = (i + 1) | 0;
                            allWhitespace = false;
                        } else {
                            i = (i + 1) | 0;
                        }
                    }

                    // end case
                    if ((allWhitespace && newBlockNextWhitespaceLine) || (!allWhitespace && newBlockNextNonWhitespaceLine)) {
                        blockStarts.add(lineStart);
                    }
                }
            }
        },
        fields: {
            lineStarts: null,
            blocks: null
        },
        props: {
            /**
             * The text that contains the sequence of {@link }s.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CodeScript
             * @function Text
             * @type string
             */
            Text: null,
            /**
             * The factory used to construct a {@link } for each block.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CodeScript
             * @function Factory
             * @type Kusto.Language.Editor.CodeServiceFactory
             */
            Factory: null,
            /**
             * The collection of individual {@link }s.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeScript
             * @function Blocks
             * @type System.Collections.Generic.IReadOnlyList$1
             */
            Blocks: {
                get: function () {
                    return this.blocks;
                }
            },
            /**
             * The {@link } used by Kusto {@link }s.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeScript
             * @function Globals
             * @type Kusto.Language.GlobalState
             */
            Globals: {
                get: function () {
                    var $t;
                    return ($t = this.Factory.GetFactory(Kusto.Language.Editor.KustoCodeServiceFactory)) != null ? $t.Globals : null;
                }
            },
            LineStarts: {
                get: function () {
                    return this.lineStarts;
                }
            }
        },
        ctors: {
            ctor: function (text, lineStarts, blocks, factory) {
                this.$initialize();
                this.Text = text;
                this.lineStarts = lineStarts;
                this.blocks = blocks;
                this.Factory = factory;
            }
        },
        methods: {
            /**
             * Creates a new {@link } with the text changed.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeScript
             * @memberof Kusto.Language.Editor.CodeScript
             * @param   {string}                              newText
             * @return  {Kusto.Language.Editor.CodeScript}
             */
            WithText: function (newText) {
                var $t;
                // reuse any existing blocks and their queries that have not changed.
                return Kusto.Language.Editor.CodeScript.CreateScript(($t = newText, $t != null ? $t : ""), this.Factory, this.Blocks);
            },
            /**
             * Creates a new {@link } with the {@link } changed.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeScript
             * @memberof Kusto.Language.Editor.CodeScript
             * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory
             * @return  {Kusto.Language.Editor.CodeScript}
             */
            WithFactory: function (factory) {
                if (!Bridge.referenceEquals(factory, this.Factory)) {
                    return Kusto.Language.Editor.CodeScript.CreateScript(this.Text, factory, null);
                } else {
                    return this;
                }
            },
            /**
             * Creates a new {@link } with the text and globals changed.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeScript
             * @memberof Kusto.Language.Editor.CodeScript
             * @param   {string}                                      newText    
             * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory
             * @return  {Kusto.Language.Editor.CodeScript}
             */
            WithTextAndFactory: function (newText, factory) {
                return this.WithText(newText).WithFactory(factory);
            },
            /**
             * Creates a new {@link } with the kusto globals changed.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeScript
             * @memberof Kusto.Language.Editor.CodeScript
             * @param   {Kusto.Language.GlobalState}          newGlobals
             * @return  {Kusto.Language.Editor.CodeScript}
             */
            WithGlobals: function (newGlobals) {
                var kustoFactory = this.Factory.GetFactory(Kusto.Language.Editor.KustoCodeServiceFactory);
                if (kustoFactory != null) {
                    return this.WithFactory(this.Factory.WithFactory(kustoFactory.WithGlobals(newGlobals)));
                }

                return this;
            },
            /**
             * Gets the block corresponding to the text position.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeScript
             * @memberof Kusto.Language.Editor.CodeScript
             * @param   {number}                             position
             * @return  {Kusto.Language.Editor.CodeBlock}
             */
            GetBlockAtPosition: function (position) {
                if (position === 0) {
                    // first block
                    return System.Array.getItem(this.Blocks, 0, Kusto.Language.Editor.CodeBlock);
                } else if (position === this.Text.length) {
                    // last block
                    return System.Array.getItem(this.Blocks, ((System.Array.getCount(this.Blocks, Kusto.Language.Editor.CodeBlock) - 1) | 0), Kusto.Language.Editor.CodeBlock);
                } else if (position >= 0 && position < this.Text.length) {
                    var index = Kusto.Language.Utils.ListExtensions.BinarySearch(Kusto.Language.Editor.CodeBlock, this.blocks, function (b) {
                        return position < b.Start ? 1 : position >= b.End ? -1 : 0;
                    });
                    return System.Array.getItem(this.Blocks, index, Kusto.Language.Editor.CodeBlock);
                } else {
                    return null;
                }
            },
            /**
             * Gets the text position for the line number and character offset.
             Returns true if the position is determined, or false if the line/character is outside the text.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeScript
             * @memberof Kusto.Language.Editor.CodeScript
             * @param   {number}          line          The line number (1 based)
             * @param   {number}          lineOffset    The offset of the character in the line (1 based)
             * @param   {System.Int32}    position      The position in the text.
             * @return  {boolean}
             */
            TryGetTextPosition: function (line, lineOffset, position) {
                line = (line - 1) | 0;
                lineOffset = (lineOffset - 1) | 0;

                position.v = 0;

                if (line < 0 || line >= this.lineStarts.Count) {
                    return false;
                }

                var lineStart = this.lineStarts.getItem(line);
                var lineEnd = (line < ((this.lineStarts.Count - 1) | 0)) ? this.lineStarts.getItem(((line + 1) | 0)) : this.Text.length;

                // don't include line break characters in line length
                while (lineEnd > lineStart && Kusto.Language.Parsing.TextFacts.GetLineBreakLength(this.Text, ((lineEnd - 1) | 0)) > 0) {
                    lineEnd = (lineEnd - 1) | 0;
                }

                var lineLength = (lineEnd - lineStart) | 0;

                // allow character one position beyond end of line to represent line break or end of text
                // any virtual character beyond this is considered outside the text.
                if (lineOffset < ((lineLength + 1) | 0)) {
                    position.v = (lineStart + lineOffset) | 0;
                    return true;
                }

                return false;
            },
            /**
             * Gets the 1-based line and lineOffset for a position in the text.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeScript
             * @memberof Kusto.Language.Editor.CodeScript
             * @param   {number}          position      
             * @param   {System.Int32}    line          
             * @param   {System.Int32}    lineOffset
             * @return  {boolean}
             */
            TryGetLineAndOffset: function (position, line, lineOffset) {
                return Kusto.Language.Parsing.TextFacts.TryGetLineAndOffset(this.lineStarts, position, line, lineOffset);
            }
        }
    });

    /**
     * A service that provides intellisense and other editor related features over a piece of code.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Editor.CodeService
     */
    Bridge.define("Kusto.Language.Editor.CodeService", {
        props: {
            /**
             * The kind of code found in the text (see {@link }).
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeService
             * @function Kind
             * @type string
             */
            Kind: {
                get: function () {
                    return "";
                }
            },
            /**
             * The text of the code.
             *
             * @instance
             * @public
             * @readonly
             * @memberof Kusto.Language.Editor.CodeService
             * @function Text
             * @type string
             */
            Text: {
                get: function () {
                    return "";
                }
            }
        }
    });

    /**
     * A factory that constructs {@link } instances over blocks of code.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Editor.CodeServiceFactory
     */
    Bridge.define("Kusto.Language.Editor.CodeServiceFactory", {
        methods: {
            /**
             * .Gets a specific factory from the set of factories that compose this factory.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeServiceFactory
             * @memberof Kusto.Language.Editor.CodeServiceFactory
             * @param   {Function}    TFactory
             * @return  {TFactory}
             */
            GetFactory: function (TFactory) {
                if (Bridge.is(this, TFactory)) {
                    return Bridge.cast(this, TFactory);
                }

                return null;
            },
            /**
             * Combine an additional factory with this factory.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.CodeServiceFactory
             * @memberof Kusto.Language.Editor.CodeServiceFactory
             * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory
             * @return  {Kusto.Language.Editor.CodeServiceFactory}
             */
            WithFactory: function (factory) {
                var af;
                if (((af = Bridge.as(factory, Kusto.Language.Editor.CodeServiceFactory.AggregateCodeServiceFactory))) != null) {
                    return af.WithFactory(this);
                } else if (Bridge.referenceEquals(Bridge.getType(factory), Bridge.getType(this))) {
                    // specified factory is a replacement for this factory
                    return factory;
                } else {
                    return new Kusto.Language.Editor.CodeServiceFactory.AggregateCodeServiceFactory(System.Array.init([this], Kusto.Language.Editor.CodeServiceFactory)).WithFactory(factory);
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.CodeServiceFeatures", {
        statics: {
            fields: {
                Diagnostics: null,
                Classification: null,
                Completion: null,
                Outlining: null,
                QuickInfo: null,
                ClusterReferences: null,
                DatabaseReferences: null,
                MinimalText: null,
                Formatting: null,
                ClientParameters: null
            },
            ctors: {
                init: function () {
                    this.Diagnostics = "Diagnostics";
                    this.Classification = "Classification";
                    this.Completion = "Completion";
                    this.Outlining = "Outlining";
                    this.QuickInfo = "QuickInfo";
                    this.ClusterReferences = "ClusterReferences";
                    this.DatabaseReferences = "DatabaseReferences";
                    this.MinimalText = "MinimalText";
                    this.Formatting = "Formatting";
                    this.ClientParameters = "ClientParameters";
                }
            }
        }
    });

    /**
     * A hint that describes the category of syntax element that belongs in
     an associated syntax node location, used to determine appropriate
     completion items.
     *
     * @public
     * @class Kusto.Language.Editor.CompletionHint
     */
    Bridge.define("Kusto.Language.Editor.CompletionHint", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * No completion
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                None: 0,
                /**
                 * Inherit hint from parent
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Inherit: 1,
                /**
                 * An expression (scalar or tabular)
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Expression: 2,
                /**
                 * A scalar expression (non-boolean)
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 4
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Scalar: 4,
                /**
                 * A tabular expression
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 8
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Tabular: 8,
                /**
                 * A boolean expression
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 16
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Boolean: 16,
                /**
                 * A numeric expression
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 32
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Number: 32,
                /**
                 * Literal value
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 64
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Literal: 64,
                /**
                 * aggregate expression
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 128
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Aggregate: 128,
                /**
                 * A tabular function
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 256
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                TabularFunction: 256,
                /**
                 * A scalar function
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 512
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                ScalarFunction: 512,
                /**
                 * A database function
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 1024
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                DatabaseFunction: 1024,
                /**
                 * Any function
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 2048
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Function: 2048,
                /**
                 * A name declaration
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 4096
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Declaration: 4096,
                /**
                 * A column name reference
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 8192
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Column: 8192,
                /**
                 * A table name reference
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 16384
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Table: 16384,
                /**
                 * A database expression: database('database')
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 32768
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Database: 32768,
                /**
                 * A cluster expression: cluster('cluster')
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 65536
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Cluster: 65536,
                /**
                 * An entity group
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 131072
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                EntityGroup: 131072,
                /**
                 * Syntax completions only
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 262144
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Syntax: 262144,
                /**
                 * A query operator
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 524288
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Query: 524288,
                /**
                 * A command name
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 1048576
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Command: 1048576,
                /**
                 * A keyword
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 2097152
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Keyword: 2097152,
                /**
                 * A clause
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 4194304
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Clause: 4194304,
                /**
                 * A materialized view
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 8388608
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                MaterializedView: 8388608,
                /**
                 * A query option
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 16777216
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                Option: 16777216,
                /**
                 * An external table
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionHint
                 * @constant
                 * @default 33554432
                 * @type Kusto.Language.Editor.CompletionHint
                 */
                ExternalTable: 33554432
            }
        },
        $flags: true
    });

    /**
     * The completion info resulting from a call to {@link }
     *
     * @public
     * @class Kusto.Language.Editor.CompletionInfo
     */
    Bridge.define("Kusto.Language.Editor.CompletionInfo", {
        statics: {
            fields: {
                Empty: null
            },
            ctors: {
                init: function () {
                    this.Empty = new Kusto.Language.Editor.CompletionInfo(null, 0, 0);
                }
            }
        },
        props: {
            /**
             * The completion items.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionInfo
             * @function Items
             * @type System.Collections.Generic.IReadOnlyList$1
             */
            Items: null,
            /**
             * The start of the text that each {@link } will replace.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionInfo
             * @function EditStart
             * @type number
             */
            EditStart: 0,
            /**
             * The length of the text that each {@link } will replace.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionInfo
             * @function EditLength
             * @type number
             */
            EditLength: 0
        },
        ctors: {
            ctor: function (items, editStart, editLength) {
                this.$initialize();
                this.Items = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Editor.CompletionItem, items);
                this.EditStart = editStart;
                this.EditLength = editLength;
            }
        }
    });

    /**
     * @public
     * @class Kusto.Language.Editor.CompletionItem
     */
    Bridge.define("Kusto.Language.Editor.CompletionItem", {
        props: {
            /**
             * The kind of {@link }.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionItem
             * @function Kind
             * @type Kusto.Language.Editor.CompletionKind
             */
            Kind: 0,
            /**
             * The text to display for the {@link }.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionItem
             * @function DisplayText
             * @type string
             */
            DisplayText: null,
            /**
             * The text to match
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionItem
             * @function MatchText
             * @type string
             */
            MatchText: null,
            /**
             * The text to insert/replace with.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionItem
             * @function EditText
             * @type string
             */
            EditText: null,
            /**
             * The text insert/replace with after the cursor.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionItem
             * @function AfterText
             * @type string
             */
            AfterText: null,
            /**
             * The priority of the completion item.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.CompletionItem
             * @function Priority
             * @type Kusto.Language.Editor.CompletionPriority
             */
            Priority: 0
        },
        ctors: {
            ctor: function (kind, displayText, editText, afterText, matchText, priority) {
                if (editText === void 0) { editText = null; }
                if (afterText === void 0) { afterText = null; }
                if (matchText === void 0) { matchText = null; }
                if (priority === void 0) { priority = 2; }
                var $t, $t1, $t2;

                this.$initialize();
                this.DisplayText = ($t = displayText, $t != null ? $t : "");
                this.Kind = kind;
                this.EditText = ($t1 = editText, $t1 != null ? $t1 : this.DisplayText);
                this.AfterText = afterText;
                this.MatchText = ($t2 = matchText, $t2 != null ? $t2 : displayText);
                this.Priority = priority;
            }
        },
        methods: {
            WithKind: function (kind) {
                return new Kusto.Language.Editor.CompletionItem(kind, this.DisplayText, this.EditText, this.AfterText, this.MatchText, this.Priority);
            },
            WithDisplayText: function (displayText) {
                return new Kusto.Language.Editor.CompletionItem(this.Kind, displayText, this.EditText, this.AfterText, this.MatchText, this.Priority);
            },
            WithEditText: function (editText) {
                return new Kusto.Language.Editor.CompletionItem(this.Kind, this.DisplayText, editText, this.AfterText, this.MatchText, this.Priority);
            },
            WithAfterText: function (afterText) {
                return new Kusto.Language.Editor.CompletionItem(this.Kind, this.DisplayText, this.EditText, afterText, this.MatchText, this.Priority);
            },
            WithMatchText: function (matchText) {
                return new Kusto.Language.Editor.CompletionItem(this.Kind, this.DisplayText, this.EditText, this.AfterText, matchText, this.Priority);
            },
            WithPriority: function (priority) {
                return new Kusto.Language.Editor.CompletionItem(this.Kind, this.DisplayText, this.EditText, this.AfterText, this.MatchText, priority);
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.CompletionKind", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * Unknown
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Unknown: 0,
                /**
                 * A language keyword
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Keyword: 1,
                /**
                 * Punctuation like () {} ; , :
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Punctuation: 2,
                /**
                 * Other syntax item
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 3
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Syntax: 3,
                /**
                 * An identifier
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 4
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Identifier: 4,
                /**
                 * An example value
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 5
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Example: 5,
                /**
                 * A keyword that starts a scalar expression
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 6
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                ScalarPrefix: 6,
                /**
                 * A keyword that starts a tabular expression
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 7
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                TabularPrefix: 7,
                /**
                 * A keyword that follows a tabular expression
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 8
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                TabularSuffix: 8,
                /**
                 * A keyword that starts a query operator
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 9
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                QueryPrefix: 9,
                /**
                 * A keyword that starts a control command
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 10
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                CommandPrefix: 10,
                /**
                 * An infix scalar operator
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 11
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                ScalarInfix: 11,
                /**
                 * The name of a render chart type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 12
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                RenderChart: 12,
                /**
                 * The name of a column
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 13
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Column: 13,
                /**
                 * The name of a table
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 14
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Table: 14,
                /**
                 * The name of a built-in kusto language function.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 15
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                BuiltInFunction: 15,
                /**
                 * The name of a user defined function declared locally in a query.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 16
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                LocalFunction: 16,
                /**
                 * The name of a user defined function stored in a database.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 17
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                DatabaseFunction: 17,
                /**
                 * The name of a kusto language aggregate function.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 18
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                AggregateFunction: 18,
                /**
                 * The name of a parameter
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 19
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Parameter: 19,
                /**
                 * The name of a variable
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 20
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Variable: 20,
                /**
                 * The name of a database
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 21
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Database: 21,
                /**
                 * The name of a cluster
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 22
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Cluster: 22,
                /**
                 * The name of a materialized view
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 23
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                MaterialiedView: 23,
                /**
                 * The name of a scalar type
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 24
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                ScalarType: 24,
                /**
                 * A query option
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.CompletionKind
                 * @constant
                 * @default 25
                 * @type Kusto.Language.Editor.CompletionKind
                 */
                Option: 25
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.CompletionOptions", {
        statics: {
            fields: {
                Default: null
            },
            ctors: {
                init: function () {
                    this.Default = new Kusto.Language.Editor.CompletionOptions(Kusto.Language.Editor.CompletionOptions.OptionFlags.Default, Kusto.Language.IncludeFunctionKind.All);
                }
            },
            methods: {
                SetOption: function (flags, option, value) {
                    return value ? flags | option : flags & ~option;
                }
            }
        },
        fields: {
            flags: 0
        },
        props: {
            IncludeSymbols: {
                get: function () {
                    return (this.flags & Kusto.Language.Editor.CompletionOptions.OptionFlags.IncludeSymbols) !== 0;
                }
            },
            IncludeSyntax: {
                get: function () {
                    return (this.flags & Kusto.Language.Editor.CompletionOptions.OptionFlags.IncludeSyntax) !== 0;
                }
            },
            IncludePunctuationOnlySyntax: {
                get: function () {
                    return (this.flags & Kusto.Language.Editor.CompletionOptions.OptionFlags.IncludePunctuation) !== 0;
                }
            },
            EnableParameterInjection: {
                get: function () {
                    return (this.flags & Kusto.Language.Editor.CompletionOptions.OptionFlags.EnableParameterInjection) !== 0;
                }
            },
            AutoAppendWhitespace: {
                get: function () {
                    return (this.flags & Kusto.Language.Editor.CompletionOptions.OptionFlags.AutoAppendWhitespace) !== 0;
                }
            },
            IncludeFunctions: 0
        },
        ctors: {
            ctor: function (flags, includeFunctionKind) {
                this.$initialize();
                this.flags = flags;
                this.IncludeFunctions = includeFunctionKind;
            }
        },
        methods: {
            WithIncludeSymbols: function (include) {
                return new Kusto.Language.Editor.CompletionOptions(Kusto.Language.Editor.CompletionOptions.SetOption(this.flags, Kusto.Language.Editor.CompletionOptions.OptionFlags.IncludeSymbols, include), this.IncludeFunctions);
            },
            WithIncludeFunctions: function (kind) {
                return new Kusto.Language.Editor.CompletionOptions(this.flags, kind);
            },
            WithIncludeFunctions$1: function (include) {
                return new Kusto.Language.Editor.CompletionOptions(this.flags, include ? Kusto.Language.IncludeFunctionKind.All : Kusto.Language.IncludeFunctionKind.None);
            },
            WithIncludeSyntax: function (include) {
                return new Kusto.Language.Editor.CompletionOptions(Kusto.Language.Editor.CompletionOptions.SetOption(this.flags, Kusto.Language.Editor.CompletionOptions.OptionFlags.IncludeSyntax, include), this.IncludeFunctions);
            },
            WithIncludePunctuationOnlySyntax: function (include) {
                return new Kusto.Language.Editor.CompletionOptions(Kusto.Language.Editor.CompletionOptions.SetOption(this.flags, Kusto.Language.Editor.CompletionOptions.OptionFlags.IncludePunctuation, include), this.IncludeFunctions);
            },
            WithEnableParameterInjection: function (enable) {
                return new Kusto.Language.Editor.CompletionOptions(Kusto.Language.Editor.CompletionOptions.SetOption(this.flags, Kusto.Language.Editor.CompletionOptions.OptionFlags.EnableParameterInjection, enable), this.IncludeFunctions);
            },
            WithAutoAppendWhitespace: function (enable) {
                return new Kusto.Language.Editor.CompletionOptions(Kusto.Language.Editor.CompletionOptions.SetOption(this.flags, Kusto.Language.Editor.CompletionOptions.OptionFlags.AutoAppendWhitespace, enable), this.IncludeFunctions);
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.CompletionOptions.OptionFlags", {
        $kind: "nested enum",
        statics: {
            fields: {
                IncludeSymbols: 1,
                IncludeSyntax: 2,
                IncludePunctuation: 4,
                EnableParameterInjection: 16,
                AutoAppendWhitespace: 32,
                Default: 39
            }
        },
        $flags: true
    });

    /**
     * The priority that controls the order ranking of completion items
     when presented.
     *
     * @public
     * @class Kusto.Language.Editor.CompletionPriority
     */
    Bridge.define("Kusto.Language.Editor.CompletionPriority", {
        $kind: "enum",
        statics: {
            fields: {
                Top: 0,
                High: 1,
                Normal: 2,
                Low: 3
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.DisabledDiagnostics", {
        statics: {
            fields: {
                SeverityPrefix: null,
                _codesThatCanBeDisabled: null
            },
            ctors: {
                init: function () {
                    this.SeverityPrefix = "sev:";
                }
            },
            methods: {
                Parse: function (text) {
                    return new Kusto.Language.Editor.DisabledDiagnostics.$ctor1(text);
                },
                CanDisableSeverity: function (severity) {
                    return Bridge.referenceEquals(severity, Kusto.Language.DiagnosticSeverity.Warning) || Bridge.referenceEquals(severity, Kusto.Language.DiagnosticSeverity.Suggestion) || Bridge.referenceEquals(severity, Kusto.Language.DiagnosticSeverity.Information);
                },
                CanDisableCode: function (code) {
                    if (Kusto.Language.Editor.DisabledDiagnostics._codesThatCanBeDisabled == null) {
                        Kusto.Language.Editor.DisabledDiagnostics._codesThatCanBeDisabled = new (System.Collections.Generic.HashSet$1(System.String)).$ctor1(System.Linq.Enumerable.from(Kusto.Language.Editor.KustoCodeService.AnalyzerDiagnostics, Kusto.Language.Diagnostic).select(function (d) {
                                return d.Code;
                            }));
                    }

                    return Kusto.Language.Editor.DisabledDiagnostics._codesThatCanBeDisabled.contains(code);
                }
            }
        },
        fields: {
            _severities: null,
            _codes: null
        },
        ctors: {
            $ctor1: function (text) {
                var $t;
                this.$initialize();
                var items = System.Linq.Enumerable.from(System.String.split((($t = text, $t != null ? $t : "")), System.Array.init([44], System.Char).map(function (i) {{ return String.fromCharCode(i); }}), null, 1), System.String).select(function (s) {
                        return s.trim();
                    }).toList(System.String);
                this._severities = new (System.Collections.Generic.HashSet$1(System.String)).$ctor1(System.Linq.Enumerable.from(items, System.String).where(function (i) {
                        return System.String.startsWith(i, Kusto.Language.Editor.DisabledDiagnostics.SeverityPrefix);
                    }).select(function (i) {
                    return i.substr(Kusto.Language.Editor.DisabledDiagnostics.SeverityPrefix.length);
                }));
                this._codes = new (System.Collections.Generic.HashSet$1(System.String)).$ctor1(System.Linq.Enumerable.from(items, System.String).where(function (i) {
                        return !System.String.startsWith(i, Kusto.Language.Editor.DisabledDiagnostics.SeverityPrefix);
                    }));
            },
            ctor: function () {
                this.$initialize();
                this._severities = new (System.Collections.Generic.HashSet$1(System.String)).ctor();
                this._codes = new (System.Collections.Generic.HashSet$1(System.String)).ctor();
            }
        },
        methods: {
            toString: function () {
                return Bridge.toArray(System.Linq.Enumerable.from(this._severities, System.String).orderBy(function (s) {
                            return s;
                        }).select(function (s) {
                        return (Kusto.Language.Editor.DisabledDiagnostics.SeverityPrefix || "") + (s || "");
                    }).concat(System.Linq.Enumerable.from(this._codes, System.String).orderBy(function (c) {
                            return c;
                        }))).join(",");
            },
            IsSeverityEnabled: function (severity) {
                return !this.IsServerityDisabled(severity);
            },
            IsServerityDisabled: function (severity) {
                return this._severities.contains(severity);
            },
            IsCodeEnabled: function (code) {
                return !this.IsCodeDisabled(code);
            },
            IsCodeDisabled: function (code) {
                return this._codes.contains(code);
            },
            IsDiagnosticEnabled: function (diagnostic) {
                return !this.IsDiagnosticDisabled(diagnostic);
            },
            IsDiagnosticDisabled: function (diagnostic) {
                return this.IsServerityDisabled(diagnostic.Severity) || this.IsCodeDisabled(diagnostic.Code);
            },
            SetSeverityEnabled: function (severity, enabled) {
                if (enabled) {
                    this._severities.remove(severity);
                } else if (!enabled && Kusto.Language.Editor.DisabledDiagnostics.CanDisableSeverity(severity)) {
                    this._severities.add(severity);
                }
            },
            SetCodeEnabled: function (code, enabled) {
                if (enabled) {
                    this._codes.remove(code);
                } else if (!enabled && Kusto.Language.Editor.DisabledDiagnostics.CanDisableCode(code)) {
                    this._codes.add(code);
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.FindRelatedOptions", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * No options.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.FindRelatedOptions
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.FindRelatedOptions
                 */
                None: 0,
                /**
                 * Consider variables that reference other items to be related to those items
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.FindRelatedOptions
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.FindRelatedOptions
                 */
                SeeThroughVariables: 1
            }
        },
        $flags: true
    });

    Bridge.define("Kusto.Language.Editor.FormattedText", {
        props: {
            /**
             * The formatted text
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.FormattedText
             * @function Text
             * @type string
             */
            Text: null,
            /**
             * The new cursor position within the newly formatted text.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.FormattedText
             * @function Position
             * @type number
             */
            Position: 0
        },
        ctors: {
            ctor: function (newText, newPosition) {
                this.$initialize();
                this.Text = newText;
                this.Position = newPosition;
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.FormattingOptions", {
        statics: {
            fields: {
                Default: null
            },
            ctors: {
                init: function () {
                    this.Default = new Kusto.Language.Editor.FormattingOptions(4, true, Kusto.Language.Editor.BrackettingStyle.Vertical, Kusto.Language.Editor.PlacementStyle.Smart, Kusto.Language.Editor.PlacementStyle.NewLine, Kusto.Language.Editor.PlacementStyle.None);
                }
            }
        },
        props: {
            /**
             * The number of spaces used per indentation level.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.FormattingOptions
             * @function IndentationSize
             * @type number
             */
            IndentationSize: 0,
            /**
             * Automatically add any missing tokens.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.FormattingOptions
             * @function InsertMissingTokens
             * @type boolean
             */
            InsertMissingTokens: false,
            /**
             * Bracketting style: (), [], {}
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.FormattingOptions
             * @function BrackettingStyle
             * @type Kusto.Language.Editor.BrackettingStyle
             */
            BrackettingStyle: 0,
            /**
             * Placement style of pipe operator.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.FormattingOptions
             * @function PipeOperatorStyle
             * @type Kusto.Language.Editor.PlacementStyle
             */
            PipeOperatorStyle: 0,
            /**
             * Placement style of query statements.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.FormattingOptions
             * @function StatementStyle
             * @type Kusto.Language.Editor.PlacementStyle
             */
            StatementStyle: 0,
            /**
             * Placement style of semicolons between statements.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.FormattingOptions
             * @function SemicolonStyle
             * @type Kusto.Language.Editor.PlacementStyle
             */
            SemicolonStyle: 0
        },
        ctors: {
            ctor: function (indentationSize, insertMissingTokens, brackettingStyle, pipeOperatorStyle, statementStyle, semicolonStyle) {
                this.$initialize();
                this.IndentationSize = indentationSize;
                this.InsertMissingTokens = insertMissingTokens;
                this.BrackettingStyle = brackettingStyle;
                this.PipeOperatorStyle = pipeOperatorStyle;
                this.StatementStyle = statementStyle;
                this.SemicolonStyle = semicolonStyle;
            }
        },
        methods: {
            With: function (indentationSize, insertMissingTokens, brackettingStyle, pipeOperatorStyle, statementStyle, semicolonStyle) {
                if (indentationSize === void 0) { indentationSize = null; }
                if (insertMissingTokens === void 0) { insertMissingTokens = null; }
                if (brackettingStyle === void 0) { brackettingStyle = null; }
                if (pipeOperatorStyle === void 0) { pipeOperatorStyle = null; }
                if (statementStyle === void 0) { statementStyle = null; }
                if (semicolonStyle === void 0) { semicolonStyle = null; }
                var newIndentationSize = System.Nullable.hasValue(indentationSize) ? System.Nullable.getValue(indentationSize) : this.IndentationSize;
                var newInsertMissingTokens = System.Nullable.hasValue(insertMissingTokens) ? System.Nullable.getValue(insertMissingTokens) : this.InsertMissingTokens;
                var newBrackettingStyle = System.Nullable.hasValue(brackettingStyle) ? System.Nullable.getValue(brackettingStyle) : this.BrackettingStyle;
                var newPipeOperatorStyle = System.Nullable.hasValue(pipeOperatorStyle) ? System.Nullable.getValue(pipeOperatorStyle) : this.PipeOperatorStyle;
                var newStatementStyle = System.Nullable.hasValue(statementStyle) ? System.Nullable.getValue(statementStyle) : this.StatementStyle;
                var newSemicolonStyle = System.Nullable.hasValue(semicolonStyle) ? System.Nullable.getValue(semicolonStyle) : this.SemicolonStyle;

                if (newIndentationSize !== this.IndentationSize || newInsertMissingTokens !== this.InsertMissingTokens || newBrackettingStyle !== this.BrackettingStyle || newPipeOperatorStyle !== this.PipeOperatorStyle || newStatementStyle !== this.StatementStyle || newSemicolonStyle !== this.SemicolonStyle) {
                    return new Kusto.Language.Editor.FormattingOptions(newIndentationSize, newInsertMissingTokens, newBrackettingStyle, newPipeOperatorStyle, newStatementStyle, newSemicolonStyle);
                } else {
                    return this;
                }
            },
            WithIndentationSize: function (size) {
                return this.With(size, void 0, void 0, void 0, void 0, void 0);
            },
            WithInsertMissingTokens: function (enable) {
                return this.With(void 0, enable, void 0, void 0, void 0, void 0);
            },
            WithBrackettingStyle: function (style) {
                return this.With(void 0, void 0, style, void 0, void 0, void 0);
            },
            WithPipeOperatorStyle: function (style) {
                return this.With(void 0, void 0, void 0, style, void 0, void 0);
            },
            WithStatementStyle: function (style) {
                return this.With(void 0, void 0, void 0, void 0, style, void 0);
            },
            WithSemicolonStyle: function (style) {
                return this.With(void 0, void 0, void 0, void 0, void 0, style);
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoActors", {
        statics: {
            fields: {
                FunctionInliner: null,
                ExtractExpression: null,
                All: null
            },
            ctors: {
                init: function () {
                    this.FunctionInliner = new Kusto.Language.Editor.InlineDatabaseFunctionActor();
                    this.ExtractExpression = new Kusto.Language.Editor.ExtractExpressionActor();
                    this.All = System.Array.init([Kusto.Language.Editor.KustoActors.FunctionInliner, Kusto.Language.Editor.KustoActors.ExtractExpression], Kusto.Language.Editor.KustoActor);
                }
            }
        }
    });

    /**
     * Diagnostic codes produced by kusto analyzers.
     They must be unique.
     *
     * @static
     * @abstract
     * @class Kusto.Language.Editor.KustoAnalyzerCodes
     */
    Bridge.define("Kusto.Language.Editor.KustoAnalyzerCodes", {
        statics: {
            fields: {
                AvoidUsingContains: null,
                AvoidUsingIsNullStringComparision: null,
                AvoidUsingIsNotNullStringComparison: null,
                AvoidUsingShortStringComparision: null,
                AvoidUsingToBoolOnNumerics: null,
                NullAggregation: null,
                AvoidUsingFormatDateTimeInPredicate: null,
                AvoidUsingObsoleteFunctions: null,
                AvoidJoinWithoutKind: null,
                StdevTimespanConversion: null,
                ColumnHasSameNameAsVariable: null,
                PreferUsingMaterializedViewIntrinsic: null,
                CalledFunctionHasErrors: null,
                AvoidUsingLegacyPartition: null
            },
            ctors: {
                init: function () {
                    this.AvoidUsingContains = "KS500";
                    this.AvoidUsingIsNullStringComparision = "KS501";
                    this.AvoidUsingIsNotNullStringComparison = "KS502";
                    this.AvoidUsingShortStringComparision = "KS503";
                    this.AvoidUsingToBoolOnNumerics = "KS504";
                    this.NullAggregation = "KS505";
                    this.AvoidUsingFormatDateTimeInPredicate = "KS506";
                    this.AvoidUsingObsoleteFunctions = "KS507";
                    this.AvoidJoinWithoutKind = "KS508";
                    this.StdevTimespanConversion = "KS509";
                    this.ColumnHasSameNameAsVariable = "KS510";
                    this.PreferUsingMaterializedViewIntrinsic = "KS511";
                    this.CalledFunctionHasErrors = "KS512";
                    this.AvoidUsingLegacyPartition = "KS513";
                }
            }
        }
    });

    /**
     * The known kusto analyzers
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Editor.KustoAnalyzers
     */
    Bridge.define("Kusto.Language.Editor.KustoAnalyzers", {
        statics: {
            fields: {
                AvoidUsingContains: null,
                AvoidUsingIsNullStringComparison: null,
                AvoidUsingShortStringComparision: null,
                AvoidUsingToBoolOnNumerics: null,
                NullAggregation: null,
                AvoidUsingFormatDatetimeInPredicate: null,
                AvoidUsingLegacyPartition: null,
                AvoidUsingObsoleteFunctions: null,
                AvoidJoinWithoutKind: null,
                StdevTimespanConversion: null,
                ColumnHasSameNameAsVariable: null,
                PreferUsingMaterializedViewIntrinsic: null,
                CalledFunctionHasErrors: null,
                /**
                 * The set of all known kusto analyzers
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.KustoAnalyzers
                 * @type System.Collections.Generic.IReadOnlyList$1
                 */
                All: null
            },
            ctors: {
                init: function () {
                    this.AvoidUsingContains = new Kusto.Language.Editor.AvoidUsingContainsAnalyzer();
                    this.AvoidUsingIsNullStringComparison = new Kusto.Language.Editor.AvoidUsingIsNullStringComparisonAnalyzer();
                    this.AvoidUsingShortStringComparision = new Kusto.Language.Editor.AvoidUsingShortStringComparisionAnalyzer();
                    this.AvoidUsingToBoolOnNumerics = new Kusto.Language.Editor.AvoidUsingToBoolOnNumericsAnalyzer();
                    this.NullAggregation = new Kusto.Language.Editor.NullAggregationAnalyzer();
                    this.AvoidUsingFormatDatetimeInPredicate = new Kusto.Language.Editor.AvoidUsingFormatDateTimeInPredicateAnalyzer();
                    this.AvoidUsingLegacyPartition = new Kusto.Language.Editor.AvoidUsingLegacyPartitionAnalyzer();
                    this.AvoidUsingObsoleteFunctions = new Kusto.Language.Editor.AvoidUsingObsoleteFunctionsAnalyzer();
                    this.AvoidJoinWithoutKind = new Kusto.Language.Editor.AvoidJoinWithoutKindAnalyzer();
                    this.StdevTimespanConversion = new Kusto.Language.Editor.StdevTimespanConversionAnalyzer();
                    this.ColumnHasSameNameAsVariable = new Kusto.Language.Editor.ColumnHasSameNameAsVariableAnalyzer();
                    this.PreferUsingMaterializedViewIntrinsic = new Kusto.Language.Editor.PreferUsingMaterializedViewIntrinsicAnalyzer();
                    this.CalledFunctionHasErrors = new Kusto.Language.Editor.CalledFunctionHasErrorsAnalyzer();
                    this.All = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Editor.KustoAnalyzer, System.Array.init([Kusto.Language.Editor.KustoAnalyzers.AvoidUsingContains, Kusto.Language.Editor.KustoAnalyzers.AvoidUsingIsNullStringComparison, Kusto.Language.Editor.KustoAnalyzers.AvoidUsingToBoolOnNumerics, Kusto.Language.Editor.KustoAnalyzers.AvoidUsingShortStringComparision, Kusto.Language.Editor.KustoAnalyzers.NullAggregation, Kusto.Language.Editor.KustoAnalyzers.AvoidUsingFormatDatetimeInPredicate, Kusto.Language.Editor.KustoAnalyzers.AvoidUsingObsoleteFunctions, Kusto.Language.Editor.KustoAnalyzers.AvoidJoinWithoutKind, Kusto.Language.Editor.KustoAnalyzers.StdevTimespanConversion, Kusto.Language.Editor.KustoAnalyzers.AvoidUsingLegacyPartition, Kusto.Language.Editor.KustoAnalyzers.ColumnHasSameNameAsVariable, Kusto.Language.Editor.KustoAnalyzers.PreferUsingMaterializedViewIntrinsic, Kusto.Language.Editor.KustoAnalyzers.CalledFunctionHasErrors], Kusto.Language.Editor.KustoAnalyzer));
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoClassifier", {
        statics: {
            methods: {
                GetClassifications: function (root, start, length, clipToRange, list, cancellationToken) {
                    var end = (start + length) | 0;

                    // don't let classification ranges escape the requested bounds.
                    var limiter = function (range) {
                        // only if the classification range overlaps window
                        if (range.End > start && range.Start < end) {
                            // adjust range it if starts before or ends after the window
                            if (clipToRange && (range.Start < start || range.End > end)) {
                                var clipStart = Math.max(range.Start, start);
                                var clipEnd = Math.min(range.End, end);
                                range = new Kusto.Language.Editor.ClassifiedRange(range.Kind, clipStart, ((clipEnd - clipStart) | 0));
                            }

                            // merge ranges if this range is adjacent to the last range and the same kind
                            if (list.Count > 0) {
                                var last = list.getItem(((list.Count - 1) | 0));
                                if (last.Kind === range.Kind && last.End === range.Start) {
                                    list.setItem(((list.Count - 1) | 0), new Kusto.Language.Editor.ClassifiedRange(last.Kind, last.Start, ((last.Length + range.Length) | 0)));
                                    return;
                                }
                            }

                            list.add(range);
                        }
                    };

                    // produce classification ranges for all tokens that coincide with the window
                    root.WalkTokens$1(start, end, function (token) {
                        cancellationToken.ThrowIfCancellationRequested();

                        Kusto.Language.Editor.KustoClassifier.GetTriviaClassifications(token, limiter);

                        if (token.IsLiteral && token.Prefix.length > 0) {
                            // special case for literals with prefix
                            limiter(new Kusto.Language.Editor.ClassifiedRange(Kusto.Language.Editor.ClassificationKind.Keyword, token.TextStart, token.Prefix.length));
                            limiter(new Kusto.Language.Editor.ClassifiedRange(Kusto.Language.Editor.ClassificationKind.Literal, ((token.TextStart + token.Prefix.length) | 0), ((token.Text.length - token.Prefix.length) | 0)));
                        } else {
                            var kind = Kusto.Language.Editor.KustoClassifier.GetKind(token);

                            limiter(new Kusto.Language.Editor.ClassifiedRange(kind, token.TextStart, token.Width));
                        }
                    });
                },
                GetKind: function (token) {
                    var $step = 0,
                        $jumpFromFinally, 
                        $t, 
                        $asyncBody = Bridge.fn.bind(this, function () {
                            for (;;) {
                                $step = System.Array.min([0,1,2,3,4,5,6,7,8,9,10], $step);
                                switch ($step) {
                                    case 0: {
                                        if (Kusto.Language.Editor.KustoClassifier.IsSkipped(token)) {
                                            return Kusto.Language.Editor.ClassificationKind.PlainText;
                                        }

                                        if (Kusto.Language.Editor.KustoClassifier.IsCommandVerbToken(token)) {
                                            return Kusto.Language.Editor.ClassificationKind.Command;
                                        }

                                        if (Bridge.is(token.Parent, Kusto.Language.Syntax.BracedName)) {
                                            return Kusto.Language.Editor.ClassificationKind.ClientParameter;
                                        }

                                        $t = Kusto.Language.Syntax.SyntaxFacts.GetCategory(token.Kind);
                                        if ($t === Kusto.Language.Syntax.SyntaxCategory.Identifier) {
                                            $step = 1;
                                            continue;
                                        }
                                        else if ($t === Kusto.Language.Syntax.SyntaxCategory.Literal) {
                                            $step = 2;
                                            continue;
                                        }
                                        else if ($t === Kusto.Language.Syntax.SyntaxCategory.Keyword) {
                                            $step = 3;
                                            continue;
                                        }
                                        else if ($t === Kusto.Language.Syntax.SyntaxCategory.Punctuation) {
                                            $step = 7;
                                            continue;
                                        }
                                        else if ($t === Kusto.Language.Syntax.SyntaxCategory.Operator) {
                                            $step = 8;
                                            continue;
                                        }
                                        else  {
                                            $step = 9;
                                            continue;
                                        }
                                        $step = 10;
                                        continue;
                                    }
                                    case 1: {
                                        if (Kusto.Language.Editor.KustoClassifier.IsQueryParameter(token)) {
                                            return Kusto.Language.Editor.ClassificationKind.QueryParameter;
                                        } else {
                                            return Kusto.Language.Editor.KustoClassifier.GetIdentifierKind(token);
                                        }
                                    }
                                    case 2: {
                                        if (token.Kind === Kusto.Language.Syntax.SyntaxKind.StringLiteralToken) {
                                            return Kusto.Language.Editor.ClassificationKind.StringLiteral;
                                        } else {
                                            return Kusto.Language.Editor.ClassificationKind.Literal;
                                        }
                                    }
                                    case 3: {
                                        if (Kusto.Language.Editor.KustoClassifier.IsIdentifierKeyword(token)) {
                                            $step = 4;
                                            continue;
                                        } else  {
                                            $step = 5;
                                            continue;
                                        }
                                    }
                                    case 4: {
                                        $step = 1;
                                        continue;
                                    }
                                    case 5: {
                                        if (Kusto.Language.Editor.KustoClassifier.IsTypeToken(token)) {
                                            return Kusto.Language.Editor.ClassificationKind.Type;
                                        } else if (Kusto.Language.Editor.KustoClassifier.IsScalarOperatorToken(token)) {
                                            return Kusto.Language.Editor.ClassificationKind.ScalarOperator;
                                        } else if (Kusto.Language.Editor.KustoClassifier.IsQueryOperatorToken(token)) {
                                            return Kusto.Language.Editor.ClassificationKind.QueryOperator;
                                        } else if (Kusto.Language.Editor.KustoClassifier.IsQueryParameter(token)) {
                                            return Kusto.Language.Editor.ClassificationKind.QueryParameter;
                                        } else if (Kusto.Language.Editor.KustoClassifier.IsCommandVerbToken(token)) {
                                            return Kusto.Language.Editor.ClassificationKind.Command;
                                        } else {
                                            return Kusto.Language.Editor.ClassificationKind.Keyword;
                                        }
                                        $step = 6;
                                        continue;
                                    }
                                    case 6: {

                                    }
                                    case 7: {
                                        return Kusto.Language.Editor.ClassificationKind.Punctuation;
                                    }
                                    case 8: {
                                        return Kusto.Language.Editor.ClassificationKind.MathOperator;
                                    }
                                    case 9: {
                                        if (token.Kind === Kusto.Language.Syntax.SyntaxKind.DirectiveToken) {
                                            return Kusto.Language.Editor.ClassificationKind.Directive;
                                        } else {
                                            return Kusto.Language.Editor.ClassificationKind.PlainText;
                                        }
                                    }
                                    case 10: {
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                        }, arguments);

                    return $asyncBody();
                },
                GetIdentifierKind: function (token) {
                    var $t, $t1;
                    var symbolKind = ($t = (($t1 = token.Parent.GetFirstAncestorOrSelf(Kusto.Language.Syntax.SyntaxNode, function (n) {
                            return n.ReferencedSymbol != null;
                        })) != null ? $t1.ReferencedSymbol.Kind : null), $t != null ? $t : Kusto.Language.Symbols.SymbolKind.None);
                    switch (symbolKind) {
                        case Kusto.Language.Symbols.SymbolKind.Column: 
                            return Kusto.Language.Editor.ClassificationKind.Column;
                        case Kusto.Language.Symbols.SymbolKind.Table: 
                            return Kusto.Language.Editor.ClassificationKind.Table;
                        case Kusto.Language.Symbols.SymbolKind.Database: 
                            return Kusto.Language.Editor.ClassificationKind.Database;
                        case Kusto.Language.Symbols.SymbolKind.Function: 
                        case Kusto.Language.Symbols.SymbolKind.Pattern: 
                            return Kusto.Language.Editor.ClassificationKind.Function;
                        case Kusto.Language.Symbols.SymbolKind.Variable: 
                            return Kusto.Language.Editor.ClassificationKind.Variable;
                        case Kusto.Language.Symbols.SymbolKind.Parameter: 
                            return Kusto.Language.Editor.ClassificationKind.Parameter;
                        case Kusto.Language.Symbols.SymbolKind.MaterializedView: 
                            return Kusto.Language.Editor.ClassificationKind.MaterializedView;
                        case Kusto.Language.Symbols.SymbolKind.Option: 
                            return Kusto.Language.Editor.ClassificationKind.Option;
                        default: 
                            if (Kusto.Language.Editor.KustoClassifier.IsName(token)) {
                                return Kusto.Language.Editor.ClassificationKind.Identifier;
                            } else {
                                return Kusto.Language.Editor.ClassificationKind.Keyword;
                            }
                    }
                },
                IsSkipped: function (token) {
                    var ls;
                    return ((ls = Bridge.as(token.Parent, Kusto.Language.Syntax.SyntaxList))) != null && Bridge.is(ls.Parent, Kusto.Language.Syntax.SkippedTokens);
                },
                /**
                 * Determines if an identifier token is being used as a keyword (not a name)
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.KustoClassifier
                 * @memberof Kusto.Language.Editor.KustoClassifier
                 * @param   {Kusto.Language.Syntax.SyntaxToken}    token
                 * @return  {boolean}
                 */
                IsName: function (token) {
                    // the token is part of an actual name
                    return Bridge.is(token.Parent, Kusto.Language.Syntax.Name);
                },
                IsIdentifierKeyword: function (token) {
                    return Bridge.is(token.Parent, Kusto.Language.Syntax.TokenName);
                },
                IsTypeToken: function (token) {
                    var pt;
                    if (((pt = Bridge.as(token.Parent, Kusto.Language.Syntax.PrimitiveTypeExpression))) != null) {
                        var type = Kusto.Language.Binding.Binder.GetType(pt);
                        return type != null && !type.IsError;
                    }

                    return false;
                },
                IsScalarOperatorToken: function (token) {
                    var b;
                    var u;
                    return ((b = Bridge.as(token.Parent, Kusto.Language.Syntax.BinaryExpression))) != null && Bridge.referenceEquals(b.Operator, token) || ((u = Bridge.as(token.Parent, Kusto.Language.Syntax.PrefixUnaryExpression))) != null && Bridge.referenceEquals(u.Operator, token);
                },
                IsQueryOperatorToken: function (token) {
                    var q;
                    var tc;
                    return (((q = Bridge.as(token.Parent, Kusto.Language.Syntax.QueryOperator))) != null && Bridge.referenceEquals(q.GetChild(0), token)) || (((tc = Bridge.as(token.Parent, Kusto.Language.Syntax.TopNestedClause))) != null && Bridge.referenceEquals(tc.GetChild(0), token));
                },
                IsQueryParameter: function (token) {
                    var n;
                    var d;
                    var np;
                    return ((n = Bridge.as(token.Parent, Kusto.Language.Syntax.Name))) != null && ((d = Bridge.as(n.Parent, Kusto.Language.Syntax.NameDeclaration))) != null && ((np = Bridge.as(d.Parent, Kusto.Language.Syntax.NamedParameter))) != null && Bridge.referenceEquals(np.GetChild(0), d);
                },
                IsCommandVerbToken: function (token) {
                    var c;
                    var cn;
                    var list;
                    var uc;
                    return (((c = Bridge.as(token.Parent, Kusto.Language.Syntax.Command))) != null && c.GetChildIndex(token) < 2) || (((cn = Bridge.as(token.Parent, Kusto.Language.Syntax.CustomNode))) != null && Bridge.is(cn.Parent, Kusto.Language.Syntax.CustomCommand) && cn.GetChildIndex(token) === 0) || (((list = Bridge.as(token.Parent, Kusto.Language.Syntax.SyntaxList))) != null && ((uc = Bridge.as(list.Parent, Kusto.Language.Syntax.UnknownCommand))) != null && Bridge.referenceEquals(uc.Parts.getItem$1(0), token));
                },
                GetTriviaClassifications: function (token, action) {
                    if (token.TriviaWidth > 0) {
                        var trivia = token.Trivia;

                        for (var i = 0; i < trivia.length; i = (i + 1) | 0) {
                            // Tag anything that is not whitespace as the start of comment! 
                            // if it wasn't the start of a comment, it wouldn't be in the trivia!
                            // TODO: if we ever get more kinds of trivia, this will need updating.
                            if (!Kusto.Language.Parsing.TextFacts.IsWhitespace(trivia.charCodeAt(i))) {
                                var start = i;
                                for (; i < trivia.length; i = (i + 1) | 0) {
                                    if (Kusto.Language.Parsing.TextFacts.IsLineBreakStart(trivia.charCodeAt(i))) {
                                        break;
                                    }
                                }

                                action(new Kusto.Language.Editor.ClassifiedRange(Kusto.Language.Editor.ClassificationKind.Comment, ((token.TriviaStart + start) | 0), ((i - start) | 0)));
                            }
                        }
                    }
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoCompleter", {
        statics: {
            fields: {
                AfterQueryStart: null,
                s_expressionListPool: null,
                s_parameterListPool: null,
                punctuationWithoutSpace: null
            },
            ctors: {
                init: function () {
                    this.AfterQueryStart = "\n| ";
                    this.s_expressionListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Syntax.Expression)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Syntax.Expression)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.s_parameterListPool = new (Kusto.Language.Utils.ObjectPool$1(System.Collections.Generic.List$1(Kusto.Language.Symbols.Parameter)))(function () {
                        return new (System.Collections.Generic.List$1(Kusto.Language.Symbols.Parameter)).ctor();
                    }, function (list) {
                        list.clear();
                    });
                    this.punctuationWithoutSpace = System.Array.init(["(", "[", "{", "*", "@", "$"], System.String);
                }
            },
            methods: {
                /**
                 * True if the trivia offset is within a comment
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.KustoCompleter
                 * @memberof Kusto.Language.Editor.KustoCompleter
                 * @param   {string}     trivia          
                 * @param   {number}     triviaOffset
                 * @return  {boolean}
                 */
                IsInsideComment: function (trivia, triviaOffset) {
                    var start = { };
                    var length = { };
                    if (Kusto.Language.Parsing.TriviaFacts.TryGetCommentSpan(trivia, triviaOffset, start, length)) {
                        // the carat is before the comment, so allow completions
                        if (triviaOffset === start.v) {
                            return false;
                        }

                        if (triviaOffset === ((start.v + length.v) | 0) && Kusto.Language.Parsing.TextFacts.HasLineBreaks(trivia)) {
                            // after the line break so allow completions
                            return false;
                        }

                        return true;
                    }

                    return false;
                },
                IsInsideLiteral: function (token, position) {
                    return Kusto.Language.Syntax.SyntaxFacts.GetCategory(token.Kind) === Kusto.Language.Syntax.SyntaxCategory.Literal && (position >= token.TextStart && position <= token.End);
                },
                IsStartOfQuery: function (context) {
                    while (Bridge.is(context, Kusto.Language.Syntax.Name) || Bridge.is(context, Kusto.Language.Syntax.NameReference) || Bridge.is(context, Kusto.Language.Syntax.ExpressionStatement)) {
                        context = context.Parent;
                    }

                    return Bridge.is(context, Kusto.Language.Syntax.QueryBlock) || Bridge.is(context, Kusto.Language.Syntax.SyntaxList$1(Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement))) || Bridge.is(context, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement));
                },
                IsInvokeFunctionContext: function (node) {
                    // check to see if an ancestor is the invoke operator and not within an existing invoke function argument
                    var op = node != null ? node.GetFirstAncestorOrSelf(Kusto.Language.Syntax.QueryOperator) : null;
                    var fc = node != null ? node.GetFirstAncestorOrSelf(Kusto.Language.Syntax.FunctionCallExpression) : null;
                    return Bridge.is(op, Kusto.Language.Syntax.InvokeOperator) && (fc == null || fc.TextStart < op.TextStart);
                },
                IsNameLikeToken: function (kind) {
                    switch (Kusto.Language.Syntax.SyntaxFacts.GetCategory(kind)) {
                        case Kusto.Language.Syntax.SyntaxCategory.Identifier: 
                        case Kusto.Language.Syntax.SyntaxCategory.Keyword: 
                            return true;
                        default: 
                            // ! can be start of some keywords
                            return kind === Kusto.Language.Syntax.SyntaxKind.BangToken;
                    }
                },
                HasAffinity: function (token, position) {
                    return (position > token.TextStart && position < token.End) || position === token.TextStart && Kusto.Language.Editor.KustoCompleter.IsNameLikeToken(token.Kind) || position === token.End && Kusto.Language.Editor.KustoCompleter.IsNameLikeToken(token.Kind);
                },
                /**
                 * True if the node only contains one descendant {@link }
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.KustoCompleter
                 * @memberof Kusto.Language.Editor.KustoCompleter
                 * @param   {Kusto.Language.Syntax.SyntaxNode}    node
                 * @return  {boolean}
                 */
                ContainsOnlyOneToken: function (node) {
                    while (node != null && node.ChildCount === 1) {
                        var child = node.GetChild(0);
                        if (Bridge.is(child, Kusto.Language.Syntax.SyntaxToken)) {
                            return true;
                        }
                        node = Bridge.as(child, Kusto.Language.Syntax.SyntaxNode);
                    }

                    return false;
                },
                GetParameterExamples: function (signature, $arguments, possibleParameters, examples) {
                    var $t, $t1, $t2;
                    $t = Bridge.getEnumerator(possibleParameters, Kusto.Language.Symbols.Parameter);
                    try {
                        while ($t.moveNext()) {
                            var p = $t.Current;
                            if (System.Array.getCount(p.Examples, System.String) > 0) {
                                $t1 = Bridge.getEnumerator(p.Examples, System.String);
                                try {
                                    while ($t1.moveNext()) {
                                        var ex = $t1.Current;
                                        examples.add(ex);
                                    }
                                } finally {
                                    if (Bridge.is($t1, System.IDisposable)) {
                                        $t1.System$IDisposable$Dispose();
                                    }
                                }
                            }

                            if (Bridge.is(signature.Symbol, Kusto.Language.Symbols.FunctionSymbol)) {
                                if (p.TypeKind === Kusto.Language.Symbols.ParameterTypeKind.Declared) {
                                    $t2 = Bridge.getEnumerator(p.DeclaredTypes, Kusto.Language.Symbols.TypeSymbol);
                                    try {
                                        while ($t2.moveNext()) {
                                            var type = $t2.Current;
                                            Kusto.Language.Editor.KustoCompleter.GetTypeExamples(type, examples);
                                        }
                                    } finally {
                                        if (Bridge.is($t2, System.IDisposable)) {
                                            $t2.System$IDisposable$Dispose();
                                        }
                                    }
                                }
                            } else {
                                var op;
                                if (((op = Bridge.as(signature.Symbol, Kusto.Language.Symbols.OperatorSymbol))) != null) {
                                    Kusto.Language.Editor.KustoCompleter.GetOperatorExamples(op, $arguments, possibleParameters, examples);
                                }
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                },
                GetTypeExamples: function (type, examples) {
                    if (Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Bool)) {
                        examples.add("false");
                        examples.add("true");
                    }
                },
                GetOperatorExamples: function (symbol, $arguments, possibleParameters, examples) {
                    if (Bridge.referenceEquals(symbol, Kusto.Language.Operators.Equal) || Bridge.referenceEquals(symbol, Kusto.Language.Operators.NotEqual) || Bridge.referenceEquals(symbol, Kusto.Language.Operators.EqualTilde) || Bridge.referenceEquals(symbol, Kusto.Language.Operators.GreaterThan) || Bridge.referenceEquals(symbol, Kusto.Language.Operators.GreaterThanOrEqual) || Bridge.referenceEquals(symbol, Kusto.Language.Operators.LessThan) || Bridge.referenceEquals(symbol, Kusto.Language.Operators.LessThanOrEqual)) {
                        if (System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) > 0) {
                            var type = System.Array.getItem($arguments, 0, Kusto.Language.Syntax.Expression).ResultType;
                            Kusto.Language.Editor.KustoCompleter.GetTypeExamples(type, examples);
                        }
                    }
                },
                GetPossibleParameters: function (sig, $arguments, parameterName, argumentIndex, possibleParameters) {
                    if (parameterName != null) {
                        var ap = sig.GetParameter(parameterName);
                        if (!Bridge.referenceEquals(ap, Kusto.Language.Symbols.Signature.UnknownParameter)) {
                            possibleParameters.add(sig.GetParameter(parameterName));
                        }
                    } else if (argumentIndex < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression)) {
                        if (argumentIndex === ((System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) - 1) | 0) && System.Array.getItem($arguments, argumentIndex, Kusto.Language.Syntax.Expression).IsMissing) {
                            var prevArgs = System.Linq.Enumerable.from($arguments, Kusto.Language.Syntax.Expression).take(argumentIndex).toList(Kusto.Language.Syntax.Expression);
                            sig.GetNextPossibleParameters(prevArgs, possibleParameters);
                        } else {
                            var argParams = sig.GetArgumentParameters($arguments);
                            var ap1 = argParams.getItem(argumentIndex);
                            if (!Bridge.referenceEquals(ap1, Kusto.Language.Symbols.Signature.UnknownParameter)) {
                                possibleParameters.add(ap1);
                            }
                        }
                    } else {
                        sig.GetNextPossibleParameters($arguments, possibleParameters);
                    }
                },
                GetLeftOfFunctionCall: function (expression) {
                    var parent = expression.Parent;
                    var el;
                    if (((el = Bridge.as(parent, Kusto.Language.Syntax.ExpressionList))) != null) {
                        parent = el.Parent;
                    }
                    var fc;
                    if (((fc = Bridge.as(parent, Kusto.Language.Syntax.FunctionCallExpression))) != null) {
                        parent = fc.Parent;
                    }
                    var pe;
                    if (((pe = Bridge.as(parent, Kusto.Language.Syntax.PathExpression))) != null) {
                        return pe.Expression;
                    }

                    return null;
                },
                GetUnnamedArguments: function ($arguments, unnamedArguments) {
                    var $t;
                    $t = Bridge.getEnumerator($arguments, Kusto.Language.Syntax.Expression);
                    try {
                        while ($t.moveNext()) {
                            var arg = $t.Current;
                            var sn;
                            if (((sn = Bridge.as(arg, Kusto.Language.Syntax.SimpleNamedExpression))) != null) {
                                unnamedArguments.add(sn.Expression);
                            } else {
                                unnamedArguments.add(arg);
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }
                },
                GetSymbolMatch: function (hint) {
                    var match = Kusto.Language.Symbols.SymbolMatch.None;

                    if ((hint & Kusto.Language.Editor.CompletionHint.Column) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.Column;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.TabularFunction) !== 0) {
                        match |= 536;
                    }

                    if ((hint & (640)) !== 0) {
                        match |= 280;
                    }

                    if ((hint & (3072)) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.Function;
                    }

                    if ((hint & (52)) !== 0) {
                        match |= 281;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.Tabular) !== 0) {
                        match |= 1566;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.Expression) !== 0) {
                        match |= 1823;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.Table) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.Table;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.ExternalTable) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.ExternalTable;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.MaterializedView) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.MaterializedView;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.Database) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.Database;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.Cluster) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.Cluster;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.EntityGroup) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.EntityGroup;
                    }

                    if ((hint & Kusto.Language.Editor.CompletionHint.Option) !== 0) {
                        match |= Kusto.Language.Symbols.SymbolMatch.Option;
                    }

                    return match;
                },
                IsChildMissingOrEmpty: function (contextNode, childIndex) {
                    return Kusto.Language.Editor.KustoCompleter.IsChildMissing(contextNode, childIndex) || Kusto.Language.Editor.KustoCompleter.IsChildEmpty(contextNode, childIndex);
                },
                IsChildMissing: function (node, index) {
                    var child = node.GetChild(index);
                    return child != null && child.IsMissing;
                },
                IsChildEmpty: function (node, index) {
                    var child = node.GetChild(index);
                    return (child == null || child.Width === 0) && !Kusto.Language.Editor.KustoCompleter.IsChildMissing(node, index);
                },
                IsChildOnNewLine: function (node, index) {
                    var child;
                    var token;
                    if (((child = node.GetChild(index))) != null && ((token = child.GetFirstToken())) != null) {
                        var firstLB = Kusto.Language.Parsing.TextFacts.GetNextLineBreakStart(token.Trivia, 0);
                        return firstLB >= 0 && Kusto.Language.Parsing.TextFacts.IsWhitespaceOnly$1(token.Trivia, 0, firstLB);
                    }

                    return false;
                },
                GetNextPossibleParameterHints: function (signature, $arguments) {
                    var $t;
                    var parameterList = Kusto.Language.Editor.KustoCompleter.s_parameterListPool.AllocateFromPool();
                    try {
                        var hint = Kusto.Language.Editor.CompletionHint.None;

                        signature.GetNextPossibleParameters($arguments, parameterList);

                        $t = Bridge.getEnumerator(parameterList);
                        try {
                            while ($t.moveNext()) {
                                var p = $t.Current;
                                hint |= Kusto.Language.Editor.KustoCompleter.GetParameterHint(signature, p);
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }

                        return hint;
                    } finally {
                        Kusto.Language.Editor.KustoCompleter.s_parameterListPool.ReturnToPool(parameterList);
                    }
                },
                GetArgumentParameterHints: function (signature, $arguments, iArgument) {
                    var parameterList = Kusto.Language.Editor.KustoCompleter.s_parameterListPool.AllocateFromPool();
                    try {
                        signature.GetArgumentParameters$2($arguments, parameterList);
                        var p = parameterList.getItem(iArgument);
                        return Kusto.Language.Editor.KustoCompleter.GetParameterHint(signature, p);
                    } finally {
                        Kusto.Language.Editor.KustoCompleter.s_parameterListPool.ReturnToPool(parameterList);
                    }
                },
                GetParameterHint: function (signature, parameter) {
                    if (parameter != null) {
                        switch (parameter.ArgumentKind) {
                            case Kusto.Language.Symbols.ArgumentKind.Column: 
                                return Kusto.Language.Editor.CompletionHint.Column;
                            case Kusto.Language.Symbols.ArgumentKind.StarOnly: 
                                return Kusto.Language.Editor.CompletionHint.None;
                        }

                        switch (parameter.TypeKind) {
                            case Kusto.Language.Symbols.ParameterTypeKind.Declared: 
                                if (System.Array.getItem(parameter.DeclaredTypes, 0, Kusto.Language.Symbols.TypeSymbol).IsScalar) {
                                    if (System.Array.getCount(parameter.DeclaredTypes, Kusto.Language.Symbols.TypeSymbol) === 1 && Bridge.referenceEquals(System.Array.getItem(parameter.DeclaredTypes, 0, Kusto.Language.Symbols.TypeSymbol), Kusto.Language.Symbols.ScalarTypes.Bool)) {
                                        return Kusto.Language.Editor.CompletionHint.Boolean;
                                    } else if (System.Linq.Enumerable.from(parameter.DeclaredTypes, Kusto.Language.Symbols.TypeSymbol).all(function (t) {
                                            var s;
                                            return ((s = Bridge.as(t, Kusto.Language.Symbols.ScalarSymbol))) != null && s.IsNumeric;
                                        })) {
                                        return Kusto.Language.Editor.CompletionHint.Number;
                                    } else {
                                        return Kusto.Language.Editor.CompletionHint.Scalar;
                                    }
                                } else if (System.Array.getItem(parameter.DeclaredTypes, 0, Kusto.Language.Symbols.TypeSymbol).IsTabular) {
                                    return Kusto.Language.Editor.CompletionHint.Tabular;
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Parameter0: 
                                return Kusto.Language.Editor.KustoCompleter.GetParameterHint(signature, System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter) > 0 ? System.Array.getItem(signature.Parameters, 0, Kusto.Language.Symbols.Parameter) : null);
                            case Kusto.Language.Symbols.ParameterTypeKind.Parameter1: 
                                return Kusto.Language.Editor.KustoCompleter.GetParameterHint(signature, System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter) > 1 ? System.Array.getItem(signature.Parameters, 1, Kusto.Language.Symbols.Parameter) : null);
                            case Kusto.Language.Symbols.ParameterTypeKind.Parameter2: 
                                return Kusto.Language.Editor.KustoCompleter.GetParameterHint(signature, System.Array.getCount(signature.Parameters, Kusto.Language.Symbols.Parameter) > 2 ? System.Array.getItem(signature.Parameters, 2, Kusto.Language.Symbols.Parameter) : null);
                            case Kusto.Language.Symbols.ParameterTypeKind.Tabular: 
                                return Kusto.Language.Editor.CompletionHint.Tabular;
                            case Kusto.Language.Symbols.ParameterTypeKind.Database: 
                                return Kusto.Language.Editor.CompletionHint.Database;
                            case Kusto.Language.Symbols.ParameterTypeKind.Cluster: 
                                return Kusto.Language.Editor.CompletionHint.Cluster;
                            case Kusto.Language.Symbols.ParameterTypeKind.Number: 
                            case Kusto.Language.Symbols.ParameterTypeKind.NumberOrBool: 
                                return Kusto.Language.Editor.CompletionHint.Number;
                            default: 
                                return Kusto.Language.Editor.CompletionHint.Scalar;
                        }
                    }

                    return Kusto.Language.Editor.CompletionHint.None;
                },
                /**
                 * Gets the index of a child node within the parent context corresponding to the text position.
                 If the position is between nodes (in trivia/whitespace) it chooses the best index between existing nodes, that currently has no child node.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.KustoCompleter
                 * @memberof Kusto.Language.Editor.KustoCompleter
                 * @param   {Kusto.Language.Syntax.SyntaxNode}    node        
                 * @param   {number}                              position
                 * @return  {number}
                 */
                GetChildIndex: function (node, position) {
                    var firstChildBeyond = node.ChildCount;

                    var lastWasNullOrEmpty = false;

                    for (var i = 0, n = node.ChildCount; i < n; i = (i + 1) | 0) {
                        var child = node.GetChild(i);
                        if (child != null) {
                            if (position > child.TextStart && position < child.End && child.Width > 0) {
                                // position is in middle of child, so this is the correct child index
                                return i;
                            } else if (position < child.TextStart) {
                                // we went beyond the position, so remember this for next step
                                firstChildBeyond = i;
                                break;
                            } else if (position === child.TextStart) {
                                if (child.Width === 0) {
                                    firstChildBeyond = (i + 1) | 0;
                                    break;
                                } else if (lastWasNullOrEmpty) {
                                    firstChildBeyond = i;
                                    break;
                                }
                            } else {
                                lastWasNullOrEmpty = child.Width === 0;
                            }
                        } else {
                            lastWasNullOrEmpty = true;
                        }
                    }

                    var bestEmptyChild = (firstChildBeyond - 1) | 0;
                    for (var i1 = (firstChildBeyond - 1) | 0; i1 >= 0; i1 = (i1 - 1) | 0) {
                        var child1 = node.GetChild(i1);
                        if (child1 != null && child1.Width > 0) {
                            break;
                        } else {
                            bestEmptyChild = i1;
                        }
                    }

                    return bestEmptyChild;
                },
                /**
                 * determines if the node has an empty child appropriate for the position.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.KustoCompleter
                 * @memberof Kusto.Language.Editor.KustoCompleter
                 * @param   {Kusto.Language.Syntax.SyntaxElement}    element     
                 * @param   {number}                                 position
                 * @return  {boolean}
                 */
                HasEmptyChild: function (element, position) {
                    if (element == null) {
                        return false;
                    }

                    // on the right edge of a list.. counts as empty
                    if (position >= element.End && element.Kind === Kusto.Language.Syntax.SyntaxKind.List) {
                        return true;
                    }

                    // look for existence of empty slot before position
                    var hasEmptyChild = false;

                    for (var i = 0, n = element.ChildCount; i < n; i = (i + 1) | 0) {
                        var child = element.GetChild(i);
                        if (child != null) {
                            // position is before this node and we had a previous empty slot
                            if (position <= child.TextStart && hasEmptyChild) {
                                return true;
                            }

                            // inside this child (therefore no appropriate empty child for this position)
                            if (position < child.End) {
                                return false;
                            }
                        }

                        // child does not exist (optional) or has not content (missing node)
                        hasEmptyChild = (child == null || child.Width === 0);
                    }

                    // got all the way to the end w/o finding our position
                    return hasEmptyChild;
                },
                GetNearestAncestorWithEmptyChild: function (token, position) {
                    var node = token.Parent;

                    while (node != null && !Kusto.Language.Editor.KustoCompleter.HasEmptyChild(node, position)) {
                        node = node.Parent;
                    }

                    return node;
                },
                HasLetters: function (text) {
                    var $t;
                    $t = Bridge.getEnumerator(text);
                    try {
                        while ($t.moveNext()) {
                            var ch = $t.Current;
                            if (Kusto.Language.Parsing.TextFacts.IsLetter(ch)) {
                                return true;
                            }
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    return false;
                },
                ReturnTypeMatchesContext: function (signature, arg0Type, returnTypeHint) {
                    if ((returnTypeHint & Kusto.Language.Editor.CompletionHint.Boolean) !== 0) {
                        return Kusto.Language.Editor.KustoCompleter.IsBooleanReturnType(signature, arg0Type);
                    } else if ((returnTypeHint & Kusto.Language.Editor.CompletionHint.Scalar) !== 0 || (returnTypeHint & Kusto.Language.Editor.CompletionHint.Aggregate) !== 0) {
                        return Kusto.Language.Editor.KustoCompleter.IsNonBooleanScalarReturnType(signature, arg0Type);
                    } else if ((returnTypeHint & Kusto.Language.Editor.CompletionHint.Number) !== 0) {
                        return Kusto.Language.Editor.KustoCompleter.IsNumericReturnType(signature, arg0Type);
                    } else if ((returnTypeHint & Kusto.Language.Editor.CompletionHint.Column) !== 0) {
                        // no operators produce columns
                        return false;
                    } else {
                        // assumes signature is for scalar operator
                        return true;
                    }
                },
                IsBooleanReturnType: function (signature, arg0Type) {
                    switch (signature.ReturnKind) {
                        case Kusto.Language.Symbols.ReturnTypeKind.Common: 
                        case Kusto.Language.Symbols.ReturnTypeKind.Widest: 
                        case Kusto.Language.Symbols.ReturnTypeKind.Parameter0: 
                            {
                                var s;
                                return ((s = Bridge.as(arg0Type, Kusto.Language.Symbols.ScalarSymbol))) != null && Bridge.referenceEquals(s, Kusto.Language.Symbols.ScalarTypes.Bool);
                            }
                        case Kusto.Language.Symbols.ReturnTypeKind.Declared: 
                            return Bridge.referenceEquals(signature.DeclaredReturnType, Kusto.Language.Symbols.ScalarTypes.Bool);
                        default: 
                            return false;
                    }
                },
                IsNonBooleanScalarReturnType: function (signature, arg0Type) {
                    switch (signature.ReturnKind) {
                        case Kusto.Language.Symbols.ReturnTypeKind.Common: 
                        case Kusto.Language.Symbols.ReturnTypeKind.Widest: 
                        case Kusto.Language.Symbols.ReturnTypeKind.Parameter0: 
                            {
                                var s;
                                return ((s = Bridge.as(arg0Type, Kusto.Language.Symbols.ScalarSymbol))) != null && !Bridge.referenceEquals(s, Kusto.Language.Symbols.ScalarTypes.Bool);
                            }
                        case Kusto.Language.Symbols.ReturnTypeKind.Declared: 
                            return signature.DeclaredReturnType.IsScalar && !Bridge.referenceEquals(signature.DeclaredReturnType, Kusto.Language.Symbols.ScalarTypes.Bool);
                        default: 
                            return false;
                    }
                },
                IsNumericReturnType: function (signature, arg0Type) {
                    switch (signature.ReturnKind) {
                        case Kusto.Language.Symbols.ReturnTypeKind.Common: 
                        case Kusto.Language.Symbols.ReturnTypeKind.Widest: 
                        case Kusto.Language.Symbols.ReturnTypeKind.Parameter0: 
                            {
                                var s;
                                return ((s = Bridge.as(arg0Type, Kusto.Language.Symbols.ScalarSymbol))) != null && s.IsNumeric;
                            }
                        case Kusto.Language.Symbols.ReturnTypeKind.Declared: 
                            {
                                var s2;
                                return ((s2 = Bridge.as(signature.DeclaredReturnType, Kusto.Language.Symbols.ScalarSymbol))) != null && s2.IsNumeric;
                            }
                        default: 
                            return false;
                    }
                },
                ParameterMatches: function (parameter, type) {
                    switch (parameter.TypeKind) {
                        case Kusto.Language.Symbols.ParameterTypeKind.Declared: 
                            if (Kusto.Language.Binding.Binder.SymbolsAssignable$1(parameter.DeclaredTypes, type)) {
                                return true;
                            } else if (Kusto.Language.Binding.Binder.IsPromotable(type, System.Array.getItem(parameter.DeclaredTypes, 0, Kusto.Language.Symbols.TypeSymbol))) {
                                return true;
                            }
                            break;
                        case Kusto.Language.Symbols.ParameterTypeKind.Scalar: 
                            return type.IsScalar;
                        case Kusto.Language.Symbols.ParameterTypeKind.Integer: 
                            {
                                var s;
                                return ((s = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s.IsInteger;
                            }
                        case Kusto.Language.Symbols.ParameterTypeKind.RealOrDecimal: 
                            return Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Real) || Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Decimal);
                        case Kusto.Language.Symbols.ParameterTypeKind.StringOrDynamic: 
                            return Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.String) || Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Dynamic);
                        case Kusto.Language.Symbols.ParameterTypeKind.Number: 
                            {
                                var s2;
                                return ((s2 = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s2.IsNumeric;
                            }
                        case Kusto.Language.Symbols.ParameterTypeKind.NumberOrBool: 
                            {
                                var s2b;
                                return ((s2b = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && (s2b.IsNumeric || Bridge.referenceEquals(s2b, Kusto.Language.Symbols.ScalarTypes.Bool));
                            }
                        case Kusto.Language.Symbols.ParameterTypeKind.Summable: 
                            {
                                var s3;
                                return ((s3 = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s3.IsSummable;
                            }
                        case Kusto.Language.Symbols.ParameterTypeKind.Orderable: 
                            {
                                var s4;
                                return ((s4 = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s4.IsOrderable;
                            }
                        case Kusto.Language.Symbols.ParameterTypeKind.Tabular: 
                            return type.IsTabular;
                        case Kusto.Language.Symbols.ParameterTypeKind.Database: 
                            return Bridge.is(type, Kusto.Language.Symbols.DatabaseSymbol);
                        case Kusto.Language.Symbols.ParameterTypeKind.Cluster: 
                            return Bridge.is(type, Kusto.Language.Symbols.ClusterSymbol);
                        case Kusto.Language.Symbols.ParameterTypeKind.NotBool: 
                            return Bridge.is(type, Kusto.Language.Symbols.ScalarSymbol) && !Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Bool);
                        case Kusto.Language.Symbols.ParameterTypeKind.NotRealOrBool: 
                            return Bridge.is(type, Kusto.Language.Symbols.ScalarSymbol) && !Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Real) && !Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Bool);
                        case Kusto.Language.Symbols.ParameterTypeKind.NotDynamic: 
                            return Bridge.is(type, Kusto.Language.Symbols.ScalarSymbol) && !Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Dynamic);
                        case Kusto.Language.Symbols.ParameterTypeKind.IntegerOrDynamic: 
                            {
                                var s5;
                                return (((s5 = Bridge.as(type, Kusto.Language.Symbols.ScalarSymbol))) != null && s5.IsInteger) || Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Dynamic);
                            }
                        case Kusto.Language.Symbols.ParameterTypeKind.Parameter0: 
                        case Kusto.Language.Symbols.ParameterTypeKind.Parameter1: 
                        case Kusto.Language.Symbols.ParameterTypeKind.Parameter2: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonScalar: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonNumber: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonSummable: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonOrderable: 
                        case Kusto.Language.Symbols.ParameterTypeKind.CommonScalarOrDynamic: 
                            return Bridge.is(type, Kusto.Language.Symbols.ScalarSymbol);
                    }

                    return false;
                },
                GetOperatorKind: function (opText) {
                    var kind = { v : new Kusto.Language.Syntax.SyntaxKind() };
                    return Kusto.Language.Syntax.SyntaxFacts.TryGetKind(opText, kind) ? Kusto.Language.Syntax.SyntaxFacts.GetOperatorKind(kind.v) : Kusto.Language.Symbols.OperatorKind.None;
                }
            }
        },
        fields: {
            code: null,
            options: null,
            cancellationToken: null,
            _annotations: null,
            _annotationPosition: 0
        },
        ctors: {
            init: function () {
                this.cancellationToken = new Kusto.Language.Utils.CancellationToken();
            },
            ctor: function (code, options, cancellationToken) {
                this.$initialize();
                this.code = code;
                this.options = options;
                this.cancellationToken = cancellationToken;
            }
        },
        methods: {
            GetCompletionItems: function (position) {
                var $t, $t1;
                var completionToken = this.GetTokenWithAffinity(position);
                var editStart = ($t = (completionToken != null ? completionToken.TextStart : null), $t != null ? $t : position);
                var editLength = ($t1 = (completionToken != null ? completionToken.Width : null), $t1 != null ? $t1 : 0);

                if (!this.ShouldComplete(position)) {
                    return new Kusto.Language.Editor.CompletionInfo(Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Editor.CompletionItem).Instance, editStart, editLength);
                }

                var builder = new Kusto.Language.Editor.KustoCompleter.CompletionBuilder();
                var mode = Kusto.Language.Editor.KustoCompleter.CompletionMode.Combined;

                // use editStart instead of actual cursor position to adjust for token affinity
                if (this.options.IncludeSymbols) {
                    mode = this.GetSymbolCompletions(editStart, builder);
                }

                if (mode === Kusto.Language.Editor.KustoCompleter.CompletionMode.Combined && this.options.IncludeSyntax) {
                    this.GetSyntaxCompletions(editStart, builder);
                }

                var items = builder.ToList();

                // order completions by rank, priority & display name
                var orderedItems = System.Linq.Enumerable.from(items, Kusto.Language.Editor.CompletionItem).orderBy(Bridge.fn.bind(this, function (i) {
                        return this.GetOrderingRank(i);
                    })).thenBy(function (i) {
                    return i.Priority;
                }).thenBy(function (i) {
                    return i.DisplayText.toLowerCase();
                }).ToArray(Kusto.Language.Editor.CompletionItem);

                return new Kusto.Language.Editor.CompletionInfo(orderedItems, editStart, editLength);
            },
            /**
             * Determines if a completion list should be shown automatically during typing.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {number}     position    The text position of the caret.
             * @param   {number}     key         The last key typed.
             * @return  {boolean}
             */
            ShouldAutoComplete: function (position, key) {
                if (key === 0) {
                    return false;
                }

                // don't auto complete when we know we won't produce completions
                if (!this.ShouldComplete(position)) {
                    return false;
                }

                // don't auto complete when cursor is just being moved around
                if (System.Char.isControl(key) && key !== 8) {
                    return false;
                }

                // don't auto complete just because a new line was added
                if (key === 13 || key === 10) {
                    return false;
                }

                var token = this.GetTokenLeftOfPosition(position);
                if (token != null) {
                    // insert whitespace immediately after token?
                    if (System.Char.isWhiteSpace(String.fromCharCode(key)) && position === ((token.End + 1) | 0)) {
                        // punctuation that usually has expressions following
                        switch (token.Kind) {
                            case Kusto.Language.Syntax.SyntaxKind.OpenParenToken: 
                            case Kusto.Language.Syntax.SyntaxKind.OpenBracketToken: 
                            case Kusto.Language.Syntax.SyntaxKind.OpenBraceToken: 
                            case Kusto.Language.Syntax.SyntaxKind.CommaToken: 
                            case Kusto.Language.Syntax.SyntaxKind.ColonToken: 
                            case Kusto.Language.Syntax.SyntaxKind.BarToken: 
                            case Kusto.Language.Syntax.SyntaxKind.EqualToken: 
                            case Kusto.Language.Syntax.SyntaxKind.FatArrowToken: 
                            case Kusto.Language.Syntax.SyntaxKind.CloseParenToken:  // some clauses end in ) but there is more to go
                                return true;
                        }

                        // can have syntax or expressions following
                        switch (Kusto.Language.Syntax.SyntaxFacts.GetCategory(token.Kind)) {
                            case Kusto.Language.Syntax.SyntaxCategory.Identifier: 
                            case Kusto.Language.Syntax.SyntaxCategory.Operator: 
                            case Kusto.Language.Syntax.SyntaxCategory.Keyword: 
                                return true;
                        }

                        // after a complete expression
                        var expr = this.GetCompleteExpressionLeftOfPosition(position);
                        if (expr != null) {
                            return true;
                        }
                    } else if (token.End === position) {
                        // auto complete if backspacing into ending edge of identifier
                        if (key === 8) {
                            return Kusto.Language.Syntax.SyntaxFacts.GetCategory(token.Kind) === Kusto.Language.Syntax.SyntaxCategory.Identifier;
                        }

                        // inserting punctuation that usually has immediate followers?
                        switch (token.Kind) {
                            case Kusto.Language.Syntax.SyntaxKind.OpenParenToken: 
                            case Kusto.Language.Syntax.SyntaxKind.OpenBracketToken: 
                            case Kusto.Language.Syntax.SyntaxKind.OpenBraceToken: 
                            case Kusto.Language.Syntax.SyntaxKind.DotToken: 
                            case Kusto.Language.Syntax.SyntaxKind.ColonToken: 
                            case Kusto.Language.Syntax.SyntaxKind.EqualToken: 
                                return true;
                            case Kusto.Language.Syntax.SyntaxKind.BangToken: 
                                return true;
                        }

                        // just typed leading part of one of these tokens
                        switch (Kusto.Language.Syntax.SyntaxFacts.GetCategory(token.Kind)) {
                            case Kusto.Language.Syntax.SyntaxCategory.Identifier: 
                            case Kusto.Language.Syntax.SyntaxCategory.Operator: 
                            case Kusto.Language.Syntax.SyntaxCategory.Keyword: 
                                return true;
                        }
                    }
                }

                return false;
            },
            /**
             * Determines if completion should be shown at the specified text position.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {number}     position
             * @return  {boolean}
             */
            ShouldComplete: function (position) {
                var token = this.code.Syntax.GetTokenAt(position);
                var previous = token.GetPreviousToken();
                var affinity = this.GetTokenWithAffinity(position) || token;

                var leftOrSurrounding = (position === token.TriviaStart) ? (previous || token) : token;

                // don't show completions if position is inside a literal
                if (Kusto.Language.Editor.KustoCompleter.IsInsideLiteral(leftOrSurrounding, position)) {
                    return false;
                }

                // inside trivia?
                if (position <= affinity.TextStart && affinity.Trivia.length > 0) {
                    // don't allow completions if the position is within a comment
                    return !Kusto.Language.Editor.KustoCompleter.IsInsideComment(token.Trivia, ((position - token.TriviaStart) | 0));
                }

                return true;
            },
            GetOrderingRank: function (item) {
                // allow for cancellation during ordering of completion items
                this.cancellationToken.ThrowIfCancellationRequested();

                switch (item.Kind) {
                    case Kusto.Language.Editor.CompletionKind.Example: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Literal;
                    case Kusto.Language.Editor.CompletionKind.QueryPrefix: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Keyword;
                    case Kusto.Language.Editor.CompletionKind.Keyword: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Keyword;
                    case Kusto.Language.Editor.CompletionKind.AggregateFunction: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Aggregate;
                    case Kusto.Language.Editor.CompletionKind.Column: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Column;
                    case Kusto.Language.Editor.CompletionKind.Table: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Table;
                    case Kusto.Language.Editor.CompletionKind.MaterialiedView: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.MaterializedView;
                    case Kusto.Language.Editor.CompletionKind.Variable: 
                    case Kusto.Language.Editor.CompletionKind.Parameter: 
                        if (Bridge.referenceEquals(item.DisplayText, "$left") || Bridge.referenceEquals(item.DisplayText, "$right")) {
                            return Kusto.Language.Editor.KustoCompleter.OrderingRank.Literal;
                        }
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Variable;
                    case Kusto.Language.Editor.CompletionKind.BuiltInFunction: 
                    case Kusto.Language.Editor.CompletionKind.LocalFunction: 
                    case Kusto.Language.Editor.CompletionKind.DatabaseFunction: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Function;
                    case Kusto.Language.Editor.CompletionKind.ScalarInfix: 
                        if (Kusto.Language.Parsing.TextFacts.IsLetterOrDigit(item.DisplayText.charCodeAt(0))) {
                            return Kusto.Language.Editor.KustoCompleter.OrderingRank.StringOperator;
                        }
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.MathOperator;
                    case Kusto.Language.Editor.CompletionKind.ScalarPrefix: 
                    case Kusto.Language.Editor.CompletionKind.TabularPrefix: 
                    case Kusto.Language.Editor.CompletionKind.TabularSuffix: 
                    case Kusto.Language.Editor.CompletionKind.Identifier: 
                    case Kusto.Language.Editor.CompletionKind.Cluster: 
                    case Kusto.Language.Editor.CompletionKind.Database: 
                    case Kusto.Language.Editor.CompletionKind.Punctuation: 
                    case Kusto.Language.Editor.CompletionKind.Syntax: 
                    case Kusto.Language.Editor.CompletionKind.Unknown: 
                    case Kusto.Language.Editor.CompletionKind.RenderChart: 
                    default: 
                        return Kusto.Language.Editor.KustoCompleter.OrderingRank.Other;
                }
            },
            IsInCommand: function (element, contextChildIndex) {
                if (element == null) {
                    return false;
                }
                var e;
                if (contextChildIndex > 0 && ((e = Bridge.as(element.GetChild(((contextChildIndex - 1) | 0)), Kusto.Language.Syntax.SyntaxToken))) != null && Bridge.referenceEquals(e.Text, "<|")) {
                    return false;
                }

                // actually inside a function body, even if it is part of a create command this is not part of the command proper.
                var body = element.GetFirstAncestorOrSelf(Kusto.Language.Syntax.FunctionBody);
                if (body != null) {
                    return false;
                }

                var statementList = element.GetFirstAncestorOrSelf(Kusto.Language.Syntax.SyntaxList$1(Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement)));
                var command = element.GetFirstAncestorOrSelf(Kusto.Language.Syntax.Command);

                if (command != null) {
                    if (statementList != null && command.IsAncestorOf(statementList)) {
                        // statements inside commands are part of input pipe and are not considered part of the command for completion
                        return false;
                    } else {
                        // this is truly part of a command
                        return true;
                    }
                }

                return false;
            },
            IsQueryPart: function (element, contextChildIndex) {
                if (Bridge.is(element.Root, Kusto.Language.Syntax.QueryBlock)) {
                    return true;
                }

                if (Bridge.is(element.Root, Kusto.Language.Syntax.CommandBlock)) {
                    var e; // right of <| or | is query
                    if (contextChildIndex > 0 && ((e = Bridge.as(element.GetChild(((contextChildIndex - 1) | 0)), Kusto.Language.Syntax.SyntaxToken))) != null && (Bridge.referenceEquals(e.Text, "<|") || Bridge.referenceEquals(e.Text, "|"))) {
                        return true;
                    }

                    // part of a function body
                    if (element.GetFirstAncestorOrSelf(Kusto.Language.Syntax.FunctionBody) != null) {
                        return true;
                    }
                }

                return false;
            },
            GetSymbolCompletions: function (position, builder) {
                var $t;
                var hint = Kusto.Language.Editor.CompletionHint.None;
                var contextNode = { };
                var contextChildIndex = { };

                if (this.TryGetCompletionContext(position, contextNode, contextChildIndex)) {
                    var mode = this.GetSpecialCaseCompletions(position, contextNode.v, contextChildIndex.v, builder);
                    if (mode === Kusto.Language.Editor.KustoCompleter.CompletionMode.Isolated) {
                        return mode;
                    }

                    hint = this.GetCompletionHint(contextNode.v, contextChildIndex.v);
                }

                var symbols = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.Symbol)).ctor();

                var match = this.GetSymbolMatch(position);

                if (this.options.IncludeFunctions === Kusto.Language.IncludeFunctionKind.None) {
                    match &= -9;
                }

                var isCommand = this.IsInCommand(contextNode.v, contextChildIndex.v);

                var include = this.options.IncludeFunctions;

                if (isCommand) {
                    // commands only reference database functions
                    include &= Kusto.Language.IncludeFunctionKind.DatabaseFunctions;
                }

                Kusto.Language.Binding.Binder.GetSymbolsInScope(this.code.Tree, position, this.code.Globals, match, include, symbols, this.cancellationToken);

                var isInvoke = Kusto.Language.Editor.KustoCompleter.IsInvokeFunctionContext(contextNode.v);
                var rowScope = (isInvoke) ? Kusto.Language.Binding.Binder.GetRowScope(this.code.Tree, position, this.code.Globals, this.cancellationToken) : null;

                $t = Bridge.getEnumerator(symbols);
                try {
                    while ($t.moveNext()) {
                        var symbol = $t.Current;
                        // don't show completion for hidden symbols
                        if (symbol.IsHidden) {
                            continue;
                        }

                        // don't show invoke functions that would not match the row schema
                        if (isInvoke && rowScope != null && !rowScope.IsOpen) {
                            var fs;
                            if (((fs = Bridge.as(symbol, Kusto.Language.Symbols.FunctionSymbol))) != null && !this.IsInvokeApplicable(fs, rowScope)) {
                                continue;
                            }
                            var vs;
                            var vfs;
                            if (((vs = Bridge.as(symbol, Kusto.Language.Symbols.VariableSymbol))) != null && ((vfs = Bridge.as(vs.Type, Kusto.Language.Symbols.FunctionSymbol))) != null && !this.IsInvokeApplicable(vfs, rowScope)) {
                                continue;
                            }
                        }

                        var item = this.GetSymbolCompletionItem(symbol, contextNode.v, isCommand);

                        if (this.ShouldAugmentSymbolCompletionItem(symbol, hint)) {
                            item = this.GetAugmentedCompletionItem(item);
                        }

                        builder.Add(item);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return Kusto.Language.Editor.KustoCompleter.CompletionMode.Combined;
            },
            IsInvokeApplicable: function ($function, implicitFirstArgumentType) {
                var $t, $t1;
                if (Bridge.referenceEquals($function, Kusto.Language.Functions.Cluster) || Bridge.referenceEquals($function, Kusto.Language.Functions.Database)) {
                    return true;
                }

                $t = Bridge.getEnumerator($function.Signatures, Kusto.Language.Symbols.Signature);
                try {
                    while ($t.moveNext()) {
                        var sig = $t.Current;
                        if (System.Array.getCount(sig.Parameters, Kusto.Language.Symbols.Parameter) === 0) {
                            continue;
                        }

                        var p = System.Array.getItem(sig.Parameters, 0, Kusto.Language.Symbols.Parameter);
                        switch (p.TypeKind) {
                            case Kusto.Language.Symbols.ParameterTypeKind.Declared: 
                                $t1 = Bridge.getEnumerator(p.DeclaredTypes, Kusto.Language.Symbols.TypeSymbol);
                                try {
                                    while ($t1.moveNext()) {
                                        var t = $t1.Current;
                                        var ts;
                                        if (((ts = Bridge.as(t, Kusto.Language.Symbols.TableSymbol))) != null && Kusto.Language.Binding.Binder.SymbolsAssignable(t, implicitFirstArgumentType)) {
                                            return true;
                                        }
                                    }
                                } finally {
                                    if (Bridge.is($t1, System.IDisposable)) {
                                        $t1.System$IDisposable$Dispose();
                                    }
                                }
                                break;
                            case Kusto.Language.Symbols.ParameterTypeKind.Tabular: 
                                return Bridge.is(implicitFirstArgumentType, Kusto.Language.Symbols.TableSymbol);
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return false;
            },
            ShouldAugmentSymbolCompletionItem: function (symbol, hint) {
                // only append space if the symbol is in a boolean context and is not itself boolean
                return (hint & Kusto.Language.Editor.CompletionHint.Boolean) !== 0 && !Bridge.referenceEquals(Kusto.Language.Symbols.Symbol.GetExpressionResultType(symbol), Kusto.Language.Symbols.ScalarTypes.Bool);
            },
            GetSymbolCompletionItem: function (symbol, contextNode, nameOnly) {
                var kind = this.GetCompletionKind(symbol);
                var editName = Kusto.Language.KustoFacts.BracketNameIfNecessary(symbol.Name);
                do {
                    if (Bridge.is(symbol, Kusto.Language.Symbols.TableSymbol)) {
                        var t = Bridge.cast(symbol, Kusto.Language.Symbols.TableSymbol);
                        var addExternalTableFuncText = !nameOnly && t.IsExternal;
                        // editName gets bracketted: ['name with blanks']
                        // when the name has characters that cannot be represented in a variable name.
                        // This problem doesn't exist in external tables case as their name is put into a string anyway.
                        var insertionText = addExternalTableFuncText ? System.String.format("external_table('{0}')", [t.Name]) : editName;
                        var displayText = addExternalTableFuncText ? System.String.format("external_table('{0}')", [t.Name]) : t.Name;
                        // Lower ordering priority for external tables so that
                        // “regular” tables are displayed first and then the external ones.
                        var priority = t.IsExternal ? Kusto.Language.Editor.CompletionPriority.Low : Kusto.Language.Editor.CompletionPriority.Normal;
                        // Enables the user to be able to just type the name of the external table
                        // and not the entire expression (including the external_table('...') part)
                        var matchText = t.Name;
                        if (Kusto.Language.Editor.KustoCompleter.IsStartOfQuery(contextNode)) {
                            return new Kusto.Language.Editor.CompletionItem(kind, displayText, (insertionText || "") + (Kusto.Language.Editor.KustoCompleter.AfterQueryStart || ""), void 0, matchText, priority);
                        } else {
                            return new Kusto.Language.Editor.CompletionItem(kind, displayText, insertionText, void 0, matchText, priority);
                        }
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.FunctionSymbol)) {
                        var f = Bridge.cast(symbol, Kusto.Language.Symbols.FunctionSymbol);
                        if (nameOnly) {
                            return new Kusto.Language.Editor.CompletionItem(kind, f.Name, editName);
                        }

                        var builtIn = this.code.Globals.IsBuiltInFunction(f);
                        if (builtIn) {
                            // built-in functions don't need to be escaped even if they are keywords
                            editName = f.Name;
                        }

                        var fdisplay = f.Display;
                        if (System.Linq.Enumerable.from(f.Signatures, Kusto.Language.Symbols.Signature).max(function (s) {
                                return System.Array.getCount(s.Parameters, Kusto.Language.Symbols.Parameter);
                            }) === 0) {
                            if (builtIn) {
                                editName = (editName || "") + "()";
                            }

                            if (Kusto.Language.Editor.KustoCompleter.IsStartOfQuery(contextNode)) {
                                return new Kusto.Language.Editor.CompletionItem(kind, fdisplay, (editName || "") + (Kusto.Language.Editor.KustoCompleter.AfterQueryStart || ""), void 0, f.Name, 2);
                            } else {
                                return new Kusto.Language.Editor.CompletionItem(kind, fdisplay, editName, void 0, f.Name, 2);
                            }
                        } else {
                            var isInvoke = Kusto.Language.Editor.KustoCompleter.IsInvokeFunctionContext(contextNode);
                            if (this.options.EnableParameterInjection && f.MaxArgumentCount === 1 && !builtIn && !isInvoke) {
                                return new Kusto.Language.Editor.CompletionItem(kind, fdisplay, (editName || "") + "({parameter})", void 0, f.Name, 2);
                            } else {
                                return new Kusto.Language.Editor.CompletionItem(kind, fdisplay, (editName || "") + "(", ")", f.Name, 2);
                            }
                        }
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.PatternSymbol)) {
                        var p = Bridge.cast(symbol, Kusto.Language.Symbols.PatternSymbol);
                        return new Kusto.Language.Editor.CompletionItem(kind, p.Display, (editName || "") + "(", ")", p.Name, 2);
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.VariableSymbol)) {
                        var v = Bridge.cast(symbol, Kusto.Language.Symbols.VariableSymbol);
                        if (Bridge.is(v.Type, Kusto.Language.Symbols.FunctionSymbol)) {
                            return this.GetSymbolCompletionItem(v.Type, contextNode, nameOnly);
                        } else if (Bridge.is(v.Type, Kusto.Language.Symbols.TableSymbol) && Kusto.Language.Editor.KustoCompleter.IsStartOfQuery(contextNode)) {
                            return new Kusto.Language.Editor.CompletionItem(kind, v.Name, (editName || "") + (Kusto.Language.Editor.KustoCompleter.AfterQueryStart || ""));
                        } else {
                            return new Kusto.Language.Editor.CompletionItem(kind, v.Name, editName);
                        }
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.ParameterSymbol)) {
                        var p1 = Bridge.cast(symbol, Kusto.Language.Symbols.ParameterSymbol);
                        if (Bridge.is(p1.Type, Kusto.Language.Symbols.FunctionSymbol)) {
                            return this.GetSymbolCompletionItem(p1.Type, contextNode, nameOnly);
                        } else {
                            return new Kusto.Language.Editor.CompletionItem(kind, symbol.Name, editName);
                        }
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.DatabaseSymbol)) {
                        var d = Bridge.cast(symbol, Kusto.Language.Symbols.DatabaseSymbol);
                        return new Kusto.Language.Editor.CompletionItem(Kusto.Language.Editor.CompletionKind.Database, d.Name, editName);
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.ClusterSymbol)) {
                        var cl = Bridge.cast(symbol, Kusto.Language.Symbols.ClusterSymbol);
                        return new Kusto.Language.Editor.CompletionItem(Kusto.Language.Editor.CompletionKind.Cluster, cl.Name, Kusto.Language.KustoFacts.GetBracketedName(cl.Name));
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.OptionSymbol)) {
                        var opt = Bridge.cast(symbol, Kusto.Language.Symbols.OptionSymbol);
                        return new Kusto.Language.Editor.CompletionItem(Kusto.Language.Editor.CompletionKind.Option, opt.Name, editName);
                    }

                    {
                        return new Kusto.Language.Editor.CompletionItem(kind, symbol.Name, editName);
                    }
                } while (false);
            },
            /**
             * Get the token that the position has affinity with,
             or null if the position does not have affinity (in whitespace between tokens).
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {number}                               position
             * @return  {Kusto.Language.Syntax.SyntaxToken}
             */
            GetTokenWithAffinity: function (position) {
                var token = this.code.Syntax.GetTokenAt(position);
                var previous = token.GetPreviousToken();

                if (Kusto.Language.Editor.KustoCompleter.HasAffinity(token, position)) {
                    return token;
                } else if (previous != null && Kusto.Language.Editor.KustoCompleter.HasAffinity(previous, position)) {
                    return previous;
                } else {
                    // fully inside trivia between tokens, no affinity
                    return null;
                }
            },
            GetSymbolMatch: function (position) {
                var match = Kusto.Language.Symbols.SymbolMatch.None;
                var contextNode = { };
                var index = { };

                if (this.TryGetCompletionContext(position, contextNode, index)) {
                    var hint = this.GetCompletionHint(contextNode.v, index.v);
                    match |= Kusto.Language.Editor.KustoCompleter.GetSymbolMatch(hint);
                }

                // special case for parenthesis; get hint from outside
                while (Bridge.is(contextNode.v, Kusto.Language.Syntax.ParenthesizedExpression) && contextNode.v.Parent != null) {
                    var hint1 = this.GetCompletionHint(contextNode.v.Parent, contextNode.v.IndexInParent);
                    match |= Kusto.Language.Editor.KustoCompleter.GetSymbolMatch(hint1);
                    position = contextNode.v.TextStart;
                    contextNode.v = contextNode.v.Parent;
                }

                var grammarMatch = this.GetSymbolMatchFromGrammar(position);
                match |= grammarMatch;

                return match;
            },
            GetSymbolMatchFromGrammar: function (position) {
                var $t;
                var match = Kusto.Language.Symbols.SymbolMatch.None;

                var annotations = this.GetGrammarAnnotations(position);

                $t = Bridge.getEnumerator(System.Linq.Enumerable.from(annotations).ofType(Kusto.Language.Editor.CompletionHint));
                try {
                    while ($t.moveNext()) {
                        var hint = $t.Current;
                        match |= Kusto.Language.Editor.KustoCompleter.GetSymbolMatch(hint);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return match;
            },
            TryGetFunctionOrOperatorArgument: function (contextNode, childIndex, signatures, $arguments, argumentIndex, argumentCount, parameterName) {
                var $t, $t1, $t2, $t3, $t4, $t5;
                parameterName.v = null;

                var n = contextNode;

                if (Bridge.is(n, Kusto.Language.Syntax.NamedExpression)) {
                    var sn;
                    if (((sn = Bridge.as(n, Kusto.Language.Syntax.SimpleNamedExpression))) != null) {
                        parameterName.v = sn.Name.SimpleName;
                    }

                    childIndex = ($t = (($t1 = n.Parent) != null ? $t1.GetChildIndex(n) : null), $t != null ? $t : 0);
                    n = n.Parent;
                }

                // if this is a primitive expression that is a list element, move context up
                while (Kusto.Language.Editor.KustoCompleter.ContainsOnlyOneToken(n) && !(Bridge.is(n.Parent, Kusto.Language.Syntax.SyntaxList))) {
                    childIndex = ($t2 = (($t3 = n.Parent) != null ? $t3.GetChildIndex(n) : null), $t2 != null ? $t2 : 0);
                    n = n.Parent;
                }

                // if this is a list element (not separator), move context up to list
                if (Bridge.is(n, Kusto.Language.Syntax.SeparatedElement) && childIndex === 0) {
                    childIndex = ($t4 = (($t5 = n.Parent) != null ? $t5.GetChildIndex(n) : null), $t4 != null ? $t4 : 0);
                    n = n.Parent;
                }

                var functionCall = null;
                var el;
                var fc1;
                var fs;
                if (Bridge.is(n, Kusto.Language.Syntax.SyntaxList) && ((el = Bridge.as(n.Parent, Kusto.Language.Syntax.ExpressionList))) != null && ((fc1 = Bridge.as(el.Parent, Kusto.Language.Syntax.FunctionCallExpression))) != null && ((fs = Bridge.as(fc1.ReferencedSymbol, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                    signatures.v = fs.Signatures;
                    functionCall = fc1;
                    $arguments.v = System.Linq.Enumerable.from(fc1.ArgumentList.Expressions, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Expression)).select(function (e) {
                            return e.Element$1;
                        }).toList(Kusto.Language.Syntax.Expression);
                    argumentIndex.v = childIndex;
                    argumentCount.v = n.ChildCount;
                } else {
                    var fc2;
                    var fs2;
                    if (Bridge.is(n, Kusto.Language.Syntax.ExpressionList) && ((fc2 = Bridge.as(n.Parent, Kusto.Language.Syntax.FunctionCallExpression))) != null && ((fs2 = Bridge.as(fc2.ReferencedSymbol, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                        // this happens for the first argument
                        signatures.v = fs2.Signatures;
                        functionCall = fc2;
                        $arguments.v = System.Linq.Enumerable.from(fc2.ArgumentList.Expressions, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Expression)).select(function (e) {
                                return e.Element$1;
                            }).toList(Kusto.Language.Syntax.Expression);
                        argumentIndex.v = 0;
                        argumentCount.v = 1;
                    } else {
                        var be;
                        var os;
                        if (((be = Bridge.as(n, Kusto.Language.Syntax.BinaryExpression))) != null && ((os = Bridge.as(be.ReferencedSymbol, Kusto.Language.Symbols.OperatorSymbol))) != null) {
                            signatures.v = os.Signatures;
                            $arguments.v = function (_o1) {
                                    _o1.add(be.Left);
                                    _o1.add(be.Right);
                                    return _o1;
                                }(new (System.Collections.Generic.List$1(Kusto.Language.Syntax.Expression)).$ctor2(2));
                            argumentIndex.v = childIndex === 0 ? 0 : 1;
                            argumentCount.v = 2;
                            return true;
                        } else {
                            signatures.v = null;
                            $arguments.v = null;
                            argumentIndex.v = 0;
                            argumentCount.v = 0;
                            return false;
                        }
                    }
                }
                if (functionCall != null && $arguments.v != null && Kusto.Language.Editor.KustoCompleter.IsInvokeFunctionContext(functionCall.Parent)) {
                    // add implicit argument
                    $arguments.v.insert(0, null);
                    argumentIndex.v = (argumentIndex.v + 1) | 0;
                    argumentCount.v = (argumentCount.v + 1) | 0;
                }

                if (signatures.v != null && !System.Linq.Enumerable.from(signatures.v, Kusto.Language.Symbols.Signature).any(function (s) {
                        return s.AllowsNamedArguments;
                    })) {
                    parameterName.v = null;
                }

                return true;
            },
            GetSpecialCaseCompletions: function (position, contextNode, childIndex, builder) {
                var mode = this.GetFunctionArgumentCompletions(position, contextNode, childIndex, builder);
                if (mode === Kusto.Language.Editor.KustoCompleter.CompletionMode.Isolated) {
                    return mode;
                }

                mode = this.GetSetOptionCompletions(position, contextNode, childIndex, builder);

                return mode;
            },
            GetSetOptionCompletions: function (position, contextNode, childIndex, builder) {
                var $t;
                var clause;
                var statement;
                var option;
                if (((clause = Bridge.as(contextNode, Kusto.Language.Syntax.OptionValueClause))) != null && childIndex === 1 && ((statement = Bridge.as(clause.Parent, Kusto.Language.Syntax.SetOptionStatement))) != null && ((option = Bridge.as(statement.Name.ReferencedSymbol, Kusto.Language.Symbols.OptionSymbol))) != null && option.Examples != null) {
                    $t = Bridge.getEnumerator(option.Examples, System.String);
                    try {
                        while ($t.moveNext()) {
                            var example = $t.Current;
                            var value = Kusto.Language.KustoFacts.GetStringLiteralValue(example);
                            builder.Add(new Kusto.Language.Editor.CompletionItem(Kusto.Language.Editor.CompletionKind.Example, example, example, void 0, value, 2));
                        }
                    } finally {
                        if (Bridge.is($t, System.IDisposable)) {
                            $t.System$IDisposable$Dispose();
                        }
                    }

                    return Kusto.Language.Editor.KustoCompleter.CompletionMode.Isolated;
                }

                return Kusto.Language.Editor.KustoCompleter.CompletionMode.Combined;
            },
            GetFunctionArgumentCompletions: function (position, contextNode, childIndex, builder) {
                var $t, $t1, $t2;
                var signatures = { };
                var $arguments = { };
                var argumentIndex = { };
                var argumentCount = { };
                var name = { };
                if (this.TryGetFunctionOrOperatorArgument(contextNode, childIndex, signatures, $arguments, argumentIndex, argumentCount, name)) {
                    var fs; // argument names
                    if (!(Bridge.is(contextNode, Kusto.Language.Syntax.NamedExpression)) && ((fs = Bridge.as(System.Array.getItem(signatures.v, 0, Kusto.Language.Symbols.Signature).Symbol, Kusto.Language.Symbols.FunctionSymbol))) != null && this.ShowParameterNames(fs)) {
                        var suggestions = this.GetArgumentNameSuggestions(signatures.v, $arguments.v, argumentIndex.v);

                        $t = Bridge.getEnumerator(suggestions);
                        try {
                            while ($t.moveNext()) {
                                var s = $t.Current;
                                builder.Add(new Kusto.Language.Editor.CompletionItem(Kusto.Language.Editor.CompletionKind.Parameter, (s || "") + "=", (s || "") + "=", void 0, s, 2));
                            }
                        } finally {
                            if (Bridge.is($t, System.IDisposable)) {
                                $t.System$IDisposable$Dispose();
                            }
                        }

                        if (suggestions.Count > 0 && this.IsArgumentNameRequired$1(signatures.v, $arguments.v, argumentIndex.v)) {
                            return Kusto.Language.Editor.KustoCompleter.CompletionMode.Isolated;
                        }
                    }

                    var examples = new (System.Collections.Generic.HashSet$1(System.String)).ctor();
                    var possibleParameters = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.Parameter)).ctor();
                    var knownParameter = false;

                    $t1 = Bridge.getEnumerator(signatures.v, Kusto.Language.Symbols.Signature);
                    try {
                        while ($t1.moveNext()) {
                            var sig = $t1.Current;
                            // check for examples based off of ReturnTypeKind.Parameter0XXX
                            if (argumentIndex.v === 0 && this.TryGetReturnTypeKindCompletions(sig.ReturnKind, position, contextNode, builder)) {
                                return Kusto.Language.Editor.KustoCompleter.CompletionMode.Isolated;
                            }

                            // check for examples based on parameters
                            possibleParameters.clear();
                            Kusto.Language.Editor.KustoCompleter.GetPossibleParameters(sig, $arguments.v, name.v, argumentIndex.v, possibleParameters);
                            knownParameter = !!(knownParameter | possibleParameters.Count > 0);
                            Kusto.Language.Editor.KustoCompleter.GetParameterExamples(sig, $arguments.v, possibleParameters, examples);
                        }
                    } finally {
                        if (Bridge.is($t1, System.IDisposable)) {
                            $t1.System$IDisposable$Dispose();
                        }
                    }

                    // if we got through all the signature and did not match a known parameter
                    // then return no results and 'isolated' so there will be no completions
                    if (!knownParameter) {
                        return Kusto.Language.Editor.KustoCompleter.CompletionMode.Isolated;
                    }

                    if (examples != null) {
                        $t2 = Bridge.getEnumerator(examples);
                        try {
                            while ($t2.moveNext()) {
                                var x = $t2.Current;
                                builder.Add(new Kusto.Language.Editor.CompletionItem(Kusto.Language.Editor.CompletionKind.Example, x));
                            }
                        } finally {
                            if (Bridge.is($t2, System.IDisposable)) {
                                $t2.System$IDisposable$Dispose();
                            }
                        }
                    }
                }

                return Kusto.Language.Editor.KustoCompleter.CompletionMode.Combined;
            },
            TryGetReturnTypeKindCompletions: function (kind, position, contextNode, builder) {
                switch (kind) {
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0Cluster: 
                        // show the known cluster names
                        builder.AddRange(this.GetMemberNameExamples(this.code.Globals.Clusters));
                        this.GetMatchingSymbolCompletions(Kusto.Language.Symbols.SymbolMatch.Local, Kusto.Language.Symbols.ScalarTypes.String, position, contextNode, builder);
                        return true;
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0Database: 
                        {
                            var cpl;
                            // show either the dotted cluster's database names or the global cluster's database names
                            if (((cpl = Bridge.as(Kusto.Language.Editor.KustoCompleter.GetLeftOfFunctionCall(contextNode), Kusto.Language.Syntax.Expression))) != null) {
                                var cc;
                                if (((cc = Bridge.as(cpl.ResultType, Kusto.Language.Symbols.ClusterSymbol))) != null) {
                                    builder.AddRange(this.GetMemberNameExamples(cc.Databases));
                                }
                            } else {
                                builder.AddRange(this.GetMemberNameExamples(this.code.Globals.Cluster.Databases));
                            }
                        }
                        this.GetMatchingSymbolCompletions(Kusto.Language.Symbols.SymbolMatch.Local, Kusto.Language.Symbols.ScalarTypes.String, position, contextNode, builder);
                        return true;
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0Table: 
                        {
                            var dpl;
                            // show either the dotted database's table names or the global database's table names
                            if (((dpl = Bridge.as(Kusto.Language.Editor.KustoCompleter.GetLeftOfFunctionCall(contextNode), Kusto.Language.Syntax.Expression))) != null) {
                                var ds;
                                if (((ds = Bridge.as(dpl.ResultType, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                                    builder.AddRange(this.GetMemberNameExamples(ds.Tables));
                                }
                            } else {
                                builder.AddRange(this.GetMemberNameExamples(this.code.Globals.Database.Tables));
                            }
                        }
                        this.GetMatchingSymbolCompletions(Kusto.Language.Symbols.SymbolMatch.Local, Kusto.Language.Symbols.ScalarTypes.String, position, contextNode, builder);
                        return true;
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0ExternalTable: 
                        {
                            var edpl;
                            // show either the dotted database's table names or the global database's table names
                            if (((edpl = Bridge.as(Kusto.Language.Editor.KustoCompleter.GetLeftOfFunctionCall(contextNode), Kusto.Language.Syntax.Expression))) != null) {
                                var ds1;
                                if (((ds1 = Bridge.as(edpl.ResultType, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                                    builder.AddRange(this.GetMemberNameExamples(ds1.ExternalTables));
                                }
                            } else {
                                builder.AddRange(this.GetMemberNameExamples(this.code.Globals.Database.ExternalTables));
                            }
                        }
                        this.GetMatchingSymbolCompletions(Kusto.Language.Symbols.SymbolMatch.Local, Kusto.Language.Symbols.ScalarTypes.String, position, contextNode, builder);
                        return true;
                    case Kusto.Language.Symbols.ReturnTypeKind.Parameter0MaterializedView: 
                        {
                            var mvdpl;
                            // show either the dotted database's table names or the global database's table names
                            if (((mvdpl = Bridge.as(Kusto.Language.Editor.KustoCompleter.GetLeftOfFunctionCall(contextNode), Kusto.Language.Syntax.Expression))) != null) {
                                var ds2;
                                if (((ds2 = Bridge.as(mvdpl.ResultType, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                                    builder.AddRange(this.GetMemberNameExamples(ds2.MaterializedViews));
                                }
                            } else {
                                builder.AddRange(this.GetMemberNameExamples(this.code.Globals.Database.MaterializedViews));
                            }
                        }
                        this.GetMatchingSymbolCompletions(Kusto.Language.Symbols.SymbolMatch.Local, Kusto.Language.Symbols.ScalarTypes.String, position, contextNode, builder);
                        return true;
                    default: 
                        return false;
                }
            },
            /**
             * Get's completion items for local variables in scope that are type requested type
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {Kusto.Language.Symbols.SymbolMatch}                        match          
             * @param   {Kusto.Language.Symbols.ScalarSymbol}                       type           
             * @param   {number}                                                    position       
             * @param   {Kusto.Language.Syntax.SyntaxNode}                          contextNode    
             * @param   {Kusto.Language.Editor.KustoCompleter.CompletionBuilder}    builder
             * @return  {void}
             */
            GetMatchingSymbolCompletions: function (match, type, position, contextNode, builder) {
                var $t;
                // first get all items in scope
                var symbols = new (System.Collections.Generic.List$1(Kusto.Language.Symbols.Symbol)).ctor();
                Kusto.Language.Binding.Binder.GetSymbolsInScope(this.code.Tree, position, this.code.Globals, match, Kusto.Language.IncludeFunctionKind.All, symbols, this.cancellationToken);

                // get completion items for the symbols with a matching scalar type
                $t = Bridge.getEnumerator(symbols);
                try {
                    while ($t.moveNext()) {
                        var symbol = $t.Current;
                        if (Bridge.referenceEquals(this.GetScalarType(symbol), type)) {
                            var item = this.GetSymbolCompletionItem(symbol, contextNode, false);
                            builder.Add(item);
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            },
            GetScalarType: function (symbol) {
                do {
                    if (Bridge.is(symbol, Kusto.Language.Symbols.ParameterSymbol)) {
                        var ps = Bridge.cast(symbol, Kusto.Language.Symbols.ParameterSymbol);
                        return Bridge.as(ps.Type, Kusto.Language.Symbols.ScalarSymbol);
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.VariableSymbol)) {
                        var vs = Bridge.cast(symbol, Kusto.Language.Symbols.VariableSymbol);
                        return Bridge.as(vs.Type, Kusto.Language.Symbols.ScalarSymbol);
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.ColumnSymbol)) {
                        var cs = Bridge.cast(symbol, Kusto.Language.Symbols.ColumnSymbol);
                        return Bridge.as(cs.Type, Kusto.Language.Symbols.ScalarSymbol);
                    }

                    {
                        return null;
                    }
                } while (false);
            },
            GetMemberNameExamples: function (symbols) {
                return System.Linq.Enumerable.from(symbols, Kusto.Language.Symbols.Symbol).select(function (s) {
                        return new Kusto.Language.Editor.CompletionItem(Kusto.Language.Editor.CompletionKind.Example, Kusto.Language.KustoFacts.GetStringLiteral(s.Name));
                    });
            },
            ShowParameterNames: function ($function) {
                return !this.code.Globals.IsBuiltInFunction($function) && $function.MaxArgumentCount >= 2;
            },
            IsArgumentNameRequired$1: function (signatures, $arguments, argumentIndex) {
                var $t;
                $t = Bridge.getEnumerator(signatures, Kusto.Language.Symbols.Signature);
                try {
                    while ($t.moveNext()) {
                        var sig = $t.Current;
                        if (argumentIndex < sig.MaxArgumentCount) {
                            if (this.IsArgumentNameRequired(sig, $arguments, argumentIndex)) {
                                return true;
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return false;
            },
            IsArgumentNameRequired: function (signature, $arguments, argumentIndex) {
                if (argumentIndex > 0) {
                    var unnamedArguments = Kusto.Language.Editor.KustoCompleter.s_expressionListPool.AllocateFromPool();
                    try {
                        Kusto.Language.Editor.KustoCompleter.GetUnnamedArguments($arguments, unnamedArguments);
                        var argumentParameters = signature.GetArgumentParameters($arguments);
                        var unnamedArgumentParameters = signature.GetArgumentParameters(unnamedArguments);

                        for (var i = 0; i < argumentIndex; i = (i + 1) | 0) {
                            // unordered named argument causes requirement to use named arguments
                            if (!Bridge.referenceEquals(argumentParameters.getItem(i), unnamedArgumentParameters.getItem(i))) {
                                return true;
                            }
                        }
                    } finally {
                        Kusto.Language.Editor.KustoCompleter.s_expressionListPool.ReturnToPool(unnamedArguments);
                    }
                }

                return false;
            },
            GetSpecifiedArgumentNames: function ($arguments) {
                var names = new (System.Collections.Generic.HashSet$1(System.String)).ctor();

                for (var i = 0; i < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression); i = (i + 1) | 0) {
                    var arg = System.Array.getItem($arguments, i, Kusto.Language.Syntax.Expression);
                    var name;
                    if (((name = Kusto.Language.Binding.Binder.GetExpressionDeclaredName(arg))) != null) {
                        names.add(name);
                    }
                }

                return names;
            },
            GetArgumentNameSuggestions: function (signatures, $arguments, argumentIndex) {
                var $t, $t1;
                var specifiedNames = this.GetSpecifiedArgumentNames($arguments);
                var unspecifiedNames = new (System.Collections.Generic.HashSet$1(System.String)).ctor();
                var suggestedNames = new (System.Collections.Generic.HashSet$1(System.String)).ctor();

                $t = Bridge.getEnumerator(signatures, Kusto.Language.Symbols.Signature);
                try {
                    while ($t.moveNext()) {
                        var sig = { v : $t.Current };
                        // only consider signatures that could match
                        if (System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) <= sig.v.MaxArgumentCount && System.Linq.Enumerable.from(specifiedNames, System.String).all((function ($me, sig) {
                                return function (n) {
                                    return System.Linq.Enumerable.from(sig.v.Parameters, Kusto.Language.Symbols.Parameter).any(function (p) {
                                            return Bridge.referenceEquals(p.Name, n);
                                        });
                                };
                            })(this, sig))) {
                            unspecifiedNames.clear();
                            var argumentParameters = sig.v.GetArgumentParameters($arguments);

                            // check for argument with unspecified names
                            for (var i = 0, n = System.Array.getCount($arguments, Kusto.Language.Syntax.Expression); i < n; i = (i + 1) | 0) {
                                if (i !== argumentIndex) {
                                    var arg = System.Array.getItem($arguments, i, Kusto.Language.Syntax.Expression);
                                    var p = argumentParameters.getItem(i);
                                    unspecifiedNames.add(p.Name);
                                }
                            }

                            $t1 = Bridge.getEnumerator(sig.v.Parameters, Kusto.Language.Symbols.Parameter);
                            try {
                                while ($t1.moveNext()) {
                                    var p1 = $t1.Current;
                                    if (!specifiedNames.contains(p1.Name) && !unspecifiedNames.contains(p1.Name)) {
                                        suggestedNames.add(p1.Name);
                                    }
                                }
                            } finally {
                                if (Bridge.is($t1, System.IDisposable)) {
                                    $t1.System$IDisposable$Dispose();
                                }
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return suggestedNames;
            },
            /**
             * Gets the {@link } at the specified text position.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {number}                                  position
             * @return  {Kusto.Language.Editor.CompletionHint}
             */
            GetCompletionHint$1: function (position) {
                var contextNode = { };
                var index = { };
                if (this.TryGetCompletionContext(position, contextNode, index)) {
                    return this.GetCompletionHint(contextNode.v, index.v, Kusto.Language.Editor.CompletionHint.Query);
                } else {
                    // no context node?
                    return Kusto.Language.Editor.CompletionHint.None;
                }
            },
            /**
             * Gets the {@link } for the specified child slot of the context node
             and any following slots that can offer additional hints.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {Kusto.Language.Syntax.SyntaxNode}        contextNode    
             * @param   {number}                                  childIndex     
             * @param   {Kusto.Language.Editor.CompletionHint}    defaultHint
             * @return  {Kusto.Language.Editor.CompletionHint}
             */
            GetCompletionHint: function (contextNode, childIndex, defaultHint) {
                if (defaultHint === void 0) { defaultHint = 0; }
                var hint = this.GetChildHint(contextNode, childIndex, defaultHint);

                if (Bridge.is(contextNode, Kusto.Language.Syntax.SeparatedElement) && childIndex === 1) {
                    // list element separators are encoded as optional in the tree,
                    // but are not really optional in the grammar, so don't add follow on hints.
                    return hint;
                }

                // if this child is actually required but missing then stop getting more hints
                if (Kusto.Language.Editor.KustoCompleter.IsChildMissing(contextNode, childIndex)) {
                    return hint;
                }

                // if this child was optional and empty then also get hints from following child slots
                // if contextNode is list, then it can have followers too
                if (Kusto.Language.Editor.KustoCompleter.IsChildEmpty(contextNode, childIndex) || Kusto.Language.Editor.KustoCompleter.IsChildOnNewLine(contextNode, childIndex) || Bridge.is(contextNode, Kusto.Language.Syntax.SyntaxList)) {
                    while (contextNode != null) {
                        // get hints for all following missing or empty children
                        for (var i = (childIndex + 1) | 0, n = contextNode.ChildCount; i < n; i = (i + 1) | 0) {
                            // if next child is not missing or empty then we've already got all the hints
                            if (!Kusto.Language.Editor.KustoCompleter.IsChildMissingOrEmpty(contextNode, i) && !Kusto.Language.Editor.KustoCompleter.IsChildOnNewLine(contextNode, i)) {
                                return hint;
                            }

                            hint |= this.GetChildHint(contextNode, i, defaultHint);

                            // if this child is actually required but missing then stop getting more hints
                            if (Kusto.Language.Editor.KustoCompleter.IsChildMissing(contextNode, i)) {
                                return hint;
                            }
                        }

                        // also get hints for contextNode's missing or empty following siblings in parent
                        var parent = contextNode.Parent;
                        var indexInParent = parent != null ? parent.GetChildIndex(contextNode) : 0;
                        contextNode = parent;
                        childIndex = indexInParent;
                    }
                }

                return hint;
            },
            /**
             * Gets the {@link } for the specified child slot of the context node.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {Kusto.Language.Syntax.SyntaxNode}        contextNode    
             * @param   {number}                                  childIndex     
             * @param   {Kusto.Language.Editor.CompletionHint}    default
             * @return  {Kusto.Language.Editor.CompletionHint}
             */
            GetChildHint: function (contextNode, childIndex, $default) {
                if ($default === void 0) { $default = 0; }
                var signatures = { };
                var $arguments = { };
                var argumentIndex = { };
                var argumentCount = { };
                var parameterName = { };
                // if the context/child is an argument to a function or operator then determine the hint based on the defined parameter
                if (this.TryGetFunctionOrOperatorArgument(contextNode, childIndex, signatures, $arguments, argumentIndex, argumentCount, parameterName)) {
                    return this.GetParameterHint(signatures.v, $arguments.v, parameterName.v, argumentIndex.v);
                }

                while (true) {
                    var hint = contextNode.GetCompletionHint(childIndex);
                    if (hint !== Kusto.Language.Editor.CompletionHint.Inherit) {
                        return hint;
                    }
                    var parent;
                    if (((parent = contextNode.Parent)) != null) {
                        childIndex = parent.GetChildIndex(contextNode);
                        contextNode = parent;
                    } else {
                        // walked all the way to the top of the syntax tree
                        return $default;
                    }
                }
            },
            GetParameterHint: function (signatures, $arguments, parameterName, iArgument) {
                var $t;
                var hint = Kusto.Language.Editor.CompletionHint.None;

                // if iArgument is last argument, but also missing, don't use the last argument
                if (iArgument === ((System.Array.getCount($arguments, Kusto.Language.Syntax.Expression) - 1) | 0) && System.Array.getItem($arguments, iArgument, Kusto.Language.Syntax.Expression).IsMissing) {
                    $arguments = System.Linq.Enumerable.from($arguments, Kusto.Language.Syntax.Expression).take(iArgument).toList(Kusto.Language.Syntax.Expression);
                }

                $t = Bridge.getEnumerator(signatures, Kusto.Language.Symbols.Signature);
                try {
                    while ($t.moveNext()) {
                        var signature = $t.Current;
                        if (!signature.IsHidden) {
                            if (parameterName != null) {
                                hint |= Kusto.Language.Editor.KustoCompleter.GetParameterHint(signature, signature.GetParameter(parameterName));
                            } else {
                                if (iArgument < System.Array.getCount($arguments, Kusto.Language.Syntax.Expression)) {
                                    hint |= Kusto.Language.Editor.KustoCompleter.GetArgumentParameterHints(signature, $arguments, iArgument);
                                } else {
                                    hint |= Kusto.Language.Editor.KustoCompleter.GetNextPossibleParameterHints(signature, $arguments);
                                }
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return hint;
            },
            /**
             * Find the most suitable node and child slot that contains the text position.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {number}                              position             
             * @param   {Kusto.Language.Syntax.SyntaxNode}    contextNode          
             * @param   {System.Int32}                        contextChildIndex
             * @return  {boolean}
             */
            TryGetCompletionContext: function (position, contextNode, contextChildIndex) {
                contextNode.v = null;
                contextChildIndex.v = 0;

                var token = this.code.Syntax.GetTokenAt(position);

                if (token == null) {
                    return false;
                }

                var hasAffinity = Kusto.Language.Editor.KustoCompleter.HasAffinity(token, position);
                if (hasAffinity) {
                    // don't have symbol completions for tokens following a missing token
                    var prev = token.GetPreviousToken(true);
                    if (prev != null && prev.IsMissing) {
                        return false;
                    }

                    contextNode.v = token.Parent;
                    contextChildIndex.v = Kusto.Language.Editor.KustoCompleter.GetChildIndex(contextNode.v, position);
                    return true;
                }

                var tokenNode = Kusto.Language.Editor.KustoCompleter.GetNearestAncestorWithEmptyChild(token, position);

                if (position <= token.TextStart && !hasAffinity || token.Kind === Kusto.Language.Syntax.SyntaxKind.EndOfTextToken) {
                    var prevToken = token.GetPreviousToken();
                    if (prevToken != null) {
                        var prevNode = Kusto.Language.Editor.KustoCompleter.GetNearestAncestorWithEmptyChild(prevToken, position);
                        if (prevNode != null) {
                            if (tokenNode == null || prevNode.Depth >= tokenNode.Depth) {
                                contextNode.v = prevNode;
                                contextChildIndex.v = Kusto.Language.Editor.KustoCompleter.GetChildIndex(contextNode.v, position);
                                return true;
                            }
                        }
                    }
                } else if (position >= token.End && !hasAffinity) {
                    var nextToken = token.GetNextToken();
                    if (nextToken != null) {
                        var nextNode = Kusto.Language.Editor.KustoCompleter.GetNearestAncestorWithEmptyChild(nextToken, position);
                        if (nextNode != null) {
                            if (tokenNode == null || nextNode.Depth > tokenNode.Depth) {
                                contextNode.v = nextNode;
                                contextChildIndex.v = Kusto.Language.Editor.KustoCompleter.GetChildIndex(contextNode.v, position);
                                return true;
                            }
                        }
                    }
                }

                if (tokenNode != null) {
                    contextNode.v = tokenNode;
                    contextChildIndex.v = Kusto.Language.Editor.KustoCompleter.GetChildIndex(contextNode.v, position);
                    return true;
                }

                if (position > token.TriviaStart && position < token.TextStart && !hasAffinity) {
                    // if we got here then there was no ancestor with empty child, so no syntax hole to fill
                    // yet we are also inside trivia and only whitespace until end of line, meaning the next syntax part
                    // is on a separate line, so allow completions to produce the same list as for syntax slot that contains
                    // the next part
                    var nextLBStart = Kusto.Language.Parsing.TextFacts.GetNextLineBreakStart(token.Trivia, ((position - token.TriviaStart) | 0));
                    if (nextLBStart >= 0 && Kusto.Language.Parsing.TextFacts.IsWhitespaceOnly$1(token.Trivia, 0, nextLBStart)) {
                        var prevToken1 = token.GetPreviousToken();
                        if (prevToken1 != null) {
                            contextNode.v = Kusto.Language.Syntax.SyntaxElement.GetCommonAncestor(prevToken1, token);
                            if (contextNode.v != null) {
                                contextChildIndex.v = contextNode.v.GetDescendantIndex(token);
                                return contextChildIndex.v >= 0;
                            }
                        }
                    }
                }

                return false;
            },
            GetSyntaxCompletions: function (position, builder) {
                var $t, $t1;
                var hints = this.GetCompletionHint$1(position);
                var match = this.GetSymbolMatch(position);
                var expr = this.GetCompleteExpressionLeftOfPosition(position);

                var annotations = this.GetGrammarAnnotations(position);

                // add in any completion hints associated with this parser
                $t = Bridge.getEnumerator(System.Linq.Enumerable.from(annotations).ofType(Kusto.Language.Editor.CompletionHint));
                try {
                    while ($t.moveNext()) {
                        var hint = $t.Current;
                        hints |= hint;
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                // consider all completion items associated with this parser
                $t1 = Bridge.getEnumerator(System.Linq.Enumerable.from(annotations).ofType(Kusto.Language.Editor.CompletionItem));
                try {
                    while ($t1.moveNext()) {
                        var item = $t1.Current;
                        if (this.IncludeSyntax(item, position, hints, match, expr)) {
                            if (this.ShouldAugmentSyntaxCompletionItem(item)) {
                                var augmentedItem = this.GetAugmentedCompletionItem(item);
                                builder.Add(augmentedItem);
                            } else {
                                builder.Add(item);
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t1, System.IDisposable)) {
                        $t1.System$IDisposable$Dispose();
                    }
                }
            },
            GetAugmentedCompletionItem: function (item) {
                return item.WithEditText((item.EditText || "") + " ");
            },
            ShouldAugmentSyntaxCompletionItem: function (item) {
                var $t;
                if (!this.options.AutoAppendWhitespace) {
                    return false;
                }

                if (System.Nullable.gt((($t = item.AfterText) != null ? $t.length : null), 0)) {
                    return false;
                }

                // was this an auto appended '='?
                // make appended additional space depend on whether it is currently separated by a space.
                if (System.String.endsWith(item.EditText, "=") && Kusto.Language.Parsing.TextFacts.IsLetterOrDigit(item.EditText.charCodeAt(0)) && item.EditText.length > 1 && !Kusto.Language.Parsing.TextFacts.IsWhitespace(item.EditText.charCodeAt(((item.EditText.length - 2) | 0)))) {
                    return false;
                }

                switch (item.Kind) {
                    case Kusto.Language.Editor.CompletionKind.Column: 
                    case Kusto.Language.Editor.CompletionKind.BuiltInFunction: 
                    case Kusto.Language.Editor.CompletionKind.LocalFunction: 
                    case Kusto.Language.Editor.CompletionKind.DatabaseFunction: 
                    case Kusto.Language.Editor.CompletionKind.AggregateFunction: 
                    case Kusto.Language.Editor.CompletionKind.Parameter: 
                    case Kusto.Language.Editor.CompletionKind.Variable: 
                    case Kusto.Language.Editor.CompletionKind.Table: 
                    case Kusto.Language.Editor.CompletionKind.Database: 
                    case Kusto.Language.Editor.CompletionKind.Cluster: 
                        // these should't appear, but if they do, then don't have a space.
                        return false;
                    case Kusto.Language.Editor.CompletionKind.Punctuation: 
                        return System.Linq.Enumerable.from(Kusto.Language.Editor.KustoCompleter.punctuationWithoutSpace, System.String).any(function (p) {
                                return Bridge.referenceEquals(item.DisplayText, p);
                            });
                    default: 
                        // offer space for syntatic keywords
                        return true;
                }
            },
            /**
             * Gets the annotations on the grammar rules that are invoke for the token at the specified text position.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {number}                                        position
             * @return  {System.Collections.Generic.IReadOnlyList$1}
             */
            GetGrammarAnnotations: function (position) {
                if (this._annotations != null && this._annotationPosition === position) {
                    return this._annotations;
                }

                var parsers = new (System.Collections.Generic.List$1(Kusto.Language.Parsing.Parser$1(Kusto.Language.Parsing.LexicalToken))).ctor();

                // look for completions in the grammar elements corresponding to the text position
                this.GetAnnotatedParsers(position, parsers);

                this._annotations = System.Linq.Enumerable.from(parsers, Kusto.Language.Parsing.Parser$1(Kusto.Language.Parsing.LexicalToken)).selectMany(function (p) {
                        return p.Annotations;
                    }).toList(System.Object);
                this._annotationPosition = position;

                return this._annotations;
            },
            /**
             * Gets a list of all annotated parsers that are invoked for the token at the specified text position.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {number}                               position            
             * @param   {System.Collections.Generic.List$1}    annotatedParsers
             * @return  {void}
             */
            GetAnnotatedParsers: function (position, annotatedParsers) {
                var startPosition = { };
                var grammar = { };
                // find a possible better starting point than the start of the whole query
                this.GetGrammarSearchContext(position, startPosition, grammar);

                var startIndex = this.code.GetTokenIndex(startPosition.v);
                var matchIndex = this.code.GetTokenIndex(position);

                // use a source that only includes relevant tokens (so we dont bother with tokens beyond)
                var tokens = this.code.GetLexicalTokens();
                var source = new (Kusto.Language.Parsing.ArraySource$1(Kusto.Language.Parsing.LexicalToken))(tokens, 0, ((matchIndex + 1) | 0));

                Kusto.Language.Editor.AnnotationFinder$1(Kusto.Language.Parsing.LexicalToken).FindAnnotations(source, matchIndex, grammar.v, startIndex, annotatedParsers);
            },
            /**
             * Find a nearby starting point (contextNode) and grammar rule to search with
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {number}                           position       
             * @param   {System.Int32}                     searchStart    
             * @param   {Kusto.Language.Parsing.Parser}    grammar
             * @return  {void}
             */
            GetGrammarSearchContext: function (position, searchStart, grammar) {
                var $t;
                var token = this.GetTokenLeftOfPosition(position);

                if (token != null) {
                    var queryGrammar = Kusto.Language.Parsing.QueryGrammar.From(Kusto.Language.GlobalState.Default);
                    var node = token.Parent;
                    var nextToken = token.GetNextToken();

                    for (; node != null; node = node.Parent) {
                        do {
                            if (Bridge.is(node, Kusto.Language.Syntax.QueryOperator)) {
                                var op = Bridge.cast(node, Kusto.Language.Syntax.QueryOperator);
                                searchStart.v = op.TextStart;
                                {
                                    var pipe;
                                    // the query operator on right of pipe
                                    if (((pipe = Bridge.as(op.Parent, Kusto.Language.Syntax.PipeExpression))) != null && Bridge.referenceEquals(pipe.Operator, op)) {
                                        grammar.v = queryGrammar.PipeSubExpression;
                                        return;
                                    }
                                }

                                // places where we know a normal pipe expression to exist
                                if (Bridge.is(op.Parent, Kusto.Language.Syntax.ParenthesizedExpression) || Bridge.is(op.Parent, Kusto.Language.Syntax.ExpressionStatement) || Bridge.is(op.Parent, Kusto.Language.Syntax.FunctionBody)) {
                                    grammar.v = queryGrammar.PipeExpression;
                                    return;
                                }

                                // otherwise back up further (to containing operator, etc) for 
                                // better starting point
                                break;
                            }

                            if (Bridge.is(node, Kusto.Language.Syntax.PipeExpression)) {
                                var pe = Bridge.cast(node, Kusto.Language.Syntax.PipeExpression);
                                // this is meant to handle the case of: XXX | YYY | $
                                if (position >= pe.Bar.TriviaStart) {
                                    var priorPipe;
                                    if (((priorPipe = Bridge.as(pe.Expression, Kusto.Language.Syntax.PipeExpression))) != null) {
                                        searchStart.v = priorPipe.Operator.TextStart;
                                        grammar.v = queryGrammar.PipeSubExpression;
                                        return;
                                    }
                                }

                                break;
                            }

                            if (Bridge.is(node, Kusto.Language.Syntax.FunctionBody)) {
                                var body = Bridge.cast(node, Kusto.Language.Syntax.FunctionBody);
                                searchStart.v = body.TextStart;
                                grammar.v = queryGrammar.FunctionBody;
                                return;
                            }

                            if (Bridge.is(node, Kusto.Language.Syntax.Statement)) {
                                var stat = Bridge.cast(node, Kusto.Language.Syntax.Statement);
                                if (this.IsQueryPart(node, 0)) {
                                    searchStart.v = stat.TextStart;
                                    grammar.v = queryGrammar.StatementList;
                                    return;
                                }

                                break;
                            }

                            if (Bridge.is(node, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement))) {
                                var _discard1 = Bridge.cast(node, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement));
                                if (this.IsQueryPart(node, 0)) {
                                    searchStart.v = node.TextStart;
                                    grammar.v = queryGrammar.StatementList;
                                    return;
                                }

                                break;
                            }

                            if (Bridge.is(node, Kusto.Language.Syntax.FunctionCallExpression)) {
                                var fc = Bridge.cast(node, Kusto.Language.Syntax.FunctionCallExpression);
                                // for argument list
                                if (position > fc.ArgumentList.OpenParen.End && ((!fc.ArgumentList.CloseParen.IsMissing && position <= fc.ArgumentList.CloseParen.TextStart) || fc.ArgumentList.CloseParen.IsMissing && nextToken != null && nextToken.Kind === Kusto.Language.Syntax.SyntaxKind.EndOfTextToken)) {
                                    searchStart.v = fc.TextStart;
                                    grammar.v = queryGrammar.UnnamedExpression;
                                    return;
                                }

                                break;
                            }

                            if (Bridge.is(node, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Expression))) {
                                var se = Bridge.cast(node, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Expression));
                                var parent = ($t = se.Parent) != null ? $t.Parent : null;
                                if (Bridge.is(parent, Kusto.Language.Syntax.DataTableExpression)) {
                                    searchStart.v = se.TextStart;
                                    grammar.v = queryGrammar.LiteralList;
                                    return;
                                }

                                break;
                            }

                            if (Bridge.is(node, Kusto.Language.Syntax.Command)) {
                                var _discard2 = Bridge.cast(node, Kusto.Language.Syntax.Command);
                                searchStart.v = node.TextStart;
                                grammar.v = this.code.Grammar; // use entire command block grammar
                                return;
                            }
                        } while (false);
                    }
                }

                // otherwise use the grammar associated with the entire source
                searchStart.v = this.code.Syntax.TextStart;
                grammar.v = this.code.Grammar;
            },
            GetTokenLeftOfPosition: function (position) {
                var token = this.code.Syntax.GetTokenAt(position);
                var hasAffinity = token != null && Kusto.Language.Editor.KustoCompleter.HasAffinity(token, position);

                if (token != null && (position <= token.TextStart || !hasAffinity || token.Kind === Kusto.Language.Syntax.SyntaxKind.EndOfTextToken)) {
                    token = token.GetPreviousToken();
                }

                return token;
            },
            GetCompleteExpressionLeftOfPosition: function (position) {
                var token = this.GetTokenLeftOfPosition(position);

                var expr = token != null ? token.GetFirstAncestorOrSelf(Kusto.Language.Syntax.Expression) : null;
                if (expr != null && expr.End === token.End && !expr.HasMissingChildren()) {
                    return expr;
                }

                return null;
            },
            IncludeSyntax: function (item, position, hints, match, left) {
                if (!this.options.IncludePunctuationOnlySyntax && item.Kind === Kusto.Language.Editor.CompletionKind.Punctuation) {
                    return false;
                }

                switch (item.Kind) {
                    case Kusto.Language.Editor.CompletionKind.QueryPrefix: 
                        return (hints & Kusto.Language.Editor.CompletionHint.Query) !== 0 || (hints & Kusto.Language.Editor.CompletionHint.Keyword) !== 0 || (match & Kusto.Language.Symbols.SymbolMatch.Tabular) !== 0;
                    case Kusto.Language.Editor.CompletionKind.TabularPrefix: 
                        return (match & Kusto.Language.Symbols.SymbolMatch.Tabular) !== 0;
                    case Kusto.Language.Editor.CompletionKind.TabularSuffix: 
                        return left != null && left.ResultType != null && left.ResultType.IsTabular;
                    case Kusto.Language.Editor.CompletionKind.ScalarPrefix: 
                    case Kusto.Language.Editor.CompletionKind.Example: 
                        return (match & Kusto.Language.Symbols.SymbolMatch.Scalar) !== 0;
                    case Kusto.Language.Editor.CompletionKind.ScalarInfix: 
                        return this.AnyInfixMatches(left, item.DisplayText, position);
                    default: 
                        return true;
                }
            },
            AnyInfixMatches: function (left, op, position) {
                var kind = Kusto.Language.Editor.KustoCompleter.GetOperatorKind(op);
                if (kind === Kusto.Language.Symbols.OperatorKind.None) {
                    return false;
                }

                // walk up expression tree and look for binary operator that would succeed with
                // type on the left
                for (; left != null; left = Bridge.as(left.Parent, Kusto.Language.Syntax.Expression)) {
                    if (position < left.End) {
                        break;
                    }

                    if (left.ResultType != null) {
                        // determine context that the expression is in
                        var hint = Kusto.Language.Editor.CompletionHint.None;
                        var parent;
                        if (((parent = left.Parent)) != null) {
                            hint = this.GetChildHint(parent, parent.GetChildIndex(left), Kusto.Language.Editor.CompletionHint.Query);
                        }

                        if (this.HasMatchingInfixOperator(kind, left.ResultType, hint)) {
                            return true;
                        }
                    }
                }

                return false;
            },
            /**
             * Returns true if the operator is defined for the left operand type.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoCompleter
             * @memberof Kusto.Language.Editor.KustoCompleter
             * @param   {Kusto.Language.Symbols.OperatorKind}     kind              
             * @param   {Kusto.Language.Symbols.TypeSymbol}       arg0Type          
             * @param   {Kusto.Language.Editor.CompletionHint}    returnTypeHint
             * @return  {boolean}
             */
            HasMatchingInfixOperator: function (kind, arg0Type, returnTypeHint) {
                var $t;
                var op = this.code.Globals.GetOperator(kind);

                $t = Bridge.getEnumerator(op.Signatures, Kusto.Language.Symbols.Signature);
                try {
                    while ($t.moveNext()) {
                        var sig = $t.Current;
                        if (!sig.IsHidden && Kusto.Language.Editor.KustoCompleter.ParameterMatches(System.Array.getItem(sig.Parameters, 0, Kusto.Language.Symbols.Parameter), arg0Type) && Kusto.Language.Editor.KustoCompleter.ReturnTypeMatchesContext(sig, arg0Type, returnTypeHint)) {
                            return true;
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return false;
            },
            GetCompletionKind: function (symbol) {
                switch (symbol.Kind) {
                    case Kusto.Language.Symbols.SymbolKind.Cluster: 
                        return Kusto.Language.Editor.CompletionKind.Cluster;
                    case Kusto.Language.Symbols.SymbolKind.Column: 
                        return Kusto.Language.Editor.CompletionKind.Column;
                    case Kusto.Language.Symbols.SymbolKind.Database: 
                        return Kusto.Language.Editor.CompletionKind.Database;
                    case Kusto.Language.Symbols.SymbolKind.Function: 
                        var fn = Bridge.cast(symbol, Kusto.Language.Symbols.FunctionSymbol);
                        if (this.code.Globals.IsAggregateFunction(fn)) {
                            return Kusto.Language.Editor.CompletionKind.AggregateFunction;
                        } else if (this.code.Globals.IsBuiltInFunction(fn)) {
                            return Kusto.Language.Editor.CompletionKind.BuiltInFunction;
                        } else if (this.code.Globals.IsDatabaseFunction(fn)) {
                            return Kusto.Language.Editor.CompletionKind.DatabaseFunction;
                        } else {
                            return Kusto.Language.Editor.CompletionKind.LocalFunction;
                        }
                    case Kusto.Language.Symbols.SymbolKind.Pattern: 
                        return Kusto.Language.Editor.CompletionKind.LocalFunction;
                    case Kusto.Language.Symbols.SymbolKind.Operator: 
                        return Kusto.Language.Editor.CompletionKind.BuiltInFunction;
                    case Kusto.Language.Symbols.SymbolKind.Variable: 
                        return this.GetVariableCompletionKind(Bridge.cast(symbol, Kusto.Language.Symbols.VariableSymbol));
                    case Kusto.Language.Symbols.SymbolKind.Parameter: 
                        return Kusto.Language.Editor.CompletionKind.Parameter;
                    case Kusto.Language.Symbols.SymbolKind.Table: 
                        return Kusto.Language.Editor.CompletionKind.Table;
                    case Kusto.Language.Symbols.SymbolKind.MaterializedView: 
                        return Kusto.Language.Editor.CompletionKind.MaterialiedView;
                    case Kusto.Language.Symbols.SymbolKind.Tuple: 
                    case Kusto.Language.Symbols.SymbolKind.Scalar: 
                    case Kusto.Language.Symbols.SymbolKind.Group: 
                    case Kusto.Language.Symbols.SymbolKind.Void: 
                    default: 
                        return Kusto.Language.Editor.CompletionKind.Unknown;
                }
            },
            GetVariableCompletionKind: function (vs) {
                switch (vs.Type.Kind) {
                    case Kusto.Language.Symbols.SymbolKind.Table: 
                    case Kusto.Language.Symbols.SymbolKind.Function: 
                    case Kusto.Language.Symbols.SymbolKind.Pattern: 
                        return this.GetCompletionKind(vs.Type);
                    default: 
                        return Kusto.Language.Editor.CompletionKind.Variable;
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoCompleter.CompletionBuilder", {
        $kind: "nested class",
        statics: {
            methods: {
                GetBetterItem: function (existing, other) {
                    // promote query operators over keywords
                    if (existing.Kind === Kusto.Language.Editor.CompletionKind.Keyword && other.Kind === Kusto.Language.Editor.CompletionKind.QueryPrefix) {
                        return other;
                    }

                    return existing;
                }
            }
        },
        fields: {
            list: null,
            indexMap: null
        },
        ctors: {
            init: function () {
                this.list = new (System.Collections.Generic.List$1(Kusto.Language.Editor.CompletionItem)).ctor();
                this.indexMap = new (System.Collections.Generic.Dictionary$2(System.String,System.Int32)).ctor();
            },
            ctor: function () {
                this.$initialize();
            }
        },
        methods: {
            ToList: function () {
                return this.list.AsReadOnly();
            },
            Add: function (item) {
                var existingItemIndex = { };
                if (this.indexMap.tryGetValue(item.DisplayText, existingItemIndex)) {
                    var better = Kusto.Language.Editor.KustoCompleter.CompletionBuilder.GetBetterItem(this.list.getItem(existingItemIndex.v), item);
                    if (Bridge.referenceEquals(better, item)) {
                        this.list.setItem(existingItemIndex.v, item);
                    }
                } else {
                    this.indexMap.add(item.DisplayText, this.list.Count);
                    this.list.add(item);
                }
            },
            AddRange: function (items) {
                var $t;
                $t = Bridge.getEnumerator(items, Kusto.Language.Editor.CompletionItem);
                try {
                    while ($t.moveNext()) {
                        var item = $t.Current;
                        this.Add(item);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoCompleter.CompletionMode", {
        $kind: "nested enum",
        statics: {
            fields: {
                /**
                 * The completions should be shown alone
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 0
                 * @type number
                 */
                Isolated: 0,
                /**
                 * The completions should be shown with other completions
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 1
                 * @type number
                 */
                Combined: 1
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoCompleter.OrderingRank", {
        $kind: "nested enum",
        statics: {
            fields: {
                Literal: 0,
                Aggregate: 1,
                Column: 2,
                Table: 3,
                Variable: 4,
                Function: 5,
                MaterializedView: 6,
                Keyword: 7,
                StringOperator: 8,
                MathOperator: 9,
                Other: 10
            }
        }
    });

    /**
     * Rewrites whitespace to conform to formatting options.
     *
     * @class Kusto.Language.Editor.KustoFormatter
     */
    Bridge.define("Kusto.Language.Editor.KustoFormatter", {
        statics: {
            fields: {
                ArbitraryMaxBinaryOperatorChainWidth: 0,
                ArbitraryMaxSingleLineQueryWidth: 0,
                ArbitraryMaxCommaListWidthWidth: 0,
                ArbitraryMaxSingleLineDataTableWidth: 0,
                ArbitraryMaxSingleLineSchemaWidth: 0,
                ArbitraryMaxSingleLineRowWidth: 0,
                ArbitraryMaxValueWidth: 0,
                s_Spaces: null
            },
            ctors: {
                init: function () {
                    this.ArbitraryMaxBinaryOperatorChainWidth = 80;
                    this.ArbitraryMaxSingleLineQueryWidth = 80;
                    this.ArbitraryMaxCommaListWidthWidth = 80;
                    this.ArbitraryMaxSingleLineDataTableWidth = 80;
                    this.ArbitraryMaxSingleLineSchemaWidth = 60;
                    this.ArbitraryMaxSingleLineRowWidth = 80;
                    this.ArbitraryMaxValueWidth = 40;
                    this.s_Spaces = System.String.fromCharCount(32, 256);
                }
            },
            methods: {
                /**
                 * Gets the formatted text for the node.
                 *
                 * @static
                 * @public
                 * @this Kusto.Language.Editor.KustoFormatter
                 * @memberof Kusto.Language.Editor.KustoFormatter
                 * @param   {Kusto.Language.Syntax.SyntaxNode}           node              
                 * @param   {Kusto.Language.Editor.FormattingOptions}    options           
                 * @param   {number}                                     cursorPosition
                 * @return  {Kusto.Language.Editor.FormattedText}
                 */
                GetFormattedText: function (node, options, cursorPosition) {
                    var formatter = new Kusto.Language.Editor.KustoFormatter(cursorPosition, options || Kusto.Language.Editor.FormattingOptions.Default);
                    formatter.Format(node);
                    return new Kusto.Language.Editor.FormattedText(formatter._builder.toString(), formatter._newCursorPosition);
                },
                SkipWhitespace: function (text, start) {
                    var p = start;

                    while (p < text.length && Kusto.Language.Parsing.TextFacts.IsWhitespace(text.charCodeAt(p)) && !Kusto.Language.Parsing.TextFacts.IsLineBreakStart(text.charCodeAt(p))) {
                        p = (p + 1) | 0;
                    }

                    return p;
                },
                IsDirectQueryOperatorPart: function (node) {
                    return Bridge.is(node.Parent, Kusto.Language.Syntax.QueryOperator) || Bridge.is(node.Parent, Kusto.Language.Syntax.Clause);
                },
                IsChainableBinaryOperator: function (kind) {
                    switch (kind) {
                        case Kusto.Language.Syntax.SyntaxKind.AndExpression: 
                        case Kusto.Language.Syntax.SyntaxKind.OrExpression: 
                            //case SyntaxKind.AddExpression:
                            return true;
                        default: 
                            return false;
                    }

                },
                GetBinaryOperatorChainDepth: function (be) {
                    var count = 1;
                    var left;
                    while (be != null && ((left = Bridge.as(be.Left, Kusto.Language.Syntax.BinaryExpression))) != null && left.Operator.Kind === be.Operator.Kind) {
                        count = (count + 1) | 0;
                        be = left;
                    }

                    return count;
                },
                GetBalancedColumnCount: function (expressions) {
                    // if any value is too wide, then place all on separate lines
                    if (Kusto.Language.Editor.KustoFormatter.GetMaximumValueWidth(expressions) >= Kusto.Language.Editor.KustoFormatter.ArbitraryMaxValueWidth) {
                        return 1;
                    }

                    // determine if better to display as multiple columns
                    var columns = 10;

                    while (true) {
                        if (Kusto.Language.Editor.KustoFormatter.GetMaximumRowWidth(expressions, columns) <= Kusto.Language.Editor.KustoFormatter.ArbitraryMaxSingleLineRowWidth) {
                            return columns;
                        }

                        if (columns > 4) {
                            columns = (columns - 2) | 0;
                            continue;
                        }

                        return 1;
                    }
                },
                GetMaximumValueWidth: function (expressions) {
                    var maxWidth = 0;

                    for (var i = 0; i < expressions.Count; i = (i + 1) | 0) {
                        var width = expressions.getItem$1(i).Element$1.Width;
                        if (width > maxWidth) {
                            maxWidth = width;
                        }
                    }

                    return maxWidth;
                },
                GetMaximumRowWidth: function (expressions, columns) {
                    var maxWidth = 0;

                    for (var firstColumnInRow = 0; firstColumnInRow < expressions.Count; firstColumnInRow = (firstColumnInRow + columns) | 0) {
                        var lastColumnInRow = Math.min(((expressions.Count - 1) | 0), ((((firstColumnInRow + columns) | 0) - 1) | 0));
                        var start = expressions.getItem$1(firstColumnInRow).TriviaStart;
                        var end = expressions.getItem$1(lastColumnInRow).End;
                        var width = (end - start) | 0;
                        if (width > maxWidth) {
                            maxWidth = width;
                        }
                    }

                    return maxWidth;
                },
                IsIdentifierOrKeyword: function (token) {
                    return token.Kind === Kusto.Language.Syntax.SyntaxKind.IdentifierToken || Kusto.Language.Syntax.SyntaxFacts.IsKeyword(token.Kind);
                },
                /**
                 * Returns true if the tokens were originally on different lines.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.KustoFormatter
                 * @memberof Kusto.Language.Editor.KustoFormatter
                 * @param   {Kusto.Language.Syntax.SyntaxToken}    first        
                 * @param   {Kusto.Language.Syntax.SyntaxToken}    last         
                 * @param   {boolean}                              inclusive    
                 * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
                 * @return  {boolean}
                 */
                SpansMultipleLines$1: function (first, last, inclusive, excluded) {
                    if (inclusive === void 0) { inclusive = false; }
                    if (excluded === void 0) { excluded = null; }
                    if (first != null && last != null) {
                        if (inclusive && !Bridge.referenceEquals(first, excluded) && Kusto.Language.Parsing.TextFacts.HasLineBreaks(first.Trivia)) {
                            return true;
                        }

                        var token = first.GetNextToken();
                        while (token != null) {
                            if (!Bridge.referenceEquals(token, excluded) && Kusto.Language.Parsing.TextFacts.HasLineBreaks(token.Trivia)) {
                                return true;
                            }

                            if (Bridge.referenceEquals(token, last)) {
                                break;
                            }

                            token = token.GetNextToken();
                        }
                    }

                    return false;
                },
                /**
                 * Returns true if the tokens of the node are currently on different lines.
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.KustoFormatter
                 * @memberof Kusto.Language.Editor.KustoFormatter
                 * @param   {Kusto.Language.Syntax.SyntaxNode}     node         
                 * @param   {boolean}                              inclusive    
                 * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
                 * @return  {boolean}
                 */
                SpansMultipleLines: function (node, inclusive, excluded) {
                    if (inclusive === void 0) { inclusive = false; }
                    if (excluded === void 0) { excluded = null; }
                    if (node != null) {
                        return Kusto.Language.Editor.KustoFormatter.SpansMultipleLines$1(node.GetFirstToken(), node.GetLastToken(), inclusive, excluded);
                    }

                    return false;
                }
            }
        },
        fields: {
            _options: null,
            _builder: null,
            _cursorPosition: 0,
            _newCursorPosition: 0,
            _spacingRules: null,
            _alignmentRules: null,
            _elementIndentations: null
        },
        ctors: {
            init: function () {
                this._spacingRules = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Syntax.SyntaxElement,Kusto.Language.Editor.KustoFormatter.SpacingRule)).ctor();
                this._alignmentRules = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Syntax.SyntaxElement,Kusto.Language.Editor.KustoFormatter.AlignmentRule)).ctor();
                this._elementIndentations = new (System.Collections.Generic.Dictionary$2(Kusto.Language.Syntax.SyntaxElement,System.Int32)).ctor();
            },
            ctor: function (cursorPosition, options) {
                this.$initialize();
                this._cursorPosition = cursorPosition;
                this._newCursorPosition = -1;
                this._options = options;
                this._builder = new System.Text.StringBuilder();
            }
        },
        methods: {
            Format: function (node) {
                // identify formatting rules for all nodes and tokens
                this.IdentifyFormattingRules(node);

                // write out text by applying the formatting rules
                this.WriteFormattedText(node, 0);

                // adjust cursor position if not already chosen,
                // as it may need to move if it was inside the formatted area.
                if (this._newCursorPosition === -1) {
                    if (this._cursorPosition <= 0) {
                        // position was logically before this text, leave it alone
                        this._newCursorPosition = this._cursorPosition;
                    } else if (this._cursorPosition <= node.End) {
                        // position with within this text, but not already recomputed?
                        // put it at the new end position
                        this._newCursorPosition = this._builder.getLength();
                    } else {
                        // position was logically somewhere after this text, so adjust based on change delta
                        this._newCursorPosition = (this._cursorPosition + (((this._builder.getLength() - node.Width) | 0))) | 0;
                    }
                }
            },
            /**
             * Writes the node to text, applying the formatting rules
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxNode}    node           
             * @param   {number}                              indentation
             * @return  {void}
             */
            WriteFormattedText: function (node, indentation) {
                if (node == null) {
                    return;
                }

                for (var i = 0, n = node.ChildCount; i < n; i = (i + 1) | 0) {
                    var child = node.GetChild(i);

                    if (child != null) {
                        var spacingKind = Kusto.Language.Editor.KustoFormatter.SpacingKind.AlignOnly;
                        var childIndentation = indentation;
                        var spacing = { };

                        if (this.TryGetSpacingRule(child, spacing)) {
                            spacingKind = spacing.v.GetKind();
                        }
                        var alignment = { };

                        if (this.TryGetAlignmentRule(child, alignment)) {
                            if (alignment.v.RelativeToElement == null) {
                                childIndentation = (childIndentation + alignment.v.IndentationDelta) | 0;
                            } else {
                                var elementIndentation = { };
                                if (this.TryGetIndentation(alignment.v.RelativeToElement, elementIndentation)) {
                                    childIndentation = (elementIndentation.v + alignment.v.IndentationDelta) | 0;
                                }
                            }
                        }
                        var sn;
                        if (((sn = Bridge.as(child, Kusto.Language.Syntax.SyntaxNode))) != null) {
                            this.WriteFormattedText(sn, childIndentation);
                        } else {
                            var t2;
                            if (((t2 = Bridge.as(child, Kusto.Language.Syntax.SyntaxToken))) != null) {
                                this.WriteToken(t2, childIndentation, spacingKind);
                                this._elementIndentations.add(t2, childIndentation);
                            }
                        }
                    }
                }
            },
            TryGetSpacingRule: function (element, rule) {
                return this._spacingRules.tryGetValue(element, rule);
            },
            TryGetAlignmentRule: function (element, rule) {
                return this._alignmentRules.tryGetValue(element, rule);
            },
            TryGetIndentation: function (element, indentation) {
                if (this._elementIndentations.tryGetValue(element, indentation)) {
                    return true;
                }
                var node;
                // if no specific indentation is recorded for a node,
                // use the indentation of its first token
                if (((node = Bridge.as(element, Kusto.Language.Syntax.SyntaxNode))) != null) {
                    var token = element.GetFirstToken();

                    if (token != null && this._elementIndentations.tryGetValue(token, indentation)) {
                        return true;
                    }
                }

                return false;
            },
            WriteToken: function (token, indentation, spacingKind) {
                if (spacingKind === void 0) { spacingKind = 2; }
                if (token.Text.length > 0 || token.Trivia.length > 0 || (token.IsMissing && this._options.InsertMissingTokens)) {
                    this.WriteTrivia(token, indentation, spacingKind, token.Kind !== Kusto.Language.Syntax.SyntaxKind.EndOfTextToken);
                }

                if (this._newCursorPosition === -1) {
                    if (this._cursorPosition >= token.TextStart && this._cursorPosition <= token.End) {
                        this._newCursorPosition = (this._builder.getLength() + (((this._cursorPosition - token.TextStart) | 0))) | 0;
                    } else if (this._cursorPosition < token.TextStart) {
                        this._newCursorPosition = this._builder.getLength();
                    }
                }

                if (token.IsMissing && this._options.InsertMissingTokens) {
                    var text = Kusto.Language.Syntax.SyntaxFacts.GetText(token.Kind);

                    if (!System.String.isNullOrEmpty(text)) {
                        this._builder.append(text);
                    }
                } else {
                    this._builder.append(token.Text);
                }
            },
            WriteTrivia: function (token, indentation, spacingKind, hasFollowingToken) {
                var trivia = token.Trivia;
                var cursorInTrivia = this._cursorPosition >= token.TriviaStart && this._cursorPosition < token.TextStart;

                switch (spacingKind) {
                    case Kusto.Language.Editor.KustoFormatter.SpacingKind.NoSpace: 
                        // all spacing is removed
                        return;
                    case Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpace: 
                        // all spacing is replace by a single space
                        this._builder.append(" ");
                        return;
                }

                if (spacingKind !== Kusto.Language.Editor.KustoFormatter.SpacingKind.AsIs && Kusto.Language.Parsing.TextFacts.HasLineBreaks(trivia)) {
                    // adjust and write all trivia lines
                    for (var lineStart = 0, lineEnd = 0; lineStart < trivia.length; lineStart = lineEnd) {
                        var whitespaceEnd = Kusto.Language.Editor.KustoFormatter.SkipWhitespace(trivia, lineStart);

                        if (lineStart === 0) {
                            // write existing whitespace for first line, since this is whitespace that follows the last
                            // token on the last line (may contain trailing comments)
                            this._builder.append(trivia, lineStart, ((whitespaceEnd - lineStart) | 0));
                        } else {
                            // write standardized indentation instead of existing whitespace
                            this.WriteIndentation(indentation);
                        }

                        // write remainder of line (possible comments and/or EOL)
                        var nextLineBreakStart = Kusto.Language.Parsing.TextFacts.GetNextLineBreakStart(trivia, whitespaceEnd);
                        var nextLineStart = Kusto.Language.Parsing.TextFacts.GetNextLineStart(trivia, whitespaceEnd);
                        lineEnd = nextLineStart >= 0 ? nextLineStart : trivia.length;
                        this._builder.append(trivia, whitespaceEnd, ((lineEnd - whitespaceEnd) | 0));

                        // if the last thing in the trivia was a line break, add indentation for following token.
                        if (lineEnd >= trivia.length && nextLineBreakStart >= 0 && hasFollowingToken) {
                            this.WriteIndentation(indentation);
                        }
                    }
                } else {
                    switch (spacingKind) {
                        case Kusto.Language.Editor.KustoFormatter.SpacingKind.NoSpaceIfOnSameLine: 
                            // there was no line break, so make it have no spacing by writing nothing
                            break;
                        case Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine: 
                            // there was no line break, so make it a single space by writing a single space
                            this._builder.append(" ");
                            break;
                        case Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine: 
                            // there was no line break so add one
                            this._builder.appendLine();
                            this.WriteIndentation(indentation);
                            break;
                        case Kusto.Language.Editor.KustoFormatter.SpacingKind.AsIs: 
                        case Kusto.Language.Editor.KustoFormatter.SpacingKind.AlignOnly: 
                        default: 
                            this._builder.append(trivia);
                            break;
                    }
                }
            },
            WriteIndentation: function (indentation) {
                while (indentation > Kusto.Language.Editor.KustoFormatter.s_Spaces.length) {
                    this._builder.append(Kusto.Language.Editor.KustoFormatter.s_Spaces);
                    indentation = (indentation - Kusto.Language.Editor.KustoFormatter.s_Spaces.length) | 0;
                }

                this._builder.append(Kusto.Language.Editor.KustoFormatter.s_Spaces, 0, Math.min(indentation, Kusto.Language.Editor.KustoFormatter.s_Spaces.length));
            },
            /**
             * Identify formatting rules for all nodes and tokens.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxNode}    node
             * @return  {void}
             */
            IdentifyFormattingRules: function (node) {
                if (node != null) {
                    // visit children first so token rules (being more general) get added first
                    // and node rules (being more specific) get added later.
                    for (var i = 0, n = node.ChildCount; i < n; i = (i + 1) | 0) {
                        var child = node.GetChild(i);
                        var sn;
                        if (((sn = Bridge.as(child, Kusto.Language.Syntax.SyntaxNode))) != null) {
                            this.IdentifyFormattingRules(sn);
                        } else {
                            var t;
                            if (((t = Bridge.as(child, Kusto.Language.Syntax.SyntaxToken))) != null) {
                                this.AddTokenRules(t);
                            }
                        }
                    }

                    this.AddNodeRules(node);
                }
            },
            /**
             * Add spacing and alignment rules for individual tokens
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxToken}    token
             * @return  {void}
             */
            AddTokenRules: function (token) {
                // don't adjust spacing if there are already line breaks in the trivia
                if (Kusto.Language.Parsing.TextFacts.HasLineBreaks(token.Trivia)) {
                    return;
                }

                // if no previous token then leave as is
                var prev = token.GetPreviousToken();
                if (prev == null) {
                    return;
                }

                if (Kusto.Language.Editor.KustoFormatter.IsIdentifierOrKeyword(token) && Kusto.Language.Editor.KustoFormatter.IsIdentifierOrKeyword(prev)) {
                    // always have space between two adjacent names
                    if (!Bridge.referenceEquals(token.Trivia, " ")) {
                        this.AddRule$2(token, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine));
                    }
                } else {
                    var be;
                    var pbe;
                    if (((be = Bridge.as(token.Parent, Kusto.Language.Syntax.BinaryExpression))) != null && Bridge.referenceEquals(be.Operator, token) || ((pbe = Bridge.as(prev.Parent, Kusto.Language.Syntax.BinaryExpression))) != null && Bridge.referenceEquals(pbe.Operator, prev)) {
                        // space before and after binary operator
                        if (!Bridge.referenceEquals(token.Trivia, " ")) {
                            this.AddRule$2(token, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine));
                        }
                    } else {
                        var pue;
                        if (((pue = Bridge.as(prev.Parent, Kusto.Language.Syntax.PrefixUnaryExpression))) != null && Bridge.referenceEquals(pue.Operator, prev)) {
                            // no space after prefix unary operator
                            if (!Bridge.referenceEquals(token.Trivia, "")) {
                                this.AddRule$2(token, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NoSpaceIfOnSameLine));
                            }
                        } else if (token.Kind !== Kusto.Language.Syntax.SyntaxKind.EndOfTextToken) {
                            // spacing before token
                            switch (token.Kind) {
                                case Kusto.Language.Syntax.SyntaxKind.CloseBraceToken: 
                                case Kusto.Language.Syntax.SyntaxKind.CloseBracketToken: 
                                case Kusto.Language.Syntax.SyntaxKind.CloseParenToken: 
                                case Kusto.Language.Syntax.SyntaxKind.CommaToken: 
                                case Kusto.Language.Syntax.SyntaxKind.ColonToken: 
                                case Kusto.Language.Syntax.SyntaxKind.SemicolonToken: 
                                case Kusto.Language.Syntax.SyntaxKind.DotToken: 
                                    if (!Bridge.referenceEquals(token.Trivia, "")) {
                                        this.AddRule$2(token, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NoSpaceIfOnSameLine));
                                    }
                                    break;
                                case Kusto.Language.Syntax.SyntaxKind.DotDotToken: 
                                case Kusto.Language.Syntax.SyntaxKind.BarToken: 
                                    if (!Bridge.referenceEquals(token.Trivia, " ")) {
                                        this.AddRule$2(token, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine));
                                    }
                                    break;
                            }

                            // spacing after previous token
                            switch (prev.Kind) {
                                case Kusto.Language.Syntax.SyntaxKind.OpenBraceToken: 
                                case Kusto.Language.Syntax.SyntaxKind.OpenBracketToken: 
                                case Kusto.Language.Syntax.SyntaxKind.OpenParenToken: 
                                case Kusto.Language.Syntax.SyntaxKind.DotToken: 
                                    if (!Bridge.referenceEquals(token.Trivia, "")) {
                                        this.AddRule$2(token, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NoSpaceIfOnSameLine));
                                    }
                                    break;
                                case Kusto.Language.Syntax.SyntaxKind.CommaToken: 
                                case Kusto.Language.Syntax.SyntaxKind.ColonToken: 
                                case Kusto.Language.Syntax.SyntaxKind.BarToken: 
                                case Kusto.Language.Syntax.SyntaxKind.SemicolonToken: 
                                case Kusto.Language.Syntax.SyntaxKind.DotDotToken: 
                                    if (!Bridge.referenceEquals(token.Trivia, " ")) {
                                        this.AddRule$2(token, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine));
                                    }
                                    break;
                            }
                        }
                    }
                }
            },
            /**
             * Add spacing and alignment rules specific to types of nodes
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxNode}    node
             * @return  {void}
             */
            AddNodeRules: function (node) {
                var $t, $t1;
                this.AddSubElementRules(node);
                do {
                    if (Bridge.is(node, Kusto.Language.Syntax.PipeExpression)) {
                        var pe = Bridge.cast(node, Kusto.Language.Syntax.PipeExpression);
                        this.AddPipeExpressionRules(pe);
                        break;
                    }

                    if (Bridge.is(node, Kusto.Language.Syntax.FunctionDeclaration)) {
                        var fd = Bridge.cast(node, Kusto.Language.Syntax.FunctionDeclaration);
                        this.AddFunctionDeclarationRules(fd);
                        break;
                    }

                    if (Bridge.is(node, Kusto.Language.Syntax.SeparatedElement)) {
                        var se = Bridge.cast(node, Kusto.Language.Syntax.SeparatedElement);
                        // semicolons?
                        if (System.Nullable.eq((($t = se.Separator) != null ? $t.Kind : null), Kusto.Language.Syntax.SyntaxKind.SemicolonToken) && Bridge.is(se.Element, Kusto.Language.Syntax.LetStatement)) {
                            this.AddSemicolonRules(se);
                        }

                        break;
                    }

                    if (Bridge.is(node, Kusto.Language.Syntax.SyntaxList)) {
                        var list = Bridge.cast(node, Kusto.Language.Syntax.SyntaxList);
                        {
                            var listElem;
                            if (list.Count > 1 && ((listElem = Bridge.as(list.getItem(0), Kusto.Language.Syntax.SeparatedElement))) != null && System.Nullable.eq((($t1 = listElem.Separator) != null ? $t1.Kind : null), Kusto.Language.Syntax.SyntaxKind.CommaToken) && Kusto.Language.Editor.KustoFormatter.IsDirectQueryOperatorPart(list)) {
                                this.AddQueryOperatorCommaListRules(list);
                            }
                        }

                        break;
                    }

                    if (Bridge.is(node, Kusto.Language.Syntax.BracketedExpression)) {
                        var be = Bridge.cast(node, Kusto.Language.Syntax.BracketedExpression);
                        this.AddBracketExpressionRules(be);
                        break;
                    }

                    if (Bridge.is(node, Kusto.Language.Syntax.Statement)) {
                        var st = Bridge.cast(node, Kusto.Language.Syntax.Statement);
                        this.AddStatementRules(st);
                        break;
                    }

                    if (Bridge.is(node, Kusto.Language.Syntax.DataTableExpression)) {
                        var dt = Bridge.cast(node, Kusto.Language.Syntax.DataTableExpression);
                        this.AddDataTableExpressionRules(dt);
                        break;
                    }

                    if (Bridge.is(node, Kusto.Language.Syntax.BinaryExpression)) {
                        var be1 = Bridge.cast(node, Kusto.Language.Syntax.BinaryExpression);
                        this.AddBinaryOperatorChainRules(be1);
                        break;
                    }
                } while (false);
            },
            /**
             * Place operator that is part of an operator chain that is part of a query operator or clause (not nested in parens, etc)
              on new line if the overall chain is large.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.BinaryExpression}    be
             * @return  {void}
             */
            AddBinaryOperatorChainRules: function (be) {
                if (Kusto.Language.Editor.KustoFormatter.IsChainableBinaryOperator(be.Kind) && Kusto.Language.Editor.KustoFormatter.IsDirectQueryOperatorPart(be) && !Kusto.Language.Editor.KustoFormatter.SpansMultipleLines(be) && be.Width > Kusto.Language.Editor.KustoFormatter.ArbitraryMaxBinaryOperatorChainWidth) {
                    var depth = Kusto.Language.Editor.KustoFormatter.GetBinaryOperatorChainDepth(be);
                    if (depth > 1) {
                        var op = be;
                        while (op != null && op.Kind === be.Kind) {
                            this.AddRule$2(op.Operator, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine));
                            op = Bridge.as(op.Left, Kusto.Language.Syntax.BinaryExpression);
                        }
                    }
                }
            },
            AddSubElementRules: function (n) {
                if ((Bridge.is(n.Parent, Kusto.Language.Syntax.Statement) && !(Bridge.is(n.Parent, Kusto.Language.Syntax.ExpressionStatement))) || Bridge.is(n.Parent, Kusto.Language.Syntax.QueryOperator) || Bridge.is(n.Parent, Kusto.Language.Syntax.Command)) {
                    // sub elements of statements/commands/query-operators are all indented.
                    if (n.IndexInParent > 0) {
                        this.AddRule(n, this.IndentRule());
                    }

                    // start all clauses on new line if there are any new lines in statement/query-operator/command
                    if (Bridge.is(n, Kusto.Language.Syntax.Clause)) {
                        this.AddRule$2(n.GetFirstToken(), new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, Bridge.fn.bind(this, function () {
                            return this.SpansOrWillSpanMultipleLines(n.Parent);
                        })));
                    }
                }
            },
            AddPipeExpressionRules: function (pe) {
                if (Bridge.is(pe.Parent, Kusto.Language.Syntax.PipeExpression)) {
                    return;
                }

                var entireQuery = pe;

                var style = this._options.PipeOperatorStyle;

                if (!Kusto.Language.Editor.KustoFormatter.SpansMultipleLines(entireQuery) && entireQuery.Width > Kusto.Language.Editor.KustoFormatter.ArbitraryMaxSingleLineQueryWidth) {
                    style = Kusto.Language.Editor.PlacementStyle.NewLine;
                }

                for (; pe != null; pe = Bridge.as(pe.Expression, Kusto.Language.Syntax.PipeExpression)) {
                    var barToken = { v : pe.Bar };

                    switch (style) {
                        case Kusto.Language.Editor.PlacementStyle.Smart: 
                            // place this pipe expression's | on a new line if there are any new lines in the whole expression
                            this.AddRule$2(barToken.v, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, (function ($me, barToken) {
                                return Bridge.fn.bind($me, function () {
                                    return this.SpansOrWillSpanMultipleLines(entireQuery, false, barToken.v);
                                });
                            })(this, barToken)));
                            // Adjust the spacing of the operator's first token so it snaps to the |'s placement.
                            var opToken = pe.Operator.GetFirstToken();
                            this.AddRule$2(opToken, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpace));
                            // adjust first token to new line if query is part of a parenthesized expression
                            if (Bridge.referenceEquals(entireQuery, pe)) {
                                var firstToken = { v : pe.GetFirstToken() };
                                var prevToken = firstToken.v.GetPreviousToken();

                                if (prevToken != null && (prevToken.Kind === Kusto.Language.Syntax.SyntaxKind.OpenParenToken || prevToken.Kind === Kusto.Language.Syntax.SyntaxKind.OpenBraceToken)) {
                                    this.AddRule$2(firstToken.v, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, (function ($me, firstToken) {
                                        return Bridge.fn.bind($me, function () {
                                            return this.SpansOrWillSpanMultipleLines(entireQuery, false, firstToken.v);
                                        });
                                    })(this, firstToken)));
                                }
                            }
                            break;
                        case Kusto.Language.Editor.PlacementStyle.NewLine: 
                            // place this pipe expression's | on a new line if there are any new lines in the whole expression
                            this.AddRule$2(barToken.v, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine));
                            // Adjust the spacing of the operator's first token so it snaps to the |'s placement.
                            opToken = pe.Operator.GetFirstToken();
                            this.AddRule$2(opToken, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpace));
                            break;
                    }
                }
            },
            AddSemicolonRules: function (se) {
                switch (this._options.SemicolonStyle) {
                    case Kusto.Language.Editor.PlacementStyle.Smart: 
                        this.AddRule$2(se.Separator, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, Bridge.fn.bind(this, function () {
                            return this.SpansOrWillSpanMultipleLines(Bridge.cast(se.Element, Kusto.Language.Syntax.SyntaxNode));
                        })));
                        this.AddRule(se.Separator, this.IndentRule(se));
                        break;
                    case Kusto.Language.Editor.PlacementStyle.NewLine: 
                        this.AddRule$2(se.Separator, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine));
                        this.AddRule(se.Separator, this.IndentRule(se));
                        break;
                }
            },
            AddQueryOperatorCommaListRules: function (list) {
                if (list.Width > Kusto.Language.Editor.KustoFormatter.ArbitraryMaxCommaListWidthWidth && !Kusto.Language.Editor.KustoFormatter.SpansMultipleLines(list)) {
                    for (var i = 0; i < list.Count; i = (i + 1) | 0) {
                        var elem = Bridge.cast(list.getItem(i), Kusto.Language.Syntax.SyntaxNode);
                        this.AddRule$1(elem, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine));
                    }
                }
            },
            AddFunctionDeclarationRules: function (fd) {
                var $t;
                var letStatement = fd.Parent;

                this.AddBrackettingStyleRules(fd.Body.OpenBrace, fd.Body.CloseBrace, letStatement);

                // assign spacing for each statement in body
                $t = Bridge.getEnumerator(fd.Body.Statements, "GetEnumerator$1");
                try {
                    while ($t.moveNext()) {
                        var statement = $t.Current;
                        var firstToken = { v : statement.GetFirstToken() };
                        this.AddRule$2(firstToken.v, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, (function ($me, firstToken) {
                            return Bridge.fn.bind($me, function () {
                                return this.SpansOrWillSpanMultipleLines(fd.Body, true, firstToken.v);
                            });
                        })(this, firstToken)));
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                // indent all statements relative to let statement
                this.AddRule(fd.Body.Statements, this.IndentRule(letStatement));

                // also apply same rules to final body expression
                if (fd.Body.Expression != null) {
                    var firstToken1 = fd.Body.Expression.GetFirstToken();
                    this.AddRule$2(firstToken1, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, Bridge.fn.bind(this, function () {
                        return this.SpansOrWillSpanMultipleLines(fd.Body, true, firstToken1);
                    })));
                    this.AddRule(fd.Body.Expression, this.IndentRule(letStatement));
                }
            },
            AddBracketExpressionRules: function (be) {
                if (Bridge.is(be.Parent, Kusto.Language.Syntax.ElementExpression)) {
                    // no space between expression and open bracket
                    this.AddRule$2(be.OpenBracket, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NoSpaceIfOnSameLine));
                }
            },
            AddStatementRules: function (st) {
                var first = st.GetFirstToken();
                if (first != null) {
                    var prev = first.GetPreviousToken();
                    if (prev != null) {
                        switch (this._options.StatementStyle) {
                            case Kusto.Language.Editor.PlacementStyle.Smart: 
                                {
                                    var se;
                                    var list;
                                    if (((se = Bridge.as(st.Parent, Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement)))) != null && ((list = Bridge.as(se.Parent, Kusto.Language.Syntax.SyntaxList$1(Kusto.Language.Syntax.SeparatedElement$1(Kusto.Language.Syntax.Statement))))) != null) {
                                        this.AddRule$2(first, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, Bridge.fn.bind(this, function () {
                                            return this.SpansOrWillSpanMultipleLines(list, false, first);
                                        })));
                                    }
                                }
                                break;
                            case Kusto.Language.Editor.PlacementStyle.NewLine: 
                                this.AddRule$2(first, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine));
                                break;
                        }
                    }
                }
            },
            AddDataTableExpressionRules: function (dt) {
                // do nothing if whole declaration is small and on one line
                if (dt.Width <= Kusto.Language.Editor.KustoFormatter.ArbitraryMaxSingleLineDataTableWidth && !Kusto.Language.Editor.KustoFormatter.SpansMultipleLines(dt)) {
                    return;
                }

                var relativeTo = Bridge.cast(dt.GetFirstAncestor(Kusto.Language.Syntax.Statement), Kusto.Language.Syntax.SyntaxNode) || dt;

                var schemaColumns = dt.Schema.Columns.Count;

                // add schema rules
                if (dt.Schema.Width > Kusto.Language.Editor.KustoFormatter.ArbitraryMaxSingleLineSchemaWidth || Kusto.Language.Editor.KustoFormatter.SpansMultipleLines(dt.Schema)) {
                    this.AddBrackettingStyleRules(dt.Schema.OpenParen, dt.Schema.CloseParen, relativeTo);

                    for (var i = 0; i < dt.Schema.Columns.Count; i = (i + 1) | 0) {
                        var token = dt.Schema.Columns.getItem$1(i).GetFirstToken();
                        this.AddRule$2(token, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine));
                        this.AddRule(token, this.IndentRule(relativeTo));
                    }
                }

                // add value rules
                var valueColumns = schemaColumns > 1 ? schemaColumns : Kusto.Language.Editor.KustoFormatter.GetBalancedColumnCount(dt.Values);

                this.AddBrackettingStyleRules(dt.OpenBracket, dt.CloseBracket, relativeTo);

                // place rows of values on separate lines
                for (var i1 = 0; i1 < dt.Values.Count; i1 = (i1 + 1) | 0) {
                    var token1 = dt.Values.getItem$1(i1).Element$1.GetFirstToken();
                    if (token1 != null) {
                        if ((i1 % valueColumns) === 0) {
                            this.AddRule$2(token1, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine));
                            this.AddRule(token1, this.IndentRule(relativeTo));
                        } else {
                            this.AddRule$2(token1, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpace));
                        }
                    }
                }
            },
            AddBrackettingStyleRules: function (open, close, alignedTo) {
                switch (this._options.BrackettingStyle) {
                    case Kusto.Language.Editor.BrackettingStyle.Vertical: 
                        this.AddRule$2(open, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, Bridge.fn.bind(this, function () {
                            return this.SpansOrWillSpanMultipleLines$1(open, close, true, open);
                        })).Otherwise(Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine)));
                        var next = open.GetNextToken();
                        if (next != null && !Bridge.referenceEquals(next, close)) {
                            this.AddRule$2(next, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine));
                        }
                        this.AddRule(open, new Kusto.Language.Editor.KustoFormatter.AlignmentRule.ctor(alignedTo));
                        this.AddRule$2(close, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, Bridge.fn.bind(this, function () {
                            return this.SpansOrWillSpanMultipleLines$1(open, close, true, close);
                        })).Otherwise(Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine)));
                        this.AddRule(close, new Kusto.Language.Editor.KustoFormatter.AlignmentRule.ctor(alignedTo));
                        break;
                    case Kusto.Language.Editor.BrackettingStyle.Diagonal: 
                        this.AddRule$2(open, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpace));
                        next = open.GetNextToken();
                        if (next != null && !Bridge.referenceEquals(next, close)) {
                            this.AddRule$2(next, Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine));
                        }
                        this.AddRule$2(close, new Kusto.Language.Editor.KustoFormatter.SpacingRule(Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine, Bridge.fn.bind(this, function () {
                            return this.SpansOrWillSpanMultipleLines$1(open, close, true, close);
                        })).Otherwise(Kusto.Language.Editor.KustoFormatter.SpacingRule.From(Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpaceIfOnSameLine)));
                        this.AddRule(close, new Kusto.Language.Editor.KustoFormatter.AlignmentRule.ctor(alignedTo));
                        break;
                }
            },
            /**
             * Create and indentation (alignment) rule.
             If the relativeTo item is specified, the resulting alignment will be relative to this items alignment.
             If the relaetiveTo item is not specified, the resulting alignment will be relative to the current alignment.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxElement}                   relativeTo
             * @return  {Kusto.Language.Editor.KustoFormatter.AlignmentRule}
             */
            IndentRule: function (relativeTo) {
                if (relativeTo === void 0) { relativeTo = null; }
                return new Kusto.Language.Editor.KustoFormatter.AlignmentRule.ctor(relativeTo, this._options.IndentationSize);
            },
            /**
             * Add a spacing rule for the first token of the specified node.
             If a spacing rule already exists, this one takes precidence.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxNode}                    node    
             * @param   {Kusto.Language.Editor.KustoFormatter.SpacingRule}    rule
             * @return  {void}
             */
            AddRule$1: function (node, rule) {
                if (node != null) {
                    this.AddRule$2(node.GetFirstToken(), rule);
                }
            },
            /**
             * Add a spacing rule for the specified token.
             If a spacing rule already exists, this one takes precidence.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxToken}                   token    
             * @param   {Kusto.Language.Editor.KustoFormatter.SpacingRule}    rule
             * @return  {void}
             */
            AddRule$2: function (token, rule) {
                if (token != null) {
                    var existingRule = { };
                    if (this._spacingRules.tryGetValue(token, existingRule)) {
                        // chain rules together so more specific rule gets applied after more general rule
                        rule = rule.Otherwise(existingRule.v);
                    }

                    this._spacingRules.setItem(token, rule);
                }
            },
            AddRule: function (element, rule) {
                if (element != null) {
                    this._alignmentRules.setItem(element, rule);
                }
            },
            /**
             * Returns true if the tokens are currently or will end up on different lines.
             Returns null if the outcome is unknown due to cyclic dependencies between formatting rules.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxToken}    first        
             * @param   {Kusto.Language.Syntax.SyntaxToken}    last         
             * @param   {boolean}                              inclusive    
             * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
             * @return  {boolean}
             */
            SpansOrWillSpanMultipleLines$1: function (first, last, inclusive, excluded) {
                if (inclusive === void 0) { inclusive = false; }
                if (excluded === void 0) { excluded = null; }
                if (Kusto.Language.Editor.KustoFormatter.SpansMultipleLines$1(first, last, inclusive, excluded)) {
                    return true;
                }

                return this.WillSpanMultipleLines$1(first, last, inclusive, excluded);
            },
            /**
             * Returns true if the tokens of the node are currently or will end up on different lines.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxNode}     node         
             * @param   {boolean}                              inclusive    
             * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
             * @return  {boolean}
             */
            SpansOrWillSpanMultipleLines: function (node, inclusive, excluded) {
                if (inclusive === void 0) { inclusive = false; }
                if (excluded === void 0) { excluded = null; }
                if (Kusto.Language.Editor.KustoFormatter.SpansMultipleLines(node, inclusive, excluded)) {
                    return true;
                }

                return this.WillSpanMultipleLines(node, inclusive, excluded);
            },
            /**
             * Returns true if the tokens will end up on different lines.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxToken}    first        
             * @param   {Kusto.Language.Syntax.SyntaxToken}    last         
             * @param   {boolean}                              inclusive    
             * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
             * @return  {boolean}
             */
            WillSpanMultipleLines$1: function (first, last, inclusive, excluded) {
                if (inclusive === void 0) { inclusive = false; }
                if (excluded === void 0) { excluded = null; }
                if (first != null && last != null) {
                    if (inclusive && !Bridge.referenceEquals(first, excluded) && this.WillHaveLineBreak(first)) {
                        return true;
                    }

                    var token = first.GetNextToken();
                    while (token != null) {
                        if (!Bridge.referenceEquals(token, excluded) && this.WillHaveLineBreak(token)) {
                            return true;
                        }

                        if (Bridge.referenceEquals(token, last)) {
                            break;
                        }

                        token = token.GetNextToken();
                    }
                }

                return false;
            },
            /**
             * Returns true if the tokens of the node will end up on different lines.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxNode}     node         
             * @param   {boolean}                              inclusive    
             * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
             * @return  {boolean}
             */
            WillSpanMultipleLines: function (node, inclusive, excluded) {
                if (inclusive === void 0) { inclusive = false; }
                if (excluded === void 0) { excluded = null; }
                if (node != null) {
                    var first = node.GetFirstToken();
                    var last = node.GetLastToken();
                    return this.WillSpanMultipleLines$1(first, last, inclusive, excluded);
                }

                return false;
            },
            /**
             * Returns true if the token's trivia will end up with at least one line break.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxToken}    token
             * @return  {boolean}
             */
            WillHaveLineBreak: function (token) {
                if (Kusto.Language.Parsing.TextFacts.HasLineBreaks(token.Trivia)) {
                    return !this.WillHaveLineBreakRemoved(token);
                } else {
                    return this.WillHaveLineBreakAdded(token);
                }
            },
            /**
             * Returns true if the token's trivia definitely will have a line break added.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxToken}    token
             * @return  {boolean}
             */
            WillHaveLineBreakAdded: function (token) {
                var s = { };
                if (this._spacingRules.tryGetValue(token, s)) {
                    return s.v.GetKind() === Kusto.Language.Editor.KustoFormatter.SpacingKind.NewLine;
                }

                return false;
            },
            /**
             * Returns true if the token's trivia will definitely have its line breaks removed.
             *
             * @instance
             * @private
             * @this Kusto.Language.Editor.KustoFormatter
             * @memberof Kusto.Language.Editor.KustoFormatter
             * @param   {Kusto.Language.Syntax.SyntaxToken}    token
             * @return  {boolean}
             */
            WillHaveLineBreakRemoved: function (token) {
                var s = { };
                if (this._spacingRules.tryGetValue(token, s)) {
                    var kind = s.v.GetKind();
                    return kind === Kusto.Language.Editor.KustoFormatter.SpacingKind.NoSpace || kind === Kusto.Language.Editor.KustoFormatter.SpacingKind.SingleSpace;
                }

                return false;
            }
        }
    });

    /**
     * A formatting rule that determines the relative alignment between syntax elements
     when they appear on separate lines.
     *
     * @private
     * @class Kusto.Language.Editor.KustoFormatter.AlignmentRule
     */
    Bridge.define("Kusto.Language.Editor.KustoFormatter.AlignmentRule", {
        $kind: "nested class",
        props: {
            /**
             * The element to align relative to.
             If this value is null, alignment is relative to the current default.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.KustoFormatter.AlignmentRule
             * @function RelativeToElement
             * @type Kusto.Language.Syntax.SyntaxElement
             */
            RelativeToElement: null,
            /**
             * The relative indentation (number of spaces to indent/exdent?).
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.KustoFormatter.AlignmentRule
             * @function IndentationDelta
             * @type number
             */
            IndentationDelta: 0
        },
        ctors: {
            ctor: function (relativeTo, indentationDelta) {
                if (indentationDelta === void 0) { indentationDelta = 0; }

                this.$initialize();
                this.RelativeToElement = relativeTo;
                this.IndentationDelta = indentationDelta;
            },
            $ctor1: function (indentationDelta) {
                Kusto.Language.Editor.KustoFormatter.AlignmentRule.ctor.call(this, null, indentationDelta);
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoFormatter.ComputationState", {
        $kind: "nested enum",
        statics: {
            fields: {
                Uncomputed: 0,
                Computing: 1,
                Computed: 2
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoFormatter.SpacingKind", {
        $kind: "nested enum",
        statics: {
            fields: {
                /**
                 * Spacing is unknown.  This value is not used.
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 0
                 * @type number
                 */
                Unknown: 0,
                /**
                 * Leave spacing as is.
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 2
                 * @type number
                 */
                AsIs: 2,
                /**
                 * Align leading spacing between tokens if they are on separate lines
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 4
                 * @type number
                 */
                AlignOnly: 4,
                /**
                 * No space between tokens
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 8
                 * @type number
                 */
                NoSpace: 8,
                /**
                 * No space between tokens if they are on the same line.
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 16
                 * @type number
                 */
                NoSpaceIfOnSameLine: 16,
                /**
                 * A single space between tokens.
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 32
                 * @type number
                 */
                SingleSpace: 32,
                /**
                 * A single space between tokens if they are on the same line.
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 64
                 * @type number
                 */
                SingleSpaceIfOnSameLine: 64,
                /**
                 * A single new line between tokens if they are on the same line
                 *
                 * @static
                 * @public
                 * @memberof number
                 * @constant
                 * @default 128
                 * @type number
                 */
                NewLine: 128
            }
        },
        $flags: true
    });

    /**
     * A formating rule that dictates the spacing/trivia between tokens.
     *
     * @private
     * @class Kusto.Language.Editor.KustoFormatter.SpacingRule
     */
    Bridge.define("Kusto.Language.Editor.KustoFormatter.SpacingRule", {
        $kind: "nested class",
        statics: {
            fields: {
                s_spacings: null
            },
            ctors: {
                ctor: function () {
                    var nSpacings = 129;
                    Kusto.Language.Editor.KustoFormatter.SpacingRule.s_spacings = System.Array.init(nSpacings, null, Kusto.Language.Editor.KustoFormatter.SpacingRule);

                    for (var i = 0; i < nSpacings; i = (i + 1) | 0) {
                        Kusto.Language.Editor.KustoFormatter.SpacingRule.s_spacings[System.Array.index(i, Kusto.Language.Editor.KustoFormatter.SpacingRule.s_spacings)] = new Kusto.Language.Editor.KustoFormatter.SpacingRule(i, null, null);
                    }
                }
            },
            methods: {
                From: function (kind) {
                    return Kusto.Language.Editor.KustoFormatter.SpacingRule.s_spacings[System.Array.index(kind, Kusto.Language.Editor.KustoFormatter.SpacingRule.s_spacings)];
                }
            }
        },
        fields: {
            /**
             * The kind of spacing triggered by the condition
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Editor.KustoFormatter.SpacingRule
             * @type number
             */
            _kind: 0,
            /**
             * The next rule to apply if this rule does not apply.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Editor.KustoFormatter.SpacingRule
             * @type Kusto.Language.Editor.KustoFormatter.SpacingRule
             */
            _otherwise: null,
            /**
             * The rule is only applied when the condition evalutes to true.
             *
             * @instance
             * @private
             * @readonly
             * @memberof Kusto.Language.Editor.KustoFormatter.SpacingRule
             * @type System.Func
             */
            _condition: null,
            _computeState: 0,
            _computedKind: 0
        },
        ctors: {
            ctor: function (kind, condition, otherwise) {
                if (otherwise === void 0) { otherwise = null; }

                this.$initialize();
                this._kind = kind;
                this._otherwise = otherwise;
                this._condition = condition;
            }
        },
        methods: {
            GetKind: function () {
                if (Bridge.staticEquals(this._condition, null)) {
                    return this._kind;
                }

                switch (this._computeState) {
                    case Kusto.Language.Editor.KustoFormatter.ComputationState.Computing: 
                        return this.GetPossibleKinds();
                    case Kusto.Language.Editor.KustoFormatter.ComputationState.Uncomputed: 
                        // avoids recursion during computation
                        this._computeState = Kusto.Language.Editor.KustoFormatter.ComputationState.Computing;
                        if (this._condition()) {
                            this._computedKind = this._kind;
                        } else if (this._otherwise != null) {
                            this._computedKind = this._otherwise.GetKind();
                        } else {
                            this._computedKind = Kusto.Language.Editor.KustoFormatter.SpacingKind.AlignOnly;
                        }
                        this._computeState = Kusto.Language.Editor.KustoFormatter.ComputationState.Computed;
                        break;
                }

                return this._computedKind;
            },
            GetPossibleKinds: function () {
                if (!Bridge.staticEquals(this._condition, null)) {
                    if (this._otherwise != null) {
                        return this._kind | this._otherwise.GetPossibleKinds();
                    } else {
                        return this._kind | Kusto.Language.Editor.KustoFormatter.SpacingKind.AlignOnly;
                    }
                } else {
                    return this._kind;
                }
            },
            /**
             * Create a new {@link } that applies another rule if this rule does not apply.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.KustoFormatter.SpacingRule
             * @memberof Kusto.Language.Editor.KustoFormatter.SpacingRule
             * @param   {Kusto.Language.Editor.KustoFormatter.SpacingRule}    rule
             * @return  {Kusto.Language.Editor.KustoFormatter.SpacingRule}
             */
            Otherwise: function (rule) {
                if (Bridge.staticEquals(this._condition, null)) {
                    // this rule is unconditional, so it will never fallback to otherwise, so just return same rule.
                    return this;
                } else if (this._otherwise == null) {
                    return new Kusto.Language.Editor.KustoFormatter.SpacingRule(this._kind, this._condition, rule);
                } else if (Bridge.staticEquals(this._otherwise._condition, null) && !Bridge.staticEquals(rule._condition, null)) {
                    // if this rule's otherwise is unconditional, but the new rule is conditional, then 
                    // insert the new rule between this rule and the existing unconditional otherwise.
                    return new Kusto.Language.Editor.KustoFormatter.SpacingRule(this._kind, this._condition, rule.Otherwise(this._otherwise));
                } else {
                    // otherwise, attempt to chain the new rule after this rule's otherwise
                    return new Kusto.Language.Editor.KustoFormatter.SpacingRule(this._kind, this._condition, this._otherwise.Otherwise(rule));
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoQuickInfoBuilder", {
        statics: {
            methods: {
                GetQuickInfoKind: function (severity) {
                    switch (severity) {
                        case Kusto.Language.DiagnosticSeverity.Error: 
                            return Kusto.Language.Editor.QuickInfoKind.Error;
                        case Kusto.Language.DiagnosticSeverity.Warning: 
                            return Kusto.Language.Editor.QuickInfoKind.Warning;
                        case Kusto.Language.DiagnosticSeverity.Suggestion: 
                            return Kusto.Language.Editor.QuickInfoKind.Suggestion;
                        default: 
                            return Kusto.Language.Editor.QuickInfoKind.Text;
                    }
                }
            }
        },
        fields: {
            _service: null,
            _code: null,
            _options: null,
            _disabled: null
        },
        ctors: {
            ctor: function (service, code, options) {
                this.$initialize();
                this._service = service;
                this._code = code;
                this._options = options;
                this._disabled = new Kusto.Language.Editor.DisabledDiagnostics.$ctor1(this._options.DisabledDiagnostics);
            }
        },
        methods: {
            /**
             * Gets the quick info for the item near the specified text position.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.KustoQuickInfoBuilder
             * @memberof Kusto.Language.Editor.KustoQuickInfoBuilder
             * @param   {number}                                    position             
             * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
             * @return  {Kusto.Language.Editor.QuickInfo}
             */
            GetQuickInfo: function (position, cancellationToken) {
                if (this._code.HasSemantics) {
                    var builder = new System.Text.StringBuilder();

                    var symbolInfo = this.GetSymbolInfo$1(position) || this.GetSyntaxInfo(position);
                    var diagnosticInfo = this.GetDiagnosticInfo(position, cancellationToken);

                    if (symbolInfo != null) {
                        if (diagnosticInfo != null) {
                            return new Kusto.Language.Editor.QuickInfo.ctor([symbolInfo, diagnosticInfo]);
                        } else {
                            return new Kusto.Language.Editor.QuickInfo.ctor([symbolInfo]);
                        }
                    } else if (diagnosticInfo != null) {
                        return new Kusto.Language.Editor.QuickInfo.ctor([diagnosticInfo]);
                    }
                }

                return Kusto.Language.Editor.QuickInfo.Empty;
            },
            GetSymbolInfo$1: function (position) {
                var token = this._code.Syntax.GetTokenAt(position);
                if (token != null && position >= token.TextStart) {
                    var node;
                    if (((node = token.Parent)) != null) {
                        var expr = node.GetFirstAncestorOrSelf(Kusto.Language.Syntax.Expression);

                        if (node.ReferencedSymbol != null && !Bridge.referenceEquals(expr, node)) {
                            return this.GetSymbolInfo(node.ReferencedSymbol, null);
                        } else if (expr != null) {
                            if (expr.IsLiteral) {
                                var br;
                                if (((br = Bridge.as(expr.Parent, Kusto.Language.Syntax.BracketedExpression))) != null) {
                                    // special case for ['column name']
                                    expr = br;
                                } else if (expr.ResultType != null && expr.ResultType.IsScalar) {
                                    return this.GetSymbolInfo(expr.ResultType, expr.ResultType, Kusto.Language.Editor.QuickInfoKind.Literal);
                                }
                            }

                            return this.GetSymbolInfo(expr.ReferencedSymbol, expr.ResultType);
                        }
                    }
                }

                return null;
            },
            GetSymbolInfo: function (symbol, type, itemKind) {
                if (itemKind === void 0) { itemKind = null; }
                if (symbol != null) {
                    var texts = new (System.Collections.Generic.List$1(Kusto.Language.Editor.ClassifiedText)).ctor();
                    Kusto.Language.Editor.SymbolDisplay.GetSymbolDisplay(symbol, type, texts);

                    if (itemKind == null) {
                        itemKind = this.GetItemKind(symbol);
                    }

                    return new Kusto.Language.Editor.QuickInfoItem.$ctor1(System.Nullable.getValue(itemKind), texts);
                } else {
                    return null;
                }
            },
            GetItemKind: function (symbol) {
                do {
                    if (Bridge.is(symbol, Kusto.Language.Symbols.ClusterSymbol)) {
                        var _discard1 = Bridge.cast(symbol, Kusto.Language.Symbols.ClusterSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Cluster;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.ColumnSymbol)) {
                        var _discard2 = Bridge.cast(symbol, Kusto.Language.Symbols.ColumnSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Column;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.DatabaseSymbol)) {
                        var _discard3 = Bridge.cast(symbol, Kusto.Language.Symbols.DatabaseSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Database;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.FunctionSymbol)) {
                        var f = Bridge.cast(symbol, Kusto.Language.Symbols.FunctionSymbol);
                        if (this._code.Globals.IsBuiltInFunction(f)) {
                            return Kusto.Language.Editor.QuickInfoKind.BuiltInFunction;
                        } else if (this._code.Globals.IsDatabaseFunction(f)) {
                            return Kusto.Language.Editor.QuickInfoKind.DatabaseFunction;
                        } else {
                            return Kusto.Language.Editor.QuickInfoKind.LocalFunction;
                        }
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.OperatorSymbol)) {
                        var _discard4 = Bridge.cast(symbol, Kusto.Language.Symbols.OperatorSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Operator;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.ParameterSymbol)) {
                        var _discard5 = Bridge.cast(symbol, Kusto.Language.Symbols.ParameterSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Parameter;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.PatternSymbol)) {
                        var _discard6 = Bridge.cast(symbol, Kusto.Language.Symbols.PatternSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Pattern;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.TableSymbol)) {
                        var _discard7 = Bridge.cast(symbol, Kusto.Language.Symbols.TableSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Table;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.VariableSymbol)) {
                        var v = Bridge.cast(symbol, Kusto.Language.Symbols.VariableSymbol);
                        if (Bridge.is(v.Type, Kusto.Language.Symbols.FunctionSymbol) || Bridge.is(v.Type, Kusto.Language.Symbols.PatternSymbol) || Bridge.is(v.Type, Kusto.Language.Symbols.TableSymbol) || Bridge.is(v.Type, Kusto.Language.Symbols.ScalarSymbol)) {
                            return this.GetItemKind(v.Type);
                        } else {
                            return Kusto.Language.Editor.QuickInfoKind.Variable;
                        }
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.ScalarSymbol)) {
                        var _discard8 = Bridge.cast(symbol, Kusto.Language.Symbols.ScalarSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Type;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.CommandSymbol)) {
                        var _discard9 = Bridge.cast(symbol, Kusto.Language.Symbols.CommandSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Command;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.OptionSymbol)) {
                        var _discard10 = Bridge.cast(symbol, Kusto.Language.Symbols.OptionSymbol);
                        return Kusto.Language.Editor.QuickInfoKind.Option;
                    }

                    if (Bridge.is(symbol, Kusto.Language.Symbols.GroupSymbol)) {
                        var gs = Bridge.cast(symbol, Kusto.Language.Symbols.GroupSymbol);
                        if (System.Array.getCount(gs.Members, Kusto.Language.Symbols.Symbol) > 0) {
                            return this.GetItemKind(System.Array.getItem(gs.Members, 0, Kusto.Language.Symbols.Symbol));
                        }
                        return Kusto.Language.Editor.QuickInfoKind.Text;
                    }

                    {
                        return Kusto.Language.Editor.QuickInfoKind.Text;
                    }
                } while (false);
            },
            GetSyntaxInfo: function (position) {
                // place holder for adding information for the current grammar
                return null;
            },
            GetDiagnosticInfo: function (position, cancellationToken) {
                var $t;
                var diagnostics = System.Linq.Enumerable.from(this._service.GetDiagnostics(false, cancellationToken), Kusto.Language.Diagnostic).concat(this._service.GetAnalyzerDiagnostics(void 0, false, cancellationToken)).where(Bridge.fn.bind(this, function (dx) {
                    return this._disabled.IsDiagnosticEnabled(dx);
                }));

                var bestDx = null;

                $t = Bridge.getEnumerator(diagnostics);
                try {
                    while ($t.moveNext()) {
                        var d = $t.Current;
                        var end = d.End > d.Start ? d.End : ((d.End + 1) | 0);
                        if (position >= d.Start && position < end) {
                            // a later matching diagnostic is better if it starts closer to the position
                            if (bestDx == null || d.Start > bestDx.Start) {
                                bestDx = d;
                            }
                        }
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                if (bestDx != null) {
                    return new Kusto.Language.Editor.QuickInfoItem.$ctor2(Kusto.Language.Editor.KustoQuickInfoBuilder.GetQuickInfoKind(bestDx.Severity), bestDx.Message);
                }

                return null;
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.KustoRelatedElementFinder", {
        statics: {
            methods: {
                IsPartOfNameReferenceOrDeclaration: function (token) {
                    var name = token.Parent.GetFirstAncestorOrSelf(Kusto.Language.Syntax.Name);
                    return name != null && (Bridge.is(name.Parent, Kusto.Language.Syntax.NameReference) || Bridge.is(name.Parent, Kusto.Language.Syntax.NameDeclaration));
                },
                /**
                 * Returns true if the symbol of element <b />
                 is equal to <b />
                 *
                 * @static
                 * @private
                 * @this Kusto.Language.Editor.KustoRelatedElementFinder
                 * @memberof Kusto.Language.Editor.KustoRelatedElementFinder
                 * @param   {Kusto.Language.Symbols.Symbol}               symbol     
                 * @param   {Kusto.Language.Syntax.SyntaxElement}         element    
                 * @param   {Kusto.Language.Editor.FindRelatedOptions}    options
                 * @return  {boolean}
                 */
                AreSymbolsEqual: function (symbol, element, options) {
                    var canSee = (options & Kusto.Language.Editor.FindRelatedOptions.SeeThroughVariables) !== 0;
                    var n;
                    var d;
                    return (((n = Bridge.as(element, Kusto.Language.Syntax.NameReference))) != null && (Bridge.referenceEquals(n.ReferencedSymbol, symbol) || (canSee && Bridge.referenceEquals(n.ReferencedSymbol, Kusto.Language.Symbols.Symbol.GetExpressionResultType(symbol))))) || (((d = Bridge.as(element, Kusto.Language.Syntax.NameDeclaration))) != null && (Bridge.referenceEquals(d.ReferencedSymbol, symbol) || (canSee && Bridge.referenceEquals(Kusto.Language.Symbols.Symbol.GetExpressionResultType(d.ReferencedSymbol), symbol))));
                }
            }
        },
        fields: {
            _code: null
        },
        ctors: {
            ctor: function (code) {
                this.$initialize();
                this._code = code;
            }
        },
        methods: {
            FindRelatedElements: function (position, options) {
                if (options === void 0) { options = 0; }
                var token = this._code.Syntax.GetTokenAt(position);

                if (token == null || position > token.TriviaStart && position < ((token.TextStart - 1) | 0)) {
                    // position is inside trivia and not attached to any token.
                    return Kusto.Language.Editor.RelatedInfo.Empty;
                }

                var prev = token != null ? token.GetPreviousToken() : null;

                if (position === token.TriviaStart) {
                    if (token.Trivia.length > 0 || (prev != null && this.IsRelatable(prev) && !this.IsRelatable(token))) {
                        token = token.GetPreviousToken();
                    }
                }

                if (token == null) {
                    return Kusto.Language.Editor.RelatedInfo.Empty;
                }

                var elements = new (System.Collections.Generic.List$1(Kusto.Language.Editor.RelatedElement)).ctor();

                if (this.IsBracket(token)) {
                    this.GetRelatedBrackets(token, elements);
                } else if (Kusto.Language.Editor.KustoRelatedElementFinder.IsPartOfNameReferenceOrDeclaration(token)) {
                    this.GetRelatedNameReferencesAndDeclarations(token, elements, options);
                }

                if (elements.Count > 1) {
                    var current = System.Linq.Enumerable.from(elements, Kusto.Language.Editor.RelatedElement).firstOrDefault(function (r) {
                            return r.Start === token.TextStart;
                        }, null);
                    if (current != null) {
                        var currentIndex = elements.indexOf(current);
                        return new Kusto.Language.Editor.RelatedInfo(elements, currentIndex);
                    }
                }

                return Kusto.Language.Editor.RelatedInfo.Empty;
            },
            IsRelatable: function (token) {
                return this.IsBracket(token) || Kusto.Language.Editor.KustoRelatedElementFinder.IsPartOfNameReferenceOrDeclaration(token);
            },
            IsBracket: function (token) {
                switch (token.Text) {
                    case "{": 
                    case "}": 
                    case "(": 
                    case ")": 
                        return true;
                    case "[": 
                    case "]": 
                        return !Kusto.Language.Editor.KustoRelatedElementFinder.IsPartOfNameReferenceOrDeclaration(token);
                    default: 
                        return false;
                }
            },
            GetRelatedBrackets: function (token, elements) {
                switch (token.Text) {
                    case "{": 
                        this.GetNextTokenReference(token, "}", elements);
                        break;
                    case "}": 
                        this.GetPreviousTokenReference(token, "{", elements);
                        break;
                    case "(": 
                        this.GetNextTokenReference(token, ")", elements);
                        break;
                    case ")": 
                        this.GetPreviousTokenReference(token, "(", elements);
                        break;
                    case "[": 
                        this.GetNextTokenReference(token, "]", elements);
                        break;
                    case "]": 
                        this.GetPreviousTokenReference(token, "[", elements);
                        break;
                }
            },
            GetNextTokenReference: function (token, matchingText, elements) {
                var parent = token.Parent;
                var index = parent.GetChildIndex(token);

                for (var i = (index + 1) | 0, n = parent.ChildCount; i < n; i = (i + 1) | 0) {
                    var child = parent.GetChild(i);
                    var t;
                    if (((t = Bridge.as(child, Kusto.Language.Syntax.SyntaxToken))) != null && Bridge.referenceEquals(t.Text, matchingText)) {
                        elements.add(new Kusto.Language.Editor.RelatedElement.ctor(token.TextStart, token.Text.length, Kusto.Language.Editor.RelatedElementKind.Syntax));
                        elements.add(new Kusto.Language.Editor.RelatedElement.ctor(t.TextStart, t.Text.length, Kusto.Language.Editor.RelatedElementKind.Syntax));
                        return;
                    }
                }
            },
            GetPreviousTokenReference: function (token, matchingText, elements) {
                var parent = token.Parent;
                var index = parent.GetChildIndex(token);

                for (var i = (index - 1) | 0; i >= 0; i = (i - 1) | 0) {
                    var child = parent.GetChild(i);
                    var t;
                    if (((t = Bridge.as(child, Kusto.Language.Syntax.SyntaxToken))) != null && Bridge.referenceEquals(t.Text, matchingText)) {
                        elements.add(new Kusto.Language.Editor.RelatedElement.ctor(t.TextStart, t.Text.length, Kusto.Language.Editor.RelatedElementKind.Syntax));
                        elements.add(new Kusto.Language.Editor.RelatedElement.ctor(token.TextStart, token.Text.length, Kusto.Language.Editor.RelatedElementKind.Syntax));
                        return;
                    }
                }
            },
            GetRelatedNameReferencesAndDeclarations: function (token, elements, options) {
                var $t;
                var symbol = ($t = token.Parent.GetFirstAncestorOrSelf(Kusto.Language.Syntax.SyntaxNode, function (n) {
                        return n.ReferencedSymbol != null;
                    })) != null ? $t.ReferencedSymbol : null;

                if (symbol != null) {
                    this._code.Syntax.WalkElements(function (e) {
                        if (Kusto.Language.Editor.KustoRelatedElementFinder.AreSymbolsEqual(symbol, e, options)) {
                            var kind = new Kusto.Language.Editor.RelatedElementKind();

                            if (Bridge.is(e, Kusto.Language.Syntax.NameDeclaration)) {
                                kind = Kusto.Language.Editor.RelatedElementKind.Declaration;
                            } else if (Bridge.is(e, Kusto.Language.Syntax.NameReference)) {
                                kind = Kusto.Language.Editor.RelatedElementKind.Reference;
                            } else {
                                kind = Kusto.Language.Editor.RelatedElementKind.Other;
                            }

                            elements.add(new Kusto.Language.Editor.RelatedElement.$ctor1(e.TextStart, e.Width, kind, e.TextStart, e.TextStart));
                        }
                    });
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.MinimalTextKind", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * Removes only whitespace and comments before the start of the query
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.MinimalTextKind
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.MinimalTextKind
                 */
                RemoveLeadingWhitespaceAndComments: 0,
                /**
                 * Removes all whitespace before the query, removes all comments and reduces
                 remaining whitespace to a single space or line break between tokens.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.MinimalTextKind
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.MinimalTextKind
                 */
                MinimizeWhitespaceAndRemoveComments: 1,
                /**
                 * Removes all whitespace before and after the query, removes all comments,
                 and reduces any remaining whitespace to a single space between tokens.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.MinimalTextKind
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Editor.MinimalTextKind
                 */
                SingleLine: 2
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.OutlineInfo", {
        statics: {
            fields: {
                Empty: null
            },
            ctors: {
                init: function () {
                    this.Empty = new Kusto.Language.Editor.OutlineInfo(null);
                }
            }
        },
        props: {
            Ranges: null
        },
        ctors: {
            ctor: function (ranges) {
                this.$initialize();
                this.Ranges = ranges || Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Editor.OutlineRange).Instance;
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.OutlineRange", {
        props: {
            /**
             * The start of the outline range.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.OutlineRange
             * @function Start
             * @type number
             */
            Start: 0,
            /**
             * The length of the outline range.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.OutlineRange
             * @function Length
             * @type number
             */
            Length: 0,
            /**
             * The text to show when the range is collapsed.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.OutlineRange
             * @function CollapsedText
             * @type string
             */
            CollapsedText: null
        },
        ctors: {
            ctor: function (start, length, collapsedText) {
                var $t;
                this.$initialize();
                this.Start = start;
                this.Length = length;
                this.CollapsedText = ($t = collapsedText, $t != null ? $t : "");
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.PlacementStyle", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * Do not adjust placement
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.PlacementStyle
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.PlacementStyle
                 */
                None: 0,
                /**
                 * Place on a new line always
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.PlacementStyle
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.PlacementStyle
                 */
                NewLine: 1,
                /**
                 * Place on a new line if other parts are already span multiple lines
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.PlacementStyle
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Editor.PlacementStyle
                 */
                Smart: 2
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.QuickInfo", {
        statics: {
            fields: {
                Empty: null
            },
            ctors: {
                init: function () {
                    this.Empty = new Kusto.Language.Editor.QuickInfo.$ctor1(null);
                }
            },
            methods: {
                GetKindText: function (kind) {
                    switch (kind) {
                        case Kusto.Language.Editor.QuickInfoKind.Text: 
                        default: 
                            return null;
                        case Kusto.Language.Editor.QuickInfoKind.Table: 
                            return "table";
                        case Kusto.Language.Editor.QuickInfoKind.Database: 
                            return "database";
                        case Kusto.Language.Editor.QuickInfoKind.Cluster: 
                            return "cluster";
                        case Kusto.Language.Editor.QuickInfoKind.Literal: 
                            return "literal";
                        case Kusto.Language.Editor.QuickInfoKind.Type: 
                            return "type";
                        case Kusto.Language.Editor.QuickInfoKind.Pattern: 
                            return "pattern";
                        case Kusto.Language.Editor.QuickInfoKind.Parameter: 
                            return "parameter";
                        case Kusto.Language.Editor.QuickInfoKind.Scalar: 
                            return "scalar";
                        case Kusto.Language.Editor.QuickInfoKind.Variable: 
                            return "variable";
                        case Kusto.Language.Editor.QuickInfoKind.LocalFunction: 
                        case Kusto.Language.Editor.QuickInfoKind.BuiltInFunction: 
                        case Kusto.Language.Editor.QuickInfoKind.DatabaseFunction: 
                            return "function";
                        case Kusto.Language.Editor.QuickInfoKind.Operator: 
                            return "operator";
                    }
                }
            }
        },
        fields: {
            _text: null
        },
        props: {
            Items: null,
            Text: {
                get: function () {
                    if (this._text == null) {
                        this._text = this.BuildText();
                    }

                    return this._text;
                }
            }
        },
        ctors: {
            $ctor2: function (text) {
                this.$initialize();
                this._text = text;
                this.Items = System.Array.init([new Kusto.Language.Editor.QuickInfoItem.$ctor2(Kusto.Language.Editor.QuickInfoKind.Text, text)], Kusto.Language.Editor.QuickInfoItem);
            },
            ctor: function (items) {
                if (items === void 0) { items = []; }

                Kusto.Language.Editor.QuickInfo.$ctor1.call(this, Bridge.cast(items, System.Collections.Generic.IEnumerable$1(Kusto.Language.Editor.QuickInfoItem)));
            },
            $ctor1: function (items) {
                this.$initialize();
                this.Items = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Editor.QuickInfoItem, items);
            }
        },
        methods: {
            BuildText: function () {
                var $t;
                var sb = new System.Text.StringBuilder();

                $t = Bridge.getEnumerator(this.Items, Kusto.Language.Editor.QuickInfoItem);
                try {
                    while ($t.moveNext()) {
                        var item = $t.Current;
                        if (sb.getLength() > 0) {
                            sb.append("\n\n");
                        }

                        var kindText = Kusto.Language.Editor.QuickInfo.GetKindText(item.Kind);
                        if (kindText != null) {
                            sb.append(String.fromCharCode(40)).append(kindText).append(") ");
                        }

                        sb.append(item.Text);
                    }
                } finally {
                    if (Bridge.is($t, System.IDisposable)) {
                        $t.System$IDisposable$Dispose();
                    }
                }

                return sb.toString();
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.QuickInfoItem", {
        fields: {
            _text: null
        },
        props: {
            Kind: 0,
            Parts: null,
            Text: {
                get: function () {
                    if (this._text == null) {
                        this._text = System.String.concat(Bridge.toArray(System.Linq.Enumerable.from(this.Parts, Kusto.Language.Editor.ClassifiedText).select(function (s) {
                                    return s.Text;
                                })));
                    }

                    return this._text;
                }
            }
        },
        ctors: {
            $ctor2: function (kind, text) {
                Kusto.Language.Editor.QuickInfoItem.ctor.call(this, kind, [new Kusto.Language.Editor.ClassifiedText.$ctor1(text)]);
            },
            ctor: function (kind, parts) {
                if (parts === void 0) { parts = []; }

                Kusto.Language.Editor.QuickInfoItem.$ctor1.call(this, kind, Bridge.cast(parts, System.Collections.Generic.IEnumerable$1(Kusto.Language.Editor.ClassifiedText)));
            },
            $ctor1: function (kind, parts) {
                this.$initialize();
                this.Kind = kind;
                this.Parts = Kusto.Language.Utils.ListExtensions.ToReadOnly(Kusto.Language.Editor.ClassifiedText, parts);
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.QuickInfoKind", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * The {@link } is general text.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Text: 0,
                /**
                 * The {@link } is an error diagnostic.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Error: 1,
                /**
                 * The {@link } is a warning diagnostic.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Warning: 2,
                /**
                 * The {@link } is a suggestion diagnostic.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 3
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Suggestion: 3,
                /**
                 * The {@link } is a column name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 4
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Column: 4,
                /**
                 * The {@link } is a table name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 5
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Table: 5,
                /**
                 * The {@link } is a database name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 6
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Database: 6,
                /**
                 * The {@link } is a cluster name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 7
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Cluster: 7,
                /**
                 * The {@link } is a literal value.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 8
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Literal: 8,
                /**
                 * The {@link } is a scalar type name.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 9
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Type: 9,
                /**
                 * The {@link } is a pattern name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 10
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Pattern: 10,
                /**
                 * The {@link } is a parameter name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 11
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Parameter: 11,
                /**
                 * The {@link } is a scalar variable name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 12
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Scalar: 12,
                /**
                 * The {@link } is a variable name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 13
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Variable: 13,
                /**
                 * The {@link } is a local function name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 14
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                LocalFunction: 14,
                /**
                 * The {@link } is a built in function name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 15
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                BuiltInFunction: 15,
                /**
                 * The {@link } is a database function name reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 16
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                DatabaseFunction: 16,
                /**
                 * The {@link } is a scalar operator reference.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 17
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Operator: 17,
                /**
                 * The {@link } is a control command.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 18
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Command: 18,
                /**
                 * The {@link } is a query option.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.QuickInfoKind
                 * @constant
                 * @default 19
                 * @type Kusto.Language.Editor.QuickInfoKind
                 */
                Option: 19
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.QuickInfoOptions", {
        statics: {
            fields: {
                Default: null
            },
            ctors: {
                init: function () {
                    this.Default = new Kusto.Language.Editor.QuickInfoOptions("");
                }
            }
        },
        props: {
            /**
             * A comma separated list of diagnostic codes that are disabled.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.QuickInfoOptions
             * @function DisabledDiagnostics
             * @type string
             */
            DisabledDiagnostics: null
        },
        ctors: {
            ctor: function (disabledDiagnostics) {
                var $t;
                this.$initialize();
                this.DisabledDiagnostics = ($t = disabledDiagnostics, $t != null ? $t : "");
            }
        },
        methods: {
            With: function (disabledDiagnostics) {
                var $t;
                if (disabledDiagnostics === void 0) { disabledDiagnostics = null; }
                var disdx = ($t = disabledDiagnostics, $t != null ? $t : this.DisabledDiagnostics);

                if (!Bridge.referenceEquals(disdx, this.DisabledDiagnostics)) {
                    return new Kusto.Language.Editor.QuickInfoOptions(disdx);
                } else {
                    return this;
                }
            },
            WithDisabledDiagnostics: function (disabledDiagnostics) {
                return this.With(disabledDiagnostics);
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.RelatedElementKind", {
        $kind: "enum",
        statics: {
            fields: {
                /**
                 * The element is a piece of syntax that is related to the other elements structurally.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.RelatedElementKind
                 * @constant
                 * @default 0
                 * @type Kusto.Language.Editor.RelatedElementKind
                 */
                Syntax: 0,
                /**
                 * The element is a named reference to a common item
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.RelatedElementKind
                 * @constant
                 * @default 1
                 * @type Kusto.Language.Editor.RelatedElementKind
                 */
                Reference: 1,
                /**
                 * The element is a named declaration of a common item
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.RelatedElementKind
                 * @constant
                 * @default 2
                 * @type Kusto.Language.Editor.RelatedElementKind
                 */
                Declaration: 2,
                /**
                 * The element is related to other elements, but does not name a common item.
                 *
                 * @static
                 * @public
                 * @memberof Kusto.Language.Editor.RelatedElementKind
                 * @constant
                 * @default 3
                 * @type Kusto.Language.Editor.RelatedElementKind
                 */
                Other: 3
            }
        }
    });

    /**
     * The elements in the code that are related to the element at a particular cursor position.
     *
     * @public
     * @class Kusto.Language.Editor.RelatedInfo
     */
    Bridge.define("Kusto.Language.Editor.RelatedInfo", {
        statics: {
            fields: {
                Empty: null
            },
            ctors: {
                init: function () {
                    this.Empty = new Kusto.Language.Editor.RelatedInfo(Kusto.Language.Utils.EmptyReadOnlyList$1(Kusto.Language.Editor.RelatedElement).Instance, 0);
                }
            }
        },
        props: {
            Elements: null,
            CurrentIndex: 0
        },
        ctors: {
            ctor: function (elements, currentIndex) {
                this.$initialize();
                this.Elements = elements;
                this.CurrentIndex = currentIndex;
            }
        },
        methods: {
            GetNextIndex: function (index) {
                if (index < ((System.Array.getCount(this.Elements, Kusto.Language.Editor.RelatedElement) - 1) | 0)) {
                    return ((index + 1) | 0);
                } else {
                    return 0;
                }
            },
            GetPreviousIndex: function (index) {
                if (index > 0) {
                    return ((index - 1) | 0);
                } else {
                    return ((System.Array.getCount(this.Elements, Kusto.Language.Editor.RelatedElement) - 1) | 0);
                }
            }
        }
    });

    Bridge.define("Kusto.Language.Editor.SymbolDisplay", {
        statics: {
            fields: {
                MaxColumns: 0
            },
            ctors: {
                init: function () {
                    this.MaxColumns = 7;
                }
            },
            methods: {
                GetSymbolDisplay: function (symbol, type, texts, showDescription) {
                    if (showDescription === void 0) { showDescription = true; }
                    var gs;
                    if (((gs = Bridge.as(symbol, Kusto.Language.Symbols.GroupSymbol))) != null) {
                        var lines = Math.min(System.Array.getCount(gs.Members, Kusto.Language.Symbols.Symbol), 5);

                        for (var i = 0; i < lines; i = (i + 1) | 0) {
                            var subsym = System.Array.getItem(gs.Members, i, Kusto.Language.Symbols.Symbol);
                            if (i > 0) {
                                texts.add(new Kusto.Language.Editor.ClassifiedText.$ctor1("\n"));
                            }

                            // TODO: get the correct types for the sub symbols
                            Kusto.Language.Editor.SymbolDisplay.GetSymbolDisplay(subsym, null, texts, false);
                        }

                        if (lines < System.Array.getCount(gs.Members, Kusto.Language.Symbols.Symbol)) {
                            texts.add(new Kusto.Language.Editor.ClassifiedText.$ctor1(System.String.format("\n+ ({0}) additional", [Bridge.box(((System.Array.getCount(gs.Members, Kusto.Language.Symbols.Symbol) - lines) | 0), System.Int32)])));
                        }
                    } else if (Bridge.is(symbol, Kusto.Language.Symbols.ScalarSymbol)) {
                        texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Identifier, symbol.Name));
                    } else {
                        var v;
                        if (((v = Bridge.as(symbol, Kusto.Language.Symbols.VariableSymbol))) != null && (Bridge.is(v.Type, Kusto.Language.Symbols.FunctionSymbol) || Bridge.is(v.Type, Kusto.Language.Symbols.PatternSymbol))) {
                            Kusto.Language.Editor.SymbolDisplay.GetSymbolDisplay(v.Type, type, texts);
                        } else if (symbol != null) {
                            var nameKind = Kusto.Language.Editor.SymbolDisplay.GetNameClassificationKind(symbol);
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(nameKind, symbol.Name));
                            var fs;
                            if (((fs = Bridge.as(symbol, Kusto.Language.Symbols.FunctionSymbol))) != null) {
                                // TODO: have this use the correct signature?
                                Kusto.Language.Editor.SymbolDisplay.GetSignatureDisplay(System.Array.getItem(fs.Signatures, 0, Kusto.Language.Symbols.Signature), texts);
                            }

                            var vs;
                            if (type == null && ((vs = Bridge.as(symbol, Kusto.Language.Symbols.VariableSymbol))) != null) {
                                type = vs.Type;
                            }

                            if (type != null && !Bridge.referenceEquals(type, Kusto.Language.Symbols.ScalarTypes.Unknown) && !type.IsError) {
                                texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ": "));
                                Kusto.Language.Editor.SymbolDisplay.GetTypeDisplay(type, texts);
                            }

                            if (showDescription) {
                                var description = Kusto.Language.Editor.SymbolDisplay.GetDescription(symbol);
                                if (!System.String.isNullOrEmpty(description)) {
                                    texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Comment, "\n\n" + (description || "")));
                                }
                            }
                        }
                    }
                },
                GetDescription: function (symbol) {
                    do {
                        if (Bridge.is(symbol, Kusto.Language.Symbols.TableSymbol)) {
                            var t = Bridge.cast(symbol, Kusto.Language.Symbols.TableSymbol);
                            return t.Description;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.ColumnSymbol)) {
                            var c = Bridge.cast(symbol, Kusto.Language.Symbols.ColumnSymbol);
                            return c.Description;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.ParameterSymbol)) {
                            var p = Bridge.cast(symbol, Kusto.Language.Symbols.ParameterSymbol);
                            return p.Description;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.FunctionSymbol)) {
                            var f = Bridge.cast(symbol, Kusto.Language.Symbols.FunctionSymbol);
                            return f.Description;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.OptionSymbol)) {
                            var o = Bridge.cast(symbol, Kusto.Language.Symbols.OptionSymbol);
                            return o.Description;
                        }

                        {
                            return "";
                        }
                    } while (false);
                },
                GetNameClassificationKind: function (symbol) {
                    do {
                        if (Bridge.is(symbol, Kusto.Language.Symbols.ColumnSymbol)) {
                            var _discard11 = Bridge.cast(symbol, Kusto.Language.Symbols.ColumnSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Column;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.DatabaseSymbol)) {
                            var _discard12 = Bridge.cast(symbol, Kusto.Language.Symbols.DatabaseSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Database;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.FunctionSymbol)) {
                            var _discard13 = Bridge.cast(symbol, Kusto.Language.Symbols.FunctionSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Function;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.OperatorSymbol)) {
                            var _discard14 = Bridge.cast(symbol, Kusto.Language.Symbols.OperatorSymbol);
                            return Kusto.Language.Editor.ClassificationKind.MathOperator;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.ParameterSymbol)) {
                            var _discard15 = Bridge.cast(symbol, Kusto.Language.Symbols.ParameterSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Parameter;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.PatternSymbol)) {
                            var _discard16 = Bridge.cast(symbol, Kusto.Language.Symbols.PatternSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Function; // TODO: need separate classification
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.TableSymbol)) {
                            var _discard17 = Bridge.cast(symbol, Kusto.Language.Symbols.TableSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Table;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.VariableSymbol)) {
                            var _discard18 = Bridge.cast(symbol, Kusto.Language.Symbols.VariableSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Variable;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.CommandSymbol)) {
                            var _discard19 = Bridge.cast(symbol, Kusto.Language.Symbols.CommandSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Command;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.OptionSymbol)) {
                            var _discard20 = Bridge.cast(symbol, Kusto.Language.Symbols.OptionSymbol);
                            return Kusto.Language.Editor.ClassificationKind.Option;
                        }

                        if (Bridge.is(symbol, Kusto.Language.Symbols.ScalarSymbol)) {
                            var s = Bridge.cast(symbol, Kusto.Language.Symbols.ScalarSymbol);
                            if (Bridge.referenceEquals(s, Kusto.Language.Symbols.ScalarTypes.String)) {
                                return Kusto.Language.Editor.ClassificationKind.StringLiteral;
                            } else {
                                return Kusto.Language.Editor.ClassificationKind.Literal;
                            }
                        }

                        {
                            return Kusto.Language.Editor.ClassificationKind.PlainText;
                        }
                    } while (false);
                },
                GetSignatureDisplay: function (sig, texts) {
                    texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "("));

                    for (var i = 0; i < System.Array.getCount(sig.Parameters, Kusto.Language.Symbols.Parameter); i = (i + 1) | 0) {
                        if (i > 0) {
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ", "));
                        }

                        var p = System.Array.getItem(sig.Parameters, i, Kusto.Language.Symbols.Parameter);

                        if (p.IsOptional) {
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "["));
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.SignatureParameter, p.Name));
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "]"));
                        } else {
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.SignatureParameter, p.Name));
                        }
                    }

                    if (sig.HasRepeatableParameters) {
                        texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ", "));
                        texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "..."));
                    }

                    texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ")"));
                },
                GetTypeDisplay: function (type, texts, useName) {
                    if (useName === void 0) { useName = false; }
                    var ts;
                    if (((ts = Bridge.as(type, Kusto.Language.Symbols.TableSymbol))) != null) {
                        if (useName && !System.String.isNullOrEmpty(ts.Name)) {
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Table, ts.Name));
                        } else {
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "("));

                            var maxCol = Math.min(Kusto.Language.Editor.SymbolDisplay.MaxColumns, System.Array.getCount(ts.Columns, Kusto.Language.Symbols.ColumnSymbol));
                            for (var i = 0; i < maxCol; i = (i + 1) | 0) {
                                if (i > 0) {
                                    texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ", "));
                                }

                                var col = System.Array.getItem(ts.Columns, i, Kusto.Language.Symbols.ColumnSymbol);
                                texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.SchemaMember, col.Name));
                            }

                            if (maxCol < System.Array.getCount(ts.Columns, Kusto.Language.Symbols.ColumnSymbol)) {
                                texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ", "));
                                texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "..."));
                            }

                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ")"));
                        }
                    } else {
                        var tus;
                        if (((tus = Bridge.as(type, Kusto.Language.Symbols.TupleSymbol))) != null) {
                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "{"));
                            var maxCol1 = Math.min(Kusto.Language.Editor.SymbolDisplay.MaxColumns, System.Array.getCount(tus.Columns, Kusto.Language.Symbols.ColumnSymbol));
                            for (var i1 = 0; i1 < maxCol1; i1 = (i1 + 1) | 0) {
                                if (i1 > 0) {
                                    texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ", "));
                                }

                                var col1 = System.Array.getItem(tus.Columns, i1, Kusto.Language.Symbols.ColumnSymbol);
                                texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Column, col1.Name));
                            }

                            if (maxCol1 < System.Array.getCount(tus.Columns, Kusto.Language.Symbols.ColumnSymbol)) {
                                texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, ", "));
                                texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "..."));
                            }

                            texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Punctuation, "}"));
                        } else {
                            var cs;
                            if (((cs = Bridge.as(type, Kusto.Language.Symbols.ClusterSymbol))) != null) {
                                texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Type, System.String.format("cluster('{0}')", [cs.Name])));
                            } else {
                                var db;
                                if (((db = Bridge.as(type, Kusto.Language.Symbols.DatabaseSymbol))) != null) {
                                    texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Type, System.String.format("database('{0}')", [db.Name])));
                                } else if (type != null) {
                                    texts.add(new Kusto.Language.Editor.ClassifiedText.ctor(Kusto.Language.Editor.ClassificationKind.Type, type.Display));
                                }
                            }
                        }
                    }
                }
            }
        }
    });

    Bridge.define("Kusto.Language.EngineCommands", {
        statics: {
            fields: {
                _schema0: null,
                _schema1: null,
                _schema2: null,
                _schema3: null,
                _schema4: null,
                _schema5: null,
                _schema6: null,
                _schema7: null,
                _schema8: null,
                _schema9: null,
                _schema10: null,
                _schema11: null,
                _schema12: null,
                _schema13: null,
                _schema14: null,
                _schema15: null,
                _schema16: null,
                _schema17: null,
                _schema18: null,
                _schema19: null,
                _schema20: null,
                _schema21: null,
                _schema22: null,
                _schema23: null,
                _schema24: null,
                _schema25: null,
                _schema26: null,
                _schema27: null,
                _schema28: null,
                _schema29: null,
                _schema30: null,
                _schema31: null,
                _schema32: null,
                _schema33: null,
                _schema34: null,
                _schema35: null,
                _schema36: null,
                ShowDatabase: null,
                ShowDatabaseDetails: null,
                ShowDatabaseIdentity: null,
                ShowDatabasePolicies: null,
                ShowDatabaseDataStats: null,
                ShowClusterDatabases: null,
                ShowClusterDatabasesDetails: null,
                ShowClusterDatabasesIdentity: null,
                ShowClusterDatabasesPolicies: null,
                ShowClusterDatabasesDataStats: null,
                CreateDatabasePersist: null,
                CreateDatabaseVolatile: null,
                AttachDatabase: null,
                AttachDatabaseMetadata: null,
                DetachDatabase: null,
                AlterDatabasePrettyName: null,
                DropDatabasePrettyName: null,
                AlterDatabasePersistMetadata: null,
                SetAccess: null,
                ShowDatabaseSchema: null,
                ShowDatabaseSchemaAsJson: null,
                ShowDatabaseSchemaAsCslScript: null,
                ShowDatabaseCslSchema: null,
                ShowDatabaseSchemaViolations: null,
                ShowDatabasesSchema: null,
                ShowDatabasesSchemaAsJson: null,
                CreateDatabaseIngestionMapping: null,
                AlterDatabaseIngestionMapping: null,
                ShowDatabaseIngestionMappings: null,
                ShowIngestionMappings: null,
                DropDatabaseIngestionMapping: null,
                ShowTables: null,
                ShowTable: null,
                ShowTablesDetails: null,
                ShowTableDetails: null,
                ShowTableCslSchema: null,
                ShowTableSchemaAsJson: null,
                CreateTable: null,
                CreateTableBasedOnAnother: null,
                CreateMergeTable: null,
                DefineTable: null,
                CreateTables: null,
                CreateMergeTables: null,
                DefineTables: null,
                AlterTable: null,
                AlterMergeTable: null,
                AlterTableDocString: null,
                AlterTableFolder: null,
                RenameTable: null,
                RenameTables: null,
                DropTable: null,
                UndoDropTable: null,
                DropTables: null,
                CreateTableIngestionMapping: null,
                AlterTableIngestionMapping: null,
                ShowTableIngestionMappings: null,
                ShowTableIngestionMapping: null,
                DropTableIngestionMapping: null,
                RenameColumn: null,
                RenameColumns: null,
                AlterColumnType: null,
                DropColumn: null,
                DropTableColumns: null,
                AlterTableColumnDocStrings: null,
                AlterMergeTableColumnDocStrings: null,
                ShowFunctions: null,
                ShowFunction: null,
                CreateFunction: null,
                AlterFunction: null,
                CreateOrAlterFunction: null,
                DropFunction: null,
                DropFunctions: null,
                AlterFunctionDocString: null,
                AlterFunctionFolder: null,
                ShowExternalTables: null,
                ShowExternalTable: null,
                ShowExternalTableCslSchema: null,
                ShowExternalTableSchema: null,
                ShowExternalTableArtifacts: null,
                DropExternalTable: null,
                CreateStorageExternalTable: null,
                AlterStorageExternalTable: null,
                CreateOrAlterStorageExternalTable: null,
                CreateSqlExternalTable: null,
                AlterSqlExternalTable: null,
                CreateOrAlterSqlExternalTable: null,
                CreateExternalTableMapping: null,
                SetExternalTableAdmins: null,
                AddExternalTableAdmins: null,
                DropExternalTableAdmins: null,
                AlterExternalTableDocString: null,
                AlterExternalTableFolder: null,
                ShowExternalTablePrincipals: null,
                ShowFabric: null,
                AlterExternalTableMapping: null,
                ShowExternalTableMappings: null,
                ShowExternalTableMapping: null,
                DropExternalTableMapping: null,
                ShowWorkloadGroups: null,
                ShowWorkloadGroup: null,
                CreateOrAleterWorkloadGroup: null,
                AlterMergeWorkloadGroup: null,
                DropWorkloadGroup: null,
                ShowDatabasePolicyCaching: null,
                ShowTablePolicyCaching: null,
                ShowTableStarPolicyCaching: null,
                ShowColumnPolicyCaching: null,
                ShowMaterializedViewPolicyCaching: null,
                ShowClusterPolicyCaching: null,
                AlterDatabasePolicyCaching: null,
                AlterTablePolicyCaching: null,
                AlterTablesPolicyCaching: null,
                AlterColumnPolicyCaching: null,
                AlterMaterializedViewPolicyCaching: null,
                AlterClusterPolicyCaching: null,
                DeleteDatabasePolicyCaching: null,
                DeleteTablePolicyCaching: null,
                DeleteColumnPolicyCaching: null,
                DeleteMaterializedViewPolicyCaching: null,
                DeleteClusterPolicyCaching: null,
                ShowTablePolicyIngestionTime: null,
                ShowTableStarPolicyIngestionTime: null,
                AlterTablePolicyIngestionTime: null,
                AlterTablesPolicyIngestionTime: null,
                DeleteTablePolicyIngestionTime: null,
                ShowTablePolicyRetention: null,
                ShowTableStarPolicyRetention: null,
                ShowDatabasePolicyRetention: null,
                AlterTablePolicyRetention: null,
                AlterMaterializedViewPolicyRetention: null,
                AlterDatabasePolicyRetention: null,
                AlterTablesPolicyRetention: null,
                AlterMergeTablePolicyRetention: null,
                AlterMergeMaterializedViewPolicyRetention: null,
                AlterMergeDatabasePolicyRetention: null,
                DeleteTablePolicyRetention: null,
                DeleteDatabasePolicyRetention: null,
                ShowDatabasePolicyHardRetentionViolations: null,
                ShowDatabasePolicySoftRetentionViolations: null,
                ShowTablePolicyRowLevelSecurity: null,
                ShowTableStarPolicyRowLevelSecurity: null,
                AlterTablePolicyRowLevelSecurity: null,
                DeleteTablePolicyRowLevelSecurity: null,
                ShowMaterializedViewPolicyRowLevelSecurity: null,
                AlterMaterializedViewPolicyRowLevelSecurity: null,
                DeleteMaterializedViewPolicyRowLevelSecurity: null,
                ShowTablePolicyRowOrder: null,
                ShowTableStarPolicyRowOrder: null,
                AlterTablePolicyRowOrder: null,
                AlterTablesPolicyRowOrder: null,
                AlterMergeTablePolicyRowOrder: null,
                DeleteTablePolicyRowOrder: null,
                ShowTablePolicyUpdate: null,
                ShowTableStarPolicyUpdate: null,
                AlterTablePolicyUpdate: null,
                AlterMergeTablePolicyUpdate: null,
                DeleteTablePolicyUpdate: null,
                ShowClusterPolicyIngestionBatching: null,
                ShowDatabasePolicyIngestionBatching: null,
                ShowTablePolicyIngestionBatching: null,
                ShowTableStarPolicyIngestionBatching: null,
                AlterClusterPolicyIngestionBatching: null,
                AlterDatabasePolicyIngestionBatching: null,
                AlterTablePolicyIngestionBatching: null,
                AlterTablesPolicyIngestionBatching: null,
                DeleteDatabasePolicyIngestionBatching: null,
                DeleteTablePolicyIngestionBatching: null,
                ShowDatabasePolicyEncoding: null,
                ShowTablePolicyEncoding: null,
                ShowColumnPolicyEncoding: null,
                AlterDatabasePolicyEncoding: null,
                AlterTablePolicyEncoding: null,
                AlterTableColumnsPolicyEncoding: null,
                AlterColumnPolicyEncoding: null,
                AlterColumnPolicyEncodingType: null,
                AlterMergeDatabasePolicyEncoding: null,
                AlterMergeTablePolicyEncoding: null,
                AlterMergeColumnPolicyEncoding: null,
                DeleteDatabasePolicyEncoding: null,
                DeleteTablePolicyEncoding: null,
                DeleteColumnPolicyEncoding: null,
                ShowDatabasePolicyMerge: null,
                ShowTablePolicyMerge: null,
                ShowTableStarPolicyMerge: null,
                AlterDatabasePolicyMerge: null,
                AlterTablePolicyMerge: null,
                AlterTablesPolicyMerge: null,
                AlterMergeDatabasePolicyMerge: null,
                AlterMergeTablePolicyMerge: null,
                DeleteDatabasePolicyMerge: null,
                DeleteTablePolicyMerge: null,
                ShowTablePolicyPartitioning: null,
                ShowTableStarPolicyPartitioning: null,
                AlterTablePolicyPartitioning: null,
                AlterMergeTablePolicyPartitioning: null,
                AlterMaterializedViewPolicyPartitioning: null,
                AlterMergeMaterializedViewPolicyPartitioning: null,
                DeleteTablePolicyPartitioning: null,
                DeleteMaterializedViewPolicyPartitioning: null,
                ShowTablePolicyRestrictedViewAccess: null,
                ShowTableStarPolicyRestrictedViewAccess: null,
                AlterTablePolicyRestrictedViewAccess: null,
                AlterTablesPolicyRestrictedViewAccess: null,
                DeleteTablePolicyRestrictedViewAccess: null,
                ShowClusterPolicyRowStore: null,
                AlterClusterPolicyRowStore: null,
                AlterMergeClusterPolicyRowStore: null,
                DeleteClusterPolicyRowStore: null,
                ShowClusterPolicySandbox: null,
                AlterClusterPolicySandbox: null,
                DeleteClusterPolicySandbox: null,
                ShowClusterSandboxesStats: null,
                ShowDatabasePolicySharding: null,
                ShowTablePolicySharding: null,
                ShowTableStarPolicySharding: null,
                AlterDatabasePolicySharding: null,
                AlterTablePolicySharding: null,
                AlterMergeDatabasePolicySharding: null,
                AlterMergeTablePolicySharding: null,
                DeleteDatabasePolicySharding: null,
                DeleteTablePolicySharding: null,
                AlterClusterPolicySharding: null,
                AlterMergeClusterPolicySharding: null,
                DeleteClusterPolicySharding: null,
                ShowClusterPolicySharding: null,
                ShowDatabasePolicyShardsGrouping: null,
                AlterDatabasePolicyShardsGrouping: null,
                AlterMergeDatabasePolicyShardsGrouping: null,
                DeleteDatabasePolicyShardsGrouping: null,
                ShowDatabasePolicyStreamingIngestion: null,
                ShowTablePolicyStreamingIngestion: null,
                ShowClusterPolicyStreamingIngestion: null,
                AlterDatabasePolicyStreamingIngestion: null,
                AlterMergeDatabasePolicyStreamingIngestion: null,
                AlterTablePolicyStreamingIngestion: null,
                AlterMergeTablePolicyStreamingIngestion: null,
                AlterClusterPolicyStreamingIngestion: null,
                AlterMergeClusterPolicyStreamingIngestion: null,
                DeleteDatabasePolicyStreamingIngestion: null,
                DeleteTablePolicyStreamingIngestion: null,
                DeleteClusterPolicyStreamingIngestion: null,
                ShowDatabasePolicyManagedIdentity: null,
                ShowClusterPolicyManagedIdentity: null,
                AlterDatabasePolicyManagedIdentity: null,
                AlterClusterPolicyManagedIdentity: null,
                DeleteDatabasePolicyManagedIdentity: null,
                DeleteClusterPolicyManagedIdentity: null,
                ShowTablePolicyAutoDelete: null,
                AlterTablePolicyAutoDelete: null,
                DeleteTablePolicyAutoDelete: null,
                ShowClusterPolicyCallout: null,
                AlterClusterPolicyCallout: null,
                AlterMergeClusterPolicyCallout: null,
                DeleteClusterPolicyCallout: null,
                ShowClusterPolicyCapacity: null,
                AlterClusterPolicyCapacity: null,
                AlterMergeClusterPolicyCapacity: null,
                ShowClusterPolicyRequestClassification: null,
                AlterClusterPolicyRequestClassification: null,
                AlterMergeClusterPolicyRequestClassification: null,
                DeleteClusterPolicyRequestClassification: null,
                ShowClusterPolicyMultiDatabaseAdmins: null,
                AlterClusterPolicyMultiDatabaseAdmins: null,
                AlterMergeClusterPolicyMultiDatabaseAdmins: null,
                ShowDatabasePolicyDiagnostics: null,
                ShowClusterPolicyDiagnostics: null,
                AlterDatabasePolicyDiagnostics: null,
                AlterMergeDatabasePolicyDiagnostics: null,
                AlterClusterPolicyDiagnostics: null,
                AlterMergeClusterPolicyDiagnostics: null,
                DeleteDatabasePolicyDiagnostics: null,
                ShowClusterPolicyQueryWeakConsistency: null,
                AlterClusterPolicyQueryWeakConsistency: null,
                AlterMergeClusterPolicyQueryWeakConsistency: null,
                ShowTablePolicyExtentTagsRetention: null,
                ShowTableStarPolicyExtentTagsRetention: null,
                ShowDatabasePolicyExtentTagsRetention: null,
                AlterTablePolicyExtentTagsRetention: null,
                AlterDatabasePolicyExtentTagsRetention: null,
                DeleteTablePolicyExtentTagsRetention: null,
                DeleteDatabasePolicyExtentTagsRetention: null,
                ShowPrincipalRoles: null,
                ShowDatabasePrincipalRoles: null,
                ShowTablePrincipalRoles: null,
                ShowExternalTablesPrincipalRoles: null,
                ShowFunctionPrincipalRoles: null,
                ShowClusterPrincipalRoles: null,
                ShowClusterPrincipals: null,
                ShowDatabasePrincipals: null,
                ShowTablePrincipals: null,
                ShowFunctionPrincipals: null,
                AddClusterRole: null,
                DropClusterRole: null,
                SetClusterRole: null,
                AddDatabaseRole: null,
                DropDatabaseRole: null,
                SetDatabaseRole: null,
                AddTableRole: null,
                DropTableRole: null,
                SetTableRole: null,
                AddFunctionRole: null,
                DropFunctionRole: null,
                SetFunctionRole: null,
                ShowClusterBlockedPrincipals: null,
                AddClusterBlockedPrincipals: null,
                DropClusterBlockedPrincipals: null,
                IngestIntoTable: null,
                IngestInlineIntoTable: null,
                SetTable: null,
                AppendTable: null,
                SetOrAppendTable: null,
                SetOrReplaceTable: null,
                ExportToStorage: null,
                ExportToSqlTable: null,
                ExportToExternalTable: null,
                CreateOrAlterContinuousExport: null,
                ShowContinuousExport: null,
                ShowContinuousExports: null,
                ShowClusterPendingContinuousExports: null,
                ShowContinuousExportExportedArtifacts: null,
                ShowContinuousExportFailures: null,
                SetContinuousExportCursor: null,
                DropContinuousExport: null,
                EnableContinuousExport: null,
                DisableContinuousExport: null,
                CreateMaterializedView: null,
                RenameMaterializedView: null,
                ShowMaterializedView: null,
                ShowMaterializedViews: null,
                ShowMaterializedViewsDetails: null,
                ShowMaterializedViewDetails: null,
                ShowMaterializedViewPolicyRetention: null,
                ShowMaterializedViewPolicyMerge: null,
                ShowMaterializedViewPolicyPartitioning: null,
                ShowMaterializedViewExtents: null,
                AlterMaterializedView: null,
                CreateOrAlterMaterializedView: null,
                DropMaterializedView: null,
                EnableDisableMaterializedView: null,
                ShowMaterializedViewPrincipals: null,
                ShowMaterializedViewSchemaAsJson: null,
                ShowMaterializedViewCslSchema: null,
                AlterMaterializedViewFolder: null,
                AlterMaterializedViewDocString: null,
                AlterMaterializedViewLookback: null,
                AlterMaterializedViewAutoUpdateSchema: null,
                ClearMaterializedViewData: null,
                SetMaterializedViewCursor: null,
                ShowCluster: null,
                ShowDiagnostics: null,
                ShowCapacity: null,
                ShowOperations: null,
                ShowOperationDetails: null,
                ShowJournal: null,
                ShowDatabaseJournal: null,
                ShowClusterJournal: null,
                ShowQueries: null,
                ShowRunningQueries: null,
                CancelQuery: null,
                ShowQueryPlan: null,
                ShowBasicAuthUsers: null,
                CreateBasicAuthUser: null,
                DropBasicAuthUser: null,
                ShowCache: null,
                AlterCache: null,
                ShowCommands: null,
                ShowCommandsAndQueries: null,
                ShowIngestionFailures: null,
                ShowClusterExtents: null,
                ShowClusterExtentsMetadata: null,
                ShowDatabaseExtents: null,
                ShowDatabaseExtentsMetadata: null,
                ShowDatabaseExtentTagsStatistics: null,
                ShowTableExtents: null,
                ShowTableExtentsMetadata: null,
                TableShardGroupsShow: null,
                TableShardGroupsStatisticsShow: null,
                DatabaseShardGroupsStatisticsShow: null,
                MergeExtents: null,
                MergeExtentsDryrun: null,
                MoveExtentsFrom: null,
                MoveExtentsQuery: null,
                ReplaceExtents: null,
                DropExtent: null,
                DropExtents: null,
                DropExtentsPartitionMetadata: null,
                DropPretendExtentsByProperties: null,
                ShowVersion: null,
                ClearTableData: null,
                ClearTableCacheStreamingIngestionSchema: null,
                StoredQueryResultSet: null,
                StoredQueryResultSetOrReplace: null,
                StoredQueryResultsShow: null,
                StoredQueryResultShowSchema: null,
                StoredQueryResultDrop: null,
                StoredQueryResultsDrop: null,
                CreateRequestSupport: null,
                ShowRequestSupport: null,
                ShowClusterAdminState: null,
                ClearRemoteClusterDatabaseSchema: null,
                ShowClusterMonitoring: null,
                ShowClusterScaleIn: null,
                ShowClusterServices: null,
                ShowClusterNetwork: null,
                AlterClusterStorageKeys: null,
                ShowClusterStorageKeysHash: null,
                CreateEntityGroupCommand: null,
                AlterEntityGroup: null,
                AlterMergeEntityGroup: null,
                DropEntityGroup: null,
                ShowEntityGroup: null,
                ShowEntityGroups: null,
                AlterExtentContainersAdd: null,
                AlterExtentContainersDrop: null,
                AlterExtentContainersRecycle: null,
                AlterExtentContainersSet: null,
                ShowExtentContainers: null,
                DropEmptyExtentContainers: null,
                CleanDatabaseExtentContainers: null,
                ShowDatabaseExtentContainersCleanOperations: null,
                ClearDatabaseCacheQueryResults: null,
                ShowDatabaseCacheQueryResults: null,
                ShowDatabasesManagementGroups: null,
                AlterDatabaseStorageKeys: null,
                ClearDatabaseCacheStreamingIngestionSchema: null,
                ClearDatabaseCacheQueryWeakConsistency: null,
                ShowEntitySchema: null,
                ShowExtentDetails: null,
                ShowExtentColumnStorageStats: null,
                AttachExtentsIntoTableByContainer: null,
                AttachExtentsIntoTableByMetadata: null,
                AlterExtentTagsFromQuery: null,
                DropExtentTagsRetention: null,
                AlterFollowerClusterConfiguration: null,
                AddFollowerDatabaseAuthorizedPrincipals: null,
                DropFollowerDatabaseAuthorizedPrincipals: null,
                AlterFollowerDatabaseAuthorizedPrincipals: null,
                DropFollowerDatabasePolicyCaching: null,
                AlterFollowerDatabaseChildEntities: null,
                AlterFollowerDatabaseConfiguration: null,
                DropFollowerDatabases: null,
                ShowFollowerDatabase: null,
                AlterFollowerTablesPolicyCaching: null,
                DropFollowerTablesPolicyCaching: null,
                ShowFreshness: null,
                ShowFunctionSchemaAsJson: null,
                SetMaterializedViewAdmins: null,
                AddMaterializedViewAdmins: null,
                DropMaterializedViewAdmins: null,
                SetMaterializedViewConcurrency: null,
                ClearMaterializedViewStatistics: null,
                ShowMaterializedViewStatistics: null,
                ShowMaterializedViewDiagnostics: null,
                ShowMaterializedViewFailures: null,
                ShowMemory: null,
                CancelOperation: null,
                DisablePlugin: null,
                EnablePlugin: null,
                ShowPlugins: null,
                ShowPrincipalAccess: null,
                ShowDatabasePurgeOperation: null,
                ShowQueryExecution: null,
                AlterPoliciesOfRetention: null,
                DeletePoliciesOfRetention: null,
                CreateRowStore: null,
                DropRowStore: null,
                ShowRowStore: null,
                ShowRowStores: null,
                ShowRowStoreTransactions: null,
                ShowRowStoreSeals: null,
                ShowSchema: null,
                ShowCallStacks: null,
                ShowStreamingIngestionFailures: null,
                ShowStreamingIngestionStatistics: null,
                AlterTableRowStoreReferencesDropKey: null,
                AlterTableRowStoreReferencesDropRowStore: null,
                AlterTableRowStoreReferencesDropBlockedKeys: null,
                AlterTableRowStoreReferencesDisableKey: null,
                AlterTableRowStoreReferencesDisableRowStore: null,
                AlterTableRowStoreReferencesDisableBlockedKeys: null,
                SetTableRowStoreReferences: null,
                ShowTableRowStoreReferences: null,
                AlterTableColumnStatistics: null,
                AlterTableColumnStatisticsMethod: null,
                ShowTableColumnStatitics: null,
                ShowTableDimensions: null,
                DeleteTableRecords: null,
                ShowTableColumnsClassification: null,
                ShowTableRowStores: null,
                ShowTableRowStoreSealInfo: null,
                ShowTablesColumnStatistics: null,
                ShowTableUsageStatistics: null,
                ShowTableUsageStatisticsDetails: null,
                CreateTempStorage: null,
                DropTempStorage: null,
                DropStoredQueryResultContainers: null,
                DropUnusedStoredQueryResultContainers: null,
                EnableDatabaseMaintenanceMode: null,
                DisableDatabaseMaintenanceMode: null,
                ShowQueryCallTree: null,
                ShowExtentCorruptedDatetime: null,
                PatchExtentCorruptedDatetime: null,
                All: null
            },
            ctors: {
                init: function () {
                    this._schema0 = "(DatabaseName: string, PersistentStorage: string, Version: string, IsCurrent: bool, DatabaseAccessMode: string, PrettyName: string, ReservedSlot1: bool, DatabaseId: guid, InTransitionTo: string)";
                    this._schema1 = "(DatabaseName: string, PersistentStorage: string, Version: string, IsCurrent: bool, DatabaseAccessMode: string, PrettyName: string, AuthorizedPrincipals: string, RetentionPolicy: string, MergePolicy: string, ReservedSlot1: string, CachingPolicy: string, ShardingPolicy: string, StreamingIngestionPolicy: string, IngestionBatchingPolicy: string, TotalSize: real, DatabaseId: guid, InTransitionTo: string)";
                    this._schema2 = "(DatabaseName: string, PersistentStorage: string, Version: string, IsCurrent: bool, DatabaseAccessMode: string, PrettyName: string, CurrentUserIsUnrestrictedViewer: bool, DatabaseId: guid, InTransitionTo: string)";
                    this._schema3 = "(DatabaseName: string, PersistentStorage: string, Version: string, IsCurrent: bool, DatabaseAccessMode: string, PrettyName: string, DatabaseId: guid, AuthorizedPrincipals: string, RetentionPolicy: string, MergePolicy: string, CachingPolicy: string, ShardingPolicy: string, StreamingIngestionPolicy: string, IngestionBatchingPolicy: string)";
                    this._schema4 = "(Step: string, Duration: string)";
                    this._schema5 = "(DatabaseName: string, PrettyName: string)";
                    this._schema6 = "(DatabaseName: string, TableName: string, ColumnName: string, ColumnType: string, IsDefaultTable: bool, IsDefaultColumn: bool, PrettyName: string, Version: string, Folder: string, DocString: string)";
                    this._schema7 = "(DatabaseSchema: string)";
                    this._schema8 = "(Name: string, Kind: string, Mapping: string, LastUpdatedOn: datetime, Database: string)";
                    this._schema9 = "(TableName: string, DatabaseName: string, Folder: string, DocString: string, TotalExtents: long, TotalExtentSize: real, TotalOriginalSize: real, TotalRowCount: long, HotExtents: long, HotExtentSize: real, HotOriginalSize: real, HotRowCount: long, AuthorizedPrincipals: string, RetentionPolicy: string, CachingPolicy: string, ShardingPolicy: string, MergePolicy: string, StreamingIngestionPolicy: string, IngestionBatchingPolicy: string, MinExtentsCreationTime: datetime, MaxExtentsCreationTime: datetime, RowOrderPolicy: string, TableId: guid)";
                    this._schema10 = "(TableName: string, Schema: string, DatabaseName: string, Folder: string, DocString: string)";
                    this._schema11 = "(TableName: string, DatabaseName: string, Folder: string, DocString: string)";
                    this._schema12 = "(TableName: string, DatabaseName: string)";
                    this._schema13 = "(Name: string, Kind: string, Mapping: string, LastUpdatedOn: datetime, Database: string, Table: string)";
                    this._schema14 = "(EntityName: string, DataType: string, Policy: string)";
                    this._schema15 = "(Name: string, Parameters: string, Body: string, Folder: string, DocString: string)";
                    this._schema16 = "(TableName: string, TableType: string, Folder: string, DocString: string, Properties: string, ConnectionStrings: dynamic, Partitions: dynamic, PathFormat: string)";
                    this._schema17 = "(TableName: string, TableType: string, Folder: string, DocString: string, Schema: string, Properties: string)";
                    this._schema18 = "()";
                    this._schema19 = "(WorkloadGroupName: string, WorkloadGroup:string)";
                    this._schema20 = "(PolicyName: string, EntityName: string, Policy: string, ChildEntities: string, EntityType: string)";
                    this._schema21 = "(Scope: string, DisplayName: string, AADObjectID: string, Role: string)";
                    this._schema22 = "(Role: string, PrincipalType: string, PrincipalDisplayName: string, PrincipalObjectId: string, PrincipalFQN: string, Notes: string, RoleAssignmentIdentifier: string)";
                    this._schema23 = "(PrincipalType: string, PrincipalDisplayName: string, PrincipalObjectId: string, PrincipalFQN: string, Application: string, User: string, BlockedUntil: datetime, Reason: string)";
                    this._schema24 = "(ExtentId: guid, OriginalSize: long, ExtentSize: long, ColumnSize: long, IndexSize: long, RowCount: long)";
                    this._schema25 = "(Name: string, ExternalTableName: string, Query: string, ForcedLatency: timespan, IntervalBetweenRuns: timespan, CursorScopedTables: string, ExportProperties: string, LastRunTime: datetime, StartCursor: string, IsDisabled: bool, LastRunResult: string, ExportedTo: datetime, IsRunning: bool)";
                    this._schema26 = "(Name: string, SourceTable: string, Query: string, MaterializedTo: datetime, LastRun: datetime, LastRunResult: string, IsHealthy: bool, IsEnabled: bool, Folder: string, DocString: string, AutoUpdateSchema: bool, EffectiveDateTime: datetime, Lookback:timespan)";
                    this._schema27 = "(MaterializedViewName: string, DatabaseName: string, Folder: string, DocString: string, TotalExtents: long, TotalExtentSize: real, TotalOriginalSize: real, TotalRowCount: long, HotExtents: long, HotExtentSize: real, HotOriginalSize: real, HotRowCount: long, AuthorizedPrincipals: string, RetentionPolicy: string, CachingPolicy: string, ShardingPolicy: string, MergePolicy: string, MinExtentsCreationTime: datetime, MaxExtentsCreationTime: datetime)";
                    this._schema28 = "(Event: string, EventTimestamp: datetime, Database: string, EntityName: string, UpdatedEntityName: string, EntityVersion: string, EntityContainerName: string, OriginalEntityState: string, UpdatedEntityState: string, ChangeCommand: string, Principal: string, RootActivityId: guid, ClientRequestId: string, User: string, OriginalEntityVersion: string)";
                    this._schema29 = "(ExtentId: guid, DatabaseName: string, TableName: string, MaxCreatedOn: datetime, OriginalSize: real, ExtentSize: real, CompressedSize: real, IndexSize: real, Blocks: long, Segments: long, ExtentContainerId: string, RowCount: long, MinCreatedOn: datetime, Tags: string, Kind: string, DeletedRowCount: long)";
                    this._schema30 = "(ExtentId: guid, DatabaseName: string, TableName: string, ExtentMetadata: string)";
                    this._schema31 = "(TableId: guid, long ShardGroupCount: long, ShardCount: long, RowCount: long, OriginalSize: long, ShardSize: long, CompressedSize: long, IndexSize: long, DeletedRowCount: long, V2ShardCount: long, V2RowCount: long)";
                    this._schema32 = "(OriginalExtentId: string, ResultExtentId: string, Duration: timespan)";
                    this._schema33 = "(OriginalExtentId: string, ResultExtentId: string, Details: string)";
                    this._schema34 = "(ExtentId: guid, TableName: string, CreatedOn: datetime)";
                    this._schema35 = "(StoredQueryResultId:guid, Name:string, DatabaseName:string, PrincipalIdentity:string, SizeInBytes:long, RowCount:long, CreatedOn:datetime, ExpiresOn:datetime)";
                    this._schema36 = "(Name: string, Entities: string)";
                    this.ShowDatabase = new Kusto.Language.Symbols.CommandSymbol("ShowDatabase", Kusto.Language.EngineCommands._schema0);
                    this.ShowDatabaseDetails = new Kusto.Language.Symbols.CommandSymbol("ShowDatabaseDetails", Kusto.Language.EngineCommands._schema1);
                    this.ShowDatabaseIdentity = new Kusto.Language.Symbols.CommandSymbol("ShowDatabaseIdentity", Kusto.Language.EngineCommands._schema2);
                    this.ShowDatabasePolicies = new Kusto.Language.Symbols.CommandSymbol("ShowDatabasePolicies", Kusto.Language.EngineCommands._schema3);
                    this.ShowDatabaseDataStats = new Kusto.Language.Symbols.CommandSymbol("ShowDatabaseDataStats", "(DatabaseName: string, PersistentStorage: string, Version: string, IsCurrent: bool, DatabaseAccessMode: string, PrettyName: string, CurrentUseIsUnrestrictedViewer: bool, DatabaseId: guid, OriginalSize: real, ExtentSize: real, CompressedSize: real, IndexSize: real, RowCount: long, HotOriginalSize: real, HotExtentSize: real, HotCompressedSize: real, HotIndexSize: real, HotRowCount: long)");
                    this.ShowClusterDatabases = new Kusto.Language.Symbols.CommandSymbol("ShowClusterDatabases", Kusto.Language.EngineCommands._schema0);
                    this.ShowClusterDatabasesDetails = new Kusto.Language.Symbols.CommandSymbol("ShowClusterDatabasesDetails", Kusto.Language.EngineCommands._schema1);
                    this.ShowClusterDatabasesIdentity = new Kusto.Language.Symbols.CommandSymbol("ShowClusterDatabasesIdentity", Kusto.Language.EngineCommands._schema2);
                    this.ShowClusterDatabasesPolicies = new Kusto.Language.Symbols.CommandSymbol("ShowClusterDatabasesPolicies", Kusto.Language.EngineCommands._schema3);
                    this.ShowClusterDatabasesDataStats = new Kusto.Language.Symbols.CommandSymbol("ShowClusterDatabasesDataStats", "(DatabaseName: string, PersistentStorage: string, Version: string, IsCurrent: bool, DatabaseAccessMode: string, PrettyName: string, DatabaseId: guid, OriginalSize: real, ExtentSize: real, CompressedSize: real, IndexSize: real, RowCount: long, HotOriginalSize: real, HotExtentSize: real, HotCompressedSize: real, HotIndexSize: real, HotRowCount: long)");
                    this.CreateDatabasePersist = new Kusto.Language.Symbols.CommandSymbol("CreateDatabasePersist", "(DatabaseName: string, PersistentPath: string, Created: string, StoresMetadata: bool, StoresData: bool)");
                    this.CreateDatabaseVolatile = new Kusto.Language.Symbols.CommandSymbol("CreateDatabaseVolatile", "(DatabaseName: string, PersistentPath: string, Created: bool, StoresMetadata: bool, StoresData: bool)");
                    this.AttachDatabase = new Kusto.Language.Symbols.CommandSymbol("AttachDatabase", Kusto.Language.EngineCommands._schema4);
                    this.AttachDatabaseMetadata = new Kusto.Language.Symbols.CommandSymbol("AttachDatabaseMetadata", Kusto.Language.EngineCommands._schema4);
                    this.DetachDatabase = new Kusto.Language.Symbols.CommandSymbol("DetachDatabase", "(Table: string, NumberOfRemovedExtents: string)");
                    this.AlterDatabasePrettyName = new Kusto.Language.Symbols.CommandSymbol("AlterDatabasePrettyName", Kusto.Language.EngineCommands._schema5);
                    this.DropDatabasePrettyName = new Kusto.Language.Symbols.CommandSymbol("DropDatabasePrettyName", Kusto.Language.EngineCommands._schema5);
                    this.AlterDatabasePersistMetadata = new Kusto.Language.Symbols.CommandSymbol("AlterDatabasePersistMetadata", "(Moniker: guid