import { IObject } from "@daybrush/utils";
import { CompatElement } from "./types";
export declare function createElement(type: any, props: any, ...children: any[]): CompatElement;
declare abstract class Provider<T extends Element | Component | Node = Element | Component | Node> {
    type: any;
    key: string;
    index: number;
    container?: Provider | null;
    ref?: (e: Element | Component | Node) => any;
    props: IObject<any>;
    original: CompatElement | string;
    base: T;
    _providers: Array<Provider<any>>;
    constructor(type: any, key: string, index: number, container?: Provider | null, ref?: (e: Element | Component | Node) => any, props?: IObject<any>);
    abstract _render(hooks: Function[], prevProps: any, nextState: any): any;
    abstract _unmount(): any;
    _should(nextProps: any, nextState: any): boolean;
    _update(hooks: Function[], nextElement: CompatElement | string, nextState?: any, isForceUpdate?: boolean): boolean;
    _mounted(): void;
    _setState(nextstate: IObject<any>): void;
    _updated(): void;
    _destroy(): void;
}
export declare function findDOMNode(comp: Component | Node | null): Node | null;
declare class ComponentProvider extends Provider<Component> {
    constructor(type: typeof Component, key: string, index: number, container: Provider | null, ref: (e: Element | Component | Node) => any, props?: IObject<any>);
    _should(nextProps: any, nextState: any): boolean;
    _render(hooks: Function[], prevProps: any): void;
    _setState(nextState?: IObject<any>): void;
    _unmount(): void;
}
export declare class Component {
    props: IObject<any>;
    static defaultProps?: IObject<any>;
    state: IObject<any>;
    $_provider: ComponentProvider;
    $_timer: number;
    $_state: IObject<any>;
    constructor(props?: IObject<any>);
    shouldComponentUpdate(props?: any, state?: any): boolean;
    render(): any;
    setState(state: IObject<any>, callback?: Function, isForceUpdate?: boolean): void;
    forceUpdate(callback?: Function): void;
    componentDidMount(): void;
    componentDidUpdate(prevProps: any, prevState: any): void;
    componentWillUnmount(): void;
    private $_setState;
}
export declare class PureComponent extends Component {
    shouldComponentUpdate(props?: any, state?: any): boolean;
}
export declare function render(element: any, container: Element, callback?: Function): void;
export declare function createPortal(el: any, container: Element): any;
export declare const version = "simple-1.1.0";
export {};
