import { BettererFileTest } from '@betterer/betterer';
import { BettererESLintRulesConfig } from './types';
/**
 * @public Use this test to incrementally introduce new {@link https://eslint.org/ | **ESLint**} rules to
 * your codebase. You can pass as many **ESLint** {@link https://eslint.org/docs/rules/ | rule configurations}
 * as you like:
 *
 * @remarks {@link @betterer/eslint#eslint | `eslint`} is a {@link @betterer/betterer#BettererFileTest | `BettererFileTest`},
 * so you can use {@link @betterer/betterer#BettererFileTest.include | `include()`},
 * {@link @betterer/betterer#BettererFileTest.exclude | `exclude()`}, {@link @betterer/betterer#BettererFileTest.only | `only()`},
 * and {@link @betterer/betterer#BettererFileTest.skip | `skip()`}.
 *
 * @example
 * ```typescript
 * import { eslint } from '@betterer/eslint';
 *
 * export default {
 *   'new eslint rules': () =>
 *     eslint({
 *       'no-debugger': 'error',
 *       'no-unsafe-finally': 'error',
 *     })
 *     .include('./src/*.ts')
 * };
 * ```
 *
 * @param rules - Additional {@link https://eslint.org/ | **ESLint**} {@link https://eslint.org/docs/rules/ | rules}
 * to enable.
 *
 * @throws {@link @betterer/errors#BettererError | `BettererError` }
 * Will throw if the user doesn't pass `rules`.
 */
export declare function eslint(rules: BettererESLintRulesConfig): BettererFileTest;
//# sourceMappingURL=eslint.d.ts.map