import { Plugin } from 'rollup';
interface ExternalsOptions {
    /** Mark node built-in modules like `path`, `fs`... as external. Defaults to `true`. */
    builtins?: boolean;
    /** How to treat prefixed builtins. Defaults to `true` (prefixed are considered the same as unprefixed). */
    builtinsPrefix?: 'add' | 'strip';
    /**
     * Path/to/your/package.json file (or array of paths).
     * Defaults to all package.json files found in parent directories recursively.
     * Won't got outside of a git repository.
     */
    packagePath?: string | string[];
    /** Mark dependencies as external. Defaults to `true`. */
    deps?: boolean;
    /** Mark devDependencies as external. Defaults to `true`. */
    devDeps?: boolean;
    /** Mark peerDependencies as external. Defaults to `true`. */
    peerDeps?: boolean;
    /** Mark optionalDependencies as external. Defaults to `true`. */
    optDeps?: boolean;
    /** Force these deps in the list of externals, regardless of other settings. Defaults to `[]`  */
    include?: string | RegExp | (string | RegExp)[];
    /** Exclude these deps from the list of externals, regardless of other settings. Defaults to `[]`  */
    exclude?: string | RegExp | (string | RegExp)[];
    /**
     * @deprecated - Please use `builtinsPrefix`instead.
    */
    prefixedBuiltins?: boolean | 'strip' | 'add';
}
/**
 * A Rollup plugin that automatically declares NodeJS built-in modules,
 * and optionally npm dependencies, as 'external'.
 */
declare function externals(options?: ExternalsOptions): Plugin;
export { externals as default, externals, ExternalsOptions };
