'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var lr = require('@lezer/lr');
var highlight = require('@lezer/highlight');

// This file was generated by lezer-generator. You probably shouldn't edit it.
const inf$1 = 147,
  nan$1 = 148,
  Bool$1 = 1,
  Ignoring$1 = 2,
  On$1 = 3,
  GroupLeft$1 = 4,
  GroupRight$1 = 5,
  Offset$1 = 6,
  Atan2$1 = 7,
  Avg$1 = 8,
  Bottomk$1 = 9,
  Count$1 = 10,
  CountValues$1 = 11,
  Group$1 = 12,
  Max$1 = 13,
  Min$1 = 14,
  Quantile$1 = 15,
  Stddev$1 = 16,
  Stdvar$1 = 17,
  Sum$1 = 18,
  Topk$1 = 19,
  By$1 = 20,
  Without$1 = 21,
  And$1 = 22,
  Or$1 = 23,
  Unless$1 = 24,
  Start$1 = 25,
  End$1 = 26;

// Copyright 2021 The Prometheus Authors

const keywordTokens = {
    inf: inf$1,
    nan: nan$1,
    bool: Bool$1,
    ignoring: Ignoring$1,
    on: On$1,
    group_left: GroupLeft$1,
    group_right: GroupRight$1,
    offset: Offset$1,
};

const specializeIdentifier = (value, stack) => {
    return keywordTokens[value.toLowerCase()] || -1;
};

const contextualKeywordTokens = {
    avg: Avg$1,
    atan2: Atan2$1,
    bottomk: Bottomk$1,
    count: Count$1,
    count_values: CountValues$1,
    group: Group$1,
    max: Max$1,
    min: Min$1,
    quantile: Quantile$1,
    stddev: Stddev$1,
    stdvar: Stdvar$1,
    sum: Sum$1,
    topk: Topk$1,
    by: By$1,
    without: Without$1,
    and: And$1,
    or: Or$1,
    unless: Unless$1,
    start: Start$1,
    end: End$1,
};

const extendIdentifier = (value, stack) => {
    return contextualKeywordTokens[value.toLowerCase()] || -1;
};

// Copyright 2022 The Prometheus Authors

const promQLHighLight = highlight.styleTags({
    LineComment: highlight.tags.comment,
    LabelName: highlight.tags.labelName,
    StringLiteral: highlight.tags.string,
    NumberLiteral: highlight.tags.number,
    Duration: highlight.tags.number,
    'Abs Absent AbsentOverTime Acos Acosh Asin Asinh Atan Atanh AvgOverTime Ceil Changes Clamp ClampMax ClampMin Cos Cosh CountOverTime DaysInMonth DayOfMonth DayOfWeek DayOfYear Deg Delta Deriv Exp Floor HistogramQuantile HoltWinters Hour Idelta Increase Irate LabelReplace LabelJoin LastOverTime Ln Log10 Log2 MaxOverTime MinOverTime Minute Month Pi PredictLinear PresentOverTime QuantileOverTime Rad Rate Resets Round Scalar Sgn Sin Sinh Sort SortDesc Sqrt StddevOverTime StdvarOverTime SumOverTime Tan Tanh Time Timestamp Vector Year':
        highlight.tags.function(highlight.tags.variableName),
    'Avg Bottomk Count Count_values Group Max Min Quantile Stddev Stdvar Sum Topk': highlight.tags.operatorKeyword,
    'By Without Bool On Ignoring GroupLeft GroupRight Offset Start End': highlight.tags.modifier,
    'And Unless Or': highlight.tags.logicOperator,
    'Sub Add Mul Mod Div Atan2 Eql Neq Lte Lss Gte Gtr EqlRegex EqlSingle NeqRegex Pow At': highlight.tags.operator,
    UnaryOp: highlight.tags.arithmeticOperator,
    '( )': highlight.tags.paren,
    '[ ]': highlight.tags.squareBracket,
    '{ }': highlight.tags.brace,
    '⚠': highlight.tags.invalid,
});

// This file was generated by lezer-generator. You probably shouldn't edit it.
const spec_Identifier = {__proto__:null,absent_over_time:309, absent:311, abs:313, acos:315, acosh:317, asin:319, asinh:321, atan:323, atanh:325, avg_over_time:327, ceil:329, changes:331, clamp:333, clamp_max:335, clamp_min:337, cos:339, cosh:341, count_over_time:343, days_in_month:345, day_of_month:347, day_of_week:349, day_of_year:351, deg:353, delta:355, deriv:357, exp:359, floor:361, histogram_quantile:363, holt_winters:365, hour:367, idelta:369, increase:371, irate:373, label_replace:375, label_join:377, last_over_time:379, ln:381, log10:383, log2:385, max_over_time:387, min_over_time:389, minute:391, month:393, pi:395, predict_linear:397, present_over_time:399, quantile_over_time:401, rad:403, rate:405, resets:407, round:409, scalar:411, sgn:413, sin:415, sinh:417, sort:419, sort_desc:421, sqrt:423, stddev_over_time:425, stdvar_over_time:427, sum_over_time:429, tan:431, tanh:433, timestamp:435, time:437, vector:439, year:441};
const parser = lr.LRParser.deserialize({
  version: 14,
  states: "6bOYQPOOO'OQPOOOOQO'#C{'#C{O'TQPO'#CzQ'`QQOOOOQO'#De'#DeO'ZQPO'#DdOOQO'#FO'#FOO(mQPO'#FUOYQPO'#FQOYQPO'#FTOOQO'#FW'#FWO.lQSO'#FXO.tQQO'#FVOOQO'#FV'#FVOOQO'#Cy'#CyOOQO'#Df'#DfOOQO'#Dh'#DhOOQO'#Di'#DiOOQO'#Dj'#DjOOQO'#Dk'#DkOOQO'#Dl'#DlOOQO'#Dm'#DmOOQO'#Dn'#DnOOQO'#Do'#DoOOQO'#Dp'#DpOOQO'#Dq'#DqOOQO'#Dr'#DrOOQO'#Ds'#DsOOQO'#Dt'#DtOOQO'#Du'#DuOOQO'#Dv'#DvOOQO'#Dw'#DwOOQO'#Dx'#DxOOQO'#Dy'#DyOOQO'#Dz'#DzOOQO'#D{'#D{OOQO'#D|'#D|OOQO'#D}'#D}OOQO'#EO'#EOOOQO'#EP'#EPOOQO'#EQ'#EQOOQO'#ER'#EROOQO'#ES'#ESOOQO'#ET'#ETOOQO'#EU'#EUOOQO'#EV'#EVOOQO'#EW'#EWOOQO'#EX'#EXOOQO'#EY'#EYOOQO'#EZ'#EZOOQO'#E['#E[OOQO'#E]'#E]OOQO'#E^'#E^OOQO'#E_'#E_OOQO'#E`'#E`OOQO'#Ea'#EaOOQO'#Eb'#EbOOQO'#Ec'#EcOOQO'#Ed'#EdOOQO'#Ee'#EeOOQO'#Ef'#EfOOQO'#Eg'#EgOOQO'#Eh'#EhOOQO'#Ei'#EiOOQO'#Ej'#EjOOQO'#Ek'#EkOOQO'#El'#ElOOQO'#Em'#EmOOQO'#En'#EnOOQO'#Eo'#EoOOQO'#Ep'#EpOOQO'#Eq'#EqOOQO'#Er'#ErOOQO'#Es'#EsOOQO'#Et'#EtOOQO'#Eu'#EuOOQO'#Ev'#EvOOQO'#Ew'#EwOOQO'#Ex'#ExOOQO'#Ey'#EyOOQO'#Ez'#EzOOQO'#E{'#E{QOQPOOO0_QPO'#C|O0dQPO'#DRO'ZQPO,59fO0kQQO,59fO2XQPO,59oO2XQPO,59oO2XQPO,59oO2XQPO,59oO2XQPO,59oO8WQQO,5;hO8]QQO,5;kO8eQPO,5;zOOQO,5:O,5:OOOQO,5;j,5;jO8|QQO,5;lO9TQQO,5;oO:kQPO'#FZO:yQPO,5;sOOQO'#FY'#FYOOQO,5;s,5;sOOQO,5;q,5;qO;RQSO'#C}OOQO,59h,59hO;ZQPO,59mO;cQQO'#DSOOQO,59m,59mOOQO1G/Q1G/QO0_QPO'#DWOAcQPO'#DVOAmQPO'#DVOYQPO1G/ZOYQPO1G/ZOYQPO1G/ZOYQPO1G/ZOYQPO1G/ZOAwQSO1G1SOOQO1G1V1G1VOBPQQO1G1VOBUQPO'#FOOOQO'#Fb'#FbOOQO1G1f1G1fOBaQPO1G1fOOQO1G1W1G1WOOQO'#F['#F[OBfQPO,5;uOBkQSO1G1_OOQO1G1_1G1_OOQO'#DP'#DPOBsQPO,59iOOQO'#DO'#DOOOQO,59i,59iOYQPO,59nOOQO1G/X1G/XOOQO,59r,59rOHnQPO,59qOHuQPO,59qOJ^QQO7+$uOJnQQO7+$uOLSQQO7+$uOLjQQO7+$uONRQQO7+$uOOQO7+&n7+&nONlQQO7+&tOOQO7+&q7+&qONtQPO7+'QOOQO1G1a1G1aOOQO1G1`1G1`OOQO7+&y7+&yONyQSO1G/TOOQO1G/T1G/TO! RQQO1G/YOOQO1G/]1G/]O! ]QPO1G/]OOQO<<J`<<J`O!'RQPO<<J`OOQO<<Jl<<JlOOQO1G/U1G/UOOQO7+$o7+$oOOQO7+$w7+$wOOQOAN?zAN?z",
  stateData: "!'W~O$[OSkOS~OWQOXQOYQOZQO[QO]QO^QO_QO`QOaQObQOcQO!ZZO#u_O$XVO$YVO$]XO$``O$aaO$bbO$ccO$ddO$eeO$ffO$ggO$hhO$iiO$jjO$kkO$llO$mmO$nnO$ooO$ppO$qqO$rrO$ssO$ttO$uuO$vvO$wwO$xxO$yyO$zzO${{O$||O$}}O%O!OO%P!PO%Q!QO%R!RO%S!SO%T!TO%U!UO%V!VO%W!WO%X!XO%Y!YO%Z!ZO%[![O%]!]O%^!^O%_!_O%`!`O%a!aO%b!bO%c!cO%d!dO%e!eO%f!fO%g!gO%h!hO%i!iO%j!jO%k!kO%l!lO%m!mO%n!nO%o!oO%p!pO%q!qO%r!rO%s!sO%t!tO%wWO%xWO%yVO%{[O~O!ZZO~Od!vOe!vO$]!wO~OU#QOV!zOf!}Og#OOh!}Ox!zO{!zO|!zO}!zO!O!{O!P!{O!Q!|O!R!|O!S!|O!T!|O!U!|O!V!|O$T#RO%u#PO~O$X#TO$Y#TO%y#TOW#xXX#xXY#xXZ#xX[#xX]#xX^#xX_#xX`#xXa#xXb#xXc#xX!Z#xX#u#xX$X#xX$Y#xX$]#xX$`#xX$a#xX$b#xX$c#xX$d#xX$e#xX$f#xX$g#xX$h#xX$i#xX$j#xX$k#xX$l#xX$m#xX$n#xX$o#xX$p#xX$q#xX$r#xX$s#xX$t#xX$u#xX$v#xX$w#xX$x#xX$y#xX$z#xX${#xX$|#xX$}#xX%O#xX%P#xX%Q#xX%R#xX%S#xX%T#xX%U#xX%V#xX%W#xX%X#xX%Y#xX%Z#xX%[#xX%]#xX%^#xX%_#xX%`#xX%a#xX%b#xX%c#xX%d#xX%e#xX%f#xX%g#xX%h#xX%i#xX%j#xX%k#xX%l#xX%m#xX%n#xX%o#xX%p#xX%q#xX%r#xX%s#xX%t#xX%w#xX%x#xX%y#xX%{#xX~Ot#WO%|#ZO~O%{[OU#yXV#yXf#yXg#yXh#yXx#yX{#yX|#yX}#yX!O#yX!P#yX!Q#yX!R#yX!S#yX!T#yX!U#yX!V#yX$T#yX$W#yX%u#yX$_#yX$^#yX~O$]#]O~O$_#aO~PYOd!vOe!vOUnaVnafnagnahnaxna{na|na}na!Ona!Pna!Qna!Rna!Sna!Tna!Una!Vna$Tna$Wna%una$_na$^na~OP#eOQ#cOR#cOWyPXyPYyPZyP[yP]yP^yP_yP`yPayPbyPcyP!ZyP#uyP$XyP$YyP$]yP$`yP$ayP$byP$cyP$dyP$eyP$fyP$gyP$hyP$iyP$jyP$kyP$lyP$myP$nyP$oyP$pyP$qyP$ryP$syP$tyP$uyP$vyP$wyP$xyP$yyP$zyP${yP$|yP$}yP%OyP%PyP%QyP%RyP%SyP%TyP%UyP%VyP%WyP%XyP%YyP%ZyP%[yP%]yP%^yP%_yP%`yP%ayP%byP%cyP%dyP%eyP%fyP%gyP%hyP%iyP%jyP%kyP%lyP%myP%nyP%oyP%pyP%qyP%ryP%syP%tyP%wyP%xyP%yyP%{yP~O#q#kO~O!P#mO#q#lO~Oi#oOj#oO$XVO$YVO%w#nO%x#nO%yVO~O$_#rO~P'`Ox!zOU#waV#waf#wag#wah#wa{#wa|#wa}#wa!O#wa!P#wa!Q#wa!R#wa!S#wa!T#wa!U#wa!V#wa$T#wa$W#wa%u#wa$_#wa$^#wa~O!V#sO$P#sO$Q#sO$R#sO~O$^#uO%|#vO~Ot#wO$_#zO~O$^#{O$_#|O~O$^vX$_vX~P'`OWyXXyXYyXZyX[yX]yX^yX_yX`yXayXbyXcyX!ZyX#uyX$XyX$YyX$]yX$`yX$ayX$byX$cyX$dyX$eyX$fyX$gyX$hyX$iyX$jyX$kyX$lyX$myX$nyX$oyX$pyX$qyX$ryX$syX$tyX$uyX$vyX$wyX$xyX$yyX$zyX${yX$|yX$}yX%OyX%PyX%QyX%RyX%SyX%TyX%UyX%VyX%WyX%XyX%YyX%ZyX%[yX%]yX%^yX%_yX%`yX%ayX%byX%cyX%dyX%eyX%fyX%gyX%hyX%iyX%jyX%kyX%lyX%myX%nyX%oyX%pyX%qyX%ryX%syX%tyX%wyX%xyX%yyX%{yX~OS$OOT$OO~P;mOQ#cOR#cO~P;mO%v$VO%z$WO~O#q$XO~O$X#TO$Y#TO%y#TO~O$]$YO~O#u$ZO~Ot#WO%|$]O~O$^$^O$_$_O~OWyaXyaYyaZya[ya]ya^ya_ya`yaayabyacya!Zya#uya$Xya$Yya$`ya$aya$bya$cya$dya$eya$fya$gya$hya$iya$jya$kya$lya$mya$nya$oya$pya$qya$rya$sya$tya$uya$vya$wya$xya$yya$zya${ya$|ya$}ya%Oya%Pya%Qya%Rya%Sya%Tya%Uya%Vya%Wya%Xya%Yya%Zya%[ya%]ya%^ya%_ya%`ya%aya%bya%cya%dya%eya%fya%gya%hya%iya%jya%kya%lya%mya%nya%oya%pya%qya%rya%sya%tya%wya%xya%yya%{ya~O$]#]O~PB{OS$bOT$bO$]ya~PB{Ox!zOUwqfwqgwqhwq!Owq!Pwq!Qwq!Rwq!Swq!Twq!Uwq!Vwq$Twq$Wwq%uwq$_wq$^wq~OVwq{wq|wq}wq~PISOV!zO{!zO|!zO}!zO~PISOV!zOx!zO{!zO|!zO}!zO!O!{O!P!{OUwqfwqgwqhwq$Twq$Wwq%uwq$_wq$^wq~O!Qwq!Rwq!Swq!Twq!Uwq!Vwq~PKOO!Q!|O!R!|O!S!|O!T!|O!U!|O!V!|O~PKOOV!zOf!}Oh!}Ox!zO{!zO|!zO}!zO!O!{O!P!{O!Q!|O!R!|O!S!|O!T!|O!U!|O!V!|O~OUwqgwq$Twq$Wwq%uwq$_wq$^wq~PMQO#q$dO%v$cO~O$_$eO~Ot#wO$_$gO~O$^vi$_vi~P'`O$]#]OWyiXyiYyiZyi[yi]yi^yi_yi`yiayibyicyi!Zyi#uyi$Xyi$Yyi$`yi$ayi$byi$cyi$dyi$eyi$fyi$gyi$hyi$iyi$jyi$kyi$lyi$myi$nyi$oyi$pyi$qyi$ryi$syi$tyi$uyi$vyi$wyi$xyi$yyi$zyi${yi$|yi$}yi%Oyi%Pyi%Qyi%Ryi%Syi%Tyi%Uyi%Vyi%Wyi%Xyi%Yyi%Zyi%[yi%]yi%^yi%_yi%`yi%ayi%byi%cyi%dyi%eyi%fyi%gyi%hyi%iyi%jyi%kyi%lyi%myi%nyi%oyi%pyi%qyi%ryi%syi%tyi%wyi%xyi%yyi%{yi~O%v$iO~O",
  goto: "(v$VPPPPPPPPPPPPPPPPPPPPPPPPPPPPP$W$v%S%`%f%r%uP%{&U$vP&X&hPPPPPPPPPPP$v&r'OP'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O'O$vP'[$v$vP$v$v'k$v'w(W(g(j(pPPP$vP(sQSOQ#UXQ#VYQ#`!wQ$Q#fQ$R#gQ$S#hQ$T#iQ$U#jR$`#{e_OXY!w#f#g#h#i#j#{eROXY!w#f#g#h#i#j#{Q!xRR#b!yQ#^!vQ#}#cQ$a$OR$h$bR#x#]Q#y#]R$f$^Q!yRQ#SUR#b!xR#_!wQ#f!zQ#g!{Q#h!|Q#i!}R#j#OY#d!z!{!|!}#OR$P#eeUOXY!w#f#g#h#i#j#{eTOXY!w#f#g#h#i#j#{d_OXY!w#f#g#h#i#j#{R#p#ReYOXY!w#f#g#h#i#j#{d]OXY!w#f#g#h#i#j#{R!uPd^OXY!w#f#g#h#i#j#{R#[]R#X[Q#Y[R$[#uR#t#WR#q#R",
  nodeNames: "⚠ Bool Ignoring On GroupLeft GroupRight Offset Atan2 Avg Bottomk Count CountValues Group Max Min Quantile Stddev Stdvar Sum Topk By Without And Or Unless Start End LineComment PromQL Expr AggregateExpr AggregateOp AggregateModifier GroupingLabels GroupingLabelList GroupingLabel LabelName FunctionCallBody FunctionCallArgs BinaryExpr Pow BinModifiers OnOrIgnoring Mul Div Mod Add Sub Eql Gte Gtr Lte Lss Neq FunctionCall FunctionIdentifier AbsentOverTime Identifier Absent Abs Acos Acosh Asin Asinh Atan Atanh AvgOverTime Ceil Changes Clamp ClampMax ClampMin Cos Cosh CountOverTime DaysInMonth DayOfMonth DayOfWeek DayOfYear Deg Delta Deriv Exp Floor HistogramQuantile HoltWinters Hour Idelta Increase Irate LabelReplace LabelJoin LastOverTime Ln Log10 Log2 MaxOverTime MinOverTime Minute Month Pi PredictLinear PresentOverTime QuantileOverTime Rad Rate Resets Round Scalar Sgn Sin Sinh Sort SortDesc Sqrt StddevOverTime StdvarOverTime SumOverTime Tan Tanh Timestamp Time Vector Year MatrixSelector Duration NumberLiteral OffsetExpr ParenExpr StringLiteral SubqueryExpr UnaryExpr UnaryOp VectorSelector MetricIdentifier LabelMatchers LabelMatchList LabelMatcher MatchOp EqlSingle EqlRegex NeqRegex StepInvariantExpr At AtModifierPreprocessors MetricName",
  maxTerm: 228,
  propSources: [promQLHighLight],
  skippedNodes: [0,27],
  repeatNodeCount: 0,
  tokenData: "1R~RwX^#lpq#lqr$ars$tst%huv%swx%xxy&gyz&lz{&q{|&v|}&}}!O'S!O!P'Z!P!Q(Z!Q!R(`!R![)W![!]-r!^!_.n!_!`.{!`!a/b!b!c/o!c!}/t!}#O0[#P#Q0a#Q#R0f#R#S/t#S#T0k#T#o/t#o#p0w#q#r0|#y#z#l$f$g#l#BY#BZ#l$IS$I_#l$I|$JO#l$JT$JU#l$KV$KW#l&FU&FV#l~#qY$[~X^#lpq#l#y#z#l$f$g#l#BY#BZ#l$IS$I_#l$I|$JO#l$JT$JU#l$KV$KW#l&FU&FV#l~$dQ!_!`$j#r#s$o~$oO!V~~$tO$R~~$yU#u~OY$tZr$trs%]s#O$t#O#P%b#P~$t~%bO#u~~%ePO~$t~%mQk~OY%hZ~%h~%xO}~~%}U#u~OY%xZw%xwx%]x#O%x#O#P&a#P~%x~&dPO~%x~&lO$]~~&qO$_~~&vO{~R&}O%xP!OQ~'SO$^~R'ZO%wP!PQP'^P!Q!['aP'fR%yP!Q!['a!g!h'o#X#Y'oP'rR{|'{}!O'{!Q![(RP(OP!Q![(RP(WP%yP!Q![(R~(`O|~R(eZ%yP!O!P'a!Q![)W!g!h'o#W#X){#X#Y'o#[#]*d#a#b*x#g#h+l#k#l+}#l#m-W#m#n,iR)]Y%yP!O!P'a!Q![)W!g!h'o#W#X){#X#Y'o#[#]*d#a#b*x#g#h+l#k#l+}#m#n,iQ*QP#qQ!Q![*TQ*WS!Q![*T#[#]*d#a#b*x#g#h+lQ*iP#qQ!Q![*lQ*oR!Q![*l#a#b*x#g#h+lQ*}Q#qQ!Q![+T#g#h+gQ+WR!Q![+T#a#b+a#g#h+lQ+dP#g#h+gQ+lO#qQQ+qP#qQ!Q![+tQ+wQ!Q![+t#a#b+aQ,SP#qQ!Q![,VQ,YT!Q![,V#W#X){#[#]*d#a#b*x#g#h+lQ,nP#qQ!Q![,qQ,tU!Q![,q#W#X){#[#]*d#a#b*x#g#h+l#k#l+}P-ZR!Q![-d!c!i-d#T#Z-dP-iR%yP!Q![-d!c!i-d#T#Z-dV-yT%zS!ZR!Q![.Y![!].Y!c!}.Y#R#S.Y#T#o.YR._T!ZR!Q![.Y![!].Y!c!}.Y#R#S.Y#T#o.Y~.sP!U~!_!`.v~.{O!T~~/QQ$PP!_!`/W#r#s/]Q/]O!QQ~/bO$Q~~/gP!S~!_!`/j~/oO!R~~/tO$T~V/{T!ZRtS!Q![/t![!].Y!c!}/t#R#S/t#T#o/t~0aO%u~~0fO%v~~0kOx~~0nRO#S0k#S#T%]#T~0k~0|O%{~~1RO%|~",
  tokenizers: [0, 1, 2],
  topRules: {"PromQL":[0,28],"MetricName":[1,145]},
  specialized: [{term: 57, get: (value, stack) => (specializeIdentifier(value) << 1)},{term: 57, get: (value, stack) => (extendIdentifier(value) << 1) | 1},{term: 57, get: value => spec_Identifier[value] || -1}],
  tokenPrec: 0
});
// This file was generated by lezer-generator. You probably shouldn't edit it.
const inf = 147,
  nan = 148,
  Bool = 1,
  Ignoring = 2,
  On = 3,
  GroupLeft = 4,
  GroupRight = 5,
  Offset = 6,
  Atan2 = 7,
  Avg = 8,
  Bottomk = 9,
  Count = 10,
  CountValues = 11,
  Group = 12,
  Max = 13,
  Min = 14,
  Quantile = 15,
  Stddev = 16,
  Stdvar = 17,
  Sum = 18,
  Topk = 19,
  By = 20,
  Without = 21,
  And = 22,
  Or = 23,
  Unless = 24,
  Start = 25,
  End = 26,
  LineComment = 27,
  PromQL = 28,
  Expr = 29,
  AggregateExpr = 30,
  AggregateOp = 31,
  AggregateModifier = 32,
  GroupingLabels = 33,
  GroupingLabelList = 34,
  GroupingLabel = 35,
  LabelName = 36,
  FunctionCallBody = 37,
  FunctionCallArgs = 38,
  BinaryExpr = 39,
  Pow = 40,
  BinModifiers = 41,
  OnOrIgnoring = 42,
  Mul = 43,
  Div = 44,
  Mod = 45,
  Add = 46,
  Sub = 47,
  Eql = 48,
  Gte = 49,
  Gtr = 50,
  Lte = 51,
  Lss = 52,
  Neq = 53,
  FunctionCall = 54,
  FunctionIdentifier = 55,
  AbsentOverTime = 56,
  Identifier = 57,
  Absent = 58,
  Abs = 59,
  Acos = 60,
  Acosh = 61,
  Asin = 62,
  Asinh = 63,
  Atan = 64,
  Atanh = 65,
  AvgOverTime = 66,
  Ceil = 67,
  Changes = 68,
  Clamp = 69,
  ClampMax = 70,
  ClampMin = 71,
  Cos = 72,
  Cosh = 73,
  CountOverTime = 74,
  DaysInMonth = 75,
  DayOfMonth = 76,
  DayOfWeek = 77,
  DayOfYear = 78,
  Deg = 79,
  Delta = 80,
  Deriv = 81,
  Exp = 82,
  Floor = 83,
  HistogramQuantile = 84,
  HoltWinters = 85,
  Hour = 86,
  Idelta = 87,
  Increase = 88,
  Irate = 89,
  LabelReplace = 90,
  LabelJoin = 91,
  LastOverTime = 92,
  Ln = 93,
  Log10 = 94,
  Log2 = 95,
  MaxOverTime = 96,
  MinOverTime = 97,
  Minute = 98,
  Month = 99,
  Pi = 100,
  PredictLinear = 101,
  PresentOverTime = 102,
  QuantileOverTime = 103,
  Rad = 104,
  Rate = 105,
  Resets = 106,
  Round = 107,
  Scalar = 108,
  Sgn = 109,
  Sin = 110,
  Sinh = 111,
  Sort = 112,
  SortDesc = 113,
  Sqrt = 114,
  StddevOverTime = 115,
  StdvarOverTime = 116,
  SumOverTime = 117,
  Tan = 118,
  Tanh = 119,
  Timestamp = 120,
  Time = 121,
  Vector = 122,
  Year = 123,
  MatrixSelector = 124,
  Duration = 125,
  NumberLiteral = 126,
  OffsetExpr = 127,
  ParenExpr = 128,
  StringLiteral = 129,
  SubqueryExpr = 130,
  UnaryExpr = 131,
  UnaryOp = 132,
  VectorSelector = 133,
  MetricIdentifier = 134,
  LabelMatchers = 135,
  LabelMatchList = 136,
  LabelMatcher = 137,
  MatchOp = 138,
  EqlSingle = 139,
  EqlRegex = 140,
  NeqRegex = 141,
  StepInvariantExpr = 142,
  At = 143,
  AtModifierPreprocessors = 144,
  MetricName = 145;

exports.Abs = Abs;
exports.Absent = Absent;
exports.AbsentOverTime = AbsentOverTime;
exports.Acos = Acos;
exports.Acosh = Acosh;
exports.Add = Add;
exports.AggregateExpr = AggregateExpr;
exports.AggregateModifier = AggregateModifier;
exports.AggregateOp = AggregateOp;
exports.And = And;
exports.Asin = Asin;
exports.Asinh = Asinh;
exports.At = At;
exports.AtModifierPreprocessors = AtModifierPreprocessors;
exports.Atan = Atan;
exports.Atan2 = Atan2;
exports.Atanh = Atanh;
exports.Avg = Avg;
exports.AvgOverTime = AvgOverTime;
exports.BinModifiers = BinModifiers;
exports.BinaryExpr = BinaryExpr;
exports.Bool = Bool;
exports.Bottomk = Bottomk;
exports.By = By;
exports.Ceil = Ceil;
exports.Changes = Changes;
exports.Clamp = Clamp;
exports.ClampMax = ClampMax;
exports.ClampMin = ClampMin;
exports.Cos = Cos;
exports.Cosh = Cosh;
exports.Count = Count;
exports.CountOverTime = CountOverTime;
exports.CountValues = CountValues;
exports.DayOfMonth = DayOfMonth;
exports.DayOfWeek = DayOfWeek;
exports.DayOfYear = DayOfYear;
exports.DaysInMonth = DaysInMonth;
exports.Deg = Deg;
exports.Delta = Delta;
exports.Deriv = Deriv;
exports.Div = Div;
exports.Duration = Duration;
exports.End = End;
exports.Eql = Eql;
exports.EqlRegex = EqlRegex;
exports.EqlSingle = EqlSingle;
exports.Exp = Exp;
exports.Expr = Expr;
exports.Floor = Floor;
exports.FunctionCall = FunctionCall;
exports.FunctionCallArgs = FunctionCallArgs;
exports.FunctionCallBody = FunctionCallBody;
exports.FunctionIdentifier = FunctionIdentifier;
exports.Group = Group;
exports.GroupLeft = GroupLeft;
exports.GroupRight = GroupRight;
exports.GroupingLabel = GroupingLabel;
exports.GroupingLabelList = GroupingLabelList;
exports.GroupingLabels = GroupingLabels;
exports.Gte = Gte;
exports.Gtr = Gtr;
exports.HistogramQuantile = HistogramQuantile;
exports.HoltWinters = HoltWinters;
exports.Hour = Hour;
exports.Idelta = Idelta;
exports.Identifier = Identifier;
exports.Ignoring = Ignoring;
exports.Increase = Increase;
exports.Irate = Irate;
exports.LabelJoin = LabelJoin;
exports.LabelMatchList = LabelMatchList;
exports.LabelMatcher = LabelMatcher;
exports.LabelMatchers = LabelMatchers;
exports.LabelName = LabelName;
exports.LabelReplace = LabelReplace;
exports.LastOverTime = LastOverTime;
exports.LineComment = LineComment;
exports.Ln = Ln;
exports.Log10 = Log10;
exports.Log2 = Log2;
exports.Lss = Lss;
exports.Lte = Lte;
exports.MatchOp = MatchOp;
exports.MatrixSelector = MatrixSelector;
exports.Max = Max;
exports.MaxOverTime = MaxOverTime;
exports.MetricIdentifier = MetricIdentifier;
exports.MetricName = MetricName;
exports.Min = Min;
exports.MinOverTime = MinOverTime;
exports.Minute = Minute;
exports.Mod = Mod;
exports.Month = Month;
exports.Mul = Mul;
exports.Neq = Neq;
exports.NeqRegex = NeqRegex;
exports.NumberLiteral = NumberLiteral;
exports.Offset = Offset;
exports.OffsetExpr = OffsetExpr;
exports.On = On;
exports.OnOrIgnoring = OnOrIgnoring;
exports.Or = Or;
exports.ParenExpr = ParenExpr;
exports.Pi = Pi;
exports.Pow = Pow;
exports.PredictLinear = PredictLinear;
exports.PresentOverTime = PresentOverTime;
exports.PromQL = PromQL;
exports.Quantile = Quantile;
exports.QuantileOverTime = QuantileOverTime;
exports.Rad = Rad;
exports.Rate = Rate;
exports.Resets = Resets;
exports.Round = Round;
exports.Scalar = Scalar;
exports.Sgn = Sgn;
exports.Sin = Sin;
exports.Sinh = Sinh;
exports.Sort = Sort;
exports.SortDesc = SortDesc;
exports.Sqrt = Sqrt;
exports.Start = Start;
exports.Stddev = Stddev;
exports.StddevOverTime = StddevOverTime;
exports.Stdvar = Stdvar;
exports.StdvarOverTime = StdvarOverTime;
exports.StepInvariantExpr = StepInvariantExpr;
exports.StringLiteral = StringLiteral;
exports.Sub = Sub;
exports.SubqueryExpr = SubqueryExpr;
exports.Sum = Sum;
exports.SumOverTime = SumOverTime;
exports.Tan = Tan;
exports.Tanh = Tanh;
exports.Time = Time;
exports.Timestamp = Timestamp;
exports.Topk = Topk;
exports.UnaryExpr = UnaryExpr;
exports.UnaryOp = UnaryOp;
exports.Unless = Unless;
exports.Vector = Vector;
exports.VectorSelector = VectorSelector;
exports.Without = Without;
exports.Year = Year;
exports.inf = inf;
exports.nan = nan;
exports.parser = parser;
