var $6vrKB$reactariautils = require("@react-aria/utils");
var $6vrKB$reactariafocus = require("@react-aria/focus");
var $6vrKB$react = require("react");

function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}

$parcel$export(module.exports, "useDialog", () => $e7b76b4fae4e4c55$export$d55e7ee900f34e93);



function $e7b76b4fae4e4c55$export$d55e7ee900f34e93(props, ref) {
    let { role: role = 'dialog'  } = props;
    let titleId = $6vrKB$reactariautils.useSlotId();
    titleId = props['aria-label'] ? undefined : titleId;
    // Focus the dialog itself on mount, unless a child element is already focused.
    $6vrKB$react.useEffect(()=>{
        if (ref.current && !ref.current.contains(document.activeElement)) {
            $6vrKB$reactariafocus.focusSafely(ref.current);
            // Safari on iOS does not move the VoiceOver cursor to the dialog
            // or announce that it has opened until it has rendered. A workaround
            // is to wait for half a second, then blur and re-focus the dialog.
            let timeout = setTimeout(()=>{
                if (document.activeElement === ref.current) {
                    ref.current.blur();
                    $6vrKB$reactariafocus.focusSafely(ref.current);
                }
            }, 500);
            return ()=>{
                clearTimeout(timeout);
            };
        }
    }, [
        ref
    ]);
    // We do not use aria-modal due to a Safari bug which forces the first focusable element to be focused
    // on mount when inside an iframe, no matter which element we programmatically focus.
    // See https://bugs.webkit.org/show_bug.cgi?id=211934.
    // useModal sets aria-hidden on all elements outside the dialog, so the dialog will behave as a modal
    // even without aria-modal on the dialog itself.
    return {
        dialogProps: {
            ...$6vrKB$reactariautils.filterDOMProps(props, {
                labelable: true
            }),
            role: role,
            tabIndex: -1,
            'aria-labelledby': props['aria-labelledby'] || titleId
        },
        titleProps: {
            id: titleId
        }
    };
}




//# sourceMappingURL=main.js.map
