Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var ui = require('@grafana/ui');
var React = require('react');
var React__default = _interopDefault(React);
var data = require('@grafana/data');
var runtime = require('@grafana/runtime');
var css = require('@emotion/css');

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

(function (OperatorType) {
    OperatorType[OperatorType["Comparison"] = 0] = "Comparison";
    OperatorType[OperatorType["Logical"] = 1] = "Logical";
})(exports.OperatorType || (exports.OperatorType = {}));
(function (MacroType) {
    MacroType[MacroType["Value"] = 0] = "Value";
    MacroType[MacroType["Filter"] = 1] = "Filter";
    MacroType[MacroType["Group"] = 2] = "Group";
    MacroType[MacroType["Column"] = 3] = "Column";
    MacroType[MacroType["Table"] = 4] = "Table";
})(exports.MacroType || (exports.MacroType = {}));
(function (TokenType) {
    TokenType["Parenthesis"] = "delimiter.parenthesis.sql";
    TokenType["Whitespace"] = "white.sql";
    TokenType["Keyword"] = "keyword.sql";
    TokenType["Delimiter"] = "delimiter.sql";
    TokenType["Operator"] = "operator.sql";
    TokenType["Identifier"] = "identifier.sql";
    TokenType["IdentifierQuote"] = "identifier.quote.sql";
    TokenType["Type"] = "type.sql";
    TokenType["Function"] = "predefined.sql";
    TokenType["Number"] = "number.sql";
    TokenType["String"] = "string.sql";
    TokenType["Variable"] = "variable.sql";
})(exports.TokenType || (exports.TokenType = {}));
(function (StatementPosition) {
    StatementPosition["Unknown"] = "unknown";
    StatementPosition["SelectKeyword"] = "selectKeyword";
    StatementPosition["WithKeyword"] = "withKeyword";
    StatementPosition["AfterSelectKeyword"] = "afterSelectKeyword";
    StatementPosition["AfterSelectArguments"] = "afterSelectArguments";
    StatementPosition["AfterSelectFuncFirstArgument"] = "afterSelectFuncFirstArgument";
    StatementPosition["SelectAlias"] = "selectAlias";
    StatementPosition["AfterFromKeyword"] = "afterFromKeyword";
    StatementPosition["AfterTable"] = "afterTable";
    StatementPosition["SchemaFuncFirstArgument"] = "schemaFuncFirstArgument";
    StatementPosition["SchemaFuncExtraArgument"] = "schemaFuncExtraArgument";
    StatementPosition["FromKeyword"] = "fromKeyword";
    StatementPosition["AfterFrom"] = "afterFrom";
    StatementPosition["WhereKeyword"] = "whereKeyword";
    StatementPosition["WhereComparisonOperator"] = "whereComparisonOperator";
    StatementPosition["WhereValue"] = "whereValue";
    StatementPosition["AfterWhereFunctionArgument"] = "afterWhereFunctionArgument";
    StatementPosition["AfterGroupByFunctionArgument"] = "afterGroupByFunctionArgument";
    StatementPosition["AfterWhereValue"] = "afterWhereValue";
    StatementPosition["AfterGroupByKeywords"] = "afterGroupByKeywords";
    StatementPosition["AfterGroupBy"] = "afterGroupBy";
    StatementPosition["AfterOrderByKeywords"] = "afterOrderByKeywords";
    StatementPosition["AfterOrderByFunction"] = "afterOrderByFunction";
    StatementPosition["AfterOrderByDirection"] = "afterOrderByDirection";
    StatementPosition["AfterIsOperator"] = "afterIsOperator";
    StatementPosition["AfterIsNotOperator"] = "afterIsNotOperator";
    StatementPosition["AfterSchema"] = "afterSchema";
})(exports.StatementPosition || (exports.StatementPosition = {}));
(function (SuggestionKind) {
    SuggestionKind["Schemas"] = "schemas";
    SuggestionKind["Tables"] = "tables";
    SuggestionKind["Columns"] = "columns";
    SuggestionKind["SelectKeyword"] = "selectKeyword";
    SuggestionKind["WithKeyword"] = "withKeyword";
    SuggestionKind["FunctionsWithArguments"] = "functionsWithArguments";
    SuggestionKind["FromKeyword"] = "fromKeyword";
    SuggestionKind["WhereKeyword"] = "whereKeyword";
    SuggestionKind["GroupByKeywords"] = "groupByKeywords";
    SuggestionKind["OrderByKeywords"] = "orderByKeywords";
    SuggestionKind["FunctionsWithoutArguments"] = "functionsWithoutArguments";
    SuggestionKind["LimitKeyword"] = "limitKeyword";
    SuggestionKind["SortOrderDirectionKeyword"] = "sortOrderDirectionKeyword";
    SuggestionKind["ComparisonOperators"] = "comparisonOperators";
    SuggestionKind["LogicalOperators"] = "logicalOperators";
    SuggestionKind["SelectMacro"] = "selectMacro";
    SuggestionKind["TableMacro"] = "tableMacro";
    SuggestionKind["FilterMacro"] = "filterMacro";
    SuggestionKind["GroupMacro"] = "groupMacro";
    SuggestionKind["BoolValues"] = "boolValues";
    SuggestionKind["NullValue"] = "nullValue";
    SuggestionKind["NotKeyword"] = "notKeyword";
    SuggestionKind["TemplateVariables"] = "templateVariables";
    SuggestionKind["StarWildCard"] = "starWildCard";
})(exports.SuggestionKind || (exports.SuggestionKind = {}));
(function (CompletionItemPriority) {
    CompletionItemPriority["High"] = "a";
    CompletionItemPriority["MediumHigh"] = "d";
    CompletionItemPriority["Medium"] = "g";
    CompletionItemPriority["MediumLow"] = "k";
    CompletionItemPriority["Low"] = "q";
})(exports.CompletionItemPriority || (exports.CompletionItemPriority = {}));
(function (CompletionItemKind) {
    CompletionItemKind[CompletionItemKind["Method"] = 0] = "Method";
    CompletionItemKind[CompletionItemKind["Function"] = 1] = "Function";
    CompletionItemKind[CompletionItemKind["Constructor"] = 2] = "Constructor";
    CompletionItemKind[CompletionItemKind["Field"] = 3] = "Field";
    CompletionItemKind[CompletionItemKind["Variable"] = 4] = "Variable";
    CompletionItemKind[CompletionItemKind["Class"] = 5] = "Class";
    CompletionItemKind[CompletionItemKind["Struct"] = 6] = "Struct";
    CompletionItemKind[CompletionItemKind["Interface"] = 7] = "Interface";
    CompletionItemKind[CompletionItemKind["Module"] = 8] = "Module";
    CompletionItemKind[CompletionItemKind["Property"] = 9] = "Property";
    CompletionItemKind[CompletionItemKind["Event"] = 10] = "Event";
    CompletionItemKind[CompletionItemKind["Operator"] = 11] = "Operator";
    CompletionItemKind[CompletionItemKind["Unit"] = 12] = "Unit";
    CompletionItemKind[CompletionItemKind["Value"] = 13] = "Value";
    CompletionItemKind[CompletionItemKind["Constant"] = 14] = "Constant";
    CompletionItemKind[CompletionItemKind["Enum"] = 15] = "Enum";
    CompletionItemKind[CompletionItemKind["EnumMember"] = 16] = "EnumMember";
    CompletionItemKind[CompletionItemKind["Keyword"] = 17] = "Keyword";
    CompletionItemKind[CompletionItemKind["Text"] = 18] = "Text";
    CompletionItemKind[CompletionItemKind["Color"] = 19] = "Color";
    CompletionItemKind[CompletionItemKind["File"] = 20] = "File";
    CompletionItemKind[CompletionItemKind["Reference"] = 21] = "Reference";
    CompletionItemKind[CompletionItemKind["Customcolor"] = 22] = "Customcolor";
    CompletionItemKind[CompletionItemKind["Folder"] = 23] = "Folder";
    CompletionItemKind[CompletionItemKind["TypeParameter"] = 24] = "TypeParameter";
    CompletionItemKind[CompletionItemKind["User"] = 25] = "User";
    CompletionItemKind[CompletionItemKind["Issue"] = 26] = "Issue";
    CompletionItemKind[CompletionItemKind["Snippet"] = 27] = "Snippet";
})(exports.CompletionItemKind || (exports.CompletionItemKind = {}));
(function (CompletionItemInsertTextRule) {
    CompletionItemInsertTextRule[CompletionItemInsertTextRule["KeepWhitespace"] = 1] = "KeepWhitespace";
    CompletionItemInsertTextRule[CompletionItemInsertTextRule["InsertAsSnippet"] = 4] = "InsertAsSnippet";
})(exports.CompletionItemInsertTextRule || (exports.CompletionItemInsertTextRule = {}));
(function (EditorMode) {
    EditorMode["Builder"] = "builder";
    EditorMode["Code"] = "code";
})(exports.EditorMode || (exports.EditorMode = {}));

// Given current cursor position in the SQL editor, returns the statement position.
function getStatementPosition(currentToken, statementPositionResolversRegistry) {
    var e_1, _a;
    var _b;
    var previousNonWhiteSpace = currentToken === null || currentToken === void 0 ? void 0 : currentToken.getPreviousNonWhiteSpaceToken();
    var previousKeyword = currentToken === null || currentToken === void 0 ? void 0 : currentToken.getPreviousKeyword();
    var previousIsSlash = (_b = currentToken === null || currentToken === void 0 ? void 0 : currentToken.getPreviousNonWhiteSpaceToken()) === null || _b === void 0 ? void 0 : _b.is(exports.TokenType.Operator, '/');
    var resolvers = statementPositionResolversRegistry.list();
    var positions = [];
    try {
        for (var resolvers_1 = __values(resolvers), resolvers_1_1 = resolvers_1.next(); !resolvers_1_1.done; resolvers_1_1 = resolvers_1.next()) {
            var resolver = resolvers_1_1.value;
            if (resolver.resolve(currentToken, previousKeyword !== null && previousKeyword !== void 0 ? previousKeyword : null, previousNonWhiteSpace !== null && previousNonWhiteSpace !== void 0 ? previousNonWhiteSpace : null, Boolean(previousIsSlash))) {
                positions.push(resolver.id);
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (resolvers_1_1 && !resolvers_1_1.done && (_a = resolvers_1.return)) _a.call(resolvers_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (positions.length === 0) {
        return [exports.StatementPosition.Unknown];
    }
    return positions;
}

var toCompletionItem = function (value, range, rest) {
    if (rest === void 0) { rest = {}; }
    var item = __assign({ label: value, insertText: value, kind: exports.CompletionItemKind.Field, sortText: exports.CompletionItemPriority.Medium, range: range }, rest);
    return item;
};

// Given standard and custom registered suggestions and kinds of suggestion expected, return a list of completion items
var getStandardSuggestions = function (monaco, currentToken, suggestionKinds, positionContext, suggestionsRegistry) { return __awaiter(void 0, void 0, void 0, function () {
    var suggestions, invalidRangeToken, range, _a, _b, suggestion, registeredSuggestions, su, e_1_1;
    var e_1, _c;
    return __generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                suggestions = [];
                invalidRangeToken = (currentToken === null || currentToken === void 0 ? void 0 : currentToken.isWhiteSpace()) ||
                    (currentToken === null || currentToken === void 0 ? void 0 : currentToken.isParenthesis()) ||
                    ((currentToken === null || currentToken === void 0 ? void 0 : currentToken.isIdentifier()) && currentToken.value.endsWith('.'));
                range = invalidRangeToken || !(currentToken === null || currentToken === void 0 ? void 0 : currentToken.range)
                    ? monaco.Range.fromPositions(positionContext.position)
                    : currentToken === null || currentToken === void 0 ? void 0 : currentToken.range;
                _d.label = 1;
            case 1:
                _d.trys.push([1, 6, 7, 8]);
                _a = __values(__spreadArray([], __read(new Set(suggestionKinds)), false)), _b = _a.next();
                _d.label = 2;
            case 2:
                if (!!_b.done) return [3 /*break*/, 5];
                suggestion = _b.value;
                registeredSuggestions = suggestionsRegistry.getIfExists(suggestion);
                if (!registeredSuggestions) return [3 /*break*/, 4];
                return [4 /*yield*/, registeredSuggestions.suggestions(__assign(__assign({}, positionContext), { range: range }), monaco)];
            case 3:
                su = _d.sent();
                suggestions = __spreadArray(__spreadArray([], __read(suggestions), false), __read(su.map(function (s) { return toCompletionItem(s.label, range, __assign({ kind: s.kind }, s)); })), false);
                _d.label = 4;
            case 4:
                _b = _a.next();
                return [3 /*break*/, 2];
            case 5: return [3 /*break*/, 8];
            case 6:
                e_1_1 = _d.sent();
                e_1 = { error: e_1_1 };
                return [3 /*break*/, 8];
            case 7:
                try {
                    if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                }
                finally { if (e_1) throw e_1.error; }
                return [7 /*endfinally*/];
            case 8: return [2 /*return*/, Promise.resolve(suggestions)];
        }
    });
}); };

// Registry of possible suggestions for the given statement position
var initSuggestionsKindRegistry = function () {
    return [
        {
            id: exports.StatementPosition.SelectKeyword,
            name: exports.StatementPosition.SelectKeyword,
            kind: [exports.SuggestionKind.SelectKeyword],
        },
        {
            id: exports.StatementPosition.WithKeyword,
            name: exports.StatementPosition.WithKeyword,
            kind: [exports.SuggestionKind.WithKeyword],
        },
        {
            id: exports.StatementPosition.AfterSelectKeyword,
            name: exports.StatementPosition.AfterSelectKeyword,
            kind: [
                exports.SuggestionKind.StarWildCard,
                exports.SuggestionKind.FunctionsWithArguments,
                exports.SuggestionKind.Columns,
                exports.SuggestionKind.SelectMacro,
            ],
        },
        {
            id: exports.StatementPosition.AfterSelectFuncFirstArgument,
            name: exports.StatementPosition.AfterSelectFuncFirstArgument,
            kind: [exports.SuggestionKind.Columns],
        },
        {
            id: exports.StatementPosition.AfterGroupByFunctionArgument,
            name: exports.StatementPosition.AfterGroupByFunctionArgument,
            kind: [exports.SuggestionKind.Columns],
        },
        {
            id: exports.StatementPosition.AfterWhereFunctionArgument,
            name: exports.StatementPosition.AfterWhereFunctionArgument,
            kind: [exports.SuggestionKind.Columns],
        },
        {
            id: exports.StatementPosition.AfterSelectArguments,
            name: exports.StatementPosition.AfterSelectArguments,
            kind: [exports.SuggestionKind.Columns],
        },
        {
            id: exports.StatementPosition.AfterFromKeyword,
            name: exports.StatementPosition.AfterFromKeyword,
            kind: [exports.SuggestionKind.Schemas, exports.SuggestionKind.Tables, exports.SuggestionKind.TableMacro],
        },
        {
            id: exports.StatementPosition.AfterSchema,
            name: exports.StatementPosition.AfterSchema,
            kind: [exports.SuggestionKind.Tables, exports.SuggestionKind.TableMacro],
        },
        {
            id: exports.StatementPosition.SelectAlias,
            name: exports.StatementPosition.SelectAlias,
            kind: [exports.SuggestionKind.Columns, exports.SuggestionKind.FunctionsWithArguments],
        },
        {
            id: exports.StatementPosition.FromKeyword,
            name: exports.StatementPosition.FromKeyword,
            kind: [exports.SuggestionKind.FromKeyword],
        },
        {
            id: exports.StatementPosition.AfterFrom,
            name: exports.StatementPosition.AfterFrom,
            kind: [
                exports.SuggestionKind.WhereKeyword,
                exports.SuggestionKind.GroupByKeywords,
                exports.SuggestionKind.OrderByKeywords,
                exports.SuggestionKind.LimitKeyword,
            ],
        },
        {
            id: exports.StatementPosition.AfterTable,
            name: exports.StatementPosition.AfterTable,
            kind: [
                exports.SuggestionKind.WhereKeyword,
                exports.SuggestionKind.GroupByKeywords,
                exports.SuggestionKind.OrderByKeywords,
                exports.SuggestionKind.LimitKeyword,
            ],
        },
        {
            id: exports.StatementPosition.WhereKeyword,
            name: exports.StatementPosition.WhereKeyword,
            kind: [exports.SuggestionKind.Columns, exports.SuggestionKind.FilterMacro, exports.SuggestionKind.TemplateVariables],
        },
        {
            id: exports.StatementPosition.WhereComparisonOperator,
            name: exports.StatementPosition.WhereComparisonOperator,
            kind: [exports.SuggestionKind.ComparisonOperators],
        },
        {
            id: exports.StatementPosition.WhereValue,
            name: exports.StatementPosition.WhereValue,
            kind: [exports.SuggestionKind.FilterMacro, exports.SuggestionKind.TemplateVariables],
        },
        {
            id: exports.StatementPosition.AfterWhereValue,
            name: exports.StatementPosition.AfterWhereValue,
            kind: [
                exports.SuggestionKind.LogicalOperators,
                exports.SuggestionKind.GroupByKeywords,
                exports.SuggestionKind.OrderByKeywords,
                exports.SuggestionKind.LimitKeyword,
                exports.SuggestionKind.Columns,
                exports.SuggestionKind.TemplateVariables,
            ],
        },
        {
            id: exports.StatementPosition.AfterGroupByKeywords,
            name: exports.StatementPosition.AfterGroupByKeywords,
            kind: [exports.SuggestionKind.GroupMacro, exports.SuggestionKind.Columns],
        },
        {
            id: exports.StatementPosition.AfterGroupBy,
            name: exports.StatementPosition.AfterGroupBy,
            kind: [exports.SuggestionKind.OrderByKeywords, exports.SuggestionKind.LimitKeyword],
        },
        {
            id: exports.StatementPosition.AfterOrderByKeywords,
            name: exports.StatementPosition.AfterOrderByKeywords,
            kind: [exports.SuggestionKind.Columns],
        },
        {
            id: exports.StatementPosition.AfterOrderByFunction,
            name: exports.StatementPosition.AfterOrderByFunction,
            kind: [exports.SuggestionKind.SortOrderDirectionKeyword, exports.SuggestionKind.LimitKeyword],
        },
        {
            id: exports.StatementPosition.AfterOrderByDirection,
            name: exports.StatementPosition.AfterOrderByDirection,
            kind: [exports.SuggestionKind.LimitKeyword],
        },
        {
            id: exports.StatementPosition.AfterIsOperator,
            name: exports.StatementPosition.AfterOrderByDirection,
            kind: [exports.SuggestionKind.NotKeyword, exports.SuggestionKind.NullValue, exports.SuggestionKind.BoolValues],
        },
        {
            id: exports.StatementPosition.AfterIsNotOperator,
            name: exports.StatementPosition.AfterOrderByDirection,
            kind: [exports.SuggestionKind.NullValue, exports.SuggestionKind.BoolValues],
        },
    ];
};

/**
 * Given statement positions, returns list of suggestion kinds that apply to those positions.
 */
function getSuggestionKinds(statementPosition, suggestionsKindRegistry) {
    var result = [];
    for (var i = 0; i < statementPosition.length; i++) {
        var exists = suggestionsKindRegistry.getIfExists(statementPosition[i]);
        if (exists) {
            result = result.concat(exists.kind);
        }
    }
    return result;
}

var LinkedToken = /** @class */ (function () {
    function LinkedToken(type, value, range, previous, next) {
        this.type = type;
        this.value = value;
        this.range = range;
        this.previous = previous;
        this.next = next;
    }
    LinkedToken.prototype.isKeyword = function () {
        return this.type === exports.TokenType.Keyword;
    };
    LinkedToken.prototype.isWhiteSpace = function () {
        return this.type === exports.TokenType.Whitespace;
    };
    LinkedToken.prototype.isParenthesis = function () {
        return this.type === exports.TokenType.Parenthesis;
    };
    LinkedToken.prototype.isIdentifier = function () {
        return this.type === exports.TokenType.Identifier;
    };
    LinkedToken.prototype.isString = function () {
        return this.type === exports.TokenType.String;
    };
    LinkedToken.prototype.isNumber = function () {
        return this.type === exports.TokenType.Number;
    };
    LinkedToken.prototype.isDoubleQuotedString = function () {
        return this.type === exports.TokenType.Type;
    };
    LinkedToken.prototype.isVariable = function () {
        return this.type === exports.TokenType.Variable;
    };
    LinkedToken.prototype.isFunction = function () {
        return this.type === exports.TokenType.Function;
    };
    LinkedToken.prototype.isOperator = function () {
        return this.type === exports.TokenType.Operator;
    };
    LinkedToken.prototype.isTemplateVariable = function () {
        return this.type === exports.TokenType.Variable;
    };
    LinkedToken.prototype.is = function (type, value) {
        var isType = this.type === type;
        return value !== undefined ? isType && compareTokenWithValue(type, this, value) : isType;
    };
    LinkedToken.prototype.getPreviousNonWhiteSpaceToken = function () {
        var curr = this.previous;
        while (curr != null) {
            if (!curr.isWhiteSpace()) {
                return curr;
            }
            curr = curr.previous;
        }
        return null;
    };
    LinkedToken.prototype.getPreviousOfType = function (type, value) {
        var curr = this.previous;
        while (curr != null) {
            var isType = curr.type === type;
            if (value !== undefined ? isType && compareTokenWithValue(type, curr, value) : isType) {
                return curr;
            }
            curr = curr.previous;
        }
        return null;
    };
    LinkedToken.prototype.getPreviousUntil = function (type, ignoreTypes, value) {
        var tokens = [];
        var curr = this.previous;
        while (curr != null) {
            if (ignoreTypes.some(function (t) { return t === (curr === null || curr === void 0 ? void 0 : curr.type); })) {
                curr = curr.previous;
                continue;
            }
            var isType = curr.type === type;
            if (value !== undefined ? isType && compareTokenWithValue(type, curr, value) : isType) {
                return tokens;
            }
            if (!curr.isWhiteSpace()) {
                tokens.push(curr);
            }
            curr = curr.previous;
        }
        return tokens;
    };
    LinkedToken.prototype.getNextUntil = function (type, ignoreTypes, value) {
        var tokens = [];
        var curr = this.next;
        while (curr != null) {
            if (ignoreTypes.some(function (t) { return t === (curr === null || curr === void 0 ? void 0 : curr.type); })) {
                curr = curr.next;
                continue;
            }
            var isType = curr.type === type;
            if (value !== undefined ? isType && compareTokenWithValue(type, curr, value) : isType) {
                return tokens;
            }
            if (!curr.isWhiteSpace()) {
                tokens.push(curr);
            }
            curr = curr.next;
        }
        return tokens;
    };
    LinkedToken.prototype.getPreviousKeyword = function () {
        var curr = this.previous;
        while (curr != null) {
            if (curr.isKeyword()) {
                return curr;
            }
            curr = curr.previous;
        }
        return null;
    };
    LinkedToken.prototype.getNextNonWhiteSpaceToken = function () {
        var curr = this.next;
        while (curr != null) {
            if (!curr.isWhiteSpace()) {
                return curr;
            }
            curr = curr.next;
        }
        return null;
    };
    LinkedToken.prototype.getNextOfType = function (type, value) {
        var curr = this.next;
        while (curr != null) {
            var isType = curr.type === type;
            if (value !== undefined ? isType && compareTokenWithValue(type, curr, value) : isType) {
                return curr;
            }
            curr = curr.next;
        }
        return null;
    };
    return LinkedToken;
}());
function compareTokenWithValue(type, token, value) {
    return type === exports.TokenType.Keyword || type === exports.TokenType.Operator
        ? token.value.toLowerCase() === value.toString().toLowerCase()
        : token.value === value;
}

function linkedTokenBuilder(monaco, model, position, languageId) {
    var _a;
    if (languageId === void 0) { languageId = 'sql'; }
    var current = null;
    var previous = null;
    var tokensPerLine = monaco.editor.tokenize((_a = model.getValue()) !== null && _a !== void 0 ? _a : '', languageId);
    for (var lineIndex = 0; lineIndex < tokensPerLine.length; lineIndex++) {
        var tokens = tokensPerLine[lineIndex];
        // In case position is first column in new line, add empty whitespace token so that links are not broken
        if (!tokens.length && previous) {
            var token = {
                offset: 0,
                type: exports.TokenType.Whitespace,
                language: languageId,
                _tokenBrand: undefined,
            };
            tokens.push(token);
        }
        for (var columnIndex = 0; columnIndex < tokens.length; columnIndex++) {
            var token = tokens[columnIndex];
            var endColumn = tokens.length > columnIndex + 1 ? tokens[columnIndex + 1].offset + 1 : model.getLineLength(lineIndex + 1) + 1;
            var range = {
                startLineNumber: lineIndex + 1,
                startColumn: token.offset === 0 ? 0 : token.offset + 1,
                endLineNumber: lineIndex + 1,
                endColumn: endColumn,
            };
            var value = model.getValueInRange(range);
            var sqlToken = new LinkedToken(token.type, value, range, previous, null);
            if (monaco.Range.containsPosition(range, position)) {
                current = sqlToken;
            }
            if (previous) {
                previous.next = sqlToken;
            }
            previous = sqlToken;
        }
    }
    return current;
}

// STD basic SQL
var SELECT = 'select';
var FROM = 'from';
var WHERE = 'where';
var GROUP = 'group';
var ORDER = 'order';
var BY = 'by';
var DESC = 'desc';
var ASC = 'asc';
var LIMIT = 'limit';
var WITH = 'with';
var AS = 'as';
var SCHEMA = 'schema';
var AND = 'AND';
var OR = 'OR';
var LOGICAL_OPERATORS = [AND, OR];
var EQUALS = '=';
var NOT_EQUALS = '!=';
var COMPARISON_OPERATORS = [EQUALS, NOT_EQUALS];
var STD_OPERATORS = __spreadArray([], __read(COMPARISON_OPERATORS), false);
var conf = {
    comments: {
        lineComment: '--',
        blockComment: ['/*', '*/'],
    },
    brackets: [
        ['{', '}'],
        ['[', ']'],
        ['(', ')'],
    ],
    autoClosingPairs: [
        { open: '{', close: '}' },
        { open: '[', close: ']' },
        { open: '(', close: ')' },
        { open: '"', close: '"' },
        { open: "'", close: "'" },
    ],
    surroundingPairs: [
        { open: '{', close: '}' },
        { open: '[', close: ']' },
        { open: '(', close: ')' },
        { open: '"', close: '"' },
        { open: "'", close: "'" },
    ],
};
// based on https://github.com/microsoft/monaco-editor/blob/main/src/basic-languages/sql/sql.ts
var language = {
    defaultToken: '',
    tokenPostfix: '.sql',
    ignoreCase: true,
    brackets: [
        { open: '[', close: ']', token: 'delimiter.square' },
        { open: '(', close: ')', token: 'delimiter.parenthesis' },
    ],
    keywords: [
        'ABORT',
        'ABSOLUTE',
        'ACTION',
        'ADA',
        'ADD',
        'AFTER',
        'ALL',
        'ALLOCATE',
        'ALTER',
        'ALWAYS',
        'ANALYZE',
        'AND',
        'ANY',
        'ARE',
        'AS',
        'ASC',
        'ASSERTION',
        'AT',
        'ATTACH',
        'AUTHORIZATION',
        'AUTOINCREMENT',
        'AVG',
        'BACKUP',
        'BEFORE',
        'BEGIN',
        'BETWEEN',
        'BIT',
        'BIT_LENGTH',
        'BOTH',
        'BREAK',
        'BROWSE',
        'BULK',
        'BY',
        'CASCADE',
        'CASCADED',
        'CASE',
        'CAST',
        'CATALOG',
        'CHAR',
        'CHARACTER',
        'CHARACTER_LENGTH',
        'CHAR_LENGTH',
        'CHECK',
        'CHECKPOINT',
        'CLOSE',
        'CLUSTERED',
        'COALESCE',
        'COLLATE',
        'COLLATION',
        'COLUMN',
        'COMMIT',
        'COMPUTE',
        'CONFLICT',
        'CONNECT',
        'CONNECTION',
        'CONSTRAINT',
        'CONSTRAINTS',
        'CONTAINS',
        'CONTAINSTABLE',
        'CONTINUE',
        'CONVERT',
        'CORRESPONDING',
        'COUNT',
        'CREATE',
        'CROSS',
        'CURRENT',
        'CURRENT_DATE',
        'CURRENT_TIME',
        'CURRENT_TIMESTAMP',
        'CURRENT_USER',
        'CURSOR',
        'DATABASE',
        'DATE',
        'DAY',
        'DBCC',
        'DEALLOCATE',
        'DEC',
        'DECIMAL',
        'DECLARE',
        'DEFAULT',
        'DEFERRABLE',
        'DEFERRED',
        'DELETE',
        'DENY',
        'DESC',
        'DESCRIBE',
        'DESCRIPTOR',
        'DETACH',
        'DIAGNOSTICS',
        'DISCONNECT',
        'DISK',
        'DISTINCT',
        'DISTRIBUTED',
        'DO',
        'DOMAIN',
        'DOUBLE',
        'DROP',
        'DUMP',
        'EACH',
        'ELSE',
        'END',
        'END-EXEC',
        'ERRLVL',
        'ESCAPE',
        'EXCEPT',
        'EXCEPTION',
        'EXCLUDE',
        'EXCLUSIVE',
        'EXEC',
        'EXECUTE',
        'EXISTS',
        'EXIT',
        'EXPLAIN',
        'EXTERNAL',
        'EXTRACT',
        'FAIL',
        'FALSE',
        'FETCH',
        'FILE',
        'FILLFACTOR',
        'FILTER',
        'FIRST',
        'FLOAT',
        'FOLLOWING',
        'FOR',
        'FOREIGN',
        'FORTRAN',
        'FOUND',
        'FREETEXT',
        'FREETEXTTABLE',
        'FROM',
        'FULL',
        'FUNCTION',
        'GENERATED',
        'GET',
        'GLOB',
        'GLOBAL',
        'GO',
        'GOTO',
        'GRANT',
        'GROUP',
        'GROUPS',
        'HAVING',
        'HOLDLOCK',
        'HOUR',
        'IDENTITY',
        'IDENTITYCOL',
        'IDENTITY_INSERT',
        'IF',
        'IGNORE',
        'IMMEDIATE',
        'IN',
        'INCLUDE',
        'INDEX',
        'INDEXED',
        'INDICATOR',
        'INITIALLY',
        'INNER',
        'INPUT',
        'INSENSITIVE',
        'INSERT',
        'INSTEAD',
        'INT',
        'INTEGER',
        'INTERSECT',
        'INTERVAL',
        'INTO',
        'IS',
        'ISNULL',
        'ISOLATION',
        'JOIN',
        'KEY',
        'KILL',
        'LANGUAGE',
        'LAST',
        'LEADING',
        'LEFT',
        'LEVEL',
        'LIKE',
        'LIMIT',
        'LINENO',
        'LOAD',
        'LOCAL',
        'LOWER',
        'MATCH',
        'MATERIALIZED',
        'MAX',
        'MERGE',
        'MIN',
        'MINUTE',
        'MODULE',
        'MONTH',
        'NAMES',
        'NATIONAL',
        'NATURAL',
        'NCHAR',
        'NEXT',
        'NO',
        'NOCHECK',
        'NONCLUSTERED',
        'NONE',
        'NOT',
        'NOTHING',
        'NOTNULL',
        'NULL',
        'NULLIF',
        'NULLS',
        'NUMERIC',
        'OCTET_LENGTH',
        'OF',
        'OFF',
        'OFFSET',
        'OFFSETS',
        'ON',
        'ONLY',
        'OPEN',
        'OPENDATASOURCE',
        'OPENQUERY',
        'OPENROWSET',
        'OPENXML',
        'OPTION',
        'OR',
        'ORDER',
        'OTHERS',
        'OUTER',
        'OUTPUT',
        'OVER',
        'OVERLAPS',
        'PAD',
        'PARTIAL',
        'PARTITION',
        'PASCAL',
        'PERCENT',
        'PIVOT',
        'PLAN',
        'POSITION',
        'PRAGMA',
        'PRECEDING',
        'PRECISION',
        'PREPARE',
        'PRESERVE',
        'PRIMARY',
        'PRINT',
        'PRIOR',
        'PRIVILEGES',
        'PROC',
        'PROCEDURE',
        'PUBLIC',
        'QUERY',
        'RAISE',
        'RAISERROR',
        'RANGE',
        'READ',
        'READTEXT',
        'REAL',
        'RECONFIGURE',
        'RECURSIVE',
        'REFERENCES',
        'REGEXP',
        'REINDEX',
        'RELATIVE',
        'RELEASE',
        'RENAME',
        'REPLACE',
        'REPLICATION',
        'RESTORE',
        'RESTRICT',
        'RETURN',
        'RETURNING',
        'REVERT',
        'REVOKE',
        'RIGHT',
        'ROLLBACK',
        'ROW',
        'ROWCOUNT',
        'ROWGUIDCOL',
        'ROWS',
        'RULE',
        'SAVE',
        'SAVEPOINT',
        'SCHEMA',
        'SCROLL',
        'SECOND',
        'SECTION',
        'SECURITYAUDIT',
        'SELECT',
        'SEMANTICKEYPHRASETABLE',
        'SEMANTICSIMILARITYDETAILSTABLE',
        'SEMANTICSIMILARITYTABLE',
        'SESSION',
        'SESSION_USER',
        'SET',
        'SETUSER',
        'SHUTDOWN',
        'SIZE',
        'SMALLINT',
        'SOME',
        'SPACE',
        'SQL',
        'SQLCA',
        'SQLCODE',
        'SQLERROR',
        'SQLSTATE',
        'SQLWARNING',
        'STATISTICS',
        'SUBSTRING',
        'SUM',
        'SYSTEM_USER',
        'TABLE',
        'TABLESAMPLE',
        'TEMP',
        'TEMPORARY',
        'TEXTSIZE',
        'THEN',
        'TIES',
        'TIME',
        'TIMESTAMP',
        'TIMEZONE_HOUR',
        'TIMEZONE_MINUTE',
        'TO',
        'TOP',
        'TRAILING',
        'TRAN',
        'TRANSACTION',
        'TRANSLATE',
        'TRANSLATION',
        'TRIGGER',
        'TRIM',
        'TRUE',
        'TRUNCATE',
        'TRY_CONVERT',
        'TSEQUAL',
        'UNBOUNDED',
        'UNION',
        'UNIQUE',
        'UNKNOWN',
        'UNPIVOT',
        'UPDATE',
        'UPDATETEXT',
        'UPPER',
        'USAGE',
        'USE',
        'USER',
        'USING',
        'VACUUM',
        'VALUE',
        'VALUES',
        'VARCHAR',
        'VARYING',
        'VIEW',
        'VIRTUAL',
        'WAITFOR',
        'WHEN',
        'WHENEVER',
        'WHERE',
        'WHILE',
        'WINDOW',
        'WITH',
        'WITHIN GROUP',
        'WITHOUT',
        'WORK',
        'WRITE',
        'WRITETEXT',
        'YEAR',
        'ZONE',
    ],
    operators: [
        // Set
        'EXCEPT',
        'INTERSECT',
        'UNION',
        // Join
        'APPLY',
        'CROSS',
        'FULL',
        'INNER',
        'JOIN',
        'LEFT',
        'OUTER',
        'RIGHT',
        // Predicates
        'CONTAINS',
        'FREETEXT',
        'IS',
        'NULL',
        // Pivoting
        'PIVOT',
        'UNPIVOT',
        // Merging
        'MATCHED',
    ],
    logicalOperators: ['ALL', 'AND', 'ANY', 'BETWEEN', 'EXISTS', 'IN', 'LIKE', 'NOT', 'OR', 'SOME'],
    comparisonOperators: ['<>', '>', '<', '>=', '<=', '=', '!=', '&', '~', '^', '%'],
    builtinFunctions: [
        // Aggregate
        'AVG',
        'CHECKSUM_AGG',
        'COUNT',
        'COUNT_BIG',
        'GROUPING',
        'GROUPING_ID',
        'MAX',
        'MIN',
        'SUM',
        'STDEV',
        'STDEVP',
        'VAR',
        'VARP',
        // Analytic
        'CUME_DIST',
        'FIRST_VALUE',
        'LAG',
        'LAST_VALUE',
        'LEAD',
        'PERCENTILE_CONT',
        'PERCENTILE_DISC',
        'PERCENT_RANK',
        // Collation
        'COLLATE',
        'COLLATIONPROPERTY',
        'TERTIARY_WEIGHTS',
        // Azure
        'FEDERATION_FILTERING_VALUE',
        // Conversion
        'CAST',
        'CONVERT',
        'PARSE',
        'TRY_CAST',
        'TRY_CONVERT',
        'TRY_PARSE',
        // Cryptographic
        'ASYMKEY_ID',
        'ASYMKEYPROPERTY',
        'CERTPROPERTY',
        'CERT_ID',
        'CRYPT_GEN_RANDOM',
        'DECRYPTBYASYMKEY',
        'DECRYPTBYCERT',
        'DECRYPTBYKEY',
        'DECRYPTBYKEYAUTOASYMKEY',
        'DECRYPTBYKEYAUTOCERT',
        'DECRYPTBYPASSPHRASE',
        'ENCRYPTBYASYMKEY',
        'ENCRYPTBYCERT',
        'ENCRYPTBYKEY',
        'ENCRYPTBYPASSPHRASE',
        'HASHBYTES',
        'IS_OBJECTSIGNED',
        'KEY_GUID',
        'KEY_ID',
        'KEY_NAME',
        'SIGNBYASYMKEY',
        'SIGNBYCERT',
        'SYMKEYPROPERTY',
        'VERIFYSIGNEDBYCERT',
        'VERIFYSIGNEDBYASYMKEY',
        // Cursor
        'CURSOR_STATUS',
        // Datatype
        'DATALENGTH',
        'IDENT_CURRENT',
        'IDENT_INCR',
        'IDENT_SEED',
        'IDENTITY',
        'SQL_VARIANT_PROPERTY',
        // Datetime
        'CURRENT_TIMESTAMP',
        'DATEADD',
        'DATEDIFF',
        'DATEFROMPARTS',
        'DATENAME',
        'DATEPART',
        'DATETIME2FROMPARTS',
        'DATETIMEFROMPARTS',
        'DATETIMEOFFSETFROMPARTS',
        'DAY',
        'EOMONTH',
        'GETDATE',
        'GETUTCDATE',
        'ISDATE',
        'MONTH',
        'SMALLDATETIMEFROMPARTS',
        'SWITCHOFFSET',
        'SYSDATETIME',
        'SYSDATETIMEOFFSET',
        'SYSUTCDATETIME',
        'TIMEFROMPARTS',
        'TODATETIMEOFFSET',
        'YEAR',
        // Logical
        'CHOOSE',
        'COALESCE',
        'IIF',
        'NULLIF',
        // Mathematical
        'ABS',
        'ACOS',
        'ASIN',
        'ATAN',
        'ATN2',
        'CEILING',
        'COS',
        'COT',
        'DEGREES',
        'EXP',
        'FLOOR',
        'LOG',
        'LOG10',
        'PI',
        'POWER',
        'RADIANS',
        'RAND',
        'ROUND',
        'SIGN',
        'SIN',
        'SQRT',
        'SQUARE',
        'TAN',
        // Metadata
        'APP_NAME',
        'APPLOCK_MODE',
        'APPLOCK_TEST',
        'ASSEMBLYPROPERTY',
        'COL_LENGTH',
        'COL_NAME',
        'COLUMNPROPERTY',
        'DATABASE_PRINCIPAL_ID',
        'DATABASEPROPERTYEX',
        'DB_ID',
        'DB_NAME',
        'FILE_ID',
        'FILE_IDEX',
        'FILE_NAME',
        'FILEGROUP_ID',
        'FILEGROUP_NAME',
        'FILEGROUPPROPERTY',
        'FILEPROPERTY',
        'FULLTEXTCATALOGPROPERTY',
        'FULLTEXTSERVICEPROPERTY',
        'INDEX_COL',
        'INDEXKEY_PROPERTY',
        'INDEXPROPERTY',
        'OBJECT_DEFINITION',
        'OBJECT_ID',
        'OBJECT_NAME',
        'OBJECT_SCHEMA_NAME',
        'OBJECTPROPERTY',
        'OBJECTPROPERTYEX',
        'ORIGINAL_DB_NAME',
        'PARSENAME',
        'SCHEMA_ID',
        'SCHEMA_NAME',
        'SCOPE_IDENTITY',
        'SERVERPROPERTY',
        'STATS_DATE',
        'TYPE_ID',
        'TYPE_NAME',
        'TYPEPROPERTY',
        // Ranking
        'DENSE_RANK',
        'NTILE',
        'RANK',
        'ROW_NUMBER',
        // Replication
        'PUBLISHINGSERVERNAME',
        // Rowset
        'OPENDATASOURCE',
        'OPENQUERY',
        'OPENROWSET',
        'OPENXML',
        // Security
        'CERTENCODED',
        'CERTPRIVATEKEY',
        'CURRENT_USER',
        'HAS_DBACCESS',
        'HAS_PERMS_BY_NAME',
        'IS_MEMBER',
        'IS_ROLEMEMBER',
        'IS_SRVROLEMEMBER',
        'LOGINPROPERTY',
        'ORIGINAL_LOGIN',
        'PERMISSIONS',
        'PWDENCRYPT',
        'PWDCOMPARE',
        'SESSION_USER',
        'SESSIONPROPERTY',
        'SUSER_ID',
        'SUSER_NAME',
        'SUSER_SID',
        'SUSER_SNAME',
        'SYSTEM_USER',
        'USER',
        'USER_ID',
        'USER_NAME',
        // String
        'ASCII',
        'CHAR',
        'CHARINDEX',
        'CONCAT',
        'DIFFERENCE',
        'FORMAT',
        'LEFT',
        'LEN',
        'LOWER',
        'LTRIM',
        'NCHAR',
        'PATINDEX',
        'QUOTENAME',
        'REPLACE',
        'REPLICATE',
        'REVERSE',
        'RIGHT',
        'RTRIM',
        'SOUNDEX',
        'SPACE',
        'STR',
        'STUFF',
        'SUBSTRING',
        'UNICODE',
        'UPPER',
        // System
        'BINARY_CHECKSUM',
        'CHECKSUM',
        'CONNECTIONPROPERTY',
        'CONTEXT_INFO',
        'CURRENT_REQUEST_ID',
        'ERROR_LINE',
        'ERROR_NUMBER',
        'ERROR_MESSAGE',
        'ERROR_PROCEDURE',
        'ERROR_SEVERITY',
        'ERROR_STATE',
        'FORMATMESSAGE',
        'GETANSINULL',
        'GET_FILESTREAM_TRANSACTION_CONTEXT',
        'HOST_ID',
        'HOST_NAME',
        'ISNULL',
        'ISNUMERIC',
        'MIN_ACTIVE_ROWVERSION',
        'NEWID',
        'NEWSEQUENTIALID',
        'ROWCOUNT_BIG',
        'XACT_STATE',
        // TextImage
        'TEXTPTR',
        'TEXTVALID',
        // Trigger
        'COLUMNS_UPDATED',
        'EVENTDATA',
        'TRIGGER_NESTLEVEL',
        'UPDATE',
        // ChangeTracking
        'CHANGETABLE',
        'CHANGE_TRACKING_CONTEXT',
        'CHANGE_TRACKING_CURRENT_VERSION',
        'CHANGE_TRACKING_IS_COLUMN_IN_MASK',
        'CHANGE_TRACKING_MIN_VALID_VERSION',
        // FullTextSearch
        'CONTAINSTABLE',
        'FREETEXTTABLE',
        // SemanticTextSearch
        'SEMANTICKEYPHRASETABLE',
        'SEMANTICSIMILARITYDETAILSTABLE',
        'SEMANTICSIMILARITYTABLE',
        // FileStream
        'FILETABLEROOTPATH',
        'GETFILENAMESPACEPATH',
        'GETPATHLOCATOR',
        'PATHNAME',
        // ServiceBroker
        'GET_TRANSMISSION_STATUS',
    ],
    builtinVariables: [
        // Configuration
        '@@DATEFIRST',
        '@@DBTS',
        '@@LANGID',
        '@@LANGUAGE',
        '@@LOCK_TIMEOUT',
        '@@MAX_CONNECTIONS',
        '@@MAX_PRECISION',
        '@@NESTLEVEL',
        '@@OPTIONS',
        '@@REMSERVER',
        '@@SERVERNAME',
        '@@SERVICENAME',
        '@@SPID',
        '@@TEXTSIZE',
        '@@VERSION',
        // Cursor
        '@@CURSOR_ROWS',
        '@@FETCH_STATUS',
        // Datetime
        '@@DATEFIRST',
        // Metadata
        '@@PROCID',
        // System
        '@@ERROR',
        '@@IDENTITY',
        '@@ROWCOUNT',
        '@@TRANCOUNT',
        // Stats
        '@@CONNECTIONS',
        '@@CPU_BUSY',
        '@@IDLE',
        '@@IO_BUSY',
        '@@PACKET_ERRORS',
        '@@PACK_RECEIVED',
        '@@PACK_SENT',
        '@@TIMETICKS',
        '@@TOTAL_ERRORS',
        '@@TOTAL_READ',
        '@@TOTAL_WRITE',
    ],
    pseudoColumns: ['$ACTION', '$IDENTITY', '$ROWGUID', '$PARTITION'],
    tokenizer: {
        root: [
            { include: '@templateVariables' },
            { include: '@macros' },
            { include: '@comments' },
            { include: '@whitespace' },
            { include: '@pseudoColumns' },
            { include: '@numbers' },
            { include: '@strings' },
            { include: '@complexIdentifiers' },
            { include: '@scopes' },
            { include: '@schemaTable' },
            [/[;,.]/, 'delimiter'],
            [/[()]/, '@brackets'],
            [
                /[\w@#$|<|>|=|!|%|&|+|\|-|*|/|~|^]+/,
                {
                    cases: {
                        '@operators': 'operator',
                        '@comparisonOperators': 'operator',
                        '@logicalOperators': 'operator',
                        '@builtinVariables': 'predefined',
                        '@builtinFunctions': 'predefined',
                        '@keywords': 'keyword',
                        '@default': 'identifier',
                    },
                },
            ],
        ],
        templateVariables: [[/\$[a-zA-Z0-9]+/, 'variable']],
        macros: [[/\$__[a-zA-Z0-9-_]+/, 'type']],
        schemaTable: [
            [/(\w+)\./, 'identifier'],
            [/(\w+\.\w+)/, 'identifier'],
        ],
        whitespace: [[/\s+/, 'white']],
        comments: [
            [/--+.*/, 'comment'],
            [/\/\*/, { token: 'comment.quote', next: '@comment' }],
        ],
        comment: [
            [/[^*/]+/, 'comment'],
            // Not supporting nested comments, as nested comments seem to not be standard?
            // i.e. http://stackoverflow.com/questions/728172/are-there-multiline-comment-delimiters-in-sql-that-are-vendor-agnostic
            // [/\/\*/, { token: 'comment.quote', next: '@push' }],    // nested comment not allowed :-(
            [/\*\//, { token: 'comment.quote', next: '@pop' }],
            [/./, 'comment'],
        ],
        pseudoColumns: [
            [
                /[$][A-Za-z_][\w@#$]*/,
                {
                    cases: {
                        '@pseudoColumns': 'predefined',
                        '@default': 'identifier',
                    },
                },
            ],
        ],
        numbers: [
            [/0[xX][0-9a-fA-F]*/, 'number'],
            [/[$][+-]*\d*(\.\d*)?/, 'number'],
            [/((\d+(\.\d*)?)|(\.\d+))([eE][\-+]?\d+)?/, 'number'],
        ],
        strings: [
            [/N'/, { token: 'string', next: '@string' }],
            [/'/, { token: 'string', next: '@string' }],
        ],
        string: [
            [/[^']+/, 'string'],
            [/''/, 'string'],
            [/'/, { token: 'string', next: '@pop' }],
        ],
        complexIdentifiers: [
            [/\[/, { token: 'identifier.quote', next: '@bracketedIdentifier' }],
            [/"/, { token: 'identifier.quote', next: '@quotedIdentifier' }],
        ],
        bracketedIdentifier: [
            [/[^\]]+/, 'identifier'],
            [/]]/, 'identifier'],
            [/]/, { token: 'identifier.quote', next: '@pop' }],
        ],
        quotedIdentifier: [
            [/[^"]+/, 'identifier'],
            [/""/, 'identifier'],
            [/"/, { token: 'identifier.quote', next: '@pop' }],
        ],
        scopes: [
            [/BEGIN\s+(DISTRIBUTED\s+)?TRAN(SACTION)?\b/i, 'keyword'],
            [/BEGIN\s+TRY\b/i, { token: 'keyword.try' }],
            [/END\s+TRY\b/i, { token: 'keyword.try' }],
            [/BEGIN\s+CATCH\b/i, { token: 'keyword.catch' }],
            [/END\s+CATCH\b/i, { token: 'keyword.catch' }],
            [/(BEGIN|CASE)\b/i, { token: 'keyword.block' }],
            [/END\b/i, { token: 'keyword.block' }],
            [/WHEN\b/i, { token: 'keyword.choice' }],
            [/THEN\b/i, { token: 'keyword.choice' }],
        ],
    },
};

var language$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    SELECT: SELECT,
    FROM: FROM,
    WHERE: WHERE,
    GROUP: GROUP,
    ORDER: ORDER,
    BY: BY,
    DESC: DESC,
    ASC: ASC,
    LIMIT: LIMIT,
    WITH: WITH,
    AS: AS,
    SCHEMA: SCHEMA,
    AND: AND,
    OR: OR,
    LOGICAL_OPERATORS: LOGICAL_OPERATORS,
    EQUALS: EQUALS,
    NOT_EQUALS: NOT_EQUALS,
    COMPARISON_OPERATORS: COMPARISON_OPERATORS,
    STD_OPERATORS: STD_OPERATORS,
    conf: conf,
    language: language
});

var getSelectToken = function (currentToken) { var _a; return (_a = currentToken === null || currentToken === void 0 ? void 0 : currentToken.getPreviousOfType(exports.TokenType.Keyword, SELECT)) !== null && _a !== void 0 ? _a : null; };
var getFromKeywordToken = function (currentToken) {
    var selectToken = getSelectToken(currentToken);
    return selectToken === null || selectToken === void 0 ? void 0 : selectToken.getNextOfType(exports.TokenType.Keyword, FROM);
};
var getTableToken = function (currentToken) {
    var _a;
    var fromToken = getFromKeywordToken(currentToken);
    var nextNonWhiteSpace = fromToken === null || fromToken === void 0 ? void 0 : fromToken.getNextNonWhiteSpaceToken();
    if (nextNonWhiteSpace === null || nextNonWhiteSpace === void 0 ? void 0 : nextNonWhiteSpace.isVariable()) {
        // TODO: resolve column from variable?
        return null;
    }
    else if ((nextNonWhiteSpace === null || nextNonWhiteSpace === void 0 ? void 0 : nextNonWhiteSpace.isKeyword()) && ((_a = nextNonWhiteSpace.next) === null || _a === void 0 ? void 0 : _a.is(exports.TokenType.Parenthesis, '('))) {
        return null;
    }
    else {
        return nextNonWhiteSpace;
    }
};
var defaultTableNameParser = function (token) {
    var parts = token === null || token === void 0 ? void 0 : token.value.split('.');
    if ((parts === null || parts === void 0 ? void 0 : parts.length) === 1) {
        return { table: parts[0] };
    }
    else if ((parts === null || parts === void 0 ? void 0 : parts.length) === 2) {
        return { schema: parts[0], table: parts[1] };
    }
    return null;
};

var TRIGGER_SUGGEST = {
    id: 'editor.action.triggerSuggest',
    title: '',
};

// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
var getRandomValues;
var rnds8 = new Uint8Array(16);
function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation. Also,
    // find the complete implementation of crypto (msCrypto) on IE11.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto !== 'undefined' && typeof msCrypto.getRandomValues === 'function' && msCrypto.getRandomValues.bind(msCrypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}

var REGEX = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;

function validate(uuid) {
  return typeof uuid === 'string' && REGEX.test(uuid);
}

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */

var byteToHex = [];

for (var i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).substr(1));
}

function stringify(arr) {
  var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  var uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase(); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!validate(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

function v4(options, buf, offset) {
  options = options || {};
  var rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (var i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return stringify(rnds);
}

/**
 * This registry glues particular SuggestionKind with an async function that provides completion items for it.
 * To add a new suggestion kind, SQLEditor should be configured with a provider that implements customSuggestionKinds.
 */
var initStandardSuggestions = function (functions, operators, macros) {
    return function () {
        return [
            {
                id: exports.SuggestionKind.SelectKeyword,
                name: exports.SuggestionKind.SelectKeyword,
                suggestions: function (_, m) {
                    return Promise.resolve([
                        {
                            label: "SELECT <column>",
                            insertText: "SELECT $0",
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                            kind: exports.CompletionItemKind.Snippet,
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Medium,
                        },
                        {
                            label: "SELECT <column> FROM <table>",
                            insertText: "SELECT $2 FROM $1",
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                            kind: exports.CompletionItemKind.Snippet,
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Medium,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.TemplateVariables,
                name: exports.SuggestionKind.TemplateVariables,
                suggestions: function (_, m) {
                    var templateSrv = runtime.getTemplateSrv();
                    if (!templateSrv) {
                        return Promise.resolve([]);
                    }
                    return Promise.resolve(templateSrv.getVariables().map(function (variable) {
                        var label = "$".concat(variable.name);
                        var val = templateSrv.replace(label);
                        return {
                            label: label,
                            detail: "(Template Variable) ".concat(val),
                            kind: exports.CompletionItemKind.Snippet,
                            documentation: "(Template Variable) ".concat(val),
                            insertText: "\\$".concat(variable.name, " "),
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Low,
                        };
                    }));
                },
            },
            {
                id: exports.SuggestionKind.SelectMacro,
                name: exports.SuggestionKind.SelectMacro,
                suggestions: function (_, m) {
                    return Promise.resolve(__spreadArray([], __read(macros
                        .list()
                        .filter(function (m) { return m.type === exports.MacroType.Value || m.type === exports.MacroType.Column; })
                        .map(createMacroSuggestionItem)), false));
                },
            },
            {
                id: exports.SuggestionKind.TableMacro,
                name: exports.SuggestionKind.TableMacro,
                suggestions: function (_, m) {
                    return Promise.resolve(__spreadArray([], __read(macros
                        .list()
                        .filter(function (m) { return m.type === exports.MacroType.Table; })
                        .map(createMacroSuggestionItem)), false));
                },
            },
            {
                id: exports.SuggestionKind.GroupMacro,
                name: exports.SuggestionKind.GroupMacro,
                suggestions: function (_, m) {
                    return Promise.resolve(__spreadArray([], __read(macros
                        .list()
                        .filter(function (m) { return m.type === exports.MacroType.Group; })
                        .map(createMacroSuggestionItem)), false));
                },
            },
            {
                id: exports.SuggestionKind.FilterMacro,
                name: exports.SuggestionKind.FilterMacro,
                suggestions: function (_, m) {
                    return Promise.resolve(__spreadArray([], __read(macros
                        .list()
                        .filter(function (m) { return m.type === exports.MacroType.Filter; })
                        .map(createMacroSuggestionItem)), false));
                },
            },
            {
                id: exports.SuggestionKind.WithKeyword,
                name: exports.SuggestionKind.WithKeyword,
                suggestions: function (_, m) {
                    return Promise.resolve([
                        {
                            label: "WITH <alias> AS ( ... )",
                            insertText: "WITH $1  AS ( $2 )",
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                            kind: exports.CompletionItemKind.Snippet,
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Medium,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.StarWildCard,
                name: exports.SuggestionKind.StarWildCard,
                suggestions: function (_, m) {
                    return Promise.resolve([
                        {
                            label: '*',
                            insertText: "* $0",
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                            kind: exports.CompletionItemKind.Field,
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.High,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.FunctionsWithArguments,
                name: exports.SuggestionKind.FunctionsWithArguments,
                suggestions: function (_, m) {
                    return Promise.resolve(__spreadArray([], __read(functions.list().map(function (f) { return ({
                        label: f.name,
                        insertText: "".concat(f.name, "($0)"),
                        documentation: f.description,
                        insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                        kind: exports.CompletionItemKind.Function,
                        command: TRIGGER_SUGGEST,
                        sortText: exports.CompletionItemPriority.MediumLow,
                    }); })), false));
                },
            },
            {
                id: exports.SuggestionKind.FunctionsWithoutArguments,
                name: exports.SuggestionKind.FunctionsWithoutArguments,
                suggestions: function (_, m) {
                    return Promise.resolve(__spreadArray([], __read(functions.list().map(function (f) { return ({
                        label: f.name,
                        insertText: "".concat(f.name, "()"),
                        documentation: f.description,
                        insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                        kind: exports.CompletionItemKind.Function,
                        command: TRIGGER_SUGGEST,
                        sortText: exports.CompletionItemPriority.MediumHigh,
                    }); })), false));
                },
            },
            {
                id: exports.SuggestionKind.FromKeyword,
                name: exports.SuggestionKind.FromKeyword,
                suggestions: function (_, m) {
                    return Promise.resolve([
                        {
                            label: 'FROM',
                            insertText: "FROM $0",
                            command: TRIGGER_SUGGEST,
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                            kind: exports.CompletionItemKind.Keyword,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.Schemas,
                name: exports.SuggestionKind.Schemas,
                suggestions: function (_, m) { return Promise.resolve([]); },
            },
            {
                id: exports.SuggestionKind.Tables,
                name: exports.SuggestionKind.Tables,
                suggestions: function (_, m) { return Promise.resolve([]); },
            },
            {
                id: exports.SuggestionKind.Columns,
                name: exports.SuggestionKind.Columns,
                suggestions: function (_, m) { return Promise.resolve([]); },
            },
            {
                id: exports.SuggestionKind.LogicalOperators,
                name: exports.SuggestionKind.LogicalOperators,
                suggestions: function (_, m) {
                    return Promise.resolve(operators
                        .list()
                        .filter(function (o) { return o.type === exports.OperatorType.Logical; })
                        .map(function (o) { return ({
                        label: o.operator,
                        insertText: "".concat(o.operator, " "),
                        documentation: o.description,
                        command: TRIGGER_SUGGEST,
                        sortText: exports.CompletionItemPriority.MediumHigh,
                        kind: exports.CompletionItemKind.Operator,
                    }); }));
                },
            },
            {
                id: exports.SuggestionKind.WhereKeyword,
                name: exports.SuggestionKind.WhereKeyword,
                suggestions: function (_, m) {
                    return Promise.resolve([
                        {
                            label: 'WHERE',
                            insertText: "WHERE ",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.MediumHigh,
                            kind: exports.CompletionItemKind.Keyword,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.ComparisonOperators,
                name: exports.SuggestionKind.ComparisonOperators,
                suggestions: function (_, m) {
                    return Promise.resolve(__spreadArray(__spreadArray([], __read(operators
                        .list()
                        .filter(function (o) { return o.type === exports.OperatorType.Comparison; })
                        .map(function (o) { return ({
                        label: o.operator,
                        insertText: "".concat(o.operator, " "),
                        documentation: o.description,
                        command: TRIGGER_SUGGEST,
                        sortText: exports.CompletionItemPriority.MediumHigh,
                        kind: exports.CompletionItemKind.Operator,
                    }); })), false), [
                        {
                            label: 'IN (...)',
                            insertText: "IN ( $0 )",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Medium,
                            kind: exports.CompletionItemKind.Operator,
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                        },
                        {
                            label: 'NOT IN (...)',
                            insertText: "NOT IN ( $0 )",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Medium,
                            kind: exports.CompletionItemKind.Operator,
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                        },
                        {
                            label: 'IS',
                            insertText: "IS",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Medium,
                            kind: exports.CompletionItemKind.Operator,
                        },
                        {
                            label: 'IS NOT',
                            insertText: "IS NOT",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Medium,
                            kind: exports.CompletionItemKind.Operator,
                        },
                    ], false));
                },
            },
            {
                id: exports.SuggestionKind.GroupByKeywords,
                name: exports.SuggestionKind.GroupByKeywords,
                suggestions: function (_, m) {
                    return Promise.resolve([
                        {
                            label: 'GROUP BY',
                            insertText: "GROUP BY ",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.MediumHigh,
                            kind: exports.CompletionItemKind.Keyword,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.OrderByKeywords,
                name: exports.SuggestionKind.OrderByKeywords,
                suggestions: function (_, m) {
                    return Promise.resolve([
                        {
                            label: 'ORDER BY',
                            insertText: "ORDER BY ",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.Medium,
                            kind: exports.CompletionItemKind.Keyword,
                        },
                        {
                            label: 'ORDER BY(ascending)',
                            insertText: "ORDER BY $1 ASC ",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.MediumLow,
                            kind: exports.CompletionItemKind.Snippet,
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                        },
                        {
                            label: 'ORDER BY(descending)',
                            insertText: "ORDER BY $1 DESC",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.MediumLow,
                            kind: exports.CompletionItemKind.Snippet,
                            insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.LimitKeyword,
                name: exports.SuggestionKind.LimitKeyword,
                suggestions: function (_, m) {
                    return Promise.resolve([
                        {
                            label: 'LIMIT',
                            insertText: "LIMIT ",
                            command: TRIGGER_SUGGEST,
                            sortText: exports.CompletionItemPriority.MediumLow,
                            kind: exports.CompletionItemKind.Keyword,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.SortOrderDirectionKeyword,
                name: exports.SuggestionKind.SortOrderDirectionKeyword,
                suggestions: function (_, m) {
                    return Promise.resolve([ASC, DESC].map(function (o) { return ({
                        label: o,
                        insertText: "".concat(o, " "),
                        command: TRIGGER_SUGGEST,
                        kind: exports.CompletionItemKind.Keyword,
                    }); }));
                },
            },
            {
                id: exports.SuggestionKind.NotKeyword,
                name: exports.SuggestionKind.NotKeyword,
                suggestions: function () {
                    return Promise.resolve([
                        {
                            label: 'NOT',
                            insertText: 'NOT',
                            command: TRIGGER_SUGGEST,
                            kind: exports.CompletionItemKind.Keyword,
                            sortText: exports.CompletionItemPriority.High,
                        },
                    ]);
                },
            },
            {
                id: exports.SuggestionKind.BoolValues,
                name: exports.SuggestionKind.BoolValues,
                suggestions: function () {
                    return Promise.resolve(['TRUE', 'FALSE'].map(function (o) { return ({
                        label: o,
                        insertText: "".concat(o),
                        command: TRIGGER_SUGGEST,
                        kind: exports.CompletionItemKind.Keyword,
                        sortText: exports.CompletionItemPriority.Medium,
                    }); }));
                },
            },
            {
                id: exports.SuggestionKind.NullValue,
                name: exports.SuggestionKind.NullValue,
                suggestions: function () {
                    return Promise.resolve(['NULL'].map(function (o) { return ({
                        label: o,
                        insertText: "".concat(o),
                        command: TRIGGER_SUGGEST,
                        kind: exports.CompletionItemKind.Keyword,
                        sortText: exports.CompletionItemPriority.Low,
                    }); }));
                },
            },
        ];
    };
};
function createMacroSuggestionItem(m) {
    return {
        label: m.name,
        insertText: "".concat('\\' + m.text).concat(argsString(m.args), " "),
        insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
        kind: exports.CompletionItemKind.Snippet,
        documentation: m.description,
        command: TRIGGER_SUGGEST,
    };
}
function argsString(args) {
    if (!args) {
        return '()';
    }
    return '('.concat(args.map(function (t, i) { return "${".concat(i, ":").concat(t, "}"); }).join(', ')).concat(')');
}

function initStatementPositionResolvers() {
    return [
        {
            id: exports.StatementPosition.SelectKeyword,
            name: exports.StatementPosition.SelectKeyword,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean(currentToken === null ||
                    (currentToken.isWhiteSpace() && currentToken.previous === null) ||
                    currentToken.is(exports.TokenType.Keyword, SELECT) ||
                    (currentToken.is(exports.TokenType.Keyword, SELECT) && currentToken.previous === null) ||
                    previousIsSlash ||
                    (currentToken.isIdentifier() && (previousIsSlash || (currentToken === null || currentToken === void 0 ? void 0 : currentToken.previous) === null)) ||
                    (currentToken.isIdentifier() && SELECT.startsWith(currentToken.value.toLowerCase())));
            },
        },
        {
            id: exports.StatementPosition.WithKeyword,
            name: exports.StatementPosition.WithKeyword,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean(currentToken === null ||
                    (currentToken.isWhiteSpace() && currentToken.previous === null) ||
                    (currentToken.is(exports.TokenType.Keyword, WITH) && currentToken.previous === null) ||
                    (currentToken.isIdentifier() && WITH.toLowerCase().startsWith(currentToken.value.toLowerCase())));
            },
        },
        {
            id: exports.StatementPosition.AfterSelectKeyword,
            name: exports.StatementPosition.AfterSelectKeyword,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.value.toLowerCase()) === SELECT);
            },
        },
        {
            id: exports.StatementPosition.AfterSelectArguments,
            name: exports.StatementPosition.AfterSelectArguments,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === SELECT && (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.value) === ',');
            },
        },
        {
            id: exports.StatementPosition.AfterSelectFuncFirstArgument,
            name: exports.StatementPosition.AfterSelectFuncFirstArgument,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean(((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === SELECT || (previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === AS) &&
                    ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis, '(')) || (currentToken === null || currentToken === void 0 ? void 0 : currentToken.is(exports.TokenType.Parenthesis, '()'))));
            },
        },
        {
            id: exports.StatementPosition.AfterWhereFunctionArgument,
            name: exports.StatementPosition.AfterWhereFunctionArgument,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.is(exports.TokenType.Keyword, WHERE)) &&
                    ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis, '(')) || (currentToken === null || currentToken === void 0 ? void 0 : currentToken.is(exports.TokenType.Parenthesis, '()'))));
            },
        },
        {
            id: exports.StatementPosition.AfterGroupBy,
            name: exports.StatementPosition.AfterGroupBy,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                var _a;
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.is(exports.TokenType.Keyword, BY)) &&
                    ((_a = previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.getPreviousKeyword()) === null || _a === void 0 ? void 0 : _a.is(exports.TokenType.Keyword, GROUP)) &&
                    ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isIdentifier()) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isDoubleQuotedString()) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis, ')')) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis, '()'))));
            },
        },
        {
            id: exports.StatementPosition.SelectAlias,
            name: exports.StatementPosition.SelectAlias,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                if ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.value) === ',' && (previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === AS) {
                    return true;
                }
                return false;
            },
        },
        {
            id: exports.StatementPosition.FromKeyword,
            name: exports.StatementPosition.FromKeyword,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                // cloudwatch specific commented out
                // Boolean(previousKeyword?.value === SELECT && previousNonWhiteSpace?.isParenthesis()),
                return Boolean(((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === SELECT && (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.value) !== ',') ||
                    (((currentToken === null || currentToken === void 0 ? void 0 : currentToken.isKeyword()) || (currentToken === null || currentToken === void 0 ? void 0 : currentToken.isIdentifier())) &&
                        FROM.toLowerCase().startsWith(currentToken.value.toLowerCase())));
            },
        },
        {
            id: exports.StatementPosition.AfterFromKeyword,
            name: exports.StatementPosition.AfterFromKeyword,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean(!(currentToken === null || currentToken === void 0 ? void 0 : currentToken.value.includes('.')) && (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.value.toLowerCase()) === FROM);
            },
        },
        {
            id: exports.StatementPosition.AfterSchema,
            name: exports.StatementPosition.AfterSchema,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                // depending on whether the schema was the last token in the query or not, current token might be whitespace or dot. if whitespace, just use the previous token
                if ((currentToken === null || currentToken === void 0 ? void 0 : currentToken.isWhiteSpace()) && (currentToken === null || currentToken === void 0 ? void 0 : currentToken.next)) {
                    currentToken = currentToken === null || currentToken === void 0 ? void 0 : currentToken.previous;
                    previousNonWhiteSpace = currentToken === null || currentToken === void 0 ? void 0 : currentToken.getPreviousNonWhiteSpaceToken();
                }
                return Boolean((currentToken === null || currentToken === void 0 ? void 0 : currentToken.isIdentifier()) &&
                    (currentToken === null || currentToken === void 0 ? void 0 : currentToken.value.endsWith('.')) &&
                    (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.value.toLowerCase()) === FROM);
            },
        },
        {
            id: exports.StatementPosition.AfterFrom,
            name: exports.StatementPosition.AfterFrom,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean(((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === FROM && (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isDoubleQuotedString())) ||
                    ((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === FROM && (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isIdentifier())) ||
                    ((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === FROM && (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isVariable()))
                //  cloudwatch specific
                // (previousKeyword?.value === SCHEMA && previousNonWhiteSpace?.is(TokenType.Parenthesis, ')'))
                );
            },
        },
        {
            id: exports.StatementPosition.AfterTable,
            name: exports.StatementPosition.AfterTable,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === FROM &&
                    ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isVariable()) ||
                        ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.value) !== '' && (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.value.toLowerCase()) !== FROM)));
            },
        },
        {
            id: exports.StatementPosition.WhereKeyword,
            name: exports.StatementPosition.WhereKeyword,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === WHERE &&
                    ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isKeyword()) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis, '(')) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Operator, AND))));
            },
        },
        {
            id: exports.StatementPosition.WhereComparisonOperator,
            name: exports.StatementPosition.WhereComparisonOperator,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === WHERE &&
                    !(previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.getPreviousNonWhiteSpaceToken().isOperator()) &&
                    !currentToken.is(exports.TokenType.Delimiter, '.') &&
                    !currentToken.isParenthesis() &&
                    ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isIdentifier()) || (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isDoubleQuotedString())));
            },
        },
        {
            id: exports.StatementPosition.WhereValue,
            name: exports.StatementPosition.WhereValue,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === WHERE && (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isOperator()));
            },
        },
        {
            id: exports.StatementPosition.AfterWhereValue,
            name: exports.StatementPosition.AfterWhereValue,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                var _a, _b, _c;
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.value.toLowerCase()) === WHERE &&
                    (previousNonWhiteSpace.is(exports.TokenType.Operator, 'and') ||
                        previousNonWhiteSpace.is(exports.TokenType.Operator, 'or') ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isString()) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isNumber()) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis, ')')) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis, '()')) ||
                        (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.isTemplateVariable()) ||
                        ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.IdentifierQuote)) &&
                            ((_a = previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) === null || _a === void 0 ? void 0 : _a.is(exports.TokenType.Identifier)) &&
                            ((_c = (_b = previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) === null || _b === void 0 ? void 0 : _b.getPreviousNonWhiteSpaceToken()) === null || _c === void 0 ? void 0 : _c.is(exports.TokenType.IdentifierQuote)))));
            },
        },
        {
            id: exports.StatementPosition.AfterGroupByKeywords,
            name: exports.StatementPosition.AfterGroupByKeywords,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                var _a;
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.is(exports.TokenType.Keyword, BY)) &&
                    ((_a = previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.getPreviousKeyword()) === null || _a === void 0 ? void 0 : _a.is(exports.TokenType.Keyword, GROUP)) &&
                    ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Keyword, BY)) || (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Delimiter, ','))));
            },
        },
        {
            id: exports.StatementPosition.AfterGroupByFunctionArgument,
            name: exports.StatementPosition.AfterGroupByFunctionArgument,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                var _a;
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.is(exports.TokenType.Keyword, BY)) &&
                    ((_a = previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.getPreviousKeyword()) === null || _a === void 0 ? void 0 : _a.is(exports.TokenType.Keyword, GROUP)) &&
                    ((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis, '(')) || (currentToken === null || currentToken === void 0 ? void 0 : currentToken.is(exports.TokenType.Parenthesis, '()'))));
            },
        },
        {
            id: exports.StatementPosition.AfterOrderByKeywords,
            name: exports.StatementPosition.AfterOrderByKeywords,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                var _a;
                return Boolean((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Keyword, BY)) &&
                    ((_a = previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.getPreviousKeyword()) === null || _a === void 0 ? void 0 : _a.is(exports.TokenType.Keyword, ORDER)));
            },
        },
        {
            id: exports.StatementPosition.AfterOrderByFunction,
            name: exports.StatementPosition.AfterOrderByFunction,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                var _a, _b;
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.is(exports.TokenType.Keyword, BY)) &&
                    ((_a = previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.getPreviousKeyword()) === null || _a === void 0 ? void 0 : _a.is(exports.TokenType.Keyword, ORDER)) &&
                    (previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Parenthesis)) &&
                    ((_b = previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) === null || _b === void 0 ? void 0 : _b.is(exports.TokenType.Function)));
            },
        },
        {
            id: exports.StatementPosition.AfterOrderByDirection,
            name: exports.StatementPosition.AfterOrderByDirection,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean((previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.is(exports.TokenType.Keyword, DESC)) || (previousKeyword === null || previousKeyword === void 0 ? void 0 : previousKeyword.is(exports.TokenType.Keyword, ASC)));
            },
        },
        {
            id: exports.StatementPosition.AfterIsOperator,
            name: exports.StatementPosition.AfterIsOperator,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                return Boolean(previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Operator, 'IS'));
            },
        },
        {
            id: exports.StatementPosition.AfterIsNotOperator,
            name: exports.StatementPosition.AfterIsNotOperator,
            resolve: function (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) {
                var _a;
                return Boolean((previousNonWhiteSpace === null || previousNonWhiteSpace === void 0 ? void 0 : previousNonWhiteSpace.is(exports.TokenType.Operator, 'NOT')) &&
                    ((_a = previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) === null || _a === void 0 ? void 0 : _a.is(exports.TokenType.Operator, 'IS')));
            },
        },
    ];
}

var sqlEditorLogger = { logger: function () { } };
var sqlEditorLog = function () { };
if (ui.attachDebugger && ui.createLogger) {
    sqlEditorLogger = ui.createLogger('SQLEditor');
    sqlEditorLog = sqlEditorLogger.logger;
    ui.attachDebugger('sqleditor', undefined, sqlEditorLogger);
}

var COLUMN = 'column', RELATIVE_TIME_STRING = "'5m'";
var MACROS = [
    {
        id: '$__timeFilter(dateColumn)',
        name: '$__timeFilter(dateColumn)',
        text: '$__timeFilter',
        args: [COLUMN],
        type: exports.MacroType.Filter,
        description: 'Will be replaced by a time range filter using the specified column name. For example, dateColumn BETWEEN FROM_UNIXTIME(1494410783) AND FROM_UNIXTIME(1494410983)',
    },
    {
        id: '$__timeFrom()',
        name: '$__timeFrom()',
        text: '$__timeFrom',
        args: [],
        type: exports.MacroType.Filter,
        description: 'Will be replaced by the start of the currently active time selection. For example, FROM_UNIXTIME(1494410783)',
    },
    {
        id: '$__timeTo()',
        name: '$__timeTo()',
        text: '$__timeTo',
        args: [],
        type: exports.MacroType.Filter,
        description: 'Will be replaced by the end of the currently active time selection. For example, FROM_UNIXTIME(1494410983)',
    },
    {
        id: "$__timeGroup(dateColumn, '5m')",
        name: "$__timeGroup(dateColumn, '5m')",
        text: '$__timeGroup',
        args: [COLUMN, RELATIVE_TIME_STRING],
        type: exports.MacroType.Value,
        description: 'Will be replaced by an expression usable in GROUP BY clause. For example, *cast(cast(UNIX_TIMESTAMP(dateColumn)/(300) as signed)*300 as signed),*',
    },
    {
        id: '$__table',
        name: '$__table',
        text: '$__table',
        args: [],
        type: exports.MacroType.Table,
        description: 'Will be replaced by the query table.',
    },
    {
        id: '$__column',
        name: '$__column',
        text: '$__column',
        args: [],
        type: exports.MacroType.Column,
        description: 'Will be replaced by the query column.',
    },
];
/*
  {
    id: "$__timeGroupAlias(dateColumn, '5m', fill)",
    name: "$__timeGroupAlias(dateColumn, '5m', fill)",
    text: "$__timeGroup",
    args: [COLUMN, RELATIVE_TIME_STRING , FILL_TYPE],
    type: MacroType.Group,
    description:
      "Will be replaced by an expression usable in GROUP BY clause. For example, *cast(cast(UNIX_TIMESTAMP(dateColumn)/(300) as signed)*300 as signed),* with an added column alias",
  },
  {
    id: "$__unixEpochFilter(dateColumn)",
    name: "$__unixEpochFilter(dateColumn)",
    text: "$__unixEpochFilter",
    args: [COLUMN],
    type: MacroType.Filter,
    description:
      "Will be replaced by a time range filter using the specified column name with times represented as Unix timestamp. For example, dateColumn > 1494410783 AND dateColumn < 1494497183",
  },
  {
    id: "$__unixEpochFrom()",
    name: "$__unixEpochFrom()",
    text: "$__unixEpochFrom",
    args: [],
    type: MacroType.Value,
    description:
      "Will be replaced by the start of the currently active time selection as Unix timestamp. For example, 1494410783",
  },
  {
    id: "$__unixEpochTo()",
    name: "$__unixEpochTo()",
    text: "$__unixEpochTo",
    args: [],
    type: MacroType.Value,
    description:
      "Will be replaced by the end of the currently active time selection as Unix timestamp. For example, 1494410783",
  },
  {
    id: "$__unixEpochNanoFilter(dateColumn)",
    name: "$__unixEpochNanoFilter(dateColumn)",
    text: "$__unixEpochNanoFilter",
    args: [COLUMN],
    type: MacroType.Filter,
    description:
      "Will be replaced by a time range filter using the specified column name with times represented as nanosecond timestamp. For example, dateColumn > 1494410783152415214 AND dateColumn < 1494497183142514872",
  },
  {
    id: "$__unixEpochNanoFrom()",
    name: "$__unixEpochNanoFrom()",
    text: "$__unixEpochNanoFrom",
    args: [],
    type: MacroType.Value,
    description:
      "Will be replaced by the start of the currently active time selection as nanosecond timestamp. For example, 1494410783152415214",
  },
  {
    id: "$__unixEpochNanoTo()",
    name: "$__unixEpochNanoTo()",
    text: "$__unixEpochNanoTo",
    args: [],
    type: MacroType.Value,
    description:
      "Will be replaced by the end of the currently active time selection as nanosecond timestamp. For example, 1494410783152415214",
  },
  {
    id: "$__unixEpochGroup(dateColumn, '5m')",
    name: "$__unixEpochGroup(dateColumn, '5m')",
    text: "$__unixEpochGroup",
    args: [COLUMN, RELATIVE_TIME_STRING],
    type: MacroType.Group,
    description:
      "Will be replaced by an expression usable in GROUP BY clause. For values stored as unix timestamp.",
  },
  {
    id: "$__unixEpochGroup(dateColumn, '5m', fill)",
    name: "$__unixEpochGroup(dateColumn, '5m', fill)",
    text: "$__unixEpochGroup",
    args: [COLUMN, RELATIVE_TIME_STRING, FILL_TYPE],
    type: MacroType.Group,
    description:
      "Will be replaced by an expression usable in GROUP BY clause. For values stored as unix timestamp. Missing values can be filled with 0, NULL or previous",
  },
  {
    id: "$__timeEpoch(dateColumn, )",
    name: "$__timeEpoch(dateColumn)",
    text: "$__timeEpoch",
    args: [COLUMN],
    type: MacroType.Value,
    description:
      "Will be replaced by an expression to convert to a UNIX timestamp and rename the column to time_sec. For example, UNIX_TIMESTAMP(dateColumn) as time_sec",
  },
  {
    id: "$__time(dateColumn)",
    name: "$__time(dateColumn)",
    text: "$__time",
    args: [COLUMN],
    type: MacroType.Value,
    description:
      "Will be replaced by an expression to convert to a UNIX timestamp and rename the column to time_sec. For example, UNIX_TIMESTAMP(dateColumn) as time_sec",
  },
  {
    id: "$__timeGroup(dateColumn, '5m', fill)",
    name: "$__timeGroup(dateColumn, '5m', fill)",
    text: "$__timeGroup",
    args: [COLUMN, RELATIVE_TIME_STRING, FILL_TYPE],
    type: MacroType.Value,
    description:
      "Will be replaced by an expression usable in GROUP BY clause. For example, *cast(cast(UNIX_TIMESTAMP(dateColumn)/(300) as signed)*300 as signed),* missing values can be filled with 0, NULL or previous",
  },
  */

function getStandardSQLCompletionProvider(monaco, language) {
    var _a, _b, _c;
    var provider = { triggerCharacters: ['.', ' ', '$', ',', '(', "'"] };
    if (language === null || language === void 0 ? void 0 : language.builtinFunctions.length) {
        provider.supportedFunctions = function () { return language.builtinFunctions.map(function (f) { return ({ id: f, name: f }); }); };
    }
    var operators = [];
    if ((_a = language === null || language === void 0 ? void 0 : language.comparisonOperators) === null || _a === void 0 ? void 0 : _a.length) {
        operators.push.apply(operators, __spreadArray([], __read(language.comparisonOperators.map(function (f) { return ({
            id: f.toLocaleLowerCase(),
            operator: f,
            type: exports.OperatorType.Comparison,
        }); })), false));
    }
    // some languages in the monaco language registry don't specify logical operators, only operators. if so, suggest them instead
    language.logicalOperators = (_b = language.logicalOperators) !== null && _b !== void 0 ? _b : language.operators;
    if ((_c = language === null || language === void 0 ? void 0 : language.logicalOperators) === null || _c === void 0 ? void 0 : _c.length) {
        operators.push.apply(operators, __spreadArray([], __read(language.logicalOperators.map(function (f) { return ({ id: f.toLocaleLowerCase(), operator: f, type: exports.OperatorType.Logical }); })), false));
    }
    provider.supportedOperators = function () { return operators; };
    provider.supportedMacros = function () { return MACROS; };
    return provider;
}

var standardSQLLanguageDefinition = {
    id: 'standardSql',
    extensions: ['.sql'],
    aliases: ['sql'],
    mimetypes: [],
    loader: function () { return Promise.resolve().then(function () { return language$1; }); },
    completionProvider: getStandardSQLCompletionProvider,
};

var STANDARD_SQL_LANGUAGE = 'sql';
var LANGUAGES_CACHE = new Map();
var INSTANCE_CACHE = new Map();
var SQLEditor = function (_a) {
    var children = _a.children, onBlur = _a.onBlur, onChange = _a.onChange, query = _a.query, _b = _a.language, language = _b === void 0 ? { id: STANDARD_SQL_LANGUAGE } : _b, width = _a.width, height = _a.height;
    var monacoRef = React.useRef(null);
    var langUid = React.useRef();
    // create unique language id for each SQLEditor instance
    var id = React.useMemo(function () {
        var uid = v4();
        var id = "".concat(language.id, "-").concat(uid);
        langUid.current = id;
        return id;
    }, [language.id]);
    React.useEffect(function () {
        return function () {
            INSTANCE_CACHE.delete(langUid.current);
            sqlEditorLog("Removing instance cache ".concat(langUid.current), false, INSTANCE_CACHE);
        };
    }, []);
    var formatQuery = React.useCallback(function () {
        if (monacoRef.current) {
            monacoRef.current.getAction('editor.action.formatDocument').run();
        }
    }, []);
    return (React__default.createElement("div", { style: { width: width } },
        React__default.createElement(ui.CodeEditor, { height: height || '240px', 
            // -2px to compensate for borders width
            width: width ? "".concat(width - 2, "px") : undefined, language: id, value: query, onBlur: function (v) {
                onChange && onChange(v, false);
                onBlur && onBlur();
            }, showMiniMap: false, showLineNumbers: true, 
            // Using onEditorDidMount instead of onBeforeEditorMount to support Grafana < 8.2.x
            onEditorDidMount: function (editor, m) {
                monacoRef.current = editor;
                editor.onDidChangeModelContent(function (e) {
                    var text = editor.getValue();
                    if (onChange) {
                        onChange(text, false);
                    }
                });
                editor.addCommand(m.KeyMod.CtrlCmd | m.KeyCode.Enter, function () {
                    var text = editor.getValue();
                    if (onChange) {
                        onChange(text, true);
                    }
                });
                editor.onKeyUp(function (e) {
                    // keyCode 84 is . (DOT)
                    if (e.keyCode === 84) {
                        editor.trigger(TRIGGER_SUGGEST.id, TRIGGER_SUGGEST.id, {});
                    }
                });
                registerLanguageAndSuggestions(m, language, id);
            } }),
        children && children({ formatQuery: formatQuery })));
};
// There's three ways to define Monaco language:
// 1. Leave language.id empty or set it to 'sql'. This will load a standard sql language definition, including syntax highlighting and tokenization for
// common Grafana entities such as macros and template variables
// 2. Provide a custom language and load it via the async LanguageDefinition.loader callback
// 3. Specify a language.id that exists in the Monaco language registry. A custom completion item provider can still be provided.
// If not, the standard SQL completion item provider will be used. See available languages here: https://github.com/microsoft/monaco-editor/tree/main/src/basic-languages
// If a custom language is specified, its LanguageDefinition will be merged with the LanguageDefinition for standard SQL. This allows the consumer to only
// override parts of the LanguageDefinition, such as for example the completion item provider.
var resolveLanguage = function (monaco, languageDefinitionProp) {
    if ((languageDefinitionProp === null || languageDefinitionProp === void 0 ? void 0 : languageDefinitionProp.id) !== STANDARD_SQL_LANGUAGE && !languageDefinitionProp.loader) {
        sqlEditorLog("Loading language '".concat(languageDefinitionProp === null || languageDefinitionProp === void 0 ? void 0 : languageDefinitionProp.id, "' from Monaco registry"), false);
        var allLangs = monaco.languages.getLanguages();
        var custom = allLangs.find(function (_a) {
            var id = _a.id;
            return id === (languageDefinitionProp === null || languageDefinitionProp === void 0 ? void 0 : languageDefinitionProp.id);
        });
        if (!custom) {
            throw Error("Unknown Monaco language ".concat(languageDefinitionProp === null || languageDefinitionProp === void 0 ? void 0 : languageDefinitionProp.id));
        }
        return __assign(__assign({ completionProvider: getStandardSQLCompletionProvider }, custom), languageDefinitionProp);
    }
    return __assign(__assign({}, standardSQLLanguageDefinition), languageDefinitionProp);
};
var registerLanguageAndSuggestions = function (monaco, l, lid) { return __awaiter(void 0, void 0, void 0, function () {
    var languageDefinition, _a, language, conf, customProvider, languageSuggestionsRegistries_1, instanceSuggestionsRegistry_1, completionProvider;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0:
                languageDefinition = resolveLanguage(monaco, l);
                return [4 /*yield*/, languageDefinition.loader(monaco)];
            case 1:
                _a = _b.sent(), language = _a.language, conf = _a.conf;
                monaco.languages.register({ id: lid });
                monaco.languages.setMonarchTokensProvider(lid, __assign({}, language));
                monaco.languages.setLanguageConfiguration(lid, __assign({}, conf));
                if (languageDefinition.formatter) {
                    monaco.languages.registerDocumentFormattingEditProvider(lid, {
                        provideDocumentFormattingEdits: function (model) {
                            var formatted = l.formatter(model.getValue());
                            return [
                                {
                                    range: model.getFullModelRange(),
                                    text: formatted,
                                },
                            ];
                        },
                    });
                }
                if (languageDefinition.completionProvider) {
                    customProvider = languageDefinition.completionProvider(monaco, language);
                    extendStandardRegistries(l.id, lid, customProvider);
                    languageSuggestionsRegistries_1 = LANGUAGES_CACHE.get(l.id);
                    instanceSuggestionsRegistry_1 = INSTANCE_CACHE.get(lid);
                    completionProvider = function (model, position, context, token) { return __awaiter(void 0, void 0, void 0, function () {
                        var currentToken, statementPosition, kind, ctx, stdSuggestions;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    currentToken = linkedTokenBuilder(monaco, model, position, lid);
                                    statementPosition = getStatementPosition(currentToken, languageSuggestionsRegistries_1.positionResolvers);
                                    kind = getSuggestionKinds(statementPosition, languageSuggestionsRegistries_1.suggestionKinds);
                                    sqlEditorLog('Statement position', false, statementPosition);
                                    sqlEditorLog('Suggestion kinds', false, kind);
                                    ctx = {
                                        position: position,
                                        currentToken: currentToken,
                                        statementPosition: statementPosition,
                                        kind: kind,
                                        range: monaco.Range.fromPositions(position),
                                    };
                                    return [4 /*yield*/, getStandardSuggestions(monaco, currentToken, kind, ctx, instanceSuggestionsRegistry_1)];
                                case 1:
                                    stdSuggestions = _a.sent();
                                    return [2 /*return*/, {
                                            suggestions: stdSuggestions,
                                        }];
                            }
                        });
                    }); };
                    monaco.languages.registerCompletionItemProvider(lid, __assign(__assign({}, customProvider), { provideCompletionItems: completionProvider }));
                }
                return [2 /*return*/];
        }
    });
}); };
function extendStandardRegistries(id, lid, customProvider) {
    var e_1, _a, e_2, _b, e_3, _c, e_4, _d, e_5, _e;
    var _this = this;
    var _f;
    if (!LANGUAGES_CACHE.has(id)) {
        initializeLanguageRegistries(id);
    }
    var languageRegistries = LANGUAGES_CACHE.get(id);
    if (!INSTANCE_CACHE.has(lid)) {
        INSTANCE_CACHE.set(lid, new data.Registry(initStandardSuggestions(languageRegistries.functions, languageRegistries.operators, languageRegistries.macros)));
    }
    var instanceSuggestionsRegistry = INSTANCE_CACHE.get(lid);
    if (customProvider.supportedFunctions) {
        try {
            for (var _g = __values(customProvider.supportedFunctions()), _h = _g.next(); !_h.done; _h = _g.next()) {
                var func = _h.value;
                var exists = languageRegistries.functions.getIfExists(func.id);
                if (!exists) {
                    languageRegistries.functions.register(func);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_h && !_h.done && (_a = _g.return)) _a.call(_g);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    if (customProvider.supportedOperators) {
        try {
            for (var _j = __values(customProvider.supportedOperators()), _k = _j.next(); !_k.done; _k = _j.next()) {
                var op = _k.value;
                var exists = languageRegistries.operators.getIfExists(op.id);
                if (!exists) {
                    languageRegistries.operators.register(__assign(__assign({}, op), { name: op.id }));
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_k && !_k.done && (_b = _j.return)) _b.call(_j);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    if (customProvider.supportedMacros) {
        try {
            for (var _l = __values(customProvider.supportedMacros()), _m = _l.next(); !_m.done; _m = _l.next()) {
                var macro = _m.value;
                var exists = languageRegistries.macros.getIfExists(macro.id);
                if (!exists) {
                    languageRegistries.macros.register(__assign(__assign({}, macro), { name: macro.id }));
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_m && !_m.done && (_c = _l.return)) _c.call(_l);
            }
            finally { if (e_3) throw e_3.error; }
        }
    }
    if (customProvider.customStatementPlacement) {
        var _loop_1 = function (placement) {
            var exists = languageRegistries.positionResolvers.getIfExists(placement.id);
            if (!exists) {
                languageRegistries.positionResolvers.register(__assign(__assign({}, placement), { id: placement.id, name: placement.id }));
                languageRegistries.suggestionKinds.register({
                    id: placement.id,
                    name: placement.id,
                    kind: [],
                });
            }
            else {
                // Allow extension to the built-in placement resolvers
                var origResolve_1 = exists.resolve;
                exists.resolve = function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    var ext = placement.resolve.apply(placement, __spreadArray([], __read(args), false));
                    if (placement.overrideDefault) {
                        return ext;
                    }
                    var orig = origResolve_1.apply(void 0, __spreadArray([], __read(args), false));
                    return orig || ext;
                };
            }
        };
        try {
            for (var _o = __values(customProvider.customStatementPlacement()), _p = _o.next(); !_p.done; _p = _o.next()) {
                var placement = _p.value;
                _loop_1(placement);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_p && !_p.done && (_d = _o.return)) _d.call(_o);
            }
            finally { if (e_4) throw e_4.error; }
        }
    }
    if (customProvider.customSuggestionKinds) {
        var _loop_2 = function (kind) {
            (_f = kind.applyTo) === null || _f === void 0 ? void 0 : _f.forEach(function (applyTo) {
                var exists = languageRegistries.suggestionKinds.getIfExists(applyTo);
                if (exists) {
                    // avoid duplicates
                    if (exists.kind.indexOf(kind.id) === -1) {
                        exists.kind.push(kind.id);
                    }
                }
            });
            if (kind.overrideDefault) {
                var stbBehaviour = instanceSuggestionsRegistry.get(kind.id);
                if (stbBehaviour !== undefined) {
                    stbBehaviour.suggestions = kind.suggestionsResolver;
                    return "continue";
                }
            }
            instanceSuggestionsRegistry.register({
                id: kind.id,
                name: kind.id,
                suggestions: kind.suggestionsResolver,
            });
        };
        try {
            for (var _q = __values(customProvider.customSuggestionKinds()), _r = _q.next(); !_r.done; _r = _q.next()) {
                var kind = _r.value;
                _loop_2(kind);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_r && !_r.done && (_e = _q.return)) _e.call(_q);
            }
            finally { if (e_5) throw e_5.error; }
        }
    }
    if (customProvider.schemas) {
        var stbBehaviour = instanceSuggestionsRegistry.get(exports.SuggestionKind.Schemas);
        var s_1 = stbBehaviour.suggestions;
        stbBehaviour.suggestions = function (ctx, m) { return __awaiter(_this, void 0, void 0, function () {
            var standardSchemas, customSchemas, customSchemaCompletionItems;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, s_1(ctx, m)];
                    case 1:
                        standardSchemas = _a.sent();
                        return [4 /*yield*/, customProvider.schemas.resolve()];
                    case 2:
                        customSchemas = _a.sent();
                        customSchemaCompletionItems = customSchemas.map(function (x) {
                            var _a;
                            return ({
                                label: x.name,
                                insertText: "".concat((_a = x.completion) !== null && _a !== void 0 ? _a : x.name, "."),
                                command: TRIGGER_SUGGEST,
                                kind: exports.CompletionItemKind.Module,
                                sortText: exports.CompletionItemPriority.High,
                            });
                        });
                        return [2 /*return*/, __spreadArray(__spreadArray([], __read(standardSchemas), false), __read(customSchemaCompletionItems), false)];
                }
            });
        }); };
    }
    if (customProvider.tables) {
        var stbBehaviour = instanceSuggestionsRegistry.get(exports.SuggestionKind.Tables);
        var s_2 = stbBehaviour.suggestions;
        stbBehaviour.suggestions = function (ctx, m) { return __awaiter(_this, void 0, void 0, function () {
            var o, tableToken, tableNameParser, tableIdentifier, oo;
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, s_2(ctx, m)];
                    case 1:
                        o = _c.sent();
                        tableToken = getTableToken(ctx.currentToken);
                        tableNameParser = (_b = (_a = customProvider.tables) === null || _a === void 0 ? void 0 : _a.parseName) !== null && _b !== void 0 ? _b : defaultTableNameParser;
                        tableIdentifier = tableNameParser(tableToken);
                        return [4 /*yield*/, customProvider.tables.resolve(tableIdentifier)];
                    case 2:
                        oo = (_c.sent()).map(function (x) {
                            var _a;
                            return ({
                                label: x.name,
                                // if no custom completion is provided it's safe to move cursor further in the statement
                                insertText: "".concat((_a = x.completion) !== null && _a !== void 0 ? _a : x.name).concat(x.completion === x.name ? ' $0' : ''),
                                insertTextRules: exports.CompletionItemInsertTextRule.InsertAsSnippet,
                                command: TRIGGER_SUGGEST,
                                kind: exports.CompletionItemKind.Field,
                                sortText: exports.CompletionItemPriority.MediumHigh,
                            });
                        });
                        return [2 /*return*/, __spreadArray(__spreadArray([], __read(o), false), __read(oo), false)];
                }
            });
        }); };
    }
    if (customProvider.columns) {
        var stbBehaviour = instanceSuggestionsRegistry.get(exports.SuggestionKind.Columns);
        var s_3 = stbBehaviour.suggestions;
        stbBehaviour.suggestions = function (ctx, m) { return __awaiter(_this, void 0, void 0, function () {
            var o, tableToken, tableIdentifier, tableNameParser, oo, columns;
            var _a, _b, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0: return [4 /*yield*/, s_3(ctx, m)];
                    case 1:
                        o = _d.sent();
                        tableToken = getTableToken(ctx.currentToken);
                        tableNameParser = (_b = (_a = customProvider.tables) === null || _a === void 0 ? void 0 : _a.parseName) !== null && _b !== void 0 ? _b : defaultTableNameParser;
                        if (tableToken && tableToken.value) {
                            tableIdentifier = tableNameParser(tableToken);
                        }
                        oo = [];
                        if (!tableIdentifier) return [3 /*break*/, 3];
                        return [4 /*yield*/, ((_c = customProvider.columns) === null || _c === void 0 ? void 0 : _c.resolve(tableIdentifier))];
                    case 2:
                        columns = _d.sent();
                        oo = columns
                            ? columns.map(function (x) {
                                var _a;
                                return ({
                                    label: x.name,
                                    insertText: (_a = x.completion) !== null && _a !== void 0 ? _a : x.name,
                                    kind: exports.CompletionItemKind.Field,
                                    sortText: exports.CompletionItemPriority.High,
                                    detail: x.type,
                                    documentation: x.description,
                                });
                            })
                            : [];
                        _d.label = 3;
                    case 3: return [2 /*return*/, __spreadArray(__spreadArray([], __read(o), false), __read(oo), false)];
                }
            });
        }); };
    }
}
/**
 * Initializes language specific registries that are treated as singletons
 */
function initializeLanguageRegistries(id) {
    if (!LANGUAGES_CACHE.has(id)) {
        LANGUAGES_CACHE.set(id, {
            functions: new data.Registry(),
            operators: new data.Registry(),
            suggestionKinds: new data.Registry(initSuggestionsKindRegistry),
            positionResolvers: new data.Registry(initStatementPositionResolvers),
            macros: new data.Registry(),
        });
    }
    return LANGUAGES_CACHE.get(id);
}

var singleLineFullQuery = {
    query: "SELECT column1, FROM table1 WHERE column1 = \"value1\" GROUP BY column1 ORDER BY column1 DESC LIMIT 10",
    tokens: [
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 7,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 14,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 15,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 16,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 20,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 21,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 27,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 28,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 33,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 34,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 41,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 42,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 43,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 44,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 45,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 51,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 52,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 53,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 58,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 59,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 61,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 62,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 69,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 70,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 75,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 76,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 78,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 79,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 86,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 87,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 91,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 92,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 97,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 98,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 100,
                type: 'delimiter.sql',
                language: 'sql',
            },
        ],
    ],
};

var singleLineFullQueryWithAggregation = {
    query: 'SELECT count(column1), FROM table1 WHERE column1 = "value1" GROUP BY column1 ORDER BY column1 DESC LIMIT 10;',
    tokens: [
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 7,
                type: 'predefined.sql',
                language: 'sql',
            },
            {
                offset: 12,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 13,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 20,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 21,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 22,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 27,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 28,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 34,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 35,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 40,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 41,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 48,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 49,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 50,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 51,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 52,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 58,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 59,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 60,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 65,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 66,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 68,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 69,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 76,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 77,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 82,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 83,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 85,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 86,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 93,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 94,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 98,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 99,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 104,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 105,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 107,
                type: 'delimiter.sql',
                language: 'sql',
            },
        ],
    ],
};

var multiLineFullQuery = {
    query: "SELECT column1,  \n  FROM table1 \n  \n  WHERE column1 = \"value1\" \n  GROUP BY column1 ORDER BY column1 DESC \n  LIMIT 10;",
    tokens: [
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 7,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 14,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 15,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 4,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 11,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 13,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 14,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 15,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 16,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 17,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 24,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 8,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 9,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 16,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 17,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 22,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 25,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 26,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 33,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 34,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 38,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 8,
                type: 'delimiter.sql',
                language: 'sql',
            },
        ],
    ],
};

var multiLineFullQueryWithAggregation = {
    query: "SELECT count(column1),  \n  FROM table1 \n  \n  WHERE column1 = \"value1\" \n  GROUP BY column1 ORDER BY column1 DESC \n  LIMIT 10;",
    tokens: [
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 7,
                type: 'predefined.sql',
                language: 'sql',
            },
            {
                offset: 12,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 13,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 20,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 21,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 22,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 4,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 11,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 13,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 14,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 15,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 16,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 17,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 24,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 8,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 9,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 16,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 17,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 22,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 25,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 26,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 33,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 34,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 38,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 8,
                type: 'delimiter.sql',
                language: 'sql',
            },
        ],
    ],
};

var singleLineEmptyQuery = {
    query: '',
    tokens: [],
};

var singleLineTwoQueries = {
    query: 'SELECT column1, FROM table1 WHERE column1 = "value1" GROUP BY column1 ORDER BY column1 DESC LIMIT 10; SELECT column2, FROM table2 WHERE column2 = "value2" GROUP BY column1 ORDER BY column2 DESC LIMIT 10;',
    tokens: [
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 7,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 14,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 15,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 16,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 20,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 21,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 27,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 28,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 33,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 34,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 41,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 42,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 43,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 44,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 45,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 51,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 52,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 53,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 58,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 59,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 61,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 62,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 69,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 70,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 75,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 76,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 78,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 79,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 86,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 87,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 91,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 92,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 97,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 98,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 100,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 101,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 102,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 108,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 109,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 116,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 117,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 118,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 122,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 123,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 129,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 130,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 135,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 136,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 143,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 144,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 145,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 146,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 147,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 153,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 154,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 155,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 160,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 161,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 163,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 164,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 171,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 172,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 177,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 178,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 180,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 181,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 188,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 189,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 193,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 194,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 199,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 200,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 202,
                type: 'delimiter.sql',
                language: 'sql',
            },
        ],
    ],
};

var singleLineTwoQueriesWithAggregation = {
    query: 'SELECT count(column1), FROM table1 WHERE column1 = "value1" GROUP BY column1 ORDER BY column1 DESC LIMIT 10; SELECT count(column2), FROM table2 WHERE column2 = "value2" GROUP BY column1 ORDER BY column2 DESC LIMIT 10;',
    tokens: [
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 7,
                type: 'predefined.sql',
                language: 'sql',
            },
            {
                offset: 12,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 13,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 20,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 21,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 22,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 27,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 28,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 34,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 35,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 40,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 41,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 48,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 49,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 50,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 51,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 52,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 58,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 59,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 60,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 65,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 66,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 68,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 69,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 76,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 77,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 82,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 83,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 85,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 86,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 93,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 94,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 98,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 99,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 104,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 105,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 107,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 108,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 109,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 115,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 116,
                type: 'predefined.sql',
                language: 'sql',
            },
            {
                offset: 121,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 122,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 129,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 130,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 131,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 132,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 136,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 137,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 143,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 144,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 149,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 150,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 157,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 158,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 159,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 160,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 161,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 167,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 168,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 169,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 174,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 175,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 177,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 178,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 185,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 186,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 191,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 192,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 194,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 195,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 202,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 203,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 207,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 208,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 213,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 214,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 216,
                type: 'delimiter.sql',
                language: 'sql',
            },
        ],
    ],
};

var singleLineMultipleColumns = {
    query: 'SELECT count(column1), column2 FROM table1 WHERE column1 = "value1" GROUP BY column1 ORDER BY column1, avg(column2) DESC LIMIT 10;',
    tokens: [
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 7,
                type: 'predefined.sql',
                language: 'sql',
            },
            {
                offset: 12,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 13,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 20,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 21,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 22,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 30,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 31,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 35,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 36,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 42,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 43,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 48,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 49,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 56,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 57,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 58,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 59,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 60,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 66,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 67,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 68,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 73,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 74,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 76,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 77,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 84,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 85,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 90,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 91,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 93,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 94,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 101,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 102,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 103,
                type: 'predefined.sql',
                language: 'sql',
            },
            {
                offset: 106,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 107,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 114,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 115,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 116,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 120,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 121,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 126,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 127,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 129,
                type: 'delimiter.sql',
                language: 'sql',
            },
        ],
    ],
};

var multiLineMultipleColumns = {
    query: "SELECT count(column1), column2 \n  FROM table1 \n  \n  WHERE column1 = \"value1\" \n  GROUP BY column1 ORDER BY column1, avg(column2) DESC \n  LIMIT 10;",
    tokens: [
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 7,
                type: 'predefined.sql',
                language: 'sql',
            },
            {
                offset: 12,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 13,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 20,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 21,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 22,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 30,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 4,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 11,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 13,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 14,
                type: 'operator.sql',
                language: 'sql',
            },
            {
                offset: 15,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 16,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 17,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'identifier.quote.sql',
                language: 'sql',
            },
            {
                offset: 24,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 8,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 9,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 16,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 17,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 22,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 23,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 25,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 26,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 33,
                type: 'delimiter.sql',
                language: 'sql',
            },
            {
                offset: 34,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 35,
                type: 'predefined.sql',
                language: 'sql',
            },
            {
                offset: 38,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 39,
                type: 'identifier.sql',
                language: 'sql',
            },
            {
                offset: 46,
                type: 'delimiter.parenthesis.sql',
                language: 'sql',
            },
            {
                offset: 47,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 48,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 52,
                type: 'white.sql',
                language: 'sql',
            },
        ],
        [
            {
                offset: 0,
                type: 'keyword.sql',
                language: 'sql',
            },
            {
                offset: 5,
                type: 'white.sql',
                language: 'sql',
            },
            {
                offset: 6,
                type: 'number.sql',
                language: 'sql',
            },
            {
                offset: 8,
                type: 'delimiter.sql',
                language: 'sql',
            },
        ],
    ],
};



var testData = /*#__PURE__*/Object.freeze({
    __proto__: null,
    singleLineFullQuery: singleLineFullQuery,
    singleLineFullQueryWithAggregation: singleLineFullQueryWithAggregation,
    multiLineFullQuery: multiLineFullQuery,
    multiLineFullQueryWithAggregation: multiLineFullQueryWithAggregation,
    singleLineEmptyQuery: singleLineEmptyQuery,
    singleLineTwoQueries: singleLineTwoQueries,
    singleLineTwoQueriesWithAggregation: singleLineTwoQueriesWithAggregation,
    singleLineMultipleColumns: singleLineMultipleColumns,
    multiLineMultipleColumns: multiLineMultipleColumns
});

// Stub for the Monaco instance. Only implements the parts that are used in cloudwatch sql
var getMonacoMock = function (testData) { return ({
    editor: {
        tokenize: function (value, languageId) { return testData.get(value); },
    },
    Range: {
        containsPosition: function (range, position) {
            return (position.lineNumber >= range.startLineNumber &&
                position.lineNumber <= range.endLineNumber &&
                position.column >= range.startColumn &&
                position.column <= range.endColumn);
        },
    },
    languages: {
        CompletionItemKind: { Snippet: 2, Function: 1, Keyword: 3 },
        CompletionItemInsertTextRule: { InsertAsSnippet: 2 },
    },
}); };

// Stub for monacoTypes.editor.ITextModel
function TextModel(value) {
    return {
        getValue: function (eol, preserveBOM) {
            return value;
        },
        getValueInRange: function (range, eol) {
            var lines = value.split('\n');
            var line = lines[range.startLineNumber - 1];
            return line.trim().slice(range.startColumn === 0 ? 0 : range.startColumn - 1, range.endColumn - 1);
        },
        getLineLength: function (lineNumber) {
            var lines = value.split('\n');
            return lines[lineNumber - 1].trim().length;
        },
    };
}

function assertPosition(query, position, expected, monacoMock, resolversRegistry) {
    var testModel = TextModel(query);
    var current = linkedTokenBuilder(monacoMock, testModel, position);
    var statementPosition = getStatementPosition(current, resolversRegistry);
    expect(statementPosition).toContain(expected);
}
var testStatementPosition = function (expected, cases, resolvers) {
    describe("".concat(expected), function () {
        var MonacoMock;
        var statementPositionResolversRegistry;
        beforeEach(function () {
            var mockQueries = new Map();
            cases.forEach(function (c) { return mockQueries.set(c.query.query, c.query.tokens); });
            MonacoMock = getMonacoMock(mockQueries);
            statementPositionResolversRegistry = new data.Registry(function () {
                return resolvers().map(function (r) { return ({
                    id: r.id,
                    name: r.name || r.id,
                    resolve: r.resolve,
                }); });
            });
        });
        // using forEach here rather than test.each as been struggling to get the arguments intepolated in test name string
        cases.forEach(function (c) {
            test("".concat(c.query.query), function () {
                assertPosition(c.query.query, { lineNumber: c.position.line, column: c.position.column }, expected, MonacoMock, statementPositionResolversRegistry);
            });
        });
    });
};

var SQLEditorTestUtils = {
    testData: testData,
    testStatementPosition: testStatementPosition,
};

var AccessoryButton = function (_a) {
    var className = _a.className, props = __rest(_a, ["className"]);
    var styles = ui.useStyles2(getButtonStyles);
    return React__default.createElement(ui.Button, __assign({}, props, { className: css.cx(className, styles.button) }));
};
var getButtonStyles = function (theme) { return ({
    button: css.css({
        paddingLeft: theme.spacing(3 / 2),
        paddingRight: theme.spacing(3 / 2),
    }),
}); };

var Stack = function (_a) {
    var children = _a.children, props = __rest(_a, ["children"]);
    var styles = ui.useStyles2(React.useCallback(function (theme) { return getStyles(theme, props); }, [props]));
    return React__default.createElement("div", { className: styles.root }, children);
};
var getStyles = function (theme, props) {
    var _a, _b, _c;
    return ({
        root: css.css({
            display: 'flex',
            flexDirection: (_a = props.direction) !== null && _a !== void 0 ? _a : 'row',
            flexWrap: ((_b = props.wrap) !== null && _b !== void 0 ? _b : true) ? 'wrap' : undefined,
            alignItems: props.alignItems,
            gap: theme.spacing((_c = props.gap) !== null && _c !== void 0 ? _c : 2),
            flexGrow: props.flexGrow,
        }),
    });
};

var EditorFieldGroup = function (_a) {
    var children = _a.children;
    return React__default.createElement(Stack, { gap: 1 }, children);
};

var EditorHeader = function (_a) {
    var children = _a.children;
    var styles = ui.useStyles2(getStyles$1);
    return React__default.createElement("div", { className: styles.root }, children);
};
var getStyles$1 = function (theme) { return ({
    root: css.css({
        display: 'flex',
        flexWrap: 'wrap',
        alignItems: 'center',
        gap: theme.spacing(3),
        minHeight: theme.spacing(4),
    }),
}); };

var Space = function (props) {
    var styles = ui.useStyles2(React.useCallback(function (theme) { return getStyles$2(theme, props); }, [props]));
    return React__default.createElement("span", { className: css.cx(styles.wrapper) });
};
Space.defaultProps = {
    v: 0,
    h: 0,
    layout: 'block',
};
var getStyles$2 = function (theme, props) {
    var _a, _b;
    return ({
        wrapper: css.css([
            {
                paddingRight: theme.spacing((_a = props.h) !== null && _a !== void 0 ? _a : 0),
                paddingBottom: theme.spacing((_b = props.v) !== null && _b !== void 0 ? _b : 0),
            },
            props.layout === 'inline' && {
                display: 'inline-block',
            },
            props.layout === 'block' && {
                display: 'block',
            },
        ]),
    });
};

var EditorField = function (props) {
    var label = props.label, optional = props.optional, tooltip = props.tooltip, tooltipInteractive = props.tooltipInteractive, children = props.children, width = props.width, fieldProps = __rest(props, ["label", "optional", "tooltip", "tooltipInteractive", "children", "width"]);
    var styles = ui.useStyles2(React.useCallback(function (theme) { return getStyles$3(theme, width); }, [width]));
    // Null check for backward compatibility
    var childInputId = (fieldProps === null || fieldProps === void 0 ? void 0 : fieldProps.htmlFor) || (ui.ReactUtils === null || ui.ReactUtils === void 0 ? void 0 : ui.ReactUtils.getChildId(children));
    var labelEl = (React__default.createElement(React__default.Fragment, null,
        React__default.createElement("label", { className: styles.label, htmlFor: childInputId },
            label,
            optional && React__default.createElement("span", { className: styles.optional }, " - optional"),
            tooltip && (React__default.createElement(ui.Tooltip, { placement: "top", content: tooltip, theme: "info", interactive: tooltipInteractive },
                React__default.createElement(ui.Icon, { name: "info-circle", size: "sm", className: styles.icon })))),
        React__default.createElement(Space, { v: 0.5 })));
    return (React__default.createElement("div", { className: styles.root },
        React__default.createElement(ui.Field, __assign({ className: styles.field, label: labelEl }, fieldProps), children)));
};
var getStyles$3 = function (theme, width) {
    return {
        root: css.css({
            minWidth: theme.spacing(width !== null && width !== void 0 ? width : 0),
        }),
        label: css.css({
            fontSize: 12,
            fontWeight: theme.typography.fontWeightMedium,
        }),
        optional: css.css({
            fontStyle: 'italic',
            color: theme.colors.text.secondary,
        }),
        field: css.css({
            marginBottom: 0, // GrafanaUI/Field has a bottom margin which we must remove
        }),
        icon: css.css({
            color: theme.colors.text.secondary,
            marginLeft: theme.spacing(1),
            ':hover': {
                color: theme.colors.text.primary,
            },
        }),
    };
};

var EditorRow = function (_a) {
    var children = _a.children;
    var styles = ui.useStyles2(getStyles$4);
    return (React__default.createElement("div", { className: styles.root },
        React__default.createElement(Stack, { gap: 2 }, children)));
};
var getStyles$4 = function (theme) {
    return {
        root: css.css({
            padding: theme.spacing(1),
            backgroundColor: theme.colors.background.secondary,
            borderRadius: theme.shape.borderRadius(1),
        }),
    };
};

function EditorList(_a) {
    var items = _a.items, renderItem = _a.renderItem, onChange = _a.onChange;
    var onAddItem = function () {
        var newItems = __spreadArray(__spreadArray([], __read(items), false), [{}], false);
        onChange(newItems);
    };
    var onChangeItem = function (itemIndex, newItem) {
        var newItems = __spreadArray([], __read(items), false);
        newItems[itemIndex] = newItem;
        onChange(newItems);
    };
    var onDeleteItem = function (itemIndex) {
        var newItems = __spreadArray([], __read(items), false);
        newItems.splice(itemIndex, 1);
        onChange(newItems);
    };
    return (React__default.createElement(Stack, null,
        items.map(function (item, index) { return (React__default.createElement("div", { key: index }, renderItem(item, function (newItem) { return onChangeItem(index, newItem); }, function () { return onDeleteItem(index); }))); }),
        React__default.createElement(ui.Button, { onClick: onAddItem, variant: "secondary", size: "md", icon: "plus", "aria-label": "Add", type: "button" })));
}

var EditorRows = function (_a) {
    var children = _a.children;
    return (React__default.createElement(Stack, { gap: 0.5, direction: "column" }, children));
};

// Wrapper component around <Switch /> that properly aligns it in <EditorField />
var EditorSwitch = function (props) {
    var styles = getStyles$5();
    return (React__default.createElement("div", { className: styles.switch },
        React__default.createElement(ui.Switch, __assign({}, props))));
};
var getStyles$5 = function () {
    return {
        switch: css.css({
            display: 'flex',
            alignItems: 'center',
            minHeight: 30,
        }),
    };
};

var FlexItem = function (_a) {
    var grow = _a.grow, shrink = _a.shrink;
    return React__default.createElement("div", { style: { display: 'block', flexGrow: grow, flexShrink: shrink } });
};

function InlineSelect(_a) {
    var labelProp = _a.label, props = __rest(_a, ["label"]);
    var styles = ui.useStyles2(getSelectStyles);
    var _b = __read(React.useState(function () { return Math.random().toString(16).slice(2); }), 1), id = _b[0];
    var components = {
        SelectContainer: SelectContainer,
        ValueContainer: ValueContainer,
        SingleValue: ValueContainer,
    };
    return (React__default.createElement("div", { className: styles.root },
        labelProp && (React__default.createElement("label", { className: styles.label, htmlFor: id },
            labelProp,
            ':',
            "\u00A0")),
        React__default.createElement(ui.Select, __assign({ openMenuOnFocus: true, inputId: id }, props, { components: components }))));
}
var SelectContainer = function (props) {
    var children = props.children;
    var styles = ui.useStyles2(getSelectStyles);
    return (React__default.createElement(ui.SelectContainer, __assign({}, props, { className: css.cx(props.className, styles.container) }), children));
};
var ValueContainer = function (props) {
    var className = props.className, children = props.children;
    var styles = ui.useStyles2(getSelectStyles);
    return React__default.createElement("div", { className: css.cx(className, styles.valueContainer) }, children);
};
var getSelectStyles = function (theme) { return ({
    root: css.css({
        display: 'flex',
        fontSize: 12,
        alignItems: 'center',
    }),
    label: css.css({
        color: theme.colors.text.secondary,
        whiteSpace: 'nowrap',
    }),
    container: css.css({
        background: 'none',
        borderColor: 'transparent',
    }),
    valueContainer: css.css({
        display: 'flex',
        alignItems: 'center',
        flex: 'initial',
        color: theme.colors.text.secondary,
        fontSize: 12,
    }),
}); };

var InputGroup = function (_a) {
    var children = _a.children;
    var styles = ui.useStyles2(getStyles$6);
    // Find children with an invalid prop, and set a class name to raise their z-index so all
    // of the invalid border is visible
    var modifiedChildren = React.Children.map(children, function (child) {
        if (React.isValidElement(child) && child.props.invalid) {
            return React.cloneElement(child, { className: css.cx(child.props.className, styles.invalidChild) });
        }
        return child;
    });
    return React__default.createElement("div", { className: styles.root }, modifiedChildren);
};
// The later in the array the higher the priority for showing that element's border
var borderPriority = [
    '',
    'base',
    'hovered',
    'invalid',
    'focused',
];
var getStyles$6 = function () { return ({
    root: css.css({
        display: 'flex',
        // Style the direct children of the component
        '> *': {
            '&:not(:first-child)': {
                // Negative margin hides the double-border on adjacent selects
                marginLeft: -1,
            },
            '&:first-child': {
                borderTopRightRadius: 0,
                borderBottomRightRadius: 0,
            },
            '&:last-child': {
                borderTopLeftRadius: 0,
                borderBottomLeftRadius: 0,
            },
            '&:not(:first-child):not(:last-child)': {
                borderRadius: 0,
            },
            //
            position: 'relative',
            zIndex: borderPriority.indexOf('base'),
            // Adjacent borders are overlapping, so raise children up when hovering etc
            // so all that child's borders are visible.
            '&:hover': {
                zIndex: borderPriority.indexOf('hovered'),
            },
            '&:focus-within': {
                zIndex: borderPriority.indexOf('focused'),
            },
        },
    }),
    invalidChild: css.css({
        zIndex: borderPriority.indexOf('invalid'),
    }),
}); };

exports.AccessoryButton = AccessoryButton;
exports.EditorField = EditorField;
exports.EditorFieldGroup = EditorFieldGroup;
exports.EditorHeader = EditorHeader;
exports.EditorList = EditorList;
exports.EditorRow = EditorRow;
exports.EditorRows = EditorRows;
exports.EditorSwitch = EditorSwitch;
exports.FlexItem = FlexItem;
exports.InlineSelect = InlineSelect;
exports.InputGroup = InputGroup;
exports.LinkedToken = LinkedToken;
exports.SQLEditor = SQLEditor;
exports.SQLEditorTestUtils = SQLEditorTestUtils;
exports.Space = Space;
exports.Stack = Stack;
exports.getStandardSQLCompletionProvider = getStandardSQLCompletionProvider;
exports.grafanaStandardSQLLanguage = language;
exports.grafanaStandardSQLLanguageConf = conf;
//# sourceMappingURL=index.development.js.map
