import { Monaco, monacoTypes } from '@grafana/ui';
import React from 'react';
import { SQLCompletionItemProvider } from '../types';
import { SQLMonarchLanguage } from '../standardSql/types';
export interface LanguageDefinition extends monacoTypes.languages.ILanguageExtensionPoint {
    loader?: (module: any) => Promise<{
        language: SQLMonarchLanguage;
        conf: monacoTypes.languages.LanguageConfiguration;
    }>;
    completionProvider?: (m: Monaco, language?: SQLMonarchLanguage) => SQLCompletionItemProvider;
    formatter?: (q: string) => string;
}
interface SQLEditorProps {
    query: string;
    /**
     * Use for inspecting the query as it changes. I.e. for validation.
     */
    onChange?: (q: string, processQuery: boolean) => void;
    onBlur?: () => void;
    language?: LanguageDefinition;
    children?: (props: {
        formatQuery: () => void;
    }) => React.ReactNode;
    width?: number;
    height?: number;
}
export declare const SQLEditor: React.FC<SQLEditorProps>;
export declare const registerLanguageAndSuggestions: (monaco: Monaco, l: LanguageDefinition, lid: string) => Promise<void>;
export {};
