"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Suite = void 0;
const render_1 = require("@betterer/render");
const tasks_1 = require("@betterer/tasks");
const tasks_2 = require("./tasks");
const SuiteSummary_1 = require("./SuiteSummary");
exports.Suite = (0, render_1.memo)(function Runs({ context, suite, suiteSummary, done }) {
    const { ci, precommit } = context.config;
    return (render_1.React.createElement(render_1.React.Fragment, null,
        render_1.React.createElement(render_1.Box, { flexDirection: "column", paddingBottom: 1 },
            render_1.React.createElement(tasks_1.BettererTasksLogger, { name: "Betterer", update: update, exit: false, done: done, timer: !precommit && !ci }, suite.runs.map((run) => (render_1.React.createElement(tasks_1.BettererTaskLogger, { key: run.name, name: run.name, task: (0, tasks_2.useTask)(run) }))))),
        suiteSummary ? render_1.React.createElement(SuiteSummary_1.SuiteSummary, { context: context, suiteSummary: suiteSummary }) : null));
});
function update(state) {
    const { done, errors, running } = state;
    const runningStatus = running ? `${tests(running)} running... ` : '';
    const doneStatus = done ? `${tests(done)} done! ` : '';
    const errorStatus = errors ? `${tests(errors)} errored! ` : '';
    return `${runningStatus}${doneStatus}${errorStatus}`;
}
function tests(n) {
    return n === 1 ? `${n} test` : `${n} tests`;
}
//# sourceMappingURL=Suite.js.map