"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchReporter = void 0;
const render_1 = require("@betterer/render");
const suite_1 = require("../suite");
const WatchEnding_1 = require("./WatchEnding");
const WatchFiles_1 = require("./WatchFiles");
const WatchInstructions_1 = require("./WatchInstructions");
const WatchStarting_1 = require("./WatchStarting");
const useControls_1 = require("./useControls");
exports.WatchReporter = (0, render_1.memo)(function WatchReporter(props) {
    const { context, contextSummary, done, suiteSummary } = props;
    const suite = props.suiteSummary || props.suite;
    const editing = (0, useControls_1.useControls)(context);
    if (contextSummary) {
        return render_1.React.createElement(WatchEnding_1.WatchEnding, null);
    }
    if (suite) {
        return (render_1.React.createElement(render_1.React.Fragment, null,
            render_1.React.createElement(WatchFiles_1.WatchFiles, { context: context, editField: editing, suite: suite, running: !suiteSummary }),
            render_1.React.createElement(suite_1.Suite, { context: context, suite: suite, suiteSummary: suiteSummary, done: done }),
            render_1.React.createElement(WatchInstructions_1.WatchInstructions, null)));
    }
    return render_1.React.createElement(WatchStarting_1.WatchStarting, { context: context, editField: editing });
});
//# sourceMappingURL=WatchReporter.js.map