# Contributing Guide

This document describes the requirements for committing to this repository.

## Developer Certificate of Origin (DCO)

In order to contribute to this project, you must sign each of your commits to
attest that you have the right to contribute that code. This is done with the
`-s`/`--signoff` flag on `git commit`. More information about DCO can be found
[here](https://developercertificate.org/)

## Pull Request Management

All code that is contributed to oci-distribution must go through the Pull
Request (PR) process. To contribute a PR, fork this project, create a new
branch, make changes on that branch, and then use GitHub to open a pull request
with your changes.

Every PR must be reviewed by at least one Core Maintainer of the project. Once
a PR has been marked "Approved" by a Core Maintainer (and no other core
maintainer has an open "Rejected" vote), the PR may be merged. While it is fine
for non-maintainers to contribute their own code reviews, those reviews do not
satisfy the above requirement.

## Code of Conduct

This project has adopted the [CNCF Code of
Conduct](https://github.com/cncf/foundation/blob/master/code-of-conduct.md).
