/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;

public interface PrivateKey
extends java.security.PrivateKey {
    public static final Type RSA = Type.RSA;
    public static final Type DSA = Type.DSA;
    public static final Type EC = Type.EC;
    public static final Type DiffieHellman = Type.DiffieHellman;

    public Type getType();

    public byte[] getUniqueID() throws TokenException;

    public int getStrength();

    public CryptoToken getOwningToken();

    public static final class Type {
        private OBJECT_IDENTIFIER oid;
        private String name;
        private int pkcs11Type;
        private static Hashtable<OBJECT_IDENTIFIER, Type> oidMap = new Hashtable();
        public static OBJECT_IDENTIFIER DH_OID = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 10046L, 2L, 1L});
        private static int CKK_RSA = 0;
        private static int CKK_DSA = 1;
        private static int CKK_DH = 2;
        private static int CKK_EC = 3;
        private static int CKK_X9_42_DH = 4;
        private static int CKK_KEA = 5;
        public static final Type RSA = new Type(OBJECT_IDENTIFIER.PKCS1.subBranch(1L), "RSA", CKK_RSA);
        public static final Type DSA = new Type(Algorithm.ANSI_X9_ALGORITHM.subBranch(1L), "DSA", CKK_DSA);
        public static final Type EC = new Type(Algorithm.ANSI_X962_OID.subBranch(2L).subBranch(1L), "EC", CKK_EC);
        public static final Type DiffieHellman = new Type(DH_OID, "DiffieHellman", CKK_DH);

        private Type() {
        }

        private Type(OBJECT_IDENTIFIER oid, String name, int pkcs11Type) {
            this.oid = oid;
            this.name = name;
            Type old = oidMap.put(oid, this);
            this.pkcs11Type = pkcs11Type;
            assert (old == null);
        }

        public static Type fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
            Type obj = oidMap.get(oid);
            if (obj == null) {
                throw new NoSuchAlgorithmException();
            }
            return obj;
        }

        public String toString() {
            return this.name;
        }

        public OBJECT_IDENTIFIER toOID() {
            return this.oid;
        }

        public int getPKCS11Type() {
            return this.pkcs11Type;
        }
    }
}

