/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.nss.PR;
import org.mozilla.jss.nss.PRErrors;
import org.mozilla.jss.nss.PRFDProxy;

public class TestPRFD {
    public static void TestPROpenNoCreate() {
        String name = "path_which_should_not_exist_on_any_reasonable_system";
        PRFDProxy fd = PR.Open((String)name, (int)2, (int)420);
        assert (fd == null);
    }

    public static void TestPROpenClose() {
        PRFDProxy fd = PR.Open((String)"results/prfd_open_close", (int)12, (int)420);
        assert (fd != null);
        assert (PR.Close((PRFDProxy)fd) == PR.SUCCESS);
    }

    public static void TestPROpenWriteClose() {
        PRFDProxy fd = PR.Open((String)"results/prfd_open_write_close", (int)12, (int)420);
        assert (fd != null);
        byte[] data = new byte[]{42, 32, 42, 32};
        assert (PR.Write((PRFDProxy)fd, (byte[])data) == 4);
        assert (PR.Close((PRFDProxy)fd) == PR.SUCCESS);
    }

    public static void TestPRRead() {
        byte[] data = new byte[]{42, 32, 42, 32};
        PRFDProxy fd = PR.Open((String)"results/prfd_open_write_close", (int)4, (int)420);
        assert (fd != null);
        byte[] read_data = PR.Read((PRFDProxy)fd, (int)10);
        assert (read_data != null);
        assert (read_data.length == data.length);
        for (int i = 0; i < data.length; ++i) {
            assert (read_data[i] == data[i]);
        }
        assert (PR.Close((PRFDProxy)fd) == PR.SUCCESS);
    }

    public static void TestPREmptyRead() {
        PRFDProxy fd = PR.Open((String)"results/prfd_open_close", (int)4, (int)420);
        assert (fd != null);
        byte[] read_data = PR.Read((PRFDProxy)fd, (int)10);
        assert (read_data == null || read_data.length == 0);
        assert (PR.Close((PRFDProxy)fd) == PR.SUCCESS);
    }

    public static void TestNewTCPSocket() {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
    }

    public static void TestShutdown() {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        PR.Shutdown((PRFDProxy)fd, (int)PR.SHUTDOWN_RCV);
        PR.Shutdown((PRFDProxy)fd, (int)PR.SHUTDOWN_SEND);
        PR.Shutdown((PRFDProxy)fd, (int)PR.SHUTDOWN_BOTH);
        assert (PR.Close((PRFDProxy)fd) == PR.SUCCESS);
    }

    public static void TestConstants() {
        System.out.println("PR.SHUTDOWN_RCV: " + PR.SHUTDOWN_RCV);
        System.out.println("PR.SHUTDOWN_SEND: " + PR.SHUTDOWN_SEND);
        System.out.println("PR.SHUTDOWN_BOTH: " + PR.SHUTDOWN_BOTH);
        assert (PR.ErrorToName((int)PRErrors.WOULD_BLOCK_ERROR).equals("PR_WOULD_BLOCK_ERROR"));
    }

    public static void main(String[] args) {
        System.loadLibrary("jss");
        System.out.println("Calling TestPROpenNoCreate()...");
        TestPRFD.TestPROpenNoCreate();
        System.out.println("Calling TestPROpenClose()...");
        TestPRFD.TestPROpenClose();
        System.out.println("Calling TestPROpenWriteClose()...");
        TestPRFD.TestPROpenWriteClose();
        System.out.println("Calling TestPRRead()...");
        TestPRFD.TestPRRead();
        System.out.println("Calling TestPREmptyRead()...");
        TestPRFD.TestPREmptyRead();
        System.out.println("Calling TestNewTCPSocket()...");
        TestPRFD.TestNewTCPSocket();
        System.out.println("Calling TestShutdown()...");
        TestPRFD.TestShutdown();
        System.out.println("Calling TestConstants()...");
        TestPRFD.TestConstants();
    }
}

