// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2020 Alibaba Cloud. or its affiliates. All Rights Reserved.
 */
#include <linux/arm-smccc.h>
#include <kvm/arm_hypercalls.h>
#include <asm/pvpoll-abi.h>
#include <asm/kvm_mmu.h>

u32 kvm_pv_poll_control_set(struct kvm_vcpu *vcpu)
{
	gpa_t guest_poll_ctl;
	struct pv_vcpu_poll_ctl guest_vcpu_poll_ctl = {};

	guest_poll_ctl = smccc_get_arg1(vcpu);
	if (guest_poll_ctl != -1UL)
		kvm_write_guest_lock(vcpu->kvm, guest_poll_ctl, &guest_vcpu_poll_ctl,
			sizeof(guest_vcpu_poll_ctl));
	return SMCCC_RET_SUCCESS;
}

u32 kvm_pv_poll_control_update(struct kvm_vcpu *vcpu)
{
	bool host_halt_poll;

	host_halt_poll = smccc_get_arg1(vcpu);
	vcpu->arch.pv_poll_ctl.host_halt_poll = host_halt_poll;
	return SMCCC_RET_SUCCESS;
}
