// SPDX-License-Identifier: GPL-2.0
/* This module is a simplified version of the pvpanic driver. */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/types.h>
#include <dragonball/dragonball.h>

#define MAGIC_IOPORT_SIGNAL_GUEST_PANIC 0x03f1
#define MAGIC_VALUE_SIGNAL_GUEST_PANIC 1

extern void arch_outb(unsigned long value, int addr);

static int
pvpanic_panic_notify(struct notifier_block *nb, unsigned long code,
		     void *unused)
{
	pr_info("Dragonball pvpanic: Guest panic! Send pio to vmm.\n");
	pr_info("Dragonball pvpanic: kimage_voffset 0x%llx PHYS_OFFSET 0x%llx\n",
	     kimage_voffset, PHYS_OFFSET);
	arch_outb(MAGIC_VALUE_SIGNAL_GUEST_PANIC,
		  MAGIC_IOPORT_SIGNAL_GUEST_PANIC);
	return NOTIFY_DONE;
}

static struct notifier_block pvpanic_panic_nb = {
	.notifier_call = pvpanic_panic_notify,
	.priority = 1,		/* let this called before broken drm_fb_helper */
};

static int __init pvpanic_init(void)
{
	pr_info("Dragonball pvpanic module: init!\n");
	atomic_notifier_chain_register(&panic_notifier_list, &pvpanic_panic_nb);

	return 0;
}

static void __exit pvpanic_exit(void)
{
	pr_info("Dragonball pvpanic module: exit!\n");
	atomic_notifier_chain_unregister(&panic_notifier_list,
					 &pvpanic_panic_nb);
}

module_init(pvpanic_init);
module_exit(pvpanic_exit);

MODULE_LICENSE("GPL");
