// SPDX-License-Identifier: GPL-2.0
#ifndef __KPP_H
#define __KPP_H

#include <stdint.h>

struct kpp_ctx {
	uint32_t flags; /* SYNC/ASYNC flags */
	unsigned int reqsize;

	struct kpp_alg *alg;
	void *__ctx[];
};

struct kpp_req;
typedef void (*kpp_completion_t)(struct kpp_req *req, int err);

struct kpp_req {
	unsigned char *src;
	unsigned char *dst;

	unsigned int src_len;
	unsigned int dst_len;

	kpp_completion_t complete;
	void *data;

	struct kpp_ctx *ctx;
	void *__req[];
};

struct kpp_alg {
	const char *name;
	int (*set_secret)(struct kpp_ctx *ctx, void *buffer, unsigned int len);
	int (*generate_public_key)(struct kpp_req *req);
	int (*generate_key_pair)(struct kpp_req *req);
	int (*compute_shared_secret)(struct kpp_req *req);
	unsigned int (*max_size)(struct kpp_ctx *ctx);
	int (*init)(struct kpp_ctx *ctx);
	void (*exit)(struct kpp_ctx *ctx);

	unsigned int ctxsize;
};

struct kpp_alg_entry {
	struct kpp_alg *alg;
	struct kpp_alg_entry *next;
};

struct kpp_ctx *kpp_alloc_ctx(const char *alg_name, uint32_t flag);
void kpp_free_ctx(struct kpp_ctx *ctx);
struct kpp_req *kpp_alloc_req(struct kpp_ctx *ctx);
void kpp_free_req(struct kpp_req *req);
void kpp_req_set_callback(struct kpp_req *req, kpp_completion_t complete, void *data);
void kpp_set_req(struct kpp_req *req, unsigned char *src, uint32_t src_len,
		 unsigned char *dst, uint32_t dst_len);
int kpp_set_secret(struct kpp_ctx *ctx, void *buffer, unsigned int len);
int kpp_generate_public_key(struct kpp_req *req);
int kpp_generate_key_pair(struct kpp_req *req);
int kpp_compute_shared_secret(struct kpp_req *req);
unsigned int kpp_maxsize(struct kpp_ctx *ctx);
void kpp_register_algs(void);
void kpp_unregister_algs(void);

#endif
