; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-linux -mcpu=corei7 | FileCheck %s
; RUN: opt -instsimplify -disable-output < %s

define <8 x ptr> @SHUFF0(<4 x ptr> %ptrv) nounwind {
; CHECK-LABEL: SHUFF0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,1,2]
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,1,1,1]
; CHECK-NEXT:    movdqa %xmm2, %xmm0
; CHECK-NEXT:    retl
entry:
  %G = shufflevector <4 x ptr> %ptrv, <4 x ptr> %ptrv, <8 x i32> <i32 2, i32 7, i32 1, i32 2, i32 4, i32 5, i32 1, i32 1>
  ret <8 x ptr> %G
}

define <4 x ptr> @SHUFF1(<4 x ptr> %ptrv) nounwind {
; CHECK-LABEL: SHUFF1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,3,2]
; CHECK-NEXT:    retl
entry:
  %G = shufflevector <4 x ptr> %ptrv, <4 x ptr> %ptrv, <4 x i32> <i32 2, i32 7, i32 7, i32 2>
  ret <4 x ptr> %G
}

define <4 x ptr> @SHUFF3(<4 x ptr> %ptrv) nounwind {
; CHECK-LABEL: SHUFF3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,1,2]
; CHECK-NEXT:    retl
entry:
  %G = shufflevector <4 x ptr> %ptrv, <4 x ptr> undef, <4 x i32> <i32 2, i32 7, i32 1, i32 2>
  ret <4 x ptr> %G
}

define <4 x ptr> @LOAD0(ptr %p) nounwind {
; CHECK-LABEL: LOAD0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movaps (%eax), %xmm0
; CHECK-NEXT:    retl
entry:
  %G = load <4 x ptr>, ptr %p
  ret <4 x ptr> %G
}

define <4 x ptr> @LOAD1(ptr %p) nounwind {
; CHECK-LABEL: LOAD1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movdqa (%eax), %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[3,1,0,3]
; CHECK-NEXT:    movdqa %xmm1, (%eax)
; CHECK-NEXT:    retl
entry:
  %G = load <4 x ptr>, ptr %p
  %T = shufflevector <4 x ptr> %G, <4 x ptr> %G, <4 x i32> <i32 7, i32 1, i32 4, i32 3>
  store <4 x ptr> %T, ptr %p
  ret <4 x ptr> %G
}

define <4 x ptr> @LOAD2(ptr %p) nounwind {
; CHECK-LABEL: LOAD2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl $28, %esp
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movaps (%eax), %xmm0
; CHECK-NEXT:    movaps %xmm0, (%esp)
; CHECK-NEXT:    addl $28, %esp
; CHECK-NEXT:    retl
entry:
  %I = alloca <4 x ptr>
  %G = load <4 x ptr>, ptr %p
  store <4 x ptr> %G, ptr %I
  %Z = load <4 x ptr>, ptr %I
  ret <4 x ptr> %Z
}

define <4 x i32> @INT2PTR0(ptr %p) nounwind {
; CHECK-LABEL: INT2PTR0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movaps (%eax), %xmm0
; CHECK-NEXT:    retl
entry:
  %G = load <4 x ptr>, ptr %p
  %K = ptrtoint <4 x ptr> %G to <4 x i32>
  ret <4 x i32> %K
}

define <4 x ptr> @INT2PTR1(ptr %p) nounwind {
; CHECK-LABEL: INT2PTR1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; CHECK-NEXT:    retl
entry:
  %G = load <4 x i8>, ptr %p
  %K = inttoptr <4 x i8> %G to <4 x ptr>
  ret <4 x ptr> %K
}

define <4 x ptr> @BITCAST0(ptr %p) nounwind {
; CHECK-LABEL: BITCAST0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movaps (%eax), %xmm0
; CHECK-NEXT:    retl
entry:
  %G = load <4 x ptr>, ptr %p
  %T = bitcast <4 x ptr> %G to <4 x ptr>
  ret <4 x ptr> %T
}

define <2 x ptr> @BITCAST1(ptr %p) nounwind {
; CHECK-LABEL: BITCAST1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; CHECK-NEXT:    retl
entry:
  %G = load <2 x ptr>, ptr %p
  %T = bitcast <2 x ptr> %G to <2 x ptr>
  ret <2 x ptr> %T
}

define <4 x i32> @ICMP0(ptr %p0, ptr %p1) nounwind {
; CHECK-LABEL: ICMP0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movdqa (%ecx), %xmm0
; CHECK-NEXT:    pcmpgtd (%eax), %xmm0
; CHECK-NEXT:    movaps {{.*#+}} xmm1 = [9,8,7,6]
; CHECK-NEXT:    blendvps %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; CHECK-NEXT:    movaps %xmm1, %xmm0
; CHECK-NEXT:    retl
entry:
  %g0 = load <4 x ptr>, ptr %p0
  %g1 = load <4 x ptr>, ptr %p1
  %k = icmp sgt <4 x ptr> %g0, %g1
  %j = select <4 x i1> %k, <4 x i32> <i32 0, i32 1, i32 2, i32 4>, <4 x i32> <i32 9, i32 8, i32 7, i32 6>
  ret <4 x i32> %j
}

define <4 x i32> @ICMP1(ptr %p0, ptr %p1) nounwind {
; CHECK-LABEL: ICMP1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movdqa (%ecx), %xmm0
; CHECK-NEXT:    pcmpeqd (%eax), %xmm0
; CHECK-NEXT:    movaps {{.*#+}} xmm1 = [9,8,7,6]
; CHECK-NEXT:    blendvps %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; CHECK-NEXT:    movaps %xmm1, %xmm0
; CHECK-NEXT:    retl
entry:
  %g0 = load <4 x ptr>, ptr %p0
  %g1 = load <4 x ptr>, ptr %p1
  %k = icmp eq <4 x ptr> %g0, %g1
  %j = select <4 x i1> %k, <4 x i32> <i32 0, i32 1, i32 2, i32 4>, <4 x i32> <i32 9, i32 8, i32 7, i32 6>
  ret <4 x i32> %j
}

