/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux.loongarch64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;
import sun.jvm.hotspot.debugger.loongarch64.LOONGARCH64ThreadContext;

public final class LinuxLOONGARCH64CFrame
extends BasicCFrame {
    private static final int ADDRESS_SIZE = 8;
    private Address pc;
    private Address fp;
    private LinuxDebugger dbg;

    public LinuxLOONGARCH64CFrame(LinuxDebugger dbg, Address fp, Address pc) {
        super(dbg.getCDebugger());
        this.fp = fp;
        this.pc = pc;
        this.dbg = dbg;
    }

    @Override
    public ClosestSymbol closestSymbolToPC() {
        return this.dbg.lookup(this.dbg.getAddressValue(this.pc()));
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.fp;
    }

    @Override
    public CFrame sender(ThreadProxy thread) {
        LOONGARCH64ThreadContext context = (LOONGARCH64ThreadContext)thread.getContext();
        Address sp = context.getRegisterAsAddress(3);
        if (this.fp == null || this.fp.lessThan(sp)) {
            return null;
        }
        Address nextFP = this.fp.getAddressAt(-16L);
        if (nextFP == null) {
            return null;
        }
        Address nextPC = this.fp.getAddressAt(-8L);
        if (nextPC == null) {
            return null;
        }
        return new LinuxLOONGARCH64CFrame(this.dbg, nextFP, nextPC);
    }
}

