/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.remote;

import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerBase;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.DebuggerUtilities;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.remote.RemoteAddress;
import sun.jvm.hotspot.debugger.remote.RemoteDebugger;
import sun.jvm.hotspot.debugger.remote.RemoteOopHandle;
import sun.jvm.hotspot.debugger.remote.RemoteThreadFactory;
import sun.jvm.hotspot.debugger.remote.amd64.RemoteAMD64ThreadFactory;
import sun.jvm.hotspot.debugger.remote.loongarch64.RemoteLOONGARCH64ThreadFactory;
import sun.jvm.hotspot.debugger.remote.mips64.RemoteMIPS64ThreadFactory;
import sun.jvm.hotspot.debugger.remote.sparc.RemoteSPARCThreadFactory;
import sun.jvm.hotspot.debugger.remote.x86.RemoteX86ThreadFactory;

public class RemoteDebuggerClient
extends DebuggerBase
implements JVMDebugger {
    private RemoteDebugger remoteDebugger;
    private RemoteThreadFactory threadFactory;
    private boolean unalignedAccessesOkay = false;
    private static final int cacheSize = 0x1000000;

    public RemoteDebuggerClient(RemoteDebugger remoteDebugger) throws DebuggerException {
        try {
            int cacheNumPages;
            int cachePageSize;
            this.remoteDebugger = remoteDebugger;
            this.machDesc = remoteDebugger.getMachineDescription();
            this.utils = new DebuggerUtilities(this.machDesc.getAddressSize(), this.machDesc.isBigEndian());
            String cpu = remoteDebugger.getCPU();
            if (cpu.equals("sparc")) {
                this.threadFactory = new RemoteSPARCThreadFactory(this);
                cachePageSize = 8192;
                cacheNumPages = this.parseCacheNumPagesProperty(0x1000000 / cachePageSize);
            } else if (cpu.equals("x86")) {
                this.threadFactory = new RemoteX86ThreadFactory(this);
                cachePageSize = 4096;
                cacheNumPages = this.parseCacheNumPagesProperty(0x1000000 / cachePageSize);
                this.unalignedAccessesOkay = true;
            } else if (cpu.equals("amd64") || cpu.equals("x86_64")) {
                this.threadFactory = new RemoteAMD64ThreadFactory(this);
                cachePageSize = 4096;
                cacheNumPages = this.parseCacheNumPagesProperty(0x1000000 / cachePageSize);
                this.unalignedAccessesOkay = true;
            } else if (cpu.equals("mips64") || cpu.equals("mips64el")) {
                this.threadFactory = new RemoteMIPS64ThreadFactory(this);
                cachePageSize = 4096;
                cacheNumPages = this.parseCacheNumPagesProperty(0x1000000 / cachePageSize);
                this.unalignedAccessesOkay = true;
            } else if (cpu.equals("loongarch64")) {
                this.threadFactory = new RemoteLOONGARCH64ThreadFactory(this);
                cachePageSize = 4096;
                cacheNumPages = this.parseCacheNumPagesProperty(0x1000000 / cachePageSize);
                this.unalignedAccessesOkay = true;
            } else {
                try {
                    Class<?> tf = Class.forName("sun.jvm.hotspot.debugger.remote." + cpu.toLowerCase() + ".Remote" + cpu.toUpperCase() + "ThreadFactory");
                    Constructor<?>[] ctf = tf.getConstructors();
                    this.threadFactory = (RemoteThreadFactory)ctf[0].newInstance(this);
                }
                catch (Exception e) {
                    throw new DebuggerException("Thread access for CPU architecture " + cpu + " not yet supported");
                }
                cachePageSize = 4096;
                cacheNumPages = this.parseCacheNumPagesProperty(0x1000000 / cachePageSize);
                this.unalignedAccessesOkay = false;
            }
            this.initCache(cachePageSize, cacheNumPages);
            this.jbooleanSize = remoteDebugger.getJBooleanSize();
            this.jbyteSize = remoteDebugger.getJByteSize();
            this.jcharSize = remoteDebugger.getJCharSize();
            this.jdoubleSize = remoteDebugger.getJDoubleSize();
            this.jfloatSize = remoteDebugger.getJFloatSize();
            this.jintSize = remoteDebugger.getJIntSize();
            this.jlongSize = remoteDebugger.getJLongSize();
            this.jshortSize = remoteDebugger.getJShortSize();
            this.javaPrimitiveTypesConfigured = true;
            this.narrowOopBase = remoteDebugger.getNarrowOopBase();
            this.narrowOopShift = remoteDebugger.getNarrowOopShift();
            this.narrowKlassBase = remoteDebugger.getNarrowKlassBase();
            this.narrowKlassShift = remoteDebugger.getNarrowKlassShift();
            this.heapOopSize = remoteDebugger.getHeapOopSize();
            this.klassPtrSize = remoteDebugger.getKlassPtrSize();
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    public long[] getThreadIntegerRegisterSet(Address addr) {
        try {
            return this.remoteDebugger.getThreadIntegerRegisterSet(this.getAddressValue(addr), true);
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    public long[] getThreadIntegerRegisterSet(long id) {
        try {
            return this.remoteDebugger.getThreadIntegerRegisterSet(id, false);
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public boolean hasProcessList() throws DebuggerException {
        throw new DebuggerException("Should not be called on RemoteDebuggerClient");
    }

    @Override
    public List getProcessList() throws DebuggerException {
        throw new DebuggerException("Should not be called on RemoteDebuggerClient");
    }

    @Override
    public void attach(int processID) throws DebuggerException {
        throw new DebuggerException("Should not be called on RemoteDebuggerClient");
    }

    @Override
    public void attach(String executableName, String coreFileName) throws DebuggerException {
        throw new DebuggerException("Should not be called on RemoteDebuggerClient");
    }

    @Override
    public boolean detach() {
        throw new DebuggerException("Should not be called on RemoteDebuggerClient");
    }

    @Override
    public Address parseAddress(String addressString) throws NumberFormatException {
        long addr = this.utils.scanAddress(addressString);
        if (addr == 0L) {
            return null;
        }
        return new RemoteAddress(this, addr);
    }

    @Override
    public String getOS() throws DebuggerException {
        try {
            return this.remoteDebugger.getOS();
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public String getCPU() {
        try {
            return this.remoteDebugger.getCPU();
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public boolean hasConsole() throws DebuggerException {
        try {
            return this.remoteDebugger.hasConsole();
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public String consoleExecuteCommand(String cmd) throws DebuggerException {
        try {
            return this.remoteDebugger.consoleExecuteCommand(cmd);
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public String getConsolePrompt() throws DebuggerException {
        try {
            return this.remoteDebugger.getConsolePrompt();
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public CDebugger getCDebugger() throws DebuggerException {
        return null;
    }

    @Override
    public Address lookup(String objectName, String symbol) {
        try {
            long addr = this.remoteDebugger.lookupInProcess(objectName, symbol);
            if (addr == 0L) {
                return null;
            }
            return new RemoteAddress(this, addr);
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public OopHandle lookupOop(String objectName, String symbol) {
        try {
            long addr = this.remoteDebugger.lookupInProcess(objectName, symbol);
            if (addr == 0L) {
                return null;
            }
            return new RemoteOopHandle(this, addr);
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public long readCInteger(long address, long numBytes, boolean isUnsigned) throws UnmappedAddressException, UnalignedAddressException {
        if (!this.unalignedAccessesOkay) {
            this.utils.checkAlignment(address, numBytes);
        } else if (numBytes == 8L) {
            this.utils.checkAlignment(address, 4L);
        } else {
            this.utils.checkAlignment(address, numBytes);
        }
        byte[] data = this.readBytes(address, numBytes);
        return this.utils.dataToCInteger(data, isUnsigned);
    }

    @Override
    public long readJLong(long address) throws UnmappedAddressException, UnalignedAddressException {
        if (this.unalignedAccessesOkay) {
            this.utils.checkAlignment(address, this.jintSize);
        } else {
            this.utils.checkAlignment(address, this.jlongSize);
        }
        byte[] data = this.readBytes(address, this.jlongSize);
        return this.utils.dataToJLong(data, this.jlongSize);
    }

    @Override
    public void configureJavaPrimitiveTypeSizes(long jbooleanSize, long jbyteSize, long jcharSize, long jdoubleSize, long jfloatSize, long jintSize, long jlongSize, long jshortSize) {
        throw new DebuggerException("Should not be called on RemoteDebuggerClient");
    }

    public void setMachineDescription(MachineDescription machDesc) {
        throw new DebuggerException("Should not be called on RemoteDebuggerClient");
    }

    public int getRemoteProcessAddressSize() {
        throw new DebuggerException("Should not be called on RemoteDebuggerClient");
    }

    public String addressValueToString(long addr) {
        return this.utils.addressValueToString(addr);
    }

    @Override
    public long getAddressValue(Address addr) throws DebuggerException {
        if (addr == null) {
            return 0L;
        }
        return ((RemoteAddress)addr).getValue();
    }

    public Address newAddress(long value) {
        if (value == 0L) {
            return null;
        }
        return new RemoteAddress(this, value);
    }

    RemoteAddress readAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new RemoteAddress(this, value);
    }

    RemoteAddress readCompOopAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new RemoteAddress(this, value);
    }

    RemoteAddress readCompKlassAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readCompKlassAddressValue(address);
        return value == 0L ? null : new RemoteAddress(this, value);
    }

    RemoteOopHandle readOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new RemoteOopHandle(this, value);
    }

    RemoteOopHandle readCompOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new RemoteOopHandle(this, value);
    }

    boolean areThreadsEqual(Address addr1, Address addr2) {
        try {
            return this.remoteDebugger.areThreadsEqual(this.getAddressValue(addr1), true, this.getAddressValue(addr2), true);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    boolean areThreadsEqual(long id1, long id2) {
        try {
            return this.remoteDebugger.areThreadsEqual(id1, false, id2, false);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    boolean areThreadsEqual(Address addr1, long id2) {
        try {
            return this.remoteDebugger.areThreadsEqual(this.getAddressValue(addr1), true, id2, false);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    boolean areThreadsEqual(long id1, Address addr2) {
        try {
            return this.remoteDebugger.areThreadsEqual(id1, false, this.getAddressValue(addr2), true);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    int getThreadHashCode(Address a) {
        try {
            return this.remoteDebugger.getThreadHashCode(this.getAddressValue(a), true);
        }
        catch (RemoteException remoteException) {
            return a.hashCode();
        }
    }

    int getThreadHashCode(long id) {
        try {
            return this.remoteDebugger.getThreadHashCode(id, false);
        }
        catch (RemoteException remoteException) {
            return (int)id;
        }
    }

    @Override
    public ThreadProxy getThreadForIdentifierAddress(Address addr) {
        return this.threadFactory.createThreadWrapper(addr);
    }

    @Override
    public ThreadProxy getThreadForThreadId(long id) {
        return this.threadFactory.createThreadWrapper(id);
    }

    @Override
    public MachineDescription getMachineDescription() throws DebuggerException {
        return this.machDesc;
    }

    @Override
    public ReadResult readBytesFromProcess(long address, long numBytes) {
        try {
            return this.remoteDebugger.readBytesFromProcess(address, numBytes);
        }
        catch (RemoteException e) {
            throw new DebuggerException(e);
        }
    }

    @Override
    public void writeBytesToProcess(long a, long b, byte[] c) {
        throw new DebuggerException("Unimplemented!");
    }
}

