#!/bin/bash

url="https://openwebapi.oceanbase.com/api/web/oceanbase/report"
type=oceanbase-ce
version=4.2.1.4
release=104000052024022918
ip=($hostname -i)
hostHash=$(echo -n "$ip" | sha1sum | awk '{print $1}')
cnf_file='/etc/oceanbase.cnf'

step='none'
reporter='none'

jsonData=$(jq -n --arg reporter "$reporter" \
                 --arg type "$type" \
                 --arg step "$step" \
                 --arg version "$version" \
                 --arg release "$revision" \
                 --arg hostHash "$hostHash" '{
  component: "ocs",
  content: {
    reporter: $reporter,
    type: $type,
    step: $step,
    version: $version,
    release: $release,
    hostHash: $hostHash,
    observerConfig: {}
  }
}')

function add_observer_config {
    while IFS='=' read -r key value; do
        key=$(echo "$key" | awk '{$1=$1};1')
        value=$(echo "$value" | awk '{$1=$1};1')
        value=$(echo "$value" | sed 's/^"//' | sed 's/"$//')
        if [[ -n "$key" && ! "$key" =~ ^\; && $key != *"rootPwd"* ]]; then
            jsonData=$(echo "$jsonData" | jq --arg parent "content" --arg child "observerConfig" --arg key "$key" --arg value "$value" '.[$parent][$child][$key] = $value')
        fi
    done < "$cnf_file"
}

# Function Name: do_telemetry
# Purpose: prepare the telemetry json data
# Arguments: arg1 - 0 means rpm uninstall, 1 means rpm install, 2 means rpm upgrade, 3 means systemd deploy
# Arguments: arg2 - systemd step: 10 means only start, 11 means start successfully with bootstrap,
# 12 means start successfully without bootstrap
# Return Value: None
function do_telemetry {
    # arg1 0 means rpm uninstall, 1 means rpm install, 2 means rpm upgrade, 3 means systemd deploy
    # arg2 means systemd step
    if [ "$1" -eq 0 ]; then
        # rpm uninstall step
        step="0"
        reporter="rpm"
    elif [ "$1" -eq 1 ]; then
        # rpm install step
        step="1"
        reporter="rpm"
    elif [ "$1" -eq 2 ]; then
        # rpm upgrade step
        step="2"
        reporter="rpm"
        add_observer_config
    elif [ "$1" -eq 3 ]; then
        step="$2"
        reporter="systemd"
        add_observer_config
    fi
    jsonData=$(echo "$jsonData" | jq --arg parent "content" --arg key "reporter" --arg value "$reporter" '.[$parent][$key] = $value')
    jsonData=$(echo "$jsonData" | jq --arg parent "content" --arg key "step" --arg value "$step" '.[$parent][$key] = $value')

    nohup curl -X POST \
        -H "Content-Type: application/json" \
        -d "$jsonData" "$url" >/dev/null 2>&1 &
}

if [[ -z "$TELEMETRY_MODE" ]] || ( [[ "$TELEMETRY_MODE" =~ ^-?[0-9]+$ ]] && [[ "$TELEMETRY_MODE" -eq 1 ]] ); then
    do_telemetry $1 "$2"
fi
