/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the ContentRedirectContentGuard type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ContentRedirectContentGuard{}

// ContentRedirectContentGuard A serializer for ContentRedirectContentGuard.
type ContentRedirectContentGuard struct {
	// The unique name.
	Name string `json:"name"`
	// An optional description.
	Description NullableString `json:"description,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _ContentRedirectContentGuard ContentRedirectContentGuard

// NewContentRedirectContentGuard instantiates a new ContentRedirectContentGuard object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewContentRedirectContentGuard(name string) *ContentRedirectContentGuard {
	this := ContentRedirectContentGuard{}
	this.Name = name
	return &this
}

// NewContentRedirectContentGuardWithDefaults instantiates a new ContentRedirectContentGuard object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewContentRedirectContentGuardWithDefaults() *ContentRedirectContentGuard {
	this := ContentRedirectContentGuard{}
	return &this
}

// GetName returns the Name field value
func (o *ContentRedirectContentGuard) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *ContentRedirectContentGuard) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *ContentRedirectContentGuard) SetName(v string) {
	o.Name = v
}

// GetDescription returns the Description field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ContentRedirectContentGuard) GetDescription() string {
	if o == nil || IsNil(o.Description.Get()) {
		var ret string
		return ret
	}
	return *o.Description.Get()
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ContentRedirectContentGuard) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description.Get(), o.Description.IsSet()
}

// HasDescription returns a boolean if a field has been set.
func (o *ContentRedirectContentGuard) HasDescription() bool {
	if o != nil && o.Description.IsSet() {
		return true
	}

	return false
}

// SetDescription gets a reference to the given NullableString and assigns it to the Description field.
func (o *ContentRedirectContentGuard) SetDescription(v string) {
	o.Description.Set(&v)
}
// SetDescriptionNil sets the value for Description to be an explicit nil
func (o *ContentRedirectContentGuard) SetDescriptionNil() {
	o.Description.Set(nil)
}

// UnsetDescription ensures that no value is present for Description, not even an explicit nil
func (o *ContentRedirectContentGuard) UnsetDescription() {
	o.Description.Unset()
}

func (o ContentRedirectContentGuard) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ContentRedirectContentGuard) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	if o.Description.IsSet() {
		toSerialize["description"] = o.Description.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ContentRedirectContentGuard) UnmarshalJSON(bytes []byte) (err error) {
	varContentRedirectContentGuard := _ContentRedirectContentGuard{}

	if err = json.Unmarshal(bytes, &varContentRedirectContentGuard); err == nil {
		*o = ContentRedirectContentGuard(varContentRedirectContentGuard)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "description")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableContentRedirectContentGuard struct {
	value *ContentRedirectContentGuard
	isSet bool
}

func (v NullableContentRedirectContentGuard) Get() *ContentRedirectContentGuard {
	return v.value
}

func (v *NullableContentRedirectContentGuard) Set(val *ContentRedirectContentGuard) {
	v.value = val
	v.isSet = true
}

func (v NullableContentRedirectContentGuard) IsSet() bool {
	return v.isSet
}

func (v *NullableContentRedirectContentGuard) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableContentRedirectContentGuard(val *ContentRedirectContentGuard) *NullableContentRedirectContentGuard {
	return &NullableContentRedirectContentGuard{value: val, isSet: true}
}

func (v NullableContentRedirectContentGuard) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableContentRedirectContentGuard) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


