/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authorization;

import com.netscape.certsrv.acls.EACLsException;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzInternalError;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.evaluators.AccessEvaluator;
import com.netscape.cms.authorization.ACL;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzManager;
import org.dogtagpki.server.authorization.AuthzManagerConfig;
import org.dogtagpki.server.authorization.AuthzToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicGroupAuthz
extends AuthzManager
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(BasicGroupAuthz.class);
    private static final String GROUP = "group";
    private String groupName;
    protected static Vector<String> extendedPluginInfo = new Vector();
    protected static String[] configParams;

    public BasicGroupAuthz() {
        configParams = new String[]{GROUP};
    }

    public String[] getExtendedPluginInfo() {
        return Utils.getStringArrayFromVector(extendedPluginInfo);
    }

    @Override
    public void accessInit(String accessInfo) throws EBaseException {
    }

    @Override
    public AuthzToken authorize(AuthToken authToken, String resource, String operation) throws EAuthzInternalError, EAuthzAccessDenied {
        String user = authToken.getInString("userid");
        if (user == null) {
            throw new EAuthzAccessDenied("No userid provided");
        }
        UGSubsystem ug = this.engine.getUGSubsystem();
        Group group = ug.getGroupFromName(this.groupName);
        if (!group.isMember(user)) {
            logger.error("BasicGroupAuthz: access denied. User: " + user + " is not a member of group: " + this.groupName);
            throw new EAuthzAccessDenied("Access denied");
        }
        logger.debug("BasicGroupAuthz: authorization passed");
        AuthzToken authzToken = new AuthzToken(this);
        authzToken.set("authzRes", resource);
        authzToken.set("authzOp", operation);
        authzToken.set("status", "statusSuccess");
        return authzToken;
    }

    @Override
    public AuthzToken authorize(AuthToken authToken, String expression) throws EAuthzInternalError, EAuthzAccessDenied {
        return this.authorize(authToken, null, null);
    }

    @Override
    public void init(String name, String implName, AuthzManagerConfig config) throws EBaseException {
        this.name = name;
        this.implName = implName;
        this.config = config;
        this.groupName = config.getString(GROUP);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String[] getConfigParams() throws EBaseException {
        return configParams;
    }

    @Override
    public Collection<ACL> getACLs() {
        return null;
    }

    @Override
    public ACL getACL(String target) {
        return null;
    }

    @Override
    public void updateACLs(String id, String rights, String strACLs, String desc) throws EACLsException {
    }

    @Override
    public Enumeration<AccessEvaluator> aclEvaluatorElements() {
        return null;
    }

    @Override
    public void registerEvaluator(String type, AccessEvaluator evaluator) {
    }

    @Override
    public Hashtable<String, AccessEvaluator> getAccessEvaluators() {
        return null;
    }

    static {
        extendedPluginInfo.add("group;string,required;Group to permit access");
    }
}

