/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmsutil.json.JSONObject;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStatus
extends CMSServlet {
    public static final Logger logger = LoggerFactory.getLogger(GetStatus.class);
    private static final long serialVersionUID = -2852842030221659847L;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        logger.debug("GetStatus: process()");
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        EngineConfig config = engine.getConfig();
        int state = config.getState();
        String type = config.getType();
        String status = engine.isReady() ? "running" : "starting";
        String version = GetStatus.class.getPackage().getImplementationVersion();
        try {
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            responseNode.put("State", "" + state);
            responseNode.put("Type", type);
            responseNode.put("Status", status);
            responseNode.put("Version", version);
            String productName = CMS.getProductName();
            if (!StringUtils.isEmpty((CharSequence)productName)) {
                responseNode.put("ProductVersion", productName);
            }
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
        }
        catch (Exception e) {
            logger.warn("GetStatus: Failed to send the output: " + e, (Throwable)e);
        }
    }

    @Override
    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }
}

