/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(LongMapper.class);
    private String mLdapName = null;
    private Vector<String> v = new Vector();

    public LongMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        logger.debug("LongMapper: Mapping " + name + " to " + this.mLdapName);
        attrs.add(new LDAPAttribute(this.mLdapName, LongMapper.LongToDB((Long)obj)));
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
        if (attr == null) {
            return;
        }
        parent.set(name, LongMapper.LongFromDB((String)attr.getStringValues().nextElement()));
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        String v = null;
        try {
            v = value.startsWith("0x") || value.startsWith("0X") ? LongMapper.LongToDB(Long.valueOf(value.substring(2), 16)) : LongMapper.LongToDB(Long.valueOf(value));
        }
        catch (NumberFormatException e) {
            v = value;
        }
        return this.mLdapName + op + v;
    }

    public static String LongToDB(Long i) {
        int len = i.toString().length();
        String ret = null;
        ret = len < 10 ? "0" + Integer.toString(len) + i.toString() : Integer.toString(len) + i.toString();
        return ret;
    }

    public static Long LongFromDB(String i) {
        String s = i.substring(2);
        return Long.valueOf(s);
    }
}

