/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import java.net.URL;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEDirectory;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="directory")
@ACMEManagedService
public class ACMEDirectoryService {
    public static Logger logger = LoggerFactory.getLogger(ACMEDirectoryService.class);
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    public Response getDirectory() throws Exception {
        logger.info("Creating directory");
        ACMEEngine engine = ACMEEngine.getInstance();
        URL baseURL = engine.getBaseURL();
        UriBuilder uriBuilder = baseURL != null ? UriBuilder.fromUri((URI)baseURL.toURI()) : this.uriInfo.getBaseUriBuilder();
        ACMEDirectory directory = new ACMEDirectory();
        directory.setMetadata(engine.getMetadata());
        URI newNonceURL = uriBuilder.clone().path("new-nonce").build(new Object[0]);
        directory.setNewNonce(newNonceURL);
        URI newAccountURL = uriBuilder.clone().path("new-account").build(new Object[0]);
        directory.setNewAccount(newAccountURL);
        URI newOrderURL = uriBuilder.clone().path("new-order").build(new Object[0]);
        directory.setNewOrder(newOrderURL);
        URI revokeCertURL = uriBuilder.clone().path("revoke-cert").build(new Object[0]);
        directory.setRevokeCert(revokeCertURL);
        logger.info("Directory:\n" + directory);
        Response.ResponseBuilder builder = Response.ok();
        builder.entity((Object)directory);
        return builder.build();
    }
}

