/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.base;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageFormatter {
    private static final Class<?>[] toStringSignature = new Class[]{Locale.class};

    public static String getLocalizedString(Locale locale, String resourceBundleBaseName, String formatString) {
        return MessageFormatter.getLocalizedString(locale, resourceBundleBaseName, formatString, null);
    }

    public static String getLocalizedString(Locale locale, String resourceBundleBaseName, String formatString, Object params) {
        Object[] o = new Object[]{params};
        return MessageFormatter.getLocalizedString(locale, resourceBundleBaseName, formatString, o);
    }

    public static String getLocalizedString(Locale locale, String resourceBundleBaseName, String formatString, Object[] params) {
        String localizedFormat = null;
        try {
            localizedFormat = ResourceBundle.getBundle(resourceBundleBaseName, locale).getString(formatString);
        }
        catch (MissingResourceException e) {
            return formatString;
        }
        Object[] localizedParams = params;
        Object[] localeArg = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof String && params[i] instanceof Date && params[i] instanceof Number) continue;
                if (localizedParams == params) {
                    localizedParams = new Object[params.length];
                    System.arraycopy(params, 0, localizedParams, 0, params.length);
                }
                try {
                    Method toStringMethod = params[i].getClass().getMethod("toString", toStringSignature);
                    if (localeArg == null) {
                        localeArg = new Object[]{locale};
                    }
                    localizedParams[i] = toStringMethod.invoke(params[i], localeArg);
                    continue;
                }
                catch (Exception e) {
                    localizedParams[i] = params[i].toString();
                }
            }
        }
        try {
            MessageFormat format = new MessageFormat(localizedFormat);
            return format.format(localizedParams);
        }
        catch (IllegalArgumentException e) {
            return localizedFormat;
        }
    }
}

