/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.Signature;
import com.netscape.cmsutil.ocsp.TBSRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class OCSPRequest
implements ASN1Value {
    private TBSRequest tbsRequest;
    private Signature optionalSignature;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public TBSRequest getTBSRequest() {
        return this.tbsRequest;
    }

    public Signature getSignature() {
        return this.optionalSignature;
    }

    public OCSPRequest(TBSRequest tbsRequest, Signature optionalSignature) {
        this.tbsRequest = tbsRequest;
        this.sequence.addElement((ASN1Value)tbsRequest);
        this.optionalSignature = optionalSignature;
        if (optionalSignature != null) {
            this.sequence.addElement((ASN1Value)optionalSignature);
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)TBSRequest.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new Signature.Template()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(istream);
            Signature signature = null;
            if (seq.elementAt(1) != null) {
                signature = (Signature)((EXPLICIT)seq.elementAt(1)).getContent();
            }
            return new OCSPRequest((TBSRequest)seq.elementAt(0), signature);
        }
    }
}

