/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceCert4Crl
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(ServiceCert4Crl.class);

    public ServiceCert4Crl(CAService service) {
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        BigInteger[] revokedCertIds = request.getExtDataInBigIntegerArray("revokedCertRecs");
        if (revokedCertIds == null || revokedCertIds.length == 0) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT4CRL_NO_ENTRY", (Object[])new Object[]{request.getRequestId().toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_CLAREQ", (String[])new String[0]));
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        CertRecord[] revokedCertRecs = new CertRecord[revokedCertIds.length];
        for (int i = 0; i < revokedCertIds.length; ++i) {
            revokedCertRecs[i] = cr.readCertificateRecord(revokedCertIds[i]);
        }
        if (revokedCertRecs == null || revokedCertRecs.length == 0 || revokedCertRecs[0] == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT4CRL_NO_ENTRY", (Object[])new Object[]{request.getRequestId().toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_CLAREQ", (String[])new String[0]));
        }
        CertRecord[] recordedCerts = new CertRecord[revokedCertRecs.length];
        String[] svcerrors = null;
        for (int i = 0; i < revokedCertRecs.length; ++i) {
            try {
                cr.addRevokedCertRecord(revokedCertRecs[i]);
                recordedCerts[i] = revokedCertRecs[i];
                for (CRLIssuingPoint ip : engine.getCRLIssuingPoints()) {
                    RevokedCertImpl rci = new RevokedCertImpl(revokedCertRecs[i].getSerialNumber(), revokedCertRecs[i].getRevokedOn());
                    if (ip == null) continue;
                    ip.addRevokedCert(revokedCertRecs[i].getSerialNumber(), rci);
                }
                continue;
            }
            catch (ECAException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CERT4CRL_NO_REC", (Object[])new Object[]{Integer.toString(i), request.getRequestId().toString(), e.toString()}), (Throwable)e);
                recordedCerts[i] = null;
                if (svcerrors == null) {
                    svcerrors = new String[recordedCerts.length];
                }
                svcerrors[i] = e.toString();
            }
        }
        if (svcerrors != null) {
            request.setExtData("serviceErrors", svcerrors);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CERT4CRL_FAILED", (String[])new String[0]));
        }
        return true;
    }
}

