/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.input.EnrollInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.lang.invoke.CallSite;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAltNameExtInput
extends EnrollInput {
    public static Logger logger = LoggerFactory.getLogger(SubjectAltNameExtInput.class);
    public static final int DEF_REQ_ENTRIES = 4;
    public static final String CONFIG_SAN_REQ_PATTERN = "req_san_pattern_";
    public static final String CONFIG_SAN_REQ_TYPE = "req_san_type_";
    public static final String VAL_SAN_REQ_PATTERN = "req_san_pattern_";
    public static final String VAL_SAN_REQ_TYPE = "req_san_type_";
    private int mSANentryNum = 4;

    public SubjectAltNameExtInput() {
        for (int i = 0; i < this.mSANentryNum; ++i) {
            this.addValueName("req_san_pattern_" + i);
            this.addValueName("req_san_type_" + i);
        }
    }

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        super.init(profile, config);
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        try {
            this.mSANentryNum = cs.getInteger("ca.SAN.entryNum", 4);
        }
        catch (EBaseException e) {
            logger.warn("SubjectAltNameExtInput: init(): getting config failed on ca.SAN.entryNum: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_SUBJECT_ALT_NAME_EXT_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_SUBJECT_ALT_NAME_EXT_TEXT", (String[])new String[0]);
    }

    @Override
    public Enumeration<String> getValueNames() {
        Vector<CallSite> v = new Vector<CallSite>();
        for (int i = 0; i < this.mSANentryNum; ++i) {
            v.addElement((CallSite)((Object)("req_san_type_" + i)));
            v.addElement((CallSite)((Object)("req_san_pattern_" + i)));
        }
        return v.elements();
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws Exception {
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.startsWith("req_san_type_")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REQ_SAN_TYPE", (String[])new String[0]));
        }
        if (name.startsWith("req_san_pattern_")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REQ_SAN_PATTERN", (String[])new String[0]));
        }
        return null;
    }
}

